# from pysisyphus.constants import ANG2BOHR


# Taken from periodictable-1.5.0
MASS_DICT = {
    'x': 1, # dummy atom
    'n': 14.0067, 'h': 1.00794, 'he': 4.002602, 'li': 6.941, 'be': 9.012182,
    # 'n': 14.0067, 'h': 1.007825, 'he': 4.002602, 'li': 6.941, 'be': 9.012182,
    'b': 10.811, 'c': 12.0107, 'o': 15.9994, 'f': 18.9984032, 'ne': 20.1797,
    # 'b': 10.811, 'c': 12.0000, 'o': 15.994915, 'f': 18.9984032, 'ne': 20.1797,
    'na': 22.98977, 'mg': 24.305, 'al': 26.981538, 'si': 28.0855, 'p': 30.973761,
    's': 32.065, 'cl': 35.453, 'ar': 39.948, 'k': 39.0983, 'ca': 40.078,
    'sc': 44.95591, 'ti': 47.867, 'v': 50.9415, 'cr': 51.9961, 'mn': 54.938049,
    'fe': 55.845, 'co': 58.9332, 'ni': 58.6934, 'cu':63.546, 'zn': 65.409,
    'ga': 69.723, 'ge': 72.64, 'as': 74.9216, 'se': 78.96, 'br': 79.904,
    'kr': 83.798,'rb': 85.4678, 'sr': 87.62, 'y': 88.90585, 'zr': 91.224,
    'nb': 92.90638, 'mo': 95.94, 'tc': 98, 'ru': 101.07, 'rh': 102.9055,
    'pd': 106.42, 'ag': 107.8682, 'cd': 112.411, 'in': 114.818, 'sn': 118.71,
    'sb': 121.76, 'te': 127.6, 'i': 126.90447, 'xe': 131.293, 'cs': 132.90545,
    'ba': 137.327, 'la': 138.9055, 'ce': 140.116, 'pr': 140.90765, 'nd': 144.24,
    'pm': 145, 'sm': 150.36, 'eu': 151.964, 'gd': 157.25, 'tb': 158.92534,
    'dy': 162.5, 'ho': 164.93032, 'er': 167.259, 'tm': 168.93421, 'yb': 173.04,
    'lu': 174.967, 'hf': 178.49, 'ta': 180.9479, 'w': 183.84, 're': 186.207,
    'os': 190.23, 'ir': 192.217, 'pt': 195.078, 'au': 196.96655, 'hg': 200.59,
    'tl': 204.3833, 'pb': 207.2, 'bi': 208.98038, 'po': 209, 'at': 210, 'rn': 222,
    'fr': 223, 'ra': 226, 'ac': 227, 'th': 232.0381, 'pa': 231.03588, 'u': 238.02891,
    'np': 237, 'pu': 244, 'am': 243, 'cm': 247, 'bk': 247, 'cf': 251, 'es': 252,
    'fm': 257, 'md': 258, 'no': 259, 'lr': 262, 'rf': 261, 'db': 262, 'sg': 266,
    'bh': 264, 'hs': 277, 'mt': 268, 'ds': 281, 'rg': 272, 'cn': 285, 'nh': 286,
    'fl': 289,'mc': 289, 'lv': 293, 'ts': 294, 'og': 294
}
KNOWN_ATOMS = tuple(MASS_DICT.keys())


# Taken from periodictable-1.5.3
ISOTOPE_DICT = {
 ('ac', 207): 207.01209,
 ('ac', 208): 208.01149,
 ('ac', 209): 209.00957,
 ('ac', 210): 210.00926,
 ('ac', 211): 211.00765,
 ('ac', 212): 212.00781,
 ('ac', 213): 213.00657,
 ('ac', 214): 214.00689,
 ('ac', 215): 215.00645,
 ('ac', 216): 216.008721,
 ('ac', 217): 217.009333,
 ('ac', 218): 218.01163,
 ('ac', 219): 219.0124,
 ('ac', 220): 220.01475,
 ('ac', 221): 221.01558,
 ('ac', 222): 222.017829,
 ('ac', 223): 223.019126,
 ('ac', 224): 224.021708,
 ('ac', 225): 225.023221,
 ('ac', 226): 226.02609,
 ('ac', 227): 227.027747,
 ('ac', 228): 228.0310148,
 ('ac', 229): 229.03293,
 ('ac', 230): 230.03603,
 ('ac', 231): 231.03855,
 ('ac', 232): 232.04202,
 ('ac', 233): 233.04455,
 ('ac', 234): 234.04842,
 ('ac', 235): 235.0511,
 ('ac', 236): 236.05518,
 ('ag', 94): 93.94278,
 ('ag', 95): 94.93548,
 ('ag', 96): 95.93068,
 ('ag', 97): 96.924,
 ('ag', 98): 97.92176,
 ('ag', 99): 98.9176,
 ('ag', 100): 99.91607,
 ('ag', 101): 100.9128,
 ('ag', 102): 101.912,
 ('ag', 103): 102.908972,
 ('ag', 104): 103.908628,
 ('ag', 105): 104.906528,
 ('ag', 106): 105.906666,
 ('ag', 107): 106.905093,
 ('ag', 108): 107.905954,
 ('ag', 109): 108.904756,
 ('ag', 110): 109.90611,
 ('ag', 111): 110.905295,
 ('ag', 112): 111.907004,
 ('ag', 113): 112.906566,
 ('ag', 114): 113.908808,
 ('ag', 115): 114.90876,
 ('ag', 116): 115.91136,
 ('ag', 117): 116.91168,
 ('ag', 118): 117.91458,
 ('ag', 119): 118.91567,
 ('ag', 120): 119.91879,
 ('ag', 121): 120.91985,
 ('ag', 122): 121.92332,
 ('ag', 123): 122.9249,
 ('ag', 124): 123.92853,
 ('ag', 125): 124.93054,
 ('ag', 126): 125.9345,
 ('ag', 127): 126.93688,
 ('al', 21): 21.02804,
 ('al', 22): 22.01952,
 ('al', 23): 23.007265,
 ('al', 24): 23.999941,
 ('al', 25): 24.9904286,
 ('al', 26): 25.98689166,
 ('al', 27): 26.98153844,
 ('al', 28): 27.98191018,
 ('al', 29): 28.9804448,
 ('al', 30): 29.98296,
 ('al', 31): 30.983946,
 ('al', 32): 31.98812,
 ('al', 33): 32.99087,
 ('al', 34): 33.99693,
 ('al', 35): 34.99994,
 ('al', 36): 36.00635,
 ('al', 37): 37.01031,
 ('al', 38): 38.0169,
 ('al', 39): 39.0219,
 ('am', 231): 231.04556,
 ('am', 232): 232.04659,
 ('am', 233): 233.04647,
 ('am', 234): 234.04779,
 ('am', 235): 235.04803,
 ('am', 236): 236.04957,
 ('am', 237): 237.04997,
 ('am', 238): 238.05198,
 ('am', 239): 239.053018,
 ('am', 240): 240.055288,
 ('am', 241): 241.0568229,
 ('am', 242): 242.059543,
 ('am', 243): 243.0613727,
 ('am', 244): 244.0642794,
 ('am', 245): 245.066445,
 ('am', 246): 246.069768,
 ('am', 247): 247.07209,
 ('am', 248): 248.07575,
 ('am', 249): 249.07848,
 ('ar', 30): 30.02156,
 ('ar', 31): 31.01213,
 ('ar', 32): 31.99766,
 ('ar', 33): 32.98993,
 ('ar', 34): 33.98027,
 ('ar', 35): 34.9752567,
 ('ar', 36): 35.96754628,
 ('ar', 37): 36.9667759,
 ('ar', 38): 37.9627322,
 ('ar', 39): 38.964313,
 ('ar', 40): 39.962383123,
 ('ar', 41): 40.9645008,
 ('ar', 42): 41.96305,
 ('ar', 43): 42.96567,
 ('ar', 44): 43.965365,
 ('ar', 45): 44.96809,
 ('ar', 46): 45.96809,
 ('ar', 47): 46.97219,
 ('ar', 48): 47.97507,
 ('ar', 49): 48.98218,
 ('ar', 50): 49.98594,
 ('ar', 51): 50.99324,
 ('ar', 52): 51.99817,
 ('ar', 53): 53.00623,
 ('as', 60): 59.99313,
 ('as', 61): 60.98062,
 ('as', 62): 61.9732,
 ('as', 63): 62.96369,
 ('as', 64): 63.95757,
 ('as', 65): 64.94948,
 ('as', 66): 65.94437,
 ('as', 67): 66.93919,
 ('as', 68): 67.93679,
 ('as', 69): 68.93228,
 ('as', 70): 69.93093,
 ('as', 71): 70.927115,
 ('as', 72): 71.926753,
 ('as', 73): 72.923825,
 ('as', 74): 73.9239291,
 ('as', 75): 74.9215964,
 ('as', 76): 75.9223939,
 ('as', 77): 76.9206477,
 ('as', 78): 77.921829,
 ('as', 79): 78.920948,
 ('as', 80): 79.922578,
 ('as', 81): 80.922133,
 ('as', 82): 81.9245,
 ('as', 83): 82.92498,
 ('as', 84): 83.92906,
 ('as', 85): 84.93181,
 ('as', 86): 85.93623,
 ('as', 87): 86.93958,
 ('as', 88): 87.94456,
 ('as', 89): 88.94923,
 ('at', 193): 193.00019,
 ('at', 194): 193.99897,
 ('at', 195): 194.99655,
 ('at', 196): 195.9957,
 ('at', 197): 196.99329,
 ('at', 198): 197.99275,
 ('at', 199): 198.99063,
 ('at', 200): 199.99029,
 ('at', 201): 200.98849,
 ('at', 202): 201.98845,
 ('at', 203): 202.98685,
 ('at', 204): 203.98726,
 ('at', 205): 204.98604,
 ('at', 206): 205.9866,
 ('at', 207): 206.985776,
 ('at', 208): 207.986583,
 ('at', 209): 208.986159,
 ('at', 210): 209.987131,
 ('at', 211): 210.987481,
 ('at', 212): 211.990735,
 ('at', 213): 212.992921,
 ('at', 214): 213.996356,
 ('at', 215): 214.998641,
 ('at', 216): 216.002409,
 ('at', 217): 217.00471,
 ('at', 218): 218.008681,
 ('at', 219): 219.0113,
 ('at', 220): 220.0153,
 ('at', 221): 221.01814,
 ('at', 222): 222.02233,
 ('at', 223): 223.02534,
 ('au', 171): 170.99177,
 ('au', 172): 171.99011,
 ('au', 173): 172.9864,
 ('au', 174): 173.98492,
 ('au', 175): 174.98155,
 ('au', 176): 175.98027,
 ('au', 177): 176.97722,
 ('au', 178): 177.97598,
 ('au', 179): 178.97341,
 ('au', 180): 179.9724,
 ('au', 181): 180.96995,
 ('au', 182): 181.96962,
 ('au', 183): 182.96762,
 ('au', 184): 183.96747,
 ('au', 185): 184.96581,
 ('au', 186): 185.966,
 ('au', 187): 186.96456,
 ('au', 188): 187.96509,
 ('au', 189): 188.96389,
 ('au', 190): 189.964699,
 ('au', 191): 190.96365,
 ('au', 192): 191.96481,
 ('au', 193): 192.964132,
 ('au', 194): 193.965339,
 ('au', 195): 194.965018,
 ('au', 196): 195.966551,
 ('au', 197): 196.966552,
 ('au', 198): 197.968225,
 ('au', 199): 198.968748,
 ('au', 200): 199.97072,
 ('au', 201): 200.971641,
 ('au', 202): 201.97379,
 ('au', 203): 202.975137,
 ('au', 204): 203.97771,
 ('au', 205): 204.97961,
 ('b', 7): 7.02992,
 ('b', 8): 8.0246067,
 ('b', 9): 9.0133288,
 ('b', 10): 10.012937,
 ('b', 11): 11.0093055,
 ('b', 12): 12.0143521,
 ('b', 13): 13.0177803,
 ('b', 14): 14.025404,
 ('b', 15): 15.031097,
 ('b', 16): 16.03981,
 ('b', 17): 17.04693,
 ('b', 18): 18.05617,
 ('b', 19): 19.06373,
 ('ba', 114): 113.95094,
 ('ba', 115): 114.94771,
 ('ba', 116): 115.94168,
 ('ba', 117): 116.93886,
 ('ba', 118): 117.93344,
 ('ba', 119): 118.93105,
 ('ba', 120): 119.92605,
 ('ba', 121): 120.92449,
 ('ba', 122): 121.92026,
 ('ba', 123): 122.91885,
 ('ba', 124): 123.915088,
 ('ba', 125): 124.91462,
 ('ba', 126): 125.911244,
 ('ba', 127): 126.91112,
 ('ba', 128): 127.908309,
 ('ba', 129): 128.908674,
 ('ba', 130): 129.90631,
 ('ba', 131): 130.906931,
 ('ba', 132): 131.905056,
 ('ba', 133): 132.906002,
 ('ba', 134): 133.904503,
 ('ba', 135): 134.905683,
 ('ba', 136): 135.90457,
 ('ba', 137): 136.905821,
 ('ba', 138): 137.905241,
 ('ba', 139): 138.908835,
 ('ba', 140): 139.910599,
 ('ba', 141): 140.914406,
 ('ba', 142): 141.916448,
 ('ba', 143): 142.920617,
 ('ba', 144): 143.92294,
 ('ba', 145): 144.92692,
 ('ba', 146): 145.93011,
 ('ba', 147): 146.93399,
 ('ba', 148): 147.93768,
 ('ba', 149): 148.94246,
 ('ba', 150): 149.94562,
 ('ba', 151): 150.9507,
 ('ba', 152): 151.95416,
 ('ba', 153): 152.95961,
 ('be', 5): 5.04079,
 ('be', 6): 6.019726,
 ('be', 7): 7.0169292,
 ('be', 8): 8.00530509,
 ('be', 9): 9.0121821,
 ('be', 10): 10.0135337,
 ('be', 11): 11.021658,
 ('be', 12): 12.026921,
 ('be', 13): 13.03613,
 ('be', 14): 14.04282,
 ('bh', 260): 260.1218,
 ('bh', 261): 261.1218,
 ('bh', 262): 262.12301,
 ('bh', 263): 263.12315,
 ('bh', 264): 264.12473,
 ('bh', 265): 265.1252,
 ('bh', 266): 266.12701,
 ('bh', 267): 267.12774,
 ('bi', 185): 184.99771,
 ('bi', 186): 185.99648,
 ('bi', 187): 186.99346,
 ('bi', 188): 187.99217,
 ('bi', 189): 188.98951,
 ('bi', 190): 189.98852,
 ('bi', 191): 190.98605,
 ('bi', 192): 191.98537,
 ('bi', 193): 192.98306,
 ('bi', 194): 193.98275,
 ('bi', 195): 194.98075,
 ('bi', 196): 195.98061,
 ('bi', 197): 196.97893,
 ('bi', 198): 197.97902,
 ('bi', 199): 198.97758,
 ('bi', 200): 199.97814,
 ('bi', 201): 200.97697,
 ('bi', 202): 201.97767,
 ('bi', 203): 202.976868,
 ('bi', 204): 203.977805,
 ('bi', 205): 204.977375,
 ('bi', 206): 205.978483,
 ('bi', 207): 206.978455,
 ('bi', 208): 207.979727,
 ('bi', 209): 208.980383,
 ('bi', 210): 209.984105,
 ('bi', 211): 210.987258,
 ('bi', 212): 211.991272,
 ('bi', 213): 212.994375,
 ('bi', 214): 213.998699,
 ('bi', 215): 215.00183,
 ('bi', 216): 216.0062,
 ('bk', 235): 235.05658,
 ('bk', 236): 236.05733,
 ('bk', 237): 237.05713,
 ('bk', 238): 238.05827,
 ('bk', 239): 239.05836,
 ('bk', 240): 240.05975,
 ('bk', 241): 241.06022,
 ('bk', 242): 242.06205,
 ('bk', 243): 243.063002,
 ('bk', 244): 244.065168,
 ('bk', 245): 245.0663554,
 ('bk', 246): 246.06867,
 ('bk', 247): 247.070299,
 ('bk', 248): 248.07308,
 ('bk', 249): 249.07498,
 ('bk', 250): 250.078311,
 ('bk', 251): 251.080753,
 ('bk', 252): 252.0843,
 ('bk', 253): 253.08688,
 ('bk', 254): 254.0906,
 ('br', 67): 66.96479,
 ('br', 68): 67.95825,
 ('br', 69): 68.95018,
 ('br', 70): 69.94462,
 ('br', 71): 70.93925,
 ('br', 72): 71.9365,
 ('br', 73): 72.93179,
 ('br', 74): 73.929891,
 ('br', 75): 74.925776,
 ('br', 76): 75.924542,
 ('br', 77): 76.92138,
 ('br', 78): 77.921146,
 ('br', 79): 78.9183376,
 ('br', 80): 79.91853,
 ('br', 81): 80.916291,
 ('br', 82): 81.916805,
 ('br', 83): 82.91518,
 ('br', 84): 83.916504,
 ('br', 85): 84.915608,
 ('br', 86): 85.918797,
 ('br', 87): 86.920711,
 ('br', 88): 87.92407,
 ('br', 89): 88.92639,
 ('br', 90): 89.93063,
 ('br', 91): 90.93397,
 ('br', 92): 91.93926,
 ('br', 93): 92.9431,
 ('br', 94): 93.94868,
 ('c', 8): 8.037675,
 ('c', 9): 9.0310401,
 ('c', 10): 10.0168531,
 ('c', 11): 11.0114338,
 ('c', 12): 12.0,
 ('c', 13): 13.0033548378,
 ('c', 14): 14.003241988,
 ('c', 15): 15.0105993,
 ('c', 16): 16.014701,
 ('c', 17): 17.022584,
 ('c', 18): 18.02676,
 ('c', 19): 19.03525,
 ('c', 20): 20.04032,
 ('c', 21): 21.04934,
 ('c', 22): 22.05645,
 ('ca', 34): 34.01412,
 ('ca', 35): 35.00477,
 ('ca', 36): 35.99309,
 ('ca', 37): 36.985872,
 ('ca', 38): 37.976319,
 ('ca', 39): 38.9707177,
 ('ca', 40): 39.9625912,
 ('ca', 41): 40.9622783,
 ('ca', 42): 41.9586183,
 ('ca', 43): 42.9587668,
 ('ca', 44): 43.9554811,
 ('ca', 45): 44.9561859,
 ('ca', 46): 45.9536928,
 ('ca', 47): 46.9545465,
 ('ca', 48): 47.952534,
 ('ca', 49): 48.955673,
 ('ca', 50): 49.957518,
 ('ca', 51): 50.96147,
 ('ca', 52): 51.9651,
 ('ca', 53): 52.97005,
 ('ca', 54): 53.97468,
 ('ca', 55): 54.98055,
 ('ca', 56): 55.98579,
 ('ca', 57): 56.99236,
 ('cd', 96): 95.93977,
 ('cd', 97): 96.93494,
 ('cd', 98): 97.92758,
 ('cd', 99): 98.92501,
 ('cd', 100): 99.92023,
 ('cd', 101): 100.91868,
 ('cd', 102): 101.91478,
 ('cd', 103): 102.913419,
 ('cd', 104): 103.909848,
 ('cd', 105): 104.909468,
 ('cd', 106): 105.906458,
 ('cd', 107): 106.906614,
 ('cd', 108): 107.904183,
 ('cd', 109): 108.904986,
 ('cd', 110): 109.903006,
 ('cd', 111): 110.904182,
 ('cd', 112): 111.9027572,
 ('cd', 113): 112.9044009,
 ('cd', 114): 113.9033581,
 ('cd', 115): 114.905431,
 ('cd', 116): 115.904755,
 ('cd', 117): 116.907218,
 ('cd', 118): 117.906914,
 ('cd', 119): 118.90992,
 ('cd', 120): 119.909851,
 ('cd', 121): 120.91298,
 ('cd', 122): 121.9135,
 ('cd', 123): 122.917,
 ('cd', 124): 123.91765,
 ('cd', 125): 124.92125,
 ('cd', 126): 125.92235,
 ('cd', 127): 126.92643,
 ('cd', 128): 127.92776,
 ('cd', 129): 128.93226,
 ('cd', 130): 129.93398,
 ('ce', 119): 118.95276,
 ('ce', 120): 119.94664,
 ('ce', 121): 120.94367,
 ('ce', 122): 121.93801,
 ('ce', 123): 122.93551,
 ('ce', 124): 123.93052,
 ('ce', 125): 124.92854,
 ('ce', 126): 125.9241,
 ('ce', 127): 126.92275,
 ('ce', 128): 127.91887,
 ('ce', 129): 128.91809,
 ('ce', 130): 129.91469,
 ('ce', 131): 130.91442,
 ('ce', 132): 131.91149,
 ('ce', 133): 132.91155,
 ('ce', 134): 133.90903,
 ('ce', 135): 134.909146,
 ('ce', 136): 135.90714,
 ('ce', 137): 136.90778,
 ('ce', 138): 137.905986,
 ('ce', 139): 138.906647,
 ('ce', 140): 139.905434,
 ('ce', 141): 140.908271,
 ('ce', 142): 141.90924,
 ('ce', 143): 142.912381,
 ('ce', 144): 143.913643,
 ('ce', 145): 144.91723,
 ('ce', 146): 145.91869,
 ('ce', 147): 146.92251,
 ('ce', 148): 147.92439,
 ('ce', 149): 148.92829,
 ('ce', 150): 149.93023,
 ('ce', 151): 150.93404,
 ('ce', 152): 151.93638,
 ('ce', 153): 152.94058,
 ('ce', 154): 153.94332,
 ('ce', 155): 154.94804,
 ('ce', 156): 155.95126,
 ('ce', 157): 156.95634,
 ('cf', 237): 237.06207,
 ('cf', 238): 238.06141,
 ('cf', 239): 239.06258,
 ('cf', 240): 240.0623,
 ('cf', 241): 241.06372,
 ('cf', 242): 242.06369,
 ('cf', 243): 243.06542,
 ('cf', 244): 244.06599,
 ('cf', 245): 245.06804,
 ('cf', 246): 246.0687988,
 ('cf', 247): 247.070992,
 ('cf', 248): 248.072178,
 ('cf', 249): 249.074847,
 ('cf', 250): 250.0764,
 ('cf', 251): 251.07958,
 ('cf', 252): 252.08162,
 ('cf', 253): 253.085127,
 ('cf', 254): 254.087316,
 ('cf', 255): 255.09104,
 ('cf', 256): 256.09344,
 ('cl', 28): 28.02851,
 ('cl', 29): 29.01411,
 ('cl', 30): 30.00477,
 ('cl', 31): 30.99242,
 ('cl', 32): 31.985689,
 ('cl', 33): 32.9774518,
 ('cl', 34): 33.97376197,
 ('cl', 35): 34.96885271,
 ('cl', 36): 35.96830695,
 ('cl', 37): 36.9659026,
 ('cl', 38): 37.96801055,
 ('cl', 39): 38.9680077,
 ('cl', 40): 39.97042,
 ('cl', 41): 40.97065,
 ('cl', 42): 41.97317,
 ('cl', 43): 42.9742,
 ('cl', 44): 43.97854,
 ('cl', 45): 44.9797,
 ('cl', 46): 45.98412,
 ('cl', 47): 46.98795,
 ('cl', 48): 47.99485,
 ('cl', 49): 48.99989,
 ('cl', 50): 50.00773,
 ('cl', 51): 51.01353,
 ('cm', 233): 233.0508,
 ('cm', 234): 234.05024,
 ('cm', 235): 235.05159,
 ('cm', 236): 236.05141,
 ('cm', 237): 237.05289,
 ('cm', 238): 238.05302,
 ('cm', 239): 239.05495,
 ('cm', 240): 240.055519,
 ('cm', 241): 241.0576467,
 ('cm', 242): 242.0588293,
 ('cm', 243): 243.0613822,
 ('cm', 244): 244.0627463,
 ('cm', 245): 245.0654856,
 ('cm', 246): 246.0672176,
 ('cm', 247): 247.070347,
 ('cm', 248): 248.072342,
 ('cm', 249): 249.075947,
 ('cm', 250): 250.078351,
 ('cm', 251): 251.082278,
 ('cm', 252): 252.08487,
 ('cn', 285): None,
 ('co', 48): 48.00176,
 ('co', 49): 48.98972,
 ('co', 50): 49.98154,
 ('co', 51): 50.97072,
 ('co', 52): 51.96359,
 ('co', 53): 52.954225,
 ('co', 54): 53.9484641,
 ('co', 55): 54.9420031,
 ('co', 56): 55.9398439,
 ('co', 57): 56.9362962,
 ('co', 58): 57.9357576,
 ('co', 59): 58.9332002,
 ('co', 60): 59.9338222,
 ('co', 61): 60.9324794,
 ('co', 62): 61.934054,
 ('co', 63): 62.933615,
 ('co', 64): 63.935814,
 ('co', 65): 64.936485,
 ('co', 66): 65.93983,
 ('co', 67): 66.94061,
 ('co', 68): 67.94436,
 ('co', 69): 68.9452,
 ('co', 70): 69.94981,
 ('co', 71): 70.95173,
 ('co', 72): 71.95641,
 ('cr', 42): 42.00643,
 ('cr', 43): 42.99771,
 ('cr', 44): 43.98547,
 ('cr', 45): 44.97916,
 ('cr', 46): 45.968362,
 ('cr', 47): 46.962907,
 ('cr', 48): 47.954036,
 ('cr', 49): 48.9513411,
 ('cr', 50): 49.9460496,
 ('cr', 51): 50.9447718,
 ('cr', 52): 51.9405119,
 ('cr', 53): 52.9406538,
 ('cr', 54): 53.9388849,
 ('cr', 55): 54.9408442,
 ('cr', 56): 55.940645,
 ('cr', 57): 56.94375,
 ('cr', 58): 57.94425,
 ('cr', 59): 58.94863,
 ('cr', 60): 59.94973,
 ('cr', 61): 60.95409,
 ('cr', 62): 61.9558,
 ('cr', 63): 62.96186,
 ('cr', 64): 63.9642,
 ('cr', 65): 64.97037,
 ('cs', 112): 111.95033,
 ('cs', 113): 112.94454,
 ('cs', 114): 113.94142,
 ('cs', 115): 114.93594,
 ('cs', 116): 115.93291,
 ('cs', 117): 116.92864,
 ('cs', 118): 117.926555,
 ('cs', 119): 118.922371,
 ('cs', 120): 119.920678,
 ('cs', 121): 120.917184,
 ('cs', 122): 121.916122,
 ('cs', 123): 122.91299,
 ('cs', 124): 123.912246,
 ('cs', 125): 124.909725,
 ('cs', 126): 125.909448,
 ('cs', 127): 126.907418,
 ('cs', 128): 127.907748,
 ('cs', 129): 128.906063,
 ('cs', 130): 129.906706,
 ('cs', 131): 130.90546,
 ('cs', 132): 131.90643,
 ('cs', 133): 132.905447,
 ('cs', 134): 133.906713,
 ('cs', 135): 134.905972,
 ('cs', 136): 135.907306,
 ('cs', 137): 136.907084,
 ('cs', 138): 137.911011,
 ('cs', 139): 138.913358,
 ('cs', 140): 139.917277,
 ('cs', 141): 140.920044,
 ('cs', 142): 141.924292,
 ('cs', 143): 142.92733,
 ('cs', 144): 143.93203,
 ('cs', 145): 144.93539,
 ('cs', 146): 145.94016,
 ('cs', 147): 146.94386,
 ('cs', 148): 147.9489,
 ('cs', 149): 148.95272,
 ('cs', 150): 149.95797,
 ('cs', 151): 150.962,
 ('cu', 52): 51.99718,
 ('cu', 53): 52.98555,
 ('cu', 54): 53.97671,
 ('cu', 55): 54.96605,
 ('cu', 56): 55.95856,
 ('cu', 57): 56.949216,
 ('cu', 58): 57.9445407,
 ('cu', 59): 58.9395041,
 ('cu', 60): 59.9373681,
 ('cu', 61): 60.9334622,
 ('cu', 62): 61.932587,
 ('cu', 63): 62.9296011,
 ('cu', 64): 63.9297679,
 ('cu', 65): 64.9277937,
 ('cu', 66): 65.928873,
 ('cu', 67): 66.92775,
 ('cu', 68): 67.92964,
 ('cu', 69): 68.929425,
 ('cu', 70): 69.932409,
 ('cu', 71): 70.93262,
 ('cu', 72): 71.93552,
 ('cu', 73): 72.93649,
 ('cu', 74): 73.9402,
 ('cu', 75): 74.9417,
 ('cu', 76): 75.94599,
 ('cu', 77): 76.94795,
 ('cu', 78): 77.95281,
 ('cu', 79): 78.95528,
 ('cu', 80): 79.96189,
 ('db', 255): 255.1074,
 ('db', 256): 256.10811,
 ('db', 257): 257.10786,
 ('db', 258): 258.10944,
 ('db', 259): 259.10972,
 ('db', 260): 260.11143,
 ('db', 261): 261.11211,
 ('db', 262): 262.11415,
 ('db', 263): 263.11508,
 ('db', 264): 264.11747,
 ('db', 265): 265.11866,
 ('ds', 267): 267.14396,
 ('ds', 268): 268.14353,
 ('ds', 269): 269.14514,
 ('ds', 270): 270.14463,
 ('ds', 271): 271.14608,
 ('ds', 272): 272.14631,
 ('ds', 273): 273.14925,
 ('ds', 281): None,
 ('dy', 140): 139.95379,
 ('dy', 141): 140.95119,
 ('dy', 142): 141.94627,
 ('dy', 143): 142.94383,
 ('dy', 144): 143.93907,
 ('dy', 145): 144.93695,
 ('dy', 146): 145.93272,
 ('dy', 147): 146.93088,
 ('dy', 148): 147.92718,
 ('dy', 149): 148.927334,
 ('dy', 150): 149.92558,
 ('dy', 151): 150.92618,
 ('dy', 152): 151.924714,
 ('dy', 153): 152.925761,
 ('dy', 154): 153.924422,
 ('dy', 155): 154.925749,
 ('dy', 156): 155.924278,
 ('dy', 157): 156.925461,
 ('dy', 158): 157.924405,
 ('dy', 159): 158.925736,
 ('dy', 160): 159.925194,
 ('dy', 161): 160.92693,
 ('dy', 162): 161.926795,
 ('dy', 163): 162.928728,
 ('dy', 164): 163.929171,
 ('dy', 165): 164.9317,
 ('dy', 166): 165.932803,
 ('dy', 167): 166.93565,
 ('dy', 168): 167.93723,
 ('dy', 169): 168.9403,
 ('dy', 170): 169.94267,
 ('dy', 171): 170.94648,
 ('dy', 172): 171.94911,
 ('dy', 173): 172.95344,
 ('er', 144): 143.96059,
 ('er', 145): 144.95746,
 ('er', 146): 145.95212,
 ('er', 147): 146.94931,
 ('er', 148): 147.94444,
 ('er', 149): 148.94217,
 ('er', 150): 149.93776,
 ('er', 151): 150.93746,
 ('er', 152): 151.93508,
 ('er', 153): 152.935093,
 ('er', 154): 153.932777,
 ('er', 155): 154.9332,
 ('er', 156): 155.93102,
 ('er', 157): 156.93195,
 ('er', 158): 157.92991,
 ('er', 159): 158.930681,
 ('er', 160): 159.92908,
 ('er', 161): 160.930001,
 ('er', 162): 161.928775,
 ('er', 163): 162.930029,
 ('er', 164): 163.929197,
 ('er', 165): 164.930723,
 ('er', 166): 165.93029,
 ('er', 167): 166.932045,
 ('er', 168): 167.932368,
 ('er', 169): 168.934588,
 ('er', 170): 169.93546,
 ('er', 171): 170.938026,
 ('er', 172): 171.939352,
 ('er', 173): 172.9424,
 ('er', 174): 173.94434,
 ('er', 175): 174.94793,
 ('er', 176): 175.95029,
 ('er', 177): 176.95437,
 ('es', 240): 240.06892,
 ('es', 241): 241.06866,
 ('es', 242): 242.0697,
 ('es', 243): 243.06963,
 ('es', 244): 244.07097,
 ('es', 245): 245.07132,
 ('es', 246): 246.07297,
 ('es', 247): 247.07365,
 ('es', 248): 248.07546,
 ('es', 249): 249.07641,
 ('es', 250): 250.07865,
 ('es', 251): 251.079984,
 ('es', 252): 252.08297,
 ('es', 253): 253.084818,
 ('es', 254): 254.088016,
 ('es', 255): 255.090266,
 ('es', 256): 256.09359,
 ('es', 257): 257.09598,
 ('eu', 132): 131.95416,
 ('eu', 133): 132.9489,
 ('eu', 134): 133.94632,
 ('eu', 135): 134.94172,
 ('eu', 136): 135.9395,
 ('eu', 137): 136.93521,
 ('eu', 138): 137.93345,
 ('eu', 139): 138.92984,
 ('eu', 140): 139.92808,
 ('eu', 141): 140.92489,
 ('eu', 142): 141.9234,
 ('eu', 143): 142.920287,
 ('eu', 144): 143.918774,
 ('eu', 145): 144.916261,
 ('eu', 146): 145.9172,
 ('eu', 147): 146.916741,
 ('eu', 148): 147.918154,
 ('eu', 149): 148.917926,
 ('eu', 150): 149.919698,
 ('eu', 151): 150.919846,
 ('eu', 152): 151.92174,
 ('eu', 153): 152.921226,
 ('eu', 154): 153.922975,
 ('eu', 155): 154.922889,
 ('eu', 156): 155.924751,
 ('eu', 157): 156.925419,
 ('eu', 158): 157.92784,
 ('eu', 159): 158.929084,
 ('eu', 160): 159.93197,
 ('eu', 161): 160.93368,
 ('eu', 162): 161.93704,
 ('eu', 163): 162.93921,
 ('eu', 164): 163.94299,
 ('eu', 165): 164.94572,
 ('eu', 166): 165.94997,
 ('eu', 167): 166.95305,
 ('f', 14): 14.03608,
 ('f', 15): 15.01801,
 ('f', 16): 16.011466,
 ('f', 17): 17.00209524,
 ('f', 18): 18.0009377,
 ('f', 19): 18.9984032,
 ('f', 20): 19.99998132,
 ('f', 21): 20.9999489,
 ('f', 22): 22.002999,
 ('f', 23): 23.00357,
 ('f', 24): 24.0081,
 ('f', 25): 25.01209,
 ('f', 26): 26.01963,
 ('f', 27): 27.02689,
 ('f', 28): 28.03567,
 ('f', 29): 29.04326,
 ('fe', 45): 45.01456,
 ('fe', 46): 46.00081,
 ('fe', 47): 46.99289,
 ('fe', 48): 47.98056,
 ('fe', 49): 48.97361,
 ('fe', 50): 49.96299,
 ('fe', 51): 50.956825,
 ('fe', 52): 51.948117,
 ('fe', 53): 52.9453123,
 ('fe', 54): 53.9396148,
 ('fe', 55): 54.938298,
 ('fe', 56): 55.9349421,
 ('fe', 57): 56.9353987,
 ('fe', 58): 57.9332805,
 ('fe', 59): 58.9348805,
 ('fe', 60): 59.934077,
 ('fe', 61): 60.936749,
 ('fe', 62): 61.93677,
 ('fe', 63): 62.94012,
 ('fe', 64): 63.94087,
 ('fe', 65): 64.94494,
 ('fe', 66): 65.94598,
 ('fe', 67): 66.95,
 ('fe', 68): 67.95251,
 ('fe', 69): 68.9577,
 ('fl', 289): None,
 ('fm', 242): 242.07343,
 ('fm', 243): 243.07451,
 ('fm', 244): 244.07408,
 ('fm', 245): 245.07538,
 ('fm', 246): 246.07528,
 ('fm', 247): 247.07682,
 ('fm', 248): 248.077184,
 ('fm', 249): 249.07902,
 ('fm', 250): 250.079515,
 ('fm', 251): 251.081566,
 ('fm', 252): 252.08246,
 ('fm', 253): 253.085176,
 ('fm', 254): 254.086848,
 ('fm', 255): 255.089955,
 ('fm', 256): 256.091767,
 ('fm', 257): 257.095099,
 ('fm', 258): 258.09707,
 ('fm', 259): 259.10059,
 ('fr', 200): 200.0065,
 ('fr', 201): 201.00399,
 ('fr', 202): 202.00329,
 ('fr', 203): 203.00105,
 ('fr', 204): 204.00059,
 ('fr', 205): 204.99866,
 ('fr', 206): 205.99849,
 ('fr', 207): 206.99686,
 ('fr', 208): 207.99713,
 ('fr', 209): 208.99592,
 ('fr', 210): 209.996398,
 ('fr', 211): 210.995529,
 ('fr', 212): 211.996195,
 ('fr', 213): 212.996175,
 ('fr', 214): 213.998955,
 ('fr', 215): 215.000326,
 ('fr', 216): 216.003188,
 ('fr', 217): 217.004616,
 ('fr', 218): 218.007563,
 ('fr', 219): 219.009241,
 ('fr', 220): 220.012313,
 ('fr', 221): 221.014246,
 ('fr', 222): 222.017544,
 ('fr', 223): 223.0197307,
 ('fr', 224): 224.02324,
 ('fr', 225): 225.025607,
 ('fr', 226): 226.02934,
 ('fr', 227): 227.03183,
 ('fr', 228): 228.03572,
 ('fr', 229): 229.03843,
 ('fr', 230): 230.04251,
 ('fr', 231): 231.04541,
 ('fr', 232): 232.04965,
 ('ga', 56): 55.99491,
 ('ga', 57): 56.98293,
 ('ga', 58): 57.97425,
 ('ga', 59): 58.96337,
 ('ga', 60): 59.95706,
 ('ga', 61): 60.94917,
 ('ga', 62): 61.94418,
 ('ga', 63): 62.93914,
 ('ga', 64): 63.936838,
 ('ga', 65): 64.9327393,
 ('ga', 66): 65.931592,
 ('ga', 67): 66.9282049,
 ('ga', 68): 67.9279835,
 ('ga', 69): 68.925581,
 ('ga', 70): 69.926028,
 ('ga', 71): 70.924705,
 ('ga', 72): 71.9263694,
 ('ga', 73): 72.92517,
 ('ga', 74): 73.92694,
 ('ga', 75): 74.926501,
 ('ga', 76): 75.92893,
 ('ga', 77): 76.92928,
 ('ga', 78): 77.93166,
 ('ga', 79): 78.93292,
 ('ga', 80): 79.93659,
 ('ga', 81): 80.93775,
 ('ga', 82): 81.94316,
 ('ga', 83): 82.94687,
 ('ga', 84): 83.95234,
 ('gd', 136): 135.94707,
 ('gd', 137): 136.94465,
 ('gd', 138): 137.93997,
 ('gd', 139): 138.93808,
 ('gd', 140): 139.93395,
 ('gd', 141): 140.93221,
 ('gd', 142): 141.92823,
 ('gd', 143): 142.92674,
 ('gd', 144): 143.92279,
 ('gd', 145): 144.92169,
 ('gd', 146): 145.918305,
 ('gd', 147): 146.919089,
 ('gd', 148): 147.91811,
 ('gd', 149): 148.919336,
 ('gd', 150): 149.918655,
 ('gd', 151): 150.920344,
 ('gd', 152): 151.919788,
 ('gd', 153): 152.921746,
 ('gd', 154): 153.920862,
 ('gd', 155): 154.922619,
 ('gd', 156): 155.92212,
 ('gd', 157): 156.923957,
 ('gd', 158): 157.924101,
 ('gd', 159): 158.926385,
 ('gd', 160): 159.927051,
 ('gd', 161): 160.929666,
 ('gd', 162): 161.930981,
 ('gd', 163): 162.93399,
 ('gd', 164): 163.93586,
 ('gd', 165): 164.93938,
 ('gd', 166): 165.9416,
 ('gd', 167): 166.94557,
 ('gd', 168): 167.94836,
 ('gd', 169): 168.95287,
 ('ge', 58): 57.99101,
 ('ge', 59): 58.98175,
 ('ge', 60): 59.97019,
 ('ge', 61): 60.96379,
 ('ge', 62): 61.95465,
 ('ge', 63): 62.94964,
 ('ge', 64): 63.94157,
 ('ge', 65): 64.93944,
 ('ge', 66): 65.93385,
 ('ge', 67): 66.932738,
 ('ge', 68): 67.928097,
 ('ge', 69): 68.927972,
 ('ge', 70): 69.9242504,
 ('ge', 71): 70.924954,
 ('ge', 72): 71.9220762,
 ('ge', 73): 72.9234594,
 ('ge', 74): 73.9211782,
 ('ge', 75): 74.9228595,
 ('ge', 76): 75.9214027,
 ('ge', 77): 76.9235485,
 ('ge', 78): 77.922853,
 ('ge', 79): 78.9254,
 ('ge', 80): 79.925445,
 ('ge', 81): 80.92882,
 ('ge', 82): 81.92955,
 ('ge', 83): 82.93451,
 ('ge', 84): 83.93731,
 ('ge', 85): 84.94269,
 ('ge', 86): 85.94627,
 ('h', 1): 1.0078250321,
 ('h', 2): 2.014101778,
 ('h', 3): 3.0160492675,
 ('h', 4): 4.02783,
 ('h', 5): 5.03954,
 ('h', 6): 6.04494,
 ('he', 3): 3.0160293097,
 ('he', 4): 4.0026032497,
 ('he', 5): 5.01222,
 ('he', 6): 6.0188881,
 ('he', 7): 7.02803,
 ('he', 8): 8.033922,
 ('he', 9): 9.04382,
 ('he', 10): 10.0524,
 ('hf', 154): 153.96425,
 ('hf', 155): 154.96276,
 ('hf', 156): 155.95925,
 ('hf', 157): 156.95813,
 ('hf', 158): 157.95465,
 ('hf', 159): 158.954,
 ('hf', 160): 159.95071,
 ('hf', 161): 160.95033,
 ('hf', 162): 161.947203,
 ('hf', 163): 162.94706,
 ('hf', 164): 163.94442,
 ('hf', 165): 164.94454,
 ('hf', 166): 165.94225,
 ('hf', 167): 166.9426,
 ('hf', 168): 167.94063,
 ('hf', 169): 168.94116,
 ('hf', 170): 169.93965,
 ('hf', 171): 170.94049,
 ('hf', 172): 171.93946,
 ('hf', 173): 172.94065,
 ('hf', 174): 173.94004,
 ('hf', 175): 174.941503,
 ('hf', 176): 175.9414018,
 ('hf', 177): 176.94322,
 ('hf', 178): 177.9436977,
 ('hf', 179): 178.9458151,
 ('hf', 180): 179.9465488,
 ('hf', 181): 180.9490991,
 ('hf', 182): 181.950553,
 ('hf', 183): 182.95353,
 ('hf', 184): 183.95545,
 ('hf', 185): 184.95878,
 ('hf', 186): 185.96092,
 ('hg', 175): 174.99141,
 ('hg', 176): 175.98741,
 ('hg', 177): 176.98634,
 ('hg', 178): 177.982476,
 ('hg', 179): 178.98178,
 ('hg', 180): 179.97832,
 ('hg', 181): 180.97781,
 ('hg', 182): 181.97475,
 ('hg', 183): 182.97456,
 ('hg', 184): 183.9719,
 ('hg', 185): 184.97198,
 ('hg', 186): 185.96946,
 ('hg', 187): 186.96979,
 ('hg', 188): 187.96756,
 ('hg', 189): 188.96813,
 ('hg', 190): 189.96628,
 ('hg', 191): 190.96706,
 ('hg', 192): 191.96557,
 ('hg', 193): 192.966644,
 ('hg', 194): 193.965382,
 ('hg', 195): 194.96664,
 ('hg', 196): 195.965815,
 ('hg', 197): 196.967195,
 ('hg', 198): 197.966752,
 ('hg', 199): 198.968262,
 ('hg', 200): 199.968309,
 ('hg', 201): 200.970285,
 ('hg', 202): 201.970626,
 ('hg', 203): 202.972857,
 ('hg', 204): 203.973476,
 ('hg', 205): 204.976056,
 ('hg', 206): 205.977499,
 ('hg', 207): 206.98258,
 ('hg', 208): 207.98594,
 ('ho', 142): 141.95986,
 ('ho', 143): 142.95469,
 ('ho', 144): 143.95164,
 ('ho', 145): 144.94688,
 ('ho', 146): 145.9441,
 ('ho', 147): 146.93984,
 ('ho', 148): 147.93727,
 ('ho', 149): 148.93379,
 ('ho', 150): 149.93335,
 ('ho', 151): 150.931681,
 ('ho', 152): 151.93174,
 ('ho', 153): 152.930195,
 ('ho', 154): 153.930596,
 ('ho', 155): 154.929079,
 ('ho', 156): 155.92971,
 ('ho', 157): 156.92819,
 ('ho', 158): 157.92895,
 ('ho', 159): 158.927709,
 ('ho', 160): 159.928726,
 ('ho', 161): 160.927852,
 ('ho', 162): 161.929092,
 ('ho', 163): 162.92873,
 ('ho', 164): 163.930231,
 ('ho', 165): 164.930319,
 ('ho', 166): 165.932281,
 ('ho', 167): 166.933126,
 ('ho', 168): 167.9355,
 ('ho', 169): 168.936868,
 ('ho', 170): 169.93961,
 ('ho', 171): 170.94146,
 ('ho', 172): 171.94482,
 ('ho', 173): 172.94729,
 ('ho', 174): 173.95115,
 ('ho', 175): 174.95405,
 ('hs', 263): 263.12871,
 ('hs', 264): 264.12841,
 ('hs', 265): 265.13,
 ('hs', 266): 266.13004,
 ('hs', 267): 267.13177,
 ('hs', 268): 268.13216,
 ('hs', 269): 269.13411,
 ('hs', 277): None,
 ('i', 108): 107.94329,
 ('i', 109): 108.93819,
 ('i', 110): 109.93521,
 ('i', 111): 110.93028,
 ('i', 112): 111.92797,
 ('i', 113): 112.92364,
 ('i', 114): 113.92185,
 ('i', 115): 114.91792,
 ('i', 116): 115.91674,
 ('i', 117): 116.91365,
 ('i', 118): 117.91338,
 ('i', 119): 118.91018,
 ('i', 120): 119.910048,
 ('i', 121): 120.907366,
 ('i', 122): 121.907592,
 ('i', 123): 122.905598,
 ('i', 124): 123.9062114,
 ('i', 125): 124.9046241,
 ('i', 126): 125.905619,
 ('i', 127): 126.904468,
 ('i', 128): 127.905805,
 ('i', 129): 128.904987,
 ('i', 130): 129.906674,
 ('i', 131): 130.9061242,
 ('i', 132): 131.907995,
 ('i', 133): 132.907806,
 ('i', 134): 133.909877,
 ('i', 135): 134.91005,
 ('i', 136): 135.91466,
 ('i', 137): 136.917873,
 ('i', 138): 137.92238,
 ('i', 139): 138.92609,
 ('i', 140): 139.93121,
 ('i', 141): 140.93483,
 ('i', 142): 141.94018,
 ('i', 143): 142.94407,
 ('i', 144): 143.94961,
 ('in', 98): 97.94224,
 ('in', 99): 98.93461,
 ('in', 100): 99.93115,
 ('in', 101): 100.92656,
 ('in', 102): 101.92471,
 ('in', 103): 102.919914,
 ('in', 104): 103.91834,
 ('in', 105): 104.914673,
 ('in', 106): 105.913461,
 ('in', 107): 106.910292,
 ('in', 108): 107.90972,
 ('in', 109): 108.907154,
 ('in', 110): 109.907169,
 ('in', 111): 110.905111,
 ('in', 112): 111.905533,
 ('in', 113): 112.904061,
 ('in', 114): 113.904917,
 ('in', 115): 114.903878,
 ('in', 116): 115.90526,
 ('in', 117): 116.904516,
 ('in', 118): 117.906355,
 ('in', 119): 118.905846,
 ('in', 120): 119.90796,
 ('in', 121): 120.907849,
 ('in', 122): 121.91028,
 ('in', 123): 122.910439,
 ('in', 124): 123.91318,
 ('in', 125): 124.9136,
 ('in', 126): 125.91646,
 ('in', 127): 126.91734,
 ('in', 128): 127.92017,
 ('in', 129): 128.92166,
 ('in', 130): 129.92485,
 ('in', 131): 130.92677,
 ('in', 132): 131.93292,
 ('in', 133): 132.93834,
 ('in', 134): 133.94466,
 ('ir', 165): 164.98758,
 ('ir', 166): 165.98551,
 ('ir', 167): 166.98154,
 ('ir', 168): 167.97997,
 ('ir', 169): 168.97639,
 ('ir', 170): 169.97503,
 ('ir', 171): 170.97178,
 ('ir', 172): 171.97064,
 ('ir', 173): 172.96771,
 ('ir', 174): 173.9668,
 ('ir', 175): 174.96428,
 ('ir', 176): 175.96351,
 ('ir', 177): 176.96117,
 ('ir', 178): 177.96108,
 ('ir', 179): 178.95915,
 ('ir', 180): 179.95925,
 ('ir', 181): 180.95764,
 ('ir', 182): 181.95813,
 ('ir', 183): 182.95681,
 ('ir', 184): 183.95739,
 ('ir', 185): 184.95659,
 ('ir', 186): 185.957951,
 ('ir', 187): 186.957361,
 ('ir', 188): 187.958852,
 ('ir', 189): 188.958716,
 ('ir', 190): 189.96059,
 ('ir', 191): 190.960591,
 ('ir', 192): 191.962602,
 ('ir', 193): 192.962924,
 ('ir', 194): 193.965076,
 ('ir', 195): 194.965977,
 ('ir', 196): 195.96838,
 ('ir', 197): 196.969636,
 ('ir', 198): 197.97228,
 ('ir', 199): 198.97379,
 ('k', 32): 32.02192,
 ('k', 33): 33.00726,
 ('k', 34): 33.99841,
 ('k', 35): 34.988012,
 ('k', 36): 35.981293,
 ('k', 37): 36.97337691,
 ('k', 38): 37.9690801,
 ('k', 39): 38.9637069,
 ('k', 40): 39.96399867,
 ('k', 41): 40.96182597,
 ('k', 42): 41.9624031,
 ('k', 43): 42.960716,
 ('k', 44): 43.96156,
 ('k', 45): 44.9607,
 ('k', 46): 45.961976,
 ('k', 47): 46.961678,
 ('k', 48): 47.965513,
 ('k', 49): 48.96745,
 ('k', 50): 49.97278,
 ('k', 51): 50.97638,
 ('k', 52): 51.98261,
 ('k', 53): 52.98712,
 ('k', 54): 53.99399,
 ('k', 55): 54.99939,
 ('kr', 69): 68.96532,
 ('kr', 70): 69.95601,
 ('kr', 71): 70.95051,
 ('kr', 72): 71.94191,
 ('kr', 73): 72.93893,
 ('kr', 74): 73.93326,
 ('kr', 75): 74.931034,
 ('kr', 76): 75.925948,
 ('kr', 77): 76.924668,
 ('kr', 78): 77.920386,
 ('kr', 79): 78.920083,
 ('kr', 80): 79.916378,
 ('kr', 81): 80.916592,
 ('kr', 82): 81.9134846,
 ('kr', 83): 82.914136,
 ('kr', 84): 83.911507,
 ('kr', 85): 84.912527,
 ('kr', 86): 85.9106103,
 ('kr', 87): 86.9133543,
 ('kr', 88): 87.914447,
 ('kr', 89): 88.91763,
 ('kr', 90): 89.919524,
 ('kr', 91): 90.92344,
 ('kr', 92): 91.926153,
 ('kr', 93): 92.93127,
 ('kr', 94): 93.93436,
 ('kr', 95): 94.93984,
 ('kr', 96): 95.94307,
 ('kr', 97): 96.94856,
 ('la', 117): 116.95001,
 ('la', 118): 117.94657,
 ('la', 119): 118.94099,
 ('la', 120): 119.93807,
 ('la', 121): 120.93301,
 ('la', 122): 121.93071,
 ('la', 123): 122.92624,
 ('la', 124): 123.92453,
 ('la', 125): 124.92067,
 ('la', 126): 125.91937,
 ('la', 127): 126.91616,
 ('la', 128): 127.91545,
 ('la', 129): 128.91267,
 ('la', 130): 129.91232,
 ('la', 131): 130.91011,
 ('la', 132): 131.91011,
 ('la', 133): 132.9084,
 ('la', 134): 133.90849,
 ('la', 135): 134.906971,
 ('la', 136): 135.90765,
 ('la', 137): 136.90647,
 ('la', 138): 137.907107,
 ('la', 139): 138.906348,
 ('la', 140): 139.909473,
 ('la', 141): 140.910957,
 ('la', 142): 141.914074,
 ('la', 143): 142.916059,
 ('la', 144): 143.91959,
 ('la', 145): 144.92164,
 ('la', 146): 145.9257,
 ('la', 147): 146.92782,
 ('la', 148): 147.93219,
 ('la', 149): 148.93437,
 ('la', 150): 149.93857,
 ('la', 151): 150.94156,
 ('la', 152): 151.94611,
 ('la', 153): 152.94945,
 ('la', 154): 153.9544,
 ('la', 155): 154.95813,
 ('li', 4): 4.02718,
 ('li', 5): 5.01254,
 ('li', 6): 6.0151223,
 ('li', 7): 7.016004,
 ('li', 8): 8.0224867,
 ('li', 9): 9.0267891,
 ('li', 10): 10.035481,
 ('li', 11): 11.043796,
 ('li', 12): 12.05378,
 ('lr', 251): 251.09436,
 ('lr', 252): 252.09533,
 ('lr', 253): 253.09526,
 ('lr', 254): 254.09659,
 ('lr', 255): 255.09677,
 ('lr', 256): 256.09876,
 ('lr', 257): 257.09961,
 ('lr', 258): 258.10188,
 ('lr', 259): 259.10299,
 ('lr', 260): 260.10557,
 ('lr', 261): 261.10694,
 ('lr', 262): 262.10969,
 ('lr', 263): 263.11139,
 ('lu', 150): 149.97267,
 ('lu', 151): 150.96715,
 ('lu', 152): 151.96361,
 ('lu', 153): 152.95869,
 ('lu', 154): 153.9571,
 ('lu', 155): 154.95423,
 ('lu', 156): 155.95291,
 ('lu', 157): 156.950102,
 ('lu', 158): 157.94917,
 ('lu', 159): 158.94662,
 ('lu', 160): 159.94602,
 ('lu', 161): 160.94354,
 ('lu', 162): 161.94322,
 ('lu', 163): 162.9412,
 ('lu', 164): 163.94122,
 ('lu', 165): 164.93961,
 ('lu', 166): 165.93976,
 ('lu', 167): 166.93831,
 ('lu', 168): 167.9387,
 ('lu', 169): 168.937649,
 ('lu', 170): 169.938472,
 ('lu', 171): 170.93791,
 ('lu', 172): 171.939082,
 ('lu', 173): 172.938927,
 ('lu', 174): 173.9403335,
 ('lu', 175): 174.9407679,
 ('lu', 176): 175.9426824,
 ('lu', 177): 176.943755,
 ('lu', 178): 177.945951,
 ('lu', 179): 178.947324,
 ('lu', 180): 179.94988,
 ('lu', 181): 180.95197,
 ('lu', 182): 181.95521,
 ('lu', 183): 182.95757,
 ('lu', 184): 183.96117,
 ('lv', 293): None,
 ('mc', 289): None,
 ('md', 245): 245.08102,
 ('md', 246): 246.08193,
 ('md', 247): 247.0818,
 ('md', 248): 248.08291,
 ('md', 249): 249.083,
 ('md', 250): 250.08449,
 ('md', 251): 251.08492,
 ('md', 252): 252.08663,
 ('md', 253): 253.08728,
 ('md', 254): 254.08973,
 ('md', 255): 255.091075,
 ('md', 256): 256.09405,
 ('md', 257): 257.095535,
 ('md', 258): 258.098425,
 ('md', 259): 259.1005,
 ('md', 260): 260.10365,
 ('mg', 20): 20.018863,
 ('mg', 21): 21.011714,
 ('mg', 22): 21.9995741,
 ('mg', 23): 22.9941249,
 ('mg', 24): 23.9850419,
 ('mg', 25): 24.98583702,
 ('mg', 26): 25.98259304,
 ('mg', 27): 26.98434074,
 ('mg', 28): 27.9838767,
 ('mg', 29): 28.98855,
 ('mg', 30): 29.99046,
 ('mg', 31): 30.99655,
 ('mg', 32): 31.99915,
 ('mg', 33): 33.00559,
 ('mg', 34): 34.00907,
 ('mg', 35): 35.01749,
 ('mg', 36): 36.02245,
 ('mg', 37): 37.03124,
 ('mn', 44): 44.00687,
 ('mn', 45): 44.99451,
 ('mn', 46): 45.98672,
 ('mn', 47): 46.9761,
 ('mn', 48): 47.96887,
 ('mn', 49): 48.959623,
 ('mn', 50): 49.954244,
 ('mn', 51): 50.9482155,
 ('mn', 52): 51.9455701,
 ('mn', 53): 52.9412947,
 ('mn', 54): 53.9403632,
 ('mn', 55): 54.9380496,
 ('mn', 56): 55.9389094,
 ('mn', 57): 56.938287,
 ('mn', 58): 57.93999,
 ('mn', 59): 58.94045,
 ('mn', 60): 59.94319,
 ('mn', 61): 60.94446,
 ('mn', 62): 61.94797,
 ('mn', 63): 62.94981,
 ('mn', 64): 63.95373,
 ('mn', 65): 64.9561,
 ('mn', 66): 65.96082,
 ('mn', 67): 66.96382,
 ('mo', 83): 82.94874,
 ('mo', 84): 83.94009,
 ('mo', 85): 84.93659,
 ('mo', 86): 85.9307,
 ('mo', 87): 86.92733,
 ('mo', 88): 87.921953,
 ('mo', 89): 88.919481,
 ('mo', 90): 89.913936,
 ('mo', 91): 90.911751,
 ('mo', 92): 91.90681,
 ('mo', 93): 92.906812,
 ('mo', 94): 93.9050876,
 ('mo', 95): 94.9058415,
 ('mo', 96): 95.9046789,
 ('mo', 97): 96.906021,
 ('mo', 98): 97.9054078,
 ('mo', 99): 98.9077116,
 ('mo', 100): 99.907477,
 ('mo', 101): 100.910347,
 ('mo', 102): 101.910297,
 ('mo', 103): 102.9132,
 ('mo', 104): 103.91376,
 ('mo', 105): 104.91697,
 ('mo', 106): 105.918134,
 ('mo', 107): 106.92169,
 ('mo', 108): 107.92358,
 ('mo', 109): 108.92781,
 ('mo', 110): 109.92973,
 ('mo', 111): 110.93451,
 ('mo', 112): 111.93684,
 ('mo', 113): 112.94203,
 ('mt', 265): 265.13657,
 ('mt', 266): 266.13794,
 ('mt', 267): 267.13753,
 ('mt', 268): 268.13882,
 ('mt', 269): 269.13911,
 ('mt', 270): 270.14072,
 ('mt', 271): 271.14123,
 ('n', 10): 10.04262,
 ('n', 11): 11.0268,
 ('n', 12): 12.0186132,
 ('n', 13): 13.00573858,
 ('n', 14): 14.0030740052,
 ('n', 15): 15.0001088984,
 ('n', 16): 16.0061014,
 ('n', 17): 17.00845,
 ('n', 18): 18.014082,
 ('n', 19): 19.017027,
 ('n', 20): 20.02337,
 ('n', 21): 21.02709,
 ('n', 22): 22.03444,
 ('n', 23): 23.04051,
 ('n', 24): 24.0505,
 ('na', 18): 18.02718,
 ('na', 19): 19.013879,
 ('na', 20): 20.007348,
 ('na', 21): 20.9976551,
 ('na', 22): 21.9944368,
 ('na', 23): 22.98976967,
 ('na', 24): 23.99096333,
 ('na', 25): 24.9899544,
 ('na', 26): 25.99259,
 ('na', 27): 26.99401,
 ('na', 28): 27.99889,
 ('na', 29): 29.00281,
 ('na', 30): 30.00923,
 ('na', 31): 31.0136,
 ('na', 32): 32.01965,
 ('na', 33): 33.02739,
 ('na', 34): 34.0349,
 ('na', 35): 35.04418,
 ('nb', 81): 80.94905,
 ('nb', 82): 81.94313,
 ('nb', 83): 82.9367,
 ('nb', 84): 83.93357,
 ('nb', 85): 84.92791,
 ('nb', 86): 85.92504,
 ('nb', 87): 86.92036,
 ('nb', 88): 87.91796,
 ('nb', 89): 88.9135,
 ('nb', 90): 89.911264,
 ('nb', 91): 90.906991,
 ('nb', 92): 91.9071932,
 ('nb', 93): 92.9063775,
 ('nb', 94): 93.9072835,
 ('nb', 95): 94.9068352,
 ('nb', 96): 95.9081,
 ('nb', 97): 96.9080971,
 ('nb', 98): 97.910331,
 ('nb', 99): 98.911618,
 ('nb', 100): 99.914181,
 ('nb', 101): 100.915252,
 ('nb', 102): 101.91804,
 ('nb', 103): 102.91914,
 ('nb', 104): 103.92246,
 ('nb', 105): 104.92393,
 ('nb', 106): 105.92819,
 ('nb', 107): 106.93031,
 ('nb', 108): 107.93501,
 ('nb', 109): 108.93763,
 ('nb', 110): 109.94268,
 ('nd', 126): 125.94307,
 ('nd', 127): 126.9405,
 ('nd', 128): 127.93539,
 ('nd', 129): 128.93325,
 ('nd', 130): 129.92878,
 ('nd', 131): 130.9271,
 ('nd', 132): 131.92312,
 ('nd', 133): 132.92221,
 ('nd', 134): 133.91865,
 ('nd', 135): 134.91824,
 ('nd', 136): 135.91502,
 ('nd', 137): 136.91464,
 ('nd', 138): 137.91193,
 ('nd', 139): 138.91192,
 ('nd', 140): 139.90931,
 ('nd', 141): 140.909605,
 ('nd', 142): 141.907719,
 ('nd', 143): 142.90981,
 ('nd', 144): 143.910083,
 ('nd', 145): 144.912569,
 ('nd', 146): 145.913112,
 ('nd', 147): 146.916096,
 ('nd', 148): 147.916889,
 ('nd', 149): 148.920144,
 ('nd', 150): 149.920887,
 ('nd', 151): 150.923825,
 ('nd', 152): 151.92468,
 ('nd', 153): 152.927695,
 ('nd', 154): 153.92948,
 ('nd', 155): 154.93263,
 ('nd', 156): 155.9352,
 ('nd', 157): 156.93927,
 ('nd', 158): 157.94187,
 ('nd', 159): 158.94639,
 ('nd', 160): 159.94939,
 ('nd', 161): 160.95433,
 ('ne', 16): 16.025757,
 ('ne', 17): 17.0177,
 ('ne', 18): 18.0056971,
 ('ne', 19): 19.0018798,
 ('ne', 20): 19.9924401759,
 ('ne', 21): 20.99384674,
 ('ne', 22): 21.99138551,
 ('ne', 23): 22.99446734,
 ('ne', 24): 23.993615,
 ('ne', 25): 24.99779,
 ('ne', 26): 26.00046,
 ('ne', 27): 27.00762,
 ('ne', 28): 28.01211,
 ('ne', 29): 29.01935,
 ('ne', 30): 30.02387,
 ('ne', 31): 31.03311,
 ('ne', 32): 32.03991,
 ('nh', 286): None,
 ('ni', 50): 49.99593,
 ('ni', 51): 50.98772,
 ('ni', 52): 51.97568,
 ('ni', 53): 52.96846,
 ('ni', 54): 53.95791,
 ('ni', 55): 54.951336,
 ('ni', 56): 55.942136,
 ('ni', 57): 56.9398,
 ('ni', 58): 57.9353479,
 ('ni', 59): 58.9343516,
 ('ni', 60): 59.9307906,
 ('ni', 61): 60.9310604,
 ('ni', 62): 61.9283488,
 ('ni', 63): 62.9296729,
 ('ni', 64): 63.9279696,
 ('ni', 65): 64.930088,
 ('ni', 66): 65.929115,
 ('ni', 67): 66.93157,
 ('ni', 68): 67.931845,
 ('ni', 69): 68.93518,
 ('ni', 70): 69.93614,
 ('ni', 71): 70.94,
 ('ni', 72): 71.9413,
 ('ni', 73): 72.94608,
 ('ni', 74): 73.94791,
 ('ni', 75): 74.95297,
 ('ni', 76): 75.95533,
 ('ni', 77): 76.96083,
 ('ni', 78): 77.9638,
 ('no', 249): 249.08782,
 ('no', 250): 250.08749,
 ('no', 251): 251.08896,
 ('no', 252): 252.088966,
 ('no', 253): 253.09065,
 ('no', 254): 254.090949,
 ('no', 255): 255.093232,
 ('no', 256): 256.094276,
 ('no', 257): 257.09685,
 ('no', 258): 258.0982,
 ('no', 259): 259.10102,
 ('no', 260): 260.10264,
 ('no', 261): 261.10574,
 ('no', 262): 262.10752,
 ('np', 225): 225.0339,
 ('np', 226): 226.03513,
 ('np', 227): 227.03496,
 ('np', 228): 228.03618,
 ('np', 229): 229.03625,
 ('np', 230): 230.03781,
 ('np', 231): 231.03823,
 ('np', 232): 232.0401,
 ('np', 233): 233.04073,
 ('np', 234): 234.042889,
 ('np', 235): 235.0440559,
 ('np', 236): 236.04656,
 ('np', 237): 237.0481673,
 ('np', 238): 238.0509405,
 ('np', 239): 239.0529314,
 ('np', 240): 240.056169,
 ('np', 241): 241.05825,
 ('np', 242): 242.06164,
 ('np', 243): 243.06427,
 ('np', 244): 244.06785,
 ('o', 12): 12.034405,
 ('o', 13): 13.02481,
 ('o', 14): 14.00859529,
 ('o', 15): 15.0030654,
 ('o', 16): 15.9949146221,
 ('o', 17): 16.9991315,
 ('o', 18): 17.9991604,
 ('o', 19): 19.003579,
 ('o', 20): 20.0040762,
 ('o', 21): 21.008655,
 ('o', 22): 22.00997,
 ('o', 23): 23.01569,
 ('o', 24): 24.02037,
 ('o', 25): 25.02914,
 ('o', 26): 26.03775,
 ('og', 294): None,
 ('os', 162): 161.98382,
 ('os', 163): 162.98205,
 ('os', 164): 163.97793,
 ('os', 165): 164.97648,
 ('os', 166): 165.97253,
 ('os', 167): 166.97155,
 ('os', 168): 167.96783,
 ('os', 169): 168.96708,
 ('os', 170): 169.96357,
 ('os', 171): 170.96304,
 ('os', 172): 171.96008,
 ('os', 173): 172.95979,
 ('os', 174): 173.95712,
 ('os', 175): 174.95708,
 ('os', 176): 175.95495,
 ('os', 177): 176.95505,
 ('os', 178): 177.95335,
 ('os', 179): 178.95395,
 ('os', 180): 179.95235,
 ('os', 181): 180.95327,
 ('os', 182): 181.952186,
 ('os', 183): 182.95311,
 ('os', 184): 183.952491,
 ('os', 185): 184.954043,
 ('os', 186): 185.953838,
 ('os', 187): 186.9557479,
 ('os', 188): 187.955836,
 ('os', 189): 188.9581449,
 ('os', 190): 189.958445,
 ('os', 191): 190.960928,
 ('os', 192): 191.961479,
 ('os', 193): 192.964148,
 ('os', 194): 193.965179,
 ('os', 195): 194.96812,
 ('os', 196): 195.96962,
 ('p', 24): 24.03435,
 ('p', 25): 25.02026,
 ('p', 26): 26.01178,
 ('p', 27): 26.99919,
 ('p', 28): 27.992312,
 ('p', 29): 28.9818014,
 ('p', 30): 29.9783138,
 ('p', 31): 30.97376151,
 ('p', 32): 31.97390716,
 ('p', 33): 32.9717253,
 ('p', 34): 33.973636,
 ('p', 35): 34.9733142,
 ('p', 36): 35.97826,
 ('p', 37): 36.97961,
 ('p', 38): 37.98447,
 ('p', 39): 38.98642,
 ('p', 40): 39.99105,
 ('p', 41): 40.9948,
 ('p', 42): 42.00009,
 ('p', 43): 43.00331,
 ('p', 44): 44.00988,
 ('p', 45): 45.01514,
 ('p', 46): 46.02383,
 ('pa', 213): 213.02118,
 ('pa', 214): 214.02074,
 ('pa', 215): 215.0191,
 ('pa', 216): 216.01911,
 ('pa', 217): 217.01829,
 ('pa', 218): 218.02001,
 ('pa', 219): 219.01988,
 ('pa', 220): 220.02188,
 ('pa', 221): 221.02186,
 ('pa', 222): 222.02373,
 ('pa', 223): 223.02396,
 ('pa', 224): 224.02561,
 ('pa', 225): 225.02612,
 ('pa', 226): 226.027933,
 ('pa', 227): 227.028793,
 ('pa', 228): 228.031037,
 ('pa', 229): 229.032089,
 ('pa', 230): 230.034533,
 ('pa', 231): 231.0358789,
 ('pa', 232): 232.038582,
 ('pa', 233): 233.0402402,
 ('pa', 234): 234.043302,
 ('pa', 235): 235.04544,
 ('pa', 236): 236.04868,
 ('pa', 237): 237.05114,
 ('pa', 238): 238.0545,
 ('pa', 239): 239.05713,
 ('pa', 240): 240.06098,
 ('pb', 181): 180.99671,
 ('pb', 182): 181.992676,
 ('pb', 183): 182.99193,
 ('pb', 184): 183.9882,
 ('pb', 185): 184.98758,
 ('pb', 186): 185.9843,
 ('pb', 187): 186.98403,
 ('pb', 188): 187.98106,
 ('pb', 189): 188.98088,
 ('pb', 190): 189.97818,
 ('pb', 191): 190.9782,
 ('pb', 192): 191.97576,
 ('pb', 193): 192.97608,
 ('pb', 194): 193.97397,
 ('pb', 195): 194.97447,
 ('pb', 196): 195.97271,
 ('pb', 197): 196.97338,
 ('pb', 198): 197.97198,
 ('pb', 199): 198.97291,
 ('pb', 200): 199.971816,
 ('pb', 201): 200.97285,
 ('pb', 202): 201.972144,
 ('pb', 203): 202.973375,
 ('pb', 204): 203.973029,
 ('pb', 205): 204.974467,
 ('pb', 206): 205.974449,
 ('pb', 207): 206.975881,
 ('pb', 208): 207.976636,
 ('pb', 209): 208.981075,
 ('pb', 210): 209.984173,
 ('pb', 211): 210.988731,
 ('pb', 212): 211.9918875,
 ('pb', 213): 212.9965,
 ('pb', 214): 213.9997981,
 ('pd', 91): 90.94948,
 ('pd', 92): 91.94042,
 ('pd', 93): 92.93591,
 ('pd', 94): 93.92877,
 ('pd', 95): 94.92469,
 ('pd', 96): 95.91822,
 ('pd', 97): 96.91648,
 ('pd', 98): 97.912721,
 ('pd', 99): 98.911768,
 ('pd', 100): 99.908505,
 ('pd', 101): 100.908289,
 ('pd', 102): 101.905608,
 ('pd', 103): 102.906087,
 ('pd', 104): 103.904035,
 ('pd', 105): 104.905084,
 ('pd', 106): 105.903483,
 ('pd', 107): 106.905128,
 ('pd', 108): 107.903894,
 ('pd', 109): 108.905954,
 ('pd', 110): 109.905152,
 ('pd', 111): 110.90764,
 ('pd', 112): 111.907313,
 ('pd', 113): 112.91015,
 ('pd', 114): 113.910365,
 ('pd', 115): 114.91368,
 ('pd', 116): 115.91416,
 ('pd', 117): 116.91784,
 ('pd', 118): 117.91898,
 ('pd', 119): 118.92268,
 ('pd', 120): 119.92403,
 ('pd', 121): 120.92818,
 ('pd', 122): 121.9298,
 ('pd', 123): 122.93426,
 ('pm', 128): 127.94826,
 ('pm', 129): 128.94316,
 ('pm', 130): 129.94045,
 ('pm', 131): 130.9358,
 ('pm', 132): 131.93375,
 ('pm', 133): 132.92972,
 ('pm', 134): 133.92849,
 ('pm', 135): 134.92462,
 ('pm', 136): 135.92345,
 ('pm', 137): 136.92071,
 ('pm', 138): 137.91945,
 ('pm', 139): 138.91676,
 ('pm', 140): 139.9158,
 ('pm', 141): 140.913607,
 ('pm', 142): 141.91295,
 ('pm', 143): 142.910928,
 ('pm', 144): 143.912586,
 ('pm', 145): 144.912744,
 ('pm', 146): 145.914692,
 ('pm', 147): 146.915134,
 ('pm', 148): 147.917468,
 ('pm', 149): 148.918329,
 ('pm', 150): 149.920979,
 ('pm', 151): 150.921203,
 ('pm', 152): 151.92349,
 ('pm', 153): 152.924113,
 ('pm', 154): 153.92655,
 ('pm', 155): 154.9281,
 ('pm', 156): 155.93106,
 ('pm', 157): 156.9332,
 ('pm', 158): 157.93669,
 ('pm', 159): 158.93913,
 ('pm', 160): 159.94299,
 ('pm', 161): 160.94586,
 ('pm', 162): 161.95029,
 ('pm', 163): 162.95352,
 ('po', 190): 189.99511,
 ('po', 191): 190.99465,
 ('po', 192): 191.99152,
 ('po', 193): 192.9911,
 ('po', 194): 193.98828,
 ('po', 195): 194.98805,
 ('po', 196): 195.98551,
 ('po', 197): 196.98557,
 ('po', 198): 197.98334,
 ('po', 199): 198.9836,
 ('po', 200): 199.98174,
 ('po', 201): 200.98221,
 ('po', 202): 201.9807,
 ('po', 203): 202.98141,
 ('po', 204): 203.980307,
 ('po', 205): 204.98117,
 ('po', 206): 205.980465,
 ('po', 207): 206.981578,
 ('po', 208): 207.981231,
 ('po', 209): 208.982416,
 ('po', 210): 209.982857,
 ('po', 211): 210.986637,
 ('po', 212): 211.988852,
 ('po', 213): 212.992843,
 ('po', 214): 213.995186,
 ('po', 215): 214.999415,
 ('po', 216): 216.0019052,
 ('po', 217): 217.00625,
 ('po', 218): 218.0089658,
 ('pr', 121): 120.95536,
 ('pr', 122): 121.95165,
 ('pr', 123): 122.94596,
 ('pr', 124): 123.94296,
 ('pr', 125): 124.93783,
 ('pr', 126): 125.93531,
 ('pr', 127): 126.93083,
 ('pr', 128): 127.9288,
 ('pr', 129): 128.92486,
 ('pr', 130): 129.92338,
 ('pr', 131): 130.92006,
 ('pr', 132): 131.91912,
 ('pr', 133): 132.9162,
 ('pr', 134): 133.91567,
 ('pr', 135): 134.91314,
 ('pr', 136): 135.91265,
 ('pr', 137): 136.91068,
 ('pr', 138): 137.910749,
 ('pr', 139): 138.908932,
 ('pr', 140): 139.909071,
 ('pr', 141): 140.907648,
 ('pr', 142): 141.91004,
 ('pr', 143): 142.910812,
 ('pr', 144): 143.913301,
 ('pr', 145): 144.914507,
 ('pr', 146): 145.91759,
 ('pr', 147): 146.91898,
 ('pr', 148): 147.92218,
 ('pr', 149): 148.923791,
 ('pr', 150): 149.927,
 ('pr', 151): 150.92823,
 ('pr', 152): 151.9316,
 ('pr', 153): 152.93365,
 ('pr', 154): 153.93739,
 ('pr', 155): 154.93999,
 ('pr', 156): 155.94412,
 ('pr', 157): 156.94717,
 ('pr', 158): 157.95178,
 ('pr', 159): 158.95523,
 ('pt', 168): 167.98804,
 ('pt', 169): 168.98642,
 ('pt', 170): 169.98233,
 ('pt', 171): 170.98125,
 ('pt', 172): 171.97738,
 ('pt', 173): 172.9765,
 ('pt', 174): 173.972811,
 ('pt', 175): 174.97228,
 ('pt', 176): 175.969,
 ('pt', 177): 176.96845,
 ('pt', 178): 177.96571,
 ('pt', 179): 178.96548,
 ('pt', 180): 179.96322,
 ('pt', 181): 180.96318,
 ('pt', 182): 181.96127,
 ('pt', 183): 182.96173,
 ('pt', 184): 183.9599,
 ('pt', 185): 184.96075,
 ('pt', 186): 185.95943,
 ('pt', 187): 186.96056,
 ('pt', 188): 187.959396,
 ('pt', 189): 188.960832,
 ('pt', 190): 189.95993,
 ('pt', 191): 190.961685,
 ('pt', 192): 191.961035,
 ('pt', 193): 192.962985,
 ('pt', 194): 193.962664,
 ('pt', 195): 194.964774,
 ('pt', 196): 195.964935,
 ('pt', 197): 196.967323,
 ('pt', 198): 197.967876,
 ('pt', 199): 198.970576,
 ('pt', 200): 199.971424,
 ('pt', 201): 200.9745,
 ('pt', 202): 201.97574,
 ('pu', 228): 228.03873,
 ('pu', 229): 229.04014,
 ('pu', 230): 230.039646,
 ('pu', 231): 231.04126,
 ('pu', 232): 232.041179,
 ('pu', 233): 233.04299,
 ('pu', 234): 234.043305,
 ('pu', 235): 235.045282,
 ('pu', 236): 236.0460481,
 ('pu', 237): 237.0484038,
 ('pu', 238): 238.0495534,
 ('pu', 239): 239.0521565,
 ('pu', 240): 240.0538075,
 ('pu', 241): 241.0568453,
 ('pu', 242): 242.0587368,
 ('pu', 243): 243.061997,
 ('pu', 244): 244.064198,
 ('pu', 245): 245.067739,
 ('pu', 246): 246.070198,
 ('pu', 247): 247.07407,
 ('ra', 203): 203.00921,
 ('ra', 204): 204.00648,
 ('ra', 205): 205.00619,
 ('ra', 206): 206.00378,
 ('ra', 207): 207.00373,
 ('ra', 208): 208.00178,
 ('ra', 209): 209.00194,
 ('ra', 210): 210.00045,
 ('ra', 211): 211.00089,
 ('ra', 212): 211.999783,
 ('ra', 213): 213.00035,
 ('ra', 214): 214.000091,
 ('ra', 215): 215.002704,
 ('ra', 216): 216.003518,
 ('ra', 217): 217.006306,
 ('ra', 218): 218.007124,
 ('ra', 219): 219.010069,
 ('ra', 220): 220.011015,
 ('ra', 221): 221.013908,
 ('ra', 222): 222.015362,
 ('ra', 223): 223.018497,
 ('ra', 224): 224.020202,
 ('ra', 225): 225.023604,
 ('ra', 226): 226.0254026,
 ('ra', 227): 227.0291707,
 ('ra', 228): 228.0310641,
 ('ra', 229): 229.03482,
 ('ra', 230): 230.03708,
 ('ra', 231): 231.04122,
 ('ra', 232): 232.04369,
 ('ra', 233): 233.048,
 ('ra', 234): 234.05055,
 ('rb', 71): 70.96532,
 ('rb', 72): 71.95908,
 ('rb', 73): 72.95037,
 ('rb', 74): 73.94447,
 ('rb', 75): 74.938569,
 ('rb', 76): 75.935071,
 ('rb', 77): 76.930407,
 ('rb', 78): 77.928141,
 ('rb', 79): 78.923997,
 ('rb', 80): 79.922519,
 ('rb', 81): 80.918994,
 ('rb', 82): 81.918208,
 ('rb', 83): 82.915112,
 ('rb', 84): 83.914385,
 ('rb', 85): 84.9117893,
 ('rb', 86): 85.9111671,
 ('rb', 87): 86.9091835,
 ('rb', 88): 87.911319,
 ('rb', 89): 88.91228,
 ('rb', 90): 89.914809,
 ('rb', 91): 90.916534,
 ('rb', 92): 91.919725,
 ('rb', 93): 92.922033,
 ('rb', 94): 93.926407,
 ('rb', 95): 94.929319,
 ('rb', 96): 95.934284,
 ('rb', 97): 96.93734,
 ('rb', 98): 97.9417,
 ('rb', 99): 98.94542,
 ('rb', 100): 99.94987,
 ('rb', 101): 100.9532,
 ('rb', 102): 101.95921,
 ('re', 160): 159.98149,
 ('re', 161): 160.97766,
 ('re', 162): 161.97571,
 ('re', 163): 162.97197,
 ('re', 164): 163.97032,
 ('re', 165): 164.96705,
 ('re', 166): 165.9658,
 ('re', 167): 166.96256,
 ('re', 168): 167.96161,
 ('re', 169): 168.95883,
 ('re', 170): 169.95816,
 ('re', 171): 170.95555,
 ('re', 172): 171.95529,
 ('re', 173): 172.95306,
 ('re', 174): 173.95311,
 ('re', 175): 174.95139,
 ('re', 176): 175.95157,
 ('re', 177): 176.95027,
 ('re', 178): 177.95085,
 ('re', 179): 178.94998,
 ('re', 180): 179.95079,
 ('re', 181): 180.950065,
 ('re', 182): 181.95121,
 ('re', 183): 182.950821,
 ('re', 184): 183.952524,
 ('re', 185): 184.9529557,
 ('re', 186): 185.954987,
 ('re', 187): 186.9557508,
 ('re', 188): 187.9581123,
 ('re', 189): 188.959228,
 ('re', 190): 189.96182,
 ('re', 191): 190.963124,
 ('re', 192): 191.96596,
 ('rf', 253): 253.10068,
 ('rf', 254): 254.10017,
 ('rf', 255): 255.10149,
 ('rf', 256): 256.10118,
 ('rf', 257): 257.10307,
 ('rf', 258): 258.10357,
 ('rf', 259): 259.10563,
 ('rf', 260): 260.10643,
 ('rf', 261): 261.10875,
 ('rf', 262): 262.10992,
 ('rf', 263): 263.11254,
 ('rf', 264): 264.11398,
 ('rg', 272): 272.15348,
 ('rh', 89): 88.94938,
 ('rh', 90): 89.94287,
 ('rh', 91): 90.93655,
 ('rh', 92): 91.93198,
 ('rh', 93): 92.92574,
 ('rh', 94): 93.9217,
 ('rh', 95): 94.9159,
 ('rh', 96): 95.914518,
 ('rh', 97): 96.91134,
 ('rh', 98): 97.910716,
 ('rh', 99): 98.908132,
 ('rh', 100): 99.908117,
 ('rh', 101): 100.906164,
 ('rh', 102): 101.906843,
 ('rh', 103): 102.905504,
 ('rh', 104): 103.906655,
 ('rh', 105): 104.905692,
 ('rh', 106): 105.907285,
 ('rh', 107): 106.906751,
 ('rh', 108): 107.90873,
 ('rh', 109): 108.908736,
 ('rh', 110): 109.91095,
 ('rh', 111): 110.91166,
 ('rh', 112): 111.91461,
 ('rh', 113): 112.91542,
 ('rh', 114): 113.91885,
 ('rh', 115): 114.92012,
 ('rh', 116): 115.92371,
 ('rh', 117): 116.92535,
 ('rh', 118): 117.92943,
 ('rh', 119): 118.93136,
 ('rh', 120): 119.93578,
 ('rh', 121): 120.93808,
 ('rn', 196): 196.00231,
 ('rn', 197): 197.00166,
 ('rn', 198): 197.99878,
 ('rn', 199): 198.99831,
 ('rn', 200): 199.99568,
 ('rn', 201): 200.99554,
 ('rn', 202): 201.99322,
 ('rn', 203): 202.99332,
 ('rn', 204): 203.99137,
 ('rn', 205): 204.99167,
 ('rn', 206): 205.99016,
 ('rn', 207): 206.99073,
 ('rn', 208): 207.989631,
 ('rn', 209): 208.99038,
 ('rn', 210): 209.98968,
 ('rn', 211): 210.990585,
 ('rn', 212): 211.990689,
 ('rn', 213): 212.993868,
 ('rn', 214): 213.995346,
 ('rn', 215): 214.998729,
 ('rn', 216): 216.000258,
 ('rn', 217): 217.003915,
 ('rn', 218): 218.005586,
 ('rn', 219): 219.009475,
 ('rn', 220): 220.0113841,
 ('rn', 221): 221.01546,
 ('rn', 222): 222.0175705,
 ('rn', 223): 223.02179,
 ('rn', 224): 224.02409,
 ('rn', 225): 225.02844,
 ('rn', 226): 226.03089,
 ('rn', 227): 227.03541,
 ('rn', 228): 228.03808,
 ('ru', 87): 86.94918,
 ('ru', 88): 87.94042,
 ('ru', 89): 88.93611,
 ('ru', 90): 89.92978,
 ('ru', 91): 90.92638,
 ('ru', 92): 91.92012,
 ('ru', 93): 92.91705,
 ('ru', 94): 93.91136,
 ('ru', 95): 94.910413,
 ('ru', 96): 95.907598,
 ('ru', 97): 96.907555,
 ('ru', 98): 97.905287,
 ('ru', 99): 98.9059393,
 ('ru', 100): 99.9042197,
 ('ru', 101): 100.9055822,
 ('ru', 102): 101.9043495,
 ('ru', 103): 102.9063237,
 ('ru', 104): 103.90543,
 ('ru', 105): 104.90775,
 ('ru', 106): 105.907327,
 ('ru', 107): 106.90991,
 ('ru', 108): 107.91019,
 ('ru', 109): 108.9132,
 ('ru', 110): 109.91397,
 ('ru', 111): 110.91756,
 ('ru', 112): 111.91855,
 ('ru', 113): 112.92254,
 ('ru', 114): 113.924,
 ('ru', 115): 114.92831,
 ('ru', 116): 115.93016,
 ('ru', 117): 116.93479,
 ('ru', 118): 117.93703,
 ('s', 26): 26.02788,
 ('s', 27): 27.0188,
 ('s', 28): 28.00437,
 ('s', 29): 28.99661,
 ('s', 30): 29.984903,
 ('s', 31): 30.9795544,
 ('s', 32): 31.97207069,
 ('s', 33): 32.9714585,
 ('s', 34): 33.96786683,
 ('s', 35): 34.96903214,
 ('s', 36): 35.96708088,
 ('s', 37): 36.97112572,
 ('s', 38): 37.971163,
 ('s', 39): 38.97514,
 ('s', 40): 39.97547,
 ('s', 41): 40.98003,
 ('s', 42): 41.98149,
 ('s', 43): 42.9866,
 ('s', 44): 43.98832,
 ('s', 45): 44.99482,
 ('s', 46): 45.99957,
 ('s', 47): 47.00762,
 ('s', 48): 48.01299,
 ('s', 49): 49.02201,
 ('sb', 103): 102.94012,
 ('sb', 104): 103.93629,
 ('sb', 105): 104.93153,
 ('sb', 106): 105.92876,
 ('sb', 107): 106.92415,
 ('sb', 108): 107.92216,
 ('sb', 109): 108.918136,
 ('sb', 110): 109.91676,
 ('sb', 111): 110.91321,
 ('sb', 112): 111.912395,
 ('sb', 113): 112.909378,
 ('sb', 114): 113.9091,
 ('sb', 115): 114.906599,
 ('sb', 116): 115.906797,
 ('sb', 117): 116.90484,
 ('sb', 118): 117.905532,
 ('sb', 119): 118.903946,
 ('sb', 120): 119.905074,
 ('sb', 121): 120.903818,
 ('sb', 122): 121.9051754,
 ('sb', 123): 122.9042157,
 ('sb', 124): 123.9059375,
 ('sb', 125): 124.905248,
 ('sb', 126): 125.90725,
 ('sb', 127): 126.906915,
 ('sb', 128): 127.909167,
 ('sb', 129): 128.90915,
 ('sb', 130): 129.911546,
 ('sb', 131): 130.91195,
 ('sb', 132): 131.914413,
 ('sb', 133): 132.91524,
 ('sb', 134): 133.92055,
 ('sb', 135): 134.92517,
 ('sb', 136): 135.93066,
 ('sb', 137): 136.93531,
 ('sb', 138): 137.94096,
 ('sb', 139): 138.94571,
 ('sc', 36): 36.01492,
 ('sc', 37): 37.00305,
 ('sc', 38): 37.9947,
 ('sc', 39): 38.98479,
 ('sc', 40): 39.977964,
 ('sc', 41): 40.9692513,
 ('sc', 42): 41.9655168,
 ('sc', 43): 42.961151,
 ('sc', 44): 43.959403,
 ('sc', 45): 44.9559102,
 ('sc', 46): 45.9551703,
 ('sc', 47): 46.952408,
 ('sc', 48): 47.952235,
 ('sc', 49): 48.950024,
 ('sc', 50): 49.952187,
 ('sc', 51): 50.953603,
 ('sc', 52): 51.95665,
 ('sc', 53): 52.95924,
 ('sc', 54): 53.963,
 ('sc', 55): 54.96743,
 ('sc', 56): 55.97266,
 ('sc', 57): 56.97704,
 ('sc', 58): 57.98307,
 ('sc', 59): 58.98804,
 ('se', 65): 64.96466,
 ('se', 66): 65.95521,
 ('se', 67): 66.95009,
 ('se', 68): 67.94187,
 ('se', 69): 68.93956,
 ('se', 70): 69.9335,
 ('se', 71): 70.93227,
 ('se', 72): 71.927112,
 ('se', 73): 72.926767,
 ('se', 74): 73.9224766,
 ('se', 75): 74.9225236,
 ('se', 76): 75.9192141,
 ('se', 77): 76.9199146,
 ('se', 78): 77.9173095,
 ('se', 79): 78.9184998,
 ('se', 80): 79.9165218,
 ('se', 81): 80.9179929,
 ('se', 82): 81.9167,
 ('se', 83): 82.919119,
 ('se', 84): 83.918465,
 ('se', 85): 84.92224,
 ('se', 86): 85.924271,
 ('se', 87): 86.92852,
 ('se', 88): 87.93142,
 ('se', 89): 88.93602,
 ('se', 90): 89.93942,
 ('se', 91): 90.94537,
 ('se', 92): 91.94933,
 ('sg', 258): 258.11315,
 ('sg', 259): 259.11465,
 ('sg', 260): 260.11444,
 ('sg', 261): 261.1162,
 ('sg', 262): 262.11648,
 ('sg', 263): 263.11831,
 ('sg', 264): 264.11892,
 ('sg', 265): 265.12107,
 ('sg', 266): 266.12193,
 ('si', 22): 22.03453,
 ('si', 23): 23.02552,
 ('si', 24): 24.011546,
 ('si', 25): 25.004107,
 ('si', 26): 25.99233,
 ('si', 27): 26.98670476,
 ('si', 28): 27.9769265327,
 ('si', 29): 28.97649472,
 ('si', 30): 29.97377022,
 ('si', 31): 30.97536327,
 ('si', 32): 31.9741481,
 ('si', 33): 32.978001,
 ('si', 34): 33.978576,
 ('si', 35): 34.98458,
 ('si', 36): 35.98669,
 ('si', 37): 36.993,
 ('si', 38): 37.99598,
 ('si', 39): 39.0023,
 ('si', 40): 40.0058,
 ('si', 41): 41.0127,
 ('si', 42): 42.0161,
 ('sm', 130): 129.94863,
 ('sm', 131): 130.94589,
 ('sm', 132): 131.94082,
 ('sm', 133): 132.93873,
 ('sm', 134): 133.93402,
 ('sm', 135): 134.93235,
 ('sm', 136): 135.9283,
 ('sm', 137): 136.92705,
 ('sm', 138): 137.92354,
 ('sm', 139): 138.922302,
 ('sm', 140): 139.918991,
 ('sm', 141): 140.918469,
 ('sm', 142): 141.915193,
 ('sm', 143): 142.914624,
 ('sm', 144): 143.911995,
 ('sm', 145): 144.913406,
 ('sm', 146): 145.913037,
 ('sm', 147): 146.914893,
 ('sm', 148): 147.914818,
 ('sm', 149): 148.91718,
 ('sm', 150): 149.917271,
 ('sm', 151): 150.919928,
 ('sm', 152): 151.919728,
 ('sm', 153): 152.922094,
 ('sm', 154): 153.922205,
 ('sm', 155): 154.924636,
 ('sm', 156): 155.925526,
 ('sm', 157): 156.92835,
 ('sm', 158): 157.92999,
 ('sm', 159): 158.9332,
 ('sm', 160): 159.93514,
 ('sm', 161): 160.93883,
 ('sm', 162): 161.94122,
 ('sm', 163): 162.94536,
 ('sm', 164): 163.94828,
 ('sm', 165): 164.95298,
 ('sn', 100): 99.93895,
 ('sn', 101): 100.93606,
 ('sn', 102): 101.93049,
 ('sn', 103): 102.92813,
 ('sn', 104): 103.92319,
 ('sn', 105): 104.92139,
 ('sn', 106): 105.91688,
 ('sn', 107): 106.91567,
 ('sn', 108): 107.91197,
 ('sn', 109): 108.911287,
 ('sn', 110): 109.907853,
 ('sn', 111): 110.907735,
 ('sn', 112): 111.904821,
 ('sn', 113): 112.905173,
 ('sn', 114): 113.902782,
 ('sn', 115): 114.903346,
 ('sn', 116): 115.901744,
 ('sn', 117): 116.902954,
 ('sn', 118): 117.901606,
 ('sn', 119): 118.903309,
 ('sn', 120): 119.9021966,
 ('sn', 121): 120.9042369,
 ('sn', 122): 121.9034401,
 ('sn', 123): 122.9057219,
 ('sn', 124): 123.9052746,
 ('sn', 125): 124.9077849,
 ('sn', 126): 125.907654,
 ('sn', 127): 126.910351,
 ('sn', 128): 127.910535,
 ('sn', 129): 128.91344,
 ('sn', 130): 129.91385,
 ('sn', 131): 130.91692,
 ('sn', 132): 131.917744,
 ('sn', 133): 132.92381,
 ('sn', 134): 133.92846,
 ('sn', 135): 134.93473,
 ('sn', 136): 135.93934,
 ('sn', 137): 136.94579,
 ('sr', 73): 72.96597,
 ('sr', 74): 73.95631,
 ('sr', 75): 74.94992,
 ('sr', 76): 75.94161,
 ('sr', 77): 76.93776,
 ('sr', 78): 77.932179,
 ('sr', 79): 78.929707,
 ('sr', 80): 79.924525,
 ('sr', 81): 80.923213,
 ('sr', 82): 81.918401,
 ('sr', 83): 82.917555,
 ('sr', 84): 83.913425,
 ('sr', 85): 84.912933,
 ('sr', 86): 85.9092624,
 ('sr', 87): 86.9088793,
 ('sr', 88): 87.9056143,
 ('sr', 89): 88.9074529,
 ('sr', 90): 89.9077376,
 ('sr', 91): 90.91021,
 ('sr', 92): 91.91103,
 ('sr', 93): 92.914022,
 ('sr', 94): 93.91536,
 ('sr', 95): 94.919358,
 ('sr', 96): 95.92168,
 ('sr', 97): 96.926149,
 ('sr', 98): 97.928471,
 ('sr', 99): 98.93332,
 ('sr', 100): 99.93535,
 ('sr', 101): 100.94052,
 ('sr', 102): 101.94302,
 ('sr', 103): 102.94895,
 ('sr', 104): 103.95233,
 ('ta', 156): 155.97169,
 ('ta', 157): 156.96815,
 ('ta', 158): 157.96637,
 ('ta', 159): 158.96291,
 ('ta', 160): 159.96136,
 ('ta', 161): 160.95837,
 ('ta', 162): 161.95715,
 ('ta', 163): 162.95432,
 ('ta', 164): 163.95357,
 ('ta', 165): 164.95082,
 ('ta', 166): 165.95047,
 ('ta', 167): 166.94797,
 ('ta', 168): 167.94779,
 ('ta', 169): 168.94592,
 ('ta', 170): 169.94609,
 ('ta', 171): 170.94446,
 ('ta', 172): 171.94474,
 ('ta', 173): 172.94354,
 ('ta', 174): 173.94417,
 ('ta', 175): 174.94365,
 ('ta', 176): 175.94474,
 ('ta', 177): 176.944472,
 ('ta', 178): 177.94575,
 ('ta', 179): 178.945934,
 ('ta', 180): 179.947466,
 ('ta', 181): 180.947996,
 ('ta', 182): 181.950152,
 ('ta', 183): 182.951373,
 ('ta', 184): 183.954009,
 ('ta', 185): 184.955559,
 ('ta', 186): 185.95855,
 ('ta', 187): 186.96041,
 ('ta', 188): 187.96371,
 ('tb', 138): 137.95287,
 ('tb', 139): 138.94803,
 ('tb', 140): 139.94554,
 ('tb', 141): 140.94116,
 ('tb', 142): 141.93886,
 ('tb', 143): 142.93475,
 ('tb', 144): 143.93253,
 ('tb', 145): 144.92888,
 ('tb', 146): 145.92718,
 ('tb', 147): 146.924037,
 ('tb', 148): 147.9243,
 ('tb', 149): 148.923242,
 ('tb', 150): 149.923654,
 ('tb', 151): 150.923098,
 ('tb', 152): 151.92407,
 ('tb', 153): 152.923431,
 ('tb', 154): 153.92469,
 ('tb', 155): 154.9235,
 ('tb', 156): 155.924744,
 ('tb', 157): 156.924021,
 ('tb', 158): 157.92541,
 ('tb', 159): 158.925343,
 ('tb', 160): 159.927164,
 ('tb', 161): 160.927566,
 ('tb', 162): 161.92948,
 ('tb', 163): 162.930644,
 ('tb', 164): 163.93335,
 ('tb', 165): 164.93488,
 ('tb', 166): 165.93805,
 ('tb', 167): 166.94005,
 ('tb', 168): 167.94364,
 ('tb', 169): 168.94622,
 ('tb', 170): 169.95025,
 ('tb', 171): 170.9533,
 ('tc', 85): 84.94894,
 ('tc', 86): 85.94288,
 ('tc', 87): 86.93653,
 ('tc', 88): 87.93283,
 ('tc', 89): 88.92754,
 ('tc', 90): 89.92356,
 ('tc', 91): 90.91843,
 ('tc', 92): 91.91526,
 ('tc', 93): 92.910248,
 ('tc', 94): 93.909656,
 ('tc', 95): 94.907656,
 ('tc', 96): 95.907871,
 ('tc', 97): 96.906365,
 ('tc', 98): 97.907216,
 ('tc', 99): 98.9062546,
 ('tc', 100): 99.9076576,
 ('tc', 101): 100.907314,
 ('tc', 102): 101.909213,
 ('tc', 103): 102.909179,
 ('tc', 104): 103.91144,
 ('tc', 105): 104.91166,
 ('tc', 106): 105.914355,
 ('tc', 107): 106.91508,
 ('tc', 108): 107.91848,
 ('tc', 109): 108.91963,
 ('tc', 110): 109.92339,
 ('tc', 111): 110.92505,
 ('tc', 112): 111.92924,
 ('tc', 113): 112.93133,
 ('tc', 114): 113.93588,
 ('tc', 115): 114.93828,
 ('te', 106): 105.9377,
 ('te', 107): 106.93504,
 ('te', 108): 107.92949,
 ('te', 109): 108.92746,
 ('te', 110): 109.92241,
 ('te', 111): 110.92112,
 ('te', 112): 111.91706,
 ('te', 113): 112.91593,
 ('te', 114): 113.91206,
 ('te', 115): 114.91158,
 ('te', 116): 115.90842,
 ('te', 117): 116.908634,
 ('te', 118): 117.905825,
 ('te', 119): 118.906408,
 ('te', 120): 119.90402,
 ('te', 121): 120.90493,
 ('te', 122): 121.9030471,
 ('te', 123): 122.904273,
 ('te', 124): 123.9028195,
 ('te', 125): 124.9044247,
 ('te', 126): 125.9033055,
 ('te', 127): 126.905217,
 ('te', 128): 127.9044614,
 ('te', 129): 128.906596,
 ('te', 130): 129.9062228,
 ('te', 131): 130.9085219,
 ('te', 132): 131.908524,
 ('te', 133): 132.91094,
 ('te', 134): 133.91154,
 ('te', 135): 134.91645,
 ('te', 136): 135.9201,
 ('te', 137): 136.92532,
 ('te', 138): 137.92922,
 ('te', 139): 138.93473,
 ('te', 140): 139.9387,
 ('te', 141): 140.94439,
 ('te', 142): 141.9485,
 ('th', 210): 210.01503,
 ('th', 211): 211.01486,
 ('th', 212): 212.01292,
 ('th', 213): 213.01296,
 ('th', 214): 214.01145,
 ('th', 215): 215.01173,
 ('th', 216): 216.011051,
 ('th', 217): 217.01307,
 ('th', 218): 218.013268,
 ('th', 219): 219.01552,
 ('th', 220): 220.015733,
 ('th', 221): 221.018171,
 ('th', 222): 222.018454,
 ('th', 223): 223.020795,
 ('th', 224): 224.021459,
 ('th', 225): 225.023941,
 ('th', 226): 226.024891,
 ('th', 227): 227.027699,
 ('th', 228): 228.0287313,
 ('th', 229): 229.031755,
 ('th', 230): 230.0331266,
 ('th', 231): 231.0362971,
 ('th', 232): 232.0380504,
 ('th', 233): 233.0415769,
 ('th', 234): 234.043595,
 ('th', 235): 235.0475,
 ('th', 236): 236.04971,
 ('th', 237): 237.05389,
 ('th', 238): 238.05624,
 ('ti', 38): 38.00977,
 ('ti', 39): 39.00132,
 ('ti', 40): 39.9905,
 ('ti', 41): 40.98313,
 ('ti', 42): 41.973032,
 ('ti', 43): 42.968523,
 ('ti', 44): 43.9596902,
 ('ti', 45): 44.9581243,
 ('ti', 46): 45.9526295,
 ('ti', 47): 46.9517638,
 ('ti', 48): 47.9479471,
 ('ti', 49): 48.9478708,
 ('ti', 50): 49.9447921,
 ('ti', 51): 50.946616,
 ('ti', 52): 51.946898,
 ('ti', 53): 52.94973,
 ('ti', 54): 53.95087,
 ('ti', 55): 54.95512,
 ('ti', 56): 55.95799,
 ('ti', 57): 56.9629,
 ('ti', 58): 57.96611,
 ('ti', 59): 58.97196,
 ('ti', 60): 59.97564,
 ('ti', 61): 60.98202,
 ('tl', 177): 176.99688,
 ('tl', 178): 177.99523,
 ('tl', 179): 178.99147,
 ('tl', 180): 179.99019,
 ('tl', 181): 180.9869,
 ('tl', 182): 181.98561,
 ('tl', 183): 182.9827,
 ('tl', 184): 183.98176,
 ('tl', 185): 184.9791,
 ('tl', 186): 185.97855,
 ('tl', 187): 186.97617,
 ('tl', 188): 187.97592,
 ('tl', 189): 188.97369,
 ('tl', 190): 189.97379,
 ('tl', 191): 190.97189,
 ('tl', 192): 191.97214,
 ('tl', 193): 192.97055,
 ('tl', 194): 193.97105,
 ('tl', 195): 194.96965,
 ('tl', 196): 195.97052,
 ('tl', 197): 196.96954,
 ('tl', 198): 197.97047,
 ('tl', 199): 198.96981,
 ('tl', 200): 199.970945,
 ('tl', 201): 200.970804,
 ('tl', 202): 201.972091,
 ('tl', 203): 202.972329,
 ('tl', 204): 203.973849,
 ('tl', 205): 204.974412,
 ('tl', 206): 205.976095,
 ('tl', 207): 206.977408,
 ('tl', 208): 207.982005,
 ('tl', 209): 208.985349,
 ('tl', 210): 209.990066,
 ('tm', 146): 145.9665,
 ('tm', 147): 146.96108,
 ('tm', 148): 147.95755,
 ('tm', 149): 148.95265,
 ('tm', 150): 149.94967,
 ('tm', 151): 150.94543,
 ('tm', 152): 151.9443,
 ('tm', 153): 152.942028,
 ('tm', 154): 153.94142,
 ('tm', 155): 154.939192,
 ('tm', 156): 155.93901,
 ('tm', 157): 156.93676,
 ('tm', 158): 157.937,
 ('tm', 159): 158.93481,
 ('tm', 160): 159.93509,
 ('tm', 161): 160.9334,
 ('tm', 162): 161.93397,
 ('tm', 163): 162.932648,
 ('tm', 164): 163.933451,
 ('tm', 165): 164.932432,
 ('tm', 166): 165.933553,
 ('tm', 167): 166.932849,
 ('tm', 168): 167.93417,
 ('tm', 169): 168.934211,
 ('tm', 170): 169.935798,
 ('tm', 171): 170.936426,
 ('tm', 172): 171.938396,
 ('tm', 173): 172.9396,
 ('tm', 174): 173.94216,
 ('tm', 175): 174.94383,
 ('tm', 176): 175.94699,
 ('tm', 177): 176.94904,
 ('tm', 178): 177.95264,
 ('tm', 179): 178.95534,
 ('ts', 294): None,
 ('u', 218): 218.02349,
 ('u', 219): 219.02492,
 ('u', 220): 220.02471,
 ('u', 221): 221.02635,
 ('u', 222): 222.02607,
 ('u', 223): 223.02772,
 ('u', 224): 224.02759,
 ('u', 225): 225.02938,
 ('u', 226): 226.02934,
 ('u', 227): 227.03114,
 ('u', 228): 228.031366,
 ('u', 229): 229.033496,
 ('u', 230): 230.033927,
 ('u', 231): 231.036289,
 ('u', 232): 232.0371463,
 ('u', 233): 233.039628,
 ('u', 234): 234.0409456,
 ('u', 235): 235.0439231,
 ('u', 236): 236.0455619,
 ('u', 237): 237.048724,
 ('u', 238): 238.0507826,
 ('u', 239): 239.0542878,
 ('u', 240): 240.056586,
 ('u', 241): 241.06033,
 ('u', 242): 242.06293,
 ('v', 40): 40.01109,
 ('v', 41): 40.99974,
 ('v', 42): 41.99123,
 ('v', 43): 42.98065,
 ('v', 44): 43.9744,
 ('v', 45): 44.965782,
 ('v', 46): 45.9601995,
 ('v', 47): 46.9549069,
 ('v', 48): 47.9522545,
 ('v', 49): 48.9485169,
 ('v', 50): 49.9471628,
 ('v', 51): 50.9439637,
 ('v', 52): 51.9447797,
 ('v', 53): 52.944343,
 ('v', 54): 53.946444,
 ('v', 55): 54.94724,
 ('v', 56): 55.95036,
 ('v', 57): 56.95236,
 ('v', 58): 57.95665,
 ('v', 59): 58.9593,
 ('v', 60): 59.9645,
 ('v', 61): 60.96741,
 ('v', 62): 61.97314,
 ('v', 63): 62.97675,
 ('w', 158): 157.97394,
 ('w', 159): 158.97228,
 ('w', 160): 159.96837,
 ('w', 161): 160.96709,
 ('w', 162): 161.96334,
 ('w', 163): 162.96253,
 ('w', 164): 163.95898,
 ('w', 165): 164.95834,
 ('w', 166): 165.95502,
 ('w', 167): 166.95467,
 ('w', 168): 167.95186,
 ('w', 169): 168.95176,
 ('w', 170): 169.94929,
 ('w', 171): 170.94946,
 ('w', 172): 171.94742,
 ('w', 173): 172.94783,
 ('w', 174): 173.94616,
 ('w', 175): 174.94677,
 ('w', 176): 175.94559,
 ('w', 177): 176.94662,
 ('w', 178): 177.94585,
 ('w', 179): 178.947072,
 ('w', 180): 179.946706,
 ('w', 181): 180.948198,
 ('w', 182): 181.948206,
 ('w', 183): 182.9502245,
 ('w', 184): 183.9509326,
 ('w', 185): 184.9534206,
 ('w', 186): 185.954362,
 ('w', 187): 186.957158,
 ('w', 188): 187.958487,
 ('w', 189): 188.96191,
 ('w', 190): 189.96318,
 ('xe', 110): 109.94448,
 ('xe', 111): 110.94163,
 ('xe', 112): 111.93567,
 ('xe', 113): 112.93338,
 ('xe', 114): 113.92815,
 ('xe', 115): 114.92654,
 ('xe', 116): 115.92174,
 ('xe', 117): 116.92056,
 ('xe', 118): 117.91657,
 ('xe', 119): 118.91555,
 ('xe', 120): 119.91215,
 ('xe', 121): 120.911386,
 ('xe', 122): 121.90855,
 ('xe', 123): 122.908471,
 ('xe', 124): 123.9058958,
 ('xe', 125): 124.9063982,
 ('xe', 126): 125.904269,
 ('xe', 127): 126.90518,
 ('xe', 128): 127.9035304,
 ('xe', 129): 128.9047795,
 ('xe', 130): 129.9035079,
 ('xe', 131): 130.9050819,
 ('xe', 132): 131.9041545,
 ('xe', 133): 132.905906,
 ('xe', 134): 133.9053945,
 ('xe', 135): 134.907207,
 ('xe', 136): 135.90722,
 ('xe', 137): 136.911563,
 ('xe', 138): 137.91399,
 ('xe', 139): 138.918787,
 ('xe', 140): 139.92164,
 ('xe', 141): 140.92665,
 ('xe', 142): 141.9297,
 ('xe', 143): 142.93489,
 ('xe', 144): 143.93823,
 ('xe', 145): 144.94367,
 ('xe', 146): 145.9473,
 ('xe', 147): 146.95301,
 ('y', 77): 76.94962,
 ('y', 78): 77.9435,
 ('y', 79): 78.93735,
 ('y', 80): 79.93434,
 ('y', 81): 80.92913,
 ('y', 82): 81.92679,
 ('y', 83): 82.92235,
 ('y', 84): 83.92039,
 ('y', 85): 84.916427,
 ('y', 86): 85.914888,
 ('y', 87): 86.9108778,
 ('y', 88): 87.9095034,
 ('y', 89): 88.9058479,
 ('y', 90): 89.9071514,
 ('y', 91): 90.907303,
 ('y', 92): 91.908947,
 ('y', 93): 92.909582,
 ('y', 94): 93.911594,
 ('y', 95): 94.912824,
 ('y', 96): 95.915898,
 ('y', 97): 96.918131,
 ('y', 98): 97.92222,
 ('y', 99): 98.924635,
 ('y', 100): 99.92776,
 ('y', 101): 100.93031,
 ('y', 102): 101.93356,
 ('y', 103): 102.93694,
 ('y', 104): 103.94145,
 ('y', 105): 104.94509,
 ('y', 106): 105.95022,
 ('yb', 148): 147.96676,
 ('yb', 149): 148.96348,
 ('yb', 150): 149.95799,
 ('yb', 151): 150.95525,
 ('yb', 152): 151.95017,
 ('yb', 153): 152.94921,
 ('yb', 154): 153.94624,
 ('yb', 155): 154.94579,
 ('yb', 156): 155.94285,
 ('yb', 157): 156.94266,
 ('yb', 158): 157.939858,
 ('yb', 159): 158.94015,
 ('yb', 160): 159.93756,
 ('yb', 161): 160.93785,
 ('yb', 162): 161.93575,
 ('yb', 163): 162.93627,
 ('yb', 164): 163.93452,
 ('yb', 165): 164.935398,
 ('yb', 166): 165.93388,
 ('yb', 167): 166.934947,
 ('yb', 168): 167.933894,
 ('yb', 169): 168.935187,
 ('yb', 170): 169.934759,
 ('yb', 171): 170.936322,
 ('yb', 172): 171.9363777,
 ('yb', 173): 172.9382068,
 ('yb', 174): 173.9388581,
 ('yb', 175): 174.9412725,
 ('yb', 176): 175.942568,
 ('yb', 177): 176.945257,
 ('yb', 178): 177.946643,
 ('yb', 179): 178.95017,
 ('yb', 180): 179.95233,
 ('yb', 181): 180.95615,
 ('zn', 54): 53.99295,
 ('zn', 55): 54.98398,
 ('zn', 56): 55.97238,
 ('zn', 57): 56.96491,
 ('zn', 58): 57.9546,
 ('zn', 59): 58.94927,
 ('zn', 60): 59.941832,
 ('zn', 61): 60.939514,
 ('zn', 62): 61.934334,
 ('zn', 63): 62.9332156,
 ('zn', 64): 63.9291466,
 ('zn', 65): 64.9292451,
 ('zn', 66): 65.9260368,
 ('zn', 67): 66.9271309,
 ('zn', 68): 67.9248476,
 ('zn', 69): 68.9265535,
 ('zn', 70): 69.925325,
 ('zn', 71): 70.927727,
 ('zn', 72): 71.926861,
 ('zn', 73): 72.92978,
 ('zn', 74): 73.92946,
 ('zn', 75): 74.93294,
 ('zn', 76): 75.93339,
 ('zn', 77): 76.93709,
 ('zn', 78): 77.93857,
 ('zn', 79): 78.94268,
 ('zn', 80): 79.94441,
 ('zn', 81): 80.95048,
 ('zn', 82): 81.95484,
 ('zr', 79): 78.94916,
 ('zr', 80): 79.94055,
 ('zr', 81): 80.93682,
 ('zr', 82): 81.93109,
 ('zr', 83): 82.92865,
 ('zr', 84): 83.92325,
 ('zr', 85): 84.92147,
 ('zr', 86): 85.91647,
 ('zr', 87): 86.914817,
 ('zr', 88): 87.910226,
 ('zr', 89): 88.908889,
 ('zr', 90): 89.9047037,
 ('zr', 91): 90.905645,
 ('zr', 92): 91.9050401,
 ('zr', 93): 92.9064756,
 ('zr', 94): 93.9063158,
 ('zr', 95): 94.9080427,
 ('zr', 96): 95.908276,
 ('zr', 97): 96.910951,
 ('zr', 98): 97.912746,
 ('zr', 99): 98.916511,
 ('zr', 100): 99.91776,
 ('zr', 101): 100.92114,
 ('zr', 102): 101.92298,
 ('zr', 103): 102.9266,
 ('zr', 104): 103.92878,
 ('zr', 105): 104.93305,
 ('zr', 106): 105.93591,
 ('zr', 107): 106.94086,
 ('zr', 108): 107.94428,
}

# See 10.1039/b801115j
# {el.symbol: el.covalent_radius for el  in periodictable.elements
#  if el.covalent_radius}
# COVALENT_RADII_ANG = {
    # 'x': 0.529,
    # 'n': 0.71, 'h': 0.4, 'he': 0.28, 'li': 1.28, 'be': 0.96, 'b': 0.84,
    # 'c': 0.76, 'o': 0.66, 'f': 0.57, 'ne': 0.58, 'na': 1.66, 'mg': 1.41,
    # 'al': 1.21, 'si': 1.11, 'p': 1.07, 's': 1.05, 'cl': 1.02, 'ar': 1.06,
    # 'k': 2.03, 'ca': 1.76, 'sc': 1.7, 'ti': 1.6, 'v': 1.53, 'cr': 1.39,
    # 'mn': 1.39, 'fe': 1.32, 'co': 1.26, 'ni': 1.24, 'cu': 1.32, 'zn': 1.22,
    # 'ga': 1.22, 'ge': 1.2, 'as': 1.19, 'se': 1.2, 'br': 1.2, 'kr': 1.16,
    # 'rb': 2.2, 'sr': 1.95, 'y': 1.9, 'zr': 1.75, 'nb': 1.64, 'mo': 1.54,
    # 'tc': 1.47, 'ru': 1.46, 'rh': 1.42, 'pd': 1.39, 'ag': 1.45, 'cd': 1.44,
    # 'in': 1.42, 'sn': 1.39, 'sb': 1.39, 'te': 1.38, 'i': 1.39, 'xe': 1.4,
    # 'cs': 2.44, 'ba': 2.15, 'la': 2.07, 'ce': 2.04, 'pr': 2.03, 'nd': 2.01,
    # 'pm': 1.99, 'sm': 1.98, 'eu': 1.98, 'gd': 1.96, 'tb': 1.94, 'dy': 1.92,
    # 'ho': 1.92, 'er': 1.89, 'tm': 1.9, 'yb': 1.87, 'lu': 1.87, 'hf': 1.75,
    # 'ta': 1.7, 'w': 1.62, 're': 1.51, 'os': 1.44, 'ir': 1.41, 'pt': 1.36,
    # 'au': 1.36, 'hg': 1.32, 'tl': 1.45, 'pb': 1.46, 'bi': 1.48, 'po': 1.4,
    # 'at': 1.5, 'rn': 1.5, 'fr': 2.6, 'ra': 2.21, 'ac': 2.15, 'th': 2.06,
    # 'pa': 2.0, 'u': 1.96, 'np': 1.9, 'pu': 1.87, 'am': 1.8, 'cm': 1.69
# }

# In Bohr
COVALENT_RADII = {
    'x': 1.0,
    # Hydrogen uses a hardcoded value of 0.4 Angstrom instead of 0.31 Angstrom
    # (0.5858 au).
    'n': 1.3417, 'h': 0.7561, 'he': 0.5291, 'li': 2.4188, 'be': 1.8141,
    'b': 1.5874, 'c': 1.4362, 'o': 1.2472, 'f': 1.0771, 'ne': 1.096,
    'na': 3.1369, 'mg': 2.6645, 'al': 2.2866, 'si': 2.0976, 'p': 2.022,
    's': 1.9842, 'cl': 1.9275, 'ar': 2.0031, 'k': 3.8361, 'ca': 3.3259,
    'sc': 3.2125, 'ti': 3.0236, 'v': 2.8913, 'cr': 2.6267, 'mn': 2.6267,
    'fe': 2.4944, 'co': 2.3811, 'ni': 2.3433, 'cu': 2.4944, 'zn': 2.3055,
    'ga': 2.3055, 'ge': 2.2677, 'as': 2.2488, 'se': 2.2677, 'br': 2.2677,
    'kr': 2.1921, 'rb': 4.1574, 'sr': 3.685, 'y': 3.5905, 'zr': 3.307,
    'nb': 3.0992, 'mo': 2.9102, 'tc': 2.7779, 'ru': 2.759, 'rh': 2.6834,
    # 'nb': 3.0992, 'mo': 2.9102, 'tc': 2.7779, 'ru': 2.700, 'rh': 2.6834,
    'pd': 2.6267, 'ag': 2.7401, 'cd': 2.7212, 'in': 2.6834, 'sn': 2.6267,
    'sb': 2.6267, 'te': 2.6078, 'i': 2.6267, 'xe': 2.6456, 'cs': 4.6109,
    'ba': 4.0629, 'la': 3.9117, 'ce': 3.855, 'pr': 3.8361, 'nd': 3.7983,
    'pm': 3.7606, 'sm': 3.7417, 'eu': 3.7417, 'gd': 3.7039, 'tb': 3.6661,
    'dy': 3.6283, 'ho': 3.6283, 'er': 3.5716, 'tm': 3.5905, 'yb': 3.5338,
    'lu': 3.5338, 'hf': 3.307, 'ta': 3.2125, 'w': 3.0614, 're': 2.8535,
    'os': 2.7212, 'ir': 2.6645, 'pt': 2.57, 'au': 2.57, 'hg': 2.4944,
    'tl': 2.7401, 'pb': 2.759, 'bi': 2.7968, 'po': 2.6456, 'at': 2.8346,
    'rn': 2.8346, 'fr': 4.9133, 'ra': 4.1763, 'ac': 4.0629, 'th': 3.8928,
    'pa': 3.7795, 'u': 3.7039, 'np': 3.5905, 'pu': 3.5338, 'am': 3.4015,
    'cm': 3.1936
}

# Taken from mendeleev 0.41
# CRC Handbook of Chem. and Phys 95th ed.
# for e in element(["H", "N", "O", "F", "P", "S", "Cl"]):
#   print(e.symbol, e.vdw_radius)
# pm -> Bohr
# {key: f"{value/100*ANG2BOHR:.4f}" for key, value in VDW_RADII.items()}
# VDW_RADII = { # In pm
#    "h": 110.0000,
#    "n": 155.0,
#    "o": 152.0,
#    "f": 147.0,
#    "p": 180.0,
#    "s": 180.0,
#    "cl": 175.0,
# }
# In Bohr, for hydrogen bonds
VDW_RADII = {
    'h': 2.0787, 'n': 2.9291, 'o': 2.8724, 'f': 2.7779,
    'p': 3.4015, 's': 3.4015, 'cl': 3.3070
}


ATOMIC_NUMBERS = {
    'n': 7,
    'h': 1,
    'he': 2,
    'li': 3,
    'be': 4,
    'b': 5,
    'c': 6,
    'o': 8,
    'f': 9,
    'ne': 10,
    'na': 11,
    'mg': 12,
    'al': 13,
    'si': 14,
    'p': 15,
    's': 16,
    'cl': 17,
    'ar': 18,
    'k': 19,
    'ca': 20,
    'sc': 21,
    'ti': 22,
    'v': 23,
    'cr': 24,
    'mn': 25,
    'fe': 26,
    'co': 27,
    'ni': 28,
    'cu': 29,
    'zn': 30,
    'ga': 31,
    'ge': 32,
    'as': 33,
    'se': 34,
    'br': 35,
    'kr': 36,
    'rb': 37,
    'sr': 38,
    'y': 39,
    'zr': 40,
    'nb': 41,
    'mo': 42,
    'tc': 43,
    'ru': 44,
    'rh': 45,
    'pd': 46,
    'ag': 47,
    'cd': 48,
    'in': 49,
    'sn': 50,
    'sb': 51,
    'te': 52,
    'i': 53,
    'xe': 54,
    'cs': 55,
    'ba': 56,
    'la': 57,
    'ce': 58,
    'pr': 59,
    'nd': 60,
    'pm': 61,
    'sm': 62,
    'eu': 63,
    'gd': 64,
    'tb': 65,
    'dy': 66,
    'ho': 67,
    'er': 68,
    'tm': 69,
    'yb': 70,
    'lu': 71,
    'hf': 72,
    'ta': 73,
    'w': 74,
    're': 75,
    'os': 76,
    'ir': 77,
    'pt': 78,
    'au': 79,
    'hg': 80,
    'tl': 81,
    'pb': 82,
    'bi': 83,
    'po': 84,
    'at': 85,
    'rn': 86,
    'fr': 87,
    'ra': 88,
    'ac': 89,
    'th': 90,
    'pa': 91,
    'u': 92,
    'np': 93,
    'pu': 94,
    'am': 95,
    'cm': 96,
    'bk': 97,
    'cf': 98,
    'es': 99,
    'fm': 100,
    'md': 101,
    'no': 102,
    'lr': 103,
    'rf': 104,
    'db': 105,
    'sg': 106,
    'bh': 107,
    'hs': 108,
    'mt': 109,
    'ds': 110,
    'rg': 111,
    'cn': 112,
    'nh': 113,
    'fl': 114,
    'mc': 115,
    'lv': 116,
    'ts': 117,
    'og': 118
}

INV_ATOMIC_NUMBERS = {num: elem for elem, num in ATOMIC_NUMBERS.items()}
