"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-iam-role-1');
const role = new lib_1.Role(stack, 'TestRole', {
    assumedBy: new lib_1.ServicePrincipal('sqs.amazonaws.com')
});
role.addToPolicy(new lib_1.PolicyStatement({ resources: ['*'], actions: ['sqs:SendMessage'] }));
const policy = new lib_1.Policy(stack, 'HelloPolicy', { policyName: 'Default' });
policy.addStatements(new lib_1.PolicyStatement({ actions: ['ec2:*'], resources: ['*'] }));
policy.attachToRole(role);
// Role with an external ID
new lib_1.Role(stack, 'TestRole2', {
    assumedBy: new lib_1.AccountRootPrincipal(),
    externalIds: ['supply-me'],
});
// Role with an org
new lib_1.Role(stack, 'TestRole3', {
    assumedBy: new lib_1.OrganizationPrincipal('o-1234'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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