"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
test('use of cross-stack role reference does not lead to URLSuffix being exported', () => {
    // GIVEN
    const app = new core_1.App();
    const first = new core_1.Stack(app, 'First');
    const second = new core_1.Stack(app, 'Second');
    // WHEN
    const role = new iam.Role(first, 'Role', {
        assumedBy: new iam.ServicePrincipal('s3.amazonaws.com')
    });
    new core_1.CfnOutput(second, 'Output', {
        value: role.roleArn
    });
    // THEN
    app.synth();
    expect(first).toMatchTemplate({
        Resources: {
            Role1ABCC5F0: {
                Type: 'AWS::IAM::Role',
                Properties: {
                    AssumeRolePolicyDocument: {
                        Statement: [
                            {
                                Action: 'sts:AssumeRole',
                                Effect: 'Allow',
                                Principal: { Service: 's3.amazonaws.com' }
                            }
                        ],
                        Version: '2012-10-17'
                    }
                }
            }
        },
        Outputs: {
            ExportsOutputFnGetAttRole1ABCC5F0ArnB4C0B73E: {
                Value: { 'Fn::GetAtt': ['Role1ABCC5F0', 'Arn'] },
                Export: {
                    Name: 'First:ExportsOutputFnGetAttRole1ABCC5F0ArnB4C0B73E'
                }
            }
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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