/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ow2.proactive.scheduler.common.task.UpdatableProperties;

public class LogFormatter {
    private LogFormatter() {
    }

    public static String line(String name, Map<?, ?> content) {
        if (content.isEmpty()) {
            return name + " = {}";
        }
        return name + " = {" + System.lineSeparator() + content.entrySet().stream().map(pair -> pair.getKey() + " = " + pair.getValue()).map(s -> "\t" + s).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "}";
    }

    public static String addIndent(String content) {
        return LogFormatter.addIndent(content, 1);
    }

    public static String addIndent(String content, int numberOfIndents) {
        if (numberOfIndents <= 0) {
            return content;
        }
        String lineIndent = IntStream.range(0, numberOfIndents).mapToObj(i -> "\t").reduce("", String::concat);
        return Arrays.stream(content.split(System.lineSeparator())).map(s -> lineIndent + s).collect(Collectors.joining(System.lineSeparator()));
    }

    public static String lineWithQuotes(String name, Object value) {
        if (value != null) {
            return String.format("%s = '%s'", name, value);
        }
        return String.format("%s = null", name);
    }

    public static String line(String name, Object value) {
        if (value instanceof UpdatableProperties) {
            UpdatableProperties prop = (UpdatableProperties)value;
            return LogFormatter.displayKeyValueIfSet(name, prop, prop::getValue);
        }
        return LogFormatter.displayKeyValue(name, value);
    }

    private static String displayKeyValue(String name, Object value) {
        return String.format("%s = %s", name, value);
    }

    private static String displayKeyValueIfSet(String name, UpdatableProperties prop, Supplier<?> supplier) {
        if (prop.isSet()) {
            return String.format("%s = '%s'", name, supplier.get());
        }
        return "";
    }

    public static String line(String name, Object value, Supplier<?> supplier) {
        if (value != null) {
            return String.format("%s = %s", name, supplier.get());
        }
        return String.format("%s = null", name);
    }
}

