/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.task.TaskId;

public class TaskLoggerRelativePathGenerator {
    private static final String LOG_FILE_PREFIX = "TaskLogs";
    private final String relativePath;
    private final String fileName;

    public TaskLoggerRelativePathGenerator(TaskId taskId) {
        this.fileName = "TaskLogs-" + taskId.getJobId() + "-" + taskId.value() + ".log";
        this.relativePath = taskId.getJobId().toString() + "/" + this.fileName;
    }

    public static String getIncludePatternForAllLogFiles(JobId jobId) {
        return jobId.toString() + "/" + LOG_FILE_PREFIX + "-" + jobId.toString() + "-*.log";
    }

    public static String getContainingFolderForLogFiles(JobId jobId) {
        return jobId.toString();
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getFileName() {
        return this.fileName;
    }
}

