/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.objectweb.proactive.utils.ArgCheck;

public final class ThreadPools {
    public static ThreadPoolExecutor newBoundedThreadPool(int maxThreads) {
        return ThreadPools.newBoundedThreadPool(maxThreads, Executors.defaultThreadFactory());
    }

    public static ThreadPoolExecutor newBoundedThreadPool(int maxThreads, ThreadFactory threadFactory) {
        return ThreadPools.newBoundedThreadPool(maxThreads, 60L, TimeUnit.SECONDS, threadFactory);
    }

    public static ThreadPoolExecutor newBoundedThreadPool(int maxThreads, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        ArgCheck.requireStrictlyPostive(maxThreads);
        ArgCheck.requirePostive(keepAliveTime);
        ArgCheck.requireNonNull(unit);
        ArgCheck.requireNonNull(threadFactory);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(maxThreads, maxThreads, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    public static ThreadPoolExecutor newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        ArgCheck.requireNonNull(threadFactory);
        ArgCheck.requireStrictlyPostive(nThreads);
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ThreadPoolExecutor newCachedThreadPool(long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        ArgCheck.requireNonNull(unit);
        ArgCheck.requireNonNull(threadFactory);
        ArgCheck.requirePostive(keepAliveTime);
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newCachedBoundedThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        ArgCheck.requirePostive(corePoolSize);
        ArgCheck.requireStrictlyPostive(maximumPoolSize);
        ArgCheck.requireNonNull(timeUnit);
        ArgCheck.requireNonNull(threadFactory);
        ArgCheck.requirePostive(keepAliveTime);
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){

            @Override
            public boolean offer(Runnable e) {
                return this.tryTransfer(e);
            }
        };
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, (BlockingQueue<Runnable>)queue, threadFactory);
        threadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        return threadPool;
    }
}

