/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ow2.proactive.scheduler.common.job.CompletedJobsCount;
import org.ow2.proactive.scheduler.common.job.CompletedTasksCount;
import org.ow2.proactive.scheduler.common.job.FilteredStatistics;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflow;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflowsCumulatedCoreTime;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflowsNumberOfNodes;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobLabelInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.job.JobStatus;
import org.ow2.proactive.scheduler.common.job.UserIdentification;
import org.ow2.proactive.scheduler.common.job.WorkflowDuration;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskInfo;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.usage.JobUsage;
import org.ow2.proactive.scheduler.common.usage.TaskUsage;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.scheduler.job.JobIdImpl;
import org.ow2.proactive.scheduler.job.SchedulerUserInfo;
import org.ow2.proactive.scheduler.rest.data.JobInfoImpl;
import org.ow2.proactive.scheduler.rest.data.JobResultImpl;
import org.ow2.proactive.scheduler.rest.data.JobStateImpl;
import org.ow2.proactive.scheduler.rest.data.TaskInfoImpl;
import org.ow2.proactive.scheduler.rest.data.TaskLogsImpl;
import org.ow2.proactive.scheduler.rest.data.TaskResultImpl;
import org.ow2.proactive.scheduler.rest.data.TaskStateImpl;
import org.ow2.proactive.scheduler.rest.data.UserIdentificationImpl;
import org.ow2.proactive.scheduler.task.TaskIdImpl;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.CompletedJobsCountData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.CompletedTasksCountData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredStatisticsData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredTopWorkflowData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredTopWorkflowsCumulatedCoreTimeData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredTopWorkflowsNumberOfNodesData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobLabelInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobPriorityData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStatusData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobUsageData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskUsageData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.UserJobData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.WorkflowDurationData;

public class DataUtility {
    private DataUtility() {
    }

    public static JobId jobId(JobIdData jobIdData) {
        return new JobIdImpl(jobIdData.getId(), jobIdData.getReadableName());
    }

    public static JobPriority jobPriority(JobPriorityData d) {
        return JobPriority.valueOf((String)d.name());
    }

    public static JobStatus jobStatus(JobStatusData d) {
        return JobStatus.valueOf((String)d.name());
    }

    public static JobInfo toJobInfo(JobInfoData d) {
        JobInfoImpl impl = new JobInfoImpl();
        impl.setJobId(DataUtility.jobId(d.getJobId()));
        impl.setParentId(d.getParentId());
        impl.setChildrenCount(d.getChildrenCount());
        impl.setFinishedTime(d.getFinishedTime());
        impl.setJobOwner(d.getJobOwner());
        impl.setTenant(d.getTenant());
        impl.setDomain(d.getDomain());
        impl.setBucketName(d.getBucketName());
        impl.setDescription(d.getDescription());
        impl.setNumberOfFinishedTasks(d.getNumberOfFinishedTasks());
        impl.setNumberOfPendingTasks(d.getNumberOfPendingTasks());
        impl.setNumberOfRunningTasks(d.getNumberOfRunningTasks());
        impl.setNumberOfFailedTasks(d.getNumberOfFailedTasks());
        impl.setNumberOfFaultyTasks(d.getNumberOfFaultyTasks());
        impl.setNumberOfInErrorTasks(d.getNumberOfInErrorTasks());
        impl.setJobPriority(DataUtility.jobPriority(d.getPriority()));
        impl.setRemovedTime(d.getRemovedTime());
        impl.setStartTime(d.getStartTime());
        impl.setInErrorTime(d.getInErrorTime());
        impl.setJobStatus(DataUtility.jobStatus(d.getStatus()));
        impl.setSubmittedTime(d.getSubmittedTime());
        impl.setTotalNumberOfTasks(d.getTotalNumberOfTasks());
        impl.setGenericInformation(d.getGenericInformation());
        impl.setVariables(d.getVariables());
        impl.setDetailedVariables(d.getDetailedVariables());
        impl.setSignals(d.getSignals());
        impl.setDetailedSignals(d.getDetailedSignals());
        impl.setVisualizationConnectionStrings(d.getVisualizationConnectionStrings());
        impl.setVisualizationIcons(d.getVisualizationIcons());
        impl.setAttachedServices(d.getAttachedServices());
        impl.setExternalEndpointUrls(d.getExternalEndpointUrls());
        impl.setResultMapPresent(d.isResultMapPresent());
        impl.setPreciousTasks(d.getPreciousTasks());
        impl.setCumulatedCoreTime(d.getCumulatedCoreTime());
        impl.setNumberOfNodes(d.getNumberOfNodes());
        impl.setSubmissionMode(d.getSubmissionMode());
        impl.setLabel(d.getLabel());
        impl.setStartAt(d.getStartAt());
        return impl;
    }

    public static CompletedJobsCount toCompletedJobsCount(CompletedJobsCountData completedJobsCountData) {
        return new CompletedJobsCount(completedJobsCountData.getJobsWithIssues(), completedJobsCountData.getJobsWithoutIssues());
    }

    public static CompletedTasksCount toCompletedTasksCount(CompletedTasksCountData completedTasksCountData) {
        return new CompletedTasksCount(completedTasksCountData.getTasksWithIssues(), completedTasksCountData.getTasksWithoutIssues());
    }

    public static TaskInfo taskInfo(TaskInfoData d) {
        TaskInfoImpl impl = new TaskInfoImpl();
        JobIdData jobIdData = d.getJobId();
        if (jobIdData != null) {
            JobId jobId = DataUtility.jobId(jobIdData);
            impl.setJobId(jobId);
            TaskId taskId = DataUtility.taskId(jobId, d.getTaskId());
            impl.setTaskId(taskId);
        }
        impl.setExecutionDuration(d.getExecutionDuration());
        impl.setExecutionHostName(d.getExecutionHostName());
        impl.setInErrorTime(d.getInErrorTime());
        impl.setFinishedTime(d.getFinishedTime());
        impl.setNumberOfExecutionLeft(d.getNumberOfExecutionLeft());
        impl.setNumberOfExecutionOnFailureLeft(d.getNumberOfExecutionOnFailureLeft());
        impl.setStartTime(d.getStartTime());
        impl.setStatus(TaskStatus.valueOf((String)d.getTaskStatus().name()));
        impl.setName(d.getTaskId().getReadableName());
        impl.setProgress(d.getProgress());
        impl.setVisualizationActivated(d.isVisualizationActivated());
        impl.setVisualizationConnectionString(d.getVisualizationConnectionString());
        impl.setVariables(d.getVariables());
        return impl;
    }

    public static TaskState taskState(TaskStateData d) {
        return new TaskStateImpl(d);
    }

    public static TaskResult toTaskResult(JobId jobId, TaskResultData d) {
        return new TaskResultImpl(DataUtility.taskId(jobId, d.getId()), d);
    }

    public static TaskLogsImpl toTaskLogs(String all, String out, String err) {
        return new TaskLogsImpl(out, err, all);
    }

    public static JobState toJobState(JobStateData d) {
        return new JobStateImpl(d);
    }

    public static JobResult toJobResult(JobResultData d) throws IOException, ClassNotFoundException {
        return new JobResultImpl(d);
    }

    public static List<JobUsage> toJobUsages(List<JobUsageData> dataList) {
        ArrayList<JobUsage> jobUsages = new ArrayList<JobUsage>(dataList.size());
        for (JobUsageData d : dataList) {
            jobUsages.add(DataUtility.jobUsage(d));
        }
        return jobUsages;
    }

    public static JobUsage jobUsage(JobUsageData d) {
        JobUsage impl = new JobUsage(d.getOwner(), d.getTenant(), d.getProject(), d.getJobId(), d.getJobName(), d.getJobDuration(), d.getStatus(), d.getSubmittedTime(), d.getParentId());
        List taskUsageDataList = d.getTaskUsages();
        for (TaskUsageData taskUsageData : taskUsageDataList) {
            impl.add(DataUtility.taskUsage(taskUsageData));
        }
        return impl;
    }

    public static TaskUsage taskUsage(TaskUsageData d) {
        return new TaskUsage(d.getTaskId(), d.getTaskStatus(), d.getTaskName(), d.getTaskTag(), d.getTaskStartTime(), d.getTaskFinishedTime(), d.getTaskExecutionDuration(), d.getTaskNodeNumber(), d.getTaskDescription() == null ? null : d.getTaskDescription().trim(), d.getExecutionHostName(), d.getNumberOfExecutionLeft(), d.getNumberOfExecutionOnFailureLeft(), d.getMaxNumberOfExecution(), PASchedulerProperties.NUMBER_OF_EXECUTION_ON_FAILURE.getValueAsInt());
    }

    public static List<JobInfo> toJobInfos(List<UserJobData> dataList) {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>(dataList.size());
        for (UserJobData ujd : dataList) {
            jobInfos.add(DataUtility.toJobInfo(ujd.getJobInfo()));
        }
        return jobInfos;
    }

    public static List<FilteredTopWorkflow> toFilteredTopWorkflowsWithIssues(List<FilteredTopWorkflowData> filteredTopWorkflowsData) {
        return filteredTopWorkflowsData.stream().map(filteredTopWorkflow -> new FilteredTopWorkflow(filteredTopWorkflow.getWorkflowName(), filteredTopWorkflow.getProjectName(), filteredTopWorkflow.getNumberOfIssues(), filteredTopWorkflow.getNumberOfExecutions())).collect(Collectors.toList());
    }

    public static List<FilteredTopWorkflowsCumulatedCoreTime> toFilteredTopCumulatedCoreTime(List<FilteredTopWorkflowsCumulatedCoreTimeData> filteredTopWorkflowsData) {
        return filteredTopWorkflowsData.stream().map(filteredTopWorkflow -> new FilteredTopWorkflowsCumulatedCoreTime(filteredTopWorkflow.getWorkflowName(), filteredTopWorkflow.getProjectName(), filteredTopWorkflow.getCumulatedCoreTime(), filteredTopWorkflow.getNumberOfExecutions())).collect(Collectors.toList());
    }

    public static List<FilteredTopWorkflowsNumberOfNodes> tFilteredTopWorkflowsNumberOfNodes(List<FilteredTopWorkflowsNumberOfNodesData> filteredTopWorkflowsData) {
        return filteredTopWorkflowsData.stream().map(filteredTopWorkflow -> new FilteredTopWorkflowsNumberOfNodes(filteredTopWorkflow.getWorkflowName(), filteredTopWorkflow.getProjectName(), filteredTopWorkflow.getNumberOfNodes(), filteredTopWorkflow.getNumberOfExecutions())).collect(Collectors.toList());
    }

    public static List<WorkflowDuration> toWorkflowsDuration(List<WorkflowDurationData> filteredTopWorkflowsData) {
        return filteredTopWorkflowsData.stream().map(filteredTopWorkflow -> new WorkflowDuration(filteredTopWorkflow.getWorkflowName(), filteredTopWorkflow.getProjectName(), filteredTopWorkflow.getDuration(), filteredTopWorkflow.getNumberOfExecutions())).collect(Collectors.toList());
    }

    public static List<SchedulerUserInfo> toSchedulerUserInfos(List<SchedulerUserData> dataList) {
        ArrayList<SchedulerUserInfo> schedulerUserInfos = new ArrayList<SchedulerUserInfo>(dataList.size());
        for (SchedulerUserData sud : dataList) {
            schedulerUserInfos.add(new SchedulerUserInfo(sud.getHostName(), sud.getUsername(), sud.getGroups(), sud.getTenant(), sud.getConnectionTime(), sud.getLastSubmitTime(), sud.getSubmitNumber()));
        }
        return schedulerUserInfos;
    }

    public static FilteredStatistics toFilteredStatistics(FilteredStatisticsData jobsReportData) {
        return new FilteredStatistics(jobsReportData.getCurrentJobs(), jobsReportData.getRunningJobs(), jobsReportData.getPausedJobs(), jobsReportData.getStalledJobs(), jobsReportData.getPendingJobs(), jobsReportData.getCurrentJobsWithoutIssues(), jobsReportData.getRunningJobsWithoutIssues(), jobsReportData.getPausedJobsWithoutIssues(), jobsReportData.getStalledJobsWithoutIssues(), jobsReportData.getCurrentJobsWithIssues(), jobsReportData.getInErrorJobs(), jobsReportData.getRunningJobsWithIssues(), jobsReportData.getPausedJobsWithIssues(), jobsReportData.getStalledJobsWithIssues(), jobsReportData.getPastJobsWithIssues(), jobsReportData.getCanceledJobs(), jobsReportData.getKilledJobs(), jobsReportData.getFailedJobs(), jobsReportData.getFinishedJobsWithIssues(), jobsReportData.getSuccessfulJobs(), jobsReportData.getTotalJobs(), jobsReportData.getSuccessfulRate());
    }

    public static UserIdentification userIdentification(SchedulerUserData d) {
        return new UserIdentificationImpl(d.getUsername(), d.getGroups(), d.getTenant(), d.getDomain(), d.getSubmitNumber(), d.getHostName(), d.getConnectionTime(), d.getLastSubmitTime(), d.isMyEventsOnly());
    }

    public static TaskId taskId(JobId jobId, TaskIdData taskIdData) {
        return TaskIdImpl.createTaskId((JobId)jobId, (String)taskIdData.getReadableName(), (long)taskIdData.getId());
    }

    public static JobLabelInfo toJobLabelInfo(JobLabelInfoData jobLabel) {
        return new JobLabelInfo(jobLabel.getId(), jobLabel.getLabel());
    }

    public static List<JobLabelInfo> toJobLabelsInfo(List<JobLabelInfoData> jobLabel) {
        ArrayList<JobLabelInfo> jobLabelInfo = new ArrayList<JobLabelInfo>(jobLabel.size());
        jobLabel.forEach(jobLabelInfoData -> jobLabelInfo.add(DataUtility.toJobLabelInfo(jobLabelInfoData)));
        return jobLabelInfo;
    }
}

