/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.common.event;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.resourcemanager.common.event.RMEvent;
import org.ow2.proactive.resourcemanager.common.event.RMEventType;
import org.ow2.proactive.resourcemanager.common.event.RMNodeEvent;
import org.ow2.proactive.resourcemanager.common.event.RMNodeSourceEvent;
import org.ow2.proactive.resourcemanager.common.event.SortedUniqueSet;
import org.ow2.proactive.resourcemanager.common.event.dto.RMStateDelta;
import org.ow2.proactive.resourcemanager.common.event.dto.RMStateFull;
import org.ow2.proactive.resourcemanager.core.properties.PAResourceManagerProperties;

@PublicAPI
@XmlRootElement
public class RMInitialState
implements Serializable {
    public static final Long EMPTY_STATE = -1L;
    private static final Logger LOGGER = Logger.getLogger(RMInitialState.class);
    private SortedUniqueSet<RMEvent> events = new SortedUniqueSet();
    private AtomicLong latestCounter = new AtomicLong(0L);

    public void addAll(Collection<? extends RMEvent> toAdd) {
        toAdd.forEach(rmEvent -> this.events.add((RMEvent)rmEvent));
        this.latestCounter.set(Math.max(this.latestCounter.get(), this.findLargestCounter(this.events.getSortedItems())));
    }

    public List<RMNodeEvent> getNodeEvents() {
        return this.getNodeEvents(this.events.getSortedItems());
    }

    public List<RMNodeSourceEvent> getNodeSourceEvents() {
        return this.getNodeSourceEvents(this.events.getSortedItems());
    }

    private List<RMNodeEvent> getNodeEvents(Collection<RMEvent> rmEvents) {
        return rmEvents.stream().filter(event -> event instanceof RMNodeEvent).map(event -> (RMNodeEvent)event).collect(Collectors.toList());
    }

    private List<RMNodeSourceEvent> getNodeSourceEvents(Collection<RMEvent> rmevents) {
        return rmevents.stream().filter(event -> event instanceof RMNodeSourceEvent).map(event -> (RMNodeSourceEvent)event).collect(Collectors.toList());
    }

    public long getLatestCounter() {
        return this.latestCounter.get();
    }

    public void nodeAdded(RMNodeEvent event) {
        this.update(event);
    }

    public void nodeStateChanged(RMNodeEvent event) {
        this.update(event);
    }

    public void nodeRemoved(RMNodeEvent event) {
        this.update(event);
    }

    public void nodeSourceAdded(RMNodeSourceEvent event) {
        this.update(event);
    }

    public void nodeSourceRemoved(RMNodeSourceEvent event) {
        this.update(event);
    }

    public void nodeSourceStateChanged(RMNodeSourceEvent event) {
        this.update(event);
    }

    protected void update(RMEvent event) {
        Optional<RMEvent> existingEvent = this.events.get(event.getKey());
        existingEvent.ifPresent(event::updateFirstCounter);
        this.events.add(event);
        this.updateCounter(event);
    }

    public RMStateDelta cloneAndFilter(long counterKnownByClient) {
        long effectiveFilter = this.computeActualFilter(counterKnownByClient);
        List<RMEvent> responseEvents = this.events.getSortedItems().tailSet(new RMEvent(effectiveFilter + 1L)).stream().filter(event -> this.isRemovedButRelevantToClient(effectiveFilter, (RMEvent)event) || this.isNotRemoved((RMEvent)event)).limit(PAResourceManagerProperties.RM_REST_MONITORING_MAXIMUM_CHUNK_SIZE.getValueAsInt()).collect(Collectors.toList());
        RMStateDelta response = new RMStateDelta();
        response.setNodeSource(this.getNodeSourceEvents(responseEvents));
        response.setNodesEvents(this.getNodeEvents(responseEvents));
        response.setLatestCounter(Math.max(effectiveFilter, this.findLargestCounter(responseEvents)));
        return response;
    }

    private boolean isNotRemoved(RMEvent event) {
        return event.getEventType() != RMEventType.NODE_REMOVED && event.getEventType() != RMEventType.NODESOURCE_REMOVED;
    }

    private boolean isRemovedButRelevantToClient(long counterKnownByClient, RMEvent event) {
        return (event.getEventType() == RMEventType.NODE_REMOVED || event.getEventType() == RMEventType.NODESOURCE_REMOVED) && event.getFirstCounter() <= counterKnownByClient;
    }

    private long computeActualFilter(long clientFilter) {
        if (clientFilter <= this.latestCounter.get()) {
            return clientFilter;
        }
        LOGGER.info((Object)String.format("Client is aware of %d but server knows only about %d counter. Probably because there was network server restart.", clientFilter, this.latestCounter.get()));
        return EMPTY_STATE;
    }

    private void updateCounter(RMEvent event) {
        this.latestCounter.set(Math.max(this.latestCounter.get(), event.getCounter()));
    }

    private <T extends RMEvent> long findLargestCounter(Collection<T> events) {
        Optional<RMEvent> max = events.stream().max(Comparator.comparing(RMEvent::getCounter));
        return max.map(RMEvent::getCounter).orElse(EMPTY_STATE);
    }

    public RMStateFull cloneAndFilterNotRemovedOnly() {
        List<RMEvent> responseEvents = this.events.getSortedItems().stream().filter(event -> event.getEventType() != RMEventType.NODE_REMOVED && event.getEventType() != RMEventType.NODESOURCE_REMOVED).collect(Collectors.toList());
        RMStateFull response = new RMStateFull();
        response.setNodeSource(this.getNodeSourceEvents(responseEvents));
        response.setNodesEvents(this.getNodeEvents(responseEvents));
        return response;
    }
}

