"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageManager = void 0;
const os = require("os");
const path = require("path");
/**
 * A node package manager
 */
class PackageManager {
    constructor(props) {
        this.lockFile = props.lockFile;
        this.installCommand = props.installCommand;
        this.runCommand = props.runCommand;
    }
    static fromLockFile(lockFilePath) {
        const lockFile = path.basename(lockFilePath);
        switch (lockFile) {
            case PackageManager.NPM.lockFile:
                return PackageManager.NPM;
            case PackageManager.YARN.lockFile:
                return PackageManager.YARN;
            case PackageManager.PNPM.lockFile:
                return PackageManager.PNPM;
            default:
                return PackageManager.NPM;
        }
    }
    runBinCommand(bin) {
        const [runCommand, ...runArgs] = this.runCommand;
        return [
            os.platform() === 'win32' ? `${runCommand}.cmd` : runCommand,
            ...runArgs,
            bin,
        ].join(' ');
    }
}
exports.PackageManager = PackageManager;
PackageManager.NPM = new PackageManager({
    lockFile: 'package-lock.json',
    installCommand: ['npm', 'install'],
    runCommand: ['npx', '--no-install'],
});
PackageManager.YARN = new PackageManager({
    lockFile: 'yarn.lock',
    installCommand: ['yarn', 'install'],
    runCommand: ['yarn', 'run'],
});
PackageManager.PNPM = new PackageManager({
    lockFile: 'pnpm-lock.yaml',
    installCommand: ['pnpm', 'install'],
    runCommand: ['pnpm', 'run'],
});
//# sourceMappingURL=data:application/json;base64,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