# generated by datamodel-codegen:
#   filename:  schema/entity/feed/thread.json
#   timestamp: 2022-06-23T06:27:50+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic


class Post(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies the post.'
    )
    message: str = Field(
        ...,
        description='Message in markdown format. See markdown support for more details.',
    )
    postTs: Optional[basic.Timestamp] = Field(
        None, description='Timestamp of the post in Unix epoch time milliseconds.'
    )
    from_: str = Field(
        ..., alias='from', description='Name of the User posting the message.'
    )


class Thread(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies an entity instance.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    threadTs: Optional[basic.Timestamp] = Field(
        None,
        description='Timestamp of the when the first post created the thread in Unix epoch time milliseconds.',
    )
    about: basic.EntityLink = Field(
        ...,
        description='Data asset about which this thread is created for with format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
    )
    entityId: Optional[basic.Uuid] = Field(
        None, description='Entity Id of the entity that the thread belongs to.'
    )
    addressedTo: Optional[basic.EntityLink] = Field(
        None,
        description='User or team this thread is addressed to in format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
    )
    createdBy: Optional[str] = Field(None, description='User who created the thread.')
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    resolved: Optional[bool] = Field(
        False, description='When `true` indicates the thread has been resolved.'
    )
    message: str = Field(
        ..., description='The main message of the thread in markdown format.'
    )
    postsCount: Optional[int] = Field(
        0, description='The total count of posts in the thread.'
    )
    posts: Optional[List[Post]] = None
