# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/supersetConnection.json
#   timestamp: 2022-06-23T06:27:50+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class SupersetType(Enum):
    Superset = 'Superset'


class SupersetConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SupersetType] = Field(
        SupersetType.Superset, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ..., description='URL for the superset instance.', title='Host and Port'
    )
    username: str = Field(..., description='Username for Superset.', title='Username')
    password: Optional[SecretStr] = Field(
        None, description='Password for Superset.', title='Password'
    )
    provider: Optional[str] = Field(
        'db',
        description='Authentication provider for the Superset service.',
        title='Provider',
    )
    dbServiceName: Optional[str] = Field(
        None,
        description='Database Service Name to create lineage',
        title='Database Service Name',
    )
    connectionOptions: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional connection options that can be sent to service during the connection.',
        title='Connection Options',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
