# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/mariaDBConnection.json
#   timestamp: 2022-06-23T06:27:50+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class MariaDBType(Enum):
    MariaDB = 'MariaDB'


class MariaDBScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class MariaDBConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MariaDBType] = Field(
        MariaDBType.MariaDB, description='Service Type', title='Service Type'
    )
    scheme: Optional[MariaDBScheme] = Field(
        MariaDBScheme.mysql_pymysql,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to MariaDB. This user should have privileges to read all the metadata in MariaDB.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to MariaDB.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the MariaDB service.', title='Host and Port'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
