# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictStr, conint

from typing import Optional

from circle.web3.developer_controlled_wallets.models.accelerate_transaction_for_developer import AccelerateTransactionForDeveloper
from circle.web3.developer_controlled_wallets.models.accelerate_transaction_for_developer_request import AccelerateTransactionForDeveloperRequest
from circle.web3.developer_controlled_wallets.models.blockchain import Blockchain
from circle.web3.developer_controlled_wallets.models.cancel_transaction_for_developer import CancelTransactionForDeveloper
from circle.web3.developer_controlled_wallets.models.cancel_transaction_for_developer_request import CancelTransactionForDeveloperRequest
from circle.web3.developer_controlled_wallets.models.create_contract_execution_transaction_for_developer import CreateContractExecutionTransactionForDeveloper
from circle.web3.developer_controlled_wallets.models.create_contract_execution_transaction_for_developer_request import CreateContractExecutionTransactionForDeveloperRequest
from circle.web3.developer_controlled_wallets.models.create_transfer_transaction_for_developer_request import CreateTransferTransactionForDeveloperRequest
from circle.web3.developer_controlled_wallets.models.create_transfer_transaction_for_developer_response import CreateTransferTransactionForDeveloperResponse
from circle.web3.developer_controlled_wallets.models.create_wallet_upgrade_transaction_for_developer import CreateWalletUpgradeTransactionForDeveloper
from circle.web3.developer_controlled_wallets.models.create_wallet_upgrade_transaction_for_developer_request import CreateWalletUpgradeTransactionForDeveloperRequest
from circle.web3.developer_controlled_wallets.models.custody_type import CustodyType
from circle.web3.developer_controlled_wallets.models.estimate_contract_execution_transaction_fee_request import EstimateContractExecutionTransactionFeeRequest
from circle.web3.developer_controlled_wallets.models.estimate_transaction_fee import EstimateTransactionFee
from circle.web3.developer_controlled_wallets.models.estimate_transfer_transaction_fee_request import EstimateTransferTransactionFeeRequest
from circle.web3.developer_controlled_wallets.models.get_lowest_nonce_transaction_response import GetLowestNonceTransactionResponse
from circle.web3.developer_controlled_wallets.models.transaction_response import TransactionResponse
from circle.web3.developer_controlled_wallets.models.transaction_state import TransactionState
from circle.web3.developer_controlled_wallets.models.transaction_type import TransactionType
from circle.web3.developer_controlled_wallets.models.transactions import Transactions
from circle.web3.developer_controlled_wallets.models.validate_address import ValidateAddress
from circle.web3.developer_controlled_wallets.models.validate_address_request import ValidateAddressRequest

from circle.web3.developer_controlled_wallets.api_client import ApiClient
from circle.web3.developer_controlled_wallets.api_response import ApiResponse
from circle.web3.developer_controlled_wallets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class TransactionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def create_developer_transaction_accelerate(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], accelerate_transaction_for_developer_request : Annotated[AccelerateTransactionForDeveloperRequest, Field(..., description="Accelerate transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> AccelerateTransactionForDeveloper:  # noqa: E501
        """Accelerate a transaction  # noqa: E501

        Accelerates a specified transaction from a developer-controlled wallet. Additional gas fees may be incurred.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_accelerate(id, accelerate_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param accelerate_transaction_for_developer_request: Accelerate transaction for developer request (required)
        :type accelerate_transaction_for_developer_request: AccelerateTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccelerateTransactionForDeveloper
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_developer_transaction_accelerate_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_developer_transaction_accelerate_with_http_info(id, accelerate_transaction_for_developer_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_developer_transaction_accelerate_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], accelerate_transaction_for_developer_request : Annotated[AccelerateTransactionForDeveloperRequest, Field(..., description="Accelerate transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Accelerate a transaction  # noqa: E501

        Accelerates a specified transaction from a developer-controlled wallet. Additional gas fees may be incurred.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_accelerate_with_http_info(id, accelerate_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param accelerate_transaction_for_developer_request: Accelerate transaction for developer request (required)
        :type accelerate_transaction_for_developer_request: AccelerateTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccelerateTransactionForDeveloper, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'accelerate_transaction_for_developer_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_developer_transaction_accelerate" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['accelerate_transaction_for_developer_request'] is not None:
            _body_params = _params['accelerate_transaction_for_developer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccelerateTransactionForDeveloper",
            '400': "Error",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/transactions/{id}/accelerate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_developer_transaction_cancel(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], cancel_transaction_for_developer_request : Annotated[CancelTransactionForDeveloperRequest, Field(..., description="Cancel transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> CancelTransactionForDeveloper:  # noqa: E501
        """Cancel a transaction  # noqa: E501

        Cancels a specified transaction from a developer-controlled wallet. Gas fees may still be incurred.  This is a best-effort operation, it won't be effective if the original transaction has already been processed by the blockchain.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_cancel(id, cancel_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param cancel_transaction_for_developer_request: Cancel transaction for developer request (required)
        :type cancel_transaction_for_developer_request: CancelTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CancelTransactionForDeveloper
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_developer_transaction_cancel_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_developer_transaction_cancel_with_http_info(id, cancel_transaction_for_developer_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_developer_transaction_cancel_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], cancel_transaction_for_developer_request : Annotated[CancelTransactionForDeveloperRequest, Field(..., description="Cancel transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Cancel a transaction  # noqa: E501

        Cancels a specified transaction from a developer-controlled wallet. Gas fees may still be incurred.  This is a best-effort operation, it won't be effective if the original transaction has already been processed by the blockchain.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_cancel_with_http_info(id, cancel_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param cancel_transaction_for_developer_request: Cancel transaction for developer request (required)
        :type cancel_transaction_for_developer_request: CancelTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CancelTransactionForDeveloper, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'cancel_transaction_for_developer_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_developer_transaction_cancel" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['cancel_transaction_for_developer_request'] is not None:
            _body_params = _params['cancel_transaction_for_developer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CancelTransactionForDeveloper",
            '400': "Error",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/transactions/{id}/cancel', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_developer_transaction_contract_execution(self, create_contract_execution_transaction_for_developer_request : Annotated[CreateContractExecutionTransactionForDeveloperRequest, Field(..., description="Create transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> CreateContractExecutionTransactionForDeveloper:  # noqa: E501
        """Create a contract execution transaction  # noqa: E501

        Creates a transaction which executes a smart contract. ABI parameters must be passed in the request. Related transactions may be submitted as a batch transaction in a single call.  You must provide either a `walletId` or a `walletAddress` and `blockchain` pair in the request body.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_contract_execution(create_contract_execution_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_contract_execution_transaction_for_developer_request: Create transaction for developer request (required)
        :type create_contract_execution_transaction_for_developer_request: CreateContractExecutionTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateContractExecutionTransactionForDeveloper
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_developer_transaction_contract_execution_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_developer_transaction_contract_execution_with_http_info(create_contract_execution_transaction_for_developer_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_developer_transaction_contract_execution_with_http_info(self, create_contract_execution_transaction_for_developer_request : Annotated[CreateContractExecutionTransactionForDeveloperRequest, Field(..., description="Create transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create a contract execution transaction  # noqa: E501

        Creates a transaction which executes a smart contract. ABI parameters must be passed in the request. Related transactions may be submitted as a batch transaction in a single call.  You must provide either a `walletId` or a `walletAddress` and `blockchain` pair in the request body.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_contract_execution_with_http_info(create_contract_execution_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_contract_execution_transaction_for_developer_request: Create transaction for developer request (required)
        :type create_contract_execution_transaction_for_developer_request: CreateContractExecutionTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateContractExecutionTransactionForDeveloper, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_contract_execution_transaction_for_developer_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_developer_transaction_contract_execution" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_contract_execution_transaction_for_developer_request'] is not None:
            _body_params = _params['create_contract_execution_transaction_for_developer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CreateContractExecutionTransactionForDeveloper",
            '201': "CreateContractExecutionTransactionForDeveloper",
            '400': "Error",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/transactions/contractExecution', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_developer_transaction_transfer(self, create_transfer_transaction_for_developer_request : Annotated[CreateTransferTransactionForDeveloperRequest, Field(..., description="Create transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> CreateTransferTransactionForDeveloperResponse:  # noqa: E501
        """Create a transfer transaction  # noqa: E501

        Initiates an on-chain digital asset transfer from a specified developer-controlled wallet.  You must provide either a `walletId` or a `walletAddress` and `blockchain` pair in the request body.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_transfer(create_transfer_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_transfer_transaction_for_developer_request: Create transaction for developer request (required)
        :type create_transfer_transaction_for_developer_request: CreateTransferTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateTransferTransactionForDeveloperResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_developer_transaction_transfer_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_developer_transaction_transfer_with_http_info(create_transfer_transaction_for_developer_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_developer_transaction_transfer_with_http_info(self, create_transfer_transaction_for_developer_request : Annotated[CreateTransferTransactionForDeveloperRequest, Field(..., description="Create transaction for developer request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create a transfer transaction  # noqa: E501

        Initiates an on-chain digital asset transfer from a specified developer-controlled wallet.  You must provide either a `walletId` or a `walletAddress` and `blockchain` pair in the request body.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_transfer_with_http_info(create_transfer_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_transfer_transaction_for_developer_request: Create transaction for developer request (required)
        :type create_transfer_transaction_for_developer_request: CreateTransferTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateTransferTransactionForDeveloperResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_transfer_transaction_for_developer_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_developer_transaction_transfer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_transfer_transaction_for_developer_request'] is not None:
            _body_params = _params['create_transfer_transaction_for_developer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CreateTransferTransactionForDeveloperResponse",
            '201': "CreateTransferTransactionForDeveloperResponse",
            '400': "Error",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/transactions/transfer', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_developer_transaction_wallet_upgrade(self, create_wallet_upgrade_transaction_for_developer_request : Annotated[CreateWalletUpgradeTransactionForDeveloperRequest, Field(..., description="Creates a transaction for a developer request.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> CreateWalletUpgradeTransactionForDeveloper:  # noqa: E501
        """Create a wallet upgrade transaction  # noqa: E501

        Creates a transaction which upgrades a wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_wallet_upgrade(create_wallet_upgrade_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_wallet_upgrade_transaction_for_developer_request: Creates a transaction for a developer request. (required)
        :type create_wallet_upgrade_transaction_for_developer_request: CreateWalletUpgradeTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateWalletUpgradeTransactionForDeveloper
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_developer_transaction_wallet_upgrade_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_developer_transaction_wallet_upgrade_with_http_info(create_wallet_upgrade_transaction_for_developer_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_developer_transaction_wallet_upgrade_with_http_info(self, create_wallet_upgrade_transaction_for_developer_request : Annotated[CreateWalletUpgradeTransactionForDeveloperRequest, Field(..., description="Creates a transaction for a developer request.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create a wallet upgrade transaction  # noqa: E501

        Creates a transaction which upgrades a wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_developer_transaction_wallet_upgrade_with_http_info(create_wallet_upgrade_transaction_for_developer_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_wallet_upgrade_transaction_for_developer_request: Creates a transaction for a developer request. (required)
        :type create_wallet_upgrade_transaction_for_developer_request: CreateWalletUpgradeTransactionForDeveloperRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateWalletUpgradeTransactionForDeveloper, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_wallet_upgrade_transaction_for_developer_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_developer_transaction_wallet_upgrade" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_wallet_upgrade_transaction_for_developer_request'] is not None:
            _body_params = _params['create_wallet_upgrade_transaction_for_developer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CreateWalletUpgradeTransactionForDeveloper",
            '201': "CreateWalletUpgradeTransactionForDeveloper",
            '400': "Error",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/transactions/walletUpgrade', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_transaction_estimate_fee(self, estimate_contract_execution_transaction_fee_request : Annotated[EstimateContractExecutionTransactionFeeRequest, Field(..., description="Estimate transaction fee request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> EstimateTransactionFee:  # noqa: E501
        """Estimate fee for a contract execution transaction  # noqa: E501

        Estimates gas fees that will be incurred for a contract execution transaction, given its ABI parameters and blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transaction_estimate_fee(estimate_contract_execution_transaction_fee_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param estimate_contract_execution_transaction_fee_request: Estimate transaction fee request (required)
        :type estimate_contract_execution_transaction_fee_request: EstimateContractExecutionTransactionFeeRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EstimateTransactionFee
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_transaction_estimate_fee_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_transaction_estimate_fee_with_http_info(estimate_contract_execution_transaction_fee_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_transaction_estimate_fee_with_http_info(self, estimate_contract_execution_transaction_fee_request : Annotated[EstimateContractExecutionTransactionFeeRequest, Field(..., description="Estimate transaction fee request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Estimate fee for a contract execution transaction  # noqa: E501

        Estimates gas fees that will be incurred for a contract execution transaction, given its ABI parameters and blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transaction_estimate_fee_with_http_info(estimate_contract_execution_transaction_fee_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param estimate_contract_execution_transaction_fee_request: Estimate transaction fee request (required)
        :type estimate_contract_execution_transaction_fee_request: EstimateContractExecutionTransactionFeeRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EstimateTransactionFee, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'estimate_contract_execution_transaction_fee_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transaction_estimate_fee" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['estimate_contract_execution_transaction_fee_request'] is not None:
            _body_params = _params['estimate_contract_execution_transaction_fee_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EstimateTransactionFee",
            '400': "Error",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/transactions/contractExecution/estimateFee', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_transfer_estimate_fee(self, estimate_transfer_transaction_fee_request : Annotated[EstimateTransferTransactionFeeRequest, Field(..., description="Estimate transaction fee request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> EstimateTransactionFee:  # noqa: E501
        """Estimate fee for a transfer transaction  # noqa: E501

        Estimates gas fees that will be incurred for a transfer transaction; given its amount, blockchain, and token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transfer_estimate_fee(estimate_transfer_transaction_fee_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param estimate_transfer_transaction_fee_request: Estimate transaction fee request (required)
        :type estimate_transfer_transaction_fee_request: EstimateTransferTransactionFeeRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EstimateTransactionFee
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_transfer_estimate_fee_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_transfer_estimate_fee_with_http_info(estimate_transfer_transaction_fee_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_transfer_estimate_fee_with_http_info(self, estimate_transfer_transaction_fee_request : Annotated[EstimateTransferTransactionFeeRequest, Field(..., description="Estimate transaction fee request")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Estimate fee for a transfer transaction  # noqa: E501

        Estimates gas fees that will be incurred for a transfer transaction; given its amount, blockchain, and token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transfer_estimate_fee_with_http_info(estimate_transfer_transaction_fee_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param estimate_transfer_transaction_fee_request: Estimate transaction fee request (required)
        :type estimate_transfer_transaction_fee_request: EstimateTransferTransactionFeeRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EstimateTransactionFee, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'estimate_transfer_transaction_fee_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transfer_estimate_fee" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['estimate_transfer_transaction_fee_request'] is not None:
            _body_params = _params['estimate_transfer_transaction_fee_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EstimateTransactionFee",
            '400': "Error",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/transactions/transfer/estimateFee', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_validate_address(self, validate_address_request : Annotated[ValidateAddressRequest, Field(..., description="Validate address request")], **kwargs) -> ValidateAddress:  # noqa: E501
        """Validate an address  # noqa: E501

        Confirms that a specified address is valid for a given token on a certain blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_validate_address(validate_address_request, async_req=True)
        >>> result = thread.get()

        :param validate_address_request: Validate address request (required)
        :type validate_address_request: ValidateAddressRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValidateAddress
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_validate_address_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_validate_address_with_http_info(validate_address_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_validate_address_with_http_info(self, validate_address_request : Annotated[ValidateAddressRequest, Field(..., description="Validate address request")], **kwargs) -> ApiResponse:  # noqa: E501
        """Validate an address  # noqa: E501

        Confirms that a specified address is valid for a given token on a certain blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_validate_address_with_http_info(validate_address_request, async_req=True)
        >>> result = thread.get()

        :param validate_address_request: Validate address request (required)
        :type validate_address_request: ValidateAddressRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValidateAddress, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'validate_address_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_validate_address" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['validate_address_request'] is not None:
            _body_params = _params['validate_address_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "ValidateAddress",
            '400': "Error",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/transactions/validateAddress', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_lowest_nonce_transaction(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, address : Annotated[Optional[StrictStr], Field(description="Filter by the blockchain address of the wallet.")] = None, wallet_id : Annotated[Optional[StrictStr], Field(description="Filter by the wallet ID")] = None, **kwargs) -> GetLowestNonceTransactionResponse:  # noqa: E501
        """Get the lowest nonce pending transaction for a wallet  # noqa: E501

        For a nonce-supported blockchain, get the lowest nonce transaction that's in QUEUED or SENT or STUCK state for the provided wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lowest_nonce_transaction(blockchain, address, wallet_id, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param address: Filter by the blockchain address of the wallet.
        :type address: str
        :param wallet_id: Filter by the wallet ID
        :type wallet_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetLowestNonceTransactionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_lowest_nonce_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_lowest_nonce_transaction_with_http_info(blockchain, address, wallet_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_lowest_nonce_transaction_with_http_info(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, address : Annotated[Optional[StrictStr], Field(description="Filter by the blockchain address of the wallet.")] = None, wallet_id : Annotated[Optional[StrictStr], Field(description="Filter by the wallet ID")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get the lowest nonce pending transaction for a wallet  # noqa: E501

        For a nonce-supported blockchain, get the lowest nonce transaction that's in QUEUED or SENT or STUCK state for the provided wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lowest_nonce_transaction_with_http_info(blockchain, address, wallet_id, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param address: Filter by the blockchain address of the wallet.
        :type address: str
        :param wallet_id: Filter by the wallet ID
        :type wallet_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetLowestNonceTransactionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blockchain',
            'address',
            'wallet_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lowest_nonce_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('address') is not None:  # noqa: E501
            _query_params.append(('address', _params['address']))

        if _params.get('wallet_id') is not None:  # noqa: E501
            _query_params.append(('walletId', _params['wallet_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GetLowestNonceTransactionResponse",
            '204': None,
            '400': "Error",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/transactions/lowestNonceTransaction', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_transaction(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], tx_type : Annotated[Optional[TransactionType], Field(description="Filter by on the transaction type.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> TransactionResponse:  # noqa: E501
        """Get a transaction  # noqa: E501

        Retrieves info for a single transaction using it's unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction(id, tx_type, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param tx_type: Filter by on the transaction type.
        :type tx_type: TransactionType
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_transaction_with_http_info(id, tx_type, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_transaction_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], tx_type : Annotated[Optional[TransactionType], Field(description="Filter by on the transaction type.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get a transaction  # noqa: E501

        Retrieves info for a single transaction using it's unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_with_http_info(id, tx_type, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param tx_type: Filter by on the transaction type.
        :type tx_type: TransactionType
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'tx_type',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('tx_type') is not None:  # noqa: E501
            _query_params.append(('txType', _params['tx_type'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionResponse",
            '400': "Error",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/transactions/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def list_transactions(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, custody_type : Annotated[Optional[CustodyType], Field(description="Filter by the custody type.")] = None, destination_address : Annotated[Optional[StrictStr], Field(description="Filter by the destination address.")] = None, include_all : Annotated[Optional[StrictBool], Field(description="Return all recourses with monitored and non-monitored tokens.")] = None, operation : Annotated[Optional[StrictStr], Field(description="Filter by the operation of the transaction.")] = None, state : Annotated[Optional[TransactionState], Field(description="Filter by the state of the transaction.")] = None, tx_hash : Annotated[Optional[StrictStr], Field(description="Filter on the transaction hash of the transaction.")] = None, tx_type : Annotated[Optional[TransactionType], Field(description="Filter by on the transaction type.")] = None, wallet_ids : Annotated[Optional[StrictStr], Field(description="Filter by the wallet IDs, this parameter is a comma separated list of ids.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, order : Annotated[Optional[StrictStr], Field(description="Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). ")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> Transactions:  # noqa: E501
        """List transactions  # noqa: E501

        Lists all transactions. Includes details such as status, source/destination, and transaction hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions(blockchain, custody_type, destination_address, include_all, operation, state, tx_hash, tx_type, wallet_ids, var_from, to, page_before, page_after, page_size, order, x_request_id, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param custody_type: Filter by the custody type.
        :type custody_type: CustodyType
        :param destination_address: Filter by the destination address.
        :type destination_address: str
        :param include_all: Return all recourses with monitored and non-monitored tokens.
        :type include_all: bool
        :param operation: Filter by the operation of the transaction.
        :type operation: str
        :param state: Filter by the state of the transaction.
        :type state: TransactionState
        :param tx_hash: Filter on the transaction hash of the transaction.
        :type tx_hash: str
        :param tx_type: Filter by on the transaction type.
        :type tx_type: TransactionType
        :param wallet_ids: Filter by the wallet IDs, this parameter is a comma separated list of ids.
        :type wallet_ids: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param order: Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). 
        :type order: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Transactions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_transactions_with_http_info(blockchain, custody_type, destination_address, include_all, operation, state, tx_hash, tx_type, wallet_ids, var_from, to, page_before, page_after, page_size, order, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def list_transactions_with_http_info(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, custody_type : Annotated[Optional[CustodyType], Field(description="Filter by the custody type.")] = None, destination_address : Annotated[Optional[StrictStr], Field(description="Filter by the destination address.")] = None, include_all : Annotated[Optional[StrictBool], Field(description="Return all recourses with monitored and non-monitored tokens.")] = None, operation : Annotated[Optional[StrictStr], Field(description="Filter by the operation of the transaction.")] = None, state : Annotated[Optional[TransactionState], Field(description="Filter by the state of the transaction.")] = None, tx_hash : Annotated[Optional[StrictStr], Field(description="Filter on the transaction hash of the transaction.")] = None, tx_type : Annotated[Optional[TransactionType], Field(description="Filter by on the transaction type.")] = None, wallet_ids : Annotated[Optional[StrictStr], Field(description="Filter by the wallet IDs, this parameter is a comma separated list of ids.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, order : Annotated[Optional[StrictStr], Field(description="Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). ")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List transactions  # noqa: E501

        Lists all transactions. Includes details such as status, source/destination, and transaction hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_with_http_info(blockchain, custody_type, destination_address, include_all, operation, state, tx_hash, tx_type, wallet_ids, var_from, to, page_before, page_after, page_size, order, x_request_id, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param custody_type: Filter by the custody type.
        :type custody_type: CustodyType
        :param destination_address: Filter by the destination address.
        :type destination_address: str
        :param include_all: Return all recourses with monitored and non-monitored tokens.
        :type include_all: bool
        :param operation: Filter by the operation of the transaction.
        :type operation: str
        :param state: Filter by the state of the transaction.
        :type state: TransactionState
        :param tx_hash: Filter on the transaction hash of the transaction.
        :type tx_hash: str
        :param tx_type: Filter by on the transaction type.
        :type tx_type: TransactionType
        :param wallet_ids: Filter by the wallet IDs, this parameter is a comma separated list of ids.
        :type wallet_ids: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param order: Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). 
        :type order: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Transactions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blockchain',
            'custody_type',
            'destination_address',
            'include_all',
            'operation',
            'state',
            'tx_hash',
            'tx_type',
            'wallet_ids',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size',
            'order',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('custody_type') is not None:  # noqa: E501
            _query_params.append(('custodyType', _params['custody_type'].value))

        if _params.get('destination_address') is not None:  # noqa: E501
            _query_params.append(('destinationAddress', _params['destination_address']))

        if _params.get('include_all') is not None:  # noqa: E501
            _query_params.append(('includeAll', _params['include_all']))

        if _params.get('operation') is not None:  # noqa: E501
            _query_params.append(('operation', _params['operation']))

        if _params.get('state') is not None:  # noqa: E501
            _query_params.append(('state', _params['state'].value))

        if _params.get('tx_hash') is not None:  # noqa: E501
            _query_params.append(('txHash', _params['tx_hash']))

        if _params.get('tx_type') is not None:  # noqa: E501
            _query_params.append(('txType', _params['tx_type'].value))

        if _params.get('wallet_ids') is not None:  # noqa: E501
            _query_params.append(('walletIds', _params['wallet_ids']))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        if _params.get('order') is not None:  # noqa: E501
            _query_params.append(('order', _params['order']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Transactions",
            '400': "Error",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
