# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBytes, StrictStr, conlist
from circle.web3.developer_controlled_wallets.models.create_transfer_transaction_for_developer_request_blockchain import CreateTransferTransactionForDeveloperRequestBlockchain
from circle.web3.developer_controlled_wallets.models.fee_level import FeeLevel

class CreateTransferTransactionForDeveloperRequest(BaseModel):
    """
    CreateTransferTransactionForDeveloperRequest
    """
    idempotency_key: StrictStr = Field(..., alias="idempotencyKey", description="Universally unique identifier (UUID v4) idempotency key. This key is utilized to ensure exactly-once execution of mutating requests. To create a UUIDv4 go to [uuidgenerator.net](https://www.uuidgenerator.net). If the same key is reused, it will be treated as the same request and the original response will be returned.")
    amounts: Optional[conlist(StrictStr, min_items=1)] = Field(None, description="Transfer amounts in decimal number format, at least one element is required for transfer. For ERC721 token transfer, the amounts field is required to be [\"1\"] (array with \"1\" as the only element).")
    destination_address: StrictStr = Field(..., alias="destinationAddress", description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    entity_secret_ciphertext: Union[StrictBytes, StrictStr] = Field(..., alias="entitySecretCiphertext", description="A base64 string expression of the entity secret ciphertext. The entity secret should be encrypted by the entity public key. Circle mandates that the entity secret ciphertext is unique for each API request. ")
    fee_level: Optional[FeeLevel] = Field(None, alias="feeLevel")
    gas_limit: Optional[StrictStr] = Field(None, alias="gasLimit", description="The maximum units of gas to use for the transaction. Required if `feeLevel` is not provided. Estimates for this limit can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. GasLimit override (only supported for EOA wallets): Using `gasLimit` together with `feeLevel`, the provided `gasLimit` is required to be greater or equal to `feeLevel` estimation and will override the estimation's gasLimit. ")
    gas_price: Optional[StrictStr] = Field(None, alias="gasPrice", description="For blockchains without EIP-1559 support, the maximum price of gas, in gwei, to use per each unit of gas (see `gasLimit`). Requires `gasLimit`. Cannot be used with `feeLevel`, `priorityFee`, or `maxFee`. Estimates for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    max_fee: Optional[StrictStr] = Field(None, alias="maxFee", description="For blockchains with EIP-1559 support, the maximum price per unit of gas (see `gasLimit`), in gwei. Requires `priorityFee`, and `gasLimit` to be present. Cannot be used with `feeLevel` or `gasPrice`. Estimates for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    priority_fee: Optional[StrictStr] = Field(None, alias="priorityFee", description="For blockchains with EIP-1559 support, the “tip”, in gwei, to add to the base fee as an incentive for validators. Please note that the `maxFee` and `gasLimit` parameters are required alongside the `priorityFee`. The `feeLevel` and `gasPrice` parameters cannot be used with the `priorityFee`.  Estimations for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    nft_token_ids: Optional[conlist(StrictStr)] = Field(None, alias="nftTokenIds", description="List of NFT token IDs corresponding with the NFTs to transfer. Batch transfers are supported only for ERC-1155 tokens. The length of NFT token IDs must match the length of amounts.")
    ref_id: Optional[StrictStr] = Field(None, alias="refId", description="Optional reference or description used to identify the transaction.")
    token_id: Optional[StrictStr] = Field(None, alias="tokenId", description="System generated identifier of the token. Excluded with `tokenAddress` and `tokenBlockchain`.")
    token_address: Optional[StrictStr] = Field(None, alias="tokenAddress", description="Blockchain address of the transferred token. Empty for native tokens. Excluded with `tokenId`.")
    blockchain: Optional[CreateTransferTransactionForDeveloperRequestBlockchain] = None
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="Unique system generated identifier of the wallet. For contract deploys this wallet ID will be used as the source. ")
    wallet_address: Optional[StrictStr] = Field(None, alias="walletAddress", description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    __properties = ["idempotencyKey", "amounts", "destinationAddress", "entitySecretCiphertext", "feeLevel", "gasLimit", "gasPrice", "maxFee", "priorityFee", "nftTokenIds", "refId", "tokenId", "tokenAddress", "blockchain", "walletId", "walletAddress"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> CreateTransferTransactionForDeveloperRequest:
        """Create an instance of CreateTransferTransactionForDeveloperRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of blockchain
        if self.blockchain:
            _dict['blockchain'] = self.blockchain.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateTransferTransactionForDeveloperRequest:
        """Create an instance of CreateTransferTransactionForDeveloperRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateTransferTransactionForDeveloperRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = CreateTransferTransactionForDeveloperRequest.parse_obj({
            "idempotency_key": obj.get("idempotencyKey"),
                        "amounts": obj.get("amounts"),
                        "destination_address": obj.get("destinationAddress"),
                        "entity_secret_ciphertext": obj.get("entitySecretCiphertext"),
                        "fee_level": obj.get("feeLevel"),
                        "gas_limit": obj.get("gasLimit"),
                        "gas_price": obj.get("gasPrice"),
                        "max_fee": obj.get("maxFee"),
                        "priority_fee": obj.get("priorityFee"),
                        "nft_token_ids": obj.get("nftTokenIds"),
                        "ref_id": obj.get("refId"),
                        "token_id": obj.get("tokenId"),
                        "token_address": obj.get("tokenAddress"),
                        "blockchain": CreateTransferTransactionForDeveloperRequestBlockchain.from_dict(obj.get("blockchain")) if obj.get("blockchain") is not None else None,
                        "wallet_id": obj.get("walletId"),
                        "wallet_address": obj.get("walletAddress")
            
        })
        return _obj


