# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder



from pydantic import BaseModel, Field, StrictInt, StrictStr

class NotAuthorizedResponse(BaseModel):
    """
    NotAuthorizedResponse
    """
    code: StrictInt = Field(..., description="Code that corresponds to the error.")
    message: StrictStr = Field(..., description="Message that describes the error.")
    __properties = ["code", "message"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> NotAuthorizedResponse:
        """Create an instance of NotAuthorizedResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NotAuthorizedResponse:
        """Create an instance of NotAuthorizedResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NotAuthorizedResponse.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = NotAuthorizedResponse.parse_obj({
            "code": obj.get("code"),
                        "message": obj.get("message")
            
        })
        return _obj


