# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist, constr
from circle.web3.developer_controlled_wallets.models.abi_parameters_inner import AbiParametersInner
from circle.web3.developer_controlled_wallets.models.blockchain import Blockchain
from circle.web3.developer_controlled_wallets.models.custody_type import CustodyType
from circle.web3.developer_controlled_wallets.models.fee_level import FeeLevel
from circle.web3.developer_controlled_wallets.models.operation import Operation
from circle.web3.developer_controlled_wallets.models.transaction_fee import TransactionFee
from circle.web3.developer_controlled_wallets.models.transaction_screening_decision import TransactionScreeningDecision
from circle.web3.developer_controlled_wallets.models.transaction_state import TransactionState
from circle.web3.developer_controlled_wallets.models.transaction_type import TransactionType

class Transaction(BaseModel):
    """
    Transaction
    """
    id: StrictStr = Field(..., description="System-generated unique identifier of the resource.")
    abi_function_signature: Optional[StrictStr] = Field(None, alias="abiFunctionSignature", description="The contract ABI function signature or `callData` field is required for interacting with the smart contract. The ABI function signature cannot be used simultaneously with `callData`. e.g. burn(uint256)")
    abi_parameters: Optional[conlist(AbiParametersInner)] = Field(None, alias="abiParameters", description="The contract ABI function signature parameters for executing the contract interaction. Supported parameter types include string, integer, boolean, and array. These parameters should be used exclusively with the abiFunctionSignature and cannot be used with `callData`.")
    amounts: Optional[conlist(StrictStr)] = Field(None, description="Transfer amounts in decimal number format, at least one element is required for transfer. For ERC721 token transfer, the amounts field is required to be [\"1\"] (array with \"1\" as the only element).")
    amount_in_usd: Optional[StrictStr] = Field(None, alias="amountInUSD", description="Transaction amount in USD decimal format.")
    block_hash: Optional[StrictStr] = Field(None, alias="blockHash", description="Identifier for the block that includes the transaction.")
    block_height: Optional[StrictInt] = Field(None, alias="blockHeight", description="Block height of the transaction, representing the number of blockchain confirmations.")
    blockchain: Blockchain = Field(...)
    contract_address: Optional[StrictStr] = Field(None, alias="contractAddress", description="The blockchain address of the contract to be executed.")
    create_date: datetime = Field(..., alias="createDate", description="Date and time the resource was created, in ISO-8601 UTC format.")
    custody_type: Optional[CustodyType] = Field(None, alias="custodyType")
    destination_address: Optional[StrictStr] = Field(None, alias="destinationAddress", description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    error_reason: Optional[StrictStr] = Field(None, alias="errorReason", description="Description of the error. Only present for transactions in `FAILED` state.")
    error_details: Optional[StrictStr] = Field(None, alias="errorDetails", description="Additional detail associated with the corresponding transaction's error reason")
    estimated_fee: Optional[TransactionFee] = Field(None, alias="estimatedFee")
    fee_level: Optional[FeeLevel] = Field(None, alias="feeLevel")
    first_confirm_date: Optional[datetime] = Field(None, alias="firstConfirmDate", description="Date the transaction was first confirmed in a block. ISO-8601 UTC date/time.")
    network_fee: Optional[StrictStr] = Field(None, alias="networkFee", description="Gas fee, in native token, paid to the network for the transaction.")
    network_fee_in_usd: Optional[StrictStr] = Field(None, alias="networkFeeInUSD", description="Gas fee, in USD, paid to the network for the transaction.")
    nfts: Optional[conlist(StrictStr)] = Field(None, description="List of Nfts, in JSON string format, associated with the transaction.")
    operation: Optional[Operation] = None
    ref_id: Optional[StrictStr] = Field(None, alias="refId", description="Optional reference or description used to identify the transaction.")
    source_address: Optional[StrictStr] = Field(None, alias="sourceAddress", description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    state: TransactionState = Field(...)
    token_id: Optional[StrictStr] = Field(None, alias="tokenId", description="System-generated unique identifier of the resource.")
    transaction_type: TransactionType = Field(..., alias="transactionType")
    tx_hash: Optional[StrictStr] = Field(None, alias="txHash", description="Blockchain generated identifier of the transaction.")
    update_date: datetime = Field(..., alias="updateDate", description="Date and time the resource was last updated, in ISO-8601 UTC format.")
    user_id: Optional[constr(strict=True, max_length=50, min_length=5)] = Field(None, alias="userId", description="Unique system generated identifier for the user.")
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="System-generated unique identifier of the resource.")
    transaction_screening_evaluation: Optional[TransactionScreeningDecision] = Field(None, alias="transactionScreeningEvaluation")
    __properties = ["id", "abiFunctionSignature", "abiParameters", "amounts", "amountInUSD", "blockHash", "blockHeight", "blockchain", "contractAddress", "createDate", "custodyType", "destinationAddress", "errorReason", "errorDetails", "estimatedFee", "feeLevel", "firstConfirmDate", "networkFee", "networkFeeInUSD", "nfts", "operation", "refId", "sourceAddress", "state", "tokenId", "transactionType", "txHash", "updateDate", "userId", "walletId", "transactionScreeningEvaluation"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> Transaction:
        """Create an instance of Transaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in abi_parameters (list)
        _items = []
        if self.abi_parameters:
            for _item in self.abi_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['abiParameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of estimated_fee
        if self.estimated_fee:
            _dict['estimatedFee'] = self.estimated_fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_screening_evaluation
        if self.transaction_screening_evaluation:
            _dict['transactionScreeningEvaluation'] = self.transaction_screening_evaluation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Transaction:
        """Create an instance of Transaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Transaction.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = Transaction.parse_obj({
            "id": obj.get("id"),
                        "abi_function_signature": obj.get("abiFunctionSignature"),
                        "abi_parameters": [AbiParametersInner.from_dict(_item) for _item in obj.get("abiParameters")] if obj.get("abiParameters") is not None else None,
                        "amounts": obj.get("amounts"),
                        "amount_in_usd": obj.get("amountInUSD"),
                        "block_hash": obj.get("blockHash"),
                        "block_height": obj.get("blockHeight"),
                        "blockchain": obj.get("blockchain"),
                        "contract_address": obj.get("contractAddress"),
                        "create_date": obj.get("createDate"),
                        "custody_type": obj.get("custodyType"),
                        "destination_address": obj.get("destinationAddress"),
                        "error_reason": obj.get("errorReason"),
                        "error_details": obj.get("errorDetails"),
                        "estimated_fee": TransactionFee.from_dict(obj.get("estimatedFee")) if obj.get("estimatedFee") is not None else None,
                        "fee_level": obj.get("feeLevel"),
                        "first_confirm_date": obj.get("firstConfirmDate"),
                        "network_fee": obj.get("networkFee"),
                        "network_fee_in_usd": obj.get("networkFeeInUSD"),
                        "nfts": obj.get("nfts"),
                        "operation": obj.get("operation"),
                        "ref_id": obj.get("refId"),
                        "source_address": obj.get("sourceAddress"),
                        "state": obj.get("state"),
                        "token_id": obj.get("tokenId"),
                        "transaction_type": obj.get("transactionType"),
                        "tx_hash": obj.get("txHash"),
                        "update_date": obj.get("updateDate"),
                        "user_id": obj.get("userId"),
                        "wallet_id": obj.get("walletId"),
                        "transaction_screening_evaluation": TransactionScreeningDecision.from_dict(obj.get("transactionScreeningEvaluation")) if obj.get("transactionScreeningEvaluation") is not None else None
            
        })
        return _obj


