from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define

from ..models.create_message_request_role import CreateMessageRequestRole
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.create_message_request_attachments_type_0_item import CreateMessageRequestAttachmentsType0Item
    from ..models.create_message_request_metadata_type_0 import CreateMessageRequestMetadataType0


T = TypeVar("T", bound="CreateMessageRequest")


@_attrs_define
class CreateMessageRequest:
    """
    Attributes:
        role (CreateMessageRequestRole): The role of the entity that is creating the message. Allowed values include:
            - `user`: Indicates the message is sent by an actual user and should be used in most cases to represent user-
            generated messages.
            - `assistant`: Indicates the message is generated by the assistant. Use this value to insert messages from the
            assistant into the conversation.
        content (str): The content of the message.
        attachments (Union[List['CreateMessageRequestAttachmentsType0Item'], None, Unset]): A list of files attached to
            the message, and the tools they should be added to.
        metadata (Union['CreateMessageRequestMetadataType0', None, Unset]): Set of 16 key-value pairs that can be
            attached to an object. This can be useful for storing additional information about the object in a structured
            format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
    """

    role: CreateMessageRequestRole
    content: str
    attachments: Union[List["CreateMessageRequestAttachmentsType0Item"], None, Unset] = UNSET
    metadata: Union["CreateMessageRequestMetadataType0", None, Unset] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        from ..models.create_message_request_metadata_type_0 import CreateMessageRequestMetadataType0

        role = self.role.value

        content = self.content

        attachments: Union[List[Dict[str, Any]], None, Unset]
        if isinstance(self.attachments, Unset):
            attachments = UNSET
        elif isinstance(self.attachments, list):
            attachments = []
            for attachments_type_0_item_data in self.attachments:
                attachments_type_0_item = attachments_type_0_item_data.to_dict()
                attachments.append(attachments_type_0_item)

        else:
            attachments = self.attachments

        metadata: Union[Dict[str, Any], None, Unset]
        if isinstance(self.metadata, Unset):
            metadata = UNSET
        elif isinstance(self.metadata, CreateMessageRequestMetadataType0):
            metadata = self.metadata.to_dict()
        else:
            metadata = self.metadata

        field_dict: Dict[str, Any] = {}
        field_dict.update(
            {
                "role": role,
                "content": content,
            }
        )
        if attachments is not UNSET:
            field_dict["attachments"] = attachments
        if metadata is not UNSET:
            field_dict["metadata"] = metadata

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.create_message_request_attachments_type_0_item import CreateMessageRequestAttachmentsType0Item
        from ..models.create_message_request_metadata_type_0 import CreateMessageRequestMetadataType0

        d = src_dict.copy()
        role = CreateMessageRequestRole(d.pop("role"))

        content = d.pop("content")

        def _parse_attachments(data: object) -> Union[List["CreateMessageRequestAttachmentsType0Item"], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                attachments_type_0 = []
                _attachments_type_0 = data
                for attachments_type_0_item_data in _attachments_type_0:
                    attachments_type_0_item = CreateMessageRequestAttachmentsType0Item.from_dict(
                        attachments_type_0_item_data
                    )

                    attachments_type_0.append(attachments_type_0_item)

                return attachments_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List["CreateMessageRequestAttachmentsType0Item"], None, Unset], data)

        attachments = _parse_attachments(d.pop("attachments", UNSET))

        def _parse_metadata(data: object) -> Union["CreateMessageRequestMetadataType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                metadata_type_0 = CreateMessageRequestMetadataType0.from_dict(data)

                return metadata_type_0
            except:  # noqa: E722
                pass
            return cast(Union["CreateMessageRequestMetadataType0", None, Unset], data)

        metadata = _parse_metadata(d.pop("metadata", UNSET))

        create_message_request = cls(
            role=role,
            content=content,
            attachments=attachments,
            metadata=metadata,
        )

        return create_message_request
