"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * A Golang Lambda function
 */
let GoFunction = class GoFunction extends lambda.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_go_alpha_GoFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GoFunction);
            }
            throw error;
        }
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = (0, util_1.findUp)('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = props.runtime ?? lambda.Runtime.PROVIDED_AL2;
        const architecture = props.architecture ?? lambda.Architecture.X86_64;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...props.bundling ?? {},
                entry,
                runtime,
                architecture,
                moduleDir,
            }),
            handler: 'bootstrap', // setting name to bootstrap so that the 'provided' runtime can also be used
        });
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
    }
};
exports.GoFunction = GoFunction;
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go-alpha.GoFunction", version: "2.200.2-alpha.0" };
/** Uniquely identifies this class. */
GoFunction.PROPERTY_INJECTION_ID = '@aws-cdk.aws-lambda-go-alpha.GoFunction';
/**
 * The address of the Google Go proxy
 */
GoFunction.GOOGLE_GOPROXY = 'https://proxy.golang.org';
exports.GoFunction = GoFunction = __decorate([
    prop_injectable_1.propertyInjectable
], GoFunction);
//# sourceMappingURL=data:application/json;base64,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