#  Copyright 2023 Alibaba, Inc. or its affiliates.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       https://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from __future__ import absolute_import

from .artifact import (
    ArtifactMetadataUtils,
    DataType,
    LocationArtifactMetadata,
    LocationType,
    ModelType,
    PipelineArtifact,
)
from .parameter import ParameterType, PipelineParameter
from .spec import IO_TYPE_INPUTS, IO_TYPE_OUTPUTS, InputsSpec, OutputsSpec
from .variable import PipelineVariable

__all__ = [
    "PipelineVariable",
    "PipelineArtifact",
    "ModelType",
    "DataType",
    "LocationType",
    "LocationArtifactMetadata",
    "PipelineParameter",
    "ParameterType",
    "InputsSpec",
    "OutputsSpec",
    "ArtifactMetadataUtils",
    "IO_TYPE_OUTPUTS",
    "IO_TYPE_INPUTS",
]
