# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, Optional

try:
    from pydantic.v1 import BaseModel, Field, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictStr

from sensorpush_api.models.tags import Tags

class Gateway(BaseModel):
    """
    Gateway
    """
    last_alert: Optional[datetime] = Field(default=None, description="Date last alert was sent")
    last_seen: Optional[datetime] = Field(default=None, description="Date the gateway was last seen")
    message: Optional[StrictStr] = Field(default=None, description="Detailed message associated with the gateway status.")
    name: Optional[StrictStr] = Field(default=None, description="Name associated with a gateway")
    paired: Optional[StrictStr] = Field(default=None, description="Gateway is paired with a bluetooth device")
    tags: Optional[Dict[str, Tags]] = Field(default=None, description="List of tags associated with this device")
    version: Optional[StrictStr] = Field(default=None, description="Version of Sensorpush software")
    __properties = ["last_alert", "last_seen", "message", "name", "paired", "tags", "version"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Gateway:
        """Create an instance of Gateway from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in tags (dict)
        _field_dict = {}
        if self.tags:
            for _key in self.tags:
                if self.tags[_key]:
                    _field_dict[_key] = self.tags[_key].to_dict()
            _dict['tags'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Gateway:
        """Create an instance of Gateway from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Gateway.parse_obj(obj)

        _obj = Gateway.parse_obj({
            "last_alert": obj.get("last_alert"),
            "last_seen": obj.get("last_seen"),
            "message": obj.get("message"),
            "name": obj.get("name"),
            "paired": obj.get("paired"),
            "tags": dict(
                (_k, Tags.from_dict(_v))
                for _k, _v in obj.get("tags").items()
            )
            if obj.get("tags") is not None
            else None,
            "version": obj.get("version")
        })
        return _obj


