# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, Optional, Union

try:
    from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt
except ImportError:
    from pydantic import BaseModel, Field, StrictFloat, StrictInt

from sensorpush_api.models.tags import Tags

class Sample(BaseModel):
    """
    This represents one observation recorded by a given sensor. The fields listed below (except for observed) will be populated base on the measures parameter specified in the request, and if the given sensor version collects that particular measure. For example, barometric_pressure is not available in HT1 series sensors, and thus will not be reported.  # noqa: E501
    """
    altitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value unit is feet (ft)")
    barometric_pressure: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value unit is inch of mercury (inHg)")
    dewpoint: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value unit is farenheit (°F)")
    humidity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value unit is percentage (%)")
    observed: Optional[datetime] = Field(default=None, description="Date time when sample was observed.")
    tags: Optional[Dict[str, Tags]] = Field(default=None, description="List of tags associated with this device")
    temperature: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value unit is farenheit (°F)")
    vpd: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value unit is kPa")
    __properties = ["altitude", "barometric_pressure", "dewpoint", "humidity", "observed", "tags", "temperature", "vpd"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Sample:
        """Create an instance of Sample from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in tags (dict)
        _field_dict = {}
        if self.tags:
            for _key in self.tags:
                if self.tags[_key]:
                    _field_dict[_key] = self.tags[_key].to_dict()
            _dict['tags'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Sample:
        """Create an instance of Sample from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Sample.parse_obj(obj)

        _obj = Sample.parse_obj({
            "altitude": obj.get("altitude"),
            "barometric_pressure": obj.get("barometric_pressure"),
            "dewpoint": obj.get("dewpoint"),
            "humidity": obj.get("humidity"),
            "observed": obj.get("observed"),
            "tags": dict(
                (_k, Tags.from_dict(_v))
                for _k, _v in obj.get("tags").items()
            )
            if obj.get("tags") is not None
            else None,
            "temperature": obj.get("temperature"),
            "vpd": obj.get("vpd")
        })
        return _obj


