# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional, Union

try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist

from sensorpush_api.models.sample import Sample

class Samples(BaseModel):
    """
    Map of registered SensorPush sensors  # noqa: E501
    """
    last_time: Optional[datetime] = Field(default=None, description="ISO date time of the last sample returned. Use this as the start_ts to query for the next page of samples.")
    sensors: Optional[Dict[str, conlist(Sample)]] = Field(default=None, description="Map of sensors and the associated samples.")
    status: Optional[StrictStr] = Field(default=None, description="Message describing state of the api call.")
    total_samples: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of samples across all sensors")
    total_sensors: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of sensors returned")
    truncated: Optional[StrictBool] = Field(default=None, description="The query returned too many results, causing the sample list to be truncated. Consider adjusting the limit or startTime parameters.")
    __properties = ["last_time", "sensors", "status", "total_samples", "total_sensors", "truncated"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Samples:
        """Create an instance of Samples from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in sensors (dict of array)
        _field_dict_of_array = {}
        if self.sensors:
            for _key in self.sensors:
                if self.sensors[_key] is not None:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.sensors[_key]
                    ]
            _dict['sensors'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Samples:
        """Create an instance of Samples from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Samples.parse_obj(obj)

        _obj = Samples.parse_obj({
            "last_time": obj.get("last_time"),
            "sensors": dict(
                (_k,
                        [Sample.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("sensors").items()
            ),
            "status": obj.get("status"),
            "total_samples": obj.get("total_samples"),
            "total_sensors": obj.get("total_sensors"),
            "truncated": obj.get("truncated")
        })
        return _obj


