/*
@license

dhtmlxSuite v.8.3.4 GPL

This software is covered by GPL license.
To use it in non-GPL project, you need obtain Commercial or Enterprise license
Please contact sales@dhtmlx.com. Usage without proper license is prohibited.
(c) XB Software.

*/
if (window.dhx){ window.dhx_legacy = dhx; delete window.dhx; }(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["dhx"] = factory();
	else
		root["dhx"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/codebase/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 108);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.setTheme = exports.awaitRedraw = exports.resizeHandler = exports.resizer = exports.disableHelp = exports.KEYED_LIST = exports.inject = exports.create = exports.view = exports.sv = exports.el = void 0;
var dom = __webpack_require__(120);
var html_1 = __webpack_require__(3);
exports.el = dom.defineElement;
exports.sv = dom.defineSvgElement;
exports.view = dom.defineView;
exports.create = dom.createView;
exports.inject = dom.injectView;
exports.KEYED_LIST = dom.KEYED_LIST;
function disableHelp() {
    dom.DEVMODE.mutations = false;
    dom.DEVMODE.warnings = false;
    dom.DEVMODE.verbose = false;
    dom.DEVMODE.UNKEYED_INPUT = false;
}
exports.disableHelp = disableHelp;
function resizer(handler) {
    var resize = window.ResizeObserver;
    var activeHandler = function (node) {
        var height = node.el.offsetHeight;
        var width = node.el.offsetWidth;
        handler(width, height);
    };
    if (resize) {
        return (0, exports.el)("div.dhx-resize-observer", {
            _hooks: {
                didInsert: function (node) {
                    new resize(function () { return activeHandler(node); }).observe(node.el);
                },
            },
        });
    }
    return (0, exports.el)("iframe.dhx-resize-observer", {
        _hooks: {
            didInsert: function (node) {
                node.el.contentWindow.onresize = function () { return activeHandler(node); };
                activeHandler(node);
            },
        },
    });
}
exports.resizer = resizer;
function resizeHandler(container, handler) {
    return (0, exports.create)({
        render: function () {
            return resizer(handler);
        },
    }).mount(container);
}
exports.resizeHandler = resizeHandler;
function awaitRedraw() {
    return new Promise(function (res) {
        requestAnimationFrame(function () {
            res();
        });
    });
}
exports.awaitRedraw = awaitRedraw;
function setTheme(theme, container) {
    if (theme === void 0) { theme = "light"; }
    var dhxAttr = "data-dhx-theme";
    if (!container) {
        var elements = document.querySelectorAll("[".concat(dhxAttr, "]"));
        elements.forEach(function (el) { return el.removeAttribute(dhxAttr); });
    }
    container = container || document.documentElement;
    (0, html_1.toNode)(container).setAttribute(dhxAttr, theme);
}
exports.setTheme = setTheme;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTextLines = exports.getCloneObject = exports.rgbToHex = exports.getStringWidth = exports.getMinArrayNumber = exports.getMaxArrayNumber = exports.isEmptyObj = exports.isType = exports.compare = exports.debounce = exports.downloadFile = exports.isNumeric = exports.range = exports.isId = exports.isDefined = exports.wrapBox = exports.unwrapBox = exports.detectWidgetClick = exports.singleOuterClick = exports.isEqualString = exports.findIndex = exports.naturalSort = exports.copy = exports.extend = exports.uid = void 0;
var html_1 = __webpack_require__(3);
var counter = new Date().valueOf();
function uid() {
    return "u" + counter++;
}
exports.uid = uid;
function extend(target, source, deep) {
    if (deep === void 0) { deep = true; }
    if (source) {
        for (var key in source) {
            var sobj = source[key];
            var tobj = target[key];
            if (sobj === undefined) {
                delete target[key];
            }
            else if (deep &&
                typeof tobj === "object" &&
                !(tobj instanceof Date) &&
                !(tobj instanceof Array)) {
                extend(tobj, sobj);
            }
            else {
                target[key] = sobj;
            }
        }
    }
    return target;
}
exports.extend = extend;
function copy(source, withoutInner) {
    var result = {};
    for (var key in source) {
        if (!withoutInner || !key.startsWith("$")) {
            result[key] = source[key];
        }
    }
    return result;
}
exports.copy = copy;
function naturalSort(arr) {
    return arr.sort(function (a, b) {
        var nn = typeof a === "string" ? a.localeCompare(b) : a - b;
        return nn;
    });
}
exports.naturalSort = naturalSort;
function findIndex(arr, predicate) {
    var len = arr.length;
    for (var i = 0; i < len; i++) {
        if (predicate(arr[i])) {
            return i;
        }
    }
    return -1;
}
exports.findIndex = findIndex;
function isEqualString(from, to) {
    from = from.toString();
    to = to.toString();
    if (from.length > to.length) {
        return false;
    }
    for (var i = 0; i < from.length; i++) {
        if (from[i].toLowerCase() !== to[i].toLowerCase()) {
            return false;
        }
    }
    return true;
}
exports.isEqualString = isEqualString;
function singleOuterClick(fn) {
    var click = function (e) {
        if (fn(e)) {
            document.removeEventListener("click", click);
        }
    };
    document.addEventListener("click", click);
}
exports.singleOuterClick = singleOuterClick;
function detectWidgetClick(widgetId, cb) {
    var click = function (e) { return cb((0, html_1.locate)(e, "data-dhx-widget-id") === widgetId); };
    document.addEventListener("click", click);
    return function () { return document.removeEventListener("click", click); };
}
exports.detectWidgetClick = detectWidgetClick;
function unwrapBox(box) {
    if (Array.isArray(box)) {
        return box[0];
    }
    return box;
}
exports.unwrapBox = unwrapBox;
function wrapBox(unboxed) {
    if (Array.isArray(unboxed)) {
        return unboxed;
    }
    return [unboxed];
}
exports.wrapBox = wrapBox;
function isDefined(some) {
    return some !== null && some !== undefined;
}
exports.isDefined = isDefined;
function isId(some) {
    return typeof some === "number" || (typeof some === "string" && some !== "");
}
exports.isId = isId;
function range(from, to) {
    if (from > to) {
        return [];
    }
    var result = [];
    while (from <= to) {
        result.push(from++);
    }
    return result;
}
exports.range = range;
function isNumeric(val) {
    return !isNaN(val - parseFloat(val));
}
exports.isNumeric = isNumeric;
function downloadFile(data, filename, mimeType) {
    if (mimeType === void 0) { mimeType = "text/plain"; }
    var file = new Blob([data], { type: mimeType });
    if (window.navigator.msSaveOrOpenBlob) {
        // IE10+
        window.navigator.msSaveOrOpenBlob(file, filename);
    }
    else {
        var a_1 = document.createElement("a");
        var url_1 = URL.createObjectURL(file);
        a_1.href = url_1;
        a_1.download = filename;
        document.body.appendChild(a_1);
        a_1.click();
        setTimeout(function () {
            document.body.removeChild(a_1);
            window.URL.revokeObjectURL(url_1);
        }, 0);
    }
}
exports.downloadFile = downloadFile;
function debounce(func, wait, immediate) {
    var timeout;
    return function executedFunction() {
        var _this = this;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var later = function () {
            timeout = null;
            if (!immediate) {
                func.apply(_this, args);
            }
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        if (callNow) {
            func.apply(this, args);
        }
    };
}
exports.debounce = debounce;
function compare(obj1, obj2) {
    for (var p in obj1) {
        if (obj1.hasOwnProperty(p) !== obj2.hasOwnProperty(p)) {
            return false;
        }
        switch (typeof obj1[p]) {
            case "object":
                if (!compare(obj1[p], obj2[p])) {
                    return false;
                }
                break;
            case "function":
                if (typeof obj2[p] === "undefined" ||
                    (p !== "compare" && obj1[p].toString() !== obj2[p].toString())) {
                    return false;
                }
                break;
            default:
                if (obj1[p] !== obj2[p]) {
                    return false;
                }
        }
    }
    for (var p in obj2) {
        if (!obj1.hasOwnProperty(p)) {
            return false;
        }
    }
    return true;
}
exports.compare = compare;
var isType = function (value) {
    var regex = /^\[object (\S+?)\]$/;
    var matches = Object.prototype.toString.call(value).match(regex) || [];
    return (matches[1] || "undefined").toLowerCase();
};
exports.isType = isType;
var isEmptyObj = function (obj) {
    for (var key in obj) {
        return false;
    }
    return true;
};
exports.isEmptyObj = isEmptyObj;
var getMaxArrayNumber = function (array) {
    if (!array.length)
        return;
    var maxNumber = -Infinity;
    var index = 0;
    var length = array.length;
    for (index; index < length; index++) {
        if (array[index] > maxNumber)
            maxNumber = array[index];
    }
    return maxNumber;
};
exports.getMaxArrayNumber = getMaxArrayNumber;
var getMinArrayNumber = function (array) {
    if (!array.length)
        return;
    var minNumber = +Infinity;
    var index = 0;
    var length = array.length;
    for (index; index < length; index++) {
        if (array[index] < minNumber)
            minNumber = array[index];
    }
    return minNumber;
};
exports.getMinArrayNumber = getMinArrayNumber;
var getStringWidth = function (value, config) {
    config = __assign({ font: "normal 14px Roboto", lineHeight: 20 }, config);
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    if (config.font)
        ctx.font = config.font;
    var width = ctx.measureText(value).width;
    if (!(0, html_1.isIE)())
        canvas.remove();
    return width;
};
exports.getStringWidth = getStringWidth;
var rgbToHex = function (color) {
    if (color.substr(0, 1) === "#") {
        return color;
    }
    if (color.substr(0, 3) !== "rgb") {
        return;
    }
    var digits = /(.*?)rgb[a]?\((\d+), *(\d+), *(\d+),* *([\d+.]*)\)/.exec(color);
    var red = parseInt(digits[2], 10)
        .toString(16)
        .padStart(2, "0");
    var green = parseInt(digits[3], 10)
        .toString(16)
        .padStart(2, "0");
    var blue = parseInt(digits[4], 10)
        .toString(16)
        .padStart(2, "0");
    return "#".concat(red).concat(green).concat(blue);
};
exports.rgbToHex = rgbToHex;
function getCloneObject(obj) {
    if (!obj) {
        return obj;
    }
    var clone = Array.isArray(obj) ? [] : {};
    for (var key in obj) {
        var value = obj[key];
        if (value instanceof Date) {
            clone[key] = new Date(value);
            continue;
        }
        clone[key] = typeof value === "object" ? getCloneObject(value) : value;
    }
    return clone;
}
exports.getCloneObject = getCloneObject;
function getTextLines(ctx, text, maxWidth) {
    var words = text.split(" ");
    var line = "";
    var testLine = "";
    var lineArray = [];
    for (var n = 0; n < words.length; n++) {
        testLine += "".concat(words[n], " ");
        var metrics = ctx.measureText(testLine.trimEnd());
        var testWidth = metrics.width;
        if (testWidth > maxWidth && n > 0) {
            lineArray.push(line);
            line = "".concat(words[n], " ");
            testLine = "".concat(words[n], " ");
        }
        else {
            line += "".concat(words[n], " ");
        }
        if (n === words.length - 1) {
            lineArray.push(line);
        }
    }
    return lineArray;
}
exports.getTextLines = getTextLines;


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsMixin = exports.EventSystem = void 0;
var EventSystem = /** @class */ (function () {
    function EventSystem(context) {
        this.events = {};
        this.context = context || this;
    }
    EventSystem.prototype.on = function (name, callback, context) {
        var event = name.toLowerCase();
        this.events[event] = this.events[event] || [];
        this.events[event].push({ callback: callback, context: context || this.context });
    };
    EventSystem.prototype.detach = function (name, context) {
        var event = name.toLowerCase();
        var eStack = this.events[event];
        if (context && eStack && eStack.length) {
            for (var i = eStack.length - 1; i >= 0; i--) {
                if (eStack[i].context === context) {
                    eStack.splice(i, 1);
                }
            }
        }
        else {
            this.events[event] = [];
        }
    };
    EventSystem.prototype.fire = function (name, args) {
        if (typeof args === "undefined") {
            args = [];
        }
        var event = name.toLowerCase();
        if (this.events[event]) {
            var res = this.events[event].map(function (e) { return e.callback.apply(e.context, args); });
            return !res.includes(false);
        }
        return true;
    };
    EventSystem.prototype.clear = function () {
        this.events = {};
    };
    return EventSystem;
}());
exports.EventSystem = EventSystem;
function EventsMixin(obj) {
    obj = obj || {};
    var eventSystem = new EventSystem(obj);
    obj.detachEvent = eventSystem.detach.bind(eventSystem);
    obj.attachEvent = eventSystem.on.bind(eventSystem);
    obj.callEvent = eventSystem.fire.bind(eventSystem);
}
exports.EventsMixin = EventsMixin;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPageLinksCss = exports.getPageInlineCss = exports.getLabelStyle = exports.getPageCss = exports.fitPosition = exports.calculatePosition = exports.getRealPosition = exports.isFirefox = exports.isSafari = exports.isIE = exports.getScrollbarHeight = exports.getScrollbarWidth = exports.getBox = exports.locateNodeByClassName = exports.locate = exports.locateNode = exports.eventHandler = exports.toNode = void 0;
function toNode(node) {
    var _a;
    return typeof node === "string"
        ? document.getElementById(node) || document.querySelector("[data-cell-id=".concat(node, "]")) || document.querySelector(node) || ((_a = document.querySelector("[data-dhx-root-id=".concat(node, "]"))) === null || _a === void 0 ? void 0 : _a.parentElement) || document.body
        : node || document.body;
}
exports.toNode = toNode;
function eventHandler(prepare, hash, afterCall) {
    var keys = Object.keys(hash);
    return function (ev) {
        var data = prepare(ev);
        if (data !== undefined) {
            var node = ev.target;
            outer_block: while (node) {
                var cssstring = node.getAttribute ? node.getAttribute("class") || "" : "";
                if (cssstring.length) {
                    var css = cssstring.split(" ");
                    for (var j = 0; j < keys.length; j++) {
                        if (css.includes(keys[j])) {
                            if (hash[keys[j]](ev, data) === false || ev.cancelBubble)
                                return false;
                            else
                                break outer_block;
                        }
                    }
                }
                node = node.parentNode;
            }
        }
        if (typeof afterCall === "function")
            afterCall(ev);
        return true;
    };
}
exports.eventHandler = eventHandler;
function locateNode(target, attr, dir) {
    if (attr === void 0) { attr = "data-dhx-id"; }
    if (dir === void 0) { dir = "target"; }
    if (target instanceof Event) {
        target = target[dir];
    }
    while (target) {
        if (target.getAttribute && target.getAttribute(attr)) {
            return target;
        }
        target = target.parentNode;
    }
}
exports.locateNode = locateNode;
function locate(target, attr) {
    if (attr === void 0) { attr = "data-dhx-id"; }
    var node = locateNode(target, attr);
    return node ? node.getAttribute(attr) : "";
}
exports.locate = locate;
function locateNodeByClassName(target, className) {
    if (target instanceof Event) {
        target = target.target;
    }
    while (target) {
        if (className) {
            if (target.classList && target.classList.contains(className)) {
                return target;
            }
        }
        else if (target.getAttribute && target.getAttribute("data-dhx-id")) {
            return target;
        }
        target = target.parentNode;
    }
}
exports.locateNodeByClassName = locateNodeByClassName;
function getBox(elem) {
    var box = elem.getBoundingClientRect();
    var body = document.body;
    var scrollTop = window.pageYOffset || body.scrollTop;
    var scrollLeft = window.pageXOffset || body.scrollLeft;
    var top = box.top + scrollTop;
    var left = box.left + scrollLeft;
    var right = body.offsetWidth - box.right;
    var bottom = body.offsetHeight - box.bottom;
    var width = box.right - box.left;
    var height = box.bottom - box.top;
    return { top: top, left: left, right: right, bottom: bottom, width: width, height: height };
}
exports.getBox = getBox;
var scrollWidth = -1;
function getScrollbarWidth() {
    if (scrollWidth > -1) {
        return scrollWidth;
    }
    var scrollDiv = document.createElement("div");
    document.body.appendChild(scrollDiv);
    scrollDiv.style.cssText = "position: absolute;left: -99999px;overflow:scroll;width: 100px;height: 100px;";
    scrollWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
    document.body.removeChild(scrollDiv);
    return scrollWidth;
}
exports.getScrollbarWidth = getScrollbarWidth;
var scrollHeight = -1;
function getScrollbarHeight() {
    if (scrollHeight > -1) {
        return scrollHeight;
    }
    var scrollDiv = document.createElement("div");
    document.body.appendChild(scrollDiv);
    scrollDiv.style.cssText = "position: absolute;left: -99999px;overflow:scroll;width: 100px;height: 100px;";
    scrollHeight = scrollDiv.offsetHeight - scrollDiv.clientHeight;
    document.body.removeChild(scrollDiv);
    return scrollHeight;
}
exports.getScrollbarHeight = getScrollbarHeight;
function isIE() {
    var ua = window.navigator.userAgent;
    return ua.includes("MSIE ") || ua.includes("Trident/");
}
exports.isIE = isIE;
function isSafari() {
    var check = function (str) { return str.test(window.navigator.userAgent); };
    var chrome = check(/Chrome/);
    var firefox = check(/Firefox/);
    return !chrome && !firefox && check(/Safari/);
}
exports.isSafari = isSafari;
function isFirefox() {
    var check = function (str) { return str.test(window.navigator.userAgent); };
    var chrome = check(/Chrome/);
    var safari = check(/Safari/);
    return !chrome && !safari && check(/Firefox/);
}
exports.isFirefox = isFirefox;
function getRealPosition(node) {
    var rects = node.getBoundingClientRect();
    return {
        left: rects.left + window.pageXOffset,
        right: rects.right + window.pageXOffset,
        top: rects.top + window.pageYOffset,
        bottom: rects.bottom + window.pageYOffset,
    };
}
exports.getRealPosition = getRealPosition;
function getWindowBorders() {
    return {
        rightBorder: window.pageXOffset + window.innerWidth,
        bottomBorder: window.pageYOffset + window.innerHeight,
    };
}
function horizontalCentering(pos, width, rightBorder) {
    var nodeWidth = pos.right - pos.left;
    var diff = (width - nodeWidth) / 2;
    var left = pos.left - diff;
    var right = pos.right + diff;
    if (left >= 0 && right <= rightBorder) {
        return left;
    }
    if (left < 0) {
        return 0;
    }
    return rightBorder - width;
}
function verticalCentering(pos, height, bottomBorder) {
    var nodeHeight = pos.bottom - pos.top;
    var diff = (height - nodeHeight) / 2;
    var top = pos.top - diff;
    var bottom = pos.bottom + diff;
    if (top >= 0 && bottom <= bottomBorder) {
        return top;
    }
    if (top < 0) {
        return 0;
    }
    return bottomBorder - height;
}
function placeBottomOrTop(pos, config) {
    var _a = getWindowBorders(), rightBorder = _a.rightBorder, bottomBorder = _a.bottomBorder;
    var left;
    var top;
    var bottomDiff = bottomBorder - pos.bottom - config.height;
    var topDiff = pos.top - config.height;
    if (config.mode === "bottom") {
        if (bottomDiff >= 0) {
            top = pos.bottom;
        }
        else if (topDiff >= 0) {
            top = topDiff;
        }
    }
    else {
        if (topDiff >= 0) {
            top = topDiff;
        }
        else if (bottomDiff >= 0) {
            top = pos.bottom;
        }
    }
    if (bottomDiff < 0 && topDiff < 0) {
        if (config.auto) {
            // eslint-disable-next-line @typescript-eslint/no-use-before-define
            return placeRightOrLeft(pos, __assign(__assign({}, config), { mode: "right", auto: false }));
        }
        top = bottomDiff > topDiff ? pos.bottom : topDiff;
    }
    if (config.centering) {
        left = horizontalCentering(pos, config.width, rightBorder);
    }
    else {
        var leftDiff = rightBorder - pos.left - config.width;
        var rightDiff = pos.right - config.width;
        if (leftDiff >= 0) {
            left = pos.left;
        }
        else if (rightDiff >= 0) {
            left = rightDiff;
        }
        else {
            left = rightDiff > leftDiff ? pos.left : rightDiff;
        }
    }
    return { left: left, top: top };
}
function placeRightOrLeft(pos, config) {
    var _a = getWindowBorders(), rightBorder = _a.rightBorder, bottomBorder = _a.bottomBorder;
    var left;
    var top;
    var rightDiff = rightBorder - pos.right - config.width;
    var leftDiff = pos.left - config.width;
    if (config.mode === "right") {
        if (rightDiff >= 0) {
            left = pos.right;
        }
        else if (leftDiff >= 0) {
            left = leftDiff;
        }
    }
    else {
        if (leftDiff >= 0) {
            left = leftDiff;
        }
        else if (rightDiff >= 0) {
            left = pos.right;
        }
    }
    if (leftDiff < 0 && rightDiff < 0) {
        if (config.auto) {
            return placeBottomOrTop(pos, __assign(__assign({}, config), { mode: "bottom", auto: false }));
        }
        left = leftDiff > rightDiff ? leftDiff : pos.right;
    }
    if (config.centering) {
        top = verticalCentering(pos, config.height, rightBorder);
    }
    else {
        var bottomDiff = pos.bottom - config.height;
        var topDiff = bottomBorder - pos.top - config.height;
        if (topDiff >= 0) {
            top = pos.top;
        }
        else if (bottomDiff > 0) {
            top = bottomDiff;
        }
        else {
            top = bottomDiff > topDiff ? bottomDiff : pos.top;
        }
    }
    return { left: left, top: top };
}
function calculatePosition(pos, config) {
    var _a = config.mode === "bottom" || config.mode === "top"
        ? placeBottomOrTop(pos, config)
        : placeRightOrLeft(pos, config), left = _a.left, top = _a.top;
    return {
        left: Math.round(left) + "px",
        top: Math.round(top) + "px",
        minWidth: Math.round(config.width) + "px",
        position: "absolute",
    };
}
exports.calculatePosition = calculatePosition;
function fitPosition(node, config) {
    return calculatePosition(getRealPosition(node), config);
}
exports.fitPosition = fitPosition;
function getPageCss() {
    var css = [];
    for (var sheeti = 0; sheeti < document.styleSheets.length; sheeti++) {
        var sheet = document.styleSheets[sheeti];
        var rules = "cssRules" in sheet ? sheet.cssRules : sheet.rules;
        for (var rulei = 0; rulei < rules.length; rulei++) {
            var rule = rules[rulei];
            if ("cssText" in rule) {
                css.push(rule.cssText);
            }
            else {
                css.push("".concat(rule.selectorText, " {\n").concat(rule.style.cssText, "\n}\n"));
            }
        }
    }
    return css.join("\n");
}
exports.getPageCss = getPageCss;
function getLabelStyle(config) {
    var helpMessage = config.helpMessage, type = config.type, labelWidth = config.labelWidth, label = config.label;
    var isZero = labelWidth && labelWidth.toString().startsWith("0");
    var required = type !== "text" && config.required;
    if (!helpMessage && !required && (!label || (label && isZero)) && (!labelWidth || isZero)) {
        return false;
    }
    return {
        style: (label || labelWidth) && !isZero && { width: labelWidth, "max-width": "100%" },
        label: label && isZero ? null : label,
    };
}
exports.getLabelStyle = getLabelStyle;
var checkCrossLink = function (sheet) { return sheet.href && !sheet.href.startsWith(window.location.origin); };
function getPageInlineCss() {
    var css = [];
    for (var i = 0; i < document.styleSheets.length; i++) {
        var sheet = document.styleSheets[i];
        if (!checkCrossLink(sheet)) {
            var rules = "cssRules" in sheet && sheet.cssRules.length
                ? sheet.cssRules
                : sheet.rules;
            for (var j = 0; j < rules.length; j++) {
                var rule = rules[j];
                if ("cssText" in rule) {
                    css.push(rule.cssText);
                }
                else {
                    css.push("".concat(rule.selectorText, " {\n").concat(rule.style.cssText, "\n}\n"));
                }
            }
        }
    }
    return css.join("\n");
}
exports.getPageInlineCss = getPageInlineCss;
function getPageLinksCss(exportStyles) {
    var css = [];
    if (exportStyles) {
        exportStyles.forEach(function (link) { return css.push("<link href=\"".concat(link, "\" rel=\"stylesheet\"/>")); });
    }
    else {
        for (var i = 0; i < document.styleSheets.length; i++) {
            var sheet = document.styleSheets[i];
            if (checkCrossLink(sheet)) {
                css.push("<link href=\"".concat(sheet.href, "\" rel=\"stylesheet\"/>"));
            }
        }
    }
    return css.join("\n");
}
exports.getPageLinksCss = getPageLinksCss;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemEvent = exports.ValidationStatus = exports.FormEvents = exports.ClearMethod = void 0;
var ClearMethod;
(function (ClearMethod) {
    ClearMethod["value"] = "value";
    ClearMethod["validation"] = "validation";
})(ClearMethod || (exports.ClearMethod = ClearMethod = {}));
var FormEvents;
(function (FormEvents) {
    FormEvents["beforeChange"] = "beforeChange";
    FormEvents["change"] = "change";
    FormEvents["click"] = "click";
    FormEvents["focus"] = "focus";
    FormEvents["blur"] = "blur";
    FormEvents["keydown"] = "keydown";
    FormEvents["beforeShow"] = "beforeShow";
    FormEvents["afterShow"] = "afterShow";
    FormEvents["beforeHide"] = "beforeHide";
    FormEvents["afterHide"] = "afterHide";
    FormEvents["afterValidate"] = "afterValidate";
    FormEvents["beforeValidate"] = "beforeValidate";
    FormEvents["beforeChangeProperties"] = "beforeChangeProperties";
    FormEvents["afterChangeProperties"] = "afterChangeProperties";
    FormEvents["beforeSend"] = "beforesend";
    FormEvents["afterSend"] = "aftersend";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    FormEvents["buttonClick"] = "buttonClick";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    FormEvents["validationFail"] = "validationfail";
})(FormEvents || (exports.FormEvents = FormEvents = {}));
var ValidationStatus;
(function (ValidationStatus) {
    ValidationStatus[ValidationStatus["pre"] = 0] = "pre";
    ValidationStatus[ValidationStatus["error"] = 1] = "error";
    ValidationStatus[ValidationStatus["success"] = 2] = "success";
})(ValidationStatus || (exports.ValidationStatus = ValidationStatus = {}));
var ItemEvent;
(function (ItemEvent) {
    ItemEvent["click"] = "click";
    ItemEvent["beforeChange"] = "beforeChange";
    ItemEvent["change"] = "change";
    ItemEvent["input"] = "input";
    ItemEvent["focus"] = "focus";
    ItemEvent["blur"] = "blur";
    ItemEvent["keydown"] = "keydown";
    ItemEvent["beforeChangeOptions"] = "beforeChangeOptions";
    ItemEvent["changeOptions"] = "changeOptions";
    ItemEvent["beforeShow"] = "beforeShow";
    ItemEvent["afterShow"] = "afterShow";
    ItemEvent["beforeHide"] = "beforeHide";
    ItemEvent["afterHide"] = "afterHide";
    ItemEvent["beforeValidate"] = "beforeValidate";
    ItemEvent["afterValidate"] = "afterValidate";
    ItemEvent["beforeUploadFile"] = "beforeUploadFile";
    ItemEvent["uploadFile"] = "uploadfile";
    ItemEvent["uploadBegin"] = "uploadBegin";
    ItemEvent["uploadComplete"] = "uploadComplete";
    ItemEvent["uploadFail"] = "uploadFail";
    ItemEvent["uploadProgress"] = "uploadProgress";
    ItemEvent["beforeChangeProperties"] = "beforeChangeProperties";
    ItemEvent["afterChangeProperties"] = "afterChangeProperties";
})(ItemEvent || (exports.ItemEvent = ItemEvent = {}));


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkPositions = exports.superposition = exports.getSizesSVGText = exports.getScales = exports.getClassesForRotateScale = exports.calcPointRef = exports.verticalBottomText = exports.verticalTopText = exports.verticalCenteredText = exports.roundToTwoNumAfterPoint = exports.euclideanDistance = exports.getRadialGradient = exports.linearGradient = exports.getFontStyle = exports.getColorShade = exports.getTextWidth = exports.log10 = exports.locator = exports.getDefaultColor = void 0;
var dom_1 = __webpack_require__(0);
var defaultColors = [
    "#2A9D8F",
    "#78586F",
    "#E76F51",
    "#E5A910",
    "#11A3D0",
    "#985F99",
    "#217B70",
    "#BD9391",
    "#9C89B8",
    "#734B5E",
    "#D66BA0",
    "#5C5D8D",
];
var defaultColorsTreeMap = ["#237396", "#2780A8", "#3892A3", "#4DA3A0", "#67BF99"];
function getDefaultColor(index, isTreeMapRange) {
    if (index === void 0) { index = 0; }
    return isTreeMapRange ? defaultColorsTreeMap[index] : defaultColors[index];
}
exports.getDefaultColor = getDefaultColor;
function locator(value) {
    if (!value) {
        return function () { return ""; };
    }
    if (typeof value === "string") {
        return function (obj) { return obj[value]; };
    }
    else {
        return value;
    }
}
exports.locator = locator;
function log10(x) {
    return Math.log(x) / Math.LN10;
}
exports.log10 = log10;
function anyArgsMemo(fn) {
    var cached = {};
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var mem = cached;
        for (var i = 0; i < args.length - 1; i++) {
            mem[args[i]] = mem[args[i]] || {};
            mem = mem[args[i]];
        }
        var last = args.length - 1;
        if (mem[last]) {
            return mem[last];
        }
        return (mem[last] = fn.apply(void 0, args));
    };
}
exports.getTextWidth = anyArgsMemo(function (text, font) {
    if (font === void 0) { font = ""; }
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    if (font) {
        ctx.font = font;
    }
    return ctx.measureText(text).width;
});
function memo(fn) {
    var cached = {};
    return function (arg) {
        if (cached[arg]) {
            return cached[arg];
        }
        return (cached[arg] = fn(arg));
    };
}
function getRgbaFromColor(color) {
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    ctx.fillStyle = color;
    ctx.fillRect(0, 0, 2, 2);
    var rgba = ctx.getImageData(1, 1, 1, 1).data;
    return [rgba[0], rgba[1], rgba[2]];
}
var memoizedColorFromRgba = memo(getRgbaFromColor);
function getColorShade(color, light) {
    var _a = memoizedColorFromRgba(color).map(function (value) {
        return Math.floor(value * light + 255 * (1 - light));
    }), r = _a[0], g = _a[1], b = _a[2];
    return "rgb(".concat(r, ",").concat(g, ",").concat(b, ")");
}
exports.getColorShade = getColorShade;
exports.getFontStyle = memo(function (className) {
    var chart = document.createElementNS("http://www.w3.org/2000/svg", "svg");
    chart.setAttribute("class", "dhx_chart");
    var text = document.createElementNS("http://www.w3.org/2000/svg", "text");
    text.setAttribute("class", className);
    chart.setAttribute("visibility", "hidden");
    text.textContent = "test";
    chart.appendChild(text);
    document.body.appendChild(chart);
    var style = getComputedStyle(text);
    var font = "".concat(style.fontSize, " ").concat(style.fontFamily);
    document.body.removeChild(chart);
    return font;
});
function linearGradient(grad, id) {
    var stops = grad.stops;
    var colors = stops.map(function (item) {
        return (0, dom_1.sv)("stop", {
            offset: "".concat(item.offset * 100, "%"),
            "stop-color": item.color,
            "stop-opacity": item.opacity || 1,
        });
    });
    var gradient = (0, dom_1.sv)("linearGradient", {
        id: id,
        gradientTransform: "rotate(90)",
    }, colors);
    return gradient;
}
exports.linearGradient = linearGradient;
function getRadialGradient(opts, stops, id) {
    var colors = stops.map(function (item) {
        return (0, dom_1.sv)("stop", {
            offset: item.offset,
            "stop-color": item.color,
            "stop-opacity": item.opacity || 1,
        });
    });
    var gradient = (0, dom_1.sv)("radialGradient", __assign({ id: id, cx: 0, cy: 0, gradientUnits: "userSpaceOnUse" }, opts), colors);
    return gradient;
}
exports.getRadialGradient = getRadialGradient;
function euclideanDistance(x1, y1, x2, y2) {
    return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
}
exports.euclideanDistance = euclideanDistance;
function roundToTwoNumAfterPoint(p) {
    return Math.round((p * 100 + Number.EPSILON) * 100) / 100;
}
exports.roundToTwoNumAfterPoint = roundToTwoNumAfterPoint;
function verticalCenteredText(text) {
    return (0, dom_1.sv)("tspan", {
        dy: "0.5ex",
        style: {
            pointerEvents: "none",
        },
    }, text);
}
exports.verticalCenteredText = verticalCenteredText;
function verticalTopText(text) {
    return (0, dom_1.sv)("tspan", {
        dy: "-0.5ex",
    }, text);
}
exports.verticalTopText = verticalTopText;
function verticalBottomText(text) {
    return (0, dom_1.sv)("tspan", {
        dy: "1.5ex",
    }, text);
}
exports.verticalBottomText = verticalBottomText;
function calcPointRef(pointId, serieId) {
    return pointId + "_" + serieId;
}
exports.calcPointRef = calcPointRef;
function getClassesForRotateScale(position, angle) {
    var className = "";
    var classList = [];
    if (position === "left" || position === "top") {
        classList.push("start-text", "end-text");
    }
    else if (position === "right" || position === "bottom") {
        classList.push("end-text", "start-text");
    }
    switch (position) {
        case "left":
        case "right":
            if (angle === 0) {
                className = classList[1];
            }
            else if (angle > 0) {
                if (angle === 180) {
                    className = classList[0];
                }
                else if (angle > 180) {
                    if (angle < 270) {
                        className = classList[0];
                    }
                    else if (angle > 270) {
                        className = classList[1];
                    }
                }
                else if (angle < 180) {
                    if (angle > 90) {
                        className = classList[0];
                    }
                    else if (angle < 90) {
                        className = classList[1];
                    }
                }
            }
            else if (angle < 0) {
                if (angle === -180) {
                    className = classList[0];
                }
                else if (angle < -180) {
                    if (angle > -270) {
                        className = classList[0];
                    }
                    else if (angle < -270) {
                        className = classList[1];
                    }
                }
                else if (angle > -180) {
                    if (angle < -90) {
                        className = classList[0];
                    }
                    else if (angle > -90) {
                        className = classList[1];
                    }
                }
            }
            break;
        case "top":
        case "bottom":
            if (angle > 0) {
                if (angle > 180) {
                    className = classList[0];
                }
                else if (angle < 180) {
                    className = classList[1];
                }
            }
            else if (angle < 0) {
                if (angle > -180) {
                    className = classList[0];
                }
                else if (angle < -180) {
                    className = classList[1];
                }
            }
            break;
    }
    return className;
}
exports.getClassesForRotateScale = getClassesForRotateScale;
function getScales(config) {
    var scales = [];
    for (var scaleName in config) {
        var scale = config[scaleName];
        if (scale.min || scale.max || scale.maxTicks || scale.text || scale.value) {
            scales.push(scaleName);
        }
    }
    return scales;
}
exports.getScales = getScales;
function getSizesSVGText(text, config) {
    var sizes = [];
    config = __assign({ font: "normal 14px Roboto", lineHeight: 18 }, config);
    sizes.push((0, exports.getTextWidth)(text, config.font));
    sizes.push(config.lineHeight);
    return sizes;
}
exports.getSizesSVGText = getSizesSVGText;
function superposition(objA, objB) {
    if (objA.x < objB.x + objB.width &&
        objA.x + objA.width > objB.x &&
        objA.y < objB.y + objB.height &&
        objA.y + objA.height > objB.y) {
        return true;
    }
    else
        return false;
}
exports.superposition = superposition;
function checkPositions(current, previos, radiusX, radiusY, obj) {
    if (superposition(current, previos)) {
        var dY = obj.right
            ? previos.y - current.y + current.height
            : previos.y - previos.height - current.y;
        var newY = obj.text1.y + dY;
        if (Math.abs(newY) + obj.dy > radiusY) {
            newY = newY > 0 ? radiusY + obj.dy : -radiusY + obj.dy;
            obj.changeSector = !obj.changeSector;
        }
        var newX = Math.sqrt(Math.pow(radiusX, 2) - Math.pow(((newY - obj.dy) * radiusX) / radiusY, 2));
        newX = obj.right ? newX : -newX;
        if (obj.changeSector) {
            newX *= -1;
            obj.line *= -1;
            current.class = obj.right ? "pie-value end-text" : "pie-value start-text";
        }
        obj.text1.x = newX;
        obj.text1.y = newY;
        obj.text2.x = newX;
        obj.text2.y = newY + 16;
    }
}
exports.checkPositions = checkPositions;


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.setAttacments = exports.widgetConfig = exports.baseProps = exports.isVerify = exports.isTimeFormat = exports.baseInputValidate = exports.validateInput = exports.isBlock = exports.validateTemplate = exports.getValidationMessage = exports.getFormItemCss = void 0;
/* eslint-disable no-useless-escape */
var types_1 = __webpack_require__(4);
var input_1 = __webpack_require__(39);
function getFormItemCss(item, validate, focus) {
    var _a;
    if (focus === void 0) { focus = false; }
    var labelPosition = item.labelPosition, required = item.required, disabled = item.disabled, hiddenLabel = item.hiddenLabel, $validationStatus = item.$validationStatus;
    var cssStatus = (_a = {},
        _a[types_1.ValidationStatus.pre] = "",
        _a[types_1.ValidationStatus.error] = " dhx_form-group--state_error",
        _a[types_1.ValidationStatus.success] = " dhx_form-group--state_success",
        _a)[$validationStatus] || "";
    var labelPositionCss = labelPosition === "left" ? " dhx_form-group--inline" : "";
    var requiredCss = required ? " dhx_form-group--required" : "";
    var disabledCss = disabled ? " dhx_form-group--disabled" : "";
    var labelSrCss = hiddenLabel ? " dhx_form-group--label_sr" : "";
    var focusStatus = focus ? "" : cssStatus;
    if (validate) {
        return labelPositionCss + focusStatus + requiredCss + disabledCss + labelSrCss;
    }
    return labelPositionCss + disabledCss + labelSrCss;
}
exports.getFormItemCss = getFormItemCss;
var validators = (_a = {},
    _a[input_1.Validation.validAlphaNumeric] = /^[a-zA-Z0-9_]+$/,
    _a[input_1.Validation.validEmail] = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
    _a[input_1.Validation.validInteger] = /^-?\d+$/,
    _a[input_1.Validation.validIPv4] = /\b((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\.|$)){4}\b/,
    _a[input_1.Validation.validNumeric] = /^-?\d+(\.\d+)?$/,
    _a);
function getValidationMessage(item) {
    var _a;
    var validationMessage = (_a = {
            undefined: item.preMessage
        },
        _a[types_1.ValidationStatus.pre] = item.preMessage,
        _a[types_1.ValidationStatus.error] = item.errorMessage,
        _a[types_1.ValidationStatus.success] = item.successMessage,
        _a)[item.$validationStatus] || "";
    return validationMessage;
}
exports.getValidationMessage = getValidationMessage;
function validateTemplate(template, str) {
    return validators[template] ? validators[template].test(str) : true;
}
exports.validateTemplate = validateTemplate;
function isBlock(config) {
    return config.type !== "fieldset" && (Boolean(config.rows) || Boolean(config.cols));
}
exports.isBlock = isBlock;
function validateInput(value, validation) {
    var isValid = true;
    if (typeof validation === "function") {
        isValid = validation(value);
    }
    else {
        var regExp = validators[validation];
        if (regExp) {
            isValid = regExp.test(value.toString());
        }
    }
    return isValid;
}
exports.validateInput = validateInput;
function baseInputValidate(value, config) {
    var inputType = config.inputType, min = config.min, max = config.max, minlength = config.minlength, maxlength = config.maxlength;
    if (inputType === "number") {
        if (typeof min !== "undefined" && typeof max !== "undefined") {
            return Number(min) <= Number(max) && Number(min) <= Number(value) && Number(max) >= Number(value);
        }
        else if (typeof min !== "undefined") {
            return Number(min) <= Number(value);
        }
        else if (typeof max !== "undefined") {
            return Number(max) >= Number(value);
        }
        else {
            return value === 0 || value === "0" || !!value;
        }
    }
    else {
        if (typeof minlength !== "undefined" && typeof maxlength !== "undefined") {
            return Number(minlength) <= String(value).length && Number(maxlength) >= String(value).length;
        }
        else if (typeof minlength !== "undefined") {
            return Number(minlength) <= String(value).length;
        }
        else if (typeof maxlength !== "undefined") {
            return Number(maxlength) >= String(value).length;
        }
        else {
            return typeof value === "string" && !!value;
        }
    }
}
exports.baseInputValidate = baseInputValidate;
function isTimeFormat(value, timeFormat) {
    if (timeFormat === 12) {
        return /(^0?([1-9][0-2]?):[0-5][0-9]?([AP][M]?)$)/i.test(value);
    }
    return /(^(0[0-9]|1[0-9]|2[0-3]|[0-9]):[0-5][0-9]$)/i.test(value);
}
exports.isTimeFormat = isTimeFormat;
function isVerify(config) {
    var validationProp = ["required", "validation", "minlength", "maxlength", "min", "max"];
    return validationProp.some(function (prop) {
        switch (prop) {
            case "required":
                return !!config[prop];
            case "validation":
                return (typeof config[prop] === "function" ||
                    config[prop] === "email" ||
                    config[prop] === "integer" ||
                    config[prop] === "numeric" ||
                    config[prop] === "alphanumeric" ||
                    config[prop] === "IPv4");
            case "minlength":
            case "maxlength":
                return typeof config[prop] === "number" || typeof config[prop] === "string";
            case "min":
            case "max":
                return ((typeof config[prop] === "number" || typeof config[prop] === "string") &&
                    config.inputType === "number");
        }
    });
}
exports.isVerify = isVerify;
exports.baseProps = ["width", "height", "padding", "css"];
var widgetConfig = function (_a) {
    var width = _a.width, type = _a.type, id = _a.id, name = _a.name, hidden = _a.hidden, editable = _a.editable, css = _a.css, required = _a.required, helpMessage = _a.helpMessage, preMessage = _a.preMessage, successMessage = _a.successMessage, errorMessage = _a.errorMessage, label = _a.label, labelWidth = _a.labelWidth, labelPosition = _a.labelPosition, hiddenLabel = _a.hiddenLabel, validation = _a.validation, icon = _a.icon, res = __rest(_a, ["width", "type", "id", "name", "hidden", "editable", "css", "required", "helpMessage", "preMessage", "successMessage", "errorMessage", "label", "labelWidth", "labelPosition", "hiddenLabel", "validation", "icon"]);
    return res;
};
exports.widgetConfig = widgetConfig;
function getFlatAttacments(arr, attachments, parent) {
    if (arr === void 0) { arr = []; }
    var items = [];
    for (var index = 0; index < arr.length; index++) {
        var conf = arr[index];
        if (conf.type) {
            attachments[conf.name].parent = parent;
            items.push(attachments[conf.name]);
        }
        if (isBlock(conf)) {
            items.push.apply(items, getFlatAttacments(conf.rows || conf.cols, attachments, parent));
        }
    }
    return items;
}
function setAttacments(attachments, layout) {
    var _a;
    for (var name_1 in attachments) {
        var item = attachments[name_1];
        if (item.config.type === "fieldset") {
            item.setAttachments(getFlatAttacments(item.config.rows || item.config.cols, attachments, item));
            item.setCell(layout.getCell(name_1));
        }
        else {
            (_a = layout.getCell(name_1)) === null || _a === void 0 ? void 0 : _a.attach(item);
        }
    }
}
exports.setAttacments = setAttacments;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(22), exports);
__exportStar(__webpack_require__(60), exports);
__exportStar(__webpack_require__(125), exports);
__exportStar(__webpack_require__(126), exports);
__exportStar(__webpack_require__(26), exports);
__exportStar(__webpack_require__(162), exports);
__exportStar(__webpack_require__(23), exports);
__exportStar(__webpack_require__(63), exports);
__exportStar(__webpack_require__(62), exports);
__exportStar(__webpack_require__(163), exports);
__exportStar(__webpack_require__(61), exports);
__exportStar(__webpack_require__(41), exports);


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.toViewLike = exports.View = void 0;
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(3);
var View = /** @class */ (function () {
    function View(_container, config) {
        var _a;
        this.config = config || {};
        this._uid = (_a = this.config.rootId) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
    }
    View.prototype.mount = function (container, vnode) {
        if (vnode) {
            this._view = vnode;
        }
        if (container && this._view && this._view.mount) {
            // init view inside of HTML container
            this._container = (0, html_1.toNode)(container);
            if (this._container.tagName) {
                this._view.mount(this._container);
            }
            else if (this._container.attach) {
                this._container.attach(this);
            }
        }
    };
    View.prototype.unmount = function () {
        var rootView = this.getRootView();
        if (rootView && rootView.node) {
            rootView.unmount();
            this._view = null;
        }
    };
    View.prototype.getRootView = function () {
        return this._view;
    };
    View.prototype.getRootNode = function () {
        return this._view && this._view.node && this._view.node.el;
    };
    View.prototype.paint = function () {
        if (this._view && // was mounted
            (this._view.node || // already rendered node
                this._container)) {
            // not rendered, but has container
            this._doNotRepaint = false;
            this._view.redraw();
        }
    };
    return View;
}());
exports.View = View;
function toViewLike(view) {
    return {
        getRootView: function () { return view; },
        paint: function () { return view.node && view.redraw(); },
        mount: function (container) { return view.mount(container); },
    };
}
exports.toViewLike = toViewLike;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Split = exports.GridSelectionEvents = exports.GridSystemEvents = exports.GridEvents = exports.HeaderFilterEvent = void 0;
var HeaderFilterEvent;
(function (HeaderFilterEvent) {
    HeaderFilterEvent["change"] = "change";
})(HeaderFilterEvent || (exports.HeaderFilterEvent = HeaderFilterEvent = {}));
var GridEvents;
(function (GridEvents) {
    GridEvents["scroll"] = "scroll";
    GridEvents["expand"] = "expand";
    GridEvents["filterChange"] = "filterChange";
    GridEvents["beforeFilter"] = "beforeFilter";
    GridEvents["beforeResizeStart"] = "beforeResizeStart";
    GridEvents["resize"] = "resize";
    GridEvents["afterResizeEnd"] = "afterResizeEnd";
    GridEvents["cellClick"] = "cellClick";
    GridEvents["cellRightClick"] = "cellRightClick";
    GridEvents["cellMouseOver"] = "cellMouseOver";
    GridEvents["cellMouseDown"] = "cellMouseDown";
    GridEvents["cellDblClick"] = "cellDblClick";
    GridEvents["headerCellClick"] = "headerCellClick";
    GridEvents["footerCellClick"] = "footerCellClick";
    GridEvents["headerCellMouseOver"] = "headerCellMouseOver";
    GridEvents["footerCellMouseOver"] = "footerCellMouseOver";
    GridEvents["headerCellMouseDown"] = "headerCellMouseDown";
    GridEvents["footerCellMouseDown"] = "footerCellMouseDown";
    GridEvents["headerCellDblClick"] = "headerCellDblClick";
    GridEvents["footerCellDblClick"] = "footerCellDblClick";
    GridEvents["headerCellRightClick"] = "headerCellRightClick";
    GridEvents["footerCellRightClick"] = "footerCellRightClick";
    GridEvents["beforeEditStart"] = "beforeEditStart";
    GridEvents["afterEditStart"] = "afterEditStart";
    GridEvents["beforeEditEnd"] = "beforeEditEnd";
    GridEvents["afterEditEnd"] = "afterEditEnd";
    GridEvents["beforeKeyDown"] = "beforeKeyDown";
    GridEvents["afterKeyDown"] = "afterKeyDown";
    GridEvents["beforeColumnHide"] = "beforeColumnHide";
    GridEvents["afterColumnHide"] = "afterColumnHide";
    GridEvents["beforeColumnShow"] = "beforeColumnShow";
    GridEvents["afterColumnShow"] = "afterColumnShow";
    GridEvents["beforeRowHide"] = "beforeRowHide";
    GridEvents["afterRowHide"] = "afterRowHide";
    GridEvents["beforeRowShow"] = "beforeRowShow";
    GridEvents["afterRowShow"] = "afterRowShow";
    GridEvents["beforeRowDrag"] = "beforeRowDrag";
    GridEvents["dragRowStart"] = "dragRowStart";
    GridEvents["dragRowOut"] = "dragRowOut";
    GridEvents["dragRowIn"] = "dragRowIn";
    GridEvents["canRowDrop"] = "canRowDrop";
    GridEvents["cancelRowDrop"] = "cancelRowDrop";
    GridEvents["beforeRowDrop"] = "beforeRowDrop";
    GridEvents["afterRowDrop"] = "afterRowDrop";
    GridEvents["afterRowDrag"] = "afterRowDrag";
    GridEvents["beforeColumnDrag"] = "beforeColumnDrag";
    GridEvents["dragColumnStart"] = "dragColumnStart";
    GridEvents["dragColumnOut"] = "dragColumnOut";
    GridEvents["dragColumnIn"] = "dragColumnIn";
    GridEvents["canColumnDrop"] = "canColumnDrop";
    GridEvents["cancelColumnDrop"] = "cancelColumnDrop";
    GridEvents["beforeColumnDrop"] = "beforeColumnDrop";
    GridEvents["afterColumnDrop"] = "afterColumnDrop";
    GridEvents["afterColumnDrag"] = "afterColumnDrag";
    GridEvents["beforeRowResize"] = "beforeRowResize";
    GridEvents["afterRowResize"] = "afterRowResize";
    GridEvents["beforeSort"] = "beforeSort";
    GridEvents["afterSort"] = "afterSort";
})(GridEvents || (exports.GridEvents = GridEvents = {}));
var GridSystemEvents;
(function (GridSystemEvents) {
    GridSystemEvents["cellTouchMove"] = "cellTouchMove";
    GridSystemEvents["cellTouchEnd"] = "cellTouchEnd";
    GridSystemEvents["headerCellTouchMove"] = "headerCellTouchMove";
    GridSystemEvents["headerCellTouchEnd"] = "headerCellTouchEnd";
})(GridSystemEvents || (exports.GridSystemEvents = GridSystemEvents = {}));
var GridSelectionEvents;
(function (GridSelectionEvents) {
    GridSelectionEvents["beforeUnSelect"] = "beforeUnSelect";
    GridSelectionEvents["afterUnSelect"] = "afterUnSelect";
    GridSelectionEvents["beforeSelect"] = "beforeSelect";
    GridSelectionEvents["afterSelect"] = "afterSelect";
})(GridSelectionEvents || (exports.GridSelectionEvents = GridSelectionEvents = {}));
var Split;
(function (Split) {
    Split["left"] = "leftSplit";
    Split["right"] = "rightSplit";
    Split["top"] = "topSplit";
    Split["bottom"] = "bottomSplit";
})(Split || (exports.Split = Split = {}));


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Label = void 0;
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(3);
var view_1 = __webpack_require__(8);
var ts_popup_1 = __webpack_require__(13);
var types_1 = __webpack_require__(4);
var Label = /** @class */ (function (_super) {
    __extends(Label, _super);
    function Label(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, container, config) || this;
        _this._handlers = __assign({ showHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.show(e.target, {
                    mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                    theme: e.target,
                });
            }, hideHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.hide();
            } }, _this._getHandlers());
        var render = function () { return _this._draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Label.prototype.setValidationStatus = function (state) {
        if (state === void 0) { state = "pre"; }
        this.config.$validationStatus = types_1.ValidationStatus[state];
    };
    Label.prototype._destructor = function () {
        this._helper && this._helper.destructor();
        this.config = this._handlers = this._helper = null;
        this.unmount();
    };
    Label.prototype._getHandlers = function () {
        return {};
    };
    Label.prototype._init = function () {
        return;
    };
    Label.prototype._draw = function () {
        return this._drawLabel();
    };
    Label.prototype._drawLabel = function () {
        var _a = this.config, id = _a.id, helpMessage = _a.helpMessage, required = _a.required;
        if (this.config.helpMessage) {
            if (this._helper) {
                this._helper.attachHTML(this.config.helpMessage);
            }
            else {
                this._helper = new ts_popup_1.Popup({
                    css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
                });
                this._helper.attachHTML(this.config.helpMessage);
            }
        }
        var labelStyle = (0, html_1.getLabelStyle)(this.config);
        return (labelStyle &&
            (0, dom_1.el)("".concat(this.config.type.includes("group") ? "legend" : "label", ".dhx_label"), {
                for: id || this._uid,
                class: helpMessage ? "dhx_label--with-help" : "",
                style: labelStyle.style,
            }, helpMessage
                ? [
                    (labelStyle.label || required) && (0, dom_1.el)("span.dhx_label__holder", labelStyle.label),
                    (0, dom_1.el)("span.dhx_label-help.dxi.dxi-help-circle-outline", {
                        tabindex: "0",
                        role: "button",
                        onclick: this._handlers.showHelper,
                        onfocus: this._handlers.showHelper,
                        onblur: this._handlers.hideHelper,
                        id: "dhx_label__help_".concat(id || this._uid),
                    }),
                ]
                : labelStyle.label));
    };
    return Label;
}(view_1.View));
exports.Label = Label;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(128), exports);
__exportStar(__webpack_require__(129), exports);
__exportStar(__webpack_require__(130), exports);
__exportStar(__webpack_require__(67), exports);
__exportStar(__webpack_require__(42), exports);


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(45), exports);
__exportStar(__webpack_require__(139), exports);
__exportStar(__webpack_require__(46), exports);


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(142), exports);
__exportStar(__webpack_require__(69), exports);


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyManager = void 0;
var FocusManager_1 = __webpack_require__(19);
var html_1 = __webpack_require__(3);
function getHotKeyCode(code) {
    var matches = code.toLowerCase().match(/\w+/g);
    var comp = 0;
    var key = "";
    for (var i = 0; i < matches.length; i++) {
        var check = matches[i];
        if (check === "ctrl") {
            comp += 4;
        }
        else if (check === "shift") {
            comp += 2;
        }
        else if (check === "alt") {
            comp += 1;
        }
        else {
            key = check;
        }
    }
    return comp + key;
}
var ie_key_map = {
    Up: "arrowUp",
    Down: "arrowDown",
    Right: "arrowRight",
    Left: "arrowLeft",
    Esc: "escape",
    Spacebar: "space",
};
var KeyManager = /** @class */ (function () {
    function KeyManager(beforeCall) {
        var _this = this;
        this._keysStorage = {};
        this._initHandler = function (e) {
            var key;
            if ((e.which >= 48 && e.which <= 57) || (e.which >= 65 && e.which <= 90)) {
                key = String.fromCharCode(e.which);
            }
            else {
                var keyName = e.which === 32 ? e.code : e.key;
                key = (0, html_1.isIE)() ? ie_key_map[keyName] || keyName : keyName;
            }
            var actions = _this._keysStorage[(e.ctrlKey || e.metaKey ? 4 : 0) +
                (e.shiftKey ? 2 : 0) +
                (e.altKey ? 1 : 0) +
                (key && key.toLowerCase())];
            if (actions) {
                for (var i = 0; i < actions.length; i++) {
                    if (_this._beforeCall && _this._beforeCall(e, FocusManager_1.focusManager.getFocusId()) === false) {
                        return;
                    }
                    actions[i].handler(e);
                }
            }
        };
        if (beforeCall) {
            this._beforeCall = beforeCall;
        }
        document.addEventListener("keydown", this._initHandler);
    }
    KeyManager.prototype.destructor = function () {
        document.removeEventListener("keydown", this._initHandler);
        this.removeHotKey();
    };
    KeyManager.prototype.addHotKey = function (key, handler) {
        var code = getHotKeyCode(key);
        if (!this._keysStorage[code]) {
            this._keysStorage[code] = [];
        }
        this._keysStorage[code].push({ handler: handler });
    };
    KeyManager.prototype.removeHotKey = function (key, handler) {
        var _this = this;
        if (key) {
            if (key && handler) {
                var code_1 = getHotKeyCode(key);
                var functionToString_1 = function (fun) {
                    return fun
                        .toString()
                        .replace(/\n/g, "")
                        .replace(/\s/g, "");
                };
                this._keysStorage[code_1].forEach(function (existHotKey, i) {
                    if (functionToString_1(existHotKey.handler) === functionToString_1(handler)) {
                        delete _this._keysStorage[code_1][i];
                        _this._keysStorage[code_1] = _this._keysStorage[code_1].filter(function (el) { return el; });
                    }
                });
            }
            else {
                var code = getHotKeyCode(key);
                delete this._keysStorage[code];
            }
        }
        else {
            this._keysStorage = {};
        }
    };
    KeyManager.prototype.exist = function (key) {
        var code = getHotKeyCode(key);
        return !!this._keysStorage[code];
    };
    KeyManager.prototype.getKeyStorageLength = function () {
        return Object.keys(this._keysStorage).length;
    };
    return KeyManager;
}());
exports.KeyManager = KeyManager;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.scrollFixedColsAndRows = exports.getTotalHeight = exports.getTotalWidth = exports.isHtmlEnable = exports.isTooltip = exports.isContentTooltip = exports.showTooltip = exports.isAutoWidth = exports.isSortable = exports.isRowEmpty = exports.isCssSupport = exports.removeHTMLTags = exports.getStyleByClass = exports.transpose = void 0;
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(3);
var ts_message_1 = __webpack_require__(11);
function transpose(arr, transform) {
    var columns = [];
    for (var i = 0; i < arr.length; i++) {
        var row = arr[i];
        for (var cellInd = 0; cellInd < row.length; cellInd++) {
            columns[cellInd] = columns[cellInd] || [];
            var cell = transform ? transform(row[cellInd]) : row[cellInd];
            columns[cellInd].push(cell);
        }
    }
    return columns;
}
exports.transpose = transpose;
function insert(node, newone) {
    if (typeof newone === "string") {
        node.insertAdjacentHTML("beforeend", newone);
        return node.lastChild;
    }
    else {
        node.appendChild(newone);
        return newone;
    }
}
function getStyleByClass(cssClass, container, targetClass, def) {
    var cont = container.querySelector("." + targetClass);
    var testDiv = insert(cont, "<div class=\"".concat(cssClass, "\"></div>"));
    var styles = window.getComputedStyle(testDiv);
    var result = {
        color: styles.color === "rgb(0, 0, 0)" ? def.color : (0, core_1.rgbToHex)(styles.color),
        background: styles.backgroundColor === "rgba(0, 0, 0, 0)" ? def.background : (0, core_1.rgbToHex)(styles.backgroundColor),
        fontSize: Math.round(parseFloat(styles.fontSize)),
        bold: ["bold", "700", "600", "500"].includes(styles.fontWeight),
    };
    cont.removeChild(testDiv);
    // [dirty]
    if (result.color === def.color &&
        result.background === def.background &&
        result.fontSize === def.fontSize) {
        return null;
    }
    return result;
}
exports.getStyleByClass = getStyleByClass;
function removeHTMLTags(str) {
    if (typeof str !== "string" && typeof str !== "number" && typeof str !== "boolean") {
        return "";
    }
    return "".concat(str === undefined || str === null ? "" : str)
        .replace(/<[^>]*>/g, "")
        .replace(/["]/g, "&quot;")
        .trim();
}
exports.removeHTMLTags = removeHTMLTags;
function isCssSupport(property, value) {
    try {
        return CSS.supports(property, value);
    }
    catch (err) {
        var el = document.createElement("div");
        el.style[property] = value;
        return el.style[property] === value;
    }
}
exports.isCssSupport = isCssSupport;
function isRowEmpty(row) {
    if (!row) {
        return;
    }
    return Object.keys(row).reduce(function (acc, col) {
        if (col === "id" || col.startsWith("$")) {
            return acc;
        }
        if (acc && row[col] !== undefined && row[col] !== "") {
            return;
        }
        return acc;
    }, true);
}
exports.isRowEmpty = isRowEmpty;
function isSortable(config, col) {
    return (col.sortable !== false && config.sortable) || col.sortable;
}
exports.isSortable = isSortable;
function isAutoWidth(config, col) {
    if (col) {
        return (col.autoWidth !== false && config.autoWidth) || col.autoWidth;
    }
    var check = false;
    config.columns.map(function (col) {
        if ((col.autoWidth !== false && config.autoWidth) || col.autoWidth) {
            check = true;
            return;
        }
    });
    return check;
}
exports.isAutoWidth = isAutoWidth;
function showTooltip(_a) {
    var node = _a.node, value = _a.value, _b = _a.htmlEnable, htmlEnable = _b === void 0 ? false : _b;
    if (!node)
        return;
    (0, ts_message_1.tooltip)(value.toString(), { css: "dhx_grid_tooltip", node: node, htmlEnable: htmlEnable });
}
exports.showTooltip = showTooltip;
function isContentTooltip(config, col, cell, type) {
    var isEnable = false;
    var cellProp = type === "header" ? config.headerTooltip : config.footerTooltip;
    var prop = [config.tooltip, cellProp, col.tooltip, cell === null || cell === void 0 ? void 0 : cell.tooltip];
    for (var index = 0; index < prop.length; index++) {
        if (typeof prop[index] === "boolean")
            isEnable = prop[index];
    }
    return isEnable;
}
exports.isContentTooltip = isContentTooltip;
function isTooltip(config, element) {
    return (element.tooltip !== false && config.tooltip) || element.tooltip;
}
exports.isTooltip = isTooltip;
function isHtmlEnable(config, col, content) {
    var _a, _b;
    return !!((_b = (_a = content === null || content === void 0 ? void 0 : content.htmlEnable) !== null && _a !== void 0 ? _a : col.htmlEnable) !== null && _b !== void 0 ? _b : config.htmlEnable);
}
exports.isHtmlEnable = isHtmlEnable;
function getTotalWidth(columns) {
    return columns.reduce(function (total, col) { return total + (col.$width || 0); }, 0);
}
exports.getTotalWidth = getTotalWidth;
function getTotalHeight(rows) {
    return rows.reduce(function (total, row) { return total + (row.$height || 0); }, 0);
}
exports.getTotalHeight = getTotalHeight;
function scrollFixedColsAndRows(e) {
    var grid = (0, html_1.locateNode)(e, "data-dhx-widget-id");
    var gridBody = grid.querySelector(".dhx_grid-body");
    var delta = e.deltaY;
    var position = e.shiftKey ? [delta, 0] : [0, delta];
    gridBody === null || gridBody === void 0 ? void 0 : gridBody.scrollBy.apply(gridBody, position);
}
exports.scrollFixedColsAndRows = scrollFixedColsAndRows;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DateHelper = exports.stringToDate = exports.getFormattedDate = exports.locale = void 0;
var core_1 = __webpack_require__(1);
var core_2 = __webpack_require__(1);
exports.locale = {
    monthsShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    months: [
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December",
    ],
    daysShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Monday"],
    cancel: "Cancel",
};
/*
    %d	day as a number with leading zero, 01..31
    %j	day as a number, 1..31
    %D	short name of the day, Su Mo Tu...
    %l	full name of the day, Sunday Monday Tuesday...
    %m	month as a number with leading zero, 01..12
    %n	month as a number, 1..12
    %M	short name of the month, Jan Feb Mar...
    %F	full name of the month, January February March...
    %y	year as a number, 2 digits
    %Y	year as a number, 4 digits
    %h	hours 12-format with leading zero, 01..12)
    %g	hours 12-format, 1..12)
    %H	hours 24-format with leading zero, 01..24
    %G	hours 24-format, 1..24
    %i	minutes with leading zero, 01..59
    %s	seconds with leading zero, 01..59
    %a	am or pm
    %A	AM or PM
    %u	milliseconds
*/
var formatters = {
    "%d": function (date) {
        var day = date.getDate();
        return day < 10 ? "0" + day : day;
    },
    "%j": function (date) { return date.getDate(); },
    "%l": function (date) {
        return exports.locale.days[date.getDay()];
    },
    "%D": function (date) {
        return exports.locale.daysShort[date.getDay()];
    },
    "%m": function (date) {
        var month = date.getMonth() + 1;
        return month < 10 ? "0" + month : month;
    },
    "%n": function (date) { return date.getMonth() + 1; },
    "%M": function (date) { return exports.locale.monthsShort[date.getMonth()]; },
    "%F": function (date) { return exports.locale.months[date.getMonth()]; },
    "%y": function (date) {
        return date
            .getFullYear()
            .toString()
            .slice(2);
    },
    "%Y": function (date) { return date.getFullYear(); },
    "%h": function (date) {
        var hours = date.getHours() % 12;
        if (hours === 0) {
            hours = 12;
        }
        return hours < 10 ? "0" + hours : hours;
    },
    "%g": function (date) {
        var hours = date.getHours() % 12;
        if (hours === 0) {
            hours = 12;
        }
        return hours;
    },
    "%H": function (date) {
        var hours = date.getHours();
        return hours < 10 ? "0" + hours : hours;
    },
    "%G": function (date) { return date.getHours(); },
    "%i": function (date) {
        var minutes = date.getMinutes();
        return minutes < 10 ? "0" + minutes : minutes;
    },
    "%s": function (date) {
        var seconds = date.getSeconds();
        return seconds < 10 ? "0" + seconds : seconds;
    },
    "%a": function (date) {
        return date.getHours() >= 12 ? "pm" : "am";
    },
    "%A": function (date) {
        return date.getHours() >= 12 ? "PM" : "AM";
    },
    "%u": function (date) { return date.getMilliseconds(); },
};
var setFormatters = {
    "%d": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setDate(Number(value)) : date.setDate(Number(1));
    },
    "%j": function (date, value, _format, validate) {
        var check = /(^([0-9]?[0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setDate(Number(value)) : date.setDate(Number(1));
    },
    "%m": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMonth(Number(value) - 1) : date.setMonth(Number(0));
        if (check && date.getMonth() !== Number(value) - 1)
            date.setMonth(Number(value) - 1);
    },
    "%n": function (date, value, _format, validate) {
        var check = /(^([0-9]?[0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMonth(Number(value) - 1) : date.setMonth(Number(0));
        if (check && date.getMonth() !== Number(value) - 1)
            date.setMonth(Number(value) - 1);
    },
    "%M": function (date, value, _format, validate) {
        var index = (0, core_2.findIndex)(exports.locale.monthsShort, function (v) { return v === value; });
        if (validate) {
            return index !== -1;
        }
        index === -1 ? date.setMonth(0) : date.setMonth(index);
        if (index !== -1 && date.getMonth() !== index)
            date.setMonth(index);
    },
    "%F": function (date, value, _format, validate) {
        var index = (0, core_2.findIndex)(exports.locale.months, function (v) { return v === value; });
        if (validate) {
            return index !== -1;
        }
        index === -1 ? date.setMonth(0) : date.setMonth(index);
        if (index !== -1 && date.getMonth() !== index)
            date.setMonth(index);
    },
    "%y": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setFullYear(Number("20" + value)) : date.setFullYear(Number("2000"));
    },
    "%Y": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9][0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setFullYear(Number(value)) : date.setFullYear(Number("2000"));
    },
    "%h": function (date, value, dateFormat, validate) {
        var check = /(^0[1-9]|1[0-2]$)/i.test(value);
        if (validate) {
            return check;
        }
        (check && (dateFormat === "am" || dateFormat === "pm")) || dateFormat === "AM" || dateFormat === "PM"
            ? date.setHours(Number(value))
            : date.setHours(Number(0));
    },
    "%g": function (date, value, dateFormat, validate) {
        var check = /(^[1-9]$)|(^0[1-9]|1[0-2]$)/i.test(value);
        if (validate) {
            return check;
        }
        (check && (dateFormat === "am" || dateFormat === "pm")) || dateFormat === "AM" || dateFormat === "PM"
            ? date.setHours(Number(value))
            : date.setHours(Number(0));
    },
    "%H": function (date, value, _format, validate) {
        var check = /(^[0-2][0-9]$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setHours(Number(value)) : date.setHours(Number(0));
    },
    "%G": function (date, value, _format, validate) {
        var check = /(^[1-9][0-9]?$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setHours(Number(value)) : date.setHours(Number(0));
    },
    "%i": function (date, value, _format, validate) {
        var check = /(^([0-5][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMinutes(Number(value)) : date.setMinutes(Number(0));
    },
    "%s": function (date, value, _format, validate) {
        var check = /(^([0-5][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setSeconds(Number(value)) : date.setSeconds(Number(0));
    },
    "%u": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMilliseconds(Number(value)) : date.setMilliseconds(Number(0));
    },
    "%a": function (date, value, _format, validate) {
        if (validate) {
            return value === "pm" || value === "am";
        }
        value === "pm" && date.setHours(date.getHours() + 12);
    },
    "%A": function (date, value, _format, validate) {
        if (validate) {
            return value === "PM" || value === "AM";
        }
        value === "PM" && date.setHours(date.getHours() + 12);
    },
};
var TokenType;
(function (TokenType) {
    TokenType[TokenType["separator"] = 0] = "separator";
    TokenType[TokenType["datePart"] = 1] = "datePart";
})(TokenType || (TokenType = {}));
function tokenizeFormat(format) {
    var tokens = [];
    var currentSeparator = "";
    for (var i = 0; i < format.length; i++) {
        if (format[i] === "%") {
            if (currentSeparator.length > 0) {
                tokens.push({
                    type: TokenType.separator,
                    value: currentSeparator,
                });
                currentSeparator = "";
            }
            tokens.push({
                type: TokenType.datePart,
                value: format[i] + format[i + 1],
            });
            i++;
        }
        else {
            currentSeparator += format[i];
        }
    }
    if (currentSeparator.length > 0) {
        tokens.push({
            type: TokenType.separator,
            value: currentSeparator,
        });
    }
    return tokens;
}
function getFormattedDate(format, date) {
    return tokenizeFormat(format).reduce(function (res, token) {
        if (token.type === TokenType.separator) {
            return res + token.value;
        }
        else {
            if (!formatters[token.value]) {
                return res;
            }
            return res + formatters[token.value](date);
        }
    }, "");
}
exports.getFormattedDate = getFormattedDate;
function stringToDate(str, format, validate) {
    if (typeof str !== "string") {
        return;
    }
    format = format.replace(/(?<=[a-z])%a/i, function (match) {
        str = str.replace(/(am|pm)/i, " $&");
        return " " + match;
    });
    var tokens = tokenizeFormat(format);
    var dateParts = [];
    var index = 0;
    var formatter = null;
    var message = "Incorrect date, see docs: https://docs.dhtmlx.com/suite/calendar__api__calendar_dateformat_config.html";
    for (var i = 0; i < tokens.length; i++) {
        if (tokens[i].type === TokenType.separator) {
            var sepratorIndex = str.indexOf(tokens[i].value, index);
            if (sepratorIndex === -1) {
                if (validate) {
                    return false;
                }
                throw new Error(message);
            }
            if (formatter) {
                dateParts.push({
                    formatter: formatter,
                    value: str.slice(index, sepratorIndex),
                });
                formatter = null;
            }
            index = sepratorIndex + tokens[i].value.length;
        }
        else if (tokens[i].type === TokenType.datePart) {
            if (tokens[i + 1] && tokens[i + 1].type !== TokenType.separator) {
                if (validate) {
                    return false;
                }
                throw new Error(message);
            }
            else {
                formatter = tokens[i].value;
            }
        }
    }
    if (formatter === "%A" || formatter === "%a") {
        dateParts.unshift({
            formatter: formatter,
            value: str.slice(index),
        });
    }
    else if (formatter) {
        dateParts.push({
            formatter: formatter,
            value: str.slice(index),
        });
    }
    dateParts.reverse();
    var dateFormat;
    for (var _i = 0, dateParts_1 = dateParts; _i < dateParts_1.length; _i++) {
        var datePart = dateParts_1[_i];
        if (datePart.formatter === "%A" || datePart.formatter === "%a") {
            dateFormat = datePart.value;
        }
    }
    var date = new Date(0);
    for (var _a = 0, dateParts_2 = dateParts; _a < dateParts_2.length; _a++) {
        var datePart = dateParts_2[_a];
        if (setFormatters[datePart.formatter]) {
            if (validate && !setFormatters[datePart.formatter](date, datePart.value, dateFormat, validate)) {
                return false;
            }
            setFormatters[datePart.formatter](date, datePart.value, dateFormat);
        }
    }
    return validate ? true : date;
}
exports.stringToDate = stringToDate;
var DateHelper = exports.DateHelper = /** @class */ (function () {
    function DateHelper() {
    }
    DateHelper.copy = function (d) {
        return new Date(d);
    };
    DateHelper.fromYear = function (year) {
        return new Date(year, 0, 1);
    };
    DateHelper.fromYearAndMonth = function (year, month) {
        return new Date(year, month, 1);
    };
    DateHelper.weekStart = function (d, firstWeekday) {
        var diff = (d.getDay() + 7 - firstWeekday) % 7;
        return new Date(d.getFullYear(), d.getMonth(), d.getDate() - diff);
    };
    DateHelper.monthStart = function (d) {
        return new Date(d.getFullYear(), d.getMonth(), 1);
    };
    DateHelper.yearStart = function (d) {
        return new Date(d.getFullYear(), 0, 1);
    };
    DateHelper.dayStart = function (d) {
        return new Date(d.getFullYear(), d.getMonth(), d.getDate());
    };
    DateHelper.addDay = function (d, count) {
        if (count === void 0) { count = 1; }
        return new Date(d.getFullYear(), d.getMonth(), d.getDate() + count);
    };
    DateHelper.addMonth = function (d, count) {
        if (count === void 0) { count = 1; }
        return new Date(d.getFullYear(), d.getMonth() + count);
    };
    DateHelper.addYear = function (d, count) {
        if (count === void 0) { count = 1; }
        return new Date(d.getFullYear() + count, d.getMonth());
    };
    DateHelper.withHoursAndMinutes = function (d, hours, minutes, dateFormat) {
        if (dateFormat === undefined || (!dateFormat && hours === 12) || (dateFormat && hours !== 12)) {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate(), hours, minutes);
        }
        else if (dateFormat && hours === 12) {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate(), 0, minutes);
        }
        else {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate(), hours + 12, minutes);
        }
    };
    DateHelper.setMonth = function (d, month) {
        d.setMonth(month);
    };
    DateHelper.setYear = function (d, year) {
        d.setFullYear(year);
    };
    DateHelper.mergeHoursAndMinutes = function (source, target) {
        return new Date(source.getFullYear(), source.getMonth(), source.getDate(), target.getHours(), target.getMinutes());
    };
    DateHelper.isWeekEnd = function (d) {
        return d.getDay() === 0 || d.getDay() === 6;
    };
    DateHelper.getTwelweYears = function (d) {
        var y = d.getFullYear();
        var firstYear = y - (y % 12);
        return (0, core_1.range)(firstYear, firstYear + 11);
    };
    DateHelper.getDayOrdinal = function (d) {
        var dayMS = 24 * 60 * 60 * 1000;
        return (d.valueOf() - DateHelper.yearStart(d).valueOf()) / dayMS;
    };
    DateHelper.getWeekNumber = function (d) {
        var currThursday = d.getDay() === 4 ? d : DateHelper.addDay(d, 4 - d.getDay());
        var ordinal = DateHelper.getDayOrdinal(currThursday);
        return Math.trunc(ordinal / 7) + 1;
    };
    DateHelper.isSameDay = function (d1, d2) {
        return (d1.getFullYear() === d2.getFullYear() &&
            d1.getMonth() === d2.getMonth() &&
            d1.getDate() === d2.getDate());
    };
    DateHelper.toDateObject = function (date, dateFormat) {
        if (typeof date === "string") {
            return stringToDate(date, dateFormat);
        }
        else {
            return new Date(date);
        }
    };
    DateHelper.nullTimestampDate = new Date(0);
    return DateHelper;
}());


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, setImmediate) {(function () {
  global = typeof window !== 'undefined' ? window : this

  var queueId = 1
  var queue = {}
  var isRunningTask = false

  if (!global.setImmediate)
    global.addEventListener('message', function (e) {
      if (e.source == global){
        if (isRunningTask)
          nextTick(queue[e.data])
        else {
          isRunningTask = true
          try {
            queue[e.data]()
          } catch (e) {}

          delete queue[e.data]
          isRunningTask = false
        }
      }
    })

  function nextTick(fn) {
    if (global.setImmediate) setImmediate(fn)
    // if inside of web worker
    else if (global.importScripts) setTimeout(fn)
    else {
      queueId++
      queue[queueId] = fn
      global.postMessage(queueId, '*')
    }
  }

  Deferred.resolve = function (value) {
    if (!(this._d == 1))
      throw TypeError()

    if (value instanceof Deferred)
      return value

    return new Deferred(function (resolve) {
        resolve(value)
    })
  }

  Deferred.reject = function (value) {
    if (!(this._d == 1))
      throw TypeError()

    return new Deferred(function (resolve, reject) {
        reject(value)
    })
  }

  Deferred.all = function (arr) {
    if (!(this._d == 1))
      throw TypeError()

    if (!(arr instanceof Array))
      return Deferred.reject(TypeError())

    var d = new Deferred()

    function done(e, v) {
      if (v)
        return d.resolve(v)

      if (e)
        return d.reject(e)

      var unresolved = arr.reduce(function (cnt, v) {
        if (v && v.then)
          return cnt + 1
        return cnt
      }, 0)

      if(unresolved == 0)
        d.resolve(arr)

      arr.map(function (v, i) {
        if (v && v.then)
          v.then(function (r) {
            arr[i] = r
            done()
            return r
          }, done)
      })
    }

    done()

    return d
  }

  Deferred.race = function (arr) {
    if (!(this._d == 1))
      throw TypeError()

    if (!(arr instanceof Array))
      return Deferred.reject(TypeError())

    if (arr.length == 0)
      return new Deferred()

    var d = new Deferred()

    function done(e, v) {
      if (v)
        return d.resolve(v)

      if (e)
        return d.reject(e)

      var unresolved = arr.reduce(function (cnt, v) {
        if (v && v.then)
          return cnt + 1
        return cnt
      }, 0)

      if(unresolved == 0)
        d.resolve(arr)

      arr.map(function (v, i) {
        if (v && v.then)
          v.then(function (r) {
            done(null, r)
          }, done)
      })
    }

    done()

    return d
  }

  Deferred._d = 1


  /**
   * @constructor
   */
  function Deferred(resolver) {
    'use strict'
    if (typeof resolver != 'function' && resolver != undefined)
      throw TypeError()

    if (typeof this != 'object' || (this && this.then))
      throw TypeError()

    // states
    // 0: pending
    // 1: resolving
    // 2: rejecting
    // 3: resolved
    // 4: rejected
    var self = this,
      state = 0,
      val = 0,
      next = [],
      fn, er;

    self['promise'] = self

    self['resolve'] = function (v) {
      fn = self.fn
      er = self.er
      if (!state) {
        val = v
        state = 1

        nextTick(fire)
      }
      return self
    }

    self['reject'] = function (v) {
      fn = self.fn
      er = self.er
      if (!state) {
        val = v
        state = 2

        nextTick(fire)

      }
      return self
    }

    self['_d'] = 1

    self['then'] = function (_fn, _er) {
      if (!(this._d == 1))
        throw TypeError()

      var d = new Deferred()

      d.fn = _fn
      d.er = _er
      if (state == 3) {
        d.resolve(val)
      }
      else if (state == 4) {
        d.reject(val)
      }
      else {
        next.push(d)
      }

      return d
    }

    self['catch'] = function (_er) {
      return self['then'](null, _er)
    }

    var finish = function (type) {
      state = type || 4
      next.map(function (p) {
        state == 3 && p.resolve(val) || p.reject(val)
      })
    }

    try {
      if (typeof resolver == 'function')
        resolver(self['resolve'], self['reject'])
    } catch (e) {
      self['reject'](e)
    }

    return self

    // ref : reference to 'then' function
    // cb, ec, cn : successCallback, failureCallback, notThennableCallback
    function thennable (ref, cb, ec, cn) {
      // Promises can be rejected with other promises, which should pass through
      if (state == 2) {
        return cn()
      }
      if ((typeof val == 'object' || typeof val == 'function') && typeof ref == 'function') {
        try {

          // cnt protects against abuse calls from spec checker
          var cnt = 0
          ref.call(val, function (v) {
            if (cnt++) return
            val = v
            cb()
          }, function (v) {
            if (cnt++) return
            val = v
            ec()
          })
        } catch (e) {
          val = e
          ec()
        }
      } else {
        cn()
      }
    };

    function fire() {

      // check if it's a thenable
      var ref;
      try {
        ref = val && val.then
      } catch (e) {
        val = e
        state = 2
        return fire()
      }

      thennable(ref, function () {
        state = 1
        fire()
      }, function () {
        state = 2
        fire()
      }, function () {
        try {
          if (state == 1 && typeof fn == 'function') {
            val = fn(val)
          }

          else if (state == 2 && typeof er == 'function') {
            val = er(val)
            state = 1
          }
        } catch (e) {
          val = e
          return finish()
        }

        if (val == self) {
          val = TypeError()
          finish()
        } else thennable(ref, function () {
            finish(3)
          }, finish, function () {
            finish(state == 1 && 3)
          })

      })
    }


  }

  // Export our library object, either for node.js or as a globally scoped variable
  if (true) {
    module['exports'] = Deferred
  } else {}
})()

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(40), __webpack_require__(117).setImmediate))

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValueForNumberColumn = exports.getEditorOptions = exports.toFormat = exports.getMaxColsWidth = exports.getTreeCellWidthOffset = exports.getCalculatedRowHeight = exports.getMaxRowHeight = exports.getUnique = exports.calculatePositions = exports.countColumns = exports.measureTextHeight = exports.normalizeArray = void 0;
var core_1 = __webpack_require__(1);
var main_1 = __webpack_require__(15);
var date_1 = __webpack_require__(16);
function normalizeArray(obj, name) {
    if (!obj[name]) {
        return;
    }
    if (typeof obj[name] === "string") {
        obj[name] = [
            {
                text: "".concat(obj[name]),
            },
        ];
    }
    else {
        obj[name] = obj[name].map(function (el) {
            if (typeof el === "string") {
                el = { text: el };
            }
            return el;
        });
    }
}
exports.normalizeArray = normalizeArray;
function measureTextHeight(_a) {
    var _b = _a.text, text = _b === void 0 ? "" : _b, _c = _a.width, width = _c === void 0 ? 0 : _c, _d = _a.lineHeight, lineHeight = _d === void 0 ? 20 : _d, _e = _a.font, font = _e === void 0 ? "14px Arial" : _e, _f = _a.htmlEnable, htmlEnable = _f === void 0 ? false : _f;
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = font;
    var defaultLineBreak = [];
    var mathLineBreak = [];
    if (htmlEnable)
        text = (0, main_1.removeHTMLTags)(text);
    var lineBreak = Math.ceil(ctx.measureText(text).width / width);
    if (lineBreak > 1)
        lineBreak = (0, core_1.getTextLines)(ctx, text, width).length;
    mathLineBreak.push(lineBreak);
    defaultLineBreak.push(text.split("\n").length);
    var maxRows = Math.max((0, core_1.getMaxArrayNumber)(defaultLineBreak), (0, core_1.getMaxArrayNumber)(mathLineBreak));
    canvas.remove();
    return maxRows * lineHeight;
}
exports.measureTextHeight = measureTextHeight;
function countColumns(config, columns) {
    var headerRowsCount = 0;
    var footerRowsCount = 0;
    var totalWidth = 0;
    var colspans = false;
    var rowsHeadersCount = 0;
    var footer = false;
    columns.forEach(function (col) {
        headerRowsCount = Math.max(headerRowsCount, col.header.length);
        totalWidth += col.$width;
        if (col.footer) {
            footerRowsCount = Math.max(footerRowsCount, col.footer.length);
            if (!footer) {
                footer = true;
            }
        }
        if (!colspans) {
            for (var _i = 0, _a = col.header; _i < _a.length; _i++) {
                var head = _a[_i];
                if (head.colspan) {
                    colspans = true;
                    return;
                }
            }
        }
    });
    // fill missing cells
    columns.forEach(function (col) {
        if (footer) {
            col.footer = col.footer || [];
        }
        if (col.header.length < headerRowsCount) {
            for (var i = 0; i < headerRowsCount; i++) {
                col.header[i] = col.header[i] || { text: "" };
            }
        }
        if (col.footer) {
            if (col.footer.length < footerRowsCount) {
                for (var i = 0; i < footerRowsCount; i++) {
                    col.footer[i] = col.footer[i] || { text: "" };
                }
            }
            for (var i = 0; i < col.footer.length; i++) {
                if (!col.footer[i].id)
                    col.footer[i].id = (0, core_1.uid)();
            }
        }
        col.header = col.header.map(function (head) {
            if (typeof head !== "object") {
                head = { text: head };
            }
            head.css = head.css || "";
            if (!head.text && !head.css.includes("dhx_cell-empty")) {
                head.css += " dhx_cell-empty";
            }
            if (!head.id)
                head.id = (0, core_1.uid)();
            return head;
        });
        // find header columns indexes
        if (col.header[0].text === "") {
            rowsHeadersCount++;
        }
    });
    config.$totalWidth = totalWidth;
    config.$colspans = colspans;
    config.$footer = footer;
    return rowsHeadersCount;
}
exports.countColumns = countColumns;
function calculatePositions(width, height, scroll, conf, data) {
    var _a, _b, _c;
    var columns = conf.columns || [];
    var columnsLength = columns.length;
    var rows = data || [];
    var rowsLength = rows.length;
    var leftSplit = conf.leftSplit
        ? conf.columns.slice(0, conf.leftSplit).filter(function (col) { return !col.hidden; }).length
        : 0;
    var topSplit = (_a = conf.topSplit) !== null && _a !== void 0 ? _a : 0;
    var rightSplit = (_b = conf.rightSplit) !== null && _b !== void 0 ? _b : 0;
    var bottomSplit = (_c = conf.bottomSplit) !== null && _c !== void 0 ? _c : 0;
    var x = 0;
    var scrollLeft = scroll.left;
    var avrColWidth = conf.$totalWidth / columnsLength;
    for (var i = 0; i < columnsLength; i++) {
        var col = columns[i];
        if (col.hidden)
            continue;
        scrollLeft = scrollLeft - col.$width;
        if (scrollLeft + avrColWidth / 2 > 0) {
            x++;
        }
        else {
            break;
        }
    }
    var y = 0;
    var scrollTop = scroll.top;
    var avrRowHeight = conf.$totalHeight / rowsLength;
    for (var i = 0; i < rowsLength; i++) {
        var row = rows[i];
        if (row.hidden)
            continue;
        scrollTop = scrollTop - row.$height;
        if (scrollTop + avrRowHeight / 2 > 0) {
            y++;
        }
        else {
            break;
        }
    }
    var sizeByWidth = 0;
    var itemsTotalByWidth = 0;
    var maxWidth = -Infinity;
    var minWidth = +Infinity;
    for (var index = 0; index < columnsLength; index++) {
        var column = columns[index];
        if (index >= x && sizeByWidth < width && !column.hidden) {
            sizeByWidth += column.$width;
            itemsTotalByWidth++;
        }
        if (column.$width > maxWidth)
            maxWidth = column.$width;
        if (column.$width < minWidth)
            minWidth = column.$width;
    }
    var sizeByHeight = 0;
    var itemsTotalByHeight = 0;
    var maxHeight = -Infinity;
    var minHeight = +Infinity;
    for (var index = 0; index < rowsLength; index++) {
        var row = rows[index];
        if (index >= y && sizeByHeight < height && !row.hidden) {
            sizeByHeight += row.$height;
            itemsTotalByHeight++;
        }
        if (row.$height > maxHeight)
            maxHeight = row.$height;
        if (row.$height < minHeight)
            minHeight = row.$height;
    }
    minHeight = minHeight < conf.rowHeight ? minHeight : conf.rowHeight;
    var xReserve = Math.round(maxWidth / minWidth);
    var yReserve = Math.round(maxHeight / minHeight);
    var xStart = x - xReserve >= leftSplit ? x - xReserve : leftSplit;
    var xTotal = x + itemsTotalByWidth + xReserve;
    var leftSplitHidden = (conf.leftSplit || 0) - leftSplit;
    var colIndexStartSplit = columns.length - rightSplit - leftSplitHidden;
    var xEnd = xTotal < colIndexStartSplit ? xTotal : colIndexStartSplit;
    var yStart = y - yReserve >= topSplit ? y - yReserve : topSplit;
    var yTotal = y + itemsTotalByHeight + yReserve;
    var rowIndexStartSplit = rows.length - bottomSplit;
    var yEnd = yTotal < rowIndexStartSplit ? yTotal : rowIndexStartSplit;
    return {
        xStart: xStart,
        xEnd: xEnd,
        yStart: yStart,
        yEnd: yEnd,
    };
}
exports.calculatePositions = calculatePositions;
function getUnique(arr, name, multiselection) {
    var allItems = arr.map(function (item) { return item[name]; });
    if (multiselection) {
        allItems.forEach(function (item, index) {
            if (typeof item === "string" && item.includes(", ")) {
                item.split(", ").forEach(function (i) { return allItems.push(i); });
                delete allItems[index];
            }
        });
    }
    return allItems.filter(function (item, i, array) { return array.indexOf(item) === i && (0, core_1.isDefined)(item); }).sort();
}
exports.getUnique = getUnique;
var getMaxRowHeight = function (row, cols, config) {
    var _a, _b;
    if (config === void 0) { config = { font: "14px Arial", lineHeight: 20 }; }
    var HORIZONTAL_OFFSET = 24;
    var VERTICAL_OFFSET = 8;
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = config.font;
    var definedColumns = {};
    var colLength = cols.length;
    for (var index = 0; index < colLength; index++) {
        if (cols[index].template) {
            definedColumns[cols[index].id] = {
                width: cols[index].$width - HORIZONTAL_OFFSET || 0,
                htmlEnable: cols[index].htmlEnable,
                template: cols[index].template,
                cols: cols[index],
            };
        }
        else {
            definedColumns[cols[index].id] = {
                width: cols[index].$width - HORIZONTAL_OFFSET || 0,
                htmlEnable: cols[index].htmlEnable,
            };
        }
    }
    var defaultLineBreak = [];
    var mathLineBreak = [];
    for (var _i = 0, _c = Object.entries(row); _i < _c.length; _i++) {
        var _d = _c[_i], key = _d[0], value = _d[1];
        if (definedColumns[key] &&
            key !== "id" &&
            key !== "height" &&
            !key.startsWith("$") &&
            (typeof value === "string" ||
                typeof value === "number" ||
                value instanceof Date ||
                Array.isArray(value))) {
            var currentValue = "";
            if ((_a = definedColumns[key]) === null || _a === void 0 ? void 0 : _a.template) {
                var templateValue = definedColumns[key].template(value, row, definedColumns[key].cols);
                currentValue = definedColumns[key].htmlEnable ? (0, main_1.removeHTMLTags)(templateValue) : templateValue;
            }
            else if (typeof value === "string") {
                if (definedColumns[key].htmlEnable) {
                    currentValue = (0, main_1.removeHTMLTags)(value);
                }
                else {
                    currentValue = value;
                }
            }
            else {
                currentValue = value.toString();
            }
            var lineBreak = Math.ceil(ctx.measureText(currentValue).width / definedColumns[key].width);
            if (lineBreak > 1) {
                lineBreak = (0, core_1.getTextLines)(ctx, currentValue, (_b = definedColumns[key]) === null || _b === void 0 ? void 0 : _b.width).length;
            }
            mathLineBreak.push(lineBreak);
            defaultLineBreak.push(currentValue.split("\n").length);
        }
    }
    var maxRows = Math.max((0, core_1.getMaxArrayNumber)(defaultLineBreak), (0, core_1.getMaxArrayNumber)(mathLineBreak));
    canvas.remove();
    return maxRows * config.lineHeight + VERTICAL_OFFSET;
};
exports.getMaxRowHeight = getMaxRowHeight;
var getCalculatedRowHeight = function (height, config) {
    config = __assign({ rowHeight: 40, padding: 12 }, config);
    var calculateHeight = config.rowHeight < 40 ? height : height + config.padding * 2;
    return height < config.rowHeight ? config.rowHeight : calculateHeight;
};
exports.getCalculatedRowHeight = getCalculatedRowHeight;
var getTreeCellWidthOffset = function (row) {
    return 20 + row.$level * 20 - (row.$items ? 20 : 0);
};
exports.getTreeCellWidthOffset = getTreeCellWidthOffset;
var getMaxColsWidth = function (rows, cols, config, target) {
    if (config === void 0) { config = {
        font: "normal 14.4px Arial",
    }; }
    if (!rows.length || !cols.length)
        return;
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = config.font;
    var definedColumns = {};
    var colLength = cols.length;
    for (var index = 0; index < colLength; index++) {
        var col = cols[index];
        var template = col.template, htmlEnable = col.htmlEnable, format = col.format, id = col.id, type = col.type;
        if (template && target === "data") {
            definedColumns[id] = {
                width: 20,
                htmlEnable: !!htmlEnable,
                template: template,
                cols: col,
                type: type,
            };
        }
        else {
            definedColumns[id] = {
                width: 20,
                htmlEnable: !!htmlEnable,
                format: type === "date" ? format || "%M %d %Y" : format,
                type: type,
            };
        }
    }
    var rowsLength = rows.length;
    for (var index = 0; index < rowsLength; index++) {
        for (var _i = 0, _a = Object.entries(rows[index]); _i < _a.length; _i++) {
            var _b = _a[_i], key = _b[0], value = _b[1];
            var definedCol = definedColumns[key];
            if (definedCol &&
                key !== "id" &&
                key !== "height" &&
                !key.startsWith("$") &&
                (typeof value === "string" ||
                    typeof value === "number" ||
                    value instanceof Date ||
                    Array.isArray(value))) {
                var template = definedCol.template, cols_1 = definedCol.cols, format = definedCol.format, type = definedCol.type, htmlEnable = definedCol.htmlEnable, colWidth = definedCol.width;
                var currentValue = void 0;
                if (typeof template === "function") {
                    var templateValue = template(value, rows[index], cols_1);
                    currentValue = htmlEnable ? (0, main_1.removeHTMLTags)(templateValue) : templateValue;
                }
                else {
                    currentValue = htmlEnable ? (0, main_1.removeHTMLTags)(value) : value.toString();
                }
                var date = format && type === "date" && new Date(currentValue);
                if (date === null || date === void 0 ? void 0 : date.valueOf()) {
                    currentValue = (0, date_1.getFormattedDate)(format, date);
                }
                var width = ctx.measureText(currentValue).width;
                if (width > colWidth)
                    definedColumns[key].width = width;
            }
        }
    }
    canvas.remove();
    var totalColumns = {};
    for (var _c = 0, _d = Object.entries(definedColumns); _c < _d.length; _c++) {
        var _e = _d[_c], key = _e[0], value = _e[1];
        totalColumns[key] = Math.ceil(value.width);
    }
    return totalColumns;
};
exports.getMaxColsWidth = getMaxColsWidth;
function toFormat(value, type, format) {
    if (typeof value === "boolean") {
        return value;
    }
    if (!value && typeof value !== "number") {
        return value;
    }
    var formatTemplate = function (type) {
        var result;
        var fractional;
        var delimiter;
        var template = format
            .replace(/#+/g, "#")
            .split("#")
            .filter(function (i) { return i; });
        var formatFractionLength = format.match(/0/g) && format.match(/0/g).length;
        value = (type === "percent" ? Number(value) * 100 : value).toString();
        var truncNumber = Math.trunc(Number(value));
        if (formatFractionLength) {
            var truncFractional = value.split(".")[1] || "0";
            delimiter = template.find(function (i) { return i.includes("0"); }).replace(/0+/g, "");
            fractional = Number("0." + truncFractional).toFixed(formatFractionLength);
            if (Number(fractional) >= 1) {
                truncNumber++;
            }
            fractional = fractional
                .toString()
                .split(".")[1]
                .padEnd(formatFractionLength, "0");
        }
        var trunc = "".concat(value < 0 && Math.abs(truncNumber) === 0 ? "-" : "").concat(truncNumber);
        var truncTemplate = template.find(function (i) { return !i.includes("0"); });
        result = truncTemplate ? trunc.replace(/(\d)(?=(\d{3})+(\D|$))/g, "$1".concat(truncTemplate)) : trunc;
        result += (delimiter || "") + (fractional || "");
        return type === "percent" ? "".concat(result, "%") : result;
    };
    switch (type) {
        case "number":
            return format && !isNaN(Number(value)) ? formatTemplate(type) : value;
        case "percent":
            if (!format)
                format = "#";
            return !isNaN(Number(value)) ? formatTemplate(type) : value;
        case "date":
            if (!format)
                format = "%M %d %Y";
            if (typeof value === "string") {
                value = (0, date_1.getFormattedDate)(format, (0, date_1.stringToDate)(value, format));
            }
            else if (typeof value === "object") {
                value = (0, date_1.getFormattedDate)(format, value);
            }
            return value;
        default:
            return value;
    }
}
exports.toFormat = toFormat;
function getEditorOptions(col, row) {
    return __spreadArray(__spreadArray([], ((typeof col.options === "function" ? col.options(col, row) : col.options) || []), true), (col.$customOptions || []), true);
}
exports.getEditorOptions = getEditorOptions;
function getValueForNumberColumn(col, value) {
    if (!(0, core_1.isDefined)(value) ||
        value === "" ||
        typeof value === "number" ||
        ["select", "combobox", "multiselect"].includes(col.editorType)) {
        return value;
    }
    else if (typeof value === "string") {
        return parseFloat(value);
    }
    else {
        return NaN;
    }
}
exports.getValueForNumberColumn = getValueForNumberColumn;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.focusManager = void 0;
var html_1 = __webpack_require__(3);
var FocusManager = /** @class */ (function () {
    function FocusManager() {
        var _this = this;
        this._initHandler = function (e) { return (_this._activeWidgetId = (0, html_1.locate)(e, "data-dhx-widget-id")); };
        this._removeFocusClass = function (e) {
            var classList = document.body.classList;
            if (classList.contains("utilityfocus"))
                classList.remove("utilityfocus");
        };
        this._addFocusClass = function (e) {
            var classList = document.body.classList;
            if (e.code === "Tab") {
                if (!classList.contains("utilityfocus"))
                    classList.add("utilityfocus");
            }
            else {
                if (classList.contains("utilityfocus"))
                    classList.remove("utilityfocus");
            }
        };
        document.addEventListener("focusin", this._initHandler);
        document.addEventListener("pointerdown", this._initHandler);
        document.addEventListener("mousedown", this._removeFocusClass);
        document.addEventListener("keydown", this._addFocusClass);
    }
    FocusManager.prototype.getFocusId = function () {
        return this._activeWidgetId;
    };
    FocusManager.prototype.setFocusId = function (id) {
        this._activeWidgetId = id;
    };
    return FocusManager;
}());
exports.focusManager = new FocusManager();


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ScrollView = exports.scrollViewConfig = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(3);
exports.scrollViewConfig = {
    enable: false,
    autoHide: true,
    timeout: 1000,
    scrollHandler: function () { },
};
var ScrollView = /** @class */ (function () {
    function ScrollView(getRootView, config) {
        var _a;
        if (config === void 0) { config = {}; }
        var _this = this;
        this.config = (0, core_1.extend)({
            enable: exports.scrollViewConfig.enable,
            autoHide: exports.scrollViewConfig.autoHide,
            timeout: exports.scrollViewConfig.timeout,
            scrollHandler: exports.scrollViewConfig.scrollHandler,
        }, config);
        this._wheelName = (0, html_1.isIE)() ? "onmousewheel" : "onwheel";
        this._getRootView = getRootView;
        this._scrollYTop = this._scrollXLeft = this._runnerYTop = this._runnerXLeft = this._runnerHeight = this._runnerWidth = 0;
        this._visibleYArea = this._visibleXArea = 1;
        this._scrollWidth = (0, html_1.getScrollbarWidth)();
        this._scrollHeight = (0, html_1.getScrollbarHeight)();
        this._handlers = (_a = {
                onscroll: function (e) {
                    _this.config.scrollHandler(e);
                    _this.update();
                }
            },
            _a[this._wheelName] = function (e) {
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                e.preventDefault();
                var sign = (e.deltaY || -e.wheelDelta) > 0 ? 1 : -1;
                var delta = sign * 40;
                var area = _this._getRefs().area;
                if (isY) {
                    var maxBottom = area.scrollHeight - _this._runnerHeight;
                    var newScrollTop = _this._scrollYTop + delta;
                    if (newScrollTop < 0) {
                        area.scrollTop = 0;
                    }
                    else if (newScrollTop > maxBottom) {
                        area.scrollTop = maxBottom;
                    }
                    else {
                        area.scrollTop = newScrollTop;
                    }
                }
                else {
                    var maxRight = area.scrollWidth - _this._runnerWidth;
                    var newScrollLeft = _this._scrollXLeft + delta;
                    if (newScrollLeft < 0) {
                        area.scrollLeft = 0;
                    }
                    else if (newScrollLeft > maxRight) {
                        area.scrollLeft = maxRight;
                    }
                    else {
                        area.scrollLeft = newScrollLeft;
                    }
                }
                _this.update();
            },
            _a.onmousedownRunner = function (mouseDownEv) {
                mouseDownEv.preventDefault();
                var isY = !!(0, html_1.locateNodeByClassName)(mouseDownEv.target, "y-scroll");
                var _a = _this._getRefs(), area = _a.area, runnerY = _a.runnerY, runnerX = _a.runnerX;
                var rect = area.getBoundingClientRect();
                var top = rect.top + window.pageYOffset;
                var bottom = rect.bottom + window.pageYOffset;
                var maxBottom = area.scrollHeight - _this._runnerHeight;
                var deltaY = mouseDownEv.pageY - runnerY.getBoundingClientRect().top - window.pageYOffset;
                var left = rect.left + window.pageXOffset;
                var right = rect.right + window.pageXOffset;
                var maxRight = area.scrollWidth - _this._runnerWidth;
                var deltaX = mouseDownEv.pageX - runnerX.getBoundingClientRect().left - window.pageXOffset;
                var mouseMove = function (e) {
                    if (isY) {
                        var y = e.pageY - deltaY;
                        if (y <= top) {
                            area.scrollTop = 0;
                        }
                        else if (y > bottom) {
                            area.scrollTop = maxBottom;
                        }
                        else {
                            area.scrollTop = (y - top) / _this._visibleYArea;
                        }
                    }
                    else {
                        var x = e.pageX - deltaX;
                        if (x <= left) {
                            area.scrollLeft = 0;
                        }
                        else if (x > right) {
                            area.scrollLeft = maxRight;
                        }
                        else {
                            area.scrollLeft = (x - left) / _this._visibleXArea;
                        }
                    }
                    _this.update();
                };
                var mouseUp = function () {
                    document.removeEventListener("mousemove", mouseMove);
                    document.removeEventListener("mouseup", mouseUp);
                    document.body.classList.remove("dhx-no-select");
                };
                document.body.classList.add("dhx-no-select");
                document.addEventListener("mousemove", mouseMove);
                document.addEventListener("mouseup", mouseUp);
            },
            _a.onmousedownArea = function (e) {
                if ((0, html_1.locateNodeByClassName)(e, "scroll-runner"))
                    return;
                e.preventDefault();
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                var _a = _this._getRefs(), area = _a.area, runnerY = _a.runnerY, runnerX = _a.runnerX;
                if (isY) {
                    area.scrollTop += (e.pageY - runnerY.getBoundingClientRect().top) / _this._visibleYArea;
                }
                else {
                    area.scrollLeft += (e.pageX - runnerX.getBoundingClientRect().left) / _this._visibleXArea;
                }
                _this.update();
            },
            _a.onmouseenter = function (e) {
                if ((0, html_1.locateNodeByClassName)(e, "scroll-runner"))
                    return;
                var refs = _this._getRefs();
                if (!refs) {
                    return;
                }
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                var areaX = refs.areaX, areaY = refs.areaY;
                if (isY && _this._runnerHeight > 0) {
                    areaY.style.background = "#eee";
                }
                else if (!isY && _this._runnerWidth > 0) {
                    areaX.style.background = "#eee";
                }
            },
            _a.onmouseleave = function (e) {
                if ((0, html_1.locateNodeByClassName)(e, "scroll-runner"))
                    return;
                var refs = _this._getRefs();
                if (!refs) {
                    return;
                }
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                var areaX = refs.areaX, areaY = refs.areaY;
                if (isY && _this._runnerHeight > 0) {
                    areaY.style.background = "transparent";
                }
                else if (!isY && _this._runnerWidth > 0) {
                    areaX.style.background = "transparent";
                }
            },
            _a);
    }
    ScrollView.prototype.enable = function () {
        this.config.enable = true;
        this._getRootView().redraw();
    };
    ScrollView.prototype.disable = function () {
        this.config.enable = false;
        this._getRootView().redraw();
    };
    ScrollView.prototype.render = function (element, uid) {
        var _a, _b;
        var _this = this;
        if (uid === void 0) { uid = ""; }
        if (!this.config.enable || !element.length) {
            return element;
        }
        if (uid)
            this._uid = uid;
        var scrollView = this.config.enable
            ? [
                (0, dom_1.el)(".y-scroll", (_a = {},
                    _a[this._wheelName] = this._handlers[this._wheelName],
                    _a._ref = uid ? "scroll-y-area-".concat(uid) : "scroll-y-area",
                    _a.onmousedown = this._handlers.onmousedownArea,
                    _a.onmouseenter = this._handlers.onmouseenter,
                    _a.onmouseleave = this._handlers.onmouseleave,
                    _a.style = {
                        width: "6px",
                        height: "100%",
                        right: 0,
                        top: 0,
                        position: "absolute",
                    },
                    _a), [
                    (0, dom_1.el)(".scroll-runner", {
                        _ref: uid ? "scroll-y-runner-".concat(uid) : "scroll-y-runner",
                        onmousedown: this._handlers.onmousedownRunner,
                        style: {
                            height: this._runnerHeight + "px",
                            top: this._runnerYTop,
                        },
                    }),
                ]),
                (0, dom_1.el)(".x-scroll", (_b = {},
                    _b[this._wheelName] = this._handlers[this._wheelName],
                    _b._ref = uid ? "scroll-x-area-".concat(uid) : "scroll-x-area",
                    _b.onmousedown = this._handlers.onmousedownArea,
                    _b.onmouseenter = this._handlers.onmouseenter,
                    _b.onmouseleave = this._handlers.onmouseleave,
                    _b.style = {
                        width: "100%",
                        height: "6px",
                        left: 0,
                        bottom: 0,
                        position: "absolute",
                    },
                    _b), [
                    (0, dom_1.el)(".scroll-runner", {
                        _ref: uid ? "scroll-x-runner-".concat(uid) : "scroll-x-runner",
                        onmousedown: this._handlers.onmousedownRunner,
                        style: {
                            width: this._runnerWidth + "px",
                            left: this._runnerXLeft,
                        },
                    }),
                ]),
            ]
            : null;
        return (0, dom_1.el)(".scroll-view-wrapper", [
            (0, dom_1.el)(".scroll-view", {
                onscroll: this._handlers.onscroll,
                _ref: uid ? "scroll-view-".concat(uid) : "scroll-view",
                _hooks: {
                    didInsert: function () {
                        _this.update();
                    },
                    didRecycle: function () {
                        _this.update();
                    },
                },
                style: {
                    width: "calc(100% + ".concat(this._scrollWidth, "px)"),
                    height: "calc(100% + ".concat(this._scrollHeight, "px)"),
                },
            }, element),
        ].concat(scrollView));
    };
    ScrollView.prototype.update = function () {
        var refs = this._getRefs();
        if (!refs) {
            return;
        }
        var area = refs.area, areaX = refs.areaX, areaY = refs.areaY, runnerY = refs.runnerY, runnerX = refs.runnerX;
        this._visibleYArea = area.clientHeight / area.scrollHeight;
        this._visibleXArea = area.clientWidth / area.scrollWidth;
        this._scrollYTop = area.scrollTop;
        this._scrollXLeft = area.scrollLeft;
        this._runnerYTop = this._scrollYTop * this._visibleYArea;
        this._runnerXLeft = this._scrollXLeft * this._visibleXArea;
        this._runnerHeight = this._visibleYArea < 1 ? area.clientHeight * this._visibleYArea : 0;
        this._runnerWidth = this._visibleXArea < 1 ? area.clientWidth * this._visibleXArea : 0;
        var initialTop = runnerY.style.top;
        var initialLeft = runnerX.style.left;
        // update dom
        runnerY.style.opacity = 1;
        runnerY.style.top = this._runnerYTop + "px";
        runnerY.style.height = this._runnerHeight + "px";
        runnerX.style.opacity = 1;
        runnerX.style.left = this._runnerXLeft + "px";
        runnerX.style.width = this._runnerWidth + "px";
        if (initialTop !== runnerY.style.top) {
            areaY.style.opacity = 0.9;
            areaY.style.width = "10px";
        }
        if (initialLeft !== runnerX.style.left) {
            areaX.style.opacity = 0.9;
            areaX.style.height = "10px";
        }
        if (this.config.autoHide) {
            !this._autoHideFunc &&
                (this._autoHideFunc = (0, core_1.debounce)(function () {
                    runnerY.style.opacity = 0;
                    areaY.style.width = "6px";
                    runnerX.style.opacity = 0;
                    areaX.style.height = "6px";
                }, this.config.timeout));
        }
        else {
            this._autoHideFunc = (0, core_1.debounce)(function () {
                areaY.style.width = "6px";
                areaX.style.height = "6px";
            }, this.config.timeout);
        }
        this._autoHideFunc();
    };
    ScrollView.prototype._getRefs = function () {
        var rootView = this._getRootView();
        var refsCheck = !!(rootView.refs["scroll-view"] &&
            (rootView.refs["scroll-x-runner"] || rootView.refs["scroll-y-runner"]));
        var refsIdCheck = !!(this._uid &&
            rootView.refs["scroll-view-".concat(this._uid)] &&
            (rootView.refs["scroll-x-runner-".concat(this._uid)] || rootView.refs["scroll-y-runner-".concat(this._uid)]));
        if (rootView.refs) {
            if (refsCheck) {
                return {
                    area: rootView.refs["scroll-view"].el,
                    areaY: rootView.refs["scroll-y-area"].el,
                    areaX: rootView.refs["scroll-x-area"].el,
                    runnerY: rootView.refs["scroll-y-runner"].el,
                    runnerX: rootView.refs["scroll-x-runner"].el,
                };
            }
            else if (refsIdCheck) {
                return {
                    area: rootView.refs["scroll-view-".concat(this._uid)].el,
                    areaY: rootView.refs["scroll-y-area-".concat(this._uid)].el,
                    areaX: rootView.refs["scroll-x-area-".concat(this._uid)].el,
                    runnerY: rootView.refs["scroll-y-runner-".concat(this._uid)].el,
                    runnerX: rootView.refs["scroll-x-runner-".concat(this._uid)].el,
                };
            }
        }
    };
    return ScrollView;
}());
exports.ScrollView = ScrollView;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(165), exports);
__exportStar(__webpack_require__(166), exports);
__exportStar(__webpack_require__(38), exports);


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataDriver = exports.DragEvents = exports.DataEvents = exports.TreeFilterType = void 0;
var TreeFilterType;
(function (TreeFilterType) {
    TreeFilterType["all"] = "all";
    TreeFilterType["level"] = "level";
    TreeFilterType["leafs"] = "leafs";
})(TreeFilterType || (exports.TreeFilterType = TreeFilterType = {}));
var DataEvents;
(function (DataEvents) {
    DataEvents["afterAdd"] = "afteradd";
    DataEvents["beforeAdd"] = "beforeadd";
    DataEvents["removeAll"] = "removeall";
    DataEvents["beforeRemove"] = "beforeremove";
    DataEvents["afterRemove"] = "afterremove";
    DataEvents["change"] = "change";
    DataEvents["filter"] = "filter";
    DataEvents["dataRequest"] = "dataRequest";
    DataEvents["load"] = "load";
    DataEvents["loadError"] = "loaderror";
    DataEvents["beforeLazyLoad"] = "beforelazyload";
    DataEvents["afterLazyLoad"] = "afterlazyload";
    DataEvents["beforeItemLoad"] = "beforeItemLoad";
    DataEvents["afterItemLoad"] = "afterItemLoad";
})(DataEvents || (exports.DataEvents = DataEvents = {}));
var DragEvents;
(function (DragEvents) {
    DragEvents["beforeDrag"] = "beforeDrag";
    DragEvents["dragStart"] = "dragStart";
    DragEvents["dragOut"] = "dragOut";
    DragEvents["dragIn"] = "dragIn";
    DragEvents["canDrop"] = "canDrop";
    DragEvents["cancelDrop"] = "cancelDrop";
    DragEvents["beforeDrop"] = "beforeDrop";
    DragEvents["afterDrop"] = "afterDrop";
    DragEvents["afterDrag"] = "afterDrag";
})(DragEvents || (exports.DragEvents = DragEvents = {}));
var DataDriver;
(function (DataDriver) {
    DataDriver["json"] = "json";
    DataDriver["csv"] = "csv";
    DataDriver["xml"] = "xml";
})(DataDriver || (exports.DataDriver = DataDriver = {}));


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isOnlyPermanentFilters = exports.hasJsonOrArrayStructure = exports.isTreeCollection = exports.copyWithoutInner = exports.toDataDriver = exports.toProxy = exports.dhxError = exports.dhxWarning = exports.isDebug = exports.findByConf = exports.naturalCompare = exports.isEqualObj = void 0;
var core_1 = __webpack_require__(1);
var dataproxy_1 = __webpack_require__(26);
var drivers_1 = __webpack_require__(61);
function isEqualObj(a, b) {
    for (var key in a) {
        if (a[key] !== b[key] || Array.isArray(a[key])) {
            return false;
        }
    }
    return true;
}
exports.isEqualObj = isEqualObj;
function naturalCompare(a, b) {
    if (isNaN(a) || isNaN(b)) {
        var ax_1 = [];
        var bx_1 = [];
        a.replace(/(\d+)|(\D+)/g, function (_, $1, $2) {
            ax_1.push([$1 || Infinity, $2 || ""]);
        });
        b.replace(/(\d+)|(\D+)/g, function (_, $1, $2) {
            bx_1.push([$1 || Infinity, $2 || ""]);
        });
        while (ax_1.length && bx_1.length) {
            var an = ax_1.shift();
            var bn = bx_1.shift();
            var nn = an[0] - bn[0] || an[1].localeCompare(bn[1]);
            if (nn) {
                return nn;
            }
        }
        return ax_1.length - bx_1.length;
    }
    return a - b;
}
exports.naturalCompare = naturalCompare;
function findByConf(item, conf) {
    if (typeof conf === "function") {
        if (conf.call(this, item)) {
            return item;
        }
    }
    else if (conf.by && conf.match) {
        if (item[conf.by] === conf.match) {
            return item;
        }
    }
}
exports.findByConf = findByConf;
function isDebug() {
    var dhx = window.dhx;
    if (typeof dhx !== "undefined") {
        return typeof dhx.debug !== "undefined" && dhx.debug;
    }
    // return typeof DHX_DEBUG_MODE !== "undefined" && DHX_DEBUG_MODE;
}
exports.isDebug = isDebug;
function dhxWarning(msg) {
    // tslint:disable-next-line:no-console
    console.warn(msg);
}
exports.dhxWarning = dhxWarning;
function dhxError(msg) {
    throw new Error(msg);
}
exports.dhxError = dhxError;
function toProxy(proxy) {
    var type = typeof proxy;
    if (type === "string") {
        return new dataproxy_1.DataProxy(proxy);
    }
    else if (type === "object") {
        return proxy;
    }
}
exports.toProxy = toProxy;
function toDataDriver(driver) {
    if (typeof driver === "string") {
        var dhx = window.dhx;
        var drivers = (dhx && dhx.dataDrivers) || drivers_1.dataDrivers;
        if (drivers[driver]) {
            return new drivers[driver]();
        }
        else {
            // tslint:disable-next-line:no-console
            console.warn("Incorrect data driver type:", driver);
            // tslint:disable-next-line:no-console
            console.warn("Available types:", JSON.stringify(Object.keys(drivers)));
        }
    }
    else if (typeof driver === "object") {
        return driver;
    }
}
exports.toDataDriver = toDataDriver;
function copyWithoutInner(obj, forbidden) {
    var result = {};
    for (var key in obj) {
        if (!key.startsWith("$") && (!forbidden || !forbidden[key])) {
            result[key] = obj[key];
        }
    }
    return result;
}
exports.copyWithoutInner = copyWithoutInner;
function isTreeCollection(obj) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    return Boolean(obj.getRoot);
}
exports.isTreeCollection = isTreeCollection;
function hasJsonOrArrayStructure(str) {
    if (typeof str === "object") {
        return true;
    }
    if (typeof str !== "string") {
        return false;
    }
    try {
        var result = JSON.parse(str);
        return Object.prototype.toString.call(result) === "[object Object]" || Array.isArray(result);
    }
    catch (err) {
        return false;
    }
}
exports.hasJsonOrArrayStructure = hasJsonOrArrayStructure;
function isOnlyPermanentFilters(filters) {
    if (!filters || (0, core_1.isEmptyObj)(filters))
        return false;
    return Object.keys(filters).every(function (key) {
        var _a;
        return (_a = filters[key].config) === null || _a === void 0 ? void 0 : _a.permanent;
    });
}
exports.isOnlyPermanentFilters = isOnlyPermanentFilters;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.proRender = exports.render = exports.applyAutoWidth = exports.getElementSizes = exports.getRenderConfig = exports.getCurrFixedCols = exports.calcScrollBarWidth = exports.BORDERS = void 0;
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(3);
var data_1 = __webpack_require__(18);
var main_1 = __webpack_require__(15);
var types_1 = __webpack_require__(9);
var Cells_1 = __webpack_require__(27);
var FixedCols_1 = __webpack_require__(79);
var FixedRows_1 = __webpack_require__(80);
var core_1 = __webpack_require__(1);
exports.BORDERS = 2;
function calcScrollBarWidth(config, customScroll, sizes) {
    var _a, _b;
    if (customScroll === void 0) { customScroll = false; }
    var yState = config.$totalHeight + config.$headerHeight + config.$footerHeight + exports.BORDERS >
        ((_a = sizes === null || sizes === void 0 ? void 0 : sizes.height) !== null && _a !== void 0 ? _a : config.$height);
    var scrollbarY = !yState || customScroll ? 0 : (0, html_1.getScrollbarWidth)();
    var xState = config.$totalWidth + exports.BORDERS + scrollbarY > ((_b = sizes === null || sizes === void 0 ? void 0 : sizes.width) !== null && _b !== void 0 ? _b : config.$width);
    var scrollbarX = !xState || customScroll ? 0 : (0, html_1.getScrollbarWidth)();
    return { x: scrollbarX, y: scrollbarY, xState: xState, yState: yState };
}
exports.calcScrollBarWidth = calcScrollBarWidth;
function getCurrFixedCols(config, split) {
    if (!config[split])
        return [];
    return (split === types_1.Split.left
        ? config.columns.slice(0, config.leftSplit)
        : config.columns.slice(-config.rightSplit)).filter(function (col) { return !col.hidden; });
}
exports.getCurrFixedCols = getCurrFixedCols;
function getWrapperAutoHeight(grid, config, wrapperSizes) {
    var _a, _b;
    var container = grid._container;
    var height = config.$headerHeight +
        (config.$footerHeight && config.$footerHeight + 1) +
        config.$totalHeight +
        exports.BORDERS;
    if (container) {
        var _c = window.getComputedStyle(container), minHeight = _c.minHeight, maxHeight = _c.maxHeight;
        if (height <= parseFloat(minHeight)) {
            return parseFloat(minHeight);
        }
        else if (height >= parseFloat(maxHeight)) {
            return parseFloat(maxHeight);
        }
        else {
            return height + calcScrollBarWidth(config, !!((_a = grid.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable), wrapperSizes).x;
        }
    }
    else {
        return (height +
            (wrapperSizes ? calcScrollBarWidth(config, !!((_b = grid.scrollView) === null || _b === void 0 ? void 0 : _b.config.enable), wrapperSizes).x : 0));
    }
}
function getRenderConfig(obj, data, wrapperSizes) {
    var config = obj.config;
    var filteredColumns = config.columns.filter(function (col) { return !col.hidden; });
    var positions = (0, data_1.calculatePositions)(wrapperSizes.width, wrapperSizes.height, obj._scroll, config, data);
    var currentColumns = filteredColumns.slice(positions.xStart, positions.xEnd);
    var currentRows = data.slice(positions.yStart, positions.yEnd);
    var fixedColumns = {
        left: getCurrFixedCols(config, types_1.Split.left),
        right: getCurrFixedCols(config, types_1.Split.right),
    };
    var fixedRows = {
        top: data.slice(0, config.topSplit || 0),
        bottom: config.bottomSplit ? data.slice(-config.bottomSplit) : [],
    };
    return __assign(__assign({}, config), { data: data, columns: config.columns, scroll: obj._scroll, $positions: positions, headerHeight: config.$headerHeight, footerHeight: config.$footerHeight, firstColId: filteredColumns[0] && filteredColumns[0].id, events: obj.events, _events: obj._events, filteredColumns: filteredColumns, currentColumns: currentColumns, currentRows: currentRows, fixedColumns: fixedColumns, fixedRows: fixedRows, sortBy: obj._sortBy, sortDir: obj._sortDir, content: obj.content, gridId: obj._uid, $renderFrom: "render" });
}
exports.getRenderConfig = getRenderConfig;
function getElementSizes(element) {
    if (!element)
        return;
    if (!element.tagName)
        element = element._parent._container;
    if (!element)
        return;
    var styles = element.currentStyle || window.getComputedStyle(element);
    var paddingsByWidth = parseFloat(styles.paddingLeft) + parseFloat(styles.paddingRight) || 0;
    var paddingsByHeight = parseFloat(styles.paddingTop) + parseFloat(styles.paddingBottom) || 0;
    return {
        width: element.clientWidth - paddingsByWidth,
        height: element.clientHeight - paddingsByHeight,
    };
}
exports.getElementSizes = getElementSizes;
function getGridData(renderConfig, shifts) {
    var content = (0, Cells_1.getCells)(renderConfig);
    var filteredColumns = renderConfig.filteredColumns, $resizing = renderConfig.$resizing, $totalHeight = renderConfig.$totalHeight, $totalWidth = renderConfig.$totalWidth, leftSplit = renderConfig.leftSplit, data = renderConfig.data, $positions = renderConfig.$positions;
    var contentSpans = (0, Cells_1.getSpans)(renderConfig);
    var getRowAriaAttrs = function (count) { return ({
        role: "rowgroup",
        "aria-rowcount": count,
    }); };
    var resizedLine;
    if ($resizing) {
        var colIndex = (0, core_1.findIndex)(filteredColumns, function (col) { return col.id === $resizing; });
        var firstCellLeft = (0, main_1.getTotalWidth)(filteredColumns.slice(0, colIndex)) + filteredColumns[colIndex].$width;
        resizedLine = (0, dom_1.el)(".dhx_grid-resize-line", {
            style: {
                top: 0,
                left: firstCellLeft,
                height: $totalHeight,
            },
        });
    }
    var selection = renderConfig.selection ? renderConfig.selection.toHTML() : null;
    selection =
        typeof selection === "string" ? (0, dom_1.el)("div.dhx_selection", { ".innerHTML": selection }) : selection;
    var pos = $positions;
    return (0, dom_1.el)(".dhx_data-wrap", {
        style: {
            height: $totalHeight,
            width: $totalWidth,
            "padding-left": shifts.x,
            "padding-top": shifts.y,
        },
        role: "presentation",
    }, [
        (0, dom_1.el)(".dhx_grid_data".concat(leftSplit ? ".dhx_grid_fixed_left" : ""), __assign(__assign({ _flags: dom_1.KEYED_LIST }, (0, Cells_1.getHandlers)(pos.yStart, pos.xStart, renderConfig)), getRowAriaAttrs(data.length)), content),
        (0, dom_1.el)(".dhx_span-spans", __assign({ role: "presentation" }, (0, Cells_1.getHandlers)(pos.yStart, pos.xStart, renderConfig)), contentSpans),
        (0, dom_1.el)(".dhx_grid_selection", { _ref: "selection", "aria-hidden": "true" }, [selection, resizedLine]),
    ]);
}
function getContentHeight(renderConfig, isSticky, wrapperSizes) {
    var contentHeight = wrapperSizes.height - exports.BORDERS;
    contentHeight = isSticky ? contentHeight : contentHeight - renderConfig.headerHeight;
    var isFooter = renderConfig.$footer;
    return (contentHeight = isFooter
        ? isSticky
            ? contentHeight
            : contentHeight - renderConfig.footerHeight
        : contentHeight);
}
function applyAutoWidth(config, wrapperSizes, firstApply, resizer, scrollViewConfig) {
    if (firstApply === void 0) { firstApply = true; }
    if (resizer === void 0) { resizer = false; }
    if (scrollViewConfig === void 0) { scrollViewConfig = false; }
    var scrollbarY = !scrollViewConfig && config.$totalHeight >= wrapperSizes.height - config.$headerHeight
        ? (0, html_1.getScrollbarWidth)()
        : 0;
    var newTotalWidth = wrapperSizes.width - exports.BORDERS - scrollbarY;
    var columns = config.columns.filter(function (col) { return !col.hidden; });
    var growingColumns = columns.filter(function (col) { return !col.width && !col.$fixed && (0, main_1.isAutoWidth)(config, col); });
    var nonGrowingColumnsWidth = (0, main_1.getTotalWidth)(columns.filter(function (col) { return col.width || col.$fixed || !(0, main_1.isAutoWidth)(config, col); }));
    var fullGravity = growingColumns.reduce(function (gravity, col) { return gravity + (col.gravity || 1); }, 0);
    if (newTotalWidth < config.$totalWidth) {
        var growingColumnsWidth_1 = growingColumns.reduce(function (width, col) { return width + (col.maxWidth || col.$width); }, 0);
        if (growingColumns.length) {
            growingColumns.forEach(function (col) {
                var newWidth = 0;
                if (firstApply) {
                    newWidth =
                        Math.abs(newTotalWidth - growingColumnsWidth_1) * ((col.gravity || 1) / fullGravity);
                }
                else {
                    newWidth =
                        Math.abs(newTotalWidth - nonGrowingColumnsWidth) * ((col.gravity || 1) / fullGravity);
                }
                var wrongMin = newWidth < col.minWidth || col.minWidth < col.$width;
                var wrongMax = newWidth > col.maxWidth;
                if (!wrongMin && !wrongMax) {
                    col.$width = newWidth;
                }
                else if (wrongMin) {
                    nonGrowingColumnsWidth += col.$width - newWidth;
                    col.$fixed = true;
                }
                else if (wrongMax) {
                    col.$width = col.maxWidth;
                    col.$fixed = true;
                }
                if (col.$width < 20)
                    col.$width = 20;
            });
        }
    }
    else {
        growingColumns.forEach(function (col) {
            var newWidth = Math.abs(newTotalWidth - nonGrowingColumnsWidth) * ((col.gravity || 1) / fullGravity);
            var wrongMin = newWidth < col.minWidth || col.minWidth < col.$width;
            var wrongMax = newWidth > col.maxWidth;
            if (!wrongMin && !wrongMax) {
                col.$width = newWidth;
            }
            else if (wrongMin) {
                nonGrowingColumnsWidth += col.$width - newWidth;
                if (resizer)
                    col.$fixed = true;
            }
            else if (wrongMax) {
                col.$width = col.maxWidth;
                if (resizer)
                    col.$fixed = true;
            }
            if (col.$width < 20)
                col.$width = 20;
            if (!firstApply && col.$fixed) {
                delete col.$fixed;
            }
        });
    }
    if (firstApply) {
        applyAutoWidth(config, wrapperSizes, false, resizer, scrollViewConfig);
    }
}
exports.applyAutoWidth = applyAutoWidth;
function render(vm, obj, htmlEvents, selection, uid) {
    if (!obj._container) {
        obj.config.$width = 1;
        obj.config.$height = 1;
    }
    // if grid placed inside another component, it will fit to its container
    if (vm && vm.node && vm.node.parent && vm.node.parent.el) {
        var parentNode = vm.node.parent.el;
        var parentSizes = getElementSizes(parentNode);
        obj.config.$width = parentSizes.width;
        obj.config.$height = parentSizes.height;
    }
    var config = obj.config;
    // when grid is destructing and user try to repaint it
    if (!config) {
        return (0, dom_1.el)("div");
    }
    if (!config.columns.length) {
        return (0, dom_1.el)(".dhx_grid", {
            "data-dhx-widget-id": uid,
            "data-dhx-root-id": config.rootParent,
            role: "empty-grid",
        });
    }
    var data = obj.data.getRawData(0, -1, null, 2);
    if (config.columns.reduce(function (check, col) { return (check = !col.hidden ? col.hidden : check); }, true)) {
        config.$totalHeight = 0;
    }
    else {
        config.$totalHeight = data.reduce(function (total, _a) {
            var $height = _a.$height;
            return (total += $height || 0);
        }, 0);
    }
    var width, height;
    var sizes = getElementSizes(obj._container);
    if (config.$width) {
        width = config.$width;
    }
    else {
        width = config.width && typeof config.width === "number" ? config.width : sizes === null || sizes === void 0 ? void 0 : sizes.width;
    }
    if (config.$height) {
        height = config.$height;
    }
    else {
        height =
            config.height && typeof config.height === "number" ? config.height : sizes === null || sizes === void 0 ? void 0 : sizes.height;
    }
    var wrapperSizes = { width: width || 0, height: height || 0 };
    // TODO: Remove scroll
    if ((0, main_1.isAutoWidth)(config)) {
        applyAutoWidth(config, wrapperSizes);
        config.$totalWidth = (0, main_1.getTotalWidth)(config.columns.filter(function (col) { return !col.hidden; }));
    }
    config.$width = wrapperSizes.width;
    config.$height = wrapperSizes.height;
    var renderConfig = getRenderConfig(obj, data, wrapperSizes);
    renderConfig.selection = selection;
    renderConfig.datacollection = obj.data;
    var shifts = (0, Cells_1.getShifts)(renderConfig);
    renderConfig.$scrollBarWidth = calcScrollBarWidth(renderConfig);
    var isSticky = (0, main_1.isCssSupport)("position", "sticky");
    var gridBodyHeight = getContentHeight(renderConfig, isSticky, wrapperSizes);
    var layoutState = {
        wrapper: wrapperSizes,
        sticky: isSticky,
        shifts: shifts,
        gridBodyHeight: gridBodyHeight,
    };
    var header = (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "header", position: "top" }));
    var footer = renderConfig.$footer
        ? (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "footer", position: "bottom" }))
        : null;
    var lessByWidth = renderConfig.$totalWidth + exports.BORDERS < wrapperSizes.width ? "dhx_grid-less-width" : "";
    var lessByHeight = renderConfig.$totalHeight + exports.BORDERS < wrapperSizes.height ? "dhx_grid-less-height" : "";
    var fixedRight = renderConfig.fixedColumns.right.length ? "dhx_grid__contains_cols_right--fixed" : "";
    var fixedBottom = config.bottomSplit ? "dhx_grid__contains_rows_bottom--fixed" : "";
    var getGridAriaAttrs = function (rows, cols, isEditable, isMultiselectable) { return ({
        role: "grid",
        "aria-rowcount": rows.length,
        "aria-colcount": cols.filter(function (col) { return !col.hidden; }).length,
        "aria-readonly": isEditable ? "false" : "true",
        "aria-multiselectable": isMultiselectable ? "true" : "false",
    }); };
    // dirty: but work. Change checking of rendering Grid
    if (!vm.node) {
        var _a = obj.getScrollState(), x_1 = _a.x, y_1 = _a.y;
        (0, dom_1.awaitRedraw)().then(function () {
            obj.scroll(x_1, y_1);
        });
    }
    return (0, dom_1.el)(".dhx_grid.dhx_widget", __assign({ class: (renderConfig.css || "") +
            (!isSticky ? " dhx_grid_border" : "") +
            (config.multiselection ? " dhx_no-select--pointer" : ""), "data-dhx-widget-id": uid, "data-dhx-root-id": config.rootParent }, getGridAriaAttrs(renderConfig.data, config.columns, renderConfig.editable, renderConfig.multiselection)), [
        (0, dom_1.resizer)(function (changeWith) {
            if ((0, main_1.isAutoWidth)(obj.config) && !!changeWith) {
                config.$totalWidth = 0;
                applyAutoWidth(config, wrapperSizes, true, true);
            }
            return obj.paint();
        }),
        (0, dom_1.el)(".dhx_grid-content", {
            style: __assign({}, wrapperSizes),
            onclick: htmlEvents.onclick,
            onmouseover: htmlEvents.onmouseover,
            class: "".concat(lessByWidth, " ").concat(lessByHeight, " ").concat(fixedRight, " ").concat(fixedBottom).trim(),
            role: "presentation",
        }, [
            isSticky ? null : header,
            (0, dom_1.el)(".dhx_grid-body", {
                style: {
                    height: gridBodyHeight,
                    width: wrapperSizes.width - exports.BORDERS,
                },
                onscroll: htmlEvents.onscroll,
                _ref: "grid_body",
                role: "presentation",
            }, [
                (0, dom_1.el)("div", {}, [
                    isSticky ? header : null,
                    getGridData(renderConfig, shifts),
                    isSticky ? footer : null,
                ]),
            ]),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.top),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.bottom),
            isSticky ? null : footer,
        ]),
    ]);
}
exports.render = render;
function proRender(vm, obj, htmlEvents, selection, uid) {
    var _a;
    if (!obj._container) {
        obj.config.$width = 1;
        obj.config.$height = 1;
    }
    var parentSizes;
    // if grid placed inside another component, it will fit to its container
    if (vm && vm.node && vm.node.parent && vm.node.parent.el) {
        var parentNode = vm.node.parent.el;
        parentSizes = getElementSizes(parentNode);
        obj.config.$width = parentSizes.width;
        obj.config.$height = parentSizes.height;
    }
    var config = obj.config;
    // when grid is destructing and user try to repaint it
    if (!config) {
        return (0, dom_1.el)("div");
    }
    if (!config.columns.length) {
        return (0, dom_1.el)(".dhx_grid", {
            "data-dhx-widget-id": uid,
            "data-dhx-root-id": config.rootParent,
            role: "empty-grid",
        });
    }
    var data = obj.data.getRawData(0, -1, null, 2);
    if (config.columns.reduce(function (check, col) { return (check = !col.hidden ? col.hidden : check); }, true)) {
        config.$totalHeight = 0;
    }
    else {
        config.$totalHeight = data.reduce(function (total, _a) {
            var $height = _a.$height;
            return (total += $height || 0);
        }, 0);
    }
    var width, height;
    var wrapperAutoHeight;
    var sizes = getElementSizes(obj._container);
    if (obj.config.height === "auto") {
        wrapperAutoHeight = getWrapperAutoHeight(obj, config, parentSizes ? parentSizes : sizes);
    }
    if (config.$width) {
        width = config.$width;
    }
    else {
        width = config.width && typeof config.width === "number" ? config.width : sizes === null || sizes === void 0 ? void 0 : sizes.width;
    }
    if (config.$height) {
        height = config.$height;
    }
    else {
        height =
            config.height && typeof config.height === "number" ? config.height : sizes === null || sizes === void 0 ? void 0 : sizes.height;
    }
    var wrapperSizes = {
        width: width || 0,
        height: (obj.config.height === "auto" ? wrapperAutoHeight : height) || 0,
    };
    // TODO: Remove scroll
    if ((0, main_1.isAutoWidth)(config)) {
        applyAutoWidth(config, wrapperSizes, true, false, obj.scrollView && obj.scrollView.config.enable);
        config.$totalWidth = (0, main_1.getTotalWidth)(config.columns.filter(function (col) { return !col.hidden; }));
    }
    config.$width = wrapperSizes.width;
    config.$height = wrapperSizes.height;
    var renderConfig = getRenderConfig(obj, data, wrapperSizes);
    renderConfig.selection = selection;
    renderConfig.datacollection = obj.data;
    var shifts = (0, Cells_1.getShifts)(renderConfig);
    renderConfig.$scrollBarWidth = calcScrollBarWidth(renderConfig, !!((_a = obj.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable));
    var isSticky = (0, main_1.isCssSupport)("position", "sticky");
    var gridBodyHeight = getContentHeight(renderConfig, isSticky, wrapperSizes);
    var layoutState = {
        wrapper: wrapperSizes,
        sticky: isSticky,
        shifts: shifts,
        gridBodyHeight: gridBodyHeight,
    };
    var header = (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "header", position: "top" }));
    var footer = renderConfig.$footer
        ? (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "footer", position: "bottom" }))
        : null;
    var lessByWidth = renderConfig.$totalWidth + exports.BORDERS < wrapperSizes.width ? "dhx_grid-less-width" : "";
    var lessByHeight = renderConfig.$totalHeight + exports.BORDERS < wrapperSizes.height ? "dhx_grid-less-height" : "";
    var fixedRight = renderConfig.fixedColumns.right.length ? "dhx_grid__contains_cols_right--fixed" : "";
    var fixedBottom = config.bottomSplit ? "dhx_grid__contains_rows_bottom--fixed" : "";
    // dirty: but work. Change checking of rendering Grid
    if (!vm.node) {
        var _b = obj.getScrollState(), x_2 = _b.x, y_2 = _b.y;
        (0, dom_1.awaitRedraw)().then(function () {
            obj.scroll(x_2, y_2);
        });
    }
    var gridContent = (0, dom_1.el)("div", {}, [
        isSticky ? header : null,
        getGridData(renderConfig, shifts),
        isSticky ? footer : null,
    ]);
    return (0, dom_1.el)(".dhx_grid.dhx_widget", {
        class: (renderConfig.css || "") +
            (!isSticky ? " dhx_grid_border" : "") +
            (config.multiselection ? " dhx_no-select--pointer" : ""),
        style: {
            height: wrapperAutoHeight !== null && wrapperAutoHeight !== void 0 ? wrapperAutoHeight : null,
        },
        "data-dhx-widget-id": uid,
        "data-dhx-root-id": config.rootParent,
        role: "grid",
        "aria-rowcount": renderConfig.data.length,
        "aria-colcount": config.columns.filter(function (col) { return !col.hidden; }).length,
    }, [
        (0, dom_1.resizer)(function (changeWith) {
            if ((0, main_1.isAutoWidth)(obj.config) && !!changeWith) {
                config.$totalWidth = 0;
                applyAutoWidth(config, wrapperSizes, true, true);
            }
            return obj.paint();
        }),
        (0, dom_1.el)(".dhx_grid-content", {
            style: __assign({}, wrapperSizes),
            onclick: htmlEvents.onclick,
            onmouseover: htmlEvents.onmouseover,
            class: "".concat(lessByWidth, " ").concat(lessByHeight, " ").concat(fixedRight, " ").concat(fixedBottom).trim(),
            role: "presentation",
        }, [
            isSticky ? null : header,
            (0, dom_1.el)(".dhx_grid-body", {
                style: {
                    height: gridBodyHeight,
                    width: wrapperSizes.width - exports.BORDERS,
                },
                onscroll: htmlEvents.onscroll,
                _ref: "grid_body",
                role: "presentation",
            }, [
                obj.scrollView && obj.scrollView.config.enable
                    ? obj.scrollView.render([gridContent])
                    : gridContent,
            ]),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.top),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.bottom),
            isSticky ? null : footer,
        ]),
    ]);
}
exports.proRender = proRender;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartEvents = void 0;
var ChartEvents;
(function (ChartEvents) {
    ChartEvents["toggleSeries"] = "toggleSeries";
    ChartEvents["chartMouseMove"] = "chartMouseMove";
    ChartEvents["chartMouseLeave"] = "chartMouseLeave";
    ChartEvents["resize"] = "resize";
    ChartEvents["serieClick"] = "serieClick";
    // private
    ChartEvents["seriaMouseMove"] = "seriaMouseMove";
    ChartEvents["seriaMouseLeave"] = "seriaMouseLeave";
})(ChartEvents || (exports.ChartEvents = ChartEvents = {}));


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataProxy = void 0;
var ajax_1 = __webpack_require__(41);
var DataProxy = /** @class */ (function () {
    function DataProxy(url, config) {
        this.url = this._url = url;
        this.config = config;
    }
    DataProxy.prototype.updateUrl = function (url, params) {
        if (params === void 0) { params = {}; }
        this._url = this.url = url || this._url;
        this.url += this.url.includes("?") ? "&" : "?";
        for (var param in params) {
            this.config[param] = params[param];
            this.url += "".concat(param, "=").concat(encodeURIComponent(params[param]), "&");
        }
        this.url = this.url.slice(0, -1);
    };
    DataProxy.prototype.load = function () {
        return ajax_1.ajax.get(this.url, undefined, { responseType: "text" });
    };
    DataProxy.prototype.save = function (data, mode) {
        switch (mode) {
            case "delete":
                return ajax_1.ajax.delete(this.url, data);
            case "update":
                return ajax_1.ajax.put(this.url, data);
            case "insert":
            default:
                return ajax_1.ajax.post(this.url, data);
        }
    };
    return DataProxy;
}());
exports.DataProxy = DataProxy;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeSpan = exports.getShifts = exports.getSpans = exports.getCells = exports.getTreeCell = exports.getHandlers = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var cells_1 = __webpack_require__(32);
var main_1 = __webpack_require__(15);
var types_1 = __webpack_require__(9);
var editors_1 = __webpack_require__(132);
var html_1 = __webpack_require__(3);
var data_1 = __webpack_require__(18);
var render_1 = __webpack_require__(24);
function handleMouse(rowStart, colStart, conf, type, e) {
    colStart = (0, html_1.locateNodeByClassName)(e.target, "dhx_grid-fixed-cols-wrap") ? 0 : colStart;
    var target = (0, html_1.locateNodeByClassName)(e.target, "dhx_grid-cell");
    var targetSpan = (0, html_1.locateNodeByClassName)(e.target, "dhx_span-cell");
    if ((!target && !targetSpan) || !type) {
        return;
    }
    var rowNode = target ? target.parentNode : targetSpan;
    var colId = (target || targetSpan).getAttribute("data-dhx-col-id");
    var col = conf.filteredColumns.find(function (column) { return column.id === colId; });
    var rowId = rowNode.getAttribute("data-dhx-id");
    var row = (conf.$data || conf.data).find(function (r) { return r.id.toString() === rowId; });
    var systemEvent = type.toLocaleLowerCase().includes("touch");
    if (systemEvent) {
        conf._events.fire(type, [row, col, e]);
    }
    else {
        conf.events.fire(type, [row, col, e]);
    }
}
function getHandlers(row, column, conf) {
    return {
        onclick: [handleMouse, row, column, conf, types_1.GridEvents.cellClick],
        onmouseover: [handleMouse, row, column, conf, types_1.GridEvents.cellMouseOver],
        onmousedown: [handleMouse, row, column, conf, types_1.GridEvents.cellMouseDown],
        ondblclick: [handleMouse, row, column, conf, types_1.GridEvents.cellDblClick],
        oncontextmenu: [handleMouse, row, column, conf, types_1.GridEvents.cellRightClick],
        ontouchstart: [handleMouse, row, column, conf, types_1.GridEvents.cellMouseDown],
        ontouchmove: [handleMouse, row, column, conf, types_1.GridSystemEvents.cellTouchMove],
        ontouchend: [handleMouse, row, column, conf, types_1.GridSystemEvents.cellTouchEnd],
    };
}
exports.getHandlers = getHandlers;
function getTreeCell(content, row, col, conf) {
    var getCellAriaAttrs = function (col, ind) { return ({
        role: "gridcell",
        "aria-colindex": ind,
    }); };
    var getToggleAriaAttrs = function (row) { return ({
        role: "button",
        "aria-label": row.$opened ? "Collapse group" : "Expand group",
    }); };
    var isEditable = conf.$editable && conf.$editable.row === row.id && conf.$editable.col === col.id;
    var isFilledCell = !conf.fixedColumns.left.length || conf.$renderFrom === "leftFixedCols";
    var cellAlign = col.align ? "dhx_align-".concat(col.align) : "dhx_align-left";
    var css = "";
    if (isFilledCell) {
        css = "dhx_tree-cell ".concat(col.$cellCss[row.id] || "", " ").concat(cellAlign);
        if (row.$items)
            css += " dhx_grid-expand-cell";
        if (isEditable)
            css += " dhx_tree-editing-cell";
        if (conf.dragMode && !isEditable) {
            css +=
                (row.$drophere ? " dhx_grid-cell--drophere" : "") +
                    (row.$dragtarget ? " dhx_grid-cell--dragtarget" : "");
        }
    }
    var parentPadding = (0, data_1.getTreeCellWidthOffset)(row);
    return (0, dom_1.el)(".dhx_grid-cell", __assign({ class: css, style: {
            width: col.$width,
            height: row.$height,
            padding: !row.$items ? "0 0 0 ".concat(parentPadding, "px") : 0,
        }, "data-dhx-col-id": col.id }, getCellAriaAttrs(col, 1)), isFilledCell
        ? [
            row.$items
                ? (0, dom_1.el)(".dhx_grid-expand-cell-icon", __assign(__assign({ class: row.$opened ? "dxi dxi-chevron-up" : "dxi dxi-chevron-down", "data-dhx-id": row.id }, getToggleAriaAttrs(row)), { style: {
                        padding: row.$level ? "0 0 0 ".concat(4 + parentPadding, "px") : "0 0 0 4px",
                    } }))
                : null,
            (0, dom_1.el)(".dhx_tree-cell", {
                class: cellAlign + "".concat((conf.autoHeight && " dhx_tree-cell_auto-height") || ""),
            }, [content]),
        ]
        : null);
}
exports.getTreeCell = getTreeCell;
function getEditorCell(row, col, conf) {
    return (0, editors_1.getEditor)(row, col, conf);
}
function getCells(conf) {
    if (!conf.data || !conf.filteredColumns) {
        return [];
    }
    var getRowAriaAttrs = function (ind) { return ({
        role: "row",
        "aria-rowindex": ind,
    }); };
    var pos = conf.$positions;
    var data = conf.data ? conf.data.slice(pos.yStart, pos.yEnd) : [];
    var columns = conf.filteredColumns.slice(pos.xStart, pos.xEnd);
    var selectedCell = conf.selection.getCell();
    var isFirstTabindex = true;
    var filteredDragRows;
    var dragGhost = document.querySelector(".dhx_drag-ghost");
    if (dragGhost) {
        var dragRowIndexes = Array.from(dragGhost.querySelectorAll(".dhx_grid-row")).map(function (elem) {
            return Number(elem.getAttribute("aria-rowindex")) - 1;
        });
        if (dragRowIndexes.length) {
            filteredDragRows = dragRowIndexes
                .map(function (i) { return conf.data[i]; })
                .filter(function (item) { return item && !data.find(function (i) { return i.id === item.id; }); });
            data.push.apply(data, filteredDragRows);
        }
    }
    return data.map(function (row, index) {
        var isFilteredDragRow = filteredDragRows === null || filteredDragRows === void 0 ? void 0 : filteredDragRows.some(function (item) { return item.id === row.id; });
        var isLastRow = data.length - 1 === index;
        var rowCss = "";
        if (conf.rowCss) {
            rowCss = conf.rowCss(row);
        }
        if (row.$css) {
            rowCss += row.$css;
        }
        return (0, dom_1.el)(".dhx_grid-row", __assign({ style: {
                height: isLastRow ? row.$height + 1 : row.$height,
                display: isFilteredDragRow ? "none" : null,
            }, "data-dhx-id": row.id, class: rowCss, _key: row.id, _flags: dom_1.KEYED_LIST }, (isFilteredDragRow ? {} : getRowAriaAttrs(pos.yStart + index + 1))), row.$customRender
            ? [row.$customRender(row, conf)]
            : columns.map(function (col, colIndex) {
                var _a;
                if (!col.hidden) {
                    var initValue = row[col.id];
                    var options_1 = (0, data_1.getEditorOptions)(col, row);
                    if ((col.editable || (conf.editable && col.editable !== false)) &&
                        (col.editorType === "select" ||
                            col.editorType === "combobox" ||
                            col.editorType === "multiselect") &&
                        options_1) {
                        initValue =
                            typeof initValue === "string" && col.editorType === "multiselect"
                                ? initValue.split(",").map(function (item) { return item.trim(); })
                                : [initValue === null || initValue === void 0 ? void 0 : initValue.toString()];
                        initValue = initValue
                            .map(function (item) {
                            var _a, _b;
                            return ((_b = (_a = options_1.find(function (option) {
                                return option.id &&
                                    option.id.toString() === item;
                            })) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : item);
                        })
                            .join(", ");
                    }
                    var value = (0, data_1.toFormat)(initValue, col.type, col.format);
                    var getTabIndex_1 = function (col, row) {
                        var attrs = {
                            tabindex: -1,
                        };
                        if (selectedCell) {
                            // is current cell selected?
                            if (selectedCell.row.id === row.id && selectedCell.column.id === col.id) {
                                attrs["tabindex"] = 0;
                            }
                        }
                        else if (isFirstTabindex) {
                            attrs["tabindex"] = 0;
                            // one-time event - only on first focus
                            // FIXME: crutch-solution
                            attrs["onkeydown"] = function (e) {
                                // FIXME: issue with samples that already setCell from index.html, rendered twice
                                // TODO: not here BUT if first cell is not in viewport -> scroll to it to set focus
                                if (conf.selection && !selectedCell && e.key === "Tab") {
                                    var rowId = e.target.parentNode.getAttribute("data-dhx-id");
                                    var colId = e.target.getAttribute("data-dhx-col-id");
                                    if (colId && rowId) {
                                        conf.selection.setCell(rowId, colId);
                                        selectedCell = conf.selection.getCell();
                                    }
                                    isFirstTabindex = false;
                                }
                            };
                        }
                        return attrs;
                    };
                    var getEditBtnAriaAttrs = function () { return ({
                        role: "button",
                        "aria-label": "Edit content",
                    }); };
                    var getCellAriaAttrs = function (col, colIndex, rowIndex, isEditable) { return (__assign({ role: "gridcell", "aria-colindex": colIndex, "aria-readonly": isEditable ? "false" : "true" }, getTabIndex_1(col, row))); };
                    var defaultTemplate = function (text) {
                        if (typeof text === "boolean" || col.type === "boolean") {
                            if (typeof text !== "string") {
                                return "".concat(Boolean(text));
                            }
                        }
                        return text || text === 0 ? text : "";
                    };
                    var content = col.template
                        ? col.template(value, row, col)
                        : defaultTemplate(value);
                    // content can be a domvm node or a string
                    if (typeof content === "string") {
                        content = (0, main_1.isHtmlEnable)(conf, col)
                            ? (0, dom_1.el)("div.dhx_grid-cell__content", __assign({ ".innerHTML": content }, getEditBtnAriaAttrs()))
                            : content;
                    }
                    var css = "".concat((col.$cellCss && col.$cellCss[row.id]) || "", " dhx_").concat(col.type, "-cell").replace(/\s+/g, " ");
                    var colWidth = col.$width;
                    var isEditable = conf.$editable &&
                        conf.$editable.row === row.id &&
                        conf.$editable.col === col.id &&
                        !conf.$editable.isSpan;
                    var leftSplit = conf.leftSplit, filteredColumns = conf.filteredColumns;
                    if (isEditable ||
                        (col.type === "boolean" &&
                            ((conf.editable && ((_a = col.editable) !== null && _a !== void 0 ? _a : true)) ||
                                (!conf.editable && col.editable)))) {
                        content = getEditorCell(row, col, conf).toHTML();
                        css += " dhx_grid-cell__editable";
                        if (leftSplit === filteredColumns.indexOf(col) + 1) {
                            colWidth -= 1;
                        }
                    }
                    if (conf.type === "tree" && conf.firstColId === col.id) {
                        return getTreeCell(content, row, col, conf);
                    }
                    if (conf.dragMode && !isEditable) {
                        css +=
                            (row.$drophere ? " dhx_grid-cell--drophere" : "") +
                                (row.$dragtarget ? " dhx_grid-cell--dragtarget" : "");
                    }
                    if (col.align) {
                        css += " dhx_align-".concat(col.align);
                    }
                    if ((0, main_1.isHtmlEnable)(conf, col)) {
                        css += " dhx_grid-cell__content_html-enable";
                    }
                    if (conf.autoHeight) {
                        css += " dhx_grid-cell__content_auto-height";
                    }
                    return (0, dom_1.el)(".dhx_grid-cell", __assign({ class: css, style: {
                            width: colWidth,
                            height: row.$height + "px",
                        }, _key: col.id, "data-dhx-col-id": col.id }, getCellAriaAttrs(col, pos.xStart + colIndex + 1, index, conf.editable)), [content]);
                }
            }));
    });
}
exports.getCells = getCells;
function getReverseScrollState(config) {
    var $scrollBarWidth = config.$scrollBarWidth;
    var totalScrollX = config.$totalWidth - config.$width + render_1.BORDERS + $scrollBarWidth.y;
    var totalScrollY = config.$totalHeight -
        config.$height +
        config.$headerHeight +
        config.$footerHeight +
        render_1.BORDERS +
        $scrollBarWidth.x;
    return {
        x: totalScrollX > 0 ? totalScrollX - config.scroll.left : 0,
        y: totalScrollY > 0 ? totalScrollY - config.scroll.top : 0,
    };
}
function getSpans(config, mode) {
    var _a, _b;
    var spanCells = [];
    var columns = config.columns, filteredColumns = config.filteredColumns, data = config.data, rSpans = config.spans, bottomSplit = config.bottomSplit;
    if (!filteredColumns.length || !rSpans)
        return null;
    var rightSplit = config.fixedColumns.right.length;
    var filteredSpans = rSpans.filter(function (span) { var _a; return (_a = span.$renderFrom) === null || _a === void 0 ? void 0 : _a.includes(config.$renderFrom); });
    var spans = filteredSpans.sort(function (a, b) {
        return typeof a.row === "string" && typeof b.row === "string"
            ? a.row.localeCompare(b.row)
            : a.row - b.row;
    });
    var _loop_1 = function (i) {
        var row = spans[i].row;
        var col = spans[i].column;
        var spanHeight = spans[i].rowspan || 1;
        var spanWidth = spans[i].colspan || 1;
        var spanText = spans[i].text;
        var spanCss = spans[i].css;
        var markCss = spans[i].$markCss;
        var spanType = spans[i].$type;
        var isFixedColsByBottomSplit = mode === types_1.Split.bottom && config.$renderFrom.endsWith("FixedCols");
        var rows = isFixedColsByBottomSplit ? config.$data : data;
        var colIndex = (0, core_1.findIndex)(filteredColumns, function (item) { return "".concat(item.id) === "".concat(col); });
        var rowIndex = (0, core_1.findIndex)(rows, function (item) { return "".concat(item.id) === "".concat(row); });
        if (colIndex < 0 || rowIndex < 0) {
            return "continue";
        }
        if (isFixedColsByBottomSplit) {
            var item_1 = config.$data[rowIndex + spanHeight - 1];
            if (!data.find(function (i) { return i.id === (item_1 === null || item_1 === void 0 ? void 0 : item_1.id); }))
                return "continue";
        }
        var currCol = filteredColumns[colIndex];
        var currRow = rows[rowIndex];
        if (currCol.hidden) {
            return "continue";
        }
        var content = void 0;
        if ((0, core_1.isDefined)(spanText)) {
            content = spanText.toString();
        }
        else {
            content = currRow[col] === undefined ? "" : (0, data_1.toFormat)(currRow[col], currCol.type, currCol.format);
        }
        var t = function (text, _row, _col) { return (text || text === 0 ? text : ""); };
        var template = currCol.template || t;
        content = template(content, currRow, currCol);
        var htmlEnable = (0, main_1.isHtmlEnable)(config, currCol);
        content =
            typeof content === "string"
                ? (0, dom_1.el)("div.dhx_span-cell-content", {
                    ".innerHTML": htmlEnable ? content : null,
                }, htmlEnable ? null : content)
                : content;
        var top_1 = void 0;
        if (config.$renderFrom === "bottomFixedRows" || isFixedColsByBottomSplit) {
            var rowIndexStartSplit = rows.length - bottomSplit;
            top_1 =
                rowIndex < rowIndexStartSplit
                    ? -(0, main_1.getTotalHeight)(rows.slice(rowIndex, rowIndexStartSplit))
                    : (0, main_1.getTotalHeight)(rows.slice(rowIndexStartSplit, rowIndex));
        }
        else {
            top_1 = (0, main_1.getTotalHeight)(rows.slice(0, rowIndex)) - (mode ? 0 : 1);
        }
        var left = 0;
        if (config.$renderFrom === "rightFixedCols") {
            var colIndexStartSplit = filteredColumns.length - config.fixedColumns.right.length;
            left =
                colIndex < colIndexStartSplit
                    ? -(0, main_1.getTotalWidth)(filteredColumns.slice(colIndex, colIndexStartSplit))
                    : (0, main_1.getTotalWidth)(filteredColumns.slice(colIndexStartSplit, colIndex));
        }
        else {
            for (var s = colIndex - 1; s >= 0; s--) {
                left += filteredColumns[s].$width;
            }
        }
        var isExpandingSpan = currRow.$items && colIndex === 0;
        var rowspanWithLastCol = colIndex === filteredColumns.length - 1;
        var colspanWithLastCol = colIndex + (0, cells_1.getReducedColspan)(columns, col, spanWidth) === filteredColumns.length;
        var firstRightFixedCol = rightSplit && colIndex === filteredColumns.length - rightSplit;
        var allFixedSpanByBottomFixedRows = mode === types_1.Split.bottom && config.fixedRows.bottom.find(function (item) { return item.id === row; });
        var bottomFixedRowWithPartSpan = bottomSplit && rowIndex + spanHeight > rows.length - bottomSplit;
        var spanBeforeFixedCol = rightSplit && colIndex + spanWidth === filteredColumns.length - rightSplit;
        var css = currCol.header[0].text ? " dhx_span-cell" : " dhx_span-cell dhx_span-cell--title";
        css += isExpandingSpan ? " dhx_span-expand-cell" : "";
        css += markCss ? " ".concat(markCss) : "";
        css += spanCss ? " ".concat(spanCss) : "";
        css += rowIndex === 0 ? " dhx_span-first-row" : "";
        css += rowIndex + spanHeight === rows.length ? " dhx_grid__span_bottom--last-row" : "";
        css += colIndex === 0 || firstRightFixedCol ? " dhx_span-first-col" : "";
        css += rowspanWithLastCol || colspanWithLastCol ? " dhx_span-last-col" : "";
        css += spanWidth === 1 ? " dhx_span-".concat(currCol.type || "string", "-cell") : " dhx_span-string-cell";
        css += currCol.align ? " dhx_align-".concat(currCol.align) : " dhx_".concat(spanType, "-cell");
        css += allFixedSpanByBottomFixedRows ? " dhx_grid__span_bottom--all-fixed" : "";
        css += bottomFixedRowWithPartSpan ? " dhx_grid__span_bottom--part-fixed" : "";
        css += spanBeforeFixedCol ? " dhx_grid__span_right--before-fixed" : "";
        var rColIndex = (0, core_1.findIndex)(columns, function (item) { return item.id === col; });
        var width = spanWidth > 1 ? (0, cells_1.getWidth)(columns, spanWidth, rColIndex) : currCol.$width;
        var height = void 0;
        if (spanHeight > 1) {
            height = (0, cells_1.getHeight)(rows, spanHeight, rowIndex);
            if (mode === types_1.Split.top && config.$renderFrom.endsWith("FixedCols")) {
                var delta = rowIndex + spanHeight - rows.length;
                if (delta > 0) {
                    var i_1 = config.fixedRows.top.length;
                    height += (0, main_1.getTotalHeight)(config.$data.slice(i_1, i_1 + delta));
                }
            }
        }
        else {
            height = currRow.$height;
        }
        var zIndex = null;
        var isEditable = (((_a = config.$editable) === null || _a === void 0 ? void 0 : _a.isSpan) && config.$editable.row === row && config.$editable.col === col) ||
            (currCol.type === "boolean" &&
                ((config.editable && ((_b = currCol.editable) !== null && _b !== void 0 ? _b : true)) || (!config.editable && currCol.editable)));
        if (isEditable) {
            var topSplit = config.topSplit;
            var leftSplit = config.fixedColumns.left.length;
            var allFixedByCol = (leftSplit && colIndex + spanWidth <= leftSplit) ||
                (rightSplit && colIndex >= filteredColumns.length - rightSplit);
            var fixedByRow = rowIndex < (topSplit || 0) || rowIndex + spanHeight > rows.length - (bottomSplit || 0);
            var allFixedByRow = (topSplit && rowIndex + spanHeight <= topSplit) ||
                (bottomSplit && rowIndex >= rows.length - bottomSplit);
            var fixedByCol = colIndex < (leftSplit || 0) ||
                colIndex + spanWidth > filteredColumns.length - (rightSplit || 0);
            if (config.$renderFrom === "render" ||
                (allFixedByCol && !fixedByRow) ||
                (allFixedByRow && !fixedByCol)) {
                var $height = config.$height, $scrollBarWidth = config.$scrollBarWidth, scroll_1 = config.scroll, fixedRows = config.fixedRows, fixedColumns = config.fixedColumns;
                var text = spans[i].text;
                var gap = 0;
                content = getEditorCell(currRow, currCol, config).toHTML(text);
                css += " dhx_span__editable";
                if (!allFixedByRow) {
                    var topFixedHeight = (0, main_1.getTotalHeight)(fixedRows.top);
                    var bottomFixedHeight = (0, main_1.getTotalHeight)(fixedRows.bottom);
                    var bodyHeight = $scrollBarWidth.yState
                        ? $height - config.$headerHeight - config.$footerHeight - $scrollBarWidth.x - render_1.BORDERS
                        : config.$totalHeight;
                    var bottomByScroll = top_1 + height - scroll_1.top;
                    var isOutsideByTop = top_1 - topFixedHeight < scroll_1.top;
                    var isOutsideByBottom = bottomByScroll > bodyHeight - bottomFixedHeight;
                    if (isOutsideByTop && isOutsideByBottom && $scrollBarWidth.xState)
                        gap = 1;
                    top_1 = isOutsideByTop
                        ? scroll_1.top + topFixedHeight - (topFixedHeight && !allFixedByCol ? 1 : 0)
                        : top_1;
                    if (isOutsideByBottom) {
                        height = bodyHeight - top_1 - bottomFixedHeight + scroll_1.top - gap;
                    }
                    else {
                        height = isOutsideByTop ? bottomByScroll - topFixedHeight : height;
                    }
                }
                if (config.$renderFrom === "render") {
                    zIndex = 12;
                    if (fixedColumns.left.find(function (i) { return i.id === col; })) {
                        left = scroll_1.left + (0, main_1.getTotalWidth)(fixedColumns.left.slice(0, colIndex));
                        if (!allFixedByCol) {
                            var minWidth = (0, main_1.getTotalWidth)(fixedColumns.left.slice(colIndex, leftSplit));
                            width = width - scroll_1.left > minWidth ? width - scroll_1.left : minWidth;
                        }
                    }
                    if (fixedRows.top.find(function (i) { return i.id === row; })) {
                        top_1 = scroll_1.top + (0, main_1.getTotalHeight)(fixedRows.top.slice(0, rowIndex));
                        if (!allFixedByRow) {
                            var minHeight = (0, main_1.getTotalHeight)(config.fixedRows.top.slice(rowIndex, config.topSplit));
                            height = height > 0 ? minHeight + height - gap : minHeight;
                        }
                    }
                    if (fixedColumns.right.find(function (col) {
                        return col === filteredColumns[filteredColumns.indexOf(currCol) + spanWidth - 1];
                    })) {
                        var totalLength = filteredColumns.length;
                        var reverseScrollState = getReverseScrollState(config);
                        var i_2 = totalLength - filteredColumns.indexOf(currCol) - spanWidth;
                        var minWidth = i_2
                            ? (0, main_1.getTotalWidth)(fixedColumns.right.slice(0, -i_2))
                            : (0, main_1.getTotalWidth)(fixedColumns.right);
                        var widthBeforeFixed = (0, main_1.getTotalWidth)(filteredColumns.slice(colIndex, totalLength - rightSplit));
                        left =
                            reverseScrollState.x > widthBeforeFixed
                                ? left - reverseScrollState.x + widthBeforeFixed
                                : left;
                        if (!allFixedByCol) {
                            width =
                                reverseScrollState.x < widthBeforeFixed
                                    ? width - reverseScrollState.x - 1
                                    : minWidth - 1;
                        }
                    }
                    if (fixedRows.bottom.find(function (row) {
                        return row === rows[rows.indexOf(currRow) + spanHeight - 1];
                    })) {
                        var totalLength = rows.length;
                        var reverseScrollState = getReverseScrollState(config);
                        var i_3 = totalLength - rows.indexOf(currRow) - spanHeight;
                        var minHeight = i_3
                            ? (0, main_1.getTotalHeight)(fixedRows.bottom.slice(0, -i_3))
                            : (0, main_1.getTotalHeight)(config.fixedRows.bottom);
                        var heightBeforeFixed = (0, main_1.getTotalHeight)(rows.slice(rowIndex, totalLength - bottomSplit));
                        top_1 =
                            reverseScrollState.y > heightBeforeFixed
                                ? top_1 - reverseScrollState.y + heightBeforeFixed
                                : top_1;
                        if (!allFixedByRow) {
                            height =
                                reverseScrollState.y < heightBeforeFixed
                                    ? minHeight + height - gap - (i_3 ? -1 : gap ? 0 : 1)
                                    : minHeight - (i_3 ? -1 : 1);
                        }
                    }
                }
                if (leftSplit === colIndex + 1) {
                    width -= 1;
                }
                if (colIndex === filteredColumns.length - rightSplit) {
                    left += 1;
                    width -= 1;
                }
            }
        }
        spanCells.push((0, dom_1.el)("div", {
            class: css,
            style: {
                width: width,
                height: height,
                top: top_1,
                left: left,
                zIndex: zIndex,
            },
            "data-dhx-col-id": col,
            "data-dhx-id": row,
            "aria-hidden": "true",
        }, [
            isExpandingSpan
                ? (0, dom_1.el)(".dhx_span-expand-cell-icon", {
                    class: currRow.$opened ? "dxi dxi-chevron-up" : "dxi dxi-chevron-down",
                    "data-dhx-id": currRow.id,
                    role: "button",
                    "aria-label": currRow.$opened ? "Collapse group" : "Expand group",
                    style: {
                        padding: "0 0 0 ".concat(4 + (0, data_1.getTreeCellWidthOffset)(currRow), "px"),
                    },
                })
                : null,
            content,
        ]));
    };
    for (var i = 0; i < spans.length; i++) {
        _loop_1(i);
    }
    return spanCells;
}
exports.getSpans = getSpans;
function getShifts(conf) {
    var columnsLeft = conf.filteredColumns.slice(0, conf.$positions.xStart);
    var rowsTop = conf.data.slice(0, conf.$positions.yStart);
    return {
        x: (0, main_1.getTotalWidth)(columnsLeft),
        y: (0, main_1.getTotalHeight)(rowsTop),
    };
}
exports.getShifts = getShifts;
function normalizeSpan(span, config) {
    var _a = config.topSplit, topSplit = _a === void 0 ? 0 : _a, _b = config.bottomSplit, bottomSplit = _b === void 0 ? 0 : _b, data = config.data, columns = config.columns;
    var leftSplit = (0, render_1.getCurrFixedCols)(config, types_1.Split.left).length;
    var rightSplit = (0, render_1.getCurrFixedCols)(config, types_1.Split.right).length;
    var column = span.column, row = span.row, colspan = span.colspan, rowspan = span.rowspan;
    var colIndexStart = columns.findIndex(function (c) { return c.id == column; });
    var $type = (0, core_1.isDefined)(span.text) ? "string" : columns[colIndexStart].type;
    var rowIndexStart = data.findIndex(function (r) { return r.id == row; });
    var colIndexEnd = colIndexStart + (colspan ? colspan - 1 : 0);
    var rowIndexEnd = rowIndexStart + (rowspan ? rowspan - 1 : 0);
    var $renderFrom = [];
    var fixedLeftByStart = colIndexStart < leftSplit;
    var fixedTopByStart = rowIndexStart < topSplit;
    var fixedRightByEnd = colIndexEnd >= columns.length - rightSplit;
    var fixedBottomByEnd = rowIndexEnd >= data.length - bottomSplit;
    // if the span is not fully fixed
    if (colIndexEnd >= leftSplit &&
        rowIndexEnd >= topSplit &&
        colIndexStart < columns.length - rightSplit &&
        rowIndexStart < data.length - bottomSplit) {
        $renderFrom.push("render");
    }
    // if the span is fixed left
    if (fixedLeftByStart) {
        $renderFrom.push("leftFixedCols");
    }
    // if the span is fixed right
    if (fixedRightByEnd) {
        $renderFrom.push("rightFixedCols");
    }
    // if the span isn't fixed left or right and fixed top
    if (fixedTopByStart && !fixedLeftByStart && !fixedRightByEnd) {
        $renderFrom.push("topFixedRows");
    }
    else if (fixedTopByStart && !$renderFrom.includes("render")) {
        $renderFrom.push("render");
    }
    // if the span isn't fixed left or right and fixed bottom
    if (fixedBottomByEnd && !fixedLeftByStart && !fixedRightByEnd) {
        $renderFrom.push("bottomFixedRows");
    }
    else if (fixedBottomByEnd && !$renderFrom.includes("render")) {
        $renderFrom.push("render");
    }
    return __assign(__assign({}, span), { $renderFrom: $renderFrom, $type: $type });
}
exports.normalizeSpan = normalizeSpan;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectionEvents = void 0;
var SelectionEvents;
(function (SelectionEvents) {
    SelectionEvents["beforeUnSelect"] = "beforeunselect";
    SelectionEvents["afterUnSelect"] = "afterunselect";
    SelectionEvents["beforeSelect"] = "beforeselect";
    SelectionEvents["afterSelect"] = "afterselect";
})(SelectionEvents || (exports.SelectionEvents = SelectionEvents = {}));


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNavbarButtonCSS = exports.navbarComponentMixin = exports.getIcon = exports.getCount = void 0;
var dom_1 = __webpack_require__(0);
var core_1 = __webpack_require__(1);
function getCount(item, widgetClass, isLimited) {
    var countColor = {
        danger: " dhx_navbar-count--color_danger",
        secondary: " dhx_navbar-count--color_secondary",
        primary: " dhx_navbar-count--color_primary",
        success: " dhx_navbar-count--color_success",
    }[item.countColor] || " dhx_navbar-count--color_danger";
    return (0, dom_1.el)(".dhx_navbar-count", {
        class: widgetClass +
            countColor +
            (!isLimited && parseInt(item.count, 10) > 99 ? " dhx_navbar-count--overlimit" : ""),
    }, isLimited && parseInt(item.count, 10) > 99 ? "99+" : item.count);
}
exports.getCount = getCount;
function getIcon(iconName, type) {
    if (iconName === void 0) { iconName = ""; }
    if (iconName.startsWith("dxi")) {
        iconName = "dxi " + iconName;
    }
    return (0, dom_1.el)("span", {
        class: "dhx_".concat(type, "__icon ").concat(iconName),
        "aria-hidden": "true",
    });
}
exports.getIcon = getIcon;
var getNavbarItemClass = function (widgetName, item, asMenuItem) {
    var baseClassName = "";
    var resultClassName = "";
    if (asMenuItem) {
        baseClassName = "dhx_menu-item";
    }
    else {
        baseClassName = "dhx_" + widgetName + "__item";
    }
    resultClassName = baseClassName + (item.css ? " " + item.css : "");
    if (item.type === "spacer" || item.type === "separator") {
        resultClassName += " ".concat(baseClassName, "--").concat(item.type);
    }
    if (item.type === "button" && widgetName === "sidebar" && !item.icon) {
        resultClassName += " dhx_navbar-item--colapse_hidden";
    }
    return resultClassName;
};
function navbarComponentMixin(widgetName, item, asMenuItem, body) {
    var getAriaAttrs = function (type) {
        var attrs = {
            role: "none",
        };
        if (type === "separator") {
            attrs.role = "separator";
            attrs["aria-orientation"] = "vertical";
        }
        return attrs;
    };
    var itemClass = getNavbarItemClass(widgetName, item, asMenuItem);
    var hasRibbonSize = widgetName === "ribbon" && (item.type === "navItem" || item.type === "imageButton");
    return (0, dom_1.el)("li", __assign({ _key: item.id, class: itemClass +
            (item.icon && !item.value && hasRibbonSize ? " dhx_ribbon__item--icon" : "") +
            (item.src && !item.value && hasRibbonSize ? " dhx_ribbon__item--icon" : "") +
            (item.size && hasRibbonSize ? " dhx_ribbon__item--" + item.size : ""), ".innerHTML": item.type === "customHTML" ? item.html : undefined, "data-dhx-id": item.type === "customHTML" ? item.id : undefined }, getAriaAttrs(item.type)), item.type !== "customHTML" ? [body] : undefined);
}
exports.navbarComponentMixin = navbarComponentMixin;
function getNavbarButtonCSS(_a, widgetName) {
    var color = _a.color, size = _a.size, view = _a.view, full = _a.full, icon = _a.icon, circle = _a.circle, loading = _a.loading, value = _a.value, active = _a.active, count = _a.count;
    var colorsCss = {
        danger: " dhx_button--color_danger",
        secondary: " dhx_button--color_secondary",
        primary: " dhx_button--color_primary",
        success: " dhx_button--color_success",
    }[color] || " dhx_button--color_primary";
    var sizeCss = {
        small: " dhx_button--size_small",
        medium: " dhx_button--size_medium",
    }[size] || " dhx_button--size_medium";
    var viewCss = {
        flat: " dhx_button--view_flat",
        link: " dhx_button--view_link",
    }[view] || " dhx_button--view_flat";
    var fullCss = full ? " dhx_button--width_full" : "";
    var circleCss = circle ? " dhx_button--circle" : "";
    var loadingCss = loading ? " dhx_button--loading" : "";
    var iconViewCss = icon && !value ? " dhx_button--icon" : "";
    var activeCss = active ? " dhx_button--active" : "";
    var countCss = (0, core_1.isDefined)(count) ? " dhx_button--count" : "";
    return (colorsCss + sizeCss + viewCss + fullCss + circleCss + loadingCss + activeCss + iconViewCss + countCss);
}
exports.getNavbarButtonCSS = getNavbarButtonCSS;


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.radarScale = exports.pieLikeHandlers = exports.shiftCoordinates = exports.getCoordinates = void 0;
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
function getCoordinates(percent, radiusX, radiusY, stroke) {
    if (stroke) {
        percent = percent + (2 * radiusX * Math.asin((0.5 * stroke) / radiusX)) / (2 * Math.PI * radiusX);
    }
    var x = Math.cos(2 * Math.PI * percent) * radiusX;
    var y = Math.sin(2 * Math.PI * percent) * radiusY;
    return [x, y];
}
exports.getCoordinates = getCoordinates;
function shiftCoordinates(item, dx, dy) {
    return [item[0] + dx, item[1] + dy];
}
exports.shiftCoordinates = shiftCoordinates;
function setTransform(elem, shiftX, shiftY) {
    elem.setAttribute("transform", "translate(".concat(shiftX, ", ").concat(shiftY, ") scale(1.05)"));
    elem.classList.add("dhx_pie-transform-delay");
}
function removeTransform(elem) {
    elem.setAttribute("transform", "translate(0, 0)");
    elem.classList.remove("dhx_pie-transform-delay");
}
exports.pieLikeHandlers = {
    onmouseover: function (shiftX, shiftY, _, node) {
        var id = node.parent.attrs.id;
        setTransform(node.el, shiftX, shiftY);
        node.parent.body.forEach(function (nodeEl) {
            if (nodeEl.attrs.id === "".concat(id, "-text") || nodeEl.attrs.id === "".concat(id, "-connector")) {
                setTransform(nodeEl.el, shiftX, shiftY);
            }
        });
    },
    onmouseout: function (_, node) {
        var id = node.parent.attrs.id;
        removeTransform(node.el);
        node.parent.body.forEach(function (nodeEl) {
            if (nodeEl.attrs.id === "".concat(id, "-text") || nodeEl.attrs.id === "".concat(id, "-connector")) {
                removeTransform(nodeEl.el);
            }
        });
    },
};
function checkMiss(v, r) {
    var miss = 0.000001;
    return v - miss < r && v + miss > r;
}
function drawBackgroundCircle(radius, color) {
    return (0, dom_1.sv)("circle", {
        cx: 0,
        cy: 0,
        r: radius,
        fill: color,
        stroke: "none",
        class: "background-circle",
    });
}
function arc(r, flag) {
    return "M".concat(-r, ",0A").concat(r, ",").concat(r, " 0 ").concat(flag ? 0 : 1, " 1 ").concat(r, ",0A").concat(r, ",").concat(r, " 0 ").concat(flag ? 0 : 1, " 1 ").concat(-r, ",0");
}
function radarScale(data, width, height) {
    var getScaleAriaAttrs = function (text) { return ({
        "aria-label": "x-axis".concat(text ? ", " + text : ""),
    }); };
    var radius;
    if (height > width) {
        radius = width / 2;
    }
    else {
        radius = height / 2;
    }
    var scalePercent = 1 / data.scales.length;
    var largeArcFlag = scalePercent > 0.5 ? 1 : 0;
    var svg = [];
    var background = drawBackgroundCircle(radius, "#fafafa");
    svg.push(background);
    var currentPercent = -0.25;
    var grid = [];
    var axis = data.axis;
    var gridClass = "radar-grid ".concat(data.zebra ? "zebra" : "");
    for (var i = 1; i < axis.length; i += 2) {
        var r1 = radius * axis[i - 1];
        var r2 = radius * axis[i];
        var d = "".concat(arc(r1, true), " ").concat(arc(r2, false));
        var arcs = (0, dom_1.sv)("path", {
            d: d,
            fill: "none",
            stroke: "black",
            class: gridClass,
        });
        grid.push(arcs);
    }
    svg.push(grid);
    data.scales.forEach(function (item) {
        var _a = getCoordinates(currentPercent, radius, radius), startX = _a[0], startY = _a[1];
        var nextPercent = currentPercent + scalePercent;
        var _b = getCoordinates(nextPercent, radius, radius), endX = _b[0], endY = _b[1];
        var d = "M ".concat(startX, " ").concat(startY, " A ").concat(radius, " ").concat(radius, " 0 ").concat(largeArcFlag, " 1 ").concat(endX, " ").concat(endY, " L 0 0");
        var path = (0, dom_1.sv)("path", {
            d: d,
            stroke: "black",
            fill: "none",
            class: "radar-scale",
        });
        svg.push(path);
        var _c = [8, 8], yTextPadding = _c[0], xTextPadding = _c[1];
        var dy = checkMiss(currentPercent, 0) || checkMiss(currentPercent, 0.5)
            ? 0
            : currentPercent < 0 || currentPercent > 0.5
                ? -yTextPadding
                : yTextPadding;
        var dx = checkMiss(currentPercent, -0.25) || checkMiss(currentPercent, 0.25)
            ? 0
            : currentPercent < -0.25 || currentPercent > 0.25
                ? -xTextPadding
                : xTextPadding;
        if (checkMiss(currentPercent, -0.25) || checkMiss(currentPercent, 0.25)) {
            var alignFn = checkMiss(currentPercent, -0.25) ? common_1.verticalTopText : common_1.verticalBottomText;
            var text = (0, dom_1.sv)("text", { x: startX + dx, y: startY + dy, class: "scale-text" }, [alignFn(item)]);
            svg.push(text);
        }
        else {
            var className = currentPercent >= -0.25 && currentPercent <= 0.25
                ? "start-text scale-text"
                : "end-text scale-text";
            var text = (0, dom_1.sv)("text", { x: startX + dx, y: startY + dy, class: className }, [
                (0, common_1.verticalCenteredText)(item),
            ]);
            svg.push(text);
        }
        currentPercent = nextPercent;
    });
    currentPercent = -0.25;
    if (data.realAxis) {
        var scaleText = data.realAxis.map(function (item, index) {
            var _a = getCoordinates(-0.25, radius * axis[index], radius * axis[index]), x = _a[0], y = _a[1];
            return (0, dom_1.sv)("text", { x: x, y: y, dx: -10, class: "radar-axis-text" }, [
                (0, common_1.verticalCenteredText)(item.toString()),
            ]);
        });
        svg.push(scaleText);
    }
    return (0, dom_1.sv)("g", __assign({ transform: "translate(".concat(width / 2, ", ").concat(height / 2, ")") }, getScaleAriaAttrs(data.attribute)), svg);
}
exports.radarScale = radarScale;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = __webpack_require__(1);
var types_1 = __webpack_require__(25);
var common_1 = __webpack_require__(5);
var line_1 = __webpack_require__(89);
var date_1 = __webpack_require__(16);
var BaseSeria = /** @class */ (function () {
    function BaseSeria(_data, config, other) {
        var _this = this;
        this._data = _data;
        this._handlers = {
            onclick: function (id, value) { return _this._events.fire(types_1.ChartEvents.serieClick, [id, value]); },
            onmousemove: function (id, value, e) {
                return _this._events.fire(types_1.ChartEvents.seriaMouseMove, [id, value, e]);
            },
            onmouseleave: function (id, value) {
                return _this._events.fire(types_1.ChartEvents.seriaMouseLeave, [id, value]);
            },
        };
        this.id = config.id = config.id || (0, core_1.uid)();
        this._events = other;
        this._points = [];
        this._setDefaults(config);
    }
    BaseSeria.prototype.toggle = function () {
        this.config.active = !this.config.active;
    };
    BaseSeria.prototype.getClosest = function (x, y) {
        var res = [Infinity, null, null, null];
        for (var _i = 0, _a = this._points; _i < _a.length; _i++) {
            var point = _a[_i];
            var dist = this._getClosestDist(x, y, point[0], point[1]);
            if (res[0] > dist) {
                res[0] = dist;
                res[1] = point[0];
                res[2] = point[1];
                res[3] = point[2];
            }
        }
        return res;
    };
    BaseSeria.prototype.getClosestVertical = function (x) {
        var res = [Infinity, null, null, null, null];
        for (var _i = 0, _a = this._points; _i < _a.length; _i++) {
            var point = _a[_i];
            var dist = Math.abs(point[0] - x);
            if (res[0] > dist) {
                res[0] = dist;
                res[1] = point[0];
                res[2] = point[1];
                res[3] = point[2];
                res[4] = point[4];
            }
        }
        return res;
    };
    BaseSeria.prototype.getTooltipType = function (_id) {
        return "top";
    };
    BaseSeria.prototype.getTooltipText = function (id) {
        if (!this._data.getItem(id) && this.config.type !== "calendarHeatMap") {
            return;
        }
        if (this.config.tooltip) {
            var p = void 0;
            var heatP = void 0;
            if (this.config.type === "calendarHeatMap") {
                heatP = this._points.find(function (i) { return i[2] === id.toString(); });
                if (heatP) {
                    var heatDate = new Date();
                    heatDate.setTime(heatP[0]);
                    heatP = [
                        (0, date_1.getFormattedDate)(this.config.dateFormat, heatDate),
                        heatP[1],
                    ];
                }
            }
            else {
                p = this._defaultLocator(this._data.getItem(id));
            }
            if (this.config.tooltipTemplate) {
                return this.config.tooltipTemplate(p || heatP);
            }
            return p ? p[0] : "".concat(heatP[1], ", <br>").concat(heatP[0]);
        }
    };
    BaseSeria.prototype.dataReady = function (prev) {
        return (this._points = []);
    };
    BaseSeria.prototype.paint = function (width, height) {
        return this._calckFinalPoints(width, height);
    };
    BaseSeria.prototype.getPoints = function () {
        return this._points;
    };
    BaseSeria.prototype.addScale = function (type, scale) {
        // do nothing
    };
    BaseSeria.prototype._getClosestDist = function (x, y, px, py) {
        return (0, common_1.euclideanDistance)(x, y, px, py);
    };
    BaseSeria.prototype._calckFinalPoints = function (_width, _height) {
        // do nothing
    };
    BaseSeria.prototype._setDefaults = function (config) {
        this.config = config;
    };
    BaseSeria.prototype._defaultLocator = function (_) {
        return [null, null];
    };
    BaseSeria.prototype._getPointType = function (form, color) {
        return (0, line_1.getShadeHelper)(form, color);
    };
    return BaseSeria;
}());
exports.default = BaseSeria;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getReducedColspan = exports.getHeight = exports.getWidth = void 0;
function getWidth(columns, colspan, index) {
    return columns
        .slice(index, index + (colspan || 1))
        .filter(function (col) { return !col.hidden; })
        .reduce(function (width, col) { return width + col.$width; }, 0);
}
exports.getWidth = getWidth;
function getHeight(dataRows, rowspan, index) {
    var rows = dataRows.filter(function (_a) {
        var hidden = _a.hidden;
        return !hidden;
    });
    if (!rowspan) {
        return rows[index].$height;
    }
    return rows.reduce(function (height, _a, i) {
        var $height = _a.$height;
        height += i >= index && i < index + rowspan ? $height : 0;
        return height;
    }, 0);
}
exports.getHeight = getHeight;
function getReducedColspan(columns, colId, colspan) {
    var index = columns.findIndex(function (item) { return item.id === colId; });
    return columns.slice(index, index + (colspan || 1)).filter(function (col) { return !col.hidden; }).length;
}
exports.getReducedColspan = getReducedColspan;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(136), exports);
__exportStar(__webpack_require__(73), exports);


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(74), exports);
__exportStar(__webpack_require__(152), exports);
__exportStar(__webpack_require__(78), exports);


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(75), exports);
__exportStar(__webpack_require__(150), exports);
__exportStar(__webpack_require__(76), exports);
__exportStar(__webpack_require__(48), exports);


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.VaultMode = exports.ProgressBarEvents = exports.UploaderEvents = exports.FileStatus = void 0;
var ts_data_1 = __webpack_require__(7);
var FileStatus;
(function (FileStatus) {
    FileStatus["queue"] = "queue";
    FileStatus["uploaded"] = "uploaded";
    FileStatus["failed"] = "failed";
    FileStatus["inprogress"] = "inprogress";
})(FileStatus || (exports.FileStatus = FileStatus = {}));
var UploaderEvents;
(function (UploaderEvents) {
    UploaderEvents["uploadBegin"] = "uploadbegin";
    UploaderEvents["beforeUploadFile"] = "beforeuploadfile";
    UploaderEvents["uploadFile"] = "uploadfile";
    UploaderEvents["uploadFail"] = "uploadfail";
    UploaderEvents["uploadComplete"] = "uploadcomplete";
    UploaderEvents["uploadProgress"] = "uploadprogress";
})(UploaderEvents || (exports.UploaderEvents = UploaderEvents = {}));
var ProgressBarEvents;
(function (ProgressBarEvents) {
    ProgressBarEvents["cancel"] = "cancel";
})(ProgressBarEvents || (exports.ProgressBarEvents = ProgressBarEvents = {}));
var VaultMode;
(function (VaultMode) {
    VaultMode["grid"] = "grid";
    VaultMode["list"] = "list";
})(VaultMode || (exports.VaultMode = VaultMode = {}));


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(81), exports);
__exportStar(__webpack_require__(177), exports);


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.NavigationBarEvents = exports.DataEvents = void 0;
var ts_data_1 = __webpack_require__(7);
Object.defineProperty(exports, "DataEvents", { enumerable: true, get: function () { return ts_data_1.DataEvents; } });
var NavigationBarEvents;
(function (NavigationBarEvents) {
    NavigationBarEvents["inputCreated"] = "inputCreated";
    NavigationBarEvents["click"] = "click";
    NavigationBarEvents["openMenu"] = "openMenu";
    NavigationBarEvents["beforeHide"] = "beforeHide";
    NavigationBarEvents["afterHide"] = "afterHide";
    NavigationBarEvents["inputFocus"] = "inputFocus";
    NavigationBarEvents["inputBlur"] = "inputBlur";
    NavigationBarEvents["inputChange"] = "inputChange";
    NavigationBarEvents["input"] = "input";
    NavigationBarEvents["keydown"] = "keydown";
})(NavigationBarEvents || (exports.NavigationBarEvents = NavigationBarEvents = {}));


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = exports.Validation = void 0;
var dom_1 = __webpack_require__(0);
var core_1 = __webpack_require__(1);
var helper_1 = __webpack_require__(6);
var label_1 = __webpack_require__(10);
var events_1 = __webpack_require__(2);
var types_1 = __webpack_require__(4);
var Validation;
(function (Validation) {
    Validation["empty"] = "";
    Validation["validEmail"] = "email";
    Validation["validInteger"] = "integer";
    Validation["validNumeric"] = "numeric";
    Validation["validAlphaNumeric"] = "alphanumeric";
    Validation["validIPv4"] = "IPv4";
})(Validation || (exports.Validation = Validation = {}));
var Input = /** @class */ (function (_super) {
    __extends(Input, _super);
    function Input(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, null, config) || this;
        _this.events = new events_1.EventSystem();
        _this._propsItem = [
            "inputType",
            "required",
            "validation",
            "icon",
            "placeholder",
            "autocomplete",
            "readOnly",
            "maxlength",
            "minlength",
            "min",
            "max",
            "step",
            "label",
            "labelWidth",
            "labelPosition",
            "hiddenLabel",
            "helpMessage",
            "preMessage",
            "successMessage",
            "errorMessage",
        ];
        _this._props = __spreadArray(__spreadArray([], helper_1.baseProps, true), _this._propsItem, true);
        _this._initView(config);
        _this._initHandlers();
        return _this;
    }
    Input.prototype.destructor = function () {
        this.events && this.events.clear();
        this.events = this._uid = this._propsItem = this._propsItem = null;
        _super.prototype._destructor.call(this);
        this.unmount();
    };
    Input.prototype.setProperties = function (propertyConfig) {
        if (!propertyConfig ||
            (0, core_1.isEmptyObj)(propertyConfig) ||
            !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()]))
            return;
        for (var key in propertyConfig) {
            if (this._props.includes(key)) {
                this.config[key] = propertyConfig[key];
            }
        }
        this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
        this.paint();
    };
    Input.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this._props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    Input.prototype.show = function () {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if (!hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [value])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [value]);
    };
    Input.prototype.hide = function (init) {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if ((hidden && !init) || !this.events.fire(types_1.ItemEvent.beforeHide, [value, init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [value, init]);
    };
    Input.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    Input.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    Input.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    Input.prototype.isDisabled = function () {
        return !!this.config.disabled;
    };
    Input.prototype.validate = function (silent, value) {
        if (silent === void 0) { silent = false; }
        if (value === void 0) { value = this.getValue(); }
        if (!silent && !this.events.fire(types_1.ItemEvent.beforeValidate, [value])) {
            return false;
        }
        var isValid = this.config.validation
            ? (0, helper_1.validateInput)(value, this.config.validation)
            : this.config.required
                ? !!((0, helper_1.baseInputValidate)(value, this.config) && String(value).trim().length)
                : (0, helper_1.baseInputValidate)(value, this.config);
        if (!silent) {
            this.setValidationStatus(isValid ? "success" : "error");
            this.events.fire(types_1.ItemEvent.afterValidate, [value, isValid]);
            !this.isFocused() && this.paint();
        }
        return isValid;
    };
    Input.prototype.clearValidate = function () {
        this.setValidationStatus();
        this.paint();
    };
    Input.prototype.clear = function () {
        if (this.config.value === "" || !this.events.fire(types_1.ItemEvent.beforeChange, [""]))
            return;
        this.config.value = "";
        this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        (0, helper_1.isVerify)(this.config) && this.setValidationStatus(this.validate(true) ? "success" : "error");
    };
    Input.prototype.setValue = function (value) {
        if (typeof value === "undefined" ||
            this.config.value === value ||
            !this.events.fire(types_1.ItemEvent.beforeChange, [value]))
            return;
        this.config.value = value;
        this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        (0, helper_1.isVerify)(this.config) && this.validate();
    };
    Input.prototype.getValue = function () {
        var _a = this.config, inputType = _a.inputType, value = _a.value;
        if ((inputType === "number" && typeof value === "number") || value === null) {
            return value;
        }
        if (inputType === "number" && typeof value === "string") {
            return value.length ? Number(value) : "";
        }
        if (typeof value === "string") {
            return value.length ? value : "";
        }
        return typeof value === "undefined" ? "" : String(value);
    };
    Input.prototype.isFocused = function () {
        var _a, _b, _c;
        return ((_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el) === document.activeElement;
    };
    Input.prototype.focus = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.focus();
        });
    };
    Input.prototype.blur = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.blur();
        });
    };
    Input.prototype._initView = function (config) {
        var _this = this;
        if ((0, core_1.isEmptyObj)(config)) {
            throw new Error("Check the configuration is correct");
        }
        this.config = {
            type: "input",
            id: config.id,
            name: config.name,
            disabled: false,
            hidden: false,
            inputType: "text",
            required: false,
            icon: "",
            placeholder: "",
            autocomplete: false,
            readOnly: false,
            label: "",
            labelWidth: "",
            labelPosition: "top",
            hiddenLabel: false,
            helpMessage: "",
            preMessage: "",
            successMessage: "",
            errorMessage: "",
            width: "content",
            height: "content",
        };
        for (var key in config) {
            if (key !== "id" && key !== "type" && key !== "name") {
                this.config[key] = config[key];
            }
        }
        if (this.config.hidden) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this.hide(true);
            });
        }
        this._value = this.config.value;
        this.paint();
    };
    Input.prototype._initHandlers = function () {
        var _this = this;
        this.events.on(types_1.ItemEvent.change, function (value) {
            _this._value = value;
            _this.paint();
        });
    };
    Input.prototype._getHandlers = function () {
        var _this = this;
        return {
            oninput: function (e) {
                _this._value = e.target.value;
                _this.events.fire(types_1.ItemEvent.input, [_this._value]);
            },
            onchange: function (e) {
                _this._value = e.target.value;
                if (_this._value !== _this.config.value)
                    _this.setValue(_this._value);
            },
            onfocus: function () {
                _this.events.fire(types_1.ItemEvent.focus, [_this.getValue()]);
                _this.paint();
            },
            onblur: function () {
                if (!_this._uid)
                    return;
                _this.events.fire(types_1.ItemEvent.blur, [_this.getValue()]);
                if (_this._value !== _this.config.value)
                    _this.setValue(_this._value);
                _this.paint();
            },
            onkeydown: function (event) {
                if (event.code === "Enter" && _this.config.type === "input")
                    event.preventDefault();
                _this.events.fire(types_1.ItemEvent.keydown, [event]);
            },
        };
    };
    Input.prototype._draw = function () {
        var _this = this;
        var _a = this.config, id = _a.id, disabled = _a.disabled, name = _a.name, icon = _a.icon, placeholder = _a.placeholder, required = _a.required, inputType = _a.inputType, hidden = _a.hidden, autocomplete = _a.autocomplete, readOnly = _a.readOnly, maxlength = _a.maxlength, minlength = _a.minlength, max = _a.max, min = _a.min, label = _a.label, helpMessage = _a.helpMessage, value = _a.value;
        var visibility = hidden ? " dhx_form-group--hidden" : "";
        return (0, dom_1.el)("div.dhx_form-group", {
            class: (0, helper_1.getFormItemCss)(this.config, (0, helper_1.isVerify)(this.config), this.isFocused()) + visibility,
        }, [
            this._drawLabel(),
            (0, dom_1.el)(".dhx_input__wrapper", {}, [
                (0, dom_1.el)("div.dhx_input__container", {}, [
                    this.config.icon
                        ? (0, dom_1.el)(".dhx_input__icon", {
                            class: this.config.icon,
                        })
                        : null,
                    (0, dom_1.el)("input.dhx_input", {
                        type: ["text", "number", "password"].includes(inputType) ? inputType : "text",
                        "data-dhx-id": name || id,
                        id: id || this._uid,
                        placeholder: placeholder || "",
                        value: value,
                        name: name || "",
                        disabled: disabled,
                        required: required,
                        readOnly: readOnly,
                        maxlength: maxlength,
                        minlength: minlength,
                        max: max,
                        min: min,
                        onblur: this._handlers.onblur,
                        oninput: this._handlers.oninput,
                        onchange: this._handlers.onchange,
                        onfocus: this._handlers.onfocus,
                        onkeydown: this._handlers.onkeydown,
                        class: icon ? "dhx_input--icon-padding" : "",
                        autocomplete: autocomplete ? "on" : "off",
                        _ref: "input",
                        "aria-label": label || helpMessage || "type ".concat(name || inputType || "text"),
                        "aria-describedby": helpMessage ? "dhx_label__help_".concat(id || this._uid) : null,
                        _hooks: {
                            didRecycle: function (_oldNode, newNode) {
                                if (_this.isFocused() && _this._value) {
                                    newNode.el.value = _this._value;
                                }
                            },
                        },
                    }),
                ]),
                (0, helper_1.getValidationMessage)(this.config) &&
                    (0, dom_1.el)("span.dhx_input__caption", (0, helper_1.getValidationMessage)(this.config)),
            ]),
        ]);
    };
    return Input;
}(label_1.Label));
exports.Input = Input;


/***/ }),
/* 40 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.ajax = void 0;
var types_1 = __webpack_require__(22);
var helpers_1 = __webpack_require__(23);
function toQueryString(data) {
    return Object.keys(data)
        .reduce(function (entries, key) {
        var value = typeof data[key] === "object" ? JSON.stringify(data[key]) : data[key];
        entries.push(key + "=" + encodeURIComponent(value));
        return entries;
    }, [])
        .join("&");
}
function inferResponseType(contentType) {
    if (!contentType) {
        return "text";
    }
    if (contentType.includes("json")) {
        return "json";
    }
    if (contentType.includes("xml")) {
        return "xml";
    }
    return "text";
}
function send(url, data, method, headers, responseType) {
    function parseResponse(responseText, genResponseType) {
        switch (genResponseType) {
            case "json": {
                return JSON.parse(responseText);
            }
            case "text": {
                return responseText;
            }
            case "xml": {
                var driver = (0, helpers_1.toDataDriver)(types_1.DataDriver.xml);
                if (driver) {
                    return driver.toJsonObject(responseText);
                }
                else {
                    return { parseError: "Incorrect data driver type: 'xml'" };
                }
            }
            default: {
                return responseText;
            }
        }
    }
    var allHeaders = headers || {};
    if (responseType) {
        allHeaders.Accept = "application/" + responseType;
    }
    if (method !== "GET") {
        allHeaders["Content-Type"] = allHeaders["Content-Type"] || "application/json";
    }
    if (method === "GET") {
        var urlData = data && typeof data === "object"
            ? toQueryString(data)
            : data && typeof data === "string"
                ? data
                : "";
        if (urlData) {
            url += !url.includes("?") ? "?" : "&";
            url += urlData;
        }
        data = null;
    }
    if (!window.fetch) {
        return new Promise(function (resolve, reject) {
            var xhr = new XMLHttpRequest();
            xhr.onload = function () {
                if (xhr.status >= 200 && xhr.status < 300) {
                    if (responseType === "raw") {
                        resolve({
                            url: xhr.responseURL,
                            headers: xhr
                                .getAllResponseHeaders()
                                .trim()
                                .split(/[\r\n]+/)
                                .reduce(function (acc, cur) {
                                var kv = cur.split(": ");
                                acc[kv[0]] = kv[1];
                                return acc;
                            }, {}),
                            body: xhr.response,
                        });
                    }
                    if (xhr.status === 204) {
                        resolve();
                    }
                    else {
                        resolve(parseResponse(xhr.responseText, responseType || inferResponseType(xhr.getResponseHeader("Content-Type"))));
                    }
                }
                else {
                    reject({
                        status: xhr.status,
                        statusText: xhr.statusText,
                    });
                }
            };
            xhr.onerror = function () {
                reject({
                    status: xhr.status,
                    statusText: xhr.statusText,
                    message: xhr.responseText,
                });
            };
            xhr.open(method, url);
            for (var headerKey in allHeaders) {
                xhr.setRequestHeader(headerKey, allHeaders[headerKey]);
            }
            switch (method) {
                case "POST":
                case "DELETE":
                case "PUT":
                    xhr.send(data !== undefined ? JSON.stringify(data) : "");
                    break;
                case "GET":
                    xhr.send();
                    break;
                default:
                    xhr.send();
                    break;
            }
        });
    }
    else {
        var isJson = allHeaders["Content-Type"] === "application/json";
        if (isJson && data && typeof data === "object") {
            data = JSON.stringify(data);
        }
        return window
            .fetch(url, {
            method: method,
            body: data || null,
            headers: allHeaders,
        })
            .then(function (response) {
            if (response.ok) {
                var genResponseType = responseType || inferResponseType(response.headers.get("Content-Type"));
                if (genResponseType === "raw") {
                    return {
                        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                        // @ts-ignore
                        headers: Object.fromEntries(response.headers.entries()),
                        url: response.url,
                        body: response.body,
                    };
                }
                if (response.status !== 204) {
                    switch (genResponseType) {
                        case "json": {
                            return response.json();
                        }
                        case "xml": {
                            var driver_1 = (0, helpers_1.toDataDriver)(types_1.DataDriver.xml);
                            if (driver_1) {
                                return response.text().then(function (xmlData) { return driver_1.toJsonObject(xmlData); });
                            }
                            else {
                                return response.text();
                            }
                        }
                        default:
                            return response.text();
                    }
                }
            }
            else {
                return response.text().then(function (message) {
                    return Promise.reject({
                        status: response.status,
                        statusText: response.statusText,
                        message: message,
                    });
                });
            }
        });
    }
}
exports.ajax = {
    get: function (url, data, config) {
        return send(url, data, "GET", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
    post: function (url, data, config) {
        return send(url, data, "POST", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
    put: function (url, data, config) {
        return send(url, data, "PUT", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
    delete: function (url, data, config) {
        return send(url, data, "DELETE", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
};

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageContainerPosition = exports.Position = exports.RealPosition = void 0;
var RealPosition;
(function (RealPosition) {
    RealPosition["left"] = "left";
    RealPosition["right"] = "right";
    RealPosition["top"] = "top";
    RealPosition["bottom"] = "bottom";
    RealPosition["center"] = "center";
})(RealPosition || (exports.RealPosition = RealPosition = {}));
var Position;
(function (Position) {
    Position["right"] = "right";
    Position["bottom"] = "bottom";
    Position["center"] = "center";
    Position["left"] = "left";
    Position["top"] = "top";
})(Position || (exports.Position = Position = {}));
var MessageContainerPosition;
(function (MessageContainerPosition) {
    MessageContainerPosition["topLeft"] = "top-left";
    MessageContainerPosition["topRight"] = "top-right";
    MessageContainerPosition["bottomLeft"] = "bottom-left";
    MessageContainerPosition["bottomRight"] = "bottom-right";
})(MessageContainerPosition || (exports.MessageContainerPosition = MessageContainerPosition = {}));


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    apply: "apply",
    reject: "reject",
};
exports.default = locale;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(137), exports);
__exportStar(__webpack_require__(72), exports);


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Layout = void 0;
var types_1 = __webpack_require__(46);
var Cell_1 = __webpack_require__(68);
var dom_1 = __webpack_require__(0);
var Layout = /** @class */ (function (_super) {
    __extends(Layout, _super);
    function Layout(parent, config) {
        var _this = _super.call(this, parent, config) || this;
        // root layout
        _this._root = _this.config.parent || _this;
        _this._all = {};
        _this._parseConfig();
        _this._progress = false;
        if (_this.config.activeTab) {
            _this.config.activeView = _this.config.activeTab;
        }
        // Need replace to tabbar
        if (_this.config.views) {
            _this.config.activeView = _this.config.activeView || _this._cells[0].id;
            _this._isViewLayout = true;
        }
        if (!config.parent) {
            var view = (0, dom_1.create)({ render: function () { return _this._root && _this.toVDOM(); } }, _this);
            _this.mount(parent, view);
        }
        return _this;
    }
    Layout.prototype.destructor = function () {
        if (this._all !== null && typeof this._all[Symbol.iterator] === "function") {
            for (var _i = 0, _a = this._all; _i < _a.length; _i++) {
                var key = _a[_i];
                this._all[key].destructor();
            }
        }
        this.config = this._cells = this._root = this._xLayout = this._isViewLayout = null;
        this._all = {};
        this.unmount();
    };
    Layout.prototype.toVDOM = function () {
        var _a;
        if (this._isViewLayout) {
            var roots = [this.getCell(this.config.activeView).toVDOM()];
            return _super.prototype.toVDOM.call(this, roots);
        }
        var nodes = [];
        this._inheritTypes();
        (_a = this._cells) === null || _a === void 0 ? void 0 : _a.forEach(function (cell) {
            var node = cell.toVDOM();
            if (Array.isArray(node)) {
                nodes = nodes.concat(node);
            }
            else {
                nodes.push(node);
            }
        });
        return _super.prototype.toVDOM.call(this, nodes);
    };
    Layout.prototype.removeCell = function (id) {
        if (!this.events.fire(types_1.LayoutEvents.beforeRemove, [id])) {
            return;
        }
        var root = this.config.parent || this;
        if (root !== this) {
            root.removeCell(id);
            return;
        }
        // this === root layout
        var view = this.getCell(id);
        if (view) {
            var parent_1 = view.getParent();
            delete this._all[id];
            parent_1._cells = parent_1._cells.filter(function (cell) { return cell.id != id; });
            parent_1.paint();
        }
        this.events.fire(types_1.LayoutEvents.afterRemove, [id]);
    };
    Layout.prototype.addCell = function (config, index) {
        if (index === void 0) { index = -1; }
        if (!this.events.fire(types_1.LayoutEvents.beforeAdd, [config.id])) {
            return;
        }
        var view = this._createCell(config);
        if (index < 0) {
            index = this._cells.length + index + 1;
        }
        this._cells.splice(index, 0, view);
        this.paint();
        if (!this.events.fire(types_1.LayoutEvents.afterAdd, [config.id])) {
            return;
        }
    };
    Layout.prototype.getId = function (index) {
        if (index < 0) {
            index = this._cells.length + index;
        }
        return this._cells[index] ? this._cells[index].id : undefined;
    };
    Layout.prototype.getRefs = function (name) {
        return this._root.getRootView().refs[name];
    };
    Layout.prototype.getCell = function (id) {
        var _a;
        return (_a = this._root) === null || _a === void 0 ? void 0 : _a._all[id];
    };
    Layout.prototype.forEach = function (callback, parent, level) {
        if (level === void 0) { level = Infinity; }
        if (!this._haveCells(parent) || level < 1) {
            return;
        }
        var array;
        if (parent) {
            array = this._root._all[parent]._cells;
        }
        else {
            array = this._root._cells;
        }
        for (var index = 0; index < array.length; index++) {
            var cell = array[index];
            callback.call(this, cell, index, array);
            if (this._haveCells(cell.id)) {
                cell.forEach(callback, cell.id, --level);
            }
        }
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Layout.prototype.cell = function (id) {
        return this.getCell(id);
    };
    Layout.prototype.progressShow = function () {
        this._progress = true;
        this.paint();
    };
    Layout.prototype.progressHide = function () {
        this._progress = false;
        this.paint();
    };
    Layout.prototype._getCss = function (content) {
        var layoutCss = this._xLayout ? "dhx_layout-columns" : "dhx_layout-rows";
        var directionCss = this.config.align ? " " + layoutCss + "--" + this.config.align : "";
        if (content) {
            return (layoutCss +
                " dhx_layout-cell" +
                (this.config.align ? " dhx_layout-cell--" + this.config.align : ""));
        }
        else {
            var cellCss = this.config.parent ? _super.prototype._getCss.call(this) : "dhx_widget dhx_layout";
            var fullModeCss = this.config.parent ? "" : " dhx_layout-cell";
            return cellCss + (this.config.full ? fullModeCss : " " + layoutCss) + directionCss;
        }
    };
    Layout.prototype._parseConfig = function () {
        var _this = this;
        var config = this.config;
        var cells = config.rows || config.cols || config.views || [];
        this._xLayout = !config.rows;
        this._cells = cells.map(function (a) { return _this._createCell(a); });
    };
    Layout.prototype._createCell = function (cell) {
        var view;
        if (cell.rows || cell.cols || cell.views) {
            cell.parent = this._root;
            view = new Layout(this, cell);
        }
        else {
            view = new Cell_1.Cell(this, cell);
        }
        // FIxME
        this._root._all[view.id] = view;
        if (cell.init) {
            cell.init(view, cell);
        }
        return view;
    };
    Layout.prototype._haveCells = function (id) {
        if (id) {
            var array = this._root._all[id];
            return array._cells && array._cells.length > 0;
        }
        return Object.keys(this._all).length > 0;
    };
    Layout.prototype._inheritTypes = function (obj) {
        var _this = this;
        if (obj === void 0) { obj = this._cells; }
        if (Array.isArray(obj)) {
            obj.forEach(function (cell) { return _this._inheritTypes(cell); });
        }
        else {
            var cellConfig = obj === null || obj === void 0 ? void 0 : obj.config;
            if ((cellConfig === null || cellConfig === void 0 ? void 0 : cellConfig.rows) || (cellConfig === null || cellConfig === void 0 ? void 0 : cellConfig.cols)) {
                var viewParent = obj.getParent();
                if (!cellConfig.type && viewParent) {
                    if (viewParent.config.type) {
                        cellConfig.type = viewParent.config.type;
                    }
                    else {
                        this._inheritTypes(viewParent);
                    }
                }
            }
        }
    };
    return Layout;
}(Cell_1.Cell));
exports.Layout = Layout;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LayoutEvents = void 0;
var LayoutEvents;
(function (LayoutEvents) {
    LayoutEvents["beforeShow"] = "beforeShow";
    LayoutEvents["afterShow"] = "afterShow";
    LayoutEvents["beforeHide"] = "beforeHide";
    LayoutEvents["afterHide"] = "afterHide";
    LayoutEvents["beforeResizeStart"] = "beforeResizeStart";
    LayoutEvents["resize"] = "resize";
    LayoutEvents["afterResizeEnd"] = "afterResizeEnd";
    LayoutEvents["beforeAdd"] = "beforeAdd";
    LayoutEvents["afterAdd"] = "afterAdd";
    LayoutEvents["beforeRemove"] = "beforeRemove";
    LayoutEvents["afterRemove"] = "afterRemove";
    LayoutEvents["beforeCollapse"] = "beforeCollapse";
    LayoutEvents["afterCollapse"] = "afterCollapse";
    LayoutEvents["beforeExpand"] = "beforeExpand";
    LayoutEvents["afterExpand"] = "afterExpand";
})(LayoutEvents || (exports.LayoutEvents = LayoutEvents = {}));


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(141), exports);
__exportStar(__webpack_require__(70), exports);


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ListEvents = void 0;
var ListEvents;
(function (ListEvents) {
    ListEvents["click"] = "click";
    ListEvents["doubleClick"] = "doubleclick";
    ListEvents["focusChange"] = "focuschange";
    ListEvents["beforeEditStart"] = "beforeEditStart";
    ListEvents["afterEditStart"] = "afterEditStart";
    ListEvents["beforeEditEnd"] = "beforeEditEnd";
    ListEvents["afterEditEnd"] = "afterEditEnd";
    ListEvents["itemRightClick"] = "itemRightClick";
    ListEvents["itemMouseOver"] = "itemMouseOver";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ListEvents["contextmenu"] = "contextmenu";
})(ListEvents || (exports.ListEvents = ListEvents = {}));


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    notFound: "Not Found",
    selectAll: "Select All",
    unselectAll: "Unselect All",
    selectedItems: "selected items",
    createItem: "Create",
};


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    dragAndDrop: "Drag & drop",
    or: "or",
    browse: "Browse files",
    filesOrFoldersHere: "files or folders here",
    cancel: "Cancel",
    clearAll: "Clear all",
    clear: "Clear",
    add: "Add",
    upload: "Upload",
    download: "Download",
    error: "error",
    byte: "B",
    kilobyte: "KB",
    megabyte: "MB",
    gigabyte: "GB",
};
exports.default = locale;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.locale = void 0;
__exportStar(__webpack_require__(182), exports);
__exportStar(__webpack_require__(83), exports);
__exportStar(__webpack_require__(82), exports);
__exportStar(__webpack_require__(52), exports);
var en_1 = __webpack_require__(53);
Object.defineProperty(exports, "locale", { enumerable: true, get: function () { return en_1.default; } });


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getAlpha = exports.alphaToHex = exports.isHex = exports.HexToHSV = exports.RGBToHSV = exports.HexToRGB = exports.RGBToHex = exports.HSVtoRGB = void 0;
function HSVtoRGB(hsv) {
    var rgb = { r: 0, g: 0, b: 0 };
    var h = hsv.h / 60;
    var s = hsv.s;
    var v = hsv.v;
    var i = Math.floor(h) % 6;
    var f = h - Math.floor(h);
    var p = 255 * v * (1 - s);
    var q = 255 * v * (1 - s * f);
    var t = 255 * v * (1 - s * (1 - f));
    v *= 255;
    switch (i) {
        case 0:
            rgb.r = v;
            rgb.g = t;
            rgb.b = p;
            break;
        case 1:
            rgb.r = q;
            rgb.g = v;
            rgb.b = p;
            break;
        case 2:
            rgb.r = p;
            rgb.g = v;
            rgb.b = t;
            break;
        case 3:
            rgb.r = p;
            rgb.g = q;
            rgb.b = v;
            break;
        case 4:
            rgb.r = t;
            rgb.g = p;
            rgb.b = v;
            break;
        case 5:
            rgb.r = v;
            rgb.g = p;
            rgb.b = q;
            break;
    }
    for (var key in rgb) {
        rgb[key] = Math.round(rgb[key]);
    }
    return rgb;
}
exports.HSVtoRGB = HSVtoRGB;
function RGBToHex(rgb) {
    return Object.keys(rgb).reduce(function (hex, c) {
        var h = rgb[c].toString(16).toUpperCase();
        h = h.length === 1 ? "0" + h : h;
        return (hex += h);
    }, "#");
}
exports.RGBToHex = RGBToHex;
function HexToRGB(hex) {
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (_m, r, g, b) { return r + r + g + g + b + b; });
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result
        ? {
            r: parseInt(result[1], 16),
            g: parseInt(result[2], 16),
            b: parseInt(result[3], 16),
        }
        : null;
}
exports.HexToRGB = HexToRGB;
function RGBToHSV(rgb) {
    var h;
    var s;
    var r = rgb.r / 255;
    var g = rgb.g / 255;
    var b = rgb.b / 255;
    var v = Math.max(r, g, b);
    var diff = v - Math.min(r, g, b);
    var diffc = function (c) {
        return (v - c) / 6 / diff + 1 / 2;
    };
    if (diff === 0) {
        h = s = 0;
    }
    else {
        s = diff / v;
        var rdif = diffc(r);
        var gdif = diffc(g);
        var bdif = diffc(b);
        if (r === v) {
            h = bdif - gdif;
        }
        else if (g === v) {
            h = 1 / 3 + rdif - bdif;
        }
        else if (b === v) {
            h = 2 / 3 + gdif - rdif;
        }
        if (h < 0) {
            h += 1;
        }
        else if (h > 1) {
            h -= 1;
        }
    }
    return {
        h: h * 360,
        s: s,
        v: v,
    };
}
exports.RGBToHSV = RGBToHSV;
function HexToHSV(hex) {
    return RGBToHSV(HexToRGB(hex.length === 9 ? hex.slice(0, -2) : hex));
}
exports.HexToHSV = HexToHSV;
function isHex(hex) {
    return /(^#[0-9A-F]{8}$)|(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
}
exports.isHex = isHex;
function alphaToHex(alpha) {
    var hex = Math.round(alpha * 255)
        .toString(16)
        .toUpperCase();
    return hex.length === 1 ? "0" + hex : hex;
}
exports.alphaToHex = alphaToHex;
function getAlpha(hex) {
    return hex.length === 9 ? Number((parseInt(hex.slice(-2), 16) / 255).toFixed(2)) : 1;
}
exports.getAlpha = getAlpha;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var en = {
    cancel: "Cancel",
    select: "Select",
    rightClickToDelete: "Right click to delete",
    customColors: "Custom colors",
    addNewColor: "Add new color",
};
exports.default = en;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scale = void 0;
var AxisCreator_1 = __webpack_require__(191);
var SvgScales_1 = __webpack_require__(86);
var common_1 = __webpack_require__(5);
var renderScale = {
    left: SvgScales_1.left,
    right: SvgScales_1.right,
    bottom: SvgScales_1.bottom,
    top: SvgScales_1.top,
};
var renderGrid = {
    left: SvgScales_1.leftGrid,
    right: SvgScales_1.rightGrid,
    bottom: SvgScales_1.bottomGrid,
    top: SvgScales_1.topGrid,
};
var Scale = /** @class */ (function () {
    function Scale(_data, config, position) {
        this._data = _data;
        this._padding = false;
        this._charts = [];
        this._position = position;
        this._setDefaults(config);
        this._isXDirection = position === "bottom" || position === "top";
        if (position !== "radial") {
            if (position === "left" || position === "right") {
                this.config.size = this.config.size || 40 + (this.config.title ? 40 : 0);
            }
            else {
                this.config.size = this.config.size || 20 + (this.config.title ? 40 : 0);
            }
        }
    }
    Scale.prototype.addPadding = function () {
        this._padding = true;
    };
    Scale.prototype.getSize = function () {
        return this.config.size;
    };
    Scale.prototype.scaleReady = function (sizes) {
        var points = [];
        this._charts.forEach(function (chart) {
            chart.getPoints().forEach(function (item) { return points.push(item[1]); }); // y-value
        });
        this._axis = new AxisCreator_1.AxisCreator(points, this.config).getScale();
        var position = this._position;
        if (position !== "radial") {
            sizes[position] += this.config.size;
        }
    };
    Scale.prototype.point = function (pos) {
        if (this.config.log) {
            return this._logPoint(pos);
        }
        else {
            return this._isXDirection
                ? (pos - this._axis.min) / (this._axis.max - this._axis.min)
                : 1 - (pos - this._axis.min) / (this._axis.max - this._axis.min);
        }
    };
    Scale.prototype.add = function (val) {
        this._charts.push(val);
    };
    Scale.prototype.paint = function (width, height) {
        var _this = this;
        if (this.config.hidden) {
            return null;
        }
        var steps = this._axis.steps;
        var points = steps.map(function (item) { return [
            _this._isXDirection ? _this.point(item) * width : _this.point(item) * height,
            item,
        ]; });
        if (points.length === 0 && this._position === "left") {
            points = [[0, 0]];
        }
        return renderScale[this._position](points, this.config, width, height);
    };
    Scale.prototype.scaleGrid = function () {
        var _this = this;
        var getPoints = function (width, height) {
            return _this._axis.steps.map(function (item) { return [
                _this._isXDirection ? _this.point(item) * width : _this.point(item) * height,
                item,
            ]; });
        };
        var type = this._position;
        var grid = this.config.grid;
        var dashed = this.config.dashed;
        var hidden = this.config.hidden;
        var getSpecificLevel = function () { return _this._axis.steps.indexOf(_this.config.targetLine); };
        var getSpecificNumber = function () { return _this.point(_this.config.targetValue); };
        return {
            paint: function (width, height) {
                var targetLine = getSpecificLevel();
                var points = getPoints(width, height);
                var targetValue = getSpecificNumber();
                var config = {
                    targetLine: targetLine,
                    dashed: dashed,
                    grid: grid,
                    targetValue: targetValue,
                    hidden: hidden,
                };
                return renderGrid[type](points, width, height, config);
            },
        };
    };
    Scale.prototype._setDefaults = function (config) {
        var defaults = {
            scalePadding: 20,
            textPadding: 11,
            grid: true,
            targetLine: null,
            showText: true,
        };
        if (config.locator) {
            this.locator = (0, common_1.locator)(config.locator);
        }
        this.config = __assign(__assign({}, defaults), config);
    };
    Scale.prototype._logPoint = function (pos) {
        var logPos;
        var sign = Math.abs(pos) / pos;
        var steps = this._axis.steps;
        var count = steps.length - 1;
        var index = steps.indexOf(pos);
        if (index !== -1) {
            logPos = index / count;
        }
        else {
            var dx = this._axis.min < 0 ? steps.indexOf(0) : 0;
            var exp = sign * (0, common_1.log10)(Math.abs(pos));
            logPos = (dx + exp) / count;
        }
        return this._isXDirection ? logPos : 1 - logPos;
    };
    return Scale;
}());
exports.Scale = Scale;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__(5);
var BaseSeria_1 = __webpack_require__(31);
var ScaleSeria = /** @class */ (function (_super) {
    __extends(ScaleSeria, _super);
    function ScaleSeria() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ScaleSeria.prototype.addScale = function (type, scale) {
        if (type === "bottom" || type === "top") {
            this.xScale = scale;
            this._xLocator = scale.locator;
        }
        else {
            this.yScale = scale;
            this._yLocator = (0, common_1.locator)(this.config.value);
        }
    };
    ScaleSeria.prototype.paint = function (width, height) {
        _super.prototype.paint.call(this, width, height);
    };
    ScaleSeria.prototype.dataReady = function (prev) {
        var _this = this;
        if (!this.config.active) {
            return (this._points = []);
        }
        this._points = this._data.map(function (item, index) {
            // raw values
            var x = _this._xLocator(item);
            var y = _this._yLocator(item);
            var set = [x, y, item.id, x, y];
            if (prev) {
                set[1] += prev[index][1];
            }
            return set;
        });
        return this._points;
    };
    ScaleSeria.prototype._calckFinalPoints = function (width, height) {
        var _this = this;
        this._points.forEach(function (item, index) {
            // scaled values
            item[0] = _this.xScale.point(item[0]) * width || 0;
            var pointHeight = _this.yScale.point(item[1]) * height;
            item[1] = !isNaN(pointHeight) ? pointHeight : _this.config.type === "xbar" ? 0 : height;
        });
    };
    ScaleSeria.prototype._defaultLocator = function (v) {
        return [this._yLocator(v), this._xLocator(v)];
    };
    return ScaleSeria;
}(BaseSeria_1.default));
exports.default = ScaleSeria;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__(5);
var BaseSeria_1 = __webpack_require__(31);
var NoScaleSeria = /** @class */ (function (_super) {
    __extends(NoScaleSeria, _super);
    function NoScaleSeria() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._center = [0, 0]; // (x, y)
        _this._tooltipData = []; // (x, y)
        return _this;
    }
    NoScaleSeria.prototype.scaleReady = function (sizes) {
        for (var key in sizes) {
            sizes[key] += this.config.paddings;
        }
        return sizes;
    };
    NoScaleSeria.prototype.dataReady = function () {
        var _this = this;
        var data = this._data;
        this._sum = data.reduce(function (sum, item) { return (item.$hidden ? sum : sum + parseFloat(_this._valueLocator(item))); }, 0);
        this._points = data.reduce(function (items, item, i) {
            if (item.$hidden) {
                return items;
            }
            var t = _this._textLocator(item);
            var v = _this._valueLocator(item);
            var x = v / _this._sum;
            var c = _this._colorLocator ? _this._colorLocator(item) : (0, common_1.getDefaultColor)(i);
            items.push([x, v, item.id, t, c]);
            return items;
        }, []);
        return this._points;
    };
    NoScaleSeria.prototype.toggle = function (id) {
        var item = this._data.getItem(id);
        if (!item) {
            return;
        }
        this._data.update(id, { $hidden: !item.$hidden });
    };
    NoScaleSeria.prototype.getClosest = function (x, y) {
        var percent = 1 - (Math.atan2(x - this._center[0], y - this._center[1]) + Math.PI) / Math.PI / 2;
        var points = this._points;
        for (var i = 0; i < points.length; i++) {
            if (points[i][0] >= percent) {
                return [0, this._tooltipData[i][0], this._tooltipData[i][1], points[i][2]];
            }
            percent -= points[i][0];
        }
        return [Infinity, null, null, null];
    };
    NoScaleSeria.prototype.getTooltipText = function (id) {
        if (this.config.tooltip) {
            var p = this._defaultLocator(this._data.getItem(id));
            if (this.config.tooltipTemplate) {
                return this.config.tooltipTemplate(p);
            }
            return p[0];
        }
    };
    NoScaleSeria.prototype.getTooltipType = function (_id) {
        return "simple";
    };
    NoScaleSeria.prototype._setDefaults = function (config) {
        var _this = this;
        var defaults = {
            subType: "basic",
            paddings: config.useLines ? 70 : 50,
        };
        this.config = __assign(__assign({}, defaults), config);
        this._drawPointType = this._getPointType("empty", "none");
        this._valueLocator = (0, common_1.locator)(config.value);
        this._textLocator = (0, common_1.locator)(config.text);
        if (config.color) {
            this._colorLocator = (0, common_1.locator)(config.color);
        }
        else if (config.monochrome) {
            this._colorLocator = function (item) { return (0, common_1.getColorShade)(config.monochrome, _this._getPercent(item) * 2); }; // 2 for more bright
        }
    };
    NoScaleSeria.prototype._defaultLocator = function (v) {
        return [this._valueLocator(v), this._textLocator(v)];
    };
    NoScaleSeria.prototype._getPercent = function (item) {
        return parseFloat(this._valueLocator(item)) / this._sum;
    };
    return NoScaleSeria;
}(BaseSeria_1.default));
exports.default = NoScaleSeria;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
var ScaleSeria_1 = __webpack_require__(55);
var Line = /** @class */ (function (_super) {
    __extends(Line, _super);
    function Line() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Line.prototype.paint = function (width, height) {
        var _this = this;
        _super.prototype.paint.call(this, width, height);
        var getChartAriaAttrs = function (cfg) { return ({
            "aria-label": "chart ".concat(cfg.value || ""),
        }); };
        var getPointAriaAttrs = function (key, points) {
            var point;
            if (key) {
                point = points.find(function (p) { return key.includes(p[2]); });
            }
            return {
                role: "graphics-symbol",
                "aria-roledescription": "point",
                "aria-label": point ? "point x=".concat(point[3], " y=").concat(point[4]) : "",
                tabindex: 0,
            };
        };
        var color = this.config.pointColor || this.config.color;
        var css = "chart ".concat(this.config.type, " ").concat(this.config.css || "", " ").concat(this.config.dashed ? "dash-line" : "");
        var svg = [];
        if (this.config.strokeWidth) {
            svg.push(this._getForm(this._points, this.config, css, width, height));
        }
        if (this.config.pointType) {
            var point_1 = this._getPointType(this.config.pointType, color);
            svg = svg.concat(this._points
                .map(function (p) { return point_1(p[0], p[1], (0, common_1.calcPointRef)(p[2], _this.id)); })
                .map(function (node, index) {
                if (node && node.attrs) {
                    node.attrs = __assign(__assign({}, node.attrs), getPointAriaAttrs(node.key, _this._points));
                    if (_this.config.tooltip) {
                        node.attrs.onmousemove = [
                            _this._handlers.onmousemove,
                            _this._points[index][2],
                            _this.id,
                        ];
                        node.attrs.onmouseleave = [
                            _this._handlers.onmouseleave,
                            _this._points[index][2],
                            _this.id,
                        ];
                        node.attrs.onclick = [
                            _this._handlers.onmousemove,
                            _this._points[index][2],
                            _this.id,
                        ];
                    }
                }
                return node;
            }));
        }
        return (0, dom_1.sv)("g", __assign(__assign({ class: "seria", _key: this.id }, getChartAriaAttrs(this.config)), { tabindex: 0 }), svg);
    };
    Line.prototype._getForm = function (points, config, css, width, height) {
        var d = points.map(function (item, index) { return (index ? "L" : "M") + "".concat(item[0], " ").concat(item[1]); }).join(" ");
        var path = (0, dom_1.sv)("path", {
            id: "seria" + config.id,
            d: d,
            stroke: config.color,
            class: css,
            "stroke-width": this.config.strokeWidth,
            fill: "none",
        });
        return path;
    };
    Line.prototype._setDefaults = function (config) {
        var defaults = {
            alpha: 1,
            strokeWidth: 2,
            active: true,
            tooltip: true,
        };
        this.config = __assign(__assign({}, defaults), config);
    };
    return Line;
}(ScaleSeria_1.default));
exports.default = Line;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(59), exports);
__exportStar(__webpack_require__(164), exports);
__exportStar(__webpack_require__(36), exports);


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.Uploader = void 0;
/* eslint-disable @typescript-eslint/unbound-method */
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(3);
var ts_data_1 = __webpack_require__(7);
var types_1 = __webpack_require__(36);
var Uploader = /** @class */ (function () {
    function Uploader(config, data, events) {
        if (config === void 0) { config = {}; }
        this.config = (0, core_1.extend)({
            autosend: true,
            updateFromResponse: true,
            fieldName: "file",
            accept: "",
        }, config);
        this.data = data || new ts_data_1.DataCollection();
        this.events = events || this.data.events;
        this.isActive = false;
        this._fileInput = document.createElement("input");
        this._fileInput.type = "file";
        this._fileInput.accept = this.config.accept;
        this._fileInput.multiple = true;
        this._initEvents();
        this._dropAreas = new Map();
    }
    Uploader.prototype.selectFile = function () {
        this._fileInput.click();
    };
    Uploader.prototype.linkDropArea = function (element) {
        var _this = this;
        var node = (0, html_1.toNode)(element);
        var dragover = function (e) { return e.preventDefault(); };
        var drop = function (e) {
            e.preventDefault();
            _this.parseFiles(e.dataTransfer);
        };
        node.addEventListener("dragover", dragover);
        node.addEventListener("drop", drop);
        this._dropAreas.set(node, {
            dragover: dragover,
            drop: drop,
        });
    };
    Uploader.prototype.unlinkDropArea = function (element) {
        var _this = this;
        if (!element) {
            this._dropAreas.forEach(function (_, node) {
                _this._unlinkDropArea(node);
            });
            this._dropAreas.clear();
        }
        else {
            var node = (0, html_1.toNode)(element);
            this._unlinkDropArea(node);
            this._dropAreas.delete(node);
        }
    };
    Uploader.prototype.parseFiles = function (dataTransfer) {
        if (!dataTransfer.items || !dataTransfer.items[0] || !dataTransfer.items[0].webkitGetAsEntry) {
            var files = dataTransfer.files;
            for (var i = 0; i < files.length; i++) {
                this._addFile(files[i]);
            }
            if (this.config.autosend) {
                this.send();
            }
        }
        else {
            this._parseAsWebkitEntry(dataTransfer.items);
        }
    };
    Uploader.prototype.send = function (params) {
        var _this = this;
        if (this._uploadInfo && this.isActive) {
            // cancel two active sends
            return;
        }
        var all = this.data.findAll(function (item) { return item.status === types_1.FileStatus.queue || item.status === types_1.FileStatus.failed; });
        var files = all.filter(function (file) { return _this.events.fire(types_1.UploaderEvents.beforeUploadFile, [file]); });
        if (!files.length) {
            return;
        }
        this.isActive = true;
        this._uploadInfo = {
            files: files,
            count: files.length,
            size: files.reduce(function (s, f) { return s + f.file.size; }, 0),
        };
        this.events.fire(types_1.UploaderEvents.uploadBegin, [files]);
        this.events.fire(types_1.UploaderEvents.uploadProgress, [0, 0, this._uploadInfo.size]);
        if (this.config.singleRequest) {
            this._xhrSend(files, params);
        }
        else {
            for (var _i = 0, files_1 = files; _i < files_1.length; _i++) {
                var fileWrapper = files_1[_i];
                this._xhrSend([fileWrapper], params);
            }
        }
    };
    Uploader.prototype.abort = function (id) {
        if (!id) {
            if (!this._uploadInfo || !this._uploadInfo.files) {
                return;
            }
            for (var _i = 0, _a = this._uploadInfo.files; _i < _a.length; _i++) {
                var fileWrapper = _a[_i];
                this.abort(fileWrapper.id);
            }
            return;
        }
        else {
            var item = this.data.getItem(id);
            if (!item || !item.request || item.request.readyState === 4) {
                return;
            }
            item.request.abort();
        }
    };
    Uploader.prototype._unlinkDropArea = function (node) {
        var handlers = this._dropAreas.get(node);
        if (!handlers) {
            return;
        }
        var dragover = handlers.dragover, drop = handlers.drop;
        node.removeEventListener("dragover", dragover);
        node.removeEventListener("drop", drop);
    };
    Uploader.prototype._initEvents = function () {
        var _this = this;
        this._fileInput.addEventListener("change", function () {
            var files = _this._fileInput.files;
            for (var i = 0; i < files.length; i++) {
                _this._addFile(files[i]);
            }
            if (_this.config.autosend) {
                _this.send();
            }
            _this._fileInput.value = null; // clear file input after get info about files
        });
    };
    Uploader.prototype._xhrSend = function (fileWrappers, params) {
        var _this = this;
        var formData = this._createFormData(fileWrappers, params);
        var request = new XMLHttpRequest();
        var headerParams = this.config.headerParams;
        for (var _i = 0, fileWrappers_1 = fileWrappers; _i < fileWrappers_1.length; _i++) {
            var fileWrapper = fileWrappers_1[_i];
            this.data.update(fileWrapper.id, {
                request: request,
                status: types_1.FileStatus.inprogress,
                progress: 0,
            });
        }
        request.open("POST", this.config.target);
        if (headerParams) {
            for (var headerItem in headerParams) {
                request.setRequestHeader(headerItem, headerParams[headerItem]);
            }
        }
        request.upload.onprogress = function (ev) {
            for (var _i = 0, fileWrappers_2 = fileWrappers; _i < fileWrappers_2.length; _i++) {
                var fileWrapper = fileWrappers_2[_i];
                _this.data.update(fileWrapper.id, {
                    progress: ev.loaded / ev.total,
                    status: types_1.FileStatus.inprogress,
                });
            }
            var current = _this._uploadInfo.files.reduce(function (tot, file) { return tot + file.size * file.progress; }, 0) || 0;
            var total = _this._uploadInfo.size;
            var progress = (current / _this._uploadInfo.size) * 100 || 0;
            _this.events.fire(types_1.UploaderEvents.uploadProgress, [progress, current, total]);
        };
        request.onloadend = function () {
            _this._uploadInfo.count = _this.config.singleRequest ? 0 : _this._uploadInfo.count - 1;
            var status = request.status === 200 ? types_1.FileStatus.uploaded : types_1.FileStatus.failed;
            var extra = request.status === 200 && request.response ? JSON.parse(request.response) : null;
            for (var _i = 0, fileWrappers_3 = fileWrappers; _i < fileWrappers_3.length; _i++) {
                var fileWrapper = fileWrappers_3[_i];
                _this.data.update(fileWrapper.id, { status: status });
                if (status === types_1.FileStatus.uploaded) {
                    if (_this.config.updateFromResponse && extra) {
                        if (_this.config.singleRequest && extra[fileWrapper.id]) {
                            _this.data.update(fileWrapper.id, extra[fileWrapper.id]);
                        }
                        else if (!_this.config.singleRequest) {
                            _this.data.update(fileWrapper.id, extra);
                        }
                    }
                    _this.events.fire(types_1.UploaderEvents.uploadFile, [fileWrapper, extra]);
                }
                else {
                    _this.events.fire(types_1.UploaderEvents.uploadFail, [fileWrapper]);
                }
            }
            if (_this._uploadInfo.count === 0) {
                _this.isActive = false;
                _this.events.fire(types_1.UploaderEvents.uploadComplete, [_this._uploadInfo.files]);
            }
        };
        request.send(formData);
    };
    Uploader.prototype._parseAsWebkitEntry = function (items) {
        var _this = this;
        var reads = [];
        for (var i = 0; i < items.length; i++) {
            var item = items[i].webkitGetAsEntry();
            reads.push(this._traverseFileTree(item));
        }
        Promise.all(reads).then(function () {
            if (_this.config.autosend) {
                _this.send();
            }
        });
    };
    Uploader.prototype._createFormData = function (fileWrappers, params) {
        var fieldName = this.config.fieldName;
        var formData = new FormData();
        var extraParams = this.config.params;
        if (params) {
            for (var key in params) {
                formData.append(key, params[key]);
            }
        }
        if (extraParams) {
            for (var key in extraParams) {
                formData.append(key, extraParams[key]);
            }
        }
        var brackets = fileWrappers.length > 1 ? "[]" : "";
        for (var _i = 0, fileWrappers_4 = fileWrappers; _i < fileWrappers_4.length; _i++) {
            var fileWrapper = fileWrappers_4[_i];
            formData.append(fieldName + brackets, fileWrapper.file, fileWrapper.file.name);
            formData.append(fieldName + "_fullname" + brackets, fileWrapper.path + fileWrapper.file.name);
            var id = typeof fileWrapper.id === "object" ? fileWrapper.id : fileWrapper.id.toString();
            formData.append(fieldName + "_id" + brackets, id);
        }
        return formData;
    };
    Uploader.prototype._addFile = function (file, path) {
        if (path === void 0) { path = ""; }
        var fileWrapper = {
            id: (0, core_1.uid)(),
            file: file,
            progress: 0,
            status: types_1.FileStatus.queue,
            src: null,
            path: path,
        };
        this.data.add(fileWrapper);
    };
    Uploader.prototype._traverseFileTree = function (item) {
        var _this = this;
        return new Promise(function (res) {
            var count = 0;
            var readDirectory = function (reader, path) {
                count++;
                reader.readEntries(function (entries) {
                    count--;
                    for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
                        var entry = entries_1[_i];
                        // eslint-disable-next-line @typescript-eslint/no-use-before-define
                        readEntry(entry, path);
                    }
                    if (count === 0) {
                        res();
                    }
                });
            };
            var readEntry = function (entry, path) {
                if (entry.isFile) {
                    count++;
                    entry.file(function (file) {
                        count--;
                        _this._addFile(file, path);
                        if (count === 0) {
                            res();
                        }
                    });
                }
                else if (entry.isDirectory) {
                    var reader = entry.createReader();
                    readDirectory(reader, path + entry.name + "/");
                }
            };
            readEntry(item, "");
        });
    };
    return Uploader;
}());
exports.Uploader = Uploader;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataCollection = void 0;
var events_1 = __webpack_require__(2);
var loader_1 = __webpack_require__(121);
var sort_1 = __webpack_require__(124);
var dataproxy_1 = __webpack_require__(26);
var helpers_1 = __webpack_require__(23);
var types_1 = __webpack_require__(22);
var core_1 = __webpack_require__(1);
var DataCollection = /** @class */ (function () {
    function DataCollection(config, events) {
        var _this = this;
        this._filters = {};
        this._changes = { order: [] };
        this.config = config || {};
        this._sort = new sort_1.Sort();
        this._loader = new loader_1.Loader(this, this._changes);
        this.events = events || new events_1.EventSystem(this);
        this.events.on(types_1.DataEvents.dataRequest, function (from, to) {
            var proxy = _this.dataProxy;
            if (proxy && proxy.updateUrl) {
                proxy.updateUrl(null, { from: from, limit: proxy.config.limit || to - from });
                _this.load(proxy);
            }
        });
        this.events.on(types_1.DataEvents.loadError, function (response) {
            setTimeout(function () {
                if (typeof response !== "string") {
                    (0, helpers_1.dhxError)(response);
                }
                else {
                    (0, helpers_1.dhxWarning)(response);
                }
            }, 0);
        });
        this._reset();
    }
    DataCollection.prototype._reset = function () {
        this._order = [];
        this._pull = {};
        this._changes = { order: [] };
        this._initOrder = null;
        this._meta = new WeakMap();
        this._loaded = false;
    };
    DataCollection.prototype.add = function (newItem, index) {
        var _this = this;
        if (!this.events.fire(types_1.DataEvents.beforeAdd, [newItem])) {
            return;
        }
        var out;
        if (Array.isArray(newItem)) {
            out = newItem.map(function (element, key) {
                if (key !== 0) {
                    index = index + 1;
                }
                return _this._add(element, index);
            });
        }
        else {
            out = this._add(newItem, index);
        }
        this._reapplyFilters(true);
        return out;
    };
    DataCollection.prototype.remove = function (id) {
        var _this = this;
        if (id instanceof Array) {
            __spreadArray([], id, true).map(function (elementId) {
                _this._remove(elementId);
            });
        }
        else if ((0, core_1.isId)(id)) {
            this._remove(id);
        }
    };
    DataCollection.prototype.removeAll = function () {
        this._reset();
        this.events.fire(types_1.DataEvents.removeAll);
        this.events.fire(types_1.DataEvents.change);
    };
    DataCollection.prototype.exists = function (id) {
        return !!this._pull[id];
    };
    DataCollection.prototype.getNearId = function (id) {
        var item = this._pull[id];
        if (!item) {
            return this._order[0].id || "";
        }
    };
    DataCollection.prototype.getItem = function (id) {
        return this._pull[id];
    };
    DataCollection.prototype.update = function (id, newItem, silent) {
        var item = this.getItem(id);
        if (item) {
            if ((0, helpers_1.isEqualObj)(newItem, item)) {
                return;
            }
            if ((0, core_1.isId)(newItem.id) && id !== newItem.id) {
                (0, helpers_1.dhxWarning)("this method doesn't allow change id");
                if ((0, helpers_1.isDebug)()) {
                    // eslint-disable-next-line no-debugger
                    debugger;
                }
            }
            else {
                if (newItem.parent && item.parent && newItem.parent !== item.parent) {
                    this.move(id, -1, this, newItem.parent);
                }
                (0, core_1.extend)(this._pull[id], newItem, false);
                if (this.config.update) {
                    this.config.update(this._pull[id]);
                }
                if (!silent) {
                    this._onChange("update", id, this._pull[id]);
                }
            }
            this._reapplyFilters(true);
        }
        else {
            (0, helpers_1.dhxWarning)("item not found");
        }
    };
    DataCollection.prototype.getIndex = function (id) {
        if (!(0, core_1.isId)(id) || !(0, core_1.isDefined)(this._pull[id])) {
            return -1;
        }
        return (0, core_1.findIndex)(this._order, function (item) { return item && item.id.toString() === id.toString(); });
    };
    DataCollection.prototype.getId = function (index) {
        if (!this._order[index]) {
            return;
        }
        return this._order[index].id;
    };
    DataCollection.prototype.getLength = function () {
        return this._order.length;
    };
    DataCollection.prototype.isDataLoaded = function (from, to) {
        if (from === void 0) { from = 0; }
        if (to === void 0) { to = this._order.length; }
        if ((0, core_1.isNumeric)(from) && (0, core_1.isNumeric)(to)) {
            return this._order.slice(from, to).filter(function (item) { return item && item.$empty; }).length === 0;
        }
        // if check succeeds once, collection can't go back to not-loaded state
        if (!this._loaded) {
            this._loaded = !this.find(function (item) { return item.$empty; });
        }
        return !!this._loaded;
    };
    DataCollection.prototype.filter = function (rule, config, silent) {
        var _a;
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        if (config === null || config === void 0 ? void 0 : config.$restore) {
            rule = this._normalizeFilters(rule || this._filters);
        }
        if (!(config === null || config === void 0 ? void 0 : config.add)) {
            this._order = this._initOrder || this._order;
            this._initOrder = null;
            if (!(config === null || config === void 0 ? void 0 : config.$restore)) {
                for (var key in this._filters) {
                    var filter = this._filters[key];
                    if ((_a = filter.config) === null || _a === void 0 ? void 0 : _a.permanent) {
                        this._applyFilters(filter.rule);
                    }
                    else {
                        delete this._filters[key];
                    }
                }
            }
        }
        var id;
        if (rule && !(config === null || config === void 0 ? void 0 : config.$restore)) {
            id = (config === null || config === void 0 ? void 0 : config.id) || (0, core_1.uid)();
            this._filters[id] = { rule: rule, config: config || {} };
        }
        if (rule && typeof rule !== "function") {
            if ((0, core_1.isDefined)(rule.by)) {
                this._applyFilters(rule);
            }
            else {
                for (var key in rule) {
                    this._applyFilters(rule[key]);
                }
            }
        }
        else {
            this._applyFilters(rule);
        }
        if (!silent) {
            var filters = this._getPureFilters(this._filters);
            this.events.fire(types_1.DataEvents.filter, [(0, core_1.isEmptyObj)(filters) ? null : filters]);
        }
        return id;
    };
    DataCollection.prototype.resetFilter = function (config, silent) {
        var _a;
        var _b = config || {}, id = _b.id, permanent = _b.permanent;
        if ((0, core_1.isEmptyObj)(config)) {
            for (var key in this._filters) {
                if (!((_a = this._filters[key].config) === null || _a === void 0 ? void 0 : _a.permanent)) {
                    delete this._filters[key];
                }
            }
        }
        else if (permanent) {
            this._filters = {};
        }
        else if (id) {
            delete this._filters[id];
        }
        this.filter(null, { $restore: true }, silent);
        return (0, core_1.isEmptyObj)(this._getPureFilters(this._filters));
    };
    DataCollection.prototype.getFilters = function (config) {
        var filters = this.getRawFilters(config);
        var pureFilters = filters ? this._getPureFilters(filters) : {};
        return (0, core_1.isEmptyObj)(pureFilters) ? null : pureFilters;
    };
    DataCollection.prototype.getRawFilters = function (config) {
        var filters = this._filters;
        if (config === null || config === void 0 ? void 0 : config.permanent) {
            filters = Object.keys(filters).reduce(function (obj, key) {
                var _a;
                if ((_a = filters[key].config) === null || _a === void 0 ? void 0 : _a.permanent) {
                    obj[key] = filters[key];
                }
                return obj;
            }, {});
        }
        return (0, core_1.isEmptyObj)(filters) ? null : filters;
    };
    DataCollection.prototype.find = function (conf) {
        for (var key in this._pull) {
            var res = (0, helpers_1.findByConf)(this._pull[key], conf);
            if (res) {
                return res;
            }
        }
        return null;
    };
    DataCollection.prototype.findAll = function (conf) {
        var res = [];
        for (var key in this._pull) {
            var item = (0, helpers_1.findByConf)(this._pull[key], conf);
            if (item) {
                res.push(item);
            }
        }
        return res;
    };
    DataCollection.prototype.sort = function (rule, config) {
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        if (config && config.smartSorting) {
            this._sorter = rule;
        }
        if (rule) {
            this._applySorters(rule);
        }
        this.events.fire(types_1.DataEvents.change, [undefined, "sort", rule]);
    };
    DataCollection.prototype.copy = function (id, index, target, targetId) {
        var _this = this;
        if (id instanceof Array) {
            return id.map(function (elementId, key) {
                return _this._copy(elementId, index, target, targetId, key);
            });
        }
        else {
            return this._copy(id, index, target, targetId);
        }
    };
    DataCollection.prototype.move = function (id, index, target, targetId, newId) {
        var _this = this;
        if (id instanceof Array) {
            return id.map(function (elementId, key) {
                return _this._move(elementId, index, target, targetId, key);
            });
        }
        else {
            return this._move(id, index, target, targetId, 0, newId);
        }
    };
    DataCollection.prototype.forEach = function (callback) {
        for (var i = 0; i < this._order.length; i++) {
            callback.call(this, this._order[i], i, this._order);
        }
    };
    DataCollection.prototype.load = function (url, driver) {
        if (typeof url === "string") {
            this.dataProxy = url = new dataproxy_1.DataProxy(url);
        }
        this.dataProxy = url;
        return this._loader.load(url, driver);
    };
    DataCollection.prototype.parse = function (data, driver) {
        this._reset();
        return this._loader.parse(data, driver);
    };
    DataCollection.prototype.$parse = function (data) {
        var apx = this.config.approximate;
        if (apx) {
            data = this._approximate(data, apx.value, apx.maxNum);
        }
        this._parse_data(data);
        this._reapplyFilters(true);
        this.events.fire(types_1.DataEvents.change, ["load"]);
        this.events.fire(types_1.DataEvents.load);
    };
    DataCollection.prototype.save = function (url) {
        if (typeof url === "string") {
            url = new dataproxy_1.DataProxy(url);
        }
        this._loader.save(url);
    };
    DataCollection.prototype.changeId = function (id, newId, silent) {
        if (newId === void 0) { newId = (0, core_1.uid)(); }
        if (!silent && !this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        var item = this.getItem(id);
        if (!item) {
            (0, helpers_1.dhxWarning)("item not found");
        }
        else {
            item.id = newId;
            (0, core_1.extend)(this._pull[id], item);
            this._pull[newId] = this._pull[id];
            if (!silent) {
                this._onChange("update", newId, this._pull[newId]);
            }
            delete this._pull[id];
        }
    };
    // todo: loop through the array and check saved statuses
    DataCollection.prototype.isSaved = function () {
        return !this._changes.order.length; // todo: bad solution, errors and holded elments are missed...
    };
    DataCollection.prototype.map = function (callback) {
        var result = [];
        for (var i = 0; i < this._order.length; i++) {
            result.push(callback.call(this, this._order[i], i, this._order));
        }
        return result;
    };
    DataCollection.prototype.mapRange = function (from, to, callback) {
        if (from < 0) {
            from = 0;
        }
        if (to > this._order.length - 1) {
            to = this._order.length - 1;
        }
        var arr = this._order.slice(from, to);
        var result = [];
        for (var i = from; i <= to; i++) {
            result.push(callback.call(this, this._order[i], i, arr));
        }
        return result;
    };
    DataCollection.prototype.reduce = function (callback, acc) {
        for (var i = 0; i < this._order.length; i++) {
            acc = callback.call(this, acc, this._order[i], i);
        }
        return acc;
    };
    DataCollection.prototype.serialize = function (driver) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        // remove $ attrs
        var data = [];
        var _loop_1 = function (index) {
            var item = __assign({}, this_1._order[index]);
            Object.keys(item).forEach(function (key) {
                if (key.startsWith("$")) {
                    delete item[key];
                }
            });
            data.push(item);
        };
        var this_1 = this;
        for (var index = 0; index < this._order.length; index++) {
            _loop_1(index);
        }
        var dataDriver = (0, helpers_1.toDataDriver)(driver);
        if (dataDriver) {
            return dataDriver.serialize(data);
        }
    };
    DataCollection.prototype.getInitialData = function () {
        return this._initOrder;
    };
    DataCollection.prototype.setMeta = function (obj, key, value) {
        if (!obj)
            return;
        var map = this._meta.get(obj);
        if (!map) {
            map = {};
            this._meta.set(obj, map);
        }
        map[key] = value;
    };
    DataCollection.prototype.getMeta = function (obj, key) {
        var map = this._meta.get(obj);
        return map ? map[key] : null;
    };
    DataCollection.prototype.getMetaMap = function (obj) {
        return this._meta.get(obj);
    };
    DataCollection.prototype.setRange = function (from, to) {
        this._range = !to ? null : [from, to];
    };
    DataCollection.prototype.getRawData = function (from, to, order, mode) {
        order = order || this._order;
        if (mode === 1)
            return order;
        if (this._range) {
            from = this._range[0] + from;
            if (to === -1) {
                to = this._range[1];
            }
            else {
                var diff = Math.abs(to - from);
                to = from + diff > this._range[1] ? this._range[1] : from + diff;
            }
        }
        if (!to || (from === 0 && (to === -1 || to === order.length))) {
            return order;
        }
        if (from >= order.length)
            return [];
        if (to === -1 || to > order.length)
            to = order.length;
        var slice = order.slice(from, to);
        if (slice.filter(function (item) { return item.$empty; }).length !== 0) {
            this.events.fire(types_1.DataEvents.dataRequest, [from, to]);
        }
        return slice;
    };
    DataCollection.prototype._add = function (newItem, index) {
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        var id = this._addCore(newItem, index);
        this._onChange("add", newItem.id, newItem);
        this.events.fire(types_1.DataEvents.afterAdd, [newItem]);
        return id;
    };
    DataCollection.prototype._remove = function (id) {
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        var removedItem = this._pull[id];
        if (removedItem) {
            if (!this.events.fire(types_1.DataEvents.beforeRemove, [removedItem])) {
                return;
            }
            this._removeCore(removedItem.id);
            this._onChange("remove", id, removedItem);
        }
        this.events.fire(types_1.DataEvents.afterRemove, [removedItem]);
    };
    DataCollection.prototype._copy = function (id, index, target, targetId, key) {
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        if (!this.exists(id)) {
            return null;
        }
        var newid = (0, core_1.uid)();
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target) {
            if (!(target instanceof DataCollection) && targetId) {
                target.add((0, helpers_1.copyWithoutInner)(this.getItem(id)), index);
                return;
            }
            if (target.exists(id)) {
                target.add(__assign(__assign({}, (0, helpers_1.copyWithoutInner)(this.getItem(id))), { id: newid }), index);
                return newid;
            }
            else {
                target.add((0, helpers_1.copyWithoutInner)(this.getItem(id)), index);
                return id;
            }
        }
        this.add(__assign(__assign({}, (0, helpers_1.copyWithoutInner)(this.getItem(id))), { id: newid }), index);
        return newid;
    };
    DataCollection.prototype._move = function (id, index, target, targetId, key, newId) {
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target && target !== this && this.exists(id)) {
            var item = (0, core_1.copy)(this.getItem(id), true);
            if (newId)
                item.id = newId;
            if ((!newId && target.exists(id)) || target.exists(newId)) {
                item.id = (0, core_1.uid)();
            }
            if (targetId) {
                item.parent = targetId;
            }
            target.add(item, index);
            // remove data from original collection
            this.remove(id);
            return item.id;
        }
        if (this.getIndex(id) === index) {
            return null;
        }
        // move other elements
        var spliced = this._order.splice(this.getIndex(id), 1)[0];
        if (index === -1) {
            index = this._order.length;
        }
        this._order.splice(index, 0, spliced);
        this.events.fire(types_1.DataEvents.change, [id, "update", this.getItem(id)]);
        return id;
    };
    DataCollection.prototype._addCore = function (obj, index) {
        var _a;
        if (this.config.init) {
            obj = this.config.init(obj);
        }
        obj.id = (_a = obj.id) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
        if (this._pull[obj.id]) {
            (0, helpers_1.dhxError)("Item ".concat(obj.id, " already exist"));
        }
        // todo: not ideal solution
        if (this._initOrder && !(0, helpers_1.isTreeCollection)(this)) {
            this._addToOrder(this._initOrder, obj, index);
        }
        this._addToOrder(this._order, obj, index);
        return obj.id;
    };
    DataCollection.prototype._removeCore = function (id) {
        if (this.getIndex(id) >= 0) {
            this._order = this._order.filter(function (el) { return el.id !== id; });
            delete this._pull[id];
        }
        if (this._initOrder && this._initOrder.length) {
            this._initOrder = this._initOrder.filter(function (el) { return el.id !== id; });
            delete this._pull[id];
        }
    };
    DataCollection.prototype._parse_data = function (data) {
        var index = this._order.length;
        if (this.config.prep) {
            data = this.config.prep(data);
        }
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var obj = data_1[_i];
            this._addCore(obj, index++);
        }
    };
    DataCollection.prototype._approximate = function (data, values, maxNum) {
        var len = data.length;
        var vlen = values.length;
        var rlen = Math.floor(len / maxNum);
        var newData = Array(Math.ceil(len / rlen));
        var index = 0;
        for (var i = 0; i < len; i += rlen) {
            var newItem = (0, core_1.copy)(data[i]);
            var end = Math.min(len, i + rlen);
            for (var j = 0; j < vlen; j++) {
                var sum = 0;
                for (var z = i; z < end; z++) {
                    sum += data[z][values[j]];
                }
                newItem[values[j]] = sum / (end - i);
            }
            newData[index++] = newItem;
        }
        return newData;
    };
    DataCollection.prototype._onChange = function (status, id, obj) {
        var itemCount = 0;
        var maxStack = 10;
        for (var _i = 0, _a = this._changes.order; _i < _a.length; _i++) {
            var item = _a[_i];
            // update pending item if previous state is "saving" or if item not saved yet
            var index = this._changes.order.indexOf(item);
            if (item.id === id && !item.saving) {
                itemCount += 1;
                if (index === this._changes.order.length - 1 || this._changes.order[index + 1].id !== id) {
                    // update item
                    if (item.error) {
                        item.error = false;
                    }
                    item = __assign(__assign({}, item), { obj: obj, status: status });
                    itemCount += 1;
                    if (itemCount > maxStack) {
                        this._changes.order.splice(index, itemCount - maxStack, item);
                    }
                    else {
                        this._changes.order.splice(index + 1, 0, item);
                    }
                    this._loader.updateChanges(this._changes);
                    if (status === "remove" && obj.$emptyRow)
                        return;
                    this.events.fire(types_1.DataEvents.change, [id, status, obj]);
                    return;
                }
            }
        }
        this._changes.order.push({ id: id, status: status, obj: __assign({}, obj), saving: false });
        this._loader.updateChanges(this._changes);
        this.events.fire(types_1.DataEvents.change, [id, status, obj]);
    };
    DataCollection.prototype._addToOrder = function (array, obj, index) {
        if (index >= 0 && array[index]) {
            this._pull[obj.id] = obj;
            array.splice(index, 0, obj);
        }
        else {
            this._pull[obj.id] = obj;
            array.push(obj);
        }
    };
    DataCollection.prototype._applySorters = function (by) {
        this._sort.sort(this._order, by, this._sorter);
        // sort the not-filtered dataset
        if (this._initOrder && this._initOrder.length) {
            this._sort.sort(this._initOrder, by, this._sorter);
        }
    };
    DataCollection.prototype._applyFilters = function (rule) {
        if (!rule)
            return;
        var filter = typeof rule !== "function" ? this._getRuleCallback(rule) : rule;
        var fOrder = this._order.filter(function (item) { return filter(item); });
        if (!this._initOrder) {
            this._initOrder = this._order;
        }
        this._order = fOrder;
    };
    DataCollection.prototype._reapplyFilters = function (sort) {
        if (sort === void 0) { sort = false; }
        var permFilters = this.getFilters({ permanent: true });
        if (permFilters) {
            this.filter(permFilters, { $restore: true, add: true }, true);
        }
        if (sort && this._sorter) {
            this._applySorters();
        }
    };
    DataCollection.prototype._getRuleCallback = function (rule) {
        if (!(0, core_1.isDefined)(rule.by) || !(0, core_1.isDefined)(rule.match))
            return;
        return rule.compare
            ? function (obj) { return rule.compare(obj[rule.by], rule.match, obj, rule.multi); }
            : function (obj) { return obj[rule.by] == rule.match; };
    };
    DataCollection.prototype._getPureFilters = function (filters) {
        return Object.keys(filters).reduce(function (obj, key) {
            var _a;
            if (!((_a = filters[key].config) === null || _a === void 0 ? void 0 : _a.$local)) {
                obj[key] = filters[key];
            }
            return obj;
        }, {});
    };
    DataCollection.prototype._normalizeFilters = function (filters) {
        var rules = [];
        for (var key in filters) {
            var rule = filters[key].rule;
            if (typeof rule !== "function") {
                if ((0, core_1.isDefined)(rule.by)) {
                    rules.push(this._getRuleCallback(rule));
                }
                else {
                    for (var key_1 in rule) {
                        rules.push(this._getRuleCallback(rule[key_1]));
                    }
                }
            }
            else {
                rules.push(rule);
            }
        }
        return __assign({}, rules);
    };
    return DataCollection;
}());
exports.DataCollection = DataCollection;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dataDriversPro = exports.dataDrivers = void 0;
var JsonDriver_1 = __webpack_require__(62);
var CsvDriver_1 = __webpack_require__(63);
var XMLDriver_1 = __webpack_require__(122);
exports.dataDrivers = {
    json: JsonDriver_1.JsonDriver,
    csv: CsvDriver_1.CsvDriver,
};
exports.dataDriversPro = __assign(__assign({}, exports.dataDrivers), { xml: XMLDriver_1.XMLDriver });


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonDriver = void 0;
var JsonDriver = /** @class */ (function () {
    function JsonDriver() {
    }
    JsonDriver.prototype.toJsonArray = function (data) {
        return this.getRows(data);
    };
    JsonDriver.prototype.serialize = function (data) {
        return data;
    };
    JsonDriver.prototype.getFields = function (row) {
        return row;
    };
    JsonDriver.prototype.getRows = function (data) {
        return typeof data === "string" ? JSON.parse(data) : data;
    };
    return JsonDriver;
}());
exports.JsonDriver = JsonDriver;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CsvDriver = void 0;
var CsvDriver = /** @class */ (function () {
    function CsvDriver(config) {
        var initConfig = {
            skipHeader: 0,
            nameByHeader: false,
            rowDelimiter: "\n",
            columnDelimiter: ",",
        };
        this.config = __assign(__assign({}, initConfig), config);
        if (this.config.nameByHeader) {
            this.config.skipHeader = 1;
        }
    }
    CsvDriver.prototype.getFields = function (row, headers) {
        var regex = new RegExp("(?<!\")".concat(this.config.columnDelimiter, "(?!\")"));
        var parts = row.trim().split(regex);
        var obj = {};
        for (var i = 0; i < parts.length; i++) {
            obj[headers ? headers[i] : i + 1] = isNaN(Number(parts[i]))
                ? parts[i].replace(/"[,;"]"/gi, function (match) {
                    return match
                        .split("")
                        .splice(1, 1)
                        .slice(-1, 1)
                        .join("");
                })
                : parseFloat(parts[i]);
        }
        return obj;
    };
    CsvDriver.prototype.getRows = function (data) {
        return data.trim().split(this.config.rowDelimiter);
    };
    CsvDriver.prototype.toJsonArray = function (data) {
        var _this = this;
        var rows = this.getRows(data);
        var names = this.config.names;
        if (this.config.skipHeader) {
            var top_1 = rows.splice(0, this.config.skipHeader);
            if (this.config.nameByHeader) {
                names = top_1[0].trim().split(this.config.columnDelimiter);
            }
        }
        return rows.map(function (row) { return _this.getFields(row, names); });
    };
    CsvDriver.prototype.serialize = function (data, withoutHeader) {
        var header = data[0]
            ? Object.keys(data[0])
                .filter(function (key) { return !key.startsWith("$"); })
                .join(this.config.columnDelimiter) +
                this.config.columnDelimiter +
                this.config.rowDelimiter
            : "";
        var readyData = this._serialize(data);
        if (withoutHeader) {
            return readyData;
        }
        return header + readyData;
    };
    CsvDriver.prototype._serialize = function (data) {
        var _this = this;
        return data.reduce(function (csv, row) {
            var cells = Object.keys(row).reduce(function (total, key, i) {
                var _a, _b;
                if (key.startsWith("$") || key === "items") {
                    return total;
                }
                return "".concat(total).concat(((_b = (_a = row[key]) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : "").replaceAll(/[,;"]/gi, function (match) { return "\"".concat(match, "\""); })).concat(i === row.length - 1 ? "" : _this.config.columnDelimiter);
            }, "");
            if (row.items) {
                return "".concat(csv).concat(csv ? "\n" : "").concat(cells).concat(_this._serialize(row.items));
            }
            return "".concat(csv).concat(csv ? _this.config.rowDelimiter : "").concat(cells);
        }, "");
    };
    return CsvDriver;
}());
exports.CsvDriver = CsvDriver;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTreeCell = void 0;
__exportStar(__webpack_require__(65), exports);
__exportStar(__webpack_require__(160), exports);
__exportStar(__webpack_require__(9), exports);
__exportStar(__webpack_require__(32), exports);
var Cells_1 = __webpack_require__(27);
Object.defineProperty(exports, "getTreeCell", { enumerable: true, get: function () { return Cells_1.getTreeCell; } });
__exportStar(__webpack_require__(18), exports);
__exportStar(__webpack_require__(15), exports);


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grid = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var html_1 = __webpack_require__(3);
var core_1 = __webpack_require__(1);
var KeyManager_1 = __webpack_require__(14);
var view_1 = __webpack_require__(8);
var ts_data_1 = __webpack_require__(7);
var Exporter_1 = __webpack_require__(127);
var data_1 = __webpack_require__(18);
var cells_1 = __webpack_require__(32);
var main_1 = __webpack_require__(15);
var Selection_1 = __webpack_require__(131);
var types_1 = __webpack_require__(9);
var render_1 = __webpack_require__(24);
var date_1 = __webpack_require__(16);
var content_1 = __webpack_require__(154);
var columnsResizer_1 = __webpack_require__(158);
var keys_1 = __webpack_require__(159);
var FocusManager_1 = __webpack_require__(19);
var Cells_1 = __webpack_require__(27);
var Grid = /** @class */ (function (_super) {
    __extends(Grid, _super);
    function Grid(container, config) {
        var _this = _super.call(this, container, config) || this;
        _this._touch = {
            duration: 350,
            dblDuration: 300,
            timer: null,
            start: false,
        };
        _this._destructed = false;
        _this.version = "8.3.4";
        _this.config = (0, core_1.extend)({
            rowHeight: 40,
            headerRowHeight: 40,
            footerRowHeight: 40,
            keyNavigation: true,
            sortable: true,
            columns: [],
            data: [],
            tooltip: true,
            rootParent: (typeof container === "string" && container) || _this._uid,
        }, _this._normalizeConfig(config));
        _this.content = (0, content_1.getContent)();
        _this._scroll = {
            top: 0,
            left: 0,
        };
        // TODO: remove suite_7.0
        _this.config.autoWidth = _this.config.autoWidth || _this.config.fitToContainer;
        _this.config.adjust = _this.config.adjust || _this.config.columnsAutoWidth;
        _this.config.editable = _this.config.editable || _this.config.editing;
        _this.config.leftSplit = _this.config.leftSplit || _this.config.splitAt;
        _this.config.columns.forEach(function (col) {
            col.format = col.format || col.dateFormat;
        });
        var showCellTooltip = function (row, column, node) {
            var _a;
            if (row && column && (0, main_1.isTooltip)(_this.config, column)) {
                var editorOption = void 0;
                if (column.editorType === "combobox" || column.editorType === "select") {
                    var option = (0, data_1.getEditorOptions)(column, row).find(function (item) {
                        var _a;
                        var value = item instanceof Object ? item.id.toString() : item;
                        return value === ((_a = row[column.id]) === null || _a === void 0 ? void 0 : _a.toString());
                    });
                    editorOption = option instanceof Object ? option.value : option;
                }
                else if (column.editorType === "multiselect") {
                    var values_1 = (_a = row[column.id]) === null || _a === void 0 ? void 0 : _a.toString().split(", ");
                    if (values_1 === null || values_1 === void 0 ? void 0 : values_1.length) {
                        var options = (0, data_1.getEditorOptions)(column, row).filter(function (item) {
                            return values_1.includes(item instanceof Object ? item.id.toString() : item);
                        });
                        editorOption = options
                            .map(function (item) {
                            return item instanceof Object ? item.value : item;
                        })
                            .join(", ");
                    }
                }
                var value_1 = (0, data_1.toFormat)(editorOption || row[column.id], column.type, column.format);
                var checkIsExistValue = function () { return !!value_1 || typeof value_1 === "boolean"; };
                if (column.tooltipTemplate) {
                    value_1 = column.tooltipTemplate(value_1, row, column) || null;
                }
                else if (checkIsExistValue() && column.template) {
                    value_1 = column.template(value_1, row, column);
                }
                checkIsExistValue() &&
                    (0, main_1.showTooltip)({ value: value_1, node: node, htmlEnable: (0, main_1.isHtmlEnable)(_this.config, column) });
            }
        };
        var showContentTooltip = function (event, type) {
            var _a, _b;
            if (type === void 0) { type = "header"; }
            var node = event.target;
            var id = node.getAttribute("data-dhx-text-id");
            var column = _this.getColumn(node.getAttribute("data-dhx-id"));
            if (!id || !column) {
                return;
            }
            var cell = (_a = column[type]) === null || _a === void 0 ? void 0 : _a.find(function (c) { return c.id === id; });
            if (!(0, main_1.isContentTooltip)(_this.config, column, cell, type)) {
                return;
            }
            var isContentFunc = (cell === null || cell === void 0 ? void 0 : cell.content) && ["avg", "sum", "max", "min", "count"].includes(cell.content);
            var value = isContentFunc
                ? (_b = _this.content[cell.content]) === null || _b === void 0 ? void 0 : _b.toHtml(column, __assign(__assign({}, _this.config), { datacollection: _this.data }))
                : cell === null || cell === void 0 ? void 0 : cell.text;
            if (typeof (cell === null || cell === void 0 ? void 0 : cell.tooltipTemplate) === "function") {
                value = cell.tooltipTemplate(value, cell, column);
            }
            if (isContentFunc && typeof column.template === "function") {
                value = column.template(value, cell, column);
            }
            if (value === null || value === void 0 ? void 0 : value.toString().length) {
                (0, main_1.showTooltip)({ value: value, node: node, htmlEnable: (0, main_1.isHtmlEnable)(_this.config, column, cell) });
            }
        };
        _this._htmlEvents = {
            onclick: (0, html_1.eventHandler)(function (e) { return (0, html_1.locate)(e); }, {
                "dhx_grid-header-cell--sortable": function (e, id) {
                    var _a;
                    var isResizable = e.target.getAttribute("dhx_resized");
                    var column = _this.getColumn(id);
                    if (column &&
                        (0, main_1.isSortable)(_this.config, column) &&
                        !isResizable &&
                        _this.events.fire(types_1.GridEvents.beforeSort, [
                            column,
                            _this._sortDir === "asc" ? "desc" : "asc",
                        ])) {
                        var text_1 = (_a = (0, html_1.locateNodeByClassName)(e, "dhx_grid-header-cell")) === null || _a === void 0 ? void 0 : _a.querySelector(".dhx_grid-header-cell-text_content").innerHTML;
                        var cellConfig = text_1 ? column.header.find(function (item) { return item.text === text_1; }) : null;
                        var dir = _this._sortDir === "asc" && _this._sortBy === id ? "desc" : "asc";
                        _this._sort(id, dir, cellConfig === null || cellConfig === void 0 ? void 0 : cellConfig.sortAs);
                    }
                },
                "dhx_grid-expand-cell": function (e, rowId) {
                    if (e.target.classList.contains("dhx_grid-expand-cell-icon")) {
                        _this.events.fire(types_1.GridEvents.expand, [rowId]);
                    }
                },
                "dhx_span-expand-cell": function (e, rowId) {
                    if (e.target.classList.contains("dhx_span-expand-cell-icon")) {
                        _this.events.fire(types_1.GridEvents.expand, [rowId]);
                    }
                },
            }),
            onscroll: function (e) {
                _this.events.fire(types_1.GridEvents.scroll, [
                    {
                        y: e.target.scrollTop,
                        x: e.target.scrollLeft,
                    },
                ]);
            },
            onmouseover: {
                ".dhx_grid-cell.dhx_boolean-cell .dhx_checkbox.dhx_cell-editor__checkbox": function (e) {
                    var path = e.composedPath();
                    var row = _this.data.getItem(path[2].getAttribute("data-dhx-id"));
                    var column = _this.getColumn(path[1].getAttribute("data-dhx-col-id"));
                    showCellTooltip(row, column, e.target);
                },
                ".dhx_grid-cell:not(.dhx_boolean-cell)": function (e) {
                    var row = _this.data.getItem(e.composedPath()[1].getAttribute("data-dhx-id"));
                    var column = _this.getColumn(e.target.getAttribute("data-dhx-col-id"));
                    showCellTooltip(row, column, e.target);
                },
                ".dhx_grid-cell:not(.dhx_tree-cell) .dhx_grid-cell__content, .dhx_tree-cell :not(.dhx_grid-cell__content)": function (e) {
                    var path = e.composedPath();
                    var row = _this.data.getItem(path[2].getAttribute("data-dhx-id"));
                    var column = _this.getColumn(path[1].getAttribute("data-dhx-col-id"));
                    showCellTooltip(row, column, e.target);
                },
                ".dhx_grid-cell.dhx_tree-cell .dhx_grid-cell__content": function (e) {
                    var path = e.composedPath();
                    var row = _this.data.getItem(path[3].getAttribute("data-dhx-id"));
                    var column = _this.getColumn(path[2].getAttribute("data-dhx-col-id"));
                    showCellTooltip(row, column, path[2]);
                },
                ".dhx_span-cell:not(.dhx_grid-header-cell)": function (e) {
                    var node = e.target;
                    var row = _this.data.getItem(node.getAttribute("data-dhx-id"));
                    var column = _this.getColumn(node.getAttribute("data-dhx-col-id"));
                    var span = _this.getSpan(row.id, column.id);
                    if (row && span && (0, main_1.isTooltip)(_this.config, span)) {
                        var value = span.text || (0, data_1.toFormat)(row[column.id], column.type, column.format);
                        if (span.tooltipTemplate) {
                            value = span.tooltipTemplate(value, span);
                        }
                        else if (column.template) {
                            value = column.template(value, row, column);
                        }
                        value && (0, main_1.showTooltip)({ value: value, node: node, htmlEnable: (0, main_1.isHtmlEnable)(_this.config, column) });
                    }
                },
                ".dhx_grid-header-cell": function (event) { return showContentTooltip(event, "header"); },
                ".dhx_grid-footer-cell": function (event) { return showContentTooltip(event, "footer"); },
            },
        };
        if (_this.config.eventHandlers) {
            for (var _i = 0, _a = Object.entries(_this.config.eventHandlers); _i < _a.length; _i++) {
                var _b = _a[_i], name_1 = _b[0], events = _b[1];
                _this._htmlEvents[name_1] = (0, html_1.eventHandler)(function (e) {
                    return {
                        col: _this.getColumn((0, html_1.locate)(e, "data-dhx-col-id") || (0, html_1.locate)(e, "data-dhx-id")) ||
                            {},
                        row: _this.data.getItem((0, html_1.locate)(e, "data-dhx-id")) || {},
                    };
                }, events, _this._htmlEvents[name_1]);
            }
        }
        if (_this.config.dragMode || _this.config.dragItem) {
            ts_data_1.dragManager.setItem(_this._uid, _this);
            if (!_this.config.dragItem) {
                _this.config.dragItem = "row";
            }
            if (!_this.config.dragMode) {
                _this.config.dragMode = "both";
            }
        }
        _this._init();
        if (_this.config.columns) {
            _this._parseColumns(true);
        }
        if (_this._canDataParse()) {
            _this.data.parse(_this.config.data);
        }
        _this.selection = new Selection_1.Selection(_this, {
            disabled: !_this.config.selection,
        }, _this.events, _this._uid);
        _this.mount(container, _this._createView());
        (0, dom_1.awaitRedraw)().then(function () {
            if (_this.config.keyNavigation) {
                _this.keyManager = new KeyManager_1.KeyManager(function (e, focusId) {
                    if (focusId === _this._uid && _this.events.fire(types_1.GridEvents.beforeKeyDown, [e])) {
                        _this.events.fire(types_1.GridEvents.afterKeyDown, [e]);
                        return true;
                    }
                    return false;
                });
                _this._initHotKey();
                FocusManager_1.focusManager.setFocusId(_this._uid);
            }
        });
        if (config.autoEmptyRow && _this.data.getLength() === 0) {
            _this._addEmptyRow();
            _this.paint();
        }
        return _this;
    }
    Grid.prototype.destructor = function () {
        this._destructed = true;
        this._destroyContent();
        this.keyManager && this.keyManager.destructor();
        this.events && this.events.clear();
        this._events && this._events.clear();
        this.export = this.content = this.selection = null;
        this._activeFilters = this._filterData = this._scroll = this._touch = this._htmlEvents = this._hiddenFilters = null;
        this.unmount();
    };
    Grid.prototype.setColumns = function (columns) {
        var _this = this;
        this._destroyContent();
        this.config.columns = columns;
        this._parseColumns(true);
        this._adjustColumns();
        this._checkFilters();
        this._checkMarks();
        this.paint();
        if (this.config.keyNavigation) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this._initHotKey(true);
                _this.paint();
            });
        }
    };
    Grid.prototype.addRowCss = function (rowId, css) {
        var item = this.data.getItem(rowId);
        var styles = item.$css || "";
        if (!styles.match(new RegExp(css, "g"))) {
            item.$css = styles + " ".concat(css);
            this.paint();
        }
    };
    Grid.prototype.removeRowCss = function (rowId, css) {
        var item = this.data.getItem(rowId);
        var styles = item.$css ? item.$css.replace(css, "") : "";
        item.$css = styles;
        this.paint();
    };
    Grid.prototype.addCellCss = function (rowId, colId, css) {
        var column = this.getColumn(colId);
        var span = this.config.spans ? this.getSpan(rowId, colId) : null;
        if (span || column) {
            var cellStyle = span ? span.css : column.$cellCss[rowId];
            if (cellStyle) {
                // eslint-disable-next-line @typescript-eslint/prefer-regexp-exec
                var newClass = cellStyle.match(new RegExp(css, "g")) ? "" : " ".concat(css);
                if (span) {
                    span.css += newClass;
                }
                else {
                    column.$cellCss[rowId] += newClass;
                }
            }
            else if (this.data.getItem(rowId)) {
                if (span) {
                    span.css = "".concat(css, " ");
                }
                else {
                    column.$cellCss[rowId] = "".concat(css, " ");
                }
            }
            this.paint();
        }
    };
    Grid.prototype.removeCellCss = function (rowId, colId, css) {
        var column = this.getColumn(colId);
        if (column) {
            if (column.$cellCss[rowId]) {
                column.$cellCss[rowId] = column.$cellCss[rowId].replace(css, "");
                this.paint();
            }
            else if (this.data.getItem(rowId)) {
                column.$cellCss[rowId] = "";
            }
        }
    };
    Grid.prototype.showColumn = function (colId) {
        var column = this.getColumn(colId);
        if (!column || !column.hidden) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeColumnShow, [column]))
            return;
        column.hidden = false;
        this.config.$totalWidth += column.$width;
        this._parseColumns();
        this.config.data = this._prepareData(this.data);
        var filter = this._hiddenFilters && this._hiddenFilters[column.id];
        if (filter) {
            this._activeFilters[column.id] = filter;
            delete this._hiddenFilters[column.id];
            this._checkFilters();
            this._checkSelectFilterValue();
        }
        this.paint();
        this.events.fire(types_1.GridEvents.afterColumnShow, [column]);
    };
    Grid.prototype.hideColumn = function (colId) {
        var column = this.getColumn(colId);
        if (!column || column.hidden) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeColumnHide, [column]))
            return;
        column.hidden = true;
        this.config.$totalWidth -= column.$width;
        this._parseColumns();
        this.config.data = this._prepareData(this.data);
        var filter = this._activeFilters && this._activeFilters[column.id];
        if (filter) {
            if (!this._hiddenFilters) {
                this._hiddenFilters = {};
            }
            this._hiddenFilters[column.id] = filter;
            delete this._activeFilters[column.id];
            this._checkFilters();
        }
        this.paint();
        this.events.fire(types_1.GridEvents.afterColumnHide, [column]);
    };
    Grid.prototype.isColumnHidden = function (colId) {
        var column = this.getColumn(colId);
        if (column) {
            return !!column.hidden;
        }
    };
    Grid.prototype.showRow = function (rowId) {
        if (!(0, core_1.isDefined)(rowId)) {
            return;
        }
        var id = rowId.toString();
        var row = this.data.getItem(id);
        if (!row || !row.hidden) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeRowShow, [row]))
            return;
        this.data.update(id, { hidden: false });
        this._checkFilters(true);
        this.paint();
        this.events.fire(types_1.GridEvents.afterRowShow, [row]);
    };
    Grid.prototype.hideRow = function (rowId) {
        if (!(0, core_1.isDefined)(rowId)) {
            return;
        }
        var id = rowId.toString();
        var row = this.data.getItem(id);
        if (!row) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeRowHide, [row]))
            return;
        this.data.update(id, { hidden: true });
        this._checkFilters(true);
        this._checkSelectFilterValue();
        this.paint();
        this.events.fire(types_1.GridEvents.afterRowHide, [row]);
    };
    Grid.prototype.isRowHidden = function (rowId) {
        if (!(0, core_1.isDefined)(rowId)) {
            return;
        }
        var row = this.data.getItem(rowId.toString());
        if (row) {
            return !!row.hidden;
        }
    };
    Grid.prototype.getScrollState = function () {
        return {
            x: this._scroll.left,
            y: this._scroll.top,
        };
    };
    Grid.prototype.scroll = function (x, y) {
        var gridBody = this.getRootView().refs.grid_body.el.querySelector(".scroll-view") ||
            this.getRootView().refs.grid_body.el;
        gridBody.scrollLeft = (x || x === 0) && typeof x === "number" ? x : gridBody.scrollLeft;
        gridBody.scrollTop = (y || y === 0) && typeof y === "number" ? y : gridBody.scrollTop;
        this.paint();
    };
    Grid.prototype.scrollTo = function (rowId, colId) {
        var selectedCell = this.selection.getCell();
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var colInd = (0, core_1.findIndex)(columns, function (_a) {
            var id = _a.id;
            return id == colId;
        });
        var prevCol = selectedCell ? selectedCell.column : this.config.columns[0];
        var prevColInd = (0, core_1.findIndex)(columns, function (obj) { return obj.id == prevCol.id; });
        var fixedColsWidth = this.config.leftSplit
            ? (0, main_1.getTotalWidth)(columns.slice(0, this.config.leftSplit))
            : 0;
        var x = (0, main_1.getTotalWidth)(columns.slice(0, colInd)) - (colInd - prevColInd < 0 ? fixedColsWidth : 0);
        var rows = this.data.getRawData(0, -1);
        var rowInd = (0, core_1.findIndex)(rows, function (_a) {
            var id = _a.id;
            return id == rowId;
        });
        var y = (0, main_1.getTotalHeight)(rows.slice(0, rowInd));
        var scrollState = this.getScrollState();
        var gridRight = this.config.$width + scrollState.x;
        var gridBottom = this.config.$height + scrollState.y - this.config.$headerHeight;
        var cellTop = y - scrollState.y - rows[rowInd].$height;
        var cellLeft = x - scrollState.x - columns[colInd].$width;
        var cellBottom = y + rows[rowInd].$height * 2 + 18 - gridBottom;
        var cellRight = x + columns[colInd].$width * 2 + 18 - gridRight;
        var scrollTop = cellTop > 0 && cellBottom < 0 ? 0 : cellTop < 0 ? cellTop : cellBottom;
        var scrollLeft = cellLeft > 0 && cellRight < 0 ? 0 : cellLeft < 0 ? cellLeft : cellRight;
        this.scroll(scrollLeft + scrollState.x, scrollTop + scrollState.y);
    };
    Grid.prototype.adjustColumnWidth = function (colId, adjust) {
        if (adjust === void 0) { adjust = true; }
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var col = columns.filter(function (col) { return col.id === colId; });
        var totalCols = this._adjustColumnsWidth({
            rows: this.config.data,
            cols: col,
            totalCols: columns,
            adjust: adjust,
        });
        this.config.$totalWidth = columns.reduce(function (totalWidth, column) {
            if (totalCols[column.id]) {
                column.$fixed = true;
                var max = column.maxWidth;
                var min = column.minWidth;
                var width = totalCols[column.id];
                column.$width = width;
                if (max && width > max) {
                    column.$width = max;
                }
                if (min && column.$width < min) {
                    column.$width = min;
                }
            }
            return (totalWidth += column.$width);
        }, 0);
        this.paint();
    };
    Grid.prototype.getCellRect = function (rowId, colId) {
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var rows = this.data.getRawData(0, -1);
        var span = this.getSpan(rowId, colId);
        var colInd = (0, core_1.findIndex)(columns, function (obj) { return obj.id == (span ? span.column : colId); });
        var rowInd = (0, core_1.findIndex)(rows, function (obj) { return obj.id == (span ? span.row : rowId); });
        var x = (0, main_1.getTotalWidth)(columns.slice(0, colInd));
        var y = (0, main_1.getTotalHeight)(rows.slice(0, rowInd));
        return {
            x: x,
            y: y,
            height: (span === null || span === void 0 ? void 0 : span.rowspan)
                ? (0, cells_1.getHeight)(rows, span.rowspan, rowInd)
                : rows[rowInd]
                    ? rows[rowInd].$height
                    : 0,
            width: (span === null || span === void 0 ? void 0 : span.colspan)
                ? (0, cells_1.getWidth)(this.config.columns, span.colspan, (0, core_1.findIndex)(this.config.columns, function (item) { return item.id === span.column; }))
                : columns[colInd]
                    ? columns[colInd].$width
                    : 0,
        };
    };
    Grid.prototype.getColumn = function (colId) {
        var _a;
        for (var _i = 0, _b = (_a = this.config) === null || _a === void 0 ? void 0 : _a.columns; _i < _b.length; _i++) {
            var col = _b[_i];
            if (col.id == colId) {
                return col;
            }
        }
    };
    Grid.prototype.addSpan = function (spanObj) {
        this.config.spans = this.config.spans || [];
        var index = (0, core_1.findIndex)(this.config.spans, function (span) { return "".concat(span.row) === "".concat(spanObj.row) && "".concat(span.column) === "".concat(spanObj.column); });
        if (index >= 0) {
            this.config.spans[index] = spanObj;
            return;
        }
        this.config.spans.push((0, Cells_1.normalizeSpan)(spanObj, this.config));
        this._checkMarks();
        this.paint();
    };
    Grid.prototype.getSpan = function (rowId, colId) {
        var _this = this;
        var _a;
        if (this.config.spans) {
            var rowIndex_1 = this.data.getIndex(rowId.toString());
            var colIndex_1 = this.config.columns.findIndex(function (col) { return col.id === colId; });
            var index = (0, core_1.findIndex)(this.config.spans, function (span) {
                var startRowInd = _this.data.getIndex(span.row.toString());
                var startColInd = _this.config.columns.findIndex(function (col) { return col.id === span.column; });
                var rows = {
                    start: startRowInd,
                    end: span.rowspan ? startRowInd + span.rowspan : startRowInd + 1,
                };
                var cols = {
                    start: startColInd,
                    end: span.colspan ? startColInd + span.colspan : startColInd + 1,
                };
                return (rowIndex_1 >= rows.start &&
                    rowIndex_1 < rows.end &&
                    colIndex_1 >= cols.start &&
                    colIndex_1 < cols.end);
            });
            return (_a = this.config) === null || _a === void 0 ? void 0 : _a.spans[index];
        }
    };
    Grid.prototype.removeSpan = function (rowId, colId) {
        if (this.config.spans) {
            var index = (0, core_1.findIndex)(this.config.spans, function (span) { return "".concat(span.row) == "".concat(rowId) && "".concat(span.column) == "".concat(colId); });
            this.config.spans.splice(index, 1);
            this.paint();
        }
    };
    Grid.prototype.editCell = function (rowId, colId, editorType) {
        var _a;
        var row = this.data.getItem(rowId);
        var col = this.getColumn(colId);
        if (!row || !col) {
            (0, ts_data_1.dhxWarning)("item not found");
            return;
        }
        var colEditorType = col.editorType;
        var span = this.getSpan(row.id, col.id);
        if (!editorType) {
            editorType = this.config.autoHeight && col.type !== "number" ? "textarea" : "input";
            if (col.type === "date") {
                editorType = "datePicker";
            }
            if (col.type === "boolean") {
                editorType = "checkbox";
            }
            if (colEditorType) {
                editorType = colEditorType;
            }
            if ((0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text)) {
                editorType = this.config.autoHeight ? "textarea" : "input";
            }
        }
        if (col.type === "number") {
            var isTextSpanEditor = (0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text) && ["input", "textarea"].includes(editorType);
            if (!isTextSpanEditor && !["input", "select", "combobox"].includes(editorType)) {
                return;
            }
        }
        if (!this.events.fire(types_1.GridEvents.beforeEditStart, [row, col, editorType])) {
            return;
        }
        if (((_a = this.config.$editable) === null || _a === void 0 ? void 0 : _a.editor) ||
            (this.config.$editable &&
                this.config.$editable.row === rowId &&
                this.config.$editable.col === colId &&
                this.config.$editable.editorType === editorType)) {
            return;
        }
        this.config.$editable = {
            row: row.id,
            col: col.id,
            isSpan: !!span,
            editorType: editorType,
        };
        if (!this.selection.config.disabled) {
            this.selection.setCell(rowId.toString(), colId.toString());
        }
        this.paint();
        this.events.fire(types_1.GridEvents.afterEditStart, [row, col, editorType]);
    };
    Grid.prototype.editEnd = function (withoutSave) {
        if (this.config.$editable && this.config.$editable.editor) {
            this.config.$editable.editor.endEdit(withoutSave);
        }
    };
    Grid.prototype.getSortingState = function () {
        return { dir: this._sortDir, by: this._sortBy };
    };
    Grid.prototype.getHeaderFilter = function (colId) {
        var _this = this;
        var col = this.getColumn(colId);
        if (!col) {
            return;
        }
        var filter = null;
        col.header.forEach(function (cell) {
            if (cell.content) {
                filter = _this.content[cell.content].element[colId];
            }
        });
        return filter;
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Grid.prototype.edit = function (rowId, colId, editorType) {
        this.editCell(rowId, colId, editorType);
    };
    Grid.prototype.paint = function () {
        var customHotkeysLength = this.config.hotkeys ? Object.keys(this.config.hotkeys).length : 0;
        if (this.keyManager && !(this.keyManager.getKeyStorageLength() - customHotkeysLength)) {
            this._initHotKey(true);
        }
        _super.prototype.paint.call(this);
    };
    Grid.prototype._createView = function () {
        var _this = this;
        return (0, dom_1.create)({
            render: function (vm, obj) {
                return _this._destructed
                    ? (0, dom_1.el)("div")
                    : (0, render_1.render)(vm, obj, _this._htmlEvents, _this.selection, _this._uid);
            },
            hooks: this._initHooks(),
        }, this);
    };
    Grid.prototype._parseColumns = function (configChanged) {
        if (configChanged === void 0) { configChanged = false; }
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        this.normalizeColumns({ config: this.config, columns: columns, configChanged: configChanged });
        (0, data_1.countColumns)(this.config, columns);
    };
    Grid.prototype.normalizeColumns = function (_a) {
        var _this = this;
        var _b, _c, _d;
        var config = _a.config, columns = _a.columns, configChanged = _a.configChanged;
        config.$headerHeightMap = [];
        config.$footerHeightMap = [];
        config.$headerHeight = config.$footerHeight = 0;
        for (var _i = 0, columns_1 = columns; _i < columns_1.length; _i++) {
            var col = columns_1[_i];
            col.htmlEnable = (_b = col.htmlEnable) !== null && _b !== void 0 ? _b : config.htmlEnable;
            col.$cellCss = col.$cellCss || {};
            (0, data_1.normalizeArray)(col, "header");
            (0, data_1.normalizeArray)(col, "footer");
            if (col.minWidth && col.minWidth < 20)
                col.minWidth = 20;
            if (col.maxWidth && col.maxWidth < 20)
                col.maxWidth = 20;
            var width = col.minWidth || 100;
            if (col.width) {
                if (col.maxWidth && col.minWidth) {
                    width =
                        col.width >= col.minWidth && col.width <= col.maxWidth
                            ? col.width
                            : col.width >= col.maxWidth
                                ? col.maxWidth
                                : col.minWidth;
                }
                else if (col.maxWidth) {
                    width = col.width <= col.maxWidth ? col.width : col.maxWidth > 100 ? col.maxWidth : 100;
                }
                else if (col.minWidth) {
                    width = col.width >= col.minWidth ? col.width : col.minWidth;
                }
                else {
                    width = col.width;
                }
                width = width < 20 ? 20 : width;
            }
            col.$width = col.$width && !configChanged ? col.$width : width;
            if (col.$width > col.maxWidth) {
                col.$width = col.maxWidth;
            }
            if (col.$width < col.minWidth) {
                col.$width = col.minWidth;
            }
        }
        var _loop_1 = function (col) {
            if ((_c = col.header) === null || _c === void 0 ? void 0 : _c.length) {
                var currentHeight_1 = 0;
                col.header.forEach(function (header, index) {
                    if (config.headerAutoHeight) {
                        currentHeight_1 = _this.getNormalizeContentHeight(header, col, config);
                    }
                    else {
                        currentHeight_1 = config.headerRowHeight;
                    }
                    if (currentHeight_1 > (config.$headerHeightMap[index] || 0)) {
                        config.$headerHeightMap[index] = Math.max(currentHeight_1, config.headerRowHeight);
                    }
                });
            }
            if ((_d = col.footer) === null || _d === void 0 ? void 0 : _d.length) {
                var currentHeight_2 = 0;
                col.footer.forEach(function (footer, index) {
                    if (config.footerAutoHeight) {
                        currentHeight_2 = _this.getNormalizeContentHeight(footer, col, config);
                    }
                    else {
                        currentHeight_2 = config.footerRowHeight;
                    }
                    if (currentHeight_2 > (config.$footerHeightMap[index] || 0)) {
                        config.$footerHeightMap[index] = Math.max(currentHeight_2, config.footerRowHeight);
                    }
                });
            }
        };
        for (var _e = 0, columns_2 = columns; _e < columns_2.length; _e++) {
            var col = columns_2[_e];
            _loop_1(col);
        }
        config.$headerHeight = config.$headerHeightMap.reduce(function (acc, cur) { return (acc += cur); }, 0);
        config.$footerHeight = config.$footerHeightMap.reduce(function (acc, cur) { return (acc += cur); }, 0);
    };
    Grid.prototype.getNormalizeContentHeight = function (row, col, config) {
        return this.config.footerRowHeight;
    };
    Grid.prototype._parseData = function () {
        this._detectColsTypes();
        this.config.data = this.data.map(function (row) { return row; });
        this.config.data = this._prepareData(this.data);
        this._checkMarks();
        this.data.filter(function (i) { return !i.hidden; }, { $local: true, permanent: true }, true);
        this._checkFilters();
        this._render();
    };
    Grid.prototype._createCollection = function (prep) {
        this.data = new ts_data_1.DataCollection({ prep: prep }, this.events);
    };
    Grid.prototype._getRowIndex = function (rowId) {
        return this.data.getIndex(rowId);
    };
    Grid.prototype._setEventHandlers = function () {
        var _this = this;
        var updater = function (_a) {
            var source = _a.source, target = _a.target, updateObj = __rest(_a, ["source", "target"]);
            if (source === null || source === void 0 ? void 0 : source.length) {
                source.map(function (selectedId) { return _this.data.exists(selectedId) && _this.data.update(selectedId, updateObj); });
            }
            if (_this.data.exists(target)) {
                _this.data.update(target, updateObj);
            }
        };
        this.data.events.on(ts_data_1.DataEvents.load, function () {
            _this.data.filter(function (i) { return i; }, { $local: true }, true);
            _this._parseData();
            if (_this.config.data instanceof ts_data_1.DataCollection) {
                (0, dom_1.awaitRedraw)().then(function () { return _this._normalizeSpans(); });
            }
            else {
                _this._normalizeSpans();
            }
        });
        this.data.events.on(ts_data_1.DataEvents.change, function (id, status, obj) {
            if (status === "setPage") {
                (0, dom_1.awaitRedraw)().then(function () {
                    var colVisible = _this.config.columns.find(function (col) { return col.hidden !== true; });
                    _this.scrollTo(_this.data.getId(obj[0]).toString(), colVisible.id.toString());
                    _this._render();
                });
                return;
            }
            if (status === "sort") {
                if (!obj.dir) {
                    if (_this._sortBy === obj.by) {
                        _this._sortDir = _this._sortDir === "asc" ? "desc" : "asc";
                    }
                    else {
                        _this._sortDir = "asc";
                    }
                }
                else {
                    _this._sortDir = obj.dir;
                }
                _this._sortBy = obj.by;
            }
            else if (status === "add" || status === "update" || status === "remove") {
                if ((0, core_1.isId)(id) && status === "remove") {
                    var removed = _this.selection.getCells().find(function (cell) { return cell.row.id === id; });
                    removed && _this.selection.removeCell(removed.row.id, removed.column.id);
                }
                _this.config.data = _this._prepareData(_this.data);
            }
            else {
                if ((0, ts_data_1.isTreeCollection)(_this.data)) {
                    _this.config.data = _this._prepareData(_this.data);
                }
                _this._adjustColumns();
            }
            if ((0, core_1.isId)(id)) {
                _this._checkFilters();
                _this._checkSelectFilterValue();
            }
            _this._detectColsTypes();
            _this._removeMarks();
            _this._checkMarks();
            if (_this.config.autoEmptyRow && (!_this._activeFilters || (0, core_1.isEmptyObj)(_this._activeFilters))) {
                var emptyRow = _this.data.find({ by: "$emptyRow", match: true });
                if (emptyRow) {
                    if (emptyRow.id === id)
                        return;
                    _this.data.move(emptyRow.id, _this.data.getLength() - 1);
                }
                else {
                    _this._addEmptyRow();
                }
            }
            _this._render();
        });
        this.data.events.on(ts_data_1.DataEvents.filter, function (filters) {
            if (!filters && !_this.data.getRawFilters({ permanent: true })) {
                _this.data.filter(function (i) { return !i.hidden; }, { $local: true, permanent: true }, true);
            }
            if (!filters || (0, ts_data_1.isOnlyPermanentFilters)(filters)) {
                _this._filterData = _this.data.map(function (el) { return el; }) || [];
                _this._setUniqueData();
                _this._clearFilterValue();
            }
            else {
                _this._checkFilters();
            }
            _this.paint();
        });
        this.data.events.on(ts_data_1.DataEvents.removeAll, function () {
            _this._hiddenFilters = {};
            _this.config.columns.map(function (col) {
                col.header.map(function (cell) {
                    if (cell.content && (cell.content === "selectFilter" || cell.content === "comboFilter")) {
                        col.$uniqueData = [];
                    }
                });
            });
            if (!(0, core_1.isEmptyObj)(_this._activeFilters)) {
                _this.data.resetFilter();
            }
            _this._clearFilterValue(true);
        });
        this.events.on(ts_data_1.DragEvents.beforeDrag, function (data, events) {
            if (_this.data.getItem(data.start)) {
                return _this.events.fire(types_1.GridEvents.beforeRowDrag, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                return _this.events.fire(types_1.GridEvents.beforeColumnDrag, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.dragStart, function (data, events) {
            var source = data.source, target = data.target, start = data.start;
            updater({
                source: source,
                target: target,
                $dragtarget: true,
            });
            if (_this.data.getItem(start)) {
                _this.events.fire(types_1.GridEvents.dragRowStart, [data, events]);
                _this._autoScroll("vertical");
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.dragColumnStart, [data, events]);
                _this._autoScroll("horizontal");
            }
        });
        this.events.on(ts_data_1.DragEvents.dragIn, function (data, events) {
            if (_this.data.getItem(data.start)) {
                _this.events.fire(types_1.GridEvents.dragRowIn, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.dragColumnIn, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.dragOut, function (data, events) {
            if (_this.data.getItem(data.start)) {
                _this.events.fire(types_1.GridEvents.dragRowOut, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.dragColumnOut, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.canDrop, function (data, events) {
            var _a = data, source = _a.source, target = _a.target, dragItem = _a.dragItem;
            delete data.dragItem;
            updater({
                source: source,
                target: target,
                $drophere: true,
            });
            if (dragItem === "row") {
                _this.events.fire(types_1.GridEvents.canRowDrop, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.canColumnDrop, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.cancelDrop, function (data, events) {
            var source = data.source, target = data.target, start = data.start;
            updater({
                source: source,
                target: target,
                $drophere: undefined,
                $dragtarget: undefined,
            });
            if (_this.data.getItem(start)) {
                _this.events.fire(types_1.GridEvents.cancelRowDrop, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.cancelColumnDrop, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.beforeDrop, function (data, events) {
            if (_this.config.dragItem === "row" &&
                (_this.config.dragMode === "both" || _this.config.dragMode === "target")) {
                return _this.events.fire(types_1.GridEvents.beforeRowDrop, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                return _this.events.fire(types_1.GridEvents.beforeColumnDrop, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.afterDrop, function (data, events) {
            var _a;
            var _b;
            if (_this.data.getItem(data.start)) {
                var source = data.source;
                if (source.some(function (id) { return id == data.target; }))
                    return;
                var item = _this.data.getItem(data.start);
                for (var _i = 0, _c = _this.config.columns; _i < _c.length; _i++) {
                    var col = _c[_i];
                    if (typeof item[col.id] === "undefined") {
                        _this.data.update(item.id, (_a = {}, _a[col.id] = null, _a), true);
                    }
                }
                var initData = _this.data.getInitialData();
                var startIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == data.start; });
                var targetIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == data.target; });
                if (startIndex > -1 && targetIndex > -1) {
                    if (((_b = data.source) === null || _b === void 0 ? void 0 : _b.length) > 1) {
                        var moveData = [];
                        var _loop_2 = function (id) {
                            var itemIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == id; });
                            var moveItem = initData === null || initData === void 0 ? void 0 : initData.splice(itemIndex, 1)[0];
                            moveData.push(moveItem);
                        };
                        for (var _d = 0, source_1 = source; _d < source_1.length; _d++) {
                            var id = source_1[_d];
                            _loop_2(id);
                        }
                        targetIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == data.target; });
                        if (targetIndex > 0)
                            ++targetIndex;
                        initData === null || initData === void 0 ? void 0 : initData.splice.apply(initData, __spreadArray([targetIndex, 0], moveData, false));
                    }
                    else {
                        initData === null || initData === void 0 ? void 0 : initData.splice(targetIndex, 0, initData === null || initData === void 0 ? void 0 : initData.splice(startIndex, 1)[0]);
                    }
                }
                _this.config.data = _this._prepareData(initData || _this.data.map(function (i) { return i; }));
                _this.data.parse(_this.config.data);
                _this._checkFilters();
                _this.paint();
                _this.events.fire(types_1.GridEvents.afterRowDrop, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.afterColumnDrop, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.afterDrag, function (data, events) {
            var source = data.source, target = data.target, start = data.start;
            updater({
                source: source,
                target: target,
                $dragtarget: undefined,
            });
            if (_this.data.getItem(start)) {
                _this.events.fire(types_1.GridEvents.afterRowDrag, [data, events]);
            }
            else if (_this.config.dragItem === "column" || _this.config.dragItem === "both") {
                _this.events.fire(types_1.GridEvents.afterColumnDrag, [data, events]);
            }
            _this.config.data = _this._prepareData(_this.data instanceof Array ? _this.data.map(function (i) { return i; }) : _this.data.getInitialData() || _this.data);
            _this.data.parse(_this.config.data);
        });
        // TODO: When introducing touch events, remove system events
        this.events.on(types_1.GridEvents.cellMouseDown, function (row, col, e) {
            if (!e.targetTouches) {
                _this._dragStart(e);
            }
            else {
                _this._touch.timer = setTimeout(function () {
                    _this._dragStart(e);
                }, _this._touch.duration);
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +e.timeStamp.toFixed();
                }
                else {
                    var doubleTap = _this._touch.dblDuration >= _this._touch.timeStamp - +e.timeStamp.toFixed();
                    if (doubleTap) {
                        if ((col.editable !== false && _this.config.editable) || col.editable) {
                            _this.editCell(row.id, col.id, col.editorType);
                        }
                        e.preventDefault();
                        // to simulate on touch devices
                        _this.events.fire(types_1.GridEvents.cellDblClick, [row, col, e]);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            }
        });
        this._events.on(types_1.GridSystemEvents.cellTouchMove, function (_row, _col, e) {
            _this._touch.start && e.preventDefault();
            _this._clearTouchTimer();
        });
        this._events.on(types_1.GridSystemEvents.cellTouchEnd, function () {
            _this._touch.start = false;
            _this._clearTouchTimer();
        });
        this.events.on(types_1.GridEvents.filterChange, function (val, colId, filter, silent) {
            var _a, _b, _c;
            if (!_this.events.fire(types_1.GridEvents.beforeFilter, [val, colId])) {
                return;
            }
            if (_this.config.autoEmptyRow) {
                var emptyRow = _this.data.find({ by: "$emptyRow", match: true });
                if (emptyRow) {
                    _this.data.remove(emptyRow.id);
                }
            }
            if (!_this._activeFilters) {
                _this._activeFilters = {};
            }
            var columnConfig = _this.getColumn(colId);
            var conf = columnConfig.header.filter(function (item) { return item.content === filter && item.customFilter !== undefined; })[0];
            if ((filter === "comboFilter" && val !== undefined) || (filter !== "comboFilter" && val !== "")) {
                var options_1 = (0, data_1.getEditorOptions)(columnConfig);
                if ((columnConfig.editorType === "combobox" ||
                    columnConfig.editorType === "select" ||
                    columnConfig.editorType === "multiselect") &&
                    options_1) {
                    if (Array.isArray(val)) {
                        val = val.map(function (item) {
                            var _a;
                            return (((_a = options_1.find(function (option) {
                                return typeof option === "string" ? option === item : option.value === item;
                            })) === null || _a === void 0 ? void 0 : _a.id) || item);
                        });
                    }
                    else {
                        val =
                            (_b = (_a = options_1.find(function (option) {
                                return typeof option === "string" ? option === val : option.value === val;
                            })) === null || _a === void 0 ? void 0 : _a.id) !== null && _b !== void 0 ? _b : val;
                    }
                }
                var match = function (colId) {
                    var col = _this.getColumn(colId);
                    return function (val, match, obj, multi) {
                        return _this.content[filter].match({ val: val, match: match, obj: obj, multi: multi, col: col });
                    };
                };
                _this._activeFilters[colId] = {
                    by: colId,
                    match: val,
                    compare: (_c = conf === null || conf === void 0 ? void 0 : conf.customFilter) !== null && _c !== void 0 ? _c : match(colId),
                    multi: (columnConfig === null || columnConfig === void 0 ? void 0 : columnConfig.editorType) === "multiselect",
                };
            }
            else {
                delete _this._activeFilters[colId];
            }
            if (!silent) {
                _this.data.filter(_this._activeFilters);
            }
        });
        this.events.on(types_1.GridEvents.scroll, function (scrollState) {
            _this._scroll = { top: scrollState.y, left: scrollState.x };
            _this.editEnd();
            _this.paint();
        });
        this.events.on(types_1.GridEvents.cellDblClick, function (row, col, e) {
            var targetCheckbox = (0, html_1.locateNodeByClassName)(e, "dhx_boolean-cell");
            if (targetCheckbox || row.hasOwnProperty("$groupName"))
                return;
            if ((col.editable !== false && _this.config.editable) || col.editable) {
                _this.editCell(row.id, col.id, col.editorType);
            }
        });
        this.events.on(types_1.GridEvents.afterEditEnd, function (value, eRow, eCol) {
            var _a;
            var _b;
            if (((_b = _this.config.$editable) === null || _b === void 0 ? void 0 : _b.editor) &&
                (_this.config.$editable.col !== eCol.id || _this.config.$editable.row !== eRow.id))
                return;
            var row;
            var col;
            if (!_this.config.$editable) {
                row = eRow.id;
                col = eCol.id;
            }
            else {
                row = _this.config.$editable.row;
                col = _this.config.$editable.col;
            }
            var span = _this.getSpan(row, col);
            if ((0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text) && value !== undefined) {
                span.text = value.toString();
            }
            else {
                var item = _this.data.getItem(row);
                delete item.$emptyRow;
                if (value !== undefined) {
                    _this.data.update(row, __assign(__assign({}, item), (_a = {}, _a[col] = value, _a)));
                }
            }
            _this.config.$editable = null;
            _this.paint();
        });
        this.events.on(types_1.GridEvents.headerCellMouseDown, function (col, e) {
            var target = e.target;
            var resizedColumn = target.getAttribute("dhx_resized");
            if (resizedColumn && _this.events.fire(types_1.GridEvents.beforeResizeStart, [col, e])) {
                (0, columnsResizer_1.startResize)(_this, resizedColumn.toString(), e, function () {
                    _this.paint();
                    _this.config.$resizing = null;
                    _this.events.fire(types_1.GridEvents.afterResizeEnd, [col, e]);
                });
            }
            if (e.targetTouches) {
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +e.timeStamp.toFixed();
                }
                else {
                    var doubleTap = _this._touch.dblDuration >= _this._touch.timeStamp - +e.timeStamp.toFixed();
                    if (doubleTap) {
                        e.preventDefault();
                        // to simulate on touch devices
                        _this.events.fire(types_1.GridEvents.headerCellDblClick, [col, e]);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            }
        });
        this.events.on(types_1.GridEvents.footerCellDblClick, function (col, e) {
            if (e.targetTouches) {
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +e.timeStamp.toFixed();
                }
                else {
                    var doubleTap = _this._touch.dblDuration >= _this._touch.timeStamp - +e.timeStamp.toFixed();
                    if (doubleTap) {
                        e.preventDefault();
                        // to simulate on touch devices
                        _this.events.fire(types_1.GridEvents.footerCellDblClick, [col, e]);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            }
        });
        this.events.on(types_1.GridEvents.resize, function () { return _this._parseColumns(); });
        this.events.on(types_1.GridEvents.afterResizeEnd, function (col) {
            var _a;
            _this.config.columns = (_a = _this.config.columns) === null || _a === void 0 ? void 0 : _a.map(function (c) {
                if (c.id == col.id)
                    c.width = col.$width;
                return c;
            });
            _this._parseColumns();
        });
    };
    Grid.prototype._addEmptyRow = function () {
        var id = this.data.getId(this.data.getLength() - 1);
        var lastRow = this.data.getItem(id);
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var isEmpty = (0, main_1.isRowEmpty)(lastRow);
        if (!isEmpty) {
            this.data.add(columns.reduce(function (total, col) {
                total[col.id] = "";
                return total;
            }, { $emptyRow: true }));
        }
    };
    Grid.prototype._sort = function (by, dir, sortAs) {
        var _this = this;
        if (!dir) {
            if (this._sortBy === by) {
                dir = this._sortDir === "asc" ? "desc" : "asc";
            }
            else {
                dir = "asc";
            }
        }
        var defaultAs = function (item) {
            var col = _this.getColumn(by);
            if (item && col.type === "date") {
                return typeof item === "string" ? (0, date_1.stringToDate)(item, col.format).getTime() : item.getTime();
            }
            return item ? "".concat(item) : "";
        };
        this.data.sort({
            by: by,
            dir: dir,
            as: sortAs !== null && sortAs !== void 0 ? sortAs : defaultAs,
        });
        this.events.fire(types_1.GridEvents.afterSort, [this.getColumn(by), dir]);
    };
    Grid.prototype._clearTouchTimer = function () {
        if (this._touch.timer) {
            clearTimeout(this._touch.timer);
            this._touch.timer = null;
        }
    };
    Grid.prototype._checkFilters = function (reset) {
        if (reset === void 0) { reset = false; }
        if ((0, core_1.isEmptyObj)(this._activeFilters)) {
            if (reset) {
                this.data.resetFilter();
            }
            this._filterData = this.data.map(function (el) { return el; }) || [];
            this._setUniqueData();
        }
        else {
            var permFilters = this.data.getRawFilters({ permanent: true });
            this.data.filter(permFilters, { $restore: true }, true);
            this._filterData = this.data.map(function (el) { return el; }) || [];
            this._setUniqueData();
            this.data.filter(null, { $restore: true }, true);
            this._filterData = this.data.map(function (el) { return el; }) || [];
            this._setUniqueData(true);
        }
    };
    Grid.prototype._setUniqueData = function (sync) {
        var _this = this;
        if (sync === void 0) { sync = false; }
        if (!this._filterData)
            return;
        this.config.columns.forEach(function (col) {
            col.header.forEach(function (cell) {
                if (cell.content && (cell.content === "selectFilter" || cell.content === "comboFilter")) {
                    var multi = col.header.some(function (i) { var _a; return (_a = i.filterConfig) === null || _a === void 0 ? void 0 : _a.multiselection; });
                    if (!sync || (sync && !multi)) {
                        var unique = (0, data_1.getUnique)(_this._filterData, col.id, multi);
                        var options_2 = (0, data_1.getEditorOptions)(col);
                        if ((col.editorType === "combobox" ||
                            col.editorType === "select" ||
                            col.editorType === "multiselect") &&
                            options_2) {
                            unique = unique.map(function (item) {
                                var foundItem = options_2.find(function (option) {
                                    return typeof option === "string" ? item === option : item === option.id;
                                });
                                return foundItem && typeof foundItem !== "string" ? foundItem.value : item;
                            });
                        }
                        unique =
                            col.type !== "string"
                                ? Array.from(new Set(unique.map(function (val) { return (0, data_1.toFormat)(val, col.type, col.format); })))
                                : unique;
                        if (!sync) {
                            col.$uniqueData = unique;
                            if (col.$activeFilterData)
                                delete col.$activeFilterData;
                        }
                        else {
                            col.$activeFilterData = unique;
                        }
                    }
                }
            });
        });
    };
    Grid.prototype._checkSelectFilterValue = function () {
        var _a;
        var filter = (_a = this.content) === null || _a === void 0 ? void 0 : _a.selectFilter;
        if (!filter)
            return;
        for (var key in filter.value) {
            var col = this.getColumn(key);
            var val = filter.value[key];
            if (!col.hidden && val && !col.$uniqueData.includes(val)) {
                filter.element[key].clear();
            }
        }
    };
    Grid.prototype._clearFilterValue = function (allCols) {
        var _this = this;
        if (allCols === void 0) { allCols = false; }
        var filters = ["selectFilter", "inputFilter"].map(function (i) { var _a; return (_a = _this.content) === null || _a === void 0 ? void 0 : _a[i]; }).filter(function (i) { return i; });
        filters.forEach(function (filter) {
            for (var key in filter.value) {
                if (filter.value[key] && (allCols || !_this.getColumn(key).hidden)) {
                    filter.element[key].clear(true);
                }
            }
        });
    };
    Grid.prototype._adjustColumns = function () {
        var _this = this;
        if (typeof this.config.adjust === "boolean" ||
            this.config.adjust === "data" ||
            this.config.adjust === "header" ||
            this.config.adjust === "footer") {
            var columns = this.config.columns.filter(function (col) { return !col.hidden; });
            if (!columns.length)
                return;
            var data = !this.config.data || !this.config.data.length ? this.data.map(function (row) { return row; }) : this.config.data;
            var totalCols_1 = this._adjustColumnsWidth({
                rows: data,
                cols: columns,
                totalCols: columns,
            });
            this.config.$totalWidth = columns.reduce(function (totalWidth, column) {
                column.$fixed = true;
                var max = column.maxWidth;
                var min = column.minWidth;
                var width = totalCols_1[column.id];
                column.$width = width;
                if (max && width > max) {
                    column.$width = max;
                }
                if (min && column.$width < min) {
                    column.$width = min;
                }
                return (totalWidth += column.$width);
            }, 0);
        }
        else {
            var columns = this.config.columns.filter(function (col) { return !col.hidden && col.adjust; });
            if (!columns.length)
                return;
            columns.forEach(function (col) {
                _this.adjustColumnWidth(col.id, col.adjust);
            });
        }
    };
    Grid.prototype._prepareData = function (data) {
        var _this = this;
        if (this.config.autoHeight || this.config.headerAutoHeight || this.config.footerAutoHeight) {
            this.config.autoHeight = this.config.headerAutoHeight = this.config.footerAutoHeight = false;
        }
        this._normalizeDataType();
        this._adjustColumns();
        return data.map(function (row) {
            row.$height = row.height || _this.config.rowHeight;
            return row;
        });
    };
    Grid.prototype._adjustColumnsWidth = function (_a) {
        var _b, _c, _d;
        var _this = this;
        var rows = _a.rows, cols = _a.cols, _e = _a.adjust, adjust = _e === void 0 ? this.config.adjust : _e;
        var HORIZONTAL_OFFSET = 24;
        var iconOffset = function (col) { return ((0, main_1.isSortable)(_this.config, col) ? 16 : 0); };
        var columnsWidth = {};
        if (adjust === "header" || adjust === true) {
            var currentCols = cols.filter(function (col) { return col.header; });
            var data = (0, data_1.getMaxColsWidth)(this._prepareColumnData(currentCols, "header"), currentCols, {
                font: "bold 14.4px Arial",
            }, "header");
            if (data) {
                for (var _i = 0, _f = Object.entries(data); _i < _f.length; _i++) {
                    var _g = _f[_i], key = _g[0], value = _g[1];
                    columnsWidth = Object.assign(columnsWidth, (_b = {},
                        _b[key] = +value + HORIZONTAL_OFFSET + iconOffset(this.getColumn(key)),
                        _b));
                }
            }
        }
        if (adjust === "footer" || adjust === true) {
            var currentCols = cols.filter(function (col) { return col.footer; });
            var data = (0, data_1.getMaxColsWidth)(this._prepareColumnData(currentCols, "footer"), currentCols, {
                font: "bold 14.4px Arial",
            }, "footer");
            if (data) {
                for (var _h = 0, _j = Object.entries(data); _h < _j.length; _h++) {
                    var _k = _j[_h], key = _k[0], value = _k[1];
                    if ((columnsWidth[key] && columnsWidth[key] < +value + HORIZONTAL_OFFSET) ||
                        !columnsWidth[key]) {
                        columnsWidth = Object.assign(columnsWidth, (_c = {},
                            _c[key] = +value + HORIZONTAL_OFFSET,
                            _c));
                    }
                }
            }
        }
        if (adjust === "data" || adjust === true) {
            var data = (0, data_1.getMaxColsWidth)(rows, cols, {
                font: "normal 14.4px Arial",
            }, "data");
            if (data) {
                for (var _l = 0, _m = Object.entries(data); _l < _m.length; _l++) {
                    var _o = _m[_l], key = _o[0], value = _o[1];
                    if ((columnsWidth[key] && columnsWidth[key] < +value + HORIZONTAL_OFFSET) ||
                        !columnsWidth[key]) {
                        columnsWidth = Object.assign(columnsWidth, (_d = {},
                            _d[key] = +value + HORIZONTAL_OFFSET,
                            _d));
                    }
                }
            }
        }
        return columnsWidth;
    };
    Grid.prototype._prepareColumnData = function (data, type) {
        var _a;
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
        var totalRow = [];
        for (var i = 0; i < data.length; i++) {
            var row = [];
            for (var k = 0; k < ((_b = data[i]) === null || _b === void 0 ? void 0 : _b[type].length); k++) {
                var rowData = {};
                if ((_d = (_c = data[i]) === null || _c === void 0 ? void 0 : _c[type][k]) === null || _d === void 0 ? void 0 : _d.text) {
                    var isHTML = (_f = (_e = data[i]) === null || _e === void 0 ? void 0 : _e[type][k]) === null || _f === void 0 ? void 0 : _f.htmlEnable;
                    rowData[data[i].id] = ((_h = (_g = data[i]) === null || _g === void 0 ? void 0 : _g[type][k]) === null || _h === void 0 ? void 0 : _h.text) || "";
                    if (isHTML) {
                        rowData[data[i].id] = (0, main_1.removeHTMLTags)(rowData[data[i].id]);
                    }
                    row.push(rowData);
                }
                else if ((_k = (_j = data[i]) === null || _j === void 0 ? void 0 : _j[type][k]) === null || _k === void 0 ? void 0 : _k.content) {
                    var content = (_l = this.content) === null || _l === void 0 ? void 0 : _l[(_o = (_m = data[i]) === null || _m === void 0 ? void 0 : _m[type][k]) === null || _o === void 0 ? void 0 : _o.content];
                    if (typeof content.calculate === "function") {
                        rowData[data[i].id] =
                            (content === null || content === void 0 ? void 0 : content.toHtml(this.getColumn(data[i].id), __assign(__assign({}, this.config), { datacollection: this.data }))) || "";
                    }
                    else {
                        rowData[data[i].id] = "";
                    }
                    row.push(rowData);
                }
            }
            for (var j = 0; j < row.length; j++) {
                for (var _i = 0, _p = Object.entries(row[j]); _i < _p.length; _i++) {
                    var _q = _p[_i], key = _q[0], value = _q[1];
                    totalRow[j] = __assign({}, totalRow[j]) || {};
                    totalRow[j] = Object.assign(totalRow[j], (_a = {}, _a[key] = value, _a));
                }
            }
        }
        return totalRow;
    };
    Grid.prototype._dragStart = function (event) {
        if (this.config.dragMode &&
            (this.config.dragItem === "row" || this.config.dragItem === "both") &&
            !this.config.$editable) {
            var column = this.getColumn(event.target.getAttribute("data-dhx-col-id"));
            if ((column === null || column === void 0 ? void 0 : column.draggable) === false)
                return;
            var item = (0, html_1.locateNode)(event, "data-dhx-id");
            var itemId = item && item.getAttribute("data-dhx-id");
            if (event.targetTouches) {
                this._touch.start = true;
            }
            return ts_data_1.dragManager.onMouseDown(event, [itemId], [this._getRowGhost([itemId])]);
        }
    };
    Grid.prototype._getRowGhost = function (ids) {
        var container = this._container || (0, html_1.toNode)(this._uid);
        var rows = ids.map(function (id) { return container.querySelector(".dhx_grid-row[data-dhx-id=\"".concat(id, "\"]")); });
        var ghostContainer = document.createElement("div");
        rows.forEach(function (node) { return node && ghostContainer.appendChild(node.cloneNode(true)); });
        return ghostContainer;
    };
    Grid.prototype._initHooks = function () {
        var _this = this;
        return {
            didMount: function () {
                var _a;
                if (_this._canDataParse(true)) {
                    if (!_this._container) {
                        var parentNode = _this.getRootView().node.parent.el;
                        var parentSizes = (0, render_1.getElementSizes)(parentNode);
                        var scrollView = (_a = _this.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable;
                        (0, render_1.applyAutoWidth)(_this.config, parentSizes, true, false, scrollView);
                    }
                    _this.data.parse(_this.config.data);
                }
                if (_this.config.autoWidth) {
                    _this._parseColumns();
                }
            },
        };
    };
    Grid.prototype._normalizeDataType = function () {
        var _this = this;
        var numberColumns = this.config.columns.reduce(function (arr, col) {
            if (col.type === "number")
                arr.push(col);
            return arr;
        }, []);
        if (!numberColumns.length)
            return;
        this.data.forEach(function (item) {
            var _a;
            for (var _i = 0, numberColumns_1 = numberColumns; _i < numberColumns_1.length; _i++) {
                var col = numberColumns_1[_i];
                var value = (0, data_1.getValueForNumberColumn)(col, item[col.id]);
                if (Number.isNaN(value)) {
                    throw new Error("Incorrect data in column with type 'number', see docs: https://docs.dhtmlx.com/suite/grid/api/api_gridcolumn_properties/");
                }
                else if (item[col.id] !== value) {
                    _this.data.update(item.id, (_a = {}, _a[col.id] = value, _a), true);
                }
            }
        });
    };
    Grid.prototype._canDataParse = function (afterMount) {
        var _a;
        if (afterMount === void 0) { afterMount = false; }
        if (((_a = this.config.data) === null || _a === void 0 ? void 0 : _a.length) && this.config.data instanceof Array && this.config.columns) {
            return this.config.autoWidth && this.config.autoHeight ? afterMount : !afterMount;
        }
        return false;
    };
    Grid.prototype._init = function () {
        this.events = new events_1.EventSystem(this);
        this._events = new events_1.EventSystem(this);
        this._attachDataCollection();
        this.export = new Exporter_1.Exporter("grid", this.version, this);
        this._setEventHandlers();
    };
    Grid.prototype._attachDataCollection = function () {
        var _this = this;
        var prep = function (data) {
            if (data.spans) {
                _this.config.spans = data.spans;
                data = data.data;
            }
            return data;
        };
        if (this.config.data instanceof ts_data_1.DataCollection) {
            this.data = this.config.data;
            this.data.config.collapsed = this.config.collapsed;
            this.config.data = this.data.serialize();
            return;
        }
        this._createCollection(prep);
    };
    Grid.prototype._setMarks = function (col, func) {
        var colCells = this.data.map(function (row) { return ({
            id: row.id,
            data: row[col.id],
            row: row,
        }); });
        var colCellsData = this.data.map(function (row) { return row[col.id]; });
        var _loop_3 = function (cell) {
            var css = func(cell.data, colCellsData, cell.row, col);
            if (css) {
                col.$cellCss = col.$cellCss || {};
                var cellCss_1 = (col.$cellCss[cell.id] || "").split(" ");
                css.split(" ").map(function (item) {
                    if (!cellCss_1.includes(item)) {
                        cellCss_1.push(item);
                    }
                });
                var cellCssStr = cellCss_1.join(" ");
                var span = this_1.getSpan(cell.id, col.id);
                col.$cellCss[cell.id] = cellCssStr;
                if (span &&
                    (span.rowspan || (span.colspan && span.column === col.id)) &&
                    span.$markCss !== cellCssStr) {
                    span.$markCss = cellCssStr;
                }
            }
        };
        var this_1 = this;
        for (var _i = 0, colCells_1 = colCells; _i < colCells_1.length; _i++) {
            var cell = colCells_1[_i];
            _loop_3(cell);
        }
    };
    Grid.prototype._checkMarks = function () {
        var _this = this;
        this.config.columns.map(function (col) {
            var mark = col.mark;
            if (mark) {
                if (typeof mark === "function") {
                    _this._setMarks(col, mark);
                }
                else {
                    _this._setMarks(col, function (el, c) {
                        var data = [];
                        c.forEach(function (item) {
                            if (item !== null && item !== undefined && item !== "") {
                                data.push(parseFloat(item));
                            }
                        });
                        var min = (0, core_1.getMinArrayNumber)(data);
                        var max = (0, core_1.getMaxArrayNumber)(data);
                        if (mark.max && max === parseFloat(el)) {
                            return mark.max;
                        }
                        if (mark.min && min === parseFloat(el)) {
                            return mark.min;
                        }
                        return false;
                    });
                }
            }
        });
    };
    Grid.prototype._removeMarks = function () {
        var _a;
        this.config.columns.forEach(function (col) {
            if (col.mark) {
                col.$cellCss = {};
            }
        });
        (_a = this.config.spans) === null || _a === void 0 ? void 0 : _a.forEach(function (span) {
            if (span.$markCss) {
                delete span.$markCss;
            }
        });
    };
    // [todo] make more smart type detection
    Grid.prototype._detectColsTypes = function () {
        this.config.columns.forEach(function (col) {
            if (col.type) {
                return col;
            }
            if (col.format) {
                col.type = "number";
                return col;
            }
            if (!col.type) {
                col.type = "string";
            }
        });
    };
    Grid.prototype._destroyContent = function () {
        for (var contentName in this.content) {
            if (contentName === "comboFilter") {
                this.content[contentName].destroy();
            }
        }
    };
    Grid.prototype._render = function () {
        this.paint();
    };
    Grid.prototype._initHotKey = function (secondInit) {
        if (secondInit === void 0) { secondInit = false; }
        var handlers = (0, keys_1.getKeysHandlers)(this);
        for (var key in handlers) {
            if (!this.keyManager.exist(key))
                this.keyManager.addHotKey(key, handlers[key]);
        }
        if (!secondInit) {
            for (var key in this.config.hotkeys) {
                this.keyManager.addHotKey(key, this.config.hotkeys[key]);
            }
        }
    };
    Grid.prototype._normalizeConfig = function (config) {
        Object.keys(config).forEach(function (key) {
            if (key.startsWith("$"))
                delete config[key];
        });
        return config;
    };
    Grid.prototype._normalizeSpans = function () {
        var _this = this;
        var _a;
        this.config.spans = (_a = this.config.spans) === null || _a === void 0 ? void 0 : _a.map(function (span) { return (0, Cells_1.normalizeSpan)(span, _this.config); });
    };
    Grid.prototype._autoScroll = function (mode) {
        var _a, _b, _c;
        var elem = ((_a = this.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable)
            ? (_b = this.getRootNode()) === null || _b === void 0 ? void 0 : _b.querySelector(".scroll-view")
            : (_c = this.getRootNode()) === null || _c === void 0 ? void 0 : _c.querySelector(".dhx_grid-body");
        if (!elem)
            return;
        var timer = null;
        var _d = elem.getBoundingClientRect(), elemTop = _d.top, elemBottom = _d.bottom, elemLeft = _d.left, elemRight = _d.right, elemHeight = _d.height, elemWidth = _d.width;
        var STEP = 40;
        var DELAY = 100;
        var FIELD_WIDTH = 30;
        var scroll = function (direction) {
            if (direction === "up" || direction === "down") {
                elem.scrollBy(0, direction === "up" ? -STEP : STEP);
            }
            else {
                elem.scrollBy(direction === "left" ? -STEP : STEP, 0);
            }
            timer = setTimeout(function () {
                scroll(direction);
            }, DELAY);
        };
        var handler = function (e) {
            var xPos = e.clientX;
            var yPos = e.clientY;
            switch (mode) {
                case "horizontal":
                    if (xPos > elemRight - FIELD_WIDTH &&
                        xPos < elemRight &&
                        yPos > elemTop &&
                        yPos < elemBottom) {
                        timer || scroll("right");
                    }
                    else if (xPos > elemLeft &&
                        xPos < elemLeft + FIELD_WIDTH &&
                        yPos > elemTop &&
                        yPos < elemBottom) {
                        timer || scroll("left");
                    }
                    else if (timer) {
                        clearTimeout(timer);
                        timer = null;
                    }
                    break;
                case "vertical":
                    if (yPos > elemBottom - FIELD_WIDTH &&
                        yPos < elemBottom &&
                        xPos > elemLeft &&
                        xPos < elemRight) {
                        timer || scroll("down");
                    }
                    else if (yPos > elemTop &&
                        yPos < elemTop + FIELD_WIDTH &&
                        xPos > elemLeft &&
                        xPos < elemRight) {
                        timer || scroll("up");
                    }
                    else if (timer) {
                        clearTimeout(timer);
                        timer = null;
                    }
                    break;
            }
        };
        if (elemWidth < elem.scrollWidth || elemHeight < elem.scrollHeight) {
            document.addEventListener("pointermove", handler);
            document.addEventListener("pointerup", function () {
                document.removeEventListener("pointermove", handler);
                if (timer)
                    clearTimeout(timer);
            }, { once: true });
        }
    };
    return Grid;
}(view_1.View));
exports.Grid = Grid;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.blockScreen = void 0;
function blockKeys(e) {
    var active = document.activeElement;
    if (active.classList.contains("dhx_alert__apply-button") && e.key === "Enter") {
        return;
    }
    if (!active.classList.contains("dhx_alert__confirm-reject") &&
        !active.classList.contains("dhx_alert__confirm-aply")) {
        e.preventDefault();
    }
}
function blockScreen(css) {
    var blocker = document.createElement("div");
    blocker.className = "dhx_alert__overlay " + (css || "");
    document.body.appendChild(blocker);
    document.addEventListener("keydown", blockKeys);
    return function () {
        document.body.removeChild(blocker);
        document.removeEventListener("keydown", blockKeys);
    };
}
exports.blockScreen = blockScreen;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.disableTooltip = exports.enableTooltip = exports.tooltip = exports.getZIndex = exports.findPosition = void 0;
var html_1 = __webpack_require__(3);
var types_1 = __webpack_require__(42);
var DEFAULT_SHOW_DELAY = 750;
var DEFAULT_HIDE_DELAY = 200;
function findPosition(targetRect, position, width, height, margin, recursion) {
    if (margin === void 0) { margin = 8; }
    if (recursion === void 0) { recursion = 0; }
    var pos;
    var left;
    var top;
    if (recursion > 1) {
        position = types_1.Position.center;
    }
    switch (position) {
        case types_1.Position.center:
            left = targetRect.left + window.pageXOffset + (targetRect.width - width) / 2;
            if (left + margin < window.pageXOffset) {
                left = targetRect.left + window.pageXOffset;
            }
            top = targetRect.top + window.pageYOffset + (targetRect.height - height) / 2;
            pos = types_1.RealPosition.center;
            return { left: left, top: top, pos: pos };
        case types_1.Position.right:
            pos = types_1.RealPosition.right;
            left = targetRect.right + window.pageXOffset + margin;
            if (left + width > window.innerWidth + window.pageXOffset) {
                // // set left
                return findPosition(targetRect, types_1.Position.left, width, height, margin, ++recursion);
            }
            top = window.pageYOffset + targetRect.top + (targetRect.height - height) / 2;
            return { left: left, top: top, pos: pos };
        case types_1.Position.left:
            pos = types_1.RealPosition.left;
            left = window.pageXOffset + targetRect.left - width - margin;
            if (left < 0) {
                // // set right
                return findPosition(targetRect, types_1.Position.right, width, height, margin, ++recursion);
            }
            top = window.pageYOffset + targetRect.top + (targetRect.height - height) / 2;
            return { left: left, top: top, pos: pos };
        case types_1.Position.top:
            pos = types_1.RealPosition.top;
            left = window.pageXOffset + targetRect.left + (targetRect.width - width) / 2;
            if (left + width > window.innerWidth + window.pageXOffset) {
                left = window.innerWidth + window.pageXOffset - width;
            }
            else if (left < 0) {
                left = 0;
            }
            top = window.pageYOffset + targetRect.top - height - margin;
            if (top - height < 0) {
                // // set bottom
                return findPosition(targetRect, types_1.Position.bottom, width, height, margin, ++recursion);
            }
            return { left: left, top: top, pos: pos };
        case types_1.Position.bottom:
        default:
            left = window.pageXOffset + targetRect.left + (targetRect.width - width) / 2;
            if (left + width > window.innerWidth + window.pageXOffset) {
                left = window.innerWidth + window.pageXOffset - width;
            }
            else if (left < 0) {
                left = 0;
            }
            pos = types_1.RealPosition.bottom;
            top = window.pageYOffset + targetRect.bottom + margin;
            if (top + height > window.innerHeight + window.pageYOffset) {
                // // set top
                return findPosition(targetRect, types_1.Position.top, width, height, margin, ++recursion);
            }
            return { left: left, top: top, pos: pos };
    }
}
exports.findPosition = findPosition;
// tooltip init
var tooltipBox = document.createElement("div");
var tooltipText = document.createElement("span");
tooltipText.className = "dhx_tooltip__text";
tooltipBox.appendChild(tooltipText);
tooltipBox.setAttribute("role", "tooltip");
tooltipBox.style.position = "absolute";
var lastNode = null;
var isActive = false;
var hideTimeout = null;
var showTimeout = null;
var activeListenersDestructor;
function getZIndex(node) {
    if (node &&
        ((node.classList.contains("dhx_popup--window") &&
            node.classList.contains("dhx_popup--window_active")) ||
            node.classList.contains("dhx_popup--window_modal") ||
            node.classList.contains("dhx_popup"))) {
        return 10000000;
    }
    if (node === null || node === void 0 ? void 0 : node.classList.contains("dhx_popup--window")) {
        return 9999999;
    }
    if (node && node.offsetParent) {
        return getZIndex(node.offsetParent);
    }
    return null;
}
exports.getZIndex = getZIndex;
function showTooltip(node, text, position, css, force, margin, htmlEnable) {
    if (force === void 0) { force = false; }
    if (margin === void 0) { margin = 8; }
    var rects = node.getBoundingClientRect();
    if (htmlEnable) {
        tooltipText.innerHTML = text;
    }
    else {
        tooltipText.textContent = text;
    }
    document.body.appendChild(tooltipBox);
    tooltipBox.className = "dhx_widget dhx_tooltip" + (force ? " dhx_tooltip--forced" : "");
    var _a = tooltipBox.getBoundingClientRect(), width = _a.width, height = _a.height;
    var _b = findPosition(rects, position, width, height, margin), left = _b.left, top = _b.top, pos = _b.pos;
    var zIndex = getZIndex(node);
    if (zIndex) {
        tooltipBox.style.zIndex = zIndex.toString();
    }
    switch (pos) {
        case types_1.RealPosition.bottom:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.top:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.left:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.right:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.center:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
    }
    tooltipBox.className += " dhx_tooltip--".concat(pos, " ").concat(css || "");
    isActive = true;
    if (!force) {
        setTimeout(function () {
            tooltipBox.className += " dhx_tooltip--animate";
        });
    }
}
function hideTooltip(delay) {
    if (lastNode) {
        hideTimeout = setTimeout(function () {
            document.body.removeChild(tooltipBox);
            isActive = false;
            hideTimeout = null;
        }, delay || DEFAULT_HIDE_DELAY);
    }
}
function addListeners(node, text, config) {
    var force = config.force, showDelay = config.showDelay, hideDelay = config.hideDelay, position = config.position, css = config.css, htmlEnable = config.htmlEnable, margin = config.margin;
    if (!force) {
        showTimeout = setTimeout(function () {
            showTooltip(node, text, position || types_1.Position.bottom, css, false, margin, htmlEnable);
        }, showDelay || DEFAULT_SHOW_DELAY);
    }
    var hide = function () {
        if (isActive) {
            hideTooltip(hideDelay);
        }
        clearTimeout(showTimeout);
        node.removeEventListener("mouseleave", hide);
        node.removeEventListener("blur", hide);
        document.removeEventListener("mousedown", hide);
        lastNode = null;
        activeListenersDestructor = null;
    };
    if (force) {
        showTooltip(node, text, position, css, force, margin, htmlEnable);
    }
    node.addEventListener("mouseleave", hide);
    node.addEventListener("blur", hide);
    document.addEventListener("mousedown", hide);
    activeListenersDestructor = hide;
}
// default
function tooltip(text, config) {
    var node = (0, html_1.toNode)(config.node);
    if (node === lastNode) {
        return;
    }
    if (activeListenersDestructor) {
        activeListenersDestructor();
        activeListenersDestructor = null;
    }
    lastNode = node;
    if (hideTimeout) {
        clearTimeout(hideTimeout);
        hideTimeout = null;
        addListeners(node, text, __assign(__assign({}, config), { force: true }));
    }
    else {
        addListeners(node, text, config);
    }
}
exports.tooltip = tooltip;
function _mousemove(e) {
    var node = (0, html_1.locateNode)(e, "dhx_tooltip_text");
    if (!node) {
        return;
    }
    tooltip(node.getAttribute("dhx_tooltip_text"), {
        position: node.getAttribute("dhx_tooltip_position") || types_1.Position.bottom,
        node: node,
    });
}
function enableTooltip() {
    document.addEventListener("mousemove", _mousemove);
}
exports.enableTooltip = enableTooltip;
function disableTooltip() {
    document.removeEventListener("mousemove", _mousemove);
}
exports.disableTooltip = disableTooltip;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cell = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var view_1 = __webpack_require__(8);
var types_1 = __webpack_require__(46);
var helpers_1 = __webpack_require__(138);
var events_1 = __webpack_require__(2);
var Layout_1 = __webpack_require__(45);
var Cell = /** @class */ (function (_super) {
    __extends(Cell, _super);
    function Cell(parent, config) {
        var _this = _super.call(this, parent, config) || this;
        _this._disabled = [];
        var p = parent;
        if (p && p.isVisible) {
            _this._parent = p;
        }
        if (_this._parent && _this._parent.events) {
            _this.events = _this._parent.events;
        }
        else {
            _this.events = new events_1.EventSystem(_this);
        }
        _this.config.full =
            _this.config.full === undefined
                ? Boolean(_this.config.header ||
                    _this.config.collapsable ||
                    _this.config.headerHeight ||
                    _this.config.headerIcon ||
                    _this.config.headerImage)
                : _this.config.full;
        _this._afterWindowResized = _this._resizedWindow.bind(_this);
        _this._initHandlers();
        _this.id = _this.config.id || (0, core_1.uid)();
        _this._progress = !!_this.config.progressDefault;
        _this._stopProgressDefault = false;
        if (_this._isXDirection() && !config.width)
            config.$autoWidth = true;
        if (!_this._isXDirection() && !config.height)
            config.$autoHeight = true;
        return _this;
    }
    Cell.prototype.paint = function () {
        var _a;
        if (this.isVisible()) {
            var view = this.getRootView();
            if (view) {
                view.redraw();
            }
            else {
                (_a = this._parent) === null || _a === void 0 ? void 0 : _a.paint();
            }
        }
    };
    Cell.prototype.isVisible = function () {
        var _a;
        // top level node
        if (!this._parent) {
            if (this._container && this._container.tagName) {
                return true;
            }
            return Boolean(this.getRootNode());
        }
        // check active view in case of multiview
        var active = (_a = this._parent.config) === null || _a === void 0 ? void 0 : _a.activeView;
        if (active && active !== this.id) {
            return false;
        }
        // check that all parents of the cell are visible as well
        return !this.config.hidden && (!this._parent || this._parent.isVisible());
    };
    Cell.prototype.hide = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeHide, [this.id])) {
            return;
        }
        this.config.hidden = true;
        this._resetCellsSize();
        if (this._parent && this._parent.paint) {
            this._parent.paint();
        }
        this.events.fire(types_1.LayoutEvents.afterHide, [this.id]);
    };
    Cell.prototype.show = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeShow, [this.id])) {
            return;
        }
        if (this._parent && this._parent.config && this._parent.config.activeView !== undefined) {
            this._parent.config.activeView = this.id;
        }
        else {
            this.config.hidden = false;
        }
        if (this._parent && !this._parent.isVisible()) {
            this._parent.show();
        }
        this.paint();
        this.events.fire(types_1.LayoutEvents.afterShow, [this.id]);
    };
    Cell.prototype.expand = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeExpand, [this.id])) {
            return;
        }
        this.config.collapsed = false;
        this._checkNextSize() || this._checkNextSize(this._getAnyFlexCell());
        this.events.fire(types_1.LayoutEvents.afterExpand, [this.id]);
        this.paint();
    };
    Cell.prototype.collapse = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeCollapse, [this.id])) {
            return;
        }
        this.config.collapsed = true;
        this._checkNextSize() || this._checkNextSize(this._getAnyFlexCell());
        this.events.fire(types_1.LayoutEvents.afterCollapse, [this.id]);
        this.paint();
    };
    Cell.prototype.toggle = function () {
        if (this.config.collapsed) {
            this.expand();
        }
        else {
            this.collapse();
        }
    };
    Cell.prototype._checkNextSize = function (cell) {
        var nextCell = cell !== null && cell !== void 0 ? cell : this._getNextCell();
        if (!nextCell)
            return false;
        if (this._isXDirection() && nextCell.config.$autoWidth && nextCell.config.width) {
            nextCell.config.width = undefined;
            return true;
        }
        if (!this._isXDirection() && nextCell.config.$autoHeight && nextCell.config.height) {
            nextCell.config.height = undefined;
            return true;
        }
        return !cell ? nextCell._checkNextSize() : false;
    };
    Cell.prototype.getParent = function () {
        return this._parent;
    };
    Cell.prototype.destructor = function () {
        var _a;
        this.events && this.events.clear();
        window.removeEventListener("resize", this._afterWindowResized);
        if (typeof ((_a = this.getWidget()) === null || _a === void 0 ? void 0 : _a.destructor) === "function") {
            this.getWidget().destructor();
        }
        this.config = this.events = this.id = this._parent = this._handlers = this._uid = this._disabled = this._resizerHandlers = null;
        this.unmount();
    };
    Cell.prototype.getWidget = function () {
        return this._ui;
    };
    Cell.prototype.getCellView = function () {
        return this._parent && this._parent.getRefs(this._uid);
    };
    Cell.prototype.attach = function (component, config) {
        this.config.html = null;
        if (typeof component === "object") {
            this._ui = component;
        }
        else if (typeof component === "string") {
            this._ui = new window.dhx[component](null, config);
        }
        else if (typeof component === "function") {
            if (component.prototype instanceof view_1.View) {
                this._ui = new component(null, config);
            }
            else {
                this._ui = {
                    getRootView: function () {
                        return component(config);
                    },
                };
            }
        }
        this.paint();
        return this._ui;
    };
    Cell.prototype.attachHTML = function (html) {
        this.config.html = html;
        this.paint();
    };
    Cell.prototype.detach = function () {
        this._stopProgressDefault = false;
        this._ui = this.config.html = null;
        this.paint();
    };
    Cell.prototype.progressShow = function () {
        if (this.config.progressDefault) {
            this._stopProgressDefault = false;
        }
        this._progress = true;
        this.paint();
    };
    Cell.prototype.progressHide = function () {
        if (this.config.progressDefault) {
            this._stopProgressDefault = true;
        }
        this._progress = false;
        this.paint();
    };
    Cell.prototype.isVisibleProgress = function () {
        return this._progress;
    };
    Cell.prototype.toVDOM = function (nodes) {
        var _a;
        var _b;
        if (this.config === null) {
            this.config = {};
        }
        if (this.config.hidden) {
            return;
        }
        var isFieldset = this.config.$fieldset;
        var style = this._calculateStyle();
        var stylePadding = (0, core_1.isDefined)(this.config.padding)
            ? !isNaN(Number(this.config.padding))
                ? { padding: "".concat(this.config.padding, "px") }
                : { padding: this.config.padding }
            : "";
        var fullStyle = this.config.full || this.config.html ? style : __assign(__assign({}, style), stylePadding);
        var progressBar = this._checkProgress() ? this._getProgressBar() : null;
        var kids;
        if (!this.config.html) {
            if (this._ui) {
                var view = this._ui.getRootView();
                if (view.render) {
                    view = (0, dom_1.inject)(view);
                }
                kids = [view];
            }
            else {
                kids = nodes || null;
            }
        }
        var resizer = this.config.resizable && !this._isLastCell() && this._getNextCell() && !this.config.collapsed
            ? (0, dom_1.el)(".dhx_layout-resizer." +
                (this._isXDirection() ? "dhx_layout-resizer--x" : "dhx_layout-resizer--y"), __assign(__assign({}, this._resizerHandlers), { _ref: "resizer_" + this._uid, tabindex: 0 }), [
                (0, dom_1.el)("span.dhx_layout-resizer__icon", {
                    class: "dxi " +
                        (this._isXDirection() ? "dxi-dots-vertical" : "dxi-dots-horizontal"),
                }),
            ])
            : null;
        var handlers = {};
        if (this.config.on) {
            for (var key in this.config.on) {
                handlers["on" + key] = this.config.on[key];
            }
        }
        var typeClass = "";
        var isParent = this.config.cols || this.config.rows;
        if (this.config.type && isParent) {
            switch (this.config.type) {
                case "line":
                    typeClass = " dhx_layout-line";
                    break;
                case "wide":
                    typeClass = " dhx_layout-wide";
                    break;
                case "space":
                    typeClass = " dhx_layout-space";
                    break;
                default:
                    break;
            }
        }
        var cellContent = isFieldset
            ? (0, dom_1.el)("fieldset.dhx_form-fieldset", {
                class: (this.config.$disabled && " dhx_form-fieldset--disabled") || "",
                style: stylePadding,
                disabled: this.config.$disabled,
            }, [
                (0, dom_1.el)("legend.dhx_form-fieldset-legend", {
                    class: "dhx_form-fieldset-legend--".concat(this.config.labelAlignment || "left"),
                }, this.config.label),
                (0, dom_1.el)(".dhx_layout-cell-content", {
                    class: this._getCss(false),
                }, [kids]),
            ])
            : this.config.full
                ? [
                    (0, dom_1.el)("div", {
                        tabindex: this.config.collapsable ? "0" : "-1",
                        role: this.config.collapsable ? "button" : null,
                        "aria-label": this.config.collapsable
                            ? "click to ".concat(this.config.collapsed ? "expand" : "collapse")
                            : null,
                        class: "dhx_layout-cell-header" +
                            (this._isXDirection()
                                ? " dhx_layout-cell-header--col"
                                : " dhx_layout-cell-header--row") +
                            (this.config.collapsable ? " dhx_layout-cell-header--collapseble" : "") +
                            (this.config.collapsed ? " dhx_layout-cell-header--collapsed" : "") +
                            (((this.getParent() || {}).config || {}).isAccordion
                                ? " dhx_layout-cell-header--accordion"
                                : ""),
                        style: {
                            height: this.config.headerHeight,
                        },
                        onclick: this._handlers.toggle,
                        onkeydown: this._handlers.enterCollapse,
                    }, [
                        this.config.headerIcon &&
                            (0, dom_1.el)("span.dhx_layout-cell-header__icon", {
                                class: this.config.headerIcon,
                            }),
                        this.config.headerImage &&
                            (0, dom_1.el)(".dhx_layout-cell-header__image-wrapper", [
                                (0, dom_1.el)("img", {
                                    src: this.config.headerImage,
                                    class: "dhx_layout-cell-header__image",
                                }),
                            ]),
                        this.config.header && (0, dom_1.el)("h3.dhx_layout-cell-header__title", this.config.header),
                        this.config.collapsable
                            ? (0, dom_1.el)("div.dhx_layout-cell-header__collapse-icon", {
                                class: this._getCollapseIcon(),
                            })
                            : (0, dom_1.el)("div.dhx_layout-cell-header__collapse-icon", {
                                class: "dxi dxi-empty",
                            }),
                    ]),
                    !this.config.collapsed
                        ? (0, dom_1.el)("div", {
                            style: __assign(__assign({}, stylePadding), { height: "calc(100% - ".concat(this.config.headerHeight || 37, "px)") }),
                            class: this._getCss(true) +
                                " dhx_layout-cell-content" +
                                (this.config.type ? typeClass : ""),
                        }, this.config.html
                            ? [
                                (0, dom_1.el)("div", {
                                    ".innerHTML": this.config.html,
                                    class: "dhx_layout-cell dhx_layout-cell-inner_html",
                                }),
                            ]
                            : kids)
                        : null,
                ]
                : this.config.html &&
                    !(this.config.rows &&
                        this.config.cols &&
                        this.config.views)
                    ? [
                        !this.config.collapsed
                            ? (0, dom_1.el)(".dhx_layout-cell-content", { style: stylePadding }, [
                                (0, dom_1.el)(".dhx_layout-cell-inner_html", {
                                    ".innerHTML": this.config.html,
                                }),
                            ])
                            : null,
                    ]
                    : kids;
        var cell = (0, dom_1.el)("div", __assign(__assign((_a = { _key: this._uid, _ref: this._uid }, _a["aria-label"] = this.config.id ? "tab-content-" + this.config.id : null, _a["data-cell-id"] = (_b = this.config.id) !== null && _b !== void 0 ? _b : null, _a), handlers), { class: this._getCss(false) +
                (this.config.css ? " " + this.config.css : "") +
                (this.config.collapsed ? " dhx_layout-cell--collapsed" : "") +
                (this.config.resizable ? " dhx_layout-cell--resizable" : "") +
                (this.config.type && !this.config.full ? typeClass : ""), style: isFieldset ? style : fullStyle }), cellContent || progressBar ? [cellContent, progressBar] : null);
        return resizer ? [cell, resizer] : cell;
    };
    Cell.prototype._getProgressBar = function () {
        return (0, dom_1.el)("span", {
            class: "dhx_progress-bar",
        }, [
            (0, dom_1.sv)("svg", {
                viewBox: "25 25 50 50",
                class: "dhx_spinner",
            }, [
                (0, dom_1.sv)("circle", {
                    cx: "50",
                    cy: "50",
                    r: "20",
                    class: "path",
                }),
            ]),
        ]);
    };
    Cell.prototype._getCss = function (_content) {
        return "dhx_layout-cell";
    };
    Cell.prototype._initHandlers = function () {
        var _this = this;
        window.addEventListener("resize", this._afterWindowResized);
        this._handlers = {
            enterCollapse: function (e) {
                if (e.keyCode === 13) {
                    _this._handlers.toggle();
                }
            },
            collapse: function () {
                if (!_this.config.collapsable) {
                    return;
                }
                _this.collapse();
            },
            expand: function () {
                if (!_this.config.collapsable) {
                    return;
                }
                _this.expand();
            },
            toggle: function () {
                if (!_this.config.collapsable) {
                    return;
                }
                _this.toggle();
            },
        };
        var blockOpts = {
            left: null,
            top: null,
            isActive: false,
            range: null,
            xLayout: null,
            nextCell: null,
            size: null,
            resizerLength: null,
            margin: null,
            collapsedSize: null,
        };
        var resizeMove = function (event, startCoords) {
            if (startCoords === void 0) { startCoords = { x: 0, y: 0 }; }
            if (!blockOpts.isActive) {
                return;
            }
            var xLayout = blockOpts.xLayout;
            var clientX = event.targetTouches
                ? event.targetTouches[0].clientX
                : event.clientX + startCoords.x;
            var clientY = event.targetTouches
                ? event.targetTouches[0].clientY
                : event.clientY + startCoords.y;
            var newValue = xLayout
                ? clientX - blockOpts.range.min + window.pageXOffset
                : clientY - blockOpts.range.min + window.pageYOffset;
            var prop = xLayout ? "width" : "height";
            if (newValue < 0) {
                newValue = blockOpts.resizerLength / 2;
            }
            else if (newValue > blockOpts.size) {
                newValue = blockOpts.size - blockOpts.resizerLength;
            }
            var getValue = function (key) { var _a; return parseInt((_a = _this.config[key]) === null || _a === void 0 ? void 0 : _a.toString()); };
            var maxSize = getValue(xLayout ? "maxWidth" : "maxHeight");
            var minSize = getValue(xLayout ? "minWidth" : "minHeight");
            if ((!maxSize || newValue < maxSize) && (!minSize || newValue > minSize)) {
                _this.config[prop] = newValue - blockOpts.resizerLength / 2 + "px";
                blockOpts.nextCell.config[prop] =
                    blockOpts.size - newValue - blockOpts.resizerLength / 2 + "px";
                if (blockOpts.nextCell._getAnyFlexCell())
                    blockOpts.nextCell._getAnyFlexCell().config[prop] = undefined;
                _this.paint();
                _this.events.fire(types_1.LayoutEvents.resize, [_this.id]);
            }
        };
        var iframesInfo = {};
        var resizeEnd = function (event) {
            blockOpts.isActive = false;
            document.body.classList.remove("dhx_no-select--resize");
            if (!event.targetTouches) {
                document.removeEventListener("mouseup", resizeEnd);
                document.removeEventListener("mousemove", resizeMove);
                for (var index in iframesInfo) {
                    iframesInfo[index].node.contentWindow.document.removeEventListener("mouseup", resizeEnd);
                    iframesInfo[index].node.contentWindow.document.removeEventListener("mousemove", iframesInfo[index].listener);
                }
            }
            else {
                document.removeEventListener("touchend", resizeEnd);
                document.removeEventListener("touchmove", resizeMove);
                for (var index in iframesInfo) {
                    iframesInfo[index].node.contentWindow.document.removeEventListener("touchend", resizeEnd);
                    iframesInfo[index].node.contentWindow.document.removeEventListener("touchmove", iframesInfo[index].listener);
                }
            }
            _this.events.fire(types_1.LayoutEvents.afterResizeEnd, [_this.id]);
        };
        var resizeStart = function (event) {
            event.targetTouches && event.preventDefault();
            if (event.which === 3) {
                return;
            }
            if (blockOpts.isActive) {
                resizeEnd(event);
            }
            if (!_this.events.fire(types_1.LayoutEvents.beforeResizeStart, [_this.id])) {
                return;
            }
            document.body.classList.add("dhx_no-select--resize");
            var block = _this.getCellView();
            var nextCell = _this._getNextCell();
            var nextBlock = nextCell.getCellView();
            var resizerBlock = _this._getResizerView();
            var blockOffsets = block.el.getBoundingClientRect();
            var resizerOffsets = resizerBlock.el.getBoundingClientRect();
            var nextBlockOffsets = nextBlock.el.getBoundingClientRect();
            blockOpts.xLayout = _this._isXDirection();
            blockOpts.left = blockOffsets.left + window.pageXOffset;
            blockOpts.top = blockOffsets.top + window.pageYOffset;
            blockOpts.collapsedSize = _this._getCollapsedSize(_this, nextCell);
            blockOpts.margin = (0, helpers_1.getMarginSize)(_this.getParent().config);
            blockOpts.range = (0, helpers_1.getBlockRange)(blockOffsets, nextBlockOffsets, blockOpts.xLayout);
            blockOpts.size =
                blockOpts.range.max - blockOpts.range.min - blockOpts.margin - blockOpts.collapsedSize;
            blockOpts.isActive = true;
            blockOpts.nextCell = nextCell;
            blockOpts.resizerLength = blockOpts.xLayout ? resizerOffsets.width : resizerOffsets.height;
        };
        this._resizerHandlers = {
            onmousedown: function (e) {
                resizeStart(e);
                document.addEventListener("mouseup", resizeEnd);
                document.addEventListener("mousemove", resizeMove);
                var iframes = document.querySelectorAll("iframe");
                if (iframes.length) {
                    iframes.forEach(function (iframe, index) {
                        var iframeCoords = {
                            x: iframe.getBoundingClientRect().x,
                            y: iframe.getBoundingClientRect().y,
                        };
                        iframesInfo[index] = {
                            node: iframe,
                            listener: function (event) { return resizeMove(event, iframeCoords); },
                        };
                    });
                    for (var index in iframesInfo) {
                        iframesInfo[index].node.contentWindow.document.addEventListener("mouseup", resizeEnd);
                        iframesInfo[index].node.contentWindow.document.addEventListener("mousemove", iframesInfo[index].listener);
                    }
                }
            },
            ontouchstart: function (e) {
                resizeStart(e);
                document.addEventListener("touchend", resizeEnd);
                document.addEventListener("touchmove", resizeMove);
                var iframes = document.querySelectorAll("iframe");
                if (iframes.length) {
                    iframes.forEach(function (iframe, index) {
                        var iframeCoords = {
                            x: iframe.getBoundingClientRect().x,
                            y: iframe.getBoundingClientRect().y,
                        };
                        iframesInfo[index] = {
                            node: iframe,
                            listener: function (event) { return resizeMove(event, iframeCoords); },
                        };
                    });
                    for (var index in iframesInfo) {
                        iframesInfo[index].node.contentWindow.document.addEventListener("touchend", resizeEnd);
                        iframesInfo[index].node.contentWindow.document.addEventListener("touchmove", iframesInfo[index].listener);
                    }
                }
            },
            ondragstart: function (e) { return e.preventDefault(); },
        };
    };
    Cell.prototype._getCollapsedSize = function (cell, nextCell) {
        var collapsedSize = 0;
        var parent = this._parent;
        var index = parent._cells.indexOf(cell);
        var nextIndex = parent._cells.indexOf(nextCell);
        if (nextIndex - index === 1)
            return collapsedSize;
        for (var i = index + 1; i < nextIndex; i++) {
            if (parent._cells[i].config.collapsed) {
                if (!this._isXDirection()) {
                    collapsedSize += Number(parent._cells[i].config.headerHeight) || 37;
                }
                else {
                    collapsedSize += 45;
                }
            }
        }
        return collapsedSize;
    };
    Cell.prototype._getCollapseIcon = function () {
        if (this._isXDirection() && this.config.collapsed) {
            return "dxi dxi-chevron-right";
        }
        if (this._isXDirection() && !this.config.collapsed) {
            return "dxi dxi-chevron-left";
        }
        if (!this._isXDirection() && this.config.collapsed) {
            return "dxi dxi-chevron-up";
        }
        if (!this._isXDirection() && !this.config.collapsed) {
            return "dxi dxi-chevron-down";
        }
    };
    Cell.prototype._isLastCell = function () {
        var parent = this._parent;
        return parent && parent._cells.indexOf(this) === parent._cells.length - 1;
    };
    Cell.prototype._getNextCell = function () {
        var parent = this._parent;
        var index = parent._cells.indexOf(this);
        var nextCell = !this._isLastCell() && parent._cells[index + 1];
        if (!nextCell)
            return false;
        if (nextCell.config.hidden || nextCell.config.collapsed) {
            return nextCell._getNextCell();
        }
        else
            return nextCell;
    };
    Cell.prototype._getAnyFlexCell = function (selfInclude) {
        var _this = this;
        var _a;
        if (selfInclude === void 0) { selfInclude = false; }
        var parent = this._parent;
        var prop = this._isXDirection() ? "$autoWidth" : "$autoHeight";
        var cells = (_a = parent === null || parent === void 0 ? void 0 : parent._cells) === null || _a === void 0 ? void 0 : _a.filter(function (cell) { return cell.config[prop] === true && (selfInclude ? true : cell.id !== _this.id); });
        return (cells === null || cells === void 0 ? void 0 : cells.length) ? cells[cells.length - 1] : false;
    };
    Cell.prototype._getResizerView = function () {
        return this._parent.getRefs("resizer_" + this._uid);
    };
    Cell.prototype._isXDirection = function () {
        return this._parent && this._parent._xLayout;
    };
    Cell.prototype._checkProgress = function () {
        if (this instanceof Layout_1.Layout) {
            return this.isVisibleProgress();
        }
        this._calculateProgressState();
        return ((this._progress || this._checkAutoProgress()) &&
            !this.config.collapsed &&
            !this.config.hidden &&
            !this._parent.isVisibleProgress());
    };
    Cell.prototype._checkAutoProgress = function () {
        if (this._stopProgressDefault)
            return false;
        var _a = this.config, html = _a.html, progressDefault = _a.progressDefault;
        return progressDefault && !this._ui && !html;
    };
    Cell.prototype._calculateProgressState = function () {
        if (this._stopProgressDefault)
            return;
        var _a = this.config, html = _a.html, progressDefault = _a.progressDefault;
        if (progressDefault && !this._ui && !html) {
            this._progress = true;
        }
        if (progressDefault && (this._ui || html)) {
            this._progress = false;
        }
    };
    Cell.prototype._calculateStyle = function () {
        var config = this.config;
        if (!config) {
            return;
        }
        var style = {};
        var autoWidth = false;
        var autoHeight = false;
        if (!isNaN(Number(config.width)))
            config.width = config.width + "px";
        if (!isNaN(Number(config.height)))
            config.height = config.height + "px";
        if (!isNaN(Number(config.minWidth)))
            config.minWidth = config.minWidth + "px";
        if (!isNaN(Number(config.minHeight)))
            config.minHeight = config.minHeight + "px";
        if (!isNaN(Number(config.maxWidth)))
            config.maxWidth = config.maxWidth + "px";
        if (!isNaN(Number(config.maxHeight)))
            config.maxHeight = config.maxHeight + "px";
        if (config.width === "content")
            autoWidth = true;
        if (config.height === "content")
            autoHeight = true;
        // if (this._isXDirection() && !config.width) config.$autoWidth = true;
        // if (!this._isXDirection() && !config.height) config.$autoHeight = true;
        var _a = config, width = _a.width, height = _a.height, cols = _a.cols, rows = _a.rows, minWidth = _a.minWidth, minHeight = _a.minHeight, maxWidth = _a.maxWidth, maxHeight = _a.maxHeight, gravity = _a.gravity, collapsed = _a.collapsed, $fixed = _a.$fixed;
        var gravityNumber = Math.sign(gravity) === -1 ? 0 : gravity;
        if (typeof gravity === "boolean") {
            gravityNumber = gravity ? 1 : 0;
        }
        var fixed = typeof gravity === "boolean" ? !gravity : Math.sign(gravity) === -1;
        if (this._isXDirection()) {
            if ($fixed || width || (gravity === undefined && (minWidth || maxWidth))) {
                fixed = true;
            }
        }
        else {
            if ($fixed || height || (gravity === undefined && (minHeight || maxHeight))) {
                fixed = true;
            }
        }
        var isFullSizeCell = this._checkFullSizeCell();
        var grow = fixed && !isFullSizeCell ? 0 : isFullSizeCell ? 1 : gravityNumber || 1;
        var fillSpace = this._isXDirection() ? "x" : "y";
        if (minWidth !== undefined && !collapsed)
            style.minWidth = minWidth;
        if (minHeight !== undefined && !collapsed)
            style.minHeight = minHeight;
        if (maxWidth !== undefined)
            style.maxWidth = maxWidth;
        if (maxHeight !== undefined)
            style.maxHeight = maxHeight;
        if (this._parent === undefined && !fillSpace !== undefined) {
            fillSpace = true;
        }
        if (!isFullSizeCell && width !== undefined && width !== "content") {
            style.width = width;
        }
        else {
            if (fillSpace === true) {
                style.width = "100%";
            }
            else if (fillSpace === "x") {
                if (autoWidth) {
                    style.flex = "0 0 auto";
                }
                else {
                    var isAuto = this._isXDirection() ? "1px" : "auto";
                    style.flex = "".concat(grow, " ").concat(cols || rows ? "0 ".concat(isAuto) : "1 auto");
                }
            }
        }
        if (!isFullSizeCell && height !== undefined && height !== "content") {
            style.height = height;
        }
        else {
            if (fillSpace === true) {
                style.height = "100%";
            }
            else if (fillSpace === "y") {
                if (autoHeight) {
                    style.flex = "0 0 auto";
                }
                else {
                    var isAuto = !this._isXDirection() ? "1px" : "auto";
                    style.flex = "".concat(grow, " ").concat(cols || rows ? "0 ".concat(isAuto) : "1 auto");
                }
            }
        }
        if (fillSpace === true && config.width === undefined && config.height === undefined) {
            style.flex = "".concat(grow, " 1 auto");
        }
        if (collapsed) {
            if (this._isXDirection()) {
                style.width = "auto";
            }
            else {
                style.height = "auto";
            }
            style.flex = "0 0 auto";
        }
        return style;
    };
    Cell.prototype._resizedWindow = function () {
        var _a;
        if (this._isLastFlexCell === undefined) {
            this._isLastFlexCell = ((_a = this._getAnyFlexCell(true)) === null || _a === void 0 ? void 0 : _a.id) === this.id;
        }
        else if (!this._isLastFlexCell) {
            window.removeEventListener("resize", this._afterWindowResized);
        }
        if (this._isLastFlexCell) {
            var prop = this._isXDirection() ? "width" : "height";
            this.config[prop] = undefined;
            this.paint();
        }
    };
    Cell.prototype._resetCellsSize = function () {
        var _this = this;
        var cells = this._parent._cells.filter(function (cell) {
            return cell !== _this && !cell.config.hidden && !cell.config.collapsed;
        });
        var direction = this._isXDirection();
        var autoSize = direction ? "$autoWidth" : "$autoHeight";
        var size = direction ? "width" : "height";
        cells.forEach(function (cell) {
            if (cell.config[autoSize]) {
                cell.config[size] = undefined;
            }
        });
    };
    Cell.prototype._checkFullSizeCell = function () {
        var _this = this;
        if (!this._parent)
            return false;
        var autoSize = this._isXDirection() ? "$autoWidth" : "$autoHeight";
        if (!this.config[autoSize])
            return false;
        var cells = this._parent._cells.filter(function (cell) {
            return cell !== _this && !cell.config.hidden;
        });
        return !!cells.length && cells.every(function (cell) { return cell.config.collapsed; });
    };
    return Cell;
}(view_1.View));
exports.Cell = Cell;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.PopupEvents = void 0;
var PopupEvents;
(function (PopupEvents) {
    PopupEvents["beforeHide"] = "beforeHide";
    PopupEvents["beforeShow"] = "beforeShow";
    PopupEvents["afterHide"] = "afterHide";
    PopupEvents["afterShow"] = "afterShow";
    PopupEvents["click"] = "click";
})(PopupEvents || (exports.PopupEvents = PopupEvents = {}));


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SliderEvents = void 0;
var SliderEvents;
(function (SliderEvents) {
    SliderEvents["beforeChange"] = "beforeChange";
    SliderEvents["change"] = "change";
    SliderEvents["focus"] = "focus";
    SliderEvents["blur"] = "blur";
    SliderEvents["keydown"] = "keydown";
    SliderEvents["mousedown"] = "mousedown";
    SliderEvents["mouseup"] = "mouseup";
})(SliderEvents || (exports.SliderEvents = SliderEvents = {}));


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    hours: "Hours",
    minutes: "Minutes",
    save: "Save",
};
exports.default = locale;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TimepickerEvents = void 0;
var TimepickerEvents;
(function (TimepickerEvents) {
    TimepickerEvents["beforeChange"] = "beforeChange";
    TimepickerEvents["change"] = "change";
    TimepickerEvents["beforeApply"] = "beforeApply";
    TimepickerEvents["afterApply"] = "afterApply";
    TimepickerEvents["beforeClose"] = "beforeClose";
    TimepickerEvents["afterClose"] = "afterClose";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TimepickerEvents["apply"] = "apply";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TimepickerEvents["close"] = "close";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TimepickerEvents["save"] = "save";
})(TimepickerEvents || (exports.TimepickerEvents = TimepickerEvents = {}));


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarEvents = void 0;
var CalendarEvents;
(function (CalendarEvents) {
    CalendarEvents["change"] = "change";
    CalendarEvents["beforeChange"] = "beforechange";
    CalendarEvents["modeChange"] = "modeChange";
    CalendarEvents["monthSelected"] = "monthSelected";
    CalendarEvents["yearSelected"] = "yearSelected";
    CalendarEvents["cancelClick"] = "cancelClick";
    CalendarEvents["dateMouseOver"] = "dateMouseOver";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    CalendarEvents["dateHover"] = "dateHover";
})(CalendarEvents || (exports.CalendarEvents = CalendarEvents = {}));


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Combobox = exports.$template = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var html_1 = __webpack_require__(3);
var keycodes_1 = __webpack_require__(147);
var view_1 = __webpack_require__(8);
var ts_data_1 = __webpack_require__(7);
var ts_layout_1 = __webpack_require__(12);
var ts_list_1 = __webpack_require__(35);
var ts_popup_1 = __webpack_require__(13);
var keyListener_1 = __webpack_require__(151);
var en_1 = __webpack_require__(49);
var types_1 = __webpack_require__(28);
var helper_1 = __webpack_require__(77);
var types_2 = __webpack_require__(78);
function itemsCountTemplate(count, templateFN) {
    if (typeof templateFN === "function") {
        return templateFN(count);
    }
    else {
        return count + " " + en_1.default.selectedItems;
    }
}
var $template = function (item) {
    if (item.icon) {
        return (0, dom_1.el)("div.dhx_combobox-options-wrapper", [
            (0, dom_1.el)("span", { class: "".concat(item.icon, " dhx_combobox-options__icon") }),
            (0, dom_1.el)("span", { class: "dhx_combobox-options__value" }, item.value),
        ]);
    }
    if (item.src) {
        return (0, dom_1.el)("div.dhx_combobox-options-wrapper", [
            (0, dom_1.el)("img", { class: "dhx_combobox-options__image", alt: item.value, src: item.src }),
            (0, dom_1.el)("span", { class: "dhx_combobox-options__value" }, item.value),
        ]);
    }
    return (0, dom_1.el)("span", { class: "dhx_combobox-options__value" }, item.value);
};
exports.$template = $template;
var Combobox = /** @class */ (function (_super) {
    __extends(Combobox, _super);
    function Combobox(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            listHeight: 224,
            itemHeight: 36,
            disabled: false,
            readOnly: false,
            newOptions: false,
            htmlEnable: true,
        }, config)) || this;
        _this.config.itemsCount = _this.config.itemsCount || _this.config.showItemsCount; // TODO: remove suite_7.0
        _this.config.helpMessage = _this.config.helpMessage || _this.config.help; // TODO: remove suite_7.0
        if (_this.config.cellHeight && _this.config.itemHeight === 36) {
            _this.config.itemHeight = _this.config.cellHeight; // TODO: remove suite_7.0
        }
        if (_this.config.labelInline) {
            _this.config.labelPosition = "left"; // TODO: remove suite_7.0
        }
        if (Array.isArray(_this.config.data)) {
            _this.events = new events_1.EventSystem(_this);
            _this.data = new ts_data_1.DataCollection({});
            _this.data.parse(_this.config.data);
        }
        else if (_this.config.data) {
            _this.data = _this.config.data;
            _this.events = new events_1.EventSystem(_this);
            _this.events.context = _this;
        }
        else {
            _this.events = new events_1.EventSystem(_this);
            _this.data = new ts_data_1.DataCollection({});
        }
        _this.popup = new ts_popup_1.Popup();
        _this.popup.events.on(ts_popup_1.PopupEvents.afterShow, function () {
            _this.paint();
        });
        _this.popup.events.on(ts_popup_1.PopupEvents.afterHide, function () {
            if (_this.config.multiselection) {
                _this._state.value = "";
            }
            _this.paint();
        });
        _this.popup.events.on(ts_popup_1.PopupEvents.beforeHide, function (fromOuterClick) {
            fromOuterClick && _this._hideOptions();
        });
        if (_this.config.readonly || _this.config.readOnly) {
            _this.config.readOnly = _this.config.readOnly || _this.config.readonly;
            _this._keyListener = new keyListener_1.KeyListener();
        }
        _this._state = {
            value: "",
            ignoreNext: false,
            canDelete: false,
            unselectActive: false,
            currentState: types_2.ComboState.default,
            creatingState: false,
        };
        _this._initHandlers();
        _this._createLayout();
        if (_this.config.value) {
            _this._setValue(_this.config.value, true);
        }
        _this._initEvents();
        var vnode = (0, dom_1.create)({
            render: function () { return _this._draw(); },
            hooks: {
                didRedraw: function () {
                    if (_this.popup.isVisible()) {
                        _this.focus();
                        _this._configurePopup();
                    }
                },
            },
        });
        // const container = toNode(element);
        _this.mount(element, vnode);
        return _this;
    }
    Combobox.prototype.focus = function () {
        if (this.config.disabled)
            return false;
        var rootView = this.getRootView();
        rootView.refs.input.el.focus();
    };
    Combobox.prototype.blur = function () {
        if (this.config.disabled)
            return false;
        var rootView = this.getRootView();
        rootView.refs.input.el.blur();
        this.popup.hide();
    };
    Combobox.prototype.enable = function () {
        this.config.disabled = false;
        this.paint();
    };
    Combobox.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    Combobox.prototype.isDisabled = function () {
        return this.config.disabled;
    };
    Combobox.prototype.clear = function () {
        this.list.selection.remove();
        this._state.value = "";
        this._filter();
        this.paint();
    };
    Combobox.prototype.getValue = function (asArray) {
        var ids = this.list.selection.getId();
        if (asArray) {
            return (0, core_1.wrapBox)(ids);
        }
        return Array.isArray(ids) ? ids.join(",") : ids;
    };
    Combobox.prototype.setValue = function (ids, silent) {
        return this._setValue(ids, silent);
    };
    Combobox.prototype.addOption = function (value, join) {
        if (join === void 0) { join = true; }
        if (!value)
            return;
        var id;
        if (typeof value === "string") {
            id = this.data.add({ value: value });
        }
        else if (typeof value === "object") {
            id = this.data.add(value);
        }
        var options = this.config.multiselection && join ? __spreadArray(__spreadArray([], this.list.selection.getId(), true), [id], false) : id;
        this.setValue(options);
    };
    Combobox.prototype.destructor = function () {
        this.popup && this.popup.destructor();
        this.events && this.events.clear();
        this.list && this.list.destructor();
        this._helper && this._helper.destructor();
        this._layout && this._layout.destructor();
        this.config = this.events = this.list = this.popup = null;
        this._helper = this._keyListener = this._handlers = this._state = this._uid = this._isPopupConfiqureted = null;
        this.unmount();
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Combobox.prototype.setState = function (state) {
        switch (state) {
            case "success":
                this._state.currentState = types_2.ComboState.success;
                break;
            case "error":
                this._state.currentState = types_2.ComboState.error;
                break;
            default:
                this._state.currentState = types_2.ComboState.default;
                break;
        }
        this.paint();
    };
    Combobox.prototype._setValue = function (ids, silent) {
        var _this = this;
        if (silent === void 0) { silent = false; }
        if (!this._exsistId(ids)) {
            return false;
        }
        this._filter();
        this.list.selection.remove(null, silent);
        if (this.config.multiselection) {
            if (typeof ids === "string") {
                ids = ids.split(",");
            }
            if (typeof ids === "number") {
                ids = [ids];
            }
            ids.forEach(function (id) {
                _this.list.selection.add(id, false, false, silent);
            });
        }
        else {
            var id = (0, core_1.unwrapBox)(ids);
            this.list.selection.add(id, false, false, silent);
            var item = this.data.getItem(id);
            if (item) {
                this._state.value = this._getItemText(item);
            }
        }
        this.paint();
    };
    Combobox.prototype._createLayout = function () {
        var list = (this.list = new ts_list_1.List(null, {
            $template: exports.$template,
            template: this.config.template,
            htmlEnable: this.config.htmlEnable,
            virtual: this.config.virtual,
            keyNavigation: true,
            multiselection: this.config.multiselection,
            itemHeight: this.config.itemHeight,
            height: this.config.listHeight,
            data: this.data,
        }));
        var layout = (this._layout = new ts_layout_1.Layout(this.popup.getContainer(), {
            css: "dhx_combobox-options dhx_combobox__options",
            rows: [
                {
                    id: "select-unselect-all",
                    hidden: !this.config.multiselection || !this.config.selectAllButton,
                },
                { id: "list", height: "content" },
                {
                    id: "not-found",
                    hidden: true,
                },
            ],
            on: {
                click: {
                    ".dhx_combobox__action-select-all": this._handlers.selectAll,
                    ".dhx_combobox-options__action-create-option": this._handlers.addOption,
                },
            },
        }));
        layout.getCell("list").attach(list);
        if (this.config.multiselection && this.config.selectAllButton) {
            layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
        }
    };
    Combobox.prototype._initHandlers = function () {
        var _this = this;
        if (this.config.helpMessage) {
            this._helper = new ts_popup_1.Popup({
                css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
            });
            this._helper.attachHTML(this.config.helpMessage);
        }
        this._handlers = {
            addOption: function () { return _this.addOption(_this._state.value); },
            showHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.show(e.target, {
                    mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                    theme: e.target,
                });
            },
            selectAll: function () {
                if (_this._state.unselectActive) {
                    _this.list.selection.remove();
                    if (_this.config.selectAllButton) {
                        _this._layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
                        _this._state.unselectActive = false;
                    }
                }
                else {
                    _this.data.filter();
                    _this.list.selection.add();
                    if (_this.config.selectAllButton) {
                        _this._layout.getCell("select-unselect-all").attach(helper_1.unselectAllView);
                        _this._state.unselectActive = true;
                    }
                }
                _this._changePopupPosition();
                _this.paint();
            },
            onkeydown: function (e) {
                if (e.key === "Tab" && _this.popup.isVisible()) {
                    _this._hideOptions();
                }
                else {
                    if (!_this.popup.isVisible() && e.which === keycodes_1.KEY_CODES.DOWN_ARROW) {
                        _this._showOptions();
                    }
                    if (_this.popup.isVisible()) {
                        if (e.which === keycodes_1.KEY_CODES.RIGHT_ARROW) {
                            if (_this.config.readOnly && !_this.config.multiselection) {
                                _this.list.moveFocus(ts_list_1.MOVE_DOWN);
                                e.preventDefault();
                            }
                        }
                        if (e.which === keycodes_1.KEY_CODES.LEFT_ARROW) {
                            if (_this.config.readOnly && !_this.config.multiselection) {
                                _this.list.moveFocus(ts_list_1.MOVE_UP);
                                e.preventDefault();
                            }
                        }
                        if (e.which === keycodes_1.KEY_CODES.DOWN_ARROW) {
                            _this.list.moveFocus(ts_list_1.MOVE_DOWN);
                            e.preventDefault();
                        }
                        if (e.which === keycodes_1.KEY_CODES.UP_ARROW) {
                            _this.list.moveFocus(ts_list_1.MOVE_UP);
                            e.preventDefault();
                        }
                        if (e.which === keycodes_1.KEY_CODES.ESC) {
                            _this._hideOptions();
                        }
                        if (e.which === keycodes_1.KEY_CODES.ENTER) {
                            if (_this.data.getLength()) {
                                var id = _this.list.getFocus();
                                var value = _this.config.multiselection
                                    ? __spreadArray(__spreadArray([], _this.list.selection.getId(), true), [id], false) : id;
                                _this.setValue(value);
                            }
                            else if (_this.config.newOptions) {
                                _this.addOption(_this._state.value, true);
                            }
                            if (_this.config.multiselection) {
                                _this._updatePopup();
                            }
                            else if (_this.data.getLength()) {
                                _this._hideOptions();
                            }
                        }
                    }
                }
                _this.events.fire(types_2.ComboboxEvents.keydown, [e, _this.list.getFocus()]);
            },
            onkeyup: function (e) {
                if (!_this.config.multiselection || _this.config.itemsCount) {
                    return;
                }
                if (_this._state.ignoreNext) {
                    _this._state.ignoreNext = false;
                    return;
                }
                if (e.which === keycodes_1.KEY_CODES.BACKSPACE &&
                    !_this._state.value &&
                    _this.config.multiselection &&
                    _this.list.selection.getId().length) {
                    var selected = _this.list.selection.getId();
                    var id = selected[selected.length - 1];
                    _this.list.selection.remove(id);
                    _this._changePopupPosition();
                    _this.paint();
                }
            },
            oninput: function (e) {
                if (_this.config.disabled) {
                    return;
                }
                var input = e.target;
                var value = input.value;
                _this.events.fire(types_2.ComboboxEvents.input, [value]);
                _this._state.value = value;
                _this._filter();
                if (!value.length) {
                    _this._state.ignoreNext = true;
                    _this._state.canDelete = true;
                }
                else {
                    _this._state.canDelete = false;
                }
                if (!_this.config.multiselection) {
                    _this.list.selection.remove();
                    _this.paint();
                }
                if (!_this.popup.isVisible()) {
                    _this._showOptions();
                }
                _this._updatePopup();
            },
            oninputclick: function (e) {
                var _a;
                if (_this.config.disabled) {
                    return;
                }
                _this.focus();
                if (e.target.classList.contains("dhx_combobox__action-remove")) {
                    var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                    if (!(0, core_1.isId)(id)) {
                        return;
                    }
                    _this.list.selection.remove(id);
                    _this._changePopupPosition();
                    _this.paint();
                    return;
                }
                if (e.target.classList.contains("dhx_combobox__action-clear-all")) {
                    _this.list.selection.getId().forEach(function (id) { return _this.list.selection.remove(id); });
                    if (_this.config.selectAllButton && _this._state.unselectActive) {
                        _this._layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
                        _this._state.unselectActive = false;
                    }
                    _this.paint();
                    return;
                }
                e.preventDefault();
                if (!_this.popup.isVisible()) {
                    _this._showOptions();
                    return;
                }
                _this.focus();
            },
            toggleIcon: function () {
                _this.focus();
                if (_this.popup.isVisible()) {
                    _this._hideOptions();
                }
                else {
                    _this._showOptions();
                }
            },
            onfocus: function () { var _a; return (_a = _this.events) === null || _a === void 0 ? void 0 : _a.fire(types_2.ComboboxEvents.focus, []); },
            onblur: function () { var _a; return (_a = _this.events) === null || _a === void 0 ? void 0 : _a.fire(types_2.ComboboxEvents.blur, []); },
        };
    };
    Combobox.prototype._initEvents = function () {
        var _this = this;
        this.data.events.on(ts_data_1.DataEvents.load, function () {
            if (_this.config.value) {
                _this._setValue(_this.config.value, true);
            }
        });
        this.data.events.on(ts_data_1.DataEvents.afterAdd, function () {
            if (!_this.config.multiselection) {
                _this._hideOptions();
            }
            else {
                _this._changePopupPosition();
            }
        });
        this.list.events.on(ts_list_1.ListEvents.click, function () {
            if (!_this.config.multiselection) {
                _this._hideOptions();
            }
            _this._changePopupPosition();
        });
        this.list.selection.events.on(types_1.SelectionEvents.beforeSelect, function (id) {
            var value = _this.config.multiselection
                ? __spreadArray(__spreadArray([], _this.getValue(_this.config.multiselection), true), [id], false) : id;
            return _this.events.fire(types_2.ComboboxEvents.beforeChange, [value]);
        });
        this.list.selection.events.on(types_1.SelectionEvents.afterSelect, function () {
            var value = _this.getValue(_this.config.multiselection);
            _this.events.fire(types_2.ComboboxEvents.change, [value]);
            _this._updateSelectedItem(value);
        });
        this.list.selection.events.on(types_1.SelectionEvents.beforeUnSelect, function (id) {
            var value = _this.config.multiselection
                ? _this.getValue(_this.config.multiselection).filter(function (i) { return i != id; })
                : id;
            return _this.events.fire(types_2.ComboboxEvents.beforeChange, [value]);
        });
        this.list.selection.events.on(types_1.SelectionEvents.afterUnSelect, function () {
            var multi = _this.config.multiselection;
            if (_this.config.readOnly && !multi)
                return;
            var value = _this.getValue(multi);
            _this.events.fire(types_2.ComboboxEvents.change, [value]);
            if (multi)
                _this._updateSelectedItem(value);
        });
        this.popup.events.on(ts_popup_1.PopupEvents.beforeShow, function () {
            if (!_this.popup.isVisible() && !_this._isPopupConfiqureted) {
                _this._configurePopup();
                return false;
            }
        });
        if (this.config.readOnly) {
            this.popup.events.on(ts_popup_1.PopupEvents.afterShow, function () {
                if (_this._state.value) {
                    var id = _this.list.selection.getId();
                    _this.list.setFocus(id);
                }
                else {
                    _this.list.setFocus(_this.data.getId(0));
                }
                _this._keyListener.startNewListen(function (val) { return _this._findBest(val); });
            });
        }
    };
    Combobox.prototype._showOptions = function () {
        if (!this.events.fire(types_2.ComboboxEvents.beforeOpen)) {
            return;
        }
        if (this._state.value.length) {
            this._state.canDelete = true;
        }
        this._filter();
        if (this._configurePopup()) {
            this.events.fire(types_2.ComboboxEvents.open);
            this.events.fire(types_2.ComboboxEvents.afterOpen);
        }
    };
    Combobox.prototype._configurePopup = function () {
        this._isPopupConfiqureted = true;
        var rootView = this.getRootView();
        if (!rootView || !rootView.refs || !rootView.refs.holder) {
            return false;
        }
        if (!this.popup.isVisible()) {
            this._updatePopup();
        }
        return true;
    };
    Combobox.prototype._hideOptions = function () {
        var _this = this;
        if (!this.events.fire(types_2.ComboboxEvents.beforeClose)) {
            return;
        }
        if (this.config.readOnly) {
            this._keyListener.endListen();
        }
        this.list.setFocus(this.data.getId(0));
        if (!this.config.multiselection && !this.config.readOnly && !this.list.selection.contains()) {
            this._state.value = "";
        }
        (0, dom_1.awaitRedraw)().then(function () { return _this.popup.isVisible() && _this.popup.hide(); });
        this.events.fire(types_2.ComboboxEvents.afterClose);
        this.events.fire(types_2.ComboboxEvents.close); // TODO: remove suite_7.0
        this._filter();
        this.paint();
    };
    Combobox.prototype._filter = function () {
        var _this = this;
        if (this.config.readOnly) {
            return;
        }
        this.data.filter(function (item) {
            return _this.config.filter
                ? _this.config.filter(item, _this._state.value)
                : (0, core_1.isEqualString)(_this._state.value, _this._getItemText(item));
        });
        if (this.config.multiselection) {
            this.list.setFocus(this.data.getId(0));
        }
        else {
            var index = this.data.getIndex(this.list.selection.getId());
            this.list.setFocus(this.data.getId(index > -1 ? index : 0));
        }
        var listCell = this._layout.getCell("list");
        var notFoundCell = this._layout.getCell("not-found");
        if (this.data.getLength() === 0) {
            if (this.config.multiselection && this.config.selectAllButton) {
                this._layout.getCell("select-unselect-all").hide();
            }
            listCell.hide();
            this._state.creatingState = true;
            var notFoundContent = this.config.newOptions ? this._state.value : "";
            notFoundCell.height = (0, helper_1.emptyListHeight)(notFoundContent, this.getRootView().refs.holder.el.offsetWidth);
            notFoundCell.attach(helper_1.emptyListView, notFoundContent);
            notFoundCell.show();
        }
        else {
            if (this.config.multiselection && this.config.selectAllButton) {
                this._layout.getCell("select-unselect-all").show();
            }
            var sameItem = this._state.value && this.data.find(function (item) { return item.value === _this._state.value; });
            if (!sameItem && this._state.value) {
                this._state.creatingState = this.config.newOptions;
                listCell.show();
                if (this.config.newOptions) {
                    var notFoundContent = this._state.value;
                    notFoundCell.height = (0, helper_1.emptyListHeight)(notFoundContent, this.getRootView().refs.holder.el.offsetWidth);
                    notFoundCell.attach(helper_1.emptyListView, notFoundContent);
                    notFoundCell.show();
                }
                else
                    notFoundCell.hide();
            }
            else {
                this._state.creatingState = false;
                if (notFoundCell.isVisible()) {
                    listCell.show();
                    notFoundCell.hide();
                }
            }
        }
    };
    Combobox.prototype._findBest = function (value) {
        var _this = this;
        var best = this.data.find(function (item) { return (0, core_1.isEqualString)(value, _this._getItemText(item)); });
        if (!best) {
            return;
        }
        if (this.list.selection.getId() === best.id) {
            return;
        }
        this.list.setFocus(best.id);
        this.paint();
    };
    Combobox.prototype._exsistId = function (id) {
        var _this = this;
        if (id instanceof Array) {
            return id.every(function (i) { return _this.data.exists(i); });
        }
        return this.data.exists(id);
    };
    Combobox.prototype._draw = function () {
        if (!this.config) {
            return (0, dom_1.el)("div");
        }
        var _a = this.config, multiselection = _a.multiselection, labelPosition = _a.labelPosition, hiddenLabel = _a.hiddenLabel, required = _a.required, disabled = _a.disabled, css = _a.css, helpMessage = _a.helpMessage, readOnly = _a.readOnly, placeholder = _a.placeholder;
        var item = multiselection ? null : this.data.getItem(this.list.selection.getId());
        var showPlaceholder = !this.list.selection.getId() ||
            (typeof this.list.selection.getId() === "object" &&
                this.list.selection.getId().length === 0);
        var labelStyle = (0, html_1.getLabelStyle)(this.config);
        var canTemplate = !this.config.multiselection && (this.config.readOnly || !this.popup.isVisible());
        var isInputTemplate = canTemplate && this.config.htmlEnable && this.config.template;
        var isInputImageOrIcon = canTemplate && ((item === null || item === void 0 ? void 0 : item.icon) || (item === null || item === void 0 ? void 0 : item.src)) && !this.config.template;
        return (0, dom_1.el)("div", {
            "data-dhx-widget-id": this._uid,
            onkeydown: this._handlers.onkeydown,
            onkeyup: this._handlers.onkeyup,
            class: "dhx_widget dhx_combobox" +
                (labelPosition === "left" ? " dhx_combobox--label-inline" : "") +
                (hiddenLabel ? " dhx_combobox--sr_only" : "") +
                (required ? " dhx_combobox--required" : "") +
                (disabled ? " dhx_combobox--disabled" : "") +
                (css ? " ".concat(css) : ""),
        }, [
            labelStyle
                ? (0, dom_1.el)("label.dhx_label.dhx_combobox__label", {
                    style: labelStyle.style,
                    class: helpMessage ? "dhx_label--with-help" : "",
                    onclick: this._handlers.oninputclick,
                }, helpMessage
                    ? [
                        (labelStyle.label || required) &&
                            (0, dom_1.el)("span.dhx_label__holder", labelStyle.label),
                        (0, dom_1.el)("span.dhx_label-help.dxi.dxi-help-circle-outline", {
                            tabindex: "0",
                            role: "button",
                            onclick: this._handlers.showHelper,
                            id: "dhx_label__help_".concat(this._uid),
                        }),
                    ]
                    : labelStyle.label)
                : null,
            (0, dom_1.el)("div.dhx_combobox-input-box" +
                // (this.popup.isVisible() ? ".dhx_combobox-input-box" : "") +
                (disabled ? ".dhx_combobox-input-box--disabled" : "") +
                (readOnly ? ".dhx_combobox-input-box--readonly" : "") +
                (this._state.currentState === types_2.ComboState.error
                    ? ".dhx_combobox-input-box--state_error"
                    : "") +
                (this._state.currentState === types_2.ComboState.success
                    ? ".dhx_combobox-input-box--state_success"
                    : ""), {
                _ref: "holder",
            }, [
                (0, dom_1.el)("div.dhx_combobox-input__icon", {
                    onclick: this._handlers.toggleIcon,
                }, [
                    (0, dom_1.el)("span" +
                        (this.popup.isVisible() ? ".dxi.dxi-menu-up" : ".dxi.dxi-menu-down")),
                ]),
                (0, dom_1.el)("div.dhx_combobox-input-list-wrapper", {
                    onclick: this._handlers.oninputclick,
                }, [
                    (0, dom_1.el)("ul.dhx_combobox-input-list", __spreadArray(__spreadArray([], this._drawSelectedItems(), true), [
                        (0, dom_1.el)("li.dhx_combobox-input-list__item.dhx_combobox-input-list__item--input", [
                            (isInputTemplate || isInputImageOrIcon) && item
                                ? (0, dom_1.el)("div.dhx_combobox-input__template", {
                                    ".innerHTML": isInputTemplate
                                        ? this.config.template(item)
                                        : null,
                                }, isInputImageOrIcon ? [(0, exports.$template)(item)] : null)
                                : null,
                            (0, dom_1.el)("input.dhx_combobox-input", {
                                oninput: this._handlers.oninput,
                                onfocus: this._handlers.onfocus,
                                onblur: this._handlers.onblur,
                                _ref: "input",
                                _key: this._uid,
                                type: "text",
                                placeHolder: showPlaceholder && placeholder ? placeholder : undefined,
                                value: readOnly && item
                                    ? this._getItemText(item)
                                    : this._state.value,
                                readOnly: readOnly || disabled,
                                required: required,
                                "aria-label": readOnly
                                    ? "Select value"
                                    : "Type or select value",
                                "aria-describedby": helpMessage
                                    ? "dhx_label__help_".concat(this._uid)
                                    : null,
                                "aria-expanded": true,
                            }),
                        ]),
                    ], false)),
                ]),
            ]),
        ]);
    };
    Combobox.prototype._drawSelectedItems = function () {
        var _this = this;
        if (!this.config.multiselection) {
            return [];
        }
        if (this.config.itemsCount) {
            var count = this.list.selection.getId().length;
            return count
                ? [
                    (0, dom_1.el)("li.dhx_combobox-input-list__item.dhx_combobox-tag", [
                        (0, dom_1.el)("span.dhx_combobox-tag__value", itemsCountTemplate(count, this.config.itemsCount)),
                        (0, dom_1.el)("button.dhx_button.dhx_combobox-tag__action.dhx_combobox__action-clear-all", { "aria-label": "clear all" }, [(0, dom_1.el)("span.dhx_button__icon.dxi.dxi-close-circle")]),
                    ]),
                ]
                : [];
        }
        return this.list.selection.getId().map(function (id) {
            var item = _this.data.getItem(id);
            if (!item) {
                return null;
            }
            var imageOrIcon = _this._drawImageOrIcon(item);
            return (0, dom_1.el)("li.dhx_combobox-input-list__item.dhx_combobox-tag", { "data-dhx-id": id }, __spreadArray(__spreadArray([], (imageOrIcon || !_this.config.template
                ? [imageOrIcon, (0, dom_1.el)("span.dhx_combobox-tag__value", _this._getItemText(item))]
                : [
                    (0, dom_1.el)("span.dhx_combobox-tag__template", {
                        ".innerHTML": _this.config.template(item),
                    }),
                ]), true), [
                (0, dom_1.el)("button.dhx_button.dhx_button--icon.dhx_combobox-tag__action.dhx_combobox__action-remove", {
                    type: "button",
                    "aria-label": "remove",
                }, [(0, dom_1.el)("span.dhx_button__icon.dxi.dxi-close-circle")]),
            ], false));
        });
    };
    Combobox.prototype._drawImageOrIcon = function (item) {
        if (item.src) {
            return (0, dom_1.el)("img.dhx_combobox-tag__image", { src: item.src, alt: "" });
        }
        else if (item.icon) {
            return (0, dom_1.el)("span.dhx_combobox-tag__icon", { class: item.icon });
        }
        return null;
    };
    Combobox.prototype._getItemText = function (item) {
        if (!item) {
            return null;
        }
        return item.value;
    };
    Combobox.prototype._updateSelectedItem = function (id) {
        var _a;
        if (this.config.multiselection) {
            if (this.config.selectAllButton &&
                !this._state.unselectActive &&
                this.data.getLength() === id.length) {
                this._layout.getCell("select-unselect-all").attach(helper_1.unselectAllView);
                this._state.unselectActive = true;
            }
            else if (this.config.selectAllButton && this._state.unselectActive) {
                this._layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
                this._state.unselectActive = false;
            }
            if (this._state.value) {
                this._state.value = "";
                this._state.canDelete = id.length === 0;
                this._filter();
            }
        }
        else {
            this._state.value = (_a = this._getItemText(this.data.getItem(id))) !== null && _a !== void 0 ? _a : "";
        }
        this.paint();
    };
    Combobox.prototype._changePopupPosition = function () {
        var _this = this;
        if (this.config.multiselection) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this._updatePopup();
            });
        }
    };
    Combobox.prototype._updatePopup = function () {
        var holderNode = this.getRootView().refs.holder.el;
        this.popup.getContainer().style.width = holderNode.offsetWidth + "px";
        var itemsHeight = this.data.getLength() * (this.config.itemHeight || 36);
        this.config.listHeight = parseFloat(this.config.listHeight);
        var listHeight = itemsHeight < this.config.listHeight ? itemsHeight : this.config.listHeight;
        this.popup.getContainer().style.height =
            Number(listHeight) +
                (this.config.selectAllButton &&
                    this.config.multiselection &&
                    this._layout.getCell("select-unselect-all").isVisible()
                    ? 33
                    : 0) +
                (this._state.creatingState ? this._layout.getCell("not-found").height : 0) +
                "px";
        this.popup.show(holderNode, {
            mode: "bottom",
            theme: this.getRootNode(),
        });
    };
    return Combobox;
}(view_1.View));
exports.Combobox = Combobox;


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.List = exports.MOVE_DOWN = exports.MOVE_UP = void 0;
var core_1 = __webpack_require__(1);
var ts_data_1 = __webpack_require__(7);
var dom_1 = __webpack_require__(0);
var KeyManager_1 = __webpack_require__(14);
var types_1 = __webpack_require__(28);
var view_1 = __webpack_require__(8);
var Selection_1 = __webpack_require__(76);
var html_1 = __webpack_require__(3);
var types_2 = __webpack_require__(48);
var editors_1 = __webpack_require__(148);
exports.MOVE_UP = 1;
exports.MOVE_DOWN = 2;
var List = /** @class */ (function (_super) {
    __extends(List, _super);
    function List(node, config) {
        if (config === void 0) { config = {}; }
        var _this = this;
        var itemHeight = config.itemHeight || (config.virtual ? 37 : null);
        if (itemHeight && typeof itemHeight === "number") {
            itemHeight = itemHeight.toString() + "px";
        }
        _this = _super.call(this, node, (0, core_1.extend)({
            itemHeight: itemHeight,
            keyNavigation: true,
            editable: false,
            selection: true,
            htmlEnable: true,
        }, config)) || this;
        _this._destructed = false;
        _this._touch = {
            duration: 350,
            dblDuration: 300,
            timer: null,
            start: false,
            timeStamp: null,
        };
        // init data colleciton and link events between widget and data
        var data = _this.config.data;
        if (!(data instanceof ts_data_1.DataCollection)) {
            _this.data = new ts_data_1.DataCollection({});
            _this.events = _this.data.events;
            if (data)
                _this.data.parse(data);
        }
        else {
            // [TODO] deprecate in favor of raw data input
            _this.data = data;
            _this.events = data.events;
        }
        _this.selection = new Selection_1.Selection({
            disabled: !_this.config.selection,
            multiselection: _this.config.multiselection,
        }, _this.data, _this.events);
        if (_this.config.keyNavigation) {
            _this.keyManager = new KeyManager_1.KeyManager(function (e, focusId) {
                return focusId == _this._uid && (!_this._edited || (_this._edited && e.key !== "escape"));
            });
            _this._initHotKey();
        }
        _this.events.on(ts_data_1.DataEvents.change, function (_, status, item) {
            if (status === "setPage") {
                _this.scrollTo(_this.data.getId(item[0]));
            }
            _this.paint();
        });
        _this.events.on(ts_data_1.DataEvents.filter, function () {
            _this.paint();
        });
        _this.events.on(types_1.SelectionEvents.afterUnSelect, function () { return _this.paint(); });
        _this.events.on(types_1.SelectionEvents.afterSelect, function (id) {
            if ((0, core_1.isId)(id) && _this.config.selection)
                _this.setFocus(id);
            _this.paint();
        });
        _this.events.on(types_2.ListEvents.afterEditEnd, _this.editEnd.bind(_this));
        var drop = function (value) { return function (info) {
            _this.data.setMeta(_this.data.getItem(info.target), "drop", value);
            _this.paint();
        }; };
        _this.events.on(ts_data_1.DragEvents.canDrop, drop(true));
        _this.events.on(ts_data_1.DragEvents.cancelDrop, drop(false));
        var drag = function (value) { return function (info) {
            info.source.map(function (id) { return _this.data.setMeta(_this.data.getItem(id), "drag", value); });
            _this.paint();
        }; };
        _this.events.on(ts_data_1.DragEvents.dragStart, drag(true));
        _this.events.on(ts_data_1.DragEvents.afterDrag, drag(false));
        _this._handlers = {
            onmousedown: function (e) {
                _this._dragStart(e);
            },
            ontouchstart: function (e) {
                _this._touch.timer = setTimeout(function () {
                    _this._dragStart(e);
                }, _this._touch.duration);
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +e.timeStamp.toFixed();
                }
                else {
                    var dblTap = _this._touch.dblDuration >= _this._touch.timeStamp - +e.timeStamp.toFixed();
                    if (dblTap) {
                        e.preventDefault();
                        _this._dblClick(e);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            },
            ontouchmove: function (e) {
                _this._touch.start && e.preventDefault();
                _this._clearTouchTimer();
            },
            ontouchend: function () {
                _this._touch.start = false;
                _this._clearTouchTimer();
            },
            ondragstart: function () { return (_this.config.dragMode && !_this._edited ? false : null); },
            oncontextmenu: function (e) {
                var _a;
                var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                if (!(0, core_1.isId)(id)) {
                    return;
                }
                _this.events.fire(types_2.ListEvents.itemRightClick, [id, e]);
            },
            onclick: function (e) {
                var _a;
                var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                if (!(0, core_1.isId)(id)) {
                    return;
                }
                _this.selection.add(id, e.ctrlKey || e.metaKey, e.shiftKey);
                if (_this.config.selection) {
                    _this._focus = id;
                }
                _this.events.fire(types_2.ListEvents.click, [id, e]);
                _this.paint();
            },
            ondblclick: function (e) {
                _this._dblClick(e);
            },
            onscroll: function (e) {
                if (_this.config.virtual) {
                    _this._topOffset = e.target.scrollTop;
                    _this._visibleHeight = e.target.offsetHeight;
                    _this.paint();
                }
            },
            onmouseover: function (e) {
                var _a;
                var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                if (!(0, core_1.isId)(id)) {
                    return;
                }
                var prevId = (0, html_1.locate)(e.relatedTarget);
                if (id !== prevId)
                    _this.events.fire(types_2.ListEvents.itemMouseOver, [id, e]);
            },
        };
        var evs = _this.config.eventHandlers;
        if (evs) {
            for (var _i = 0, _a = Object.entries(evs); _i < _a.length; _i++) {
                var _b = _a[_i], event_name = _b[0], events = _b[1];
                _this._handlers[event_name] = (0, html_1.eventHandler)(function (e) { return (0, html_1.locate)(e); }, events, _this._handlers[event_name]);
            }
        }
        if (_this.config.dragMode) {
            ts_data_1.dragManager.setItem(_this._uid, _this);
        }
        // defaults for virtual rendering
        _this._topOffset = _this._visibleHeight = 0;
        var view = (0, dom_1.create)({
            render: function () {
                return _this._destructed ? (0, dom_1.el)("div") : _this._renderList();
            },
            hooks: {
                didMount: function (vm) {
                    if (_this.config.virtual)
                        _this._visibleHeight = vm.node.el.offsetHeight;
                },
                didRedraw: function (vm) { return _this._didRedraw(vm); },
            },
        });
        _this.mount(node, view);
        return _this;
    }
    List.prototype._didRedraw = function (vm) {
        // do nothing
    };
    List.prototype._dblClick = function (e) {
        var id = (0, html_1.locate)(e);
        if (!id) {
            return;
        }
        id = this.data.getItem(id).id;
        if (this.config.editable) {
            this.editItem(id);
        }
        this.events.fire(types_2.ListEvents.doubleClick, [id, e]);
    };
    List.prototype._clearTouchTimer = function () {
        if (this._touch.timer) {
            clearTimeout(this._touch.timer);
            this._touch.timer = null;
        }
    };
    List.prototype._dragStart = function (e) {
        var _this = this;
        this._touch.start = true;
        var itemsForGhost = [];
        var item = (0, html_1.locateNode)(e, "data-dhx-id");
        var itemId = item && item.getAttribute("data-dhx-id");
        var selectionIds = this.selection.getId();
        if (this.config.multiselection && selectionIds instanceof Array) {
            selectionIds.map(function (id) {
                if (id !== itemId && _this.getRootView().refs[id]) {
                    itemsForGhost.push(_this.getRootView().refs[id].el);
                }
            });
            selectionIds = __spreadArray([], selectionIds, true);
        }
        if (typeof selectionIds === "string") {
            selectionIds = [selectionIds];
        }
        return this.config.dragMode && !this._edited
            ? ts_data_1.dragManager.onMouseDown(e, selectionIds || [itemId], itemsForGhost)
            : null;
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    List.prototype.disableSelection = function () {
        this.selection.disable();
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    List.prototype.enableSelection = function () {
        this.selection.enable();
    };
    List.prototype.editItem = function (id) {
        this._edited = id;
        if (!this.data.getItem(this._edited) || !this.events.fire(types_2.ListEvents.beforeEditStart, [id])) {
            this._edited = null;
            return;
        }
        this.paint();
        this.events.fire(types_2.ListEvents.afterEditStart, [id]);
    };
    // [TODO] maybe better name
    List.prototype.editEnd = function (value, id) {
        if (this._edited) {
            if (value !== null) {
                var item = this.data.getItem(id);
                this.data.update(id, __assign(__assign({}, item), { value: value }));
                this._changed = true;
            }
            this._edited = null;
            this.paint();
        }
    };
    /*
        Focus API allows to mark item as active one, but not selected yet
        Used by keyboard navigation
    */
    List.prototype.getFocusItem = function () {
        return this.data.getItem(this._focus);
    };
    List.prototype.setFocus = function (id) {
        if (this._focus != id && this.data.exists(id)) {
            this._focus = id;
            this.events.fire(types_2.ListEvents.focusChange, [this.data.getIndex(this._focus), this._focus]);
            this.scrollTo(id);
            this.paint();
        }
    };
    List.prototype.getFocus = function () {
        return this._focus;
    };
    List.prototype.destructor = function () {
        this._destructed = true;
        this.events && this.events.clear();
        this.keyManager && this.keyManager.destructor();
        this.selection && this.selection.destructor();
        this.config = this.events = this.selection = this.keyManager = null;
        this._handlers = this._focus = this._edited = this._events = this._topOffset = this._visibleHeight = this._touch = null;
        this.unmount();
    };
    List.prototype.scrollTo = function (id) {
        var rootView = this.getRootView();
        if (!rootView || !rootView.node || !rootView.node.el || typeof id === "undefined") {
            return;
        }
        var listEl = this.getRootNode();
        this._scrollTo(id, listEl);
    };
    List.prototype._scrollTo = function (id, el) {
        if (!el)
            return;
        var index = this.data.getIndex(id);
        if (index === -1)
            return;
        var virtual = this.config.virtual;
        var currentPage = Math.floor(index / el.children.length) || 0;
        var item = el.children[index - el.children.length * currentPage];
        if (!virtual && !item)
            return;
        var height = virtual ? parseInt(this.config.itemHeight) : item.clientHeight;
        var top = virtual ? index * height : item.offsetTop;
        if (top >= el.scrollTop + el.clientHeight - height) {
            el.scrollTo(0, top - el.clientHeight + height);
        }
        else if (top < el.scrollTop) {
            el.scrollTo(0, top);
        }
    };
    List.prototype._renderItem = function (item, index) {
        var itemHeight = this.config.itemHeight;
        if (item.$empty) {
            return (0, dom_1.el)("li", {
                class: "dhx_list-item",
                style: {
                    height: itemHeight,
                },
            });
        }
        var html = "";
        if (this.config.template)
            html = this.config.template(item);
        if (item.html)
            html = item.html;
        var focus = item.id == this._focus && this.config.keyNavigation;
        if (item.id == this._edited) {
            var editor = (0, editors_1.getEditor)(item, this);
            return editor.toHTML();
        }
        var mx = this.data.getMetaMap(item);
        var node = __assign(__assign(__assign(__assign({}, this._events), { class: "dhx_list-item" +
                (mx && mx.selected ? " dhx_list-item--selected" : "") +
                (focus ? " dhx_list-item--focus" : "") +
                (mx && mx.drop && !this._edited ? " dhx_list-item--drophere" : "") +
                (mx && mx.drag && !this._edited ? " dhx_list-item--dragtarget" : "") +
                (this.config.dragMode && !this._edited ? " dhx_list-item--drag" : "") +
                (item.css ? " " + item.css : ""), "data-dhx-id": item.id, _ref: item.id.toString(), style: {
                height: itemHeight,
            }, _key: item.id }), this.getItemAriaAttrs(this, item)), { tabindex: focus ? 0 : -1 });
        if (html) {
            if (html === item.html || this.config.htmlEnable) {
                node[".innerHTML"] = html;
                return (0, dom_1.el)("li", node);
            }
            else {
                return (0, dom_1.el)("li", node, html);
            }
        }
        else if (this.config.$template) {
            return (0, dom_1.el)("li", node, [this.config.$template(item)]);
        }
        else {
            var value = item.text || item.value;
            if (this.config.htmlEnable) {
                node[".innerHTML"] = value;
            }
            else
                node.class += " dhx_list-item--text";
            return this.config.htmlEnable ? (0, dom_1.el)("li", node) : (0, dom_1.el)("li", node, value);
        }
    };
    List.prototype._renderList = function () {
        var _this = this;
        var range = this._getRange();
        // mapRange
        var data = this.data.getRawData(range[0], range[1]);
        var kids = data.map(function (obj, index) { return _this._renderItem(obj, index); });
        if (this.config.virtual) {
            kids = __spreadArray(__spreadArray([
                (0, dom_1.el)(".div", { style: { height: range[2] + "px" } })
            ], kids, true), [
                (0, dom_1.el)(".div", { style: { height: range[3] + "px" } }),
            ], false);
        }
        return (0, dom_1.el)("ul.dhx_widget.dhx_list", __assign(__assign({ style: {
                "max-height": this.config.height,
                position: "relative",
            }, tabindex: 0, class: (this.config.css ? this.config.css : "") +
                (this.config.multiselection && this.selection.getItem() ? " dhx_no-select--pointer" : ""), "data-dhx-widget-id": this._uid }, this._handlers), this._getListAriaAttrs(this.config, this.data.getLength())), kids);
    };
    List.prototype.moveFocus = function (mode, step) {
        var length = this.data.getLength();
        if (!length) {
            return;
        }
        var id = this._focus;
        var index = id ? this.data.getIndex(id) : -1;
        step = step || 1;
        if (mode === exports.MOVE_DOWN) {
            id = this.data.getId(Math.min(index + step, length - 1));
        }
        else if (mode === exports.MOVE_UP) {
            id = this.data.getId(Math.max(index - step, 0));
        }
        this.setFocus(id);
    };
    List.prototype._getRange = function () {
        if (this.config.virtual) {
            var overscanCount = 5;
            var visibleHeight = this._visibleHeight || parseInt(this.config.height);
            var itemHeight = parseInt(this.config.itemHeight);
            var total = this.data.getRawData(0, -1).length;
            var totalHeight = total * itemHeight;
            var position = this._topOffset;
            // correct value to be in [0, total-visible] range
            position = Math.max(0, Math.min(position, totalHeight - visibleHeight));
            var index = Math.floor(position / itemHeight);
            var count = Math.min(total - index, Math.floor(visibleHeight / itemHeight) + overscanCount);
            this._topOffset = position;
            return [index, count + index, index * itemHeight, totalHeight - itemHeight * (count + index)];
        }
        else {
            return [0, -1, 0, 0];
        }
    };
    List.prototype._getHotkeys = function () {
        var _this = this;
        return {
            arrowDown: function (e) {
                _this.moveFocus(exports.MOVE_DOWN);
                if (_this._changed)
                    _this._changed = false;
                e.preventDefault();
            },
            arrowUp: function (e) {
                _this.moveFocus(exports.MOVE_UP);
                if (_this._changed)
                    _this._changed = false;
                e.preventDefault();
            },
            escape: function () {
                _this.editEnd(null);
                if (_this._changed)
                    _this._changed = false;
            },
            enter: function (e) {
                var _a;
                if (_this._changed) {
                    _this._changed = false;
                    return;
                }
                var selected = _this.selection.getItem();
                var selectedId = selected instanceof Array ? (_a = selected[0]) === null || _a === void 0 ? void 0 : _a.id : selected === null || selected === void 0 ? void 0 : selected.id;
                if (_this.config.editable &&
                    !_this._edited &&
                    ((selected && selectedId === _this._focus) || !selected)) {
                    _this.editItem(_this._focus);
                }
                else
                    _this.selection.add(_this._focus);
                _this.events.fire(types_2.ListEvents.click, [_this._focus, e]);
            },
            "shift+enter": function (e) {
                _this.selection.add(_this._focus, false, true);
                _this.events.fire(types_2.ListEvents.click, [_this._focus, e]);
            },
            "ctrl+enter": function (e) {
                _this.selection.add(_this._focus, true, false);
                _this.events.fire(types_2.ListEvents.click, [_this._focus, e]);
            },
            "ctrl+a": function (e) {
                if (_this.config.multiselection) {
                    e.preventDefault();
                    _this.selection.remove();
                    var ids = _this.data.map(function (i) { return i.id; });
                    ids.forEach(function (id) {
                        if (_this.config.multiselection === "ctrlClick") {
                            _this.selection.add(id, true);
                        }
                        else {
                            _this.selection.add(id);
                        }
                    });
                }
            },
        };
    };
    List.prototype._initHotKey = function () {
        var handlers = this._getHotkeys();
        for (var key in handlers) {
            this.keyManager.addHotKey(key, handlers[key]);
        }
        for (var key in this.config.hotkeys) {
            this.keyManager.addHotKey(key, this.config.hotkeys[key]);
        }
    };
    List.prototype.getItemAriaAttrs = function (context, item) {
        var getAriaGrabbed = function (context, item) {
            return context.config.dragMode && !context._edited
                ? { "aria-grabbed": Boolean(item.$dragtarget && !context._edited).toString() }
                : {};
        };
        var getAriaRoleDescription = function (context) {
            return context.config.editable
                ? {
                    "aria-roledescription": "".concat(context._edited ? "Press Enter to stop editing" : "Double click to edit content"),
                }
                : {};
        };
        return __assign(__assign({ role: "option", "aria-selected": item.$selected ? "true" : "false" }, getAriaGrabbed(context, item)), getAriaRoleDescription(context));
    };
    List.prototype._getListAriaAttrs = function (config, dataLength) {
        return {
            role: "listbox",
            "aria-label": "Listbox ".concat(config.title || "", ", count of options = ").concat(dataLength, ".").concat(config.editable ? " Content is editable." : ""),
            "aria-multiselectable": config.selection && config.multiselection ? "true" : "false",
            "aria-readonly": config.editable ? "false" : "true",
        };
    };
    return List;
}(view_1.View));
exports.List = List;


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Selection = void 0;
var types_1 = __webpack_require__(28);
var ts_data_1 = __webpack_require__(7);
var core_1 = __webpack_require__(1);
var Selection = /** @class */ (function () {
    function Selection(config, data, events) {
        var _this = this;
        this.config = config;
        this.events = events;
        this._data = data;
        this._selected = [];
        this._data.events.on(ts_data_1.DataEvents.removeAll, function () {
            _this._selected = [];
        });
        if (typeof this.config.multiselection === "string") {
            var types = ["click", "ctrlClick"];
            if (!types.includes(this.config.multiselection)) {
                this.config.multiselection = false;
            }
        }
        this._data.events.on(ts_data_1.DataEvents.beforeRemove, function (obj) {
            _this._nextSelection = null;
            if (_this._selected.length === 1) {
                var next = _this._data.getIndex(obj.id);
                var count = _this._data.getLength();
                if (count > 1) {
                    var lastIndex = count == next - 1 ? next - 1 : next + 1;
                    _this._nextSelection = _this._data.getId(lastIndex);
                }
            }
        });
        this._data.events.on(ts_data_1.DataEvents.afterRemove, function (obj) {
            var hasIndex = _this._selected.indexOf(obj.id);
            if (hasIndex !== -1) {
                _this._selected.splice(hasIndex, 1);
            }
            if ((0, core_1.isId)(_this._nextSelection)) {
                _this.add(_this._nextSelection);
                _this._nextSelection = null;
            }
        });
    }
    Selection.prototype.enable = function () {
        this.config.disabled = false;
    };
    Selection.prototype.disable = function () {
        this.remove();
        this.config.disabled = true;
    };
    Selection.prototype.getId = function () {
        if (this.config.multiselection) {
            return this._selected;
        }
        return this._selected[0];
    };
    Selection.prototype.getItem = function () {
        var _this = this;
        if (this.config.multiselection) {
            return this._selected.map(function (id) { return _this._data.getItem(id); });
        }
        return this._selected.length ? this._data.getItem(this._selected[0]) : null;
    };
    Selection.prototype.contains = function (id) {
        if ((0, core_1.isId)(id)) {
            return this._selected.includes(id);
        }
        return this._selected.length > 0;
    };
    Selection.prototype.remove = function (id, silent) {
        var _this = this;
        if ((0, core_1.isId)(id)) {
            this._unselectItem(id, silent);
        }
        else {
            this._selected.forEach(function (selectedId) { return _this._unselectItem(selectedId, silent); });
            this._selected = [];
        }
    };
    Selection.prototype.add = function (id, isCtrl, isShift, silent) {
        var _this = this;
        if (this.config.disabled) {
            return;
        }
        if (typeof id === "undefined") {
            var unSelected = this._data.serialize().filter(function (_a) {
                var id = _a.id;
                return !_this._selected.includes(id);
            });
            unSelected.forEach(function (_a) {
                var id = _a.id;
                _this._addMulti(id, silent);
            });
            return;
        }
        var multi = this.config.multiselection;
        if (isShift && this._selected.length && multi) {
            this._addMulti(id, silent);
        }
        else {
            this._addSingle(id, multi && (multi !== "ctrlClick" || isCtrl), silent);
        }
    };
    Selection.prototype.destructor = function () {
        var _this = this;
        this._selected.forEach(function (selectedId) { return _this._unselectItem(selectedId, true); });
    };
    Selection.prototype._addMulti = function (id, silent) {
        var _a;
        var last = this._selected[this._selected.length - 1];
        var i1 = this._data.getIndex(last);
        var i2 = this._data.getIndex(id);
        if (i1 > i2) {
            _a = [i2, i1], i1 = _a[0], i2 = _a[1];
        }
        for (i1; i1 <= i2; i1++) {
            var id_1 = this._data.getId(i1);
            this._selectItem(id_1, silent);
        }
    };
    Selection.prototype._addSingle = function (id, isCtrl, silent) {
        var _this = this;
        if (!isCtrl) {
            this._selected.forEach(function (selectedId) {
                if (selectedId != id)
                    _this._unselectItem(selectedId);
            });
        }
        if (isCtrl && this._selected.includes(id)) {
            this._unselectItem(id, silent);
        }
        else {
            this._selectItem(id, silent);
        }
    };
    Selection.prototype._selectItem = function (id, silent) {
        var item = this._data.getItem(id);
        if (!item || this._data.getMeta(item, "selected"))
            return;
        if (!silent && !this.events.fire(types_1.SelectionEvents.beforeSelect, [id]))
            return;
        this._selected.push(id);
        this._data.setMeta(item, "selected", true);
        if (!silent)
            this.events.fire(types_1.SelectionEvents.afterSelect, [id]);
    };
    Selection.prototype._unselectItem = function (id, silent) {
        if (!silent && !this.events.fire(types_1.SelectionEvents.beforeUnSelect, [id]))
            return;
        this._selected = this._selected.filter(function (selectedId) { return selectedId !== id; });
        this._data.setMeta(this._data.getItem(id), "selected", false);
        if (!silent)
            this.events.fire(types_1.SelectionEvents.afterUnSelect, [id]);
    };
    return Selection;
}());
exports.Selection = Selection;


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.emptyListHeight = exports.emptyListView = exports.unselectAllView = exports.selectAllView = void 0;
var dom_1 = __webpack_require__(0);
var en_1 = __webpack_require__(49);
function selectAllView() {
    return (0, dom_1.el)(".dhx_list-item.dhx_combobox-options__item.dhx_combobox-options__item--select-all.dhx_combobox__action-select-all", en_1.default.selectAll);
}
exports.selectAllView = selectAllView;
function unselectAllView() {
    return (0, dom_1.el)(".dhx_list-item.dhx_combobox-options__item.dhx_combobox-options__item--select-all.dhx_combobox__action-select-all", en_1.default.unselectAll);
}
exports.unselectAllView = unselectAllView;
function emptyListView(value) {
    return (0, dom_1.el)("ul.dhx_list", [
        (0, dom_1.el)("li.dhx_list-item.dhx_combobox-options__item".concat(value ? ".dhx_combobox-options__action-create-option" : ""), {}, value ? "".concat(en_1.default.createItem, " \"").concat(value, "\"") : en_1.default.notFound),
    ]);
}
exports.emptyListView = emptyListView;
function emptyListHeight(value, width) {
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = "normal 14px Roboto";
    var sumValue = value ? "".concat(en_1.default.createItem, " \"").concat(value, "\"") : en_1.default.notFound;
    return 13 + 20 * Math.ceil(ctx.measureText(sumValue).width / (width - 16));
}
exports.emptyListHeight = emptyListHeight;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ComboState = exports.ComboboxEvents = void 0;
var ComboboxEvents;
(function (ComboboxEvents) {
    ComboboxEvents["beforeChange"] = "beforeChange";
    ComboboxEvents["change"] = "change";
    ComboboxEvents["focus"] = "focus";
    ComboboxEvents["blur"] = "blur";
    ComboboxEvents["keydown"] = "keydown";
    ComboboxEvents["input"] = "input";
    ComboboxEvents["beforeOpen"] = "beforeOpen";
    ComboboxEvents["afterOpen"] = "afterOpen";
    ComboboxEvents["beforeClose"] = "beforeClose";
    ComboboxEvents["afterClose"] = "afterClose";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ComboboxEvents["open"] = "open";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ComboboxEvents["close"] = "close";
})(ComboboxEvents || (exports.ComboboxEvents = ComboboxEvents = {}));
var ComboState;
(function (ComboState) {
    ComboState[ComboState["default"] = 0] = "default";
    ComboState[ComboState["error"] = 1] = "error";
    ComboState[ComboState["success"] = 2] = "success";
})(ComboState || (exports.ComboState = ComboState = {}));


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFixedCols = exports.getFixedColsHeader = void 0;
var dom_1 = __webpack_require__(0);
var types_1 = __webpack_require__(9);
var Cells_1 = __webpack_require__(27);
var FixedRows_1 = __webpack_require__(80);
var main_1 = __webpack_require__(15);
var render_1 = __webpack_require__(24);
function getFixedColsHeader(renderConfig, layout, mode) {
    if ((mode === types_1.Split.left &&
        (typeof renderConfig.leftSplit !== "number" || !renderConfig.fixedColumns.left.length)) ||
        (mode === types_1.Split.right &&
            (typeof renderConfig.rightSplit !== "number" || !renderConfig.fixedColumns.right.length))) {
        return;
    }
    var leftSplit = renderConfig.leftSplit, rightSplit = renderConfig.rightSplit, $positions = renderConfig.$positions, $totalWidth = renderConfig.$totalWidth, $scrollBarWidth = renderConfig.$scrollBarWidth;
    var isRightSplit = mode === types_1.Split.right;
    var columns = isRightSplit ? renderConfig.fixedColumns.right : renderConfig.fixedColumns.left;
    var width = (0, main_1.getTotalWidth)(columns);
    var getRowAriaAttrs = function (count) { return ({
        role: "rowgroup",
        "aria-rowcount": count,
    }); };
    var frozenHeaderCols = (0, FixedRows_1.getFixedRows)(__assign(__assign({}, renderConfig), { currentColumns: columns, $positions: __assign(__assign({}, $positions), { xStart: 0, xEnd: isRightSplit ? rightSplit : leftSplit }), scroll: { top: 0, left: 0 }, filteredColumns: columns }), __assign(__assign({}, layout), { name: "header", position: "top", shifts: { x: 0, y: 0 } }), mode);
    var headerRowsConfig = __assign(__assign({}, layout), { name: "header", position: "top" });
    return (0, dom_1.el)(".dhx_".concat(headerRowsConfig.name, "-fixed-cols"), __assign({ onwheel: main_1.scrollFixedColsAndRows, class: isRightSplit ? "dhx_grid__cols_right--fixed" : "dhx_grid__cols_left--fixed", style: {
            position: "absolute",
            top: 0,
            left: isRightSplit
                ? $totalWidth < layout.wrapper.width - $scrollBarWidth.y - render_1.BORDERS
                    ? $totalWidth - width
                    : layout.wrapper.width - width - $scrollBarWidth.y - render_1.BORDERS
                : 0,
            width: width,
            overflow: "hidden",
        } }, getRowAriaAttrs(frozenHeaderCols.length)), frozenHeaderCols.body);
}
exports.getFixedColsHeader = getFixedColsHeader;
function getFixedCols(renderConfig, layout, mode, source) {
    if ((mode === types_1.Split.left &&
        (typeof renderConfig.leftSplit !== "number" || !renderConfig.fixedColumns.left.length)) ||
        (mode === types_1.Split.right &&
            (typeof renderConfig.rightSplit !== "number" || !renderConfig.fixedColumns.right.length))) {
        return;
    }
    var leftSplit = renderConfig.leftSplit, rightSplit = renderConfig.rightSplit, $totalWidth = renderConfig.$totalWidth, $totalHeight = renderConfig.$totalHeight, headerHeight = renderConfig.headerHeight, configFooterHeight = renderConfig.footerHeight, $positions = renderConfig.$positions, scroll = renderConfig.scroll, data = renderConfig.data, $scrollBarWidth = renderConfig.$scrollBarWidth;
    var isRightSplit = mode === types_1.Split.right;
    var fixedContentHeight = $totalHeight + headerHeight + configFooterHeight;
    var fixedColsHeight;
    if (fixedContentHeight > layout.gridBodyHeight) {
        fixedColsHeight = renderConfig.$footer
            ? fixedContentHeight - $scrollBarWidth.x
            : layout.gridBodyHeight;
    }
    else if (fixedContentHeight < layout.gridBodyHeight - $scrollBarWidth.x) {
        fixedColsHeight = fixedContentHeight;
    }
    else {
        fixedColsHeight = renderConfig.$footer
            ? layout.gridBodyHeight
            : layout.gridBodyHeight - $scrollBarWidth.x;
    }
    var columns = isRightSplit ? renderConfig.fixedColumns.right : renderConfig.fixedColumns.left;
    var width = (0, main_1.getTotalWidth)(columns);
    var renderFrom = isRightSplit ? "rightFixedCols" : "leftFixedCols";
    var fixedCols = (0, Cells_1.getCells)(__assign(__assign({}, renderConfig), { filteredColumns: columns, $renderFrom: renderFrom, $positions: __assign(__assign({}, $positions), { xStart: 0, xEnd: isRightSplit ? rightSplit : leftSplit }) }));
    var isSticky = layout.sticky;
    var footerRowsConfig = __assign(__assign({}, layout), { name: "footer", position: "bottom" });
    var frozenFooterCols = (0, FixedRows_1.getRows)(__assign(__assign({}, renderConfig), { currentColumns: columns, $positions: __assign(__assign({}, $positions), { xStart: 0, xEnd: isRightSplit ? rightSplit : leftSplit }) }), __assign(__assign({}, layout), { name: "footer", position: "bottom" }));
    var footerHeight = 0;
    frozenFooterCols.forEach(function (node) { return (footerHeight += node.attrs.style.height); });
    var frozenFooterSpans = (0, FixedRows_1.getFixedSpans)(__assign(__assign({}, renderConfig), { filteredColumns: columns }), __assign(__assign({}, layout), { name: "footer", position: "bottom" }), mode);
    var getRowAriaAttrs = function (count) { return ({
        role: "rowgroup",
        "aria-rowcount": count,
    }); };
    var frozenFooter = isSticky
        ? (0, dom_1.el)(".dhx_".concat(footerRowsConfig.name, "-fixed-cols"), __assign({ onwheel: main_1.scrollFixedColsAndRows, class: isRightSplit ? "dhx_grid__cols_right--fixed" : "dhx_grid__cols_left--fixed", style: {
                position: "absolute",
                top: fixedColsHeight < layout.gridBodyHeight ? fixedColsHeight - footerHeight : null,
                left: isRightSplit
                    ? $totalWidth < layout.wrapper.width - $scrollBarWidth.y - render_1.BORDERS
                        ? $totalWidth - width
                        : layout.wrapper.width - width - $scrollBarWidth.y - render_1.BORDERS
                    : 0,
                bottom: fixedColsHeight >= layout.gridBodyHeight
                    ? "".concat(isSticky ? $scrollBarWidth.x : 0, "px")
                    : null,
            } }, getRowAriaAttrs(frozenFooterCols.length)), [
            frozenFooterCols,
            (0, dom_1.el)("span.dhx_span-spans", {
                class: "dhx_footer-spans",
                role: "presentation",
            }, frozenFooterSpans),
        ])
        : null;
    var pos = $positions;
    var spans = (0, Cells_1.getSpans)(__assign(__assign({}, renderConfig), { $renderFrom: renderFrom }), source || (isRightSplit ? types_1.Split.right : types_1.Split.left));
    var getFixedColAriaAttrs = function () { return ({
        role: "presentation",
        "aria-label": "Fixed column",
    }); };
    return [
        (0, dom_1.el)(".dhx_grid-fixed-cols-wrap", __assign({ style: {
                left: isRightSplit
                    ? $totalWidth < layout.wrapper.width - $scrollBarWidth.y - render_1.BORDERS
                        ? $totalWidth - width
                        : layout.wrapper.width - width - $scrollBarWidth.y - render_1.BORDERS
                    : 0,
                height: fixedColsHeight >= layout.gridBodyHeight
                    ? (isSticky ? layout.gridBodyHeight : layout.gridBodyHeight + headerHeight) -
                        $scrollBarWidth.x
                    : fixedColsHeight,
                paddingTop: headerHeight,
                overflow: "hidden",
                width: width,
            } }, getFixedColAriaAttrs()), [
            (0, dom_1.el)(".dhx_grid-fixed-cols", __assign(__assign({ onwheel: main_1.scrollFixedColsAndRows, class: isRightSplit ? "dhx_grid__cols_right--fixed" : "dhx_grid__cols_left--fixed", style: {
                    top: -scroll.top + headerHeight - 1 + "px",
                    paddingTop: layout.shifts.y,
                    height: $totalHeight,
                    position: "absolute",
                }, _flags: dom_1.KEYED_LIST }, (0, Cells_1.getHandlers)(pos.yStart, pos.xStart, renderConfig)), getRowAriaAttrs(data.length)), __spreadArray(__spreadArray([], fixedCols, true), [spans && (0, dom_1.el)("span.dhx_span-spans", { role: "presentation" }, [spans])], false)),
            isRightSplit
                ? (0, dom_1.el)(".dhx_grid__cols-border--frozen", { role: "presentation", style: { left: 0 } })
                : (0, dom_1.el)(".dhx_grid__cols-border--frozen", { role: "presentation", style: { right: 0 } }),
        ]),
        renderConfig.$footer ? frozenFooter : null,
    ];
}
exports.getFixedCols = getFixedCols;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFixedDataRows = exports.getFixedRows = exports.getFixedSpans = exports.getRows = void 0;
var dom_1 = __webpack_require__(0);
var cells_1 = __webpack_require__(32);
var main_1 = __webpack_require__(15);
var types_1 = __webpack_require__(9);
var Cells_1 = __webpack_require__(27);
var FixedCols_1 = __webpack_require__(79);
var core_1 = __webpack_require__(1);
var BORDERS = 2;
function handleMouse(col, config, type, e) {
    if (!type)
        return;
    var systemEvent = type.toLocaleLowerCase().includes("touch");
    if (systemEvent) {
        config._events.fire(type, [col, e]);
    }
    else {
        config.events.fire(type, [col, e]);
    }
}
function getHandlers(column, rowName, config) {
    return {
        onclick: [handleMouse, column, config, types_1.GridEvents[rowName + "CellClick"]],
        onmouseover: [handleMouse, column, config, types_1.GridEvents[rowName + "CellMouseOver"]],
        onmousedown: [handleMouse, column, config, types_1.GridEvents[rowName + "CellMouseDown"]],
        ontouchstart: [handleMouse, column, config, types_1.GridEvents[rowName + "CellMouseDown"]],
        ondblclick: [handleMouse, column, config, types_1.GridEvents[rowName + "CellDblClick"]],
        oncontextmenu: [handleMouse, column, config, types_1.GridEvents[rowName + "CellRightClick"]],
        ontouchmove: [handleMouse, column, config, types_1.GridSystemEvents[rowName + "CellTouchMove"]],
        ontouchend: [handleMouse, column, config, types_1.GridSystemEvents[rowName + "CelltouchEnd"]],
    };
}
function buildRows(columns, name) {
    var header = columns.map(function (col) { return col[name] || [{}]; });
    return (0, main_1.transpose)(header);
}
function getCustomContentCell(cell, column, config, rowName, css, rowIndex, isHTMLEnable) {
    if (css === void 0) { css = ""; }
    if (isHTMLEnable === void 0) { isHTMLEnable = false; }
    var type = column.type ? "dhx_".concat(column.type, "-cell") : "dhx_string-cell";
    // TODO: over with index of filter inside of header or footer
    var content = config.content[cell.content] && config.content[cell.content].toHtml(column, config);
    var cellRow = {};
    config.filteredColumns.forEach(function (col) {
        var hasContent = !!config.content[col[rowName][rowIndex].content];
        cellRow[col.id] =
            (hasContent && config.content[col[rowName][rowIndex].content].toHtml(col, config)) ||
                col[rowName][rowIndex].text;
    });
    var contentBody = column.template && typeof content === "string" ? column.template(content, cellRow, column) : content;
    return (0, dom_1.el)(".".concat(type), {
        style: {
            class: css.trim(),
            padding: 0,
        },
    }, [
        content &&
            (typeof content === "string" || typeof content === "number"
                ? (0, dom_1.el)("div", {
                    class: "dhx_grid-footer-cell-text",
                    role: "presentation",
                    ".innerHTML": isHTMLEnable ? contentBody : null,
                }, isHTMLEnable ? null : contentBody)
                : content),
    ]);
}
function getRows(config, rowsConfig) {
    if (!config.data || !config.filteredColumns) {
        return [];
    }
    var getRowAriaAttrs = function (ind) { return ({
        role: "row",
        "aria-rowindex": ind + 1,
    }); };
    var rowName = rowsConfig.name;
    var isAutoHeight = rowName === "header" ? config.headerAutoHeight : config.footerAutoHeight;
    var pos = config.$positions;
    var columns = config.currentColumns;
    var rows = buildRows(columns, rowName);
    var colRange;
    var colsCount = 1;
    return rows.map(function (row, j) {
        var rowHeight = (rowName === "header"
            ? config.$headerHeightMap
            : config.$footerHeightMap)[j];
        return (0, dom_1.el)(".dhx_".concat(rowName, "-row"), __assign({ style: {
                height: rowHeight,
            } }, getRowAriaAttrs(j)), row.map(function (cell, i) {
            var _a;
            var css = cell.css || "";
            var column = columns[i];
            var colIndex = pos.xStart + i + 1;
            var isHTMLEnable = (0, main_1.isHtmlEnable)(config, column, cell);
            var sortIconCss = "dxi dxi-sort-variant dhx_grid-sort-icon";
            var ariaSort = "none";
            if (config.sortBy && "".concat(column.id) === config.sortBy && !cell.content) {
                var dir = config.sortDir || "asc";
                sortIconCss += " dhx_grid-sort-icon--".concat(dir);
                css += " dhx_grid-".concat(rowName, "-cell--sorted ");
                ariaSort = dir === "asc" ? "ascending" : "descending";
            }
            var sortIconVisible = (0, main_1.isSortable)(config, column) &&
                cell.text &&
                rowName !== "footer" &&
                cell.headerSort !== false;
            if (sortIconVisible) {
                css += " dhx_grid-header-cell--sortable";
            }
            var isFirstCol = i === 0 ? "dhx_first-column-cell" : "";
            var isLastCol = i === columns.length - 1 ? "dhx_last-column-cell" : "";
            if (!cell.content) {
                if (cell.align) {
                    css += " dhx_grid-header-cell--align_".concat(cell.align, " ");
                }
                else {
                    css += " dhx_grid-header-cell--".concat(column.type === "number" || column.type === "percent" || column.type === "date"
                        ? "align_right"
                        : "align_left", " ");
                }
            }
            css += "".concat(isFirstCol, " ").concat(isLastCol);
            var resizable = column.resizable !== undefined ? column.resizable : config.resizable;
            if (resizable) {
                var isLeftResize = config.rightSplit &&
                    config.$scrollBarWidth.xState &&
                    config.fixedColumns.right.includes(column);
                resizable = (0, dom_1.el)("div", {
                    class: "dhx_resizer_grip_wrap",
                    "aria-hidden": "true",
                }, [
                    (0, dom_1.el)("div", {
                        class: "dhx_resizer_grip" +
                            (isLeftResize
                                ? " dhx_resizer_grip--left"
                                : " dhx_resizer_grip--right"),
                        dhx_resized: column.id,
                        style: {
                            height: "".concat(rows.length * 100, "%"),
                        },
                    }, [(0, dom_1.el)("div", { class: "dhx_resizer_grip_line" })]),
                ]);
                var colSpan = column.header && ((_a = column.header[0]) === null || _a === void 0 ? void 0 : _a.colspan);
                if (colSpan) {
                    colRange = colSpan;
                    colsCount = 1;
                }
                if (colRange && colsCount !== colRange) {
                    if (j === 0)
                        resizable = null;
                    colsCount++;
                }
                if (rowName === "footer") {
                    resizable = null;
                }
            }
            if (cell.align) {
                css += " dhx_align-".concat(cell.align);
            }
            var getCellAriaAttrs = function (rowName, colIndex, ariaSort) {
                var attrs = {
                    "aria-colindex": colIndex,
                };
                if (!sortIconVisible) {
                    // if cell is sortable - set tabindex on button (getInnerCellAriaAttrs),
                    // else - on cell
                    // attrs["tabindex"] = 0;
                    // TODO: after sort AND if first cell is not visible: selection.setCell(first cell) -> scrollTo
                    // TODO: use arrows to navigate, set tabindex for first cell only
                }
                if (rowName === "footer" || cell.content) {
                    attrs["role"] = "gridcell";
                }
                else {
                    attrs["role"] = "columnheader";
                    attrs["aria-sort"] = ariaSort;
                    // attrs["aria-label"] = title;
                }
                return attrs;
            };
            if (cell.content) {
                return (0, dom_1.el)(".dhx_grid-".concat(rowName, "-cell.dhx_grid-custom-content-cell"), __assign(__assign({ class: css.trim(), "data-dhx-id": column.id, "data-dhx-text-id": cell.id, _key: column.id, style: {
                        width: column.$width,
                        height: rowName === "footer" ? rowHeight + BORDERS / 2 + "px" : rowHeight + "px",
                    } }, getHandlers(column, rowName, config)), getCellAriaAttrs(rowName, colIndex, ariaSort)), [
                    getCustomContentCell(cell, column, config, rowName, "", j, isHTMLEnable),
                    resizable || null,
                ]);
            }
            var getInnerCellAriaAttrs = function (rowName, text) {
                return sortIconVisible
                    ? {
                        role: "button",
                        "aria-label": "Sort by ".concat(text),
                        // tabindex: 0,
                        // TODO: after sort AND if first cell is not visible: selection.setCell(first cell) -> scrollTo
                        // TODO: use arrows to navigate, set tabindex for first cell only
                    }
                    : {};
            };
            var cellCss = "dhx_grid-header-cell-text_content";
            if (isAutoHeight)
                cellCss += " dhx_grid-header-cell-text_content-auto-height";
            return (0, dom_1.el)(".dhx_grid-".concat(rowName, "-cell"), __assign(__assign({ class: css.trim(), "data-dhx-id": column.id, "data-dhx-text-id": cell.id, _key: column.id, style: {
                    width: column.$width,
                    height: rowName === "footer" ? rowHeight + BORDERS / 2 + "px" : rowHeight + "px",
                } }, getHandlers(column, rowName, config)), getCellAriaAttrs(rowName, colIndex, ariaSort)), [
                (0, dom_1.el)("div.dhx_grid-header-cell-text", {
                    role: "presentation",
                }, [
                    (0, dom_1.el)("span", __assign(__assign({ class: cellCss }, getInnerCellAriaAttrs(rowName, cell.text)), { ".innerHTML": isHTMLEnable ? cell.text : null }), isHTMLEnable ? null : cell.text),
                    resizable || null,
                ]),
                sortIconVisible && (0, dom_1.el)("div", { class: sortIconCss, "aria-hidden": "true" }),
            ]);
        }));
    });
}
exports.getRows = getRows;
function getFixedSpans(config, rowsConfig, mode) {
    var columns = config.columns, cols = config.filteredColumns;
    var rows = (0, main_1.transpose)(cols.map(function (col) { return col[rowsConfig.name] || []; }));
    var rowName = rowsConfig.name;
    var isAutoHeight = rowName === "header" ? config.headerAutoHeight : config.footerAutoHeight;
    var heightMap = (rowName === "header" ? config.$headerHeightMap : config.$footerHeightMap);
    var leftShift = 0;
    return rows.map(function (row, i) {
        leftShift = 0;
        var rowHeight = heightMap[i];
        return (0, dom_1.el)(".dhx_span-row", {
            class: "dhx_header-row",
            "aria-hidden": "true",
        }, row
            .map(function (cell, cellIdx) {
            var spanPartByRightSplit;
            var col = cols[cellIdx];
            if (mode === types_1.Split.right && cellIdx === 0 && !cell.colspan) {
                var rows_1 = (0, main_1.transpose)(columns.map(function (col) { return col[rowsConfig.name] || []; }));
                outer: for (var j = 0; j < rows_1[i].length; j++) {
                    var currCell = rows_1[i][j];
                    if (currCell.colspan > 1) {
                        var spanCols = columns.slice(j, j + currCell.colspan);
                        for (var k = 0; k < spanCols.length; k++) {
                            if (spanCols[k].id !== col.id)
                                continue;
                            spanPartByRightSplit = {
                                cell: currCell,
                                col: columns[j],
                                widthBefore: (0, cells_1.getWidth)(spanCols, k, 0),
                                isLastCol: j + currCell.colspan >= columns.length,
                            };
                            break outer;
                        }
                    }
                }
            }
            var nCell = (spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.cell) || cell;
            var nCol = (spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.col) || col;
            var isHTMLEnable = (0, main_1.isHtmlEnable)(config, col, cell);
            leftShift += nCol.hidden ? 0 : nCol.$width;
            var isFirstCol = cellIdx === 0 ? "dhx_first-column-cell" : "";
            var n = mode ? 1 : config.fixedColumns.right.length + 1;
            var reducedColspan = cell.colspan && (0, cells_1.getReducedColspan)(columns, col.id, cell.colspan);
            var isLastCol = (spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.isLastCol) ||
                cellIdx === cols.length - n ||
                (reducedColspan || 1) + (cellIdx - 1) >= cols.length - n
                ? "dhx_last-column-cell"
                : "";
            var spanHeight = rowHeight;
            var spanPositionTop = rowHeight * i;
            if (nCell.rowspan) {
                var count = nCell.rowspan - 1;
                while (count > 0) {
                    spanHeight += heightMap[i + count];
                    count--;
                }
                spanHeight -= 1;
            }
            if (nCell.rowspan || nCell.colspan) {
                spanPositionTop = 0;
                for (var j = i - 1; j >= 0; j--) {
                    spanPositionTop += heightMap[j];
                }
            }
            var sortIconVisible = (0, main_1.isSortable)(config, nCol) &&
                nCell.rowspan &&
                nCell.text &&
                rowsConfig.name !== "footer" &&
                nCell.headerSort !== false;
            var sortIconCss = "dxi dxi-sort-variant dhx_grid-sort-icon";
            if (config.sortBy && "".concat(nCol.id) === config.sortBy && !nCell.content) {
                sortIconCss += " dhx_grid-sort-icon--".concat(config.sortDir || "asc");
            }
            var cellAlign = nCol.align
                ? "dhx_align-".concat(nCol.align)
                : (nCol.type === "number" || nCol.type === "percent" || nCol.type === "date") &&
                    !nCell.colspan
                    ? "dhx_align-right"
                    : "dhx_align-left";
            var css = "dhx_grid-header-cell ".concat(isFirstCol, " ").concat(isLastCol, " ").concat(nCell.rowspan ? "dhx_span-cell__rowspan" : "", " ").concat(nCell.align ? "dhx_align-".concat(nCell.align) : cellAlign, " ").concat(nCell.css ? nCell.css : "");
            if (sortIconVisible) {
                css += " dhx_grid-header-cell--sortable";
            }
            if (!nCell.content) {
                if (nCell.align) {
                    css += " dhx_grid-header-cell--align_".concat(nCell.align, " ");
                }
                else {
                    css += " dhx_grid-header-cell--".concat(nCol.type === "number" || nCol.type === "percent" || nCol.type === "date"
                        ? "align_right"
                        : "align_left", " ");
                }
            }
            var content = null;
            if (nCell.content) {
                content = getCustomContentCell(nCell, nCol, config, rowName, css, i);
                content.attrs.style = __assign(__assign({}, content.attrs.style), { width: "100%", borderRight: "0" });
            }
            var borderLeft = "";
            if (leftShift - nCol.$width > 0) {
                borderLeft = "var(--dhx-border)";
            }
            var cellCss = "dhx_grid-header-cell-text_content";
            if (isAutoHeight)
                cellCss += " dhx_grid-header-cell-text_content-auto-height";
            var spanElement = (0, dom_1.el)("span", {
                class: cellCss,
                ".innerHTML": isHTMLEnable ? nCell.text : null,
            }, isHTMLEnable ? null : nCell.text);
            return nCell.colspan || nCell.rowspan
                ? (0, dom_1.el)(".dhx_span-cell", __assign({ style: {
                        width: (0, cells_1.getWidth)(columns, nCell.colspan, (0, core_1.findIndex)(columns, function (item) { return item.id === nCol.id; })),
                        height: spanHeight,
                        left: leftShift -
                            nCol.$width -
                            ((spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.widthBefore) || 0),
                        borderLeft: borderLeft,
                        top: spanPositionTop,
                    }, class: css.trim(), "data-dhx-id": nCol.id, "data-dhx-text-id": nCell.id }, getHandlers(nCol, rowName, config)), [
                    content || nCell.rowspan
                        ? (0, dom_1.el)("div.dhx_grid-header-cell-text", {
                            role: "presentation",
                        }, [spanElement])
                        : spanElement,
                    sortIconVisible && (0, dom_1.el)("div", { class: sortIconCss }),
                    (mode === types_1.Split.left &&
                        reducedColspan &&
                        cellIdx + reducedColspan > cols.length) ||
                        spanPartByRightSplit
                        ? (0, dom_1.el)(".dhx_grid__cols-border--frozen", {
                            role: "presentation",
                            style: {
                                left: ((spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.widthBefore) ||
                                    (0, cells_1.getWidth)(cols, cols.length - cellIdx, cellIdx)) -
                                    BORDERS / 2,
                            },
                        })
                        : null,
                ])
                : null;
        })
            .filter(function (cell) { return cell; }));
    });
}
exports.getFixedSpans = getFixedSpans;
function getRowAriaAttrs(rowCount) {
    return { role: "rowgroup", "aria-rowcount": rowCount };
}
function getFixedRows(config, rowsConfig, mode) {
    var _a;
    var leftSplit = config.leftSplit, $totalWidth = config.$totalWidth;
    var rows = getRows(config, rowsConfig);
    var spans = getFixedSpans(config, rowsConfig, mode);
    var fixedCols = null;
    if (rowsConfig.name === "footer" && !rowsConfig.sticky) {
        var rightSplit_1 = config.rightSplit, fixedColumns_1 = config.fixedColumns;
        var getCols = function (isRightSplit) {
            if (isRightSplit === void 0) { isRightSplit = false; }
            var columns = isRightSplit ? fixedColumns_1.right : fixedColumns_1.left;
            return (!isRightSplit && leftSplit >= 0) || (isRightSplit && rightSplit_1 >= 0)
                ? getRows(__assign(__assign({}, config), { currentColumns: columns, $positions: __assign(__assign({}, config.$positions), { xStart: 0, xEnd: isRightSplit ? rightSplit_1 : leftSplit }) }), rowsConfig)
                : [];
        };
        fixedCols = __spreadArray(__spreadArray([], getCols(), true), getCols(true), true);
    }
    var styles = (_a = {
            position: "sticky"
        },
        _a[rowsConfig.position] = 0,
        _a);
    var left;
    if (!rowsConfig.sticky) {
        styles.left = -config.scroll.left;
        left = -config.scroll.left;
        styles.position = "relative";
    }
    return (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-wrapper").concat(config.rightSplit ? ".dhx_grid__rows_right--fixed" : ""), {
        class: rowsConfig.sticky ? "" : "dhx_compatible-".concat(rowsConfig.name),
        style: __assign(__assign({}, styles), { left: rowsConfig.sticky ? left : 0, height: rowsConfig.name === "footer"
                ? config[rowsConfig.name + "Height"] + BORDERS / 2
                : config[rowsConfig.name + "Height"], width: rowsConfig.sticky ? $totalWidth : rowsConfig.wrapper.width - BORDERS }),
        role: "presentation",
    }, [
        (0, dom_1.el)(".dhx_grid-".concat(rowsConfig.name).concat(leftSplit ? ".dhx_grid_fixed_left" : ""), {
            style: {
                height: rowsConfig.name === "footer"
                    ? config[rowsConfig.name + "Height"] + BORDERS / 2
                    : config[rowsConfig.name + "Height"],
                left: left,
                paddingLeft: rowsConfig.shifts.x,
                width: $totalWidth,
            },
            role: "presentation",
        }, [
            (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-rows"), __assign({}, getRowAriaAttrs(__spreadArray([], rows, true).length)), __spreadArray([], rows, true)),
            (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-spans"), {
                style: {
                    marginLeft: -rowsConfig.shifts.x,
                },
                class: "dhx_".concat(rowsConfig.name, "-rows"),
                role: "presentation",
            }, spans),
            fixedCols &&
                (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-fixed-cols"), {
                    style: {
                        position: "absolute",
                        top: 0,
                        left: config.scroll.left + "px",
                        height: "100%",
                    },
                }, fixedCols),
        ]),
        (0, dom_1.el)("div", { style: { width: $totalWidth }, role: "presentation" }),
    ]);
}
exports.getFixedRows = getFixedRows;
function getFixedDataRows(config, layout, mode) {
    if ((mode === types_1.Split.top && typeof config.topSplit !== "number") ||
        (mode === types_1.Split.bottom && typeof config.bottomSplit !== "number")) {
        return;
    }
    var $totalWidth = config.$totalWidth, topSplit = config.topSplit, bottomSplit = config.bottomSplit, $positions = config.$positions, data = config.data, $totalHeight = config.$totalHeight, $width = config.$width, headerHeight = config.headerHeight, footerHeight = config.footerHeight, $scrollBarWidth = config.$scrollBarWidth;
    var isBottomSplit = mode === types_1.Split.bottom;
    var splitedData = isBottomSplit ? config.fixedRows.bottom : config.fixedRows.top;
    var $renderFrom = isBottomSplit ? "bottomFixedRows" : "topFixedRows";
    var fixedRows = (0, Cells_1.getCells)(__assign(__assign({}, config), { data: splitedData, $renderFrom: $renderFrom, $positions: __assign(__assign({}, $positions), { yStart: 0, yEnd: isBottomSplit ? bottomSplit : topSplit }) }));
    var fixedRowsHeight = splitedData.reduce(function (acc, item) { return acc + item.$height; }, 0);
    var spans = (0, Cells_1.getSpans)(__assign(__assign({}, config), { $renderFrom: $renderFrom, data: data }), isBottomSplit ? types_1.Split.bottom : types_1.Split.top);
    var bottomSplitHeight = (0, main_1.getTotalHeight)(config.fixedRows.bottom);
    var getCols = function (split) {
        return ((0, FixedCols_1.getFixedCols)(__assign(__assign({}, config), { headerHeight: 0, data: splitedData, $renderFrom: $renderFrom, scroll: __assign(__assign({}, config.scroll), { top: -1 }), $positions: __assign(__assign({}, $positions), { yStart: 0, yEnd: isBottomSplit ? bottomSplit : topSplit }), $totalHeight: fixedRowsHeight, $data: data }), __assign(__assign({}, layout), { shifts: __assign(__assign({}, layout.shifts), { y: 0 }) }), split, mode) || []);
    };
    var fixedCols = __spreadArray(__spreadArray([], getCols(types_1.Split.left), true), getCols(types_1.Split.right), true);
    return [
        (0, dom_1.el)(".dhx_grid-fixed-data-rows-wrap", {
            class: isBottomSplit ? "dhx_grid__rows_bottom--fixed" : "",
            style: {
                top: isBottomSplit
                    ? $totalHeight + headerHeight + footerHeight <
                        layout.wrapper.height - $scrollBarWidth.x - BORDERS
                        ? $totalHeight + headerHeight - bottomSplitHeight + BORDERS / 2
                        : layout.wrapper.height -
                            bottomSplitHeight -
                            footerHeight -
                            BORDERS / 2 -
                            $scrollBarWidth.x
                    : headerHeight,
                overflow: "hidden",
                height: fixedRowsHeight > layout.wrapper.height ? layout.wrapper.height : fixedRowsHeight,
                width: $totalWidth + $scrollBarWidth.y + BORDERS < $width
                    ? $totalWidth
                    : $width - $scrollBarWidth.y - BORDERS,
            },
        }, __spreadArray(__spreadArray([
            (0, dom_1.el)(".dhx_grid-fixed-cols", __assign(__assign({ onwheel: main_1.scrollFixedColsAndRows, style: {
                    left: -config.scroll.left + "px",
                    paddingLeft: layout.shifts.x,
                    position: "absolute",
                    width: $totalWidth,
                }, _flags: dom_1.KEYED_LIST }, (0, Cells_1.getHandlers)(0, $positions.xStart, config)), getRowAriaAttrs(data.length)), [
                (0, dom_1.el)(".dhx_grid-fixed-rows", {
                    class: config.rightSplit ? "dhx_grid__rows_right--fixed" : "",
                }, __spreadArray(__spreadArray([], fixedRows, true), [spans && (0, dom_1.el)(".dhx_span-spans", { role: "presentation" }, [spans])], false)),
            ])
        ], fixedCols, true), [
            config.bottomSplit ? (0, dom_1.el)(".dhx_grid__rows-border--frozen", { role: "presentation" }) : null,
        ], false)),
    ];
}
exports.getFixedDataRows = getFixedDataRows;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Toolbar = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(3);
var ts_message_1 = __webpack_require__(11);
var ts_navbar_1 = __webpack_require__(21);
var Toolbar = /** @class */ (function (_super) {
    __extends(Toolbar, _super);
    function Toolbar(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            navigationType: "click",
            $name: "toolbar",
        }, config)) || this;
        _this._currentRoot = null;
        var render = function () { return _this._draw(element); };
        _this.mount(element, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Toolbar.prototype.getState = function (id) {
        if ((0, core_1.isDefined)(id) && !this.data.getItem(id)) {
            return;
        }
        var state = {};
        this.data.eachChild(this.data.getRoot(), function (item) {
            if (item.twoState && !item.group) {
                state[item.id] = item.active;
            }
            else if (item.type === "input" ||
                item.type === "selectButton" ||
                item.type === "datePicker") {
                state[item.id] = item.value;
            }
        }, false);
        for (var key in this._groups) {
            if (this._groups[key].active) {
                state[key] = this._groups[key].active;
            }
        }
        if ((0, core_1.isId)(id)) {
            return state[id];
        }
        return state;
    };
    Toolbar.prototype.setState = function (state) {
        var _a;
        var _loop_1 = function (key) {
            if (this_1._groups && this_1._groups[key]) {
                if (this_1._groups[key].active) {
                    this_1.data.update(this_1._groups[key].active, { active: false });
                    this_1._groups[key].active = state[key];
                    this_1.data.update(state[key], { active: true });
                }
            }
            else {
                var item = this_1.data.getItem(key);
                switch (item.type) {
                    case "input":
                        this_1.data.update(key, { value: state[key] });
                        break;
                    case "selectButton":
                        {
                            var selected = (_a = item.items) === null || _a === void 0 ? void 0 : _a.find(function (option) { return option.value === state[key]; });
                            this_1.data.update(key, { value: state[key], icon: selected === null || selected === void 0 ? void 0 : selected.icon });
                        }
                        break;
                    case "datePicker":
                        if (item.$calendar) {
                            item.$calendar.setValue(state[key]);
                        }
                        else {
                            this_1.data.update(key, { value: state[key] });
                        }
                        break;
                    default:
                        this_1.data.update(key, { active: state[key] });
                }
            }
        };
        var this_1 = this;
        for (var key in state) {
            _loop_1(key);
        }
    };
    Toolbar.prototype.setFocus = function (id) {
        if (!this.data.getItem(id) || this.data.getItem(id).type !== "input") {
            return;
        }
        var inputEl = this.getRootNode().querySelector("[data-dhx-id=\"".concat(id, "\"]"));
        if (!inputEl) {
            return;
        }
        inputEl.focus();
    };
    Toolbar.prototype._customHandlers = function () {
        var _this = this;
        return {
            input: function (e) {
                var id = (0, html_1.locate)(e);
                var item = _this.data.getItem(id);
                if (!item)
                    return;
                var value = e.target.value;
                _this.data.update(id, { value: value });
                if (item.type === "input") {
                    _this.events.fire(ts_navbar_1.NavigationBarEvents.input, [id, value]);
                }
            },
            tooltip: function (e) {
                var elem = (0, html_1.locateNode)(e);
                if (!elem) {
                    return;
                }
                var id = elem.getAttribute("data-dhx-id");
                var item = _this.data.getItem(id);
                if (item === null || item === void 0 ? void 0 : item.tooltip) {
                    (0, ts_message_1.tooltip)(item.tooltip, {
                        node: elem,
                        position: ts_message_1.Position.bottom,
                    });
                }
            },
        };
    };
    Toolbar.prototype._getFactory = function () {
        return (0, ts_navbar_1.createFactory)({
            widget: this,
            defaultType: "navItem",
            allowedTypes: [
                "button",
                "imageButton",
                "selectButton",
                "navItem",
                "menuItem",
                "separator",
                "spacer",
                "title",
                "input",
                "customHTML",
                "datePicker",
                "customHTMLButton",
            ],
            widgetName: "toolbar",
        });
    };
    Toolbar.prototype._draw = function (element) {
        var _this = this;
        var getAriaAttrs = function (element) { return ({
            role: "toolbar",
            "aria-label": element || "", // to differ toolbars if there are 2 or more on page
        }); };
        var toolbarHeight = this.data.getLength()
            ? this.data.reduce(function (result, item) {
                switch (item.type) {
                    case "title":
                        return !result ? 20 : result;
                    case "button":
                        return item.size === "small" && (!result || result <= 28) ? 28 : result || 32;
                    default:
                        return 32;
                }
            }, 0) + 24
            : null;
        return (0, dom_1.el)("nav.dhx_widget.dhx_toolbar", {
            style: { height: toolbarHeight },
            class: this.config.css ? this.config.css : "",
        }, [
            (0, dom_1.el)("ul.dhx_navbar.dhx_navbar--horizontal", __assign(__assign({ "data-dhx-widget-id": this._uid, tabindex: 0 }, getAriaAttrs(element)), { onclick: this._handlers.onclick, onmousedown: this._handlers.onmousedown, oninput: this._handlers.input, onmouseover: this._handlers.tooltip, onkeydown: this._handlers.onkeydown, _hooks: {
                    didInsert: function (node) {
                        node.el.addEventListener("keyup", function (e) {
                            if (e.which !== 9) {
                                return;
                            }
                            var elem = (0, html_1.locateNode)(document.activeElement);
                            if (!elem) {
                                return;
                            }
                            var id = elem.getAttribute("data-dhx-id");
                            var item = _this.data.getItem(id);
                            if (item === null || item === void 0 ? void 0 : item.tooltip) {
                                (0, ts_message_1.tooltip)(item.tooltip, {
                                    node: elem,
                                    position: ts_message_1.Position.bottom,
                                    force: true,
                                });
                            }
                        }, true);
                    },
                } }), this.data.map(function (item) { return _this._factory(item); }, this.data.getRoot(), false)),
        ]);
    };
    Toolbar.prototype._getMode = function (item, root) {
        return item.id === root ? "bottom" : "right";
    };
    Toolbar.prototype._close = function (e) {
        this._activePosition = null;
        this._currentRoot = null;
        _super.prototype._close.call(this, e);
    };
    Toolbar.prototype._setRoot = function (id) {
        if (this.data.getParent(id) === this.data.getRoot()) {
            this._currentRoot = id;
        }
    };
    return Toolbar;
}(ts_navbar_1.Navbar));
exports.Toolbar = Toolbar;


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.palette = exports.grayShades = void 0;
exports.grayShades = [
    "#000000",
    "#4C4C4C",
    "#666666",
    "#808080",
    "#999999",
    "#B3B3B3",
    "#CCCCCC",
    "#E6E6E6",
    "#F2F2F2",
    "#FFFFFF",
];
exports.palette = [
    ["#D4DAE4", "#B0B8CD", "#949DB1", "#727A8C", "#5E6677", "#3F4757", "#1D2534"],
    ["#FFCDD2", "#FE9998", "#F35C4E", "#E94633", "#D73C2D", "#CA3626", "#BB2B1A"],
    ["#F9E6AD", "#F4D679", "#EDB90F", "#EAA100", "#EA8F00", "#EA7E00", "#EA5D00"],
    ["#BCE4CE", "#90D2AF", "#33B579", "#36955F", "#247346", "#1D5B38", "#17492D"],
    ["#BDF0E9", "#92E7DC", "#02D7C5", "#11B3A5", "#018B80", "#026B60", "#024F43"],
    ["#B3E5FC", "#81D4FA", "#29B6F6", "#039BE5", "#0288D1", "#0277BD", "#01579B"],
    ["#AEC1FF", "#88A3F9", "#5874CD", "#2349AE", "#163FA2", "#083596", "#002381"],
    ["#C5C0DA", "#9F97C1", "#7E6BAD", "#584A8F", "#4F4083", "#473776", "#3A265F"],
    ["#D6BDCC", "#C492AC", "#A9537C", "#963A64", "#81355A", "#6E3051", "#4C2640"],
    ["#D2C5C1", "#B4A09A", "#826358", "#624339", "#5D4037", "#4E342E", "#3E2723"],
];


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorpickerEvents = void 0;
var ColorpickerEvents;
(function (ColorpickerEvents) {
    ColorpickerEvents["beforeChange"] = "beforeChange";
    ColorpickerEvents["change"] = "change";
    ColorpickerEvents["apply"] = "apply";
    ColorpickerEvents["cancelClick"] = "cancelClick";
    ColorpickerEvents["modeChange"] = "modeChange";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ColorpickerEvents["selectClick"] = "selectClick";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ColorpickerEvents["colorChange"] = "colorChange";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ColorpickerEvents["viewChange"] = "viewChange";
})(ColorpickerEvents || (exports.ColorpickerEvents = ColorpickerEvents = {}));


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chart = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var view_1 = __webpack_require__(8);
var ts_data_1 = __webpack_require__(7);
var ComposeLayer_1 = __webpack_require__(186);
var Legend_1 = __webpack_require__(85);
var types_1 = __webpack_require__(25);
var index_1 = __webpack_require__(189);
var index_2 = __webpack_require__(87);
var Stacker_1 = __webpack_require__(92);
var common_1 = __webpack_require__(5);
var Tooltip_1 = __webpack_require__(203);
var core_1 = __webpack_require__(1);
var Export_1 = __webpack_require__(204);
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart(node, config) {
        if (config === void 0) { config = {}; }
        var _this = this;
        var _a;
        _this = _super.call(this, null, config) || this;
        // using zero values ensure that widget will not attempt to render self in the hidden state
        _this._width = 0;
        _this._height = 0;
        _this._left = 0;
        _this._top = 0;
        var dataConfig = {};
        if (config.maxPoints) {
            dataConfig.approximate = {
                value: (_a = config.series) === null || _a === void 0 ? void 0 : _a.map(function (a) { return a.value; }),
                maxNum: config.maxPoints,
            };
        }
        if (Array.isArray(config.data)) {
            _this.events = new events_1.EventSystem(_this);
            _this.data =
                config.type === "treeMap"
                    ? new ts_data_1.TreeCollection(dataConfig, _this.events)
                    : new ts_data_1.DataCollection(dataConfig, _this.events);
            _this.data.parse(config.data);
        }
        else if (config.data && config.data.events) {
            _this.data = config.data;
            _this.events = _this.data.events;
            _this.events.context = _this;
        }
        else {
            _this.events = new events_1.EventSystem(_this);
            _this.data =
                config.type === "treeMap"
                    ? new ts_data_1.TreeCollection(dataConfig, _this.events)
                    : new ts_data_1.DataCollection(dataConfig, _this.events);
        }
        _this._globalHTMLHandlers = {
            onmousemove: function (e) {
                var _a = _this._layers.getSizes(), left = _a.left, top = _a.top, bottom = _a.bottom, right = _a.right;
                var pageX = e.pageX, pageY = e.pageY;
                var rects = _this.getRootView().node.el.getBoundingClientRect();
                _this._left = rects.left + window.pageXOffset;
                _this._top = rects.top + window.pageYOffset;
                var x = pageX - left - _this._left;
                var y = pageY - top - _this._top;
                if (x >= 0 && x <= _this._width - right - left && y >= 0 && y <= _this._height - bottom - top) {
                    _this.events.fire(types_1.ChartEvents.chartMouseMove, [x, y, _this._left + left, _this._top + top]);
                }
                else {
                    _this.events.fire(types_1.ChartEvents.chartMouseLeave);
                }
            },
            onmouseleave: function () { return _this.events.fire(types_1.ChartEvents.chartMouseLeave); },
        };
        _this._layers = new ComposeLayer_1.ComposeLayer();
        _this.setConfig(config);
        _this._initEvents();
        _this._tooltip = new Tooltip_1.Tooltip(_this);
        var render = function () {
            if (!_this.data.getLength()) {
                return (0, dom_1.el)("div");
            }
            var getChartAriaLabel = function (config) {
                /*  Full example (without symbols of new line):
                    Type chart "Title". X/Y Scale Name: bottom axis from Min to Max. Scale Name: left axis Name from Min to Max.
                    Series: seria A, seria B, seria C, ...
                 */
                var scales = _this._scales;
                var series = config.series;
                var type = config.type;
                if (!type) {
                    // scatter chart
                    type = series && series.length && series[0] ? series[0].type || "" : "";
                }
                var label = "".concat(type || "", " chart.");
                var getAxisName = function (cfg) { return (cfg._isXDirection ? "X" : "Y"); };
                var getAxisTitle = function (cfg) { return cfg.title || cfg.text || cfg.value || ""; };
                var getAxisMin = function (cfg) { return (cfg.steps && cfg.steps.length ? cfg.steps[0] : cfg.min || 0); };
                var getAxisMax = function (cfg) {
                    return cfg.steps && cfg.steps.length
                        ? cfg.steps[cfg.steps.length - 1]
                        : cfg.max || cfg.maxPoints || "max";
                };
                var getRadialAxisValue = function (attr, point) { return point[attr]; };
                if (scales) {
                    Object.keys(scales).forEach(function (direction) {
                        var scale = scales[direction];
                        var cfg = scale._axis || scale.config;
                        if (direction === "radial") {
                            var xData = scale._data._order;
                            label += " X scale ".concat(getAxisTitle(scale.config), ": ").concat(direction, " axis from ").concat(getRadialAxisValue(scale.config.value, xData[0]), " to ").concat(getRadialAxisValue(scale.config.value, xData[xData.length - 1]), ".");
                            label += " ".concat(getAxisName(scale), " scale: axis from ").concat(getAxisMin(cfg), " to ").concat(getAxisMax(cfg), ".");
                        }
                        else {
                            label += " ".concat(getAxisName(scale), " scale ").concat(getAxisTitle(scale.config), ": ").concat(direction, " axis from ").concat(getAxisMin(cfg), " to ").concat(getAxisMax(cfg), ".");
                        }
                    });
                }
                if (series && series.length) {
                    label += " Series:";
                    series.forEach(function (seria, index) {
                        label += " ".concat(type === "pie" || type === "pie3D" || type === "donut" ? seria.text : seria.value);
                        label += index === series.length - 1 ? "." : ",";
                    });
                }
                return label;
            };
            var getChartAriaAttrs = function (config) { return ({
                "aria-label": getChartAriaLabel(config),
            }); };
            var content = [
                (0, dom_1.resizer)(function (x, y) {
                    _this._width = x;
                    _this._height = y || 400; // if height is not provided, use default value
                    var view = _this.getRootView();
                    if (view && view.node && view.node.el) {
                        var rects = view.node.el.getBoundingClientRect();
                        _this._left = rects.left + window.pageXOffset;
                        _this._top = rects.top + window.pageYOffset;
                    }
                    _this.events.fire(types_1.ChartEvents.resize, [_this._width, _this._height]);
                    _this.paint();
                    if (!document.querySelector(".dhx_widget.dhx_chart") && _this._tooltip) {
                        _this._tooltip.destructor();
                    }
                }),
            ];
            if (_this._width && _this._height) {
                content.push(_this._layers.toVDOM(_this._width, _this._height));
            }
            return (0, dom_1.el)(".dhx_widget.dhx_chart", __assign(__assign({ class: config.css ? config.css : "", onmousemove: _this._globalHTMLHandlers.onmousemove, onmouseleave: _this._globalHTMLHandlers.onmouseleave }, getChartAriaAttrs(config)), { tabIndex: 0 }), content);
        };
        var view = (0, dom_1.create)({
            render: render,
            hooks: {
                didMount: function (vm) {
                    if (vm && vm.node && vm.node.parent && vm.node.parent.el) {
                        _this._width = vm.node.parent.el.offsetWidth;
                        _this._height = vm.node.parent.el.offsetHeight || 400;
                        _this.paint();
                    }
                },
            },
        });
        _this.mount(node, view);
        _this.export = new Export_1.Exporter("chart", _this);
        return _this;
    }
    Chart.prototype.getSeries = function (key) {
        return this._series[key];
    };
    Chart.prototype.eachSeries = function (handler) {
        var result = [];
        for (var key in this._series) {
            result.push(handler.call(this, this._series[key]));
        }
        return result;
    };
    Chart.prototype.destructor = function () {
        this._tooltip.destructor();
        this.events.clear();
        this.unmount();
    };
    Chart.prototype.setConfig = function (config) {
        var _this = this;
        var _a;
        if (config.type === "calendarHeatMap") {
            throw new TypeError("The calendarHeatMap chart type is a pro functionality");
        }
        this.config = config;
        this._layers.clear();
        this._series = {};
        this._scales = {};
        var min;
        // let baseLine;
        if (config.scales) {
            for (var key in config.scales) {
                var scale = __assign({}, config.scales[key]);
                if (config.scales[key].min !== undefined) {
                    min = config.scales[key].min;
                }
                scale.type = scale.type || this._detectScaleType(scale, key);
                if (config.scales.radial && key !== "radial") {
                    scale.hidden = true;
                }
                this._setScale(scale, key);
            }
        }
        var stack = new Stacker_1.default();
        this._layers.add(stack);
        (_a = config.series) === null || _a === void 0 ? void 0 : _a.forEach(function (cfg, ind) {
            var _a, _b, _c, _d;
            if (cfg.baseLine !== undefined && cfg.baseLine < min) {
                cfg.baseLine = undefined;
            }
            var serieConfig = __assign({}, cfg);
            serieConfig.type = serieConfig.type || config.type;
            switch (serieConfig.type) {
                case "bar":
                case "xbar":
                case "area":
                case "splineArea":
                    if (!serieConfig.color)
                        serieConfig.color = serieConfig.fill || (0, common_1.getDefaultColor)(ind);
                    if (!serieConfig.fill)
                        serieConfig.fill = serieConfig.color || (0, common_1.getDefaultColor)(ind);
                    break;
                case "treeMap":
                    serieConfig.legendType = ((_a = config.legend) === null || _a === void 0 ? void 0 : _a.type) || "groupName";
                    (_c = (_b = config.legend) === null || _b === void 0 ? void 0 : _b.treeSeries) === null || _c === void 0 ? void 0 : _c.map(function (serie, index) {
                        var _a, _b;
                        serie.active = (_a = serie.active) !== null && _a !== void 0 ? _a : true;
                        serie.id = (_b = serie.id) !== null && _b !== void 0 ? _b : (0, core_1.uid)();
                        if (!serie.color)
                            serie.color = (0, common_1.getDefaultColor)(index, serieConfig.legendType === "range");
                    });
                    serieConfig.treeSeries = (_d = config.legend) === null || _d === void 0 ? void 0 : _d.treeSeries;
                    break;
                case "scatter":
                    if (!serieConfig.pointColor)
                        serieConfig.pointColor = serieConfig.color || (0, common_1.getDefaultColor)(ind);
                    break;
            }
            var chartFactory = index_2.default[serieConfig.type];
            if (serieConfig.barWidth || _this.config.barWidth) {
                serieConfig.barWidth = serieConfig.barWidth || _this.config.barWidth;
            }
            var chart = new chartFactory(_this.data, serieConfig, _this.events);
            var scales = (0, common_1.getScales)(config.scales);
            var chartScales = scales.length > 1 && scales[0] !== "radial"
                ? scales
                : scales[0] === "radial"
                    ? scales
                    : ["bottom", "left"];
            chartScales.forEach(function (type) {
                var scale = _this._scales[type];
                if (!scale) {
                    return;
                }
                chart.addScale(type, scale);
                if (!serieConfig.stacked) {
                    scale.add(chart);
                }
                else {
                    scale.add(stack);
                }
            });
            _this._series[chart.id] = chart;
            if (serieConfig.stacked) {
                stack.add(chart);
            }
            else {
                _this._layers.add(chart);
            }
        });
        if (config.legend) {
            var legendConfig = __assign({}, config.legend);
            if (legendConfig.series) {
                legendConfig.$seriesInfo = legendConfig.series.map(function (id) { return _this._series[id]; });
            }
            var legend = new Legend_1.Legend(this.data, legendConfig, this.events);
            this._layers.add(legend);
        }
        this.paint();
    };
    Chart.prototype._setScale = function (config, position) {
        if (!config.type)
            return;
        var scale = new index_1.default[config.type](this.data, config, position);
        if (scale.config.type !== "radial") {
            this._layers.add(scale.scaleGrid());
        }
        this._layers.add(scale);
        this._scales[position] = scale;
    };
    Chart.prototype._detectScaleType = function (config, key) {
        if (key === "radial") {
            return key;
        }
        if (config.text) {
            return "text";
        }
        return "numeric";
    };
    Chart.prototype._initEvents = function () {
        var _this = this;
        // hide/show series on legend click
        this.events.on(types_1.ChartEvents.toggleSeries, function (id, pieLike) {
            if (_this.config.type === "treeMap") {
                Object.values(_this._series)[0].toggle(id);
                _this.paint();
            }
            else if (pieLike) {
                var serie = _this._series[Object.keys(_this._series)[0]];
                if (serie) {
                    serie.toggle(id);
                    _this.paint();
                }
            }
            else if (_this._series[id]) {
                _this._series[id].toggle();
                _this.paint();
            }
        }, this);
        // repaint on data change
        this.events.on(ts_data_1.DataEvents.change, function () { return _this.paint(); });
        this.events.on(ts_data_1.DataEvents.filter, function () { return _this.paint(); });
    };
    return Chart;
}(view_1.View));
exports.Chart = Chart;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Legend = void 0;
var ts_data_1 = __webpack_require__(7);
var types_1 = __webpack_require__(25);
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
var legend_1 = __webpack_require__(188);
var core_1 = __webpack_require__(1);
function getDefaultMargin(halign, valign, isTreeMap, form) {
    switch (valign) {
        case "middle": {
            switch (halign) {
                case "right":
                    return isTreeMap ? 20 : 60;
                case "left":
                    return 120;
                case "center":
                    throw new Error("cant place legend on center, middle");
            }
        }
        // eslint-disable-next-line no-fallthrough
        case "top":
            return 20;
        case "bottom":
            return isTreeMap || form === "line" ? 20 : 60;
    }
}
var Legend = /** @class */ (function () {
    function Legend(_data, config, _events) {
        var _this = this;
        this._data = _data;
        this._events = _events;
        var defaults = {
            form: "rect",
            itemPadding: 20,
            halign: "right",
            valign: "top",
            direction: "row",
            type: "groupName",
        };
        this.config = __assign(__assign({}, defaults), config);
        this.config.margin =
            config.margin ||
                getDefaultMargin(this.config.halign, this.config.valign, (0, ts_data_1.isTreeCollection)(this._data), this.config.form);
        this._handlers = {
            onclick: function (id, pieLike) {
                return _this._events.fire(types_1.ChartEvents.toggleSeries, [id, pieLike]);
            },
            onkeyup: function (id, pieLike, event) {
                // FIXME: set handler correctly according app code style
                event.preventDefault();
                // enter or space
                if (event.key === "Enter" || event.key === " ") {
                    _this._events.fire(types_1.ChartEvents.toggleSeries, [id, pieLike]);
                }
            },
        };
    }
    Legend.prototype.scaleReady = function (sizes) {
        var isColumnInCorner = this.config.direction === "column" &&
            (this.config.halign === "left" || this.config.halign === "right");
        switch (this.config.valign) {
            case "middle":
                if (this.config.halign === "right") {
                    sizes.right += this.config.size >= 0 ? this.config.size : 200;
                }
                else if (this.config.halign === "left") {
                    sizes.left += this.config.size >= 0 ? this.config.size : 200;
                }
                break;
            case "top":
                if (isColumnInCorner) {
                    sizes[this.config.halign] += this.config.size >= 0 ? this.config.size : 200;
                }
                else {
                    sizes.top += this.config.size >= 0 ? this.config.size : 40;
                }
                break;
            case "bottom":
                if (isColumnInCorner) {
                    sizes[this.config.halign] += this.config.size >= 0 ? this.config.size : 200;
                }
                else {
                    sizes.bottom += this.config.size >= 0 ? this.config.size : 40;
                }
                break;
        }
    };
    Legend.prototype.paint = function (width, height) {
        var _this = this;
        var getLegendAriaAttrs = function (item) { return ({
            role: "button",
            "aria-label": item.active ? "Hide chart ".concat(item.text) : "Show chart ".concat(item.text),
        }); };
        var data = this._getData();
        var config = this.config;
        config.$sizes = {
            width: 0,
            height: 0,
        };
        var positionX;
        var positionY;
        var font = (0, common_1.getFontStyle)("legend-text");
        var figureWidth = 10; // get Figure width from config ??
        var lineWidth = 500; // get Figure width from config ??
        var margin = config.margin, itemPadding = config.itemPadding;
        var svg = [];
        var isMid = config.valign === "middle";
        var xPadding = 0;
        var yPadding = 0;
        var xPaddingMax = 0;
        var yPaddingMax = 0;
        data.forEach(function (item, index) {
            if (!isMid && config.direction === "row") {
                var textWidth = (0, common_1.getTextWidth)(item.text, font);
                if (xPadding + textWidth + figureWidth * 1.5 > width && index !== 0) {
                    xPadding = 0;
                    yPadding += itemPadding + 2;
                }
            }
            svg.push((0, dom_1.sv)("g", __assign(__assign({ transform: "translate(".concat(xPadding, ",").concat(yPadding, ")"), onclick: [_this._handlers.onclick, item.id, _this.config.values], onkeyup: [_this._handlers.onkeyup, item.id, _this.config.values], class: "legend-item ".concat(!item.active ? "not-active" : "") }, getLegendAriaAttrs(item)), { tabindex: 0 }), [
                (0, dom_1.sv)("text", {
                    x: item.maxValue ? 0 : figureWidth / 2 + 5,
                    y: 0,
                    class: "start-text legend-text",
                }, [(0, common_1.verticalCenteredText)(item.text)]),
                [
                    (0, legend_1.legendShape)(config.form, item),
                    !isNaN(item.maxValue) && !isNaN(item.minValue) && (0, legend_1.legendTicks)(config.form, item),
                ],
            ]));
            var itemWidth = config.form !== "line" ? figureWidth * 1.5 + (0, common_1.getTextWidth)(item.text, font) : 0;
            if (!isMid && config.direction === "row") {
                xPadding += itemWidth + itemPadding;
                xPaddingMax = xPaddingMax > xPadding ? xPaddingMax : xPadding;
            }
            else {
                xPadding = 0;
                xPaddingMax = xPaddingMax > itemWidth ? xPaddingMax : itemWidth;
                yPadding += itemPadding + 2;
                yPaddingMax = yPaddingMax > yPadding ? yPaddingMax : yPadding;
            }
        });
        switch (config.valign) {
            case "top":
                if (config.direction === "row") {
                    positionY = -margin - yPadding - figureWidth / 2 - (config.form === "line" ? 15 : 0);
                }
                else {
                    positionY =
                        config.halign === "center"
                            ? -yPaddingMax + figureWidth / 2
                            : margin + figureWidth / 2;
                }
                break;
            case "middle":
                positionY = (height - yPaddingMax) / 2 + itemPadding / 2;
                break;
            case "bottom":
                if (config.direction === "row") {
                    positionY = height + (config.form !== "line" ? margin : 10);
                }
                else {
                    positionY =
                        height + figureWidth - (config.halign === "center" ? 0 : margin + yPaddingMax);
                }
                break;
        }
        switch (config.halign) {
            case "left":
                positionX = isMid
                    ? -xPaddingMax
                    : figureWidth / 2 - (config.direction === "row" ? 0 : config.size || 200);
                break;
            case "center":
                positionX = (width - xPaddingMax - (config.form === "line" ? lineWidth : 0)) / 2;
                break;
            case "right":
                if (isMid) {
                    positionX = width + margin + figureWidth / 2;
                }
                else if (config.direction === "row") {
                    positionX =
                        width -
                            xPaddingMax +
                            itemPadding +
                            (config.form === "line" ? -lineWidth - margin : figureWidth / 2);
                }
                else {
                    positionX = width + margin + figureWidth / 2;
                }
                break;
        }
        return (0, dom_1.sv)("g", {
            transform: "translate(".concat(positionX > 0 ? positionX : 0, ", ").concat(positionY, ")"),
            "aria-label": "Legend",
            tabindex: 0,
        }, svg);
    };
    Legend.prototype._getData = function () {
        var drawData = [];
        if (this.config.type === "scale") {
            var _a = this.config.values, color = _a.color, positiveColor = _a.positiveColor, negativeColor = _a.negativeColor, text = _a.text, minValue = _a.minValue, maxValue = _a.maxValue, tick = _a.tick, majorTick = _a.majorTick, step = _a.step, tickTemplate = _a.tickTemplate;
            var _b = this.setCriticals(), minValueCalc = _b[0], maxValueCalc = _b[1];
            drawData.push({
                id: (0, core_1.uid)(),
                text: text,
                alpha: 1,
                fill: color,
                minValue: minValue !== null && minValue !== void 0 ? minValue : minValueCalc,
                maxValue: maxValue !== null && maxValue !== void 0 ? maxValue : maxValueCalc,
                positiveColor: positiveColor,
                negativeColor: negativeColor,
                active: true,
                tick: tick,
                majorTick: majorTick,
                step: step,
                tickTemplate: tickTemplate,
            });
        }
        else if (this.config.values) {
            var text_1 = (0, common_1.locator)(this.config.values.text);
            var fill_1 = (0, common_1.locator)(this.config.values.color);
            this._data.map(function (item, index) {
                drawData.push({
                    id: item.id,
                    text: text_1(item).toString(),
                    alpha: 1,
                    fill: fill_1(item).toString() || (0, common_1.getDefaultColor)(index),
                    active: !item.$hidden,
                });
            });
        }
        else if (this.config.treeSeries) {
            var series = this.config.treeSeries;
            if (this.config.type === "groupName") {
                series.forEach(function (serie) {
                    drawData.push({
                        id: serie.id,
                        text: serie.name || serie.id,
                        alpha: 1,
                        fill: serie.color,
                        active: serie.active,
                    });
                });
            }
            else {
                var getText_1 = function (serie) {
                    if (serie.from && serie.to)
                        return "".concat(serie.from, " - ").concat(serie.to);
                    if (serie.less)
                        return "<= ".concat(serie.less);
                    if (serie.greater)
                        return ">= ".concat(serie.greater);
                };
                series.forEach(function (serie) {
                    drawData.push({
                        id: serie.id,
                        text: getText_1(serie),
                        alpha: 1,
                        fill: serie.color,
                        active: serie.active,
                    });
                });
            }
        }
        else {
            var series = this.config.$seriesInfo;
            for (var _i = 0, _c = series; _i < _c.length; _i++) {
                var serie = _c[_i];
                var _d = serie.config, fill = _d.fill, color = _d.color, id = _d.id, alpha = _d.alpha, active = _d.active, label = _d.label, value = _d.value;
                var useColor = fill && color;
                var text = label && typeof label === "function" ? label(serie.config) : label || value;
                drawData.push({
                    id: id,
                    text: text,
                    fill: fill || color,
                    color: useColor && color,
                    active: active,
                    alpha: alpha,
                });
            }
        }
        return drawData;
    };
    Legend.prototype.setCriticals = function () {
        var value = this.config.values.value;
        var min;
        var max;
        this._data.forEach(function (item) {
            if (item[value]) {
                min = !min || item[value] < min ? item[value] : min;
                max = !max || item[value] > max ? item[value] : max;
            }
        });
        max = Math.ceil(max / 10) * 10;
        min = Math.floor(min / 10) * 10;
        if (min === max)
            min -= 10;
        return [min, max];
    };
    return Legend;
}());
exports.Legend = Legend;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rightGrid = exports.right = exports.leftGrid = exports.left = exports.topGrid = exports.top = exports.bottomGrid = exports.bottom = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
var defaultTextTemplate = function (item) { return item.toString(); };
var getScaleAriaAttrs = function (axis, text) { return ({
    role: "graphics-object",
    "aria-label": "".concat(axis, "-axis").concat(text ? ", " + text : ""),
}); };
function bottom(points, config, width, height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        extraTittlePadding = textPadding;
        var canRotate_1 = scaleRotate && !isNaN(scaleRotate);
        var y_1 = height + textPadding;
        text = points.map(function (p) {
            var x = p[0];
            var transform = canRotate_1 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y_1, ")") : "";
            var classList = ["scale-text", "top-text"];
            if (canRotate_1) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("bottom", angle));
            }
            return (0, dom_1.sv)("text", { x: x, y: y_1, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(template(p[1])),
            ]);
        });
    }
    var id = (0, core_1.uid)();
    var svTitle = null;
    var mainLine = (0, dom_1.sv)("path", {
        class: "main-scale",
        d: "M0 ".concat(height, " H").concat(width - 0.5),
        id: id,
    });
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: width / 2, dy: scalePadding + extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title " }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("x", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.bottom = bottom;
function bottomGrid(points, width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine, targetValue = config.targetValue;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "", " ").concat(!grid ? "hidden-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === 0 && !config.hidden) {
            continue;
        }
        if (i === targetLine) {
            var d_1 = "M".concat(points[i][0], " 0 V ").concat(height);
            var path_1 = (0, dom_1.sv)("path", { d: d_1, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path_1);
            continue;
        }
        var d = "M".concat(points[i][0], " 0 V ").concat(height);
        var path = (0, dom_1.sv)("path", { d: d, class: className, _ref: "line" + Math.round(points[i][0]) });
        gridLines.push(path);
        if (i === len - 1 && points[i][0] !== width) {
            var additionD = "M".concat(width, " 0 V ").concat(height);
            var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
            gridLines.push(additionPath);
        }
    }
    if (targetValue) {
        var d = "M".concat(targetValue * width, " 0 V ").concat(height);
        var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
        gridLines.push(path);
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.bottomGrid = bottomGrid;
function top(points, config, width, _height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        extraTittlePadding = textPadding;
        var canRotate_2 = scaleRotate && !isNaN(scaleRotate);
        var y_2 = -textPadding;
        text = points.map(function (p) {
            var classList = ["scale-text"];
            var x = p[0];
            var transform = canRotate_2 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y_2, ")") : "";
            if (canRotate_2) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("top", angle));
            }
            return (0, dom_1.sv)("text", { x: x, y: y_2, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(template(p[1])),
            ]);
        });
    }
    var id = (0, core_1.uid)();
    var mainLine = (0, dom_1.sv)("path", { d: "M0 0 H".concat(width), class: "main-scale", id: id });
    var svTitle = null;
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: width / 2, dy: -scalePadding - extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title" }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("x", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.top = top;
function topGrid(points, _width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "", " ").concat(!grid ? "hidden-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === 0 && !config.hidden) {
            continue;
        }
        if (i === targetLine) {
            var d_2 = "M".concat(points[i][0], " 0 V ").concat(height);
            var path_2 = (0, dom_1.sv)("path", { d: d_2, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path_2);
            continue;
        }
        var d = "M".concat(points[i][0], " 0 V ").concat(height);
        var path = (0, dom_1.sv)("path", { d: d, class: className, _ref: "line" + Math.round(points[i][0]) });
        gridLines.push(path);
        if (i === len - 1 && points[i][0] !== 0) {
            var additionD = "M0 0 V ".concat(height);
            var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
            gridLines.push(additionPath);
        }
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.topGrid = topGrid;
function left(points, config, _width, height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        var style_1 = (0, common_1.getFontStyle)("scale-text");
        var maxTextWidth_1 = 0;
        var canRotate_3 = scaleRotate && !isNaN(scaleRotate);
        text = points.map(function (p) {
            var y = p[0];
            var x = -textPadding;
            var transform = canRotate_3 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y, ")") : "";
            var classList = ["scale-text"];
            var scaleText = template(p[1]);
            if (title) {
                var textWidth = (0, common_1.getTextWidth)(scaleText, style_1);
                if (maxTextWidth_1 < textWidth) {
                    maxTextWidth_1 = textWidth;
                }
            }
            if (canRotate_3) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("left", angle));
            }
            else {
                classList.push("end-text");
            }
            return (0, dom_1.sv)("text", { x: x, y: y, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(scaleText),
            ]);
        });
        extraTittlePadding = maxTextWidth_1 + textPadding;
    }
    var id = (0, core_1.uid)();
    var mainLine = (0, dom_1.sv)("path", {
        class: "main-scale",
        d: "M0 ".concat(height, " V 0.5"),
        id: id,
        _ref: points.length ? "line0" : null,
    }); // 0.5 instead of 0, coz stroke-linecap: square and dirrent stroke size
    var svTitle = null;
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: height / 2, dy: -scalePadding - extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title" }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("y", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.left = left;
function leftGrid(points, width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine, targetValue = config.targetValue;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === height && !config.hidden) {
            continue;
        }
        if (targetLine === i) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path);
            continue;
        }
        if (grid) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: className });
            gridLines.push(path);
            if (i === len - 1 && points[i][0] !== width) {
                var additionD = "M0 0 H".concat(width);
                var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
                gridLines.push(additionPath);
            }
        }
    }
    if (targetValue) {
        var d = "M0 ".concat(targetValue * height, " H ").concat(width);
        var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
        gridLines.push(path);
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.leftGrid = leftGrid;
function right(points, config, width, height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        var style_2 = (0, common_1.getFontStyle)("scale-text");
        var maxTextWidth_2 = 0;
        var canRotate_4 = scaleRotate && !isNaN(scaleRotate);
        text = points.map(function (p) {
            var scaleText = template(p[1]);
            var y = p[0];
            var x = width + textPadding;
            var transform = canRotate_4 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y, ")") : "";
            var classList = ["scale-text"];
            if (title) {
                var textWidth = (0, common_1.getTextWidth)(scaleText, style_2);
                if (maxTextWidth_2 < textWidth) {
                    maxTextWidth_2 = textWidth;
                }
            }
            if (canRotate_4) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("right", angle));
            }
            else {
                classList.push("start-text");
            }
            return (0, dom_1.sv)("text", { x: x, y: y, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(scaleText),
            ]);
        });
        extraTittlePadding = textPadding + maxTextWidth_2;
    }
    var id = (0, core_1.uid)();
    var mainLine = (0, dom_1.sv)("path", {
        d: "M".concat(width, " ").concat(height, " V 0"),
        class: "main-scale",
        id: id,
        _ref: points.length ? "line0" : null,
    });
    var svTitle = null;
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: height / 2, dy: scalePadding + extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title" }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("y", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.right = right;
function rightGrid(points, width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === height && !config.hidden) {
            continue;
        }
        if (targetLine === i) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path);
            continue;
        }
        if (grid) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: className });
            gridLines.push(path);
            if (i === len - 1 && points[i][0] !== width) {
                var additionD = "M0 0 H".concat(width);
                var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
                gridLines.push(additionPath);
            }
        }
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.rightGrid = rightGrid;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Area_1 = __webpack_require__(88);
var Bar_1 = __webpack_require__(90);
var BarX_1 = __webpack_require__(193);
var Donut_1 = __webpack_require__(194);
var Line_1 = __webpack_require__(57);
var Pie_1 = __webpack_require__(195);
var Pie3D_1 = __webpack_require__(196);
var Radar_1 = __webpack_require__(197);
var Scatter_1 = __webpack_require__(198);
var Spline_1 = __webpack_require__(199);
var SplineArea_1 = __webpack_require__(200);
var TreeMap_1 = __webpack_require__(201);
var CalendarHeatMap_1 = __webpack_require__(202);
var seriesTypes = {
    line: Line_1.default,
    spline: Spline_1.default,
    area: Area_1.default,
    splineArea: SplineArea_1.default,
    scatter: Scatter_1.default,
    pie: Pie_1.default,
    pie3D: Pie3D_1.default,
    donut: Donut_1.default,
    radar: Radar_1.default,
    bar: Bar_1.default,
    xbar: BarX_1.default,
    treeMap: TreeMap_1.default,
    calendarHeatMap: CalendarHeatMap_1.default,
};
exports.default = seriesTypes;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
var ScaleSeria_1 = __webpack_require__(55);
var Area = /** @class */ (function (_super) {
    __extends(Area, _super);
    function Area() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Area.prototype.paint = function (width, height, prev) {
        _super.prototype.paint.call(this, width, height);
        var getChartAriaAttrs = function (cfg) { return ({
            "aria-label": "chart ".concat(cfg.value || ""),
        }); };
        var svg = [];
        this._form(width, height, svg, prev);
        this._markers(svg);
        return (0, dom_1.sv)("g", __assign(__assign({ class: "seria", _key: this.id }, getChartAriaAttrs(this.config)), { tabindex: 0 }), svg);
    };
    Area.prototype.paintformAndMarkers = function (width, height, prev) {
        _super.prototype.paint.call(this, width, height);
        var svg = [];
        var markers = [];
        this._form(width, height, svg, prev);
        this._markers(markers);
        return [
            (0, dom_1.sv)("g", { class: "seria", _key: this.id }, svg),
            (0, dom_1.sv)("g", { class: "seria_markers", _key: this.id + "_markers" }, markers),
        ];
    };
    Area.prototype._markers = function (svg) {
        var _this = this;
        if (this.config.pointType) {
            var color = this.config.pointColor || this.config.color;
            var point_1 = this._getPointType(this.config.pointType, color);
            svg.push.apply(svg, this._points.map(function (p) { return point_1(p[0], p[1], (0, common_1.calcPointRef)(p[2], _this.id)); }));
        }
    };
    Area.prototype._form = function (width, height, svg, prev) {
        var css = "chart ".concat(this.config.type, " ").concat(this.config.css || "", " ").concat(this.config.dashed ? "dash-line" : "");
        var _a = this.config, id = _a.id, fill = _a.fill, alpha = _a.alpha, color = _a.color, strokeWidth = _a.strokeWidth;
        var points = this._points;
        var last = points[points.length - 1];
        var d = "";
        if (prev) {
            // bottom line in stacked area
            for (var i = prev.length - 1; i >= 0; i--) {
                var item = prev[i];
                d += i === points.length - 1 ? "M".concat(item[0], " ").concat(item[1], " ") : "L".concat(item[0], " ").concat(item[1], " ");
            }
            // top line in stacked area
            d +=
                points.map(function (item, index) { return (!index ? "V ".concat(item[1]) : "L ".concat(item[0], " ").concat(item[1])); }).join(" ") +
                    "Z";
        }
        else {
            d +=
                points
                    .map(function (item, index) {
                    return index ? "L".concat(item[0], " ").concat(item[1]) : "M0 ".concat(height, " L0 ").concat(item[1], " L").concat(item[0], " ").concat(item[1]);
                })
                    .join(" ") + "L".concat(width, " ").concat(last[1], " V ").concat(height);
        }
        if (strokeWidth) {
            var len_1 = points.length - 1;
            var strokePadding_1 = function (index) { return (index === len_1 ? -0.5 : index ? 0 : 0.5); };
            var line = points
                .map(function (item, index) {
                return index
                    ? "L".concat(item[0] + strokePadding_1(index), " ").concat(item[1])
                    : "M0 ".concat(item[1], " L0 ").concat(item[1] + strokePadding_1(index), " L").concat(item[0] +
                        strokePadding_1(index), " ").concat(item[1]);
            })
                .join(" ") + "L".concat(width, " ").concat(last[1]);
            var linePath = (0, dom_1.sv)("path", {
                d: line,
                "stroke-width": strokeWidth,
                stroke: color,
                fill: "none",
                class: css,
            });
            svg.push(linePath);
        }
        var path = (0, dom_1.sv)("path", {
            id: "seria" + id,
            d: d,
            class: css,
            fill: fill,
            _ref: id,
            "fill-opacity": alpha,
            stroke: "none",
        });
        svg.push(path);
        return svg;
    };
    Area.prototype._setDefaults = function (config) {
        var defaults = {
            alpha: 0.3,
            strokeWidth: 2,
            fill: config.color || "#5E83BA",
            color: "#5E83BA",
            active: true,
            tooltip: true,
            pointType: "empty",
        };
        this.config = __assign(__assign({}, defaults), config);
        var point = this.config.pointType;
        var color = this.config.pointColor || this.config.color;
        if (point) {
            this._drawPointType = this._getPointType(point, color);
        }
    };
    return Area;
}(ScaleSeria_1.default));
exports.default = Area;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getShadeHTMLHelper = exports.getShadeHelper = exports.getHTMLHelper = exports.getHelper = void 0;
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
var forms = {
    circle: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            cx: x,
            cy: y,
            r: 4,
            class: "figure point-circle",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("circle", config);
    },
    rect: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            x: x - 4,
            y: y - 4,
            width: 8,
            height: 8,
            class: "figure point-rect",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("rect", config);
    },
    rhombus: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            points: "".concat(x - 5, ",").concat(y, " ").concat(x, ",").concat(y + 5, " ").concat(x + 5, ",").concat(y, " ").concat(x, ",").concat(y - 5),
            class: "figure point-rhombus",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("polygon", config);
    },
    triangle: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            points: "".concat(x, ",").concat(y - 5, " ").concat(x + 5, ",").concat(y + 5, " ").concat(x - 5, ",").concat(y + 5),
            class: "figure point-triangle",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("polygon", config);
    },
    simpleCircle: function (color, _fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            cx: x,
            cy: y,
            r: 3,
            class: "figure point-simple-circle",
            fill: color,
        };
        return (0, dom_1.sv)("circle", config);
    },
    simpleRect: function (color, _fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            x: x - 3,
            y: y - 3,
            width: 6,
            height: 6,
            class: "figure point-simple-rect",
            fill: color,
        };
        return (0, dom_1.sv)("rect", config);
    },
    empty: function () {
        return null;
    },
};
var formsHTML = {
    circle: function (color, fill, _alpha, x, y, id) {
        return "<circle class=\"figure point-circle\" _ref=\"".concat(id, "\" cx=\"").concat(x, "\" cy=\"").concat(y, "\" r=\"4\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    rect: function (color, fill, _alpha, x, y, id) {
        return "<rect _ref=\"".concat(id, "\" x=\"").concat(x - 4, "\" y=\"").concat(y -
            4, "\" width=\"8\" height=\"8\" class=\"figure point-rect\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    rhombus: function (color, fill, _alpha, x, y, id) {
        return "<polygon _ref=\"".concat(id, "\" points=\"").concat(x - 5, ",").concat(y, " ").concat(x, ",").concat(y + 5, " ").concat(x + 5, ",").concat(y, " ").concat(x, ",").concat(y -
            5, "\" class=\"figure point-rhombus\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    triangle: function (color, fill, _alpha, x, y, id) {
        return "<polygon _ref=\"".concat(id, "\" points=\"").concat(x, ",").concat(y - 5, " ").concat(x + 5, ",").concat(y + 5, " ").concat(x - 5, ",").concat(y +
            5, "\" class=\"figure point-triangle\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    simpleCircle: function (color, _fill, _alpha, x, y, id) {
        return "<circle _ref=\"".concat(id, "\" cx=\"").concat(x, "\" cy=\"").concat(y, "\" r=\"3\" class=\"figure point-simple-circle\" fill=\"").concat(color, "\"/>");
    },
    simpleRect: function (color, _fill, _alpha, x, y, id) {
        return "<rect _ref=\"id\" x=\"".concat(x - 3, "\" y=\"").concat(y -
            3, "\" width=\"6\" height=\"6\" class=\"figure point-simple-rect\" fill=\"").concat(color, "\"/>");
    },
    empty: function () {
        return null;
    },
};
function getHelper(type) {
    var helper = forms[type.toString()];
    if (!helper) {
        throw new Error("unknown point type");
    }
    return helper;
}
exports.getHelper = getHelper;
function getHTMLHelper(type) {
    var helper = formsHTML[type.toString()];
    if (!helper) {
        throw new Error("unknown point type");
    }
    return helper;
}
exports.getHTMLHelper = getHTMLHelper;
function getShadeHelper(type, color) {
    var helper = getHelper(type);
    color = color || "none";
    var shade = (0, common_1.getColorShade)(color, 0.2);
    return function (x, y, id) {
        return helper(color, shade, "", x, y, id);
    };
}
exports.getShadeHelper = getShadeHelper;
function getShadeHTMLHelper(type, color) {
    var helper = getHTMLHelper(type);
    color = color || "none";
    var shade = (0, common_1.getColorShade)(color, 0.2);
    return function (x, y, id) {
        return helper(color, shade, "", x, y, id);
    };
}
exports.getShadeHTMLHelper = getShadeHTMLHelper;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(5);
var ScaleSeria_1 = __webpack_require__(55);
var Bar = /** @class */ (function (_super) {
    __extends(Bar, _super);
    function Bar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._shift = 0;
        return _this;
    }
    Bar.prototype.addScale = function (type, scale) {
        _super.prototype.addScale.call(this, type, scale);
        scale.addPadding();
    };
    Bar.prototype.seriesShift = function (shift) {
        this._shift = shift;
        return this.config.barWidth;
    };
    Bar.prototype.paint = function (width, height, prev) {
        _super.prototype.paint.call(this, width, height);
        var getChartAriaAttrs = function (cfg) { return ({
            "aria-label": "chart ".concat(cfg.value || ""),
        }); };
        if (!this.config.active) {
            return null;
        }
        var svg = [];
        if (this._gradient) {
            svg.push((0, dom_1.sv)("defs", [this._gradient()]));
        }
        var css = "chart ".concat(this.config.type, " ").concat(this.config.css || "", " ").concat(this.config.dashed ? "dash-line" : "");
        var form = this._getForm(this._points, css, width, height, prev);
        svg = svg.concat(form);
        return (0, dom_1.sv)("g", __assign(__assign({ class: "seria", _key: this.id }, getChartAriaAttrs(this.config)), { tabindex: 0 }), svg);
    };
    Bar.prototype.getTooltipType = function (_id, _x, y) {
        if (this.config.baseLine !== undefined && this._baseLinePosition < y) {
            return "bot";
        }
        return "top";
    };
    Bar.prototype._getClosestDist = function (x, y, px, py) {
        if (this.config.stacked && y < py) {
            return Infinity;
        }
        return Math.abs(x - px);
    };
    Bar.prototype._path = function (item, prev) {
        item[0] += this._shift;
        return "\nM ".concat(item[0] - this.config.barWidth / 2, " ").concat(prev, "\nV ").concat(item[1], "\nh ").concat(this.config.barWidth, "\nV ").concat(prev);
    };
    Bar.prototype._base = function (height) {
        var baseLine = this.config.baseLine;
        return (this._baseLinePosition =
            baseLine !== undefined ? this.yScale.point(baseLine) * height : height - 1);
    };
    Bar.prototype._text = function (item, prev, rotate) {
        var x = item[0];
        var y = (prev + item[1]) / 2;
        var canRotate = rotate && !isNaN(rotate);
        return {
            x: x,
            y: y,
            class: "bar-text",
            transform: canRotate ? "rotate(".concat(rotate, " ").concat(x, " ").concat(y, ")") : "",
        };
    };
    Bar.prototype._getForm = function (points, css, _width, height, prev) {
        var _this = this;
        var getPointAriaLabel = function (barType, item, baseLine) {
            if (baseLine === void 0) { baseLine = 0; }
            var x = item[3];
            var yStart = baseLine;
            var yEnd = item[4];
            if (baseLine > yEnd) {
                yStart = yEnd;
                yEnd = baseLine;
            }
            return barType === "xbar"
                ? "bar y=".concat(x, ", x from ").concat(yStart, " to ").concat(yEnd)
                : "bar x=".concat(x, ", y from ").concat(yStart, " to ").concat(yEnd);
        };
        var getPointAriaAttrs = function (barType, item, baseLine) { return ({
            role: "graphics-symbol",
            "aria-roledescription": "bar",
            "aria-label": getPointAriaLabel(barType, item, baseLine),
        }); };
        var _a = this.config, baseLine = _a.baseLine, fill = _a.fill, alpha = _a.alpha, showText = _a.showText, showTextTemplate = _a.showTextTemplate, showTextRotate = _a.showTextRotate;
        var svg = [];
        var base = this._base(height);
        var getPrev = function (index) { return (!prev ? base : prev[index][1]); };
        var series = points.map(function (item, index) {
            return (0, dom_1.sv)("path", __assign(__assign({ _key: "seria" + _this.config.id + index, _ref: (0, common_1.calcPointRef)(item[2], _this.config.id), d: _this._path(item, getPrev(index)), class: css, fill: fill, onclick: [_this._handlers.onclick, item[2], _this.config.value], onmousemove: [_this._handlers.onmousemove, item[2], _this.config.id], onmouseleave: [_this._handlers.onmouseleave, item[2], _this.config.id], "fill-opacity": alpha }, getPointAriaAttrs(_this.config.type, item, baseLine)), { tabindex: 0 }));
        });
        svg.push.apply(svg, series);
        if ((showText || showTextTemplate || showTextRotate) && showText !== false) {
            var isWrite_1 = function (item, index) { return Math.abs(getPrev(index) - item[1]) > 16; }; // hide text, where height < 16
            var text = points.map(function (item, index) {
                var value = _this._getText(item);
                return isWrite_1(item, index)
                    ? (0, dom_1.sv)("text", __assign(__assign({}, _this._text(item, getPrev(index), showTextRotate)), { "aria-hidden": "true" }), [
                        showTextTemplate
                            ? (0, common_1.verticalCenteredText)(showTextTemplate(value))
                            : (0, common_1.verticalCenteredText)(value),
                    ])
                    : null;
            });
            svg.push.apply(svg, text);
        }
        return svg;
    };
    Bar.prototype._getText = function (item) {
        return item[4].toString();
    };
    Bar.prototype._setDefaults = function (config) {
        var defaults = {
            barWidth: 30,
            alpha: 1,
            active: true,
            tooltip: true,
            pointType: "empty",
        };
        this.config = __assign(__assign({}, defaults), config);
        var point = this.config.pointType;
        var color = this.config.pointColor || this.config.color;
        if (point) {
            this.config.pointType = point;
            this._drawPointType = this._getPointType(point, color);
        }
        if (this.config.gradient) {
            var id_1 = "gradient" + (0, core_1.uid)();
            var gradient_1 = this.config.gradient(this.config.fill);
            this._gradient = function () { return (0, common_1.linearGradient)(gradient_1, id_1); };
            this.config.fill = "url(#".concat(id_1, ")");
        }
    };
    return Bar;
}(ScaleSeria_1.default));
exports.default = Bar;


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
function spline(initPoints, link) {
    var len = initPoints.length;
    var points;
    if (len < 3) {
        points = initPoints;
    }
    else {
        var p0 = initPoints[0];
        var p1 = initPoints[0];
        var p2 = initPoints[1];
        var p3 = initPoints[2];
        points = [initPoints[0].slice(0, 2)];
        for (var i = 1; i < len; i++) {
            points.push([
                (-p0[0] + 6 * p1[0] + p2[0]) / 6,
                (-p0[1] + 6 * p1[1] + p2[1]) / 6,
                (p1[0] + 6 * p2[0] - p3[0]) / 6,
                (p1[1] + 6 * p2[1] - p3[1]) / 6,
                p2[0],
                p2[1],
            ]);
            p0 = p1;
            p1 = p2;
            p2 = p3;
            p3 = initPoints[i + 2] || p3;
        }
    }
    var d = "";
    for (var i = 0; i < points.length; i++) {
        var point = points[i];
        var n = point.length;
        if (!i) {
            d += link ? "L" : "M";
            d += n === 5 ? "".concat(point[0], " ").concat(point[1]) : "".concat(point[n - 2], " ").concat(point[n - 1]);
        }
        else if (n > 5) {
            d += "C".concat(point[0], " ").concat(point[1], "\n\t\t\t\t").concat(point[2], " ").concat(point[3], "\n\t\t\t\t").concat(point[4], " ").concat(point[5]);
        }
        else if (n === 5) {
            d += "L".concat(point[0], " ").concat(point[1]);
        }
        else {
            d += "S".concat(point[0], " ").concat(point[1], "\n\t\t\t\t").concat(point[2], " ").concat(point[3]);
        }
    }
    return d;
}
exports.default = spline;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var dom_1 = __webpack_require__(0);
var Stacker = /** @class */ (function () {
    function Stacker() {
        this._series = [];
    }
    Stacker.prototype.add = function (seria) {
        this._series.push(seria);
    };
    Stacker.prototype.dataReady = function (prev) {
        this._toPaint = this._series.filter(function (serie) {
            var next = serie.dataReady(prev);
            if (next.length) {
                prev = next;
                return true;
            }
            return false;
        });
        return prev || [];
    };
    Stacker.prototype.getPoints = function () {
        if (this._toPaint.length) {
            return this._toPaint[0].getPoints().concat(this._toPaint[this._toPaint.length - 1].getPoints());
        }
        return [];
    };
    Stacker.prototype.paint = function (width, height, prev) {
        var svg = [];
        var markers = [];
        this._toPaint.forEach(function (seria) {
            if (seria.paintformAndMarkers) {
                var _a = seria.paintformAndMarkers(width, height, prev), content = _a[0], seriesMarkers = _a[1];
                svg.push(content);
                markers.push(seriesMarkers);
            }
            else {
                var content = seria.paint(width, height, prev);
                svg.push(content);
            }
            prev = seria.getPoints();
        });
        return (0, dom_1.sv)("g", svg.concat(markers));
    };
    return Stacker;
}());
exports.default = Stacker;


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataView = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var ts_list_1 = __webpack_require__(35);
var editors_1 = __webpack_require__(207);
var DataView = /** @class */ (function (_super) {
    __extends(DataView, _super);
    function DataView(node, config) {
        if (config === void 0) { config = {}; }
        return _super.call(this, node, (0, core_1.extend)({
            itemsInRow: 1,
            gap: "0px",
        }, config)) || this;
    }
    DataView.prototype.scrollTo = function (id) {
        var rootView = this.getRootView();
        if (!rootView || !rootView.node || !rootView.node.el || typeof id === "undefined") {
            return;
        }
        var dataViewEl = this.getRootNode();
        this._scrollTo(id, dataViewEl);
    };
    DataView.prototype._scrollTo = function (id, el) {
        var _a;
        if (!el)
            return;
        var getPage = function (index, rest, total) {
            var count = 0;
            if (!total)
                return count;
            while (index + rest >= total) {
                count++;
                index = index + rest - total;
            }
            return count;
        };
        var index = this.data.getIndex(id);
        if (index === -1)
            return;
        var virtual = this.config.virtual;
        var rest = this.config.itemsInRow - ((_a = el.lastElementChild) === null || _a === void 0 ? void 0 : _a.children.length) || 0;
        var currentPage = getPage(index, rest, el.children.length * this.config.itemsInRow);
        var restTotal = currentPage * rest;
        var currentRow = Math.floor((index + restTotal) / this.config.itemsInRow);
        var itemRow = el.children[currentRow - el.children.length * currentPage];
        if (!virtual && !itemRow)
            return;
        var item = itemRow.children[(index + restTotal) % this.config.itemsInRow];
        var gap = parseInt(this.config.gap.toString().replace("px", ""), null);
        if (item.offsetTop >= el.clientHeight + el.scrollTop - item.clientHeight) {
            el.scrollTop = item.offsetTop - el.clientHeight + item.clientHeight + gap;
        }
        else if (item.offsetTop < el.scrollTop - gap) {
            el.scrollTop = item.offsetTop - gap;
        }
    };
    DataView.prototype._didRedraw = function (vm) {
        var rootEl = vm.node.el;
        var hasScroll = rootEl.scrollHeight > rootEl.offsetHeight;
        var classAttr = vm.node.attrs.class.replace(" dhx_dataview--has-scroll", "");
        var newClassName = hasScroll ? classAttr + " dhx_dataview--has-scroll" : classAttr;
        vm.node.patch({ class: newClassName });
    };
    DataView.prototype._renderItem = function (item, index) {
        var _a = this.config, itemsInRow = _a.itemsInRow, gap = _a.gap, template = _a.template, itemHeight = _a.itemHeight;
        var html = template ? template(item) : item.htmlContent;
        var focus = item.id == this._focus;
        var isLastItemInRow = (index + 1) % this.config.itemsInRow === 0;
        var gapWithPx = function (gapSize) { return parseFloat(gapSize); };
        if (item.id == this._edited) {
            var editor = (0, editors_1.getEditor)(item, this);
            return editor.toHTML(isLastItemInRow);
        }
        var id = item.id.toString();
        var mx = this.data.getMetaMap(item);
        return (0, dom_1.el)("div", __assign(__assign({ class: "dhx_dataview-item" +
                (mx && mx.selected ? " dhx_dataview-item--selected" : "") +
                (focus ? " dhx_dataview-item--focus" : "") +
                (mx && mx.drop && !this._edited ? " dhx_dataview-item--drophere" : "") +
                (mx && mx.drag && !this._edited ? " dhx_dataview-item--dragtarget" : "") +
                (this.config.dragMode && !this._edited ? " dhx_dataview-item--drag" : "") +
                (gapWithPx(gap) ? " dhx_dataview-item--with-gap" : "") +
                (item.css ? " " + item.css : "") +
                (isLastItemInRow ? " dhx_dataview-item--last-item-in-row" : ""), style: {
                width: "calc(".concat(100 / itemsInRow, "% - ").concat(gapWithPx(gap), " * ").concat((itemsInRow - 1) /
                    itemsInRow, "px)"),
                "margin-right": isLastItemInRow ? "" : gap,
                height: template ? null : itemHeight,
            }, _key: id, "data-dhx-id": id, _ref: id }, this.getDataViewItemAriaAttrs(this, item)), { tabindex: focus ? 0 : -1 }), html
            ? [
                (0, dom_1.el)(".dhx_dataview-item__inner-html", {
                    ".innerHTML": html,
                    role: "presentation",
                }),
            ]
            : item.value || item.text || item.value);
    };
    DataView.prototype._renderList = function () {
        var _this = this;
        var data = this.data.getRawData(0, -1);
        var _a = this.config, itemsInRow = _a.itemsInRow, css = _a.css, gap = _a.gap;
        var currentCounter = 0;
        var rows = data.reduce(function (items, obj, index) {
            if (currentCounter === 0) {
                items.push([]);
            }
            items[items.length - 1].push(_this._renderItem(obj, index));
            currentCounter = (currentCounter + 1) % itemsInRow;
            return items;
        }, []);
        return (0, dom_1.el)("", __assign(__assign(__assign(__assign({}, this._handlers), { "data-dhx-widget-id": this._uid, class: (css ? css : "") +
                " dhx_widget dhx_dataview" +
                (this.config.multiselection && this.selection.getItem() ? " dhx_no-select--pointer" : ""), style: {
                height: this.config.height,
            } }), this.getDataViewAriaAttrs(this.config, this.data.getLength(), rows.length, itemsInRow)), { tabindex: 0 }), rows.map(function (row, index) {
            return (0, dom_1.el)(".dhx_dataview-row", {
                style: { margin: gap },
                "aria-label": "Row ".concat(index + 1),
            }, row);
        }));
    };
    DataView.prototype._getHotkeys = function () {
        var _this = this;
        var handlers = _super.prototype._getHotkeys.call(this);
        handlers.arrowUp = function (e) {
            _this.moveFocus(ts_list_1.MOVE_UP, _this.config.itemsInRow);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        handlers.arrowDown = function (e) {
            _this.moveFocus(ts_list_1.MOVE_DOWN, _this.config.itemsInRow);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        handlers.arrowLeft = function (e) {
            _this.moveFocus(ts_list_1.MOVE_UP);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        handlers.arrowRight = function (e) {
            _this.moveFocus(ts_list_1.MOVE_DOWN);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        return handlers;
    };
    DataView.prototype.getDataViewItemAriaAttrs = function (context, item) {
        var getAriaGrabbed = function (context, item) {
            return context.config.dragMode && !context._edited
                ? { "aria-grabbed": Boolean(item.$dragtarget && !context._edited).toString() }
                : {};
        };
        var getAriaRoleDescription = function (context) {
            return context.config.editable
                ? {
                    "aria-roledescription": "".concat(context._edited ? "Press Enter to stop editing" : "Double click to edit content"),
                }
                : {};
        };
        return __assign(__assign({ role: "option", "aria-selected": item.$selected ? "true" : "false" }, getAriaGrabbed(context, item)), getAriaRoleDescription(context));
    };
    DataView.prototype.getDataViewAriaAttrs = function (config, itemsCount, rowsCount, itemsInRow) {
        return {
            role: "listbox",
            "aria-label": "Dataview, ".concat(itemsCount, " options on ").concat(rowsCount, " rows, ").concat(itemsInRow, " options per row.").concat(config.editable ? " Content is editable." : ""),
            "aria-multiselectable": config.selection && config.multiselection ? "true" : "false",
            "aria-readonly": config.editable ? "false" : "true",
        };
    };
    return DataView;
}(ts_list_1.List));
exports.DataView = DataView;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataViewEvents = void 0;
var DataViewEvents;
(function (DataViewEvents) {
    DataViewEvents["click"] = "click";
    DataViewEvents["doubleClick"] = "doubleclick";
    DataViewEvents["focusChange"] = "focuschange";
    DataViewEvents["beforeEditStart"] = "beforeEditStart";
    DataViewEvents["afterEditStart"] = "afterEditStart";
    DataViewEvents["beforeEditEnd"] = "beforeEditEnd";
    DataViewEvents["afterEditEnd"] = "afterEditEnd";
    DataViewEvents["itemRightClick"] = "itemRightClick";
    DataViewEvents["itemMouseOver"] = "itemMouseOver";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    DataViewEvents["contextmenu"] = "contextmenu";
})(DataViewEvents || (exports.DataViewEvents = DataViewEvents = {}));


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Form = void 0;
var events_1 = __webpack_require__(2);
var view_1 = __webpack_require__(8);
var ts_layout_1 = __webpack_require__(12);
var core_1 = __webpack_require__(1);
var dateinput_1 = __webpack_require__(211);
var button_1 = __webpack_require__(212);
var checkbox_1 = __webpack_require__(96);
var checkboxGroup_1 = __webpack_require__(213);
var input_1 = __webpack_require__(39);
var radioGroup_1 = __webpack_require__(214);
var select_1 = __webpack_require__(216);
var textarea_1 = __webpack_require__(217);
var textinput_1 = __webpack_require__(218);
var combo_1 = __webpack_require__(219);
var sliderform_1 = __webpack_require__(220);
var helper_1 = __webpack_require__(6);
var simplevault_1 = __webpack_require__(97);
var timeinput_1 = __webpack_require__(221);
var colorpicker_1 = __webpack_require__(222);
var spacer_1 = __webpack_require__(223);
var avatar_1 = __webpack_require__(224);
var fieldset_1 = __webpack_require__(225);
var ToggleButton_1 = __webpack_require__(99);
var ToggleGroup_1 = __webpack_require__(226);
var types_1 = __webpack_require__(4);
var dom_1 = __webpack_require__(0);
var Form = /** @class */ (function (_super) {
    __extends(Form, _super);
    function Form(container, config) {
        var _this = _super.call(this, null, (0, core_1.extend)({
            disabled: false,
            hidden: false,
            css: "",
        }, config)) || this;
        _this._isValid = true;
        _this._state = {};
        _this.events = new events_1.EventSystem(_this);
        _this.container = container;
        _this._initUI(container);
        _this.config.hidden && _this.hide(true);
        _this.config.disabled && _this.disable();
        _this.events.on(types_1.FormEvents.afterShow, function () {
            _this._formContainerShow();
        });
        _this.events.on(types_1.FormEvents.afterHide, function () {
            if (!Object.values(_this._attachments).some(function (item) { return !item.config.hidden; })) {
                _this._formContainerHide();
            }
        });
        (0, dom_1.awaitRedraw)().then(function () {
            var node = _this.layout.getRootNode();
            if (node) {
                node.setAttribute("role", "form");
                _this.config.title && node.setAttribute("aria-label", _this.config.title);
            }
        });
        return _this;
    }
    Form.prototype.paint = function () {
        _super.prototype.paint.call(this);
        this.layout.paint();
    };
    Form.prototype.send = function (url, method, asFormData) {
        var _this = this;
        if (method === void 0) { method = "POST"; }
        if (this.events.fire(types_1.FormEvents.beforeSend)) {
            return new Promise(function (resolve, reject) {
                var xhr = new XMLHttpRequest();
                xhr.onload = function () {
                    if (xhr.status >= 200 && xhr.status < 300) {
                        resolve(xhr.response || xhr.responseText);
                    }
                    else {
                        reject({
                            status: xhr.status,
                            statusText: xhr.statusText,
                        });
                    }
                };
                xhr.onloadend = function () {
                    if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
                        _this.events.fire(types_1.FormEvents.afterSend);
                    }
                };
                xhr.onerror = function () {
                    reject({
                        status: xhr.status,
                        statusText: xhr.statusText,
                    });
                };
                if (method === "GET") {
                    url += "?" + encodeURIComponent(JSON.stringify(_this.getValue()));
                }
                xhr.open(method, url);
                if (!asFormData) {
                    xhr.setRequestHeader("Content-Type", "application/json");
                }
                switch (method) {
                    case "POST":
                        _this._send();
                        xhr.send(asFormData ? _this.getValue(true) : JSON.stringify(_this.getValue()));
                        break;
                    case "DELETE":
                    case "PUT":
                        xhr.send(asFormData ? _this.getValue(true) : JSON.stringify(_this.getValue()));
                        break;
                    case "GET":
                        xhr.send();
                        break;
                    default:
                        xhr.send();
                        break;
                }
            });
        }
    };
    Form.prototype.clear = function (method) {
        switch (method) {
            case types_1.ClearMethod.value:
                this._clear();
                break;
            case types_1.ClearMethod.validation:
                this._clearValidate();
                break;
            default:
                this._clear();
                this._clearValidate();
                break;
        }
        this.paint();
    };
    Form.prototype.setValue = function (obj) {
        for (var item in obj) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].setValue === "function" &&
                    this._attachments[key].config.name === item) {
                    this._attachments[key].setValue(obj[item]);
                }
            }
        }
    };
    Form.prototype.getValue = function (asFormData) {
        if (asFormData) {
            var formData_1 = new FormData();
            var _loop_1 = function (key) {
                if (Array.isArray(this_1._state[key])) {
                    this_1._state[key].forEach(function (value, i) { return formData_1.append(key + "[".concat(i, "]"), value); });
                }
                else {
                    formData_1.append(key, this_1._state[key]);
                }
            };
            var this_1 = this;
            for (var key in this._state) {
                _loop_1(key);
            }
            return formData_1;
        }
        return __assign({}, this._state);
    };
    Form.prototype.getItem = function (name) {
        for (var item in this._attachments) {
            if (item == name) {
                return this._attachments[item];
            }
        }
    };
    Form.prototype.validate = function (silent) {
        if (silent === void 0) { silent = false; }
        this._isValid = true;
        for (var key in this._attachments) {
            if (typeof this._attachments[key].validate === "function") {
                if ((0, helper_1.isVerify)(this._attachments[key].config) && !this._attachments[key].validate(silent)) {
                    this._isValid = false;
                    !silent && this.events.fire(types_1.FormEvents.validationFail, [key, this._attachments[key]]);
                }
            }
        }
        return this._isValid;
    };
    Form.prototype.setProperties = function (arg, props) {
        if (typeof arg === "string" && props && !(0, core_1.isEmptyObj)(props)) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].setProperties === "function" && key === arg) {
                    this._attachments[key].setProperties(props);
                }
            }
        }
        if (typeof arg === "object" && !(0, core_1.isEmptyObj)(arg)) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].setProperties === "function" && !(0, core_1.isEmptyObj)(arg[key])) {
                    this._attachments[key].setProperties(arg[key]);
                }
            }
        }
    };
    Form.prototype.getProperties = function (name) {
        if (name) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].getProperties === "function" && key === name) {
                    return this._attachments[key].getProperties();
                }
            }
        }
        var obj = {};
        for (var key in this._attachments) {
            if (typeof this._attachments[key].getProperties === "function") {
                obj[key] = this._attachments[key].getProperties();
            }
        }
        return obj;
    };
    Form.prototype.show = function () {
        if (!this.config.hidden && !Object.values(this._attachments).some(function (item) { return !item.config.hidden; })) {
            return;
        }
        this._formContainerShow();
        for (var key in this._attachments) {
            if (typeof this._attachments[key].show === "function") {
                this._attachments[key].show();
            }
        }
    };
    Form.prototype.hide = function (init) {
        if (this.config.hidden && !init) {
            return;
        }
        this._formContainerHide();
        for (var key in this._attachments) {
            if (typeof this._attachments[key].hide === "function") {
                this._attachments[key].hide(init);
            }
        }
    };
    Form.prototype.setFocus = function (name) {
        for (var item in this._attachments) {
            var control = this._attachments[item];
            if (control.config.type === "radiogroup" || control.config.type === "checkboxgroup") {
                control.focus(name);
            }
            if (control.config.name === name) {
                control.focus();
            }
        }
    };
    Form.prototype.blur = function (name) {
        if (!name) {
            this.forEach(function (control) {
                if (typeof control.blur === "function") {
                    control.blur();
                }
            });
        }
        for (var item in this._attachments) {
            var control = this._attachments[item];
            if (control.config.type === "radiogroup" || control.config.type === "checkboxgroup") {
                control.blur(name);
            }
            if (control.config.name === name) {
                control.blur();
            }
        }
    };
    Form.prototype.isVisible = function (name) {
        if (!name) {
            return !this.config.hidden;
        }
        for (var key in this._attachments) {
            if (key === name) {
                return !this._attachments[key].config.hidden;
            }
        }
    };
    Form.prototype.disable = function () {
        this.config.disabled = true;
        for (var key in this._attachments) {
            if (typeof this._attachments[key].disable === "function") {
                this._attachments[key].disable();
            }
        }
    };
    Form.prototype.enable = function () {
        this.config.disabled = false;
        for (var key in this._attachments) {
            if (typeof this._attachments[key].enable === "function") {
                this._attachments[key].enable();
            }
        }
    };
    Form.prototype.isDisabled = function (name) {
        if (!name) {
            return this.config.disabled;
        }
        for (var key in this._attachments) {
            if (key === name) {
                return this._attachments[key].config.disabled;
            }
        }
    };
    Form.prototype.forEach = function (callback) {
        var items = Object.values(this._attachments);
        for (var index = 0; index < items.length; index++) {
            callback.call(this, items[index], index, items);
        }
    };
    Form.prototype.destructor = function () {
        this.unmount();
        for (var key in this._attachments) {
            if (typeof this._attachments[key].destructor === "function") {
                this._attachments[key].destructor();
            }
        }
        this.events && this.events.clear();
        this.layout && this.layout.destructor();
        this.config = this._attachments = this._state = this._uid = this.container = this.events = this._isValid = null;
    };
    Form.prototype.getRootView = function () {
        return this.layout.getRootView();
    };
    Form.prototype._addLayoutItem = function (item) {
        var id = (item.id = item.id || (0, core_1.uid)());
        var name = (item.name = item.name || id.toString());
        item.type = item.type && item.type.toLowerCase();
        var css = item.css, padding = item.padding, config = __rest(item, ["css", "padding"]);
        var width = item.width, height = item.height;
        var classList = css ? css + " dhx_form-element" : "dhx_form-element";
        var autoSize = item.type !== "spacer";
        if (autoSize && !width)
            width = "content";
        if (autoSize && !height)
            height = "content";
        switch (config.type) {
            case "button":
                if (config.full)
                    classList += " dhx_button--full-gravity";
                break;
            case "text":
                if (width === "content")
                    classList += " dhx_form-element--fit-content";
                break;
            case "simplevault":
                config.$vaultHeight = height;
                break;
        }
        this._initItemHandlers(item, name);
        var cell = {
            id: name,
            width: width,
            height: height,
            padding: padding,
            css: classList,
        };
        if (item.type === "fieldset") {
            cell.$fieldset = true;
            cell.label = item.label;
            cell.labelAlignment = item.labelAlignment;
            this._createLayoutConfig(item, cell);
        }
        return cell;
    };
    Form.prototype._initItemHandlers = function (item, name) {
        var _this = this;
        switch (item.type) {
            case "avatar":
                {
                    var avatar = (this._attachments[name] = new avatar_1.Avatar(null, item));
                    this._state[name] = avatar.getValue();
                    avatar.events.on(types_1.ItemEvent.beforeChange, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.change, function (value) {
                        _this._state[name] = value;
                        _this.events.fire(types_1.FormEvents.change, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                        }
                    });
                    avatar.events.on(types_1.ItemEvent.beforeShow, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                        _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.afterShow, function (value) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                        _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                    });
                    avatar.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                    });
                    avatar.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                        _this._changeProps(name, props);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                        _this.paint();
                    });
                    avatar.events.on(types_1.ItemEvent.focus, function (value) {
                        _this.events.fire(types_1.FormEvents.focus, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.blur, function (value) {
                        _this.events.fire(types_1.FormEvents.blur, [name, value]);
                    });
                    avatar.events.on(types_1.ItemEvent.keydown, function (event) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                    });
                }
                break;
            case "toggle":
                {
                    var toggle = (this._attachments[name] = new ToggleButton_1.ToggleButton(null, item));
                    this._state[name] = toggle.getValue();
                    toggle.events.on(types_1.ItemEvent.beforeChange, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.change, function (value) {
                        _this._state[name] = value;
                        _this.events.fire(types_1.FormEvents.change, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                        }
                    });
                    toggle.events.on(types_1.ItemEvent.beforeShow, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                        _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.afterShow, function (value) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.beforeChangeProperties, function (config) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, config]);
                    });
                    toggle.events.on(types_1.ItemEvent.afterChangeProperties, function (config) {
                        _this._changeProps(name, config);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, config]);
                        _this.paint();
                    });
                    toggle.events.on(types_1.ItemEvent.focus, function (value) {
                        _this.events.fire(types_1.FormEvents.focus, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.blur, function (value) {
                        _this.events.fire(types_1.FormEvents.blur, [name, value]);
                    });
                    toggle.events.on(types_1.ItemEvent.keydown, function (event) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                    });
                }
                break;
            case "togglegroup":
                {
                    var toggleGroup_1 = (this._attachments[name] = new ToggleGroup_1.ToggleGroup(null, item));
                    this._state[name] = toggleGroup_1.getValue();
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.change, function (value) {
                        _this._state[name] = value;
                        _this.events.fire(types_1.FormEvents.change, [name, value]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeHide, function (value, id, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, value, id]);
                        }
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeShow, function (value, id) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.afterHide, function (value, id, init) {
                        !toggleGroup_1.isVisible() && _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.afterShow, function (value, id) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (config) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, config]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.afterChangeProperties, function (config) {
                        _this._changeProps(name, config);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, config]);
                        _this.paint();
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.focus, function (value, id) {
                        _this.events.fire(types_1.FormEvents.focus, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.blur, function (value, id) {
                        _this.events.fire(types_1.FormEvents.blur, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.keydown, function (event, id) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                    });
                }
                break;
            case "button":
                {
                    var button_2 = (this._attachments[name] = new button_1.Button(null, item));
                    button_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                    });
                    button_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                        _this._changeProps(name, props);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                        _this.paint();
                    });
                    button_2.events.on(types_1.ItemEvent.click, function (e) {
                        e.preventDefault();
                        _this.events.fire(types_1.FormEvents.click, [name, e]);
                        _this.events.fire(types_1.FormEvents.buttonClick, [name, e]);
                        if (button_2.config.submit && _this.validate()) {
                            button_2.config.url && _this.send(button_2.config.url);
                        }
                    });
                    button_2.events.on(types_1.ItemEvent.beforeHide, function (text, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, text]);
                        }
                    });
                    button_2.events.on(types_1.ItemEvent.beforeShow, function (text) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.afterHide, function (text, init) {
                        _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.afterShow, function (text) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.focus, function (text) {
                        _this.events.fire(types_1.FormEvents.focus, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.blur, function (text) {
                        _this.events.fire(types_1.FormEvents.blur, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.keydown, function (event) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                    });
                }
                break;
            case "datepicker": {
                var datePicker_1 = (this._attachments[name] = new dateinput_1.DatePicker(null, item));
                this._state[name] = datePicker_1.getValue(item.valueFormat === "Date");
                datePicker_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = datePicker_1.getValue(item.valueFormat === "Date");
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                datePicker_1.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "checkbox": {
                var checkbox_2 = (this._attachments[name] = new checkbox_1.Checkbox(null, item));
                this._state[name] = checkbox_2.getValue();
                checkbox_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = checkbox_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                checkbox_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "checkboxgroup": {
                var checkboxGroup_2 = (this._attachments[name] = new checkboxGroup_1.CheckboxGroup(null, item));
                this._state[name] = checkboxGroup_2.getValue();
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = checkboxGroup_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeHide, function (value, id, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value, id]);
                    }
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeShow, function (value, id) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterHide, function (value, id, init) {
                    !checkboxGroup_2.isVisible() && _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterShow, function (value, id) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.focus, function (value, id) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.blur, function (value, id) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.keydown, function (event, id) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                });
                break;
            }
            case "combo": {
                var combo_2 = (this._attachments[name] = new combo_1.Combo(null, item));
                this._state[name] = combo_2.getValue();
                combo_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                combo_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = combo_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                combo_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                combo_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                combo_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.keydown, function (event, id) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                });
                break;
            }
            case "input": {
                var input_2 = (this._attachments[name] = new input_1.Input(null, item));
                this._state[name] = input_2.getValue();
                input_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                input_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = input_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                input_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                input_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                input_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "radiogroup": {
                var radioGroup_2 = (this._attachments[name] = new radioGroup_1.RadioGroup(null, item));
                this._state[name] = radioGroup_2.getValue();
                radioGroup_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = radioGroup_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeHide, function (value, id, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value, id]);
                    }
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeShow, function (value, id) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterHide, function (value, id, init) {
                    !radioGroup_2.isVisible() && _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterShow, function (value, id) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.focus, function (value, id) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.blur, function (value, id) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.keydown, function (event, id) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                });
                break;
            }
            case "select": {
                var select_2 = (this._attachments[name] = new select_1.Select(null, item));
                this._state[name] = select_2.getValue();
                select_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                select_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = select_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                select_2.events.on(types_1.ItemEvent.changeOptions, function (options) {
                    _this.layout.getCell(name).config.options = __spreadArray([], options, true);
                });
                select_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                select_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                select_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "simplevault": {
                var simpleVault_1 = (this._attachments[name] = new simplevault_1.SimpleVault(null, item));
                this._state[name] = simpleVault_1.getValue();
                simpleVault_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = simpleVault_1.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                break;
            }
            case "slider": {
                var sliderForm = (this._attachments[name] = new sliderform_1.SliderForm(null, item));
                this._state[name] = sliderForm.getValue();
                sliderForm.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                sliderForm.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "textarea": {
                var textarea_2 = (this._attachments[name] = new textarea_1.Textarea(null, item));
                this._state[name] = textarea_2.getValue();
                textarea_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = textarea_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                textarea_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                textarea_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                textarea_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "text": {
                var text_1 = (this._attachments[name] = new textinput_1.Text(null, item));
                this._state[name] = text_1.getValue();
                text_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                text_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = text_1.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                text_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                text_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                break;
            }
            case "timepicker": {
                var timePicker_1 = (this._attachments[name] = new timeinput_1.TimePicker(null, item));
                this._state[name] =
                    (item.value && timePicker_1.getValue(item.valueFormat === "timeObject")) || "";
                timePicker_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = timePicker_1.getValue(item.valueFormat === "timeObject");
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                timePicker_1.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "colorpicker": {
                var colorPicker_1 = (this._attachments[name] = new colorpicker_1.ColorPicker(null, item));
                this._state[name] = colorPicker_1.getValue();
                colorPicker_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this._state[name] = colorPicker_1.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "fieldset": {
                var fieldset = (this._attachments[name] = new fieldset_1.Fieldset(item));
                fieldset.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                fieldset.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                break;
            }
            case "spacer":
            default: {
                var spacer = (this._attachments[name] = new spacer_1.Spacer(null, item));
                spacer.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                spacer.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props);
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                spacer.events.on(types_1.ItemEvent.beforeHide, function (init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name]);
                    }
                });
                spacer.events.on(types_1.ItemEvent.beforeShow, function () {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name]);
                });
                spacer.events.on(types_1.ItemEvent.afterHide, function (init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name]);
                });
                spacer.events.on(types_1.ItemEvent.afterShow, function () {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name]);
                });
                break;
            }
        }
    };
    Form.prototype._changeProps = function (name, props) {
        var properties = ["width", "height", "css", "padding", "label", "labelAlignment", "align"];
        for (var key in props) {
            if (properties.includes(key)) {
                this.layout.getCell(name).config[key] = props[key];
            }
        }
    };
    Form.prototype._addLayoutItems = function (items) {
        var _this = this;
        return items.map(function (item) {
            if ((0, helper_1.isBlock)(item)) {
                var layoutConfig = { width: "content", height: "content" };
                _this._createLayoutConfig(item, layoutConfig);
                return layoutConfig;
            }
            return _this._addLayoutItem(item);
        });
    };
    Form.prototype._checkLayoutConfig = function (config, layoutConfig) {
        if ((0, core_1.isDefined)(config.css)) {
            layoutConfig.css = config.css;
        }
        if ((0, core_1.isDefined)(config.title)) {
            layoutConfig.header = config.title;
        }
        if ((0, core_1.isDefined)(config.padding)) {
            layoutConfig.padding = config.padding;
        }
        if ((0, core_1.isDefined)(config.width)) {
            layoutConfig.width = config.width;
        }
        if ((0, core_1.isDefined)(config.height)) {
            layoutConfig.height = config.height;
        }
        if ((0, core_1.isDefined)(config.align)) {
            layoutConfig.align = config.align;
        }
        return layoutConfig;
    };
    Form.prototype._createLayoutConfig = function (config, layoutConfig) {
        layoutConfig = this._checkLayoutConfig(config, layoutConfig);
        if ((0, core_1.isDefined)(config.rows)) {
            layoutConfig.rows = this._addLayoutItems(config.rows);
        }
        else if ((0, core_1.isDefined)(config.cols)) {
            layoutConfig.cols = this._addLayoutItems(config.cols);
        }
    };
    Form.prototype._initUI = function (container) {
        this._attachments = {};
        var layoutConfig = {
            padding: "8px",
        };
        this.config.css += " dhx_form";
        this._createLayoutConfig(this.config, layoutConfig);
        this.layout = new ts_layout_1.Layout(container, layoutConfig);
        (0, helper_1.setAttacments)(this._attachments, this.layout);
    };
    Form.prototype._clear = function () {
        this._state = {};
        for (var key in this._attachments) {
            var name_1 = this._attachments[key].config.name;
            if (typeof this._attachments[key].clear === "function") {
                this._attachments[key].clear();
                name_1
                    ? (this._state[name_1] = this._attachments[key].getValue())
                    : (this._state[key] = this._attachments[key].getValue());
            }
        }
    };
    Form.prototype._clearValidate = function () {
        for (var key in this._attachments) {
            if (typeof this._attachments[key].clearValidate === "function") {
                this._attachments[key].clearValidate();
            }
        }
    };
    Form.prototype._formContainerShow = function () {
        this.config.hidden = false;
        if (!this.getRootView().node)
            return;
        var root = this.getRootView().node.el;
        root.style.display = "flex";
    };
    Form.prototype._formContainerHide = function () {
        this.config.hidden = true;
        if (!this.getRootView().node)
            return;
        var root = this.getRootView().node.el;
        root.style.display = "none";
    };
    Form.prototype._send = function () {
        for (var key in this._attachments) {
            if (typeof this._attachments[key].send === "function") {
                this._attachments[key].send();
            }
        }
    };
    return Form;
}(view_1.View));
exports.Form = Form;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Checkbox = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var helper_1 = __webpack_require__(6);
var ts_popup_1 = __webpack_require__(13);
var types_1 = __webpack_require__(4);
var label_1 = __webpack_require__(10);
var core_1 = __webpack_require__(1);
var Checkbox = /** @class */ (function (_super) {
    __extends(Checkbox, _super);
    function Checkbox(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, container, config) || this;
        _this.events = new events_1.EventSystem();
        _this._propsItem = [
            "required",
            "label",
            "labelWidth",
            "labelPosition",
            "hiddenLabel",
            "helpMessage",
            "preMessage",
            "successMessage",
            "errorMessage",
            "text",
        ];
        _this._props = __spreadArray(__spreadArray([], helper_1.baseProps, true), _this._propsItem, true);
        _this._initView(config);
        _this._initHandlers();
        var render = function () { return _this._draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Checkbox.prototype.setProperties = function (propertyConfig, silent) {
        if (silent === void 0) { silent = false; }
        if (!propertyConfig ||
            (0, core_1.isEmptyObj)(propertyConfig) ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()])))
            return;
        for (var key in propertyConfig) {
            if (this._props.includes(key)) {
                this.config[key] = propertyConfig[key];
            }
        }
        !silent && this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
        this.paint();
    };
    Checkbox.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this._props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    Checkbox.prototype.show = function () {
        var hidden = this.config.hidden;
        if (!hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [this.getValue()])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [this.getValue()]);
    };
    Checkbox.prototype.hide = function (init) {
        var hidden = this.config.hidden;
        if ((hidden && !init) || !this.events.fire(types_1.ItemEvent.beforeHide, [this.getValue(), init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [this.getValue(), init]);
    };
    Checkbox.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    Checkbox.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    Checkbox.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    Checkbox.prototype.isDisabled = function () {
        return !!this.config.disabled;
    };
    Checkbox.prototype.validate = function (silent) {
        if (silent === void 0) { silent = false; }
        var value = this.getValue();
        if (!silent && !this.events.fire(types_1.ItemEvent.beforeValidate, [value])) {
            return false;
        }
        var isValid = !!((this.config.required || this.config.$required) && this.config.checked);
        if (!silent) {
            this.setValidationStatus(isValid ? "success" : "error");
            this.events.fire(types_1.ItemEvent.afterValidate, [value, isValid]);
            this.paint();
        }
        return isValid;
    };
    Checkbox.prototype.clearValidate = function () {
        this.setValidationStatus();
        this.paint();
    };
    Checkbox.prototype.setValue = function (checked, silent) {
        if (silent === void 0) { silent = false; }
        if (typeof checked === "undefined" ||
            checked === this.config.checked ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChange, [this._getValue(checked)])))
            return;
        this.config.checked = !!checked;
        if (!silent) {
            this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
            (0, helper_1.isVerify)(this.config) && this.validate();
        }
    };
    Checkbox.prototype.getValue = function () {
        return this._getValue(this.config.checked);
    };
    Checkbox.prototype.clear = function (silent) {
        if (!this.config.checked ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChange, [this._getValue(false)]))) {
            return;
        }
        this.config.checked = false;
        if (!silent) {
            this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        }
        (0, helper_1.isVerify)(this.config) && this.setValidationStatus(this.validate(true) ? "success" : "error");
    };
    Checkbox.prototype.destructor = function () {
        this.events && this.events.clear();
        this._inGroup = this._propsItem = this._props = this._uid = this.events = null;
        _super.prototype._destructor.call(this);
        this.unmount();
    };
    Checkbox.prototype.focus = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.focus();
        });
    };
    Checkbox.prototype.blur = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.blur();
        });
    };
    Checkbox.prototype.isChecked = function () {
        return !!this.config.checked;
    };
    Checkbox.prototype._getValue = function (checked) {
        if (typeof this.config.value === "string") {
            return (checked && this.config.value) || "";
        }
        return !!checked;
    };
    Checkbox.prototype._initView = function (config) {
        var _this = this;
        this._inGroup = this.config.$group;
        if (!this._inGroup) {
            this.config = {
                type: config.type,
                id: config.id,
                name: config.name,
                disabled: false,
                required: false,
                label: "",
                labelWidth: "",
                labelPosition: "top",
                hiddenLabel: false,
                helpMessage: "",
                preMessage: "",
                successMessage: "",
                errorMessage: "",
                width: "content",
                height: "content",
            };
            for (var key in config) {
                if (key !== "id" && key !== "type" && key !== "name") {
                    this.config[key] = config[key];
                }
            }
            if (this.config.helpMessage) {
                this._helper = new ts_popup_1.Popup({
                    css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
                });
                this._helper.attachHTML(this.config.helpMessage);
            }
            this._handlers = {
                showHelper: function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    _this._helper.show(e.target, {
                        mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                        theme: _this.getRootNode(),
                    });
                },
                hideHelper: function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    _this._helper.hide();
                },
                onchange: function (e) {
                    var checked = e.target.checked;
                    if (!_this.events.fire(types_1.ItemEvent.beforeChange, [_this._getValue(checked)])) {
                        var element = _this.getRootView().refs.input.el;
                        element.checked = !checked;
                        return;
                    }
                    _this.config.checked = checked;
                    _this.events.fire(types_1.ItemEvent.change, [_this.getValue()]);
                    (0, helper_1.isVerify)(_this.config) && _this.validate();
                },
                onfocus: function () { return _this.events.fire(types_1.ItemEvent.focus, [_this.getValue()]); },
                onblur: function () { var _a; return (_a = _this.events) === null || _a === void 0 ? void 0 : _a.fire(types_1.ItemEvent.blur, [_this.getValue()]); },
                onkeydown: function (event) {
                    _this.events.fire(types_1.ItemEvent.keydown, [event]);
                },
            };
        }
        else {
            this.config = {
                type: config.type,
                id: config.id,
                text: "",
                width: "content",
                height: "content",
                padding: 0,
            };
            for (var key in config) {
                if (key !== "id" && key !== "type" && key !== "name") {
                    this.config[key] = config[key];
                }
            }
            this._handlers = {
                onchange: function (e) {
                    var checked = e.target.checked;
                    if (!_this.events.fire(types_1.ItemEvent.beforeChange, [_this._getValue(checked)])) {
                        var element = _this.getRootView().refs.input.el;
                        element.checked = !checked;
                        return;
                    }
                    _this.config.checked = checked;
                    _this.events.fire(types_1.ItemEvent.change, [_this.getValue()]);
                    (0, helper_1.isVerify)(_this.config) && _this.validate();
                },
                onfocus: function () { return _this.events.fire(types_1.ItemEvent.focus, [_this.getValue(), _this.config.id]); },
                onblur: function () { return _this.events.fire(types_1.ItemEvent.blur, [_this.getValue(), _this.config.id]); },
                onkeydown: function (event) {
                    _this.events.fire(types_1.ItemEvent.keydown, [event, _this.config.id]);
                },
            };
        }
        if (this.config.hidden) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this.hide(true);
            });
        }
    };
    Checkbox.prototype._initHandlers = function () {
        var _this = this;
        this.events.on(types_1.ItemEvent.change, function () { return _this.paint(); });
    };
    Checkbox.prototype._draw = function () {
        var _a = this.config, id = _a.id, value = _a.value, checked = _a.checked, disabled = _a.disabled, name = _a.name, required = _a.required, $required = _a.$required, text = _a.text, label = _a.label, labelWidth = _a.labelWidth, helpMessage = _a.helpMessage;
        return (0, dom_1.el)("label.dhx_checkbox.dhx_form-group.dhx_form-group--checkbox", {
            class: (0, helper_1.getFormItemCss)(this.config, (0, helper_1.isVerify)(this.config) || !!$required),
        }, !this._inGroup
            ? [
                label || labelWidth || helpMessage || required ? this._drawLabel() : null,
                (0, dom_1.el)(".dhx_checkbox__container", [
                    (0, dom_1.el)(".dhx_checkbox__holder", [
                        (0, dom_1.el)("input.dhx_checkbox__input", {
                            type: "checkbox",
                            "data-dhx-id": name || id,
                            id: id,
                            value: value,
                            name: name,
                            disabled: disabled,
                            checked: checked,
                            onchange: this._handlers.onchange,
                            onfocus: this._handlers.onfocus,
                            onblur: this._handlers.onblur,
                            onkeydown: this._handlers.onkeydown,
                            required: required,
                            _ref: "input",
                            "aria-label": label || "checkbox ".concat(text || ""),
                            "aria-describedby": helpMessage
                                ? "dhx_label__help_".concat(id || this._uid)
                                : null,
                        }),
                        (0, dom_1.el)("span.dhx_checkbox__visual-input"),
                        (0, dom_1.el)("span.dhx_text", [text]),
                    ]),
                    required &&
                        (0, helper_1.getValidationMessage)(this.config) &&
                        (0, dom_1.el)("span.dhx_input__caption", (0, helper_1.getValidationMessage)(this.config)),
                ]),
            ]
            : [
                (0, dom_1.el)(".dhx_checkbox__holder", [
                    (0, dom_1.el)("input.dhx_checkbox__input", {
                        type: "checkbox",
                        id: id,
                        value: value || "",
                        name: name || "",
                        disabled: disabled,
                        checked: checked,
                        onchange: this._handlers.onchange,
                        onfocus: this._handlers.onfocus,
                        onblur: this._handlers.onblur,
                        onkeydown: this._handlers.onkeydown,
                        required: required,
                        _ref: "input",
                    }),
                    (0, dom_1.el)("span.dhx_checkbox__visual-input"),
                    (0, dom_1.el)("span.dhx_text", [text]),
                ]),
            ]);
    };
    return Checkbox;
}(label_1.Label));
exports.Checkbox = Checkbox;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleVault = exports.FileStatus = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var html_1 = __webpack_require__(3);
var core_1 = __webpack_require__(1);
var ts_data_1 = __webpack_require__(7);
var ts_vault_1 = __webpack_require__(58);
var ts_popup_1 = __webpack_require__(13);
var helper_1 = __webpack_require__(6);
var en_1 = __webpack_require__(98);
var types_1 = __webpack_require__(4);
var label_1 = __webpack_require__(10);
var FileStatus;
(function (FileStatus) {
    FileStatus["queue"] = "queue";
    FileStatus["uploaded"] = "uploaded";
    FileStatus["failed"] = "failed";
    FileStatus["inprogress"] = "inprogress";
})(FileStatus || (exports.FileStatus = FileStatus = {}));
var SimpleVault = /** @class */ (function (_super) {
    __extends(SimpleVault, _super);
    function SimpleVault(container, config) {
        var _this = _super.call(this, container, config) || this;
        _this._propsItem = [
            "required",
            "label",
            "labelWidth",
            "labelPosition",
            "hiddenLabel",
            "helpMessage",
            "preMessage",
            "successMessage",
            "errorMessage",
        ];
        _this._propsSimpleVault = [
            "params",
            "headerParams",
            "target",
            "fieldName",
            "singleRequest",
            "updateFromResponse",
            "autosend",
            "accept",
            "validation",
        ];
        _this._props = __spreadArray(__spreadArray(__spreadArray([], helper_1.baseProps, true), _this._propsItem, true), _this._propsSimpleVault, true);
        _this.events = new events_1.EventSystem(_this);
        _this.data = new ts_data_1.DataCollection();
        _this._uploader = new ts_vault_1.Uploader(__assign({ target: "", accept: "", fieldName: "file", singleRequest: false, updateFromResponse: true, autosend: false }, config), _this.data, _this.data.events);
        _this._initView(__assign(__assign({}, _this._uploader.config), config));
        _this._initHandlers();
        var render = function () { return _this._draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    SimpleVault.prototype.send = function (params) {
        this._uploader.send(params);
    };
    SimpleVault.prototype.selectFile = function () {
        this._uploader.selectFile();
    };
    SimpleVault.prototype.setValue = function (value) {
        if (!value.length) {
            return;
        }
        this.data.parse(value);
        (0, helper_1.isVerify)(this.config) && this.validate();
    };
    SimpleVault.prototype.getValue = function () {
        return this.data.serialize();
    };
    SimpleVault.prototype.clear = function () {
        if (this.getValue().length === 0 || !this.events.fire(types_1.ItemEvent.beforeChange, [[]])) {
            return;
        }
        this.data.removeAll();
        this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        (0, helper_1.isVerify)(this.config) && this.setValidationStatus(this.validate(true) ? "success" : "error");
        this.paint();
    };
    SimpleVault.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    SimpleVault.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    SimpleVault.prototype.isDisabled = function () {
        return this.config.disabled;
    };
    SimpleVault.prototype.show = function () {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if (!hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [value])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [value]);
    };
    SimpleVault.prototype.hide = function (init) {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if ((hidden && !init) || !this.events.fire(types_1.ItemEvent.beforeHide, [value, init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [value, init]);
    };
    SimpleVault.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    SimpleVault.prototype.validate = function (silent, value) {
        if (silent === void 0) { silent = false; }
        if (value === void 0) { value = this.getValue(); }
        if (!silent && !this.events.fire(types_1.ItemEvent.beforeValidate, [value])) {
            return false;
        }
        var isValid = !!(typeof this.config.validation === "function"
            ? this.config.validation(value)
            : value.length);
        if (!silent) {
            this.setValidationStatus(isValid ? "success" : "error");
            this.events.fire(types_1.ItemEvent.afterValidate, [value, isValid]);
            this.paint();
        }
        return isValid;
    };
    SimpleVault.prototype.clearValidate = function () {
        this.setValidationStatus();
        this.paint();
    };
    SimpleVault.prototype.setProperties = function (propertyConfig) {
        if (!propertyConfig ||
            (0, core_1.isEmptyObj)(propertyConfig) ||
            !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()]))
            return;
        for (var key in propertyConfig) {
            if (this._props.includes(key)) {
                this.config[key] = propertyConfig[key];
                if (this._propsSimpleVault.includes(key)) {
                    this._uploader.config[key] = propertyConfig[key];
                }
            }
        }
        this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
        this.paint();
    };
    SimpleVault.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this._props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    SimpleVault.prototype.focus = function () {
        var _a, _b, _c;
        (_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el.focus();
        this.paint();
    };
    SimpleVault.prototype.blur = function () {
        var _a, _b, _c;
        (_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el.blur();
        this.paint();
    };
    SimpleVault.prototype.destructor = function () {
        this.events && this.events.clear();
        this._helper && this._helper.destructor();
        this.config = this.events = this._uid = this._helper = this._handlers = this._uploader = this.data = null;
        this._propsItem = this._propsSimpleVault = this._props = this._dragover = this._dragoverTimeout = null;
        this.unmount();
    };
    SimpleVault.prototype._initView = function (config) {
        var _a;
        this.config = __assign({ type: config.type, id: config.id, name: config.name, value: [], disabled: false, hidden: false, css: "", label: "", labelWidth: "", labelPosition: "top", hiddenLabel: false, helpMessage: "", preMessage: "", successMessage: "", errorMessage: "", width: "content", height: "content" }, config);
        if ((_a = config.value) === null || _a === void 0 ? void 0 : _a.length) {
            this.data.parse(config.value);
        }
        this.paint();
    };
    SimpleVault.prototype._initHandlers = function () {
        var _this = this;
        this._handlers = {
            add: function (e) {
                if (_this.config.disabled) {
                    return;
                }
                e.preventDefault();
                _this._uploader.selectFile();
            },
            remove: function (e) {
                if (_this.config.disabled) {
                    return;
                }
                var id = (0, html_1.locate)(e);
                if (!id) {
                    return;
                }
                _this.data.remove(id);
            },
            ondragover: function (e) {
                var types = e.dataTransfer.types;
                for (var _i = 0, types_2 = types; _i < types_2.length; _i++) {
                    var type = types_2[_i];
                    if (type !== "Files" && type !== "application/x-moz-file") {
                        return;
                    }
                }
                if (_this._dragoverTimeout) {
                    clearTimeout(_this._dragoverTimeout);
                }
                else {
                    _this.paint();
                }
                _this._dragover = true;
                _this._dragoverTimeout = setTimeout(function () {
                    _this._dragover = false;
                    _this._dragoverTimeout = null;
                    _this.paint();
                }, 150);
            },
            showHelper: function (e) {
                e.stopPropagation();
                e.preventDefault();
                _this._helper.show(e.target, {
                    mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                    theme: e.target,
                });
            },
            hideHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.hide();
            },
        };
        this._uploader.events.on("beforeUploadFile", function (file) {
            if (_this.config.autosend && !_this.validate(true))
                return false;
            return _this.events.fire(types_1.ItemEvent.beforeUploadFile, [file, _this.config.value]);
        });
        this._uploader.events.on("uploadBegin", function (files) {
            _this.events.fire(types_1.ItemEvent.uploadBegin, [files, _this.config.value]);
        });
        this._uploader.events.on("uploadComplete", function (files) {
            _this.events.fire(types_1.ItemEvent.uploadComplete, [files, _this.config.value]);
        });
        this._uploader.events.on("uploadFail", function (file) {
            _this.events.fire(types_1.ItemEvent.uploadFail, [file, _this.config.value]);
        });
        this._uploader.events.on("uploadFile", function (file, extra) {
            _this.events.fire(types_1.ItemEvent.uploadFile, [file, _this.config.value, extra]);
        });
        this._uploader.events.on("uploadProgress", function (progress) {
            _this.events.fire(types_1.ItemEvent.uploadProgress, [progress, _this.config.value]);
        });
        this.data.events.on(ts_data_1.DataEvents.beforeAdd, function (file) {
            return _this.events.fire(types_1.ItemEvent.beforeChange, [__spreadArray(__spreadArray([], _this.config.value, true), [file], false), file]);
        });
        this.data.events.on(ts_data_1.DataEvents.beforeRemove, function (file) {
            var value = _this.config.value.filter(function (i) { return i.id !== file.id; });
            return _this.events.fire(types_1.ItemEvent.beforeChange, [value, file]);
        });
        this.data.events.on(types_1.ItemEvent.change, function (_id, method, file) {
            if (!method) {
                return;
            }
            var value = (_this.config.value = _this.getValue());
            if (!(_this._uploader.isActive && method === "update")) {
                _this.events.fire(types_1.ItemEvent.change, [value, file]);
                (0, helper_1.isVerify)(_this.config) && _this.validate();
            }
            _this.paint();
        });
    };
    SimpleVault.prototype._draw = function () {
        var _this = this;
        if (this.config.helpMessage) {
            if (this._helper) {
                this._helper.attachHTML(this.config.helpMessage);
            }
            else {
                this._helper = new ts_popup_1.Popup({
                    css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
                });
                this._helper.attachHTML(this.config.helpMessage);
            }
        }
        var files = this.data.getLength()
            ? (0, dom_1.el)("ul.dhx_simplevault__files.dhx_simplevault-files", {
                class: this.config.$vaultHeight ? "" : "dhx_simplevault-files__fixed",
            }, this.data.map(function (file) {
                return (0, dom_1.el)("li.dhx_simplevault-files__item", [
                    (0, dom_1.el)("span.dhx_simplevault-files__item-name", (file.file && file.file.name) || file.name),
                    (0, dom_1.el)(".dhx_button.dhx_simplevault-files__delete.dhx_button--icon.dhx_button--view_link.dhx_button--size_small.dhx_button--color_secondary.dhx_button--circle", {
                        "data-dhx-id": file.id,
                        onclick: _this._handlers.remove,
                    }, [(0, dom_1.el)("span.dxi.dxi-delete-forever")]),
                ]);
            }))
            : null;
        var _a = this.config, id = _a.id, helpMessage = _a.helpMessage, disabled = _a.disabled, required = _a.required, label = _a.label, hidden = _a.hidden, accept = _a.accept;
        var labelStyle = (0, html_1.getLabelStyle)(this.config);
        var visibility = (hidden && " dhx_form-group--hidden") || "";
        return (0, dom_1.el)(".dhx_form-group.dhx_form-group--simplevault", {
            class: (0, helper_1.getFormItemCss)(this.config, (0, helper_1.isVerify)(this.config)) + visibility,
        }, [
            labelStyle &&
                (0, dom_1.el)("legend.dhx_label", {
                    class: helpMessage ? "dhx_label--with-help" : "",
                    style: labelStyle.style,
                    onclick: this._handlers.add,
                    "aria-label": label || "select files",
                }, helpMessage
                    ? [
                        (labelStyle.label || required) &&
                            (0, dom_1.el)("span.dhx_label__holder", labelStyle.label),
                        (0, dom_1.el)("span.dhx_label-help.dxi.dxi-help-circle-outline", {
                            tabindex: "0",
                            role: "button",
                            onclick: this._handlers.showHelper,
                            onfocus: this._handlers.showHelper,
                            onblur: this._handlers.hideHelper,
                        }),
                    ]
                    : labelStyle.label),
            (0, dom_1.el)(".dhx_input__wrapper", { id: this._uid }, [
                (0, dom_1.el)("div", {
                    _hooks: {
                        didInsert: function (node) {
                            _this._uploader.linkDropArea(node.el);
                        },
                    },
                    ondragover: this._handlers.ondragover,
                    class: "dhx_simplevault" + (this._dragover ? " dhx_simplevault--on-drag" : ""),
                }, [
                    (0, dom_1.el)("div.dhx_simplevault-loader", [
                        (0, dom_1.el)("span.dhx_simplevault__icon.dxi.dxi-vault"),
                    ]),
                    (0, dom_1.el)(".dhx_simplevault__drop-area", [
                        (0, dom_1.el)("input.dhx_simplevault__input", {
                            _ref: "input",
                            type: "file",
                            id: id,
                            disabled: disabled,
                            accept: accept,
                        }),
                        (0, dom_1.el)("span.dhx_simplevault__icon.dxi.dxi-vault"),
                        (0, dom_1.el)("span.dhx_simplevault__title", [
                            (0, dom_1.el)("span", en_1.default.simpleVaultText),
                            (0, dom_1.el)("br"),
                            (0, dom_1.el)("label.dhx_simplevault__label", {
                                onclick: this._handlers.add,
                                for: id,
                            }, " " + en_1.default.simpleVaultLabel),
                        ]),
                    ]),
                    files,
                ]),
                (0, helper_1.getValidationMessage)(this.config) &&
                    (0, dom_1.el)("span.dhx_input__caption", {}, (0, helper_1.getValidationMessage)(this.config)),
            ]),
        ]);
    };
    return SimpleVault;
}(label_1.Label));
exports.SimpleVault = SimpleVault;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    simpleVaultText: "Drag & drop files or folders here or",
    simpleVaultLabel: "browse files",
};


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToggleButton = void 0;
var types_1 = __webpack_require__(4);
var view_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var helper_1 = __webpack_require__(6);
var core_1 = __webpack_require__(1);
var ToggleButton = /** @class */ (function (_super) {
    __extends(ToggleButton, _super);
    function ToggleButton(container, config) {
        var _this = _super.call(this, container, __assign({ full: false, selected: false, disabled: false, hidden: false, width: "content", height: "content", text: "", icon: "", offIcon: "", offText: "", css: "", padding: "" }, config)) || this;
        _this.events = new events_1.EventSystem();
        _this.props = __spreadArray(__spreadArray([], (_this.config.$group ? [] : helper_1.baseProps), true), [
            "value",
            "offIcon",
            "offText",
            "icon",
            "text",
            "full",
        ], false);
        if (_this.config.hidden) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this.hide(true);
            });
        }
        _this.initHandlers();
        var render = function () { return _this.draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    ToggleButton.prototype.setValue = function (selected, silent) {
        if (selected === void 0) { selected = false; }
        if (silent === void 0) { silent = false; }
        if (typeof selected !== "boolean" ||
            selected === this.config.selected ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChange, [selected]))) {
            return;
        }
        this.config.selected = selected;
        !silent && this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        this.paint();
    };
    ToggleButton.prototype.getValue = function () {
        var _a = this.config, value = _a.value, selected = _a.selected;
        if (typeof value === "string")
            return selected ? value : "";
        if (typeof value === "number")
            return selected ? value : 0;
        return !!selected;
    };
    ToggleButton.prototype.isSelected = function () {
        return !!this.config.selected;
    };
    ToggleButton.prototype.show = function () {
        if (!this.config.hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [this.getValue()])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [this.getValue()]);
    };
    ToggleButton.prototype.hide = function (init) {
        if (init === void 0) { init = false; }
        if ((this.config.hidden && !init) ||
            !this.events.fire(types_1.ItemEvent.beforeHide, [this.getValue(), init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [this.getValue(), init]);
    };
    ToggleButton.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    ToggleButton.prototype.focus = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.button.el.focus();
            _this.paint();
        });
    };
    ToggleButton.prototype.blur = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.button.el.blur();
            _this.paint();
        });
    };
    ToggleButton.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    ToggleButton.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    ToggleButton.prototype.isDisabled = function () {
        return !!this.config.disabled;
    };
    ToggleButton.prototype.setProperties = function (config) {
        if (!config ||
            (0, core_1.isEmptyObj)(config) ||
            !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()]))
            return;
        for (var key in config) {
            if (this.props.includes(key))
                this.config[key] = config[key];
        }
        this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
    };
    ToggleButton.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this.props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    ToggleButton.prototype.destructor = function () {
        this.events.clear();
        this.unmount();
    };
    ToggleButton.prototype.draw = function () {
        var _a = this.config, id = _a.id, name = _a.name, selected = _a.selected, disabled = _a.disabled, hidden = _a.hidden, text = _a.text, offText = _a.offText, icon = _a.icon, offIcon = _a.offIcon, full = _a.full, $group = _a.$group, $gap = _a.$gap, $extraCss = _a.$extraCss, css = _a.css;
        return (0, dom_1.el)("button.dhx_toggle", {
            "data-dhx-id": name || id,
            role: "button",
            type: "button",
            "aria-pressed": selected,
            "aria-label": text || name,
            disabled: disabled,
            class: ((!$group && "dhx_form-group dhx_form-group--toggle ") || "") +
                ((selected && "dhx_toggle--selected ") || "") +
                ((disabled && "dhx_toggle--disabled ") || "") +
                ((hidden && "dhx_toggle--hidden ") || "") +
                ((full && "dhx_toggle--full ") || "") +
                (($group && $extraCss) || "") +
                (($group && css) || ""),
            style: {
                marginLeft: $gap,
            },
            onclick: this.handlers.onclick,
            onfocus: this.handlers.onfocus,
            onblur: this.handlers.onblur,
            onkeydown: this.handlers.onkeydown,
            _ref: "button",
        }, [
            icon && (0, dom_1.el)("i.dhx_toggle__icon", { class: selected ? icon : offIcon || icon }),
            text && (0, dom_1.el)("span.dhx_toggle__text", {}, selected ? text : offText || text),
        ]);
    };
    ToggleButton.prototype.initHandlers = function () {
        var _this = this;
        this.handlers = {
            onclick: function () { return _this.setValue(!_this.config.selected); },
            onfocus: function () { return _this.events.fire(types_1.ItemEvent.focus, [_this.getValue()]); },
            onblur: function () { return _this.events.fire(types_1.ItemEvent.blur, [_this.getValue()]); },
            onkeydown: function (event) { return _this.events.fire(types_1.ItemEvent.keydown, [event]); },
        };
    };
    return ToggleButton;
}(view_1.View));
exports.ToggleButton = ToggleButton;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ribbon = void 0;
var dom_1 = __webpack_require__(0);
var ts_navbar_1 = __webpack_require__(21);
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(3);
var ts_message_1 = __webpack_require__(11);
var Ribbon = /** @class */ (function (_super) {
    __extends(Ribbon, _super);
    function Ribbon(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            navigationType: "click",
            $name: "ribbon",
        }, config)) || this;
        _this._widgetHeight = [];
        _this._listeners = {
            input: function (e) {
                var id = (0, html_1.locate)(e);
                var item = _this.data.getItem(id);
                if (!item)
                    return;
                var value = e.target.value;
                _this.data.update(id, { value: value });
                if (item.type === "input") {
                    _this.events.fire(ts_navbar_1.NavigationBarEvents.input, [id, value]);
                }
            },
            tooltip: function (e) {
                var elem = (0, html_1.locateNode)(e);
                if (!elem) {
                    return;
                }
                var id = elem.getAttribute("data-dhx-id");
                var item = _this.data.getItem(id);
                if (item.tooltip) {
                    (0, ts_message_1.tooltip)(item.tooltip, {
                        node: elem,
                        position: ts_message_1.Position.bottom,
                    });
                }
            },
        };
        _this._currentRoot = null;
        var render = function () { return _this._draw(); };
        _this.mount(element, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Ribbon.prototype.getState = function () {
        var state = {};
        this.data.eachChild(this.data.getRoot(), function (item) {
            if (item.twoState && !item.group) {
                state[item.id] = item.active;
            }
            else if (item.type === "input" ||
                item.type === "selectButton" ||
                item.type === "datePicker") {
                state[item.id] = item.value;
            }
        }, true);
        for (var key in this._groups) {
            if (this._groups[key].active) {
                state[key] = this._groups[key].active;
            }
        }
        return state;
    };
    Ribbon.prototype.setState = function (state) {
        for (var key in state) {
            if (this._groups && this._groups[key]) {
                if (this._groups[key].active) {
                    this.data.update(this._groups[key].active, { active: false });
                    this._groups[key].active = state[key];
                    this.data.update(state[key], { active: true });
                }
            }
            else {
                var item = this.data.getItem(key);
                switch (item.type) {
                    case "input":
                    case "selectButton":
                        this.data.update(key, { value: state[key] });
                        break;
                    case "datePicker":
                        if (item.$calendar) {
                            item.$calendar.setValue(state[key]);
                        }
                        else {
                            this.data.update(key, { value: state[key] });
                        }
                        break;
                    default:
                        this.data.update(key, { active: state[key] });
                }
            }
        }
    };
    Ribbon.prototype._getFactory = function () {
        return (0, ts_navbar_1.createFactory)({
            widget: this,
            defaultType: "navItem",
            allowedTypes: [
                "navItem",
                "button",
                "imageButton",
                "selectButton",
                "customHTML",
                "input",
                "separator",
                "spacer",
                "title",
                "block",
                "datePicker",
                "customHTMLButton",
            ],
            widgetName: "ribbon",
        });
    };
    Ribbon.prototype._getMode = function (item, root) {
        return item.id === root ? "bottom" : "right";
    };
    Ribbon.prototype._close = function (e) {
        this._activePosition = null;
        this._currentRoot = null;
        _super.prototype._close.call(this, e);
    };
    Ribbon.prototype._draw = function () {
        var _this = this;
        this._heightCalculate();
        var itemsHeight = Math.max.apply(Math, this._widgetHeight);
        return (0, dom_1.el)("ul.dhx_ribbon.dhx_widget", {
            "data-dhx-widget-id": this._uid,
            class: this.config.css ? this.config.css : "",
            tabindex: 0,
            onclick: this._handlers.onclick,
            onmousedown: this._handlers.onmousedown,
            oninput: this._listeners.input,
            onmouseover: this._listeners.tooltip,
            onkeydown: this._handlers.onkeydown,
            _hooks: {
                didInsert: function (node) {
                    node.el.addEventListener("keyup", function (e) {
                        if (e.which !== 9) {
                            return;
                        }
                        var elem = (0, html_1.locateNode)(document.activeElement);
                        if (!elem) {
                            return;
                        }
                        var id = elem.getAttribute("data-dhx-id");
                        var item = _this.data.getItem(id);
                        if (item.tooltip) {
                            (0, ts_message_1.tooltip)(item.tooltip, {
                                node: elem,
                                position: ts_message_1.Position.bottom,
                                force: true,
                            });
                        }
                    }, true);
                },
            },
        }, [
            (0, dom_1.el)("li", {
                class: "dhx_ribbon-block dhx_ribbon-block--root",
                style: { height: this._haveTitle ? itemsHeight + 24 : itemsHeight },
            }, [
                (0, dom_1.el)("ul.dhx_ribbon-content.dhx_ribbon-content--full-width", {
                    style: { height: itemsHeight },
                }, this.data.map(function (block) {
                    return block.type === "block"
                        ? _this._drawBlock(block, true)
                        : _this._factory(block);
                }, this.data.getRoot(), false)),
            ]),
        ]);
    };
    Ribbon.prototype._setRoot = function (id) {
        var parentId = this.data.getParent(id);
        if (this.data.getItem(parentId).type === "block") {
            this._currentRoot = id;
        }
    };
    Ribbon.prototype._drawBlock = function (block, isFirst) {
        var _this = this;
        if (!block || block.hidden) {
            return null;
        }
        var classNames = "dhx_ribbon-block" +
            (" dhx_ribbon-block" + (block.direction === "col" ? "--col" : "--row")) +
            (block.title ? " dhx_ribbon-block--title" : "") +
            (block.css ? " " + block.css : "") +
            (isFirst ? " dhx_ribbon-block--indented" : "");
        var childs = block.items.map(function (child) {
            if (child.type === "block") {
                return _this._drawBlock(child);
            }
            if (child.type !== "separator" && child.type !== "spacer") {
                return _this._factory(child);
            }
            return null;
        }, block.id, false);
        return (0, dom_1.el)("li", {
            class: classNames,
        }, [
            (0, dom_1.el)("ul.dhx_ribbon-content", childs),
            block.title
                ? (0, dom_1.el)("span.dhx_ribbon-content-label-wrapper", [
                    (0, dom_1.el)("span.dhx_ribbon-content-label", block.title),
                ])
                : null,
        ]);
    };
    Ribbon.prototype._getBlockHeight = function (block) {
        if (block.hidden)
            return 0;
        return block.size === "medium" && block.type !== "button" ? 72 : 36;
    };
    Ribbon.prototype._heightCalculate = function (data) {
        var _this = this;
        if (data === void 0) { data = this.data; }
        data.forEach(function (block) {
            var blockHeight;
            if (block.type === "block" && block.direction === "col") {
                blockHeight = block.items.reduce(function (count, item) { return count + _this._getBlockHeight(item); }, 0);
                _this._heightCalculate(block.items);
            }
            else {
                blockHeight = _this._getBlockHeight(block);
            }
            if (block.title) {
                _this._haveTitle = true;
            }
            _this._widgetHeight.push(blockHeight);
        });
    };
    return Ribbon;
}(ts_navbar_1.Navbar));
exports.Ribbon = Ribbon;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sidebar = void 0;
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(3);
var types_1 = __webpack_require__(102);
var ts_message_1 = __webpack_require__(11);
var ts_navbar_1 = __webpack_require__(21);
var core_1 = __webpack_require__(1);
var Sidebar = /** @class */ (function (_super) {
    __extends(Sidebar, _super);
    function Sidebar(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            navigationType: "click",
            width: "200",
            minWidth: "44",
            collapsed: false,
            $name: "sidebar",
        }, config)) || this;
        _this._currentRoot = null;
        var render = function () { return _this._draw(); };
        _this.mount(element, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Sidebar.prototype.toggle = function () {
        if (this.config.collapsed) {
            this.expand();
        }
        else {
            this.collapse();
        }
        this.events.fire(types_1.SidebarEvents.toggle, [this.config.collapsed]); // TODO: remove suite_7.0
        this.paint();
    };
    Sidebar.prototype.collapse = function () {
        if (!this.events.fire(types_1.SidebarEvents.beforeCollapse, [])) {
            return;
        }
        this.config.collapsed = true;
        this.events.fire(types_1.SidebarEvents.afterCollapse, []);
        this.paint();
    };
    Sidebar.prototype.expand = function () {
        if (!this.events.fire(types_1.SidebarEvents.beforeExpand, [])) {
            return;
        }
        this.config.collapsed = false;
        this.events.fire(types_1.SidebarEvents.afterExpand, []);
        this.paint();
    };
    Sidebar.prototype.isCollapsed = function () {
        return this.config.collapsed;
    };
    Sidebar.prototype._getFactory = function () {
        return (0, ts_navbar_1.createFactory)({
            widget: this,
            defaultType: "navItem",
            allowedTypes: [
                "navItem",
                "menuItem",
                "customHTML",
                "separator",
                "spacer",
                "title",
                "customHTMLButton",
            ],
            widgetName: "sidebar",
        });
    };
    Sidebar.prototype._close = function (e) {
        this._activePosition = null;
        this._currentRoot = null;
        _super.prototype._close.call(this, e);
    };
    Sidebar.prototype._setRoot = function (id) {
        if (this.data.getParent(id) === this.data.getRoot()) {
            this._currentRoot = id;
        }
    };
    Sidebar.prototype._customHandlers = function () {
        var _this = this;
        return {
            tooltip: function (e) {
                var elem = (0, html_1.locateNode)(e);
                if (!elem) {
                    return;
                }
                var id = elem.getAttribute("data-dhx-id");
                var item = _this.data.getItem(id);
                if (item.tooltip || (_this.config.collapsed && item.value)) {
                    (0, ts_message_1.tooltip)(item.tooltip || item.value, {
                        node: elem,
                        position: ts_message_1.Position.right,
                    });
                }
            },
        };
    };
    Sidebar.prototype._draw = function () {
        var _this = this;
        var _a = this.config, width = _a.width, minWidth = _a.minWidth;
        var actualWidth = this.config.collapsed ? minWidth : width;
        return (0, dom_1.el)("nav.dhx_widget.dhx_sidebar", {
            class: (this.config.css ? this.config.css : "") +
                (this.config.collapsed ? " dhx_sidebar--minimized" : ""),
            style: { width: actualWidth + "px" },
        }, [
            (0, dom_1.el)("ul.dhx_navbar.dhx_navbar--vertical", {
                "data-dhx-widget-id": this._uid,
                tabindex: 0,
                onclick: this._handlers.onclick,
                onmousedown: this._handlers.onmousedown,
                oninput: this._handlers.input,
                onmouseover: this._handlers.tooltip,
                onkeydown: this._handlers.onkeydown,
                _hooks: {
                    didInsert: function (node) {
                        node.el.addEventListener("keyup", function (e) {
                            if (e.which !== 9) {
                                return;
                            }
                            var elem = (0, html_1.locateNode)(document.activeElement);
                            if (!elem) {
                                return;
                            }
                            var id = elem.getAttribute("data-dhx-id");
                            var item = _this.data.getItem(id);
                            if (item.tooltip || (_this.config.collapsed && item.value)) {
                                (0, ts_message_1.tooltip)(item.tooltip || item.value, {
                                    node: elem,
                                    position: ts_message_1.Position.right,
                                    force: true,
                                });
                            }
                        }, true);
                    },
                },
            }, this.data.map(function (item) { return _this._factory(item, false); }, this.data.getRoot(), false)),
        ]);
    };
    Sidebar.prototype._getMode = function () {
        return "right";
    };
    Sidebar.prototype._customInitEvents = function () {
        var _this = this;
        this.events.on(ts_navbar_1.NavigationBarEvents.inputBlur, function () {
            if (_this._waitRestore) {
                _this.toggle();
                _this._waitRestore = false;
            }
        });
        this.events.on(ts_navbar_1.NavigationBarEvents.inputFocus, function () {
            if (_this.config.collapsed) {
                _this._waitRestore = true;
                _this.toggle();
            }
        });
    };
    return Sidebar;
}(ts_navbar_1.Navbar));
exports.Sidebar = Sidebar;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SidebarEvents = void 0;
var SidebarEvents;
(function (SidebarEvents) {
    SidebarEvents["beforeCollapse"] = "beforeCollapse";
    SidebarEvents["afterCollapse"] = "afterCollapse";
    SidebarEvents["beforeExpand"] = "beforeExpand";
    SidebarEvents["afterExpand"] = "afterExpand";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    SidebarEvents["toggle"] = "toggle";
})(SidebarEvents || (exports.SidebarEvents = SidebarEvents = {}));


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TabbarEvents = void 0;
var TabbarEvents;
(function (TabbarEvents) {
    TabbarEvents["beforeChange"] = "beforeChange";
    TabbarEvents["change"] = "change";
    TabbarEvents["beforeClose"] = "beforeClose";
    TabbarEvents["afterClose"] = "afterClose";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TabbarEvents["close"] = "close";
})(TabbarEvents || (exports.TabbarEvents = TabbarEvents = {}));


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Editor = exports.EditorEvents = exports.EditorMode = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var html_1 = __webpack_require__(3);
var KeyManager_1 = __webpack_require__(14);
var EditorMode;
(function (EditorMode) {
    EditorMode["editText"] = "text";
    EditorMode["selectItem"] = "select";
})(EditorMode || (exports.EditorMode = EditorMode = {}));
var EditorEvents;
(function (EditorEvents) {
    EditorEvents["begin"] = "begin";
    EditorEvents["end"] = "end";
})(EditorEvents || (exports.EditorEvents = EditorEvents = {}));
var Editor = /** @class */ (function () {
    function Editor() {
        var _this = this;
        this.events = new events_1.EventSystem();
        this._keyManager = new KeyManager_1.KeyManager();
        this._documentClick = function (e) {
            var id = (0, html_1.locate)(e, "id");
            if (id !== "input_" + _this._item.id) {
                _this._removeClickListener();
                _this._finishEdit();
            }
        };
        this._handlers = {
            editText: function (e) {
                _this._currentValue = e.target.innerText;
            },
            itemSelected: function (e) {
                _this._currentValue = e.target.value;
                _this._finishEdit();
            },
            didInsert: function (node) {
                var element = node === null || node === void 0 ? void 0 : node.el;
                if (element) {
                    if (element.childNodes.length) {
                        var range = document.createRange();
                        var selection = window.getSelection();
                        range.setStart(element.childNodes[0], element.innerText.length);
                        range.collapse(true);
                        selection.removeAllRanges();
                        selection.addRange(range);
                    }
                    element.focus();
                }
            },
        };
    }
    Editor.prototype.edit = function (targetId, config) {
        if (this._active && this._item !== config.item) {
            this._finishEdit();
        }
        this._active = true;
        this._targetId = targetId;
        this.config = config;
        this._item = config.item;
        this._currentValue = this._item.value;
        this.events.fire(EditorEvents.begin, [targetId]);
        this._initOuterClick();
        this._addHotkeys();
        return this._draw();
    };
    Editor.prototype.isEditable = function () {
        return this._active;
    };
    Editor.prototype._draw = function () {
        var _this = this;
        if (this.config.mode === EditorMode.selectItem) {
            var opts = this.config.options;
            return (0, dom_1.el)("select", {
                id: "input_" + this._item.id,
                "data-dhx-id": this._item.id,
                onchange: this._handlers.itemSelected,
            }, opts.map(function (item) {
                return (0, dom_1.el)("option", {
                    class: "editor-select",
                    value: item,
                    selected: _this._currentValue === item,
                    style: { border: "1px solid" },
                }, item);
            }));
        }
        else {
            return (0, dom_1.el)("div.dhx_tree-editor", {
                _hooks: {
                    didInsert: this._handlers.didInsert,
                },
                id: "input_" + this._item.id,
                oninput: this._handlers.editText,
                contentEditable: true,
            }, this._currentValue);
        }
    };
    Editor.prototype._addHotkeys = function () {
        var _this = this;
        this._keyManager.addHotKey("escape", function () {
            _this._finishEdit();
        });
        this._keyManager.addHotKey("enter", function () {
            _this._finishEdit();
        });
    };
    Editor.prototype._removeHotkeys = function () {
        this._keyManager.removeHotKey();
    };
    Editor.prototype._finishEdit = function () {
        if (!this.events.fire(EditorEvents.end, [this._targetId, this._item.id, this._currentValue]))
            return;
        this._clear();
    };
    Editor.prototype._clear = function () {
        this._active = false;
        this._removeClickListener();
        this._removeHotkeys();
    };
    Editor.prototype._initOuterClick = function () {
        document.addEventListener("click", this._documentClick);
    };
    Editor.prototype._removeClickListener = function () {
        document.removeEventListener("click", this._documentClick);
    };
    return Editor;
}());
exports.Editor = Editor;


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeEvents = exports.SelectStatus = void 0;
var SelectStatus;
(function (SelectStatus) {
    SelectStatus[SelectStatus["unselected"] = 0] = "unselected";
    SelectStatus[SelectStatus["selected"] = 1] = "selected";
    SelectStatus[SelectStatus["indeterminate"] = 2] = "indeterminate";
})(SelectStatus || (exports.SelectStatus = SelectStatus = {}));
var TreeEvents;
(function (TreeEvents) {
    TreeEvents["itemClick"] = "itemclick";
    TreeEvents["itemDblClick"] = "itemdblclick";
    TreeEvents["itemRightClick"] = "itemrightclick";
    TreeEvents["beforeCollapse"] = "beforeCollapse";
    TreeEvents["afterCollapse"] = "afterCollapse";
    TreeEvents["beforeExpand"] = "beforeExpand";
    TreeEvents["afterExpand"] = "afterExpand";
    TreeEvents["beforeEditStart"] = "beforeEditStart";
    TreeEvents["afterEditStart"] = "afterEditStart";
    TreeEvents["beforeEditEnd"] = "beforeEditEnd";
    TreeEvents["afterEditEnd"] = "afterEditEnd";
    TreeEvents["focusChange"] = "focusChange";
    TreeEvents["beforeCheck"] = "beforeCheck";
    TreeEvents["afterCheck"] = "afterCheck";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TreeEvents["itemContextMenu"] = "itemcontextmenu";
})(TreeEvents || (exports.TreeEvents = TreeEvents = {}));


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Window = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(2);
var KeyManager_1 = __webpack_require__(14);
var FocusManager_1 = __webpack_require__(19);
var ts_layout_1 = __webpack_require__(12);
var ts_toolbar_1 = __webpack_require__(37);
var helpers_1 = __webpack_require__(241);
var types_1 = __webpack_require__(107);
var WindowController_1 = __webpack_require__(242);
var ts_navbar_1 = __webpack_require__(21);
var Window = /** @class */ (function () {
    function Window(config) {
        var _this = this;
        this.config = (0, core_1.extend)({
            movable: false,
            resizable: false,
            closable: config.modal,
        }, config);
        if (this.config.node && typeof this.config.node === "string") {
            this.config.node = document.getElementById(this.config.node);
        }
        else if (!this.config.node) {
            this.config.node = document.body;
        }
        this._uid = (0, core_1.uid)();
        this.events = new events_1.EventSystem(this);
        var popup = (this._popup = document.createElement("div"));
        popup.tabIndex = 1;
        popup.setAttribute("role", "dialog");
        popup.setAttribute("aria-modal", "".concat(this.config.modal || false));
        if (!this.config.modal) {
            WindowController_1.default.add(this._uid, this._popup);
        }
        this._fullScreen = false;
        this._isActive = false;
        this._keyManager = new KeyManager_1.KeyManager(function (_, focusId) {
            return focusId === _this._uid || _this.getContainer().contains(document.activeElement);
        });
        this._initHandlers();
        this._initUI();
        if (this.config.html) {
            this.attachHTML(this.config.html);
        }
    }
    Window.prototype.paint = function () {
        this._layout.paint();
    };
    Window.prototype.isFullScreen = function () {
        return this._fullScreen;
    };
    Window.prototype.setFullScreen = function () {
        if (!this._fullScreen) {
            this._fullScreen = true;
            this.setSize(window.innerWidth, window.innerHeight);
            this.setPosition(window.pageXOffset, window.pageYOffset);
        }
    };
    Window.prototype.unsetFullScreen = function () {
        if (this._fullScreen) {
            this._fullScreen = false;
            this.setSize(this._oldSizes.width, this._oldSizes.height);
            this.setPosition(this._oldPosition.left, this._oldPosition.top);
        }
    };
    Window.prototype.setSize = function (width, height) {
        this._oldSizes = {
            width: this._popup.offsetWidth,
            height: this._popup.offsetHeight,
        };
        var size = {
            width: this._oldSizes.width,
            height: this._oldSizes.height,
        };
        if ((0, core_1.isDefined)(width)) {
            this.config.width = size.width = width;
        }
        if ((0, core_1.isDefined)(height)) {
            this.config.height = size.height = height;
        }
        this._popup.style.width = size.width + "px";
        this._popup.style.height = size.height + "px";
        this.events.fire(types_1.WindowEvents.resize, [
            size,
            this._oldSizes,
            { left: true, top: true, bottom: true, right: true },
        ]);
    };
    Window.prototype.getSize = function () {
        return {
            width: this._popup.offsetWidth,
            height: this._popup.offsetHeight,
        };
    };
    Window.prototype.setPosition = function (left, top) {
        this._oldPosition = {
            left: this._popup.offsetLeft,
            top: this._popup.offsetTop,
        };
        var position = {
            left: this._oldPosition.left,
            top: this._oldPosition.top,
        };
        if ((0, core_1.isDefined)(left)) {
            this.config.left = position.left = left;
        }
        if ((0, core_1.isDefined)(top)) {
            this.config.top = position.top = top;
        }
        this._popup.style.left = position.left + "px";
        this._popup.style.top = position.top + "px";
        this.events.fire(types_1.WindowEvents.resize, [
            position,
            this._oldPosition,
            { left: true, top: true, bottom: true, right: true },
        ]);
    };
    Window.prototype.getPosition = function () {
        return {
            left: this._popup.offsetLeft,
            top: this._popup.offsetTop,
        };
    };
    Window.prototype.show = function (left, top) {
        if (left === void 0) { left = this.config.left; }
        if (top === void 0) { top = this.config.top; }
        if (!this.events.fire(types_1.WindowEvents.beforeShow, [{ left: left, top: top }])) {
            return;
        }
        if (this.isVisible()) {
            this.hide();
        }
        WindowController_1.default.setActive(this._uid);
        this._popup.className +=
            " dhx_popup dhx_widget" +
                (this.config.modal ? " dhx_popup--window_modal" : " dhx_popup--window") +
                (this.config.css ? " " + this.config.css : "");
        this._popup.style.position = this.config.modal ? "fixed" : "absolute";
        this._popup.setAttribute("data-dhx-widget-id", this._uid);
        var _a = this._getContainerParams(), containerInnerWidth = _a.containerInnerWidth, containerInnerHeight = _a.containerInnerHeight, containerXOffset = _a.containerXOffset, containerYOffset = _a.containerYOffset;
        var width = (this.config.width =
            (typeof this.config.width === "number" && this.config.width) ||
                (typeof this.config.minWidth === "number" && this.config.minWidth) ||
                containerInnerWidth / 2);
        var height = (this.config.height =
            (typeof this.config.height === "number" && this.config.height) ||
                (typeof this.config.minHeight === "number" && this.config.minHeight) ||
                containerInnerHeight / 2);
        this.config.left = left = (0, core_1.isDefined)(left)
            ? left
            : (containerInnerWidth - width) / (this.config.modal ? 2 : 2 + containerXOffset);
        this.config.top = top = (0, core_1.isDefined)(top)
            ? top
            : (containerInnerHeight - height) / (this.config.modal ? 2 : 2 + containerYOffset);
        if (this._isActive) {
            this._popup.style.left = left + "px";
            this._popup.style.top = top + "px";
            return;
        }
        if (this.config.viewportOverflow) {
            WindowController_1.default.openFreeWindow(this.config.node);
        }
        if (this.config.modal) {
            this._blockScreen();
        }
        this._popup.style.width = width + "px";
        this._popup.style.height = height + "px";
        this._popup.style.left = left + "px";
        this._popup.style.top = top + "px";
        this.config.node.appendChild(this._popup);
        this._popup.focus();
        this._isActive = true;
        this.events.fire(types_1.WindowEvents.afterShow, [{ left: left, top: top }]);
        FocusManager_1.focusManager.setFocusId(this._uid);
    };
    Window.prototype.hide = function () {
        this._hide();
    };
    Window.prototype._hide = function (e) {
        if (!this._isActive ||
            !this.events.fire(types_1.WindowEvents.beforeHide, [{ left: this.config.left, top: this.config.top }, e])) {
            return;
        }
        if (this.config.viewportOverflow) {
            WindowController_1.default.closeFreeWindow(this.config.node);
        }
        if (this._blocker) {
            this.config.node.removeChild(this._blocker);
            if (this.config.closable) {
                this._keyManager.removeHotKey(null, this);
            }
            this._blocker = null;
        }
        this.config.node.removeChild(this._popup);
        this._isActive = false;
        this.events.fire(types_1.WindowEvents.afterHide, [{ left: this.config.left, top: this.config.top }, e]);
    };
    Window.prototype.isVisible = function () {
        return this._isActive;
    };
    Window.prototype.getWidget = function () {
        return this._layout.getCell("content").getWidget();
    };
    Window.prototype.getContainer = function () {
        return this.getRootView().data._container;
    };
    Window.prototype.attach = function (name, config) {
        this._layout.getCell("content").attach(name, config);
    };
    Window.prototype.attachHTML = function (html) {
        this._layout.getCell("content").attachHTML(html);
    };
    Window.prototype.getRootView = function () {
        return this._layout.getRootView();
    };
    Window.prototype.destructor = function () {
        this._isActive && this.hide();
        this.header && this.header.destructor();
        this.footer && this.footer.destructor();
        this.events && this.events.clear();
        this._keyManager && this._keyManager.destructor();
        this._layout && this._layout.destructor();
        this.config = this.header = this.footer = this.events = null;
        this._popup = this._uid = this._handlers = this._isActive = this._keyManager = this._fullScreen = this._oldSizes = this._oldPosition = null;
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Window.prototype.fullScreen = function () {
        this.setFullScreen();
    };
    Window.prototype._initHandlers = function () {
        var _this = this;
        this._handlers = {
            headerDblClick: function (e) { return _this.events.fire(types_1.WindowEvents.headerDoubleClick, [e]); },
            move: function (e) {
                if (e.which === 3) {
                    return;
                }
                e.preventDefault();
                (0, helpers_1.detectDrag)(e).then(function (pos) {
                    if (pos) {
                        _this._startDrag(pos.x, pos.y);
                    }
                });
            },
            resize: {
                ".dhx_window-resizer": function (e) {
                    if (e.which === 3) {
                        return;
                    }
                    e.preventDefault();
                    WindowController_1.default.setActive(_this._uid);
                    (0, helpers_1.detectDrag)(e).then(function (pos) {
                        if (pos) {
                            var classList = e.target.classList;
                            if (classList.contains("dhx_window-resizer--left")) {
                                _this._startResize({ left: true });
                            }
                            else if (classList.contains("dhx_window-resizer--right")) {
                                _this._startResize({ right: true });
                            }
                            else if (classList.contains("dhx_window-resizer--top")) {
                                _this._startResize({ top: true });
                            }
                            else if (classList.contains("dhx_window-resizer--bottom")) {
                                _this._startResize({ bottom: true });
                            }
                            else if (classList.contains("dhx_window-resizer--bottom_left")) {
                                _this._startResize({ left: true, bottom: true });
                            }
                            else if (classList.contains("dhx_window-resizer--bottom_right")) {
                                _this._startResize({ bottom: true, right: true });
                            }
                            else if (classList.contains("dhx_window-resizer--top_left")) {
                                _this._startResize({ top: true, left: true });
                            }
                            else if (classList.contains("dhx_window-resizer--top_right")) {
                                _this._startResize({ top: true, right: true });
                            }
                        }
                    });
                },
            },
            setActive: function () {
                WindowController_1.default.setActive(_this._uid);
            },
        };
    };
    Window.prototype._initUI = function () {
        var _this = this;
        var rows = [];
        var isHeader = (this.config.header || this.config.title || this.config.closable || this.config.movable) &&
            this.config.header !== false;
        if (isHeader) {
            rows.push({
                id: "header",
                height: "content",
                css: "dhx_window-header " + (this.config.movable ? "dhx_window-header--movable" : ""),
                on: {
                    mousedown: this.config.movable && this._handlers.move,
                    dblclick: this._handlers.headerDblClick,
                },
            });
        }
        rows.push({
            id: "content",
            css: isHeader ? "dhx_window-content" : "dhx_window-content-without-header",
        });
        if (this.config.footer) {
            rows.push({ id: "footer", height: "content", css: "dhx_window-footer" });
        }
        if (this.config.resizable) {
            rows.push({ id: "resizers", height: "content", css: "resizers" });
        }
        var layout = (this._layout = new ts_layout_1.Layout(this._popup, {
            css: "dhx_window" + (this.config.modal ? " dhx_window--modal" : ""),
            rows: rows,
            on: {
                mousedown: this._handlers.setActive,
            },
            id: this._uid,
        }));
        if (isHeader) {
            var header = (this.header = new ts_toolbar_1.Toolbar());
            if (this.config.title) {
                this.header.data.add({
                    type: "title",
                    value: this.config.title,
                    id: "title",
                    css: "title_max",
                });
                this._popup.setAttribute("aria-label", this.config.title);
            }
            if (this.config.closable) {
                this.header.data.add({
                    type: "spacer",
                });
                this.header.data.add({
                    id: "close",
                    type: "button",
                    view: "link",
                    size: "medium",
                    color: "secondary",
                    circle: true,
                    icon: "dxi dxi-close",
                });
                header.events.on(ts_navbar_1.NavigationBarEvents.click, function (id, e) {
                    if (id === "close") {
                        _this._hide(e);
                    }
                });
            }
            layout.getCell("header").attach(header);
        }
        if (this.config.footer) {
            var footer = (this.footer = new ts_toolbar_1.Toolbar());
            layout.getCell("footer").attach(footer);
        }
        if (this.config.resizable) {
            layout.getCell("resizers").attach(function () { return _this._drawResizers(); });
        }
    };
    Window.prototype._drawResizers = function () {
        return (0, dom_1.el)(".dhx-resizers", {
            onmousedown: this._handlers.resize,
        }, [
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--left", { _ref: "left" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--right", { _ref: "right" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--bottom", { _ref: "bottom" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--top", { _ref: "top" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--bottom_right", { _ref: "bottomRight" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--bottom_left", { _ref: "bottomLeft" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--top_right", { _ref: "topRight" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--top_left", { _ref: "topLeft" }),
        ]);
    };
    Window.prototype._startDrag = function (x, y) {
        var _this = this;
        this.config.node.classList.add("dhx_window--stop_selection");
        var deltaX = x - this._popup.offsetLeft;
        var deltaY = y - this._popup.offsetTop;
        var width = this._popup.offsetWidth;
        var height = this._popup.offsetHeight;
        var mousemove = function (e) {
            var oldposition = {
                left: _this._popup.offsetLeft,
                top: _this._popup.offsetTop,
            };
            var newX = e.pageX - deltaX;
            var newY = e.pageY - deltaY;
            if (!_this.config.viewportOverflow) {
                var _a = _this._getContainerParams(), containerXOffset = _a.containerXOffset, containerYOffset = _a.containerYOffset, containerInnerWidth = _a.containerInnerWidth, containerInnerHeight = _a.containerInnerHeight;
                if (newX < containerXOffset) {
                    newX = containerXOffset;
                }
                else if (newX > containerXOffset + containerInnerWidth - width) {
                    newX = containerXOffset + containerInnerWidth - width;
                }
                if (newY < containerYOffset) {
                    newY = containerYOffset;
                }
                else if (newY > containerYOffset + containerInnerHeight - height) {
                    newY = containerYOffset + containerInnerHeight - height;
                }
            }
            _this.config.left = newX;
            _this.config.top = newY;
            _this._popup.style.left = newX + "px";
            _this._popup.style.top = newY + "px";
            var position = { left: newX, top: newY };
            _this.events.fire(types_1.WindowEvents.move, [
                position,
                oldposition,
                { left: true, top: true, bottom: true, right: true },
            ]);
        };
        var mouseup = function () {
            document.removeEventListener("mouseup", mouseup);
            document.removeEventListener("mousemove", mousemove);
            _this.config.node.classList.remove("dhx_window--stop_selection");
        };
        document.addEventListener("mouseup", mouseup);
        document.addEventListener("mousemove", mousemove);
    };
    Window.prototype._startResize = function (resizeConfig) {
        var _this = this;
        var minWidth = this.config.minWidth | 100;
        var minHeight = this.config.minHeight | 100;
        var left = this._popup.offsetLeft;
        var top = this._popup.offsetTop;
        var width = this._popup.offsetWidth;
        var height = this._popup.offsetHeight;
        var root = this.getRootView().refs;
        var resizer;
        var resizeClassName;
        switch (true) {
            case resizeConfig.bottom && resizeConfig.left:
                resizeClassName = "dhx_window-body-pointer--bottom_left";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.bottom && resizeConfig.right:
                resizeClassName = "dhx_window-body-pointer--bottom_right";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.top && resizeConfig.left:
                resizeClassName = "dhx_window-body-pointer--top_left";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.top && resizeConfig.right:
                resizeClassName = "dhx_window-body-pointer--top-right";
                resizer = root.right;
                break;
            case resizeConfig.top:
                resizeClassName = "dhx_window-body-pointer--top";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.bottom:
                resizeClassName = "dhx_window-body-pointer--bottom";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.left:
                resizeClassName = "dhx_window-body-pointer--left";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.right:
                resizeClassName = "dhx_window-body-pointer--right";
                resizer = root.right;
                break;
        }
        resizer.el.classList.add("dhx_window-resizer--active");
        this.config.node.classList.add("dhx_window--stop_selection");
        this.config.node.classList.add(resizeClassName);
        var mousemove = function (e) {
            var _a = _this._getContainerParams(), containerInnerWidth = _a.containerInnerWidth, containerInnerHeight = _a.containerInnerHeight, containerXOffset = _a.containerXOffset, containerYOffset = _a.containerYOffset;
            var size = {
                width: _this._notInNode() ? e.pageX - left : e.pageX - _this.config.node.offsetLeft - left,
                height: _this._notInNode() ? e.pageY - top : e.pageY - _this.config.node.offsetTop - top,
                left: _this._notInNode() ? e.pageX : e.pageX - _this.config.node.offsetLeft,
                top: _this._notInNode() ? e.pageY : e.pageY - _this.config.node.offsetTop,
            };
            if (resizeConfig.right) {
                if (size.width < minWidth) {
                    size.width = minWidth;
                }
                else if (size.width > containerXOffset + containerInnerWidth - left) {
                    size.width = containerXOffset + containerInnerWidth - left;
                }
                _this._popup.style.width = size.width + "px";
            }
            if (resizeConfig.bottom) {
                if (size.height < minHeight) {
                    size.height = minHeight;
                }
                else if (size.height > containerYOffset + containerInnerHeight - top) {
                    size.height = containerYOffset + containerInnerHeight - top;
                }
                _this._popup.style.height = size.height + "px";
            }
            if (resizeConfig.left) {
                if (left + width - size.left < minWidth) {
                    size.left = left + width - minWidth;
                }
                size.width = left + width - size.left;
                _this.config.left = size.left;
                _this._popup.style.left = size.left + "px";
                _this._popup.style.width = size.width + "px";
            }
            if (resizeConfig.top) {
                if (size.top < containerYOffset) {
                    size.top = containerYOffset;
                }
                else if (top + height - size.top < minHeight) {
                    size.top = top + height - minHeight;
                }
                size.height = top + height - size.top;
                _this.config.top = size.top;
                _this._popup.style.top = size.top + "px";
                _this._popup.style.height = size.height + "px";
            }
            _this.config.width = _this._popup.offsetWidth;
            _this.config.height = _this._popup.offsetHeight;
            _this.events.fire(types_1.WindowEvents.resize, [size, { left: left, top: top, height: height, width: width }, resizeConfig]);
        };
        var mouseup = function () {
            document.removeEventListener("mouseup", mouseup);
            document.removeEventListener("mousemove", mousemove);
            _this.config.node.classList.remove("dhx_window--stop_selection");
            _this.config.node.classList.remove(resizeClassName);
            resizer.el.classList.remove("dhx_window-resizer--active");
        };
        document.addEventListener("mouseup", mouseup);
        document.addEventListener("mousemove", mousemove);
    };
    Window.prototype._blockScreen = function () {
        var _this = this;
        var blocker = document.createElement("div");
        blocker.className = "dhx_window__overlay";
        this.config.node.appendChild(blocker);
        this._blocker = blocker;
        if (this.config.closable) {
            blocker.addEventListener("click", function (e) { return _this._hide(e); });
            this._keyManager.addHotKey("escape", function (e) {
                var collection1 = Array.prototype.slice.call(document.querySelectorAll(".dhx_popup--window_modal"));
                var collection2 = Array.prototype.slice.call(document.querySelectorAll(".dhx_popup--window"));
                var mainCollection = collection1.concat(collection2);
                if (mainCollection.length === 1) {
                    _this._hide(e);
                    return;
                }
                mainCollection.sort(function (a, b) {
                    return +window.getComputedStyle(b).zIndex - +window.getComputedStyle(a).zIndex;
                });
                if (mainCollection[mainCollection.length - 1] === _this._popup) {
                    _this._hide(e);
                }
                return;
            });
        }
    };
    Window.prototype._notInNode = function () {
        return this.config.node === document.body || this.config.modal;
    };
    Window.prototype._getContainerParams = function () {
        var notInNode = this._notInNode();
        return {
            containerInnerWidth: notInNode ? window.innerWidth : this.config.node.offsetWidth,
            containerInnerHeight: notInNode ? window.innerHeight : this.config.node.offsetHeight,
            containerXOffset: notInNode ? window.pageXOffset : this.config.node.scrollLeft,
            containerYOffset: notInNode ? window.pageYOffset : this.config.node.scrollTop,
        };
    };
    return Window;
}());
exports.Window = Window;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowEvents = void 0;
var WindowEvents;
(function (WindowEvents) {
    WindowEvents["resize"] = "resize";
    WindowEvents["headerDoubleClick"] = "headerdoubleclick";
    WindowEvents["move"] = "move";
    WindowEvents["afterShow"] = "aftershow";
    WindowEvents["afterHide"] = "afterhide";
    WindowEvents["beforeShow"] = "beforeshow";
    WindowEvents["beforeHide"] = "beforehide";
})(WindowEvents || (exports.WindowEvents = WindowEvents = {}));


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(109);
__webpack_require__(110);
__webpack_require__(111);
__webpack_require__(112);
__webpack_require__(113);
module.exports = __webpack_require__(114);


/***/ }),
/* 109 */
/***/ (function(module, exports) {

Object.values = Object.values
    ? Object.values
    : function (obj) {
        var allowedTypes = [
            "[object String]",
            "[object Object]",
            "[object Array]",
            "[object Function]",
        ];
        var objType = Object.prototype.toString.call(obj);
        if (obj === null || typeof obj === "undefined") {
            throw new TypeError("Cannot convert undefined or null to object");
        }
        else if (!~allowedTypes.indexOf(objType)) {
            return [];
        }
        else {
            // if ES6 is supported
            if (Object.keys) {
                return Object.keys(obj).map(function (key) {
                    return obj[key];
                });
            }
            var result = [];
            for (var prop in obj) {
                if (obj.hasOwnProperty(prop)) {
                    result.push(obj[prop]);
                }
            }
            return result;
        }
    };
if (!Object.assign) {
    Object.defineProperty(Object, "assign", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target) {
            "use strict";
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            if (target === undefined || target === null) {
                throw new TypeError("Cannot convert first argument to object");
            }
            var to = Object(target);
            for (var i = 0; i < args.length; i++) {
                var nextSource = args[i];
                if (nextSource === undefined || nextSource === null) {
                    continue;
                }
                var keysArray = Object.keys(Object(nextSource));
                for (var nextIndex = 0, len = keysArray.length; nextIndex < len; nextIndex++) {
                    var nextKey = keysArray[nextIndex];
                    var desc = Object.getOwnPropertyDescriptor(nextSource, nextKey);
                    if (desc !== undefined && desc.enumerable) {
                        to[nextKey] = nextSource[nextKey];
                    }
                }
            }
            return to;
        },
    });
}


/***/ }),
/* 110 */
/***/ (function(module, exports) {

/* eslint-disable prefer-rest-params */
/* eslint-disable @typescript-eslint/unbound-method */
// eslint-disable-next-line @typescript-eslint/unbound-method
if (!Array.prototype.includes) {
    Object.defineProperty(Array.prototype, "includes", {
        value: function (searchElement, fromIndex) {
            if (this == null) {
                throw new TypeError('"this" is null or not defined');
            }
            // 1. Let O be ? ToObject(this value).
            var o = Object(this);
            // 2. Let len be ? ToLength(? Get(O, "length")).
            var len = o.length >>> 0;
            // 3. If len is 0, return false.
            if (len === 0) {
                return false;
            }
            // 4. Let n be ? ToInteger(fromIndex).
            //    (If fromIndex is undefined, this step produces the value 0.)
            var n = fromIndex | 0;
            // 5. If n ≥ 0, then
            //  a. Let k be n.
            // 6. Else n < 0,
            //  a. Let k be len + n.
            //  b. If k < 0, let k be 0.
            var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);
            function sameValueZero(x, y) {
                return x === y || (typeof x === "number" && typeof y === "number" && isNaN(x) && isNaN(y));
            }
            // 7. Repeat, while k < len
            while (k < len) {
                // a. Let elementK be the result of ? Get(O, ! ToString(k)).
                // b. If SameValueZero(searchElement, elementK) is true, return true.
                if (sameValueZero(o[k], searchElement)) {
                    return true;
                }
                // c. Increase k by 1.
                k++;
            }
            // 8. Return false
            return false;
        },
        configurable: true,
        writable: true,
    });
}
// https://tc39.github.io/ecma262/#sec-array.prototype.find
if (!Array.prototype.find) {
    Object.defineProperty(Array.prototype, "find", {
        value: function (predicate) {
            // 1. Let O be ? ToObject(this value).
            if (this == null) {
                throw new TypeError('"this" is null or not defined');
            }
            var o = Object(this);
            // 2. Let len be ? ToLength(? Get(O, "length")).
            var len = o.length >>> 0;
            // 3. If IsCallable(predicate) is false, throw a TypeError exception.
            if (typeof predicate !== "function") {
                throw new TypeError("predicate must be a function");
            }
            // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
            var thisArg = arguments[1];
            // 5. Let k be 0.
            var k = 0;
            // 6. Repeat, while k < len
            while (k < len) {
                // a. Let Pk be ! ToString(k).
                // b. Let kValue be ? Get(O, Pk).
                // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
                // d. If testResult is true, return kValue.
                var kValue = o[k];
                if (predicate.call(thisArg, kValue, k, o)) {
                    return kValue;
                }
                // e. Increase k by 1.
                k++;
            }
            // 7. Return undefined.
            return undefined;
        },
        configurable: true,
        writable: true,
    });
}
if (!Array.prototype.findIndex) {
    Array.prototype.findIndex = function (predicate) {
        if (this == null) {
            throw new TypeError("Array.prototype.findIndex called on null or undefined");
        }
        if (typeof predicate !== "function") {
            throw new TypeError("predicate must be a function");
        }
        var list = Object(this);
        var length = list.length >>> 0;
        var thisArg = arguments[1];
        var value;
        for (var i = 0; i < length; i++) {
            value = list[i];
            if (predicate.call(thisArg, value, i, list)) {
                return i;
            }
        }
        return -1;
    };
}


/***/ }),
/* 111 */
/***/ (function(module, exports) {

if (!String.prototype.includes) {
    String.prototype.includes = function (search, start) {
        "use strict";
        if (typeof start !== "number") {
            start = 0;
        }
        if (start + search.length > this.length) {
            return false;
        }
        else {
            return this.indexOf(search, start) !== -1;
        }
    };
}
if (!String.prototype.startsWith) {
    Object.defineProperty(String.prototype, "startsWith", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (searchString, position) {
            position = position || 0;
            return this.indexOf(searchString, position) === position;
        },
    });
}
if (!String.prototype.padStart) {
    String.prototype.padStart = function padStart(targetLength, padString) {
        targetLength = targetLength >> 0;
        padString = String(padString || " ");
        if (this.length > targetLength) {
            return String(this);
        }
        else {
            targetLength = targetLength - this.length;
            if (targetLength > padString.length) {
                padString += padString.repeat(targetLength / padString.length);
            }
            return padString.slice(0, targetLength) + String(this);
        }
    };
}
if (!String.prototype.padEnd) {
    String.prototype.padEnd = function padEnd(targetLength, padString) {
        targetLength = targetLength >> 0;
        padString = String(padString || " ");
        if (this.length > targetLength) {
            return String(this);
        }
        else {
            targetLength = targetLength - this.length;
            if (targetLength > padString.length) {
                padString += padString.repeat(targetLength / padString.length);
            }
            return String(this) + padString.slice(0, targetLength);
        }
    };
}


/***/ }),
/* 112 */
/***/ (function(module, exports) {

/* eslint-disable @typescript-eslint/no-this-alias */
/* eslint-disable prefer-rest-params */
/* eslint-disable @typescript-eslint/unbound-method */
if (Element && !Element.prototype.matches) {
    var proto = Element.prototype;
    proto.matches =
        proto.matchesSelector ||
            proto.mozMatchesSelector ||
            proto.msMatchesSelector ||
            proto.oMatchesSelector ||
            proto.webkitMatchesSelector;
}
// Source: https://github.com/naminho/svg-classlist-polyfill/blob/master/polyfill.js
if (!("classList" in SVGElement.prototype)) {
    Object.defineProperty(SVGElement.prototype, "classList", {
        get: function get() {
            var _this = this;
            return {
                contains: function contains(className) {
                    return _this.className.baseVal.split(" ").indexOf(className) !== -1;
                },
                add: function add(className) {
                    return _this.setAttribute("class", _this.getAttribute("class") + " " + className);
                },
                remove: function remove(className) {
                    var removedClass = _this
                        .getAttribute("class")
                        .replace(new RegExp("(\\s|^)".concat(className, "(\\s|$)"), "g"), "$2");
                    if (_this.classList.contains(className)) {
                        _this.setAttribute("class", removedClass);
                    }
                },
                toggle: function toggle(className) {
                    if (this.contains(className)) {
                        this.remove(className);
                    }
                    else {
                        this.add(className);
                    }
                },
            };
        },
        configurable: true,
    });
}
// Source: https://github.com/tc39/proposal-object-values-entries/blob/master/polyfill.js
if (!Object.entries) {
    var reduce_1 = Function.bind.call(Function.call, Array.prototype.reduce);
    var isEnumerable_1 = Function.bind.call(Function.call, Object.prototype.propertyIsEnumerable);
    var concat_1 = Function.bind.call(Function.call, Array.prototype.concat);
    Object.entries = function entries(O) {
        return reduce_1(Object.keys(O), function (e, k) { return concat_1(e, typeof k === "string" && isEnumerable_1(O, k) ? [[k, O[k]]] : []); }, []);
    };
}
// Source: https://gist.github.com/rockinghelvetica/00b9f7b5c97a16d3de75ba99192ff05c
if (!Event.prototype.composedPath) {
    Event.prototype.composedPath = function () {
        if (this.path) {
            return this.path;
        }
        var target = this.target;
        this.path = [];
        while (target.parentNode !== null) {
            this.path.push(target);
            target = target.parentNode;
        }
        this.path.push(document, window);
        return this.path;
    };
}


/***/ }),
/* 113 */
/***/ (function(module, exports) {

Math.sign =
    Math.sign ||
        function (x) {
            x = +x;
            if (x === 0 || isNaN(x)) {
                return x;
            }
            return x > 0 ? 1 : -1;
        };


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.i18n = exports.Window = exports.Tree = exports.Toolbar = exports.Timepicker = exports.Tabbar = exports.Slider = exports.Sidebar = exports.Ribbon = exports.Popup = exports.ContextMenu = exports.Menu = exports.tooltip = exports.disableTooltip = exports.enableTooltip = exports.confirm = exports.alert = exports.message = exports.Grid = exports.Form = exports.DataView = exports.Combobox = exports.Chart = exports.Colorpicker = exports.Calendar = exports.List = exports.Layout = exports.ajax = exports.dataDrivers = exports.DataProxy = exports.TreeCollection = exports.DataCollection = exports.Uploader = exports.setTheme = exports.resizeHandler = exports.awaitRedraw = exports.EventSystem = exports.cssManager = void 0;
__webpack_require__(115);
// HELPERS
/* tslint:disable */
var CssManager_1 = __webpack_require__(116);
Object.defineProperty(exports, "cssManager", { enumerable: true, get: function () { return CssManager_1.cssManager; } });
var events_1 = __webpack_require__(2);
Object.defineProperty(exports, "EventSystem", { enumerable: true, get: function () { return events_1.EventSystem; } });
var dom_1 = __webpack_require__(0);
Object.defineProperty(exports, "awaitRedraw", { enumerable: true, get: function () { return dom_1.awaitRedraw; } });
Object.defineProperty(exports, "resizeHandler", { enumerable: true, get: function () { return dom_1.resizeHandler; } });
Object.defineProperty(exports, "setTheme", { enumerable: true, get: function () { return dom_1.setTheme; } });
var ts_vault_1 = __webpack_require__(58);
Object.defineProperty(exports, "Uploader", { enumerable: true, get: function () { return ts_vault_1.Uploader; } });
var ts_data_1 = __webpack_require__(7);
Object.defineProperty(exports, "DataCollection", { enumerable: true, get: function () { return ts_data_1.DataCollection; } });
Object.defineProperty(exports, "TreeCollection", { enumerable: true, get: function () { return ts_data_1.TreeCollection; } });
Object.defineProperty(exports, "DataProxy", { enumerable: true, get: function () { return ts_data_1.DataProxy; } });
Object.defineProperty(exports, "dataDrivers", { enumerable: true, get: function () { return ts_data_1.dataDrivers; } });
Object.defineProperty(exports, "ajax", { enumerable: true, get: function () { return ts_data_1.ajax; } });
// WIDGETS
var ts_layout_1 = __webpack_require__(12);
Object.defineProperty(exports, "Layout", { enumerable: true, get: function () { return ts_layout_1.Layout; } });
var ts_list_1 = __webpack_require__(35);
Object.defineProperty(exports, "List", { enumerable: true, get: function () { return ts_list_1.List; } });
var ts_calendar_1 = __webpack_require__(33);
Object.defineProperty(exports, "Calendar", { enumerable: true, get: function () { return ts_calendar_1.Calendar; } });
var ts_colorpicker_1 = __webpack_require__(51);
Object.defineProperty(exports, "Colorpicker", { enumerable: true, get: function () { return ts_colorpicker_1.Colorpicker; } });
var ts_chart_1 = __webpack_require__(185);
Object.defineProperty(exports, "Chart", { enumerable: true, get: function () { return ts_chart_1.Chart; } });
var ts_combobox_1 = __webpack_require__(34);
Object.defineProperty(exports, "Combobox", { enumerable: true, get: function () { return ts_combobox_1.Combobox; } });
var ts_dataview_1 = __webpack_require__(206);
Object.defineProperty(exports, "DataView", { enumerable: true, get: function () { return ts_dataview_1.DataView; } });
var ts_form_1 = __webpack_require__(210);
Object.defineProperty(exports, "Form", { enumerable: true, get: function () { return ts_form_1.Form; } });
var ts_grid_1 = __webpack_require__(64);
Object.defineProperty(exports, "Grid", { enumerable: true, get: function () { return ts_grid_1.Grid; } });
var ts_message_1 = __webpack_require__(11);
Object.defineProperty(exports, "message", { enumerable: true, get: function () { return ts_message_1.message; } });
Object.defineProperty(exports, "alert", { enumerable: true, get: function () { return ts_message_1.alert; } });
Object.defineProperty(exports, "confirm", { enumerable: true, get: function () { return ts_message_1.confirm; } });
Object.defineProperty(exports, "enableTooltip", { enumerable: true, get: function () { return ts_message_1.enableTooltip; } });
Object.defineProperty(exports, "disableTooltip", { enumerable: true, get: function () { return ts_message_1.disableTooltip; } });
Object.defineProperty(exports, "tooltip", { enumerable: true, get: function () { return ts_message_1.tooltip; } });
var ts_menu_1 = __webpack_require__(229);
Object.defineProperty(exports, "Menu", { enumerable: true, get: function () { return ts_menu_1.Menu; } });
Object.defineProperty(exports, "ContextMenu", { enumerable: true, get: function () { return ts_menu_1.ContextMenu; } });
var ts_popup_1 = __webpack_require__(13);
Object.defineProperty(exports, "Popup", { enumerable: true, get: function () { return ts_popup_1.Popup; } });
var ts_ribbon_1 = __webpack_require__(232);
Object.defineProperty(exports, "Ribbon", { enumerable: true, get: function () { return ts_ribbon_1.Ribbon; } });
var ts_sidebar_1 = __webpack_require__(234);
Object.defineProperty(exports, "Sidebar", { enumerable: true, get: function () { return ts_sidebar_1.Sidebar; } });
var ts_slider_1 = __webpack_require__(47);
Object.defineProperty(exports, "Slider", { enumerable: true, get: function () { return ts_slider_1.Slider; } });
var ts_tabbar_1 = __webpack_require__(236);
Object.defineProperty(exports, "Tabbar", { enumerable: true, get: function () { return ts_tabbar_1.Tabbar; } });
var ts_timepicker_1 = __webpack_require__(44);
Object.defineProperty(exports, "Timepicker", { enumerable: true, get: function () { return ts_timepicker_1.Timepicker; } });
var ts_toolbar_1 = __webpack_require__(37);
Object.defineProperty(exports, "Toolbar", { enumerable: true, get: function () { return ts_toolbar_1.Toolbar; } });
var ts_tree_1 = __webpack_require__(238);
Object.defineProperty(exports, "Tree", { enumerable: true, get: function () { return ts_tree_1.Tree; } });
var ts_window_1 = __webpack_require__(240);
Object.defineProperty(exports, "Window", { enumerable: true, get: function () { return ts_window_1.Window; } });
// TOOLS
var ts_colorpicker_2 = __webpack_require__(51);
var en_1 = __webpack_require__(43);
var date_1 = __webpack_require__(16);
var en_2 = __webpack_require__(49);
var en_3 = __webpack_require__(98);
var en_4 = __webpack_require__(71);
var w = window;
exports.i18n = w.dhx && w.dhx.i18n ? w.dhx.i18n : {};
exports.i18n.setLocale = function (component, value) {
    var target = exports.i18n[component];
    for (var key in value) {
        target[key] = value[key];
    }
};
exports.i18n.colorpicker = exports.i18n.colorpicker || ts_colorpicker_2.locale;
exports.i18n.message = exports.i18n.message || en_1.default;
exports.i18n.calendar = exports.i18n.calendar || date_1.locale;
exports.i18n.combobox = exports.i18n.combobox || en_2.default;
exports.i18n.form = exports.i18n.form || en_3.default;
exports.i18n.timepicker = exports.i18n.timepicker || en_4.default;


/***/ }),
/* 115 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.cssManager = exports.CssManager = void 0;
var core_1 = __webpack_require__(1);
var CssManager = /** @class */ (function () {
    function CssManager() {
        this._classes = {};
        var styles = document.createElement("style");
        styles.id = "dhx_generated_styles";
        this._styleCont = document.head.appendChild(styles);
    }
    CssManager.prototype.update = function () {
        if (this._styleCont.innerHTML !== this._generateCss()) {
            document.head.appendChild(this._styleCont);
            this._styleCont.innerHTML = this._generateCss();
        }
    };
    CssManager.prototype.remove = function (className) {
        delete this._classes[className];
        this.update();
    };
    CssManager.prototype.add = function (cssList, customId, silent) {
        if (silent === void 0) { silent = false; }
        var cssString = this._toCssString(cssList);
        var id = this._findSameClassId(cssString);
        if (id && customId && customId !== id) {
            this._classes[customId] = this._classes[id];
            return customId;
        }
        if (id) {
            return id;
        }
        return this._addNewClass(cssString, customId, silent);
    };
    CssManager.prototype.get = function (className) {
        if (this._classes[className]) {
            var props = {};
            var css = this._classes[className].split(";");
            for (var _i = 0, css_1 = css; _i < css_1.length; _i++) {
                var item = css_1[_i];
                if (item) {
                    var prop = item.split(":");
                    props[prop[0]] = prop[1];
                }
            }
            return props;
        }
        return null;
    };
    CssManager.prototype.destructor = function () {
        this._classes = this._styleCont = null;
    };
    CssManager.prototype._findSameClassId = function (cssString) {
        for (var key in this._classes) {
            if (cssString === this._classes[key]) {
                return key;
            }
        }
        return null;
    };
    CssManager.prototype._addNewClass = function (cssString, customId, silent) {
        var id = customId || "dhx_generated_class_".concat((0, core_1.uid)());
        this._classes[id] = cssString;
        if (!silent) {
            this.update();
        }
        return id;
    };
    CssManager.prototype._toCssString = function (cssList) {
        var cssString = "";
        for (var key in cssList) {
            var prop = cssList[key];
            var name_1 = key.replace(/[A-Z]{1}/g, function (letter) { return "-".concat(letter.toLowerCase()); });
            cssString += "".concat(name_1, ":").concat(prop, ";");
        }
        return cssString;
    };
    CssManager.prototype._generateCss = function () {
        var result = "";
        for (var key in this._classes) {
            var cssProps = this._classes[key];
            result += ".".concat(key, "{").concat(cssProps, "}\n");
        }
        return result;
    };
    return CssManager;
}());
exports.CssManager = CssManager;
exports.cssManager = new CssManager();


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {var scope = (typeof global !== "undefined" && global) ||
            (typeof self !== "undefined" && self) ||
            window;
var apply = Function.prototype.apply;

// DOM APIs, for completeness

exports.setTimeout = function() {
  return new Timeout(apply.call(setTimeout, scope, arguments), clearTimeout);
};
exports.setInterval = function() {
  return new Timeout(apply.call(setInterval, scope, arguments), clearInterval);
};
exports.clearTimeout =
exports.clearInterval = function(timeout) {
  if (timeout) {
    timeout.close();
  }
};

function Timeout(id, clearFn) {
  this._id = id;
  this._clearFn = clearFn;
}
Timeout.prototype.unref = Timeout.prototype.ref = function() {};
Timeout.prototype.close = function() {
  this._clearFn.call(scope, this._id);
};

// Does not start the time, just sets up the members needed.
exports.enroll = function(item, msecs) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = msecs;
};

exports.unenroll = function(item) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = -1;
};

exports._unrefActive = exports.active = function(item) {
  clearTimeout(item._idleTimeoutId);

  var msecs = item._idleTimeout;
  if (msecs >= 0) {
    item._idleTimeoutId = setTimeout(function onTimeout() {
      if (item._onTimeout)
        item._onTimeout();
    }, msecs);
  }
};

// setimmediate attaches itself to the global object
__webpack_require__(118);
// On some exotic environments, it's not clear which object `setimmediate` was
// able to install onto.  Search each possibility in the same order as the
// `setimmediate` library.
exports.setImmediate = (typeof self !== "undefined" && self.setImmediate) ||
                       (typeof global !== "undefined" && global.setImmediate) ||
                       (this && this.setImmediate);
exports.clearImmediate = (typeof self !== "undefined" && self.clearImmediate) ||
                         (typeof global !== "undefined" && global.clearImmediate) ||
                         (this && this.clearImmediate);

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(40)))

/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, process) {(function (global, undefined) {
    "use strict";

    if (global.setImmediate) {
        return;
    }

    var nextHandle = 1; // Spec says greater than zero
    var tasksByHandle = {};
    var currentlyRunningATask = false;
    var doc = global.document;
    var registerImmediate;

    function setImmediate(callback) {
      // Callback can either be a function or a string
      if (typeof callback !== "function") {
        callback = new Function("" + callback);
      }
      // Copy function arguments
      var args = new Array(arguments.length - 1);
      for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i + 1];
      }
      // Store and register the task
      var task = { callback: callback, args: args };
      tasksByHandle[nextHandle] = task;
      registerImmediate(nextHandle);
      return nextHandle++;
    }

    function clearImmediate(handle) {
        delete tasksByHandle[handle];
    }

    function run(task) {
        var callback = task.callback;
        var args = task.args;
        switch (args.length) {
        case 0:
            callback();
            break;
        case 1:
            callback(args[0]);
            break;
        case 2:
            callback(args[0], args[1]);
            break;
        case 3:
            callback(args[0], args[1], args[2]);
            break;
        default:
            callback.apply(undefined, args);
            break;
        }
    }

    function runIfPresent(handle) {
        // From the spec: "Wait until any invocations of this algorithm started before this one have completed."
        // So if we're currently running a task, we'll need to delay this invocation.
        if (currentlyRunningATask) {
            // Delay by doing a setTimeout. setImmediate was tried instead, but in Firefox 7 it generated a
            // "too much recursion" error.
            setTimeout(runIfPresent, 0, handle);
        } else {
            var task = tasksByHandle[handle];
            if (task) {
                currentlyRunningATask = true;
                try {
                    run(task);
                } finally {
                    clearImmediate(handle);
                    currentlyRunningATask = false;
                }
            }
        }
    }

    function installNextTickImplementation() {
        registerImmediate = function(handle) {
            process.nextTick(function () { runIfPresent(handle); });
        };
    }

    function canUsePostMessage() {
        // The test against `importScripts` prevents this implementation from being installed inside a web worker,
        // where `global.postMessage` means something completely different and can't be used for this purpose.
        if (global.postMessage && !global.importScripts) {
            var postMessageIsAsynchronous = true;
            var oldOnMessage = global.onmessage;
            global.onmessage = function() {
                postMessageIsAsynchronous = false;
            };
            global.postMessage("", "*");
            global.onmessage = oldOnMessage;
            return postMessageIsAsynchronous;
        }
    }

    function installPostMessageImplementation() {
        // Installs an event handler on `global` for the `message` event: see
        // * https://developer.mozilla.org/en/DOM/window.postMessage
        // * http://www.whatwg.org/specs/web-apps/current-work/multipage/comms.html#crossDocumentMessages

        var messagePrefix = "setImmediate$" + Math.random() + "$";
        var onGlobalMessage = function(event) {
            if (event.source === global &&
                typeof event.data === "string" &&
                event.data.indexOf(messagePrefix) === 0) {
                runIfPresent(+event.data.slice(messagePrefix.length));
            }
        };

        if (global.addEventListener) {
            global.addEventListener("message", onGlobalMessage, false);
        } else {
            global.attachEvent("onmessage", onGlobalMessage);
        }

        registerImmediate = function(handle) {
            global.postMessage(messagePrefix + handle, "*");
        };
    }

    function installMessageChannelImplementation() {
        var channel = new MessageChannel();
        channel.port1.onmessage = function(event) {
            var handle = event.data;
            runIfPresent(handle);
        };

        registerImmediate = function(handle) {
            channel.port2.postMessage(handle);
        };
    }

    function installReadyStateChangeImplementation() {
        var html = doc.documentElement;
        registerImmediate = function(handle) {
            // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
            // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
            var script = doc.createElement("script");
            script.onreadystatechange = function () {
                runIfPresent(handle);
                script.onreadystatechange = null;
                html.removeChild(script);
                script = null;
            };
            html.appendChild(script);
        };
    }

    function installSetTimeoutImplementation() {
        registerImmediate = function(handle) {
            setTimeout(runIfPresent, 0, handle);
        };
    }

    // If supported, we should attach to the prototype of global, since that is where setTimeout et al. live.
    var attachTo = Object.getPrototypeOf && Object.getPrototypeOf(global);
    attachTo = attachTo && attachTo.setTimeout ? attachTo : global;

    // Don't get fooled by e.g. browserify environments.
    if ({}.toString.call(global.process) === "[object process]") {
        // For Node.js before 0.9
        installNextTickImplementation();

    } else if (canUsePostMessage()) {
        // For non-IE10 modern browsers
        installPostMessageImplementation();

    } else if (global.MessageChannel) {
        // For web workers, where supported
        installMessageChannelImplementation();

    } else if (doc && "onreadystatechange" in doc.createElement("script")) {
        // For IE 6–8
        installReadyStateChangeImplementation();

    } else {
        // For older browsers
        installSetTimeoutImplementation();
    }

    attachTo.setImmediate = setImmediate;
    attachTo.clearImmediate = clearImmediate;
}(typeof self === "undefined" ? typeof global === "undefined" ? this : global : self));

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(40), __webpack_require__(119)))

/***/ }),
/* 119 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

/**
* Copyright (c) 2017, Leon Sorokin
* All rights reserved. (MIT Licensed)
*
* domvm.js (DOM ViewModel)
* A thin, fast, dependency-free vdom view layer
* @preserve https://github.com/leeoniya/domvm (v3.2.6, micro build)
*/

(function (global, factory) {
	 true ? module.exports = factory() :
	undefined;
}(this, (function () { 'use strict';

// NOTE: if adding a new *VNode* type, make it < COMMENT and renumber rest.
// There are some places that test <= COMMENT to assert if node is a VNode

// VNode types
var ELEMENT	= 1;
var TEXT		= 2;
var COMMENT	= 3;

// placeholder types
var VVIEW		= 4;
var VMODEL		= 5;

var ENV_DOM = typeof window !== "undefined";
var win = ENV_DOM ? window : {};
var rAF = win.requestAnimationFrame;

var emptyObj = {};

function noop() {}

var isArr = Array.isArray;

function isSet(val) {
	return val != null;
}

function isPlainObj(val) {
	return val != null && val.constructor === Object;		//  && typeof val === "object"
}

function insertArr(targ, arr, pos, rem) {
	targ.splice.apply(targ, [pos, rem].concat(arr));
}

function isVal(val) {
	var t = typeof val;
	return t === "string" || t === "number";
}

function isFunc(val) {
	return typeof val === "function";
}

function isProm(val) {
	return typeof val === "object" && isFunc(val.then);
}



function assignObj(targ) {
	var args = arguments;

	for (var i = 1; i < args.length; i++)
		{ for (var k in args[i])
			{ targ[k] = args[i][k]; } }

	return targ;
}

// export const defProp = Object.defineProperty;

function deepSet(targ, path, val) {
	var seg;

	while (seg = path.shift()) {
		if (path.length === 0)
			{ targ[seg] = val; }
		else
			{ targ[seg] = targ = targ[seg] || {}; }
	}
}

/*
export function deepUnset(targ, path) {
	var seg;

	while (seg = path.shift()) {
		if (path.length === 0)
			targ[seg] = val;
		else
			targ[seg] = targ = targ[seg] || {};
	}
}
*/

function sliceArgs(args, offs) {
	var arr = [];
	for (var i = offs; i < args.length; i++)
		{ arr.push(args[i]); }
	return arr;
}

function cmpObj(a, b) {
	for (var i in a)
		{ if (a[i] !== b[i])
			{ return false; } }

	return true;
}

function cmpArr(a, b) {
	var alen = a.length;

	if (b.length !== alen)
		{ return false; }

	for (var i = 0; i < alen; i++)
		{ if (a[i] !== b[i])
			{ return false; } }

	return true;
}

// https://github.com/darsain/raft
// rAF throttler, aggregates multiple repeated redraw calls within single animframe
function raft(fn) {
	if (!rAF)
		{ return fn; }

	var id, ctx, args;

	function call() {
		id = 0;
		fn.apply(ctx, args);
	}

	return function() {
		ctx = this;
		args = arguments;
		if (!id) { id = rAF(call); }
	};
}

function curry(fn, args, ctx) {
	return function() {
		return fn.apply(ctx, args);
	};
}

/*
export function prop(val, cb, ctx, args) {
	return function(newVal, execCb) {
		if (newVal !== undefined && newVal !== val) {
			val = newVal;
			execCb !== false && isFunc(cb) && cb.apply(ctx, args);
		}

		return val;
	};
}
*/

/*
// adapted from https://github.com/Olical/binary-search
export function binaryKeySearch(list, item) {
    var min = 0;
    var max = list.length - 1;
    var guess;

	var bitwise = (max <= 2147483647) ? true : false;
	if (bitwise) {
		while (min <= max) {
			guess = (min + max) >> 1;
			if (list[guess].key === item) { return guess; }
			else {
				if (list[guess].key < item) { min = guess + 1; }
				else { max = guess - 1; }
			}
		}
	} else {
		while (min <= max) {
			guess = Math.floor((min + max) / 2);
			if (list[guess].key === item) { return guess; }
			else {
				if (list[guess].key < item) { min = guess + 1; }
				else { max = guess - 1; }
			}
		}
	}

    return -1;
}
*/

// https://en.wikipedia.org/wiki/Longest_increasing_subsequence
// impl borrowed from https://github.com/ivijs/ivi
function longestIncreasingSubsequence(a) {
	var p = a.slice();
	var result = [];
	result.push(0);
	var u;
	var v;

	for (var i = 0, il = a.length; i < il; ++i) {
		var j = result[result.length - 1];
		if (a[j] < a[i]) {
			p[i] = j;
			result.push(i);
			continue;
		}

		u = 0;
		v = result.length - 1;

		while (u < v) {
			var c = ((u + v) / 2) | 0;
			if (a[result[c]] < a[i]) {
				u = c + 1;
			} else {
				v = c;
			}
		}

		if (a[i] < a[result[u]]) {
			if (u > 0) {
				p[i] = result[u - 1];
			}
			result[u] = i;
		}
	}

	u = result.length;
	v = result[u - 1];

	while (u-- > 0) {
		result[u] = v;
		v = p[v];
	}

	return result;
}

// based on https://github.com/Olical/binary-search
function binaryFindLarger(item, list) {
	var min = 0;
	var max = list.length - 1;
	var guess;

	var bitwise = (max <= 2147483647) ? true : false;
	if (bitwise) {
		while (min <= max) {
			guess = (min + max) >> 1;
			if (list[guess] === item) { return guess; }
			else {
				if (list[guess] < item) { min = guess + 1; }
				else { max = guess - 1; }
			}
		}
	} else {
		while (min <= max) {
			guess = Math.floor((min + max) / 2);
			if (list[guess] === item) { return guess; }
			else {
				if (list[guess] < item) { min = guess + 1; }
				else { max = guess - 1; }
			}
		}
	}

	return (min == list.length) ? null : min;

//	return -1;
}

function isEvProp(name) {
	return name[0] === "o" && name[1] === "n";
}

function isSplProp(name) {
	return name[0] === "_";
}

function isStyleProp(name) {
	return name === "style";
}

function repaint(node) {
	node && node.el && node.el.offsetHeight;
}

function isHydrated(vm) {
	return vm.node != null && vm.node.el != null;
}

// tests interactive props where real val should be compared
function isDynProp(tag, attr) {
//	switch (tag) {
//		case "input":
//		case "textarea":
//		case "select":
//		case "option":
			switch (attr) {
				case "value":
				case "checked":
				case "selected":
//				case "selectedIndex":
					return true;
			}
//	}

	return false;
}

function getVm(n) {
	n = n || emptyObj;
	while (n.vm == null && n.parent)
		{ n = n.parent; }
	return n.vm;
}

function VNode() {}

var VNodeProto = VNode.prototype = {
	constructor: VNode,

	type:	null,

	vm:		null,

	// all this stuff can just live in attrs (as defined) just have getters here for it
	key:	null,
	ref:	null,
	data:	null,
	hooks:	null,
	ns:		null,

	el:		null,

	tag:	null,
	attrs:	null,
	body:	null,

	flags:	0,

	_class:	null,
	_diff:	null,

	// pending removal on promise resolution
	_dead:	false,
	// part of longest increasing subsequence?
	_lis:	false,

	idx:	null,
	parent:	null,

	/*
	// break out into optional fluent module
	key:	function(val) { this.key	= val; return this; },
	ref:	function(val) { this.ref	= val; return this; },		// deep refs
	data:	function(val) { this.data	= val; return this; },
	hooks:	function(val) { this.hooks	= val; return this; },		// h("div").hooks()
	html:	function(val) { this.html	= true; return this.body(val); },

	body:	function(val) { this.body	= val; return this; },
	*/
};

function defineText(body) {
	var node = new VNode;
	node.type = TEXT;
	node.body = body;
	return node;
}

// creates a one-shot self-ending stream that redraws target vm
// TODO: if it's already registered by any parent vm, then ignore to avoid simultaneous parent & child refresh

var tagCache = {};

var RE_ATTRS = /\[(\w+)(?:=(\w+))?\]/g;

function cssTag(raw) {
	{
		var cached = tagCache[raw];

		if (cached == null) {
			var tag, id, cls, attr;

			tagCache[raw] = cached = {
				tag:	(tag	= raw.match( /^[-\w]+/))		?	tag[0]						: "div",
				id:		(id		= raw.match( /#([-\w]+)/))		? 	id[1]						: null,
				class:	(cls	= raw.match(/\.([-\w.]+)/))		?	cls[1].replace(/\./g, " ")	: null,
				attrs:	null,
			};

			while (attr = RE_ATTRS.exec(raw)) {
				if (cached.attrs == null)
					{ cached.attrs = {}; }
				cached.attrs[attr[1]] = attr[2] || "";
			}
		}

		return cached;
	}
}

// (de)optimization flags

// forces slow bottom-up removeChild to fire deep willRemove/willUnmount hooks,
var DEEP_REMOVE = 1;
// prevents inserting/removing/reordering of children
var FIXED_BODY = 2;
// enables fast keyed lookup of children via binary search, expects homogeneous keyed body
var KEYED_LIST = 4;
// indicates an vnode match/diff/recycler function for body
var LAZY_LIST = 8;

function initElementNode(tag, attrs, body, flags) {
	var node = new VNode;

	node.type = ELEMENT;

	if (isSet(flags))
		{ node.flags = flags; }

	node.attrs = attrs;

	var parsed = cssTag(tag);

	node.tag = parsed.tag;

	// meh, weak assertion, will fail for id=0, etc.
	if (parsed.id || parsed.class || parsed.attrs) {
		var p = node.attrs || {};

		if (parsed.id && !isSet(p.id))
			{ p.id = parsed.id; }

		if (parsed.class) {
			node._class = parsed.class;		// static class
			p.class = parsed.class + (isSet(p.class) ? (" " + p.class) : "");
		}
		if (parsed.attrs) {
			for (var key in parsed.attrs)
				{ if (!isSet(p[key]))
					{ p[key] = parsed.attrs[key]; } }
		}

//		if (node.attrs !== p)
			node.attrs = p;
	}

	var mergedAttrs = node.attrs;

	if (isSet(mergedAttrs)) {
		if (isSet(mergedAttrs._key))
			{ node.key = mergedAttrs._key; }

		if (isSet(mergedAttrs._ref))
			{ node.ref = mergedAttrs._ref; }

		if (isSet(mergedAttrs._hooks))
			{ node.hooks = mergedAttrs._hooks; }

		if (isSet(mergedAttrs._data))
			{ node.data = mergedAttrs._data; }

		if (isSet(mergedAttrs._flags))
			{ node.flags = mergedAttrs._flags; }

		if (!isSet(node.key)) {
			if (isSet(node.ref))
				{ node.key = node.ref; }
			else if (isSet(mergedAttrs.id))
				{ node.key = mergedAttrs.id; }
			else if (isSet(mergedAttrs.name))
				{ node.key = mergedAttrs.name + (mergedAttrs.type === "radio" || mergedAttrs.type === "checkbox" ? mergedAttrs.value : ""); }
		}
	}

	if (body != null)
		{ node.body = body; }

	return node;
}

function setRef(vm, name, node) {
	var path = ["refs"].concat(name.split("."));
	deepSet(vm, path, node);
}

function setDeepRemove(node) {
	while (node = node.parent)
		{ node.flags |= DEEP_REMOVE; }
}

// vnew, vold
function preProc(vnew, parent, idx, ownVm) {
	if (vnew.type === VMODEL || vnew.type === VVIEW)
		{ return; }

	vnew.parent = parent;
	vnew.idx = idx;
	vnew.vm = ownVm;

	if (vnew.ref != null)
		{ setRef(getVm(vnew), vnew.ref, vnew); }

	var nh = vnew.hooks,
		vh = ownVm && ownVm.hooks;

	if (nh && (nh.willRemove || nh.didRemove) ||
		vh && (vh.willUnmount || vh.didUnmount))
		{ setDeepRemove(vnew); }

	if (isArr(vnew.body))
		{ preProcBody(vnew); }
	else {}
}

function preProcBody(vnew) {
	var body = vnew.body;

	for (var i = 0; i < body.length; i++) {
		var node2 = body[i];

		// remove false/null/undefined
		if (node2 === false || node2 == null)
			{ body.splice(i--, 1); }
		// flatten arrays
		else if (isArr(node2)) {
			insertArr(body, node2, i--, 1);
		}
		else {
			if (node2.type == null)
				{ body[i] = node2 = defineText(""+node2); }

			if (node2.type === TEXT) {
				// remove empty text nodes
				if (node2.body == null || node2.body === "")
					{ body.splice(i--, 1); }
				// merge with previous text node
				else if (i > 0 && body[i-1].type === TEXT) {
					body[i-1].body += node2.body;
					body.splice(i--, 1);
				}
				else
					{ preProc(node2, vnew, i, null); }
			}
			else
				{ preProc(node2, vnew, i, null); }
		}
	}
}

var unitlessProps = {
	animationIterationCount: true,
	boxFlex: true,
	boxFlexGroup: true,
	boxOrdinalGroup: true,
	columnCount: true,
	flex: true,
	flexGrow: true,
	flexPositive: true,
	flexShrink: true,
	flexNegative: true,
	flexOrder: true,
	gridRow: true,
	gridColumn: true,
	order: true,
	lineClamp: true,

	borderImageOutset: true,
	borderImageSlice: true,
	borderImageWidth: true,
	fontWeight: true,
	lineHeight: true,
	opacity: true,
	orphans: true,
	tabSize: true,
	widows: true,
	zIndex: true,
	zoom: true,

	fillOpacity: true,
	floodOpacity: true,
	stopOpacity: true,
	strokeDasharray: true,
	strokeDashoffset: true,
	strokeMiterlimit: true,
	strokeOpacity: true,
	strokeWidth: true
};

function autoPx(name, val) {
	{
		// typeof val === 'number' is faster but fails for numeric strings
		return !isNaN(val) && !unitlessProps[name] ? (val + "px") : val;
	}
}

// assumes if styles exist both are objects or both are strings
function patchStyle(n, o) {
	var ns =     (n.attrs || emptyObj).style;
	var os = o ? (o.attrs || emptyObj).style : null;

	// replace or remove in full
	if (ns == null || isVal(ns))
		{ n.el.style.cssText = ns; }
	else {
		for (var nn in ns) {
			var nv = ns[nn];

			if (os == null || nv != null && nv !== os[nn])
				{ n.el.style[nn] = autoPx(nn, nv); }
		}

		// clean old
		if (os) {
			for (var on in os) {
				if (ns[on] == null)
					{ n.el.style[on] = ""; }
			}
		}
	}
}

var didQueue = [];

function fireHook(hooks, name, o, n, immediate) {
	if (hooks != null) {
		var fn = o.hooks[name];

		if (fn) {
			if (name[0] === "d" && name[1] === "i" && name[2] === "d") {	// did*
				//	console.log(name + " should queue till repaint", o, n);
				immediate ? repaint(o.parent) && fn(o, n) : didQueue.push([fn, o, n]);
			}
			else {		// will*
				//	console.log(name + " may delay by promise", o, n);
				return fn(o, n);		// or pass  done() resolver
			}
		}
	}
}

function drainDidHooks(vm) {
	if (didQueue.length) {
		repaint(vm.node);

		var item;
		while (item = didQueue.shift())
			{ item[0](item[1], item[2]); }
	}
}

var doc = ENV_DOM ? document : null;

function closestVNode(el) {
	while (el._node == null)
		{ el = el.parentNode; }
	return el._node;
}

function createElement(tag, ns) {
	if (ns != null)
		{ return doc.createElementNS(ns, tag); }
	return doc.createElement(tag);
}

function createTextNode(body) {
	return doc.createTextNode(body);
}

function createComment(body) {
	return doc.createComment(body);
}

// ? removes if !recycled
function nextSib(sib) {
	return sib.nextSibling;
}

// ? removes if !recycled
function prevSib(sib) {
	return sib.previousSibling;
}

// TODO: this should collect all deep proms from all hooks and return Promise.all()
function deepNotifyRemove(node) {
	var vm = node.vm;

	var wuRes = vm != null && fireHook(vm.hooks, "willUnmount", vm, vm.data);

	var wrRes = fireHook(node.hooks, "willRemove", node);

	if ((node.flags & DEEP_REMOVE) === DEEP_REMOVE && isArr(node.body)) {
		for (var i = 0; i < node.body.length; i++)
			{ deepNotifyRemove(node.body[i]); }
	}

	return wuRes || wrRes;
}

function _removeChild(parEl, el, immediate) {
	var node = el._node, vm = node.vm;

	if (isArr(node.body)) {
		if ((node.flags & DEEP_REMOVE) === DEEP_REMOVE) {
			for (var i = 0; i < node.body.length; i++)
				{ _removeChild(el, node.body[i].el); }
		}
		else
			{ deepUnref(node); }
	}

	delete el._node;

	parEl.removeChild(el);

	fireHook(node.hooks, "didRemove", node, null, immediate);

	if (vm != null) {
		fireHook(vm.hooks, "didUnmount", vm, vm.data, immediate);
		vm.node = null;
	}
}

// todo: should delay parent unmount() by returning res prom?
function removeChild(parEl, el) {
	var node = el._node;

	// already marked for removal
	if (node._dead) { return; }

	var res = deepNotifyRemove(node);

	if (res != null && isProm(res)) {
		node._dead = true;
		res.then(curry(_removeChild, [parEl, el, true]));
	}
	else
		{ _removeChild(parEl, el); }
}

function deepUnref(node) {
	var obody = node.body;

	for (var i = 0; i < obody.length; i++) {
		var o2 = obody[i];
		delete o2.el._node;

		if (o2.vm != null)
			{ o2.vm.node = null; }

		if (isArr(o2.body))
			{ deepUnref(o2); }
	}
}

function clearChildren(parent) {
	var parEl = parent.el;

	if ((parent.flags & DEEP_REMOVE) === 0) {
		isArr(parent.body) && deepUnref(parent);
		parEl.textContent = null;
	}
	else {
		var el = parEl.firstChild;

		do {
			var next = nextSib(el);
			removeChild(parEl, el);
		} while (el = next);
	}
}

// todo: hooks
function insertBefore(parEl, el, refEl) {
	var node = el._node, inDom = el.parentNode != null;

	// el === refEl is asserted as a no-op insert called to fire hooks
	var vm = (el === refEl || !inDom) ? node.vm : null;

	if (vm != null)
		{ fireHook(vm.hooks, "willMount", vm, vm.data); }

	fireHook(node.hooks, inDom ? "willReinsert" : "willInsert", node);
	parEl.insertBefore(el, refEl);
	fireHook(node.hooks, inDom ? "didReinsert" : "didInsert", node);

	if (vm != null)
		{ fireHook(vm.hooks, "didMount", vm, vm.data); }
}

function insertAfter(parEl, el, refEl) {
	insertBefore(parEl, el, refEl ? nextSib(refEl) : null);
}

var onemit = {};

function emitCfg(cfg) {
	assignObj(onemit, cfg);
}

function emit(evName) {
	var targ = this,
		src = targ;

	var args = sliceArgs(arguments, 1).concat(src, src.data);

	do {
		var evs = targ.onemit;
		var fn = evs ? evs[evName] : null;

		if (fn) {
			fn.apply(targ, args);
			break;
		}
	} while (targ = targ.parent());

	if (onemit[evName])
		{ onemit[evName].apply(targ, args); }
}

var onevent = noop;

function config(newCfg) {
	onevent = newCfg.onevent || onevent;

	{
		if (newCfg.onemit)
			{ emitCfg(newCfg.onemit); }
	}

	
}

function bindEv(el, type, fn) {
	el[type] = fn;
}

function exec(fn, args, e, node, vm) {
	var out = fn.apply(vm, args.concat([e, node, vm, vm.data]));

	// should these respect out === false?
	vm.onevent(e, node, vm, vm.data, args);
	onevent.call(null, e, node, vm, vm.data, args);

	if (out === false) {
		e.preventDefault();
		e.stopPropagation();
	}
}

function handle(e) {
	var node = closestVNode(e.target);
	var vm = getVm(node);

	var evDef = e.currentTarget._node.attrs["on" + e.type], fn, args;

	if (isArr(evDef)) {
		fn = evDef[0];
		args = evDef.slice(1);
		exec(fn, args, e, node, vm);
	}
	else {
		for (var sel in evDef) {
			if (e.target.matches(sel)) {
				var evDef2 = evDef[sel];

				if (isArr(evDef2)) {
					fn = evDef2[0];
					args = evDef2.slice(1);
				}
				else {
					fn = evDef2;
					args = [];
				}

				exec(fn, args, e, node, vm);
			}
		}
	}
}

function patchEvent(node, name, nval, oval) {
	if (nval === oval)
		{ return; }

	var el = node.el;

	if (nval == null || isFunc(nval))
		{ bindEv(el, name, nval); }
	else if (oval == null)
		{ bindEv(el, name, handle); }
}

function remAttr(node, name, asProp) {
	if (name[0] === ".") {
		name = name.substr(1);
		asProp = true;
	}

	if (asProp)
		{ node.el[name] = ""; }
	else
		{ node.el.removeAttribute(name); }
}

// setAttr
// diff, ".", "on*", bool vals, skip _*, value/checked/selected selectedIndex
function setAttr(node, name, val, asProp, initial) {
	var el = node.el;

	if (val == null)
		{ !initial && remAttr(node, name, false); }		// will also removeAttr of style: null
	else if (node.ns != null)
		{ el.setAttribute(name, val); }
	else if (name === "class")
		{ el.className = val; }
	else if (name === "id" || typeof val === "boolean" || asProp)
		{ el[name] = val; }
	else if (name[0] === ".")
		{ el[name.substr(1)] = val; }
	else
		{ el.setAttribute(name, val); }
}

function patchAttrs(vnode, donor, initial) {
	var nattrs = vnode.attrs || emptyObj;
	var oattrs = donor.attrs || emptyObj;

	if (nattrs === oattrs) {
		
	}
	else {
		for (var key in nattrs) {
			var nval = nattrs[key];
			var isDyn = isDynProp(vnode.tag, key);
			var oval = isDyn ? vnode.el[key] : oattrs[key];

			if (nval === oval) {}
			else if (isStyleProp(key))
				{ patchStyle(vnode, donor); }
			else if (isSplProp(key)) {}
			else if (isEvProp(key))
				{ patchEvent(vnode, key, nval, oval); }
			else
				{ setAttr(vnode, key, nval, isDyn, initial); }
		}

		// TODO: bench style.cssText = "" vs removeAttribute("style")
		for (var key in oattrs) {
			!(key in nattrs) &&
			!isSplProp(key) &&
			remAttr(vnode, key, isDynProp(vnode.tag, key) || isEvProp(key));
		}
	}
}

function createView(view, data, key, opts) {
	if (view.type === VVIEW) {
		data	= view.data;
		key		= view.key;
		opts	= view.opts;
		view	= view.view;
	}

	return new ViewModel(view, data, key, opts);
}

//import { XML_NS, XLINK_NS } from './defineSvgElement';
function hydrateBody(vnode) {
	for (var i = 0; i < vnode.body.length; i++) {
		var vnode2 = vnode.body[i];
		var type2 = vnode2.type;

		// ELEMENT,TEXT,COMMENT
		if (type2 <= COMMENT)
			{ insertBefore(vnode.el, hydrate(vnode2)); }		// vnode.el.appendChild(hydrate(vnode2))
		else if (type2 === VVIEW) {
			var vm = createView(vnode2.view, vnode2.data, vnode2.key, vnode2.opts)._redraw(vnode, i, false);		// todo: handle new data updates
			type2 = vm.node.type;
			insertBefore(vnode.el, hydrate(vm.node));
		}
		else if (type2 === VMODEL) {
			var vm = vnode2.vm;
			vm._redraw(vnode, i);					// , false
			type2 = vm.node.type;
			insertBefore(vnode.el, vm.node.el);		// , hydrate(vm.node)
		}
	}
}

//  TODO: DRY this out. reusing normal patch here negatively affects V8's JIT
function hydrate(vnode, withEl) {
	if (vnode.el == null) {
		if (vnode.type === ELEMENT) {
			vnode.el = withEl || createElement(vnode.tag, vnode.ns);

		//	if (vnode.tag === "svg")
		//		vnode.el.setAttributeNS(XML_NS, 'xmlns:xlink', XLINK_NS);

			if (vnode.attrs != null)
				{ patchAttrs(vnode, emptyObj, true); }

			if ((vnode.flags & LAZY_LIST) === LAZY_LIST)	// vnode.body instanceof LazyList
				{ vnode.body.body(vnode); }

			if (isArr(vnode.body))
				{ hydrateBody(vnode); }
			else if (vnode.body != null && vnode.body !== "")
				{ vnode.el.textContent = vnode.body; }
		}
		else if (vnode.type === TEXT)
			{ vnode.el = withEl || createTextNode(vnode.body); }
		else if (vnode.type === COMMENT)
			{ vnode.el = withEl || createComment(vnode.body); }
	}

	vnode.el._node = vnode;

	return vnode.el;
}

// prevent GCC from inlining some large funcs (which negatively affects Chrome's JIT)
//window.syncChildren = syncChildren;
window.lisMove = lisMove;

function nextNode(node, body) {
	return body[node.idx + 1];
}

function prevNode(node, body) {
	return body[node.idx - 1];
}

function parentNode(node) {
	return node.parent;
}

var BREAK = 1;
var BREAK_ALL = 2;

function syncDir(advSib, advNode, insert, sibName, nodeName, invSibName, invNodeName, invInsert) {
	return function(node, parEl, body, state, convTest, lis) {
		var sibNode, tmpSib;

		if (state[sibName] != null) {
			// skip dom elements not created by domvm
			if ((sibNode = state[sibName]._node) == null) {
				state[sibName] = advSib(state[sibName]);
				return;
			}

			if (parentNode(sibNode) !== node) {
				tmpSib = advSib(state[sibName]);
				sibNode.vm != null ? sibNode.vm.unmount(true) : removeChild(parEl, state[sibName]);
				state[sibName] = tmpSib;
				return;
			}
		}

		if (state[nodeName] == convTest)
			{ return BREAK_ALL; }
		else if (state[nodeName].el == null) {
			insert(parEl, hydrate(state[nodeName]), state[sibName]);	// should lis be updated here?
			state[nodeName] = advNode(state[nodeName], body);		// also need to advance sib?
		}
		else if (state[nodeName].el === state[sibName]) {
			state[nodeName] = advNode(state[nodeName], body);
			state[sibName] = advSib(state[sibName]);
		}
		// head->tail or tail->head
		else if (!lis && sibNode === state[invNodeName]) {
			tmpSib = state[sibName];
			state[sibName] = advSib(tmpSib);
			invInsert(parEl, tmpSib, state[invSibName]);
			state[invSibName] = tmpSib;
		}
		else {
			if (lis && state[sibName] != null)
				{ return lisMove(advSib, advNode, insert, sibName, nodeName, parEl, body, sibNode, state); }

			return BREAK;
		}
	};
}

function lisMove(advSib, advNode, insert, sibName, nodeName, parEl, body, sibNode, state) {
	if (sibNode._lis) {
		insert(parEl, state[nodeName].el, state[sibName]);
		state[nodeName] = advNode(state[nodeName], body);
	}
	else {
		// find closest tomb
		var t = binaryFindLarger(sibNode.idx, state.tombs);
		sibNode._lis = true;
		var tmpSib = advSib(state[sibName]);
		insert(parEl, state[sibName], t != null ? body[state.tombs[t]].el : t);

		if (t == null)
			{ state.tombs.push(sibNode.idx); }
		else
			{ state.tombs.splice(t, 0, sibNode.idx); }

		state[sibName] = tmpSib;
	}
}

var syncLft = syncDir(nextSib, nextNode, insertBefore, "lftSib", "lftNode", "rgtSib", "rgtNode", insertAfter);
var syncRgt = syncDir(prevSib, prevNode, insertAfter, "rgtSib", "rgtNode", "lftSib", "lftNode", insertBefore);

function syncChildren(node, donor) {
	var obody	= donor.body,
		parEl	= node.el,
		body	= node.body,
		state = {
			lftNode:	body[0],
			rgtNode:	body[body.length - 1],
			lftSib:		((obody)[0] || emptyObj).el,
			rgtSib:		(obody[obody.length - 1] || emptyObj).el,
		};

	converge:
	while (1) {
//		from_left:
		while (1) {
			var l = syncLft(node, parEl, body, state, null, false);
			if (l === BREAK) { break; }
			if (l === BREAK_ALL) { break converge; }
		}

//		from_right:
		while (1) {
			var r = syncRgt(node, parEl, body, state, state.lftNode, false);
			if (r === BREAK) { break; }
			if (r === BREAK_ALL) { break converge; }
		}

		sortDOM(node, parEl, body, state);
		break;
	}
}

// TODO: also use the state.rgtSib and state.rgtNode bounds, plus reduce LIS range
function sortDOM(node, parEl, body, state) {
	var kids = Array.prototype.slice.call(parEl.childNodes);
	var domIdxs = [];

	for (var k = 0; k < kids.length; k++) {
		var n = kids[k]._node;

		if (n.parent === node)
			{ domIdxs.push(n.idx); }
	}

	// list of non-movable vnode indices (already in correct order in old dom)
	var tombs = longestIncreasingSubsequence(domIdxs).map(function (i) { return domIdxs[i]; });

	for (var i = 0; i < tombs.length; i++)
		{ body[tombs[i]]._lis = true; }

	state.tombs = tombs;

	while (1) {
		var r = syncLft(node, parEl, body, state, null, true);
		if (r === BREAK_ALL) { break; }
	}
}

function alreadyAdopted(vnode) {
	return vnode.el._node.parent !== vnode.parent;
}

function takeSeqIndex(n, obody, fromIdx) {
	return obody[fromIdx];
}

function findSeqThorough(n, obody, fromIdx) {		// pre-tested isView?
	for (; fromIdx < obody.length; fromIdx++) {
		var o = obody[fromIdx];

		if (o.vm != null) {
			// match by key & viewFn || vm
			if (n.type === VVIEW && o.vm.view === n.view && o.vm.key === n.key || n.type === VMODEL && o.vm === n.vm)
				{ return o; }
		}
		else if (!alreadyAdopted(o) && n.tag === o.tag && n.type === o.type && n.key === o.key && (n.flags & ~DEEP_REMOVE) === (o.flags & ~DEEP_REMOVE))
			{ return o; }
	}

	return null;
}

function findHashKeyed(n, obody, fromIdx) {
	return obody[obody._keys[n.key]];
}

/*
// list must be a sorted list of vnodes by key
function findBinKeyed(n, list) {
	var idx = binaryKeySearch(list, n.key);
	return idx > -1 ? list[idx] : null;
}
*/

// have it handle initial hydrate? !donor?
// types (and tags if ELEM) are assumed the same, and donor exists
function patch(vnode, donor) {
	fireHook(donor.hooks, "willRecycle", donor, vnode);

	var el = vnode.el = donor.el;

	var obody = donor.body;
	var nbody = vnode.body;

	el._node = vnode;

	// "" => ""
	if (vnode.type === TEXT && nbody !== obody) {
		el.nodeValue = nbody;
		return;
	}

	if (vnode.attrs != null || donor.attrs != null)
		{ patchAttrs(vnode, donor, false); }

	// patch events

	var oldIsArr = isArr(obody);
	var newIsArr = isArr(nbody);
	var lazyList = (vnode.flags & LAZY_LIST) === LAZY_LIST;

//	var nonEqNewBody = nbody != null && nbody !== obody;

	if (oldIsArr) {
		// [] => []
		if (newIsArr || lazyList)
			{ patchChildren(vnode, donor); }
		// [] => "" | null
		else if (nbody !== obody) {
			if (nbody != null)
				{ el.textContent = nbody; }
			else
				{ clearChildren(donor); }
		}
	}
	else {
		// "" | null => []
		if (newIsArr) {
			clearChildren(donor);
			hydrateBody(vnode);
		}
		// "" | null => "" | null
		else if (nbody !== obody) {
			if (el.firstChild)
				{ el.firstChild.nodeValue = nbody; }
			else
				{ el.textContent = nbody; }
		}
	}

	fireHook(donor.hooks, "didRecycle", donor, vnode);
}

// larger qtys of KEYED_LIST children will use binary search
//const SEQ_FAILS_MAX = 100;

// TODO: modify vtree matcher to work similar to dom reconciler for keyed from left -> from right -> head/tail -> binary
// fall back to binary if after failing nri - nli > SEQ_FAILS_MAX
// while-advance non-keyed fromIdx
// [] => []
function patchChildren(vnode, donor) {
	var nbody		= vnode.body,
		nlen		= nbody.length,
		obody		= donor.body,
		olen		= obody.length,
		isLazy		= (vnode.flags & LAZY_LIST) === LAZY_LIST,
		isFixed		= (vnode.flags & FIXED_BODY) === FIXED_BODY,
		isKeyed		= (vnode.flags & KEYED_LIST) === KEYED_LIST,
		domSync		= !isFixed && vnode.type === ELEMENT,
		doFind		= true,
		find		= (
			isKeyed ? findHashKeyed :				// keyed lists/lazyLists
			isFixed || isLazy ? takeSeqIndex :		// unkeyed lazyLists and FIXED_BODY
			findSeqThorough							// more complex stuff
		);

	if (isKeyed) {
		var keys = {};
		for (var i = 0; i < obody.length; i++)
			{ keys[obody[i].key] = i; }
		obody._keys = keys;
	}

	if (domSync && nlen === 0) {
		clearChildren(donor);
		if (isLazy)
			{ vnode.body = []; }	// nbody.tpl(all);
		return;
	}

	var donor2,
		node2,
		foundIdx,
		patched = 0,
		everNonseq = false,
		fromIdx = 0;		// first unrecycled node (search head)

	if (isLazy) {
		var fnode2 = {key: null};
		var nbodyNew = Array(nlen);
	}

	for (var i = 0; i < nlen; i++) {
		if (isLazy) {
			var remake = false;
			var diffRes = null;

			if (doFind) {
				if (isKeyed)
					{ fnode2.key = nbody.key(i); }

				donor2 = find(fnode2, obody, fromIdx);
			}

			if (donor2 != null) {
                foundIdx = donor2.idx;
				diffRes = nbody.diff(i, donor2);

				// diff returns same, so cheaply adopt vnode without patching
				if (diffRes === true) {
					node2 = donor2;
					node2.parent = vnode;
					node2.idx = i;
					node2._lis = false;
				}
				// diff returns new diffVals, so generate new vnode & patch
				else
					{ remake = true; }
			}
			else
				{ remake = true; }

			if (remake) {
				node2 = nbody.tpl(i);			// what if this is a VVIEW, VMODEL, injected element?
				preProc(node2, vnode, i);

				node2._diff = diffRes != null ? diffRes : nbody.diff(i);

				if (donor2 != null)
					{ patch(node2, donor2); }
			}
			else {
				// TODO: flag tmp FIXED_BODY on unchanged nodes?

				// domSync = true;		if any idx changes or new nodes added/removed
			}

			nbodyNew[i] = node2;
		}
		else {
			var node2 = nbody[i];
			var type2 = node2.type;

			// ELEMENT,TEXT,COMMENT
			if (type2 <= COMMENT) {
				if (donor2 = doFind && find(node2, obody, fromIdx)) {
					patch(node2, donor2);
					foundIdx = donor2.idx;
				}
			}
			else if (type2 === VVIEW) {
				if (donor2 = doFind && find(node2, obody, fromIdx)) {		// update/moveTo
					foundIdx = donor2.idx;
					var vm = donor2.vm._update(node2.data, vnode, i);		// withDOM
				}
				else
					{ var vm = createView(node2.view, node2.data, node2.key, node2.opts)._redraw(vnode, i, false); }	// createView, no dom (will be handled by sync below)

				type2 = vm.node.type;
			}
			else if (type2 === VMODEL) {
				// if the injected vm has never been rendered, this vm._update() serves as the
				// initial vtree creator, but must avoid hydrating (creating .el) because syncChildren()
				// which is responsible for mounting below (and optionally hydrating), tests .el presence
				// to determine if hydration & mounting are needed
				var withDOM = isHydrated(node2.vm);

				var vm = node2.vm._update(node2.data, vnode, i, withDOM);
				type2 = vm.node.type;
			}
		}

		// found donor & during a sequential search ...at search head
		if (!isKeyed && donor2 != null) {
			if (foundIdx === fromIdx) {
				// advance head
				fromIdx++;
				// if all old vnodes adopted and more exist, stop searching
				if (fromIdx === olen && nlen > olen) {
					// short-circuit find, allow loop just create/init rest
					donor2 = null;
					doFind = false;
				}
			}
			else
				{ everNonseq = true; }

			if (olen > 100 && everNonseq && ++patched % 10 === 0)
				{ while (fromIdx < olen && alreadyAdopted(obody[fromIdx]))
					{ fromIdx++; } }
		}
	}

	// replace List w/ new body
	if (isLazy)
		{ vnode.body = nbodyNew; }

	domSync && syncChildren(vnode, donor);
}

// view + key serve as the vm's unique identity
function ViewModel(view, data, key, opts) {
	var vm = this;

	vm.view = view;
	vm.data = data;
	vm.key = key;

	if (opts) {
		vm.opts = opts;
		vm.config(opts);
	}

	var out = isPlainObj(view) ? view : view.call(vm, vm, data, key, opts);

	if (isFunc(out))
		{ vm.render = out; }
	else {
		vm.render = out.render;
		vm.config(out);
	}

	// these must be wrapped here since they're debounced per view
	vm._redrawAsync = raft(function (_) { return vm.redraw(true); });
	vm._updateAsync = raft(function (newData) { return vm.update(newData, true); });

	vm.init && vm.init.call(vm, vm, vm.data, vm.key, opts);
}

var ViewModelProto = ViewModel.prototype = {
	constructor: ViewModel,

	_diff:	null,	// diff cache

	init:	null,
	view:	null,
	key:	null,
	data:	null,
	state:	null,
	api:	null,
	opts:	null,
	node:	null,
	hooks:	null,
	onevent: noop,
	refs:	null,
	render:	null,

	mount: mount,
	unmount: unmount,
	config: function(opts) {
		var t = this;

		if (opts.init)
			{ t.init = opts.init; }
		if (opts.diff)
			{ t.diff = opts.diff; }
		if (opts.onevent)
			{ t.onevent = opts.onevent; }

		// maybe invert assignment order?
		if (opts.hooks)
			{ t.hooks = assignObj(t.hooks || {}, opts.hooks); }

		{
			if (opts.onemit)
				{ t.onemit = assignObj(t.onemit || {}, opts.onemit); }
		}
	},
	parent: function() {
		return getVm(this.node.parent);
	},
	root: function() {
		var p = this.node;

		while (p.parent)
			{ p = p.parent; }

		return p.vm;
	},
	redraw: function(sync) {
		var vm = this;
		sync ? vm._redraw(null, null, isHydrated(vm)) : vm._redrawAsync();
		return vm;
	},
	update: function(newData, sync) {
		var vm = this;
		sync ? vm._update(newData, null, null, isHydrated(vm)) : vm._updateAsync(newData);
		return vm;
	},

	_update: updateSync,
	_redraw: redrawSync,
	_redrawAsync: null,
	_updateAsync: null,
};

function mount(el, isRoot) {
	var vm = this;

	if (isRoot) {
		clearChildren({el: el, flags: 0});

		vm._redraw(null, null, false);

		// if placeholder node doesnt match root tag
		if (el.nodeName.toLowerCase() !== vm.node.tag) {
			hydrate(vm.node);
			insertBefore(el.parentNode, vm.node.el, el);
			el.parentNode.removeChild(el);
		}
		else
			{ insertBefore(el.parentNode, hydrate(vm.node, el), el); }
	}
	else {
		vm._redraw(null, null);

		if (el)
			{ insertBefore(el, vm.node.el); }
	}

	if (el)
		{ drainDidHooks(vm); }

	return vm;
}

// asSub means this was called from a sub-routine, so don't drain did* hook queue
function unmount(asSub) {
	var vm = this;

	var node = vm.node;
	var parEl = node.el.parentNode;

	// edge bug: this could also be willRemove promise-delayed; should .then() or something to make sure hooks fire in order
	removeChild(parEl, node.el);

	if (!asSub)
		{ drainDidHooks(vm); }
}

function reParent(vm, vold, newParent, newIdx) {
	if (newParent != null) {
		newParent.body[newIdx] = vold;
		vold.idx = newIdx;
		vold.parent = newParent;
		vold._lis = false;
	}
	return vm;
}

function redrawSync(newParent, newIdx, withDOM) {
	var isRedrawRoot = newParent == null;
	var vm = this;
	var isMounted = vm.node && vm.node.el && vm.node.el.parentNode;

	var vold = vm.node, oldDiff, newDiff;

	if (vm.diff != null) {
		oldDiff = vm._diff;
		vm._diff = newDiff = vm.diff(vm, vm.data);

		if (vold != null) {
			var cmpFn = isArr(oldDiff) ? cmpArr : cmpObj;
			var isSame = oldDiff === newDiff || cmpFn(oldDiff, newDiff);

			if (isSame)
				{ return reParent(vm, vold, newParent, newIdx); }
		}
	}

	isMounted && fireHook(vm.hooks, "willRedraw", vm, vm.data);

	var vnew = vm.render.call(vm, vm, vm.data, oldDiff, newDiff);

	if (vnew === vold)
		{ return reParent(vm, vold, newParent, newIdx); }

	// todo: test result of willRedraw hooks before clearing refs
	vm.refs = null;

	// always assign vm key to root vnode (this is a de-opt)
	if (vm.key != null && vnew.key !== vm.key)
		{ vnew.key = vm.key; }

	vm.node = vnew;

	if (newParent) {
		preProc(vnew, newParent, newIdx, vm);
		newParent.body[newIdx] = vnew;
	}
	else if (vold && vold.parent) {
		preProc(vnew, vold.parent, vold.idx, vm);
		vold.parent.body[vold.idx] = vnew;
	}
	else
		{ preProc(vnew, null, null, vm); }

	if (withDOM !== false) {
		if (vold) {
			// root node replacement
			if (vold.tag !== vnew.tag || vold.key !== vnew.key) {
				// hack to prevent the replacement from triggering mount/unmount
				vold.vm = vnew.vm = null;

				var parEl = vold.el.parentNode;
				var refEl = nextSib(vold.el);
				removeChild(parEl, vold.el);
				insertBefore(parEl, hydrate(vnew), refEl);

				// another hack that allows any higher-level syncChildren to set
				// reconciliation bounds using a live node
				vold.el = vnew.el;

				// restore
				vnew.vm = vm;
			}
			else
				{ patch(vnew, vold); }
		}
		else
			{ hydrate(vnew); }
	}

	isMounted && fireHook(vm.hooks, "didRedraw", vm, vm.data);

	if (isRedrawRoot && isMounted)
		{ drainDidHooks(vm); }

	return vm;
}

// this also doubles as moveTo
// TODO? @withRedraw (prevent redraw from firing)
function updateSync(newData, newParent, newIdx, withDOM) {
	var vm = this;

	if (newData != null) {
		if (vm.data !== newData) {
			fireHook(vm.hooks, "willUpdate", vm, newData);
			vm.data = newData;

			
		}
	}

	return vm._redraw(newParent, newIdx, withDOM);
}

function defineElement(tag, arg1, arg2, flags) {
	var attrs, body;

	if (arg2 == null) {
		if (isPlainObj(arg1))
			{ attrs = arg1; }
		else
			{ body = arg1; }
	}
	else {
		attrs = arg1;
		body = arg2;
	}

	return initElementNode(tag, attrs, body, flags);
}

//export const XML_NS = "http://www.w3.org/2000/xmlns/";
var SVG_NS = "http://www.w3.org/2000/svg";

function defineSvgElement(tag, arg1, arg2, flags) {
	var n = defineElement(tag, arg1, arg2, flags);
	n.ns = SVG_NS;
	return n;
}

function defineComment(body) {
	var node = new VNode;
	node.type = COMMENT;
	node.body = body;
	return node;
}

// placeholder for declared views
function VView(view, data, key, opts) {
	this.view = view;
	this.data = data;
	this.key = key;
	this.opts = opts;
}

VView.prototype = {
	constructor: VView,

	type: VVIEW,
	view: null,
	data: null,
	key: null,
	opts: null,
};

function defineView(view, data, key, opts) {
	return new VView(view, data, key, opts);
}

// placeholder for injected ViewModels
function VModel(vm) {
	this.vm = vm;
}

VModel.prototype = {
	constructor: VModel,

	type: VMODEL,
	vm: null,
};

function injectView(vm) {
//	if (vm.node == null)
//		vm._redraw(null, null, false);

//	return vm.node;

	return new VModel(vm);
}

function injectElement(el) {
	var node = new VNode;
	node.type = ELEMENT;
	node.el = node.key = el;
	return node;
}

function lazyList(items, cfg) {
	var len = items.length;

	var self = {
		items: items,
		length: len,
		// defaults to returning item identity (or position?)
		key: function(i) {
			return cfg.key(items[i], i);
		},
		// default returns 0?
		diff: function(i, donor) {
			var newVals = cfg.diff(items[i], i);
			if (donor == null)
				{ return newVals; }
			var oldVals = donor._diff;
			var same = newVals === oldVals || isArr(oldVals) ? cmpArr(newVals, oldVals) : cmpObj(newVals, oldVals);
			return same || newVals;
		},
		tpl: function(i) {
			return cfg.tpl(items[i], i);
		},
		map: function(tpl) {
			cfg.tpl = tpl;
			return self;
		},
		body: function(vnode) {
			var nbody = Array(len);

			for (var i = 0; i < len; i++) {
				var vnode2 = self.tpl(i);

			//	if ((vnode.flags & KEYED_LIST) === KEYED_LIST && self. != null)
			//		vnode2.key = getKey(item);

				vnode2._diff = self.diff(i);			// holds oldVals for cmp

				nbody[i] = vnode2;

				// run preproc pass (should this be just preProc in above loop?) bench
				preProc(vnode2, vnode, i);
			}

			// replace List with generated body
			vnode.body = nbody;
		}
	};

	return self;
}

var nano = {
	config: config,

	ViewModel: ViewModel,
	VNode: VNode,

	createView: createView,

	defineElement: defineElement,
	defineSvgElement: defineSvgElement,
	defineText: defineText,
	defineComment: defineComment,
	defineView: defineView,

	injectView: injectView,
	injectElement: injectElement,

	lazyList: lazyList,

	FIXED_BODY: FIXED_BODY,
	DEEP_REMOVE: DEEP_REMOVE,
	KEYED_LIST: KEYED_LIST,
	LAZY_LIST: LAZY_LIST,
};

function protoPatch(n, doRepaint) {
	patch$1(this, n, doRepaint);
}

// newNode can be either {class: style: } or full new VNode
// will/didPatch hooks?
function patch$1(o, n, doRepaint) {
	if (n.type != null) {
		// no full patching of view roots, just use redraw!
		if (o.vm != null)
			{ return; }

		preProc(n, o.parent, o.idx, null);
		o.parent.body[o.idx] = n;
		patch(n, o);
		doRepaint && repaint(n);
		drainDidHooks(getVm(n));
	}
	else {
		// TODO: re-establish refs

		// shallow-clone target
		var donor = Object.create(o);
		// fixate orig attrs
		donor.attrs = assignObj({}, o.attrs);
		// assign new attrs into live targ node
		var oattrs = assignObj(o.attrs, n);
		// prepend any fixed shorthand class
		if (o._class != null) {
			var aclass = oattrs.class;
			oattrs.class = aclass != null && aclass !== "" ? o._class + " " + aclass : o._class;
		}

		patchAttrs(o, donor);

		doRepaint && repaint(o);
	}
}

VNodeProto.patch = protoPatch;

function nextSubVms(n, accum) {
	var body = n.body;

	if (isArr(body)) {
		for (var i = 0; i < body.length; i++) {
			var n2 = body[i];

			if (n2.vm != null)
				{ accum.push(n2.vm); }
			else
				{ nextSubVms(n2, accum); }
		}
	}

	return accum;
}

function defineElementSpread(tag) {
	var args = arguments;
	var len = args.length;
	var body, attrs;

	if (len > 1) {
		var bodyIdx = 1;

		if (isPlainObj(args[1])) {
			attrs = args[1];
			bodyIdx = 2;
		}

		if (len === bodyIdx + 1 && (isVal(args[bodyIdx]) || isArr(args[bodyIdx]) || attrs && (attrs._flags & LAZY_LIST) === LAZY_LIST))
			{ body = args[bodyIdx]; }
		else
			{ body = sliceArgs(args, bodyIdx); }
	}

	return initElementNode(tag, attrs, body);
}

function defineSvgElementSpread() {
	var n = defineElementSpread.apply(null, arguments);
	n.ns = SVG_NS;
	return n;
}

ViewModelProto.emit = emit;
ViewModelProto.onemit = null;

ViewModelProto.body = function() {
	return nextSubVms(this.node, []);
};

nano.defineElementSpread = defineElementSpread;
nano.defineSvgElementSpread = defineSvgElementSpread;

return nano;

})));
//# sourceMappingURL=domvm.micro.js.map


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loader = void 0;
var core_1 = __webpack_require__(1);
var helpers_1 = __webpack_require__(23);
var types_1 = __webpack_require__(22);
var core_2 = __webpack_require__(1);
var Loader = /** @class */ (function () {
    function Loader(parent, changes) {
        this._parent = parent;
        this._changes = changes; // todo: [dirty] mutation
    }
    Loader.prototype.load = function (url, driver) {
        var _this = this;
        // TODO: change way for checking lazyLoad
        if (url.config && !this._parent.events.fire(types_1.DataEvents.beforeLazyLoad, [])) {
            return;
        }
        return (this._parent.loadData = url
            .load()
            .then(function (data) {
            if (data) {
                return _this.parse(data, driver);
            }
            else {
                return [];
            }
        })
            .catch(function (error) {
            _this._parent.events.fire(types_1.DataEvents.loadError, [error]);
        }));
    };
    Loader.prototype.parse = function (data, driver) {
        var _this = this;
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        if (driver === "json" && !(0, helpers_1.hasJsonOrArrayStructure)(data)) {
            this._parent.events.fire(types_1.DataEvents.loadError, ["Uncaught SyntaxError: Unexpected end of input"]);
        }
        driver = (0, helpers_1.toDataDriver)(driver);
        data = driver.toJsonArray(data);
        if (!(data instanceof Array)) {
            var totalCount = data.total_count - 1;
            var from_1 = data.from;
            data = data.data;
            if (this._parent.getLength() === 0) {
                var newData = [];
                for (var i = 0, j = 0; i <= totalCount; i++) {
                    if (i >= from_1 && i <= from_1 + data.length - 1) {
                        newData.push(data[j]);
                        j++;
                    }
                    else {
                        newData.push({ $empty: true });
                    }
                }
                data = newData;
            }
            else {
                data.forEach(function (newItem, i) {
                    var index = from_1 + i;
                    var oldId = _this._parent.getId(index);
                    if ((0, core_1.isId)(oldId)) {
                        var emptyItem = _this._parent.getItem(oldId);
                        if (emptyItem && emptyItem.$empty) {
                            var id = newItem.id || emptyItem.id;
                            if ((0, core_2.isDefined)(newItem.id)) {
                                _this._parent.changeId(oldId, id, true);
                            }
                            _this._parent.update(id, __assign(__assign({}, newItem), { $empty: undefined }), true);
                        }
                    }
                    else {
                        (0, helpers_1.dhxWarning)("item not found");
                    }
                });
                this._parent.events.fire(types_1.DataEvents.afterLazyLoad, [from_1, data.length]);
                this._parent.events.fire(types_1.DataEvents.change);
                return data;
            }
        }
        if (this._parent.getInitialData()) {
            this._parent.removeAll();
        }
        this._parent.$parse(data);
        return data;
    };
    Loader.prototype.save = function (url) {
        var _this = this;
        var uniqueChanges = this._getUniqueOrder();
        var _loop_1 = function (el) {
            if (el.saving || el.pending) {
                (0, helpers_1.dhxWarning)("item is saving");
            }
            else {
                var prevEl_1 = this_1._findPrevState(el.id);
                if (prevEl_1 && prevEl_1.saving) {
                    var pending = new Promise(function (res, rej) {
                        prevEl_1.promise
                            .then(function () {
                            el.pending = false;
                            res(_this._setPromise(el, url));
                        })
                            .catch(function (err) {
                            _this._removeFromOrder(prevEl_1);
                            _this._setPromise(el, url);
                            (0, helpers_1.dhxWarning)(err);
                            rej(err);
                        });
                    });
                    this_1._addToChain(pending);
                    el.pending = true;
                }
                else {
                    this_1._setPromise(el, url);
                }
            }
        };
        var this_1 = this;
        for (var _i = 0, uniqueChanges_1 = uniqueChanges; _i < uniqueChanges_1.length; _i++) {
            var el = uniqueChanges_1[_i];
            _loop_1(el);
        }
        if (uniqueChanges.length) {
            this._parent.saveData.then(function () {
                _this._saving = false;
            });
        }
    };
    Loader.prototype.updateChanges = function (changes) {
        this._changes = changes;
    };
    Loader.prototype._setPromise = function (el, url) {
        var _this = this;
        var status;
        switch (el.status) {
            case "remove":
                status = "delete";
                break;
            case "add":
                status = "insert";
                break;
            default:
                status = el.status;
                break;
        }
        el.promise = url.save(el.obj, status);
        el.promise
            .then(function () {
            _this._removeFromOrder(el);
        })
            .catch(function (err) {
            el.saving = false;
            el.error = true;
            (0, helpers_1.dhxError)(err);
        });
        el.saving = true;
        this._saving = true;
        this._addToChain(el.promise);
        return el.promise;
    };
    Loader.prototype._addToChain = function (promise) {
        // eslint-disable-next-line @typescript-eslint/no-misused-promises
        if (this._parent.saveData && this._saving) {
            this._parent.saveData = this._parent.saveData.then(function () { return promise; });
        }
        else {
            this._parent.saveData = promise;
        }
    };
    Loader.prototype._findPrevState = function (id) {
        for (var _i = 0, _a = this._changes.order; _i < _a.length; _i++) {
            var el = _a[_i];
            if (el.id === id) {
                return el;
            }
        }
        return null;
    };
    Loader.prototype._removeFromOrder = function (el) {
        this._changes.order = this._changes.order.filter(function (item) { return !(0, helpers_1.isEqualObj)(item, el); });
    };
    Loader.prototype._getUniqueOrder = function () {
        return this._changes.order.reduce(function (unique, el) {
            var ind = unique.findIndex(function (item) { return item.id === el.id; });
            var involvedElem = ind > -1 ? unique[ind] : null;
            if (involvedElem && involvedElem.saving === false && involvedElem.status === "add") {
                if (el.status === "remove") {
                    unique.splice(ind, 1);
                }
                else {
                    involvedElem.obj = el.obj;
                }
            }
            else if (involvedElem && involvedElem.saving === false && involvedElem.status === "update") {
                unique.splice(ind, 1, el);
            }
            else {
                unique.push(el);
            }
            return unique;
        }, []);
    };
    return Loader;
}());
exports.Loader = Loader;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.XMLDriver = void 0;
var xml_1 = __webpack_require__(123);
var ARRAY_NAME = "items";
var ITEM_NAME = "item";
// convert xml tag to js object, all subtags and attributes are mapped to the properties of result object
function tagToObject(tag, initialObj) {
    initialObj = initialObj || {};
    // map attributes
    var a = tag.attributes;
    if (a && a.length) {
        for (var i = 0; i < a.length; i++) {
            initialObj[a[i].name] = a[i].value;
        }
    }
    // map subtags
    var b = tag.childNodes;
    for (var i = 0; i < b.length; i++) {
        if (b[i].nodeType === 1) {
            var name_1 = b[i].tagName;
            if (initialObj[name_1]) {
                if (typeof initialObj[name_1].push !== "function") {
                    initialObj[name_1] = [initialObj[name_1]];
                }
                initialObj[name_1].push(tagToObject(b[i], {}));
            }
            else {
                initialObj[name_1] = tagToObject(b[i], {}); // sub-object for complex subtags
            }
        }
    }
    return initialObj;
}
var XMLDriver = /** @class */ (function () {
    function XMLDriver() {
    }
    XMLDriver.prototype.toJsonArray = function (data) {
        return this.getRows(data);
    };
    XMLDriver.prototype.toJsonObject = function (data) {
        var doc;
        if (typeof data === "string") {
            doc = this._fromString(data);
        }
        return tagToObject(doc);
    };
    XMLDriver.prototype.serialize = function (data) {
        return (0, xml_1.jsonToXML)(data);
    };
    XMLDriver.prototype.getFields = function (row) {
        return row;
    };
    XMLDriver.prototype.getRows = function (data) {
        if (typeof data === "string") {
            data = this._fromString(data);
        }
        if (data) {
            var childNodes = data.childNodes && data.childNodes[0] && data.childNodes[0].childNodes;
            if (!childNodes || !childNodes.length) {
                return null;
            }
            return this._getRows(childNodes);
        }
        return [];
    };
    XMLDriver.prototype._getRows = function (nodes) {
        var result = [];
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].tagName === ITEM_NAME) {
                result.push(this._nodeToJS(nodes[i]));
            }
        }
        return result;
    };
    XMLDriver.prototype._fromString = function (data) {
        try {
            return new DOMParser().parseFromString(data, "text/xml");
        }
        catch (_a) {
            return null;
        }
    };
    XMLDriver.prototype._nodeToJS = function (node) {
        var result = {};
        if (this._haveAttrs(node)) {
            var attrs = node.attributes;
            for (var i = 0; i < attrs.length; i++) {
                var _a = attrs[i], name_2 = _a.name, value = _a.value;
                result[name_2] = this._toType(value);
            }
        }
        if (node.nodeType === 3) {
            result.value = result.value || this._toType(node.textContent);
            return result;
        }
        var childNodes = node.childNodes;
        if (childNodes) {
            for (var i = 0; i < childNodes.length; i++) {
                var subNode = childNodes[i];
                var tag = subNode.tagName;
                if (!tag) {
                    continue;
                }
                if (tag === ARRAY_NAME && subNode.childNodes) {
                    result[tag] = this._getRows(subNode.childNodes);
                }
                else {
                    if (this._haveAttrs(subNode)) {
                        result[tag] = this._nodeToJS(subNode);
                    }
                    else {
                        result[tag] = this._toType(subNode.textContent);
                    }
                }
            }
        }
        return result;
    };
    XMLDriver.prototype._toType = function (val) {
        if (val === "false" || val === "true") {
            return val === "true";
        }
        return val;
    };
    XMLDriver.prototype._haveAttrs = function (node) {
        return node.attributes && node.attributes.length;
    };
    return XMLDriver;
}());
exports.XMLDriver = XMLDriver;


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.jsonToXML = void 0;
var INDENT_STEP = 4;
function ws(count) {
    return " ".repeat(count);
}
function itemToXML(item, indent) {
    if (indent === void 0) { indent = INDENT_STEP; }
    var result = ws(indent) + "<item>\n";
    for (var key in item) {
        if (Array.isArray(item[key])) {
            result += ws(indent + INDENT_STEP) + "<".concat(key, ">\n");
            result +=
                item[key].map(function (subItem) { return itemToXML(subItem, indent + INDENT_STEP * 2); }).join("\n") +
                    "\n";
            result += ws(indent + INDENT_STEP) + "</".concat(key, ">\n");
        }
        else {
            result += ws(indent + INDENT_STEP) + "<".concat(key, ">").concat(item[key], "</").concat(key, ">\n");
        }
    }
    result += ws(indent) + "</item>";
    return result;
}
function jsonToXML(data, root) {
    if (root === void 0) { root = "root"; }
    var result = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<".concat(root, ">");
    for (var i = 0; i < data.length; i++) {
        result += "\n" + itemToXML(data[i]);
    }
    return result + "\n</".concat(root, ">");
}
exports.jsonToXML = jsonToXML;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Sort = void 0;
var helpers_1 = __webpack_require__(23);
var Sort = /** @class */ (function () {
    function Sort() {
    }
    Sort.prototype.sort = function (array, by, perm) {
        this._createSorter(by);
        if (perm === by)
            by = null;
        if (perm || by)
            this._sort(array, perm, by);
    };
    Sort.prototype._createSorter = function (by) {
        var _this = this;
        if (by && !by.rule) {
            by.rule = function (a, b) {
                var _a, _b;
                var aa = (_a = _this._checkVal(by.as, a[by.by])) !== null && _a !== void 0 ? _a : "";
                var bb = (_b = _this._checkVal(by.as, b[by.by])) !== null && _b !== void 0 ? _b : "";
                // [TODO] why we need naturalCompare
                return (0, helpers_1.naturalCompare)(aa.toString(), bb.toString());
            };
        }
    };
    Sort.prototype._checkVal = function (method, val) {
        return method ? method.call(this, val) : val;
    };
    Sort.prototype._sort = function (arr, conf, conf2) {
        var _this = this;
        var dir = {
            asc: 1,
            desc: -1,
        };
        return arr.sort(function (a, b) {
            var t = 0;
            if (conf)
                t = conf.rule.call(_this, a, b) * (dir[conf.dir] || dir.asc);
            if (t === 0 && conf2)
                t = conf2.rule.call(_this, a, b) * (dir[conf2.dir] || dir.asc);
            return t;
        });
    };
    return Sort;
}());
exports.Sort = Sort;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeCollection = void 0;
var core_1 = __webpack_require__(1);
var datacollection_1 = __webpack_require__(60);
var dataproxy_1 = __webpack_require__(26);
var helpers_1 = __webpack_require__(23);
var types_1 = __webpack_require__(22);
function addToOrder(store, obj, parent, index) {
    if (index !== undefined && index !== -1 && store[parent] && store[parent][index]) {
        store[parent].splice(index, 0, obj);
    }
    else {
        if (!store[parent]) {
            store[parent] = [];
        }
        store[parent].push(obj);
    }
}
var TreeCollection = /** @class */ (function (_super) {
    __extends(TreeCollection, _super);
    function TreeCollection(config, events) {
        var _a;
        var _this = _super.call(this, config, events) || this;
        _this._childs = {};
        var root = (_this._root = (config && config.rootId) || "_ROOT_" + (0, core_1.uid)());
        _this._childs = (_a = {}, _a[root] = [], _a);
        _this._initChilds = null;
        return _this;
    }
    TreeCollection.prototype.add = function (newItem, index, parent) {
        var _this = this;
        if (index === void 0) { index = -1; }
        if (parent === void 0) { parent = this._root; }
        if (!this.events.fire(types_1.DataEvents.beforeAdd, [newItem])) {
            return;
        }
        if (typeof newItem !== "object") {
            newItem = {
                value: newItem,
            };
        }
        var out;
        if (Array.isArray(newItem)) {
            out = newItem.map(function (element, key) {
                return _this._add(element, index, parent, key);
            });
        }
        else {
            out = this._add(newItem, index, parent);
        }
        this._reapplyFilters(false);
        return out;
    };
    TreeCollection.prototype.getRoot = function () {
        return this._root;
    };
    TreeCollection.prototype.getParent = function (id, asObj) {
        if (asObj === void 0) { asObj = false; }
        if (!this._pull[id]) {
            return null;
        }
        var parent = this._pull[id].parent;
        return asObj ? this._pull[parent] : parent;
    };
    TreeCollection.prototype.getItems = function (id) {
        if (this._childs && this._childs[id]) {
            return this._childs[id];
        }
        return [];
    };
    TreeCollection.prototype.getLength = function (id) {
        if (id === void 0) { id = this._root; }
        if (!this._childs[id]) {
            return null;
        }
        return this._childs[id].length;
    };
    TreeCollection.prototype.removeAll = function (id) {
        var _a;
        if (!(0, core_1.isId)(id)) {
            _super.prototype.removeAll.call(this);
            var root = this._root;
            this._initChilds = null;
            this._childs = (_a = {}, _a[root] = [], _a);
        }
        else if (this._childs[id]) {
            var childs = __spreadArray([], this._childs[id], true);
            for (var _i = 0, childs_1 = childs; _i < childs_1.length; _i++) {
                var child = childs_1[_i];
                this.remove(child.id);
            }
        }
    };
    TreeCollection.prototype.getIndex = function (id) {
        var parent = this.getParent(id);
        if (!parent || !this._childs[parent]) {
            return -1;
        }
        return (0, core_1.findIndex)(this._childs[parent], function (item) { return item.id === id; });
    };
    TreeCollection.prototype.sort = function (rule) {
        var _this = this;
        if (!rule) {
            this._childs = {};
            // [dirty]
            this._parse_data(Object.keys(this._pull).map(function (key) { return _this._pull[key]; }));
            this._reapplyFilters(false);
        }
        else {
            for (var key in this._childs) {
                this._sort.sort(this._childs[key], rule);
            }
            if (this._initChilds && Object.keys(this._initChilds).length) {
                for (var key in this._initChilds) {
                    this._sort.sort(this._initChilds[key], rule);
                }
            }
        }
        this.events.fire(types_1.DataEvents.change, [undefined, "sort", rule]);
    };
    TreeCollection.prototype.filter = function (rule, config, silent) {
        if (config === null || config === void 0 ? void 0 : config.$restore) {
            rule = this._normalizeFilters(rule || this._filters);
        }
        if (!rule || !(config === null || config === void 0 ? void 0 : config.add)) {
            this.restoreOrder();
            if (!(config === null || config === void 0 ? void 0 : config.$restore)) {
                for (var key in this._filters) {
                    var _a = this._filters[key], rule_1 = _a.rule, conf = _a.config;
                    if (conf === null || conf === void 0 ? void 0 : conf.permanent) {
                        this._applyFilter(rule_1, conf);
                    }
                    else {
                        delete this._filters[key];
                    }
                }
            }
        }
        var id;
        if (rule && !(config === null || config === void 0 ? void 0 : config.$restore)) {
            id = (config === null || config === void 0 ? void 0 : config.id) || (0, core_1.uid)();
            if (!config)
                config = {};
            config.type = config.type || types_1.TreeFilterType.all;
            this._filters[id] = { rule: rule, config: config };
            this._applyFilter(rule, config);
        }
        else {
            for (var key in rule) {
                this._applyFilter(rule[key], this._filters[key].config);
            }
        }
        if (!silent) {
            var filters = this._getPureFilters(this._filters);
            this.events.fire(types_1.DataEvents.filter, [(0, core_1.isEmptyObj)(filters) ? null : filters]);
        }
        return id;
    };
    TreeCollection.prototype.restoreOrder = function () {
        if (this._initChilds) {
            this._childs = this._initChilds;
            this._initChilds = null;
        }
    };
    TreeCollection.prototype.copy = function (id, index, target, targetId) {
        var _this = this;
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (id instanceof Array) {
            return id.map(function (elementId, key) {
                return _this._copy(elementId, index, target, targetId, key);
            });
        }
        else {
            return this._copy(id, index, target, targetId);
        }
    };
    TreeCollection.prototype.move = function (id, index, target, targetId) {
        var _this = this;
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (id instanceof Array) {
            return id.map(function (elementId, key) {
                return _this._move(elementId, index, target, targetId, key);
            });
        }
        else {
            return this._move(id, index, target, targetId);
        }
    };
    TreeCollection.prototype.forEach = function (callback, parent, level) {
        if (parent === void 0) { parent = this._root; }
        if (level === void 0) { level = Infinity; }
        if (!this.haveItems(parent) || level < 1) {
            return;
        }
        var array = this._childs[parent];
        for (var i = 0; i < array.length; i++) {
            callback.call(this, array[i], i, array);
            if (this.haveItems(array[i].id)) {
                this.forEach(callback, array[i].id, --level);
            }
        }
    };
    TreeCollection.prototype.eachChild = function (id, callback, direct, checkItem) {
        if (direct === void 0) { direct = true; }
        if (checkItem === void 0) { checkItem = function () { return true; }; }
        if (!this.haveItems(id)) {
            return;
        }
        for (var i = 0; i < this._childs[id].length; i++) {
            callback.call(this, this._childs[id][i], i);
            if (direct && checkItem(this._childs[id][i])) {
                this.eachChild(this._childs[id][i].id, callback, direct, checkItem);
            }
        }
    };
    TreeCollection.prototype.getNearId = function (id) {
        return id; // for selection
    };
    TreeCollection.prototype.loadItems = function (id, driver) {
        var _this = this;
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        if (!this.events.fire(types_1.DataEvents.beforeItemLoad, [id])) {
            return;
        }
        var urlPart = this.config.autoload.toString();
        var url = urlPart + (urlPart.includes("?") ? "&id=".concat(id) : "?id=".concat(id));
        var proxy = new dataproxy_1.DataProxy(url);
        proxy
            .load()
            .then(function (data) {
            driver = (0, helpers_1.toDataDriver)(driver);
            data = driver.toJsonArray(data);
            _this._parse_data(data, id);
            _this.events.fire(types_1.DataEvents.change);
            _this.events.fire(types_1.DataEvents.afterItemLoad, [id]);
        })
            .catch(function (error) {
            _this.events.fire(types_1.DataEvents.loadError, [error]);
        });
    };
    TreeCollection.prototype.refreshItems = function (id, driver) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        this.removeAll(id);
        this.loadItems(id, driver);
    };
    TreeCollection.prototype.eachParent = function (id, callback, self) {
        if (self === void 0) { self = false; }
        var item = this.getItem(id);
        if (!item) {
            return;
        }
        if (self) {
            callback.call(this, item);
        }
        if (item.parent === this._root) {
            return;
        }
        var parent = this.getItem(item.parent);
        callback.call(this, parent);
        this.eachParent(item.parent, callback);
    };
    TreeCollection.prototype.haveItems = function (id) {
        return id in this._childs;
    };
    TreeCollection.prototype.canCopy = function (id, target) {
        if (id === target) {
            return false;
        }
        var canCopy = true;
        this.eachParent(target, function (item) { return (item.id === id ? (canCopy = false) : null); }); // locate return string
        return canCopy;
    };
    TreeCollection.prototype.serialize = function (driver, checkItem) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        var data = this._serialize(this._root, checkItem);
        var dataDriver = (0, helpers_1.toDataDriver)(driver);
        if (dataDriver) {
            return dataDriver.serialize(data);
        }
    };
    TreeCollection.prototype.getId = function (index, parent) {
        if (parent === void 0) { parent = this._root; }
        if (!this._childs[parent] || !this._childs[parent][index]) {
            return;
        }
        return this._childs[parent][index].id;
    };
    // Non public API from suite_6.4
    TreeCollection.prototype.map = function (callback, parent, direct) {
        if (parent === void 0) { parent = this._root; }
        if (direct === void 0) { direct = true; }
        var result = [];
        if (!this.haveItems(parent)) {
            return result;
        }
        for (var i = 0; i < this._childs[parent].length; i++) {
            result.push(callback.call(this, this._childs[parent][i], i, this._childs));
            if (direct) {
                var childResult = this.map(callback, this._childs[parent][i].id, direct);
                result = result.concat(childResult);
            }
        }
        return result;
    };
    TreeCollection.prototype.getRawData = function (from, to, order, mode, parent) {
        parent = parent !== null && parent !== void 0 ? parent : this._root;
        var out;
        if (!this._childs[parent])
            return [];
        if (parent === this._root)
            out = _super.prototype.getRawData.call(this, from, to, this._childs[parent]);
        else
            out = this._childs[parent];
        if (mode === 2) {
            return this.flatten(out);
        }
        return out;
    };
    TreeCollection.prototype.flatten = function (input) {
        var _this = this;
        var out = [];
        input.forEach(function (a) {
            out.push(a);
            var kids = _this._childs[a.id];
            if (kids && a.$opened) {
                out = out.concat(_this.flatten(kids));
            }
        });
        return out;
    };
    TreeCollection.prototype._add = function (newItem, index, parent, key) {
        if (index === void 0) { index = -1; }
        if (parent === void 0) { parent = this._root; }
        this._setParent(newItem, parent);
        if (key > 0 && index !== -1) {
            index = index + 1;
        }
        var id = _super.prototype._add.call(this, newItem, index);
        if (Array.isArray(newItem.items)) {
            for (var _i = 0, _a = newItem.items; _i < _a.length; _i++) {
                var item = _a[_i];
                this.add(item, -1, newItem.id);
            }
        }
        return id;
    };
    TreeCollection.prototype._setParent = function (item, parent) {
        item.parent = item.parent ? item.parent.toString() : parent;
        var parentItem = this._pull[item.parent];
        if (parentItem && !parentItem.items) {
            parentItem.items = [];
        }
    };
    TreeCollection.prototype._copy = function (id, index, target, targetId, key) {
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (!this.exists(id)) {
            return null;
        }
        var currentChilds = this._childs[id];
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target === this && !this.canCopy(id, targetId)) {
            return null;
        }
        var itemCopy = (0, helpers_1.copyWithoutInner)(this.getItem(id), { items: true });
        if (target.exists(id)) {
            itemCopy.id = (0, core_1.uid)();
        }
        if (!(0, helpers_1.isTreeCollection)(target)) {
            target.add(itemCopy, index);
            return;
        }
        if (this.exists(id)) {
            itemCopy.parent = targetId;
            if (target !== this && targetId === this._root) {
                itemCopy.parent = target.getRoot();
            }
            target.add(itemCopy, index);
            id = itemCopy.id;
        }
        if (currentChilds) {
            for (var _i = 0, currentChilds_1 = currentChilds; _i < currentChilds_1.length; _i++) {
                var child = currentChilds_1[_i];
                var childId = child.id;
                var childIndex = this.getIndex(childId);
                if (typeof id === "string") {
                    this.copy(childId, childIndex, target, id);
                }
            }
        }
        return id;
    };
    TreeCollection.prototype._move = function (id, index, target, targetId, key) {
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (!this.exists(id)) {
            return null;
        }
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target !== this) {
            if (!(0, helpers_1.isTreeCollection)(target)) {
                // move to datacollection
                target.add((0, helpers_1.copyWithoutInner)(this.getItem(id)), index);
                this.remove(id);
                return;
            }
            var returnId = this.copy(id, index, target, targetId);
            this.remove(id);
            return returnId;
        }
        // move inside
        if (!this.canCopy(id, targetId)) {
            return null;
        }
        var parent = this.getParent(id);
        var parentIndex = this.getIndex(id);
        // get item from parent array and move to target array
        var spliced = this._childs[parent].splice(parentIndex, 1)[0];
        spliced.parent = targetId; // need for next moving, ... not best solution, may be full method for get item
        if (!this._childs[parent].length) {
            delete this._childs[parent];
        }
        if (!this.haveItems(targetId)) {
            this._childs[targetId] = [];
        }
        if (index === -1) {
            index = this._childs[targetId].push(spliced);
        }
        else {
            this._childs[targetId].splice(index, 0, spliced);
        }
        this.events.fire(types_1.DataEvents.change, [id, "update", this.getItem(id)]);
        return id;
    };
    TreeCollection.prototype._reset = function (id) {
        var _a;
        if ((0, core_1.isId)(id)) {
            var childs = __spreadArray([], this._childs[id], true);
            for (var _i = 0, childs_2 = childs; _i < childs_2.length; _i++) {
                var child = childs_2[_i];
                this.remove(child.id);
            }
        }
        else {
            _super.prototype._reset.call(this);
            var root = this._root;
            this._initChilds = null;
            this._childs = (_a = {}, _a[root] = [], _a);
        }
    };
    TreeCollection.prototype._removeCore = function (id) {
        if (this._pull[id]) {
            var parent_1 = this.getParent(id);
            this._childs[parent_1] = this._childs[parent_1].filter(function (item) { return item.id !== id; });
            if (parent_1 !== this._root && !this._childs[parent_1].length) {
                delete this._childs[parent_1];
            }
            if (this._initChilds && this._initChilds[parent_1]) {
                this._initChilds[parent_1] = this._initChilds[parent_1].filter(function (item) { return item.id !== id; });
                if (parent_1 !== this._root && !this._initChilds[parent_1].length) {
                    delete this._initChilds[parent_1];
                }
            }
            if (this._initOrder && this._initOrder.length) {
                this._initOrder = this._initOrder.filter(function (el) { return el.id !== id; });
            }
            this._fastDeleteChilds(this._childs, id);
            if (this._initChilds) {
                this._fastDeleteChilds(this._initChilds, id);
            }
        }
    };
    TreeCollection.prototype._addToOrder = function (_order, obj, index) {
        var childs = this._childs;
        var initChilds = this._initChilds;
        var parent = obj.parent;
        this._pull[obj.id] = obj;
        if (obj.parent &&
            this._pull[obj.parent] &&
            this._pull[obj.parent].items &&
            !this._pull[obj.parent].items.find(function (item) { return item.id === obj.id; })) {
            this._pull[obj.parent].items.push(obj);
        }
        _super.prototype._addToOrder.call(this, _order, obj, index);
        addToOrder(childs, obj, parent, index);
        if (initChilds) {
            addToOrder(initChilds, obj, parent, index);
        }
    };
    TreeCollection.prototype._parse_data = function (data, parent) {
        var _a;
        if (parent === void 0) { parent = this._root; }
        var index = this._order.length;
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var obj = data_1[_i];
            if (this.config.init) {
                obj = this.config.init(obj);
            }
            if (obj && typeof obj !== "object") {
                obj = {
                    value: obj,
                };
            }
            obj.id = (_a = obj.id) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
            obj.parent =
                typeof obj.parent === "undefined" || obj.parent === null || (obj.parent && obj.$items)
                    ? parent
                    : obj.parent;
            if (this._pull[obj.id]) {
                (0, helpers_1.dhxError)("Item ".concat(obj.id, " already exist"));
            }
            this._pull[obj.id] = obj;
            this._order[index++] = obj;
            if (!this._childs[obj.parent]) {
                this._childs[obj.parent] = [];
            }
            this._childs[obj.parent].push(obj);
            if (obj.items && obj.items instanceof Object) {
                this._parse_data(obj.items, obj.id);
            }
        }
    };
    TreeCollection.prototype._fastDeleteChilds = function (target, id) {
        if (this._pull[id]) {
            delete this._pull[id];
        }
        if (!target[id]) {
            return;
        }
        for (var i = 0; i < target[id].length; i++) {
            this._fastDeleteChilds(target, target[id][i].id);
        }
        delete target[id];
    };
    TreeCollection.prototype._recursiveFilter = function (rule, config, current, level, newChilds) {
        var _this = this;
        var childs = this._childs[current];
        if (!childs) {
            return;
        }
        var condition = function (item) {
            switch (config.type) {
                case types_1.TreeFilterType.all: {
                    return true;
                }
                case types_1.TreeFilterType.level: {
                    return level === config.level;
                }
                case types_1.TreeFilterType.leafs: {
                    return !_this.haveItems(item.id);
                }
            }
        };
        if (typeof rule === "function") {
            var customRule = function (item) { return condition(item) && rule(item); };
            var filtered = childs.filter(customRule);
            if (filtered.length) {
                newChilds[current] = filtered;
            }
            else if (current === this._root) {
                newChilds[current] = [];
            }
        }
        else {
            var customRule = function (item) {
                var _a;
                var responseOfRule = true;
                for (var compare in rule) {
                    if (rule[compare].by && rule[compare].match !== "") {
                        responseOfRule = rule[compare].compare
                            ? rule[compare].compare(item[rule[compare].by], rule[compare].match, item)
                            : ((_a = item[rule[compare].by]) === null || _a === void 0 ? void 0 : _a.toString().toLocaleLowerCase().indexOf(rule[compare].match.toString().toLowerCase())) !== -1;
                    }
                    if (!responseOfRule)
                        break;
                }
                return condition(item) && responseOfRule;
            };
            var filtered = childs.filter(customRule);
            if (filtered.length) {
                newChilds[current] = filtered;
            }
            else if (current === this._root) {
                newChilds[current] = [];
            }
        }
        for (var _i = 0, childs_3 = childs; _i < childs_3.length; _i++) {
            var child = childs_3[_i];
            this._recursiveFilter(rule, config, child.id, level + 1, newChilds);
        }
    };
    TreeCollection.prototype._serialize = function (parent, fn) {
        var _this = this;
        if (parent === void 0) { parent = this._root; }
        return this.map(function (item) {
            var itemCopy = {};
            for (var key in item) {
                if (key === "parent" || key === "items" || key.startsWith("$")) {
                    continue;
                }
                itemCopy[key] = item[key];
            }
            if (fn) {
                itemCopy = fn(itemCopy);
            }
            if (_this.haveItems(item.id)) {
                itemCopy.items = _this._serialize(item.id, fn);
            }
            return itemCopy;
        }, parent, false);
    };
    TreeCollection.prototype._applyFilter = function (rule, config) {
        var _this = this;
        if (!rule || (typeof rule !== "function" && (0, core_1.isEmptyObj)(rule)))
            return;
        if (!this._initOrder) {
            this._initOrder = this._order;
        }
        if (!this._initChilds) {
            this._initChilds = this._childs;
        }
        var filter;
        var newChilds = {};
        if (typeof rule !== "function") {
            filter = {};
            if ((0, core_1.isDefined)(rule.by)) {
                filter[rule.by] = rule;
            }
            else {
                for (var key in rule) {
                    filter[key] = rule[key];
                }
            }
        }
        else {
            filter = rule;
        }
        this._recursiveFilter(filter, config, this._root, 0, newChilds);
        Object.keys(newChilds).forEach(function (key) {
            var parentId = _this.getParent(key);
            var current = _this.getItem(key);
            while (parentId) {
                if (!newChilds[parentId]) {
                    newChilds[parentId] = [];
                }
                if (current && !newChilds[parentId].find(function (x) { return x.id === current.id; })) {
                    newChilds[parentId].push(current);
                }
                current = _this.getItem(parentId);
                parentId = _this.getParent(parentId);
            }
        });
        this._childs = newChilds;
    };
    TreeCollection.prototype._normalizeFilters = function (filters) {
        var rules = {};
        for (var key in filters) {
            rules[key] = filters[key].rule;
        }
        return rules;
    };
    return TreeCollection;
}(datacollection_1.DataCollection));
exports.TreeCollection = TreeCollection;


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dragManager = void 0;
var html_1 = __webpack_require__(3);
var ts_grid_1 = __webpack_require__(64);
var CollectionStore_1 = __webpack_require__(161);
var types_1 = __webpack_require__(22);
var helpers_1 = __webpack_require__(23);
var core_1 = __webpack_require__(1);
function getPosition(e) {
    var y = e.clientY;
    var element = (0, html_1.locateNode)(e);
    if (!element) {
        return null;
    }
    var treeLine = element.childNodes[0];
    if (treeLine) {
        var _a = treeLine.getBoundingClientRect(), top_1 = _a.top, height = _a.height;
        return (y - top_1) / height;
    }
}
function dragEventContent(element, elements, exhaustiveList) {
    if (exhaustiveList === void 0) { exhaustiveList = false; }
    var rect = element.getBoundingClientRect();
    var ghost = document.createElement("div");
    var clone = element.cloneNode(true);
    var fontSize = window.getComputedStyle(element.parentElement).fontSize;
    clone.style.width = rect.width + "px";
    clone.style.height = rect.height + "px";
    clone.style.maxHeight = rect.height + "px";
    clone.style.opacity = "0.8";
    clone.style.fontSize = fontSize;
    if (!exhaustiveList || !elements || !elements.length) {
        ghost.appendChild(clone);
    }
    if (elements && elements.length) {
        elements.forEach(function (node, key) {
            var nodeClone = node.cloneNode(true);
            nodeClone.style.width = rect.width + "px";
            nodeClone.style.height = rect.height + "px";
            nodeClone.style.maxHeight = rect.height + "px";
            nodeClone.style.top = (key + 1) * 12 - rect.height - rect.height * key + "px";
            nodeClone.style.left = (key + 1) * 12 + "px";
            nodeClone.style.opacity = "0.6";
            nodeClone.style.zIndex = "".concat(-key - 1);
            if (!exhaustiveList) {
                nodeClone.style.fontSize = fontSize;
                nodeClone.style.overflow = "hidden";
            }
            ghost.appendChild(nodeClone);
        });
    }
    ghost.className = "dhx_drag-ghost";
    return ghost;
}
var DragManager = /** @class */ (function () {
    function DragManager() {
        var _this = this;
        this._transferData = {};
        this._canMove = true;
        this._isDrag = false;
        this._onMouseMove = function (e) {
            if (!_this._transferData.start) {
                return;
            }
            var pageX = e.targetTouches ? e.targetTouches[0].pageX : e.pageX;
            var pageY = e.targetTouches ? e.targetTouches[0].pageY : e.pageY;
            var _a = _this._transferData, x = _a.x, y = _a.y, start = _a.start, componentId = _a.componentId;
            if (!_this._transferData.ghost) {
                if (Math.abs(x - pageX) < 3 && Math.abs(y - pageY) < 3) {
                    return;
                }
                else {
                    var ghost = _this._onDragStart(start, componentId, e);
                    if (!ghost) {
                        _this._endDrop(e);
                        return;
                    }
                    else {
                        _this._transferData.ghost = ghost;
                        document.body.appendChild(_this._transferData.ghost);
                    }
                }
            }
            _this._moveGhost(pageX, pageY);
            _this._onDrag(e);
        };
        this._onMouseUp = function (e) {
            if (!_this._transferData.x) {
                return;
            }
            if (_this._transferData.ghost) {
                _this._removeGhost();
                _this._onDrop(e);
            }
            else {
                _this._endDrop(e);
            }
            if (!e.targetTouches) {
                document.removeEventListener("mousemove", _this._onMouseMove);
                document.removeEventListener("mouseup", _this._onMouseUp);
            }
            else {
                document.removeEventListener("touchmove", _this._onMouseMove);
                document.removeEventListener("touchend", _this._onMouseUp);
            }
        };
    }
    DragManager.prototype.setItem = function (id, item) {
        CollectionStore_1.collectionStore.setItem(id, item);
    };
    DragManager.prototype.onMouseDown = function (event, source, itemsForGhost) {
        // onmousedown only for target objects
        if (event.which !== 1 && !event.targetTouches) {
            return;
        }
        if (!event.targetTouches) {
            document.addEventListener("mousemove", this._onMouseMove);
            document.addEventListener("mouseup", this._onMouseUp);
        }
        else {
            document.addEventListener("touchmove", this._onMouseMove, false);
            document.addEventListener("touchend", this._onMouseUp, false);
        }
        var item = (0, html_1.locateNode)(event, "data-dhx-id");
        var id = item && item.getAttribute("data-dhx-id");
        var componentId = (0, html_1.locate)(event, "data-dhx-widget-id");
        if (Array.isArray(source) && source.includes(id)) {
            this._transferData.source = __spreadArray([], source, true);
            this._itemsForGhost = itemsForGhost;
        }
        else {
            this._transferData.source = [id];
            this._itemsForGhost = null;
        }
        if (id && componentId) {
            var _a = (0, html_1.getBox)(item), left = _a.left, top_2 = _a.top;
            var pageX = event.targetTouches
                ? event.targetTouches[0].pageX
                : event.pageX;
            var pageY = event.targetTouches
                ? event.targetTouches[0].pageY
                : event.pageY;
            this._transferData.initXOffset = pageX - left;
            this._transferData.initYOffset = pageY - top_2;
            this._transferData.x = pageX;
            this._transferData.y = pageY;
            this._transferData.componentId = componentId;
            this._transferData.start = id;
            this._transferData.item = item;
        }
    };
    DragManager.prototype.isDrag = function () {
        return this._isDrag;
    };
    DragManager.prototype.cancelCanDrop = function (event) {
        this._canMove = false;
        this._isDrag = false;
        var _a = this._transferData, start = _a.start, source = _a.source, target = _a.target, dropComponentId = _a.dropComponentId;
        var data = {
            start: start,
            source: source,
            target: target,
        };
        var collection = CollectionStore_1.collectionStore.getItem(dropComponentId);
        if (collection && target) {
            collection.events.fire(types_1.DragEvents.cancelDrop, [data, event]);
        }
        this._transferData.dropComponentId = null;
        this._transferData.target = null;
    };
    DragManager.prototype._moveGhost = function (x, y) {
        if (this._transferData.ghost) {
            this._transferData.ghost.style.left = x - this._transferData.initXOffset + "px";
            this._transferData.ghost.style.top = y - this._transferData.initYOffset + "px";
        }
    };
    DragManager.prototype._removeGhost = function () {
        document.body.removeChild(this._transferData.ghost);
    };
    DragManager.prototype._onDrop = function (e) {
        if (!this._canMove) {
            this._endDrop(e);
            return;
        }
        var _a = this._transferData, start = _a.start, source = _a.source, target = _a.target, dropComponentId = _a.dropComponentId, dropPosition = _a.dropPosition;
        var data = { start: start, source: source, target: target, dropPosition: dropPosition };
        var component = CollectionStore_1.collectionStore.getItem(dropComponentId);
        var config = component && component.config;
        if (!component || config.dragMode === "source") {
            this._endDrop(e);
            return;
        }
        if (component.events.fire(types_1.DragEvents.beforeDrop, [data, e])) {
            var to = {
                id: target,
                component: component,
            };
            var from = {
                id: start,
                component: this._transferData.component,
                newId: null,
            };
            this._move(from, to);
            if (from.newId && from.component !== to.component)
                data.start = from.newId;
            to.component.events.fire(types_1.DragEvents.afterDrop, [data, e]);
        }
        this._endDrop(e);
    };
    DragManager.prototype._onDragStart = function (id, componentId, e) {
        var component = CollectionStore_1.collectionStore.getItem(componentId);
        var config = component.config;
        var _a = this._transferData, start = _a.start, source = _a.source, target = _a.target;
        var data = {
            start: start,
            source: source,
            target: target,
        };
        if (config.dragMode === "target" || component._pregroupData) {
            return null;
        }
        var ghost = dragEventContent(this._transferData.item, this._itemsForGhost, config.dragItem === "row" || config.dragItem === "column" || config.dragItem === "both");
        var ans = component.events.fire(types_1.DragEvents.beforeDrag, [data, e, ghost]);
        if (!ans || !(0, core_1.isId)(id)) {
            return null;
        }
        component.events.fire(types_1.DragEvents.dragStart, [data, e]);
        this._isDrag = true;
        this._toggleTextSelection(true);
        this._transferData.component = component;
        this._transferData.dragConfig = config;
        return ghost;
    };
    DragManager.prototype._onDrag = function (e) {
        var clientX = e.targetTouches ? e.targetTouches[0].clientX : e.clientX;
        var clientY = e.targetTouches ? e.targetTouches[0].clientY : e.clientY;
        var element = document.elementFromPoint(clientX, clientY);
        var collectionId = (0, html_1.locate)(element, "data-dhx-widget-id");
        var component = CollectionStore_1.collectionStore.getItem(collectionId);
        if (!component) {
            if (this._canMove) {
                this.cancelCanDrop(e);
            }
            return;
        }
        var isTreeHeaderOrFooter = !!(0, html_1.locateNodeByClassName)(element, "dhx_grid-header") ||
            !!(0, html_1.locateNodeByClassName)(element, "dhx_grid-footer");
        var gridConfig = component.config.columns
            ? component.config
            : undefined;
        var isColumnDrag = gridConfig && (gridConfig.dragItem === "both" || gridConfig.dragItem === "column");
        if (isTreeHeaderOrFooter && !isColumnDrag) {
            if (this._canMove) {
                this.cancelCanDrop(e);
            }
            return;
        }
        var id = (0, html_1.locate)(element, "data-dhx-id");
        var rootId = (0, html_1.locate)(element, "data-dhx-root-id");
        if (!id && !rootId) {
            this.cancelCanDrop(e);
            this._transferData.dropComponentId = collectionId;
            this._transferData.target = null;
            this._canDrop(e);
            return;
        }
        var _a = this._transferData, dropComponentId = _a.dropComponentId, start = _a.start, source = _a.source, target = _a.target, componentId = _a.componentId, dropPosition = _a.dropPosition;
        if (component.config.dropBehaviour === "complex") {
            var pos = getPosition(e);
            if (pos <= 0.25) {
                this._transferData.dropPosition = "top";
            }
            else if (pos >= 0.75) {
                this._transferData.dropPosition = "bottom";
            }
            else {
                this._transferData.dropPosition = "in";
            }
        }
        else if ((target === id || (!id && target === rootId)) && dropComponentId === collectionId) {
            return;
        }
        var from = {
            id: start,
            component: this._transferData.component,
        };
        if (component.config.dragMode === "source") {
            return;
        }
        from.component.events.fire(types_1.DragEvents.dragOut, [
            {
                start: start,
                source: source,
                target: target,
            },
            e,
        ]);
        if (collectionId !== componentId ||
            !(0, helpers_1.isTreeCollection)(from.component.data) ||
            ((0, helpers_1.isTreeCollection)(from.component.data) && from.component.data.canCopy(from.id, id))) {
            this.cancelCanDrop(e); // clear last
            this._transferData.target = id || rootId;
            this._transferData.dropComponentId = collectionId;
            var canMove = from.component.events.fire(types_1.DragEvents.dragIn, [
                {
                    start: start,
                    source: source,
                    target: target,
                    dropPosition: dropPosition,
                },
                e,
            ]);
            if (canMove) {
                this._canDrop(e);
            }
        }
        else {
            this.cancelCanDrop(e);
        }
    };
    DragManager.prototype._move = function (from, to) {
        var grid = from.component;
        var nextGrid = to.component;
        var fromData = from.component.data;
        var toData = to.component.data;
        var index = 0;
        var componentId = to.id;
        var behaviour = (0, helpers_1.isTreeCollection)(toData) ? to.component.config.dropBehaviour : undefined;
        var gridConfig = from.component.config.columns
            ? from.component.config
            : undefined;
        var isColumnDrag = gridConfig &&
            (gridConfig.dragItem === "both" || gridConfig.dragItem === "column") &&
            gridConfig.columns.map(function (c) { return c.id; }).filter(function (id) { return id === from.id || id === to.id; }).length;
        if (isColumnDrag && from.component === to.component) {
            if (from.id === to.id)
                return;
            var currentCols = grid.config.columns.map(function (c) { return (__assign({}, c)); });
            var sourceIndex = currentCols.findIndex(function (c) { return c.id === from.id; });
            var componentIndex = currentCols.findIndex(function (c) { return c.id === to.id; });
            if (componentIndex === -1)
                return;
            currentCols.splice(componentIndex, 0, currentCols.splice(sourceIndex, 1)[0]);
            grid.setColumns(currentCols);
            grid.paint();
            return;
        }
        else if (isColumnDrag && from.component instanceof ts_grid_1.ProGrid && to.component instanceof ts_grid_1.ProGrid) {
            var currentCols = grid.config.columns.map(function (c) { return (__assign({}, c)); });
            var sourceIndex = currentCols.findIndex(function (c) { return c.id === from.id; });
            var nextGridCols = nextGrid.config.columns.map(function (c) { return (__assign({}, c)); });
            var nextGridLength = nextGrid.data.getLength();
            var componentIndex = nextGridCols.findIndex(function (c) { return c.id === to.id; });
            var currentColumnData_1 = [];
            var currentColumnId_1 = from.id;
            grid.data.forEach(function (item) {
                var _a;
                currentColumnData_1.push((_a = { id: item.id }, _a[currentColumnId_1] = item[from.id], _a));
            });
            if (nextGridLength) {
                grid.data.forEach(function (item, index) {
                    var nextGridItem = nextGrid.data.getItem(item.id);
                    if (nextGridItem) {
                        nextGrid.data.update(nextGridItem.id, __assign(__assign({}, nextGridItem), currentColumnData_1[index]));
                    }
                    else {
                        nextGrid.data.add(currentColumnData_1[index]);
                    }
                });
            }
            else {
                nextGrid.data.parse(currentColumnData_1);
            }
            var col = currentCols.splice(sourceIndex, 1)[0];
            nextGridCols.find(function (c) { return c.id === currentColumnId_1; }) || nextGridCols.splice(componentIndex, 0, col);
            nextGrid.setColumns(nextGridCols);
            nextGrid.paint();
            grid.setColumns(currentCols);
            grid.paint();
            return;
        }
        var isRootParent = to.id === nextGrid.config.rootParent;
        switch (behaviour) {
            case "child":
                break;
            case "sibling":
                componentId = toData.getParent(componentId);
                index = toData.getIndex(to.id) + 1;
                break;
            case "complex": {
                var dropPosition = this._transferData.dropPosition;
                if (isRootParent) {
                    componentId = to.id;
                    index = toData.getLength();
                }
                else {
                    if (dropPosition === "top") {
                        componentId = toData.getParent(componentId);
                        index = toData.getIndex(to.id);
                    }
                    else if (dropPosition === "bottom") {
                        componentId = toData.getParent(componentId);
                        index = toData.getIndex(to.id) + 1;
                    }
                }
                break;
            }
            default:
                // list move
                if (!(0, core_1.isId)(to.id)) {
                    index = -1;
                }
                else if (from.component === to.component &&
                    toData.getIndex(from.id) < toData.getIndex(to.id)) {
                    index = toData.getIndex(to.id) - 1;
                }
                else {
                    if (toData.getIndex(from.id) > -1)
                        from.newId = (0, core_1.uid)();
                    index = toData.getIndex(to.id);
                }
        }
        if (this._transferData.dragConfig.dragCopy) {
            if (this._transferData.source instanceof Array && this._transferData.source.length > 1) {
                this._transferData.source.map(function (selctedId) {
                    fromData.copy(selctedId, index, toData, componentId);
                    if (index > -1) {
                        index++;
                    }
                });
            }
            else {
                fromData.copy(from.id, index, toData, componentId);
            }
        }
        else {
            if (this._transferData.source instanceof Array && this._transferData.source.length > 1) {
                fromData.move(this._transferData.source, index, toData, componentId);
            }
            else {
                if (nextGrid instanceof ts_grid_1.Grid && !nextGrid.config.columns.length) {
                    var gridItem = grid.data.getItem(from.id);
                    nextGrid.data.parse([__assign({}, gridItem)]);
                    nextGrid.setColumns(__spreadArray([], grid.config.columns, true));
                    nextGrid.paint();
                    grid.data.remove(from.id);
                    grid.paint();
                }
                else {
                    fromData.move(from.id, index, toData, componentId, from.newId);
                }
            }
        }
    };
    DragManager.prototype._endDrop = function (e) {
        this._toggleTextSelection(false);
        if (this._transferData.component) {
            var _a = this._transferData, start = _a.start, source = _a.source, target = _a.target;
            var data = { start: start, source: source, target: target };
            this._transferData.component.events.fire(types_1.DragEvents.afterDrag, [data, e]);
        }
        this.cancelCanDrop(e);
        this._canMove = true;
        this._transferData = {};
        this._transferData.target = null;
        this._transferData.dropComponentId = null;
    };
    DragManager.prototype._canDrop = function (e) {
        this._canMove = true;
        var _a = this._transferData, start = _a.start, source = _a.source, target = _a.target, dropPosition = _a.dropPosition;
        var data = {
            start: start,
            source: source,
            target: target,
            dropPosition: dropPosition,
        };
        var component = CollectionStore_1.collectionStore.getItem(this._transferData.dropComponentId);
        if (component && this._transferData.target) {
            if (component instanceof ts_grid_1.Grid) {
                data.dragItem = this._transferData.item.classList.contains("dhx_grid-row")
                    ? "row"
                    : "column";
            }
            component.events.fire(types_1.DragEvents.canDrop, [data, e]);
        }
    };
    DragManager.prototype._toggleTextSelection = function (add) {
        if (add) {
            document.body.classList.add("dhx_no-select");
        }
        else {
            document.body.classList.remove("dhx_no-select");
        }
    };
    return DragManager;
}());
var dhx = (window.dhxHelpers = window.dhxHelpers || {});
dhx.dragManager = dhx.dragManager || new DragManager();
exports.dragManager = dhx.dragManager;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Exporter = void 0;
var main_1 = __webpack_require__(15);
var ts_data_1 = __webpack_require__(7);
var core_1 = __webpack_require__(1);
var date_1 = __webpack_require__(16);
var html_1 = __webpack_require__(3);
var dom_1 = __webpack_require__(0);
function fillArray(arr, value) {
    for (var i = 0; i < arr.length; i++) {
        arr[i] = value;
    }
    return arr;
}
var Exporter = /** @class */ (function () {
    function Exporter(_name, _version, _view) {
        this._name = _name;
        this._version = _version;
        this._view = _view;
    }
    Exporter.prototype.pdf = function (config) {
        this._rawExport(config, "pdf", this._view);
    };
    Exporter.prototype.png = function (config) {
        this._rawExport(config, "png", this._view);
    };
    Exporter.prototype.xlsx = function (config) {
        return this._export(config);
    };
    Exporter.prototype.csv = function (config) {
        if (config === void 0) { config = {}; }
        config = __assign({
            asFile: true,
            rowDelimiter: "\n",
            columnDelimiter: ",",
            skipHeader: 0,
        }, config);
        var csv;
        if ("getRoot" in this._view.data && config.flat) {
            csv = this.getFlatCSV(config);
        }
        else {
            csv = this._getCSV(config);
        }
        var name = config.name || "grid_export";
        if (config.asFile) {
            (0, core_1.downloadFile)(csv, "".concat(name, ".csv"), "text/csv");
        }
        return csv;
    };
    Exporter.prototype._export = function (config) {
        if (config === void 0) { config = {}; }
        var configCols = this._view.config.columns.filter(function (i) { return !i.hidden; });
        var rowsIndexMap = {};
        var headers = (0, main_1.transpose)(configCols.map(function (col) { return col.header.map(function (level) { return level.text || " "; }); }));
        var columns = [];
        var uniqStyles = {
            default: {
                color: "#000000",
                background: "#FFFFFF",
                fontSize: 14,
                bold: false,
            },
        };
        var cells = [];
        var columnsIndexMap = {};
        var data = this._view.data.serialize().map(function (row, i) {
            rowsIndexMap[row.id] = i;
            var rowData = configCols.map(function (col, k) {
                columnsIndexMap[col.id] = k;
                if (row[col.id] instanceof Date) {
                    var format = col.format || "%M %d %Y";
                    if (typeof row[col.id] === "string") {
                        row[col.id] = (0, date_1.getFormattedDate)(format, (0, date_1.stringToDate)(row[col.id], format));
                    }
                    else if (typeof row[col.id] === "object") {
                        row[col.id] = (0, date_1.getFormattedDate)(format, row[col.id]);
                    }
                }
                return !row[col.id] && !k && row["$groupName"]
                    ? "^ ".concat(row["$groupName"])
                    : (0, main_1.removeHTMLTags)(row[col.id]);
            });
            return rowData;
        });
        var footer = [];
        var content = this._view.content;
        var _loop_1 = function (col) {
            if (col.footer) {
                var id_1 = col.id;
                var columnData = this_1._view.data.serialize().reduce(function (items, item) {
                    if (item[id_1] !== undefined && item[id_1] !== "" && !isNaN(item[id_1])) {
                        items.push(parseFloat(item[id_1]));
                    }
                    return items;
                }, []);
                var roots = columnData;
                if (this_1._view.config.type === "tree") {
                    var datacollection_1 = this_1._view.data;
                    var data_1 = datacollection_1.serialize();
                    roots = data_1.reduce(function (total, item) {
                        if (item.$level === 0) {
                            if (item[id_1] !== undefined && item[id_1] !== "" && !isNaN(item[id_1])) {
                                total.push(parseFloat(item[id_1]) || 0);
                            }
                            else {
                                var value_1 = 0;
                                datacollection_1.eachChild(item.id, function (cell) {
                                    if (!datacollection_1.haveItems(cell.id)) {
                                        value_1 += parseFloat(cell[id_1]);
                                    }
                                });
                                total.push(value_1);
                            }
                        }
                        return total;
                    }, []);
                }
                if (col.footer[0].content) {
                    var val = content[col.footer[0].content].calculate(columnData, roots);
                    footer.push((val === null || val === void 0 ? void 0 : val.toString()) || " ");
                }
                else {
                    footer.push(col.footer[0].css || col.footer[0].text || " ");
                }
            }
            var align = col.type === "number" || col.type === "percent" ? "right" : col.align;
            columns.push({ width: col.$width, align: align });
            for (var key in col.$cellCss) {
                var colStyle = col.$cellCss[key].trim();
                var colStyleHash = colStyle
                    .split("")
                    .reduce(function (h, letter) {
                    var hh = (h << 5) - h + letter.charCodeAt(0);
                    return Math.abs(hh & hh);
                }, 0)
                    .toString();
                if (!uniqStyles[colStyleHash]) {
                    var cont = document.body;
                    var css = (0, main_1.getStyleByClass)(colStyle, cont, "dhx_grid-row", uniqStyles.default);
                    if (css) {
                        uniqStyles[colStyleHash] = css;
                    }
                }
                if (uniqStyles[colStyleHash]) {
                    cells.push([rowsIndexMap[key], configCols.indexOf(col), colStyleHash]);
                }
            }
        };
        var this_1 = this;
        for (var _i = 0, configCols_1 = configCols; _i < configCols_1.length; _i++) {
            var col = configCols_1[_i];
            _loop_1(col);
        }
        if (footer.length) {
            data.push(footer);
        }
        var exportData = {
            name: config.name || "data",
            columns: columns,
            header: headers,
            data: data,
            styles: {
                cells: cells,
                css: uniqStyles,
            },
        };
        if (config.url) {
            var form_1 = document.createElement("form");
            form_1.setAttribute("target", "_blank");
            form_1.setAttribute("action", config.url);
            form_1.setAttribute("method", "POST");
            form_1.style.visibility = "hidden";
            var input = document.createElement("textarea");
            input.setAttribute("name", "data");
            input.value = JSON.stringify(exportData);
            form_1.appendChild(input);
            document.body.appendChild(form_1);
            form_1.submit();
            setTimeout(function () {
                form_1.parentNode.removeChild(form_1);
            }, 100);
        }
        return exportData;
    };
    Exporter.prototype.getFlatCSV = function (config) {
        var treeData = this._view.data;
        var root = treeData.getRoot();
        var firstCol = this._view.config.columns[0];
        var maxLevel = treeData.getMaxLevel();
        var getParentsChain = function (item, data) {
            var parents = [];
            for (var i = 0; i <= maxLevel; i++) {
                if (item && item[firstCol.id]) {
                    parents[item.$level] = item[firstCol.id];
                    var parent_1 = data.getParent(item.id, true);
                    if (parent_1 && parent_1.id) {
                        item = parent_1;
                    }
                    else {
                        item = null;
                    }
                }
                else {
                    parents[i] = "";
                }
            }
            return parents;
        };
        var total = "";
        treeData.eachChild(root, function (item) {
            var parents = getParentsChain(item, treeData).join(config.columnDelimiter);
            total +=
                parents +
                    Object.keys(item).reduce(function (values, key, i) {
                        if (key !== "id" && key !== "parent" && !key.startsWith("$") && i !== 0) {
                            return values + config.columnDelimiter + (item[key] === null ? "" : item[key]);
                        }
                        return values;
                    }, "");
            total += config.rowDelimiter;
        });
        var exportData = this._export(config);
        // [dirty]
        var emptyHeaders = fillArray(new Array(maxLevel + 1), "");
        var headers = exportData.header.map(function (header) {
            header.splice.apply(header, __spreadArray([0, 1], emptyHeaders, false));
            return header;
        });
        var head = new ts_data_1.CsvDriver(config).serialize(headers, true) + config.rowDelimiter;
        return head + total;
    };
    Exporter.prototype._getCSV = function (config) {
        var exportData = this._export(config);
        var headers = exportData.header;
        var driver = new ts_data_1.CsvDriver(config);
        var head = driver.serialize(headers, true);
        var readyData = driver.serialize(exportData.data, true);
        return head + "\n" + readyData;
    };
    Exporter.prototype._rawExport = function (config, mode, view) {
        var _a;
        if (config === void 0) { config = {}; }
        var viewContainer = document.createElement("div");
        viewContainer.setAttribute("style", "display: none;");
        var _b = view.config, _c = _b.$headerHeight, $headerHeight = _c === void 0 ? 0 : _c, _d = _b.$footerHeight, $footerHeight = _d === void 0 ? 0 : _d, _e = _b.$totalHeight, $totalHeight = _e === void 0 ? 0 : _e, $footer = _b.$footer, columns = _b.columns;
        var styles = "";
        var exportStyles = view.config.exportStyles;
        if (typeof config.exportStyles === "boolean" || Array.isArray(config.exportStyles)) {
            exportStyles = config.exportStyles;
        }
        config.url =
            config.url || "https://export.dhtmlx.com/" + this._name + "/" + mode + "/" + this._version;
        if (mode === "pdf") {
            var pdf = config.pdf;
            config.pdf = __assign(__assign({}, pdf), { printBackground: false, format: (_a = pdf === null || pdf === void 0 ? void 0 : pdf.format) !== null && _a !== void 0 ? _a : "A4" });
        }
        var width = view.config.$totalWidth;
        var height = $totalHeight + $headerHeight;
        if ($footer)
            height += $footerHeight;
        var viewColumns = [];
        for (var index = 0; index < columns.length; index++) {
            var col = columns[index];
            viewColumns.push(__assign(__assign({}, col), { width: col.$width }));
        }
        var viewConfig = __assign(__assign({}, view.config), { width: width, height: height, columns: viewColumns, data: view.data.getRawData(0, -1, null, 2), keyNavigation: false, selection: false, resizable: false });
        var $view = new view.constructor(viewContainer, (0, core_1.getCloneObject)(viewConfig));
        (0, dom_1.awaitRedraw)()
            .then(function () {
            if (exportStyles === true) {
                styles = "".concat((0, html_1.getPageLinksCss)(), "<style>").concat((0, html_1.getPageInlineCss)(), "</style>");
            }
            else if (Array.isArray(exportStyles) && exportStyles.length) {
                styles = "".concat((0, html_1.getPageLinksCss)(exportStyles));
            }
            var child = viewContainer.children[0];
            child === null || child === void 0 ? void 0 : child.setAttribute("data-dhx-theme", config.theme || "light");
            if (mode === "png") {
                child === null || child === void 0 ? void 0 : child.setAttribute("style", "width: ".concat(width, "px;"));
            }
            var html = "\n\t\t\t\t\t".concat(styles, "\n\t\t\t\t\t").concat(viewContainer.innerHTML, "\n\t\t\t\t");
            var form = document.createElement("form");
            form.setAttribute("method", "POST");
            form.setAttribute("action", config.url);
            form.innerHTML = "<input type=\"hidden\" name=\"raw\"><input type=\"hidden\" name=\"config\">";
            form.childNodes[0].value = html;
            form.childNodes[1].value = JSON.stringify(config);
            document.body.appendChild(form);
            form.submit();
            setTimeout(function () {
                var _a, _b;
                $view.destructor();
                (_a = viewContainer.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(viewContainer);
                (_b = form.parentNode) === null || _b === void 0 ? void 0 : _b.removeChild(form);
            }, 100);
        })
            .catch(function () {
            var _a;
            $view.destructor();
            (_a = viewContainer.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(viewContainer);
        });
    };
    return Exporter;
}());
exports.Exporter = Exporter;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.message = void 0;
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(3);
var types_1 = __webpack_require__(42);
var nodeTimeout = new WeakMap();
var containers = new Map();
function createMessageContainer(parent, position) {
    var messageContainer = document.createElement("div");
    messageContainer.setAttribute("data-position", position);
    messageContainer.className =
        "dhx_message-container " +
            "dhx_message-container--" +
            position +
            (parent === document.body ? " dhx_message-container--in-body" : "");
    return messageContainer;
}
function onExpire(node, fromClick) {
    if (fromClick) {
        clearTimeout(nodeTimeout.get(node));
    }
    var container = node.parentNode;
    var position = container.getAttribute("data-position");
    var parent = container.parentNode;
    var messageContainerInfo = containers.get(parent);
    if (!messageContainerInfo) {
        return;
    }
    var positionInfo = messageContainerInfo[position];
    if (!positionInfo) {
        return;
    }
    var stack = positionInfo.stack;
    var index = stack.indexOf(node);
    if (index !== -1) {
        container.removeChild(node);
        stack.splice(index, 1);
        if (stack.length === 0) {
            parent.removeChild(container);
        }
        return;
    }
}
function message(props) {
    var _a;
    if (typeof props === "string") {
        props = { text: props };
    }
    props.position = props.position || types_1.MessageContainerPosition.topRight;
    var messageBox = document.createElement("div");
    messageBox.className = "dhx_widget dhx_message " + (props.css || "");
    messageBox.setAttribute("role", "alert");
    var textId = props.text && (0, core_1.uid)();
    textId && messageBox.setAttribute("aria-describedby", textId);
    if (props.html) {
        messageBox.innerHTML = props.html;
    }
    else {
        messageBox.innerHTML = "<span class=\"dhx_message__text\" id=".concat(textId, "></span>\n\t\t").concat(props.icon ? "<span class=\"dhx_message__icon dxi ".concat(props.icon, "\"></span>") : "");
        messageBox.querySelector("#".concat(textId)).textContent = props.text;
    }
    var parent = props.node ? (0, html_1.toNode)(props.node) : document.body;
    var position = getComputedStyle(parent).position;
    if (position === "static") {
        parent.style.position = "relative";
    }
    var messageContainerInfo = containers.get(parent);
    if (!messageContainerInfo) {
        containers.set(parent, (_a = {},
            _a[props.position] = {
                stack: [],
                container: createMessageContainer(parent, props.position),
            },
            _a));
    }
    else if (!messageContainerInfo[props.position]) {
        messageContainerInfo[props.position] = {
            stack: [],
            container: createMessageContainer(parent, props.position),
        };
    }
    var _b = containers.get(parent)[props.position], stack = _b.stack, container = _b.container;
    if (stack.length === 0) {
        parent.appendChild(container);
    }
    stack.push(messageBox);
    container.appendChild(messageBox);
    function closeMessage(fromClick) {
        if (fromClick === void 0) { fromClick = true; }
        if (!messageBox)
            return;
        onExpire(messageBox, fromClick);
        messageBox = null;
    }
    if (props.expire) {
        var timeout = setTimeout(function () { return closeMessage(false); }, props.expire);
        nodeTimeout.set(messageBox, timeout);
    }
    messageBox.onclick = function () { return closeMessage(); };
    return {
        close: function () { return closeMessage(); },
    };
}
exports.message = message;


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.alert = void 0;
var en_1 = __webpack_require__(43);
var common_1 = __webpack_require__(66);
var core_1 = __webpack_require__(1);
function alert(props) {
    var apply = props.buttons && props.buttons[0] ? props.buttons[0] : en_1.default.apply;
    var unblock = (0, common_1.blockScreen)(props.blockerCss);
    return new Promise(function (res) {
        var contentId = "dhx_alert__".concat((0, core_1.uid)(), "_content");
        var headerId = "dhx_alert__".concat((0, core_1.uid)(), "_header");
        var alertBox = document.createElement("div");
        alertBox.setAttribute("role", "alert");
        alertBox.setAttribute("aria-modal", "true");
        props.text && alertBox.setAttribute("aria-describedby", contentId);
        props.header && alertBox.setAttribute("aria-labelledby", headerId);
        alertBox.className = "dhx_widget dhx_alert " + (props.css || "");
        var closeAlert = function (e) {
            if (e.key === "Escape" || e.key === "Esc") {
                // eslint-disable-next-line @typescript-eslint/no-use-before-define
                close(e);
                res(false);
            }
        };
        function close(e) {
            e.preventDefault();
            unblock();
            document.body.removeChild(alertBox);
            document.removeEventListener("keydown", closeAlert);
        }
        alertBox.innerHTML = "\n\t\t\t".concat(props.header
            ? "<div id=".concat(headerId, " class=\"dhx_alert__header\"> ").concat(props.htmlEnable !== false ? props.header : "", " </div>")
            : "", "\n\t\t\t").concat(props.text
            ? "<div id=".concat(contentId, " class=\"dhx_alert__content\">").concat(props.htmlEnable !== false ? props.text : "", "</div>")
            : "", "\n\t\t\t<div class=\"dhx_alert__footer ").concat(props.buttonsAlignment ? "dhx_alert__footer--" + props.buttonsAlignment : "", "\">\n\t\t\t\t<button type=\"button\" aria-label=\"confirm\" class=\"dhx_alert__apply-button dhx_button dhx_button--view_flat dhx_button--color_primary dhx_button--size_medium\">").concat(apply, "</button>\n\t\t\t</div>");
        if (props.htmlEnable === false) {
            props.header && (alertBox.querySelector("#".concat(headerId)).textContent = props.header);
            props.text && (alertBox.querySelector("#".concat(contentId)).textContent = props.text);
        }
        document.body.appendChild(alertBox);
        alertBox.querySelector(".dhx_alert__apply-button").focus();
        alertBox.querySelector("button").addEventListener("click", function (e) {
            close(e);
            res(true);
        });
        document.addEventListener("keydown", closeAlert);
    });
}
exports.alert = alert;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.confirm = void 0;
var en_1 = __webpack_require__(43);
var common_1 = __webpack_require__(66);
var core_1 = __webpack_require__(1);
function confirm(props) {
    props.buttonsAlignment = props.buttonsAlignment || "right";
    var apply = props.buttons && props.buttons[1] ? props.buttons[1] : en_1.default.apply;
    var reject = props.buttons && props.buttons[0] ? props.buttons[0] : en_1.default.reject;
    var unblock = (0, common_1.blockScreen)("dhx_alert__overlay-confirm " + (props.blockerCss || ""));
    return new Promise(function (res) {
        var confirmBox = document.createElement("div");
        confirmBox.setAttribute("role", "alertdialog");
        confirmBox.setAttribute("aria-modal", "true");
        var headerId = props.header && (0, core_1.uid)();
        var textId = props.header && (0, core_1.uid)();
        textId && confirmBox.setAttribute("aria-describedby", textId);
        headerId && confirmBox.setAttribute("aria-labelledby", headerId);
        var focusItem;
        var answer = function (val) {
            unblock();
            // eslint-disable-next-line @typescript-eslint/no-use-before-define
            confirmBox.removeEventListener("click", clickHandler);
            // eslint-disable-next-line @typescript-eslint/no-use-before-define
            document.removeEventListener("keydown", closeConfirm);
            document.body.removeChild(confirmBox);
            res(val);
        };
        var clickHandler = function (e) {
            if (e.target.tagName === "BUTTON") {
                answer(e.target.classList.contains("dhx_alert__confirm-aply"));
            }
        };
        var closeConfirm = function (e) {
            if (e.key === "Escape" || e.key === "Esc") {
                confirmBox.querySelector(".dhx_alert__confirm-aply").focus();
                answer(e.target.classList.contains("dhx_alert__confirm-reject"));
            }
            else if (e.key === "Tab") {
                if (focusItem === "aply") {
                    focusItem = "reject";
                    confirmBox.querySelector(".dhx_alert__confirm-reject").focus();
                }
                else {
                    focusItem = "aply";
                    confirmBox.querySelector(".dhx_alert__confirm-aply").focus();
                }
                e.preventDefault();
            }
        };
        confirmBox.className = "dhx_widget dhx_alert dhx_alert--confirm" + (props.css ? " " + props.css : "");
        confirmBox.innerHTML = "\n\t\t".concat(props.header
            ? "<div class=\"dhx_alert__header\" id=".concat(headerId, "> ").concat(props.htmlEnable !== false ? props.header : "", " </div>")
            : "", "\n\t\t").concat(props.text
            ? "<div class=\"dhx_alert__content\" id=".concat(textId, ">").concat(props.htmlEnable !== false ? props.text : "", "</div>")
            : "", "\n\t\t\t<div class=\"dhx_alert__footer ").concat(props.buttonsAlignment ? "dhx_alert__footer--" + props.buttonsAlignment : "", "\">\n\t\t\t\t<button type=\"button\" aria-label=\"reject\" class=\"dhx_alert__confirm-reject dhx_button dhx_button--view_link dhx_button--color_primary dhx_button--size_medium\">").concat(reject, "</button>\n\t\t\t\t<button type=\"button\"  aria-label=\"aply\"class=\"dhx_alert__confirm-aply dhx_button dhx_button--view_flat dhx_button--color_primary dhx_button--size_medium\">").concat(apply, "</button>\n\t\t\t</div>");
        if (props.htmlEnable === false) {
            props.header && (confirmBox.querySelector("#".concat(headerId)).textContent = props.header);
            props.text && (confirmBox.querySelector("#".concat(textId)).textContent = props.text);
        }
        document.body.appendChild(confirmBox);
        focusItem = "aply";
        confirmBox.querySelector(".dhx_alert__confirm-aply").focus();
        confirmBox.addEventListener("click", clickHandler);
        document.addEventListener("keydown", closeConfirm);
    });
}
exports.confirm = confirm;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(17)))

/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __spr