#
# DATABRICKS CONFIDENTIAL & PROPRIETARY
# __________________
#
# Copyright 2023-present Databricks, Inc.
# All Rights Reserved.
#
# NOTICE:  All information contained herein is, and remains the property of Databricks, Inc.
# and its suppliers, if any.  The intellectual and technical concepts contained herein are
# proprietary to Databricks, Inc. and its suppliers and may be covered by U.S. and foreign Patents,
# patents in process, and are protected by trade secret and/or copyright law. Dissemination, use,
# or reproduction of this information is strictly forbidden unless prior written permission is
# obtained from Databricks, Inc.
#
# If you view or obtain a copy of this information and believe Databricks, Inc. may not have
# intended it to be made available, please promptly report it to Databricks Legal Department
# @ legal@databricks.com.
#
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

DATABRICKS CONFIDENTIAL & PROPRIETARY
__________________

Copyright 2023-present Databricks, Inc.
All Rights Reserved.

NOTICE:  All information contained herein is, and remains the property of Databricks, Inc.
and its suppliers, if any.  The intellectual and technical concepts contained herein are
proprietary to Databricks, Inc. and its suppliers and may be covered by U.S. and foreign Patents,
patents in process, and are protected by trade secret and/or copyright law. Dissemination, use,
or reproduction of this information is strictly forbidden unless prior written permission is
obtained from Databricks, Inc.

If you view or obtain a copy of this information and believe Databricks, Inc. may not have
intended it to be made available, please promptly report it to Databricks Legal Department
@ legal@databricks.com.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class ResultOptions(google.protobuf.message.Message):
    """Options to specify how results are returned from an ExecutePlanRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ResultOptions._Type.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: ResultOptions._Type.ValueType  # 0
        """default to INLINE"""
        TYPE_INLINE: ResultOptions._Type.ValueType  # 1
        """returns the result inline in the response"""
        TYPE_CLOUD: ResultOptions._Type.ValueType  # 2
        """returns the result as a batch of URLs uploaded to the cloud"""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: ResultOptions.Type.ValueType  # 0
    """default to INLINE"""
    TYPE_INLINE: ResultOptions.Type.ValueType  # 1
    """returns the result inline in the response"""
    TYPE_CLOUD: ResultOptions.Type.ValueType  # 2
    """returns the result as a batch of URLs uploaded to the cloud"""

    class CloudOptions(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Format:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _FormatEnumTypeWrapper(
            google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
                ResultOptions.CloudOptions._Format.ValueType
            ],
            builtins.type,
        ):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            FORMAT_UNSPECIFIED: ResultOptions.CloudOptions._Format.ValueType  # 0
            FORMAT_ARROW: ResultOptions.CloudOptions._Format.ValueType  # 1
            FORMAT_CSV: ResultOptions.CloudOptions._Format.ValueType  # 2
            FORMAT_JSON: ResultOptions.CloudOptions._Format.ValueType  # 3

        class Format(_Format, metaclass=_FormatEnumTypeWrapper): ...
        FORMAT_UNSPECIFIED: ResultOptions.CloudOptions.Format.ValueType  # 0
        FORMAT_ARROW: ResultOptions.CloudOptions.Format.ValueType  # 1
        FORMAT_CSV: ResultOptions.CloudOptions.Format.ValueType  # 2
        FORMAT_JSON: ResultOptions.CloudOptions.Format.ValueType  # 3

        FORMAT_FIELD_NUMBER: builtins.int
        USECOMPRESSION_FIELD_NUMBER: builtins.int
        ROW_LIMIT_FIELD_NUMBER: builtins.int
        BYTE_LIMIT_FIELD_NUMBER: builtins.int
        RESULT_RETENTION_SECONDS_FIELD_NUMBER: builtins.int
        format: global___ResultOptions.CloudOptions.Format.ValueType
        """Arrow format will be used when unspecified"""
        useCompression: builtins.bool
        """Not all formats support compression, the default is to use compression when supported."""
        row_limit: builtins.int
        """Row and byte limits, strictly enforced."""
        byte_limit: builtins.int
        result_retention_seconds: builtins.int
        """How long we store the results in CloudFetch before deleting them.
        Named same as sql/core/src/main/scala/com/databricks/sql/execution/QueryResultFormat.scala
        """
        def __init__(
            self,
            *,
            format: global___ResultOptions.CloudOptions.Format.ValueType = ...,
            useCompression: builtins.bool | None = ...,
            row_limit: builtins.int | None = ...,
            byte_limit: builtins.int | None = ...,
            result_retention_seconds: builtins.int | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_byte_limit",
                b"_byte_limit",
                "_result_retention_seconds",
                b"_result_retention_seconds",
                "_row_limit",
                b"_row_limit",
                "_useCompression",
                b"_useCompression",
                "byte_limit",
                b"byte_limit",
                "result_retention_seconds",
                b"result_retention_seconds",
                "row_limit",
                b"row_limit",
                "useCompression",
                b"useCompression",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_byte_limit",
                b"_byte_limit",
                "_result_retention_seconds",
                b"_result_retention_seconds",
                "_row_limit",
                b"_row_limit",
                "_useCompression",
                b"_useCompression",
                "byte_limit",
                b"byte_limit",
                "format",
                b"format",
                "result_retention_seconds",
                b"result_retention_seconds",
                "row_limit",
                b"row_limit",
                "useCompression",
                b"useCompression",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_byte_limit", b"_byte_limit"]
        ) -> typing_extensions.Literal["byte_limit"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal[
                "_result_retention_seconds", b"_result_retention_seconds"
            ],
        ) -> typing_extensions.Literal["result_retention_seconds"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_row_limit", b"_row_limit"]
        ) -> typing_extensions.Literal["row_limit"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_useCompression", b"_useCompression"]
        ) -> typing_extensions.Literal["useCompression"] | None: ...

    TYPE_FIELD_NUMBER: builtins.int
    CLOUDOPTIONS_FIELD_NUMBER: builtins.int
    type: global___ResultOptions.Type.ValueType
    """optional; the type of the result, whether it should be inline or URLs to results."""
    @property
    def cloudOptions(self) -> global___ResultOptions.CloudOptions:
        """Required when using TYPE_CLOUD"""
    def __init__(
        self,
        *,
        type: global___ResultOptions.Type.ValueType = ...,
        cloudOptions: global___ResultOptions.CloudOptions | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_cloudOptions", b"_cloudOptions", "cloudOptions", b"cloudOptions"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_cloudOptions", b"_cloudOptions", "cloudOptions", b"cloudOptions", "type", b"type"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_cloudOptions", b"_cloudOptions"]
    ) -> typing_extensions.Literal["cloudOptions"] | None: ...

global___ResultOptions = ResultOptions

class CloudResultBatch(google.protobuf.message.Message):
    """Query result batch stored in a remote URL"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Result(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        ROW_COUNT_FIELD_NUMBER: builtins.int
        COMPRESSED_SIZE_FIELD_NUMBER: builtins.int
        UNCOMPRESSED_SIZE_FIELD_NUMBER: builtins.int
        SECRET_FILE_PATH_FIELD_NUMBER: builtins.int
        url: builtins.str
        """The URL to the result"""
        row_count: builtins.int
        """The number of rows in the result"""
        compressed_size: builtins.int
        """The size of the results after compression, in bytes"""
        uncompressed_size: builtins.int
        """The size of the results before compression, in bytes
        bytes
        """
        secret_file_path: builtins.str
        """The secret file path to the result"""
        def __init__(
            self,
            *,
            url: builtins.str = ...,
            row_count: builtins.int = ...,
            compressed_size: builtins.int = ...,
            uncompressed_size: builtins.int = ...,
            secret_file_path: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "compressed_size",
                b"compressed_size",
                "row_count",
                b"row_count",
                "secret_file_path",
                b"secret_file_path",
                "uncompressed_size",
                b"uncompressed_size",
                "url",
                b"url",
            ],
        ) -> None: ...

    RESULTS_FIELD_NUMBER: builtins.int
    TRUNCATED_FIELD_NUMBER: builtins.int
    @property
    def results(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___CloudResultBatch.Result
    ]:
        """The batch of results that are stored in a remote cloud URL"""
    truncated: builtins.bool
    """truncated by row_limit or byte_limit"""
    def __init__(
        self,
        *,
        results: collections.abc.Iterable[global___CloudResultBatch.Result] | None = ...,
        truncated: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["results", b"results", "truncated", b"truncated"],
    ) -> None: ...

global___CloudResultBatch = CloudResultBatch

class SubscribeToLiveQuery(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_ID_FIELD_NUMBER: builtins.int
    operation_id: builtins.str
    """UUID value from ExecutePlanResponse.operation_id"""
    def __init__(
        self,
        *,
        operation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["operation_id", b"operation_id"]
    ) -> None: ...

global___SubscribeToLiveQuery = SubscribeToLiveQuery
