import codepipeline = require('@aws-cdk/aws-codepipeline-api');
import cdk = require('@aws-cdk/cdk');
import { IBucket } from './bucket';
/**
 * Common properties for creating {@link PipelineSourceAction} -
 * either directly, through its constructor,
 * or through {@link IBucket#toCodePipelineSourceAction}.
 */
export interface CommonPipelineSourceActionProps extends codepipeline.CommonActionProps {
    /**
     * The name of the source's output artifact. CfnOutput artifacts are used by CodePipeline as
     * inputs into other actions.
     *
     * @default a name will be auto-generated
     */
    readonly outputArtifactName?: string;
    /**
     * The key within the S3 bucket that stores the source code.
     *
     * @example 'path/to/file.zip'
     */
    readonly bucketKey: string;
    /**
     * Whether AWS CodePipeline should poll for source changes.
     * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
     * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
     * as otherwise the CloudWatch Events will not be emitted.
     *
     * @default true
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
     */
    readonly pollForSourceChanges?: boolean;
}
/**
 * Construction properties of the {@link PipelineSourceAction S3 source Action}.
 */
export interface PipelineSourceActionProps extends CommonPipelineSourceActionProps {
    /**
     * The Amazon S3 bucket that stores the source code
     */
    readonly bucket: IBucket;
}
/**
 * Source that is provided by a specific Amazon S3 object.
 */
export declare class PipelineSourceAction extends codepipeline.SourceAction {
    private readonly props;
    constructor(props: PipelineSourceActionProps);
    protected bind(stage: codepipeline.IStage, _scope: cdk.Construct): void;
}
/**
 * Common properties for creating {@link PipelineDeployAction} -
 * either directly, through its constructor,
 * or through {@link IBucket#toCodePipelineDeployAction}.
 */
export interface CommonPipelineDeployActionProps extends codepipeline.CommonActionProps {
    /**
     * Should the deploy action extract the artifact before deploying to Amazon S3.
     *
     * @default true
     */
    readonly extract?: boolean;
    /**
     * The key of the target object. This is required if extract is false.
     */
    readonly objectKey?: string;
    /**
     * The inputArtifact to deploy to Amazon S3.
     */
    readonly inputArtifact: codepipeline.Artifact;
}
/**
 * Construction properties of the {@link PipelineDeployAction S3 deploy Action}.
 */
export interface PipelineDeployActionProps extends CommonPipelineDeployActionProps {
    /**
     * The Amazon S3 bucket that is the deploy target.
     */
    readonly bucket: IBucket;
}
/**
 * Deploys the sourceArtifact to Amazon S3.
 */
export declare class PipelineDeployAction extends codepipeline.DeployAction {
    private readonly bucket;
    constructor(props: PipelineDeployActionProps);
    protected bind(stage: codepipeline.IStage, _scope: cdk.Construct): void;
}
