"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("@aws-cdk/aws-codepipeline-api");
/**
 * Source that is provided by a specific Amazon S3 object.
 */
class PipelineSourceAction extends codepipeline.SourceAction {
    constructor(props) {
        super(Object.assign({}, props, { provider: 'S3', outputArtifactName: props.outputArtifactName || `Artifact_${props.actionName}_${props.bucket.node.uniqueId}`, configuration: {
                S3Bucket: props.bucket.bucketName,
                S3ObjectKey: props.bucketKey,
                PollForSourceChanges: props.pollForSourceChanges,
            } }));
        this.props = props;
    }
    bind(stage, _scope) {
        if (this.props.pollForSourceChanges === false) {
            this.props.bucket.onPutObject(stage.pipeline.node.uniqueId + 'SourceEventRule', stage.pipeline, this.props.bucketKey);
        }
        // pipeline needs permissions to read from the S3 bucket
        this.props.bucket.grantRead(stage.pipeline.role);
    }
}
exports.PipelineSourceAction = PipelineSourceAction;
/**
 * Deploys the sourceArtifact to Amazon S3.
 */
class PipelineDeployAction extends codepipeline.DeployAction {
    constructor(props) {
        super(Object.assign({}, props, { provider: 'S3', artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            }, configuration: {
                BucketName: props.bucket.bucketName,
                Extract: (props.extract === false) ? 'false' : 'true',
                ObjectKey: props.objectKey,
            } }));
        this.bucket = props.bucket;
    }
    bind(stage, _scope) {
        // pipeline needs permissions to write to the S3 bucket
        this.bucket.grantWrite(stage.pipeline.role);
    }
}
exports.PipelineDeployAction = PipelineDeployAction;
//# sourceMappingURL=data:application/json;base64,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