"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .callbackresponse import CallbackResponse, CallbackResponseTypedDict
from .transcriptitem import TranscriptItem, TranscriptItemTypedDict
from fathom_python.types import BaseModel
from fathom_python.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import List, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class GetRecordingTranscriptRequestTypedDict(TypedDict):
    recording_id: int
    r"""The ID of the meeting recording to fetch the transcript for."""
    destination_url: str
    r"""Destination URL for where we'll POST the transcript. If not sent, this endpoint will return the data directly."""


class GetRecordingTranscriptRequest(BaseModel):
    recording_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the meeting recording to fetch the transcript for."""

    destination_url: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""Destination URL for where we'll POST the transcript. If not sent, this endpoint will return the data directly."""


class GetRecordingTranscriptResponseBodyTypedDict(TypedDict):
    transcript: List[TranscriptItemTypedDict]


class GetRecordingTranscriptResponseBody(BaseModel):
    transcript: List[TranscriptItem]


GetRecordingTranscriptResponseTypedDict = TypeAliasType(
    "GetRecordingTranscriptResponseTypedDict",
    Union[GetRecordingTranscriptResponseBodyTypedDict, CallbackResponseTypedDict],
)
r"""Either the destination URL for where we'll POST the transcript, or the transcript for the recording as an array."""


GetRecordingTranscriptResponse = TypeAliasType(
    "GetRecordingTranscriptResponse",
    Union[GetRecordingTranscriptResponseBody, CallbackResponse],
)
r"""Either the destination URL for where we'll POST the transcript, or the transcript for the recording as an array."""
