#
# Copyright (c) 2016 MasterCard International Incorporated
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are
# permitted provided that the following conditions are met:
#
# Redistributions of source code must retain the above copyright notice, this list of
# conditions and the following disclaimer.
# Redistributions in binary form must reproduce the above copyright notice, this list of
# conditions and the following disclaimer in the documentation and/or other materials
# provided with the distribution.
# Neither the name of the MasterCard International Incorporated nor the names of its
# contributors may be used to endorse or promote products derived from this software
# without specific prior written permission.
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
# SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#


from mastercardapicore import BaseObject, RequestMap


class Subscription(BaseObject):
    """
    
    """

    def getResourcePath(self,action):
        """
        Returns the resource path based on the action
        @return str
        """
        action = action.upper()
        
        if action == "QUERY":
            return "/spendingpulse/v1/spulse.svc/subscription"
        
        raise Exception("Invalid action supplied: "+ action)


    def getHeaderParams(self,action):
        """
        Returns a list containing header params
        @return list
        """
        action = action.upper()
        
        if action == "QUERY":
            return []
        
        raise Exception("Invalid action supplied: "+ action)


    def getQueryParams(self,action):
        """
        Returns a list containing query params
        @return list
        """
        action = action.upper()
        
        if action == "QUERY":
            return ["CurrentRow","Offset"]
        
        raise Exception("Invalid action supplied: "+ action)


    @classmethod
    def getApiVersion(cls):
        return "0.0.1"






    @classmethod
    def query(cls,criteria):
        """
        Query objects of type Subscription by id and optional criteria
        @param type criteria
        @return Subscription object representing the response.
        """

        return super(Subscription,cls).queryObject(Subscription(criteria))



