"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerConfigSecret = exports.TlsSecret = exports.ServiceAccountTokenSecret = exports.SshAuthSecret = exports.BasicAuthSecret = exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
class ImportedSecret extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this.resourceType = 'secrets';
        this._name = name;
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubeSecret.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubeSecret.GVK.kind;
    }
    get resourceName() {
        return this.name;
    }
}
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'secrets';
        this.stringData = props.stringData ?? {};
        this.immutable = props.immutable ?? false;
        this.apiObject = new k8s.KubeSecret(this, 'Resource', {
            metadata: props.metadata,
            type: props.type,
            stringData: this.stringData,
            immutable: this.immutable,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     */
    static fromSecretName(scope, id, name) {
        return new ImportedSecret(scope, id, name);
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "cdk8s-plus-23.Secret", version: "2.2.5" };
/**
 * Create a secret for basic authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
 */
class BasicAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/basic-auth',
            stringData: {
                username: props.username,
                password: props.password,
            },
            immutable: props.immutable,
        });
    }
}
exports.BasicAuthSecret = BasicAuthSecret;
_b = JSII_RTTI_SYMBOL_1;
BasicAuthSecret[_b] = { fqn: "cdk8s-plus-23.BasicAuthSecret", version: "2.2.5" };
/**
 * Create a secret for ssh authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
 */
class SshAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/ssh-auth',
            stringData: {
                'ssh-privatekey': props.sshPrivateKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.SshAuthSecret = SshAuthSecret;
_c = JSII_RTTI_SYMBOL_1;
SshAuthSecret[_c] = { fqn: "cdk8s-plus-23.SshAuthSecret", version: "2.2.5" };
/**
 * Create a secret for a service account token.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
 */
class ServiceAccountTokenSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/service-account-token',
            metadata: {
                annotations: {
                    'kubernetes.io/service-account.name': props.serviceAccount.name,
                },
            },
            immutable: props.immutable,
        });
    }
}
exports.ServiceAccountTokenSecret = ServiceAccountTokenSecret;
_d = JSII_RTTI_SYMBOL_1;
ServiceAccountTokenSecret[_d] = { fqn: "cdk8s-plus-23.ServiceAccountTokenSecret", version: "2.2.5" };
/**
 * Create a secret for storing a TLS certificate and its associated key.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
 */
class TlsSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/tls',
            stringData: {
                'tls.crt': props.tlsCert,
                'tls.key': props.tlsKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.TlsSecret = TlsSecret;
_e = JSII_RTTI_SYMBOL_1;
TlsSecret[_e] = { fqn: "cdk8s-plus-23.TlsSecret", version: "2.2.5" };
/**
 * Create a secret for storing credentials for accessing a container image
 * registry.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
 */
class DockerConfigSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/dockerconfigjson',
            stringData: {
                '.dockerconfigjson': JSON.stringify(props.data),
            },
            immutable: props.immutable,
        });
    }
}
exports.DockerConfigSecret = DockerConfigSecret;
_f = JSII_RTTI_SYMBOL_1;
DockerConfigSecret[_f] = { fqn: "cdk8s-plus-23.DockerConfigSecret", version: "2.2.5" };
//# sourceMappingURL=data:application/json;base64,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