# media-killer
version=0.1.7

media-killer 可以通过配置文件操纵 ffmpeg 批量地对大量媒体文件转码。

>media-killer 并不能作为 ffmpeg 的替代。

和直接使用 ffmpeg 相比， media-killer 有如下优缺点：

- 可以进行大量视频批量处理
- 使用**可复用的配置文件**进行操作管理
- 每个转码任务**仅支持**单个文件输入和单个目标输出
- 可以通过指定文件夹作为源文件的方式来批量添加任务
- 可以根据源文件路径保留指定层级的上层目录结构
- 可以读取 xml、fcpxml、csv等文件中提供的源文件信息
- 拥有漂亮的进度监控和提示信息
- 无法指定输出的文件名（但可以指定扩展名）

#### 配置文件

media-killer 使用 toml 配置文件描述工作内容。

使用配置文件可以方便地复用设置，
你可以保存多个不同的配置文件，并在将来对不同的视频文件进行同样的操作；
或者是在源文件修改后，一键重新运行转码任务，以快速更新目标文件。

使用 `--generate` 选项生成一个示例文件：

```shell
media-killer '文件名.toml' --generate
# 或
media-killer '文件名.toml' -g
```

在示例文件中包含所有选项的说明。

#### 执行任务

不加任何选项地，指定配置文件，即可执行任务。

```shell
media-killer '文件名.toml'
```

#### 来源文件设置

一种可能的情况是，配置文件中仅仅制定了转码选项和目标位置。
这种情况下可以使用 `--add-source` 添加源文件，
这种情况下增加的源文件会附加在配置文件中指定的源文件列表之后。

例如，在配置文件 `example.toml` 中有如下设置：

```toml
[input]
files = ['a.mov', 'b.mov', 'c.mov']
```

那么运行下面的命令之后——

```shell
media-killer 'example.toml' --add-source 'one.mp4' -a 'two.mp4'
# -a 是 --add-source 的缩写
```

—— media-killer 将会处理全部 5 个目标文件。

所以，如果不在配置文件中制定源文件可以最大程度重复使用它们。

#### 来源文件的解析

在使用来源文件之前将会进行一系列处理：

1. 遍历每一个`input.file`：
    - 若：文件扩展名是被支持的**列表文件**,
      则：读取其中包含的片段信息，并将它们添加到`源文件列表`
    - 若：不是列表文件，则：直接添加到`源文件列表`
2. 初始化`扩展名列表`，
   将`配置文件`中的`input.suffix_includes`添加到`扩展名列表`，
   将`配置文件`中的`input.suffix_excludes`中包含的项目从`扩展名列表`中移除
3. 遍历`源文件列表`，并将所有的文件夹递归地展开，
   并将扩展名符合`扩展名列表`的文件添加到`源文件列表`
4. 根据路径排序`源文件列表`
5. 检查`源文件列表`，去除重复的或不存在的文件

之后才会根据`配置文件`的设置，依次处理来源文件。

#### 相对路径

在配置文件中，所有的文件都可以使用相对路径指定，
但是相对路径并非相对于当前的工作目录的，
而是相对于`general.working_folder`所设定的目录，
此目录默认为配置文件所在的目录。

```toml
[general]
working_folder = '.'
```

这允许使用拷贝配置文件，并将它 "make" 为目标文件的使用逻辑成为可能。

#### 生成 shell 脚本

如果制定了`--make-script`选项，
media-killer 不会自动转码，而是会生成一个脚本文件。
当然，**必须指定脚本文件的保存位置**。

```shell
media-killer 'example.toml' -s 'script.sh'
# -s 是 --make-script 的缩写
```

生成的脚本文件仅仅是普通的文本文件而已，**不包含 shebang**，
所以运行时你需要自己指定使用的 shell：

```shell
media-killer 'example.toml' --make-script 'script.ps1'
pwsh 'script.ps1'
```

