# subconv

subconv 用于批量转换字幕文件为台词本文档，
附加地，也可以转换成其它格式的字幕文件，但不保证完整性。

>subconv 不能当做一个完备的字幕文件转换器

subconv 有以下特点：
- 可以批量地对文件进行处理，可以自动展开文件夹
- 目标文件自动防止在源文件旁边，最大化减少参数指定
- 也可以手动指定集中的输出文件夹
- 支持 srt、ttml 等多种字幕文件读取
- 输出台词本可以选择是否需要添加时间信息
- 内置一个简单的字幕内容检查器，将会自动进行简单的格式化处理
- 可以输出字幕为表格( csv 或 xlsx )，以兼容其它工作流

#### 基本使用

直接在命令之后紧接源文件列表即可：

```shell
sub_conv '字幕1.srt' '字幕2.ttml'
```

以上命令将会在这两个字幕旁边生成同名的 'txt' 文件，
其内容为提取的台词，每条一行。

#### 高级用法

##### 文件夹输入

如果输入的来源是一个文件夹，则会自动展开其中所有的文件夹，
并将扩展名符合要求的文件列为输入文件。例如：

```shell
sub_conv 'D:/给你的在这里/' '魔法小子第一季字幕'
```

上面的命令中指定的两个输入源都是文件夹，
其中的字幕文件都会被添加。

##### 指定输出位置

使用 `--output-folder` 参数可以指定输出位置，
输出的文件都会添加到这里。

```shell
sub_conv '字幕1.srt' '字幕文件夹/' --output-folder '目标文件假/'
# -o 是 --output-folder 的缩写
sub_conv '字幕1.srt' '字幕文件夹/' -o '目标文件假/'
```

##### 指定输出格式

默认情况下输出的目标文件是 utf-8 编码的 txt 文本文件，
可以使用 `--format` 参数设置输出格式, `--encoding` 用于设置编码。

```shell
sub_conv '字幕.ttml' --format word 
sub_conv '字幕.srt' -f csv --encoding 'gb18030'
sub_conv '字幕.srt' -c 'utf-16'
# -f 是 --format 的缩写
# -c 是 --encoding 的缩写
```

具体支持的输出格式，可以用`--help`参数打印帮助信息查看

##### 关于自动格式化器

subconv 内置了一个简单的格式化器，默认启用。它将会对字幕内容进行这些检查：
- 自动去除字幕文件中携带的格式化标签（Davinci Resolve 输出的字幕通常都有）
- 自动删除开头结尾的空格或回车
- 自动缩减连续的多个空格或引号
- 自动将；连续的多个回车合并为一个

如果不希望进行这些处理，可以使用 `--bypass-formatter` 参数禁用它。

##### 测试运行
指定 `--dry-run` 参数可以启用干转模式，
subconv 将会处理所有的内容，但是不会真的输出文件。

也可以使用 `--debug` 参数，将会输出所有工作过程的信息，方便查看。

两个选项可以一起使用。