"""
This type stub file was generated by pyright.
"""

import typing as t
import yaml
from connexion.middleware.main import API

"""
This module provides general utility functions used within Connexion.
"""
if t.TYPE_CHECKING:
    ...
def boolean(s): # -> bool:
    """
    Convert JSON/Swagger boolean value to Python, raise ValueError otherwise

    >>> boolean('true')
    True

    >>> boolean('false')
    False
    """
    ...

TYPE_MAP: t.Dict[str, t.Any] = ...
def make_type(value: t.Any, type_: str, format_: t.Optional[str]) -> t.Any:
    """Cast a value to the type defined in the specification."""
    ...

def deep_merge(a, b):
    """merges b into a
    in case of conflict the value from b is used
    """
    ...

def deep_getattr(obj, attr): # -> Any:
    """
    Recurses through an attribute chain to get the ultimate value.
    """
    ...

def deep_get(obj, keys):
    """
    Recurses through a nested object get a leaf value.

    There are cases where the use of inheritance or polymorphism-- the use of allOf or
    oneOf keywords-- will cause the obj to be a list. In this case the keys will
    contain one or more strings containing integers.

    :type obj: list or dict
    :type keys: list of strings
    """
    ...

def get_function_from_name(function_name): # -> Any:
    """
    Tries to get function by fully qualified name (e.g. "mymodule.myobj.myfunc")

    :type function_name: str
    """
    ...

def is_json_mimetype(mimetype): # -> Literal[False]:
    """
    :type mimetype: str
    :rtype: bool
    """
    ...

def all_json(mimetypes): # -> bool:
    """
    Returns True if all mimetypes are serialized with json

    :type mimetypes: list
    :rtype: bool

    >>> all_json(['application/json'])
    True
    >>> all_json(['application/x.custom+json'])
    True
    >>> all_json([])
    True
    >>> all_json(['application/xml'])
    False
    >>> all_json(['text/json'])
    False
    >>> all_json(['application/json', 'other/type'])
    False
    >>> all_json(['application/json', 'application/x.custom+json'])
    True
    """
    ...

def is_nullable(param_def):
    ...

def is_null(value): # -> bool:
    ...

def has_coroutine(function, api=...): # -> bool:
    """
    Checks if function is a coroutine.
    If ``function`` is a decorator (has a ``__wrapped__`` attribute)
    this function will also look at the wrapped function.
    """
    ...

def yamldumper(openapi): # -> str:
    """
    Returns a nicely-formatted yaml spec.
    :param openapi: a spec dictionary.
    :return: a nicely-formatted, serialized yaml spec.
    """
    class NoAnchorDumper(yaml.dumper.SafeDumper):
        """A yaml Dumper that does not replace duplicate entries
        with yaml anchors.
        """
        ...
    
    

def not_installed_error(exc, *, msg=...): # -> Callable[..., NoReturn]:
    """Raises the ImportError when the module/object is actually called with a custom message."""
    ...

def extract_content_type(headers: t.Union[t.List[t.Tuple[bytes, bytes]], t.Dict[str, str]]) -> t.Optional[str]:
    """Extract the mime type and encoding from the content type headers.

    :param headers: Headers from ASGI scope

    :return: The content type if available in headers, otherwise None
    """
    ...

def split_content_type(content_type: t.Optional[str]) -> t.Tuple[t.Optional[str], t.Optional[str]]:
    """Split the content type in mime_type and encoding. Other parameters are ignored."""
    ...

def coerce_type(param, value, parameter_type, parameter_name=...): # -> list[Any] | dict[Any, Any] | None:
    ...

def get_root_path(import_name: str) -> str:
    """Copied from Flask:
    https://github.com/pallets/flask/blob/836866dc19218832cf02f8b04911060ac92bfc0b/src/flask/helpers.py#L595

    Find the root path of a package, or the path that contains a
    module. If it cannot be found, returns the current working
    directory.
    """
    ...

def inspect_function_arguments(function: t.Callable) -> t.Tuple[t.List[str], bool]:
    """
    Returns the list of variables names of a function and if it
    accepts keyword arguments.
    """
    ...

T = t.TypeVar("T")
@t.overload
def sort_routes(routes: t.List[str], *, key: None = ...) -> t.List[str]:
    ...

@t.overload
def sort_routes(routes: t.List[T], *, key: t.Callable[[T], str]) -> t.List[T]:
    ...

def sort_routes(routes, *, key=...): # -> list[Any]:
    """Sorts a list of routes from most specific to least specific.

    See Starlette routing documentation and implementation as this function
    is aimed to sort according to that logic.
    - https://www.starlette.io/routing/#route-priority

    The only difference is that a `path` component is appended to each route
    such that `/` is less specific than `/basepath` while they are technically
    not comparable.
    This is because it is also done by the `Mount` class internally:
    https://github.com/encode/starlette/blob/1c1043ca0ab7126419948b27f9d0a78270fd74e6/starlette/routing.py#L388

    For example, from most to least specific:
    - /users/me
    - /users/{username}/projects/{project}
    - /users/{username}

    :param routes: List of routes to sort
    :param key: Function to extract the path from a route if it is not a string

    :return: List of routes sorted from most specific to least specific
    """
    class SortableRoute:
        ...
    
    

def sort_apis_by_basepath(apis: t.List[API]) -> t.List[API]:
    """Sorts a list of APIs by basepath.

    :param apis: List of APIs to sort

    :return: List of APIs sorted by basepath
    """
    ...

