/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSortOrder;
import java.text.MessageFormat;

public class SQLServerMetaData {
    String columnName = null;
    int javaSqlType;
    int precision = 0;
    int scale = 0;
    boolean useServerDefault = false;
    boolean isUniqueKey = false;
    SQLServerSortOrder sortOrder = SQLServerSortOrder.Unspecified;
    int sortOrdinal;
    static final int defaultSortOrdinal = -1;

    public SQLServerMetaData(String string, int n) {
        this.columnName = string;
        this.javaSqlType = n;
    }

    public SQLServerMetaData(String string, int n, int n2, int n3) {
        this.columnName = string;
        this.javaSqlType = n;
        this.precision = n2;
        this.scale = n3;
    }

    public SQLServerMetaData(String string, int n, int n2, int n3, boolean bl, boolean bl2, SQLServerSortOrder sQLServerSortOrder, int n4) throws SQLServerException {
        this.columnName = string;
        this.javaSqlType = n;
        this.precision = n2;
        this.scale = n3;
        this.useServerDefault = bl;
        this.isUniqueKey = bl2;
        this.sortOrder = sQLServerSortOrder;
        this.sortOrdinal = n4;
        this.validateSortOrder();
    }

    public SQLServerMetaData(SQLServerMetaData sQLServerMetaData) {
        this.columnName = sQLServerMetaData.columnName;
        this.javaSqlType = sQLServerMetaData.javaSqlType;
        this.precision = sQLServerMetaData.precision;
        this.scale = sQLServerMetaData.scale;
        this.useServerDefault = sQLServerMetaData.useServerDefault;
        this.isUniqueKey = sQLServerMetaData.isUniqueKey;
        this.sortOrder = sQLServerMetaData.sortOrder;
        this.sortOrdinal = sQLServerMetaData.sortOrdinal;
    }

    public String getColumName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.javaSqlType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean useServerDefault() {
        return this.useServerDefault;
    }

    public boolean isUniqueKey() {
        return this.isUniqueKey;
    }

    public SQLServerSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public int getSortOrdinal() {
        return this.sortOrdinal;
    }

    void validateSortOrder() throws SQLServerException {
        if (SQLServerSortOrder.Unspecified == this.sortOrder != (-1 == this.sortOrdinal)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_TVPMissingSortOrderOrOrdinal"));
            throw new SQLServerException(messageFormat.format(new Object[]{this.sortOrder, this.sortOrdinal}), null, 0, null);
        }
    }
}

