from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

VTK_COLOR_BY_INPUT:int
VTK_COLOR_BY_SOURCE:int

class vtkProgrammableAttributeDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def AddInput(self, in_:'vtkDataSet') -> None: ...
    def GetInputList(self) -> 'vtkDataSetCollection': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgrammableAttributeDataFilter': ...
    def RemoveInput(self, in_:'vtkDataSet') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgrammableAttributeDataFilter': ...
    def SetExecuteMethod(self, f:Callback) -> None: ...

class vtkProgrammableFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def CopyArraysOff(self) -> None: ...
    def CopyArraysOn(self) -> None: ...
    def GetCopyArrays(self) -> bool: ...
    def GetGraphInput(self) -> 'vtkGraph': ...
    def GetHyperTreeGridInput(self) -> 'vtkHyperTreeGrid': ...
    def GetMoleculeInput(self) -> 'vtkMolecule': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataInput(self) -> 'vtkPolyData': ...
    def GetRectilinearGridInput(self) -> 'vtkRectilinearGrid': ...
    def GetStructuredGridInput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsInput(self) -> 'vtkStructuredPoints': ...
    def GetTableInput(self) -> 'vtkTable': ...
    def GetUnstructuredGridInput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgrammableFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgrammableFilter': ...
    def SetCopyArrays(self, _arg:bool) -> None: ...
    def SetExecuteMethod(self, f:Callback) -> None: ...

class vtkProgrammableGlyphFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint(self) -> Tuple[float, float, float]: ...
    def GetPointData(self) -> 'vtkPointData': ...
    def GetPointId(self) -> int: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgrammableGlyphFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgrammableGlyphFilter': ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToColorByInput(self) -> None: ...
    def SetColorModeToColorBySource(self) -> None: ...
    def SetGlyphMethod(self, f:Callback) -> None: ...
    def SetSourceConnection(self, output:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkPolyData') -> None: ...

