from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore

class vtkImageViewer(vtkmodules.vtkCommonCore.vtkObject):
    def GetActor2D(self) -> 'vtkActor2D': ...
    def GetColorLevel(self) -> float: ...
    def GetColorWindow(self) -> float: ...
    def GetImageMapper(self) -> 'vtkImageMapper': ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffScreenRendering(self) -> int: ...
    def GetPosition(self) -> Tuple[int, int]: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetWholeZMax(self) -> int: ...
    def GetWholeZMin(self) -> int: ...
    def GetWindowName(self) -> str: ...
    def GetZSlice(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageViewer': ...
    def OffScreenRenderingOff(self) -> None: ...
    def OffScreenRenderingOn(self) -> None: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageViewer': ...
    def SetColorLevel(self, s:float) -> None: ...
    def SetColorWindow(self, s:float) -> None: ...
    def SetDisplayId(self, a:Pointer) -> None: ...
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, in_:'vtkImageData') -> None: ...
    def SetOffScreenRendering(self, __a:int) -> None: ...
    def SetParentId(self, a:Pointer) -> None: ...
    @overload
    def SetPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    def SetRenderWindow(self, renWin:'vtkRenderWindow') -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetWindowId(self, a:Pointer) -> None: ...
    def SetZSlice(self, s:int) -> None: ...
    def SetupInteractor(self, __a:'vtkRenderWindowInteractor') -> None: ...

class vtkImageViewer2(vtkmodules.vtkCommonCore.vtkObject):
    SLICE_ORIENTATION_XY:int
    SLICE_ORIENTATION_XZ:int
    SLICE_ORIENTATION_YZ:int
    def GetColorLevel(self) -> float: ...
    def GetColorWindow(self) -> float: ...
    def GetImageActor(self) -> 'vtkImageActor': ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetInteractorStyle(self) -> 'vtkInteractorStyleImage': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffScreenRendering(self) -> int: ...
    def GetPosition(self) -> Tuple[int, int]: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetSlice(self) -> int: ...
    def GetSliceMax(self) -> int: ...
    def GetSliceMin(self) -> int: ...
    def GetSliceOrientation(self) -> int: ...
    @overload
    def GetSliceRange(self, range:MutableSequence[int]) -> None: ...
    @overload
    def GetSliceRange(self, min:int, max:int) -> None: ...
    @overload
    def GetSliceRange(self) -> Pointer: ...
    def GetWindowLevel(self) -> 'vtkImageMapToWindowLevelColors': ...
    def GetWindowName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageViewer2': ...
    def OffScreenRenderingOff(self) -> None: ...
    def OffScreenRenderingOn(self) -> None: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageViewer2': ...
    def SetColorLevel(self, s:float) -> None: ...
    def SetColorWindow(self, s:float) -> None: ...
    def SetDisplayId(self, a:Pointer) -> None: ...
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, in_:'vtkImageData') -> None: ...
    def SetOffScreenRendering(self, __a:int) -> None: ...
    def SetParentId(self, a:Pointer) -> None: ...
    @overload
    def SetPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    def SetRenderWindow(self, arg:'vtkRenderWindow') -> None: ...
    def SetRenderer(self, arg:'vtkRenderer') -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetSlice(self, s:int) -> None: ...
    def SetSliceOrientation(self, orientation:int) -> None: ...
    def SetSliceOrientationToXY(self) -> None: ...
    def SetSliceOrientationToXZ(self) -> None: ...
    def SetSliceOrientationToYZ(self) -> None: ...
    def SetWindowId(self, a:Pointer) -> None: ...
    def SetupInteractor(self, __a:'vtkRenderWindowInteractor') -> None: ...
    def UpdateDisplayExtent(self) -> None: ...

class vtkResliceImageViewer(vtkImageViewer2):
    RESLICE_AXIS_ALIGNED:int
    RESLICE_OBLIQUE:int
    SliceChangedEvent:int
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMeasurements(self) -> 'vtkResliceImageViewerMeasurements': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointPlacer(self) -> 'vtkBoundedPlanePointPlacer': ...
    def GetResliceCursor(self) -> 'vtkResliceCursor': ...
    def GetResliceCursorWidget(self) -> 'vtkResliceCursorWidget': ...
    def GetResliceMode(self) -> int: ...
    def GetSliceScrollFactor(self) -> float: ...
    def GetSliceScrollOnMouseWheel(self) -> int: ...
    def GetThickMode(self) -> int: ...
    def IncrementSlice(self, inc:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceImageViewer': ...
    def Render(self) -> None: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceImageViewer': ...
    def SetColorLevel(self, s:float) -> None: ...
    def SetColorWindow(self, s:float) -> None: ...
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, in_:'vtkImageData') -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    def SetResliceCursor(self, rc:'vtkResliceCursor') -> None: ...
    def SetResliceMode(self, resliceMode:int) -> None: ...
    def SetResliceModeToAxisAligned(self) -> None: ...
    def SetResliceModeToOblique(self) -> None: ...
    def SetSliceScrollFactor(self, _arg:float) -> None: ...
    def SetSliceScrollOnMouseWheel(self, _arg:int) -> None: ...
    def SetThickMode(self, __a:int) -> None: ...
    def SliceScrollOnMouseWheelOff(self) -> None: ...
    def SliceScrollOnMouseWheelOn(self) -> None: ...

class vtkResliceImageViewerMeasurements(vtkmodules.vtkCommonCore.vtkObject):
    def AddItem(self, __a:'vtkAbstractWidget') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProcessEvents(self) -> int: ...
    def GetProcessEventsMaxValue(self) -> int: ...
    def GetProcessEventsMinValue(self) -> int: ...
    def GetResliceImageViewer(self) -> 'vtkResliceImageViewer': ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceImageViewerMeasurements': ...
    def ProcessEventsOff(self) -> None: ...
    def ProcessEventsOn(self) -> None: ...
    def RemoveAllItems(self) -> None: ...
    def RemoveItem(self, __a:'vtkAbstractWidget') -> None: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceImageViewerMeasurements': ...
    def SetProcessEvents(self, _arg:int) -> None: ...
    def SetResliceImageViewer(self, __a:'vtkResliceImageViewer') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def Update(self) -> None: ...

