from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore

class vtkDataEncoder(vtkmodules.vtkCommonCore.vtkObject):
    def EncodeAsBase64Jpg(self, img:'vtkImageData', quality:int=50) -> str: ...
    def EncodeAsBase64Png(self, img:'vtkImageData', compressionLevel:int=5) -> str: ...
    def Finalize(self) -> None: ...
    def Flush(self, key:int) -> None: ...
    def GetLatestOutput(self, key:int, data:'vtkUnsignedCharArray') -> bool: ...
    def GetMaxThreads(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataEncoder': ...
    def Push(self, key:int, data:'vtkImageData', quality:int, encoding:int=1) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataEncoder': ...
    def SetMaxThreads(self, __a:int) -> None: ...

class vtkObjectIdMap(vtkmodules.vtkCommonCore.vtkObject):
    def FreeObject(self, obj:'vtkObject') -> bool: ...
    def FreeObjectById(self, id:int) -> bool: ...
    def GetActiveObject(self, objectType:str) -> 'vtkObject': ...
    def GetGlobalId(self, obj:'vtkObject') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVTKObject(self, globalId:int) -> 'vtkObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkObjectIdMap': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkObjectIdMap': ...
    def SetActiveObject(self, objectType:str, obj:'vtkObject') -> int: ...

class vtkWebApplication(vtkmodules.vtkCommonCore.vtkObject):
    COMPRESSION_JPEG:int
    COMPRESSION_NONE:int
    COMPRESSION_PNG:int
    ENCODING_BASE64:int
    ENCODING_NONE:int
    def GetHasImagesBeingProcessed(self, __a:'vtkRenderWindow') -> bool: ...
    def GetImageCompression(self) -> int: ...
    def GetImageCompressionMaxValue(self) -> int: ...
    def GetImageCompressionMinValue(self) -> int: ...
    def GetImageEncoding(self) -> int: ...
    def GetImageEncodingMaxValue(self) -> int: ...
    def GetImageEncodingMinValue(self) -> int: ...
    def GetLastStillRenderToMTime(self) -> int: ...
    def GetNumberOfEncoderThreads(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetObjectId(obj:'vtkObject') -> str: ...
    def GetObjectIdMap(self) -> 'vtkObjectIdMap': ...
    def GetWebGLBinaryData(self, view:'vtkRenderWindow', id:str, partIndex:int) -> str: ...
    def GetWebGLSceneMetaData(self, view:'vtkRenderWindow') -> str: ...
    def HandleInteractionEvent(self, view:'vtkRenderWindow', event:'vtkWebInteractionEvent') -> bool: ...
    def InteractiveRender(self, view:'vtkRenderWindow', quality:int=50) -> 'vtkUnsignedCharArray': ...
    def InvalidateCache(self, view:'vtkRenderWindow') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebApplication': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebApplication': ...
    def SetImageCompression(self, _arg:int) -> None: ...
    def SetImageEncoding(self, _arg:int) -> None: ...
    def SetNumberOfEncoderThreads(self, __a:int) -> None: ...
    def StillRender(self, view:'vtkRenderWindow', quality:int=100) -> 'vtkUnsignedCharArray': ...
    def StillRenderToBuffer(self, view:'vtkRenderWindow', time:int=0, quality:int=100) -> 'vtkUnsignedCharArray': ...
    def StillRenderToString(self, view:'vtkRenderWindow', time:int=0, quality:int=100) -> str: ...

class vtkWebInteractionEvent(vtkmodules.vtkCommonCore.vtkObject):
    class ModifierKeys(int): ...
    class MouseButton(int): ...
    ALT_KEY:'ModifierKeys'
    CTRL_KEY:'ModifierKeys'
    LEFT_BUTTON:'MouseButton'
    META_KEY:'ModifierKeys'
    MIDDLE_BUTTON:'MouseButton'
    RIGHT_BUTTON:'MouseButton'
    SHIFT_KEY:'ModifierKeys'
    def GetButtons(self) -> int: ...
    def GetKeyCode(self) -> str: ...
    def GetModifiers(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRepeatCount(self) -> int: ...
    def GetScroll(self) -> float: ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebInteractionEvent': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebInteractionEvent': ...
    def SetButtons(self, _arg:int) -> None: ...
    def SetKeyCode(self, _arg:str) -> None: ...
    def SetModifiers(self, _arg:int) -> None: ...
    def SetRepeatCount(self, _arg:int) -> None: ...
    def SetScroll(self, _arg:float) -> None: ...
    def SetX(self, _arg:float) -> None: ...
    def SetY(self, _arg:float) -> None: ...

class vtkWebUtilities(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebUtilities': ...
    @overload
    @staticmethod
    def ProcessRMIs() -> None: ...
    @overload
    @staticmethod
    def ProcessRMIs(reportError:int, dont_loop:int=0) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebUtilities': ...
    @staticmethod
    def WriteAttributeHeadersToJavaScript(field_type:int, __b:'vtkDataSet') -> str: ...
    @staticmethod
    def WriteAttributesToJavaScript(field_type:int, __b:'vtkDataSet') -> str: ...

