"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmUpdateConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const snsSubscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
class SsmUpdateConstruct extends constructs_1.Construct {
    constructor(scope, id, snsTopic, pipelineConfig) {
        super(scope, id);
        const fn = new lambda.Function(this, 'IBLambdaUpdate', {
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'main.lambda_handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'imagebuilder-lambda-update-sns')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'ssm',
                    Effect: 'Allow',
                    Action: ['ssm:PutParameter', 'ssm:AddTagsToResource', 'ssm:GetParameters'],
                    Resource: '*',
                }),
            ],
            environment: {
                SSM_PARAMETER: pipelineConfig.name,
            },
        });
        snsTopic.addSubscription(new snsSubscriptions.LambdaSubscription(fn));
    }
}
exports.SsmUpdateConstruct = SsmUpdateConstruct;
_a = JSII_RTTI_SYMBOL_1;
SsmUpdateConstruct[_a] = { fqn: "halloumi-ami-pipelines.SsmUpdateConstruct", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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