class Settings:
    def __init__(self):
        self.screen_width = 1250
        self.screen_height = 700
        self.bg_color = (0,0,0)
        self.ship_speed=3.0
        self.bullet_speed = 3.0
        self.bullet_width = 8
        self.bullet_height = 15
        self.bullet_color = (230, 230, 230)
        self.bullets_allowed = 10
        self.alien_speed = 1.0
        self.fleet_drop_speed = 40
        self.fleet_direction = 1
        self.ship_limit =3
        self.alien_points = 50

        self.speedup_scale = 1.1
        self.score_scale = 1.5
        self.initialize_dynamic_settings()
    def initialize_dynamic_settings(self):
        "Initialize settings that change throughout the game"
        self.ship_speed =3.0
        self.bullet_speed=3.0
        self.alien_speed = 1.0
        self.fleet_direction=1

    def increase_speed(self):
        self.ship_speed *= self.speedup_scale
        self.bullet_speed *= self.speedup_scale
        self.alien_speed *= self.speedup_scale
        self.alien_points = int(self.alien_points*self.score_scale)
        print(self.alien_points)
