from ...forall import *
#######################################################################################################################
# Специальные дискретные случайные величины
#######################################################################################################################
def CCE_1(a,b):
    """Несимметричная игральная кость подбрасывается до тех пор, пока не выпадут цифры `V1` и `V2`.
    Пусть  X — число сделанных при этом бросков. Даны вероятности появления цифр в одном броске:
    P(`V1`)=`a` и P(`V2`)=`b`.Требуется найти:
    - E(X);
    - Var(X), если известно, что из `V1` и `V2` сначала выпала цифра `V2`

    Args:
        a (numerical): Вероятность выпадения 1-го числа
        b (numerical): Вероятность выпадения 2-го числа

    ## Prints
        `answer` каждое значение по очереди.<br>C запятой вместо точки и сокращением до соответствующего количества знаков после запятой

    Returns:
        `answer` (tuple): Соответствующие величины
    """
    ex = 1/a+1/b-1/(a+b)
    var=(1-a-b)/(a+b)**2+(1-a)/a**2
    
    answer = (ex, var)
    
    print('E(X)   = ' + rrstr(answer[0],4))
    print('Var(X) = ' + rrstr(answer[1],3))

    return answer
#######################################################################################################################
def CCE_2(a,b,c):
    """Несимметричная игральная кость подбрасывается до тех пор,
    пока не выпадут цифры `V1`, `V2` и `V3`.
    Пусть X — число сделанных при этом бросков.
    Даны вероятности появления цифр в одном броске: P(`V1`)=`a`, P(`V2`)=`b` и P(`V3`)=`c`. Требуется найти:
    - E(X);
    - Var(X), если известно, что из `V1`, `V2` и `V3` сначала выпала цифра `V1`, затем — `V2`

    Args:
        a (numerical): Вероятность выпадения 1-го числа
        b (numerical): Вероятность выпадения 2-го числа
        c (numerical): Вероятность выпадения 3-го числа
        
    ## Prints
        `answer` каждое значение по очереди.<br>C запятой вместо точки и сокращением до соответствующего количества знаков после запятой

    Returns:
        `answer` (tuple): Соответствующие величины
    """
    ex = (1+a/(b+c)+b/(a+c)+c/(a+b)+a*b/(c*(b+c))+a*b/(c*(a+c))+a*c/(b*(b+c))+a*c/(b*(b+a))+c*b/(a*(b+a))+c*b/(a*(c+a)))/(a+b+c)
    var =(1-a-b-c)/(a+b+c)**2+(1-b-c)/(b+c)**2+(1-c)/c**2 #при a->b->c
    
    answer = (ex, var)
    
    print('E(X)   = ' + rrstr(answer[0],4))
    print('Var(X) = ' + rrstr(answer[1],3))

    return answer
#######################################################################################################################
CCE = [CCE_1,CCE_2]