import typing
import bl_operators.anim
import bl_operators.assets
import bl_operators.clip
import bl_operators.constraint
import bl_operators.file
import bl_operators.freestyle
import bl_operators.node
import bl_operators.object
import bl_operators.presets
import bl_operators.spreadsheet
import bl_operators.userpref
import bl_operators.view3d
import bl_operators.wm
import bl_ui
import bl_ui.anim
import bl_ui.asset_shelf
import bl_ui.generic_ui_list
import bl_ui.node_add_menu
import bl_ui.node_add_menu_compositor
import bl_ui.node_add_menu_geometry
import bl_ui.node_add_menu_shader
import bl_ui.node_add_menu_texture
import bl_ui.properties_collection
import bl_ui.properties_constraint
import bl_ui.properties_data_armature
import bl_ui.properties_data_bone
import bl_ui.properties_data_camera
import bl_ui.properties_data_curve
import bl_ui.properties_data_curves
import bl_ui.properties_data_empty
import bl_ui.properties_data_gpencil
import bl_ui.properties_data_grease_pencil
import bl_ui.properties_data_lattice
import bl_ui.properties_data_light
import bl_ui.properties_data_lightprobe
import bl_ui.properties_data_mesh
import bl_ui.properties_data_metaball
import bl_ui.properties_data_modifier
import bl_ui.properties_data_pointcloud
import bl_ui.properties_data_shaderfx
import bl_ui.properties_data_speaker
import bl_ui.properties_data_volume
import bl_ui.properties_freestyle
import bl_ui.properties_grease_pencil_common
import bl_ui.properties_mask_common
import bl_ui.properties_material
import bl_ui.properties_material_gpencil
import bl_ui.properties_object
import bl_ui.properties_output
import bl_ui.properties_paint_common
import bl_ui.properties_particle
import bl_ui.properties_physics_cloth
import bl_ui.properties_physics_common
import bl_ui.properties_physics_dynamicpaint
import bl_ui.properties_physics_field
import bl_ui.properties_physics_fluid
import bl_ui.properties_physics_geometry_nodes
import bl_ui.properties_physics_rigidbody
import bl_ui.properties_physics_rigidbody_constraint
import bl_ui.properties_physics_softbody
import bl_ui.properties_render
import bl_ui.properties_scene
import bl_ui.properties_texture
import bl_ui.properties_view_layer
import bl_ui.properties_workspace
import bl_ui.properties_world
import bl_ui.space_clip
import bl_ui.space_console
import bl_ui.space_dopesheet
import bl_ui.space_filebrowser
import bl_ui.space_graph
import bl_ui.space_image
import bl_ui.space_info
import bl_ui.space_nla
import bl_ui.space_node
import bl_ui.space_outliner
import bl_ui.space_properties
import bl_ui.space_sequencer
import bl_ui.space_spreadsheet
import bl_ui.space_statusbar
import bl_ui.space_text
import bl_ui.space_time
import bl_ui.space_toolsystem_common
import bl_ui.space_toolsystem_toolbar
import bl_ui.space_topbar
import bl_ui.space_userpref
import bl_ui.space_view3d
import bl_ui.space_view3d_toolbar
import mathutils

GenericType = typing.TypeVar("GenericType")

class bpy_prop_array(typing.Generic[GenericType]):
    """ """

    def foreach_get(self, attr, seq):
        """

        :param attr:
        :param seq:
        """
        ...

    def foreach_set(self, attr, seq):
        """

        :param attr:
        :param seq:
        """
        ...

    def __getitem__(self, key: typing.Union[int, str]) -> typing.Union[int, str]:
        """

        :param key:
        :type key: typing.Union[int, str]
        :return:
        :rtype: GenericType
        """
        ...

    def __setitem__(self, key: typing.Union[int, str], value: GenericType):
        """

        :param key:
        :type key: typing.Union[int, str]
        :param value:
        :type value: GenericType
        """
        ...

    def __delitem__(self, key: typing.Union[int, str]) -> typing.Union[int, str]:
        """

        :param key:
        :type key: typing.Union[int, str]
        :return:
        :rtype: GenericType
        """
        ...

    def __iter__(self) -> GenericType:
        """

        :return:
        :rtype: typing.Iterator[GenericType]
        """
        ...

    def __next__(self) -> typing.Iterator[GenericType]:
        """

        :return:
        :rtype: GenericType
        """
        ...

    def __len__(self) -> GenericType:
        """

        :return:
        :rtype: int
        """
        ...

class bpy_prop_collection(typing.Generic[GenericType]):
    """built-in class used for all collections."""

    def find(self, key: str) -> str:
        """Returns the index of a key in a collection or -1 when not found
        (matches Python's string find function of the same name).

                :param key: The identifier for the collection member.
                :type key: str
                :return: index of the key.
                :rtype: int
        """
        ...

    def foreach_get(self, attr, seq):
        """This is a function to give fast access to attributes within a collection.Only works for 'basic type' properties (bool, int and float)!
        Multi-dimensional arrays (like array of vectors) will be flattened into seq.

                :param attr:
                :param seq:
        """
        ...

    def foreach_set(self, attr, seq):
        """This is a function to give fast access to attributes within a collection.Only works for 'basic type' properties (bool, int and float)!
        seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it.

                :param attr:
                :param seq:
        """
        ...

    def get(self, key: str, default=None):
        """Returns the value of the item assigned to key or default when not found
        (matches Python's dictionary function of the same name).

                :param key: The identifier for the collection member.
                :type key: str
                :param default: Optional argument for the value to return if
        key is not found.
        """
        ...

    def items(self):
        """Return the identifiers of collection members
        (matching Python's dict.items() functionality).

                :return: (key, value) pairs for each member of this collection.
        """
        ...

    def keys(self):
        """Return the identifiers of collection members
        (matching Python's dict.keys() functionality).

                :return: the identifiers for each member of this collection.
                :rtype: typing.List[str]
        """
        ...

    def values(self) -> typing.List[str]:
        """Return the values of collection
        (matching Python's dict.values() functionality).

                :return: the members of this collection.
                :rtype: list
        """
        ...

    def __getitem__(self, key: typing.Union[int, str]) -> typing.Union[int, str]:
        """

        :param key:
        :type key: typing.Union[int, str]
        :return:
        :rtype: GenericType
        """
        ...

    def __setitem__(self, key: typing.Union[int, str], value: GenericType):
        """

        :param key:
        :type key: typing.Union[int, str]
        :param value:
        :type value: GenericType
        """
        ...

    def __delitem__(self, key: typing.Union[int, str]) -> typing.Union[int, str]:
        """

        :param key:
        :type key: typing.Union[int, str]
        :return:
        :rtype: GenericType
        """
        ...

    def __iter__(self) -> GenericType:
        """

        :return:
        :rtype: typing.Iterator[GenericType]
        """
        ...

    def __next__(self) -> typing.Iterator[GenericType]:
        """

        :return:
        :rtype: GenericType
        """
        ...

    def __len__(self) -> GenericType:
        """

        :return:
        :rtype: int
        """
        ...

class AOV(bpy_struct):
    """ """

    is_valid: bool
    """ Is the name of the AOV conflicting

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Name of the AOV

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Union[str, int]
    """ Data type of the AOV

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AOVs(bpy_struct):
    """Collection of AOVs"""

    def add(self) -> bpy_struct:
        """add

        :return: Newly created AOV
        :rtype: AOV
        """
        ...

    def remove(self, aov: AOV):
        """Remove an AOV

        :param aov: AOV to remove
        :type aov: AOV
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ASSETBROWSER_UL_metadata_tags(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Action(bpy_struct):
    """A collection of F-Curves for animation"""

    curve_frame_range: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ The combined frame range of all F-Curves within this action

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    fcurves: bpy_prop_collection[FCurve]
    """ The individual F-Curves that make up the action

    :type: bpy_prop_collection[FCurve]
    """

    frame_end: float
    """ The end frame of the manually set intended playback range

    :type: float
    """

    frame_range: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ The intended playback frame range of this action, using the manually set range if available, or the combined frame range of all F-Curves within this action if not (assigning sets the manual frame range)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    frame_start: float
    """ The start frame of the manually set intended playback range

    :type: float
    """

    groups: bpy_prop_collection[ActionGroup]
    """ Convenient groupings of F-Curves

    :type: bpy_prop_collection[ActionGroup]
    """

    id_root: typing.Any
    """ Type of ID block that action can be used on - DO NOT CHANGE UNLESS YOU KNOW WHAT YOU ARE DOING"""

    pose_markers: bpy_prop_collection[TimelineMarker]
    """ Markers specific to this action, for labeling poses

    :type: bpy_prop_collection[TimelineMarker]
    """

    use_cyclic: bool
    """ The action is intended to be used as a cycle looping over its manually set playback frame range (enabling this doesn't automatically make it loop)

    :type: bool
    """

    use_frame_range: bool
    """ Manually specify the intended playback frame range for the action (this range is used by some tools, but does not affect animation evaluation)

    :type: bool
    """

    def flip_with_pose(self, object: Object):
        """Flip the action around the X axis using a pose

        :param object: The reference armature object to use when flipping
        :type object: Object
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ActionConstraint(bpy_struct):
    """Map an action to the transform axes of a bone"""

    action: Action
    """ The constraining action

    :type: Action
    """

    eval_time: float
    """ Interpolates between Action Start and End frames

    :type: float
    """

    frame_end: int
    """ Last frame of the Action to use

    :type: int
    """

    frame_start: int
    """ First frame of the Action to use

    :type: int
    """

    max: float
    """ Maximum value for target channel range

    :type: float
    """

    min: float
    """ Minimum value for target channel range

    :type: float
    """

    mix_mode: typing.Union[str, int]
    """ Specify how existing transformations and the action channels are combined

    :type: typing.Union[str, int]
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    transform_channel: typing.Union[str, int]
    """ Transformation channel from the target that is used to key the Action

    :type: typing.Union[str, int]
    """

    use_bone_object_action: bool
    """ Bones only: apply the object's transformation channels of the action to the constrained bone, instead of bone's channels

    :type: bool
    """

    use_eval_time: bool
    """ Interpolate between Action Start and End frames, with the Evaluation Time slider instead of the Target object/bone

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ActionFCurves(bpy_struct):
    """Collection of action F-Curves"""

    def new(
        self,
        data_path: typing.Union[str, typing.Any],
        index: typing.Any = 0,
        action_group: typing.Union[str, typing.Any] = "",
    ) -> typing.Union[str, typing.Any]:
        """Add an F-Curve to the action

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Any
        :param action_group: Action Group, Acton group to add this F-Curve into
        :type action_group: typing.Union[str, typing.Any]
        :return: Newly created F-Curve
        :rtype: FCurve
        """
        ...

    def find(
        self, data_path: typing.Union[str, typing.Any], index: typing.Any = 0
    ) -> typing.Any:
        """Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the action.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Any
        :return: The found F-Curve, or None if it doesn't exist
        :rtype: FCurve
        """
        ...

    def remove(self, fcurve: FCurve):
        """Remove F-Curve

        :param fcurve: F-Curve to remove
        :type fcurve: FCurve
        """
        ...

    def clear(self):
        """Remove all F-Curves"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ActionGroup(bpy_struct):
    """Groups of F-Curves"""

    channels: bpy_prop_collection[FCurve]
    """ F-Curves in this group

    :type: bpy_prop_collection[FCurve]
    """

    color_set: typing.Any
    """ Custom color set to use"""

    colors: ThemeBoneColorSet
    """ Copy of the colors associated with the group's color set

    :type: ThemeBoneColorSet
    """

    is_custom_color_set: typing.Union[bool, typing.Any]
    """ Color set is user-defined instead of a fixed theme color set

    :type: typing.Union[bool, typing.Any]
    """

    lock: bool
    """ Action group is locked

    :type: bool
    """

    mute: bool
    """ Action group is muted

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Action group is selected

    :type: bool
    """

    show_expanded: bool
    """ Action group is expanded except in graph editor

    :type: bool
    """

    show_expanded_graph: bool
    """ Action group is expanded in graph editor

    :type: bool
    """

    use_pin: bool
    """ 

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ActionGroups(bpy_struct):
    """Collection of action groups"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Create a new action group and add it to the action

        :param name: New name for the action group
        :type name: typing.Union[str, typing.Any]
        :return: Newly created action group
        :rtype: ActionGroup
        """
        ...

    def remove(self, action_group: ActionGroup):
        """Remove action group

        :param action_group: Action group to remove
        :type action_group: ActionGroup
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ActionPoseMarkers(bpy_struct):
    """Collection of timeline markers"""

    active: TimelineMarker
    """ Active pose marker for this action

    :type: TimelineMarker
    """

    active_index: int
    """ Index of active pose marker

    :type: int
    """

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a pose marker to the action

        :param name: New name for the marker (not unique)
        :type name: typing.Union[str, typing.Any]
        :return: Newly created marker
        :rtype: TimelineMarker
        """
        ...

    def remove(self, marker: TimelineMarker):
        """Remove a timeline marker

        :param marker: Timeline marker to remove
        :type marker: TimelineMarker
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AddSequence(bpy_struct):
    """Add Sequence"""

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_2: Sequence
    """ Second input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Addon(bpy_struct):
    """Python add-ons to be loaded automatically"""

    module: typing.Union[str, typing.Any]
    """ Module name

    :type: typing.Union[str, typing.Any]
    """

    preferences: AddonPreferences
    """ 

    :type: AddonPreferences
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AddonPreferences(bpy_struct):
    """ """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    layout: UILayout
    """ 

    :type: UILayout
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Addons(bpy_struct):
    """Collection of add-ons"""

    @classmethod
    def new(cls) -> bpy_struct:
        """Add a new add-on

        :return: Add-on data
        :rtype: Addon
        """
        ...

    @classmethod
    def remove(cls, addon: Addon):
        """Remove add-on

        :param addon: Add-on to remove
        :type addon: Addon
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AdjustmentSequence(bpy_struct):
    """Sequence strip to perform filter adjustments to layers below"""

    animation_offset_end: int
    """ Animation end offset (trim end)

    :type: int
    """

    animation_offset_start: int
    """ Animation start offset (trim start)

    :type: int
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AlphaOverSequence(bpy_struct):
    """Alpha Over Sequence"""

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_2: Sequence
    """ Second input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AlphaUnderSequence(bpy_struct):
    """Alpha Under Sequence"""

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_2: Sequence
    """ Second input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AnimData(bpy_struct):
    """Animation data for data-block"""

    action: Action
    """ Active Action for this data-block

    :type: Action
    """

    action_blend_type: typing.Union[str, int]
    """ Method used for combining Active Action's result with result of NLA stack

    :type: typing.Union[str, int]
    """

    action_extrapolation: typing.Union[str, int]
    """ Action to take for gaps past the Active Action's range (when evaluating with NLA)

    :type: typing.Union[str, int]
    """

    action_influence: float
    """ Amount the Active Action contributes to the result of the NLA stack

    :type: float
    """

    action_tweak_storage: Action
    """ Slot to temporarily hold the main action while in tweak mode

    :type: Action
    """

    drivers: bpy_prop_collection[FCurve]
    """ The Drivers/Expressions for this data-block

    :type: bpy_prop_collection[FCurve]
    """

    nla_tracks: bpy_prop_collection[NlaTrack]
    """ NLA Tracks (i.e. Animation Layers)

    :type: bpy_prop_collection[NlaTrack]
    """

    use_nla: bool
    """ NLA stack is evaluated when evaluating this block

    :type: bool
    """

    use_pin: bool
    """ 

    :type: bool
    """

    use_tweak_mode: bool
    """ Whether to enable or disable tweak mode in NLA

    :type: bool
    """

    def nla_tweak_strip_time_to_scene(
        self, frame: float, invert: typing.Union[bool, typing.Any] = False
    ) -> typing.Union[bool, typing.Any]:
        """Convert a time value from the local time of the tweaked strip to scene time, exactly as done by built-in key editing tools. Returns the input time unchanged if not tweaking.

        :param frame: Input time
        :type frame: float
        :param invert: Invert, Convert scene time to action time
        :type invert: typing.Union[bool, typing.Any]
        :return: Converted time
        :rtype: float
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AnimDataDrivers(bpy_struct):
    """Collection of Driver F-Curves"""

    def new(
        self, data_path: typing.Union[str, typing.Any], index: typing.Any = 0
    ) -> typing.Any:
        """new

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Any
        :return: Newly Driver F-Curve
        :rtype: FCurve
        """
        ...

    def remove(self, driver: FCurve):
        """remove

        :param driver:
        :type driver: FCurve
        """
        ...

    def from_existing(self, src_driver: FCurve = None) -> FCurve:
        """Add a new driver given an existing one

        :param src_driver: Existing Driver F-Curve to use as template for a new one
        :type src_driver: FCurve
        :return: New Driver F-Curve
        :rtype: FCurve
        """
        ...

    def find(
        self, data_path: typing.Union[str, typing.Any], index: typing.Any = 0
    ) -> typing.Any:
        """Find a driver F-Curve. Note that this function performs a linear scan of all driver F-Curves.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Any
        :return: The found F-Curve, or None if it doesn't exist
        :rtype: FCurve
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AnimViz(bpy_struct):
    """Settings for the visualization of motion"""

    motion_path: AnimVizMotionPaths
    """ Motion Path settings for visualization

    :type: AnimVizMotionPaths
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AnimVizMotionPaths(bpy_struct):
    """Motion Path settings for animation visualization"""

    bake_location: typing.Any
    """ When calculating Bone Paths, use Head or Tips"""

    frame_after: int
    """ Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_before: int
    """ Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_end: int
    """ End frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_start: int
    """ Starting frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_step: int
    """ Number of frames between paths shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    """

    has_motion_paths: typing.Union[bool, typing.Any]
    """ Are there any bone paths that will need updating (read-only)

    :type: typing.Union[bool, typing.Any]
    """

    range: typing.Any
    """ Type of range to calculate for Motion Paths"""

    show_frame_numbers: bool
    """ Show frame numbers on Motion Paths

    :type: bool
    """

    show_keyframe_action_all: bool
    """ For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)

    :type: bool
    """

    show_keyframe_highlight: bool
    """ Emphasize position of keyframes on Motion Paths

    :type: bool
    """

    show_keyframe_numbers: bool
    """ Show frame numbers of Keyframes on Motion Paths

    :type: bool
    """

    type: typing.Any
    """ Type of range to show for Motion Paths"""

    use_camera_space_bake: bool
    """ Motion path points will be baked into the camera space of the active camera. This means they will only look right when looking through that camera. Switching cameras using markers is not supported

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AnyType(bpy_struct):
    """RNA type used for pointers to any possible data"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Area(bpy_struct):
    """Area in a subdivided screen, containing an editor"""

    height: int
    """ Area height

    :type: int
    """

    regions: bpy_prop_collection[Region]
    """ Regions this area is subdivided in

    :type: bpy_prop_collection[Region]
    """

    show_menus: bool
    """ Show menus in the header

    :type: bool
    """

    spaces: bpy_prop_collection[Space]
    """ Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation)

    :type: bpy_prop_collection[Space]
    """

    type: typing.Any
    """ Current editor type for this area"""

    ui_type: typing.Union[str, int]
    """ Current editor type for this area

    :type: typing.Union[str, int]
    """

    width: int
    """ Area width

    :type: int
    """

    x: int
    """ The window relative vertical location of the area

    :type: int
    """

    y: int
    """ The window relative horizontal location of the area

    :type: int
    """

    def tag_redraw(self):
        """tag_redraw"""
        ...

    def header_text_set(self, text: str):
        """Set the header status text

        :param text: Text, New string for the header, None clears the text
        :type text: str
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AreaLight(bpy_struct):
    """Directional area Light"""

    contact_shadow_bias: float
    """ Bias to avoid self shadowing

    :type: float
    """

    contact_shadow_distance: float
    """ World space distance in which to search for screen space occluder

    :type: float
    """

    contact_shadow_thickness: float
    """ Pixel thickness used to detect occlusion

    :type: float
    """

    energy: float
    """ Light energy emitted over the entire area of the light in all directions

    :type: float
    """

    shadow_buffer_bias: float
    """ Bias for reducing self shadowing

    :type: float
    """

    shadow_buffer_clip_start: float
    """ Shadow map clip start, below which objects will not generate shadows

    :type: float
    """

    shadow_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color of shadows cast by the light

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    shadow_filter_radius: float
    """ Blur shadow aliasing using Percentage Closer Filtering

    :type: float
    """

    shadow_resolution_scale: float
    """ Scale the Shadow Map target resolution, where 1.0 tries to match shadow map and screen pixel density. (The scale is applied on top of the scene Simplify Shadow Resolution)

    :type: float
    """

    shadow_soft_size: float
    """ Light size for ray shadow sampling (Raytraced shadows)

    :type: float
    """

    shadow_softness_factor: float
    """ Scale light shape for smaller penumbra

    :type: float
    """

    shape: typing.Union[str, int]
    """ Shape of the area Light

    :type: typing.Union[str, int]
    """

    size: float
    """ Size of the area of the area light, X direction size for rectangle shapes

    :type: float
    """

    size_y: float
    """ Size of the area of the area light in the Y direction for rectangle shapes

    :type: float
    """

    spread: float
    """ How widely the emitted light fans out, as in the case of a gridded softbox

    :type: float
    """

    use_contact_shadow: bool
    """ Use screen space ray-tracing to have correct shadowing near occluder, or for small features that does not appear in shadow maps

    :type: bool
    """

    use_shadow: bool
    """ 

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AreaSpaces(bpy_struct):
    """Collection of spaces"""

    active: Space
    """ Space currently being displayed in this area

    :type: Space
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Armature(bpy_struct):
    """Armature data-block containing a hierarchy of bones, usually used for rigging characters"""

    animation_data: AnimData
    """ Animation data for this data-block

    :type: AnimData
    """

    axes_position: float
    """ The position for the axes on the bone. Increasing the value moves it closer to the tip; decreasing moves it closer to the root

    :type: float
    """

    bones: bpy_prop_collection[Bone]
    """ 

    :type: bpy_prop_collection[Bone]
    """

    collections: typing.Any
    """ """

    collections_all: bpy_prop_collection[BoneCollection]
    """ List of all bone collections of the armature

    :type: bpy_prop_collection[BoneCollection]
    """

    display_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    edit_bones: bpy_prop_collection[EditBone]
    """ 

    :type: bpy_prop_collection[EditBone]
    """

    is_editmode: typing.Union[bool, typing.Any]
    """ True when used in editmode

    :type: typing.Union[bool, typing.Any]
    """

    pose_position: typing.Union[str, int]
    """ Show armature in binding pose or final posed state

    :type: typing.Union[str, int]
    """

    relation_line_position: typing.Union[str, int]
    """ The start position of the relation lines from parent to child bones

    :type: typing.Union[str, int]
    """

    show_axes: bool
    """ Display bone axes

    :type: bool
    """

    show_bone_colors: bool
    """ Display bone colors

    :type: bool
    """

    show_bone_custom_shapes: bool
    """ Display bones with their custom shapes

    :type: bool
    """

    show_names: bool
    """ Display bone names

    :type: bool
    """

    use_mirror_x: bool
    """ Apply changes to matching bone on opposite side of X-Axis

    :type: bool
    """

    def transform(
        self,
        matrix: typing.Union[
            typing.List[typing.List[float]],
            typing.Tuple[
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
            ],
            mathutils.Matrix,
        ],
    ):
        """Transform armature bones by a matrix

        :param matrix: Matrix
        :type matrix: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArmatureBones(bpy_struct):
    """Collection of armature bones"""

    active: Bone
    """ Armature's active bone

    :type: Bone
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArmatureConstraint(bpy_struct):
    """Applies transformations done by the Armature modifier"""

    targets: bpy_prop_collection[ConstraintTargetBone]
    """ Target Bones

    :type: bpy_prop_collection[ConstraintTargetBone]
    """

    use_bone_envelopes: bool
    """ Multiply weights by envelope for all bones, instead of acting like Vertex Group based blending. The specified weights are still used, and only the listed bones are considered

    :type: bool
    """

    use_current_location: bool
    """ Use the current bone location for envelopes and choosing B-Bone segments instead of rest position

    :type: bool
    """

    use_deform_preserve_volume: bool
    """ Deform rotation interpolation with quaternions

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArmatureConstraintTargets(bpy_struct):
    """Collection of target bones and weights"""

    def new(self) -> bpy_struct:
        """Add a new target to the constraint

        :return: New target bone
        :rtype: ConstraintTargetBone
        """
        ...

    def remove(self, target: ConstraintTargetBone):
        """Delete target from the constraint

        :param target: Target to remove
        :type target: ConstraintTargetBone
        """
        ...

    def clear(self):
        """Delete all targets from object"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArmatureEditBones(bpy_struct):
    """Collection of armature edit bones"""

    active: EditBone
    """ Armatures active edit bone

    :type: EditBone
    """

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new bone

        :param name: New name for the bone
        :type name: typing.Union[str, typing.Any]
        :return: Newly created edit bone
        :rtype: EditBone
        """
        ...

    def remove(self, bone: EditBone):
        """Remove an existing bone from the armature

        :param bone: EditBone to remove
        :type bone: EditBone
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArmatureGpencilModifier(bpy_struct):
    """Change stroke using armature to deform modifier"""

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    object: Object
    """ Armature object to deform with

    :type: Object
    """

    use_bone_envelopes: bool
    """ Bind Bone envelopes to armature modifier

    :type: bool
    """

    use_deform_preserve_volume: bool
    """ Deform rotation interpolation with quaternions

    :type: bool
    """

    use_vertex_groups: bool
    """ Bind vertex groups to armature modifier

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Name of Vertex Group which determines influence of modifier per point

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArmatureModifier(bpy_struct):
    """Armature deformation modifier"""

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    object: Object
    """ Armature object to deform with

    :type: Object
    """

    use_bone_envelopes: bool
    """ Bind Bone envelopes to armature modifier

    :type: bool
    """

    use_deform_preserve_volume: bool
    """ Deform rotation interpolation with quaternions

    :type: bool
    """

    use_multi_modifier: bool
    """ Use same input as previous modifier, and mix results using overall vgroup

    :type: bool
    """

    use_vertex_groups: bool
    """ Bind vertex groups to armature modifier

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Name of Vertex Group which determines influence of modifier per point

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArrayGpencilModifier(bpy_struct):
    """Create grid of duplicate instances"""

    constant_offset: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Value for the distance between items

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    count: int
    """ Number of items

    :type: int
    """

    invert_layer_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_layers: bool
    """ Inverse filter

    :type: bool
    """

    invert_material_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_materials: bool
    """ Inverse filter

    :type: bool
    """

    layer: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    layer_pass: int
    """ Layer pass index

    :type: int
    """

    material: Material
    """ Material used for filtering effect

    :type: Material
    """

    offset_object: Object
    """ Use the location and rotation of another object to determine the distance and rotational change between arrayed items

    :type: Object
    """

    pass_index: int
    """ Pass index

    :type: int
    """

    random_offset: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Value for changes in location

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    random_rotation: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Euler
    ]
    """ Value for changes in rotation

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Euler]
    """

    random_scale: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Value for changes in scale

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    relative_offset: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ The size of the geometry will determine the distance between arrayed items

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    replace_material: int
    """ Index of the material used for generated strokes (0 keep original material)

    :type: int
    """

    seed: int
    """ Random seed

    :type: int
    """

    use_constant_offset: bool
    """ Enable offset

    :type: bool
    """

    use_object_offset: bool
    """ Enable object offset

    :type: bool
    """

    use_relative_offset: bool
    """ Enable shift

    :type: bool
    """

    use_uniform_random_scale: bool
    """ Use the same random seed for each scale axis for a uniform scale

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ArrayModifier(bpy_struct):
    """Array duplication modifier"""

    constant_offset_displace: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Value for the distance between arrayed items

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    count: int
    """ Number of duplicates to make

    :type: int
    """

    curve: Object
    """ Curve object to fit array length to

    :type: Object
    """

    end_cap: Object
    """ Mesh object to use as an end cap

    :type: Object
    """

    fit_length: float
    """ Length to fit array within

    :type: float
    """

    fit_type: typing.Union[str, int]
    """ Array length calculation method

    :type: typing.Union[str, int]
    """

    merge_threshold: float
    """ Limit below which to merge vertices

    :type: float
    """

    offset_object: Object
    """ Use the location and rotation of another object to determine the distance and rotational change between arrayed items

    :type: Object
    """

    offset_u: float
    """ Amount to offset array UVs on the U axis

    :type: float
    """

    offset_v: float
    """ Amount to offset array UVs on the V axis

    :type: float
    """

    relative_offset_displace: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ The size of the geometry will determine the distance between arrayed items

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    start_cap: Object
    """ Mesh object to use as a start cap

    :type: Object
    """

    use_constant_offset: bool
    """ Add a constant offset

    :type: bool
    """

    use_merge_vertices: bool
    """ Merge vertices in adjacent duplicates

    :type: bool
    """

    use_merge_vertices_cap: bool
    """ Merge vertices in first and last duplicates

    :type: bool
    """

    use_object_offset: bool
    """ Add another object's transformation to the total offset

    :type: bool
    """

    use_relative_offset: bool
    """ Add an offset relative to the object's bounding box

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetCatalogPath(bpy_struct):
    """ """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetHandle(bpy_struct):
    """Reference to some asset"""

    file_data: FileSelectEntry
    """ TEMPORARY, DO NOT USE - File data used to refer to the asset

    :type: FileSelectEntry
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetLibraryCollection(bpy_struct):
    """Collection of user asset libraries"""

    @classmethod
    def new(
        cls,
        name: typing.Union[str, typing.Any] = "",
        directory: typing.Union[str, typing.Any] = "",
    ) -> typing.Union[str, typing.Any]:
        """Add a new Asset Library

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param directory: Directory
        :type directory: typing.Union[str, typing.Any]
        :return: Newly added asset library
        :rtype: UserAssetLibrary
        """
        ...

    @classmethod
    def remove(cls, library: UserAssetLibrary):
        """Remove an Asset Library

        :param library:
        :type library: UserAssetLibrary
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetLibraryReference(bpy_struct):
    """Identifier to refer to the asset library"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetMetaData(bpy_struct):
    """Additional data stored for an asset data-block"""

    active_tag: int
    """ Index of the tag set for editing

    :type: int
    """

    author: typing.Union[str, typing.Any]
    """ Name of the creator of the asset

    :type: typing.Union[str, typing.Any]
    """

    catalog_id: typing.Union[str, typing.Any]
    """ Identifier for the asset's catalog, used by Blender to look up the asset's catalog path. Must be a UUID according to RFC4122

    :type: typing.Union[str, typing.Any]
    """

    catalog_simple_name: typing.Union[str, typing.Any]
    """ Simple name of the asset's catalog, for debugging and data recovery purposes

    :type: typing.Union[str, typing.Any]
    """

    copyright: typing.Union[str, typing.Any]
    """ Copyright notice for this asset. An empty copyright notice does not necessarily indicate that this is copyright-free. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    """

    description: typing.Union[str, typing.Any]
    """ A description of the asset to be displayed for the user

    :type: typing.Union[str, typing.Any]
    """

    license: typing.Union[str, typing.Any]
    """ The type of license this asset is distributed under. An empty license name does not necessarily indicate that this is free of licensing terms. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    """

    tags: bpy_prop_collection[AssetTag]
    """ Custom tags (name tokens) for the asset, used for filtering and general asset management

    :type: bpy_prop_collection[AssetTag]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetRepresentation(bpy_struct):
    """Information about an entity that makes it possible for the asset system to deal with the entity as asset"""

    full_library_path: typing.Union[str, typing.Any]
    """ Absolute path to the .blend file containing this asset

    :type: typing.Union[str, typing.Any]
    """

    full_path: typing.Union[str, typing.Any]
    """ Absolute path to the .blend file containing this asset extended with the path of the asset inside the file

    :type: typing.Union[str, typing.Any]
    """

    id_type: typing.Any
    """ The type of the data-block, if the asset represents one ('NONE' otherwise)

    :type: typing.Any
    """

    local_id: ID
    """ The local data-block this asset represents; only valid if that is a data-block in this file

    :type: ID
    """

    metadata: AssetMetaData
    """ Additional information about the asset

    :type: AssetMetaData
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetShelf(bpy_struct):
    """Regions for quick access to assets"""

    asset_library_reference: typing.Union[str, int]
    """ Choose the asset library to display assets from

    :type: typing.Union[str, int]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the asset gets a custom ID, otherwise it takes the name of the class used to define the asset (for example, if the class name is "OBJECT_AST_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_AST_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[str], typing.Set[int]]
    """ Options for this asset shelf type

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    """

    bl_space_type: typing.Any
    """ The space where the asset shelf is going to be used in"""

    preview_size: int
    """ Size of the asset preview thumbnails in pixels

    :type: int
    """

    search_filter: typing.Union[str, typing.Any]
    """ Filter assets by name

    :type: typing.Union[str, typing.Any]
    """

    show_names: bool
    """ Show the asset name together with the preview. Otherwise only the preview will be visible

    :type: bool
    """

    @classmethod
    def poll(cls, context: Context) -> Context:
        """If this method returns a non-null output, the asset shelf will be visible

        :param context:
        :type context: Context
        :return:
        :rtype: bool
        """
        ...

    @classmethod
    def asset_poll(cls, asset: AssetRepresentation) -> AssetRepresentation:
        """Determine if an asset should be visible in the asset shelf. If this method returns a non-null output, the asset will be visible

        :param asset:
        :type asset: AssetRepresentation
        :return:
        :rtype: bool
        """
        ...

    @classmethod
    def draw_context_menu(
        cls, context: Context, asset: AssetRepresentation, layout: UILayout
    ):
        """Draw UI elements into the context menu UI layout displayed on right click

        :param context:
        :type context: Context
        :param asset:
        :type asset: AssetRepresentation
        :param layout:
        :type layout: UILayout
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetTag(bpy_struct):
    """User defined tag (name token)"""

    name: typing.Union[str, typing.Any]
    """ The identifier that makes up this tag

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetTags(bpy_struct):
    """Collection of custom asset tags"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        skip_if_exists: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Add a new tag to this asset

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param skip_if_exists: Skip if Exists, Do not add a new tag if one of the same type already exists
        :type skip_if_exists: typing.Union[bool, typing.Any]
        :return: New tag
        :rtype: AssetTag
        """
        ...

    def remove(self, tag: AssetTag):
        """Remove an existing tag from this asset

        :param tag: Removed tag
        :type tag: AssetTag
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AssetWeakReference(bpy_struct):
    """Weak reference to some asset"""

    asset_library_identifier: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    asset_library_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    relative_asset_identifier: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Attribute(bpy_struct):
    """Geometry attribute"""

    data_type: typing.Any
    """ Type of data stored in attribute

    :type: typing.Any
    """

    domain: typing.Any
    """ Domain of the Attribute

    :type: typing.Any
    """

    is_internal: typing.Union[bool, typing.Any]
    """ The attribute is meant for internal use by Blender

    :type: typing.Union[bool, typing.Any]
    """

    is_required: typing.Union[bool, typing.Any]
    """ Whether the attribute can be removed or renamed

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the Attribute

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class AttributeGroup(bpy_struct):
    """Group of geometry attributes"""

    active: Attribute
    """ Active attribute

    :type: Attribute
    """

    active_color: Attribute
    """ Active color attribute for display and editing

    :type: Attribute
    """

    active_color_index: int
    """ Active color attribute index

    :type: int
    """

    active_color_name: typing.Union[str, typing.Any]
    """ The name of the active color attribute for display and editing

    :type: typing.Union[str, typing.Any]
    """

    active_index: int
    """ Active attribute index

    :type: int
    """

    default_color_name: typing.Union[str, typing.Any]
    """ The name of the default color attribute used as a fallback for rendering

    :type: typing.Union[str, typing.Any]
    """

    render_color_index: int
    """ The index of the color attribute used as a fallback for rendering

    :type: int
    """

    def new(self, name: typing.Union[str, typing.Any], type, domain):
        """Add attribute to geometry

        :param name: Name, Name of geometry attribute
        :type name: typing.Union[str, typing.Any]
        :param type: Type, Attribute type
        :param domain: Domain, Type of element that attribute is stored on
        :return: New geometry attribute
        :rtype: Attribute
        """
        ...

    def remove(self, attribute: Attribute):
        """Remove attribute from geometry

        :param attribute: Geometry Attribute
        :type attribute: Attribute
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BakeSettings(bpy_struct):
    """Bake data for a Scene data-block"""

    cage_extrusion: float
    """ Inflate the active object by the specified distance for baking. This helps matching to points nearer to the outside of the selected object meshes

    :type: float
    """

    cage_object: Object
    """ Object to use as cage instead of calculating the cage from the active object with cage extrusion

    :type: Object
    """

    filepath: typing.Union[str, typing.Any]
    """ Image filepath to use when saving externally

    :type: typing.Union[str, typing.Any]
    """

    height: int
    """ Vertical dimension of the baking map

    :type: int
    """

    image_settings: ImageFormatSettings
    """ 

    :type: ImageFormatSettings
    """

    margin: int
    """ Extends the baked result as a post process filter

    :type: int
    """

    margin_type: typing.Any
    """ Algorithm to extend the baked result"""

    max_ray_distance: float
    """ The maximum ray distance for matching points between the active and selected objects. If zero, there is no limit

    :type: float
    """

    normal_b: typing.Any
    """ Axis to bake in blue channel"""

    normal_g: typing.Any
    """ Axis to bake in green channel"""

    normal_r: typing.Any
    """ Axis to bake in red channel"""

    normal_space: typing.Any
    """ Choose normal space for baking"""

    pass_filter: typing.Any
    """ Passes to include in the active baking pass

    :type: typing.Any
    """

    save_mode: typing.Any
    """ Where to save baked image textures"""

    target: typing.Any
    """ Where to output the baked map"""

    use_automatic_name: bool
    """ Automatically name the output file with the pass type (external only)

    :type: bool
    """

    use_cage: bool
    """ Cast rays to active object from a cage

    :type: bool
    """

    use_clear: bool
    """ Clear Images before baking (internal only)

    :type: bool
    """

    use_pass_color: bool
    """ Color the pass

    :type: bool
    """

    use_pass_diffuse: bool
    """ Add diffuse contribution

    :type: bool
    """

    use_pass_direct: bool
    """ Add direct lighting contribution

    :type: bool
    """

    use_pass_emit: bool
    """ Add emission contribution

    :type: bool
    """

    use_pass_glossy: bool
    """ Add glossy contribution

    :type: bool
    """

    use_pass_indirect: bool
    """ Add indirect lighting contribution

    :type: bool
    """

    use_pass_transmission: bool
    """ Add transmission contribution

    :type: bool
    """

    use_selected_to_active: bool
    """ Bake shading on the surface of selected objects to the active object

    :type: bool
    """

    use_split_materials: bool
    """ Split external images per material (external only)

    :type: bool
    """

    view_from: typing.Union[str, int]
    """ Source of reflection ray directions

    :type: typing.Union[str, int]
    """

    width: int
    """ Horizontal dimension of the baking map

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BevelModifier(bpy_struct):
    """Bevel modifier to make edges and vertices more rounded"""

    affect: typing.Union[str, int]
    """ Affect edges or vertices

    :type: typing.Union[str, int]
    """

    angle_limit: float
    """ Angle above which to bevel edges

    :type: float
    """

    custom_profile: CurveProfile
    """ The path for the custom profile

    :type: CurveProfile
    """

    face_strength_mode: typing.Union[str, int]
    """ Whether to set face strength, and which faces to set it on

    :type: typing.Union[str, int]
    """

    harden_normals: bool
    """ Match normals of new faces to adjacent faces

    :type: bool
    """

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    limit_method: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    loop_slide: bool
    """ Prefer sliding along edges to having even widths

    :type: bool
    """

    mark_seam: bool
    """ Mark Seams along beveled edges

    :type: bool
    """

    mark_sharp: bool
    """ Mark beveled edges as sharp

    :type: bool
    """

    material: int
    """ Material index of generated faces, -1 for automatic

    :type: int
    """

    miter_inner: typing.Union[str, int]
    """ Pattern to use for inside of miters

    :type: typing.Union[str, int]
    """

    miter_outer: typing.Union[str, int]
    """ Pattern to use for outside of miters

    :type: typing.Union[str, int]
    """

    offset_type: typing.Union[str, int]
    """ What distance Width measures

    :type: typing.Union[str, int]
    """

    profile: float
    """ The profile shape (0.5 = round)

    :type: float
    """

    profile_type: typing.Union[str, int]
    """ The type of shape used to rebuild a beveled section

    :type: typing.Union[str, int]
    """

    segments: int
    """ Number of segments for round edges/verts

    :type: int
    """

    spread: float
    """ Spread distance for inner miter arcs

    :type: float
    """

    use_clamp_overlap: bool
    """ Clamp the width to avoid overlap

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Vertex group name

    :type: typing.Union[str, typing.Any]
    """

    vmesh_method: typing.Union[str, int]
    """ The method to use to create the mesh at intersections

    :type: typing.Union[str, int]
    """

    width: float
    """ Bevel amount

    :type: float
    """

    width_pct: float
    """ Bevel amount for percentage method

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BezierSplinePoint(bpy_struct):
    """Bézier curve point with two handles"""

    co: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Coordinates of the control point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    handle_left: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Coordinates of the first handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    handle_left_type: typing.Union[str, int]
    """ Handle types

    :type: typing.Union[str, int]
    """

    handle_right: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Coordinates of the second handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    handle_right_type: typing.Union[str, int]
    """ Handle types

    :type: typing.Union[str, int]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    radius: float
    """ Radius for beveling

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Handle 1 selection status

    :type: bool
    """

    select_right_handle: bool
    """ Handle 2 selection status

    :type: bool
    """

    tilt: float
    """ Tilt in 3D View

    :type: float
    """

    weight_softbody: float
    """ Softbody goal weight

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendData(bpy_struct):
    """Main data structure representing a .blend file and all its data-blocks"""

    actions: bpy_prop_collection[Action]
    """ Action data-blocks

    :type: bpy_prop_collection[Action]
    """

    armatures: bpy_prop_collection[Armature]
    """ Armature data-blocks

    :type: bpy_prop_collection[Armature]
    """

    brushes: bpy_prop_collection[Brush]
    """ Brush data-blocks

    :type: bpy_prop_collection[Brush]
    """

    cache_files: bpy_prop_collection[CacheFile]
    """ Cache Files data-blocks

    :type: bpy_prop_collection[CacheFile]
    """

    cameras: bpy_prop_collection[Camera]
    """ Camera data-blocks

    :type: bpy_prop_collection[Camera]
    """

    collections: bpy_prop_collection[Collection]
    """ Collection data-blocks

    :type: bpy_prop_collection[Collection]
    """

    curves: bpy_prop_collection[Curve]
    """ Curve data-blocks

    :type: bpy_prop_collection[Curve]
    """

    filepath: typing.Union[str, typing.Any]
    """ Path to the .blend file

    :type: typing.Union[str, typing.Any]
    """

    fonts: bpy_prop_collection[VectorFont]
    """ Vector font data-blocks

    :type: bpy_prop_collection[VectorFont]
    """

    grease_pencils: bpy_prop_collection[GreasePencil]
    """ Grease Pencil data-blocks

    :type: bpy_prop_collection[GreasePencil]
    """

    grease_pencils_v3: bpy_prop_collection[GreasePencilv3]
    """ Grease Pencil v3 data-blocks

    :type: bpy_prop_collection[GreasePencilv3]
    """

    hair_curves: bpy_prop_collection[Curves]
    """ Hair curve data-blocks

    :type: bpy_prop_collection[Curves]
    """

    images: bpy_prop_collection[Image]
    """ Image data-blocks

    :type: bpy_prop_collection[Image]
    """

    is_dirty: typing.Union[bool, typing.Any]
    """ Have recent edits been saved to disk

    :type: typing.Union[bool, typing.Any]
    """

    is_saved: typing.Union[bool, typing.Any]
    """ Has the current session been saved to disk as a .blend file

    :type: typing.Union[bool, typing.Any]
    """

    lattices: bpy_prop_collection[Lattice]
    """ Lattice data-blocks

    :type: bpy_prop_collection[Lattice]
    """

    libraries: bpy_prop_collection[Library]
    """ Library data-blocks

    :type: bpy_prop_collection[Library]
    """

    lightprobes: bpy_prop_collection[LightProbe]
    """ Light Probe data-blocks

    :type: bpy_prop_collection[LightProbe]
    """

    lights: bpy_prop_collection[Light]
    """ Light data-blocks

    :type: bpy_prop_collection[Light]
    """

    linestyles: bpy_prop_collection[FreestyleLineStyle]
    """ Line Style data-blocks

    :type: bpy_prop_collection[FreestyleLineStyle]
    """

    masks: bpy_prop_collection[Mask]
    """ Masks data-blocks

    :type: bpy_prop_collection[Mask]
    """

    materials: bpy_prop_collection[Material]
    """ Material data-blocks

    :type: bpy_prop_collection[Material]
    """

    meshes: bpy_prop_collection[Mesh]
    """ Mesh data-blocks

    :type: bpy_prop_collection[Mesh]
    """

    metaballs: bpy_prop_collection[MetaBall]
    """ Metaball data-blocks

    :type: bpy_prop_collection[MetaBall]
    """

    movieclips: bpy_prop_collection[MovieClip]
    """ Movie Clip data-blocks

    :type: bpy_prop_collection[MovieClip]
    """

    node_groups: bpy_prop_collection[NodeTree]
    """ Node group data-blocks

    :type: bpy_prop_collection[NodeTree]
    """

    objects: bpy_prop_collection[Object]
    """ Object data-blocks

    :type: bpy_prop_collection[Object]
    """

    paint_curves: bpy_prop_collection[PaintCurve]
    """ Paint Curves data-blocks

    :type: bpy_prop_collection[PaintCurve]
    """

    palettes: bpy_prop_collection[Palette]
    """ Palette data-blocks

    :type: bpy_prop_collection[Palette]
    """

    particles: bpy_prop_collection[ParticleSettings]
    """ Particle data-blocks

    :type: bpy_prop_collection[ParticleSettings]
    """

    pointclouds: bpy_prop_collection[PointCloud]
    """ Point cloud data-blocks

    :type: bpy_prop_collection[PointCloud]
    """

    scenes: bpy_prop_collection[Scene]
    """ Scene data-blocks

    :type: bpy_prop_collection[Scene]
    """

    screens: bpy_prop_collection[Screen]
    """ Screen data-blocks

    :type: bpy_prop_collection[Screen]
    """

    shape_keys: bpy_prop_collection[Key]
    """ Shape Key data-blocks

    :type: bpy_prop_collection[Key]
    """

    sounds: bpy_prop_collection[Sound]
    """ Sound data-blocks

    :type: bpy_prop_collection[Sound]
    """

    speakers: bpy_prop_collection[Speaker]
    """ Speaker data-blocks

    :type: bpy_prop_collection[Speaker]
    """

    texts: bpy_prop_collection[Text]
    """ Text data-blocks

    :type: bpy_prop_collection[Text]
    """

    textures: bpy_prop_collection[Texture]
    """ Texture data-blocks

    :type: bpy_prop_collection[Texture]
    """

    use_autopack: bool
    """ Automatically pack all external data into .blend file

    :type: bool
    """

    version: bpy_prop_array[int]
    """ File format version the .blend file was saved with

    :type: bpy_prop_array[int]
    """

    volumes: bpy_prop_collection[Volume]
    """ Volume data-blocks

    :type: bpy_prop_collection[Volume]
    """

    window_managers: bpy_prop_collection[WindowManager]
    """ Window manager data-blocks

    :type: bpy_prop_collection[WindowManager]
    """

    workspaces: bpy_prop_collection[WorkSpace]
    """ Workspace data-blocks

    :type: bpy_prop_collection[WorkSpace]
    """

    worlds: bpy_prop_collection[World]
    """ World data-blocks

    :type: bpy_prop_collection[World]
    """

    def batch_remove(self, ids):
        """Remove (delete) several IDs at once.WARNING: Considered experimental feature currently.Note that this function is quicker than individual calls to `remove()` (from `bpy.types.BlendData`
        ID collections), but less safe/versatile (it can break Blender, e.g. by removing all scenes...).

                :param ids: Iterables of IDs (types can be mixed).
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

    def orphans_purge(self) -> typing.Any:
        """Remove (delete) all IDs with no user.

        :return: The number of deleted IDs.
        """
        ...

    def temp_data(
        self, filepath: typing.Union[str, bytes] = None
    ) -> typing.Union[str, bytes]:
        """A context manager that temporarily creates blender file data.

        :param filepath: The file path for the newly temporary data. When None, the path of the currently open file is used.
        :type filepath: typing.Union[str, bytes]
        :return: Blend file data which is freed once the context exists.
        :rtype: BlendData
        """
        ...

    def user_map(
        self,
        subset: typing.Sequence,
        key_types: typing.Set[str],
        value_types: typing.Set[str],
    ) -> typing.Set[str]:
        """Returns a mapping of all ID data-blocks in current bpy.data to a set of all datablocks using them.For list of valid set members for key_types & value_types, see: `bpy.types.KeyingSetPath.id_type`.

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map.
        :type subset: typing.Sequence
        :param key_types: Filter the keys mapped by ID types.
        :type key_types: typing.Set[str]
        :param value_types: Filter the values in the set by ID types.
        :type value_types: typing.Set[str]
        :return: dictionary of `bpy.types.ID` instances, with sets of ID's as their values.
        :rtype: dict
        """
        ...

class BlendDataActions(bpy_struct):
    """Collection of actions"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new action to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New action data-block
        :rtype: Action
        """
        ...

    def remove(
        self,
        action: Action,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove an action from the current blendfile

        :param action: Action to remove
        :type action: Action
        :param do_unlink: Unlink all usages of this action before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this action
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this action
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataArmatures(bpy_struct):
    """Collection of armatures"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new armature to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New armature data-block
        :rtype: Armature
        """
        ...

    def remove(
        self,
        armature: Armature,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove an armature from the current blendfile

        :param armature: Armature to remove
        :type armature: Armature
        :param do_unlink: Unlink all usages of this armature before deleting it (WARNING: will also delete objects instancing that armature data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this armature data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this armature data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataBrushes(bpy_struct):
    """Collection of brushes"""

    def new(
        self, name: typing.Union[str, typing.Any], mode: typing.Any = "TEXTURE_PAINT"
    ) -> typing.Any:
        """Add a new brush to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param mode: Paint Mode for the new brush
        :type mode: typing.Any
        :return: New brush data-block
        :rtype: Brush
        """
        ...

    def remove(
        self,
        brush: Brush,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a brush from the current blendfile

        :param brush: Brush to remove
        :type brush: Brush
        :param do_unlink: Unlink all usages of this brush before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this brush
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this brush
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    def create_gpencil_data(self, brush: Brush):
        """Add grease pencil brush settings

        :param brush: Brush
        :type brush: Brush
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataCacheFiles(bpy_struct):
    """Collection of cache files"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataCameras(bpy_struct):
    """Collection of cameras"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new camera to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New camera data-block
        :rtype: Camera
        """
        ...

    def remove(
        self,
        camera: Camera,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a camera from the current blendfile

        :param camera: Camera to remove
        :type camera: Camera
        :param do_unlink: Unlink all usages of this camera before deleting it (WARNING: will also delete objects instancing that camera data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this camera
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this camera
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataCollections(bpy_struct):
    """Collection of collections"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new collection to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New collection data-block
        :rtype: Collection
        """
        ...

    def remove(
        self,
        collection: Collection,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a collection from the current blendfile

        :param collection: Collection to remove
        :type collection: Collection
        :param do_unlink: Unlink all usages of this collection before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this collection
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this collection
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataCurves(bpy_struct):
    """Collection of curves"""

    def new(self, name: typing.Union[str, typing.Any], type):
        """Add a new curve to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of curve to add
        :return: New curve data-block
        :rtype: Curve
        """
        ...

    def remove(
        self,
        curve: Curve,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a curve from the current blendfile

        :param curve: Curve to remove
        :type curve: Curve
        :param do_unlink: Unlink all usages of this curve before deleting it (WARNING: will also delete objects instancing that curve data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this curve data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this curve data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataFonts(bpy_struct):
    """Collection of fonts"""

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Load a new font into the main database

        :param filepath: path of the font to load
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Union[bool, typing.Any]
        :return: New font data-block
        :rtype: VectorFont
        """
        ...

    def remove(
        self,
        vfont: VectorFont,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a font from the current blendfile

        :param vfont: Font to remove
        :type vfont: VectorFont
        :param do_unlink: Unlink all usages of this font before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this font
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this font
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataGreasePencils(bpy_struct):
    """Collection of grease pencils"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new grease pencil datablock to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New grease pencil data-block
        :rtype: GreasePencil
        """
        ...

    def remove(
        self,
        grease_pencil: GreasePencil,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a grease pencil instance from the current blendfile

        :param grease_pencil: Grease Pencil to remove
        :type grease_pencil: GreasePencil
        :param do_unlink: Unlink all usages of this grease pencil before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this grease pencil
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this grease pencil
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataGreasePencilsV3(bpy_struct):
    """Collection of grease pencils"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataHairCurves(bpy_struct):
    """Collection of hair curves"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new hair to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New curves data-block
        :rtype: Curves
        """
        ...

    def remove(
        self,
        curves: Curves,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a curves data-block from the current blendfile

        :param curves: Curves data-block to remove
        :type curves: Curves
        :param do_unlink: Unlink all usages of this curves before deleting it (WARNING: will also delete objects instancing that curves data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this curves data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this curves data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataImages(bpy_struct):
    """Collection of images"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        width: int,
        height: int,
        alpha: typing.Union[bool, typing.Any] = False,
        float_buffer: typing.Union[bool, typing.Any] = False,
        stereo3d: typing.Union[bool, typing.Any] = False,
        is_data: typing.Union[bool, typing.Any] = False,
        tiled: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Add a new image to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param width: Width of the image
        :type width: int
        :param height: Height of the image
        :type height: int
        :param alpha: Alpha, Use alpha channel
        :type alpha: typing.Union[bool, typing.Any]
        :param float_buffer: Float Buffer, Create an image with floating-point color
        :type float_buffer: typing.Union[bool, typing.Any]
        :param stereo3d: Stereo 3D, Create left and right views
        :type stereo3d: typing.Union[bool, typing.Any]
        :param is_data: Is Data, Create image with non-color data color space
        :type is_data: typing.Union[bool, typing.Any]
        :param tiled: Tiled, Create a tiled image
        :type tiled: typing.Union[bool, typing.Any]
        :return: New image data-block
        :rtype: Image
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Load a new image into the main database

        :param filepath: Path of the file to load
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Union[bool, typing.Any]
        :return: New image data-block
        :rtype: Image
        """
        ...

    def remove(
        self,
        image: Image,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove an image from the current blendfile

        :param image: Image to remove
        :type image: Image
        :param do_unlink: Unlink all usages of this image before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this image
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this image
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataLattices(bpy_struct):
    """Collection of lattices"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new lattice to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New lattice data-block
        :rtype: Lattice
        """
        ...

    def remove(
        self,
        lattice: Lattice,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a lattice from the current blendfile

        :param lattice: Lattice to remove
        :type lattice: Lattice
        :param do_unlink: Unlink all usages of this lattice before deleting it (WARNING: will also delete objects instancing that lattice data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this lattice data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this lattice data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataLibraries(bpy_struct):
    """Collection of libraries"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    def remove(
        self,
        library: Library,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a library from the current blendfile

        :param library: Library to remove
        :type library: Library
        :param do_unlink: Unlink all usages of this library before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this library
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this library
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, bytes],
        link: bool = False,
        relative: bool = False,
        assets_only: bool = False,
        create_liboverrides: bool = False,
        reuse_liboverrides: bool = False,
        create_liboverrides_runtime: bool = False,
    ):
        """Returns a context manager which exposes 2 library objects on entering.
        Each object has attributes matching bpy.data which are lists of strings to be linked.

                :param filepath: The path to a blend file.
                :type filepath: typing.Union[str, bytes]
                :param link: When False reference to the original file is lost.
                :type link: bool
                :param relative: When True the path is stored relative to the open blend file.
                :type relative: bool
                :param assets_only: If True, only list data-blocks marked as assets.
                :type assets_only: bool
                :param create_liboverrides: If True and link is True, liboverrides will
        be created for linked data.
                :type create_liboverrides: bool
                :param reuse_liboverrides: If True and create_liboverride is True,
        search for existing liboverride first.
                :type reuse_liboverrides: bool
                :param create_liboverrides_runtime: If True and create_liboverride is True,
        create (or search for existing) runtime liboverride.
                :type create_liboverrides_runtime: bool
        """
        ...

    def write(
        self,
        filepath: typing.Union[str, bytes],
        datablocks: set,
        path_remap: str = False,
        fake_user: bool = False,
        compress: bool = False,
    ):
        """Write data-blocks into a blend file.

                :param filepath: The path to write the blend-file.
                :type filepath: typing.Union[str, bytes]
                :param datablocks: set of data-blocks (`bpy.types.ID` instances).
                :type datablocks: set
                :param path_remap: Optionally remap paths when writing the file:

        NONE No path manipulation (default).

        RELATIVE Remap paths that are already relative to the new location.

        RELATIVE_ALL Remap all paths to be relative to the new location.

        ABSOLUTE Make all paths absolute on writing.
                :type path_remap: str
                :param fake_user: When True, data-blocks will be written with fake-user flag enabled.
                :type fake_user: bool
                :param compress: When True, write a compressed blend file.
                :type compress: bool
        """
        ...

class BlendDataLights(bpy_struct):
    """Collection of lights"""

    def new(self, name: typing.Union[str, typing.Any], type):
        """Add a new light to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of light to add
        :return: New light data-block
        :rtype: Light
        """
        ...

    def remove(
        self,
        light: Light,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a light from the current blendfile

        :param light: Light to remove
        :type light: Light
        :param do_unlink: Unlink all usages of this light before deleting it (WARNING: will also delete objects instancing that light data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this light data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this light data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataLineStyles(bpy_struct):
    """Collection of line styles"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new line style instance to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New line style data-block
        :rtype: FreestyleLineStyle
        """
        ...

    def remove(
        self,
        linestyle: FreestyleLineStyle,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a line style instance from the current blendfile

        :param linestyle: Line style to remove
        :type linestyle: FreestyleLineStyle
        :param do_unlink: Unlink all usages of this line style before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this line style
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this line style
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataMasks(bpy_struct):
    """Collection of masks"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new mask with a given name to the main database

        :param name: Mask, Name of new mask data-block
        :type name: typing.Union[str, typing.Any]
        :return: New mask data-block
        :rtype: Mask
        """
        ...

    def remove(
        self,
        mask: Mask,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a mask from the current blendfile

        :param mask: Mask to remove
        :type mask: Mask
        :param do_unlink: Unlink all usages of this mask before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this mask
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this mask
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataMaterials(bpy_struct):
    """Collection of materials"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new material to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New material data-block
        :rtype: Material
        """
        ...

    def create_gpencil_data(self, material: Material):
        """Add grease pencil material settings

        :param material: Material
        :type material: Material
        """
        ...

    def remove_gpencil_data(self, material: Material):
        """Remove grease pencil material settings

        :param material: Material
        :type material: Material
        """
        ...

    def remove(
        self,
        material: Material,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a material from the current blendfile

        :param material: Material to remove
        :type material: Material
        :param do_unlink: Unlink all usages of this material before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this material
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this material
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataMeshes(bpy_struct):
    """Collection of meshes"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new mesh to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New mesh data-block
        :rtype: Mesh
        """
        ...

    def new_from_object(
        self,
        object: Object,
        preserve_all_data_layers: typing.Union[bool, typing.Any] = False,
        depsgraph: Depsgraph = None,
    ) -> Depsgraph:
        """Add a new mesh created from given object (undeformed geometry if object is original, and final evaluated geometry, with all modifiers etc., if object is evaluated)

        :param object: Object to create mesh from
        :type object: Object
        :param preserve_all_data_layers: Preserve all data layers in the mesh, like UV maps and vertex groups. By default Blender only computes the subset of data layers needed for viewport display and rendering, for better performance
        :type preserve_all_data_layers: typing.Union[bool, typing.Any]
        :param depsgraph: Dependency Graph, Evaluated dependency graph which is required when preserve_all_data_layers is true
        :type depsgraph: Depsgraph
        :return: Mesh created from object, remove it if it is only used for export
        :rtype: Mesh
        """
        ...

    def remove(
        self,
        mesh: Mesh,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a mesh from the current blendfile

        :param mesh: Mesh to remove
        :type mesh: Mesh
        :param do_unlink: Unlink all usages of this mesh before deleting it (WARNING: will also delete objects instancing that mesh data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this mesh data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this mesh data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataMetaBalls(bpy_struct):
    """Collection of metaballs"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new metaball to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New metaball data-block
        :rtype: MetaBall
        """
        ...

    def remove(
        self,
        metaball: MetaBall,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a metaball from the current blendfile

        :param metaball: Metaball to remove
        :type metaball: MetaBall
        :param do_unlink: Unlink all usages of this metaball before deleting it (WARNING: will also delete objects instancing that metaball data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this metaball data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this metaball data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataMovieClips(bpy_struct):
    """Collection of movie clips"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    def remove(
        self,
        clip: MovieClip,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a movie clip from the current blendfile.

        :param clip: Movie clip to remove
        :type clip: MovieClip
        :param do_unlink: Unlink all usages of this movie clip before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this movie clip
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this movie clip
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Add a new movie clip to the main database from a file (while check_existing is disabled for consistency with other load functions, behavior with multiple movie-clips using the same file may incorrectly generate proxies)

        :param filepath: path for the data-block
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Union[bool, typing.Any]
        :return: New movie clip data-block
        :rtype: MovieClip
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataNodeTrees(bpy_struct):
    """Collection of node trees"""

    def new(
        self, name: typing.Union[str, typing.Any], type: typing.Union[str, int]
    ) -> typing.Union[str, int]:
        """Add a new node tree to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of node_group to add
        :type type: typing.Union[str, int]
        :return: New node tree data-block
        :rtype: NodeTree
        """
        ...

    def remove(
        self,
        tree: NodeTree,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a node tree from the current blendfile

        :param tree: Node tree to remove
        :type tree: NodeTree
        :param do_unlink: Unlink all usages of this node tree before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this node tree
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this node tree
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataObjects(bpy_struct):
    """Collection of objects"""

    def new(self, name: typing.Union[str, typing.Any], object_data: ID) -> ID:
        """Add a new object to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param object_data: Object data or None for an empty object
        :type object_data: ID
        :return: New object data-block
        :rtype: Object
        """
        ...

    def remove(
        self,
        object: Object,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove an object from the current blendfile

        :param object: Object to remove
        :type object: Object
        :param do_unlink: Unlink all usages of this object before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this object
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this object
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataPaintCurves(bpy_struct):
    """Collection of paint curves"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataPalettes(bpy_struct):
    """Collection of palettes"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new palette to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New palette data-block
        :rtype: Palette
        """
        ...

    def remove(
        self,
        palette: Palette,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a palette from the current blendfile

        :param palette: Palette to remove
        :type palette: Palette
        :param do_unlink: Unlink all usages of this palette before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this palette
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this palette
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataParticles(bpy_struct):
    """Collection of particle settings"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new particle settings instance to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New particle settings data-block
        :rtype: ParticleSettings
        """
        ...

    def remove(
        self,
        particle: ParticleSettings,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a particle settings instance from the current blendfile

        :param particle: Particle Settings to remove
        :type particle: ParticleSettings
        :param do_unlink: Unlink all usages of those particle settings before deleting them
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this particle settings
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this particle settings
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataPointClouds(bpy_struct):
    """Collection of point clouds"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new point cloud to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New point cloud data-block
        :rtype: PointCloud
        """
        ...

    def remove(
        self,
        pointcloud: PointCloud,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a point cloud from the current blendfile

        :param pointcloud: Point cloud to remove
        :type pointcloud: PointCloud
        :param do_unlink: Unlink all usages of this point cloud before deleting it (WARNING: will also delete objects instancing that point cloud data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this point cloud data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this point cloud data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataProbes(bpy_struct):
    """Collection of light probes"""

    def new(self, name: typing.Union[str, typing.Any], type):
        """Add a new light probe to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of light probe to add
        :return: New light probe data-block
        :rtype: LightProbe
        """
        ...

    def remove(
        self,
        lightprobe: LightProbe,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a light probe from the current blendfile

        :param lightprobe: Light probe to remove
        :type lightprobe: LightProbe
        :param do_unlink: Unlink all usages of this light probe before deleting it (WARNING: will also delete objects instancing that light probe data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this light probe
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this light probe
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataScenes(bpy_struct):
    """Collection of scenes"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new scene to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New scene data-block
        :rtype: Scene
        """
        ...

    def remove(self, scene: Scene, do_unlink: typing.Union[bool, typing.Any] = True):
        """Remove a scene from the current blendfile

        :param scene: Scene to remove
        :type scene: Scene
        :param do_unlink: Unlink all usages of this scene before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataScreens(bpy_struct):
    """Collection of screens"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataSounds(bpy_struct):
    """Collection of sounds"""

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Add a new sound to the main database from a file

        :param filepath: path for the data-block
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Union[bool, typing.Any]
        :return: New text data-block
        :rtype: Sound
        """
        ...

    def remove(
        self,
        sound: Sound,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a sound from the current blendfile

        :param sound: Sound to remove
        :type sound: Sound
        :param do_unlink: Unlink all usages of this sound before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this sound
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this sound
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataSpeakers(bpy_struct):
    """Collection of speakers"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new speaker to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New speaker data-block
        :rtype: Speaker
        """
        ...

    def remove(
        self,
        speaker: Speaker,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a speaker from the current blendfile

        :param speaker: Speaker to remove
        :type speaker: Speaker
        :param do_unlink: Unlink all usages of this speaker before deleting it (WARNING: will also delete objects instancing that speaker data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this speaker data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this speaker data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataTexts(bpy_struct):
    """Collection of texts"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new text to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New text data-block
        :rtype: Text
        """
        ...

    def remove(
        self,
        text: Text,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a text from the current blendfile

        :param text: Text to remove
        :type text: Text
        :param do_unlink: Unlink all usages of this text before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this text
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this text
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        internal: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Add a new text to the main database from a file

        :param filepath: path for the data-block
        :type filepath: typing.Union[str, typing.Any]
        :param internal: Make internal, Make text file internal after loading
        :type internal: typing.Union[bool, typing.Any]
        :return: New text data-block
        :rtype: Text
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataTextures(bpy_struct):
    """Collection of textures"""

    def new(self, name: typing.Union[str, typing.Any], type):
        """Add a new texture to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of texture to add
        :return: New texture data-block
        :rtype: Texture
        """
        ...

    def remove(
        self,
        texture: Texture,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a texture from the current blendfile

        :param texture: Texture to remove
        :type texture: Texture
        :param do_unlink: Unlink all usages of this texture before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this texture
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this texture
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataVolumes(bpy_struct):
    """Collection of volumes"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new volume to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New volume data-block
        :rtype: Volume
        """
        ...

    def remove(
        self,
        volume: Volume,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a volume from the current blendfile

        :param volume: Volume to remove
        :type volume: Volume
        :param do_unlink: Unlink all usages of this volume before deleting it (WARNING: will also delete objects instancing that volume data)
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this volume data
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this volume data
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataWindowManagers(bpy_struct):
    """Collection of window managers"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataWorkSpaces(bpy_struct):
    """Collection of workspaces"""

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendDataWorlds(bpy_struct):
    """Collection of worlds"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a new world to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :return: New world data-block
        :rtype: World
        """
        ...

    def remove(
        self,
        world: World,
        do_unlink: typing.Union[bool, typing.Any] = True,
        do_id_user: typing.Union[bool, typing.Any] = True,
        do_ui_user: typing.Union[bool, typing.Any] = True,
    ):
        """Remove a world from the current blendfile

        :param world: World to remove
        :type world: World
        :param do_unlink: Unlink all usages of this world before deleting it
        :type do_unlink: typing.Union[bool, typing.Any]
        :param do_id_user: Decrement user counter of all datablocks used by this world
        :type do_id_user: typing.Union[bool, typing.Any]
        :param do_ui_user: Make sure interface does not reference this world
        :type do_ui_user: typing.Union[bool, typing.Any]
        """
        ...

    def tag(self, value: bool):
        """tag

        :param value: Value
        :type value: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlendTexture(bpy_struct):
    """Procedural color blending texture"""

    progression: typing.Union[str, int]
    """ Style of the color blending

    :type: typing.Union[str, int]
    """

    use_flip_axis: typing.Union[str, int]
    """ Flip the texture's X and Y axis

    :type: typing.Union[str, int]
    """

    users_material: typing.Any
    """ Materials that use this texture(readonly)"""

    users_object_modifier: typing.Any
    """ Object modifiers that use this texture(readonly)"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BlenderRNA(bpy_struct):
    """Blender RNA structure definitions"""

    structs: bpy_prop_collection[Struct]
    """ 

    :type: bpy_prop_collection[Struct]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRule(bpy_struct):
    """ """

    name: typing.Union[str, typing.Any]
    """ Boid rule name

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    use_in_air: bool
    """ Use rule when boid is flying

    :type: bool
    """

    use_on_land: bool
    """ Use rule when boid is on land

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRuleAverageSpeed(bpy_struct):
    """ """

    level: float
    """ How much velocity's z-component is kept constant

    :type: float
    """

    speed: float
    """ Percentage of maximum speed

    :type: float
    """

    wander: float
    """ How fast velocity's direction is randomized

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRuleAvoid(bpy_struct):
    """ """

    fear_factor: float
    """ Avoid object if danger from it is above this threshold

    :type: float
    """

    object: Object
    """ Object to avoid

    :type: Object
    """

    use_predict: bool
    """ Predict target movement

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRuleAvoidCollision(bpy_struct):
    """ """

    look_ahead: float
    """ Time to look ahead in seconds

    :type: float
    """

    use_avoid: bool
    """ Avoid collision with other boids

    :type: bool
    """

    use_avoid_collision: bool
    """ Avoid collision with deflector objects

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRuleFight(bpy_struct):
    """ """

    distance: float
    """ Attack boids at max this distance

    :type: float
    """

    flee_distance: float
    """ Flee to this distance

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRuleFollowLeader(bpy_struct):
    """ """

    distance: float
    """ Distance behind leader to follow

    :type: float
    """

    object: Object
    """ Follow this object instead of a boid

    :type: Object
    """

    queue_count: int
    """ How many boids in a line

    :type: int
    """

    use_line: bool
    """ Follow leader in a line

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidRuleGoal(bpy_struct):
    """ """

    object: Object
    """ Goal object

    :type: Object
    """

    use_predict: bool
    """ Predict target movement

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidSettings(bpy_struct):
    """Settings for boid physics"""

    accuracy: float
    """ Accuracy of attack

    :type: float
    """

    active_boid_state: BoidRule
    """ 

    :type: BoidRule
    """

    active_boid_state_index: int
    """ 

    :type: int
    """

    aggression: float
    """ Boid will fight this times stronger enemy

    :type: float
    """

    air_acc_max: float
    """ Maximum acceleration in air (relative to maximum speed)

    :type: float
    """

    air_ave_max: float
    """ Maximum angular velocity in air (relative to 180 degrees)

    :type: float
    """

    air_personal_space: float
    """ Radius of boids personal space in air (% of particle size)

    :type: float
    """

    air_speed_max: float
    """ Maximum speed in air

    :type: float
    """

    air_speed_min: float
    """ Minimum speed in air (relative to maximum speed)

    :type: float
    """

    bank: float
    """ Amount of rotation around velocity vector on turns

    :type: float
    """

    health: float
    """ Initial boid health when born

    :type: float
    """

    height: float
    """ Boid height relative to particle size

    :type: float
    """

    land_acc_max: float
    """ Maximum acceleration on land (relative to maximum speed)

    :type: float
    """

    land_ave_max: float
    """ Maximum angular velocity on land (relative to 180 degrees)

    :type: float
    """

    land_jump_speed: float
    """ Maximum speed for jumping

    :type: float
    """

    land_personal_space: float
    """ Radius of boids personal space on land (% of particle size)

    :type: float
    """

    land_smooth: float
    """ How smoothly the boids land

    :type: float
    """

    land_speed_max: float
    """ Maximum speed on land

    :type: float
    """

    land_stick_force: float
    """ How strong a force must be to start effecting a boid on land

    :type: float
    """

    pitch: float
    """ Amount of rotation around side vector

    :type: float
    """

    range: float
    """ Maximum distance from which a boid can attack

    :type: float
    """

    states: bpy_prop_collection[BoidState]
    """ 

    :type: bpy_prop_collection[BoidState]
    """

    strength: float
    """ Maximum caused damage on attack per second

    :type: float
    """

    use_climb: bool
    """ Allow boids to climb goal objects

    :type: bool
    """

    use_flight: bool
    """ Allow boids to move in air

    :type: bool
    """

    use_land: bool
    """ Allow boids to move on land

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoidState(bpy_struct):
    """Boid state for boid physics"""

    active_boid_rule: BoidRule
    """ 

    :type: BoidRule
    """

    active_boid_rule_index: int
    """ 

    :type: int
    """

    falloff: float
    """ 

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ Boid state name

    :type: typing.Union[str, typing.Any]
    """

    rule_fuzzy: float
    """ 

    :type: float
    """

    rules: bpy_prop_collection[BoidRule]
    """ 

    :type: bpy_prop_collection[BoidRule]
    """

    ruleset_type: typing.Union[str, int]
    """ How the rules in the list are evaluated

    :type: typing.Union[str, int]
    """

    volume: float
    """ 

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Bone(bpy_struct):
    """Bone in an Armature data-block"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: Bone
    """ Bone that serves as the end handle for the B-Bone curve

    :type: Bone
    """

    bbone_custom_handle_start: Bone
    """ Bone that serves as the start handle for the B-Bone curve

    :type: Bone
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_handle_type_end: typing.Union[str, int]
    """ Selects how the end handle of the B-Bone is computed

    :type: typing.Union[str, int]
    """

    bbone_handle_type_start: typing.Union[str, int]
    """ Selects how the start handle of the B-Bone is computed

    :type: typing.Union[str, int]
    """

    bbone_handle_use_ease_end: bool
    """ Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_ease_start: bool
    """ Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_scale_end: typing.List[bool]
    """ Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_handle_use_scale_start: typing.List[bool]
    """ Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_mapping_mode: typing.Union[str, int]
    """ Selects how the vertices are mapped to B-Bone segments based on their position

    :type: typing.Union[str, int]
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    bbone_scaleout: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    bbone_segments: int
    """ Number of subdivisions of bone (for B-Bones only)

    :type: int
    """

    bbone_x: float
    """ B-Bone X size

    :type: float
    """

    bbone_z: float
    """ B-Bone Z size

    :type: float
    """

    children: bpy_prop_collection[Bone]
    """ Bones which are children of this bone

    :type: bpy_prop_collection[Bone]
    """

    collections: bpy_prop_collection[BoneCollection]
    """ Bone Collections that contain this bone

    :type: bpy_prop_collection[BoneCollection]
    """

    color: BoneColor
    """ 

    :type: BoneColor
    """

    envelope_distance: float
    """ Bone deformation distance (for Envelope deform only)

    :type: float
    """

    envelope_weight: float
    """ Bone deformation weight (for Envelope deform only)

    :type: float
    """

    head: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Location of head end of the bone relative to its parent

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    head_local: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Location of head end of the bone relative to armature

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    head_radius: float
    """ Radius of head of bone (for Envelope deform only)

    :type: float
    """

    hide: bool
    """ Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes)

    :type: bool
    """

    hide_select: bool
    """ Bone is able to be selected

    :type: bool
    """

    inherit_scale: typing.Union[str, int]
    """ Specifies how the bone inherits scaling from the parent bone

    :type: typing.Union[str, int]
    """

    length: float
    """ Length of the bone

    :type: float
    """

    matrix: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ 3×3 bone matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]], mathutils.Matrix]
    """

    matrix_local: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ 4×4 bone matrix relative to armature

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: Bone
    """ Parent bone (in same Armature)

    :type: Bone
    """

    select: bool
    """ 

    :type: bool
    """

    select_head: bool
    """ 

    :type: bool
    """

    select_tail: bool
    """ 

    :type: bool
    """

    show_wire: bool
    """ Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    """

    tail: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Location of tail end of the bone relative to its parent

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    tail_local: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Location of tail end of the bone relative to armature

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    tail_radius: float
    """ Radius of tail of bone (for Envelope deform only)

    :type: float
    """

    use_connect: typing.Union[bool, typing.Any]
    """ When bone has a parent, bone's head is stuck to the parent's tail

    :type: typing.Union[bool, typing.Any]
    """

    use_cyclic_offset: bool
    """ When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    """

    use_deform: bool
    """ Enable Bone to deform geometry

    :type: bool
    """

    use_endroll_as_inroll: bool
    """ Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    """

    use_envelope_multiply: bool
    """ When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    """

    use_inherit_rotation: bool
    """ Bone inherits rotation or scale from parent bone

    :type: bool
    """

    use_local_location: bool
    """ Bone location is set in local space

    :type: bool
    """

    use_relative_parent: bool
    """ Object children will use relative transform, like deform

    :type: bool
    """

    use_scale_easing: bool
    """ Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def evaluate_envelope(
        self,
        point: typing.Union[
            typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
        ],
    ) -> typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]:
        """Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
        :return: Factor, Envelope factor
        :rtype: float
        """
        ...

    def convert_local_to_pose(
        self,
        matrix: typing.Union[
            typing.List[typing.List[float]],
            typing.Tuple[
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
            ],
            mathutils.Matrix,
        ],
        matrix_local: typing.Union[
            typing.List[typing.List[float]],
            typing.Tuple[
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
            ],
            mathutils.Matrix,
        ],
        parent_matrix: typing.Any = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        parent_matrix_local: typing.Any = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        invert: typing.Union[bool, typing.Any] = False,
    ) -> typing.Union[bool, typing.Any]:
        """Transform a matrix from Local to Pose space (or back), taking into account options like Inherit Scale and Local Location. Unlike Object.convert_space, this uses custom rest and pose matrices provided by the caller. If the parent matrices are omitted, the bone is assumed to have no parent.This method enables conversions between Local and Pose space for bones in
        the middle of updating the armature without having to update dependencies
        after each change, by manually carrying updated matrices in a recursive walk.

                :param matrix: The matrix to transform
                :type matrix: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
                :param matrix_local: The custom rest matrix of this bone (Bone.matrix_local)
                :type matrix_local: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
                :param parent_matrix: The custom pose matrix of the parent bone (PoseBone.matrix)
                :type parent_matrix: typing.Any
                :param parent_matrix_local: The custom rest matrix of the parent bone (Bone.matrix_local)
                :type parent_matrix_local: typing.Any
                :param invert: Convert from Pose to Local space
                :type invert: typing.Union[bool, typing.Any]
                :return: The transformed matrix
                :rtype: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
        """
        ...

    @classmethod
    def MatrixFromAxisRoll(cls, axis: typing.Any, roll: float) -> float:
        """Convert the axis + roll representation to a matrix

        :param axis: The main axis of the bone (tail - head)
        :type axis: typing.Any
        :param roll: The roll of the bone
        :type roll: float
        :return: The resulting orientation matrix
        :rtype: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]], mathutils.Matrix]
        """
        ...

    @classmethod
    def AxisRollFromMatrix(
        cls, matrix: typing.Any, axis: typing.Any = (0.0, 0.0, 0.0)
    ) -> typing.Any:
        """Convert a rotational matrix to the axis + roll representation. Note that the resulting value of the roll may not be as expected if the matrix has shear or negative determinant.

                :param matrix: The orientation matrix of the bone
                :type matrix: typing.Any
                :param axis: The optional override for the axis (finds closest approximation for the matrix)
                :type axis: typing.Any
                :return: result_axis, The main axis of the bone, `mathutils.Vector` of 3 items in [-inf, inf]

        result_roll, The roll of the bone, float in [-inf, inf]
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoneCollection(bpy_struct):
    """Bone collection in an Armature data-block"""

    bones: bpy_prop_collection[Bone]
    """ Bones assigned to this bone collection. In armature edit mode this will always return an empty list of bones, as the bone collection memberships are only synchronized when exiting edit mode

    :type: bpy_prop_collection[Bone]
    """

    child_number: int
    """ Index of this collection into its parent's list of children. Note that finding this index requires a scan of all the bone collections, so do access this with care

    :type: int
    """

    children: bpy_prop_collection[BoneCollection]
    """ 

    :type: bpy_prop_collection[BoneCollection]
    """

    index: int
    """ Index of this bone collection in the armature.collections_all array. Note that finding this index requires a scan of all the bone collections, so do access this with care

    :type: int
    """

    is_editable: typing.Union[bool, typing.Any]
    """ This collection is owned by a local Armature, or was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_expanded: bool
    """ This bone collection is expanded in the bone collections tree view

    :type: bool
    """

    is_local_override: typing.Union[bool, typing.Any]
    """ This collection was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_solo: bool
    """ Show only this bone collection, and others also marked as 'solo'

    :type: bool
    """

    is_visible: bool
    """ Bones in this collection will be visible in pose/object mode

    :type: bool
    """

    is_visible_ancestors: typing.Union[bool, typing.Any]
    """ True when all of the ancestors of this bone collection are marked as visible; always True for root bone collections

    :type: typing.Union[bool, typing.Any]
    """

    is_visible_effectively: typing.Union[bool, typing.Any]
    """ Whether this bone collection is effectively visible in the viewport. This is True when this bone collection and all of its ancestors are visible, or when it is marked as 'solo'

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Unique within the Armature

    :type: typing.Union[str, typing.Any]
    """

    parent: BoneCollection
    """ Parent bone collection. Note that accessing this requires a scan of all the bone collections to find the parent

    :type: BoneCollection
    """

    bones_recursive: typing.Any
    """ A set of all bones assigned to this bone collection and its child collections.(readonly)"""

    def assign(self, bone: typing.Any) -> typing.Any:
        """Assign the given bone to this collection

        :param bone: Bone to assign to this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Any
        :return: Assigned, Whether the bone was actually assigned; will be false if the bone was already member of the collection
        :rtype: bool
        """
        ...

    def unassign(self, bone: typing.Any) -> typing.Any:
        """Remove the given bone from this collection

        :param bone: Bone to remove from this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Any
        :return: Unassigned, Whether the bone was actually removed; will be false if the bone was not a member of the collection to begin with
        :rtype: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoneCollectionMemberships(bpy_struct):
    """The Bone Collections that contain this Bone"""

    def clear(self):
        """Remove this bone from all bone collections"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoneCollections(bpy_struct):
    """The Bone Collections of this Armature"""

    active: BoneCollection
    """ Armature's active bone collection

    :type: BoneCollection
    """

    active_index: int
    """ The index of the Armature's active bone collection; -1 when there is no active collection. Note that this is indexing the underlying array of bone collections, which may not be in the order you expect. Root collections are listed first, and siblings are always sequential. Apart from that, bone collections can be in any order, and thus incrementing or decrementing this index can make the active bone collection jump around in unexpected ways. For a more predictable interface, use active or active_name

    :type: int
    """

    active_name: typing.Union[str, typing.Any]
    """ The name of the Armature's active bone collection; empty when there is no active collection

    :type: typing.Union[str, typing.Any]
    """

    is_solo_active: typing.Union[bool, typing.Any]
    """ Read-only flag that indicates there is at least one bone collection marked as 'solo'

    :type: typing.Union[bool, typing.Any]
    """

    def new(
        self, name: typing.Union[str, typing.Any], parent: BoneCollection = None
    ) -> BoneCollection:
        """Add a new empty bone collection to the armature

        :param name: Name, Name of the new collection. Blender will ensure it is unique within the collections of the Armature
        :type name: typing.Union[str, typing.Any]
        :param parent: Parent Collection, If not None, the new bone collection becomes a child of this collection
        :type parent: BoneCollection
        :return: Newly created bone collection
        :rtype: BoneCollection
        """
        ...

    def remove(self, bone_collection: BoneCollection):
        """Remove the bone collection from the armature. If this bone collection has any children, they will be reassigned to their grandparent; in other words, the children will take the place of the removed bone collection

        :param bone_collection: Bone Collection, The bone collection to remove
        :type bone_collection: BoneCollection
        """
        ...

    def move(self, from_index: int, to_index: int):
        """Move a bone collection to a different position in the collection list. This can only be used to reorder siblings, and not to change parent-child relationships

        :param from_index: From Index, Index to move
        :type from_index: int
        :param to_index: To Index, Target index
        :type to_index: int
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoneColor(bpy_struct):
    """Theme color or custom color of a bone"""

    custom: ThemeBoneColorSet
    """ The custom bone colors, used when palette is 'CUSTOM'

    :type: ThemeBoneColorSet
    """

    is_custom: typing.Union[bool, typing.Any]
    """ A color palette is user-defined, instead of using a theme-defined one

    :type: typing.Union[bool, typing.Any]
    """

    palette: typing.Union[str, int]
    """ Color palette to use

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoolAttribute(bpy_struct):
    """Geometry attribute that stores booleans"""

    data: bpy_prop_collection[BoolAttributeValue]
    """ 

    :type: bpy_prop_collection[BoolAttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoolAttributeValue(bpy_struct):
    """Bool value in geometry attribute"""

    value: bool
    """ 

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BoolProperty(bpy_struct):
    """RNA boolean property definition"""

    array_dimensions: bpy_prop_array[int]
    """ Length of each dimension of the array

    :type: bpy_prop_array[int]
    """

    array_length: int
    """ Maximum length of the array, 0 means unlimited

    :type: int
    """

    default: typing.Union[bool, typing.Any]
    """ Default value for this number

    :type: typing.Union[bool, typing.Any]
    """

    default_array: typing.List[bool]
    """ Default value for this array

    :type: typing.List[bool]
    """

    is_array: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BooleanModifier(bpy_struct):
    """Boolean operations modifier"""

    collection: Collection
    """ Use mesh objects in this collection for Boolean operation

    :type: Collection
    """

    debug_options: typing.Union[typing.Set[str], typing.Set[int]]
    """ Debugging options, only when started with '-d'

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    """

    double_threshold: float
    """ Threshold for checking overlapping geometry

    :type: float
    """

    material_mode: typing.Union[str, int]
    """ Method for setting materials on the new faces

    :type: typing.Union[str, int]
    """

    object: Object
    """ Mesh object to use for Boolean operation

    :type: Object
    """

    operand_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    operation: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    solver: typing.Union[str, int]
    """ Method for calculating booleans

    :type: typing.Union[str, int]
    """

    use_hole_tolerant: bool
    """ Better results when there are holes (slower)

    :type: bool
    """

    use_self: bool
    """ Allow self-intersection in operands

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrightContrastModifier(bpy_struct):
    """Bright/contrast modifier data for sequence strip"""

    bright: float
    """ Adjust the luminosity of the colors

    :type: float
    """

    contrast: float
    """ Adjust the difference in luminosity between pixels

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Brush(bpy_struct):
    """Brush data-block for storing brush settings for painting and sculpting"""

    area_radius_factor: float
    """ Ratio between the brush radius and the radius that is going to be used to sample the area center

    :type: float
    """

    auto_smooth_factor: float
    """ Amount of smoothing to automatically apply to each stroke

    :type: float
    """

    automasking_boundary_edges_propagation_steps: int
    """ Distance where boundary edge automasking is going to protect vertices from the fully masked edge

    :type: int
    """

    automasking_cavity_blur_steps: int
    """ The number of times the cavity mask is blurred

    :type: int
    """

    automasking_cavity_curve: CurveMapping
    """ Curve used for the sensitivity

    :type: CurveMapping
    """

    automasking_cavity_factor: float
    """ The contrast of the cavity mask

    :type: float
    """

    automasking_start_normal_falloff: float
    """ Extend the angular range with a falloff gradient

    :type: float
    """

    automasking_start_normal_limit: float
    """ The range of angles that will be affected

    :type: float
    """

    automasking_view_normal_falloff: float
    """ Extend the angular range with a falloff gradient

    :type: float
    """

    automasking_view_normal_limit: float
    """ The range of angles that will be affected

    :type: float
    """

    blend: typing.Union[str, int]
    """ Brush blending mode

    :type: typing.Union[str, int]
    """

    blur_kernel_radius: int
    """ Radius of kernel used for soften and sharpen in pixels

    :type: int
    """

    blur_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    boundary_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    boundary_falloff_type: typing.Union[str, int]
    """ How the brush falloff is applied across the boundary

    :type: typing.Union[str, int]
    """

    boundary_offset: float
    """ Offset of the boundary origin in relation to the brush radius

    :type: float
    """

    brush_capabilities: BrushCapabilities
    """ Brush's capabilities

    :type: BrushCapabilities
    """

    clone_alpha: float
    """ Opacity of clone image display

    :type: float
    """

    clone_image: Image
    """ Image for clone tool

    :type: Image
    """

    clone_offset: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    cloth_constraint_softbody_strength: float
    """ How much the cloth preserves the original shape, acting as a soft body

    :type: float
    """

    cloth_damping: float
    """ How much the applied forces are propagated through the cloth

    :type: float
    """

    cloth_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    cloth_force_falloff_type: typing.Union[str, int]
    """ Shape used in the brush to apply force to the cloth

    :type: typing.Union[str, int]
    """

    cloth_mass: float
    """ Mass of each simulation particle

    :type: float
    """

    cloth_sim_falloff: float
    """ Area to apply deformation falloff to the effects of the simulation

    :type: float
    """

    cloth_sim_limit: float
    """ Factor added relative to the size of the radius to limit the cloth simulation effects

    :type: float
    """

    cloth_simulation_area_type: typing.Union[str, int]
    """ Part of the mesh that is going to be simulated when the stroke is active

    :type: typing.Union[str, int]
    """

    color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    color_type: typing.Union[str, int]
    """ Use single color or gradient when painting

    :type: typing.Union[str, int]
    """

    crease_pinch_factor: float
    """ How much the crease brush pinches

    :type: float
    """

    cursor_color_add: bpy_prop_array[float]
    """ Color of cursor when adding

    :type: bpy_prop_array[float]
    """

    cursor_color_subtract: bpy_prop_array[float]
    """ Color of cursor when subtracting

    :type: bpy_prop_array[float]
    """

    cursor_overlay_alpha: int
    """ 

    :type: int
    """

    curve: CurveMapping
    """ Editable falloff curve

    :type: CurveMapping
    """

    curve_preset: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    curves_sculpt_settings: BrushCurvesSculptSettings
    """ 

    :type: BrushCurvesSculptSettings
    """

    curves_sculpt_tool: typing.Any
    """ """

    dash_ratio: float
    """ Ratio of samples in a cycle that the brush is enabled

    :type: float
    """

    dash_samples: int
    """ Length of a dash cycle measured in stroke samples

    :type: int
    """

    deform_target: typing.Union[str, int]
    """ How the deformation of the brush will affect the object

    :type: typing.Union[str, int]
    """

    density: float
    """ Amount of random elements that are going to be affected by the brush

    :type: float
    """

    direction: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    disconnected_distance_max: float
    """ Maximum distance to search for disconnected loose parts in the mesh

    :type: float
    """

    elastic_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    elastic_deform_volume_preservation: float
    """ Poisson ratio for elastic deformation. Higher values preserve volume more, but also lead to more bulging

    :type: float
    """

    falloff_angle: float
    """ Paint most on faces pointing towards the view according to this angle

    :type: float
    """

    falloff_shape: typing.Union[str, int]
    """ Use projected or spherical falloff

    :type: typing.Union[str, int]
    """

    fill_threshold: float
    """ Threshold above which filling is not propagated

    :type: float
    """

    flow: float
    """ Amount of paint that is applied per stroke sample

    :type: float
    """

    gpencil_sculpt_tool: typing.Any
    """ """

    gpencil_settings: BrushGpencilSettings
    """ 

    :type: BrushGpencilSettings
    """

    gpencil_tool: typing.Any
    """ """

    gpencil_vertex_tool: typing.Any
    """ """

    gpencil_weight_tool: typing.Any
    """ """

    grad_spacing: int
    """ Spacing before brush gradient goes full circle

    :type: int
    """

    gradient: ColorRamp
    """ 

    :type: ColorRamp
    """

    gradient_fill_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    gradient_stroke_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    hardness: float
    """ How close the brush falloff starts from the edge of the brush

    :type: float
    """

    height: float
    """ Affectable height of brush (layer height for layer tool, i.e.)

    :type: float
    """

    icon_filepath: typing.Union[str, typing.Any]
    """ File path to brush icon

    :type: typing.Union[str, typing.Any]
    """

    image_paint_capabilities: BrushCapabilitiesImagePaint
    """ 

    :type: BrushCapabilitiesImagePaint
    """

    image_tool: typing.Any
    """ """

    input_samples: int
    """ Number of input samples to average together to smooth the brush stroke

    :type: int
    """

    invert_density_pressure: bool
    """ Invert the modulation of pressure in density

    :type: bool
    """

    invert_flow_pressure: bool
    """ Invert the modulation of pressure in flow

    :type: bool
    """

    invert_hardness_pressure: bool
    """ Invert the modulation of pressure in hardness

    :type: bool
    """

    invert_to_scrape_fill: bool
    """ Use Scrape or Fill tool when inverting this brush instead of inverting its displacement direction

    :type: bool
    """

    invert_wet_mix_pressure: bool
    """ Invert the modulation of pressure in wet mix

    :type: bool
    """

    invert_wet_persistence_pressure: bool
    """ Invert the modulation of pressure in wet persistence

    :type: bool
    """

    jitter: float
    """ Jitter the position of the brush while painting

    :type: float
    """

    jitter_absolute: int
    """ Jitter the position of the brush in pixels while painting

    :type: int
    """

    jitter_unit: typing.Union[str, int]
    """ Jitter in screen space or relative to brush size

    :type: typing.Union[str, int]
    """

    mask_overlay_alpha: int
    """ 

    :type: int
    """

    mask_stencil_dimension: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Dimensions of mask stencil in viewport

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    mask_stencil_pos: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Position of mask stencil in viewport

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    mask_texture: Texture
    """ 

    :type: Texture
    """

    mask_texture_slot: BrushTextureSlot
    """ 

    :type: BrushTextureSlot
    """

    mask_tool: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    multiplane_scrape_angle: float
    """ Angle between the planes of the crease

    :type: float
    """

    normal_radius_factor: float
    """ Ratio between the brush radius and the radius that is going to be used to sample the normal

    :type: float
    """

    normal_weight: float
    """ How much grab will pull vertices out of surface during a grab

    :type: float
    """

    paint_curve: PaintCurve
    """ Active paint curve

    :type: PaintCurve
    """

    plane_offset: float
    """ Adjust plane on which the brush acts towards or away from the object surface

    :type: float
    """

    plane_trim: float
    """ If a vertex is further away from offset plane than this, then it is not affected

    :type: float
    """

    pose_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    pose_ik_segments: int
    """ Number of segments of the inverse kinematics chain that will deform the mesh

    :type: int
    """

    pose_offset: float
    """ Offset of the pose origin in relation to the brush radius

    :type: float
    """

    pose_origin_type: typing.Union[str, int]
    """ Method to set the rotation origins for the segments of the brush

    :type: typing.Union[str, int]
    """

    pose_smooth_iterations: int
    """ Smooth iterations applied after calculating the pose factor of each vertex

    :type: int
    """

    rake_factor: float
    """ How much grab will follow cursor rotation

    :type: float
    """

    rate: float
    """ Interval between paints for Airbrush

    :type: float
    """

    sculpt_capabilities: BrushCapabilitiesSculpt
    """ 

    :type: BrushCapabilitiesSculpt
    """

    sculpt_plane: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    sculpt_tool: typing.Any
    """ """

    secondary_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    sharp_threshold: float
    """ Threshold below which, no sharpening is done

    :type: float
    """

    show_multiplane_scrape_planes_preview: bool
    """ Preview the scrape planes in the cursor during the stroke

    :type: bool
    """

    size: int
    """ Radius of the brush in pixels

    :type: int
    """

    slide_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    smear_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    smooth_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    smooth_stroke_factor: float
    """ Higher values give a smoother stroke

    :type: float
    """

    smooth_stroke_radius: int
    """ Minimum distance from last point before stroke continues

    :type: int
    """

    snake_hook_deform_type: typing.Union[str, int]
    """ Deformation type that is used in the brush

    :type: typing.Union[str, int]
    """

    spacing: int
    """ Spacing between brush daubs as a percentage of brush diameter

    :type: int
    """

    stencil_dimension: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Dimensions of stencil in viewport

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    stencil_pos: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Position of stencil in viewport

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    strength: float
    """ How powerful the effect of the brush is when applied

    :type: float
    """

    stroke_method: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    surface_smooth_current_vertex: float
    """ How much the position of each individual vertex influences the final result

    :type: float
    """

    surface_smooth_iterations: int
    """ Number of smoothing iterations per brush step

    :type: int
    """

    surface_smooth_shape_preservation: float
    """ How much of the original shape is preserved when smoothing

    :type: float
    """

    texture: Texture
    """ 

    :type: Texture
    """

    texture_overlay_alpha: int
    """ 

    :type: int
    """

    texture_sample_bias: float
    """ Value added to texture samples

    :type: float
    """

    texture_slot: BrushTextureSlot
    """ 

    :type: BrushTextureSlot
    """

    tilt_strength_factor: float
    """ How much the tilt of the pen will affect the brush

    :type: float
    """

    tip_roundness: float
    """ Roundness of the brush tip

    :type: float
    """

    tip_scale_x: float
    """ Scale of the brush tip in the X axis

    :type: float
    """

    topology_rake_factor: float
    """ Automatically align edges to the brush direction to generate cleaner topology and define sharp features. Best used on low-poly meshes as it has a performance impact

    :type: float
    """

    unprojected_radius: float
    """ Radius of brush in Blender units

    :type: float
    """

    use_accumulate: bool
    """ Accumulate stroke daubs on top of each other

    :type: bool
    """

    use_adaptive_space: bool
    """ Space daubs according to surface orientation instead of screen space

    :type: bool
    """

    use_airbrush: bool
    """ Keep applying paint effect while holding mouse (spray)

    :type: bool
    """

    use_alpha: bool
    """ When this is disabled, lock alpha while painting

    :type: bool
    """

    use_anchor: bool
    """ Keep the brush anchored to the initial location

    :type: bool
    """

    use_automasking_boundary_edges: bool
    """ Do not affect non manifold boundary edges

    :type: bool
    """

    use_automasking_boundary_face_sets: bool
    """ Do not affect vertices that belong to a Face Set boundary

    :type: bool
    """

    use_automasking_cavity: bool
    """ Do not affect vertices on peaks, based on the surface curvature

    :type: bool
    """

    use_automasking_cavity_inverted: bool
    """ Do not affect vertices within crevices, based on the surface curvature

    :type: bool
    """

    use_automasking_custom_cavity_curve: bool
    """ Use custom curve

    :type: bool
    """

    use_automasking_face_sets: bool
    """ Affect only vertices that share Face Sets with the active vertex

    :type: bool
    """

    use_automasking_start_normal: bool
    """ Affect only vertices with a similar normal to where the stroke starts

    :type: bool
    """

    use_automasking_topology: bool
    """ Affect only vertices connected to the active vertex under the brush

    :type: bool
    """

    use_automasking_view_normal: bool
    """ Affect only vertices with a normal that faces the viewer

    :type: bool
    """

    use_automasking_view_occlusion: bool
    """ Only affect vertices that are not occluded by other faces. (Slower performance)

    :type: bool
    """

    use_cloth_collision: bool
    """ Collide with objects during the simulation

    :type: bool
    """

    use_cloth_pin_simulation_boundary: bool
    """ Lock the position of the vertices in the simulation falloff area to avoid artifacts and create a softer transition with unaffected areas

    :type: bool
    """

    use_color_as_displacement: bool
    """ Handles each pixel color as individual vector for displacement. Works only with area plane mapping

    :type: bool
    """

    use_connected_only: bool
    """ Affect only topologically connected elements

    :type: bool
    """

    use_cursor_overlay: bool
    """ Show cursor in viewport

    :type: bool
    """

    use_cursor_overlay_override: bool
    """ Don't show overlay during a stroke

    :type: bool
    """

    use_curve: bool
    """ Define the stroke curve with a Bézier curve. Dabs are separated according to spacing

    :type: bool
    """

    use_custom_icon: bool
    """ Set the brush icon from an image file

    :type: bool
    """

    use_density_pressure: bool
    """ Use pressure to modulate density

    :type: bool
    """

    use_edge_to_edge: bool
    """ Drag anchor brush from edge-to-edge

    :type: bool
    """

    use_flow_pressure: bool
    """ Use pressure to modulate flow

    :type: bool
    """

    use_frontface: bool
    """ Brush only affects vertices that face the viewer

    :type: bool
    """

    use_frontface_falloff: bool
    """ Blend brush influence by how much they face the front

    :type: bool
    """

    use_grab_active_vertex: bool
    """ Apply the maximum grab strength to the active vertex instead of the cursor location

    :type: bool
    """

    use_grab_silhouette: bool
    """ Grabs trying to automask the silhouette of the object

    :type: bool
    """

    use_hardness_pressure: bool
    """ Use pressure to modulate hardness

    :type: bool
    """

    use_inverse_smooth_pressure: bool
    """ Lighter pressure causes more smoothing to be applied

    :type: bool
    """

    use_line: bool
    """ Draw a line with dabs separated according to spacing

    :type: bool
    """

    use_locked_size: typing.Union[str, int]
    """ Measure brush size relative to the view or the scene

    :type: typing.Union[str, int]
    """

    use_multiplane_scrape_dynamic: bool
    """ The angle between the planes changes during the stroke to fit the surface under the cursor

    :type: bool
    """

    use_offset_pressure: bool
    """ Enable tablet pressure sensitivity for offset

    :type: bool
    """

    use_original_normal: bool
    """ When locked keep using normal of surface where stroke was initiated

    :type: bool
    """

    use_original_plane: bool
    """ When locked keep using the plane origin of surface where stroke was initiated

    :type: bool
    """

    use_paint_antialiasing: bool
    """ Smooths the edges of the strokes

    :type: bool
    """

    use_paint_grease_pencil: bool
    """ Use this brush in grease pencil drawing mode

    :type: bool
    """

    use_paint_image: bool
    """ Use this brush in texture paint mode

    :type: bool
    """

    use_paint_sculpt: bool
    """ Use this brush in sculpt mode

    :type: bool
    """

    use_paint_sculpt_curves: bool
    """ Use this brush in sculpt curves mode

    :type: bool
    """

    use_paint_uv_sculpt: bool
    """ Use this brush in UV sculpt mode

    :type: bool
    """

    use_paint_vertex: bool
    """ Use this brush in vertex paint mode

    :type: bool
    """

    use_paint_weight: bool
    """ Use this brush in weight paint mode

    :type: bool
    """

    use_persistent: bool
    """ Sculpt on a persistent layer of the mesh

    :type: bool
    """

    use_plane_trim: bool
    """ Limit the distance from the offset plane that a vertex can be affected

    :type: bool
    """

    use_pose_ik_anchored: bool
    """ Keep the position of the last segment in the IK chain fixed

    :type: bool
    """

    use_pose_lock_rotation: bool
    """ Do not rotate the segment when using the scale deform mode

    :type: bool
    """

    use_pressure_area_radius: bool
    """ Enable tablet pressure sensitivity for area radius

    :type: bool
    """

    use_pressure_jitter: bool
    """ Enable tablet pressure sensitivity for jitter

    :type: bool
    """

    use_pressure_masking: typing.Union[str, int]
    """ Pen pressure makes texture influence smaller

    :type: typing.Union[str, int]
    """

    use_pressure_size: bool
    """ Enable tablet pressure sensitivity for size

    :type: bool
    """

    use_pressure_spacing: bool
    """ Enable tablet pressure sensitivity for spacing

    :type: bool
    """

    use_pressure_strength: bool
    """ Enable tablet pressure sensitivity for strength

    :type: bool
    """

    use_primary_overlay: bool
    """ Show texture in viewport

    :type: bool
    """

    use_primary_overlay_override: bool
    """ Don't show overlay during a stroke

    :type: bool
    """

    use_restore_mesh: bool
    """ Allow a single dot to be carefully positioned

    :type: bool
    """

    use_scene_spacing: typing.Union[str, int]
    """ Calculate the brush spacing using view or scene distance

    :type: typing.Union[str, int]
    """

    use_secondary_overlay: bool
    """ Show texture in viewport

    :type: bool
    """

    use_secondary_overlay_override: bool
    """ Don't show overlay during a stroke

    :type: bool
    """

    use_smooth_stroke: bool
    """ Brush lags behind mouse and follows a smoother path

    :type: bool
    """

    use_space: bool
    """ Limit brush application to the distance specified by spacing

    :type: bool
    """

    use_space_attenuation: bool
    """ Automatically adjust strength to give consistent results for different spacings

    :type: bool
    """

    use_vertex_grease_pencil: bool
    """ Use this brush in grease pencil vertex color mode

    :type: bool
    """

    use_wet_mix_pressure: bool
    """ Use pressure to modulate wet mix

    :type: bool
    """

    use_wet_persistence_pressure: bool
    """ Use pressure to modulate wet persistence

    :type: bool
    """

    uv_sculpt_tool: typing.Any
    """ """

    vertex_paint_capabilities: BrushCapabilitiesVertexPaint
    """ 

    :type: BrushCapabilitiesVertexPaint
    """

    vertex_tool: typing.Any
    """ """

    weight: float
    """ Vertex weight when brush is applied

    :type: float
    """

    weight_paint_capabilities: BrushCapabilitiesWeightPaint
    """ 

    :type: BrushCapabilitiesWeightPaint
    """

    weight_tool: typing.Any
    """ """

    wet_mix: float
    """ Amount of paint that is picked from the surface into the brush color

    :type: float
    """

    wet_paint_radius_factor: float
    """ Ratio between the brush radius and the radius that is going to be used to sample the color to blend in wet paint

    :type: float
    """

    wet_persistence: float
    """ Amount of wet paint that stays in the brush after applying paint to the surface

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushCapabilities(bpy_struct):
    """Read-only indications of supported operations"""

    has_overlay: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_smooth_stroke: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_spacing: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushCapabilitiesImagePaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_accumulate: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_radius: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_space_attenuation: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushCapabilitiesSculpt(bpy_struct):
    """Read-only indications of which brush operations are supported by the current sculpt tool"""

    has_accumulate: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_auto_smooth: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_direction: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_gravity: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_height: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_jitter: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_normal_weight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_persistence: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_pinch_factor: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_plane_offset: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_rake_factor: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_sculpt_plane: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_secondary_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_smooth_stroke: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_space_attenuation: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_strength_pressure: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_tilt: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_topology_rake: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushCapabilitiesVertexPaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushCapabilitiesWeightPaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_weight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushCurvesSculptSettings(bpy_struct):
    """ """

    add_amount: int
    """ Number of curves added by the Add brush

    :type: int
    """

    curve_length: float
    """ Length of newly added curves when it is not interpolated from other curves

    :type: float
    """

    curve_parameter_falloff: CurveMapping
    """ Falloff that is applied from the tip to the root of each curve

    :type: CurveMapping
    """

    curve_radius: float
    """ Radius of newly added curves when it is not interpolated from other curves

    :type: float
    """

    density_add_attempts: int
    """ How many times the Density brush tries to add a new curve

    :type: int
    """

    density_mode: typing.Union[str, int]
    """ Determines whether the brush adds or removes curves

    :type: typing.Union[str, int]
    """

    minimum_distance: float
    """ Goal distance between curve roots for the Density brush

    :type: float
    """

    minimum_length: float
    """ Avoid shrinking curves shorter than this length

    :type: float
    """

    points_per_curve: int
    """ Number of control points in a newly added curve

    :type: int
    """

    use_length_interpolate: bool
    """ Use length of the curves in close proximity

    :type: bool
    """

    use_point_count_interpolate: bool
    """ Use the number of points from the curves in close proximity

    :type: bool
    """

    use_radius_interpolate: bool
    """ Use radius of the curves in close proximity

    :type: bool
    """

    use_shape_interpolate: bool
    """ Use shape of the curves in close proximity

    :type: bool
    """

    use_uniform_scale: bool
    """ Grow or shrink curves by changing their size uniformly instead of using trimming or extrapolation

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushGpencilSettings(bpy_struct):
    """Settings for grease pencil brush"""

    active_smooth_factor: float
    """ Amount of smoothing while drawing

    :type: float
    """

    angle: float
    """ Direction of the stroke at which brush gives maximal thickness (0° for horizontal)

    :type: float
    """

    angle_factor: float
    """ Reduce brush thickness by this factor when stroke is perpendicular to 'Angle' direction

    :type: float
    """

    aspect: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    brush_draw_mode: typing.Union[str, int]
    """ Preselected mode when using this brush

    :type: typing.Union[str, int]
    """

    caps_type: typing.Union[str, int]
    """ The shape of the start and end of the stroke

    :type: typing.Union[str, int]
    """

    curve_jitter: CurveMapping
    """ Curve used for the jitter effect

    :type: CurveMapping
    """

    curve_random_hue: CurveMapping
    """ Curve used for modulating effect

    :type: CurveMapping
    """

    curve_random_pressure: CurveMapping
    """ Curve used for modulating effect

    :type: CurveMapping
    """

    curve_random_saturation: CurveMapping
    """ Curve used for modulating effect

    :type: CurveMapping
    """

    curve_random_strength: CurveMapping
    """ Curve used for modulating effect

    :type: CurveMapping
    """

    curve_random_uv: CurveMapping
    """ Curve used for modulating effect

    :type: CurveMapping
    """

    curve_random_value: CurveMapping
    """ Curve used for modulating effect

    :type: CurveMapping
    """

    curve_sensitivity: CurveMapping
    """ Curve used for the sensitivity

    :type: CurveMapping
    """

    curve_strength: CurveMapping
    """ Curve used for the strength

    :type: CurveMapping
    """

    dilate: int
    """ Number of pixels to expand or contract fill area

    :type: int
    """

    eraser_mode: typing.Union[str, int]
    """ Eraser Mode

    :type: typing.Union[str, int]
    """

    eraser_strength_factor: float
    """ Amount of erasing for strength

    :type: float
    """

    eraser_thickness_factor: float
    """ Amount of erasing for thickness

    :type: float
    """

    extend_stroke_factor: float
    """ Strokes end extension for closing gaps, use zero to disable

    :type: float
    """

    fill_direction: typing.Union[str, int]
    """ Direction of the fill

    :type: typing.Union[str, int]
    """

    fill_draw_mode: typing.Union[str, int]
    """ Mode to draw boundary limits

    :type: typing.Union[str, int]
    """

    fill_extend_mode: typing.Union[str, int]
    """ Types of stroke extensions used for closing gaps

    :type: typing.Union[str, int]
    """

    fill_factor: float
    """ Factor for fill boundary accuracy, higher values are more accurate but slower

    :type: float
    """

    fill_layer_mode: typing.Union[str, int]
    """ Layers used as boundaries

    :type: typing.Union[str, int]
    """

    fill_simplify_level: int
    """ Number of simplify steps (large values reduce fill accuracy)

    :type: int
    """

    fill_threshold: float
    """ Threshold to consider color transparent for filling

    :type: float
    """

    gpencil_paint_icon: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    gpencil_sculpt_icon: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    gpencil_vertex_icon: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    gpencil_weight_icon: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    hardness: float
    """ Gradient from the center of Dot and Box strokes (set to 1 for a solid stroke)

    :type: float
    """

    input_samples: int
    """ Generate intermediate points for very fast mouse movements. Set to 0 to disable

    :type: int
    """

    material: Material
    """ Material used for strokes drawn using this brush

    :type: Material
    """

    material_alt: Material
    """ Material used for secondary uses for this brush

    :type: Material
    """

    outline_thickness_factor: float
    """ Thickness of the outline stroke relative to current brush thickness

    :type: float
    """

    pen_jitter: float
    """ Jitter factor for new strokes

    :type: float
    """

    pen_smooth_factor: float
    """ Amount of smoothing to apply after finish newly created strokes, to reduce jitter/noise

    :type: float
    """

    pen_smooth_steps: int
    """ Number of times to smooth newly created strokes

    :type: int
    """

    pen_strength: float
    """ Color strength for new strokes (affect alpha factor of color)

    :type: float
    """

    pen_subdivision_steps: int
    """ Number of times to subdivide newly created strokes, for less jagged strokes

    :type: int
    """

    pin_draw_mode: bool
    """ Pin the mode to the brush

    :type: bool
    """

    random_hue_factor: float
    """ Random factor to modify original hue

    :type: float
    """

    random_pressure: float
    """ Randomness factor for pressure in new strokes

    :type: float
    """

    random_saturation_factor: float
    """ Random factor to modify original saturation

    :type: float
    """

    random_strength: float
    """ Randomness factor strength in new strokes

    :type: float
    """

    random_value_factor: float
    """ Random factor to modify original value

    :type: float
    """

    show_fill: bool
    """ Show transparent lines to use as boundary for filling

    :type: bool
    """

    show_fill_boundary: bool
    """ Show help lines for filling to see boundaries

    :type: bool
    """

    show_fill_extend: bool
    """ Show help lines for stroke extension

    :type: bool
    """

    show_lasso: bool
    """ Do not display fill color while drawing the stroke

    :type: bool
    """

    simplify_factor: float
    """ Factor of Simplify using adaptive algorithm

    :type: float
    """

    use_active_layer_only: bool
    """ Only edit the active layer of the object

    :type: bool
    """

    use_collide_strokes: bool
    """ Check if extend lines collide with strokes

    :type: bool
    """

    use_default_eraser: bool
    """ Use this brush when enable eraser with fast switch key

    :type: bool
    """

    use_edit_position: bool
    """ The brush affects the position of the point

    :type: bool
    """

    use_edit_strength: bool
    """ The brush affects the color strength of the point

    :type: bool
    """

    use_edit_thickness: bool
    """ The brush affects the thickness of the point

    :type: bool
    """

    use_edit_uv: bool
    """ The brush affects the UV rotation of the point

    :type: bool
    """

    use_fill_limit: bool
    """ Fill only visible areas in viewport

    :type: bool
    """

    use_jitter_pressure: bool
    """ Use tablet pressure for jitter

    :type: bool
    """

    use_keep_caps_eraser: bool
    """ Keep the caps as they are and don't flatten them when erasing

    :type: bool
    """

    use_material_pin: bool
    """ Keep material assigned to brush

    :type: bool
    """

    use_occlude_eraser: bool
    """ Erase only strokes visible and not occluded

    :type: bool
    """

    use_pressure: bool
    """ Use tablet pressure

    :type: bool
    """

    use_random_press_hue: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_radius: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_sat: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_strength: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_uv: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_val: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_settings_outline: bool
    """ Convert stroke to perimeter

    :type: bool
    """

    use_settings_postprocess: bool
    """ Additional post processing options for new strokes

    :type: bool
    """

    use_settings_random: bool
    """ Random brush settings

    :type: bool
    """

    use_settings_stabilizer: bool
    """ Draw lines with a delay to allow smooth strokes. Press Shift key to override while drawing

    :type: bool
    """

    use_strength_pressure: bool
    """ Use tablet pressure for color strength

    :type: bool
    """

    use_stroke_random_hue: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_radius: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_sat: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_strength: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_uv: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_val: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_trim: bool
    """ Trim intersecting stroke ends

    :type: bool
    """

    uv_random: float
    """ Random factor for auto-generated UV rotation

    :type: float
    """

    vertex_color_factor: float
    """ Factor used to mix vertex color to get final color

    :type: float
    """

    vertex_mode: typing.Union[str, int]
    """ Defines how vertex color affect to the strokes

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BrushTextureSlot(bpy_struct):
    """Texture slot for textures in a Brush data-block"""

    angle: float
    """ Brush texture rotation

    :type: float
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_texture_angle_source: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    map_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    mask_map_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    random_angle: float
    """ Brush texture random angle

    :type: float
    """

    use_rake: bool
    """ 

    :type: bool
    """

    use_random: bool
    """ 

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BuildGpencilModifier(bpy_struct):
    """Animate strokes appearing and disappearing"""

    concurrent_time_alignment: typing.Union[str, int]
    """ How should strokes start to appear/disappear

    :type: typing.Union[str, int]
    """

    fade_factor: float
    """ Defines how much of the stroke is fading in/out

    :type: float
    """

    fade_opacity_strength: float
    """ How much strength fading applies on top of stroke opacity

    :type: float
    """

    fade_thickness_strength: float
    """ How much strength fading applies on top of stroke thickness

    :type: float
    """

    frame_end: float
    """ End Frame (when Restrict Frame Range is enabled)

    :type: float
    """

    frame_start: float
    """ Start Frame (when Restrict Frame Range is enabled)

    :type: float
    """

    invert_layer_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_layers: bool
    """ Inverse filter

    :type: bool
    """

    layer: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    layer_pass: int
    """ Layer pass index

    :type: int
    """

    length: float
    """ Maximum number of frames that the build effect can run for (unless another GP keyframe occurs before this time has elapsed)

    :type: float
    """

    mode: typing.Union[str, int]
    """ How strokes are being built

    :type: typing.Union[str, int]
    """

    object: Object
    """ Object used as build starting position

    :type: Object
    """

    percentage_factor: float
    """ Defines how much of the stroke is visible

    :type: float
    """

    speed_factor: float
    """ Multiply recorded drawing speed by a factor

    :type: float
    """

    speed_maxgap: float
    """ The maximum gap between strokes in seconds

    :type: float
    """

    start_delay: float
    """ Number of frames after each GP keyframe before the modifier has any effect

    :type: float
    """

    target_vertex_group: typing.Union[str, typing.Any]
    """ Output Vertex group

    :type: typing.Union[str, typing.Any]
    """

    time_mode: typing.Union[str, int]
    """ Use drawing speed, a number of frames, or a manual factor to build strokes

    :type: typing.Union[str, int]
    """

    transition: typing.Union[str, int]
    """ How are strokes animated (i.e. are they appearing or disappearing)

    :type: typing.Union[str, int]
    """

    use_fading: bool
    """ Fade out strokes instead of directly cutting off

    :type: bool
    """

    use_percentage: bool
    """ Use a percentage factor to determine the visible points

    :type: bool
    """

    use_restrict_frame_range: bool
    """ Only modify strokes during the specified frame range

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class BuildModifier(bpy_struct):
    """Build effect modifier"""

    frame_duration: float
    """ Total time the build effect requires

    :type: float
    """

    frame_start: float
    """ Start frame of the effect

    :type: float
    """

    seed: int
    """ Seed for random if used

    :type: int
    """

    use_random_order: bool
    """ Randomize the faces or edges during build

    :type: bool
    """

    use_reverse: bool
    """ Deconstruct the mesh instead of building it

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ByteColorAttribute(bpy_struct):
    """Geometry attribute that stores RGBA colors as positive integer values using 8-bits per channel"""

    data: bpy_prop_collection[ByteColorAttributeValue]
    """ 

    :type: bpy_prop_collection[ByteColorAttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ByteColorAttributeValue(bpy_struct):
    """Color value in geometry attribute"""

    color: bpy_prop_array[float]
    """ RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    """

    color_srgb: bpy_prop_array[float]
    """ RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ByteIntAttribute(bpy_struct):
    """Geometry attribute that stores 8-bit integers"""

    data: bpy_prop_collection[ByteIntAttributeValue]
    """ 

    :type: bpy_prop_collection[ByteIntAttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ByteIntAttributeValue(bpy_struct):
    """8-bit value in geometry attribute"""

    value: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CLIP_UL_tracking_objects(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        _icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param _icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CURVES_UL_attributes(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        attribute,
        _icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param attribute:
        :param _icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    def filter_items(self, _context, data, property):
        """

        :param _context:
        :param data:
        :param property:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CacheFile(bpy_struct):
    """ """

    active_index: int
    """ 

    :type: int
    """

    animation_data: AnimData
    """ Animation data for this data-block

    :type: AnimData
    """

    filepath: typing.Union[str, typing.Any]
    """ Path to external displacements file

    :type: typing.Union[str, typing.Any]
    """

    forward_axis: typing.Any
    """ """

    frame: float
    """ The time to use for looking up the data in the cache file, or to determine which file to use in a file sequence

    :type: float
    """

    frame_offset: float
    """ Subtracted from the current frame to use for looking up the data in the cache file, or to determine which file to use in a file sequence

    :type: float
    """

    is_sequence: bool
    """ Whether the cache is separated in a series of files

    :type: bool
    """

    layers: bpy_prop_collection[CacheFileLayer]
    """ Layers of the cache

    :type: bpy_prop_collection[CacheFileLayer]
    """

    object_paths: bpy_prop_collection[CacheObjectPath]
    """ Paths of the objects inside the Alembic archive

    :type: bpy_prop_collection[CacheObjectPath]
    """

    override_frame: bool
    """ Whether to use a custom frame for looking up data in the cache file, instead of using the current scene frame

    :type: bool
    """

    prefetch_cache_size: int
    """ Memory usage limit in megabytes for the Cycles Procedural cache, if the data does not fit within the limit, rendering is aborted

    :type: int
    """

    scale: float
    """ Value by which to enlarge or shrink the object with respect to the world's origin (only applicable through a Transform Cache constraint)

    :type: float
    """

    up_axis: typing.Any
    """ """

    use_prefetch: bool
    """ When enabled, the Cycles Procedural will preload animation data for faster updates

    :type: bool
    """

    use_render_procedural: bool
    """ Display boxes in the viewport as placeholders for the objects, Cycles will use a procedural to load the objects during viewport rendering in experimental mode, other render engines will also receive a placeholder and should take care of loading the Alembic data themselves if possible

    :type: bool
    """

    velocity_name: typing.Union[str, typing.Any]
    """ Name of the Alembic attribute used for generating motion blur data

    :type: typing.Union[str, typing.Any]
    """

    velocity_unit: typing.Any
    """ Define how the velocity vectors are interpreted with regard to time, 'frame' means the delta time is 1 frame, 'second' means the delta time is 1 / FPS"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CacheFileLayer(bpy_struct):
    """Layer of the cache, used to load or override data from the first the first layer"""

    filepath: typing.Union[str, typing.Any]
    """ Path to the archive

    :type: typing.Union[str, typing.Any]
    """

    hide_layer: bool
    """ Do not load data from this layer

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CacheFileLayers(bpy_struct):
    """Collection of cache layers"""

    active: CacheFileLayer
    """ Active layer of the CacheFile

    :type: CacheFileLayer
    """

    def new(
        self, filepath: typing.Union[str, typing.Any]
    ) -> typing.Union[str, typing.Any]:
        """Add a new layer

        :param filepath: File path to the archive used as a layer
        :type filepath: typing.Union[str, typing.Any]
        :return: Newly created layer
        :rtype: CacheFileLayer
        """
        ...

    def remove(self, layer: CacheFileLayer):
        """Remove an existing layer from the cache file

        :param layer: Layer to remove
        :type layer: CacheFileLayer
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CacheObjectPath(bpy_struct):
    """Path of an object inside of an Alembic archive"""

    path: typing.Union[str, typing.Any]
    """ Object path

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CacheObjectPaths(bpy_struct):
    """Collection of object paths"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Camera(bpy_struct):
    """Camera data-block for storing camera settings"""

    angle: float
    """ Camera lens field of view

    :type: float
    """

    angle_x: float
    """ Camera lens horizontal field of view

    :type: float
    """

    angle_y: float
    """ Camera lens vertical field of view

    :type: float
    """

    animation_data: AnimData
    """ Animation data for this data-block

    :type: AnimData
    """

    background_images: bpy_prop_collection[CameraBackgroundImage]
    """ List of background images

    :type: bpy_prop_collection[CameraBackgroundImage]
    """

    clip_end: float
    """ Camera far clipping distance

    :type: float
    """

    clip_start: float
    """ Camera near clipping distance

    :type: float
    """

    display_size: float
    """ Apparent size of the Camera object in the 3D View

    :type: float
    """

    dof: CameraDOFSettings
    """ 

    :type: CameraDOFSettings
    """

    fisheye_fov: float
    """ Field of view for the fisheye lens

    :type: float
    """

    fisheye_lens: float
    """ Lens focal length (mm)

    :type: float
    """

    fisheye_polynomial_k0: float
    """ Coefficient K0 of the lens polynomial

    :type: float
    """

    fisheye_polynomial_k1: float
    """ Coefficient K1 of the lens polynomial

    :type: float
    """

    fisheye_polynomial_k2: float
    """ Coefficient K2 of the lens polynomial

    :type: float
    """

    fisheye_polynomial_k3: float
    """ Coefficient K3 of the lens polynomial

    :type: float
    """

    fisheye_polynomial_k4: float
    """ Coefficient K4 of the lens polynomial

    :type: float
    """

    latitude_max: float
    """ Maximum latitude (vertical angle) for the equirectangular lens

    :type: float
    """

    latitude_min: float
    """ Minimum latitude (vertical angle) for the equirectangular lens

    :type: float
    """

    lens: float
    """ Perspective Camera focal length value in millimeters

    :type: float
    """

    lens_unit: typing.Union[str, int]
    """ Unit to edit lens in for the user interface

    :type: typing.Union[str, int]
    """

    longitude_max: float
    """ Maximum longitude (horizontal angle) for the equirectangular lens

    :type: float
    """

    longitude_min: float
    """ Minimum longitude (horizontal angle) for the equirectangular lens

    :type: float
    """

    ortho_scale: float
    """ Orthographic Camera scale (similar to zoom)

    :type: float
    """

    panorama_type: typing.Union[str, int]
    """ Distortion to use for the calculation

    :type: typing.Union[str, int]
    """

    passepartout_alpha: float
    """ Opacity (alpha) of the darkened overlay in Camera view

    :type: float
    """

    sensor_fit: typing.Union[str, int]
    """ Method to fit image and field of view angle inside the sensor

    :type: typing.Union[str, int]
    """

    sensor_height: float
    """ Vertical size of the image sensor area in millimeters

    :type: float
    """

    sensor_width: float
    """ Horizontal size of the image sensor area in millimeters

    :type: float
    """

    shift_x: float
    """ Camera horizontal shift

    :type: float
    """

    shift_y: float
    """ Camera vertical shift

    :type: float
    """

    show_background_images: bool
    """ Display reference images behind objects in the 3D View

    :type: bool
    """

    show_composition_center: bool
    """ Display center composition guide inside the camera view

    :type: bool
    """

    show_composition_center_diagonal: bool
    """ Display diagonal center composition guide inside the camera view

    :type: bool
    """

    show_composition_golden: bool
    """ Display golden ratio composition guide inside the camera view

    :type: bool
    """

    show_composition_golden_tria_a: bool
    """ Display golden triangle A composition guide inside the camera view

    :type: bool
    """

    show_composition_golden_tria_b: bool
    """ Display golden triangle B composition guide inside the camera view

    :type: bool
    """

    show_composition_harmony_tri_a: bool
    """ Display harmony A composition guide inside the camera view

    :type: bool
    """

    show_composition_harmony_tri_b: bool
    """ Display harmony B composition guide inside the camera view

    :type: bool
    """

    show_composition_thirds: bool
    """ Display rule of thirds composition guide inside the camera view

    :type: bool
    """

    show_limits: bool
    """ Display the clipping range and focus point on the camera

    :type: bool
    """

    show_mist: bool
    """ Display a line from the Camera to indicate the mist area

    :type: bool
    """

    show_name: bool
    """ Show the active Camera's name in Camera view

    :type: bool
    """

    show_passepartout: bool
    """ Show a darkened overlay outside the image area in Camera view

    :type: bool
    """

    show_safe_areas: bool
    """ Show TV title safe and action safe areas in Camera view

    :type: bool
    """

    show_safe_center: bool
    """ Show safe areas to fit content in a different aspect ratio

    :type: bool
    """

    show_sensor: bool
    """ Show sensor size (film gate) in Camera view

    :type: bool
    """

    stereo: CameraStereoData
    """ 

    :type: CameraStereoData
    """

    type: typing.Union[str, int]
    """ Camera types

    :type: typing.Union[str, int]
    """

    def view_frame(self, scene: Scene = None) -> Scene:
        """Return 4 points for the cameras frame (before object transformation)

                :param scene: Scene to use for aspect calculation, when omitted 1:1 aspect is used
                :type scene: Scene
                :return: result_1, Result, `mathutils.Vector` of 3 items in [-inf, inf]

        result_2, Result, `mathutils.Vector` of 3 items in [-inf, inf]

        result_3, Result, `mathutils.Vector` of 3 items in [-inf, inf]

        result_4, Result, `mathutils.Vector` of 3 items in [-inf, inf]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CameraBackgroundImage(bpy_struct):
    """Image and settings for display in the 3D View background"""

    alpha: float
    """ Image opacity to blend the image against the background color

    :type: float
    """

    clip: MovieClip
    """ Movie clip displayed and edited in this space

    :type: MovieClip
    """

    clip_user: MovieClipUser
    """ Parameters defining which frame of the movie clip is displayed

    :type: MovieClipUser
    """

    display_depth: typing.Union[str, int]
    """ Display under or over everything

    :type: typing.Union[str, int]
    """

    frame_method: typing.Union[str, int]
    """ How the image fits in the camera frame

    :type: typing.Union[str, int]
    """

    image: Image
    """ Image displayed and edited in this space

    :type: Image
    """

    image_user: ImageUser
    """ Parameters defining which layer, pass and frame of the image is displayed

    :type: ImageUser
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override camera, whether this background image comes from the linked reference camera, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    offset: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    rotation: float
    """ Rotation for the background image (ortho view only)

    :type: float
    """

    scale: float
    """ Scale the background image

    :type: float
    """

    show_background_image: bool
    """ Show this image as background

    :type: bool
    """

    show_expanded: bool
    """ Show the details in the user interface

    :type: bool
    """

    show_on_foreground: bool
    """ Show this image in front of objects in viewport

    :type: bool
    """

    source: typing.Union[str, int]
    """ Data source used for background

    :type: typing.Union[str, int]
    """

    use_camera_clip: bool
    """ Use movie clip from active scene camera

    :type: bool
    """

    use_flip_x: bool
    """ Flip the background image horizontally

    :type: bool
    """

    use_flip_y: bool
    """ Flip the background image vertically

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CameraBackgroundImages(bpy_struct):
    """Collection of background images"""

    def new(self) -> bpy_struct:
        """Add new background image

        :return: Image displayed as viewport background
        :rtype: CameraBackgroundImage
        """
        ...

    def remove(self, image: CameraBackgroundImage):
        """Remove background image

        :param image: Image displayed as viewport background
        :type image: CameraBackgroundImage
        """
        ...

    def clear(self):
        """Remove all background images"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CameraDOFSettings(bpy_struct):
    """Depth of Field settings"""

    aperture_blades: int
    """ Number of blades in aperture for polygonal bokeh (at least 3)

    :type: int
    """

    aperture_fstop: float
    """ F-Stop ratio (lower numbers give more defocus, higher numbers give a sharper image)

    :type: float
    """

    aperture_ratio: float
    """ Distortion to simulate anamorphic lens bokeh

    :type: float
    """

    aperture_rotation: float
    """ Rotation of blades in aperture

    :type: float
    """

    focus_distance: float
    """ Distance to the focus point for depth of field

    :type: float
    """

    focus_object: Object
    """ Use this object to define the depth of field focal point

    :type: Object
    """

    focus_subtarget: typing.Union[str, typing.Any]
    """ Use this armature bone to define the depth of field focal point

    :type: typing.Union[str, typing.Any]
    """

    use_dof: bool
    """ Use Depth of Field

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CameraSolverConstraint(bpy_struct):
    """Lock motion to the reconstructed camera movement"""

    clip: MovieClip
    """ Movie Clip to get tracking data from

    :type: MovieClip
    """

    use_active_clip: bool
    """ Use active clip defined in scene

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CameraStereoData(bpy_struct):
    """Stereoscopy settings for a Camera data-block"""

    convergence_distance: float
    """ The converge point for the stereo cameras (often the distance between a projector and the projection screen)

    :type: float
    """

    convergence_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    interocular_distance: float
    """ Set the distance between the eyes - the stereo plane distance / 30 should be fine

    :type: float
    """

    pivot: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    pole_merge_angle_from: float
    """ Angle at which interocular distance starts to fade to 0

    :type: float
    """

    pole_merge_angle_to: float
    """ Angle at which interocular distance is 0

    :type: float
    """

    use_pole_merge: bool
    """ Fade interocular distance to 0 after the given cutoff angle

    :type: bool
    """

    use_spherical_stereo: bool
    """ Render every pixel rotating the camera around the middle of the interocular distance

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CastModifier(bpy_struct):
    """Modifier to cast to other shapes"""

    cast_type: typing.Union[str, int]
    """ Target object shape

    :type: typing.Union[str, int]
    """

    factor: float
    """ 

    :type: float
    """

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    object: Object
    """ Control object: if available, its location determines the center of the effect

    :type: Object
    """

    radius: float
    """ Only deform vertices within this distance from the center of the effect (leave as 0 for infinite.)

    :type: float
    """

    size: float
    """ Size of projection shape (leave as 0 for auto)

    :type: float
    """

    use_radius_as_size: bool
    """ Use radius as size of projection shape (0 = auto)

    :type: bool
    """

    use_transform: bool
    """ Use object transform to control projection shape

    :type: bool
    """

    use_x: bool
    """ 

    :type: bool
    """

    use_y: bool
    """ 

    :type: bool
    """

    use_z: bool
    """ 

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Vertex group name

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ChannelDriverVariables(bpy_struct):
    """Collection of channel driver Variables"""

    def new(self) -> bpy_struct:
        """Add a new variable for the driver

        :return: Newly created Driver Variable
        :rtype: DriverVariable
        """
        ...

    def remove(self, variable: DriverVariable):
        """Remove an existing variable from the driver

        :param variable: Variable to remove from the driver
        :type variable: DriverVariable
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ChildOfConstraint(bpy_struct):
    """Create constraint-based parent-child relationship"""

    inverse_matrix: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Transformation matrix to apply before

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    set_inverse_pending: bool
    """ Set to true to request recalculation of the inverse matrix

    :type: bool
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    use_location_x: bool
    """ Use X Location of Parent

    :type: bool
    """

    use_location_y: bool
    """ Use Y Location of Parent

    :type: bool
    """

    use_location_z: bool
    """ Use Z Location of Parent

    :type: bool
    """

    use_rotation_x: bool
    """ Use X Rotation of Parent

    :type: bool
    """

    use_rotation_y: bool
    """ Use Y Rotation of Parent

    :type: bool
    """

    use_rotation_z: bool
    """ Use Z Rotation of Parent

    :type: bool
    """

    use_scale_x: bool
    """ Use X Scale of Parent

    :type: bool
    """

    use_scale_y: bool
    """ Use Y Scale of Parent

    :type: bool
    """

    use_scale_z: bool
    """ Use Z Scale of Parent

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ChildParticle(bpy_struct):
    """Child particle interpolated from simulated or edited particles"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ClampToConstraint(bpy_struct):
    """Constrain an object's location to the nearest point along the target path"""

    main_axis: typing.Union[str, int]
    """ Main axis of movement

    :type: typing.Union[str, int]
    """

    target: Object
    """ Target Object (Curves only)

    :type: Object
    """

    use_cyclic: bool
    """ Treat curve as cyclic curve (no clamping to curve bounding box)

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ClothCollisionSettings(bpy_struct):
    """Cloth simulation settings for self collision and collision with other objects"""

    collection: Collection
    """ Limit colliders to this Collection

    :type: Collection
    """

    collision_quality: int
    """ How many collision iterations should be done. (higher is better quality but slower)

    :type: int
    """

    damping: float
    """ Amount of velocity lost on collision

    :type: float
    """

    distance_min: float
    """ Minimum distance between collision objects before collision response takes effect

    :type: float
    """

    friction: float
    """ Friction force if a collision happened (higher = less movement)

    :type: float
    """

    impulse_clamp: float
    """ Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    """

    self_distance_min: float
    """ Minimum distance between cloth faces before collision response takes effect

    :type: float
    """

    self_friction: float
    """ Friction with self contact

    :type: float
    """

    self_impulse_clamp: float
    """ Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    """

    use_collision: bool
    """ Enable collisions with other objects

    :type: bool
    """

    use_self_collision: bool
    """ Enable self collisions

    :type: bool
    """

    vertex_group_object_collisions: typing.Union[str, typing.Any]
    """ Triangles with all vertices in this group are not used during object collisions

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_self_collisions: typing.Union[str, typing.Any]
    """ Triangles with all vertices in this group are not used during self collisions

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ClothModifier(bpy_struct):
    """Cloth simulation modifier"""

    collision_settings: ClothCollisionSettings
    """ 

    :type: ClothCollisionSettings
    """

    hair_grid_max: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    hair_grid_min: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    hair_grid_resolution: bpy_prop_array[int]
    """ 

    :type: bpy_prop_array[int]
    """

    point_cache: PointCache
    """ 

    :type: PointCache
    """

    settings: ClothSettings
    """ 

    :type: ClothSettings
    """

    solver_result: ClothSolverResult
    """ 

    :type: ClothSolverResult
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ClothSettings(bpy_struct):
    """Cloth simulation settings for an object"""

    air_damping: float
    """ Air has normally some thickness which slows falling things down

    :type: float
    """

    bending_damping: float
    """ Amount of damping in bending behavior

    :type: float
    """

    bending_model: typing.Union[str, int]
    """ Physical model for simulating bending forces

    :type: typing.Union[str, int]
    """

    bending_stiffness: float
    """ How much the material resists bending

    :type: float
    """

    bending_stiffness_max: float
    """ Maximum bending stiffness value

    :type: float
    """

    collider_friction: float
    """ 

    :type: float
    """

    compression_damping: float
    """ Amount of damping in compression behavior

    :type: float
    """

    compression_stiffness: float
    """ How much the material resists compression

    :type: float
    """

    compression_stiffness_max: float
    """ Maximum compression stiffness value

    :type: float
    """

    density_strength: float
    """ Influence of target density on the simulation

    :type: float
    """

    density_target: float
    """ Maximum density of hair

    :type: float
    """

    effector_weights: EffectorWeights
    """ 

    :type: EffectorWeights
    """

    fluid_density: float
    """ Density (kg/l) of the fluid contained inside the object, used to create a hydrostatic pressure gradient simulating the weight of the internal fluid, or buoyancy from the surrounding fluid if negative

    :type: float
    """

    goal_default: float
    """ Default Goal (vertex target position) value, when no Vertex Group used

    :type: float
    """

    goal_friction: float
    """ Goal (vertex target position) friction

    :type: float
    """

    goal_max: float
    """ Goal maximum, vertex group weights are scaled to match this range

    :type: float
    """

    goal_min: float
    """ Goal minimum, vertex group weights are scaled to match this range

    :type: float
    """

    goal_spring: float
    """ Goal (vertex target position) spring stiffness

    :type: float
    """

    gravity: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Gravity or external force vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    internal_compression_stiffness: float
    """ How much the material resists compression

    :type: float
    """

    internal_compression_stiffness_max: float
    """ Maximum compression stiffness value

    :type: float
    """

    internal_friction: float
    """ 

    :type: float
    """

    internal_spring_max_diversion: float
    """ How much the rays used to connect the internal points can diverge from the vertex normal

    :type: float
    """

    internal_spring_max_length: float
    """ The maximum length an internal spring can have during creation. If the distance between internal points is greater than this, no internal spring will be created between these points. A length of zero means that there is no length limit

    :type: float
    """

    internal_spring_normal_check: bool
    """ Require the points the internal springs connect to have opposite normal directions

    :type: bool
    """

    internal_tension_stiffness: float
    """ How much the material resists stretching

    :type: float
    """

    internal_tension_stiffness_max: float
    """ Maximum tension stiffness value

    :type: float
    """

    mass: float
    """ The mass of each vertex on the cloth material

    :type: float
    """

    pin_stiffness: float
    """ Pin (vertex target position) spring stiffness

    :type: float
    """

    pressure_factor: float
    """ Ambient pressure (kPa) that balances out between the inside and outside of the object when it has the target volume

    :type: float
    """

    quality: int
    """ Quality of the simulation in steps per frame (higher is better quality but slower)

    :type: int
    """

    rest_shape_key: ShapeKey
    """ Shape key to use the rest spring lengths from

    :type: ShapeKey
    """

    sewing_force_max: float
    """ Maximum sewing force

    :type: float
    """

    shear_damping: float
    """ Amount of damping in shearing behavior

    :type: float
    """

    shear_stiffness: float
    """ How much the material resists shearing

    :type: float
    """

    shear_stiffness_max: float
    """ Maximum shear scaling value

    :type: float
    """

    shrink_max: float
    """ Max amount to shrink cloth by

    :type: float
    """

    shrink_min: float
    """ Factor by which to shrink cloth

    :type: float
    """

    target_volume: float
    """ The mesh volume where the inner/outer pressure will be the same. If set to zero the change in volume will not affect pressure

    :type: float
    """

    tension_damping: float
    """ Amount of damping in stretching behavior

    :type: float
    """

    tension_stiffness: float
    """ How much the material resists stretching

    :type: float
    """

    tension_stiffness_max: float
    """ Maximum tension stiffness value

    :type: float
    """

    time_scale: float
    """ Cloth speed is multiplied by this value

    :type: float
    """

    uniform_pressure_force: float
    """ The uniform pressure that is constantly applied to the mesh, in units of Pressure Scale. Can be negative

    :type: float
    """

    use_dynamic_mesh: bool
    """ Make simulation respect deformations in the base mesh

    :type: bool
    """

    use_internal_springs: bool
    """ Simulate an internal volume structure by creating springs connecting the opposite sides of the mesh

    :type: bool
    """

    use_pressure: bool
    """ Simulate pressure inside a closed cloth mesh

    :type: bool
    """

    use_pressure_volume: bool
    """ Use the Target Volume parameter as the initial volume, instead of calculating it from the mesh itself

    :type: bool
    """

    use_sewing_springs: bool
    """ Pulls loose edges together

    :type: bool
    """

    vertex_group_bending: typing.Union[str, typing.Any]
    """ Vertex group for fine control over bending stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_intern: typing.Union[str, typing.Any]
    """ Vertex group for fine control over the internal spring stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_mass: typing.Union[str, typing.Any]
    """ Vertex Group for pinning of vertices

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_pressure: typing.Union[str, typing.Any]
    """ Vertex Group for where to apply pressure. Zero weight means no pressure while a weight of one means full pressure. Faces with a vertex that has zero weight will be excluded from the volume calculation

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_shear_stiffness: typing.Union[str, typing.Any]
    """ Vertex group for fine control over shear stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_shrink: typing.Union[str, typing.Any]
    """ Vertex Group for shrinking cloth

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_structural_stiffness: typing.Union[str, typing.Any]
    """ Vertex group for fine control over structural stiffness

    :type: typing.Union[str, typing.Any]
    """

    voxel_cell_size: float
    """ Size of the voxel grid cells for interaction effects

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ClothSolverResult(bpy_struct):
    """Result of cloth solver iteration"""

    avg_error: float
    """ Average error during substeps

    :type: float
    """

    avg_iterations: float
    """ Average iterations during substeps

    :type: float
    """

    max_error: float
    """ Maximum error during substeps

    :type: float
    """

    max_iterations: int
    """ Maximum iterations during substeps

    :type: int
    """

    min_error: float
    """ Minimum error during substeps

    :type: float
    """

    min_iterations: int
    """ Minimum iterations during substeps

    :type: int
    """

    status: typing.Any
    """ Status of the solver iteration

    :type: typing.Any
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CloudsTexture(bpy_struct):
    """Procedural noise texture"""

    cloud_type: typing.Union[str, int]
    """ Determine whether Noise returns grayscale or RGB values

    :type: typing.Union[str, int]
    """

    nabla: float
    """ Size of derivative offset used for calculating normal

    :type: float
    """

    noise_basis: typing.Union[str, int]
    """ Noise basis used for turbulence

    :type: typing.Union[str, int]
    """

    noise_depth: int
    """ Depth of the cloud calculation

    :type: int
    """

    noise_scale: float
    """ Scaling for noise input

    :type: float
    """

    noise_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    users_material: typing.Any
    """ Materials that use this texture(readonly)"""

    users_object_modifier: typing.Any
    """ Object modifiers that use this texture(readonly)"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Collection(bpy_struct):
    """Collection of Object data-blocks"""

    all_objects: bpy_prop_collection[Object]
    """ Objects that are in this collection and its child collections

    :type: bpy_prop_collection[Object]
    """

    children: bpy_prop_collection[Collection]
    """ Collections that are immediate children of this collection

    :type: bpy_prop_collection[Collection]
    """

    collection_children: bpy_prop_collection[CollectionChild]
    """ Children collections their parent-collection-specific settings

    :type: bpy_prop_collection[CollectionChild]
    """

    collection_objects: bpy_prop_collection[CollectionObject]
    """ Objects of the collection with their parent-collection-specific settings

    :type: bpy_prop_collection[CollectionObject]
    """

    color_tag: typing.Any
    """ Color tag for a collection"""

    hide_render: bool
    """ Globally disable in renders

    :type: bool
    """

    hide_select: bool
    """ Disable selection in viewport

    :type: bool
    """

    hide_viewport: bool
    """ Globally disable in viewports

    :type: bool
    """

    instance_offset: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Offset from the origin to use when instancing

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    lineart_intersection_mask: typing.List[bool]
    """ Intersection generated by this collection will have this mask value

    :type: typing.List[bool]
    """

    lineart_intersection_priority: int
    """ The intersection line will be included into the object with the higher intersection priority value

    :type: int
    """

    lineart_usage: typing.Union[str, int]
    """ How to use this collection in line art

    :type: typing.Union[str, int]
    """

    lineart_use_intersection_mask: bool
    """ Use custom intersection mask for faces in this collection

    :type: bool
    """

    objects: bpy_prop_collection[Object]
    """ Objects that are directly in this collection

    :type: bpy_prop_collection[Object]
    """

    use_lineart_intersection_priority: bool
    """ Assign intersection priority value for this collection

    :type: bool
    """

    children_recursive: typing.Any
    """ A list of all children from this collection.(readonly)"""

    users_dupli_group: typing.Any
    """ The collection instance objects this collection is used in(readonly)"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollectionChild(bpy_struct):
    """Child collection with its collection related settings"""

    light_linking: CollectionLightLinking
    """ Light linking settings of the collection object

    :type: CollectionLightLinking
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollectionChildren(bpy_struct):
    """Collection of child collections"""

    def link(self, child: Collection):
        """Add this collection as child of this collection

        :param child: Collection to add
        :type child: Collection
        """
        ...

    def unlink(self, child: Collection):
        """Remove this child collection from a collection

        :param child: Collection to remove
        :type child: Collection
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollectionLightLinking(bpy_struct):
    """Light linking settings of objects and children collections of a collection"""

    link_state: typing.Union[str, int]
    """ Light or shadow receiving state of the object or collection

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollectionObject(bpy_struct):
    """Object of a collection with its collection related settings"""

    light_linking: CollectionLightLinking
    """ Light linking settings of the collection

    :type: CollectionLightLinking
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollectionObjects(bpy_struct):
    """Collection of collection objects"""

    def link(self, object: Object):
        """Add this object to a collection

        :param object: Object to add
        :type object: Object
        """
        ...

    def unlink(self, object: Object):
        """Remove this object from a collection

        :param object: Object to remove
        :type object: Object
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollectionProperty(bpy_struct):
    """RNA collection property to define lists, arrays and mappings"""

    fixed_type: Struct
    """ Fixed pointer type, empty if variable type

    :type: Struct
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollisionModifier(bpy_struct):
    """Collision modifier defining modifier stack position used for collision"""

    settings: CollisionSettings
    """ 

    :type: CollisionSettings
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CollisionSettings(bpy_struct):
    """Collision settings for object in physics simulation"""

    absorption: float
    """ How much of effector force gets lost during collision with this object (in percent)

    :type: float
    """

    cloth_friction: float
    """ Friction for cloth collisions

    :type: float
    """

    damping: float
    """ Amount of damping during collision

    :type: float
    """

    damping_factor: float
    """ Amount of damping during particle collision

    :type: float
    """

    damping_random: float
    """ Random variation of damping

    :type: float
    """

    friction_factor: float
    """ Amount of friction during particle collision

    :type: float
    """

    friction_random: float
    """ Random variation of friction

    :type: float
    """

    permeability: float
    """ Chance that the particle will pass through the mesh

    :type: float
    """

    stickiness: float
    """ Amount of stickiness to surface collision

    :type: float
    """

    thickness_inner: float
    """ Inner face thickness (only used by softbodies)

    :type: float
    """

    thickness_outer: float
    """ Outer face thickness

    :type: float
    """

    use: bool
    """ Enable this object as a collider for physics systems

    :type: bool
    """

    use_culling: bool
    """ Cloth collision acts with respect to the collider normals (improves penetration recovery)

    :type: bool
    """

    use_normal: bool
    """ Cloth collision impulses act in the direction of the collider normals (more reliable in some cases)

    :type: bool
    """

    use_particle_kill: bool
    """ Kill collided particles

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorBalanceModifier(bpy_struct):
    """Color balance modifier for sequence strip"""

    color_balance: SequenceColorBalanceData
    """ 

    :type: SequenceColorBalanceData
    """

    color_multiply: float
    """ Multiply the intensity of each pixel

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorGpencilModifier(bpy_struct):
    """Change Hue/Saturation modifier"""

    curve: CurveMapping
    """ Custom curve to apply effect

    :type: CurveMapping
    """

    hue: float
    """ Color Hue

    :type: float
    """

    invert_layer_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_layers: bool
    """ Inverse filter

    :type: bool
    """

    invert_material_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_materials: bool
    """ Inverse filter

    :type: bool
    """

    layer: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    layer_pass: int
    """ Layer pass index

    :type: int
    """

    material: Material
    """ Material used for filtering effect

    :type: Material
    """

    modify_color: typing.Union[str, int]
    """ Set what colors of the stroke are affected

    :type: typing.Union[str, int]
    """

    pass_index: int
    """ Pass index

    :type: int
    """

    saturation: float
    """ Color Saturation

    :type: float
    """

    use_custom_curve: bool
    """ Use a custom curve to define color effect along the strokes

    :type: bool
    """

    value: float
    """ Color Value

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorManagedDisplaySettings(bpy_struct):
    """Color management specific to display device"""

    display_device: typing.Union[str, int]
    """ Display device name

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorManagedInputColorspaceSettings(bpy_struct):
    """Input color space settings"""

    is_data: bool
    """ Treat image as non-color data without color management, like normal or displacement maps

    :type: bool
    """

    name: typing.Any
    """ Color space in the image file, to convert to and from when saving and loading the image"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorManagedSequencerColorspaceSettings(bpy_struct):
    """Input color space settings"""

    name: typing.Any
    """ Color space that the sequencer operates in"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorManagedViewSettings(bpy_struct):
    """Color management settings used for displaying images on the display"""

    curve_mapping: CurveMapping
    """ Color curve mapping applied before display transform

    :type: CurveMapping
    """

    exposure: float
    """ Exposure (stops) applied before display transform

    :type: float
    """

    gamma: float
    """ Amount of gamma modification applied after display transform

    :type: float
    """

    look: typing.Union[str, int]
    """ Additional transform applied before view transform for artistic needs

    :type: typing.Union[str, int]
    """

    use_curve_mapping: bool
    """ Use RGB curved for pre-display transformation

    :type: bool
    """

    use_hdr_view: bool
    """ Enable high dynamic range display in rendered viewport, uncapping display brightness. This requires a monitor with HDR support and a view transform designed for HDR. 'Filmic' and 'AgX' do not generate HDR colors

    :type: bool
    """

    view_transform: typing.Union[str, int]
    """ View used when converting image to a display space

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorMapping(bpy_struct):
    """Color mapping settings"""

    blend_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Blend color to mix with texture output color

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    blend_factor: float
    """ 

    :type: float
    """

    blend_type: typing.Union[str, int]
    """ Mode used to mix with texture output color

    :type: typing.Union[str, int]
    """

    brightness: float
    """ Adjust the brightness of the texture

    :type: float
    """

    color_ramp: ColorRamp
    """ 

    :type: ColorRamp
    """

    contrast: float
    """ Adjust the contrast of the texture

    :type: float
    """

    saturation: float
    """ Adjust the saturation of colors in the texture

    :type: float
    """

    use_color_ramp: bool
    """ Toggle color ramp operations

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorMixSequence(bpy_struct):
    """Color Mix Sequence"""

    blend_effect: typing.Union[str, int]
    """ Method for controlling how the strip combines with other strips

    :type: typing.Union[str, int]
    """

    factor: float
    """ Percentage of how much the strip's colors affect other strips

    :type: float
    """

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_2: Sequence
    """ Second input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorRamp(bpy_struct):
    """Color ramp mapping a scalar value to a color"""

    color_mode: typing.Union[str, int]
    """ Set color mode to use for interpolation

    :type: typing.Union[str, int]
    """

    elements: bpy_prop_collection[ColorRampElement]
    """ 

    :type: bpy_prop_collection[ColorRampElement]
    """

    hue_interpolation: typing.Union[str, int]
    """ Set color interpolation

    :type: typing.Union[str, int]
    """

    interpolation: typing.Union[str, int]
    """ Set interpolation between color stops

    :type: typing.Union[str, int]
    """

    def evaluate(self, position: float) -> float:
        """Evaluate Color Ramp

        :param position: Position, Evaluate Color Ramp at position
        :type position: float
        :return: Color, Color at given position
        :rtype: bpy_prop_array[float]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorRampElement(bpy_struct):
    """Element defining a color at a position in the color ramp"""

    alpha: float
    """ Set alpha of selected color stop

    :type: float
    """

    color: bpy_prop_array[float]
    """ Set color of selected color stop

    :type: bpy_prop_array[float]
    """

    position: float
    """ Set position of selected color stop

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorRampElements(bpy_struct):
    """Collection of Color Ramp Elements"""

    def new(self, position: float) -> float:
        """Add element to Color Ramp

        :param position: Position, Position to add element
        :type position: float
        :return: New element
        :rtype: ColorRampElement
        """
        ...

    def remove(self, element: ColorRampElement):
        """Delete element from Color Ramp

        :param element: Element to remove
        :type element: ColorRampElement
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ColorSequence(bpy_struct):
    """Sequence strip creating an image filled with a single color"""

    color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Effect Strip color

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNode(bpy_struct):
    """ """

    def tag_need_exec(self):
        """Tag the node for compositor update"""
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeAlphaOver(bpy_struct):
    """ """

    premul: float
    """ Mix Factor

    :type: float
    """

    use_premultiply: bool
    """ 

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeAntiAliasing(bpy_struct):
    """ """

    contrast_limit: float
    """ How much to eliminate spurious edges to avoid artifacts (the larger value makes less active; the value 2.0, for example, means discard a detected edge if there is a neighboring edge that has 2.0 times bigger contrast than the current one)

    :type: float
    """

    corner_rounding: float
    """ How much sharp corners will be rounded

    :type: float
    """

    threshold: float
    """ Threshold to detect edges (smaller threshold makes more sensitive detection)

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeBilateralblur(bpy_struct):
    """ """

    iterations: int
    """ 

    :type: int
    """

    sigma_color: float
    """ 

    :type: float
    """

    sigma_space: float
    """ 

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeBlur(bpy_struct):
    """ """

    aspect_correction: typing.Union[str, int]
    """ Type of aspect correction to use

    :type: typing.Union[str, int]
    """

    factor: float
    """ 

    :type: float
    """

    factor_x: float
    """ 

    :type: float
    """

    factor_y: float
    """ 

    :type: float
    """

    filter_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    size_x: int
    """ 

    :type: int
    """

    size_y: int
    """ 

    :type: int
    """

    use_bokeh: bool
    """ Use circular filter (slower)

    :type: bool
    """

    use_extended_bounds: bool
    """ Extend bounds of the input image to fully fit blurred image

    :type: bool
    """

    use_gamma_correction: bool
    """ Apply filter on gamma corrected values

    :type: bool
    """

    use_relative: bool
    """ Use relative (percent) values to define blur radius

    :type: bool
    """

    use_variable_size: bool
    """ Support variable blur per pixel when using an image for size input

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeBokehBlur(bpy_struct):
    """ """

    blur_max: float
    """ Blur limit, maximum CoC radius

    :type: float
    """

    use_extended_bounds: bool
    """ Extend bounds of the input image to fully fit blurred image

    :type: bool
    """

    use_variable_size: bool
    """ Support variable blur per pixel when using an image for size input

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeBokehImage(bpy_struct):
    """ """

    angle: float
    """ Angle of the bokeh

    :type: float
    """

    catadioptric: float
    """ Level of catadioptric of the bokeh

    :type: float
    """

    flaps: int
    """ Number of flaps

    :type: int
    """

    rounding: float
    """ Level of rounding of the bokeh

    :type: float
    """

    shift: float
    """ Shift of the lens components

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeBoxMask(bpy_struct):
    """ """

    mask_height: float
    """ Height of the box

    :type: float
    """

    mask_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    mask_width: float
    """ Width of the box

    :type: float
    """

    rotation: float
    """ Rotation angle of the box

    :type: float
    """

    x: float
    """ X position of the middle of the box

    :type: float
    """

    y: float
    """ Y position of the middle of the box

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeBrightContrast(bpy_struct):
    """ """

    use_premultiply: bool
    """ Keep output image premultiplied alpha

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeChannelMatte(bpy_struct):
    """ """

    color_space: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    limit_channel: typing.Union[str, int]
    """ Limit by this channel's value

    :type: typing.Union[str, int]
    """

    limit_max: float
    """ Values higher than this setting are 100% opaque

    :type: float
    """

    limit_method: typing.Union[str, int]
    """ Algorithm to use to limit channel

    :type: typing.Union[str, int]
    """

    limit_min: float
    """ Values lower than this setting are 100% keyed

    :type: float
    """

    matte_channel: typing.Union[str, int]
    """ Channel used to determine matte

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeChromaMatte(bpy_struct):
    """ """

    gain: float
    """ Alpha falloff

    :type: float
    """

    lift: float
    """ Alpha lift

    :type: float
    """

    shadow_adjust: float
    """ Adjusts the brightness of any shadows captured

    :type: float
    """

    threshold: float
    """ Tolerance below which colors will be considered as exact matches

    :type: float
    """

    tolerance: float
    """ Tolerance for a color to be considered a keying color

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeColorBalance(bpy_struct):
    """ """

    correction_method: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    gain: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Correction for highlights

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    gamma: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Correction for midtones

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    lift: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Correction for shadows

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    offset: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Correction for entire tonal range

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    offset_basis: float
    """ Support negative color by using this as the RGB basis

    :type: float
    """

    power: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Correction for midtones

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    slope: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Correction for highlights

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    @classmethod
    def is_registered_node_type(
        cls,
    ) -> typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeColorCorrection(bpy_struct):
    """ """

    blue: bool
    """ Blue channel active

    :type: bool
    """

    green: bool
    """ Green channel active

    :type: bool
    """

    highlights_contrast: float
    """ Highlights contrast

    :type: float
    """

    highlights_gain: float
    """ Highlights gain

    :type: float
    """

    highlights_gamma: float
    """ Highlights gamma

    :type: float
    """

    highlights_lift: float
    """ Highlights lift

    :type: float
    """

    highlights_saturation: float
    """ Highlights saturation

    :type: float
    """

    master_contrast: float
    """ Master contrast

    :type: float
    """

    master_gain: float
    """ Master gain

    :type: float
    """

    master_gamma: float
    """ Master gamma

    :type: float
    """

    master_lift: float
    """ Master lift

    :type: float
    """

    master_saturation: float
    """ Master saturation

    :type: float
    """

    midtones_contrast: float
    """ Midtones contrast

    :type: float
    """

    midtones_end: float
    """ End of midtones

    :type: float
    """

    midtones_gain: float
    """ Midtones gain

    :type: float
    """

    midtones_gamma: float
    """ Midtones gamma

    :type: float
    """

    midtones_lift: float
    """ Midtones lift

    :type: float
    """

    midtones_saturation: float
    """ Midtones saturation

    :type: float
    """

    midtones_start: float
    """ Start of midtones

    :type: float
    """

    red: bool
    """ Red channel active

    :type: bool
    """

    shadows_contrast: float
    """ Shadows contrast

    :type: float
    """

    shadows_gain: float
    """ Shadows gain

    :type: float
    """

    shadows_gamma: float
    """ Shadows gamma

    :type: float
    """

    shadows_lift: float
    """ Shadows lift

    :type: float
    """

    shadows_saturation: float
    """ Shadows saturation

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeColorMatte(bpy_struct):
    """ """

    color_hue: float
    """ Hue tolerance for colors to be considered a keying color

    :type: float
    """

    color_saturation: float
    """ Saturation tolerance for the color

    :type: float
    """

    color_value: float
    """ Value tolerance for the color

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeColorSpill(bpy_struct):
    """ """

    channel: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    limit_channel: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    limit_method: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    ratio: float
    """ Scale limit by value

    :type: float
    """

    unspill_blue: float
    """ Blue spillmap scale

    :type: float
    """

    unspill_green: float
    """ Green spillmap scale

    :type: float
    """

    unspill_red: float
    """ Red spillmap scale

    :type: float
    """

    use_unspill: bool
    """ Compensate all channels (differently) by hand

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCombHSVA(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCombRGBA(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCombYCCA(bpy_struct):
    """ """

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCombYUVA(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCombineColor(bpy_struct):
    """ """

    mode: typing.Union[str, int]
    """ Mode of color processing

    :type: typing.Union[str, int]
    """

    ycc_mode: typing.Union[str, int]
    """ Color space used for YCbCrA processing

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCombineXYZ(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeComposite(bpy_struct):
    """ """

    use_alpha: bool
    """ Colors are treated alpha premultiplied, or colors output straight (alpha gets set to 1)

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeConvertColorSpace(bpy_struct):
    """ """

    from_color_space: typing.Any
    """ Color space of the input image"""

    to_color_space: typing.Any
    """ Color space of the output image"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCornerPin(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCrop(bpy_struct):
    """ """

    max_x: int
    """ 

    :type: int
    """

    max_y: int
    """ 

    :type: int
    """

    min_x: int
    """ 

    :type: int
    """

    min_y: int
    """ 

    :type: int
    """

    rel_max_x: float
    """ 

    :type: float
    """

    rel_max_y: float
    """ 

    :type: float
    """

    rel_min_x: float
    """ 

    :type: float
    """

    rel_min_y: float
    """ 

    :type: float
    """

    relative: bool
    """ Use relative values to crop image

    :type: bool
    """

    use_crop_size: bool
    """ Whether to crop the size of the input image

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCryptomatte(bpy_struct):
    """ """

    add: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Add object or material to matte, by picking a color from the Pick output

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    matte_id: typing.Union[str, typing.Any]
    """ List of object and material crypto IDs to include in matte

    :type: typing.Union[str, typing.Any]
    """

    remove: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Remove object or material from matte, by picking a color from the Pick output

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    @classmethod
    def is_registered_node_type(
        cls,
    ) -> typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCryptomatteV2(bpy_struct):
    """ """

    add: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Add object or material to matte, by picking a color from the Pick output

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    entries: bpy_prop_collection[CryptomatteEntry]
    """ 

    :type: bpy_prop_collection[CryptomatteEntry]
    """

    frame_duration: int
    """ Number of images of a movie to use

    :type: int
    """

    frame_offset: int
    """ Offset the number of the frame to use in the animation

    :type: int
    """

    frame_start: int
    """ Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    """

    has_layers: typing.Union[bool, typing.Any]
    """ True if this image has any named layer

    :type: typing.Union[bool, typing.Any]
    """

    has_views: typing.Union[bool, typing.Any]
    """ True if this image has multiple views

    :type: typing.Union[bool, typing.Any]
    """

    image: Image
    """ 

    :type: Image
    """

    layer: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    layer_name: typing.Union[str, int]
    """ What Cryptomatte layer is used

    :type: typing.Union[str, int]
    """

    matte_id: typing.Union[str, typing.Any]
    """ List of object and material crypto IDs to include in matte

    :type: typing.Union[str, typing.Any]
    """

    remove: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Remove object or material from matte, by picking a color from the Pick output

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    scene: Scene
    """ 

    :type: Scene
    """

    source: typing.Union[str, int]
    """ Where the Cryptomatte passes are loaded from

    :type: typing.Union[str, int]
    """

    use_auto_refresh: bool
    """ Always refresh image on frame changes

    :type: bool
    """

    use_cyclic: bool
    """ Cycle the images in the movie

    :type: bool
    """

    view: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCurveRGB(bpy_struct):
    """ """

    mapping: CurveMapping
    """ 

    :type: CurveMapping
    """

    @classmethod
    def is_registered_node_type(cls) -> CurveMapping:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCurveVec(bpy_struct):
    """ """

    mapping: CurveMapping
    """ 

    :type: CurveMapping
    """

    @classmethod
    def is_registered_node_type(cls) -> CurveMapping:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeCustomGroup(bpy_struct):
    """Custom Compositor Group Node for Python nodes"""

    node_tree: NodeTree
    """ 

    :type: NodeTree
    """

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDBlur(bpy_struct):
    """ """

    angle: float
    """ 

    :type: float
    """

    center_x: float
    """ 

    :type: float
    """

    center_y: float
    """ 

    :type: float
    """

    distance: float
    """ 

    :type: float
    """

    iterations: int
    """ 

    :type: int
    """

    spin: float
    """ 

    :type: float
    """

    zoom: float
    """ 

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDefocus(bpy_struct):
    """ """

    angle: float
    """ Bokeh shape rotation offset

    :type: float
    """

    blur_max: float
    """ Blur limit, maximum CoC radius

    :type: float
    """

    bokeh: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    f_stop: float
    """ Amount of focal blur, 128 (infinity) is perfect focus, half the value doubles the blur radius

    :type: float
    """

    scene: Scene
    """ Scene from which to select the active camera (render scene if undefined)

    :type: Scene
    """

    threshold: float
    """ CoC radius threshold, prevents background bleed on in-focus midground, 0 is disabled

    :type: float
    """

    use_gamma_correction: bool
    """ Enable gamma correction before and after main process

    :type: bool
    """

    use_preview: bool
    """ Enable low quality mode, useful for preview

    :type: bool
    """

    use_zbuffer: bool
    """ Disable when using an image as input instead of actual z-buffer (auto enabled if node not image based, eg. time node)

    :type: bool
    """

    z_scale: float
    """ Scale the Z input when not using a z-buffer, controls maximum blur designated by the color white or input value 1

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDenoise(bpy_struct):
    """ """

    prefilter: typing.Union[str, int]
    """ Denoising prefilter

    :type: typing.Union[str, int]
    """

    use_hdr: bool
    """ Process HDR images

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDespeckle(bpy_struct):
    """ """

    threshold: float
    """ Threshold for detecting pixels to despeckle

    :type: float
    """

    threshold_neighbor: float
    """ Threshold for the number of neighbor pixels that must match

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDiffMatte(bpy_struct):
    """ """

    falloff: float
    """ Color distances below this additional threshold are partially keyed

    :type: float
    """

    tolerance: float
    """ Color distances below this threshold are keyed

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDilateErode(bpy_struct):
    """ """

    distance: int
    """ Distance to grow/shrink (number of iterations)

    :type: int
    """

    edge: float
    """ Edge to inset

    :type: float
    """

    falloff: typing.Any
    """ Falloff type the feather"""

    mode: typing.Union[str, int]
    """ Growing/shrinking mode

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDisplace(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDistanceMatte(bpy_struct):
    """ """

    channel: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    falloff: float
    """ Color distances below this additional threshold are partially keyed

    :type: float
    """

    tolerance: float
    """ Color distances below this threshold are keyed

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeDoubleEdgeMask(bpy_struct):
    """ """

    edge_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    inner_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeEllipseMask(bpy_struct):
    """ """

    mask_height: float
    """ Height of the ellipse

    :type: float
    """

    mask_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    mask_width: float
    """ Width of the ellipse

    :type: float
    """

    rotation: float
    """ Rotation angle of the ellipse

    :type: float
    """

    x: float
    """ X position of the middle of the ellipse

    :type: float
    """

    y: float
    """ Y position of the middle of the ellipse

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeExposure(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeFilter(bpy_struct):
    """ """

    filter_type: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeFlip(bpy_struct):
    """ """

    axis: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeGamma(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeGlare(bpy_struct):
    """ """

    angle_offset: float
    """ Streak angle offset

    :type: float
    """

    color_modulation: float
    """ Amount of Color Modulation, modulates colors of streaks and ghosts for a spectral dispersion effect

    :type: float
    """

    fade: float
    """ Streak fade-out factor

    :type: float
    """

    glare_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    iterations: int
    """ 

    :type: int
    """

    mix: float
    """ -1 is original image only, 0 is exact 50/50 mix, 1 is processed image only

    :type: float
    """

    quality: typing.Union[str, int]
    """ If not set to high quality, the effect will be applied to a low-res copy of the source image

    :type: typing.Union[str, int]
    """

    size: int
    """ Glow/glare size (not actual size; relative to initial size of bright area of pixels)

    :type: int
    """

    streaks: int
    """ Total number of streaks

    :type: int
    """

    threshold: float
    """ The glare filter will only be applied to pixels brighter than this value

    :type: float
    """

    use_rotate_45: bool
    """ Simple star filter: add 45 degree rotation offset

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeGroup(bpy_struct):
    """ """

    node_tree: NodeTree
    """ 

    :type: NodeTree
    """

    @classmethod
    def is_registered_node_type(cls) -> NodeTree:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeHueCorrect(bpy_struct):
    """ """

    mapping: CurveMapping
    """ 

    :type: CurveMapping
    """

    @classmethod
    def is_registered_node_type(cls) -> CurveMapping:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeHueSat(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeIDMask(bpy_struct):
    """ """

    index: int
    """ Pass index number to convert to alpha

    :type: int
    """

    use_antialiasing: bool
    """ Apply an anti-aliasing filter to the mask

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeImage(bpy_struct):
    """ """

    frame_duration: int
    """ Number of images of a movie to use

    :type: int
    """

    frame_offset: int
    """ Offset the number of the frame to use in the animation

    :type: int
    """

    frame_start: int
    """ Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    """

    has_layers: typing.Union[bool, typing.Any]
    """ True if this image has any named layer

    :type: typing.Union[bool, typing.Any]
    """

    has_views: typing.Union[bool, typing.Any]
    """ True if this image has multiple views

    :type: typing.Union[bool, typing.Any]
    """

    image: Image
    """ 

    :type: Image
    """

    layer: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    use_auto_refresh: bool
    """ Always refresh image on frame changes

    :type: bool
    """

    use_cyclic: bool
    """ Cycle the images in the movie

    :type: bool
    """

    use_straight_alpha_output: bool
    """ Put node output buffer to straight alpha instead of premultiplied

    :type: bool
    """

    view: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeInpaint(bpy_struct):
    """ """

    distance: int
    """ Distance to inpaint (number of iterations)

    :type: int
    """

    @classmethod
    def is_registered_node_type(cls) -> int:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeInvert(bpy_struct):
    """ """

    invert_alpha: bool
    """ 

    :type: bool
    """

    invert_rgb: bool
    """ 

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeKeying(bpy_struct):
    """ """

    blur_post: int
    """ Matte blur size which applies after clipping and dilate/eroding

    :type: int
    """

    blur_pre: int
    """ Chroma pre-blur size which applies before running keyer

    :type: int
    """

    clip_black: float
    """ Value of non-scaled matte pixel which considers as fully background pixel

    :type: float
    """

    clip_white: float
    """ Value of non-scaled matte pixel which considers as fully foreground pixel

    :type: float
    """

    despill_balance: float
    """ Balance between non-key colors used to detect amount of key color to be removed

    :type: float
    """

    despill_factor: float
    """ Factor of despilling screen color from image

    :type: float
    """

    dilate_distance: int
    """ Distance to grow/shrink the matte

    :type: int
    """

    edge_kernel_radius: int
    """ Radius of kernel used to detect whether pixel belongs to edge

    :type: int
    """

    edge_kernel_tolerance: float
    """ Tolerance to pixels inside kernel which are treating as belonging to the same plane

    :type: float
    """

    feather_distance: int
    """ Distance to grow/shrink the feather

    :type: int
    """

    feather_falloff: typing.Any
    """ Falloff type the feather"""

    screen_balance: float
    """ Balance between two non-primary channels primary channel is comparing against

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeKeyingScreen(bpy_struct):
    """ """

    clip: MovieClip
    """ 

    :type: MovieClip
    """

    smoothness: float
    """ 

    :type: float
    """

    tracking_object: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, typing.Any]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeKuwahara(bpy_struct):
    """ """

    eccentricity: float
    """ Controls how directional the filter is. 0 means the filter is completely omnidirectional while 2 means it is maximally directed along the edges of the image

    :type: float
    """

    sharpness: float
    """ Controls the sharpness of the filter. 0 means completely smooth while 1 means completely sharp

    :type: float
    """

    uniformity: int
    """ Controls the uniformity of the direction of the filter. Higher values produces more uniform directions

    :type: int
    """

    use_high_precision: bool
    """ Uses a more precise but slower method. Use if the output contains undesirable noise

    :type: bool
    """

    variation: typing.Union[str, int]
    """ Variation of Kuwahara filter to use

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeLensdist(bpy_struct):
    """ """

    use_fit: bool
    """ For positive distortion factor only: scale image such that black areas are not visible

    :type: bool
    """

    use_jitter: bool
    """ Enable/disable jittering (faster, but also noisier)

    :type: bool
    """

    use_projector: bool
    """ Enable/disable projector mode (the effect is applied in horizontal direction only)

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeLevels(bpy_struct):
    """ """

    channel: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeLumaMatte(bpy_struct):
    """ """

    limit_max: float
    """ Values higher than this setting are 100% opaque

    :type: float
    """

    limit_min: float
    """ Values lower than this setting are 100% keyed

    :type: float
    """

    @classmethod
    def is_registered_node_type(cls) -> float:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMapRange(bpy_struct):
    """ """

    use_clamp: bool
    """ Clamp the result of the node to the target range

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMapUV(bpy_struct):
    """ """

    alpha: int
    """ 

    :type: int
    """

    filter_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMapValue(bpy_struct):
    """ """

    max: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    min: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    offset: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    size: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    use_max: bool
    """ 

    :type: bool
    """

    use_min: bool
    """ 

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMask(bpy_struct):
    """ """

    mask: Mask
    """ 

    :type: Mask
    """

    motion_blur_samples: int
    """ Number of motion blur samples

    :type: int
    """

    motion_blur_shutter: float
    """ Exposure for motion blur as a factor of FPS

    :type: float
    """

    size_source: typing.Union[str, int]
    """ Where to get the mask size from for aspect/size information

    :type: typing.Union[str, int]
    """

    size_x: int
    """ 

    :type: int
    """

    size_y: int
    """ 

    :type: int
    """

    use_feather: bool
    """ Use feather information from the mask

    :type: bool
    """

    use_motion_blur: bool
    """ Use multi-sampled motion blur of the mask

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMath(bpy_struct):
    """ """

    operation: typing.Any
    """ """

    use_clamp: bool
    """ Clamp result of the node to 0.0 to 1.0 range

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMixRGB(bpy_struct):
    """ """

    blend_type: typing.Any
    """ """

    use_alpha: bool
    """ Include alpha of second input in this operation

    :type: bool
    """

    use_clamp: bool
    """ Clamp result of the node to 0.0 to 1.0 range

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMovieClip(bpy_struct):
    """ """

    clip: MovieClip
    """ 

    :type: MovieClip
    """

    @classmethod
    def is_registered_node_type(cls) -> MovieClip:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeMovieDistortion(bpy_struct):
    """ """

    clip: MovieClip
    """ 

    :type: MovieClip
    """

    distortion_type: typing.Union[str, int]
    """ Distortion to use to filter image

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeNormal(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeNormalize(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeOutputFile(bpy_struct):
    """ """

    active_input_index: int
    """ Active input index in details view list

    :type: int
    """

    base_path: typing.Union[str, typing.Any]
    """ Base output path for the image

    :type: typing.Union[str, typing.Any]
    """

    file_slots: bpy_prop_collection[NodeOutputFileSlotFile]
    """ 

    :type: bpy_prop_collection[NodeOutputFileSlotFile]
    """

    format: ImageFormatSettings
    """ 

    :type: ImageFormatSettings
    """

    layer_slots: bpy_prop_collection[NodeOutputFileSlotLayer]
    """ 

    :type: bpy_prop_collection[NodeOutputFileSlotLayer]
    """

    @classmethod
    def is_registered_node_type(cls) -> bpy_prop_collection[NodeOutputFileSlotLayer]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeOutputFileFileSlots(bpy_struct):
    """Collection of File Output node slots"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a file slot to this node

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :return: New socket
        :rtype: NodeSocket
        """
        ...

    def remove(self, socket: NodeSocket):
        """Remove a file slot from this node

        :param socket: The socket to remove
        :type socket: NodeSocket
        """
        ...

    def clear(self):
        """Remove all file slots from this node"""
        ...

    def move(self, from_index: int, to_index: int):
        """Move a file slot to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeOutputFileLayerSlots(bpy_struct):
    """Collection of File Output node slots"""

    def new(self, name: typing.Union[str, typing.Any]) -> typing.Union[str, typing.Any]:
        """Add a file slot to this node

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :return: New socket
        :rtype: NodeSocket
        """
        ...

    def remove(self, socket: NodeSocket):
        """Remove a file slot from this node

        :param socket: The socket to remove
        :type socket: NodeSocket
        """
        ...

    def clear(self):
        """Remove all file slots from this node"""
        ...

    def move(self, from_index: int, to_index: int):
        """Move a file slot to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: int
        :param to_index: To Index, Target index for the socket
        :type to_index: int
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodePixelate(bpy_struct):
    """ """

    pixel_size: int
    """ Pixel size of the output image

    :type: int
    """

    @classmethod
    def is_registered_node_type(cls) -> int:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodePlaneTrackDeform(bpy_struct):
    """ """

    clip: MovieClip
    """ 

    :type: MovieClip
    """

    motion_blur_samples: int
    """ Number of motion blur samples

    :type: int
    """

    motion_blur_shutter: float
    """ Exposure for motion blur as a factor of FPS

    :type: float
    """

    plane_track_name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    tracking_object: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_motion_blur: bool
    """ Use multi-sampled motion blur of the mask

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodePosterize(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodePremulKey(bpy_struct):
    """ """

    mapping: typing.Union[str, int]
    """ Conversion between premultiplied alpha and key alpha

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeRGB(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeRGBToBW(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeRLayers(bpy_struct):
    """ """

    layer: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    scene: Scene
    """ 

    :type: Scene
    """

    @classmethod
    def is_registered_node_type(cls) -> Scene:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeRotate(bpy_struct):
    """ """

    filter_type: typing.Union[str, int]
    """ Method to use to filter rotation

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeScale(bpy_struct):
    """ """

    frame_method: typing.Union[str, int]
    """ How the image fits in the camera frame

    :type: typing.Union[str, int]
    """

    offset_x: float
    """ Offset image horizontally (factor of image size)

    :type: float
    """

    offset_y: float
    """ Offset image vertically (factor of image size)

    :type: float
    """

    space: typing.Union[str, int]
    """ Coordinate space to scale relative to

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSceneTime(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSepHSVA(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSepRGBA(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSepYCCA(bpy_struct):
    """ """

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSepYUVA(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSeparateColor(bpy_struct):
    """ """

    mode: typing.Union[str, int]
    """ Mode of color processing

    :type: typing.Union[str, int]
    """

    ycc_mode: typing.Union[str, int]
    """ Color space used for YCbCrA processing

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSeparateXYZ(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSetAlpha(bpy_struct):
    """ """

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSplit(bpy_struct):
    """ """

    axis: typing.Any
    """ """

    factor: int
    """ 

    :type: int
    """

    @classmethod
    def is_registered_node_type(cls) -> int:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeStabilize(bpy_struct):
    """ """

    clip: MovieClip
    """ 

    :type: MovieClip
    """

    filter_type: typing.Union[str, int]
    """ Method to use to filter stabilization

    :type: typing.Union[str, int]
    """

    invert: bool
    """ Invert stabilization to re-introduce motion to the frame

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSunBeams(bpy_struct):
    """ """

    ray_length: float
    """ Length of rays as a factor of the image size

    :type: float
    """

    source: bpy_prop_array[float]
    """ Source point of rays as a factor of the image width and height

    :type: bpy_prop_array[float]
    """

    @classmethod
    def is_registered_node_type(cls) -> bpy_prop_array[float]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSwitch(bpy_struct):
    """ """

    check: bool
    """ Off: first socket, On: second socket

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeSwitchView(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTexture(bpy_struct):
    """ """

    node_output: int
    """ For node-based textures, which output node to use

    :type: int
    """

    texture: Texture
    """ 

    :type: Texture
    """

    @classmethod
    def is_registered_node_type(cls) -> Texture:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTime(bpy_struct):
    """ """

    curve: CurveMapping
    """ 

    :type: CurveMapping
    """

    frame_end: int
    """ 

    :type: int
    """

    frame_start: int
    """ 

    :type: int
    """

    @classmethod
    def is_registered_node_type(cls) -> int:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTonemap(bpy_struct):
    """ """

    adaptation: float
    """ If 0, global; if 1, based on pixel intensity

    :type: float
    """

    contrast: float
    """ Set to 0 to use estimate from input image

    :type: float
    """

    correction: float
    """ If 0, same for all channels; if 1, each independent

    :type: float
    """

    gamma: float
    """ If not used, set to 1

    :type: float
    """

    intensity: float
    """ If less than zero, darkens image; otherwise, makes it brighter

    :type: float
    """

    key: float
    """ The value the average luminance is mapped to

    :type: float
    """

    offset: float
    """ Normally always 1, but can be used as an extra control to alter the brightness curve

    :type: float
    """

    tonemap_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTrackPos(bpy_struct):
    """ """

    clip: MovieClip
    """ 

    :type: MovieClip
    """

    frame_relative: int
    """ Frame to be used for relative position

    :type: int
    """

    position: typing.Union[str, int]
    """ Which marker position to use for output

    :type: typing.Union[str, int]
    """

    track_name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    tracking_object: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, typing.Any]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTransform(bpy_struct):
    """ """

    filter_type: typing.Union[str, int]
    """ Method to use to filter transform

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTranslate(bpy_struct):
    """ """

    use_relative: bool
    """ Use relative (fraction of input image size) values to define translation

    :type: bool
    """

    wrap_axis: typing.Union[str, int]
    """ Wrap image on a specific axis

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeTree(bpy_struct):
    """Node tree consisting of linked nodes used for compositing"""

    edit_quality: typing.Union[str, int]
    """ Quality when editing

    :type: typing.Union[str, int]
    """

    execution_mode: typing.Union[str, int]
    """ Set how compositing is executed

    :type: typing.Union[str, int]
    """

    precision: typing.Union[str, int]
    """ The precision of compositor intermediate result

    :type: typing.Union[str, int]
    """

    render_quality: typing.Union[str, int]
    """ Quality when rendering

    :type: typing.Union[str, int]
    """

    use_two_pass: bool
    """ Use two pass execution during editing: first calculate fast nodes, second pass calculate all nodes

    :type: bool
    """

    use_viewer_border: bool
    """ Use boundaries for viewer nodes and composite backdrop

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeValToRGB(bpy_struct):
    """ """

    color_ramp: ColorRamp
    """ 

    :type: ColorRamp
    """

    @classmethod
    def is_registered_node_type(cls) -> ColorRamp:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeValue(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeVecBlur(bpy_struct):
    """ """

    factor: float
    """ Scaling factor for motion vectors (actually, 'shutter speed', in frames)

    :type: float
    """

    samples: int
    """ 

    :type: int
    """

    speed_max: int
    """ Maximum speed, or zero for none

    :type: int
    """

    speed_min: int
    """ Minimum speed for a pixel to be blurred (used to separate background from foreground)

    :type: int
    """

    use_curved: bool
    """ Interpolate between frames in a Bézier curve, rather than linearly

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeViewer(bpy_struct):
    """ """

    center_x: float
    """ 

    :type: float
    """

    center_y: float
    """ 

    :type: float
    """

    tile_order: typing.Union[str, int]
    """ Tile order

    :type: typing.Union[str, int]
    """

    use_alpha: bool
    """ Colors are treated alpha premultiplied, or colors output straight (alpha gets set to 1)

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CompositorNodeZcombine(bpy_struct):
    """ """

    use_alpha: bool
    """ Take alpha channel into account when doing the Z operation

    :type: bool
    """

    use_antialias_z: bool
    """ Anti-alias the z-buffer to try to avoid artifacts, mostly useful for Blender renders

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    def update(self):
        """ """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ConsoleLine(bpy_struct):
    """Input line for the interactive console"""

    body: typing.Union[str, typing.Any]
    """ Text in the line

    :type: typing.Union[str, typing.Any]
    """

    current_character: int
    """ 

    :type: int
    """

    type: typing.Union[str, int]
    """ Console line type when used in scrollback

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Constraint(bpy_struct):
    """Constraint modifying the transformation of objects and bones"""

    active: bool
    """ Constraint is the one being edited

    :type: bool
    """

    enabled: bool
    """ Use the results of this constraint

    :type: bool
    """

    error_location: float
    """ Amount of residual error in Blender space unit for constraints that work on position

    :type: float
    """

    error_rotation: float
    """ Amount of residual error in radians for constraints that work on orientation

    :type: float
    """

    influence: float
    """ Amount of influence constraint will have on the final solution

    :type: float
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this constraint comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Constraint has valid settings and can be evaluated

    :type: typing.Union[bool, typing.Any]
    """

    mute: bool
    """ Enable/Disable Constraint

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Constraint name

    :type: typing.Union[str, typing.Any]
    """

    owner_space: typing.Union[str, int]
    """ Space that owner is evaluated in

    :type: typing.Union[str, int]
    """

    show_expanded: bool
    """ Constraint's panel is expanded in UI

    :type: bool
    """

    space_object: Object
    """ Object for Custom Space

    :type: Object
    """

    space_subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target_space: typing.Union[str, int]
    """ Space that target is evaluated in

    :type: typing.Union[str, int]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ConstraintTarget(bpy_struct):
    """Target object for multi-target constraints"""

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ConstraintTargetBone(bpy_struct):
    """Target bone for multi-target constraints"""

    subtarget: typing.Union[str, typing.Any]
    """ Target armature bone

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target armature

    :type: Object
    """

    weight: float
    """ Blending weight of this bone

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Context(bpy_struct):
    """Current windowmanager and data context"""

    area: Area
    """ 

    :type: Area
    """

    asset: AssetRepresentation
    """ 

    :type: AssetRepresentation
    """

    blend_data: BlendData
    """ 

    :type: BlendData
    """

    collection: Collection
    """ 

    :type: Collection
    """

    engine: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    gizmo_group: GizmoGroup
    """ 

    :type: GizmoGroup
    """

    layer_collection: LayerCollection
    """ 

    :type: LayerCollection
    """

    mode: typing.Any
    """ 

    :type: typing.Any
    """

    preferences: Preferences
    """ 

    :type: Preferences
    """

    region: Region
    """ 

    :type: Region
    """

    region_data: RegionView3D
    """ 

    :type: RegionView3D
    """

    scene: Scene
    """ 

    :type: Scene
    """

    screen: Screen
    """ 

    :type: Screen
    """

    space_data: Space
    """ The current space, may be None in background-mode, when the cursor is outside the window or when using menu-search

    :type: Space
    """

    tool_settings: ToolSettings
    """ 

    :type: ToolSettings
    """

    view_layer: ViewLayer
    """ 

    :type: ViewLayer
    """

    window: Window
    """ 

    :type: Window
    """

    window_manager: WindowManager
    """ 

    :type: WindowManager
    """

    workspace: WorkSpace
    """ 

    :type: WorkSpace
    """

    area: Area
    """ 

    :type: Area
    """

    asset: AssetRepresentation
    """ 

    :type: AssetRepresentation
    """

    blend_data: BlendData
    """ 

    :type: BlendData
    """

    collection: Collection
    """ 

    :type: Collection
    """

    engine: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    gizmo_group: GizmoGroup
    """ 

    :type: GizmoGroup
    """

    layer_collection: LayerCollection
    """ 

    :type: LayerCollection
    """

    mode: typing.Any
    """ 

    :type: typing.Any
    """

    preferences: Preferences
    """ 

    :type: Preferences
    """

    region: Region
    """ 

    :type: Region
    """

    region_data: RegionView3D
    """ 

    :type: RegionView3D
    """

    scene: Scene
    """ 

    :type: Scene
    """

    screen: Screen
    """ 

    :type: Screen
    """

    space_data: Space
    """ The current space, may be None in background-mode, when the cursor is outside the window or when using menu-search

    :type: Space
    """

    tool_settings: ToolSettings
    """ 

    :type: ToolSettings
    """

    view_layer: ViewLayer
    """ 

    :type: ViewLayer
    """

    window: Window
    """ 

    :type: Window
    """

    window_manager: WindowManager
    """ 

    :type: WindowManager
    """

    workspace: WorkSpace
    """ 

    :type: WorkSpace
    """

    texture_slot: TextureSlot
    """ 

    :type: TextureSlot
    """

    scene: Scene
    """ 

    :type: Scene
    """

    world: World
    """ 

    :type: World
    """

    object: Object
    """ 

    :type: Object
    """

    mesh: Mesh
    """ 

    :type: Mesh
    """

    armature: Armature
    """ 

    :type: Armature
    """

    lattice: Lattice
    """ 

    :type: Lattice
    """

    curve: Curve
    """ 

    :type: Curve
    """

    meta_ball: MetaBall
    """ 

    :type: MetaBall
    """

    light: Light
    """ 

    :type: Light
    """

    speaker: Speaker
    """ 

    :type: Speaker
    """

    lightprobe: LightProbe
    """ 

    :type: LightProbe
    """

    camera: Camera
    """ 

    :type: Camera
    """

    material: Material
    """ 

    :type: Material
    """

    material_slot: MaterialSlot
    """ 

    :type: MaterialSlot
    """

    texture: Texture
    """ 

    :type: Texture
    """

    texture_user: ID
    """ 

    :type: ID
    """

    texture_user_property: Property
    """ 

    :type: Property
    """

    texture_node: Node
    """ 

    :type: Node
    """

    bone: Bone
    """ 

    :type: Bone
    """

    edit_bone: EditBone
    """ 

    :type: EditBone
    """

    pose_bone: PoseBone
    """ 

    :type: PoseBone
    """

    particle_system: ParticleSystem
    """ 

    :type: ParticleSystem
    """

    particle_system_editable: ParticleSystem
    """ 

    :type: ParticleSystem
    """

    particle_settings: ParticleSettings
    """ 

    :type: ParticleSettings
    """

    cloth: ClothModifier
    """ 

    :type: ClothModifier
    """

    soft_body: SoftBodyModifier
    """ 

    :type: SoftBodyModifier
    """

    fluid: typing.Any
    """ """

    collision: CollisionModifier
    """ 

    :type: CollisionModifier
    """

    brush: Brush
    """ 

    :type: Brush
    """

    dynamic_paint: DynamicPaintModifier
    """ 

    :type: DynamicPaintModifier
    """

    line_style: FreestyleLineStyle
    """ 

    :type: FreestyleLineStyle
    """

    collection: LayerCollection
    """ 

    :type: LayerCollection
    """

    gpencil: GreasePencil
    """ 

    :type: GreasePencil
    """

    grease_pencil: GreasePencilv3
    """ 

    :type: GreasePencilv3
    """

    curves: typing.Any
    """ """

    pointcloud: PointCloud
    """ 

    :type: PointCloud
    """

    volume: Volume
    """ 

    :type: Volume
    """

    edit_movieclip: MovieClip
    """ 

    :type: MovieClip
    """

    edit_mask: Mask
    """ 

    :type: Mask
    """

    active_file: FileSelectEntry
    """ 

    :type: FileSelectEntry
    """

    selected_files: typing.Any
    """ """

    asset_library_reference: AssetLibraryReference
    """ 

    :type: AssetLibraryReference
    """

    selected_assets: typing.Any
    """ """

    id: ID
    """ 

    :type: ID
    """

    selected_ids: typing.Any
    """ """

    edit_image: Image
    """ 

    :type: Image
    """

    edit_mask: Mask
    """ 

    :type: Mask
    """

    selected_nodes: typing.Any
    """ """

    active_node: Node
    """ 

    :type: Node
    """

    light: Light
    """ 

    :type: Light
    """

    material: Material
    """ 

    :type: Material
    """

    world: World
    """ 

    :type: World
    """

    scene: Scene
    """ 

    :type: Scene
    """

    view_layer: ViewLayer
    """ 

    :type: ViewLayer
    """

    visible_objects: typing.Any
    """ """

    selectable_objects: typing.Any
    """ """

    selected_objects: typing.Any
    """ """

    editable_objects: typing.Any
    """ """

    selected_editable_objects: typing.Any
    """ """

    objects_in_mode: typing.Any
    """ """

    objects_in_mode_unique_data: typing.Any
    """ """

    visible_bones: typing.Any
    """ """

    editable_bones: typing.Any
    """ """

    selected_bones: typing.Any
    """ """

    selected_editable_bones: typing.Any
    """ """

    visible_pose_bones: typing.Any
    """ """

    selected_pose_bones: typing.Any
    """ """

    selected_pose_bones_from_active_object: typing.Any
    """ """

    active_bone: EditBone
    """ 

    :type: EditBone
    """

    active_pose_bone: PoseBone
    """ 

    :type: PoseBone
    """

    active_object: Object
    """ 

    :type: Object
    """

    object: Object
    """ 

    :type: Object
    """

    edit_object: Object
    """ 

    :type: Object
    """

    sculpt_object: Object
    """ 

    :type: Object
    """

    vertex_paint_object: Object
    """ 

    :type: Object
    """

    weight_paint_object: Object
    """ 

    :type: Object
    """

    image_paint_object: Object
    """ 

    :type: Object
    """

    particle_edit_object: Object
    """ 

    :type: Object
    """

    pose_object: Object
    """ 

    :type: Object
    """

    active_sequence_strip: Sequence
    """ 

    :type: Sequence
    """

    sequences: typing.Any
    """ """

    selected_sequences: typing.Any
    """ """

    selected_editable_sequences: typing.Any
    """ """

    active_nla_track: NlaTrack
    """ 

    :type: NlaTrack
    """

    active_nla_strip: NlaStrip
    """ 

    :type: NlaStrip
    """

    selected_nla_strips: typing.Any
    """ """

    selected_movieclip_tracks: typing.Any
    """ """

    gpencil_data: GreasePencil
    """ 

    :type: GreasePencil
    """

    gpencil_data_owner: ID
    """ 

    :type: ID
    """

    annotation_data: GreasePencil
    """ 

    :type: GreasePencil
    """

    annotation_data_owner: ID
    """ 

    :type: ID
    """

    visible_gpencil_layers: typing.Any
    """ """

    editable_gpencil_layers: typing.Any
    """ """

    editable_gpencil_strokes: typing.Any
    """ """

    active_gpencil_layer: typing.Any
    """ """

    active_gpencil_frame: typing.Any
    """ """

    active_annotation_layer: GPencilLayer
    """ 

    :type: GPencilLayer
    """

    active_operator: Operator
    """ 

    :type: Operator
    """

    active_action: Action
    """ 

    :type: Action
    """

    selected_visible_actions: typing.Any
    """ """

    selected_editable_actions: typing.Any
    """ """

    visible_fcurves: typing.Any
    """ """

    editable_fcurves: typing.Any
    """ """

    selected_visible_fcurves: typing.Any
    """ """

    selected_editable_fcurves: typing.Any
    """ """

    active_editable_fcurve: FCurve
    """ 

    :type: FCurve
    """

    selected_editable_keyframes: typing.Any
    """ """

    ui_list: UIList
    """ 

    :type: UIList
    """

    property: typing.Any
    """ Get the property associated with a hovered button.
Returns a tuple of the data-block, data path to the property, and array index."""

    asset_library_reference: AssetLibraryReference
    """ 

    :type: AssetLibraryReference
    """

    edit_mask: Mask
    """ 

    :type: Mask
    """

    edit_text: Text
    """ 

    :type: Text
    """

    active_object: Object
    """ 

    :type: Object
    """

    selected_ids: typing.Any
    """ """

    def evaluated_depsgraph_get(self):
        """Get the dependency graph for the current scene and view layer, to access to data-blocks with animation and modifiers applied. If any data-blocks have been edited, the dependency graph will be updated. This invalidates all references to evaluated data-blocks from the dependency graph.

        :return: Evaluated dependency graph
        :rtype: Depsgraph
        """
        ...

    def copy(self):
        """ """
        ...

    def path_resolve(self, path: str, coerce: bool = True):
        """Returns the property from the path, raise an exception when not found.

        :param path: patch which this property resolves.
        :type path: str
        :param coerce: optional argument, when True, the property will be converted into its Python representation.
        :type coerce: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

    def temp_override(self, window: Window, area: Area, region: Region, keywords):
        """Context manager to temporarily override members in the context.Overriding the context can be used to temporarily activate another window / area & region,
        as well as other members such as the active_object or bone.Notes:Overriding the context can be useful to set the context after loading files
        (which would otherwise by None). For example:This example shows how it's possible to add an object to the scene in another window.

                :param window: Window override or None.
                :type window: Window
                :param area: Area override or None.
                :type area: Area
                :param region: Region override or None.
                :type region: Region
                :param keywords: Additional keywords override context members.
                :return: The context manager .
        """
        ...

class CopyLocationConstraint(bpy_struct):
    """Copy the location of the target"""

    head_tail: float
    """ Target along length of bone: Head is 0, Tail is 1

    :type: float
    """

    invert_x: bool
    """ Invert the X location

    :type: bool
    """

    invert_y: bool
    """ Invert the Y location

    :type: bool
    """

    invert_z: bool
    """ Invert the Z location

    :type: bool
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    use_bbone_shape: bool
    """ Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    """

    use_offset: bool
    """ Add original location into copied location

    :type: bool
    """

    use_x: bool
    """ Copy the target's X location

    :type: bool
    """

    use_y: bool
    """ Copy the target's Y location

    :type: bool
    """

    use_z: bool
    """ Copy the target's Z location

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CopyRotationConstraint(bpy_struct):
    """Copy the rotation of the target"""

    euler_order: typing.Union[str, int]
    """ Explicitly specify the euler rotation order

    :type: typing.Union[str, int]
    """

    invert_x: bool
    """ Invert the X rotation

    :type: bool
    """

    invert_y: bool
    """ Invert the Y rotation

    :type: bool
    """

    invert_z: bool
    """ Invert the Z rotation

    :type: bool
    """

    mix_mode: typing.Union[str, int]
    """ Specify how the copied and existing rotations are combined

    :type: typing.Union[str, int]
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    use_offset: bool
    """ DEPRECATED: Add original rotation into copied rotation

    :type: bool
    """

    use_x: bool
    """ Copy the target's X rotation

    :type: bool
    """

    use_y: bool
    """ Copy the target's Y rotation

    :type: bool
    """

    use_z: bool
    """ Copy the target's Z rotation

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CopyScaleConstraint(bpy_struct):
    """Copy the scale of the target"""

    power: float
    """ Raise the target's scale to the specified power

    :type: float
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    use_add: bool
    """ Use addition instead of multiplication to combine scale (2.7 compatibility)

    :type: bool
    """

    use_make_uniform: bool
    """ Redistribute the copied change in volume equally between the three axes of the owner

    :type: bool
    """

    use_offset: bool
    """ Combine original scale with copied scale

    :type: bool
    """

    use_x: bool
    """ Copy the target's X scale

    :type: bool
    """

    use_y: bool
    """ Copy the target's Y scale

    :type: bool
    """

    use_z: bool
    """ Copy the target's Z scale

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CopyTransformsConstraint(bpy_struct):
    """Copy all the transforms of the target"""

    head_tail: float
    """ Target along length of bone: Head is 0, Tail is 1

    :type: float
    """

    mix_mode: typing.Union[str, int]
    """ Specify how the copied and existing transformations are combined

    :type: typing.Union[str, int]
    """

    remove_target_shear: bool
    """ Remove shear from the target transformation before combining

    :type: bool
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    use_bbone_shape: bool
    """ Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CorrectiveSmoothModifier(bpy_struct):
    """Correct distortion caused by deformation"""

    factor: float
    """ Smooth effect factor

    :type: float
    """

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    is_bind: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    iterations: int
    """ 

    :type: int
    """

    rest_source: typing.Union[str, int]
    """ Select the source of rest positions

    :type: typing.Union[str, int]
    """

    scale: float
    """ Compensate for scale applied by other modifiers

    :type: float
    """

    smooth_type: typing.Union[str, int]
    """ Method used for smoothing

    :type: typing.Union[str, int]
    """

    use_only_smooth: bool
    """ Apply smoothing without reconstructing the surface

    :type: bool
    """

    use_pin_boundary: bool
    """ Excludes boundary vertices from being smoothed

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Name of Vertex Group which determines influence of modifier per point

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CrossSequence(bpy_struct):
    """Cross Sequence"""

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_2: Sequence
    """ Second input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CryptomatteEntry(bpy_struct):
    """ """

    encoded_hash: float
    """ 

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Curve(bpy_struct):
    """Curve data-block storing curves, splines and NURBS"""

    animation_data: AnimData
    """ Animation data for this data-block

    :type: AnimData
    """

    bevel_depth: float
    """ Radius of the bevel geometry, not including extrusion

    :type: float
    """

    bevel_factor_end: float
    """ Define where along the spline the curve geometry ends (0 for the beginning, 1 for the end)

    :type: float
    """

    bevel_factor_mapping_end: typing.Union[str, int]
    """ Determine how the geometry end factor is mapped to a spline

    :type: typing.Union[str, int]
    """

    bevel_factor_mapping_start: typing.Union[str, int]
    """ Determine how the geometry start factor is mapped to a spline

    :type: typing.Union[str, int]
    """

    bevel_factor_start: float
    """ Define where along the spline the curve geometry starts (0 for the beginning, 1 for the end)

    :type: float
    """

    bevel_mode: typing.Union[str, int]
    """ Determine how to build the curve's bevel geometry

    :type: typing.Union[str, int]
    """

    bevel_object: Object
    """ The name of the Curve object that defines the bevel shape

    :type: Object
    """

    bevel_profile: CurveProfile
    """ The path for the curve's custom profile

    :type: CurveProfile
    """

    bevel_resolution: int
    """ The number of segments in each quarter-circle of the bevel

    :type: int
    """

    cycles: typing.Any
    """ Cycles mesh settings

    :type: typing.Any
    """

    dimensions: typing.Union[str, int]
    """ Select 2D or 3D curve type

    :type: typing.Union[str, int]
    """

    eval_time: float
    """ Parametric position along the length of the curve that Objects 'following' it should be at (position is evaluated by dividing by the 'Path Length' value)

    :type: float
    """

    extrude: float
    """ Length of the depth added in the local Z direction along the curve, perpendicular to its normals

    :type: float
    """

    fill_mode: typing.Union[str, int]
    """ Mode of filling curve

    :type: typing.Union[str, int]
    """

    is_editmode: typing.Union[bool, typing.Any]
    """ True when used in editmode

    :type: typing.Union[bool, typing.Any]
    """

    materials: bpy_prop_collection[Material]
    """ 

    :type: bpy_prop_collection[Material]
    """

    offset: float
    """ Distance to move the curve parallel to its normals

    :type: float
    """

    path_duration: int
    """ The number of frames that are needed to traverse the path, defining the maximum value for the 'Evaluation Time' setting

    :type: int
    """

    render_resolution_u: int
    """ Surface resolution in U direction used while rendering (zero uses preview resolution)

    :type: int
    """

    render_resolution_v: int
    """ Surface resolution in V direction used while rendering (zero uses preview resolution)

    :type: int
    """

    resolution_u: int
    """ Number of computed points in the U direction between every pair of control points

    :type: int
    """

    resolution_v: int
    """ The number of computed points in the V direction between every pair of control points

    :type: int
    """

    shape_keys: Key
    """ 

    :type: Key
    """

    splines: bpy_prop_collection[Spline]
    """ Collection of splines in this curve data object

    :type: bpy_prop_collection[Spline]
    """

    taper_object: Object
    """ Curve object name that defines the taper (width)

    :type: Object
    """

    taper_radius_mode: typing.Union[str, int]
    """ Determine how the effective radius of the spline point is computed when a taper object is specified

    :type: typing.Union[str, int]
    """

    texspace_location: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    texspace_size: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    twist_mode: typing.Union[str, int]
    """ The type of tilt calculation for 3D Curves

    :type: typing.Union[str, int]
    """

    twist_smooth: float
    """ Smoothing iteration for tangents

    :type: float
    """

    use_auto_texspace: bool
    """ Adjust active object's texture space automatically when transforming object

    :type: bool
    """

    use_deform_bounds: bool
    """ Option for curve-deform: Use the mesh bounds to clamp the deformation

    :type: bool
    """

    use_fill_caps: bool
    """ Fill caps for beveled curves

    :type: bool
    """

    use_map_taper: bool
    """ Map effect of the taper object to the beveled part of the curve

    :type: bool
    """

    use_path: bool
    """ Enable the curve to become a translation path

    :type: bool
    """

    use_path_clamp: bool
    """ Clamp the curve path children so they can't travel past the start/end point of the curve

    :type: bool
    """

    use_path_follow: bool
    """ Make curve path children rotate along the path

    :type: bool
    """

    use_radius: bool
    """ Option for paths and curve-deform: apply the curve radius to objects following it and to deformed objects

    :type: bool
    """

    use_stretch: bool
    """ Option for curve-deform: make deformed child stretch along entire path

    :type: bool
    """

    def transform(
        self,
        matrix: typing.Union[
            typing.List[typing.List[float]],
            typing.Tuple[
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
                typing.Tuple[float, float, float, float],
            ],
            mathutils.Matrix,
        ],
        shape_keys: typing.Union[bool, typing.Any] = False,
    ):
        """Transform curve by a matrix

        :param matrix: Matrix
        :type matrix: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
        :param shape_keys: Transform Shape Keys
        :type shape_keys: typing.Union[bool, typing.Any]
        """
        ...

    def validate_material_indices(self) -> typing.Union[bool, typing.Any]:
        """Validate material indices of splines or letters, return True when the curve has had invalid indices corrected (to default 0)

        :return: Result
        :rtype: bool
        """
        ...

    def update_gpu_tag(self):
        """update_gpu_tag"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveMap(bpy_struct):
    """Curve in a curve mapping"""

    points: bpy_prop_collection[CurveMapPoint]
    """ 

    :type: bpy_prop_collection[CurveMapPoint]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveMapPoint(bpy_struct):
    """Point of a curve used for a curve mapping"""

    handle_type: typing.Union[str, int]
    """ Curve interpolation at this point: Bézier or vector

    :type: typing.Union[str, int]
    """

    location: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ X/Y coordinates of the curve point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    select: bool
    """ Selection state of the curve point

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveMapPoints(bpy_struct):
    """Collection of Curve Map Points"""

    def new(self, position: float, value: float) -> float:
        """Add point to CurveMap

        :param position: Position, Position to add point
        :type position: float
        :param value: Value, Value of point
        :type value: float
        :return: New point
        :rtype: CurveMapPoint
        """
        ...

    def remove(self, point: CurveMapPoint):
        """Delete point from CurveMap

        :param point: PointElement to remove
        :type point: CurveMapPoint
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveMapping(bpy_struct):
    """Curve mapping to map color, vector and scalar values to other values using a user defined curve"""

    black_level: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ For RGB curves, the color that black is mapped to

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    clip_max_x: float
    """ 

    :type: float
    """

    clip_max_y: float
    """ 

    :type: float
    """

    clip_min_x: float
    """ 

    :type: float
    """

    clip_min_y: float
    """ 

    :type: float
    """

    curves: bpy_prop_collection[CurveMap]
    """ 

    :type: bpy_prop_collection[CurveMap]
    """

    extend: typing.Union[str, int]
    """ Extrapolate the curve or extend it horizontally

    :type: typing.Union[str, int]
    """

    tone: typing.Union[str, int]
    """ Tone of the curve

    :type: typing.Union[str, int]
    """

    use_clip: bool
    """ Force the curve view to fit a defined boundary

    :type: bool
    """

    white_level: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ For RGB curves, the color that white is mapped to

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    def update(self):
        """Update curve mapping after making changes"""
        ...

    def reset_view(self):
        """Reset the curve mapping grid to its clipping size"""
        ...

    def initialize(self):
        """Initialize curve"""
        ...

    def evaluate(self, curve: CurveMap, position: float) -> float:
        """Evaluate curve at given location

        :param curve: curve, Curve to evaluate
        :type curve: CurveMap
        :param position: Position, Position to evaluate curve at
        :type position: float
        :return: Value, Value of curve at given location
        :rtype: float
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveModifier(bpy_struct):
    """Curve deformation modifier"""

    deform_axis: typing.Union[str, int]
    """ The axis that the curve deforms along

    :type: typing.Union[str, int]
    """

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    object: Object
    """ Curve object to deform with

    :type: Object
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Name of Vertex Group which determines influence of modifier per point

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurvePaintSettings(bpy_struct):
    """ """

    corner_angle: float
    """ Angles above this are considered corners

    :type: float
    """

    curve_type: typing.Union[str, int]
    """ Type of curve to use for new strokes

    :type: typing.Union[str, int]
    """

    depth_mode: typing.Union[str, int]
    """ Method of projecting depth

    :type: typing.Union[str, int]
    """

    error_threshold: int
    """ Allow deviation for a smoother, less precise line

    :type: int
    """

    fit_method: typing.Any
    """ Curve fitting method"""

    radius_max: float
    """ Radius to use when the maximum pressure is applied (or when a tablet isn't used)

    :type: float
    """

    radius_min: float
    """ Minimum radius when the minimum pressure is applied (also the minimum when tapering)

    :type: float
    """

    radius_taper_end: float
    """ Taper factor for the radius of each point along the curve

    :type: float
    """

    radius_taper_start: float
    """ Taper factor for the radius of each point along the curve

    :type: float
    """

    surface_offset: float
    """ Offset the stroke from the surface

    :type: float
    """

    surface_plane: typing.Union[str, int]
    """ Plane for projected stroke

    :type: typing.Union[str, int]
    """

    use_corners_detect: bool
    """ Detect corners and use non-aligned handles

    :type: bool
    """

    use_offset_absolute: bool
    """ Apply a fixed offset (don't scale by the radius)

    :type: bool
    """

    use_pressure_radius: bool
    """ Map tablet pressure to curve radius

    :type: bool
    """

    use_stroke_endpoints: bool
    """ Use the start of the stroke for the depth

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurvePoint(bpy_struct):
    """Curve control point"""

    index: int
    """ Index of this point

    :type: int
    """

    position: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    radius: float
    """ 

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveProfile(bpy_struct):
    """Profile Path editor used to build a profile path"""

    points: bpy_prop_collection[CurveProfilePoint]
    """ Profile control points

    :type: bpy_prop_collection[CurveProfilePoint]
    """

    preset: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    segments: bpy_prop_collection[CurveProfilePoint]
    """ Segments sampled from control points

    :type: bpy_prop_collection[CurveProfilePoint]
    """

    use_clip: bool
    """ Force the path view to fit a defined boundary

    :type: bool
    """

    use_sample_even_lengths: bool
    """ Sample edges with even lengths

    :type: bool
    """

    use_sample_straight_edges: bool
    """ Sample edges with vector handles

    :type: bool
    """

    def update(self):
        """Refresh internal data, remove doubles and clip points"""
        ...

    def reset_view(self):
        """Reset the curve profile grid to its clipping size"""
        ...

    def initialize(self, totsegments: typing.Any):
        """Set the number of display segments and fill tables

        :param totsegments: The number of segment values to initialize the segments table with
        :type totsegments: typing.Any
        """
        ...

    def evaluate(self, length_portion: float) -> float:
        """Evaluate the at the given portion of the path length

        :param length_portion: Length Portion, Portion of the path length to travel before evaluation
        :type length_portion: float
        :return: Location, The location at the given portion of the profile
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveProfilePoint(bpy_struct):
    """Point of a path used to define a profile"""

    handle_type_1: typing.Union[str, int]
    """ Path interpolation at this point

    :type: typing.Union[str, int]
    """

    handle_type_2: typing.Union[str, int]
    """ Path interpolation at this point

    :type: typing.Union[str, int]
    """

    location: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ X/Y coordinates of the path point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    select: bool
    """ Selection state of the path point

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveProfilePoints(bpy_struct):
    """Collection of Profile Points"""

    def add(self, x: float, y: float) -> float:
        """Add point to the profile

        :param x: X Position, X Position for new point
        :type x: float
        :param y: Y Position, Y Position for new point
        :type y: float
        :return: New point
        :rtype: CurveProfilePoint
        """
        ...

    def remove(self, point: CurveProfilePoint):
        """Delete point from the profile

        :param point: Point to remove
        :type point: CurveProfilePoint
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveSlice(bpy_struct):
    """A single curve from a curves data-block"""

    first_point_index: int
    """ The index of this curve's first control point

    :type: int
    """

    index: int
    """ Index of this curve

    :type: int
    """

    points: bpy_prop_collection[CurvePoint]
    """ Control points of the curve

    :type: bpy_prop_collection[CurvePoint]
    """

    points_length: int
    """ Number of control points in the curve

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurveSplines(bpy_struct):
    """Collection of curve splines"""

    active: Spline
    """ Active curve spline

    :type: Spline
    """

    def new(self, type: typing.Union[str, int]) -> typing.Union[str, int]:
        """Add a new spline to the curve

        :param type: type for the new spline
        :type type: typing.Union[str, int]
        :return: The newly created spline
        :rtype: Spline
        """
        ...

    def remove(self, spline: Spline):
        """Remove a spline from a curve

        :param spline: The spline to remove
        :type spline: Spline
        """
        ...

    def clear(self):
        """Remove all splines from a curve"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Curves(bpy_struct):
    """Hair data-block for hair curves"""

    animation_data: AnimData
    """ Animation data for this data-block

    :type: AnimData
    """

    attributes: bpy_prop_collection[Attribute]
    """ Geometry attributes

    :type: bpy_prop_collection[Attribute]
    """

    color_attributes: bpy_prop_collection[Attribute]
    """ Geometry color attributes

    :type: bpy_prop_collection[Attribute]
    """

    curve_offset_data: bpy_prop_collection[IntAttributeValue]
    """ 

    :type: bpy_prop_collection[IntAttributeValue]
    """

    curves: bpy_prop_collection[CurveSlice]
    """ All curves in the data-block

    :type: bpy_prop_collection[CurveSlice]
    """

    materials: bpy_prop_collection[Material]
    """ 

    :type: bpy_prop_collection[Material]
    """

    normals: bpy_prop_collection[FloatVectorValueReadOnly]
    """ The curve normal value at each of the curve's control points

    :type: bpy_prop_collection[FloatVectorValueReadOnly]
    """

    points: bpy_prop_collection[CurvePoint]
    """ Control points of all curves

    :type: bpy_prop_collection[CurvePoint]
    """

    position_data: bpy_prop_collection[FloatVectorAttributeValue]
    """ 

    :type: bpy_prop_collection[FloatVectorAttributeValue]
    """

    selection_domain: typing.Any
    """ """

    surface: Object
    """ Mesh object that the curves can be attached to

    :type: Object
    """

    surface_uv_map: typing.Union[str, typing.Any]
    """ The name of the attribute on the surface mesh used to define the attachment of each curve

    :type: typing.Union[str, typing.Any]
    """

    use_mirror_x: bool
    """ Enable symmetry in the X axis

    :type: bool
    """

    use_mirror_y: bool
    """ Enable symmetry in the Y axis

    :type: bool
    """

    use_mirror_z: bool
    """ Enable symmetry in the Z axis

    :type: bool
    """

    use_sculpt_collision: bool
    """ Enable collision with the surface while sculpting

    :type: bool
    """

    def add_curves(self, sizes: typing.Iterable[int]):
        """add_curves

        :param sizes: Sizes, The number of points in each curve
        :type sizes: typing.Iterable[int]
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurvesModifier(bpy_struct):
    """RGB curves modifier for sequence strip"""

    curve_mapping: CurveMapping
    """ 

    :type: CurveMapping
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class CurvesSculpt(bpy_struct):
    """ """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DATA_UL_bone_collections(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        armature,
        bcoll,
        _icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param armature:
        :param bcoll:
        :param _icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DampedTrackConstraint(bpy_struct):
    """Point toward target by taking the shortest rotation path"""

    head_tail: float
    """ Target along length of bone: Head is 0, Tail is 1

    :type: float
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    track_axis: typing.Union[str, int]
    """ Axis that points to the target object

    :type: typing.Union[str, int]
    """

    use_bbone_shape: bool
    """ Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DashGpencilModifierData(bpy_struct):
    """Create dot-dash effect for strokes"""

    dash_offset: int
    """ Offset into each stroke before the beginning of the dashed segment generation

    :type: int
    """

    invert_layer_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_layers: bool
    """ Inverse filter

    :type: bool
    """

    invert_material_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_materials: bool
    """ Inverse filter

    :type: bool
    """

    layer: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    layer_pass: int
    """ Layer pass index

    :type: int
    """

    material: Material
    """ Material used for filtering effect

    :type: Material
    """

    pass_index: int
    """ Pass index

    :type: int
    """

    segment_active_index: int
    """ Active index in the segment list

    :type: int
    """

    segments: bpy_prop_collection[DashGpencilModifierSegment]
    """ 

    :type: bpy_prop_collection[DashGpencilModifierSegment]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DashGpencilModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    dash: int
    """ The number of consecutive points from the original stroke to include in this segment

    :type: int
    """

    gap: int
    """ The number of points skipped after this segment

    :type: int
    """

    material_index: int
    """ Use this index on generated segment. -1 means using the existing material

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ The factor to apply to the original point's opacity for the new points

    :type: float
    """

    radius: float
    """ The factor to apply to the original point's radius for the new points

    :type: float
    """

    use_cyclic: bool
    """ Enable cyclic on individual stroke dashes

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DataTransferModifier(bpy_struct):
    """Modifier transferring some data from a source mesh"""

    data_types_edges: typing.Union[typing.Set[str], typing.Set[int]]
    """ Which edge data layers to transfer

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    """

    data_types_loops: typing.Union[typing.Set[str], typing.Set[int]]
    """ Which face corner data layers to transfer

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    """

    data_types_polys: typing.Union[typing.Set[str], typing.Set[int]]
    """ Which face data layers to transfer

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    """

    data_types_verts: typing.Union[typing.Set[str], typing.Set[int]]
    """ Which vertex data layers to transfer

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    """

    edge_mapping: typing.Any
    """ Method used to map source edges to destination ones"""

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    islands_precision: float
    """ Factor controlling precision of islands handling (typically, 0.1 should be enough, higher values can make things really slow)

    :type: float
    """

    layers_uv_select_dst: typing.Any
    """ How to match source and destination layers"""

    layers_uv_select_src: typing.Any
    """ Which layers to transfer, in case of multi-layers types"""

    layers_vcol_loop_select_dst: typing.Any
    """ How to match source and destination layers"""

    layers_vcol_loop_select_src: typing.Any
    """ Which layers to transfer, in case of multi-layers types"""

    layers_vcol_vert_select_dst: typing.Any
    """ How to match source and destination layers"""

    layers_vcol_vert_select_src: typing.Any
    """ Which layers to transfer, in case of multi-layers types"""

    layers_vgroup_select_dst: typing.Any
    """ How to match source and destination layers"""

    layers_vgroup_select_src: typing.Any
    """ Which layers to transfer, in case of multi-layers types"""

    loop_mapping: typing.Any
    """ Method used to map source faces' corners to destination ones"""

    max_distance: float
    """ Maximum allowed distance between source and destination element, for non-topology mappings

    :type: float
    """

    mix_factor: float
    """ Factor to use when applying data to destination (exact behavior depends on mix mode, multiplied with weights from vertex group when defined)

    :type: float
    """

    mix_mode: typing.Any
    """ How to affect destination elements with source values"""

    object: Object
    """ Object to transfer data from

    :type: Object
    """

    poly_mapping: typing.Any
    """ Method used to map source faces to destination ones"""

    ray_radius: float
    """ 'Width' of rays (especially useful when raycasting against vertices or edges)

    :type: float
    """

    use_edge_data: bool
    """ Enable edge data transfer

    :type: bool
    """

    use_loop_data: bool
    """ Enable face corner data transfer

    :type: bool
    """

    use_max_distance: bool
    """ Source elements must be closer than given distance from destination one

    :type: bool
    """

    use_object_transform: bool
    """ Evaluate source and destination meshes in global space

    :type: bool
    """

    use_poly_data: bool
    """ Enable face data transfer

    :type: bool
    """

    use_vert_data: bool
    """ Enable vertex data transfer

    :type: bool
    """

    vert_mapping: typing.Any
    """ Method used to map source vertices to destination ones"""

    vertex_group: typing.Union[str, typing.Any]
    """ Vertex group name for selecting the affected areas

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DecimateModifier(bpy_struct):
    """Decimation modifier"""

    angle_limit: float
    """ Only dissolve angles below this (planar only)

    :type: float
    """

    decimate_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    delimit: typing.Any
    """ Limit merging geometry"""

    face_count: int
    """ The current number of faces in the decimated mesh

    :type: int
    """

    invert_vertex_group: bool
    """ Invert vertex group influence (collapse only)

    :type: bool
    """

    iterations: int
    """ Number of times reduce the geometry (unsubdivide only)

    :type: int
    """

    ratio: float
    """ Ratio of triangles to reduce to (collapse only)

    :type: float
    """

    symmetry_axis: typing.Any
    """ Axis of symmetry"""

    use_collapse_triangulate: bool
    """ Keep triangulated faces resulting from decimation (collapse only)

    :type: bool
    """

    use_dissolve_boundaries: bool
    """ Dissolve all vertices in between face boundaries (planar only)

    :type: bool
    """

    use_symmetry: bool
    """ Maintain symmetry on an axis

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Vertex group name (collapse only)

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_factor: float
    """ Vertex group strength

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Depsgraph:
    """ """

    ids: bpy_prop_collection[ID]
    """ All evaluated data-blocks

    :type: bpy_prop_collection[ID]
    """

    mode: typing.Union[str, int]
    """ Evaluation mode

    :type: typing.Union[str, int]
    """

    object_instances: bpy_prop_collection[DepsgraphObjectInstance]
    """ All object instances to display or render (Warning: Only use this as an iterator, never as a sequence, and do not keep any references to its items)

    :type: bpy_prop_collection[DepsgraphObjectInstance]
    """

    objects: bpy_prop_collection[Object]
    """ Evaluated objects in the dependency graph

    :type: bpy_prop_collection[Object]
    """

    scene: Scene
    """ Original scene dependency graph is built for

    :type: Scene
    """

    scene_eval: Scene
    """ Scene at its evaluated state

    :type: Scene
    """

    updates: bpy_prop_collection[DepsgraphUpdate]
    """ Updates to data-blocks

    :type: bpy_prop_collection[DepsgraphUpdate]
    """

    view_layer: ViewLayer
    """ Original view layer dependency graph is built for

    :type: ViewLayer
    """

    view_layer_eval: ViewLayer
    """ View layer at its evaluated state

    :type: ViewLayer
    """

    def debug_relations_graphviz(self, filepath: typing.Union[str, typing.Any]):
        """debug_relations_graphviz

        :param filepath: File Name, Output path for the graphviz debug file
        :type filepath: typing.Union[str, typing.Any]
        """
        ...

    def debug_stats_gnuplot(
        self,
        filepath: typing.Union[str, typing.Any],
        output_filepath: typing.Union[str, typing.Any],
    ):
        """debug_stats_gnuplot

        :param filepath: File Name, Output path for the gnuplot debug file
        :type filepath: typing.Union[str, typing.Any]
        :param output_filepath: Output File Name, File name where gnuplot script will save the result
        :type output_filepath: typing.Union[str, typing.Any]
        """
        ...

    def debug_tag_update(self):
        """debug_tag_update"""
        ...

    def debug_stats(self) -> typing.Union[str, typing.Any]:
        """Report the number of elements in the Dependency Graph

        :return: result
        :rtype: typing.Union[str, typing.Any]
        """
        ...

    def update(self):
        """Re-evaluate any modified data-blocks, for example for animation or modifiers. This invalidates all references to evaluated data-blocks from this dependency graph."""
        ...

    def id_eval_get(self, id: ID) -> ID:
        """id_eval_get

        :param id: Original ID to get evaluated complementary part for
        :type id: ID
        :return: Evaluated ID for the given original one
        :rtype: ID
        """
        ...

    def id_type_updated(self, id_type):
        """id_type_updated

        :param id_type: ID Type
        :return: Updated, True if any datablock with this type was added, updated or removed
        :rtype: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DepsgraphObjectInstance(bpy_struct):
    """Extended information about dependency graph object iterator (Warning: All data here is 'evaluated' one, not original .blend IDs)"""

    instance_object: Object
    """ Evaluated object which is being instanced by this iterator

    :type: Object
    """

    is_instance: typing.Union[bool, typing.Any]
    """ Denotes if the object is generated by another object

    :type: typing.Union[bool, typing.Any]
    """

    matrix_world: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Generated transform matrix in world space

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    object: Object
    """ Evaluated object the iterator points to

    :type: Object
    """

    orco: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Generated coordinates in parent object space

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    parent: Object
    """ If the object is an instance, the parent object that generated it

    :type: Object
    """

    particle_system: ParticleSystem
    """ Evaluated particle system that this object was instanced from

    :type: ParticleSystem
    """

    persistent_id: bpy_prop_array[int]
    """ Persistent identifier for inter-frame matching of objects with motion blur

    :type: bpy_prop_array[int]
    """

    random_id: int
    """ Random id for this instance, typically for randomized shading

    :type: int
    """

    show_particles: typing.Union[bool, typing.Any]
    """ Particles part of the object should be visible in the render

    :type: typing.Union[bool, typing.Any]
    """

    show_self: typing.Union[bool, typing.Any]
    """ The object geometry itself should be visible in the render

    :type: typing.Union[bool, typing.Any]
    """

    uv: bpy_prop_array[float]
    """ UV coordinates in parent object space

    :type: bpy_prop_array[float]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DepsgraphUpdate(bpy_struct):
    """Information about ID that was updated"""

    id: ID
    """ Updated data-block

    :type: ID
    """

    is_updated_geometry: typing.Union[bool, typing.Any]
    """ Object geometry is updated

    :type: typing.Union[bool, typing.Any]
    """

    is_updated_shading: typing.Union[bool, typing.Any]
    """ Object shading is updated

    :type: typing.Union[bool, typing.Any]
    """

    is_updated_transform: typing.Union[bool, typing.Any]
    """ Object transformation is updated

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DisplaceModifier(bpy_struct):
    """Displacement modifier"""

    direction: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    mid_level: float
    """ Material value that gives no displacement

    :type: float
    """

    space: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    strength: float
    """ Amount to displace geometry

    :type: float
    """

    texture: Texture
    """ 

    :type: Texture
    """

    texture_coords: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    texture_coords_bone: typing.Union[str, typing.Any]
    """ Bone to set the texture coordinates

    :type: typing.Union[str, typing.Any]
    """

    texture_coords_object: Object
    """ Object to set the texture coordinates

    :type: Object
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Name of Vertex Group which determines influence of modifier per point

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DisplaySafeAreas(bpy_struct):
    """Safe areas used in 3D view and the sequencer"""

    action: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Safe area for general elements

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    action_center: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Safe area for general elements in a different aspect ratio

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    title: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Safe area for text and graphics

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    title_center: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Safe area for text and graphics in a different aspect ratio

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DistortedNoiseTexture(bpy_struct):
    """Procedural distorted noise texture"""

    distortion: float
    """ Amount of distortion

    :type: float
    """

    nabla: float
    """ Size of derivative offset used for calculating normal

    :type: float
    """

    noise_basis: typing.Union[str, int]
    """ Noise basis used for turbulence

    :type: typing.Union[str, int]
    """

    noise_distortion: typing.Union[str, int]
    """ Noise basis for the distortion

    :type: typing.Union[str, int]
    """

    noise_scale: float
    """ Scaling for noise input

    :type: float
    """

    users_material: typing.Any
    """ Materials that use this texture(readonly)"""

    users_object_modifier: typing.Any
    """ Object modifiers that use this texture(readonly)"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DopeSheet(bpy_struct):
    """Settings for filtering the channels shown in animation editors"""

    filter_collection: Collection
    """ Collection that included object should be a member of

    :type: Collection
    """

    filter_fcurve_name: typing.Union[str, typing.Any]
    """ F-Curve live filtering string

    :type: typing.Union[str, typing.Any]
    """

    filter_text: typing.Union[str, typing.Any]
    """ Live filtering string

    :type: typing.Union[str, typing.Any]
    """

    show_armatures: bool
    """ Include visualization of armature related animation data

    :type: bool
    """

    show_cache_files: bool
    """ Include visualization of cache file related animation data

    :type: bool
    """

    show_cameras: bool
    """ Include visualization of camera related animation data

    :type: bool
    """

    show_curves: bool
    """ Include visualization of curve related animation data

    :type: bool
    """

    show_datablock_filters: bool
    """ Show options for whether channels related to certain types of data are included

    :type: bool
    """

    show_driver_fallback_as_error: bool
    """ Include drivers that relied on any fallback values for their evaluation in the Only Show Errors filter, even if the driver evaluation succeeded

    :type: bool
    """

    show_expanded_summary: bool
    """ Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only)

    :type: bool
    """

    show_gpencil: bool
    """ Include visualization of Grease Pencil related animation data and frames

    :type: bool
    """

    show_hair_curves: bool
    """ Include visualization of hair related animation data

    :type: bool
    """

    show_hidden: bool
    """ Include channels from objects/bone that are not visible

    :type: bool
    """

    show_lattices: bool
    """ Include visualization of lattice related animation data

    :type: bool
    """

    show_lights: bool
    """ Include visualization of light related animation data

    :type: bool
    """

    show_linestyles: bool
    """ Include visualization of Line Style related Animation data

    :type: bool
    """

    show_materials: bool
    """ Include visualization of material related animation data

    :type: bool
    """

    show_meshes: bool
    """ Include visualization of mesh related animation data

    :type: bool
    """

    show_metaballs: bool
    """ Include visualization of metaball related animation data

    :type: bool
    """

    show_missing_nla: bool
    """ Include animation data-blocks with no NLA data (NLA editor only)

    :type: bool
    """

    show_modifiers: bool
    """ Include visualization of animation data related to data-blocks linked to modifiers

    :type: bool
    """

    show_movieclips: bool
    """ Include visualization of movie clip related animation data

    :type: bool
    """

    show_nodes: bool
    """ Include visualization of node related animation data

    :type: bool
    """

    show_only_errors: bool
    """ Only include F-Curves and drivers that are disabled or have errors

    :type: bool
    """

    show_only_selected: bool
    """ Only include channels relating to selected objects and data

    :type: bool
    """

    show_particles: bool
    """ Include visualization of particle related animation data

    :type: bool
    """

    show_pointclouds: bool
    """ Include visualization of point cloud related animation data

    :type: bool
    """

    show_scenes: bool
    """ Include visualization of scene related animation data

    :type: bool
    """

    show_shapekeys: bool
    """ Include visualization of shape key related animation data

    :type: bool
    """

    show_speakers: bool
    """ Include visualization of speaker related animation data

    :type: bool
    """

    show_summary: bool
    """ Display an additional 'summary' line (Dope Sheet editors only)

    :type: bool
    """

    show_textures: bool
    """ Include visualization of texture related animation data

    :type: bool
    """

    show_transforms: bool
    """ Include visualization of object-level animation data (mostly transforms)

    :type: bool
    """

    show_volumes: bool
    """ Include visualization of volume related animation data

    :type: bool
    """

    show_worlds: bool
    """ Include visualization of world related animation data

    :type: bool
    """

    source: ID
    """ ID-Block representing source data, usually ID_SCE (i.e. Scene)

    :type: ID
    """

    use_datablock_sort: bool
    """ Alphabetically sorts data-blocks - mainly objects in the scene (disable to increase viewport speed)

    :type: bool
    """

    use_filter_invert: bool
    """ Invert filter search

    :type: bool
    """

    use_multi_word_filter: bool
    """ Perform fuzzy/multi-word matching.
Warning: May be slow

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Driver(bpy_struct):
    """Driver for the value of a setting based on an external value"""

    expression: typing.Union[str, typing.Any]
    """ Expression to use for Scripted Expression

    :type: typing.Union[str, typing.Any]
    """

    is_simple_expression: typing.Union[bool, typing.Any]
    """ The scripted expression can be evaluated without using the full Python interpreter

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: bool
    """ Driver could not be evaluated in past, so should be skipped

    :type: bool
    """

    type: typing.Union[str, int]
    """ Driver type

    :type: typing.Union[str, int]
    """

    use_self: bool
    """ Include a 'self' variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc...)

    :type: bool
    """

    variables: bpy_prop_collection[DriverVariable]
    """ Properties acting as inputs for this driver

    :type: bpy_prop_collection[DriverVariable]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DriverTarget(bpy_struct):
    """Source of input values for driver variables"""

    bone_target: typing.Union[str, typing.Any]
    """ Name of PoseBone to use as target

    :type: typing.Union[str, typing.Any]
    """

    context_property: typing.Union[str, int]
    """ Type of a context-dependent data-block to access property from

    :type: typing.Union[str, int]
    """

    data_path: typing.Union[str, typing.Any]
    """ RNA Path (from ID-block) to property used

    :type: typing.Union[str, typing.Any]
    """

    fallback_value: float
    """ The value to use if the data path can't be resolved

    :type: float
    """

    id: ID
    """ ID-block that the specific property used can be found from (id_type property must be set first)

    :type: ID
    """

    id_type: typing.Any
    """ Type of ID-block that can be used"""

    is_fallback_used: typing.Union[bool, typing.Any]
    """ Indicates that the most recent variable evaluation used the fallback value

    :type: typing.Union[bool, typing.Any]
    """

    rotation_mode: typing.Any
    """ Mode for calculating rotation channel values"""

    transform_space: typing.Union[str, int]
    """ Space in which transforms are used

    :type: typing.Union[str, int]
    """

    transform_type: typing.Union[str, int]
    """ Driver variable type

    :type: typing.Union[str, int]
    """

    use_fallback_value: bool
    """ Use the fallback value if the data path can't be resolved, instead of failing to evaluate the driver

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DriverVariable(bpy_struct):
    """Variable from some source/target for driver relationship"""

    is_name_valid: typing.Union[bool, typing.Any]
    """ Is this a valid name for a driver variable

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter)

    :type: typing.Union[str, typing.Any]
    """

    targets: bpy_prop_collection[DriverTarget]
    """ Sources of input data for evaluating this variable

    :type: bpy_prop_collection[DriverTarget]
    """

    type: typing.Union[str, int]
    """ Driver variable type

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DynamicPaintBrushSettings(bpy_struct):
    """Brush settings"""

    invert_proximity: bool
    """ Proximity falloff is applied inside the volume

    :type: bool
    """

    paint_alpha: float
    """ Paint alpha

    :type: float
    """

    paint_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color of the paint

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    paint_distance: float
    """ Maximum distance from brush to mesh surface to affect paint

    :type: float
    """

    paint_ramp: ColorRamp
    """ Color ramp used to define proximity falloff

    :type: ColorRamp
    """

    paint_source: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    paint_wetness: float
    """ Paint wetness, visible in wetmap (some effects only affect wet paint)

    :type: float
    """

    particle_system: ParticleSystem
    """ The particle system to paint with

    :type: ParticleSystem
    """

    proximity_falloff: typing.Union[str, int]
    """ Proximity falloff type

    :type: typing.Union[str, int]
    """

    ray_direction: typing.Union[str, int]
    """ Ray direction to use for projection (if brush object is located in that direction it's painted)

    :type: typing.Union[str, int]
    """

    smooth_radius: float
    """ Smooth falloff added after solid radius

    :type: float
    """

    smudge_strength: float
    """ Smudge effect strength

    :type: float
    """

    solid_radius: float
    """ Radius that will be painted solid

    :type: float
    """

    use_absolute_alpha: bool
    """ Only increase alpha value if paint alpha is higher than existing

    :type: bool
    """

    use_negative_volume: bool
    """ Negate influence inside the volume

    :type: bool
    """

    use_paint_erase: bool
    """ Erase / remove paint instead of adding it

    :type: bool
    """

    use_particle_radius: bool
    """ Use radius from particle settings

    :type: bool
    """

    use_proximity_project: bool
    """ Brush is projected to canvas from defined direction within brush proximity

    :type: bool
    """

    use_proximity_ramp_alpha: bool
    """ Only read color ramp alpha

    :type: bool
    """

    use_smudge: bool
    """ Make this brush to smudge existing paint as it moves

    :type: bool
    """

    use_velocity_alpha: bool
    """ Multiply brush influence by velocity color ramp alpha

    :type: bool
    """

    use_velocity_color: bool
    """ Replace brush color by velocity color ramp

    :type: bool
    """

    use_velocity_depth: bool
    """ Multiply brush intersection depth (displace, waves) by velocity ramp alpha

    :type: bool
    """

    velocity_max: float
    """ Velocity considered as maximum influence (Blender units per frame)

    :type: float
    """

    velocity_ramp: ColorRamp
    """ Color ramp used to define brush velocity effect

    :type: ColorRamp
    """

    wave_clamp: float
    """ Maximum level of surface intersection used to influence waves (use 0.0 to disable)

    :type: float
    """

    wave_factor: float
    """ Multiplier for wave influence of this brush

    :type: float
    """

    wave_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DynamicPaintCanvasSettings(bpy_struct):
    """Dynamic Paint canvas settings"""

    canvas_surfaces: bpy_prop_collection[DynamicPaintSurface]
    """ Paint surface list

    :type: bpy_prop_collection[DynamicPaintSurface]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DynamicPaintModifier(bpy_struct):
    """Dynamic Paint modifier"""

    brush_settings: DynamicPaintBrushSettings
    """ 

    :type: DynamicPaintBrushSettings
    """

    canvas_settings: DynamicPaintCanvasSettings
    """ 

    :type: DynamicPaintCanvasSettings
    """

    ui_type: typing.Any
    """ """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DynamicPaintSurface(bpy_struct):
    """A canvas surface layer"""

    brush_collection: Collection
    """ Only use brush objects from this collection

    :type: Collection
    """

    brush_influence_scale: float
    """ Adjust influence brush objects have on this surface

    :type: float
    """

    brush_radius_scale: float
    """ Adjust radius of proximity brushes or particles for this surface

    :type: float
    """

    color_dry_threshold: float
    """ The wetness level when colors start to shift to the background

    :type: float
    """

    color_spread_speed: float
    """ How fast colors get mixed within wet paint

    :type: float
    """

    depth_clamp: float
    """ Maximum level of depth intersection in object space (use 0.0 to disable)

    :type: float
    """

    displace_factor: float
    """ Strength of displace when applied to the mesh

    :type: float
    """

    displace_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    dissolve_speed: int
    """ Approximately in how many frames should dissolve happen

    :type: int
    """

    drip_acceleration: float
    """ How much surface acceleration affects dripping

    :type: float
    """

    drip_velocity: float
    """ How much surface velocity affects dripping

    :type: float
    """

    dry_speed: int
    """ Approximately in how many frames should drying happen

    :type: int
    """

    effect_ui: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    effector_weights: EffectorWeights
    """ 

    :type: EffectorWeights
    """

    frame_end: int
    """ Simulation end frame

    :type: int
    """

    frame_start: int
    """ Simulation start frame

    :type: int
    """

    frame_substeps: int
    """ Do extra frames between scene frames to ensure smooth motion

    :type: int
    """

    image_fileformat: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    image_output_path: typing.Union[str, typing.Any]
    """ Directory to save the textures

    :type: typing.Union[str, typing.Any]
    """

    image_resolution: int
    """ Output image resolution

    :type: int
    """

    init_color: bpy_prop_array[float]
    """ Initial color of the surface

    :type: bpy_prop_array[float]
    """

    init_color_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    init_layername: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    init_texture: Texture
    """ 

    :type: Texture
    """

    is_active: bool
    """ Toggle whether surface is processed or ignored

    :type: bool
    """

    is_cache_user: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Surface name

    :type: typing.Union[str, typing.Any]
    """

    output_name_a: typing.Union[str, typing.Any]
    """ Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    """

    output_name_b: typing.Union[str, typing.Any]
    """ Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    """

    point_cache: PointCache
    """ 

    :type: PointCache
    """

    shrink_speed: float
    """ How fast shrink effect moves on the canvas surface

    :type: float
    """

    spread_speed: float
    """ How fast spread effect moves on the canvas surface

    :type: float
    """

    surface_format: typing.Union[str, int]
    """ Surface Format

    :type: typing.Union[str, int]
    """

    surface_type: typing.Union[str, int]
    """ Surface Type

    :type: typing.Union[str, int]
    """

    use_antialiasing: bool
    """ Use 5× multisampling to smooth paint edges

    :type: bool
    """

    use_dissolve: bool
    """ Enable to make surface changes disappear over time

    :type: bool
    """

    use_dissolve_log: bool
    """ Use logarithmic dissolve (makes high values to fade faster than low values)

    :type: bool
    """

    use_drip: bool
    """ Process drip effect (drip wet paint to gravity direction)

    :type: bool
    """

    use_dry_log: bool
    """ Use logarithmic drying (makes high values to dry faster than low values)

    :type: bool
    """

    use_drying: bool
    """ Enable to make surface wetness dry over time

    :type: bool
    """

    use_incremental_displace: bool
    """ New displace is added cumulatively on top of existing

    :type: bool
    """

    use_output_a: bool
    """ Save this output layer

    :type: bool
    """

    use_output_b: bool
    """ Save this output layer

    :type: bool
    """

    use_premultiply: bool
    """ Multiply color by alpha (recommended for Blender input)

    :type: bool
    """

    use_shrink: bool
    """ Process shrink effect (shrink paint areas)

    :type: bool
    """

    use_spread: bool
    """ Process spread effect (spread wet paint around surface)

    :type: bool
    """

    use_wave_open_border: bool
    """ Pass waves through mesh edges

    :type: bool
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    wave_damping: float
    """ Wave damping factor

    :type: float
    """

    wave_smoothness: float
    """ Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail)

    :type: float
    """

    wave_speed: float
    """ Wave propagation speed

    :type: float
    """

    wave_spring: float
    """ Spring force that pulls water level back to zero

    :type: float
    """

    wave_timescale: float
    """ Wave time scaling factor

    :type: float
    """

    def output_exists(self, object: Object, index: int) -> int:
        """Checks if surface output layer of given name exists

        :param object:
        :type object: Object
        :param index: Index
        :type index: int
        :return:
        :rtype: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class DynamicPaintSurfaces(bpy_struct):
    """Collection of Dynamic Paint Canvas surfaces"""

    active: DynamicPaintSurface
    """ Active Dynamic Paint surface being displayed

    :type: DynamicPaintSurface
    """

    active_index: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EQCurveMappingData(bpy_struct):
    """EQCurveMappingData"""

    curve_mapping: CurveMapping
    """ 

    :type: CurveMapping
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EdgeSplitModifier(bpy_struct):
    """Edge splitting modifier to create sharp edges"""

    split_angle: float
    """ Angle above which to split edges

    :type: float
    """

    use_edge_angle: bool
    """ Split edges with high angle between faces

    :type: bool
    """

    use_edge_sharp: bool
    """ Split edges that are marked as sharp

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EditBone(bpy_struct):
    """Edit mode bone in an armature data-block"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: EditBone
    """ Bone that serves as the end handle for the B-Bone curve

    :type: EditBone
    """

    bbone_custom_handle_start: EditBone
    """ Bone that serves as the start handle for the B-Bone curve

    :type: EditBone
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_handle_type_end: typing.Union[str, int]
    """ Selects how the end handle of the B-Bone is computed

    :type: typing.Union[str, int]
    """

    bbone_handle_type_start: typing.Union[str, int]
    """ Selects how the start handle of the B-Bone is computed

    :type: typing.Union[str, int]
    """

    bbone_handle_use_ease_end: bool
    """ Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_ease_start: bool
    """ Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_scale_end: typing.List[bool]
    """ Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_handle_use_scale_start: typing.List[bool]
    """ Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_mapping_mode: typing.Union[str, int]
    """ Selects how the vertices are mapped to B-Bone segments based on their position

    :type: typing.Union[str, int]
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    bbone_scaleout: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    bbone_segments: int
    """ Number of subdivisions of bone (for B-Bones only)

    :type: int
    """

    bbone_x: float
    """ B-Bone X size

    :type: float
    """

    bbone_z: float
    """ B-Bone Z size

    :type: float
    """

    collections: bpy_prop_collection[BoneCollection]
    """ Bone Collections that contain this bone

    :type: bpy_prop_collection[BoneCollection]
    """

    color: BoneColor
    """ 

    :type: BoneColor
    """

    envelope_distance: float
    """ Bone deformation distance (for Envelope deform only)

    :type: float
    """

    envelope_weight: float
    """ Bone deformation weight (for Envelope deform only)

    :type: float
    """

    head: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Location of head end of the bone

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    head_radius: float
    """ Radius of head of bone (for Envelope deform only)

    :type: float
    """

    hide: bool
    """ Bone is not visible when in Edit Mode

    :type: bool
    """

    hide_select: bool
    """ Bone is able to be selected

    :type: bool
    """

    inherit_scale: typing.Union[str, int]
    """ Specifies how the bone inherits scaling from the parent bone

    :type: typing.Union[str, int]
    """

    length: float
    """ Length of the bone. Changing moves the tail end

    :type: float
    """

    lock: bool
    """ Bone is not able to be transformed when in Edit Mode

    :type: bool
    """

    matrix: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Matrix combining location and rotation of the bone (head position, direction and roll), in armature space (does not include/support bone's length/size)

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: EditBone
    """ Parent edit bone (in same Armature)

    :type: EditBone
    """

    roll: float
    """ Bone rotation around head-tail axis

    :type: float
    """

    select: bool
    """ 

    :type: bool
    """

    select_head: bool
    """ 

    :type: bool
    """

    select_tail: bool
    """ 

    :type: bool
    """

    show_wire: bool
    """ Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    """

    tail: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Location of tail end of the bone

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    tail_radius: float
    """ Radius of tail of bone (for Envelope deform only)

    :type: float
    """

    use_connect: bool
    """ When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    """

    use_cyclic_offset: bool
    """ When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    """

    use_deform: bool
    """ Enable Bone to deform geometry

    :type: bool
    """

    use_endroll_as_inroll: bool
    """ Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    """

    use_envelope_multiply: bool
    """ When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    """

    use_inherit_rotation: bool
    """ Bone inherits rotation or scale from parent bone

    :type: bool
    """

    use_local_location: bool
    """ Bone location is set in local space

    :type: bool
    """

    use_relative_parent: bool
    """ Object children will use relative transform, like deform

    :type: bool
    """

    use_scale_easing: bool
    """ Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children: typing.Any
    """ A list of all the bones children.(readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def align_roll(
        self,
        vector: typing.Union[
            typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
        ],
    ):
        """Align the bone to a local-space roll so the Z axis points in the direction of the vector given

        :param vector: Vector
        :type vector: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
        """
        ...

    def align_orientation(self, other):
        """Align this bone to another by moving its tail and settings its roll
        the length of the other bone is not used.

                :param other:
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
        """
        ...

    def transform(
        self,
        matrix: typing.Union[typing.Sequence[float], mathutils.Matrix],
        scale: bool = True,
        roll: bool = True,
    ):
        """Transform the the bones head, tail, roll and envelope
        (when the matrix has a scale component).

                :param matrix: 3x3 or 4x4 transformation matrix.
                :type matrix: typing.Union[typing.Sequence[float], mathutils.Matrix]
                :param scale: Scale the bone envelope by the matrix.
                :type scale: bool
                :param roll: Correct the roll to point in the same relative
        direction to the head and tail.
                :type roll: bool
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EffectSequence(bpy_struct):
    """Sequence strip applying an effect on the images created by other strips"""

    alpha_mode: typing.Union[str, int]
    """ Representation of alpha information in the RGBA pixels

    :type: typing.Union[str, int]
    """

    color_multiply: float
    """ 

    :type: float
    """

    color_saturation: float
    """ Adjust the intensity of the input's color

    :type: float
    """

    crop: SequenceCrop
    """ 

    :type: SequenceCrop
    """

    multiply_alpha: bool
    """ Multiply alpha along with color channels

    :type: bool
    """

    proxy: SequenceProxy
    """ 

    :type: SequenceProxy
    """

    strobe: float
    """ Only display every nth frame

    :type: float
    """

    transform: SequenceTransform
    """ 

    :type: SequenceTransform
    """

    use_deinterlace: bool
    """ Remove fields from video movies

    :type: bool
    """

    use_flip_x: bool
    """ Flip on the X axis

    :type: bool
    """

    use_flip_y: bool
    """ Flip on the Y axis

    :type: bool
    """

    use_float: bool
    """ Convert input to float data

    :type: bool
    """

    use_proxy: bool
    """ Use a preview proxy and/or time-code index for this strip

    :type: bool
    """

    use_reverse_frames: bool
    """ Reverse frame order

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EffectorWeights(bpy_struct):
    """Effector weights for physics simulation"""

    all: float
    """ All effector's weight

    :type: float
    """

    apply_to_hair_growing: bool
    """ Use force fields when growing hair

    :type: bool
    """

    boid: float
    """ Boid effector weight

    :type: float
    """

    charge: float
    """ Charge effector weight

    :type: float
    """

    collection: Collection
    """ Limit effectors to this collection

    :type: Collection
    """

    curve_guide: float
    """ Curve guide effector weight

    :type: float
    """

    drag: float
    """ Drag effector weight

    :type: float
    """

    force: float
    """ Force effector weight

    :type: float
    """

    gravity: float
    """ Global gravity weight

    :type: float
    """

    harmonic: float
    """ Harmonic effector weight

    :type: float
    """

    lennardjones: float
    """ Lennard-Jones effector weight

    :type: float
    """

    magnetic: float
    """ Magnetic effector weight

    :type: float
    """

    smokeflow: float
    """ Fluid Flow effector weight

    :type: float
    """

    texture: float
    """ Texture effector weight

    :type: float
    """

    turbulence: float
    """ Turbulence effector weight

    :type: float
    """

    vortex: float
    """ Vortex effector weight

    :type: float
    """

    wind: float
    """ Wind effector weight

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EnumProperty(bpy_struct):
    """RNA enumeration property definition, to choose from a number of predefined options"""

    default: typing.Union[str, int]
    """ Default value for this enum

    :type: typing.Union[str, int]
    """

    default_flag: typing.Union[typing.Set[str], typing.Set[int], typing.Any]
    """ Default value for this enum

    :type: typing.Union[typing.Set[str], typing.Set[int], typing.Any]
    """

    enum_items: bpy_prop_collection[EnumPropertyItem]
    """ Possible values for the property

    :type: bpy_prop_collection[EnumPropertyItem]
    """

    enum_items_static: bpy_prop_collection[EnumPropertyItem]
    """ Possible values for the property (never calls optional dynamic generation of those)

    :type: bpy_prop_collection[EnumPropertyItem]
    """

    enum_items_static_ui: bpy_prop_collection[EnumPropertyItem]
    """ Possible values for the property (never calls optional dynamic generation of those). Includes UI elements (separators and section headings)

    :type: bpy_prop_collection[EnumPropertyItem]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EnumPropertyItem(bpy_struct):
    """Definition of a choice in an RNA enum property"""

    description: typing.Union[str, typing.Any]
    """ Description of the item's purpose

    :type: typing.Union[str, typing.Any]
    """

    icon: typing.Any
    """ Icon of the item

    :type: typing.Any
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Human readable name

    :type: typing.Union[str, typing.Any]
    """

    value: int
    """ Value of the item

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class EnvelopeGpencilModifier(bpy_struct):
    """Envelope stroke effect modifier"""

    invert_layer_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_layers: bool
    """ Inverse filter

    :type: bool
    """

    invert_material_pass: bool
    """ Inverse filter

    :type: bool
    """

    invert_materials: bool
    """ Inverse filter

    :type: bool
    """

    invert_vertex: bool
    """ Inverse filter

    :type: bool
    """

    layer: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    layer_pass: int
    """ Layer pass index

    :type: int
    """

    mat_nr: int
    """ The material to use for the new strokes

    :type: int
    """

    material: Material
    """ Material used for filtering effect

    :type: Material
    """

    mode: typing.Union[str, int]
    """ Algorithm to use for generating the envelope

    :type: typing.Union[str, int]
    """

    pass_index: int
    """ Pass index

    :type: int
    """

    skip: int
    """ The number of generated segments to skip to reduce complexity

    :type: int
    """

    spread: int
    """ The number of points to skip to create straight segments

    :type: int
    """

    strength: float
    """ Multiplier for the strength of the new strokes

    :type: float
    """

    thickness: float
    """ Multiplier for the thickness of the new strokes

    :type: float
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Vertex group name for modulating the deform

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Event(bpy_struct):
    """Window Manager Event"""

    alt: typing.Union[bool, typing.Any]
    """ True when the Alt/Option key is held

    :type: typing.Union[bool, typing.Any]
    """

    ascii: typing.Union[str, typing.Any]
    """ Single ASCII character for this event

    :type: typing.Union[str, typing.Any]
    """

    ctrl: typing.Union[bool, typing.Any]
    """ True when the Ctrl key is held

    :type: typing.Union[bool, typing.Any]
    """

    direction: typing.Any
    """ The direction (only applies to drag events)

    :type: typing.Any
    """

    is_consecutive: typing.Union[bool, typing.Any]
    """ Part of a trackpad or NDOF motion, interrupted by cursor motion, button or key press events

    :type: typing.Union[bool, typing.Any]
    """

    is_mouse_absolute: typing.Union[bool, typing.Any]
    """ The last motion event was an absolute input

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat: typing.Union[bool, typing.Any]
    """ The event is generated by holding a key down

    :type: typing.Union[bool, typing.Any]
    """

    is_tablet: typing.Union[bool, typing.Any]
    """ The event has tablet data

    :type: typing.Union[bool, typing.Any]
    """

    mouse_prev_press_x: int
    """ The window relative horizontal location of the last press event

    :type: int
    """

    mouse_prev_press_y: int
    """ The window relative vertical location of the last press event

    :type: int
    """

    mouse_prev_x: int
    """ The window relative horizontal location of the mouse

    :type: int
    """

    mouse_prev_y: int
    """ The window relative vertical location of the mouse

    :type: int
    """

    mouse_region_x: int
    """ The region relative horizontal location of the mouse

    :type: int
    """

    mouse_region_y: int
    """ The region relative vertical location of the mouse

    :type: int
    """

    mouse_x: int
    """ The window relative horizontal location of the mouse

    :type: int
    """

    mouse_y: int
    """ The window relative vertical location of the mouse

    :type: int
    """

    oskey: typing.Union[bool, typing.Any]
    """ True when the Cmd key is held

    :type: typing.Union[bool, typing.Any]
    """

    pressure: float
    """ The pressure of the tablet or 1.0 if no tablet present

    :type: float
    """

    shift: typing.Union[bool, typing.Any]
    """ True when the Shift key is held

    :type: typing.Union[bool, typing.Any]
    """

    tilt: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """ The pressure of the tablet or zeroes if no tablet present

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    type_prev: typing.Any
    """ 

    :type: typing.Any
    """

    unicode: typing.Union[str, typing.Any]
    """ Single unicode character for this event

    :type: typing.Union[str, typing.Any]
    """

    value: typing.Any
    """ The type of event, only applies to some

    :type: typing.Any
    """

    value_prev: typing.Any
    """ The type of event, only applies to some

    :type: typing.Any
    """

    xr: XrEventData
    """ XR event data

    :type: XrEventData
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class ExplodeModifier(bpy_struct):
    """Explosion effect modifier based on a particle system"""

    invert_vertex_group: bool
    """ Invert vertex group influence

    :type: bool
    """

    particle_uv: typing.Union[str, typing.Any]
    """ UV map to change with particle age

    :type: typing.Union[str, typing.Any]
    """

    protect: float
    """ Clean vertex group edges

    :type: float
    """

    show_alive: bool
    """ Show mesh when particles are alive

    :type: bool
    """

    show_dead: bool
    """ Show mesh when particles are dead

    :type: bool
    """

    show_unborn: bool
    """ Show mesh when particles are unborn

    :type: bool
    """

    use_edge_cut: bool
    """ Cut face edges for nicer shrapnel

    :type: bool
    """

    use_size: bool
    """ Use particle size for the shrapnel

    :type: bool
    """

    vertex_group: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FCurve(bpy_struct):
    """F-Curve defining values of a period of time"""

    array_index: int
    """ Index to the specific property affected by F-Curve if applicable

    :type: int
    """

    auto_smoothing: typing.Any
    """ Algorithm used to compute automatic handles"""

    color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color of the F-Curve in the Graph Editor

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    color_mode: typing.Union[str, int]
    """ Method used to determine color of F-Curve in Graph Editor

    :type: typing.Union[str, int]
    """

    data_path: typing.Union[str, typing.Any]
    """ RNA Path to property affected by F-Curve

    :type: typing.Union[str, typing.Any]
    """

    driver: Driver
    """ Channel Driver (only set for Driver F-Curves)

    :type: Driver
    """

    extrapolation: typing.Union[str, int]
    """ Method used for evaluating value of F-Curve outside first and last keyframes

    :type: typing.Union[str, int]
    """

    group: ActionGroup
    """ Action Group that this F-Curve belongs to

    :type: ActionGroup
    """

    hide: bool
    """ F-Curve and its keyframes are hidden in the Graph Editor graphs

    :type: bool
    """

    is_empty: typing.Union[bool, typing.Any]
    """ True if the curve contributes no animation due to lack of keyframes or useful modifiers, and should be deleted

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: bool
    """ False when F-Curve could not be evaluated in past, so should be skipped when evaluating

    :type: bool
    """

    keyframe_points: bpy_prop_collection[Keyframe]
    """ User-editable keyframes

    :type: bpy_prop_collection[Keyframe]
    """

    lock: bool
    """ F-Curve's settings cannot be edited

    :type: bool
    """

    modifiers: bpy_prop_collection[FModifier]
    """ Modifiers affecting the shape of the F-Curve

    :type: bpy_prop_collection[FModifier]
    """

    mute: bool
    """ Disable F-Curve evaluation

    :type: bool
    """

    sampled_points: bpy_prop_collection[FCurveSample]
    """ Sampled animation data

    :type: bpy_prop_collection[FCurveSample]
    """

    select: bool
    """ F-Curve is selected for editing

    :type: bool
    """

    def evaluate(self, frame: float) -> float:
        """Evaluate F-Curve

        :param frame: Frame, Evaluate F-Curve at given frame
        :type frame: float
        :return: Value, Value of F-Curve specific frame
        :rtype: float
        """
        ...

    def update(self):
        """Ensure keyframes are sorted in chronological order and handles are set correctly"""
        ...

    def range(self) -> float:
        """Get the time extents for F-Curve

        :return: Range, Min/Max values
        :rtype: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
        """
        ...

    def update_autoflags(self, data: typing.Any):
        """Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float)

        :param data: Data, Data containing the property controlled by given FCurve
        :type data: typing.Any
        """
        ...

    def convert_to_samples(self, start: int, end: int):
        """Convert current FCurve from keyframes to sample points, if necessary

        :param start: Start Frame
        :type start: int
        :param end: End Frame
        :type end: int
        """
        ...

    def convert_to_keyframes(self, start: int, end: int):
        """Convert current FCurve from sample points to keyframes (linear interpolation), if necessary

        :param start: Start Frame
        :type start: int
        :param end: End Frame
        :type end: int
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FCurveKeyframePoints(bpy_struct):
    """Collection of keyframe points"""

    def insert(
        self,
        frame: float,
        value: float,
        options: typing.Any = {},
        keyframe_type: typing.Any = "KEYFRAME",
    ) -> typing.Any:
        """Add a keyframe point to a F-Curve

                :param frame: X Value of this keyframe point
                :type frame: float
                :param value: Y Value of this keyframe point
                :type value: float
                :param options: Keyframe options

        REPLACE
        Replace -- Don't add any new keyframes, but just replace existing ones.

        NEEDED
        Needed -- Only adds keyframes that are needed.

        FAST
        Fast -- Fast keyframe insertion to avoid recalculating the curve each time.
                :type options: typing.Any
                :param keyframe_type: Type of keyframe to insert
                :type keyframe_type: typing.Any
                :return: Newly created keyframe
                :rtype: Keyframe
        """
        ...

    def add(self, count: int):
        """Add a keyframe point to a F-Curve

        :param count: Number, Number of points to add to the spline
        :type count: int
        """
        ...

    def remove(self, keyframe: Keyframe, fast: typing.Union[bool, typing.Any] = False):
        """Remove keyframe from an F-Curve

        :param keyframe: Keyframe to remove
        :type keyframe: Keyframe
        :param fast: Fast, Fast keyframe removal to avoid recalculating the curve each time
        :type fast: typing.Union[bool, typing.Any]
        """
        ...

    def clear(self):
        """Remove all keyframes from an F-Curve"""
        ...

    def sort(self):
        """Ensure all keyframe points are chronologically sorted"""
        ...

    def deduplicate(self):
        """Ensure there are no duplicate keys. Assumes that the points have already been sorted"""
        ...

    def handles_recalc(self):
        """Update handles after modifications to the keyframe points, to update things like auto-clamping"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FCurveModifiers(bpy_struct):
    """Collection of F-Curve Modifiers"""

    active: FModifier
    """ Active F-Curve Modifier

    :type: FModifier
    """

    def new(self, type):
        """Add a constraint to this object

        :param type: Constraint type to add
        :return: New fmodifier
        :rtype: FModifier
        """
        ...

    def remove(self, modifier: FModifier):
        """Remove a modifier from this F-Curve

        :param modifier: Removed modifier
        :type modifier: FModifier
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FCurveSample(bpy_struct):
    """Sample point for F-Curve"""

    co: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """ Point coordinates

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    select: bool
    """ Selection status

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FFmpegSettings(bpy_struct):
    """FFmpeg related settings for the scene"""

    audio_bitrate: int
    """ Audio bitrate (kb/s)

    :type: int
    """

    audio_channels: typing.Union[str, int]
    """ Audio channel count

    :type: typing.Union[str, int]
    """

    audio_codec: typing.Union[str, int]
    """ FFmpeg audio codec to use

    :type: typing.Union[str, int]
    """

    audio_mixrate: int
    """ Audio sample rate (samples/s)

    :type: int
    """

    audio_volume: float
    """ Audio volume

    :type: float
    """

    buffersize: int
    """ Rate control: buffer size (kb)

    :type: int
    """

    codec: typing.Union[str, int]
    """ FFmpeg codec to use for video output

    :type: typing.Union[str, int]
    """

    constant_rate_factor: typing.Union[str, int]
    """ Constant Rate Factor (CRF); tradeoff between video quality and file size

    :type: typing.Union[str, int]
    """

    ffmpeg_preset: typing.Union[str, int]
    """ Tradeoff between encoding speed and compression ratio

    :type: typing.Union[str, int]
    """

    format: typing.Union[str, int]
    """ Output file container

    :type: typing.Union[str, int]
    """

    gopsize: int
    """ Distance between key frames, also known as GOP size; influences file size and seekability

    :type: int
    """

    max_b_frames: int
    """ Maximum number of B-frames between non-B-frames; influences file size and seekability

    :type: int
    """

    maxrate: int
    """ Rate control: max rate (kbit/s)

    :type: int
    """

    minrate: int
    """ Rate control: min rate (kbit/s)

    :type: int
    """

    muxrate: int
    """ Mux rate (bits/second)

    :type: int
    """

    packetsize: int
    """ Mux packet size (byte)

    :type: int
    """

    use_autosplit: bool
    """ Autosplit output at 2GB boundary

    :type: bool
    """

    use_lossless_output: bool
    """ Use lossless output for video streams

    :type: bool
    """

    use_max_b_frames: bool
    """ Set a maximum number of B-frames

    :type: bool
    """

    video_bitrate: int
    """ Video bitrate (kbit/s)

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FILEBROWSER_UL_dir(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifier(bpy_struct):
    """Modifier for values of F-Curve"""

    active: bool
    """ F-Curve modifier will show settings in the editor

    :type: bool
    """

    blend_in: float
    """ Number of frames from start frame for influence to take effect

    :type: float
    """

    blend_out: float
    """ Number of frames from end frame for influence to fade out

    :type: float
    """

    frame_end: float
    """ Frame that modifier's influence ends (if Restrict Frame Range is in use)

    :type: float
    """

    frame_start: float
    """ Frame that modifier's influence starts (if Restrict Frame Range is in use)

    :type: float
    """

    influence: float
    """ Amount of influence F-Curve Modifier will have when not fading in/out

    :type: float
    """

    is_valid: typing.Union[bool, typing.Any]
    """ F-Curve Modifier has invalid settings and will not be evaluated

    :type: typing.Union[bool, typing.Any]
    """

    mute: bool
    """ Enable F-Curve modifier evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ F-Curve Modifier name

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ F-Curve Modifier's panel is expanded in UI

    :type: bool
    """

    type: typing.Any
    """ F-Curve Modifier Type

    :type: typing.Any
    """

    use_influence: bool
    """ F-Curve Modifier's effects will be tempered by a default factor

    :type: bool
    """

    use_restricted_range: bool
    """ F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierCycles(bpy_struct):
    """Repeat the values of the modified F-Curve"""

    cycles_after: int
    """ Maximum number of cycles to allow after last keyframe (0 = infinite)

    :type: int
    """

    cycles_before: int
    """ Maximum number of cycles to allow before first keyframe (0 = infinite)

    :type: int
    """

    mode_after: typing.Union[str, int]
    """ Cycling mode to use after last keyframe

    :type: typing.Union[str, int]
    """

    mode_before: typing.Union[str, int]
    """ Cycling mode to use before first keyframe

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierEnvelope(bpy_struct):
    """Scale the values of the modified F-Curve"""

    control_points: bpy_prop_collection[FModifierEnvelopeControlPoint]
    """ Control points defining the shape of the envelope

    :type: bpy_prop_collection[FModifierEnvelopeControlPoint]
    """

    default_max: float
    """ Upper distance from Reference Value for 1:1 default influence

    :type: float
    """

    default_min: float
    """ Lower distance from Reference Value for 1:1 default influence

    :type: float
    """

    reference_value: float
    """ Value that envelope's influence is centered around / based on

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierEnvelopeControlPoint(bpy_struct):
    """Control point for envelope F-Modifier"""

    frame: float
    """ Frame this control-point occurs on

    :type: float
    """

    max: float
    """ Upper bound of envelope at this control-point

    :type: float
    """

    min: float
    """ Lower bound of envelope at this control-point

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierEnvelopeControlPoints(bpy_struct):
    """Control points defining the shape of the envelope"""

    def add(self, frame: float) -> float:
        """Add a control point to a FModifierEnvelope

        :param frame: Frame to add this control-point
        :type frame: float
        :return: Newly created control-point
        :rtype: FModifierEnvelopeControlPoint
        """
        ...

    def remove(self, point: FModifierEnvelopeControlPoint):
        """Remove a control-point from an FModifierEnvelope

        :param point: Control-point to remove
        :type point: FModifierEnvelopeControlPoint
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierFunctionGenerator(bpy_struct):
    """Generate values using a built-in function"""

    amplitude: float
    """ Scale factor determining the maximum/minimum values

    :type: float
    """

    function_type: typing.Union[str, int]
    """ Type of built-in function to use

    :type: typing.Union[str, int]
    """

    phase_multiplier: float
    """ Scale factor determining the 'speed' of the function

    :type: float
    """

    phase_offset: float
    """ Constant factor to offset time by for function

    :type: float
    """

    use_additive: bool
    """ Values generated by this modifier are applied on top of the existing values instead of overwriting them

    :type: bool
    """

    value_offset: float
    """ Constant factor to offset values by

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierGenerator(bpy_struct):
    """Deterministically generate values for the modified F-Curve"""

    coefficients: bpy_prop_array[float]
    """ Coefficients for 'x' (starting from lowest power of x^0)

    :type: bpy_prop_array[float]
    """

    mode: typing.Union[str, int]
    """ Type of generator to use

    :type: typing.Union[str, int]
    """

    poly_order: int
    """ The highest power of 'x' for this polynomial (number of coefficients - 1)

    :type: int
    """

    use_additive: bool
    """ Values generated by this modifier are applied on top of the existing values instead of overwriting them

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierLimits(bpy_struct):
    """Limit the time/value ranges of the modified F-Curve"""

    max_x: float
    """ Highest X value to allow

    :type: float
    """

    max_y: float
    """ Highest Y value to allow

    :type: float
    """

    min_x: float
    """ Lowest X value to allow

    :type: float
    """

    min_y: float
    """ Lowest Y value to allow

    :type: float
    """

    use_max_x: bool
    """ Use the maximum X value

    :type: bool
    """

    use_max_y: bool
    """ Use the maximum Y value

    :type: bool
    """

    use_min_x: bool
    """ Use the minimum X value

    :type: bool
    """

    use_min_y: bool
    """ Use the minimum Y value

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierNoise(bpy_struct):
    """Give randomness to the modified F-Curve"""

    blend_type: typing.Union[str, int]
    """ Method of modifying the existing F-Curve

    :type: typing.Union[str, int]
    """

    depth: int
    """ Amount of fine level detail present in the noise

    :type: int
    """

    offset: float
    """ Time offset for the noise effect

    :type: float
    """

    phase: float
    """ A random seed for the noise effect

    :type: float
    """

    scale: float
    """ Scaling (in time) of the noise

    :type: float
    """

    strength: float
    """ Amplitude of the noise - the amount that it modifies the underlying curve

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierPython(bpy_struct):
    """Perform user-defined operation on the modified F-Curve"""

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FModifierStepped(bpy_struct):
    """Hold each interpolated value from the F-Curve for several frames without changing the timing"""

    frame_end: float
    """ Frame that modifier's influence ends (if applicable)

    :type: float
    """

    frame_offset: float
    """ Reference number of frames before frames get held (use to get hold for '1-3' vs '5-7' holding patterns)

    :type: float
    """

    frame_start: float
    """ Frame that modifier's influence starts (if applicable)

    :type: float
    """

    frame_step: float
    """ Number of frames to hold each value

    :type: float
    """

    use_frame_end: bool
    """ Restrict modifier to only act before its 'end' frame

    :type: bool
    """

    use_frame_start: bool
    """ Restrict modifier to only act after its 'start' frame

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FieldSettings(bpy_struct):
    """Field settings for an object in physics simulation"""

    apply_to_location: bool
    """ Affect particle's location

    :type: bool
    """

    apply_to_rotation: bool
    """ Affect particle's dynamic rotation

    :type: bool
    """

    distance_max: float
    """ Maximum distance for the field to work

    :type: float
    """

    distance_min: float
    """ Minimum distance for the field's falloff

    :type: float
    """

    falloff_power: float
    """ How quickly strength falls off with distance from the force field

    :type: float
    """

    falloff_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    flow: float
    """ Convert effector force into air flow velocity

    :type: float
    """

    guide_clump_amount: float
    """ Amount of clumping

    :type: float
    """

    guide_clump_shape: float
    """ Shape of clumping

    :type: float
    """

    guide_free: float
    """ Guide-free time from particle life's end

    :type: float
    """

    guide_kink_amplitude: float
    """ The amplitude of the offset

    :type: float
    """

    guide_kink_axis: typing.Any
    """ Which axis to use for offset"""

    guide_kink_frequency: float
    """ The frequency of the offset (1/total length)

    :type: float
    """

    guide_kink_shape: float
    """ Adjust the offset to the beginning/end

    :type: float
    """

    guide_kink_type: typing.Union[str, int]
    """ Type of periodic offset on the curve

    :type: typing.Union[str, int]
    """

    guide_minimum: float
    """ The distance from which particles are affected fully

    :type: float
    """

    harmonic_damping: float
    """ Damping of the harmonic force

    :type: float
    """

    inflow: float
    """ Inwards component of the vortex force

    :type: float
    """

    linear_drag: float
    """ Drag component proportional to velocity

    :type: float
    """

    noise: float
    """ Amount of noise for the force strength

    :type: float
    """

    quadratic_drag: float
    """ Drag component proportional to the square of velocity

    :type: float
    """

    radial_falloff: float
    """ Radial falloff power (real gravitational falloff = 2)

    :type: float
    """

    radial_max: float
    """ Maximum radial distance for the field to work

    :type: float
    """

    radial_min: float
    """ Minimum radial distance for the field's falloff

    :type: float
    """

    rest_length: float
    """ Rest length of the harmonic force

    :type: float
    """

    seed: int
    """ Seed of the noise

    :type: int
    """

    shape: typing.Union[str, int]
    """ Which direction is used to calculate the effector force

    :type: typing.Union[str, int]
    """

    size: float
    """ Size of the turbulence

    :type: float
    """

    source_object: Object
    """ Select domain object of the smoke simulation

    :type: Object
    """

    strength: float
    """ Strength of force field

    :type: float
    """

    texture: Texture
    """ Texture to use as force

    :type: Texture
    """

    texture_mode: typing.Union[str, int]
    """ How the texture effect is calculated (RGB and Curl need a RGB texture, else Gradient will be used instead)

    :type: typing.Union[str, int]
    """

    texture_nabla: float
    """ Defines size of derivative offset used for calculating gradient and curl

    :type: float
    """

    type: typing.Union[str, int]
    """ Type of field

    :type: typing.Union[str, int]
    """

    use_2d_force: bool
    """ Apply force only in 2D

    :type: bool
    """

    use_absorption: bool
    """ Force gets absorbed by collision objects

    :type: bool
    """

    use_global_coords: bool
    """ Use effector/global coordinates for turbulence

    :type: bool
    """

    use_gravity_falloff: bool
    """ Multiply force by 1/distance²

    :type: bool
    """

    use_guide_path_add: bool
    """ Based on distance/falloff it adds a portion of the entire path

    :type: bool
    """

    use_guide_path_weight: bool
    """ Use curve weights to influence the particle influence along the curve

    :type: bool
    """

    use_max_distance: bool
    """ Use a maximum distance for the field to work

    :type: bool
    """

    use_min_distance: bool
    """ Use a minimum distance for the field's falloff

    :type: bool
    """

    use_multiple_springs: bool
    """ Every point is affected by multiple springs

    :type: bool
    """

    use_object_coords: bool
    """ Use object/global coordinates for texture

    :type: bool
    """

    use_radial_max: bool
    """ Use a maximum radial distance for the field to work

    :type: bool
    """

    use_radial_min: bool
    """ Use a minimum radial distance for the field's falloff

    :type: bool
    """

    use_root_coords: bool
    """ Texture coordinates from root particle locations

    :type: bool
    """

    use_smoke_density: bool
    """ Adjust force strength based on smoke density

    :type: bool
    """

    wind_factor: float
    """ How much the force is reduced when acting parallel to a surface, e.g. cloth

    :type: float
    """

    z_direction: typing.Union[str, int]
    """ Effect in full or only positive/negative Z direction

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileAssetSelectIDFilter(bpy_struct):
    """Which asset types to show/hide, when browsing an asset library"""

    experimental_filter_armature: bool
    """ Show Armature data-blocks

    :type: bool
    """

    experimental_filter_brush: bool
    """ Show Brushes data-blocks

    :type: bool
    """

    experimental_filter_cachefile: bool
    """ Show Cache File data-blocks

    :type: bool
    """

    experimental_filter_camera: bool
    """ Show Camera data-blocks

    :type: bool
    """

    experimental_filter_curve: bool
    """ Show Curve data-blocks

    :type: bool
    """

    experimental_filter_curves: bool
    """ Show/hide Curves data-blocks

    :type: bool
    """

    experimental_filter_font: bool
    """ Show Font data-blocks

    :type: bool
    """

    experimental_filter_grease_pencil: bool
    """ Show Grease pencil data-blocks

    :type: bool
    """

    experimental_filter_image: bool
    """ Show Image data-blocks

    :type: bool
    """

    experimental_filter_lattice: bool
    """ Show Lattice data-blocks

    :type: bool
    """

    experimental_filter_light: bool
    """ Show Light data-blocks

    :type: bool
    """

    experimental_filter_light_probe: bool
    """ Show Light Probe data-blocks

    :type: bool
    """

    experimental_filter_linestyle: bool
    """ Show Freestyle's Line Style data-blocks

    :type: bool
    """

    experimental_filter_mask: bool
    """ Show Mask data-blocks

    :type: bool
    """

    experimental_filter_mesh: bool
    """ Show Mesh data-blocks

    :type: bool
    """

    experimental_filter_metaball: bool
    """ Show Metaball data-blocks

    :type: bool
    """

    experimental_filter_movie_clip: bool
    """ Show Movie Clip data-blocks

    :type: bool
    """

    experimental_filter_paint_curve: bool
    """ Show Paint Curve data-blocks

    :type: bool
    """

    experimental_filter_palette: bool
    """ Show Palette data-blocks

    :type: bool
    """

    experimental_filter_particle_settings: bool
    """ Show Particle Settings data-blocks

    :type: bool
    """

    experimental_filter_pointcloud: bool
    """ Show/hide Point Cloud data-blocks

    :type: bool
    """

    experimental_filter_scene: bool
    """ Show Scene data-blocks

    :type: bool
    """

    experimental_filter_sound: bool
    """ Show Sound data-blocks

    :type: bool
    """

    experimental_filter_speaker: bool
    """ Show Speaker data-blocks

    :type: bool
    """

    experimental_filter_text: bool
    """ Show Text data-blocks

    :type: bool
    """

    experimental_filter_texture: bool
    """ Show Texture data-blocks

    :type: bool
    """

    experimental_filter_volume: bool
    """ Show/hide Volume data-blocks

    :type: bool
    """

    experimental_filter_work_space: bool
    """ Show workspace data-blocks

    :type: bool
    """

    filter_action: bool
    """ Show Action data-blocks

    :type: bool
    """

    filter_group: bool
    """ Show Collection data-blocks

    :type: bool
    """

    filter_material: bool
    """ Show Material data-blocks

    :type: bool
    """

    filter_node_tree: bool
    """ Show Node Tree data-blocks

    :type: bool
    """

    filter_object: bool
    """ Show Object data-blocks

    :type: bool
    """

    filter_world: bool
    """ Show World data-blocks

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileAssetSelectParams(bpy_struct):
    """Settings for the file selection in Asset Browser mode"""

    asset_library_reference: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    catalog_id: typing.Union[str, typing.Any]
    """ The UUID of the catalog shown in the browser

    :type: typing.Union[str, typing.Any]
    """

    filter_asset_id: FileAssetSelectIDFilter
    """ Which asset types to show/hide, when browsing an asset library

    :type: FileAssetSelectIDFilter
    """

    import_method: typing.Union[str, int]
    """ Determine how the asset will be imported

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileBrowserFSMenuEntry(bpy_struct):
    """File Select Parameters"""

    icon: int
    """ 

    :type: int
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Whether this path is currently reachable

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    path: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_save: typing.Union[bool, typing.Any]
    """ Whether this path is saved in bookmarks, or generated from OS

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileHandler:
    """Extends functionality to operators that manages files, such as adding drag and drop support"""

    bl_file_extensions: typing.Union[str, typing.Any]
    """ Formatted string of file extensions supported by the file handler, each extension should start with a "." and be separated by ";".
For Example: ".blend;.ble"

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the file handler gets a custom ID, otherwise it takes the name of the class used to define the file handler (for example, if the class name is "OBJECT_FH_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_FH_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_import_operator: typing.Union[str, typing.Any]
    """ Operator that can handle import files with the extensions given in bl_file_extensions

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The file handler label

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def poll_drop(cls, context: Context) -> Context:
        """If this method returns True, can be used to handle the drop of a drag-and-drop action

        :param context:
        :type context: Context
        :return:
        :rtype: bool
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileSelectEntry(bpy_struct):
    """A file viewable in the File Browser"""

    asset_data: AssetMetaData
    """ Asset data, valid if the file represents an asset

    :type: AssetMetaData
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    preview_icon_id: int
    """ Unique integer identifying the preview of this file as an icon (zero means invalid)

    :type: int
    """

    relative_path: typing.Union[str, typing.Any]
    """ Path relative to the directory currently displayed in the File Browser (includes the file name)

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileSelectIDFilter(bpy_struct):
    """Which ID types to show/hide, when browsing a library"""

    category_animation: bool
    """ Show animation data

    :type: bool
    """

    category_environment: bool
    """ Show worlds, lights, cameras and speakers

    :type: bool
    """

    category_geometry: bool
    """ Show meshes, curves, lattice, armatures and metaballs data

    :type: bool
    """

    category_image: bool
    """ Show images, movie clips, sounds and masks

    :type: bool
    """

    category_misc: bool
    """ Show other data types

    :type: bool
    """

    category_object: bool
    """ Show objects and collections

    :type: bool
    """

    category_scene: bool
    """ Show scenes

    :type: bool
    """

    category_shading: bool
    """ Show materials, node-trees, textures and Freestyle's line-styles

    :type: bool
    """

    filter_action: bool
    """ Show Action data-blocks

    :type: bool
    """

    filter_armature: bool
    """ Show Armature data-blocks

    :type: bool
    """

    filter_brush: bool
    """ Show Brushes data-blocks

    :type: bool
    """

    filter_cachefile: bool
    """ Show Cache File data-blocks

    :type: bool
    """

    filter_camera: bool
    """ Show Camera data-blocks

    :type: bool
    """

    filter_curve: bool
    """ Show Curve data-blocks

    :type: bool
    """

    filter_curves: bool
    """ Show/hide Curves data-blocks

    :type: bool
    """

    filter_font: bool
    """ Show Font data-blocks

    :type: bool
    """

    filter_grease_pencil: bool
    """ Show Grease pencil data-blocks

    :type: bool
    """

    filter_group: bool
    """ Show Collection data-blocks

    :type: bool
    """

    filter_image: bool
    """ Show Image data-blocks

    :type: bool
    """

    filter_lattice: bool
    """ Show Lattice data-blocks

    :type: bool
    """

    filter_light: bool
    """ Show Light data-blocks

    :type: bool
    """

    filter_light_probe: bool
    """ Show Light Probe data-blocks

    :type: bool
    """

    filter_linestyle: bool
    """ Show Freestyle's Line Style data-blocks

    :type: bool
    """

    filter_mask: bool
    """ Show Mask data-blocks

    :type: bool
    """

    filter_material: bool
    """ Show Material data-blocks

    :type: bool
    """

    filter_mesh: bool
    """ Show Mesh data-blocks

    :type: bool
    """

    filter_metaball: bool
    """ Show Metaball data-blocks

    :type: bool
    """

    filter_movie_clip: bool
    """ Show Movie Clip data-blocks

    :type: bool
    """

    filter_node_tree: bool
    """ Show Node Tree data-blocks

    :type: bool
    """

    filter_object: bool
    """ Show Object data-blocks

    :type: bool
    """

    filter_paint_curve: bool
    """ Show Paint Curve data-blocks

    :type: bool
    """

    filter_palette: bool
    """ Show Palette data-blocks

    :type: bool
    """

    filter_particle_settings: bool
    """ Show Particle Settings data-blocks

    :type: bool
    """

    filter_pointcloud: bool
    """ Show/hide Point Cloud data-blocks

    :type: bool
    """

    filter_scene: bool
    """ Show Scene data-blocks

    :type: bool
    """

    filter_sound: bool
    """ Show Sound data-blocks

    :type: bool
    """

    filter_speaker: bool
    """ Show Speaker data-blocks

    :type: bool
    """

    filter_text: bool
    """ Show Text data-blocks

    :type: bool
    """

    filter_texture: bool
    """ Show Texture data-blocks

    :type: bool
    """

    filter_volume: bool
    """ Show/hide Volume data-blocks

    :type: bool
    """

    filter_work_space: bool
    """ Show workspace data-blocks

    :type: bool
    """

    filter_world: bool
    """ Show World data-blocks

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FileSelectParams(bpy_struct):
    """File Select Parameters"""

    directory: typing.Union[str, typing.Any]
    """ Directory displayed in the file browser

    :type: typing.Union[str, typing.Any]
    """

    display_size: int
    """ Change the size of thumbnails

    :type: int
    """

    display_size_discrete: typing.Union[str, int]
    """ Change the size of thumbnails in discrete steps

    :type: typing.Union[str, int]
    """

    display_type: typing.Union[str, int]
    """ Display mode for the file list

    :type: typing.Union[str, int]
    """

    filename: typing.Union[str, typing.Any]
    """ Active file in the file browser

    :type: typing.Union[str, typing.Any]
    """

    filter_glob: typing.Union[str, typing.Any]
    """ UNIX shell-like filename patterns matching, supports wildcards ('*') and list of patterns separated by ';'

    :type: typing.Union[str, typing.Any]
    """

    filter_id: FileSelectIDFilter
    """ Which ID types to show/hide, when browsing a library

    :type: FileSelectIDFilter
    """

    filter_search: typing.Union[str, typing.Any]
    """ Filter by name or tag, supports '*' wildcard

    :type: typing.Union[str, typing.Any]
    """

    recursion_level: typing.Union[str, int]
    """ Numbers of dirtree levels to show simultaneously

    :type: typing.Union[str, int]
    """

    show_details_datetime: bool
    """ Show a column listing the date and time of modification for each file

    :type: bool
    """

    show_details_size: bool
    """ Show a column listing the size of each file

    :type: bool
    """

    show_hidden: bool
    """ Show hidden dot files

    :type: bool
    """

    sort_method: typing.Any
    """ """

    title: typing.Union[str, typing.Any]
    """ Title for the file browser

    :type: typing.Union[str, typing.Any]
    """

    use_filter: bool
    """ Enable filtering of files

    :type: bool
    """

    use_filter_asset_only: bool
    """ Hide .blend files items that are not data-blocks with asset metadata

    :type: bool
    """

    use_filter_backup: bool
    """ Show .blend1, .blend2, etc. files

    :type: bool
    """

    use_filter_blender: bool
    """ Show .blend files

    :type: bool
    """

    use_filter_blendid: bool
    """ Show .blend files items (objects, materials, etc.)

    :type: bool
    """

    use_filter_folder: bool
    """ Show folders

    :type: bool
    """

    use_filter_font: bool
    """ Show font files

    :type: bool
    """

    use_filter_image: bool
    """ Show image files

    :type: bool
    """

    use_filter_movie: bool
    """ Show movie files

    :type: bool
    """

    use_filter_script: bool
    """ Show script files

    :type: bool
    """

    use_filter_sound: bool
    """ Show sound files

    :type: bool
    """

    use_filter_text: bool
    """ Show text files

    :type: bool
    """

    use_filter_volume: bool
    """ Show 3D volume files

    :type: bool
    """

    use_library_browsing: typing.Union[bool, typing.Any]
    """ Whether we may browse Blender files' content or not

    :type: typing.Union[bool, typing.Any]
    """

    use_sort_invert: bool
    """ Sort items descending, from highest value to lowest

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Float2Attribute(bpy_struct):
    """Geometry attribute that stores floating-point 2D vectors"""

    data: bpy_prop_collection[Float2AttributeValue]
    """ 

    :type: bpy_prop_collection[Float2AttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Float2AttributeValue(bpy_struct):
    """2D Vector value in geometry attribute"""

    vector: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ 2D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Float4x4Attribute(bpy_struct):
    """Geometry attribute that stores a 4 by 4 float matrix"""

    data: bpy_prop_collection[Float4x4AttributeValue]
    """ 

    :type: bpy_prop_collection[Float4x4AttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Float4x4AttributeValue(bpy_struct):
    """Matrix value in geometry attribute"""

    value: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatAttribute(bpy_struct):
    """Geometry attribute that stores floating-point values"""

    data: bpy_prop_collection[FloatAttributeValue]
    """ 

    :type: bpy_prop_collection[FloatAttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatAttributeValue(bpy_struct):
    """Floating-point value in geometry attribute"""

    value: float
    """ 

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatColorAttribute(bpy_struct):
    """Geometry attribute that stores RGBA colors as floating-point values using 32-bits per channel"""

    data: bpy_prop_collection[FloatColorAttributeValue]
    """ 

    :type: bpy_prop_collection[FloatColorAttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatColorAttributeValue(bpy_struct):
    """Color value in geometry attribute"""

    color: bpy_prop_array[float]
    """ RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    """

    color_srgb: bpy_prop_array[float]
    """ RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatProperty(bpy_struct):
    """RNA floating-point number (single precision) property definition"""

    array_dimensions: bpy_prop_array[int]
    """ Length of each dimension of the array

    :type: bpy_prop_array[int]
    """

    array_length: int
    """ Maximum length of the array, 0 means unlimited

    :type: int
    """

    default: float
    """ Default value for this number

    :type: float
    """

    default_array: bpy_prop_array[float]
    """ Default value for this array

    :type: bpy_prop_array[float]
    """

    hard_max: float
    """ Maximum value used by buttons

    :type: float
    """

    hard_min: float
    """ Minimum value used by buttons

    :type: float
    """

    is_array: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    precision: int
    """ Number of digits after the dot used by buttons. Fraction is automatically hidden for exact integer values of fields with unit 'NONE' or 'TIME' (frame count) and step divisible by 100

    :type: int
    """

    soft_max: float
    """ Maximum value used by buttons

    :type: float
    """

    soft_min: float
    """ Minimum value used by buttons

    :type: float
    """

    step: float
    """ Step size used by number buttons, for floats 1/100th of the step size

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatVectorAttribute(bpy_struct):
    """Geometry attribute that stores floating-point 3D vectors"""

    data: bpy_prop_collection[FloatVectorAttributeValue]
    """ 

    :type: bpy_prop_collection[FloatVectorAttributeValue]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatVectorAttributeValue(bpy_struct):
    """Vector value in geometry attribute"""

    vector: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 3D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloatVectorValueReadOnly(bpy_struct):
    """ """

    vector: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 3D vector

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FloorConstraint(bpy_struct):
    """Use the target object for location limitation"""

    floor_location: typing.Union[str, int]
    """ Location of target that object will not pass through

    :type: typing.Union[str, int]
    """

    offset: float
    """ Offset of floor from object origin

    :type: float
    """

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: Object
    """ Target object

    :type: Object
    """

    use_rotation: bool
    """ Use the target's rotation to determine floor

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FluidDomainSettings(bpy_struct):
    """Fluid domain settings"""

    adapt_margin: int
    """ Margin added around fluid to minimize boundary interference

    :type: int
    """

    adapt_threshold: float
    """ Minimum amount of fluid a cell can contain before it is considered empty

    :type: float
    """

    additional_res: int
    """ Maximum number of additional cells

    :type: int
    """

    alpha: float
    """ Buoyant force based on smoke density (higher value results in faster rising smoke)

    :type: float
    """

    beta: float
    """ Buoyant force based on smoke heat (higher value results in faster rising smoke)

    :type: float
    """

    burning_rate: float
    """ Speed of the burning reaction (higher value results in smaller flames)

    :type: float
    """

    cache_data_format: typing.Union[str, int]
    """ Select the file format to be used for caching volumetric data

    :type: typing.Union[str, int]
    """

    cache_directory: typing.Union[str, typing.Any]
    """ Directory that contains fluid cache files

    :type: typing.Union[str, typing.Any]
    """

    cache_frame_end: int
    """ Frame on which the simulation stops. This is the last frame that will be baked

    :type: int
    """

    cache_frame_offset: int
    """ Frame offset that is used when loading the simulation from the cache. It is not considered when baking the simulation, only when loading it

    :type: int
    """

    cache_frame_pause_data: int
    """ 

    :type: int
    """

    cache_frame_pause_guide: int
    """ 

    :type: int
    """

    cache_frame_pause_mesh: int
    """ 

    :type: int
    """

    cache_frame_pause_noise: int
    """ 

    :type: int
    """

    cache_frame_pause_particles: int
    """ 

    :type: int
    """

    cache_frame_start: int
    """ Frame on which the simulation starts. This is the first frame that will be baked

    :type: int
    """

    cache_mesh_format: typing.Union[str, int]
    """ Select the file format to be used for caching surface data

    :type: typing.Union[str, int]
    """

    cache_noise_format: typing.Union[str, int]
    """ Select the file format to be used for caching noise data

    :type: typing.Union[str, int]
    """

    cache_particle_format: typing.Union[str, int]
    """ Select the file format to be used for caching particle data

    :type: typing.Union[str, int]
    """

    cache_resumable: bool
    """ Additional data will be saved so that the bake jobs can be resumed after pausing. Because more data will be written to disk it is recommended to avoid enabling this option when baking at high resolutions

    :type: bool
    """

    cache_type: typing.Union[str, int]
    """ Change the cache type of the simulation

    :type: typing.Union[str, int]
    """

    cell_size: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Cell Size

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    cfl_condition: float
    """ Maximal velocity per cell (greater CFL numbers will minimize the number of simulation steps and the computation time.)

    :type: float
    """

    clipping: float
    """ Value under which voxels are considered empty space to optimize rendering

    :type: float
    """

    color_grid: bpy_prop_array[float]
    """ Smoke color grid

    :type: bpy_prop_array[float]
    """

    color_ramp: ColorRamp
    """ 

    :type: ColorRamp
    """

    color_ramp_field: typing.Union[str, int]
    """ Simulation field to color map

    :type: typing.Union[str, int]
    """

    color_ramp_field_scale: float
    """ Multiplier for scaling the selected field to color map

    :type: float
    """

    delete_in_obstacle: bool
    """ Delete fluid inside obstacles

    :type: bool
    """

    density_grid: bpy_prop_array[float]
    """ Smoke density grid

    :type: bpy_prop_array[float]
    """

    display_interpolation: typing.Union[str, int]
    """ Interpolation method to use for smoke/fire volumes in solid mode

    :type: typing.Union[str, int]
    """

    display_thickness: float
    """ Thickness of smoke display in the viewport

    :type: float
    """

    dissolve_speed: int
    """ Determine how quickly the smoke dissolves (lower value makes smoke disappear faster)

    :type: int
    """

    domain_resolution: bpy_prop_array[int]
    """ Smoke Grid Resolution

    :type: bpy_prop_array[int]
    """

    domain_type: typing.Union[str, int]
    """ Change domain type of the simulation

    :type: typing.Union[str, int]
    """

    effector_group: Collection
    """ Limit effectors to this collection

    :type: Collection
    """

    effector_weights: EffectorWeights
    """ 

    :type: EffectorWeights
    """

    export_manta_script: bool
    """ Generate and export Mantaflow script from current domain settings during bake. This is only needed if you plan to analyze the cache (e.g. view grids, velocity vectors, particles) in Mantaflow directly (outside of Blender) after baking the simulation

    :type: bool
    """

    flame_grid: bpy_prop_array[float]
    """ Smoke flame grid

    :type: bpy_prop_array[float]
    """

    flame_ignition: float
    """ Minimum temperature of the flames (higher value results in faster rising flames)

    :type: float
    """

    flame_max_temp: float
    """ Maximum temperature of the flames (higher value results in faster rising flames)

    :type: float
    """

    flame_smoke: float
    """ Amount of smoke created by burning fuel

    :type: float
    """

    flame_smoke_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color of smoke emitted from burning fuel

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    flame_vorticity: float
    """ Additional vorticity for the flames

    :type: float
    """

    flip_ratio: float
    """ PIC/FLIP Ratio. A value of 1.0 will result in a completely FLIP based simulation. Use a lower value for simulations which should produce smaller splashes

    :type: float
    """

    fluid_group: Collection
    """ Limit fluid objects to this collection

    :type: Collection
    """

    force_collection: Collection
    """ Limit forces to this collection

    :type: Collection
    """

    fractions_distance: float
    """ Determines how far apart fluid and obstacle are (higher values will result in fluid being further away from obstacles, smaller values will let fluid move towards the inside of obstacles)

    :type: float
    """

    fractions_threshold: float
    """ Determines how much fluid is allowed in an obstacle cell (higher values will tag a boundary cell as an obstacle easier and reduce the boundary smoothening effect)

    :type: float
    """

    gravity: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Gravity in X, Y and Z direction

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    gridlines_cell_filter: typing.Union[str, int]
    """ Cell type to be highlighted

    :type: typing.Union[str, int]
    """

    gridlines_color_field: typing.Union[str, int]
    """ Simulation field to color map onto gridlines

    :type: typing.Union[str, int]
    """

    gridlines_lower_bound: float
    """ Lower bound of the highlighting range

    :type: float
    """

    gridlines_range_color: bpy_prop_array[float]
    """ Color used to highlight the range

    :type: bpy_prop_array[float]
    """

    gridlines_upper_bound: float
    """ Upper bound of the highlighting range

    :type: float
    """

    guide_alpha: float
    """ Guiding weight (higher value results in greater lag)

    :type: float
    """

    guide_beta: int
    """ Guiding size (higher value results in larger vortices)

    :type: int
    """

    guide_parent: Object
    """ Use velocities from this object for the guiding effect (object needs to have fluid modifier and be of type domain))

    :type: Object
    """

    guide_source: typing.Union[str, int]
    """ Choose where to get guiding velocities from

    :type: typing.Union[str, int]
    """

    guide_vel_factor: float
    """ Guiding velocity factor (higher value results in greater guiding velocities)

    :type: float
    """

    has_cache_baked_any: bool
    """ 

    :type: bool
    """

    has_cache_baked_data: bool
    """ 

    :type: bool
    """

    has_cache_baked_guide: bool
    """ 

    :type: bool
    """

    has_cache_baked_mesh: bool
    """ 

    :type: bool
    """

    has_cache_baked_noise: bool
    """ 

    :type: bool
    """

    has_cache_baked_particles: bool
    """ 

    :type: bool
    """

    heat_grid: bpy_prop_array[float]
    """ Smoke heat grid

    :type: bpy_prop_array[float]
    """

    highres_sampling: typing.Union[str, int]
    """ Method for sampling the high resolution flow

    :type: typing.Union[str, int]
    """

    is_cache_baking_any: bool
    """ 

    :type: bool
    """

    is_cache_baking_data: bool
    """ 

    :type: bool
    """

    is_cache_baking_guide: bool
    """ 

    :type: bool
    """

    is_cache_baking_mesh: bool
    """ 

    :type: bool
    """

    is_cache_baking_noise: bool
    """ 

    :type: bool
    """

    is_cache_baking_particles: bool
    """ 

    :type: bool
    """

    mesh_concave_lower: float
    """ Lower mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    """

    mesh_concave_upper: float
    """ Upper mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    """

    mesh_generator: typing.Union[str, int]
    """ Which particle level set generator to use

    :type: typing.Union[str, int]
    """

    mesh_particle_radius: float
    """ Particle radius factor (higher value results in larger (meshed) particles). Needs to be adjusted after changing the mesh scale

    :type: float
    """

    mesh_scale: int
    """ The mesh simulation is scaled up by this factor (compared to the base resolution of the domain). For best meshing, it is recommended to adjust the mesh particle radius alongside this value

    :type: int
    """

    mesh_smoothen_neg: int
    """ Negative mesh smoothening

    :type: int
    """

    mesh_smoothen_pos: int
    """ Positive mesh smoothening

    :type: int
    """

    noise_pos_scale: float
    """ Scale of noise (higher value results in larger vortices)

    :type: float
    """

    noise_scale: int
    """ The noise simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    """

    noise_strength: float
    """ Strength of noise

    :type: float
    """

    noise_time_anim: float
    """ Animation time of noise

    :type: float
    """

    openvdb_cache_compress_type: typing.Union[str, int]
    """ Compression method to be used

    :type: typing.Union[str, int]
    """

    openvdb_data_depth: typing.Union[str, int]
    """ Bit depth for fluid particles and grids (lower bit values reduce file size)

    :type: typing.Union[str, int]
    """

    particle_band_width: float
    """ Particle (narrow) band width (higher value results in thicker band and more particles)

    :type: float
    """

    particle_max: int
    """ Maximum number of particles per cell (ensures that each cell has at most this amount of particles)

    :type: int
    """

    particle_min: int
    """ Minimum number of particles per cell (ensures that each cell has at least this amount of particles)

    :type: int
    """

    particle_number: int
    """ Particle number factor (higher value results in more particles)

    :type: int
    """

    particle_radius: float
    """ Particle radius factor. Increase this value if the simulation appears to leak volume, decrease it if the simulation seems to gain volume

    :type: float
    """

    particle_randomness: float
    """ Randomness factor for particle sampling

    :type: float
    """

    particle_scale: int
    """ The particle simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    """

    resolution_max: int
    """ Resolution used for the fluid domain. Value corresponds to the longest domain side (resolution for other domain sides is calculated automatically)

    :type: int
    """

    show_gridlines: bool
    """ Show gridlines

    :type: bool
    """

    show_velocity: bool
    """ Visualize vector fields

    :type: bool
    """

    simulation_method: typing.Union[str, int]
    """ Change the underlying simulation method

    :type: typing.Union[str, int]
    """

    slice_axis: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    slice_depth: float
    """ Position of the slice

    :type: float
    """

    slice_per_voxel: float
    """ How many slices per voxel should be generated

    :type: float
    """

    sndparticle_boundary: typing.Union[str, int]
    """ How particles that left the domain are treated

    :type: typing.Union[str, int]
    """

    sndparticle_bubble_buoyancy: float
    """ Amount of buoyancy force that rises bubbles (high value results in bubble movement mainly upwards)

    :type: float
    """

    sndparticle_bubble_drag: float
    """ Amount of drag force that moves bubbles along with the fluid (high value results in bubble movement mainly along with the fluid)

    :type: float
    """

    sndparticle_combined_export: typing.Union[str, int]
    """ Determines which particle systems are created from secondary particles

    :type: typing.Union[str, int]
    """

    sndparticle_life_max: float
    """ Highest possible particle lifetime

    :type: float
    """

    sndparticle_life_min: float
    """ Lowest possible particle lifetime

    :type: float
    """

    sndparticle_potential_max_energy: float
    """ Upper clamping threshold that indicates the fluid speed where cells no longer emit more particles (higher value results in generally less particles)

    :type: float
    """

    sndparticle_potential_max_trappedair: float
    """ Upper clamping threshold for marking fluid cells where air is trapped (higher value results in less marked cells)

    :type: float
    """

    sndparticle_potential_max_wavecrest: float
    """ Upper clamping threshold for marking fluid cells as wave crests (higher value results in less marked cells)

    :type: float
    """

    sndparticle_potential_min_energy: float
    """ Lower clamping threshold that indicates the fluid speed where cells start to emit particles (lower values result in generally more particles)

    :type: float
    """

    sndparticle_potential_min_trappedair: float
    """ Lower clamping threshold for marking fluid cells where air is trapped (lower value results in more marked cells)

    :type: float
    """

    sndparticle_potential_min_wavecrest: float
    """ Lower clamping threshold for marking fluid cells as wave crests (lower value results in more marked cells)

    :type: float
    """

    sndparticle_potential_radius: int
    """ Radius to compute potential for each cell (higher values are slower but create smoother potential grids)

    :type: int
    """

    sndparticle_sampling_trappedair: int
    """ Maximum number of particles generated per trapped air cell per frame

    :type: int
    """

    sndparticle_sampling_wavecrest: int
    """ Maximum number of particles generated per wave crest cell per frame

    :type: int
    """

    sndparticle_update_radius: int
    """ Radius to compute position update for each particle (higher values are slower but particles move less chaotic)

    :type: int
    """

    start_point: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Start point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    surface_tension: float
    """ Surface tension of liquid (higher value results in greater hydrophobic behavior)

    :type: float
    """

    sys_particle_maximum: int
    """ Maximum number of fluid particles that are allowed in this simulation

    :type: int
    """

    temperature_grid: bpy_prop_array[float]
    """ Smoke temperature grid, range 0 to 1 represents 0 to 1000K

    :type: bpy_prop_array[float]
    """

    time_scale: float
    """ Adjust simulation speed

    :type: float
    """

    timesteps_max: int
    """ Maximum number of simulation steps to perform for one frame

    :type: int
    """

    timesteps_min: int
    """ Minimum number of simulation steps to perform for one frame

    :type: int
    """

    use_adaptive_domain: bool
    """ Adapt simulation resolution and size to fluid

    :type: bool
    """

    use_adaptive_timesteps: bool
    """ 

    :type: bool
    """

    use_bubble_particles: bool
    """ Create bubble particle system

    :type: bool
    """

    use_collision_border_back: bool
    """ Enable collisions with back domain border

    :type: bool
    """

    use_collision_border_bottom: bool
    """ Enable collisions with bottom domain border

    :type: bool
    """

    use_collision_border_front: bool
    """ Enable collisions with front domain border

    :type: bool
    """

    use_collision_border_left: bool
    """ Enable collisions with left domain border

    :type: bool
    """

    use_collision_border_right: bool
    """ Enable collisions with right domain border

    :type: bool
    """

    use_collision_border_top: bool
    """ Enable collisions with top domain border

    :type: bool
    """

    use_color_ramp: bool
    """ Render a simulation field while mapping its voxels values to the colors of a ramp or using a predefined color code

    :type: bool
    """

    use_diffusion: bool
    """ Enable fluid diffusion settings (e.g. viscosity, surface tension)

    :type: bool
    """

    use_dissolve_smoke: bool
    """ Let smoke disappear over time

    :type: bool
    """

    use_dissolve_smoke_log: bool
    """ Dissolve smoke in a logarithmic fashion. Dissolves quickly at first, but lingers longer

    :type: bool
    """

    use_flip_particles: bool
    """ Create liquid particle system

    :type: bool
    """

    use_foam_particles: bool
    """ Create foam particle system

    :type: bool
    """

    use_fractions: bool
    """ Fractional obstacles improve and smoothen the fluid-obstacle boundary

    :type: bool
    """

    use_guide: bool
    """ Enable fluid guiding

    :type: bool
    """

    use_mesh: bool
    """ Enable fluid mesh (using amplification)

    :type: bool
    """

    use_noise: bool
    """ Enable fluid noise (using amplification)

    :type: bool
    """

    use_slice: bool
    """ Perform a single slice of the domain object

    :type: bool
    """

    use_speed_vectors: bool
    """ Caches velocities of mesh vertices. These will be used (automatically) when rendering with motion blur enabled

    :type: bool
    """

    use_spray_particles: bool
    """ Create spray particle system

    :type: bool
    """

    use_tracer_particles: bool
    """ Create tracer particle system

    :type: bool
    """

    use_viscosity: bool
    """ Simulate fluids with high viscosity using a special solver

    :type: bool
    """

    vector_display_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    vector_field: typing.Union[str, int]
    """ Vector field to be represented by the display vectors

    :type: typing.Union[str, int]
    """

    vector_scale: float
    """ Multiplier for scaling the vectors

    :type: float
    """

    vector_scale_with_magnitude: bool
    """ Scale vectors with their magnitudes

    :type: bool
    """

    vector_show_mac_x: bool
    """ Show X-component of MAC Grid

    :type: bool
    """

    vector_show_mac_y: bool
    """ Show Y-component of MAC Grid

    :type: bool
    """

    vector_show_mac_z: bool
    """ Show Z-component of MAC Grid

    :type: bool
    """

    velocity_grid: bpy_prop_array[float]
    """ Smoke velocity grid

    :type: bpy_prop_array[float]
    """

    velocity_scale: float
    """ Factor to control the amount of motion blur

    :type: float
    """

    viscosity_base: float
    """ Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1)

    :type: float
    """

    viscosity_exponent: int
    """ Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6)

    :type: int
    """

    viscosity_value: float
    """ Viscosity of liquid (higher values result in more viscous fluids, a value of 0 will still apply some viscosity)

    :type: float
    """

    vorticity: float
    """ Amount of turbulence and rotation in smoke

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FluidEffectorSettings(bpy_struct):
    """Smoke collision settings"""

    effector_type: typing.Union[str, int]
    """ Change type of effector in the simulation

    :type: typing.Union[str, int]
    """

    guide_mode: typing.Union[str, int]
    """ How to create guiding velocities

    :type: typing.Union[str, int]
    """

    subframes: int
    """ Number of additional samples to take between frames to improve quality of fast moving effector objects

    :type: int
    """

    surface_distance: float
    """ Additional distance around mesh surface to consider as effector

    :type: float
    """

    use_effector: bool
    """ Control when to apply the effector

    :type: bool
    """

    use_plane_init: bool
    """ Treat this object as a planar, unclosed mesh

    :type: bool
    """

    velocity_factor: float
    """ Multiplier of obstacle velocity

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FluidFlowSettings(bpy_struct):
    """Fluid flow settings"""

    density: float
    """ 

    :type: float
    """

    density_vertex_group: typing.Union[str, typing.Any]
    """ Name of vertex group which determines surface emission rate

    :type: typing.Union[str, typing.Any]
    """

    flow_behavior: typing.Union[str, int]
    """ Change flow behavior in the simulation

    :type: typing.Union[str, int]
    """

    flow_source: typing.Union[str, int]
    """ Change how fluid is emitted

    :type: typing.Union[str, int]
    """

    flow_type: typing.Union[str, int]
    """ Change type of fluid in the simulation

    :type: typing.Union[str, int]
    """

    fuel_amount: float
    """ 

    :type: float
    """

    noise_texture: Texture
    """ Texture that controls emission strength

    :type: Texture
    """

    particle_size: float
    """ Particle size in simulation cells

    :type: float
    """

    particle_system: ParticleSystem
    """ Particle systems emitted from the object

    :type: ParticleSystem
    """

    smoke_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color of smoke

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    subframes: int
    """ Number of additional samples to take between frames to improve quality of fast moving flows

    :type: int
    """

    surface_distance: float
    """ Controls fluid emission from the mesh surface (higher value results in emission further away from the mesh surface

    :type: float
    """

    temperature: float
    """ Temperature difference to ambient temperature

    :type: float
    """

    texture_map_type: typing.Union[str, int]
    """ Texture mapping type

    :type: typing.Union[str, int]
    """

    texture_offset: float
    """ Z-offset of texture mapping

    :type: float
    """

    texture_size: float
    """ Size of texture mapping

    :type: float
    """

    use_absolute: bool
    """ Only allow given density value in emitter area and will not add up

    :type: bool
    """

    use_inflow: bool
    """ Control when to apply fluid flow

    :type: bool
    """

    use_initial_velocity: bool
    """ Fluid has some initial velocity when it is emitted

    :type: bool
    """

    use_particle_size: bool
    """ Set particle size in simulation cells or use nearest cell

    :type: bool
    """

    use_plane_init: bool
    """ Treat this object as a planar and unclosed mesh. Fluid will only be emitted from the mesh surface and based on the surface emission value

    :type: bool
    """

    use_texture: bool
    """ Use a texture to control emission strength

    :type: bool
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    velocity_coord: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Additional initial velocity in X, Y and Z direction (added to source velocity)

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    velocity_factor: float
    """ Multiplier of source velocity passed to fluid (source velocity is non-zero only if object is moving)

    :type: float
    """

    velocity_normal: float
    """ Amount of normal directional velocity

    :type: float
    """

    velocity_random: float
    """ Amount of random velocity

    :type: float
    """

    volume_density: float
    """ Controls fluid emission from within the mesh (higher value results in greater emissions from inside the mesh)

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FluidModifier(bpy_struct):
    """Fluid simulation modifier"""

    domain_settings: FluidDomainSettings
    """ 

    :type: FluidDomainSettings
    """

    effector_settings: FluidEffectorSettings
    """ 

    :type: FluidEffectorSettings
    """

    flow_settings: FluidFlowSettings
    """ 

    :type: FluidFlowSettings
    """

    fluid_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FollowPathConstraint(bpy_struct):
    """Lock motion to the target path"""

    forward_axis: typing.Union[str, int]
    """ Axis that points forward along the path

    :type: typing.Union[str, int]
    """

    offset: float
    """ Offset from the position corresponding to the time frame

    :type: float
    """

    offset_factor: float
    """ Percentage value defining target position along length of curve

    :type: float
    """

    target: Object
    """ Target Curve object

    :type: Object
    """

    up_axis: typing.Union[str, int]
    """ Axis that points upward

    :type: typing.Union[str, int]
    """

    use_curve_follow: bool
    """ Object will follow the heading and banking of the curve

    :type: bool
    """

    use_curve_radius: bool
    """ Object is scaled by the curve radius

    :type: bool
    """

    use_fixed_location: bool
    """ Object will stay locked to a single point somewhere along the length of the curve regardless of time

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FollowTrackConstraint(bpy_struct):
    """Lock motion to the target motion track"""

    camera: Object
    """ Camera to which motion is parented (if empty active scene camera is used)

    :type: Object
    """

    clip: MovieClip
    """ Movie Clip to get tracking data from

    :type: MovieClip
    """

    depth_object: Object
    """ Object used to define depth in camera space by projecting onto surface of this object

    :type: Object
    """

    frame_method: typing.Union[str, int]
    """ How the footage fits in the camera frame

    :type: typing.Union[str, int]
    """

    object: typing.Union[str, typing.Any]
    """ Movie tracking object to follow (if empty, camera object is used)

    :type: typing.Union[str, typing.Any]
    """

    track: typing.Union[str, typing.Any]
    """ Movie tracking track to follow

    :type: typing.Union[str, typing.Any]
    """

    use_3d_position: bool
    """ Use 3D position of track to parent to

    :type: bool
    """

    use_active_clip: bool
    """ Use active clip defined in scene

    :type: bool
    """

    use_undistorted_position: bool
    """ Parent to undistorted position of 2D track

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FreestyleLineSet(bpy_struct):
    """Line set for associating lines and style parameters"""

    collection: Collection
    """ A collection of objects based on which feature edges are selected

    :type: Collection
    """

    collection_negation: typing.Union[str, int]
    """ Specify either inclusion or exclusion of feature edges belonging to a collection of objects

    :type: typing.Union[str, int]
    """

    edge_type_combination: typing.Union[str, int]
    """ Specify a logical combination of selection conditions on feature edge types

    :type: typing.Union[str, int]
    """

    edge_type_negation: typing.Union[str, int]
    """ Specify either inclusion or exclusion of feature edges selected by edge types

    :type: typing.Union[str, int]
    """

    exclude_border: bool
    """ Exclude border edges

    :type: bool
    """

    exclude_contour: bool
    """ Exclude contours

    :type: bool
    """

    exclude_crease: bool
    """ Exclude crease edges

    :type: bool
    """

    exclude_edge_mark: bool
    """ Exclude edge marks

    :type: bool
    """

    exclude_external_contour: bool
    """ Exclude external contours

    :type: bool
    """

    exclude_material_boundary: bool
    """ Exclude edges at material boundaries

    :type: bool
    """

    exclude_ridge_valley: bool
    """ Exclude ridges and valleys

    :type: bool
    """

    exclude_silhouette: bool
    """ Exclude silhouette edges

    :type: bool
    """

    exclude_suggestive_contour: bool
    """ Exclude suggestive contours

    :type: bool
    """

    face_mark_condition: typing.Union[str, int]
    """ Specify a feature edge selection condition based on face marks

    :type: typing.Union[str, int]
    """

    face_mark_negation: typing.Union[str, int]
    """ Specify either inclusion or exclusion of feature edges selected by face marks

    :type: typing.Union[str, int]
    """

    linestyle: FreestyleLineStyle
    """ Line style settings

    :type: FreestyleLineStyle
    """

    name: typing.Union[str, typing.Any]
    """ Line set name

    :type: typing.Union[str, typing.Any]
    """

    qi_end: int
    """ Last QI value of the QI range

    :type: int
    """

    qi_start: int
    """ First QI value of the QI range

    :type: int
    """

    select_border: bool
    """ Select border edges (open mesh edges)

    :type: bool
    """

    select_by_collection: bool
    """ Select feature edges based on a collection of objects

    :type: bool
    """

    select_by_edge_types: bool
    """ Select feature edges based on edge types

    :type: bool
    """

    select_by_face_marks: bool
    """ Select feature edges by face marks

    :type: bool
    """

    select_by_image_border: bool
    """ Select feature edges by image border (less memory consumption)

    :type: bool
    """

    select_by_visibility: bool
    """ Select feature edges based on visibility

    :type: bool
    """

    select_contour: bool
    """ Select contours (outer silhouettes of each object)

    :type: bool
    """

    select_crease: bool
    """ Select crease edges (those between two faces making an angle smaller than the Crease Angle)

    :type: bool
    """

    select_edge_mark: bool
    """ Select edge marks (edges annotated by Freestyle edge marks)

    :type: bool
    """

    select_external_contour: bool
    """ Select external contours (outer silhouettes of occluding and occluded objects)

    :type: bool
    """

    select_material_boundary: bool
    """ Select edges at material boundaries

    :type: bool
    """

    select_ridge_valley: bool
    """ Select ridges and valleys (boundary lines between convex and concave areas of surface)

    :type: bool
    """

    select_silhouette: bool
    """ Select silhouettes (edges at the boundary of visible and hidden faces)

    :type: bool
    """

    select_suggestive_contour: bool
    """ Select suggestive contours (almost silhouette/contour edges)

    :type: bool
    """

    show_render: bool
    """ Enable or disable this line set during stroke rendering

    :type: bool
    """

    visibility: typing.Union[str, int]
    """ Determine how to use visibility for feature edge selection

    :type: typing.Union[str, int]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FreestyleLineStyle(bpy_struct):
    """Freestyle line style, reusable by multiple line sets"""

    active_texture: Texture
    """ Active texture slot being displayed

    :type: Texture
    """

    active_texture_index: int
    """ Index of active texture slot

    :type: int
    """

    alpha: float
    """ Base alpha transparency, possibly modified by alpha transparency modifiers

    :type: float
    """

    alpha_modifiers: bpy_prop_collection[LineStyleAlphaModifier]
    """ List of alpha transparency modifiers

    :type: bpy_prop_collection[LineStyleAlphaModifier]
    """

    angle_max: float
    """ Maximum 2D angle for splitting chains

    :type: float
    """

    angle_min: float
    """ Minimum 2D angle for splitting chains

    :type: float
    """

    animation_data: AnimData
    """ Animation data for this data-block

    :type: AnimData
    """

    caps: typing.Union[str, int]
    """ Select the shape of both ends of strokes

    :type: typing.Union[str, int]
    """

    chain_count: int
    """ Chain count for the selection of first N chains

    :type: int
    """

    chaining: typing.Union[str, int]
    """ Select the way how feature edges are jointed to form chains

    :type: typing.Union[str, int]
    """

    color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Base line color, possibly modified by line color modifiers

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    color_modifiers: bpy_prop_collection[LineStyleColorModifier]
    """ List of line color modifiers

    :type: bpy_prop_collection[LineStyleColorModifier]
    """

    dash1: int
    """ Length of the 1st dash for dashed lines

    :type: int
    """

    dash2: int
    """ Length of the 2nd dash for dashed lines

    :type: int
    """

    dash3: int
    """ Length of the 3rd dash for dashed lines

    :type: int
    """

    gap1: int
    """ Length of the 1st gap for dashed lines

    :type: int
    """

    gap2: int
    """ Length of the 2nd gap for dashed lines

    :type: int
    """

    gap3: int
    """ Length of the 3rd gap for dashed lines

    :type: int
    """

    geometry_modifiers: bpy_prop_collection[LineStyleGeometryModifier]
    """ List of stroke geometry modifiers

    :type: bpy_prop_collection[LineStyleGeometryModifier]
    """

    integration_type: typing.Union[str, int]
    """ Select the way how the sort key is computed for each chain

    :type: typing.Union[str, int]
    """

    length_max: float
    """ Maximum curvilinear 2D length for the selection of chains

    :type: float
    """

    length_min: float
    """ Minimum curvilinear 2D length for the selection of chains

    :type: float
    """

    material_boundary: bool
    """ If true, chains of feature edges are split at material boundaries

    :type: bool
    """

    node_tree: NodeTree
    """ Node tree for node-based shaders

    :type: NodeTree
    """

    panel: typing.Union[str, int]
    """ Select the property panel to be shown

    :type: typing.Union[str, int]
    """

    rounds: int
    """ Number of rounds in a sketchy multiple touch

    :type: int
    """

    sort_key: typing.Union[str, int]
    """ Select the sort key to determine the stacking order of chains

    :type: typing.Union[str, int]
    """

    sort_order: typing.Union[str, int]
    """ Select the sort order

    :type: typing.Union[str, int]
    """

    split_dash1: int
    """ Length of the 1st dash for splitting

    :type: int
    """

    split_dash2: int
    """ Length of the 2nd dash for splitting

    :type: int
    """

    split_dash3: int
    """ Length of the 3rd dash for splitting

    :type: int
    """

    split_gap1: int
    """ Length of the 1st gap for splitting

    :type: int
    """

    split_gap2: int
    """ Length of the 2nd gap for splitting

    :type: int
    """

    split_gap3: int
    """ Length of the 3rd gap for splitting

    :type: int
    """

    split_length: float
    """ Curvilinear 2D length for chain splitting

    :type: float
    """

    texture_slots: bpy_prop_collection[LineStyleTextureSlot]
    """ Texture slots defining the mapping and influence of textures

    :type: bpy_prop_collection[LineStyleTextureSlot]
    """

    texture_spacing: float
    """ Spacing for textures along stroke length

    :type: float
    """

    thickness: float
    """ Base line thickness, possibly modified by line thickness modifiers

    :type: float
    """

    thickness_modifiers: bpy_prop_collection[LineStyleThicknessModifier]
    """ List of line thickness modifiers

    :type: bpy_prop_collection[LineStyleThicknessModifier]
    """

    thickness_position: typing.Union[str, int]
    """ Thickness position of silhouettes and border edges (applicable when plain chaining is used with the Same Object option)

    :type: typing.Union[str, int]
    """

    thickness_ratio: float
    """ A number between 0 (inside) and 1 (outside) specifying the relative position of stroke thickness

    :type: float
    """

    use_angle_max: bool
    """ Split chains at points with angles larger than the maximum 2D angle

    :type: bool
    """

    use_angle_min: bool
    """ Split chains at points with angles smaller than the minimum 2D angle

    :type: bool
    """

    use_chain_count: bool
    """ Enable the selection of first N chains

    :type: bool
    """

    use_chaining: bool
    """ Enable chaining of feature edges

    :type: bool
    """

    use_dashed_line: bool
    """ Enable or disable dashed line

    :type: bool
    """

    use_length_max: bool
    """ Enable the selection of chains by a maximum 2D length

    :type: bool
    """

    use_length_min: bool
    """ Enable the selection of chains by a minimum 2D length

    :type: bool
    """

    use_nodes: bool
    """ Use shader nodes for the line style

    :type: bool
    """

    use_same_object: bool
    """ If true, only feature edges of the same object are joined

    :type: bool
    """

    use_sorting: bool
    """ Arrange the stacking order of strokes

    :type: bool
    """

    use_split_length: bool
    """ Enable chain splitting by curvilinear 2D length

    :type: bool
    """

    use_split_pattern: bool
    """ Enable chain splitting by dashed line patterns

    :type: bool
    """

    use_texture: bool
    """ Enable or disable textured strokes

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FreestyleModuleSettings(bpy_struct):
    """Style module configuration for specifying a style module"""

    script: Text
    """ Python script to define a style module

    :type: Text
    """

    use: bool
    """ Enable or disable this style module during stroke rendering

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FreestyleModules(bpy_struct):
    """A list of style modules (to be applied from top to bottom)"""

    def new(self) -> bpy_struct:
        """Add a style module to scene render layer Freestyle settings

        :return: Newly created style module
        :rtype: FreestyleModuleSettings
        """
        ...

    def remove(self, module: FreestyleModuleSettings):
        """Remove a style module from scene render layer Freestyle settings

        :param module: Style module to remove
        :type module: FreestyleModuleSettings
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FreestyleSettings(bpy_struct):
    """Freestyle settings for a ViewLayer data-block"""

    as_render_pass: bool
    """ Renders Freestyle output to a separate pass instead of overlaying it on the Combined pass

    :type: bool
    """

    crease_angle: float
    """ Angular threshold for detecting crease edges

    :type: float
    """

    kr_derivative_epsilon: float
    """ Kr derivative epsilon for computing suggestive contours

    :type: float
    """

    linesets: bpy_prop_collection[FreestyleLineSet]
    """ 

    :type: bpy_prop_collection[FreestyleLineSet]
    """

    mode: typing.Union[str, int]
    """ Select the Freestyle control mode

    :type: typing.Union[str, int]
    """

    modules: bpy_prop_collection[FreestyleModuleSettings]
    """ A list of style modules (to be applied from top to bottom)

    :type: bpy_prop_collection[FreestyleModuleSettings]
    """

    sphere_radius: float
    """ Sphere radius for computing curvatures

    :type: float
    """

    use_culling: bool
    """ If enabled, out-of-view edges are ignored

    :type: bool
    """

    use_material_boundaries: bool
    """ Enable material boundaries

    :type: bool
    """

    use_ridges_and_valleys: bool
    """ Enable ridges and valleys

    :type: bool
    """

    use_smoothness: bool
    """ Take face smoothness into account in view map calculation

    :type: bool
    """

    use_suggestive_contours: bool
    """ Enable suggestive contours

    :type: bool
    """

    use_view_map_cache: bool
    """ Keep the computed view map and avoid recalculating it if mesh geometry is unchanged

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class Function(bpy_struct):
    """RNA function definition"""

    description: typing.Union[str, typing.Any]
    """ Description of the Function's purpose

    :type: typing.Union[str, typing.Any]
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    is_registered: typing.Union[bool, typing.Any]
    """ Function is registered as callback as part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    is_registered_optional: typing.Union[bool, typing.Any]
    """ Function is optionally registered as callback part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    parameters: bpy_prop_collection[Property]
    """ Parameters for the function

    :type: bpy_prop_collection[Property]
    """

    use_self: typing.Union[bool, typing.Any]
    """ Function does not pass itself as an argument (becomes a static method in Python)

    :type: typing.Union[bool, typing.Any]
    """

    use_self_type: typing.Union[bool, typing.Any]
    """ Function passes itself type as an argument (becomes a class method in Python if use_self is false)

    :type: typing.Union[bool, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNode(bpy_struct):
    """ """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeAlignEulerToVector(bpy_struct):
    """ """

    axis: typing.Union[str, int]
    """ Axis to align to the vector

    :type: typing.Union[str, int]
    """

    pivot_axis: typing.Union[str, int]
    """ Axis to rotate around

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeAxisAngleToRotation(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeBooleanMath(bpy_struct):
    """ """

    operation: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeCombineColor(bpy_struct):
    """ """

    mode: typing.Any
    """ Mode of color processing"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeCombineTransform(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeCompare(bpy_struct):
    """ """

    data_type: typing.Any
    """ """

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    operation: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeEulerToRotation(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeFloatToInt(bpy_struct):
    """ """

    rounding_mode: typing.Any
    """ Method used to convert the float to an integer"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInputBool(bpy_struct):
    """ """

    boolean: bool
    """ Input value used for unconnected socket

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInputColor(bpy_struct):
    """ """

    value: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    @classmethod
    def is_registered_node_type(cls) -> bpy_prop_array[float]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInputInt(bpy_struct):
    """ """

    integer: int
    """ Input value used for unconnected socket

    :type: int
    """

    @classmethod
    def is_registered_node_type(cls) -> int:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInputSpecialCharacters(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInputString(bpy_struct):
    """ """

    string: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, typing.Any]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInputVector(bpy_struct):
    """ """

    vector: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    @classmethod
    def is_registered_node_type(
        cls,
    ) -> typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInvertMatrix(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeInvertRotation(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeMatrixMultiply(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeQuaternionToRotation(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRandomValue(bpy_struct):
    """ """

    data_type: typing.Any
    """ Type of data stored in attribute"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeReplaceString(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRotateEuler(bpy_struct):
    """ """

    rotation_type: typing.Union[str, int]
    """ Method used to describe the rotation

    :type: typing.Union[str, int]
    """

    space: typing.Union[str, int]
    """ Base orientation for rotation

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRotateRotation(bpy_struct):
    """ """

    rotation_space: typing.Union[str, int]
    """ Base orientation for the rotation

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRotateVector(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRotationToAxisAngle(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRotationToEuler(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeRotationToQuaternion(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeSeparateColor(bpy_struct):
    """ """

    mode: typing.Any
    """ Mode of color processing"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeSeparateTransform(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeSliceString(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeStringLength(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeTransformDirection(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeTransformPoint(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeTransposeMatrix(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class FunctionNodeValueToString(bpy_struct):
    """ """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPENCIL_UL_annotation_layer(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPENCIL_UL_layer(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPENCIL_UL_masks(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPENCIL_UL_matslots(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPENCIL_UL_vgroups(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilEditCurve(bpy_struct):
    """Edition Curve"""

    curve_points: bpy_prop_collection[GPencilEditCurvePoint]
    """ Curve data points

    :type: bpy_prop_collection[GPencilEditCurvePoint]
    """

    select: bool
    """ Curve is selected for viewport editing

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilEditCurvePoint(bpy_struct):
    """Bézier curve point with two handles"""

    co: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Coordinates of the control point

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    handle_left: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Coordinates of the first handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    handle_right: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Coordinates of the second handle

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    point_index: int
    """ Index of the corresponding grease pencil stroke point

    :type: int
    """

    pressure: float
    """ Pressure of the grease pencil stroke point

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Handle 1 selection status

    :type: bool
    """

    select_right_handle: bool
    """ Handle 2 selection status

    :type: bool
    """

    strength: float
    """ Color intensity (alpha factor) of the grease pencil stroke point

    :type: float
    """

    uv_factor: float
    """ Internal UV factor

    :type: float
    """

    uv_rotation: float
    """ Internal UV factor for dot mode

    :type: float
    """

    vertex_color: bpy_prop_array[float]
    """ Vertex color of the grease pencil stroke point

    :type: bpy_prop_array[float]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilFrame(bpy_struct):
    """Collection of related sketches on a particular frame"""

    frame_number: int
    """ The frame on which this sketch appears

    :type: int
    """

    is_edited: bool
    """ Frame is being edited (painted on)

    :type: bool
    """

    keyframe_type: typing.Union[str, int]
    """ Type of keyframe

    :type: typing.Union[str, int]
    """

    select: bool
    """ Frame is selected for editing in the Dope Sheet

    :type: bool
    """

    strokes: bpy_prop_collection[GPencilStroke]
    """ Freehand curves defining the sketch on this frame

    :type: bpy_prop_collection[GPencilStroke]
    """

    def clear(self):
        """Remove all the grease pencil frame data"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilFrames(bpy_struct):
    """Collection of grease pencil frames"""

    def new(
        self, frame_number: int, active: typing.Union[bool, typing.Any] = False
    ) -> typing.Union[bool, typing.Any]:
        """Add a new grease pencil frame

        :param frame_number: Frame Number, The frame on which this sketch appears
        :type frame_number: int
        :param active: Active
        :type active: typing.Union[bool, typing.Any]
        :return: The newly created frame
        :rtype: GPencilFrame
        """
        ...

    def remove(self, frame: GPencilFrame):
        """Remove a grease pencil frame

        :param frame: Frame, The frame to remove
        :type frame: GPencilFrame
        """
        ...

    def copy(self, source: GPencilFrame) -> GPencilFrame:
        """Copy a grease pencil frame

        :param source: Source, The source frame
        :type source: GPencilFrame
        :return: The newly copied frame
        :rtype: GPencilFrame
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilInterpolateSettings(bpy_struct):
    """Settings for Grease Pencil interpolation tools"""

    interpolation_curve: CurveMapping
    """ Custom curve to control 'sequence' interpolation between Grease Pencil frames

    :type: CurveMapping
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilLayer(bpy_struct):
    """Collection of related sketches"""

    active_frame: GPencilFrame
    """ Frame currently being displayed for this layer

    :type: GPencilFrame
    """

    annotation_hide: bool
    """ Set annotation Visibility

    :type: bool
    """

    annotation_onion_after_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Base color for ghosts after the active frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    annotation_onion_after_range: int
    """ Maximum number of frames to show after current frame

    :type: int
    """

    annotation_onion_before_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Base color for ghosts before the active frame

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    annotation_onion_before_range: int
    """ Maximum number of frames to show before current frame

    :type: int
    """

    annotation_opacity: float
    """ Annotation Layer Opacity

    :type: float
    """

    blend_mode: typing.Union[str, int]
    """ Blend mode

    :type: typing.Union[str, int]
    """

    channel_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Custom color for animation channel in Dopesheet

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color for all strokes in this layer

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    frames: bpy_prop_collection[GPencilFrame]
    """ Sketches for this layer on different frames

    :type: bpy_prop_collection[GPencilFrame]
    """

    hide: bool
    """ Set layer Visibility

    :type: bool
    """

    info: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    is_parented: typing.Union[bool, typing.Any]
    """ True when the layer parent object is set

    :type: typing.Union[bool, typing.Any]
    """

    is_ruler: typing.Union[bool, typing.Any]
    """ This is a special ruler layer

    :type: typing.Union[bool, typing.Any]
    """

    line_change: int
    """ Thickness change to apply to current strokes (in pixels)

    :type: int
    """

    location: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Values for change location

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    lock: bool
    """ Protect layer from further editing and/or frame changes

    :type: bool
    """

    lock_frame: bool
    """ Lock current frame displayed by layer

    :type: bool
    """

    lock_material: bool
    """ Avoids editing locked materials in the layer

    :type: bool
    """

    mask_layers: bpy_prop_collection[GPencilLayerMask]
    """ List of Masking Layers

    :type: bpy_prop_collection[GPencilLayerMask]
    """

    matrix_inverse: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Parent inverse transformation matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    matrix_inverse_layer: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Local Layer transformation inverse matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    matrix_layer: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
        mathutils.Matrix,
    ]
    """ Local Layer transformation matrix

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]], mathutils.Matrix]
    """

    opacity: float
    """ Layer Opacity

    :type: float
    """

    parent: Object
    """ Parent object

    :type: Object
    """

    parent_bone: typing.Union[str, typing.Any]
    """ Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    """

    parent_type: typing.Union[str, int]
    """ Type of parent relation

    :type: typing.Union[str, int]
    """

    pass_index: int
    """ Index number for the "Layer Index" pass

    :type: int
    """

    rotation: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Euler
    ]
    """ Values for changes in rotation

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Euler]
    """

    scale: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ Values for changes in scale

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    select: bool
    """ Layer is selected for editing in the Dope Sheet

    :type: bool
    """

    show_in_front: bool
    """ Make the layer display in front of objects

    :type: bool
    """

    show_points: bool
    """ Show the points which make up the strokes (for debugging purposes)

    :type: bool
    """

    thickness: int
    """ Thickness of annotation strokes

    :type: int
    """

    tint_color: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Color
    ]
    """ Color for tinting stroke colors

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Color]
    """

    tint_factor: float
    """ Factor of tinting color

    :type: float
    """

    use_annotation_onion_skinning: bool
    """ Display annotation onion skins before and after the current frame

    :type: bool
    """

    use_lights: bool
    """ Enable the use of lights on stroke and fill materials

    :type: bool
    """

    use_mask_layer: bool
    """ The visibility of drawings on this layer is affected by the layers in its masks list

    :type: bool
    """

    use_onion_skinning: bool
    """ Display onion skins before and after the current frame

    :type: bool
    """

    use_solo_mode: bool
    """ In Draw Mode only display layers with keyframe in current frame

    :type: bool
    """

    use_viewlayer_masks: bool
    """ Include the mask layers when rendering the view-layer

    :type: bool
    """

    vertex_paint_opacity: float
    """ Vertex Paint mix factor

    :type: float
    """

    viewlayer_render: typing.Union[str, typing.Any]
    """ Only include Layer in this View Layer render output (leave blank to include always)

    :type: typing.Union[str, typing.Any]
    """

    def clear(self):
        """Remove all the grease pencil layer data"""
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilLayerMask(bpy_struct):
    """List of Mask Layers"""

    hide: bool
    """ Set mask Visibility

    :type: bool
    """

    invert: bool
    """ Invert mask

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Mask layer name

    :type: typing.Union[str, typing.Any]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilSculptGuide(bpy_struct):
    """Guides for drawing"""

    angle: float
    """ Direction of lines

    :type: float
    """

    angle_snap: float
    """ Angle snapping

    :type: float
    """

    location: bpy_prop_array[float]
    """ Custom reference point for guides

    :type: bpy_prop_array[float]
    """

    reference_object: Object
    """ Object used for reference point

    :type: Object
    """

    reference_point: typing.Union[str, int]
    """ Type of speed guide

    :type: typing.Union[str, int]
    """

    spacing: float
    """ Guide spacing

    :type: float
    """

    type: typing.Union[str, int]
    """ Type of speed guide

    :type: typing.Union[str, int]
    """

    use_guide: bool
    """ Enable speed guides

    :type: bool
    """

    use_snapping: bool
    """ Enable snapping to guides angle or spacing options

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilSculptSettings(bpy_struct):
    """General properties for Grease Pencil stroke sculpting tools"""

    guide: GPencilSculptGuide
    """ 

    :type: GPencilSculptGuide
    """

    intersection_threshold: float
    """ Threshold for stroke intersections

    :type: float
    """

    lock_axis: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    multiframe_falloff_curve: CurveMapping
    """ Custom curve to control falloff of brush effect by Grease Pencil frames

    :type: CurveMapping
    """

    thickness_primitive_curve: CurveMapping
    """ Custom curve to control primitive thickness

    :type: CurveMapping
    """

    use_automasking_layer_active: bool
    """ Affect only the Active Layer

    :type: bool
    """

    use_automasking_layer_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_automasking_material_active: bool
    """ Affect only the Active Material

    :type: bool
    """

    use_automasking_material_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_automasking_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_multiframe_falloff: bool
    """ Use falloff effect when edit in multiframe mode to compute brush effect by frame

    :type: bool
    """

    use_scale_thickness: bool
    """ Scale the stroke thickness when transforming strokes

    :type: bool
    """

    use_thickness_curve: bool
    """ Use curve to define primitive stroke thickness

    :type: bool
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilStroke(bpy_struct):
    """Freehand curve defining part of a sketch"""

    aspect: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    bound_box_max: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    bound_box_min: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    display_mode: typing.Union[str, int]
    """ Coordinate space that stroke is in

    :type: typing.Union[str, int]
    """

    edit_curve: GPencilEditCurve
    """ Temporary data for Edit Curve

    :type: GPencilEditCurve
    """

    end_cap_mode: typing.Union[str, int]
    """ Stroke end extreme cap style

    :type: typing.Union[str, int]
    """

    hardness: float
    """ Amount of gradient along section of stroke

    :type: float
    """

    has_edit_curve: typing.Union[bool, typing.Any]
    """ Stroke has Curve data to edit shape

    :type: typing.Union[bool, typing.Any]
    """

    is_nofill_stroke: bool
    """ Special stroke to use as boundary for filling areas

    :type: bool
    """

    line_width: int
    """ Thickness of stroke (in pixels)

    :type: int
    """

    material_index: int
    """ Material slot index of this stroke

    :type: int
    """

    points: bpy_prop_collection[GPencilStrokePoint]
    """ Stroke data points

    :type: bpy_prop_collection[GPencilStrokePoint]
    """

    select: bool
    """ Stroke is selected for viewport editing

    :type: bool
    """

    select_index: int
    """ Index of selection used for interpolation

    :type: int
    """

    start_cap_mode: typing.Union[str, int]
    """ Stroke start extreme cap style

    :type: typing.Union[str, int]
    """

    time_start: float
    """ Initial time of the stroke

    :type: float
    """

    triangles: bpy_prop_collection[GPencilTriangle]
    """ Triangulation data for HQ fill

    :type: bpy_prop_collection[GPencilTriangle]
    """

    use_cyclic: bool
    """ Enable cyclic drawing, closing the stroke

    :type: bool
    """

    uv_rotation: float
    """ Rotation of the UV

    :type: float
    """

    uv_scale: float
    """ Scale of the UV

    :type: float
    """

    uv_translation: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Translation of default UV position

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    vertex_color_fill: bpy_prop_array[float]
    """ Color used to mix with fill color to get final color

    :type: bpy_prop_array[float]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilStrokePoint(bpy_struct):
    """Data point for freehand stroke curve"""

    co: typing.Union[
        typing.List[float], typing.Tuple[float, float, float], mathutils.Vector
    ]
    """ 

    :type: typing.Union[typing.List[float], typing.Tuple[float, float, float], mathutils.Vector]
    """

    pressure: float
    """ Pressure of tablet at point when drawing it

    :type: float
    """

    select: bool
    """ Point is selected for viewport editing

    :type: bool
    """

    strength: float
    """ Color intensity (alpha factor)

    :type: float
    """

    time: float
    """ Time relative to stroke start

    :type: float
    """

    uv_factor: float
    """ Internal UV factor

    :type: float
    """

    uv_fill: typing.Union[
        typing.List[float], typing.Tuple[float, float], mathutils.Vector
    ]
    """ Internal UV factor for filling

    :type: typing.Union[typing.List[float], typing.Tuple[float, float], mathutils.Vector]
    """

    uv_rotation: float
    """ Internal UV factor for dot mode

    :type: float
    """

    vertex_color: bpy_prop_array[float]
    """ Color used to mix with point color to get final color

    :type: bpy_prop_array[float]
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilStrokePoints(bpy_struct):
    """Collection of grease pencil stroke points"""

    def add(self, count: int, pressure: typing.Any = 1.0, strength: typing.Any = 1.0):
        """Add a new grease pencil stroke point

        :param count: Number, Number of points to add to the stroke
        :type count: int
        :param pressure: Pressure, Pressure for newly created points
        :type pressure: typing.Any
        :param strength: Strength, Color intensity (alpha factor) for newly created points
        :type strength: typing.Any
        """
        ...

    def pop(self, index: typing.Any = -1):
        """Remove a grease pencil stroke point

        :param index: Index, point index
        :type index: typing.Any
        """
        ...

    def update(self):
        """Recalculate internal triangulation data"""
        ...

    def weight_get(
        self, vertex_group_index: typing.Any = 0, point_index: typing.Any = 0
    ) -> typing.Any:
        """Get vertex group point weight

        :param vertex_group_index: Vertex Group Index, Index of Vertex Group in the array of groups
        :type vertex_group_index: typing.Any
        :param point_index: Point Index, Index of the Point in the array
        :type point_index: typing.Any
        :return: Weight, Point Weight
        :rtype: float
        """
        ...

    def weight_set(
        self,
        vertex_group_index: typing.Any = 0,
        point_index: typing.Any = 0,
        weight: typing.Any = 0.0,
    ):
        """Set vertex group point weight

        :param vertex_group_index: Vertex Group Index, Index of Vertex Group in the array of groups
        :type vertex_group_index: typing.Any
        :param point_index: Point Index, Index of the Point in the array
        :type point_index: typing.Any
        :param weight: Weight, Point Weight
        :type weight: typing.Any
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilStrokes(bpy_struct):
    """Collection of grease pencil stroke"""

    def new(self) -> bpy_struct:
        """Add a new grease pencil stroke

        :return: The newly created stroke
        :rtype: GPencilStroke
        """
        ...

    def remove(self, stroke: GPencilStroke):
        """Remove a grease pencil stroke

        :param stroke: Stroke, The stroke to remove
        :type stroke: GPencilStroke
        """
        ...

    def close(self, stroke: GPencilStroke):
        """Close a grease pencil stroke adding geometry

        :param stroke: Stroke, The stroke to close
        :type stroke: GPencilStroke
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GPencilTriangle(bpy_struct):
    """Triangulation data for Grease Pencil fills"""

    v1: int
    """ First triangle vertex index

    :type: int
    """

    v2: int
    """ Second triangle vertex index

    :type: int
    """

    v3: int
    """ Third triangle vertex index

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GREASE_PENCIL_UL_masks(bpy_struct):
    """ """

    def draw_item(
        self,
        _context,
        layout,
        _data,
        item,
        icon,
        _active_data,
        _active_propname,
        _index,
    ):
        """

        :param _context:
        :param layout:
        :param _data:
        :param item:
        :param icon:
        :param _active_data:
        :param _active_propname:
        :param _index:
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GammaCrossSequence(bpy_struct):
    """Gamma Cross Sequence"""

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_2: Sequence
    """ Second input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GaussianBlurSequence(bpy_struct):
    """Sequence strip creating a gaussian blur"""

    input_1: Sequence
    """ First input for the effect strip

    :type: Sequence
    """

    input_count: int
    """ 

    :type: int
    """

    size_x: float
    """ Size of the blur along X axis

    :type: float
    """

    size_y: float
    """ Size of the blur along Y axis

    :type: float
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNode(bpy_struct):
    """ """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeAccumulateField(bpy_struct):
    """Add the values of an evaluated field together and output the running total for each element"""

    data_type: typing.Any
    """ Type of data stored in attribute"""

    domain: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeAttributeDomainSize(bpy_struct):
    """Retrieve the number of elements in a geometry for each attribute domain"""

    component: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeAttributeStatistic(bpy_struct):
    """Calculate statistics about a data set from a field evaluated on a geometry"""

    data_type: typing.Any
    """ The data type the attribute is converted to before calculating the results"""

    domain: typing.Any
    """ Which domain to read the data from"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeBake(bpy_struct):
    """Cache the incoming data so that it can be used without recomputation"""

    active_index: int
    """ Index of the active item

    :type: int
    """

    active_item: RepeatItem
    """ Index of the active item

    :type: RepeatItem
    """

    bake_items: bpy_prop_collection[NodeGeometryBakeItem]
    """ 

    :type: bpy_prop_collection[NodeGeometryBakeItem]
    """

    @classmethod
    def is_registered_node_type(cls) -> bpy_prop_collection[NodeGeometryBakeItem]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeBlurAttribute(bpy_struct):
    """Mix attribute values of neighboring elements"""

    data_type: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeBoundBox(bpy_struct):
    """Calculate the limits of a geometry's positions and generate a box mesh with those dimensions"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCaptureAttribute(bpy_struct):
    """Store the result of a field on a geometry and output the data as a node socket. Allows remembering or interpolating data as the geometry changes, such as positions before deformation"""

    data_type: typing.Any
    """ Type of data stored in attribute"""

    domain: typing.Any
    """ Which domain to store the data in"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCollectionInfo(bpy_struct):
    """Retrieve geometry instances from a collection"""

    transform_space: typing.Union[str, int]
    """ The transformation of the instances output. Does not affect the internal geometry

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeConvexHull(bpy_struct):
    """Create a mesh that encloses all points in the input geometry with the smallest number of points"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCornersOfEdge(bpy_struct):
    """Retrieve face corners connected to edges"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCornersOfFace(bpy_struct):
    """Retrieve corners that make up a face"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCornersOfVertex(bpy_struct):
    """Retrieve face corners connected to vertices"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveArc(bpy_struct):
    """Generate a poly spline arc"""

    mode: typing.Union[str, int]
    """ Method used to determine radius and placement

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveEndpointSelection(bpy_struct):
    """Provide a selection for an arbitrary number of endpoints in each spline"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveHandleTypeSelection(bpy_struct):
    """Provide a selection based on the handle types of Bézier control points"""

    handle_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    mode: typing.Any
    """ Whether to check the type of left and right handles"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveLength(bpy_struct):
    """Retrieve the length of all splines added together"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveOfPoint(bpy_struct):
    """Retrieve the curve a control point is part of"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurvePrimitiveBezierSegment(bpy_struct):
    """Generate a 2D Bézier spline from the given control points and handles"""

    mode: typing.Union[str, int]
    """ Method used to determine control handles

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurvePrimitiveCircle(bpy_struct):
    """Generate a poly spline circle"""

    mode: typing.Union[str, int]
    """ Method used to determine radius and placement

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurvePrimitiveLine(bpy_struct):
    """Generate a poly spline line with two points"""

    mode: typing.Union[str, int]
    """ Method used to determine radius and placement

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurvePrimitiveQuadrilateral(bpy_struct):
    """Generate a polygon with four points"""

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveQuadraticBezier(bpy_struct):
    """Generate a poly spline in a parabola shape with control points positions"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveSetHandles(bpy_struct):
    """Set the handle type for the control points of a Bézier curve"""

    handle_type: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    mode: typing.Any
    """ Whether to update left and right handles"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveSpiral(bpy_struct):
    """Generate a poly spline in a spiral shape"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveSplineType(bpy_struct):
    """Change the type of curves"""

    spline_type: typing.Any
    """ The curve type to change the selected curves to"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveStar(bpy_struct):
    """Generate a poly spline in a star pattern by connecting alternating points of two circles"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveToMesh(bpy_struct):
    """Convert curves into a mesh, optionally with a custom profile shape defined by curves"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCurveToPoints(bpy_struct):
    """Generate a point cloud by sampling positions along curves"""

    mode: typing.Union[str, int]
    """ How to generate points from the input curve

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeCustomGroup(bpy_struct):
    """Custom Geometry Group Node for Python nodes"""

    node_tree: NodeTree
    """ 

    :type: NodeTree
    """

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDeformCurvesOnSurface(bpy_struct):
    """Translate and rotate curves based on changes between the object's original and evaluated surface mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDeleteGeometry(bpy_struct):
    """Remove selected elements of a geometry"""

    domain: typing.Any
    """ Which domain to delete in"""

    mode: typing.Union[str, int]
    """ Which parts of the mesh component to delete

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDistributePointsInGrid(bpy_struct):
    """Generate points inside a volume grid"""

    mode: typing.Union[str, int]
    """ Method to use for scattering points

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDistributePointsInVolume(bpy_struct):
    """Generate points inside a volume"""

    mode: typing.Union[str, int]
    """ Method to use for scattering points

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDistributePointsOnFaces(bpy_struct):
    """Generate points spread out on the surface of a mesh"""

    distribute_method: typing.Union[str, int]
    """ Method to use for scattering points

    :type: typing.Union[str, int]
    """

    use_legacy_normal: bool
    """ Output the normal and rotation values that have been output before the node started taking smooth normals into account

    :type: bool
    """

    @classmethod
    def is_registered_node_type(cls) -> bool:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDualMesh(bpy_struct):
    """Convert Faces into vertices and vertices into faces"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeDuplicateElements(bpy_struct):
    """Generate an arbitrary number copies of each selected input element"""

    domain: typing.Union[str, int]
    """ Which domain to duplicate

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeEdgePathsToCurves(bpy_struct):
    """Output curves following paths across mesh edges"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeEdgePathsToSelection(bpy_struct):
    """Output a selection of edges by following paths across mesh edges"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeEdgesOfCorner(bpy_struct):
    """Retrieve the edges on both sides of a face corner"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeEdgesOfVertex(bpy_struct):
    """Retrieve the edges connected to each vertex"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeEdgesToFaceGroups(bpy_struct):
    """Group faces into regions surrounded by the selected boundary edges"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeExtrudeMesh(bpy_struct):
    """Generate new vertices, edges, or faces from selected elements and move them based on an offset while keeping them connected by their boundary"""

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeFaceOfCorner(bpy_struct):
    """Retrieve the face each face corner is part of"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeFieldAtIndex(bpy_struct):
    """Retrieve data of other elements in the context's geometry"""

    data_type: typing.Any
    """ """

    domain: typing.Any
    """ Domain the field is evaluated in"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeFieldOnDomain(bpy_struct):
    """Retrieve values from a field on a different domain besides the domain from the context"""

    data_type: typing.Any
    """ """

    domain: typing.Any
    """ Domain the field is evaluated in"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeFillCurve(bpy_struct):
    """Generate a mesh on the XY plane with faces on the inside of input curves"""

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeFilletCurve(bpy_struct):
    """Round corners by generating circular arcs on each control point"""

    mode: typing.Union[str, int]
    """ How to choose number of vertices on fillet

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeFlipFaces(bpy_struct):
    """Reverse the order of the vertices and edges of selected faces, flipping their normal direction"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeGeometryToInstance(bpy_struct):
    """Convert each input geometry into an instance, which can be much faster than the Join Geometry node when the inputs are large"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeGetNamedGrid(bpy_struct):
    """Get volume grid from a volume geometry with the specified name"""

    data_type: typing.Any
    """ Type of grid data"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeGridToMesh(bpy_struct):
    """Generate a mesh on the "surface" of a volume grid"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeGroup(bpy_struct):
    """ """

    node_tree: NodeTree
    """ 

    :type: NodeTree
    """

    @classmethod
    def is_registered_node_type(cls) -> NodeTree:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeImageInfo(bpy_struct):
    """Retrieve information about an image"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeImageTexture(bpy_struct):
    """Sample values from an image texture"""

    extension: typing.Union[str, int]
    """ How the image is extrapolated past its original bounds

    :type: typing.Union[str, int]
    """

    interpolation: typing.Union[str, int]
    """ Method for smoothing values between pixels

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeIndexOfNearest(bpy_struct):
    """Find the nearest element in a group. Similar to the "Sample Nearest" node"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeIndexSwitch(bpy_struct):
    """Choose between an arbitrary number of values with an index"""

    data_type: typing.Any
    """ """

    index_switch_items: bpy_prop_collection[IndexSwitchItem]
    """ 

    :type: bpy_prop_collection[IndexSwitchItem]
    """

    @classmethod
    def is_registered_node_type(cls) -> bpy_prop_collection[IndexSwitchItem]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputActiveCamera(bpy_struct):
    """Retrieve the scene's active camera"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputCurveHandlePositions(bpy_struct):
    """Retrieve the position of each Bézier control point's handles"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputCurveTilt(bpy_struct):
    """Retrieve the angle at each control point used to twist the curve's normal around its tangent"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputEdgeSmooth(bpy_struct):
    """Retrieve whether each edge is marked for smooth or split normals"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputID(bpy_struct):
    """Retrieve a stable random identifier value from the "id" attribute on the point domain, or the index if the attribute does not exist"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputImage(bpy_struct):
    """Input image"""

    image: Image
    """ 

    :type: Image
    """

    @classmethod
    def is_registered_node_type(cls) -> Image:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputIndex(bpy_struct):
    """Retrieve an integer value indicating the position of each element in the list, starting at zero"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputInstanceRotation(bpy_struct):
    """Retrieve the rotation of each instance in the geometry"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputInstanceScale(bpy_struct):
    """Retrieve the scale of each instance in the geometry"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMaterial(bpy_struct):
    """Output a single material"""

    material: Material
    """ 

    :type: Material
    """

    @classmethod
    def is_registered_node_type(cls) -> Material:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMaterialIndex(bpy_struct):
    """Retrieve the index of the material used for each element in the geometry's list of materials"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshEdgeAngle(bpy_struct):
    """Calculate the surface area of each face in a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshEdgeNeighbors(bpy_struct):
    """Retrieve the number of faces that use each edge as one of their sides"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshEdgeVertices(bpy_struct):
    """Retrieve topology information relating to each edge of a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshFaceArea(bpy_struct):
    """Calculate the surface area of a mesh's faces"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshFaceIsPlanar(bpy_struct):
    """Retrieve whether all triangles in a face are on the same plane, i.e. whether they have the same normal"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshFaceNeighbors(bpy_struct):
    """Retrieve topology information relating to each face of a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshIsland(bpy_struct):
    """Retrieve information about separate connected regions in a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputMeshVertexNeighbors(bpy_struct):
    """Retrieve topology information relating to each vertex of a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputNamedAttribute(bpy_struct):
    """Retrieve the data of a specified attribute"""

    data_type: typing.Any
    """ The data type used to read the attribute values"""

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputNamedLayerSelection(bpy_struct):
    """Output a selection of a grease pencil layer"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputNormal(bpy_struct):
    """Retrieve a unit length vector indicating the direction pointing away from the geometry at each element"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputPosition(bpy_struct):
    """Retrieve a vector indicating the location of each element"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputRadius(bpy_struct):
    """Retrieve the radius at each point on curve or point cloud geometry"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputSceneTime(bpy_struct):
    """Retrieve the current time in the scene's animation in units of seconds or frames"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputShadeSmooth(bpy_struct):
    """Retrieve whether each face is marked for smooth or sharp normals"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputShortestEdgePaths(bpy_struct):
    """Find the shortest paths along mesh edges to selected end vertices, with customizable cost per edge"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputSplineCyclic(bpy_struct):
    """Retrieve whether each spline endpoint connects to the beginning"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputSplineResolution(bpy_struct):
    """Retrieve the number of evaluated points that will be generated for every control point on curves"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInputTangent(bpy_struct):
    """Retrieve the direction of curves at each control point"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInstanceOnPoints(bpy_struct):
    """Generate a reference to geometry at each of the input points, without duplicating its underlying data"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInstancesToPoints(bpy_struct):
    """Generate points at the origins of instances.
    Note: Nested instances are not affected by this node
    """

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeInterpolateCurves(bpy_struct):
    """Generate new curves on points by interpolating between existing curves"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeIsViewport(bpy_struct):
    """Retrieve whether the nodes are being evaluated for the viewport rather than the final render"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeJoinGeometry(bpy_struct):
    """Merge separately generated geometries into a single one"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMaterialSelection(bpy_struct):
    """Provide a selection of faces that use the specified material"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMenuSwitch(bpy_struct):
    """Select from multiple inputs by name"""

    data_type: typing.Any
    """ """

    enum_definition: NodeEnumDefinition
    """ Definition of enum items

    :type: NodeEnumDefinition
    """

    @classmethod
    def is_registered_node_type(cls) -> NodeEnumDefinition:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMergeByDistance(bpy_struct):
    """Merge vertices or points within a given distance"""

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshBoolean(bpy_struct):
    """Cut, subtract, or join multiple mesh inputs"""

    operation: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    solver: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshCircle(bpy_struct):
    """Generate a circular ring of edges"""

    fill_type: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshCone(bpy_struct):
    """Generate a cone mesh"""

    fill_type: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshCube(bpy_struct):
    """Generate a cuboid mesh with variable side lengths and subdivisions"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshCylinder(bpy_struct):
    """Generate a cylinder mesh"""

    fill_type: typing.Any
    """ """

    @classmethod
    def is_registered_node_type(cls):
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshFaceSetBoundaries(bpy_struct):
    """Find edges on the boundaries between groups of faces with the same ID value"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshGrid(bpy_struct):
    """Generate a planar mesh on the XY plane"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshIcoSphere(bpy_struct):
    """Generate a spherical mesh that consists of equally sized triangles"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshLine(bpy_struct):
    """Generate vertices in a line and connect them with edges"""

    count_mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshToCurve(bpy_struct):
    """Generate a curve from a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshToDensityGrid(bpy_struct):
    """Create a filled volume grid from a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshToPoints(bpy_struct):
    """Generate a point cloud from a mesh's vertices"""

    mode: typing.Union[str, int]
    """ 

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshToSDFGrid(bpy_struct):
    """Create a signed distance volume grid from a mesh"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshToVolume(bpy_struct):
    """Create a fog volume with the shape of the input mesh's surface"""

    resolution_mode: typing.Union[str, int]
    """ How the voxel size is specified

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeMeshUVSphere(bpy_struct):
    """Generate a spherical mesh with quads, except for triangles at the top and bottom"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeObjectInfo(bpy_struct):
    """Retrieve information from an object"""

    transform_space: typing.Union[str, int]
    """ The transformation of the vector and geometry outputs

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeOffsetCornerInFace(bpy_struct):
    """Retrieve corners in the same face as another"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeOffsetPointInCurve(bpy_struct):
    """Offset a control point index within its curve"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodePoints(bpy_struct):
    """Generate a point cloud with positions and radii defined by fields"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodePointsOfCurve(bpy_struct):
    """Retrieve a point index within a curve"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodePointsToCurves(bpy_struct):
    """Split all points to curve by its group ID and reorder by weight"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodePointsToSDFGrid(bpy_struct):
    """Create a signed distance volume grid from points"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodePointsToVertices(bpy_struct):
    """Generate a mesh vertex for each point cloud point"""

    @classmethod
    def is_registered_node_type(cls) -> bpy_struct:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodePointsToVolume(bpy_struct):
    """Generate a fog volume sphere around every point"""

    resolution_mode: typing.Union[str, int]
    """ How the voxel size is specified

    :type: typing.Union[str, int]
    """

    @classmethod
    def is_registered_node_type(cls) -> typing.Union[str, int]:
        """True if a registered node type

        :return: Result
        :rtype: bool
        """
        ...

    @classmethod
    def input_template(cls, index: int) -> int:
        """Input socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def output_template(cls, index: int) -> int:
        """Output socket template

        :param index: Index
        :type index: int
        :return: result
        :rtype: NodeInternalSocketTemplate
        """
        ...

    @classmethod
    def bl_rna_get_subclass(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The RNA type or default when not found.
        :rtype: Struct
        """
        ...

    @classmethod
    def bl_rna_get_subclass_py(cls, id: str, default=None):
        """

        :param id: The RNA type identifier.
        :type id: str
        :param default:
        :return: The class or default when not found.
        :rtype: typing.Any
        """
        ...

class GeometryNodeProximity(bpy_struct):
    """Co