import typing

GenericType = typing.TypeVar("GenericType")

def to_string(
    unit_system: str,
    unit_category: str,
    value: float,
    precision: int = 3,
    split_unit: bool = False,
    compatible_unit: bool = False,
) -> str:
    """Convert a given input float value into a string with units.

        :param unit_system: The unit system, from `bpy.utils.units.systems`.
        :type unit_system: str
        :param unit_category: The category of data we are converting (length, area, rotation, etc.),
    from `bpy.utils.units.categories`.
        :type unit_category: str
        :param value: The value to convert to a string.
        :type value: float
        :param precision: Number of digits after the comma.
        :type precision: int
        :param split_unit: Whether to use several units if needed (1m1cm), or always only one (1.01m).
        :type split_unit: bool
        :param compatible_unit: Whether to use keyboard-friendly units (1m2) or nicer utf-8 ones (1m²).
        :type compatible_unit: bool
        :return: The converted string.
        :rtype: str
    """

    ...

def to_value(
    unit_system: str, unit_category: str, str_input: str, str_ref_unit: str = None
) -> float:
    """Convert a given input string into a float value.

        :param unit_system: The unit system, from `bpy.utils.units.systems`.
        :type unit_system: str
        :param unit_category: The category of data we are converting (length, area, rotation, etc.),
    from `bpy.utils.units.categories`.
        :type unit_category: str
        :param str_input: The string to convert to a float value.
        :type str_input: str
        :param str_ref_unit: A reference string from which to extract a default unit, if none is found in str_input.
        :type str_ref_unit: str
        :return: The converted/interpreted value.
        :rtype: float
    """

    ...

categories: typing.Any
""" Constant value bpy.utils.units.categories(NONE='NONE', LENGTH='LENGTH', AREA='AREA', VOLUME='VOLUME', MASS='MASS', ROTATION='ROTATION', TIME='TIME', TIME_ABSOLUTE='TIME_ABSOLUTE', VELOCITY='VELOCITY', ACCELERATION='ACCELERATION', CAMERA='CAMERA', POWER='POWER', TEMPERATURE='TEMPERATURE')
"""

systems: typing.Any
""" Constant value bpy.utils.units.systems(NONE='NONE', METRIC='METRIC', IMPERIAL='IMPERIAL')
"""
