import abc
from _typeshed import Incomplete
from aioworkers.utils import cached_property as cached_property
from typing import Iterator, List, Mapping, Optional, Tuple, TypeVar
from urllib.parse import SplitResult as SplitResult

TURI = TypeVar('TURI', bound='BaseURI')

class QueryDict(Mapping[str, str]):
    true: Incomplete
    false: Incomplete
    def __init__(self, qsl: List[Tuple[str, str]]) -> None: ...
    def __getitem__(self, k: str) -> str: ...
    def get_bool(self, k: str) -> Optional[bool]: ...
    def get_int(self, k: str) -> Optional[int]: ...
    def get_float(self, k: str) -> Optional[float]: ...
    def get_list(self, k: str) -> List[str]: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[str]: ...

class BaseURI(str):
    @classmethod
    def from_bytes(cls, uri: bytes) -> TURI: ...
    @classmethod
    def from_split(cls, sr: SplitResult) -> TURI: ...
    def scheme(self) -> Optional[str]: ...
    def hostname(self) -> Optional[str]: ...
    def port(self) -> Optional[int]: ...
    def username(self) -> Optional[str]: ...
    def password(self) -> Optional[str]: ...
    def path(self) -> Optional[str]: ...
    def query_string(self) -> Optional[str]: ...
    def query(self) -> QueryDict: ...
    def with_scheme(self, scheme: str) -> TURI: ...
    def with_auth(self, username: Optional[str], password: Optional[str] = ...) -> TURI: ...
    def with_username(self, username: str) -> TURI: ...
    def with_password(self, password: str) -> TURI: ...
    def with_host(self, host: str) -> TURI: ...
    def with_port(self, port: int) -> TURI: ...
    def with_path(self, path: str, drop_query: bool = ..., drop_fragment: bool = ...) -> TURI: ...
    def with_query(self, *args, **kwargs) -> TURI: ...
    def update_query(self, **kwargs) -> TURI: ...

class URI(BaseURI): ...

class URL(BaseURI, abc.ABC):
    def __truediv__(self, other): ...
