export interface LambdaRuntimeProps {
    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     * @default false
     */
    readonly supportsInlineCode?: boolean;
}
export declare enum RuntimeFamily {
    NODEJS = 0,
    JAVA = 1,
    PYTHON = 2,
    DOTNET_CORE = 3,
    GO = 4,
    RUBY = 5,
    OTHER = 6
}
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
export declare class Runtime {
    /** A list of all known `Runtime`'s. */
    static readonly ALL: Runtime[];
    /** @deprecated Use `Nodejs810` or `Nodejs10x` */
    static readonly NODEJS: Runtime;
    /** @deprecated Use `Nodejs810` or `Nodejs10x` */
    static readonly NODEJS_4_3: Runtime;
    /** @deprecated Use `Nodejs810` or `Nodejs10x` */
    static readonly NODEJS_6_10: Runtime;
    static readonly NODEJS_8_10: Runtime;
    static readonly NODEJS_10_X: Runtime;
    static readonly PYTHON_2_7: Runtime;
    static readonly PYTHON_3_6: Runtime;
    static readonly PYTHON_3_7: Runtime;
    static readonly JAVA_8: Runtime;
    static readonly DOTNET_CORE_1: Runtime;
    /** @deprecated Use `DotNetCore21` */
    static readonly DOTNET_CORE_2: Runtime;
    static readonly DOTNET_CORE_2_1: Runtime;
    static readonly GO_1_X: Runtime;
    static readonly RUBY_2_5: Runtime;
    static readonly PROVIDED: Runtime;
    /**
     * The name of this runtime, as expected by the Lambda resource.
     */
    readonly name: string;
    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this
     * runtime.
     */
    readonly supportsInlineCode: boolean;
    /**
     * The runtime family.
     */
    readonly family?: RuntimeFamily;
    constructor(name: string, family?: RuntimeFamily, props?: LambdaRuntimeProps);
    toString(): string;
    runtimeEquals(other: Runtime): boolean;
}
