"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        Runtime.ALL.push(this);
    }
    toString() {
        return this.name;
    }
    runtimeEquals(other) {
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
/** A list of all known `Runtime`'s. */
Runtime.ALL = new Array();
/** @deprecated Use `Nodejs810` or `Nodejs10x` */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/** @deprecated Use `Nodejs810` or `Nodejs10x` */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/** @deprecated Use `Nodejs810` or `Nodejs10x` */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: false });
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, { supportsInlineCode: true });
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA);
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/** @deprecated Use `DotNetCore21` */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY, { supportsInlineCode: true });
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
exports.Runtime = Runtime;
//# sourceMappingURL=data:application/json;base64,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