# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pelican', 'pelican.plugins.precompress']

package_data = \
{'': ['*']}

install_requires = \
['pelican-granular-signals>=1.0.0,<2.0.0']

setup_kwargs = {
    'name': 'pelican-precompress',
    'version': '2.1.0',
    'description': 'Pre-compress your Pelican site using gzip, zopfli, and brotli!',
    'long_description': "..  This file is part of the pelican_precompress plugin.\n..  Copyright 2019-2021 Kurt McKee <contactme@kurtmckee.org>\n..  Released under the MIT license.\n\npelican_precompress\n*******************\n\n*Pre-compress your Pelican site using gzip, zopfli, and brotli!*\n\n----\n\nAre you using `Pelican`_, the static site generator? If so, great!\nAre you pre-compressing your static files to have the fastest site possible?\nIf not, install **pelican_precompress** today!\nIt's the plugin that makes your visitors happy and saves you money!\n\n\nInstallation\n============\n\nThere are three steps required to start using static compression:\n\n#.  Install the plugin and any supporting Python packages you want.\n#.  Configure Pelican to use the pelican_precompress plugin.\n#.  Configure your web server to use static, pre-compressed files.\n\n\n1. Install the Python modules\n-----------------------------\n\nAt minimum, you'll need to install the pelican_precompress plugin.\nIt will automatically generate gzip files because gzip is built into the\nPython standard library.\n\nHowever, if you want highly-optimized gzip files you'll need the zopfli module.\nAnd if you want to have the very best compression currently available, you'll\nneed to install the brotli module (which will require extra work in step 3).\n\n..  code-block:: shell-session\n\n    $ pip install pelican_precompress\n    $ pip install zopfli  # This produces smaller gzip'd files. Use it!\n    $ pip install brotli  # This requires extra work in step 3.\n\nFurther reading: `zopfli`_, `brotli`_\n\n\n2. Configure Pelican\n--------------------\n\nIf you're using Pelican 4.5 or higher then you might not need to configure anything.\npelican_precompress supports Pelican's namespace plugin architecture\nand will be automatically detected and loaded when Pelican runs.\n\nHowever, if you're maintaining a list of plugins for Pelican to use (even in Pelican 4.5)\nthen you'll need to add it to the list of active plugins.\n\nFeel free to copy and paste the code below into your Pelican configuration file.\nJust uncomment and edit the configuration lines to your liking...or leave\nthem alone because the defaults are awesome!\n\n..  code-block:: python3\n\n    # Pelican 4.5 introduced automatic plugin discovery and loading.\n    # You only need to add pelican_precompress to your PLUGINS list\n    # if your configuration file already has a PLUGINS list!\n    #\n    # PLUGINS = ['pelican.plugins.precompress']\n\n    # These options can be customized as desired.\n    #\n    # PRECOMPRESS_GZIP = True or False\n    # PRECOMPRESS_ZOPFLI = True or False\n    # PRECOMPRESS_BROTLI = True or False\n    # PRECOMPRESS_OVERWRITE = False\n    # PRECOMPRESS_MIN_SIZE = 20\n    # PRECOMPRESS_TEXT_EXTENSIONS = {\n    #     '.atom',\n    #     '.css',\n    #     '.html',\n    #     '.but-the-default-extensions-are-pretty-comprehensive',\n    # }\n\nFurther reading: `Pelican plugins`_\n\n\n3. Configure nginx\n------------------\n\nnginx supports gzip compression right out of the box.\nTo enable it, add something like this to your nginx configuration file:\n\n..  code-block:: nginx\n\n    http {\n        gzip_static on;\n        gzip_vary on;\n    }\n\nAt the time of writing, nginx doesn't natively support brotli compression.\nTo get it, you'll need to compile the static brotli module as an nginx\ndynamic module, or recompile nginx from scratch. When it's done you'll\nadd something like this to your nginx configuration file:\n\n..  code-block:: nginx\n\n    load_module /usr/lib/nginx/modules/ngx_http_brotli_static_module.so;\n\n    http {\n        brotli_static on;\n    }\n\nFurther reading: `gzip_static`_, `gzip_vary`_, `nginx brotli module`_\n\n\nConfiguration\n=============\n\nThere are a small number of configuration options available.\nYou set them in your Pelican configuration file.\n\n*   ``PRECOMPRESS_GZIP`` (bool, default is True)\n\n    This is always ``True`` unless you set this to ``False``.\n    For example, you might turn this off during development.\n\n*   ``PRECOMPRESS_ZOPFLI`` (bool, default is True if zopfli is installed)\n\n    If the zopfli module is installed this will default to ``True``.\n    You might set this to ``False`` during development.\n    Note that if you try to enable zopfli compression but the module\n    isn't installed then nothing will happen.\n\n*   ``PRECOMPRESS_BROTLI`` (bool, default is True if brotli is installed)\n\n    If the brotli module is installed this will default to ``True``.\n    You might set this to ``False`` during development.\n    Like ``PRECOMPRESS_ZOPFLI``, if you set this to ``True`` when the\n    brotli module isn't installed then nothing will happen.\n\n*   ``PRECOMPRESS_OVERWRITE`` (bool, default is False)\n\n    When pelican_precompress encounters an existing compressed file\n    it will refuse to overwrite it. If you want the plugin to overwrite\n    files you can set this to ``True``.\n\n*   ``PRECOMPRESS_TEXT_EXTENSIONS`` (Set[str])\n\n    This setting controls which file extensions will be pre-compressed.\n\n    If you modify this setting in the Pelican configuration file it will\n    completely replace the default extensions!\n\n*   ``PRECOMPRESS_MIN_SIZE`` (int, default is 20)\n\n    Small files tend to result in a larger file size when compressed, and any\n    improvement is likely to be marginal. The default setting is chosen to\n    avoid speculatively compressing files that are likely to result in a\n    larger file size after compression.\n\n    To try compressing every file regardless of size, set this to ``0``.\n\n\nDevelopment\n===========\n\nIf you'd like to develop and/or test the code yourself,\nclone the git repository and run these commands to set\nup a Python virtual environment, install dependencies,\nand run the test suite:\n\n..  code-block:: shell\n\n    $ python -m venv venv\n    $ source venv/bin/activate\n    (venv) $ python -m pip install poetry\n    (venv) $ poetry update\n    (venv) $ tox\n\nThe test suite uses tox to setup multiple environments with varying\ndependencies using multiple Python interpreters; pytest allows the\ntest suite to have parametrized tests; pyfakefs creates a fake\nfilesystem that the tests safely create and erase files in;\nand coverage keeps track of which lines of code have been run.\n\n**pelican_precompress** has 100% test coverage, but there may still be bugs.\nPlease report any issues that you encounter.\n\nFurther reading: `poetry`_, `tox`_, `venv`_, `pytest`_, `pyfakefs`_, `coverage`_\n\n\n..  Links\n..  =====\n\n..  _Pelican: https://getpelican.com/\n..  _Pelican plugins: https://docs.getpelican.com/en/latest/plugins.html\n..  _zopfli: https://pypi.org/project/zopfli/\n..  _brotli: https://pypi.org/project/Brotli/\n..  _gzip_static: https://nginx.org/en/docs/http/ngx_http_gzip_static_module.html#gzip_static\n..  _gzip_vary: https://nginx.org/en/docs/http/ngx_http_gzip_module.html#gzip_vary\n..  _nginx brotli module: https://github.com/google/ngx_brotli\n..  _poetry: https://python-poetry.org/\n..  _tox: https://tox.readthedocs.io/en/latest/\n..  _pytest: https://docs.pytest.org/en/latest/\n..  _pyfakefs: https://jmcgeheeiv.github.io/pyfakefs/release/\n..  _venv: https://docs.python.org/3/library/venv.html\n..  _coverage: https://coverage.readthedocs.io/en/latest/\n",
    'author': 'Kurt McKee',
    'author_email': 'contactme@kurtmckee.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kurtmckee/pelican_precompress/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0',
}


setup(**setup_kwargs)
