"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticachememcached = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("../../core");
const constructs_1 = require("constructs");
const core_1 = require("../../core");
const defaultEnvironmentVariableName = "CACHE_ENDPOINT";
/**
 * @summary The LambdaToElasticachememcached class.
 */
class LambdaToElasticachememcached extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        if ((props.existingCache || props.existingLambdaObj) && (!props.existingVpc)) {
            throw Error('If providing an existing Cache or Lambda Function, you must also supply the associated existingVpc');
        }
        if (props.cacheProps &&
            props.cacheProps.engine &&
            props.cacheProps.engine !== "memcached") {
            throw Error("This construct can only launch memcached clusters");
        }
        if (props.cacheProps && props.existingCache) {
            throw Error("Cannot specify existingCache and cacheProps");
        }
        const cachePort = (0, core_1.getCachePort)(props.cacheProps, props.existingCache);
        this.vpc = defaults.buildVpc(scope, {
            defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
            existingVpc: props.existingVpc,
            userVpcProps: props.vpcProps,
        });
        const lambdaToCacheSecurityGroup = (0, core_1.CreateSelfReferencingSecurityGroup)(this, id, this.vpc, cachePort);
        this.cache = (0, core_1.obtainMemcachedCluster)(this, id, {
            cacheSecurityGroupId: lambdaToCacheSecurityGroup.securityGroupId,
            cacheProps: props.cacheProps,
            existingCache: props.existingCache,
            vpc: this.vpc,
            cachePort,
        });
        // Add the self-referencing security group to the Lambda function props
        const lambdaFunctionProps = defaults.consolidateProps({}, props.lambdaFunctionProps, { securityGroups: [lambdaToCacheSecurityGroup] }, true);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps,
            vpc: this.vpc,
        });
        AddLambdaEnvironmentVariable(this.lambdaFunction, `${this.cache.attrConfigurationEndpointAddress}:${this.cache.attrConfigurationEndpointPort}`, defaultEnvironmentVariableName, props.cacheEndpointEnvironmentVariableName);
    }
}
exports.LambdaToElasticachememcached = LambdaToElasticachememcached;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticachememcached[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticachememcached.LambdaToElasticachememcached", version: "2.85.1" };
function AddLambdaEnvironmentVariable(targetFunction, value, defaultName, clientName) {
    const variableName = clientName || defaultName;
    targetFunction.addEnvironment(variableName, value);
}
//# sourceMappingURL=data:application/json;base64,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