/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface CancellationManager {
    public void checkCanceled() throws CanceledException;

    public void startMethod(String var1, String var2);

    public void finishMethod(String var1, String var2);

    public static CancellationManager getSimpleWithTimeout(int maxMethodTimeoutSec) {
        return new TimeoutCancellationManager(maxMethodTimeoutSec);
    }

    public static class TimeoutCancellationManager
    implements CancellationManager {
        private final long maxMilis;
        private long startMilis = 0L;

        protected TimeoutCancellationManager(int maxMethodTimeoutSec) {
            this.maxMilis = (long)maxMethodTimeoutSec * 1000L;
        }

        @Override
        public void checkCanceled() throws CanceledException {
            if (this.maxMilis <= 0L || this.startMilis <= 0L) {
                return;
            }
            long timeMillis = System.currentTimeMillis();
            if (timeMillis - this.startMilis > this.maxMilis) {
                throw new TimeExceedException();
            }
        }

        @Override
        public void startMethod(String className, String methodName) {
            this.startMilis = System.currentTimeMillis();
        }

        @Override
        public void finishMethod(String className, String methodName) {
            this.startMilis = 0L;
        }
    }

    @ApiStatus.Experimental
    public static class TimeExceedException
    extends CanceledException {
    }

    @ApiStatus.Experimental
    public static class CanceledException
    extends RuntimeException {
        public CanceledException(@NotNull Throwable cause) {
            super(cause);
        }

        public CanceledException() {
        }
    }
}

