# coding: utf-8

"""
    OpenAPI definition

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OrderDto(BaseModel):
    """
    OrderDto
    """ # noqa: E501
    order_id: Optional[StrictStr] = Field(default=None, alias="orderId")
    broker_id: Optional[StrictStr] = Field(default=None, alias="brokerId")
    created_time: Optional[datetime] = Field(default=None, alias="createdTime")
    updated_time: Optional[datetime] = Field(default=None, alias="updatedTime")
    security_id: Optional[StrictStr] = Field(default=None, alias="securityId")
    symbol: Optional[StrictStr] = None
    asset_class: Optional[StrictStr] = Field(default=None, alias="assetClass")
    notional: Optional[Union[StrictFloat, StrictInt]] = None
    quantity: Optional[StrictInt] = None
    filled_quantity: Optional[StrictInt] = Field(default=None, alias="filledQuantity")
    mean_fill_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="meanFillPrice")
    order_type: Optional[StrictStr] = Field(default=None, alias="orderType")
    order_side: Optional[StrictStr] = Field(default=None, alias="orderSide")
    time_in_force: Optional[StrictStr] = Field(default=None, alias="timeInForce")
    limit_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="limitPrice")
    stop_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="stopPrice")
    status: Optional[StrictStr] = None
    strike_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="strikePrice")
    __properties: ClassVar[List[str]] = ["orderId", "brokerId", "createdTime", "updatedTime", "securityId", "symbol", "assetClass", "notional", "quantity", "filledQuantity", "meanFillPrice", "orderType", "orderSide", "timeInForce", "limitPrice", "stopPrice", "status", "strikePrice"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId": obj.get("orderId"),
            "brokerId": obj.get("brokerId"),
            "createdTime": obj.get("createdTime"),
            "updatedTime": obj.get("updatedTime"),
            "securityId": obj.get("securityId"),
            "symbol": obj.get("symbol"),
            "assetClass": obj.get("assetClass"),
            "notional": obj.get("notional"),
            "quantity": obj.get("quantity"),
            "filledQuantity": obj.get("filledQuantity"),
            "meanFillPrice": obj.get("meanFillPrice"),
            "orderType": obj.get("orderType"),
            "orderSide": obj.get("orderSide"),
            "timeInForce": obj.get("timeInForce"),
            "limitPrice": obj.get("limitPrice"),
            "stopPrice": obj.get("stopPrice"),
            "status": obj.get("status"),
            "strikePrice": obj.get("strikePrice")
        })
        return _obj


