
from typing import List, Optional, Dict, Iterable, Any, overload
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.diagram
import aspose.diagram.activexcontrols
import aspose.diagram.autolayout
import aspose.diagram.manipulation
import aspose.diagram.printing
import aspose.diagram.properties
import aspose.diagram.saving
import aspose.diagram.vba

class AbstractInterruptMonitor:
    
    @property
    def is_interruption_requested(self) -> bool:
        raise NotImplementedError()
    

class Act:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def menu(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def action(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def checked(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def disabled(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def read_only(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def invisible(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def begin_group(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def flyout_child(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def tag_name(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def button_face(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def sort_key(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    

class ActCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Act) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Act) -> None:
        raise NotImplementedError()
    
    def get_act(self, id : int) -> aspose.diagram.Act:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Act:
        raise NotImplementedError()
    

class Align:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def align_left(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def align_center(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def align_right(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def align_top(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def align_middle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def align_bottom(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class Alignment:
    
    def __init__(self, value : aspose.diagram.AlignmentValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.AlignmentValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.AlignmentValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Annotation:
    
    @property
    def shape_id(self) -> int:
        raise NotImplementedError()
    
    @shape_id.setter
    def shape_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def reviewer_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def marker_index(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def date(self) -> aspose.diagram.DateValue:
        raise NotImplementedError()
    
    @property
    def edit_date(self) -> aspose.diagram.DateValue:
        raise NotImplementedError()
    
    @property
    def comment(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def lang_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    

class AnnotationCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Annotation) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Annotation) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Annotation:
        raise NotImplementedError()
    

class ArcTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class ArcToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.ArcTo:
        raise NotImplementedError()
    

class ArrowSize:
    
    def __init__(self, value : aspose.diagram.ArrowSizeValue) -> None:
        raise NotImplementedError()
    
    @property
    def is_themed(self) -> bool:
        raise NotImplementedError()
    
    @is_themed.setter
    def is_themed(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ArrowSizeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ArrowSizeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class AutoLinkComparison:
    
    @property
    def column_name(self) -> str:
        raise NotImplementedError()
    
    @column_name.setter
    def column_name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def context_type(self) -> aspose.diagram.ContextTypeValue:
        raise NotImplementedError()
    
    @context_type.setter
    def context_type(self, value : aspose.diagram.ContextTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def context_type_label(self) -> str:
        raise NotImplementedError()
    
    @context_type_label.setter
    def context_type_label(self, value : str) -> None:
        raise NotImplementedError()
    

class AutoSpaceOptions:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def distance_in_vertical(self) -> float:
        raise NotImplementedError()
    
    @distance_in_vertical.setter
    def distance_in_vertical(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def distance_in_horizontal(self) -> float:
        raise NotImplementedError()
    
    @distance_in_horizontal.setter
    def distance_in_horizontal(self, value : float) -> None:
        raise NotImplementedError()
    

class Bevel:
    
    @property
    def width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class BevelLightingType:
    
    def __init__(self, value : aspose.diagram.BevelLightingTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.BevelLightingTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.BevelLightingTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class BevelMaterialType:
    
    def __init__(self, value : aspose.diagram.BevelMaterialTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.BevelMaterialTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.BevelMaterialTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class BevelType:
    
    def __init__(self, value : aspose.diagram.BevelTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.BevelTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.BevelTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class BoolValue:
    
    def __init__(self, value : aspose.diagram.BOOL, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def is_themed(self) -> bool:
        raise NotImplementedError()
    
    @is_themed.setter
    def is_themed(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class BuildVersionInfo:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def ASSEMBLY_VERSION(self) -> str:
        raise NotImplementedError()

    @property
    def FILE_VERSION(self) -> str:
        raise NotImplementedError()

    @property
    def PRODUCT(self) -> str:
        raise NotImplementedError()


class Bullet:
    
    def __init__(self, value : aspose.diagram.BulletValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.BulletValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.BulletValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Calendar:
    
    def __init__(self, value : aspose.diagram.CalendarValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.CalendarValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.CalendarValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class Case:
    
    def __init__(self, value : aspose.diagram.CaseValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.CaseValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.CaseValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class Char:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def font_name(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @font_name.setter
    def font_name(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.diagram.Style:
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.diagram.Style) -> None:
        raise NotImplementedError()
    
    @property
    def case(self) -> aspose.diagram.Case:
        raise NotImplementedError()
    
    @case.setter
    def case(self, value : aspose.diagram.Case) -> None:
        raise NotImplementedError()
    
    @property
    def pos(self) -> aspose.diagram.Pos:
        raise NotImplementedError()
    
    @pos.setter
    def pos(self, value : aspose.diagram.Pos) -> None:
        raise NotImplementedError()
    
    @property
    def font_scale(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @font_scale.setter
    def font_scale(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def locale(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @locale.setter
    def locale(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def dbl_underline(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @dbl_underline.setter
    def dbl_underline(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def overline(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @overline.setter
    def overline(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def highlight(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @highlight.setter
    def highlight(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def perpendicular(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @perpendicular.setter
    def perpendicular(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    
    @property
    def strikethru(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @strikethru.setter
    def strikethru(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def double_strikethrough(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @double_strikethrough.setter
    def double_strikethrough(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def rtl_text(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @rtl_text.setter
    def rtl_text(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def use_vertical(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @use_vertical.setter
    def use_vertical(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def letterspace(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @letterspace.setter
    def letterspace(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def color_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @color_trans.setter
    def color_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def asian_font(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @asian_font.setter
    def asian_font(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def asian_font_name(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @asian_font_name.setter
    def asian_font_name(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    
    @property
    def localize_font(self) -> aspose.diagram.LocalizeFont:
        raise NotImplementedError()
    
    @localize_font.setter
    def localize_font(self, value : aspose.diagram.LocalizeFont) -> None:
        raise NotImplementedError()
    
    @property
    def is_double_underline(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_subscript(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_superscript(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_strikethrough(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_double_strikethrough(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_underline(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_italic(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_bold(self) -> bool:
        raise NotImplementedError()
    
    @property
    def complex_script_size(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @complex_script_size.setter
    def complex_script_size(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def complex_script_font(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @complex_script_font.setter
    def complex_script_font(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def complex_script_font_name(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @complex_script_font_name.setter
    def complex_script_font_name(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    
    @property
    def lang_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @lang_id.setter
    def lang_id(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    

class CharCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Char) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Char) -> None:
        raise NotImplementedError()
    
    def get_char(self, ix : int) -> aspose.diagram.Char:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Char:
        raise NotImplementedError()
    

class Collection:
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    

class ColorEntry:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        raise NotImplementedError()
    

class ColorEntryCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, color : aspose.diagram.ColorEntry) -> int:
        raise NotImplementedError()
    
    def remove(self, color : aspose.diagram.ColorEntry) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.ColorEntry:
        raise NotImplementedError()
    

class ColorValue:
    
    def __init__(self, value : str, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class CompoundType:
    
    def __init__(self, value : aspose.diagram.CompoundTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.CompoundTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.CompoundTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConFixedCode:
    
    def __init__(self, value : aspose.diagram.ConFixedCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConFixedCodeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConFixedCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConLineJumpCode:
    
    def __init__(self, value : aspose.diagram.ConLineJumpCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConLineJumpCodeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConLineJumpCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConLineJumpDirX:
    
    def __init__(self, value : aspose.diagram.ConLineJumpDirXValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConLineJumpDirXValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConLineJumpDirXValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConLineJumpDirY:
    
    def __init__(self, value : aspose.diagram.ConLineJumpDirYValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConLineJumpDirYValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConLineJumpDirYValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConLineJumpStyle:
    
    def __init__(self, value : aspose.diagram.ConLineJumpStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConLineJumpStyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConLineJumpStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConLineRouteExt:
    
    def __init__(self, value : aspose.diagram.ConLineRouteExtValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConLineRouteExtValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConLineRouteExtValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ConType:
    
    def __init__(self, value : aspose.diagram.ConValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ConValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ConValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class Connect:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def from_sheet(self) -> int:
        raise NotImplementedError()
    
    @from_sheet.setter
    def from_sheet(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def to_sheet(self) -> int:
        raise NotImplementedError()
    
    @to_sheet.setter
    def to_sheet(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def from_cell(self) -> str:
        raise NotImplementedError()
    
    @from_cell.setter
    def from_cell(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def to_cell(self) -> str:
        raise NotImplementedError()
    
    @to_cell.setter
    def to_cell(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def from_part(self) -> aspose.diagram.FromPartValue:
        raise NotImplementedError()
    
    @from_part.setter
    def from_part(self, value : aspose.diagram.FromPartValue) -> None:
        raise NotImplementedError()
    
    @property
    def to_part(self) -> aspose.diagram.ToPartValue:
        raise NotImplementedError()
    
    @to_part.setter
    def to_part(self, value : aspose.diagram.ToPartValue) -> None:
        raise NotImplementedError()
    

class ConnectCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, connect : aspose.diagram.Connect) -> int:
        raise NotImplementedError()
    
    def remove(self, connect : aspose.diagram.Connect) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Connect:
        raise NotImplementedError()
    

class Connection:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def dir_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def dir_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.TypeConnection:
        raise NotImplementedError()
    
    @property
    def auto_gen(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def prompt(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    

class ConnectionABCD:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class ConnectionABCDCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.ConnectionABCD) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.ConnectionABCD) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.ConnectionABCD:
        raise NotImplementedError()
    

class ConnectionCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Connection) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Connection) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Connection:
        raise NotImplementedError()
    

class ConnectorRule:
    
    @property
    def start_shape_id(self) -> int:
        raise NotImplementedError()
    
    @property
    def start_shape_connection(self) -> aspose.diagram.Connection:
        raise NotImplementedError()
    
    @property
    def end_shape_connection(self) -> aspose.diagram.Connection:
        raise NotImplementedError()
    
    @property
    def end_shape_id(self) -> int:
        raise NotImplementedError()
    

class Control:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def x_dyn(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x_dyn.setter
    def x_dyn(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y_dyn(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y_dyn.setter
    def y_dyn(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def x_con(self) -> aspose.diagram.ConType:
        raise NotImplementedError()
    
    @x_con.setter
    def x_con(self, value : aspose.diagram.ConType) -> None:
        raise NotImplementedError()
    
    @property
    def y_con(self) -> aspose.diagram.ConType:
        raise NotImplementedError()
    
    @y_con.setter
    def y_con(self, value : aspose.diagram.ConType) -> None:
        raise NotImplementedError()
    
    @property
    def can_glue(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @can_glue.setter
    def can_glue(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def prompt(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @prompt.setter
    def prompt(self, value : aspose.diagram.Str2Value) -> None:
        raise NotImplementedError()
    

class ControlCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Control) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Control) -> None:
        raise NotImplementedError()
    
    def get_control(self, ix : int) -> aspose.diagram.Control:
        raise NotImplementedError()
    
    def get_control_from_id(self, id : int) -> aspose.diagram.Control:
        raise NotImplementedError()
    
    def get_control_from_name(self, name : str) -> aspose.diagram.Control:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Control:
        raise NotImplementedError()
    

class Coordinate:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    

class CoordinateCollection(Collection):
    
    @overload
    def add(self, item : aspose.diagram.Coordinate) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.MoveTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.LineTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.ArcTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.InfiniteLine) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.Ellipse) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.EllipticalArcTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.SplineStart) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.SplineKnot) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.PolylineTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.NURBSTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.RelCubBezTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.RelQuadBezTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.RelMoveTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.RelLineTo) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, item : aspose.diagram.RelEllipticalArcTo) -> int:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.Coordinate) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.MoveTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.LineTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.ArcTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.InfiniteLine) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.Ellipse) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.EllipticalArcTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.SplineStart) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.SplineKnot) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.PolylineTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.NURBSTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.RelCubBezTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.RelQuadBezTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.RelMoveTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.RelLineTo) -> None:
        raise NotImplementedError()
    
    @overload
    def remove(self, item : aspose.diagram.RelEllipticalArcTo) -> None:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def move_to_col(self) -> aspose.diagram.MoveToCollection:
        raise NotImplementedError()
    
    @property
    def line_to_col(self) -> aspose.diagram.LineToCollection:
        raise NotImplementedError()
    
    @property
    def arc_to_col(self) -> aspose.diagram.ArcToCollection:
        raise NotImplementedError()
    
    @property
    def infinite_line_col(self) -> aspose.diagram.InfiniteLineCollection:
        raise NotImplementedError()
    
    @property
    def ellipse_col(self) -> aspose.diagram.EllipseCollection:
        raise NotImplementedError()
    
    @property
    def elliptical_arc_to_col(self) -> aspose.diagram.EllipticalArcToCollection:
        raise NotImplementedError()
    
    @property
    def spline_start_col(self) -> aspose.diagram.SplineStartCollection:
        raise NotImplementedError()
    
    @property
    def spline_knot_col(self) -> aspose.diagram.SplineKnotCollection:
        raise NotImplementedError()
    
    @property
    def polyline_to_col(self) -> aspose.diagram.PolylineToCollection:
        raise NotImplementedError()
    
    @property
    def nurbs_to_col(self) -> aspose.diagram.NURBSToCollection:
        raise NotImplementedError()
    
    @property
    def rel_cub_bez_to_col(self) -> aspose.diagram.RelCubBezToCollection:
        raise NotImplementedError()
    
    @property
    def rel_quad_bez_to_col(self) -> aspose.diagram.RelQuadBezToCollection:
        raise NotImplementedError()
    
    @property
    def rel_move_to_col(self) -> aspose.diagram.RelMoveToCollection:
        raise NotImplementedError()
    
    @property
    def rel_line_to_col(self) -> aspose.diagram.RelLineToCollection:
        raise NotImplementedError()
    
    @property
    def rel_elliptical_arc_to_col(self) -> aspose.diagram.RelEllipticalArcToCollection:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Coordinate:
        raise NotImplementedError()
    

class Cp(FormatTxt):
    
    def __init__(self, ix : int) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    

class CustomProp:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def prop_type(self) -> aspose.diagram.PropType:
        raise NotImplementedError()
    
    @prop_type.setter
    def prop_type(self, value : aspose.diagram.PropType) -> None:
        raise NotImplementedError()
    
    @property
    def custom_value(self) -> aspose.diagram.CustomValue:
        raise NotImplementedError()
    
    @custom_value.setter
    def custom_value(self, value : aspose.diagram.CustomValue) -> None:
        raise NotImplementedError()
    

class CustomPropCollection(Collection):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, custom_prop : aspose.diagram.CustomProp) -> int:
        raise NotImplementedError()
    
    def remove(self, custom_prop : aspose.diagram.CustomProp) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.CustomProp:
        raise NotImplementedError()
    

class CustomValue:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def value_string(self) -> str:
        raise NotImplementedError()
    
    @value_string.setter
    def value_string(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def value_bool(self) -> bool:
        raise NotImplementedError()
    
    @value_bool.setter
    def value_bool(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def value_date(self) -> datetime:
        raise NotImplementedError()
    
    @value_date.setter
    def value_date(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def value_number(self) -> float:
        raise NotImplementedError()
    
    @value_number.setter
    def value_number(self, value : float) -> None:
        raise NotImplementedError()
    

class DataColumn:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def column_name_id(self) -> str:
        raise NotImplementedError()
    
    @column_name_id.setter
    def column_name_id(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def label(self) -> str:
        raise NotImplementedError()
    
    @label.setter
    def label(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def orig_label(self) -> str:
        raise NotImplementedError()
    
    @orig_label.setter
    def orig_label(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def lang_id(self) -> int:
        raise NotImplementedError()
    
    @lang_id.setter
    def lang_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def calendar(self) -> int:
        raise NotImplementedError()
    
    @calendar.setter
    def calendar(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def data_type(self) -> int:
        raise NotImplementedError()
    
    @data_type.setter
    def data_type(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def unit_type(self) -> str:
        raise NotImplementedError()
    
    @unit_type.setter
    def unit_type(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def currency(self) -> int:
        raise NotImplementedError()
    
    @currency.setter
    def currency(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def degree(self) -> int:
        raise NotImplementedError()
    
    @degree.setter
    def degree(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def display_width(self) -> int:
        raise NotImplementedError()
    
    @display_width.setter
    def display_width(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def display_order(self) -> int:
        raise NotImplementedError()
    
    @display_order.setter
    def display_order(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def mapped(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @mapped.setter
    def mapped(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @hyperlink.setter
    def hyperlink(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    

class DataColumnCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, data_column : aspose.diagram.DataColumn) -> int:
        raise NotImplementedError()
    
    def remove(self, data_column : aspose.diagram.DataColumn) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def sort_column(self) -> str:
        raise NotImplementedError()
    
    @sort_column.setter
    def sort_column(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def sort_asc(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @sort_asc.setter
    def sort_asc(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.DataColumn:
        raise NotImplementedError()
    

class DataConnection:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def file_name(self) -> str:
        raise NotImplementedError()
    
    @file_name.setter
    def file_name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def connection_string(self) -> str:
        raise NotImplementedError()
    
    @connection_string.setter
    def connection_string(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def command(self) -> str:
        raise NotImplementedError()
    
    @command.setter
    def command(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def timeout(self) -> int:
        raise NotImplementedError()
    
    @timeout.setter
    def timeout(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def always_use_connection_file(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @always_use_connection_file.setter
    def always_use_connection_file(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    

class DataConnectionCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, data_connection : aspose.diagram.DataConnection) -> int:
        raise NotImplementedError()
    
    def remove(self, data_connection : aspose.diagram.DataConnection) -> None:
        raise NotImplementedError()
    
    def get_data_connection(self, id : int) -> aspose.diagram.DataConnection:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def next_id(self) -> int:
        raise NotImplementedError()
    
    @next_id.setter
    def next_id(self, value : int) -> None:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.DataConnection:
        raise NotImplementedError()
    

class DataRecordSet:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def refresh(self) -> None:
        raise NotImplementedError()
    
    @overload
    def refresh(self, connection_type : aspose.diagram.manipulation.DataConnectionType) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def connection_id(self) -> int:
        raise NotImplementedError()
    
    @connection_id.setter
    def connection_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def command(self) -> str:
        raise NotImplementedError()
    
    @command.setter
    def command(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def options(self) -> aspose.diagram.OptionsValue:
        raise NotImplementedError()
    
    @options.setter
    def options(self, value : aspose.diagram.OptionsValue) -> None:
        raise NotImplementedError()
    
    @property
    def time_refreshed(self) -> datetime:
        raise NotImplementedError()
    
    @time_refreshed.setter
    def time_refreshed(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def next_row_id(self) -> int:
        raise NotImplementedError()
    
    @next_row_id.setter
    def next_row_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def row_order(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @row_order.setter
    def row_order(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def refresh_overwrite_all(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @refresh_overwrite_all.setter
    def refresh_overwrite_all(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def refresh_no_reconciliation_ui(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @refresh_no_reconciliation_ui.setter
    def refresh_no_reconciliation_ui(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def refresh_interval(self) -> int:
        raise NotImplementedError()
    
    @refresh_interval.setter
    def refresh_interval(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def replace_links(self) -> int:
        raise NotImplementedError()
    
    @replace_links.setter
    def replace_links(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def checksum(self) -> int:
        raise NotImplementedError()
    
    @checksum.setter
    def checksum(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ado_data(self) -> str:
        raise NotImplementedError()
    
    @ado_data.setter
    def ado_data(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def refresh_conflicts(self) -> aspose.diagram.RowCollection:
        raise NotImplementedError()
    
    @property
    def row_maps(self) -> aspose.diagram.RowCollection:
        raise NotImplementedError()
    
    @property
    def auto_link_comparison(self) -> aspose.diagram.AutoLinkComparison:
        raise NotImplementedError()
    
    @property
    def data_columns(self) -> aspose.diagram.DataColumnCollection:
        raise NotImplementedError()
    

class DataRecordSetCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, data_record_set : aspose.diagram.DataRecordSet) -> int:
        raise NotImplementedError()
    
    def remove(self, data_record_set : aspose.diagram.DataRecordSet) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def next_id(self) -> str:
        raise NotImplementedError()
    
    @next_id.setter
    def next_id(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def active_recordset_id(self) -> str:
        raise NotImplementedError()
    
    @active_recordset_id.setter
    def active_recordset_id(self, value : str) -> None:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.DataRecordSet:
        raise NotImplementedError()
    

class DateValue:
    
    def __init__(self, value : datetime, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> datetime:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Diagram:
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, filename : str) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, stream : io._IOBase) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, filename : str, format : aspose.diagram.LoadFileFormat) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, stream : io._IOBase, format : aspose.diagram.LoadFileFormat) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, filename : str, options : aspose.diagram.LoadOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, stream : io._IOBase, options : aspose.diagram.LoadOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def save(self, filename : str, format : aspose.diagram.SaveFileFormat) -> None:
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, format : aspose.diagram.SaveFileFormat) -> None:
        raise NotImplementedError()
    
    @overload
    def save(self, filename : str, options : aspose.diagram.saving.SaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options : aspose.diagram.saving.SaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def export(input_vsd : str, output_vdw : str) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def export(input_vsd : str, output_vdw : io._IOBase) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def export(input_vsd : io._IOBase, output_vdw : str) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def export(input_vsd : io._IOBase, output_vdw : io._IOBase) -> None:
        raise NotImplementedError()
    
    @overload
    def add_master(self, src_diagram : aspose.diagram.Diagram, master_name : str) -> int:
        raise NotImplementedError()
    
    @overload
    def add_master(self, template_stream : io._IOBase, master_name : str) -> int:
        raise NotImplementedError()
    
    @overload
    def add_master(self, template_stream : io._IOBase, master_id : int) -> int:
        raise NotImplementedError()
    
    @overload
    def add_master(self, template_file_path : str, master_name : str) -> int:
        raise NotImplementedError()
    
    @overload
    def add_master(self, template_file_path : str, master_id : int) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, new_shape : aspose.diagram.Shape, master_name : str, page_number : int) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, pin_x : float, pin_y : float, master_name : str, page_number : int) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, pin_x : float, pin_y : float, width : float, height : float, master_name : str, page_number : int) -> int:
        raise NotImplementedError()
    
    @overload
    def print(self, options : aspose.diagram.saving.PrintSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_name : str) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_name : str, options : aspose.diagram.saving.PrintSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_settings : Any, options : aspose.diagram.saving.PrintSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_settings : Any) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_settings : Any, document_name : str, options : aspose.diagram.saving.PrintSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_settings : Any, document_name : str) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_name : str, document_name : str, options : aspose.diagram.saving.PrintSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def print(self, printer_name : str, document_name : str) -> None:
        raise NotImplementedError()
    
    def copy_theme(self, source : aspose.diagram.Diagram) -> None:
        raise NotImplementedError()
    
    def combine(self, second_diagram : aspose.diagram.Diagram) -> None:
        raise NotImplementedError()
    
    def refresh(self) -> None:
        raise NotImplementedError()
    
    def layout(self, options : aspose.diagram.autolayout.LayoutOptions) -> None:
        raise NotImplementedError()
    
    def has_hidden_info(self) -> bool:
        raise NotImplementedError()
    
    def remove_hidden_information(self, item : int) -> None:
        raise NotImplementedError()
    
    def get_unused_styles(self) -> aspose.diagram.StyleSheetCollection:
        raise NotImplementedError()
    
    def get_default_font_dir(self) -> List[Any]:
        raise NotImplementedError()
    
    def remove_macro(self) -> None:
        raise NotImplementedError()
    
    @property
    def start(self) -> int:
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def key(self) -> str:
        raise NotImplementedError()
    
    @key.setter
    def key(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def metric(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @metric.setter
    def metric(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def buildnum(self) -> int:
        raise NotImplementedError()
    
    @buildnum.setter
    def buildnum(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def version(self) -> str:
        raise NotImplementedError()
    
    @version.setter
    def version(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def doc_lang_id(self) -> int:
        raise NotImplementedError()
    
    @doc_lang_id.setter
    def doc_lang_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def style_sheets(self) -> aspose.diagram.StyleSheetCollection:
        raise NotImplementedError()
    
    @property
    def masters(self) -> aspose.diagram.MasterCollection:
        raise NotImplementedError()
    
    @property
    def pages(self) -> aspose.diagram.PageCollection:
        raise NotImplementedError()
    
    @property
    def document_props(self) -> aspose.diagram.DocumentProperties:
        raise NotImplementedError()
    
    @property
    def document_settings(self) -> aspose.diagram.DocumentSettings:
        raise NotImplementedError()
    
    @property
    def colors(self) -> aspose.diagram.ColorEntryCollection:
        raise NotImplementedError()
    
    @property
    def fonts(self) -> aspose.diagram.FontCollection:
        raise NotImplementedError()
    
    @property
    def document_sheet(self) -> aspose.diagram.DocumentSheet:
        raise NotImplementedError()
    
    @property
    def active_page(self) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    @property
    def windows(self) -> aspose.diagram.WindowCollection:
        raise NotImplementedError()
    
    @property
    def event_items(self) -> aspose.diagram.EventItemCollection:
        raise NotImplementedError()
    
    @property
    def header_footer(self) -> aspose.diagram.HeaderFooter:
        raise NotImplementedError()
    
    @property
    def vb_project_data(self) -> List[int]:
        raise NotImplementedError()
    
    @vb_project_data.setter
    def vb_project_data(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def email_routing_data(self) -> List[int]:
        raise NotImplementedError()
    
    @email_routing_data.setter
    def email_routing_data(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def data_connections(self) -> aspose.diagram.DataConnectionCollection:
        raise NotImplementedError()
    
    @property
    def data_record_sets(self) -> aspose.diagram.DataRecordSetCollection:
        raise NotImplementedError()
    
    @property
    def ribbon_x(self) -> str:
        raise NotImplementedError()
    
    @ribbon_x.setter
    def ribbon_x(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def user_custom_ui(self) -> str:
        raise NotImplementedError()
    
    @user_custom_ui.setter
    def user_custom_ui(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def validation(self) -> aspose.diagram.Validation:
        raise NotImplementedError()
    
    @property
    def solution_xm_ls(self) -> aspose.diagram.SolutionXMLCollection:
        raise NotImplementedError()
    
    @property
    def vba_project(self) -> aspose.diagram.vba.VbaProject:
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.diagram.AbstractInterruptMonitor:
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.diagram.AbstractInterruptMonitor) -> None:
        raise NotImplementedError()
    

class DiagramException:
    
    def __init__(self, msg : str) -> None:
        raise NotImplementedError()
    

class DisplayMode:
    
    def __init__(self, value : aspose.diagram.DisplayModeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.DisplayModeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.DisplayModeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class DisplayModeSmartTagDef:
    
    def __init__(self, value : aspose.diagram.DisplayModeSmartTagDefValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.DisplayModeSmartTagDefValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.DisplayModeSmartTagDefValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class DocProps:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def output_format(self) -> aspose.diagram.OutputFormat:
        raise NotImplementedError()
    
    @property
    def lock_preview(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def add_markup(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def view_markup(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def preview_quality(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def preview_scope(self) -> aspose.diagram.PreviewScope:
        raise NotImplementedError()
    
    @property
    def doc_lang_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    

class DocumentProperties:
    
    @property
    def title(self) -> str:
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def subject(self) -> str:
        raise NotImplementedError()
    
    @subject.setter
    def subject(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def creator(self) -> str:
        raise NotImplementedError()
    
    @creator.setter
    def creator(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def manager(self) -> str:
        raise NotImplementedError()
    
    @manager.setter
    def manager(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def company(self) -> str:
        raise NotImplementedError()
    
    @company.setter
    def company(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def category(self) -> str:
        raise NotImplementedError()
    
    @category.setter
    def category(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def keywords(self) -> str:
        raise NotImplementedError()
    
    @keywords.setter
    def keywords(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def language(self) -> str:
        raise NotImplementedError()
    
    @language.setter
    def language(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def desc(self) -> str:
        raise NotImplementedError()
    
    @desc.setter
    def desc(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def hyperlink_base(self) -> str:
        raise NotImplementedError()
    
    @hyperlink_base.setter
    def hyperlink_base(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def alternate_names(self) -> str:
        raise NotImplementedError()
    
    @alternate_names.setter
    def alternate_names(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def template(self) -> str:
        raise NotImplementedError()
    
    @template.setter
    def template(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def build_number_created(self) -> str:
        raise NotImplementedError()
    
    @build_number_created.setter
    def build_number_created(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def build_number_edited(self) -> str:
        raise NotImplementedError()
    
    @build_number_edited.setter
    def build_number_edited(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def preview_picture(self) -> List[int]:
        raise NotImplementedError()
    
    @preview_picture.setter
    def preview_picture(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def time_created(self) -> datetime:
        raise NotImplementedError()
    
    @time_created.setter
    def time_created(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def time_saved(self) -> datetime:
        raise NotImplementedError()
    
    @time_saved.setter
    def time_saved(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def time_edited(self) -> datetime:
        raise NotImplementedError()
    
    @time_edited.setter
    def time_edited(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def time_printed(self) -> datetime:
        raise NotImplementedError()
    
    @time_printed.setter
    def time_printed(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def custom_props(self) -> aspose.diagram.CustomPropCollection:
        raise NotImplementedError()
    

class DocumentSettings:
    
    @property
    def top_page(self) -> int:
        raise NotImplementedError()
    
    @top_page.setter
    def top_page(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def default_text_style(self) -> int:
        raise NotImplementedError()
    
    @default_text_style.setter
    def default_text_style(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def default_line_style(self) -> int:
        raise NotImplementedError()
    
    @default_line_style.setter
    def default_line_style(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def default_fill_style(self) -> int:
        raise NotImplementedError()
    
    @default_fill_style.setter
    def default_fill_style(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def default_guide_style(self) -> int:
        raise NotImplementedError()
    
    @default_guide_style.setter
    def default_guide_style(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def glue_settings(self) -> aspose.diagram.GlueSettings:
        raise NotImplementedError()
    
    @glue_settings.setter
    def glue_settings(self, value : aspose.diagram.GlueSettings) -> None:
        raise NotImplementedError()
    
    @property
    def snap_settings(self) -> aspose.diagram.SnapSettings:
        raise NotImplementedError()
    
    @snap_settings.setter
    def snap_settings(self, value : aspose.diagram.SnapSettings) -> None:
        raise NotImplementedError()
    
    @property
    def snap_extensions(self) -> aspose.diagram.SnapExtensions:
        raise NotImplementedError()
    
    @snap_extensions.setter
    def snap_extensions(self, value : aspose.diagram.SnapExtensions) -> None:
        raise NotImplementedError()
    
    @property
    def snap_angles(self) -> aspose.diagram.FloatPointNumCollection:
        raise NotImplementedError()
    
    @snap_angles.setter
    def snap_angles(self, value : aspose.diagram.FloatPointNumCollection) -> None:
        raise NotImplementedError()
    
    @property
    def dynamic_grid_enabled(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @dynamic_grid_enabled.setter
    def dynamic_grid_enabled(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def protect_styles(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @protect_styles.setter
    def protect_styles(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def protect_shapes(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @protect_shapes.setter
    def protect_shapes(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def protect_masters(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @protect_masters.setter
    def protect_masters(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def protect_bkgnds(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @protect_bkgnds.setter
    def protect_bkgnds(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def custom_menus_file(self) -> str:
        raise NotImplementedError()
    
    @custom_menus_file.setter
    def custom_menus_file(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def custom_toolbars_file(self) -> str:
        raise NotImplementedError()
    
    @custom_toolbars_file.setter
    def custom_toolbars_file(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def attached_toolbars(self) -> List[int]:
        raise NotImplementedError()
    
    @attached_toolbars.setter
    def attached_toolbars(self, value : List[int]) -> None:
        raise NotImplementedError()
    

class DocumentSheet:
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def line_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @line_style.setter
    def line_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def fill_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @fill_style.setter
    def fill_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def text_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @text_style.setter
    def text_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def unique_id(self) -> UUID:
        raise NotImplementedError()
    
    @unique_id.setter
    def unique_id(self, value : UUID) -> None:
        raise NotImplementedError()
    
    @property
    def doc_props(self) -> aspose.diagram.DocProps:
        raise NotImplementedError()
    
    @property
    def scratchs(self) -> aspose.diagram.ScratchCollection:
        raise NotImplementedError()
    
    @property
    def connections(self) -> aspose.diagram.ConnectionCollection:
        raise NotImplementedError()
    
    @property
    def connection_abc_ds(self) -> aspose.diagram.ConnectionABCDCollection:
        raise NotImplementedError()
    
    @property
    def users(self) -> aspose.diagram.UserCollection:
        raise NotImplementedError()
    
    @property
    def props(self) -> aspose.diagram.PropCollection:
        raise NotImplementedError()
    
    @property
    def hyperlinks(self) -> aspose.diagram.HyperlinkCollection:
        raise NotImplementedError()
    
    @property
    def reviewers(self) -> aspose.diagram.ReviewerCollection:
        raise NotImplementedError()
    
    @property
    def annotations(self) -> aspose.diagram.AnnotationCollection:
        raise NotImplementedError()
    
    @property
    def foreign_data(self) -> aspose.diagram.ForeignData:
        raise NotImplementedError()
    
    @property
    def foreign(self) -> aspose.diagram.Foreign:
        raise NotImplementedError()
    

class DoubleValue:
    
    @overload
    def __init__(self, value : float, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> float:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def is_themed(self) -> bool:
        raise NotImplementedError()
    
    @is_themed.setter
    def is_themed(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class DrawingResizeType:
    
    def __init__(self, value : aspose.diagram.DrawingResizeTypeValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.DrawingResizeTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.DrawingResizeTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class DrawingScaleType:
    
    def __init__(self, value : aspose.diagram.DrawingScaleTypeValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.DrawingScaleTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.DrawingScaleTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class DrawingSizeType:
    
    def __init__(self, value : aspose.diagram.DrawingSizeTypeValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.DrawingSizeTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.DrawingSizeTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class DynFeedback:
    
    def __init__(self, value : aspose.diagram.DynFeedbackValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.DynFeedbackValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.DynFeedbackValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Ellipse(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class EllipseCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Ellipse:
        raise NotImplementedError()
    

class EllipticalArcTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class EllipticalArcToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.EllipticalArcTo:
        raise NotImplementedError()
    

class Event:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def the_data(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @the_data.setter
    def the_data(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def the_text(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @the_text.setter
    def the_text(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def event_dbl_click(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @event_dbl_click.setter
    def event_dbl_click(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def event_xf_mod(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @event_xf_mod.setter
    def event_xf_mod(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def event_drop(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @event_drop.setter
    def event_drop(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def event_multi_drop(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @event_multi_drop.setter
    def event_multi_drop(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class EventItem:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def action(self) -> int:
        raise NotImplementedError()
    
    @action.setter
    def action(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def event_code(self) -> int:
        raise NotImplementedError()
    
    @event_code.setter
    def event_code(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def target(self) -> str:
        raise NotImplementedError()
    
    @target.setter
    def target(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def target_args(self) -> str:
        raise NotImplementedError()
    
    @target_args.setter
    def target_args(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def enabled(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @enabled.setter
    def enabled(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    

class EventItemCollection(Collection):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, event_item : aspose.diagram.EventItem) -> int:
        raise NotImplementedError()
    
    def remove(self, event_item : aspose.diagram.EventItem) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.EventItem:
        raise NotImplementedError()
    

class Field:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @property
    def display_value(self) -> str:
        raise NotImplementedError()
    
    @property
    def edit_mode(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def format(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.TypeField:
        raise NotImplementedError()
    
    @property
    def ui_cat(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def ui_cod(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def ui_fmt(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def calendar(self) -> aspose.diagram.Calendar:
        raise NotImplementedError()
    
    @property
    def object_kind(self) -> aspose.diagram.ObjectKind:
        raise NotImplementedError()
    

class FieldCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Field) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Field) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Field:
        raise NotImplementedError()
    

class FileFontSource(FontSourceBase):
    
    def __init__(self, file_path : str) -> None:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.FontSourceType:
        raise NotImplementedError()
    
    @property
    def file_path(self) -> str:
        raise NotImplementedError()
    

class FileFormatInfo:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def file_format_type(self) -> aspose.diagram.FileFormatType:
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.diagram.LoadFileFormat:
        raise NotImplementedError()
    

class FileFormatUtil:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def detect_file_format(stream : io._IOBase) -> aspose.diagram.FileFormatInfo:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def detect_file_format(file_path : str) -> aspose.diagram.FileFormatInfo:
        raise NotImplementedError()
    

class Fill:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def fill_foregnd(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @fill_foregnd.setter
    def fill_foregnd(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def gradient_fill(self) -> aspose.diagram.GradientFill:
        raise NotImplementedError()
    
    @property
    def fill_bkgnd(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @fill_bkgnd.setter
    def fill_bkgnd(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def fill_pattern(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @fill_pattern.setter
    def fill_pattern(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def shdw_foregnd(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @shdw_foregnd.setter
    def shdw_foregnd(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def shdw_bkgnd(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @shdw_bkgnd.setter
    def shdw_bkgnd(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def shdw_pattern(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @shdw_pattern.setter
    def shdw_pattern(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def fill_foregnd_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @fill_foregnd_trans.setter
    def fill_foregnd_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def fill_bkgnd_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @fill_bkgnd_trans.setter
    def fill_bkgnd_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shdw_foregnd_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shdw_foregnd_trans.setter
    def shdw_foregnd_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shdw_bkgnd_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shdw_bkgnd_trans.setter
    def shdw_bkgnd_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_type(self) -> aspose.diagram.ShapeShdwType:
        raise NotImplementedError()
    
    @shape_shdw_type.setter
    def shape_shdw_type(self, value : aspose.diagram.ShapeShdwType) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_show(self) -> aspose.diagram.ShapeShdwShow:
        raise NotImplementedError()
    
    @shape_shdw_show.setter
    def shape_shdw_show(self, value : aspose.diagram.ShapeShdwShow) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_offset_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shape_shdw_offset_x.setter
    def shape_shdw_offset_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_offset_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shape_shdw_offset_y.setter
    def shape_shdw_offset_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_oblique_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shape_shdw_oblique_angle.setter
    def shape_shdw_oblique_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_scale_factor(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shape_shdw_scale_factor.setter
    def shape_shdw_scale_factor(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def shape_shdw_blur(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @shape_shdw_blur.setter
    def shape_shdw_blur(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class Fld(FormatTxt):
    
    def __init__(self, ix : int, shape : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    

class FloatPointNumCollection(Collection):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, number : float) -> int:
        raise NotImplementedError()
    
    def remove(self, number : float) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> float:
        raise NotImplementedError()
    

class FolderFontSource(FontSourceBase):
    
    def __init__(self, folder_path : str, scan_subfolders : bool) -> None:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.FontSourceType:
        raise NotImplementedError()
    
    @property
    def folder_path(self) -> str:
        raise NotImplementedError()
    
    @property
    def scan_sub_folders(self) -> bool:
        raise NotImplementedError()
    

class Font:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def unicode_ranges(self) -> str:
        raise NotImplementedError()
    
    @unicode_ranges.setter
    def unicode_ranges(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def char_sets(self) -> str:
        raise NotImplementedError()
    
    @char_sets.setter
    def char_sets(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def panos(self) -> str:
        raise NotImplementedError()
    
    @panos.setter
    def panos(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        raise NotImplementedError()
    

class FontCollection(Collection):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, font : aspose.diagram.Font) -> int:
        raise NotImplementedError()
    
    def remove(self, font : aspose.diagram.Font) -> None:
        raise NotImplementedError()
    
    def get_font(self, id : int) -> aspose.diagram.Font:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Font:
        raise NotImplementedError()
    

class FontConfigs:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def set_font_substitutes(original_font_name : str, substitute_font_names : List[str]) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def get_font_substitutes(original_font_name : str) -> List[str]:
        raise NotImplementedError()
    
    @staticmethod
    def set_font_folder(font_folder : str, recursive : bool) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def set_font_folders(font_folders : List[str], recursive : bool) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def set_font_sources(sources : List[aspose.diagram.FontSourceBase]) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def get_font_sources() -> List[aspose.diagram.FontSourceBase]:
        raise NotImplementedError()
    
    @staticmethod
    def set_default_font_name(value: str) -> None:
    @property
    def default_font_name(self) -> str:
        raise NotImplementedError()

    @staticmethod
    def set_prefer_system_font_substitutes(value: bool) -> None:
    @property
    def prefer_system_font_substitutes(self) -> bool:
        raise NotImplementedError()


class FontSourceBase:
    
    @property
    def type(self) -> aspose.diagram.FontSourceType:
        raise NotImplementedError()
    

class Foreign:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def img_offset_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def img_offset_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def img_width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def img_height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class ForeignData:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        raise NotImplementedError()
    
    @image_data.setter
    def image_data(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def object_data(self) -> List[int]:
        raise NotImplementedError()
    
    @object_data.setter
    def object_data(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def foreign_type(self) -> aspose.diagram.ForeignType:
        raise NotImplementedError()
    
    @foreign_type.setter
    def foreign_type(self, value : aspose.diagram.ForeignType) -> None:
        raise NotImplementedError()
    
    @property
    def object_type(self) -> aspose.diagram.ObjectType:
        raise NotImplementedError()
    
    @object_type.setter
    def object_type(self, value : aspose.diagram.ObjectType) -> None:
        raise NotImplementedError()
    
    @property
    def show_as_icon(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_as_icon.setter
    def show_as_icon(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def object_width(self) -> float:
        raise NotImplementedError()
    
    @object_width.setter
    def object_width(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def object_height(self) -> float:
        raise NotImplementedError()
    
    @object_height.setter
    def object_height(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def mapping_mode(self) -> int:
        raise NotImplementedError()
    
    @mapping_mode.setter
    def mapping_mode(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def extent_x(self) -> float:
        raise NotImplementedError()
    
    @extent_x.setter
    def extent_x(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def extent_y(self) -> float:
        raise NotImplementedError()
    
    @extent_y.setter
    def extent_y(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def compression_type(self) -> aspose.diagram.CompressionType:
        raise NotImplementedError()
    
    @compression_type.setter
    def compression_type(self, value : aspose.diagram.CompressionType) -> None:
        raise NotImplementedError()
    
    @property
    def compression_level(self) -> float:
        raise NotImplementedError()
    
    @compression_level.setter
    def compression_level(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> List[int]:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def object_source_full_name(self) -> str:
        raise NotImplementedError()
    
    @object_source_full_name.setter
    def object_source_full_name(self, value : str) -> None:
        raise NotImplementedError()
    

class FormatTxt:
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    

class FormatTxtCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.FormatTxt) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.FormatTxt) -> None:
        raise NotImplementedError()
    
    def set_whole_text(self, text : str) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.FormatTxt:
        raise NotImplementedError()
    

class Geom:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def coordinate_col(self) -> aspose.diagram.CoordinateCollection:
        raise NotImplementedError()
    
    @property
    def no_fill(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @no_fill.setter
    def no_fill(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def no_line(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @no_line.setter
    def no_line(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def no_show(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @no_show.setter
    def no_show(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def no_snap(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @no_snap.setter
    def no_snap(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def no_quick_drag(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @no_quick_drag.setter
    def no_quick_drag(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def next_coordinate_ix(self) -> int:
        raise NotImplementedError()
    

class GeomCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Geom) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Geom) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Geom:
        raise NotImplementedError()
    

class GlowEffect:
    
    @property
    def size(self) -> float:
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : float) -> None:
        raise NotImplementedError()
    

class GlueType:
    
    def __init__(self, value : aspose.diagram.GlueTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.GlueTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.GlueTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class GradientFill:
    
    @property
    def gradient_stops(self) -> aspose.diagram.GradientStopCollection:
        raise NotImplementedError()
    
    @property
    def gradient_dir(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @gradient_dir.setter
    def gradient_dir(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def gradient_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @gradient_angle.setter
    def gradient_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def gradient_enabled(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @gradient_enabled.setter
    def gradient_enabled(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    

class GradientStop:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def position(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def transparency(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class GradientStopCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, position : aspose.diagram.DoubleValue, color : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.GradientStop:
        raise NotImplementedError()
    
    def __setitem__(self, key : int, value : aspose.diagram.GradientStop):
        raise NotImplementedError()
    

class GridDensity:
    
    def __init__(self, value : aspose.diagram.GridDensityValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.GridDensityValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.GridDensityValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Group:
    
    @property
    def select_mode(self) -> aspose.diagram.SelectMode:
        raise NotImplementedError()
    
    @select_mode.setter
    def select_mode(self, value : aspose.diagram.SelectMode) -> None:
        raise NotImplementedError()
    
    @property
    def display_mode(self) -> aspose.diagram.DisplayMode:
        raise NotImplementedError()
    
    @display_mode.setter
    def display_mode(self, value : aspose.diagram.DisplayMode) -> None:
        raise NotImplementedError()
    
    @property
    def is_drop_target(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @is_drop_target.setter
    def is_drop_target(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def is_snap_target(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @is_snap_target.setter
    def is_snap_target(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def is_text_edit_target(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @is_text_edit_target.setter
    def is_text_edit_target(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def dont_move_children(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @dont_move_children.setter
    def dont_move_children(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    

class HeaderFooter:
    
    @property
    def header_margin(self) -> aspose.diagram.Margin:
        raise NotImplementedError()
    
    @header_margin.setter
    def header_margin(self, value : aspose.diagram.Margin) -> None:
        raise NotImplementedError()
    
    @property
    def footer_margin(self) -> aspose.diagram.Margin:
        raise NotImplementedError()
    
    @footer_margin.setter
    def footer_margin(self, value : aspose.diagram.Margin) -> None:
        raise NotImplementedError()
    
    @property
    def header_footer_color(self) -> aspose.pydrawing.Color:
        raise NotImplementedError()
    
    @header_footer_color.setter
    def header_footer_color(self, value : aspose.pydrawing.Color) -> None:
        raise NotImplementedError()
    
    @property
    def header_left(self) -> str:
        raise NotImplementedError()
    
    @header_left.setter
    def header_left(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def header_center(self) -> str:
        raise NotImplementedError()
    
    @header_center.setter
    def header_center(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def header_right(self) -> str:
        raise NotImplementedError()
    
    @header_right.setter
    def header_right(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def footer_left(self) -> str:
        raise NotImplementedError()
    
    @footer_left.setter
    def footer_left(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def footer_center(self) -> str:
        raise NotImplementedError()
    
    @footer_center.setter
    def footer_center(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def footer_right(self) -> str:
        raise NotImplementedError()
    
    @footer_right.setter
    def footer_right(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def header_footer_font(self) -> aspose.diagram.HeaderFooterFont:
        raise NotImplementedError()
    

class HeaderFooterFont:
    
    @property
    def height(self) -> int:
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def escapement(self) -> int:
        raise NotImplementedError()
    
    @escapement.setter
    def escapement(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def orientation(self) -> int:
        raise NotImplementedError()
    
    @orientation.setter
    def orientation(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def weight(self) -> int:
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def italic(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @italic.setter
    def italic(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def underline(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @underline.setter
    def underline(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def strike_out(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @strike_out.setter
    def strike_out(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def char_set(self) -> int:
        raise NotImplementedError()
    
    @char_set.setter
    def char_set(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def out_precision(self) -> int:
        raise NotImplementedError()
    
    @out_precision.setter
    def out_precision(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def clip_precision(self) -> int:
        raise NotImplementedError()
    
    @clip_precision.setter
    def clip_precision(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def quality(self) -> int:
        raise NotImplementedError()
    
    @quality.setter
    def quality(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def pitch_and_family(self) -> int:
        raise NotImplementedError()
    
    @pitch_and_family.setter
    def pitch_and_family(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def face_name(self) -> str:
        raise NotImplementedError()
    
    @face_name.setter
    def face_name(self, value : str) -> None:
        raise NotImplementedError()
    

class Help:
    
    @property
    def help_topic(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def copyright(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    

class HorzAlign:
    
    def __init__(self, value : aspose.diagram.HorzAlignValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.HorzAlignValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.HorzAlignValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Hyperlink:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def description(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def address(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def sub_address(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def extra_info(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def frame(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def new_window(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def default(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def invisible(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def sort_key(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    

class HyperlinkCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Hyperlink) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Hyperlink) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Hyperlink:
        raise NotImplementedError()
    

class IWarningCallback:
    '''Callback interface of warning.'''
    
    def warning(self, warning_info : aspose.diagram.WarningInfo) -> None:
        '''Our callback only needs to implement the "Warning" method.
        
        :param warning_info: warning info'''
        raise NotImplementedError()
    

class Image:
    
    @property
    def gamma(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def contrast(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def brightness(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def sharpen(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def blur(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def denoise(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def transparency(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class IndividualFontConfigs:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def set_font_folder(self, font_folder : str, recursive : bool) -> None:
        raise NotImplementedError()
    
    def set_font_folders(self, font_folders : List[str], recursive : bool) -> None:
        raise NotImplementedError()
    
    def set_font_sources(self, sources : List[aspose.diagram.FontSourceBase]) -> None:
        raise NotImplementedError()
    
    def get_font_sources(self) -> List[aspose.diagram.FontSourceBase]:
        raise NotImplementedError()
    

class InfiniteLine(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class InfiniteLineCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.InfiniteLine:
        raise NotImplementedError()
    

class IntValue:
    
    def __init__(self, value : int, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> int:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def is_themed(self) -> bool:
        raise NotImplementedError()
    
    @is_themed.setter
    def is_themed(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class InterruptMonitor(AbstractInterruptMonitor):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def interrupt(self) -> None:
        raise NotImplementedError()
    
    @property
    def is_interruption_requested(self) -> bool:
        raise NotImplementedError()
    

class Issue:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ignored(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @ignored.setter
    def ignored(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def issue_target(self) -> aspose.diagram.IssueTarget:
        raise NotImplementedError()
    
    @property
    def rule_info(self) -> aspose.diagram.RuleInfo:
        raise NotImplementedError()
    

class IssueCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, issue : aspose.diagram.Issue) -> int:
        raise NotImplementedError()
    
    def remove(self, issue : aspose.diagram.Issue) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Issue:
        raise NotImplementedError()
    

class IssueTarget:
    
    def __init__(self, page_id : int, shape_id : int) -> None:
        raise NotImplementedError()
    
    @property
    def page_id(self) -> int:
        raise NotImplementedError()
    
    @page_id.setter
    def page_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def shape_id(self) -> int:
        raise NotImplementedError()
    
    @shape_id.setter
    def shape_id(self, value : int) -> None:
        raise NotImplementedError()
    

class Layer:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @property
    def is_color_checked(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @is_color_checked.setter
    def is_color_checked(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def status(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def visible(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def print(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def active(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def snap(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def glue(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def name_univ(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def color_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class LayerCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Layer) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Layer) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Layer:
        raise NotImplementedError()
    

class LayerMem:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def layer_member(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    

class Layout:
    
    @property
    def shape_place_style(self) -> aspose.diagram.ShapePlaceStyle:
        raise NotImplementedError()
    
    @shape_place_style.setter
    def shape_place_style(self, value : aspose.diagram.ShapePlaceStyle) -> None:
        raise NotImplementedError()
    
    @property
    def shape_permeable_x(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def shape_permeable_y(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def shape_permeable_place(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def shape_fixed_code(self) -> aspose.diagram.ShapeFixedCode:
        raise NotImplementedError()
    
    @property
    def shape_plow_code(self) -> aspose.diagram.ShapePlowCode:
        raise NotImplementedError()
    
    @property
    def shape_route_style(self) -> aspose.diagram.ShapeRouteStyle:
        raise NotImplementedError()
    
    @property
    def con_fixed_code(self) -> aspose.diagram.ConFixedCode:
        raise NotImplementedError()
    
    @property
    def con_line_jump_code(self) -> aspose.diagram.ConLineJumpCode:
        raise NotImplementedError()
    
    @property
    def con_line_jump_style(self) -> aspose.diagram.ConLineJumpStyle:
        raise NotImplementedError()
    
    @property
    def con_line_jump_dir_x(self) -> aspose.diagram.ConLineJumpDirX:
        raise NotImplementedError()
    
    @property
    def con_line_jump_dir_y(self) -> aspose.diagram.ConLineJumpDirY:
        raise NotImplementedError()
    
    @property
    def shape_place_flip(self) -> aspose.diagram.ShapePlaceFlip:
        raise NotImplementedError()
    
    @property
    def con_line_route_ext(self) -> aspose.diagram.ConLineRouteExt:
        raise NotImplementedError()
    
    @property
    def shape_split(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def shape_splittable(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def relationships(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def display_level(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    

class License:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def set_license(self, license_name : str) -> None:
        raise NotImplementedError()
    
    @overload
    def set_license(self, stream : io._IOBase) -> None:
        raise NotImplementedError()
    

class Line:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def line_weight(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @line_weight.setter
    def line_weight(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def gradient_line(self) -> aspose.diagram.GradientFill:
        raise NotImplementedError()
    
    @property
    def line_color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @line_color.setter
    def line_color(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def compound_type(self) -> aspose.diagram.CompoundType:
        raise NotImplementedError()
    
    @compound_type.setter
    def compound_type(self, value : aspose.diagram.CompoundType) -> None:
        raise NotImplementedError()
    
    @property
    def line_pattern(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @line_pattern.setter
    def line_pattern(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def rounding(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @rounding.setter
    def rounding(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def end_arrow_size(self) -> aspose.diagram.ArrowSize:
        raise NotImplementedError()
    
    @end_arrow_size.setter
    def end_arrow_size(self, value : aspose.diagram.ArrowSize) -> None:
        raise NotImplementedError()
    
    @property
    def begin_arrow(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @begin_arrow.setter
    def begin_arrow(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def end_arrow(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @end_arrow.setter
    def end_arrow(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def line_cap(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @line_cap.setter
    def line_cap(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def begin_arrow_size(self) -> aspose.diagram.ArrowSize:
        raise NotImplementedError()
    
    @begin_arrow_size.setter
    def begin_arrow_size(self, value : aspose.diagram.ArrowSize) -> None:
        raise NotImplementedError()
    
    @property
    def line_color_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @line_color_trans.setter
    def line_color_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class LineAdjustFrom:
    
    def __init__(self, value : aspose.diagram.LineAdjustFromValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.LineAdjustFromValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.LineAdjustFromValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class LineAdjustTo:
    
    def __init__(self, value : aspose.diagram.LineAdjustToValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.LineAdjustToValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.LineAdjustToValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class LineJumpCode:
    
    def __init__(self, value : aspose.diagram.LineJumpCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.LineJumpCodeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.LineJumpCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class LineJumpStyle:
    
    def __init__(self, value : aspose.diagram.LineJumpStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.LineJumpStyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.LineJumpStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class LineRouteExt:
    
    def __init__(self, value : aspose.diagram.LineRouteExtValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.LineRouteExtValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.LineRouteExtValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class LineTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class LineToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.LineTo:
        raise NotImplementedError()
    

class LoadFilter:
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, opts : aspose.diagram.LoadDataFilterOptions) -> None:
        raise NotImplementedError()
    
    @property
    def load_data_filter_options(self) -> aspose.diagram.LoadDataFilterOptions:
        raise NotImplementedError()
    
    @load_data_filter_options.setter
    def load_data_filter_options(self, value : aspose.diagram.LoadDataFilterOptions) -> None:
        raise NotImplementedError()
    

class LoadOptions:
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, format : aspose.diagram.LoadFileFormat) -> None:
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.diagram.LoadFileFormat:
        raise NotImplementedError()
    
    @load_format.setter
    def load_format(self, value : aspose.diagram.LoadFileFormat) -> None:
        raise NotImplementedError()
    
    @property
    def pages(self) -> List[Any]:
        raise NotImplementedError()
    
    @pages.setter
    def pages(self, value : List[Any]) -> None:
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.diagram.LoadFilter:
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.diagram.LoadFilter) -> None:
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.diagram.AbstractInterruptMonitor:
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.diagram.AbstractInterruptMonitor) -> None:
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.diagram.IndividualFontConfigs:
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.diagram.IndividualFontConfigs) -> None:
        raise NotImplementedError()
    

class LocalizeFont:
    
    def __init__(self, value : aspose.diagram.LocalizeFontValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.LocalizeFontValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.LocalizeFontValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class Margin:
    
    def __init__(self, value : float, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    @property
    def unit(self) -> aspose.diagram.MeasureConst:
        raise NotImplementedError()
    
    @unit.setter
    def unit(self, value : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> float:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : float) -> None:
        raise NotImplementedError()
    

class Master:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def base_id(self) -> UUID:
        raise NotImplementedError()
    
    @base_id.setter
    def base_id(self, value : UUID) -> None:
        raise NotImplementedError()
    
    @property
    def unique_id(self) -> UUID:
        raise NotImplementedError()
    
    @unique_id.setter
    def unique_id(self, value : UUID) -> None:
        raise NotImplementedError()
    
    @property
    def match_by_name(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @match_by_name.setter
    def match_by_name(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def icon_size(self) -> aspose.diagram.IconSizeValue:
        raise NotImplementedError()
    
    @icon_size.setter
    def icon_size(self, value : aspose.diagram.IconSizeValue) -> None:
        raise NotImplementedError()
    
    @property
    def pattern_flags(self) -> int:
        raise NotImplementedError()
    
    @pattern_flags.setter
    def pattern_flags(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def prompt(self) -> str:
        raise NotImplementedError()
    
    @prompt.setter
    def prompt(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def hidden(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @hidden.setter
    def hidden(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def icon_update(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @icon_update.setter
    def icon_update(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def align_name(self) -> aspose.diagram.AlignNameValue:
        raise NotImplementedError()
    
    @align_name.setter
    def align_name(self, value : aspose.diagram.AlignNameValue) -> None:
        raise NotImplementedError()
    
    @property
    def shapes(self) -> aspose.diagram.ShapeCollection:
        raise NotImplementedError()
    
    @property
    def connects(self) -> aspose.diagram.ConnectCollection:
        raise NotImplementedError()
    
    @property
    def icon(self) -> List[int]:
        raise NotImplementedError()
    
    @icon.setter
    def icon(self, value : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def page_sheet(self) -> aspose.diagram.PageSheet:
        raise NotImplementedError()
    

class MasterCollection(Collection):
    
    @overload
    def is_exist(self, name : str) -> bool:
        raise NotImplementedError()
    
    @overload
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, master : aspose.diagram.Master) -> int:
        raise NotImplementedError()
    
    def remove(self, master : aspose.diagram.Master) -> None:
        raise NotImplementedError()
    
    def get_master(self, id : int) -> aspose.diagram.Master:
        raise NotImplementedError()
    
    def get_master_by_name(self, name : str) -> aspose.diagram.Master:
        raise NotImplementedError()
    
    def get_max_rel_id(self) -> int:
        raise NotImplementedError()
    
    def is_exist_rel_id(self, rel_id : str) -> bool:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def master_shortcuts(self) -> aspose.diagram.MasterShortcutCollection:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Master:
        raise NotImplementedError()
    

class MasterShortcut:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def icon_size(self) -> aspose.diagram.IconSizeValue:
        raise NotImplementedError()
    
    @icon_size.setter
    def icon_size(self, value : aspose.diagram.IconSizeValue) -> None:
        raise NotImplementedError()
    
    @property
    def pattern_flags(self) -> int:
        raise NotImplementedError()
    
    @pattern_flags.setter
    def pattern_flags(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def prompt(self) -> str:
        raise NotImplementedError()
    
    @prompt.setter
    def prompt(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def shortcut_url(self) -> str:
        raise NotImplementedError()
    
    @shortcut_url.setter
    def shortcut_url(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def shortcut_help(self) -> str:
        raise NotImplementedError()
    
    @shortcut_help.setter
    def shortcut_help(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def align_name(self) -> aspose.diagram.AlignNameValue:
        raise NotImplementedError()
    
    @align_name.setter
    def align_name(self, value : aspose.diagram.AlignNameValue) -> None:
        raise NotImplementedError()
    
    @property
    def icon(self) -> List[int]:
        raise NotImplementedError()
    
    @icon.setter
    def icon(self, value : List[int]) -> None:
        raise NotImplementedError()
    

class MasterShortcutCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, master_shortcut : aspose.diagram.MasterShortcut) -> int:
        raise NotImplementedError()
    
    def remove(self, master_shortcut : aspose.diagram.MasterShortcut) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.MasterShortcut:
        raise NotImplementedError()
    

class MemoryFontSource(FontSourceBase):
    
    def __init__(self, font_data : List[int]) -> None:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.FontSourceType:
        raise NotImplementedError()
    
    @property
    def font_data(self) -> List[int]:
        raise NotImplementedError()
    

class Metered:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def set_metered_key(self, public_key : str, private_key : str) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def get_consumption_quantity() -> float:
        raise NotImplementedError()
    
    @staticmethod
    def get_consumption_credit() -> float:
        raise NotImplementedError()
    
    def get_product_name(self) -> str:
        raise NotImplementedError()
    
    @staticmethod
    def is_metered_licensed() -> bool:
        raise NotImplementedError()
    

class MilestoneHelper:
    
    def __init__(self, shape : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    def refresh_milestone(self, timeline : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @property
    def milestone_date(self) -> datetime:
        raise NotImplementedError()
    
    @milestone_date.setter
    def milestone_date(self, value : datetime) -> None:
        raise NotImplementedError()
    

class Misc:
    
    @property
    def no_obj_handles(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def non_printing(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def no_ctl_handles(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def no_align_box(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def update_align_box(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def hide_text(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def dyn_feedback(self) -> aspose.diagram.DynFeedback:
        raise NotImplementedError()
    
    @property
    def glue_type(self) -> aspose.diagram.GlueType:
        raise NotImplementedError()
    
    @property
    def walk_preference(self) -> aspose.diagram.WalkPreference:
        raise NotImplementedError()
    
    @property
    def beg_trigger(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def end_trigger(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def obj_type(self) -> aspose.diagram.ObjType:
        raise NotImplementedError()
    
    @property
    def comment(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def is_drop_source(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def is_replace_lock_shape_data(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def no_live_dynamics(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def localize_merge(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def calendar(self) -> aspose.diagram.Calendar:
        raise NotImplementedError()
    
    @property
    def lang_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def shape_keywords(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def drop_on_page_scale(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class MoveTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class MoveToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.MoveTo:
        raise NotImplementedError()
    

class NURBSTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def e(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @e.setter
    def e(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    

class NURBSToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.NURBSTo:
        raise NotImplementedError()
    

class ObjType:
    
    def __init__(self, value : aspose.diagram.ObjTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ObjTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ObjTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ObjectKind:
    
    def __init__(self, value : aspose.diagram.ObjectKindValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ObjectKindValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ObjectKindValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class OutputFormat:
    
    def __init__(self, value : aspose.diagram.OutputFormatValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.OutputFormatValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.OutputFormatValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Page:
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, pin_x : float, pin_y : float, master_name : str) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, pin_x : float, pin_y : float, width : float, height : float, master_name : str) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, pin_x : float, pin_y : float, width : float, height : float, image_stream : io._IOBase, object_data_stream : io._IOBase) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, pin_x : float, pin_y : float, width : float, height : float, stream : io._IOBase) -> int:
        raise NotImplementedError()
    
    @overload
    def add_shape(self, new_shape : aspose.diagram.Shape, master_name : str) -> int:
        raise NotImplementedError()
    
    @overload
    def connect_shapes_via_connector(self, shape_from : aspose.diagram.Shape, place_from : aspose.diagram.manipulation.ConnectionPointPlace, shape_to : aspose.diagram.Shape, place_to : aspose.diagram.manipulation.ConnectionPointPlace, connector : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @overload
    def connect_shapes_via_connector(self, shape_from_id : int, place_from : aspose.diagram.manipulation.ConnectionPointPlace, shape_to_id : int, place_to : aspose.diagram.manipulation.ConnectionPointPlace, connector_id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def connect_shapes_via_connector(self, shape_from_id : int, from_connection_name : str, shape_to_id : int, to_connection_name : str, connector_id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def connect_shapes_via_connector_index(self, shape_from_id : int, from_index : int, shape_to_id : int, to_index : int, connector_id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def connect_shapes_via_connector_index(self, shape_from : aspose.diagram.Shape, from_index : int, shape_to : aspose.diagram.Shape, to_index : int, connector : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @overload
    def glue_shapes(self, shape_from : aspose.diagram.Shape, place_to : aspose.diagram.manipulation.ConnectionPointPlace, shape_to : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @overload
    def glue_shapes(self, shape_from_id : int, place_to : aspose.diagram.manipulation.ConnectionPointPlace, shape_to_id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def glue_shapes_in_container(self, shape_from_id : int, shape_to_begin_connection_name : str, shape_to_end_connection_name : str, shape_to_id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def glue_shapes_in_container(self, shape_from_id : int, shape_to_begin_connection_index : int, shape_to_end_connection_index : int, shape_to_id : int) -> None:
        raise NotImplementedError()
    
    @overload
    def add_comment(self, shape_id : int, comment : str) -> None:
        raise NotImplementedError()
    
    @overload
    def add_comment(self, shape : aspose.diagram.Shape, comment : str) -> None:
        raise NotImplementedError()
    
    @overload
    def add_comment(self, pin_x : float, pin_y : float, comment : str) -> None:
        raise NotImplementedError()
    
    @overload
    def add_text(self, pin_x : float, pin_y : float, width : float, height : float, text : str, font_name : str, font_color : str, size : float) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @overload
    def add_text(self, pin_x : float, pin_y : float, width : float, height : float, text : str) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @overload
    def draw_line(self, begin_x : float, begin_y : float, end_x : float, end_y : float) -> int:
        raise NotImplementedError()
    
    @overload
    def draw_line(self, pin_x : float, pin_y : float, width : float, height : float, xy_array : List[float]) -> int:
        raise NotImplementedError()
    
    @overload
    def draw_line(self, pin_x : float, pin_y : float, width : float, height : float, points : List[Any]) -> int:
        raise NotImplementedError()
    
    @overload
    def draw_polyline(self, pin_x : float, pin_y : float, width : float, height : float, xy_array : List[float]) -> int:
        raise NotImplementedError()
    
    @overload
    def draw_polyline(self, pin_x : float, pin_y : float, width : float, height : float, points : List[Any]) -> int:
        raise NotImplementedError()
    
    def center_drawing(self) -> None:
        raise NotImplementedError()
    
    def copy(self, source : aspose.diagram.Page) -> None:
        raise NotImplementedError()
    
    def apply_style(self, text_style : int, line_style : int, fill_style : int) -> None:
        raise NotImplementedError()
    
    def move_to(self, index : int) -> None:
        raise NotImplementedError()
    
    def add_active_x_control(self, type : aspose.diagram.activexcontrols.ControlType, pin_x : float, pin_y : float, width : float, height : float) -> int:
        raise NotImplementedError()
    
    def layout(self, options : aspose.diagram.autolayout.LayoutOptions) -> None:
        raise NotImplementedError()
    
    def glue_shape_to_connector_begin_x(self, shape_from_id : int, connection_name : str, connector_id : int) -> None:
        raise NotImplementedError()
    
    def glue_shape_to_connector_end_x(self, shape_to_id : int, connection_name : str, connector_id : int) -> None:
        raise NotImplementedError()
    
    def glue_shapes_in_container_by_id(self, shape_from_id : int, shape_to_begin_connection_id : int, shape_to_end_connection_id : int, shape_to_id : int) -> None:
        raise NotImplementedError()
    
    def bring_forward(self, shape_id : int) -> None:
        raise NotImplementedError()
    
    def send_backward(self, shape_id : int) -> None:
        raise NotImplementedError()
    
    def bring_to_front(self, shape_id : int) -> None:
        raise NotImplementedError()
    
    def send_to_back(self, shape_id : int) -> None:
        raise NotImplementedError()
    
    def auto_space_shapes(self, shapes : aspose.diagram.ShapeCollection, options : aspose.diagram.AutoSpaceOptions) -> None:
        raise NotImplementedError()
    
    def draw_rectangle(self, pin_x : float, pin_y : float, width : float, height : float) -> int:
        raise NotImplementedError()
    
    def draw_ellipse(self, pin_x : float, pin_y : float, width : float, height : float) -> int:
        raise NotImplementedError()
    
    def draw_bezier(self, pin_x : float, pin_y : float, width : float, height : float, points : List[Any]) -> int:
        raise NotImplementedError()
    
    def draw_spline(self, pin_x : float, pin_y : float, width : float, height : float, points : List[Any]) -> int:
        raise NotImplementedError()
    
    @property
    def pages(self) -> aspose.diagram.PageCollection:
        raise NotImplementedError()
    
    @pages.setter
    def pages(self, value : aspose.diagram.PageCollection) -> None:
        raise NotImplementedError()
    
    @property
    def shapes(self) -> aspose.diagram.ShapeCollection:
        raise NotImplementedError()
    
    @property
    def page_sheet(self) -> aspose.diagram.PageSheet:
        raise NotImplementedError()
    
    @property
    def connects(self) -> aspose.diagram.ConnectCollection:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def back_page(self) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    @back_page.setter
    def back_page(self, value : aspose.diagram.Page) -> None:
        raise NotImplementedError()
    
    @property
    def view_scale(self) -> float:
        raise NotImplementedError()
    
    @view_scale.setter
    def view_scale(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def view_center_x(self) -> float:
        raise NotImplementedError()
    
    @view_center_x.setter
    def view_center_x(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def view_center_y(self) -> float:
        raise NotImplementedError()
    
    @view_center_y.setter
    def view_center_y(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def reviewer_id(self) -> int:
        raise NotImplementedError()
    
    @reviewer_id.setter
    def reviewer_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def associated_page(self) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    @associated_page.setter
    def associated_page(self, value : aspose.diagram.Page) -> None:
        raise NotImplementedError()
    

class PageCollection(Collection):
    
    @overload
    def get_page(self, id : int) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    @overload
    def get_page(self, name : str) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, page : aspose.diagram.Page) -> int:
        raise NotImplementedError()
    
    def remove(self, page : aspose.diagram.Page) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Page:
        raise NotImplementedError()
    

class PageLayout:
    
    @property
    def resize_page(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def enable_grid(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def dynamics_off(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def ctrl_as_input(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def avoid_page_breaks(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def place_style(self) -> aspose.diagram.PlaceStyle:
        raise NotImplementedError()
    
    @property
    def route_style(self) -> aspose.diagram.RouteStyle:
        raise NotImplementedError()
    
    @property
    def place_depth(self) -> aspose.diagram.PlaceDepth:
        raise NotImplementedError()
    
    @property
    def plow_code(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def line_jump_code(self) -> aspose.diagram.LineJumpCode:
        raise NotImplementedError()
    
    @property
    def line_jump_style(self) -> aspose.diagram.LineJumpStyle:
        raise NotImplementedError()
    
    @property
    def page_line_jump_dir_x(self) -> aspose.diagram.PageLineJumpDirX:
        raise NotImplementedError()
    
    @property
    def page_line_jump_dir_y(self) -> aspose.diagram.PageLineJumpDirY:
        raise NotImplementedError()
    
    @property
    def line_to_node_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def line_to_node_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def block_size_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def block_size_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def avenue_size_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def avenue_size_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def line_to_line_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def line_to_line_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def line_jump_factor_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def line_jump_factor_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def line_adjust_from(self) -> aspose.diagram.LineAdjustFrom:
        raise NotImplementedError()
    
    @property
    def line_adjust_to(self) -> aspose.diagram.LineAdjustTo:
        raise NotImplementedError()
    
    @property
    def place_flip(self) -> aspose.diagram.PlaceFlip:
        raise NotImplementedError()
    
    @property
    def line_route_ext(self) -> aspose.diagram.LineRouteExt:
        raise NotImplementedError()
    
    @property
    def page_shape_split(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    

class PageLineJumpDirX:
    
    def __init__(self, value : aspose.diagram.PageLineJumpDirXValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PageLineJumpDirXValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PageLineJumpDirXValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PageLineJumpDirY:
    
    def __init__(self, value : aspose.diagram.PageLineJumpDirYValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PageLineJumpDirYValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PageLineJumpDirYValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PageProps:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def page_width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def page_height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def shdw_offset_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def shdw_offset_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def page_scale(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def drawing_scale(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def drawing_size_type(self) -> aspose.diagram.DrawingSizeType:
        raise NotImplementedError()
    
    @property
    def drawing_scale_type(self) -> aspose.diagram.DrawingScaleType:
        raise NotImplementedError()
    
    @property
    def inhibit_snap(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def ui_visibility(self) -> aspose.diagram.UIVisibility:
        raise NotImplementedError()
    
    @property
    def shdw_type(self) -> aspose.diagram.ShdwType:
        raise NotImplementedError()
    
    @property
    def shdw_oblique_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def shdw_scale_factor(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def drawing_resize_type(self) -> aspose.diagram.DrawingResizeType:
        raise NotImplementedError()
    

class PageSheet:
    
    def copy(self, source : aspose.diagram.PageSheet) -> None:
        raise NotImplementedError()
    
    @property
    def line_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @line_style.setter
    def line_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def fill_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @fill_style.setter
    def fill_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def text_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @text_style.setter
    def text_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def unique_id(self) -> UUID:
        raise NotImplementedError()
    
    @unique_id.setter
    def unique_id(self, value : UUID) -> None:
        raise NotImplementedError()
    
    @property
    def x_form(self) -> aspose.diagram.XForm:
        raise NotImplementedError()
    
    @property
    def page_props(self) -> aspose.diagram.PageProps:
        raise NotImplementedError()
    
    @property
    def ruler_grid(self) -> aspose.diagram.RulerGrid:
        raise NotImplementedError()
    
    @property
    def page_layout(self) -> aspose.diagram.PageLayout:
        raise NotImplementedError()
    
    @property
    def print_props(self) -> aspose.diagram.PrintProps:
        raise NotImplementedError()
    
    @property
    def scratchs(self) -> aspose.diagram.ScratchCollection:
        raise NotImplementedError()
    
    @property
    def connections(self) -> aspose.diagram.ConnectionCollection:
        raise NotImplementedError()
    
    @property
    def connection_abc_ds(self) -> aspose.diagram.ConnectionABCDCollection:
        raise NotImplementedError()
    
    @property
    def acts(self) -> aspose.diagram.ActCollection:
        raise NotImplementedError()
    
    @property
    def layers(self) -> aspose.diagram.LayerCollection:
        raise NotImplementedError()
    
    @property
    def users(self) -> aspose.diagram.UserCollection:
        raise NotImplementedError()
    
    @property
    def props(self) -> aspose.diagram.PropCollection:
        raise NotImplementedError()
    
    @property
    def hyperlinks(self) -> aspose.diagram.HyperlinkCollection:
        raise NotImplementedError()
    
    @property
    def smart_tag_defs(self) -> aspose.diagram.SmartTagDefCollection:
        raise NotImplementedError()
    
    @property
    def annotations(self) -> aspose.diagram.AnnotationCollection:
        raise NotImplementedError()
    
    @property
    def foreign(self) -> aspose.diagram.Foreign:
        raise NotImplementedError()
    
    @property
    def foreign_data(self) -> aspose.diagram.ForeignData:
        raise NotImplementedError()
    

class Para:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def ind_first(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @ind_first.setter
    def ind_first(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ind_left(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @ind_left.setter
    def ind_left(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ind_right(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @ind_right.setter
    def ind_right(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def sp_line(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @sp_line.setter
    def sp_line(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def sp_before(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @sp_before.setter
    def sp_before(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def sp_after(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @sp_after.setter
    def sp_after(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def horz_align(self) -> aspose.diagram.HorzAlign:
        raise NotImplementedError()
    
    @horz_align.setter
    def horz_align(self, value : aspose.diagram.HorzAlign) -> None:
        raise NotImplementedError()
    
    @property
    def bullet(self) -> aspose.diagram.Bullet:
        raise NotImplementedError()
    
    @bullet.setter
    def bullet(self, value : aspose.diagram.Bullet) -> None:
        raise NotImplementedError()
    
    @property
    def bullet_str(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @bullet_str.setter
    def bullet_str(self, value : aspose.diagram.Str2Value) -> None:
        raise NotImplementedError()
    
    @property
    def bullet_font(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @bullet_font.setter
    def bullet_font(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    
    @property
    def localize_bullet_font(self) -> aspose.diagram.LocalizeFont:
        raise NotImplementedError()
    
    @localize_bullet_font.setter
    def localize_bullet_font(self, value : aspose.diagram.LocalizeFont) -> None:
        raise NotImplementedError()
    
    @property
    def bullet_font_size(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bullet_font_size.setter
    def bullet_font_size(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def text_pos_after_bullet(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @text_pos_after_bullet.setter
    def text_pos_after_bullet(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def flags(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    

class ParaCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Para) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Para) -> None:
        raise NotImplementedError()
    
    def get_para(self, ix : int) -> aspose.diagram.Para:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Para:
        raise NotImplementedError()
    

class PlaceDepth:
    
    def __init__(self, value : aspose.diagram.PlaceDepthValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PlaceDepthValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PlaceDepthValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PlaceFlip:
    
    def __init__(self, value : aspose.diagram.PlaceFlipValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PlaceFlipValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PlaceFlipValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PlaceStyle:
    
    def __init__(self, value : aspose.diagram.PlaceStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PlaceStyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PlaceStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PolylineTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    

class PolylineToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.PolylineTo:
        raise NotImplementedError()
    

class Pos:
    
    def __init__(self, value : aspose.diagram.PosValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PosValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PosValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class Pp(FormatTxt):
    
    def __init__(self, ix : int) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    

class PreviewScope:
    
    def __init__(self, value : aspose.diagram.PreviewScopeValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PreviewScopeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PreviewScopeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PrintPageOrientation:
    
    def __init__(self, pp : aspose.diagram.PrintProps, value : aspose.diagram.PrintPageOrientationValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.PrintPageOrientationValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.PrintPageOrientationValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class PrintProps:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def page_left_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def page_right_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def page_top_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def page_bottom_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def scale_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def scale_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def pages_x(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def pages_y(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def center_x(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def center_y(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def on_page(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def print_grid(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def print_page_orientation(self) -> aspose.diagram.PrintPageOrientation:
        raise NotImplementedError()
    
    @property
    def paper_kind(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def paper_source(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    

class Prop:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> aspose.diagram.Prop:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def prompt(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def label(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def format(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @property
    def sort_key(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.TypeProp:
        raise NotImplementedError()
    
    @property
    def invisible(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def verify(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lang_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def calendar(self) -> aspose.diagram.Calendar:
        raise NotImplementedError()
    

class PropCollection(Collection):
    
    @overload
    def get_prop(self, id : int) -> aspose.diagram.Prop:
        raise NotImplementedError()
    
    @overload
    def get_prop(self, name : str) -> aspose.diagram.Prop:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Prop) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Prop) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Prop:
        raise NotImplementedError()
    

class Protection:
    
    @property
    def lock_width(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_height(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_move_x(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_move_y(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_aspect(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_delete(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_begin(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_end(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_rotate(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_crop(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_vtx_edit(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_text_edit(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_format(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_group(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_calc_wh(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_select(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_cust_prop(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_from_group_format(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_theme_colors(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def lock_theme_effects(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    

class RelCubBezTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class RelCubBezToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RelCubBezTo:
        raise NotImplementedError()
    

class RelEllipticalArcTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class RelEllipticalArcToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RelEllipticalArcTo:
        raise NotImplementedError()
    

class RelLineTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class RelLineToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RelLineTo:
        raise NotImplementedError()
    

class RelMoveTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class RelMoveToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RelMoveTo:
        raise NotImplementedError()
    

class RelQuadBezTo(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class RelQuadBezToCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RelQuadBezTo:
        raise NotImplementedError()
    

class RelationShape:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def shape(self) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @shape.setter
    def shape(self, value : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @property
    def flag(self) -> aspose.diagram.RelationFlag:
        raise NotImplementedError()
    
    @flag.setter
    def flag(self, value : aspose.diagram.RelationFlag) -> None:
        raise NotImplementedError()
    

class RelationShapeCollection(Collection):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, relation_shape : aspose.diagram.RelationShape) -> int:
        raise NotImplementedError()
    
    def remove(self, relation_shape : aspose.diagram.RelationShape) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RelationShape:
        raise NotImplementedError()
    

class ResizeMode:
    
    def __init__(self, value : aspose.diagram.ResizeModeValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ResizeModeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ResizeModeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class Reviewer:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def initials(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @property
    def reviewer_id(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @property
    def current_index(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    

class ReviewerCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Reviewer) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Reviewer) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Reviewer:
        raise NotImplementedError()
    

class RotationType:
    
    def __init__(self, value : aspose.diagram.RotationTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.RotationTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.RotationTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class RouteStyle:
    
    def __init__(self, value : aspose.diagram.RouteStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.RouteStyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.RouteStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Row:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def row_id(self) -> int:
        raise NotImplementedError()
    
    @row_id.setter
    def row_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def shape_id(self) -> int:
        raise NotImplementedError()
    
    @shape_id.setter
    def shape_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def page_id(self) -> int:
        raise NotImplementedError()
    
    @page_id.setter
    def page_id(self, value : int) -> None:
        raise NotImplementedError()
    

class RowCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, row : aspose.diagram.Row) -> int:
        raise NotImplementedError()
    
    def remove(self, row : aspose.diagram.Row) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Row:
        raise NotImplementedError()
    

class Rule:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def rule_filter(self) -> aspose.diagram.RuleValue:
        raise NotImplementedError()
    
    @rule_filter.setter
    def rule_filter(self, value : aspose.diagram.RuleValue) -> None:
        raise NotImplementedError()
    
    @property
    def rule_test(self) -> aspose.diagram.RuleValue:
        raise NotImplementedError()
    
    @rule_test.setter
    def rule_test(self, value : aspose.diagram.RuleValue) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def category(self) -> str:
        raise NotImplementedError()
    
    @category.setter
    def category(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def description(self) -> str:
        raise NotImplementedError()
    
    @description.setter
    def description(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def rule_target(self) -> aspose.diagram.VisRuleTargetsValue:
        raise NotImplementedError()
    
    @rule_target.setter
    def rule_target(self, value : aspose.diagram.VisRuleTargetsValue) -> None:
        raise NotImplementedError()
    
    @property
    def ignored(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @ignored.setter
    def ignored(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    

class RuleCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, rule : aspose.diagram.Rule) -> int:
        raise NotImplementedError()
    
    def remove(self, rule : aspose.diagram.Rule) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Rule:
        raise NotImplementedError()
    

class RuleInfo:
    
    def __init__(self, rule_set_id : int, rule_id : int) -> None:
        raise NotImplementedError()
    
    @property
    def rule_set_id(self) -> int:
        raise NotImplementedError()
    
    @rule_set_id.setter
    def rule_set_id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def rule_id(self) -> int:
        raise NotImplementedError()
    
    @rule_id.setter
    def rule_id(self, value : int) -> None:
        raise NotImplementedError()
    

class RuleSet:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def description(self) -> str:
        raise NotImplementedError()
    
    @description.setter
    def description(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def enabled(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @enabled.setter
    def enabled(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def rule_set_flags(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @rule_set_flags.setter
    def rule_set_flags(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def rules(self) -> aspose.diagram.RuleCollection:
        raise NotImplementedError()
    

class RuleSetCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, rule_set : aspose.diagram.RuleSet) -> int:
        raise NotImplementedError()
    
    def remove(self, rule_set : aspose.diagram.RuleSet) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.RuleSet:
        raise NotImplementedError()
    

class RuleValue:
    
    def __init__(self, formula : str, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def formula(self) -> str:
        raise NotImplementedError()
    
    @formula.setter
    def formula(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        raise NotImplementedError()
    

class RulerDensity:
    
    def __init__(self, value : aspose.diagram.RulerDensityValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.RulerDensityValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.RulerDensityValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class RulerGrid:
    
    @property
    def x_ruler_density(self) -> aspose.diagram.RulerDensity:
        raise NotImplementedError()
    
    @property
    def y_ruler_density(self) -> aspose.diagram.RulerDensity:
        raise NotImplementedError()
    
    @property
    def x_ruler_origin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def x_grid_density(self) -> aspose.diagram.GridDensity:
        raise NotImplementedError()
    
    @property
    def y_grid_density(self) -> aspose.diagram.GridDensity:
        raise NotImplementedError()
    
    @property
    def x_grid_spacing(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y_grid_spacing(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def x_grid_origin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y_grid_origin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y_ruler_origin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    

class Scratch:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.Value) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.Value) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.Value) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.Value) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class ScratchCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Scratch) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Scratch) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Scratch:
        raise NotImplementedError()
    

class SelectMode:
    
    def __init__(self, value : aspose.diagram.SelectModeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.SelectModeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.SelectModeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class Shape:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def to_pdf(self, file_name : str) -> None:
        raise NotImplementedError()
    
    @overload
    def to_pdf(self, stream : io._IOBase) -> None:
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.diagram.saving.ImageSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.diagram.saving.ImageSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def to_html(self, file_name : str, options : aspose.diagram.saving.HTMLSaveOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def to_html(self, stream : io._IOBase, options : aspose.diagram.saving.HTMLSaveOptions) -> None:
        raise NotImplementedError()
    
    def convert_to_group(self) -> None:
        raise NotImplementedError()
    
    def get_connectors_type(self) -> aspose.diagram.ConnectorsTypeValue:
        raise NotImplementedError()
    
    def set_connector_jump_value(self, code : aspose.diagram.ConLineJumpCodeValue, style : aspose.diagram.ConLineJumpStyleValue) -> None:
        raise NotImplementedError()
    
    def set_connectors_type(self, type : aspose.diagram.ConnectorsTypeValue) -> None:
        raise NotImplementedError()
    
    def get_relation_flag(self, shape : aspose.diagram.Shape) -> aspose.diagram.RelationFlag:
        raise NotImplementedError()
    
    def get_relation_shape_collection(self) -> aspose.diagram.RelationShapeCollection:
        raise NotImplementedError()
    
    def set_preset_theme_style_matrics(self, style_index : aspose.diagram.PresetStyleMatricsValue, color_index : aspose.diagram.PresetColorMatricsValue) -> None:
        raise NotImplementedError()
    
    def copy(self, source : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    def bring_forward(self) -> None:
        raise NotImplementedError()
    
    def send_backward(self) -> None:
        raise NotImplementedError()
    
    def bring_to_front(self) -> None:
        raise NotImplementedError()
    
    def send_to_back(self) -> None:
        raise NotImplementedError()
    
    def get_connector_rule(self) -> aspose.diagram.ConnectorRule:
        raise NotImplementedError()
    
    def connected_shapes(self, flag : aspose.diagram.ConnectedShapesFlags, category_filter : str) -> List[int]:
        raise NotImplementedError()
    
    def is_in_group(self) -> bool:
        raise NotImplementedError()
    
    def is_contain(self, shape : aspose.diagram.Shape) -> bool:
        raise NotImplementedError()
    
    def is_intersect(self, shape : aspose.diagram.Shape) -> bool:
        raise NotImplementedError()
    
    def is_connected(self, shape : aspose.diagram.Shape) -> bool:
        raise NotImplementedError()
    
    def center_drawing(self) -> None:
        raise NotImplementedError()
    
    def is_glued(self, shape : aspose.diagram.Shape) -> bool:
        raise NotImplementedError()
    
    def refresh_data(self) -> None:
        raise NotImplementedError()
    
    def glued_shapes(self, flag : aspose.diagram.GluedShapesFlags, category_filter : str, other_shape : aspose.diagram.Shape) -> List[int]:
        raise NotImplementedError()
    
    def depends_on_shapes(self) -> List[int]:
        raise NotImplementedError()
    
    def set_width(self, width : float) -> None:
        raise NotImplementedError()
    
    def set_height(self, height : float) -> None:
        raise NotImplementedError()
    
    def set_angle(self, angle : float) -> None:
        raise NotImplementedError()
    
    def move_to(self, new_pin_x : float, new_pin_y : float) -> None:
        raise NotImplementedError()
    
    def move(self, d_x : float, d_y : float) -> None:
        raise NotImplementedError()
    
    def get_display_text(self) -> str:
        raise NotImplementedError()
    
    def get_pure_text(self) -> str:
        raise NotImplementedError()
    
    def ungroup(self) -> None:
        raise NotImplementedError()
    
    def replace_text(self, text : str, replace_text : str) -> None:
        raise NotImplementedError()
    
    def to_svg(self, file_name : str, options : aspose.diagram.saving.SVGSaveOptions) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def unique_id(self) -> UUID:
        raise NotImplementedError()
    
    @unique_id.setter
    def unique_id(self, value : UUID) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.diagram.TypeValue:
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.diagram.TypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def line_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @line_style.setter
    def line_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def fill_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @fill_style.setter
    def fill_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def text_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @text_style.setter
    def text_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def shapes(self) -> aspose.diagram.ShapeCollection:
        raise NotImplementedError()
    
    @property
    def text(self) -> aspose.diagram.Text:
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : aspose.diagram.Text) -> None:
        raise NotImplementedError()
    
    @property
    def x_form(self) -> aspose.diagram.XForm:
        raise NotImplementedError()
    
    @x_form.setter
    def x_form(self, value : aspose.diagram.XForm) -> None:
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.diagram.Line:
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.diagram.Fill:
        raise NotImplementedError()
    
    @property
    def has_theme_color(self) -> bool:
        raise NotImplementedError()
    
    @property
    def inherit_chars(self) -> aspose.diagram.CharCollection:
        raise NotImplementedError()
    
    @property
    def inherit_props(self) -> aspose.diagram.PropCollection:
        raise NotImplementedError()
    
    @property
    def inherit_acts(self) -> aspose.diagram.ActCollection:
        raise NotImplementedError()
    
    @property
    def inherit_group(self) -> aspose.diagram.Group:
        raise NotImplementedError()
    
    @property
    def inherit_users(self) -> aspose.diagram.UserCollection:
        raise NotImplementedError()
    
    @property
    def inherit_geoms(self) -> aspose.diagram.GeomCollection:
        raise NotImplementedError()
    
    @property
    def inherit_paras(self) -> aspose.diagram.ParaCollection:
        raise NotImplementedError()
    
    @property
    def inherit_text_block(self) -> aspose.diagram.TextBlock:
        raise NotImplementedError()
    
    @property
    def inherit_line(self) -> aspose.diagram.Line:
        raise NotImplementedError()
    
    @property
    def inherit_fill(self) -> aspose.diagram.Fill:
        raise NotImplementedError()
    
    @property
    def x_form_1d(self) -> aspose.diagram.XForm1D:
        raise NotImplementedError()
    
    @x_form_1d.setter
    def x_form_1d(self, value : aspose.diagram.XForm1D) -> None:
        raise NotImplementedError()
    
    @property
    def event(self) -> aspose.diagram.Event:
        raise NotImplementedError()
    
    @event.setter
    def event(self, value : aspose.diagram.Event) -> None:
        raise NotImplementedError()
    
    @property
    def layer_mem(self) -> aspose.diagram.LayerMem:
        raise NotImplementedError()
    
    @property
    def foreign(self) -> aspose.diagram.Foreign:
        raise NotImplementedError()
    
    @property
    def text_block(self) -> aspose.diagram.TextBlock:
        raise NotImplementedError()
    
    @property
    def text_x_form(self) -> aspose.diagram.TextXForm:
        raise NotImplementedError()
    
    @property
    def align(self) -> aspose.diagram.Align:
        raise NotImplementedError()
    
    @property
    def protection(self) -> aspose.diagram.Protection:
        raise NotImplementedError()
    
    @property
    def help(self) -> aspose.diagram.Help:
        raise NotImplementedError()
    
    @property
    def misc(self) -> aspose.diagram.Misc:
        raise NotImplementedError()
    
    @property
    def image(self) -> aspose.diagram.Image:
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.diagram.Group:
        raise NotImplementedError()
    
    @property
    def layout(self) -> aspose.diagram.Layout:
        raise NotImplementedError()
    
    @property
    def chars(self) -> aspose.diagram.CharCollection:
        raise NotImplementedError()
    
    @property
    def paras(self) -> aspose.diagram.ParaCollection:
        raise NotImplementedError()
    
    @property
    def scratchs(self) -> aspose.diagram.ScratchCollection:
        raise NotImplementedError()
    
    @property
    def connections(self) -> aspose.diagram.ConnectionCollection:
        raise NotImplementedError()
    
    @property
    def connection_abc_ds(self) -> aspose.diagram.ConnectionABCDCollection:
        raise NotImplementedError()
    
    @property
    def fields(self) -> aspose.diagram.FieldCollection:
        raise NotImplementedError()
    
    @property
    def controls(self) -> aspose.diagram.ControlCollection:
        raise NotImplementedError()
    
    @property
    def geoms(self) -> aspose.diagram.GeomCollection:
        raise NotImplementedError()
    
    @property
    def acts(self) -> aspose.diagram.ActCollection:
        raise NotImplementedError()
    
    @property
    def users(self) -> aspose.diagram.UserCollection:
        raise NotImplementedError()
    
    @property
    def props(self) -> aspose.diagram.PropCollection:
        raise NotImplementedError()
    
    @props.setter
    def props(self, value : aspose.diagram.PropCollection) -> None:
        raise NotImplementedError()
    
    @property
    def hyperlinks(self) -> aspose.diagram.HyperlinkCollection:
        raise NotImplementedError()
    
    @property
    def smart_tag_defs(self) -> aspose.diagram.SmartTagDefCollection:
        raise NotImplementedError()
    
    @property
    def tabs_collection(self) -> aspose.diagram.TabsCollection:
        raise NotImplementedError()
    
    @property
    def data1(self) -> str:
        raise NotImplementedError()
    
    @data1.setter
    def data1(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def data2(self) -> str:
        raise NotImplementedError()
    
    @data2.setter
    def data2(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def data3(self) -> str:
        raise NotImplementedError()
    
    @data3.setter
    def data3(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def clipping_path(self) -> str:
        raise NotImplementedError()
    
    @clipping_path.setter
    def clipping_path(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def foreign_data(self) -> aspose.diagram.ForeignData:
        raise NotImplementedError()
    
    @property
    def master_shape(self) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @master_shape.setter
    def master_shape(self, value : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @property
    def master(self) -> aspose.diagram.Master:
        raise NotImplementedError()
    
    @master.setter
    def master(self, value : aspose.diagram.Master) -> None:
        raise NotImplementedError()
    
    @property
    def parent_shape(self) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @parent_shape.setter
    def parent_shape(self, value : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    @property
    def root_shape(self) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @property
    def diagram(self) -> aspose.diagram.Diagram:
        raise NotImplementedError()
    
    @diagram.setter
    def diagram(self, value : aspose.diagram.Diagram) -> None:
        raise NotImplementedError()
    
    @property
    def page(self) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    @page.setter
    def page(self, value : aspose.diagram.Page) -> None:
        raise NotImplementedError()
    
    @property
    def one_d(self) -> bool:
        raise NotImplementedError()
    
    @property
    def two_d(self) -> bool:
        raise NotImplementedError()
    
    @two_d.setter
    def two_d(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.diagram.activexcontrols.ActiveXControl:
        raise NotImplementedError()
    
    @property
    def z_order_index(self) -> int:
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.diagram.ThreeDFormat:
        raise NotImplementedError()
    

class ShapeCollection(Collection):
    
    @overload
    def get_shape(self, name : str) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @overload
    def get_shape(self, id : int) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @overload
    def get_shape_including_child(self, name : str) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @overload
    def get_shape_including_child(self, id : int) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Shape) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    def remove_depends_on(self, item : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    def un_group(self, group_shape : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    def group(self, group_items : List[aspose.diagram.Shape]) -> aspose.diagram.Shape:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Shape:
        raise NotImplementedError()
    

class ShapeFixedCode:
    
    def __init__(self, value : aspose.diagram.ShapeFixedCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapeFixedCodeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapeFixedCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShapePlaceFlip:
    
    def __init__(self, value : aspose.diagram.ShapePlaceFlipValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapePlaceFlipValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapePlaceFlipValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShapePlaceStyle:
    
    def __init__(self, value : aspose.diagram.ShapePlaceStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapePlaceStyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapePlaceStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShapePlowCode:
    
    def __init__(self, value : aspose.diagram.ShapePlowCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapePlowCodeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapePlowCodeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShapeRouteStyle:
    
    def __init__(self, value : aspose.diagram.ShapeRouteStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapeRouteStyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapeRouteStyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShapeShdwShow:
    
    def __init__(self, value : aspose.diagram.ShapeShdwShowValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapeShdwShowValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapeShdwShowValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShapeShdwType:
    
    def __init__(self, value : aspose.diagram.ShapeShdwTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShapeShdwTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShapeShdwTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class ShdwType:
    
    def __init__(self, value : aspose.diagram.ShdwTypeValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.ShdwTypeValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.ShdwTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class SmartTagDef:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @property
    def tag_name(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def x_justify(self) -> aspose.diagram.XJustify:
        raise NotImplementedError()
    
    @property
    def y_justify(self) -> aspose.diagram.YJustify:
        raise NotImplementedError()
    
    @property
    def display_mode(self) -> aspose.diagram.DisplayModeSmartTagDef:
        raise NotImplementedError()
    
    @property
    def button_face(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @property
    def disabled(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def description(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    

class SmartTagDefCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.SmartTagDef) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.SmartTagDef) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.SmartTagDef:
        raise NotImplementedError()
    

class SolutionXML:
    
    @overload
    def __init__(self, name : str, xml_value : str) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def xml_value(self) -> str:
        raise NotImplementedError()
    
    @xml_value.setter
    def xml_value(self, value : str) -> None:
        raise NotImplementedError()
    

class SolutionXMLCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, solution_xml : aspose.diagram.SolutionXML) -> int:
        raise NotImplementedError()
    
    def remove(self, solution_xml : aspose.diagram.SolutionXML) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.SolutionXML:
        raise NotImplementedError()
    

class SplineKnot(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class SplineKnotCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.SplineKnot:
        raise NotImplementedError()
    

class SplineStart(Coordinate):
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def a(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @a.setter
    def a(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def b(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @b.setter
    def b(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def c(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @c.setter
    def c(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def d(self) -> aspose.diagram.IntValue:
        raise NotImplementedError()
    
    @d.setter
    def d(self, value : aspose.diagram.IntValue) -> None:
        raise NotImplementedError()
    

class SplineStartCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.SplineStart:
        raise NotImplementedError()
    

class Str2Value(StrValue):
    
    @overload
    def __init__(self, value : str) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, value : str, ufev : aspose.diagram.UnitFormulaErrV) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    
    @property
    def ufev(self) -> aspose.diagram.UnitFormulaErrV:
        raise NotImplementedError()
    
    @ufev.setter
    def ufev(self, value : aspose.diagram.UnitFormulaErrV) -> None:
        raise NotImplementedError()
    

class StrValue:
    
    @overload
    def __init__(self, value : str) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, value : str, ufe : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self, value : str, unit : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class StreamProviderOptions:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def default_path(self) -> str:
        raise NotImplementedError()
    
    @property
    def stream(self) -> io._IOBase:
        raise NotImplementedError()
    
    @stream.setter
    def stream(self, value : io._IOBase) -> None:
        raise NotImplementedError()
    

class Style:
    
    def __init__(self, value : aspose.diagram.StyleValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.StyleValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.StyleValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class StyleProp:
    
    @property
    def enable_line_props(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def enable_fill_props(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def enable_text_props(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @property
    def hide_for_apply(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    

class StyleSheet:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def line_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @line_style.setter
    def line_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def fill_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @fill_style.setter
    def fill_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def text_style(self) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @text_style.setter
    def text_style(self, value : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.diagram.Line:
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.diagram.Fill:
        raise NotImplementedError()
    
    @property
    def event(self) -> aspose.diagram.Event:
        raise NotImplementedError()
    
    @property
    def style_prop(self) -> aspose.diagram.StyleProp:
        raise NotImplementedError()
    
    @property
    def text_block(self) -> aspose.diagram.TextBlock:
        raise NotImplementedError()
    
    @property
    def protection(self) -> aspose.diagram.Protection:
        raise NotImplementedError()
    
    @property
    def help(self) -> aspose.diagram.Help:
        raise NotImplementedError()
    
    @property
    def misc(self) -> aspose.diagram.Misc:
        raise NotImplementedError()
    
    @property
    def ruler_grid(self) -> aspose.diagram.RulerGrid:
        raise NotImplementedError()
    
    @property
    def image(self) -> aspose.diagram.Image:
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.diagram.Group:
        raise NotImplementedError()
    
    @property
    def layout(self) -> aspose.diagram.Layout:
        raise NotImplementedError()
    
    @property
    def page_layout(self) -> aspose.diagram.PageLayout:
        raise NotImplementedError()
    
    @property
    def chars(self) -> aspose.diagram.CharCollection:
        raise NotImplementedError()
    
    @property
    def paras(self) -> aspose.diagram.ParaCollection:
        raise NotImplementedError()
    
    @property
    def tabs_collection(self) -> aspose.diagram.TabsCollection:
        raise NotImplementedError()
    
    @property
    def connections(self) -> aspose.diagram.ConnectionCollection:
        raise NotImplementedError()
    
    @property
    def connection_abc_ds(self) -> aspose.diagram.ConnectionABCDCollection:
        raise NotImplementedError()
    
    @property
    def foreign(self) -> aspose.diagram.Foreign:
        raise NotImplementedError()
    
    @property
    def foreign_data(self) -> aspose.diagram.ForeignData:
        raise NotImplementedError()
    

class StyleSheetCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.StyleSheet) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.StyleSheet) -> None:
        raise NotImplementedError()
    
    def get_style_sheet(self, id : int) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.StyleSheet:
        raise NotImplementedError()
    

class Tab:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def position(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def alignment(self) -> aspose.diagram.Alignment:
        raise NotImplementedError()
    
    @alignment.setter
    def alignment(self, value : aspose.diagram.Alignment) -> None:
        raise NotImplementedError()
    
    @property
    def leader(self) -> aspose.diagram.StrValue:
        raise NotImplementedError()
    
    @leader.setter
    def leader(self, value : aspose.diagram.StrValue) -> None:
        raise NotImplementedError()
    

class TabCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Tab) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Tab) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def ix(self) -> int:
        raise NotImplementedError()
    
    @ix.setter
    def ix(self, value : int) -> None:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Tab:
        raise NotImplementedError()
    

class TabsCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.TabCollection) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.TabCollection) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.TabCollection:
        raise NotImplementedError()
    

class Text:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.FormatTxtCollection:
        raise NotImplementedError()
    

class TextBlock:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def left_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @left_margin.setter
    def left_margin(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def right_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @right_margin.setter
    def right_margin(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def top_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @top_margin.setter
    def top_margin(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bottom_margin(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bottom_margin.setter
    def bottom_margin(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def vertical_align(self) -> aspose.diagram.VerticalAlign:
        raise NotImplementedError()
    
    @vertical_align.setter
    def vertical_align(self, value : aspose.diagram.VerticalAlign) -> None:
        raise NotImplementedError()
    
    @property
    def text_bkgnd(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @text_bkgnd.setter
    def text_bkgnd(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def default_tab_stop(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @default_tab_stop.setter
    def default_tab_stop(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.diagram.TextDirection:
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.diagram.TextDirection) -> None:
        raise NotImplementedError()
    
    @property
    def text_bkgnd_trans(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @text_bkgnd_trans.setter
    def text_bkgnd_trans(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class TextCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.Text) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.Text) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Text:
        raise NotImplementedError()
    

class TextDirection:
    
    def __init__(self, value : aspose.diagram.TextDirectionValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.TextDirectionValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.TextDirectionValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class TextXForm:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def txt_pin_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_pin_x.setter
    def txt_pin_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def txt_pin_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_pin_y.setter
    def txt_pin_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def txt_width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_width.setter
    def txt_width(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def txt_height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_height.setter
    def txt_height(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def txt_loc_pin_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_loc_pin_x.setter
    def txt_loc_pin_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def txt_loc_pin_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_loc_pin_y.setter
    def txt_loc_pin_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def txt_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @txt_angle.setter
    def txt_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class ThreeDFormat:
    
    @property
    def bevel_bottom_height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_bottom_height.setter
    def bevel_bottom_height(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_bottom_type(self) -> aspose.diagram.BevelType:
        raise NotImplementedError()
    
    @bevel_bottom_type.setter
    def bevel_bottom_type(self, value : aspose.diagram.BevelType) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_bottom_width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_bottom_width.setter
    def bevel_bottom_width(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_contour_color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @bevel_contour_color.setter
    def bevel_contour_color(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_contour_size(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_contour_size.setter
    def bevel_contour_size(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_depth_color(self) -> aspose.diagram.ColorValue:
        raise NotImplementedError()
    
    @bevel_depth_color.setter
    def bevel_depth_color(self, value : aspose.diagram.ColorValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_depth_size(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_depth_size.setter
    def bevel_depth_size(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_lighting_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_lighting_angle.setter
    def bevel_lighting_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_lighting_type(self) -> aspose.diagram.BevelLightingType:
        raise NotImplementedError()
    
    @bevel_lighting_type.setter
    def bevel_lighting_type(self, value : aspose.diagram.BevelLightingType) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_material_type(self) -> aspose.diagram.BevelMaterialType:
        raise NotImplementedError()
    
    @bevel_material_type.setter
    def bevel_material_type(self, value : aspose.diagram.BevelMaterialType) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_top_height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_top_height.setter
    def bevel_top_height(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_top_width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @bevel_top_width.setter
    def bevel_top_width(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def bevel_top_type(self) -> aspose.diagram.BevelType:
        raise NotImplementedError()
    
    @bevel_top_type.setter
    def bevel_top_type(self, value : aspose.diagram.BevelType) -> None:
        raise NotImplementedError()
    
    @property
    def distance_from_ground(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @distance_from_ground.setter
    def distance_from_ground(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def perspective(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @perspective.setter
    def perspective(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def rotation_type(self) -> aspose.diagram.RotationType:
        raise NotImplementedError()
    
    @rotation_type.setter
    def rotation_type(self, value : aspose.diagram.RotationType) -> None:
        raise NotImplementedError()
    
    @property
    def rotation_x_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @rotation_x_angle.setter
    def rotation_x_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def rotation_y_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @rotation_y_angle.setter
    def rotation_y_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def rotation_z_angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @rotation_z_angle.setter
    def rotation_z_angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def keep_text_flat(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @keep_text_flat.setter
    def keep_text_flat(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    

class TimeLineHelper:
    
    def __init__(self, shape : aspose.diagram.Shape) -> None:
        raise NotImplementedError()
    
    def refresh_time_line(self) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def get_week_end(start_date : datetime, week_start : int) -> datetime:
        raise NotImplementedError()
    
    @staticmethod
    def get_double_string_from_date_time(date_time : datetime) -> str:
        raise NotImplementedError()
    
    @property
    def time_period_start(self) -> datetime:
        raise NotImplementedError()
    
    @time_period_start.setter
    def time_period_start(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def time_period_finish(self) -> datetime:
        raise NotImplementedError()
    
    @time_period_finish.setter
    def time_period_finish(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def time_scale(self) -> int:
        raise NotImplementedError()
    
    @time_scale.setter
    def time_scale(self, value : int) -> None:
        raise NotImplementedError()
    

class Tp(FormatTxt):
    
    def __init__(self, ix : int) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    

class Txt(FormatTxt):
    
    def __init__(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        raise NotImplementedError()
    

class TypeConnection:
    
    def __init__(self, value : aspose.diagram.TypeConnectionValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.TypeConnectionValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.TypeConnectionValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class TypeField:
    
    def __init__(self, value : aspose.diagram.TypeFieldValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.TypeFieldValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.TypeFieldValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class TypeProp:
    
    def __init__(self, value : aspose.diagram.TypePropValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.TypePropValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.TypePropValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class UIVisibility:
    
    def __init__(self, value : aspose.diagram.UIVisibilityValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.UIVisibilityValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.UIVisibilityValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class UnitFormulaErr:
    
    @overload
    def __init__(self, unit : aspose.diagram.MeasureConst, f : str, err : str) -> None:
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def unit(self) -> aspose.diagram.MeasureConst:
        raise NotImplementedError()
    
    @unit.setter
    def unit(self, value : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    @property
    def f(self) -> str:
        raise NotImplementedError()
    
    @f.setter
    def f(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def err(self) -> str:
        raise NotImplementedError()
    
    @err.setter
    def err(self, value : str) -> None:
        raise NotImplementedError()
    

class UnitFormulaErrV(UnitFormulaErr):
    
    def __init__(self, unit : aspose.diagram.MeasureConst, f : str, err : str, v : str) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def unit(self) -> aspose.diagram.MeasureConst:
        raise NotImplementedError()
    
    @unit.setter
    def unit(self, value : aspose.diagram.MeasureConst) -> None:
        raise NotImplementedError()
    
    @property
    def f(self) -> str:
        raise NotImplementedError()
    
    @f.setter
    def f(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def err(self) -> str:
        raise NotImplementedError()
    
    @err.setter
    def err(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def v(self) -> str:
        raise NotImplementedError()
    
    @v.setter
    def v(self, value : str) -> None:
        raise NotImplementedError()
    

class User:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.Value:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.Value) -> None:
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def name_u(self) -> str:
        raise NotImplementedError()
    
    @name_u.setter
    def name_u(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def prompt(self) -> aspose.diagram.Str2Value:
        raise NotImplementedError()
    
    @prompt.setter
    def prompt(self, value : aspose.diagram.Str2Value) -> None:
        raise NotImplementedError()
    

class UserCollection(Collection):
    
    @overload
    def get_user(self, name : str) -> aspose.diagram.User:
        raise NotImplementedError()
    
    @overload
    def get_user(self, id : int) -> aspose.diagram.User:
        raise NotImplementedError()
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, item : aspose.diagram.User) -> int:
        raise NotImplementedError()
    
    def remove(self, item : aspose.diagram.User) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.User:
        raise NotImplementedError()
    

class Validation:
    
    @property
    def rule_sets(self) -> aspose.diagram.RuleSetCollection:
        raise NotImplementedError()
    
    @property
    def issues(self) -> aspose.diagram.IssueCollection:
        raise NotImplementedError()
    
    @property
    def validation_properties(self) -> aspose.diagram.ValidationProperties:
        raise NotImplementedError()
    

class ValidationProperties:
    
    def __init__(self, last_validated : datetime, show_ignored : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def last_validated(self) -> datetime:
        raise NotImplementedError()
    
    @last_validated.setter
    def last_validated(self, value : datetime) -> None:
        raise NotImplementedError()
    
    @property
    def show_ignored(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_ignored.setter
    def show_ignored(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    

class Value:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def ufev(self) -> aspose.diagram.UnitFormulaErrV:
        raise NotImplementedError()
    
    @ufev.setter
    def ufev(self, value : aspose.diagram.UnitFormulaErrV) -> None:
        raise NotImplementedError()
    
    @property
    def val(self) -> str:
        raise NotImplementedError()
    
    @val.setter
    def val(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def solution_xml(self) -> aspose.diagram.SolutionXML:
        raise NotImplementedError()
    
    @solution_xml.setter
    def solution_xml(self, value : aspose.diagram.SolutionXML) -> None:
        raise NotImplementedError()
    

class VerticalAlign:
    
    def __init__(self, value : aspose.diagram.VerticalAlignValue) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.VerticalAlignValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.VerticalAlignValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    
    @ufe.setter
    def ufe(self, value : aspose.diagram.UnitFormulaErr) -> None:
        raise NotImplementedError()
    

class WalkPreference:
    
    def __init__(self, value : aspose.diagram.WalkPreferenceValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.WalkPreferenceValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.WalkPreferenceValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class WarningInfo:
    
    def __init__(self, warning_type : aspose.diagram.WarningType, description : str) -> None:
        raise NotImplementedError()
    
    @property
    def warning_type(self) -> aspose.diagram.WarningType:
        raise NotImplementedError()
    
    @property
    def description(self) -> str:
        raise NotImplementedError()
    

class Window:
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def stencil_group(self) -> str:
        raise NotImplementedError()
    
    @stencil_group.setter
    def stencil_group(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def stencil_group_pos(self) -> int:
        raise NotImplementedError()
    
    @stencil_group_pos.setter
    def stencil_group_pos(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def show_rulers(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_rulers.setter
    def show_rulers(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def show_grid(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_grid.setter
    def show_grid(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def show_page_breaks(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_page_breaks.setter
    def show_page_breaks(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def show_guides(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_guides.setter
    def show_guides(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def show_connection_points(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @show_connection_points.setter
    def show_connection_points(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def glue_settings(self) -> aspose.diagram.GlueSettingsValue:
        raise NotImplementedError()
    
    @glue_settings.setter
    def glue_settings(self, value : aspose.diagram.GlueSettingsValue) -> None:
        raise NotImplementedError()
    
    @property
    def snap_settings(self) -> aspose.diagram.SnapSettingsValue:
        raise NotImplementedError()
    
    @snap_settings.setter
    def snap_settings(self, value : aspose.diagram.SnapSettingsValue) -> None:
        raise NotImplementedError()
    
    @property
    def snap_extensions(self) -> aspose.diagram.SnapExtensionsValue:
        raise NotImplementedError()
    
    @snap_extensions.setter
    def snap_extensions(self, value : aspose.diagram.SnapExtensionsValue) -> None:
        raise NotImplementedError()
    
    @property
    def snap_angles(self) -> aspose.diagram.FloatPointNumCollection:
        raise NotImplementedError()
    
    @property
    def dynamic_grid_enabled(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @dynamic_grid_enabled.setter
    def dynamic_grid_enabled(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def tab_splitter_pos(self) -> float:
        raise NotImplementedError()
    
    @tab_splitter_pos.setter
    def tab_splitter_pos(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def window_type(self) -> aspose.diagram.WindowTypeValue:
        raise NotImplementedError()
    
    @window_type.setter
    def window_type(self, value : aspose.diagram.WindowTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def window_state(self) -> aspose.diagram.WindowStateValue:
        raise NotImplementedError()
    
    @window_state.setter
    def window_state(self, value : aspose.diagram.WindowStateValue) -> None:
        raise NotImplementedError()
    
    @property
    def document(self) -> str:
        raise NotImplementedError()
    
    @document.setter
    def document(self, value : str) -> None:
        raise NotImplementedError()
    
    @property
    def window_left(self) -> int:
        raise NotImplementedError()
    
    @window_left.setter
    def window_left(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def window_top(self) -> int:
        raise NotImplementedError()
    
    @window_top.setter
    def window_top(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def window_width(self) -> int:
        raise NotImplementedError()
    
    @window_width.setter
    def window_width(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def window_height(self) -> int:
        raise NotImplementedError()
    
    @window_height.setter
    def window_height(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def master(self) -> aspose.diagram.Master:
        raise NotImplementedError()
    
    @master.setter
    def master(self, value : aspose.diagram.Master) -> None:
        raise NotImplementedError()
    
    @property
    def container_type(self) -> aspose.diagram.ContainerTypeValue:
        raise NotImplementedError()
    
    @container_type.setter
    def container_type(self, value : aspose.diagram.ContainerTypeValue) -> None:
        raise NotImplementedError()
    
    @property
    def container(self) -> int:
        raise NotImplementedError()
    
    @container.setter
    def container(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def sheet(self) -> int:
        raise NotImplementedError()
    
    @sheet.setter
    def sheet(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def read_only(self) -> aspose.diagram.BOOL:
        raise NotImplementedError()
    
    @read_only.setter
    def read_only(self, value : aspose.diagram.BOOL) -> None:
        raise NotImplementedError()
    
    @property
    def parent_window(self) -> int:
        raise NotImplementedError()
    
    @parent_window.setter
    def parent_window(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def page(self) -> aspose.diagram.Page:
        raise NotImplementedError()
    
    @page.setter
    def page(self, value : aspose.diagram.Page) -> None:
        raise NotImplementedError()
    
    @property
    def view_scale(self) -> float:
        raise NotImplementedError()
    
    @view_scale.setter
    def view_scale(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def view_center_x(self) -> float:
        raise NotImplementedError()
    
    @view_center_x.setter
    def view_center_x(self, value : float) -> None:
        raise NotImplementedError()
    
    @property
    def view_center_y(self) -> float:
        raise NotImplementedError()
    
    @view_center_y.setter
    def view_center_y(self, value : float) -> None:
        raise NotImplementedError()
    

class WindowCollection(Collection):
    
    def is_exist(self, index : int) -> bool:
        raise NotImplementedError()
    
    def clear(self) -> None:
        raise NotImplementedError()
    
    def add(self, window : aspose.diagram.Window) -> int:
        raise NotImplementedError()
    
    def remove(self, window : aspose.diagram.Window) -> None:
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        raise NotImplementedError()
    
    @property
    def client_width(self) -> int:
        raise NotImplementedError()
    
    @client_width.setter
    def client_width(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def client_height(self) -> int:
        raise NotImplementedError()
    
    @client_height.setter
    def client_height(self, value : int) -> None:
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.diagram.Window:
        raise NotImplementedError()
    

class XForm:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def pin_pos(self) -> aspose.diagram.PinPosValue:
        raise NotImplementedError()
    
    @pin_pos.setter
    def pin_pos(self, value : aspose.diagram.PinPosValue) -> None:
        raise NotImplementedError()
    
    @property
    def pin_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @pin_x.setter
    def pin_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def pin_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @pin_y.setter
    def pin_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def width(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def height(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def loc_pin_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @loc_pin_x.setter
    def loc_pin_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def loc_pin_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @loc_pin_y.setter
    def loc_pin_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def angle(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @angle.setter
    def angle(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def flip_x(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @flip_x.setter
    def flip_x(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def flip_y(self) -> aspose.diagram.BoolValue:
        raise NotImplementedError()
    
    @flip_y.setter
    def flip_y(self, value : aspose.diagram.BoolValue) -> None:
        raise NotImplementedError()
    
    @property
    def resize_mode(self) -> aspose.diagram.ResizeMode:
        raise NotImplementedError()
    
    @resize_mode.setter
    def resize_mode(self, value : aspose.diagram.ResizeMode) -> None:
        raise NotImplementedError()
    

class XForm1D:
    
    def clone(self) -> Any:
        raise NotImplementedError()
    
    @property
    def begin_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @begin_x.setter
    def begin_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def begin_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @begin_y.setter
    def begin_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def end_x(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @end_x.setter
    def end_x(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    
    @property
    def end_y(self) -> aspose.diagram.DoubleValue:
        raise NotImplementedError()
    
    @end_y.setter
    def end_y(self, value : aspose.diagram.DoubleValue) -> None:
        raise NotImplementedError()
    

class XJustify:
    
    def __init__(self, value : aspose.diagram.XJustifyValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.XJustifyValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.XJustifyValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class YJustify:
    
    def __init__(self, value : aspose.diagram.YJustifyValue) -> None:
        raise NotImplementedError()
    
    @property
    def value(self) -> aspose.diagram.YJustifyValue:
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : aspose.diagram.YJustifyValue) -> None:
        raise NotImplementedError()
    
    @property
    def ufe(self) -> aspose.diagram.UnitFormulaErr:
        raise NotImplementedError()
    

class AlignNameValue:
    
    ALIGN_TEXT_LEFT : AlignNameValue
    ALIGN_TEXT_CENTER : AlignNameValue
    ALIGN_TEXT_RIGHT : AlignNameValue
    UNDEFINED : AlignNameValue

class AlignmentValue:
    
    LEFT : AlignmentValue
    CENTER : AlignmentValue
    RIGHT : AlignmentValue
    DECIMAL : AlignmentValue
    UNDEFINED : AlignmentValue

class ArrowSizeValue:
    
    VERY_SMALL : ArrowSizeValue
    SMALL : ArrowSizeValue
    MEDIUM : ArrowSizeValue
    LARGE : ArrowSizeValue
    EXTRA_LARGE : ArrowSizeValue
    JUMBO : ArrowSizeValue
    COLOSSAL : ArrowSizeValue
    UNDEFINED : ArrowSizeValue

class BOOL:
    
    UNDEFINED : BOOL
    FALSE : BOOL
    TRUE : BOOL

class BevelLightingTypeValue:
    
    BALANCED : BevelLightingTypeValue
    BRIGHT_ROOM : BevelLightingTypeValue
    CHILLY : BevelLightingTypeValue
    CONTRASTING : BevelLightingTypeValue
    FLAT : BevelLightingTypeValue
    FLOOD : BevelLightingTypeValue
    FREEZING : BevelLightingTypeValue
    GLOW : BevelLightingTypeValue
    HARSH : BevelLightingTypeValue
    LEGACY_FLAT1 : BevelLightingTypeValue
    LEGACY_FLAT2 : BevelLightingTypeValue
    LEGACY_FLAT3 : BevelLightingTypeValue
    LEGACY_FLAT4 : BevelLightingTypeValue
    LEGACY_HARSH1 : BevelLightingTypeValue
    LEGACY_HARSH2 : BevelLightingTypeValue
    LEGACY_HARSH3 : BevelLightingTypeValue
    LEGACY_HARSH4 : BevelLightingTypeValue
    LEGACY_NORMAL1 : BevelLightingTypeValue
    LEGACY_NORMAL2 : BevelLightingTypeValue
    LEGACY_NORMAL3 : BevelLightingTypeValue
    LEGACY_NORMAL4 : BevelLightingTypeValue
    MORNING : BevelLightingTypeValue
    SOFT : BevelLightingTypeValue
    SUNRISE : BevelLightingTypeValue
    SUNSET : BevelLightingTypeValue
    THREE_POINT : BevelLightingTypeValue
    TWO_POINT : BevelLightingTypeValue
    UNDEFINED : BevelLightingTypeValue

class BevelMaterialTypeValue:
    
    CLEAR : BevelMaterialTypeValue
    DARK_EDGE : BevelMaterialTypeValue
    FLAT : BevelMaterialTypeValue
    LEGACY_MATTE : BevelMaterialTypeValue
    LEGACY_METAL : BevelMaterialTypeValue
    LEGACY_PLASTIC : BevelMaterialTypeValue
    LEGACY_WIREFRAME : BevelMaterialTypeValue
    MATTE : BevelMaterialTypeValue
    METAL : BevelMaterialTypeValue
    PLASTIC : BevelMaterialTypeValue
    POWDER : BevelMaterialTypeValue
    SOFT_EDGE : BevelMaterialTypeValue
    SOFT_METAL : BevelMaterialTypeValue
    TRANSLUCENT_POWDER : BevelMaterialTypeValue
    WARM_MATTE : BevelMaterialTypeValue
    UNDEFINED : BevelMaterialTypeValue

class BevelPresetType:
    
    NONE : BevelPresetType
    ANGLE : BevelPresetType
    ART_DECO : BevelPresetType
    CIRCLE : BevelPresetType
    CONVEX : BevelPresetType
    COOL_SLANT : BevelPresetType
    CROSS : BevelPresetType
    DIVOT : BevelPresetType
    HARD_EDGE : BevelPresetType
    RELAXED_INSET : BevelPresetType
    RIBLET : BevelPresetType
    SLOPE : BevelPresetType
    SOFT_ROUND : BevelPresetType

class BevelTypeValue:
    
    NONE : BevelTypeValue
    ANGLE : BevelTypeValue
    ART_DECO : BevelTypeValue
    CIRCLE : BevelTypeValue
    CONVEX : BevelTypeValue
    COOL_SLANT : BevelTypeValue
    CROSS : BevelTypeValue
    DIVOT : BevelTypeValue
    HARD_EDGE : BevelTypeValue
    RELAXED_INSET : BevelTypeValue
    RIBLET : BevelTypeValue
    SLOPE : BevelTypeValue
    SOFT_ROUND : BevelTypeValue
    UNDEFINED : BevelTypeValue

class BulletValue:
    
    NONE : BulletValue
    STYLE1 : BulletValue
    STYLE2 : BulletValue
    STYLE3 : BulletValue
    STYLE4 : BulletValue
    STYLE5 : BulletValue
    STYLE6 : BulletValue
    STYLE7 : BulletValue
    UNDEFINED : BulletValue

class CalendarValue:
    
    WESTERN : CalendarValue
    ARABIC_HIJIRI : CalendarValue
    HEBREW_LUNAR : CalendarValue
    TAIWAN_CALENDAR : CalendarValue
    JAPANESE_EMPEROR_REIGN : CalendarValue
    THAI_BUDDHIST : CalendarValue
    KOREAN_DANKI : CalendarValue
    SAKA_ERA : CalendarValue
    ENGLISH_TRANSLITERATED : CalendarValue
    FRENCH_TRANSLITERATED : CalendarValue
    UNDEFINED : CalendarValue

class CaseValue:
    
    NORMAL_CASE : CaseValue
    ALL_CAPITAL_LETTERS : CaseValue
    INITIAL_CAPITAL_LETTERS_ONLY : CaseValue
    UNDEFINED : CaseValue

class CompoundTypeValue:
    
    SINGLE : CompoundTypeValue
    THICK_BETWEEN_THIN : CompoundTypeValue
    THIN_THICK : CompoundTypeValue
    THICK_THIN : CompoundTypeValue
    THIN_THIN : CompoundTypeValue
    UNDEFINED : CompoundTypeValue

class CompressionType:
    
    NO : CompressionType
    JPEG : CompressionType
    GIF : CompressionType
    TIFF : CompressionType
    PNG : CompressionType
    UNDEFINED : CompressionType

class ConFixedCodeValue:
    
    REROUTE_FREELY : ConFixedCodeValue
    REROUTE_NEEDED : ConFixedCodeValue
    NEVER_REROUTE : ConFixedCodeValue
    REROUTE_ON_CROSSOVER : ConFixedCodeValue
    RESERVED1 : ConFixedCodeValue
    RESERVED2 : ConFixedCodeValue
    RESERVED3 : ConFixedCodeValue
    UNDEFINED : ConFixedCodeValue

class ConLineJumpCodeValue:
    
    PAGE_DEFAULT : ConLineJumpCodeValue
    NEVER : ConLineJumpCodeValue
    ALWAYS : ConLineJumpCodeValue
    OTHER_CONNECTOR_JUMPS : ConLineJumpCodeValue
    NEITHER_CONNECTOR_JUMPS : ConLineJumpCodeValue
    UNDEFINED : ConLineJumpCodeValue

class ConLineJumpDirXValue:
    
    PAGE_DEFAULT : ConLineJumpDirXValue
    UP : ConLineJumpDirXValue
    DOWN : ConLineJumpDirXValue
    UNDEFINED : ConLineJumpDirXValue

class ConLineJumpDirYValue:
    
    PAGE_DEFAULT : ConLineJumpDirYValue
    LEFT : ConLineJumpDirYValue
    RIGHT : ConLineJumpDirYValue
    UNDEFINED : ConLineJumpDirYValue

class ConLineJumpStyleValue:
    
    PAGE_DEFAULT : ConLineJumpStyleValue
    ARC : ConLineJumpStyleValue
    GAP : ConLineJumpStyleValue
    SQUARE : ConLineJumpStyleValue
    SIDES2 : ConLineJumpStyleValue
    SIDES3 : ConLineJumpStyleValue
    SIDES4 : ConLineJumpStyleValue
    SIDES5 : ConLineJumpStyleValue
    SIDES6 : ConLineJumpStyleValue
    SIDES7 : ConLineJumpStyleValue
    UNDEFINED : ConLineJumpStyleValue

class ConLineRouteExtValue:
    
    PAGE_DEFAULT : ConLineRouteExtValue
    STRAIGHT : ConLineRouteExtValue
    CURVED : ConLineRouteExtValue
    UNDEFINED : ConLineRouteExtValue

class ConValue:
    
    PROPORTIONAL : ConValue
    PROPORTIONAL_LOCKED : ConValue
    OFFSET_FROM_LEFT_EDGE : ConValue
    OFFSET_FROM_CENTER : ConValue
    OFFSET_FROM_RIGHT_EDGE : ConValue
    PROPORTIONAL_HIDDEN : ConValue
    PROPORTIONAL_LOCKED_HIDDEN : ConValue
    OFFSET_FROM_LEFT_EDGE_HIDDEN : ConValue
    OFFSET_FROM_CENTER_HIDDEN : ConValue
    OFFSET_FROM_RIGHT_EDGE_HIDDEN : ConValue
    UNDEFINED : ConValue

class ConnectedShapesFlags:
    
    CONNECTED_SHAPES_ALL_NODES : ConnectedShapesFlags
    CONNECTED_SHAPES_INCOMING_NODES : ConnectedShapesFlags
    CONNECTED_SHAPES_OUTGOING_NODES : ConnectedShapesFlags

class ConnectorsTypeValue:
    
    RIGHT_ANGLE : ConnectorsTypeValue
    STRAIGHT_LINES : ConnectorsTypeValue
    CURVED_LINES : ConnectorsTypeValue
    UNDEFINED : ConnectorsTypeValue

class ContainerTypeValue:
    
    DOCUMENT : ContainerTypeValue
    PAGE : ContainerTypeValue
    MASTER : ContainerTypeValue
    STYLE : ContainerTypeValue
    UNDEFINED : ContainerTypeValue

class ContextTypeValue:
    
    SHAPE_TEXT : ContextTypeValue
    SHAPE_DATA_ITEM_CUSTOM_PROPERTY_LABEL : ContextTypeValue
    USER_CELL_LOCAL_ROW_NAME : ContextTypeValue
    GEOMETRY_ANGLE : ContextTypeValue
    GEOMETRY_WIDTH : ContextTypeValue
    GEOMETRY_HEIGHT : ContextTypeValue
    SHAPE_ID : ContextTypeValue
    MASTER_NAME : ContextTypeValue
    SHAPE_LOCAL_NAME : ContextTypeValue
    SHAPE_TYPE : ContextTypeValue
    DATA1 : ContextTypeValue
    DATA2 : ContextTypeValue
    DATA3 : ContextTypeValue
    UNDEFINED : ContextTypeValue

class CountryCode:
    
    DEFAULT : CountryCode
    USA : CountryCode
    CANADA : CountryCode
    LATIN_AMERIC : CountryCode
    RUSSIA : CountryCode
    EGYPT : CountryCode
    GREECE : CountryCode
    NETHERLANDS : CountryCode
    BELGIUM : CountryCode
    FRANCE : CountryCode
    SPAIN : CountryCode
    HUNGARY : CountryCode
    ITALY : CountryCode
    SWITZERLAND : CountryCode
    AUSTRIA : CountryCode
    UNITED_KINGDOM : CountryCode
    DENMARK : CountryCode
    SWEDEN : CountryCode
    NORWAY : CountryCode
    POLAND : CountryCode
    GERMANY : CountryCode
    MEXICO : CountryCode
    BRAZIL : CountryCode
    AUSTRALIA : CountryCode
    NEW_ZEALAND : CountryCode
    THAILAND : CountryCode
    JAPAN : CountryCode
    SOUTH_KOREA : CountryCode
    VIET_NAM : CountryCode
    CHINA : CountryCode
    TURKEY : CountryCode
    INDIA : CountryCode
    ALGERIA : CountryCode
    MOROCCO : CountryCode
    LIBYA : CountryCode
    PORTUGAL : CountryCode
    ICELAND : CountryCode
    FINLAND : CountryCode
    CZECH : CountryCode
    TAIWAN : CountryCode
    LEBANON : CountryCode
    JORDAN : CountryCode
    SYRIA : CountryCode
    IRAQ : CountryCode
    KUWAIT : CountryCode
    SAUDI : CountryCode
    UNITED_ARAB_EMIRATES : CountryCode
    ISRAEL : CountryCode
    QATAR : CountryCode
    IRAN : CountryCode

class DisplayModeSmartTagDefValue:
    
    MOUSE_IS_PAUSED : DisplayModeSmartTagDefValue
    SHAPE_IS_SELECTED : DisplayModeSmartTagDefValue
    ALL_TIME : DisplayModeSmartTagDefValue
    UNDEFINED : DisplayModeSmartTagDefValue

class DisplayModeValue:
    
    HIDES_SHAPE_TEXT : DisplayModeValue
    DISPLAYS_SHAPE_BEHIND_MEMBER_SHAPES : DisplayModeValue
    DISPLAYS_SHAPE_FRONT_MEMBER_SHAPES : DisplayModeValue
    UNDEFINED : DisplayModeValue

class DrawingResizeTypeValue:
    
    DEPENDS_ON_DRAWING_SIZE_TYPE : DrawingResizeTypeValue
    AUTOMATICALLY : DrawingResizeTypeValue
    NOT_AUTOMATICALLY : DrawingResizeTypeValue
    UNDEFINED : DrawingResizeTypeValue

class DrawingScaleTypeValue:
    
    NO_SCALE : DrawingScaleTypeValue
    ARCHITECTURAL_SCALE : DrawingScaleTypeValue
    CIVIL_ENGINEERING_SCALE : DrawingScaleTypeValue
    CUSTOM_SCALE : DrawingScaleTypeValue
    METRIC_SCALE : DrawingScaleTypeValue
    MECHANICAL_ENGINEERING_SCALE : DrawingScaleTypeValue
    UNDEFINED : DrawingScaleTypeValue

class DrawingSizeTypeValue:
    
    SAME_AS_PRINTER : DrawingSizeTypeValue
    FIT_PAGE_DRAW_CONTENTS : DrawingSizeTypeValue
    STANDARD : DrawingSizeTypeValue
    CUSTOM_PAGE_SIZE : DrawingSizeTypeValue
    CUSTOM_SCALED_DRAW_SIZE : DrawingSizeTypeValue
    METRIC_ISO : DrawingSizeTypeValue
    ANSI_ENGINEERING : DrawingSizeTypeValue
    ANSI_ARCHITECTURAL : DrawingSizeTypeValue
    UNDEFINED : DrawingSizeTypeValue

class DynFeedbackValue:
    
    REMAIN_STRAIGHT : DynFeedbackValue
    SHOW_THREE_LEGS : DynFeedbackValue
    SHOW_FIVE_LEGS : DynFeedbackValue
    UNDEFINED : DynFeedbackValue

class EmfRenderSetting:
    
    EMF_ONLY : EmfRenderSetting
    EMF_PLUS_PREFER : EmfRenderSetting

class FileFormatType:
    
    VDX : FileFormatType
    VSD : FileFormatType
    VSX : FileFormatType
    VSS : FileFormatType
    VTX : FileFormatType
    VST : FileFormatType
    VDW : FileFormatType
    VSDX : FileFormatType
    VSTX : FileFormatType
    VSSX : FileFormatType
    CSV : FileFormatType
    XLSX : FileFormatType
    XLSM : FileFormatType
    XLTX : FileFormatType
    XLTM : FileFormatType
    XLAM : FileFormatType
    TAB_DELIMITED : FileFormatType
    HTML : FileFormatType
    ODS : FileFormatType
    EXCEL_97_TO_2003 : FileFormatType
    EXCEL_2003XML : FileFormatType
    XLSB : FileFormatType
    UNKNOWN : FileFormatType
    PDF : FileFormatType
    XPS : FileFormatType
    TIFF : FileFormatType
    SVG : FileFormatType
    DOCX : FileFormatType
    DIF : FileFormatType
    DOC : FileFormatType
    PPT : FileFormatType
    MAPI_MESSAGE : FileFormatType
    MS_EQUATION : FileFormatType
    OLE_10_NATIVE : FileFormatType
    DOCM : FileFormatType
    DOTX : FileFormatType
    DOTM : FileFormatType
    PPTM : FileFormatType
    POTX : FileFormatType
    POTM : FileFormatType
    PPSX : FileFormatType
    PPSM : FileFormatType
    OOXML : FileFormatType
    VSDM : FileFormatType
    VSSM : FileFormatType
    VSTM : FileFormatType
    XML : FileFormatType
    SLDX : FileFormatType
    PPTX : FileFormatType
    BMP : FileFormatType
    EMF : FileFormatType
    WMF : FileFormatType
    JPG : FileFormatType
    PNG : FileFormatType
    GIF : FileFormatType

class FillType:
    
    AUTOMATIC : FillType
    NONE : FillType
    SOLID : FillType
    GRADIENT : FillType
    TEXTURE : FillType
    PATTERN : FillType

class FontSourceType:
    
    FONT_FILE : FontSourceType
    FONTS_FOLDER : FontSourceType
    MEMORY_FONT : FontSourceType

class ForeignType:
    
    OBJECT : ForeignType
    ENH_METAFILE : ForeignType
    METAFILE : ForeignType
    BITMAP : ForeignType
    INK : ForeignType
    UNDEFINED : ForeignType

class FromPartValue:
    
    NONE : FromPartValue
    LEFT_EDGE : FromPartValue
    CENTER_EDGE : FromPartValue
    RIGHT_EDGE : FromPartValue
    BOTTOM_EDGE : FromPartValue
    MIDDLE_EDGE : FromPartValue
    TOP_EDGE : FromPartValue
    BEGIN_X_CELL : FromPartValue
    BEGIN_Y_CELL : FromPartValue
    BEGIN_X_OR_BEGIN_Y_POINT : FromPartValue
    END_X_CELL : FromPartValue
    END_Y_CELL : FromPartValue
    END_X_OR_END_Y_POINT : FromPartValue
    CONTROL_POINT : FromPartValue
    UNDEFINED : FromPartValue

class GlueSettings:
    
    NONE : GlueSettings
    GUIDES : GlueSettings
    HANDLES : GlueSettings
    VERTICES : GlueSettings
    CONNECTION_POINTS : GlueSettings
    GEOMETRY : GlueSettings
    DISABLED : GlueSettings
    UNDEFINED : GlueSettings

class GlueSettingsValue:
    
    GLUE_IS_ENABLED : GlueSettingsValue
    GLUE_TO_GUIDES : GlueSettingsValue
    GLUE_TO_HANDLES : GlueSettingsValue
    GLUE_TO_VERTICES : GlueSettingsValue
    GLUE_TO_CONNECTION_POINTS : GlueSettingsValue
    GLUE_TO_GEOMETRY : GlueSettingsValue
    GLUE_IS_DISABLED : GlueSettingsValue
    UNDEFINED : GlueSettingsValue

class GlueTypeValue:
    
    ALLOW_DYNAMIC_GLUE_FOR_DYNAMIC_CONNECTOR : GlueTypeValue
    ALLOW_DYNAMIC_GLUE2002 : GlueTypeValue
    ALLOW_DYNAMIC_GLUE : GlueTypeValue
    NO_ALLOW_DYNAMIC_GLUE : GlueTypeValue
    NO_ALLOW_2D_SHAPE : GlueTypeValue
    UNDEFINED : GlueTypeValue

class GluedShapesFlags:
    
    GLUED_SHAPES_ALL_1D : GluedShapesFlags
    GLUED_SHAPES_INCOMING_1D : GluedShapesFlags
    GLUED_SHAPES_OUTGOING_1D : GluedShapesFlags
    GLUED_SHAPES_ALL_2D : GluedShapesFlags
    GLUED_SHAPES_INCOMING_2D : GluedShapesFlags
    GLUED_SHAPES_OUTGOING_2D : GluedShapesFlags

class GradientDirectionType:
    
    FROM_UPPER_LEFT_CORNER : GradientDirectionType
    FROM_UPPER_RIGHT_CORNER : GradientDirectionType
    FROM_LOWER_LEFT_CORNER : GradientDirectionType
    FROM_LOWER_RIGHT_CORNER : GradientDirectionType
    FROM_CENTER : GradientDirectionType
    UNKNOWN : GradientDirectionType

class GradientFillDir:
    
    LINEAR : GradientFillDir
    RADIAL_FROM_BOTTOM_RIGHT : GradientFillDir
    RADIAL_FROM_BOTTOM_LEFT : GradientFillDir
    RADIAL_FROM_CENTER : GradientFillDir
    RADIAL_FROM_CENTER_BOTTOM : GradientFillDir
    RADIAL_FROM_CENTER_TOP : GradientFillDir
    RADIAL_FROM_TOP_RIGHT : GradientFillDir
    RADIAL_FROM_TOP_LEFT : GradientFillDir
    RECTANGLE_FROM_BOTTOM_RIGHT : GradientFillDir
    RECTANGLE_FROM_BOTTOM_LEFT : GradientFillDir
    RECTANGLE_FROM_CENTER : GradientFillDir
    RECTANGLE_FROM_TOP_RIGHT : GradientFillDir
    RECTANGLE_FROM_TOP_LEFT : GradientFillDir
    PATH : GradientFillDir

class GradientFillType:
    
    LINEAR : GradientFillType
    RADIAL : GradientFillType
    RECTANGLE : GradientFillType
    PATH : GradientFillType

class GradientStyleType:
    
    DIAGONAL_DOWN : GradientStyleType
    DIAGONAL_UP : GradientStyleType
    FROM_CENTER : GradientStyleType
    FROM_CORNER : GradientStyleType
    HORIZONTAL : GradientStyleType
    VERTICAL : GradientStyleType
    UNKNOWN : GradientStyleType

class GridDensityValue:
    
    FIXED : GridDensityValue
    COARSE : GridDensityValue
    NORMAL : GridDensityValue
    FINE : GridDensityValue
    UNDEFINED : GridDensityValue

class HorzAlignValue:
    
    LEFT_ALIGN : HorzAlignValue
    CENTER : HorzAlignValue
    RIGHT_ALIGN : HorzAlignValue
    JUSTIFY : HorzAlignValue
    FORCE_JUSTIFY : HorzAlignValue
    UNDEFINED : HorzAlignValue

class IconSizeValue:
    
    NORMAL : IconSizeValue
    TALL : IconSizeValue
    WIDE : IconSizeValue
    DOUBLE : IconSizeValue
    UNDEFINED : IconSizeValue

class LightRigDirectionType:
    
    BOTTOM : LightRigDirectionType
    BOTTOM_LEFT : LightRigDirectionType
    BOTTOM_RIGHT : LightRigDirectionType
    LEFT : LightRigDirectionType
    RIGHT : LightRigDirectionType
    TOP : LightRigDirectionType
    TOP_LEFT : LightRigDirectionType
    TOP_RIGHT : LightRigDirectionType

class LineAdjustFromValue:
    
    UNRELATED_LINES : LineAdjustFromValue
    ALL_LINES : LineAdjustFromValue
    NO_LINES : LineAdjustFromValue
    ROUTING_STYLE_DEFAULT : LineAdjustFromValue
    UNDEFINED : LineAdjustFromValue

class LineAdjustToValue:
    
    ROUTING_STYLE_DEFAULT : LineAdjustToValue
    ALL_LINES_CLOSE : LineAdjustToValue
    NO_LINES : LineAdjustToValue
    RELATEDLINES : LineAdjustToValue
    UNDEFINED : LineAdjustToValue

class LineJumpCodeValue:
    
    NONE : LineJumpCodeValue
    HORIZONTAL_LINES : LineJumpCodeValue
    VERTICAL_LINES : LineJumpCodeValue
    LAST_ROUTED_LINE : LineJumpCodeValue
    LAST_DISPLAYED_LINE : LineJumpCodeValue
    FIRST_DISPLAYED_LINE : LineJumpCodeValue
    UNDEFINED : LineJumpCodeValue

class LineJumpStyleValue:
    
    DEFAULT : LineJumpStyleValue
    ARC : LineJumpStyleValue
    GAP : LineJumpStyleValue
    SQUARE : LineJumpStyleValue
    SIDES2 : LineJumpStyleValue
    SIDES3 : LineJumpStyleValue
    SIDES4 : LineJumpStyleValue
    SIDES5 : LineJumpStyleValue
    SIDES6 : LineJumpStyleValue
    SIDES7 : LineJumpStyleValue
    UNDEFINED : LineJumpStyleValue

class LineRouteExtValue:
    
    DEFAULT : LineRouteExtValue
    STRAIGHT : LineRouteExtValue
    CURVED : LineRouteExtValue
    UNDEFINED : LineRouteExtValue

class LoadDataFilterOptions:
    
    ALL : LoadDataFilterOptions
    DOCUMENT_PROPERTIES : LoadDataFilterOptions
    VBA : LoadDataFilterOptions
    SOLUTION_XML : LoadDataFilterOptions
    FONT : LoadDataFilterOptions
    FOREGROUND_PAGE : LoadDataFilterOptions

class LoadFileFormat:
    
    VDX : LoadFileFormat
    VSD : LoadFileFormat
    VSX : LoadFileFormat
    VSS : LoadFileFormat
    VTX : LoadFileFormat
    VST : LoadFileFormat
    VDW : LoadFileFormat
    VSDX : LoadFileFormat
    VSTX : LoadFileFormat
    VSSX : LoadFileFormat
    VSDM : LoadFileFormat
    VSSM : LoadFileFormat
    VSTM : LoadFileFormat
    HTML : LoadFileFormat

class LocalizeFontValue:
    
    LOCALIZE_FONT_ONLY_ARIAL_SYMBOL : LocalizeFontValue
    ALWAYS_LOCALIZE_FONT : LocalizeFontValue
    NEVER_LOCALIZE_FONT : LocalizeFontValue
    UNDEFINED : LocalizeFontValue

class MeasureConst:
    
    AC : MeasureConst
    C : MeasureConst
    C_D : MeasureConst
    CM : MeasureConst
    D : MeasureConst
    DL : MeasureConst
    DP : MeasureConst
    DT : MeasureConst
    F_I : MeasureConst
    FT : MeasureConst
    HA : MeasureConst
    IN : MeasureConst
    IN_F : MeasureConst
    KM : MeasureConst
    M : MeasureConst
    MI : MeasureConst
    MI_F : MeasureConst
    MM : MeasureConst
    NM : MeasureConst
    P : MeasureConst
    PT : MeasureConst
    P_PT : MeasureConst
    YD : MeasureConst
    AD : MeasureConst
    AM : MeasureConst
    AS : MeasureConst
    DA : MeasureConst
    DEG : MeasureConst
    RAD : MeasureConst
    DE : MeasureConst
    ED : MeasureConst
    EH : MeasureConst
    EM : MeasureConst
    ES : MeasureConst
    EW : MeasureConst
    DATE : MeasureConst
    BOOL : MeasureConst
    COLOR : MeasureConst
    CY : MeasureConst
    GUID : MeasureConst
    MULTIDIM : MeasureConst
    NUM : MeasureConst
    NURBS : MeasureConst
    PER : MeasureConst
    PNT : MeasureConst
    POLYLINE : MeasureConst
    STR : MeasureConst
    UNDEFINED : MeasureConst

class ObjTypeValue:
    
    DRAWING_CONTEXT : ObjTypeValue
    SHAPE_PLACEABLE : ObjTypeValue
    SHAPE_ROUTABLE : ObjTypeValue
    SHAPE_NOT_PLACEABLE_NOT_ROUTABLE : ObjTypeValue
    SHAPE_PLACEABLE_ROUTABLE : ObjTypeValue
    UNDEFINED : ObjTypeValue

class ObjectKindValue:
    
    STANDARD : ObjectKindValue
    HORIZONTAL_IN_VERTICAL : ObjectKindValue
    UNDEFINED : ObjectKindValue

class ObjectType:
    
    LINKED_OBJECT : ObjectType
    EMBEDDED_OBJECT : ObjectType
    CONTROL : ObjectType
    OLE2_NAMED : ObjectType
    OLE2_OBJECT : ObjectType
    UNDEFINED : ObjectType

class OptionsValue:
    
    NO_EXTERNAL_DATA_UI : OptionsValue
    NO_ADV_CONFIG : OptionsValue
    NO_REFRESH_UI : OptionsValue
    NO_LINK_ON_PASTE : OptionsValue
    DELAY_QUERY : OptionsValue
    UNDEFINED : OptionsValue

class OutputFormatValue:
    
    DEFAULT_PRINT : OutputFormatValue
    POWER_POINT_SLIDE_SHOW : OutputFormatValue
    HTML_OR_GIF_OUTPUT : OutputFormatValue
    UNDEFINED : OutputFormatValue

class PageLineJumpDirXValue:
    
    DEFAULT_UP : PageLineJumpDirXValue
    UP : PageLineJumpDirXValue
    DOWN : PageLineJumpDirXValue
    UNDEFINED : PageLineJumpDirXValue

class PageLineJumpDirYValue:
    
    DEFAULTLEFT : PageLineJumpDirYValue
    LEFT : PageLineJumpDirYValue
    RIGHT : PageLineJumpDirYValue
    UNDEFINED : PageLineJumpDirYValue

class PinPosValue:
    
    TOP_LEFT : PinPosValue
    TOP_CENTER : PinPosValue
    TOP_RIGHT : PinPosValue
    CENTER_LEFT : PinPosValue
    CENTER_CENTER : PinPosValue
    CENTER_RIGHT : PinPosValue
    BOTTOM_LEFT : PinPosValue
    BOTTOM_CENTER : PinPosValue
    BOTTOM_RIGHT : PinPosValue
    UNDEFINED : PinPosValue

class PlaceDepthValue:
    
    PAGE_DEFAULT : PlaceDepthValue
    MEDIUM : PlaceDepthValue
    DEEP : PlaceDepthValue
    SHALLOW : PlaceDepthValue
    UNDEFINED : PlaceDepthValue

class PlaceFlipValue:
    
    DEFAULT_NO_FLIP : PlaceFlipValue
    FLIP_HORIZONTAL : PlaceFlipValue
    FLIP_VERTICAL : PlaceFlipValue
    FLIP_90_INCREMENTS : PlaceFlipValue
    NO_FLIP : PlaceFlipValue
    UNDEFINED : PlaceFlipValue

class PlaceStyleValue:
    
    DEFAULT_RADIAL : PlaceStyleValue
    TOP_TO_BOTTOM : PlaceStyleValue
    LEFT_TO_RIGHT : PlaceStyleValue
    RADIAL : PlaceStyleValue
    BOTTOM_TO_TOP : PlaceStyleValue
    RIGHT_TO_LEFT : PlaceStyleValue
    CIRCULAR : PlaceStyleValue
    UNDEFINED : PlaceStyleValue

class PosValue:
    
    NORMAL_POSITION : PosValue
    SUPERSCRIPT : PosValue
    SUBSCRIPT : PosValue
    UNDEFINED : PosValue

class PresetCameraType:
    
    ISOMETRIC_BOTTOM_DOWN : PresetCameraType
    ISOMETRIC_BOTTOM_UP : PresetCameraType
    ISOMETRIC_LEFT_DOWN : PresetCameraType
    ISOMETRIC_LEFT_UP : PresetCameraType
    ISOMETRIC_OFF_AXIS_1_LEFT : PresetCameraType
    ISOMETRIC_OFF_AXIS_1_RIGHT : PresetCameraType
    ISOMETRIC_OFF_AXIS_1_TOP : PresetCameraType
    ISOMETRIC_OFF_AXIS_2_LEFT : PresetCameraType
    ISOMETRIC_OFF_AXIS_2_RIGHT : PresetCameraType
    ISOMETRIC_OFF_AXIS_2_TOP : PresetCameraType
    ISOMETRIC_OFF_AXIS_3_BOTTOM : PresetCameraType
    ISOMETRIC_OFF_AXIS_3_LEFT : PresetCameraType
    ISOMETRIC_OFF_AXIS_3_RIGHT : PresetCameraType
    ISOMETRIC_OFF_AXIS_4_BOTTOM : PresetCameraType
    ISOMETRIC_OFF_AXIS_4_LEFT : PresetCameraType
    ISOMETRIC_OFF_AXIS_4_RIGHT : PresetCameraType
    ISOMETRIC_RIGHT_DOWN : PresetCameraType
    ISOMETRIC_RIGHT_UP : PresetCameraType
    ISOMETRIC_TOP_DOWN : PresetCameraType
    ISOMETRIC_TOP_UP : PresetCameraType
    LEGACY_OBLIQUE_BOTTOM : PresetCameraType
    LEGACY_OBLIQUE_BOTTOM_LEFT : PresetCameraType
    LEGACY_OBLIQUE_BOTTOM_RIGHT : PresetCameraType
    LEGACY_OBLIQUE_FRONT : PresetCameraType
    LEGACY_OBLIQUE_LEFT : PresetCameraType
    LEGACY_OBLIQUE_RIGHT : PresetCameraType
    LEGACY_OBLIQUE_TOP : PresetCameraType
    LEGACY_OBLIQUE_TOP_LEFT : PresetCameraType
    LEGACY_OBLIQUE_TOP_RIGHT : PresetCameraType
    LEGACY_PERSPECTIVE_BOTTOM : PresetCameraType
    LEGACY_PERSPECTIVE_BOTTOM_LEFT : PresetCameraType
    LEGACY_PERSPECTIVE_BOTTOM_RIGHT : PresetCameraType
    LEGACY_PERSPECTIVE_FRONT : PresetCameraType
    LEGACY_PERSPECTIVE_LEFT : PresetCameraType
    LEGACY_PERSPECTIVE_RIGHT : PresetCameraType
    LEGACY_PERSPECTIVE_TOP : PresetCameraType
    LEGACY_PERSPECTIVE_TOP_LEFT : PresetCameraType
    LEGACY_PERSPECTIVE_TOP_RIGHT : PresetCameraType
    OBLIQUE_BOTTOM : PresetCameraType
    OBLIQUE_BOTTOM_LEFT : PresetCameraType
    OBLIQUE_BOTTOM_RIGHT : PresetCameraType
    OBLIQUE_LEFT : PresetCameraType
    OBLIQUE_RIGHT : PresetCameraType
    OBLIQUE_TOP : PresetCameraType
    OBLIQUE_TOP_LEFT : PresetCameraType
    OBLIQUE_TOP_RIGHT : PresetCameraType
    ORTHOGRAPHIC_FRONT : PresetCameraType
    PERSPECTIVE_ABOVE : PresetCameraType
    PERSPECTIVE_ABOVE_LEFT_FACING : PresetCameraType
    PERSPECTIVE_ABOVE_RIGHT_FACING : PresetCameraType
    PERSPECTIVE_BELOW : PresetCameraType
    PERSPECTIVE_CONTRASTING_LEFT_FACING : PresetCameraType
    PERSPECTIVE_CONTRASTING_RIGHT_FACING : PresetCameraType
    PERSPECTIVE_FRONT : PresetCameraType
    PERSPECTIVE_HEROIC_EXTREME_LEFT_FACING : PresetCameraType
    PERSPECTIVE_HEROIC_EXTREME_RIGHT_FACING : PresetCameraType
    PERSPECTIVE_HEROIC_LEFT_FACING : PresetCameraType
    PERSPECTIVE_HEROIC_RIGHT_FACING : PresetCameraType
    PERSPECTIVE_LEFT : PresetCameraType
    PERSPECTIVE_RELAXED : PresetCameraType
    PERSPECTIVE_RELAXED_MODERATELY : PresetCameraType
    PERSPECTIVE_RIGHT : PresetCameraType

class PresetColorMatricsValue:
    
    COLOR1 : PresetColorMatricsValue
    COLOR2 : PresetColorMatricsValue
    COLOR3 : PresetColorMatricsValue
    COLOR4 : PresetColorMatricsValue
    COLOR5 : PresetColorMatricsValue
    COLOR6 : PresetColorMatricsValue
    COLOR7 : PresetColorMatricsValue

class PresetQuickStyleValue:
    
    VARIANT_STYLE1 : PresetQuickStyleValue
    VARIANT_STYLE2 : PresetQuickStyleValue
    VARIANT_STYLE3 : PresetQuickStyleValue
    VARIANT_STYLE4 : PresetQuickStyleValue

class PresetShadowType:
    
    NO_SHADOW : PresetShadowType
    CUSTOM : PresetShadowType
    OFFSET_DIAGONAL_BOTTOM_RIGHT : PresetShadowType
    OFFSET_BOTTOM : PresetShadowType
    OFFSET_DIAGONAL_BOTTOM_LEFT : PresetShadowType
    OFFSET_RIGHT : PresetShadowType
    OFFSET_CENTER : PresetShadowType
    OFFSET_LEFT : PresetShadowType
    OFFSET_DIAGONAL_TOP_RIGHT : PresetShadowType
    OFFSET_TOP : PresetShadowType
    OFFSET_DIAGONAL_TOP_LEFT : PresetShadowType
    INSIDE_DIAGONAL_TOP_LEFT : PresetShadowType
    INSIDE_TOP : PresetShadowType
    INSIDE_DIAGONAL_TOP_RIGHT : PresetShadowType
    INSIDE_LEFT : PresetShadowType
    INSIDE_CENTER : PresetShadowType
    INSIDE_RIGHT : PresetShadowType
    INSIDE_DIAGONAL_BOTTOM_LEFT : PresetShadowType
    INSIDE_BOTTOM : PresetShadowType
    INSIDE_DIAGONAL_BOTTOM_RIGHT : PresetShadowType
    PERSPECTIVE_DIAGONAL_UPPER_LEFT : PresetShadowType
    PERSPECTIVE_DIAGONAL_UPPER_RIGHT : PresetShadowType
    BELOW : PresetShadowType
    PERSPECTIVE_DIAGONAL_LOWER_LEFT : PresetShadowType
    PERSPECTIVE_DIAGONAL_LOWER_RIGHT : PresetShadowType

class PresetStyleMatricsValue:
    
    STYLE1 : PresetStyleMatricsValue
    STYLE2 : PresetStyleMatricsValue
    STYLE3 : PresetStyleMatricsValue
    STYLE4 : PresetStyleMatricsValue
    STYLE5 : PresetStyleMatricsValue
    STYLE6 : PresetStyleMatricsValue

class PresetThemeValue:
    
    NO_THEME : PresetThemeValue
    OFFICE : PresetThemeValue
    LINEAR : PresetThemeValue
    ZEPHYR : PresetThemeValue
    INTEGRAL : PresetThemeValue
    SIMPLE : PresetThemeValue
    WHISP : PresetThemeValue
    DAYBREAK : PresetThemeValue
    PARALLEL : PresetThemeValue
    SEQUENCE : PresetThemeValue
    SLICE : PresetThemeValue
    ION : PresetThemeValue
    RETROSPECT : PresetThemeValue
    ORGANIC : PresetThemeValue
    BUBBLE : PresetThemeValue
    CLOUDS : PresetThemeValue
    GEMSTONE : PresetThemeValue
    LINES : PresetThemeValue
    FACET : PresetThemeValue
    PROMINENCE : PresetThemeValue
    SMOKE : PresetThemeValue
    RADIANCE : PresetThemeValue
    SHADE : PresetThemeValue
    PENCIL : PresetThemeValue
    PEN : PresetThemeValue
    MARKER : PresetThemeValue
    WHITE_BOARD : PresetThemeValue

class PresetThemeVariantValue:
    
    VARIANT1 : PresetThemeVariantValue
    VARIANT2 : PresetThemeVariantValue
    VARIANT3 : PresetThemeVariantValue
    VARIANT4 : PresetThemeVariantValue

class PreviewScopeValue:
    
    FIRST_PAGE : PreviewScopeValue
    NO_PREVIEW : PreviewScopeValue
    ALL_PAGES : PreviewScopeValue
    UNDEFINED : PreviewScopeValue

class PrintPageOrientationValue:
    
    SAME_AS_PRINTER : PrintPageOrientationValue
    PORTRAIT : PrintPageOrientationValue
    LANDSCAPE : PrintPageOrientationValue
    UNDEFINED : PrintPageOrientationValue

class PropType:
    
    STRING : PropType
    BOOL : PropType
    DATE : PropType
    NUMBER : PropType

class RectangleAlignmentType:
    
    BOTTOM : RectangleAlignmentType
    BOTTOM_LEFT : RectangleAlignmentType
    BOTTOM_RIGHT : RectangleAlignmentType
    CENTER : RectangleAlignmentType
    LEFT : RectangleAlignmentType
    RIGHT : RectangleAlignmentType
    TOP : RectangleAlignmentType
    TOP_LEFT : RectangleAlignmentType
    TOP_RIGHT : RectangleAlignmentType

class ReflectionEffectType:
    
    NONE : ReflectionEffectType
    CUSTOM : ReflectionEffectType
    TIGHT_REFLECTION_TOUCHING : ReflectionEffectType
    HALF_REFLECTION_TOUCHING : ReflectionEffectType
    FULL_REFLECTION_TOUCHING : ReflectionEffectType
    TIGHT_REFLECTION_4_PT_OFFSET : ReflectionEffectType
    HALF_REFLECTION_4_PT_OFFSET : ReflectionEffectType
    FULL_REFLECTION_4_PT_OFFSET : ReflectionEffectType
    TIGHT_REFLECTION_8_PT_OFFSET : ReflectionEffectType
    HALF_REFLECTION_8_PT_OFFSET : ReflectionEffectType
    FULL_REFLECTION_8_PT_OFFSET : ReflectionEffectType

class RelationFlag:
    
    MEMBERS_OF_CONTAINER_SHAPES : RelationFlag
    MEMBERS_OF_LIST_SHAPES : RelationFlag
    ASSOCIATED_WITH_CALLOUTS : RelationFlag
    MEMBER_OF_CONTAINERS : RelationFlag
    MEMBER_OF_LIST : RelationFlag
    SHAPE_ASSOCIATED_WITH_CALLOUT : RelationFlag
    LEFT_BOUNDARY_EDGE : RelationFlag
    RIGHT_BOUNDARY_EDGE : RelationFlag
    TOP_BOUNDARY_EDGE : RelationFlag
    BOTTOM_BOUNDARY_EDGE : RelationFlag
    LIST_OVERLAPS : RelationFlag
    UNDEFINED : RelationFlag

class RemoveHiddenInfoItem:
    
    PERSONAL_INFO : RemoveHiddenInfoItem
    SHAPES : RemoveHiddenInfoItem
    MASTERS : RemoveHiddenInfoItem
    STYLES : RemoveHiddenInfoItem
    DATA_RECORD_SETS : RemoveHiddenInfoItem
    UNDEFINED : RemoveHiddenInfoItem

class ResizeModeValue:
    
    USE_GROUP_SETTING : ResizeModeValue
    REPOSITION_ONLY : ResizeModeValue
    SCALE_WITH_GROUP : ResizeModeValue
    UNDEFINED : ResizeModeValue

class RotationTypeValue:
    
    NONE : RotationTypeValue
    PARALLEL : RotationTypeValue
    PERSPECTIVE : RotationTypeValue
    OBLIQUE_FROM_TOP_LEFT : RotationTypeValue
    OBLIQUE_FROM_TOP_RIGHT : RotationTypeValue
    OBLIQUE_FROM_BOTTOM_LEFT : RotationTypeValue
    OBLIQUE_FROM_BOTTOM_RIGHT : RotationTypeValue
    UNDEFINED : RotationTypeValue

class RouteStyleValue:
    
    DEFAULT_RIGHT_ANGLE : RouteStyleValue
    RIGHT_ANGLE : RouteStyleValue
    STRAIGHT : RouteStyleValue
    ORGANIZATION_CHART_TOP_TO_BOTTOM : RouteStyleValue
    ORGANIZATION_CHART_LEFT_TO_RIGHT : RouteStyleValue
    FLOWCHART_TOP_TO_BOTTOM : RouteStyleValue
    FLOWCHART_LEFT_TO_RIGHT : RouteStyleValue
    TREE_TOP_TO_BOTTOM : RouteStyleValue
    TREE_LEFT_TO_RIGHT : RouteStyleValue
    NETWORK : RouteStyleValue
    ORGANIZATION_CHART_BOTTOM_TO_TOP : RouteStyleValue
    ORGANIZATION_CHART_RIGHT_TO_LEFT : RouteStyleValue
    FLOWCHART_BOTTOM_TO_TOP : RouteStyleValue
    FLOWCHART_RIGHT_TO_LEFT : RouteStyleValue
    TREE_BOTTOM_TO_TOP : RouteStyleValue
    TREE_RIGHT_TO_LEFT : RouteStyleValue
    CENTER_TO_CENTER : RouteStyleValue
    SIMPLE_TOP_TO_BOTTOM : RouteStyleValue
    SIMPLE_LEFT_TO_RIGHT : RouteStyleValue
    SIMPLE_BOTTOM_TO_TOP : RouteStyleValue
    SIMPLE_RIGHT_TO_LEFT : RouteStyleValue
    SIMPLE_HORIZONTAL_VERTICAL : RouteStyleValue
    SIMPLE_VERTICAL_HORIZONTAL : RouteStyleValue
    UNDEFINED : RouteStyleValue

class RulerDensityValue:
    
    COARSE : RulerDensityValue
    NORMAL : RulerDensityValue
    FINE : RulerDensityValue
    UNDEFINED : RulerDensityValue

class SaveFileFormat:
    
    VDX : SaveFileFormat
    VSX : SaveFileFormat
    VTX : SaveFileFormat
    TIFF : SaveFileFormat
    PNG : SaveFileFormat
    BMP : SaveFileFormat
    EMF : SaveFileFormat
    JPEG : SaveFileFormat
    PDF : SaveFileFormat
    XPS : SaveFileFormat
    GIF : SaveFileFormat
    HTML : SaveFileFormat
    SVG : SaveFileFormat
    SWF : SaveFileFormat
    XAML : SaveFileFormat
    VSDX : SaveFileFormat
    VSTX : SaveFileFormat
    VSSX : SaveFileFormat
    VSDM : SaveFileFormat
    VSSM : SaveFileFormat
    VSTM : SaveFileFormat
    CSV : SaveFileFormat
    VSD : SaveFileFormat
    VSS : SaveFileFormat
    VST : SaveFileFormat

class SelectModeValue:
    
    GROUP_SHAPE_ONLY : SelectModeValue
    GROUP_SHAPE_FIRST : SelectModeValue
    MEMBERS_GROUP_FIRST : SelectModeValue
    UNDEFINED : SelectModeValue

class ShapeFixedCodeValue:
    
    NO_MOVE_USING_LAY_OUT_SHAPES : ShapeFixedCodeValue
    NO_MOVE_AND_NO_ALLOW_SHAPES_PLACED : ShapeFixedCodeValue
    NO_MOVE_ALLOW_SHAPES_PLACED : ShapeFixedCodeValue
    IGNORE_CONNECTION_POINT : ShapeFixedCodeValue
    ALLOW_ROUTING_TO_SIDES_WITH_CONNECTION_POINTS : ShapeFixedCodeValue
    NO_GLUE_TO_PERIMETER : ShapeFixedCodeValue
    UNDEFINED : ShapeFixedCodeValue

class ShapePlaceFlipValue:
    
    USE_PAGE_DEFAULT : ShapePlaceFlipValue
    FLIP_HORIZONTAL : ShapePlaceFlipValue
    FLIP_VERTICAL : ShapePlaceFlipValue
    FLIP_90_DEGREE_INCREMENT_BETWEEN_0_AND_270 : ShapePlaceFlipValue
    NO_FLIP : ShapePlaceFlipValue
    UNDEFINED : ShapePlaceFlipValue

class ShapePlaceStyleValue:
    
    PLACE_DEFAULT : ShapePlaceStyleValue
    PLACE_TOP_TO_BOTTOM : ShapePlaceStyleValue
    PLACE_TO_RIGHT : ShapePlaceStyleValue
    PLACE_RADIAL : ShapePlaceStyleValue
    PLACE_BOTTOM_TO_TOP : ShapePlaceStyleValue
    PLACE_RIGHT_TO_LEFT : ShapePlaceStyleValue
    PLACE_CIRCULAR : ShapePlaceStyleValue
    PLACE_COMPACT_DOWN_RIGHT : ShapePlaceStyleValue
    PLACE_COMPACT_RIGHT_DOWN : ShapePlaceStyleValue
    PLACE_COMPACT_RIGHT_UP : ShapePlaceStyleValue
    PLACE_COMPACT_UP_RIGHT : ShapePlaceStyleValue
    PLACE_COMPACT_UP_LEFT : ShapePlaceStyleValue
    PLACE_COMPACT_LEFT_UP : ShapePlaceStyleValue
    PLACE_COMPACT_LEFT_DOWN : ShapePlaceStyleValue
    PLACE_COMPACT_DOWN_LEFT : ShapePlaceStyleValue
    PLACE_PARENT_DEFAULT : ShapePlaceStyleValue
    PLACE_HIERARCHY_TOP_TO_BOTTOM_LEFT : ShapePlaceStyleValue
    PLACE_HIERARCHY_TOP_TO_BOTTOM_CENTER : ShapePlaceStyleValue
    PLACE_HIERARCHY_TOP_TO_BOTTOM_RIGHT : ShapePlaceStyleValue
    PLACE_HIERARCHY_BOTTOM_TO_LEFT : ShapePlaceStyleValue
    PLACE_HIERARCHY_BOTTOM_TO_CENTER : ShapePlaceStyleValue
    PLACE_HIERARCHY_BOTTOM_TO_RIGHT : ShapePlaceStyleValue
    PLACE_HIERARCHY_LEFT_TO_RIGHT_TOP : ShapePlaceStyleValue
    PLACE_HIERARCHY_LEFT_TO_RIGHT_MIDDLE : ShapePlaceStyleValue
    PLACE_HIERARCHY_LEFT_TO_RIGHT_BOTTOM : ShapePlaceStyleValue
    PLACE_HIERARCHY_RIGHT_TO_LEFT_TOP : ShapePlaceStyleValue
    PLACE_HIERARCHY_RIGHT_TO_LEFT_MIDDLE : ShapePlaceStyleValue
    PLACE_HIERARCHY_RIGHT_TO_LEFT_BOTTOM : ShapePlaceStyleValue
    UNDEFINED : ShapePlaceStyleValue

class ShapePlowCodeValue:
    
    USE_PAGE_DEFAULT : ShapePlowCodeValue
    NOMOVE_SHAPE : ShapePlowCodeValue
    MOVE_SHAPE : ShapePlowCodeValue
    UNDEFINED : ShapePlowCodeValue

class ShapeRouteStyleValue:
    
    PAGE_DEFAULT : ShapeRouteStyleValue
    RIGHT_ANGLE : ShapeRouteStyleValue
    STRAIGHT : ShapeRouteStyleValue
    ORGANIZATION_CHART_TOP_TO_BOTTOM : ShapeRouteStyleValue
    ORGANIZATION_CHART_LEFT_TO_RIGHT : ShapeRouteStyleValue
    FLOWCHART_TOP_TO_BOTTOM : ShapeRouteStyleValue
    FLOWCHART_LEFT_TO_RIGHT : ShapeRouteStyleValue
    TREE_TOP_TO_BOTTOM : ShapeRouteStyleValue
    TREE_LEFT_TO_RIGHT : ShapeRouteStyleValue
    NETWORK : ShapeRouteStyleValue
    ORGANIZATION_CHART_BOTTOM_TO_TOP : ShapeRouteStyleValue
    ORGANIZATION_CHART_RIGHT_TO_LEFT : ShapeRouteStyleValue
    FLOWCHART_BOTTOM_TO_TOP : ShapeRouteStyleValue
    FLOWCHART_RIGHT_TO_LEFT : ShapeRouteStyleValue
    TREE_BOTTOM_TO_TOP : ShapeRouteStyleValue
    TREE_RIGHT_TO_LEFT : ShapeRouteStyleValue
    CENTER_TO_CENTER : ShapeRouteStyleValue
    SIMPLE_TOP_TO_BOTTOM : ShapeRouteStyleValue
    SIMPLE_LEFT_TO_RIGHT : ShapeRouteStyleValue
    SIMPLE_BOTTOM_TO_TOP : ShapeRouteStyleValue
    SIMPLE_RIGHT_TO_LEFT : ShapeRouteStyleValue
    SIMPLE_HORIZONTAL_VERTICAL : ShapeRouteStyleValue
    SIMPLE_VERTICAL_HORIZONTAL : ShapeRouteStyleValue
    UNDEFINED : ShapeRouteStyleValue

class ShapeShdwShowValue:
    
    HAS_GEOM_SHOW : ShapeShdwShowValue
    TOP_LEVEL_SHOW : ShapeShdwShowValue
    ALWAYS_SHOW : ShapeShdwShowValue
    UNDEFINED : ShapeShdwShowValue

class ShapeShdwTypeValue:
    
    USE_PAGE : ShapeShdwTypeValue
    SIMPLE : ShapeShdwTypeValue
    OBLIQUE : ShapeShdwTypeValue
    INNER : ShapeShdwTypeValue
    UNDEFINED : ShapeShdwTypeValue

class ShdwTypeValue:
    
    SIMPLE : ShdwTypeValue
    OBLIQUE : ShdwTypeValue
    UNDEFINED : ShdwTypeValue

class SnapExtensions:
    
    NONE : SnapExtensions
    ALIGNMENT_BOX_EXTENSION : SnapExtensions
    CENTER_AXES : SnapExtensions
    CURVE_TANGENT : SnapExtensions
    ENDPOINT : SnapExtensions
    MIDPOINT : SnapExtensions
    LINEAR_EXTENSION : SnapExtensions
    CURVE_EXTENSION : SnapExtensions
    ENDPOINT_PERPENDICULAR : SnapExtensions
    MIDPOINT_PERPENDICULAR : SnapExtensions
    ENDPOINT_HORIZONTAL : SnapExtensions
    ENDPOINT_VERTICAL : SnapExtensions
    ELLIPSE_CENTER : SnapExtensions
    ISOMETRIC_ANGLES : SnapExtensions
    UNDEFINED : SnapExtensions

class SnapExtensionsValue:
    
    SNAP_TO_NOTHING : SnapExtensionsValue
    SNAP_TO_ALIGNMENT_BOX_EXTENSION : SnapExtensionsValue
    SNAP_TO_CENTER_AXIS_EXTENSION : SnapExtensionsValue
    SNAP_TO_CURVE_TANGENT_EXTENSION : SnapExtensionsValue
    SNAP_TO_END_POINT_EXTENSION : SnapExtensionsValue
    SNAP_TO_MID_POINT_EXTENSION : SnapExtensionsValue
    SNAP_TO_LINEAR_EXTENSION : SnapExtensionsValue
    SNAP_TO_CURVE_EXTENSION : SnapExtensionsValue
    SNAP_TO_END_POINT_PERPENDICULAR_EXTENSION : SnapExtensionsValue
    SNAP_TO_MID_POINT_PERPENDICULAR_EXTENSION : SnapExtensionsValue
    SNAP_TO_END_POINT_HORIZONTAL_EXTENSION : SnapExtensionsValue
    SNAP_TO_END_POINT_VERTICAL_EXTENSION : SnapExtensionsValue
    SNAP_TO_ELLIPSE_CENTER_EXTENSION : SnapExtensionsValue
    SNAP_TO_ISOMETRIC_ANGLES_EXTENSION : SnapExtensionsValue
    UNDEFINED : SnapExtensionsValue

class SnapSettings:
    
    NONE : SnapSettings
    RULER_SUBDIVISIONS : SnapSettings
    GRID : SnapSettings
    GUIDES : SnapSettings
    HANDLES : SnapSettings
    VERTICES : SnapSettings
    CONNECTION_POINTS : SnapSettings
    GEOMETRY : SnapSettings
    ALIGNMENT_BOX : SnapSettings
    EXTENSIONS : SnapSettings
    DISABLED : SnapSettings
    INTERSECTIONS : SnapSettings
    UNDEFINED : SnapSettings

class SnapSettingsValue:
    
    SNAP_TO_NOTHING : SnapSettingsValue
    SNAP_TO_RULER_SUBDIVISIONS : SnapSettingsValue
    SNAP_TO_GRID : SnapSettingsValue
    SNAP_TO_GUIDES : SnapSettingsValue
    SNAP_TO_SELECTION_HANDLES : SnapSettingsValue
    SNAP_TO_VERTICES : SnapSettingsValue
    SNAP_TO_CONNECTION_POINTS : SnapSettingsValue
    SNAP_TO_THE_VISIBLE_EDGES_OF_SHAPES : SnapSettingsValue
    SNAP_TO_ALIGNMENT_BOX : SnapSettingsValue
    SNAP_TO_SHAPE_EXTENSIONS_OPTIONS : SnapSettingsValue
    SNAP_DISABLED : SnapSettingsValue
    SNAP_TO_INTERSECTIONS : SnapSettingsValue
    UNDEFINED : SnapSettingsValue

class StyleValue:
    
    BOLD : StyleValue
    ITALIC : StyleValue
    UNDERLINE : StyleValue
    SMALL_CAPS : StyleValue
    UNDEFINED : StyleValue

class TextDirectionValue:
    
    HORIZONTAL : TextDirectionValue
    VERTICAL : TextDirectionValue
    UNDEFINED : TextDirectionValue

class ToPartValue:
    
    NONE : ToPartValue
    GUIDE_X : ToPartValue
    GUIDE_Y : ToPartValue
    WHOLE_SHAPE : ToPartValue
    GUIDE_INTERSECTION : ToPartValue
    TO_ANGLE : ToPartValue
    CONNECTION_POINT : ToPartValue
    UNDEFINED : ToPartValue

class TypeConnectionValue:
    
    INWARD : TypeConnectionValue
    OUTWARD : TypeConnectionValue
    INWARD_OUTWARD : TypeConnectionValue
    UNDEFINED : TypeConnectionValue

class TypeFieldValue:
    
    STRING : TypeFieldValue
    NUMBER : TypeFieldValue
    DATE_TIME : TypeFieldValue
    DURATION : TypeFieldValue
    CURRENCY : TypeFieldValue
    UNDEFINED : TypeFieldValue

class TypePropValue:
    
    STRING : TypePropValue
    FIXED_LIST : TypePropValue
    NUMBER : TypePropValue
    BOOLEAN : TypePropValue
    VARIABLE_LIST : TypePropValue
    DATE_TIME : TypePropValue
    DURATION : TypePropValue
    CURRENCY : TypePropValue
    UNDEFINED : TypePropValue

class TypeValue:
    
    GROUP : TypeValue
    SHAPE : TypeValue
    GUIDE : TypeValue
    FOREIGN : TypeValue
    UNDEFINED : TypeValue

class UIVisibilityValue:
    
    VISIBLE : UIVisibilityValue
    HIDDEN : UIVisibilityValue
    UNDEFINED : UIVisibilityValue

class VerticalAlignValue:
    
    TOP : VerticalAlignValue
    MIDDLE : VerticalAlignValue
    BOTTOM : VerticalAlignValue
    UNDEFINED : VerticalAlignValue

class VisRuleTargetsValue:
    
    VIS_RULE_TARGET_SHAPE : VisRuleTargetsValue
    VIS_RULE_TARGET_PAGE : VisRuleTargetsValue
    VIS_RULE_TARGET_DOCUMENT : VisRuleTargetsValue
    UNDEFINED : VisRuleTargetsValue

class WalkPreferenceValue:
    
    SIDE_TO_SIDE_CONNECTIONS : WalkPreferenceValue
    TOP_TO_SIDE_OR_BOTTOM_TO_SIDE_CONNECTIONS : WalkPreferenceValue
    SIDE_TO_TOP_OR_SIDE_TO_BOTTOM_CONNECTIONS : WalkPreferenceValue
    TOP_TO_BOTTOM_CONNECTIONS : WalkPreferenceValue
    UNDEFINED : WalkPreferenceValue

class WarningType:
    
    FONT_SUBSTITUTION : WarningType
    UNSUPPORTED_IMAGE_TYPE : WarningType

class WindowStateValue:
    
    RESTORED : WindowStateValue
    MAXIMIZED : WindowStateValue
    MINIMIZED : WindowStateValue
    DOCKED_LEFT : WindowStateValue
    DOCKED_TOP : WindowStateValue
    DOCKED_RIGHT : WindowStateValue
    DOCKED_BOTTOM : WindowStateValue
    DOUBLEING : WindowStateValue
    ANCHOR_LEFT : WindowStateValue
    ANCHOR_TOP : WindowStateValue
    ANCHOR_RIGHT : WindowStateValue
    ANCHOR_BOTTOM : WindowStateValue
    ANCHOR_MERGED : WindowStateValue
    ACTIVE : WindowStateValue
    UNDEFINED : WindowStateValue

class WindowTypeValue:
    
    DRAWING : WindowTypeValue
    STENCIL : WindowTypeValue
    SHEET : WindowTypeValue
    ICON : WindowTypeValue
    UNDEFINED : WindowTypeValue

class XJustifyValue:
    
    LEFT_JUSTIFIED : XJustifyValue
    CENTERED : XJustifyValue
    RIGHT_JUSTIFIED : XJustifyValue
    UNDEFINED : XJustifyValue

class YJustifyValue:
    
    TOP_JUSTIFIED : YJustifyValue
    CENTERED : YJustifyValue
    BOTTOM_JUSTIFIED : YJustifyValue
    UNDEFINED : YJustifyValue

