"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicaKey = exports.CfnKey = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-04-27T22:50:33.626Z","fingerprint":"DUqAfiBAmvesbkTk6rK3BpsH5QW3YKK8BKbuqXo3tHg="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasName', cdk.requiredValidator)(properties.aliasName));
    errors.collect(cdk.propertyValidator('aliasName', cdk.validateString)(properties.aliasName));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.requiredValidator)(properties.targetKeyId));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.validateString)(properties.targetKeyId));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        AliasName: cdk.stringToCloudFormation(properties.aliasName),
        TargetKeyId: cdk.stringToCloudFormation(properties.targetKeyId),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasName', 'AliasName', cfn_parse.FromCloudFormation.getString(properties.AliasName));
    ret.addPropertyResult('targetKeyId', 'TargetKeyId', cfn_parse.FromCloudFormation.getString(properties.TargetKeyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Alias`
 *
 * The `AWS::KMS::Alias` resource specifies a display name for a [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) . You can use an alias to identify a KMS key in the AWS KMS console, in the [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html) operation, and in [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) , such as [Decrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html) and [GenerateDataKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey.html) .
 *
 * > Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see [ABAC for AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * Using an alias to refer to a KMS key can help you simplify key management. For example, an alias in your code can be associated with different KMS keys in different AWS Regions . For more information, see [Using aliases](https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html) in the *AWS Key Management Service Developer Guide* .
 *
 * When specifying an alias, observe the following rules.
 *
 * - Each alias is associated with one KMS key, but multiple aliases can be associated with the same KMS key.
 * - The alias and its associated KMS key must be in the same AWS account and Region.
 * - The alias name must be unique in the AWS account and Region. However, you can create aliases with the same name in different AWS Regions . For example, you can have an `alias/projectKey` in multiple Regions, each of which is associated with a KMS key in its Region.
 * - Each alias name must begin with `alias/` followed by a name, such as `alias/exampleKey` . The alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). Alias names cannot begin with `alias/aws/` . That alias name prefix is reserved for [AWS managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) .
 *
 * @cloudformationResource AWS::KMS::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'aliasName', this);
        cdk.requireProperty(props, 'targetKeyId', this);
        this.aliasName = props.aliasName;
        this.targetKeyId = props.targetKeyId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            aliasName: this.aliasName,
            targetKeyId: this.targetKeyId,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
exports.CfnAlias = CfnAlias;
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "@aws-cdk/aws-kms.CfnAlias", version: "1.154.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Alias";
/**
 * Determine whether the given properties match those of a `CfnKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enableKeyRotation', cdk.validateBoolean)(properties.enableKeyRotation));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keySpec', cdk.validateString)(properties.keySpec));
    errors.collect(cdk.propertyValidator('keyUsage', cdk.validateString)(properties.keyUsage));
    errors.collect(cdk.propertyValidator('multiRegion', cdk.validateBoolean)(properties.multiRegion));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Key` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Key` resource.
 */
// @ts-ignore TS6133
function cfnKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EnableKeyRotation: cdk.booleanToCloudFormation(properties.enableKeyRotation),
        KeySpec: cdk.stringToCloudFormation(properties.keySpec),
        KeyUsage: cdk.stringToCloudFormation(properties.keyUsage),
        MultiRegion: cdk.booleanToCloudFormation(properties.multiRegion),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('enableKeyRotation', 'EnableKeyRotation', properties.EnableKeyRotation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableKeyRotation) : undefined);
    ret.addPropertyResult('keySpec', 'KeySpec', properties.KeySpec != null ? cfn_parse.FromCloudFormation.getString(properties.KeySpec) : undefined);
    ret.addPropertyResult('keyUsage', 'KeyUsage', properties.KeyUsage != null ? cfn_parse.FromCloudFormation.getString(properties.KeyUsage) : undefined);
    ret.addPropertyResult('multiRegion', 'MultiRegion', properties.MultiRegion != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegion) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Key`
 *
 * The `AWS::KMS::Key` resource specifies an [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in AWS Key Management Service . You can use this resource to create symmetric encryption KMS keys, asymmetric KMS keys for encryption or signing, and symmetric HMAC KMS keys. You can use `AWS::KMS::Key` to create [multi-Region primary keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-primary-key) of all supported types. To replicate a multi-Region key, use the `AWS::KMS::ReplicaKey` resource.
 *
 * You cannot use the `AWS::KMS::Key` resource to specify a KMS key with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) or a KMS key in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) .
 *
 * > AWS KMS replaced the term *customer master key (CMK)* with *AWS KMS key* and *KMS key* . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 *
 * You can use symmetric encryption KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use a symmetric encryption KMS key to encrypt data stored in AWS services that are [integrated with AWS KMS](https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration) . For more information, see [Symmetric encryption KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric `KeySpec` value and a `KeyUsage` value. For details, see [Asymmetric keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use HMAC KMS keys (which are also symmetric keys) to generate and verify hash-based message authentication codes. To create an HMAC key, you must specify an HMAC `KeySpec` value and a `KeyUsage` value of `GENERATE_VERIFY_MAC` . For details, see [HMAC keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can also create symmetric encryption, asymmetric, and HMAC multi-Region primary keys. To create a multi-Region primary key, set the `MultiRegion` property to `true` . For information about multi-Region keys, see [Multi-Region keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * > If you change the value of the `KeyUsage` , `KeySpec` , or `MultiRegion` property on an existing KMS key, the existing KMS key is [scheduled for deletion](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html) and a new KMS key is created with the specified value.
 * >
 * > While scheduled for deletion, the existing KMS key becomes unusable. If you don't [cancel the scheduled deletion](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion) of the existing KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage asymmetric KMS keys or multi-Region KMS keys (primary or replica).
 *
 * @cloudformationResource AWS::KMS::Key
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
 */
class CfnKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.description = props.description;
        this.enabled = props.enabled;
        this.enableKeyRotation = props.enableKeyRotation;
        this.keySpec = props.keySpec;
        this.keyUsage = props.keyUsage;
        this.multiRegion = props.multiRegion;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::Key", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            description: this.description,
            enabled: this.enabled,
            enableKeyRotation: this.enableKeyRotation,
            keySpec: this.keySpec,
            keyUsage: this.keyUsage,
            multiRegion: this.multiRegion,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnKeyPropsToCloudFormation(props);
    }
}
exports.CfnKey = CfnKey;
_b = JSII_RTTI_SYMBOL_1;
CfnKey[_b] = { fqn: "@aws-cdk/aws-kms.CfnKey", version: "1.154.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Key";
/**
 * Determine whether the given properties match those of a `CfnReplicaKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicaKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.requiredValidator)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.validateString)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicaKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource.
 */
// @ts-ignore TS6133
function cfnReplicaKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicaKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        PrimaryKeyArn: cdk.stringToCloudFormation(properties.primaryKeyArn),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicaKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('primaryKeyArn', 'PrimaryKeyArn', cfn_parse.FromCloudFormation.getString(properties.PrimaryKeyArn));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::ReplicaKey`
 *
 * The `AWS::KMS::ReplicaKey` resource specifies a multi-Region replica key that is based on a multi-Region primary key.
 *
 * *Multi-Region keys* are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see [Multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * A multi-Region *primary key* is a fully functional symmetric encryption KMS key, HMAC KMS key, or asymmetric KMS key that is also the model for replica keys in other AWS Regions . To create a multi-Region primary key, add an [AWS::KMS::Key](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html) resource to your CloudFormation stack. Set its `MultiRegion` property to true.
 *
 * A multi-Region *replica key* is a fully functional KMS key that has the same key ID and key material as a multi-Region primary key, but is located in a different AWS Region of the same AWS partition. There can be multiple replicas of a primary key, but each must be in a different AWS Region .
 *
 * When you create a replica key in AWS CloudFormation , the replica key is created in the AWS Region represented by the endpoint you use for the request. If you try to replicate a multi-Region key into a Region in which the key type is not supported, the request will fail.
 *
 * > HMAC KMS keys are not supported in all AWS Regions . For a list of supported Regions, see [HMAC keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html#hmac-regions) in the *AWS Key Management Service Developer Guide* .
 *
 * A primary key and its replicas have the same key ID and key material. They also have the same key spec, key usage, key material origin, and automatic key rotation status. These properties are known as *shared properties* . If they change, AWS KMS synchronizes the change to all related multi-Region keys. All other properties of a replica key can differ, including its key policy, tags, aliases, and key state. AWS KMS does not synchronize these properties.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage multi-Region KMS keys (primary or replica).
 *
 * @cloudformationResource AWS::KMS::ReplicaKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html
 */
class CfnReplicaKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::ReplicaKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicaKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnReplicaKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        cdk.requireProperty(props, 'primaryKeyArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.primaryKeyArn = props.primaryKeyArn;
        this.description = props.description;
        this.enabled = props.enabled;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::ReplicaKey", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicaKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicaKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicaKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            primaryKeyArn: this.primaryKeyArn,
            description: this.description,
            enabled: this.enabled,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicaKeyPropsToCloudFormation(props);
    }
}
exports.CfnReplicaKey = CfnReplicaKey;
_c = JSII_RTTI_SYMBOL_1;
CfnReplicaKey[_c] = { fqn: "@aws-cdk/aws-kms.CfnReplicaKey", version: "1.154.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicaKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::ReplicaKey";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImttcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsK0VBQStFO0FBQy9FLCtEQUErRDtBQUMvRCw4RkFBOEY7QUFDOUYsc0hBQXNIO0FBRXRILDRCQUE0QixDQUFDLGlFQUFpRTtBQUU5RixxQ0FBcUM7QUFDckMsZ0VBQWdFO0FBa0RoRTs7Ozs7O0dBTUc7QUFDSCxTQUFTLHNCQUFzQixDQUFDLFVBQWU7SUFDM0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO0FBQzlFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2QkFBNkIsQ0FBQyxVQUFlO0lBQ2xELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNuRCxPQUFPO1FBQ0gsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNELFdBQVcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztLQUNsRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLCtCQUErQixDQUFDLFVBQWU7SUFDcEQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBaUIsQ0FBQztJQUM1RSxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzlHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEgsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQW9CRztBQUNILE1BQWEsUUFBUyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBOER6Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW9CO1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUMvRSxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDOUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBRWhELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7S0FDeEM7SUF0RUQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLCtCQUErQixDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDeEUsTUFBTSxHQUFHLEdBQUcsSUFBSSxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdkQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBdUREOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsUUFBUSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDdkYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7U0FDaEMsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw2QkFBNkIsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUMvQzs7QUFsR0wsNEJBbUdDOzs7QUFsR0c7O0dBRUc7QUFDb0IsK0JBQXNCLEdBQUcsaUJBQWlCLENBQUM7QUFpUXRFOzs7Ozs7R0FNRztBQUNILFNBQVMsb0JBQW9CLENBQUMsVUFBZTtJQUN6QyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM5RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzFGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2xHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxtREFBbUQsQ0FBQyxDQUFDO0FBQzVFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywyQkFBMkIsQ0FBQyxVQUFlO0lBQ2hELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxvQkFBb0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRCxPQUFPO1FBQ0gsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNELFdBQVcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUMvRCxPQUFPLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDeEQsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUM1RSxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3pELFdBQVcsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUNoRSxtQkFBbUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQy9FLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw2QkFBNkIsQ0FBQyxVQUFlO0lBQ2xELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWUsQ0FBQztJQUMxRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFVBQVUsQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakssR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsSixHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFVBQVUsQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDbEssR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBNkJHO0FBQ0gsTUFBYSxNQUFPLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUE4THZDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBa0I7UUFDNUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsTUFBTSxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBQzdFLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM5QyxJQUFJLENBQUMsT0FBTyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUN0RCxJQUFJLENBQUMsU0FBUyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUUxRCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7UUFDckQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsZUFBZSxFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxlQUFlLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUNsSDtJQTlNRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsNkJBQTZCLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN0RSxNQUFNLEdBQUcsR0FBRyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNyRCxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUErTEQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxNQUFNLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNyRixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtTQUMvQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLDJCQUEyQixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzdDOztBQWpQTCx3QkFrUEM7OztBQWpQRzs7R0FFRztBQUNvQiw2QkFBc0IsR0FBRyxlQUFlLENBQUM7QUF1VnBFOzs7Ozs7R0FNRztBQUNILFNBQVMsMkJBQTJCLENBQUMsVUFBZTtJQUNoRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzFGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUN4RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywwREFBMEQsQ0FBQyxDQUFDO0FBQ25GLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxrQ0FBa0MsQ0FBQyxVQUFlO0lBQ3ZELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwyQkFBMkIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN4RCxPQUFPO1FBQ0gsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNELGFBQWEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNuRSxXQUFXLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDL0QsT0FBTyxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3hELG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDL0UsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLG9DQUFvQyxDQUFDLFVBQWU7SUFDekQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBc0IsQ0FBQztJQUNqRixHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDMUgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsVUFBVSxDQUFDLFdBQVcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2xKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBeUJHO0FBQ0gsTUFBYSxhQUFjLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFxSTlDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsYUFBYSxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBQ3BGLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM5QyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxlQUFlLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDbEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxDQUFDLFNBQVMsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFFMUQsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7UUFDckQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQ3pIO0lBbkpEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyxvQ0FBb0MsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzdFLE1BQU0sR0FBRyxHQUFHLElBQUksYUFBYSxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzVELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQW9JRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLGFBQWEsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQzVGLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7U0FDL0IsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxrQ0FBa0MsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNwRDs7QUFuTEwsc0NBb0xDOzs7QUFuTEc7O0dBRUc7QUFDb0Isb0NBQXNCLEdBQUcsc0JBQXNCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxMi0yMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIFJlc291cmNlIFNwZWNpZmljYXRpb25cbi8vIFNlZTogZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1yZXNvdXJjZS1zcGVjaWZpY2F0aW9uLmh0bWxcbi8vIEBjZm4ydHM6bWV0YUAge1wiZ2VuZXJhdGVkXCI6XCIyMDIyLTA0LTI3VDIyOjUwOjMzLjYyNlpcIixcImZpbmdlcnByaW50XCI6XCJEVXFBZmlCQW12ZXNia1RrNnJLM0Jwc0g1UVczWUtLOEJLYnVxWG8zdEhnPVwifVxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNmbl9wYXJzZSBmcm9tICdAYXdzLWNkay9jb3JlL2xpYi9oZWxwZXJzLWludGVybmFsJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5BbGlhc2BcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWFsaWFzLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5BbGlhc1Byb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgYWxpYXMgbmFtZS4gVGhpcyB2YWx1ZSBtdXN0IGJlZ2luIHdpdGggYGFsaWFzL2AgZm9sbG93ZWQgYnkgYSBuYW1lLCBzdWNoIGFzIGBhbGlhcy9FeGFtcGxlQWxpYXNgIC5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IGNoYW5nZSB0aGUgdmFsdWUgb2YgYSBgUmVwbGFjZW1lbnRgIHByb3BlcnR5LCBzdWNoIGFzIGBBbGlhc05hbWVgICwgdGhlIGV4aXN0aW5nIGFsaWFzIGlzIGRlbGV0ZWQgYW5kIGEgbmV3IGFsaWFzIGlzIGNyZWF0ZWQgZm9yIHRoZSBzcGVjaWZpZWQgS01TIGtleS4gVGhpcyBjaGFuZ2UgY2FuIGRpc3J1cHQgYXBwbGljYXRpb25zIHRoYXQgdXNlIHRoZSBhbGlhcy4gSXQgY2FuIGFsc28gYWxsb3cgb3IgZGVueSBhY2Nlc3MgdG8gYSBLTVMga2V5IGFmZmVjdGVkIGJ5IGF0dHJpYnV0ZS1iYXNlZCBhY2Nlc3MgY29udHJvbCAoQUJBQykuXG4gICAgICpcbiAgICAgKiBUaGUgYWxpYXMgbXVzdCBiZSBzdHJpbmcgb2YgMS0yNTYgY2hhcmFjdGVycy4gSXQgY2FuIGNvbnRhaW4gb25seSBhbHBoYW51bWVyaWMgY2hhcmFjdGVycywgZm9yd2FyZCBzbGFzaGVzICgvKSwgdW5kZXJzY29yZXMgKF8pLCBhbmQgZGFzaGVzICgtKS4gVGhlIGFsaWFzIG5hbWUgY2Fubm90IGJlZ2luIHdpdGggYGFsaWFzL2F3cy9gIC4gVGhlIGBhbGlhcy9hd3MvYCBwcmVmaXggaXMgcmVzZXJ2ZWQgZm9yIFtBV1MgbWFuYWdlZCBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jb25jZXB0cy5odG1sI2F3cy1tYW5hZ2VkLWNtaykgLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYGFsaWFzL15bYS16QS1aMC05L18tXSskYFxuICAgICAqXG4gICAgICogKk1pbmltdW0qIDogYDFgXG4gICAgICpcbiAgICAgKiAqTWF4aW11bSogOiBgMjU2YFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWFsaWFzLmh0bWwjY2ZuLWttcy1hbGlhcy1hbGlhc25hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBhbGlhc05hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEFzc29jaWF0ZXMgdGhlIGFsaWFzIHdpdGggdGhlIHNwZWNpZmllZCBbY3VzdG9tZXIgbWFuYWdlZCBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmNlcHRzLmh0bWwjY3VzdG9tZXItY21rKSAuIFRoZSBLTVMga2V5IG11c3QgYmUgaW4gdGhlIHNhbWUgQVdTIGFjY291bnQgYW5kIFJlZ2lvbi5cbiAgICAgKlxuICAgICAqIEEgdmFsaWQga2V5IElEIGlzIHJlcXVpcmVkLiBJZiB5b3Ugc3VwcGx5IGEgbnVsbCBvciBlbXB0eSBzdHJpbmcgdmFsdWUsIHRoaXMgb3BlcmF0aW9uIHJldHVybnMgYW4gZXJyb3IuXG4gICAgICpcbiAgICAgKiBGb3IgaGVscCBmaW5kaW5nIHRoZSBrZXkgSUQgYW5kIEFSTiwgc2VlIFtGaW5kaW5nIHRoZSBrZXkgSUQgYW5kIEFSTl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdmlld2luZy1rZXlzLmh0bWwjZmluZC1jbWstaWQtYXJuKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogU3BlY2lmeSB0aGUga2V5IElEIG9yIHRoZSBrZXkgQVJOIG9mIHRoZSBLTVMga2V5LlxuICAgICAqXG4gICAgICogRm9yIGV4YW1wbGU6XG4gICAgICpcbiAgICAgKiAtIEtleSBJRDogYDEyMzRhYmNkLTEyYWItMzRjZC01NmVmLTEyMzQ1Njc4OTBhYmBcbiAgICAgKiAtIEtleSBBUk46IGBhcm46YXdzOmttczp1cy1lYXN0LTI6MTExMTIyMjIzMzMzOmtleS8xMjM0YWJjZC0xMmFiLTM0Y2QtNTZlZi0xMjM0NTY3ODkwYWJgXG4gICAgICpcbiAgICAgKiBUbyBnZXQgdGhlIGtleSBJRCBhbmQga2V5IEFSTiBmb3IgYSBLTVMga2V5LCB1c2UgW0xpc3RLZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RLZXlzLmh0bWwpIG9yIFtEZXNjcmliZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUtleS5odG1sKSAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMtYWxpYXMuaHRtbCNjZm4ta21zLWFsaWFzLXRhcmdldGtleWlkXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0S2V5SWQ6IHN0cmluZztcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5BbGlhc1Byb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5BbGlhc1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkFsaWFzUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhbGlhc05hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYWxpYXNOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhbGlhc05hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYWxpYXNOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YXJnZXRLZXlJZCcsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy50YXJnZXRLZXlJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFyZ2V0S2V5SWQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudGFyZ2V0S2V5SWQpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuQWxpYXNQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6S01TOjpBbGlhc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuQWxpYXNQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6S01TOjpBbGlhc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5BbGlhc1Byb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BbGlhc1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBBbGlhc05hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYWxpYXNOYW1lKSxcbiAgICAgICAgVGFyZ2V0S2V5SWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudGFyZ2V0S2V5SWQpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BbGlhc1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQWxpYXNQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQWxpYXNQcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2FsaWFzTmFtZScsICdBbGlhc05hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkFsaWFzTmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFyZ2V0S2V5SWQnLCAnVGFyZ2V0S2V5SWQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlRhcmdldEtleUlkKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpLTVM6OkFsaWFzYFxuICpcbiAqIFRoZSBgQVdTOjpLTVM6OkFsaWFzYCByZXNvdXJjZSBzcGVjaWZpZXMgYSBkaXNwbGF5IG5hbWUgZm9yIGEgW0tNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmNlcHRzLmh0bWwja21zX2tleXMpIC4gWW91IGNhbiB1c2UgYW4gYWxpYXMgdG8gaWRlbnRpZnkgYSBLTVMga2V5IGluIHRoZSBBV1MgS01TIGNvbnNvbGUsIGluIHRoZSBbRGVzY3JpYmVLZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVLZXkuaHRtbCkgb3BlcmF0aW9uLCBhbmQgaW4gW2NyeXB0b2dyYXBoaWMgb3BlcmF0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvY29uY2VwdHMuaHRtbCNjcnlwdG9ncmFwaGljLW9wZXJhdGlvbnMpICwgc3VjaCBhcyBbRGVjcnlwdF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWNyeXB0Lmh0bWwpIGFuZCBbR2VuZXJhdGVEYXRhS2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dlbmVyYXRlRGF0YUtleS5odG1sKSAuXG4gKlxuICogPiBBZGRpbmcsIGRlbGV0aW5nLCBvciB1cGRhdGluZyBhbiBhbGlhcyBjYW4gYWxsb3cgb3IgZGVueSBwZXJtaXNzaW9uIHRvIHRoZSBLTVMga2V5LiBGb3IgZGV0YWlscywgc2VlIFtBQkFDIGZvciBBV1MgS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hYmFjLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gKlxuICogVXNpbmcgYW4gYWxpYXMgdG8gcmVmZXIgdG8gYSBLTVMga2V5IGNhbiBoZWxwIHlvdSBzaW1wbGlmeSBrZXkgbWFuYWdlbWVudC4gRm9yIGV4YW1wbGUsIGFuIGFsaWFzIGluIHlvdXIgY29kZSBjYW4gYmUgYXNzb2NpYXRlZCB3aXRoIGRpZmZlcmVudCBLTVMga2V5cyBpbiBkaWZmZXJlbnQgQVdTIFJlZ2lvbnMgLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtVc2luZyBhbGlhc2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9rbXMtYWxpYXMuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiBXaGVuIHNwZWNpZnlpbmcgYW4gYWxpYXMsIG9ic2VydmUgdGhlIGZvbGxvd2luZyBydWxlcy5cbiAqXG4gKiAtIEVhY2ggYWxpYXMgaXMgYXNzb2NpYXRlZCB3aXRoIG9uZSBLTVMga2V5LCBidXQgbXVsdGlwbGUgYWxpYXNlcyBjYW4gYmUgYXNzb2NpYXRlZCB3aXRoIHRoZSBzYW1lIEtNUyBrZXkuXG4gKiAtIFRoZSBhbGlhcyBhbmQgaXRzIGFzc29jaWF0ZWQgS01TIGtleSBtdXN0IGJlIGluIHRoZSBzYW1lIEFXUyBhY2NvdW50IGFuZCBSZWdpb24uXG4gKiAtIFRoZSBhbGlhcyBuYW1lIG11c3QgYmUgdW5pcXVlIGluIHRoZSBBV1MgYWNjb3VudCBhbmQgUmVnaW9uLiBIb3dldmVyLCB5b3UgY2FuIGNyZWF0ZSBhbGlhc2VzIHdpdGggdGhlIHNhbWUgbmFtZSBpbiBkaWZmZXJlbnQgQVdTIFJlZ2lvbnMgLiBGb3IgZXhhbXBsZSwgeW91IGNhbiBoYXZlIGFuIGBhbGlhcy9wcm9qZWN0S2V5YCBpbiBtdWx0aXBsZSBSZWdpb25zLCBlYWNoIG9mIHdoaWNoIGlzIGFzc29jaWF0ZWQgd2l0aCBhIEtNUyBrZXkgaW4gaXRzIFJlZ2lvbi5cbiAqIC0gRWFjaCBhbGlhcyBuYW1lIG11c3QgYmVnaW4gd2l0aCBgYWxpYXMvYCBmb2xsb3dlZCBieSBhIG5hbWUsIHN1Y2ggYXMgYGFsaWFzL2V4YW1wbGVLZXlgIC4gVGhlIGFsaWFzIG5hbWUgY2FuIGNvbnRhaW4gb25seSBhbHBoYW51bWVyaWMgY2hhcmFjdGVycywgZm9yd2FyZCBzbGFzaGVzICgvKSwgdW5kZXJzY29yZXMgKF8pLCBhbmQgZGFzaGVzICgtKS4gQWxpYXMgbmFtZXMgY2Fubm90IGJlZ2luIHdpdGggYGFsaWFzL2F3cy9gIC4gVGhhdCBhbGlhcyBuYW1lIHByZWZpeCBpcyByZXNlcnZlZCBmb3IgW0FXUyBtYW5hZ2VkIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmNlcHRzLmh0bWwjYXdzLW1hbmFnZWQtY21rKSAuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpLTVM6OkFsaWFzXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWFsaWFzLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkFsaWFzIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6S01TOjpBbGlhc1wiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuQWxpYXMge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkFsaWFzUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkFsaWFzKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgYWxpYXMgbmFtZS4gVGhpcyB2YWx1ZSBtdXN0IGJlZ2luIHdpdGggYGFsaWFzL2AgZm9sbG93ZWQgYnkgYSBuYW1lLCBzdWNoIGFzIGBhbGlhcy9FeGFtcGxlQWxpYXNgIC5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IGNoYW5nZSB0aGUgdmFsdWUgb2YgYSBgUmVwbGFjZW1lbnRgIHByb3BlcnR5LCBzdWNoIGFzIGBBbGlhc05hbWVgICwgdGhlIGV4aXN0aW5nIGFsaWFzIGlzIGRlbGV0ZWQgYW5kIGEgbmV3IGFsaWFzIGlzIGNyZWF0ZWQgZm9yIHRoZSBzcGVjaWZpZWQgS01TIGtleS4gVGhpcyBjaGFuZ2UgY2FuIGRpc3J1cHQgYXBwbGljYXRpb25zIHRoYXQgdXNlIHRoZSBhbGlhcy4gSXQgY2FuIGFsc28gYWxsb3cgb3IgZGVueSBhY2Nlc3MgdG8gYSBLTVMga2V5IGFmZmVjdGVkIGJ5IGF0dHJpYnV0ZS1iYXNlZCBhY2Nlc3MgY29udHJvbCAoQUJBQykuXG4gICAgICpcbiAgICAgKiBUaGUgYWxpYXMgbXVzdCBiZSBzdHJpbmcgb2YgMS0yNTYgY2hhcmFjdGVycy4gSXQgY2FuIGNvbnRhaW4gb25seSBhbHBoYW51bWVyaWMgY2hhcmFjdGVycywgZm9yd2FyZCBzbGFzaGVzICgvKSwgdW5kZXJzY29yZXMgKF8pLCBhbmQgZGFzaGVzICgtKS4gVGhlIGFsaWFzIG5hbWUgY2Fubm90IGJlZ2luIHdpdGggYGFsaWFzL2F3cy9gIC4gVGhlIGBhbGlhcy9hd3MvYCBwcmVmaXggaXMgcmVzZXJ2ZWQgZm9yIFtBV1MgbWFuYWdlZCBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jb25jZXB0cy5odG1sI2F3cy1tYW5hZ2VkLWNtaykgLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYGFsaWFzL15bYS16QS1aMC05L18tXSskYFxuICAgICAqXG4gICAgICogKk1pbmltdW0qIDogYDFgXG4gICAgICpcbiAgICAgKiAqTWF4aW11bSogOiBgMjU2YFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWFsaWFzLmh0bWwjY2ZuLWttcy1hbGlhcy1hbGlhc25hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgYWxpYXNOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBc3NvY2lhdGVzIHRoZSBhbGlhcyB3aXRoIHRoZSBzcGVjaWZpZWQgW2N1c3RvbWVyIG1hbmFnZWQga2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jb25jZXB0cy5odG1sI2N1c3RvbWVyLWNtaykgLiBUaGUgS01TIGtleSBtdXN0IGJlIGluIHRoZSBzYW1lIEFXUyBhY2NvdW50IGFuZCBSZWdpb24uXG4gICAgICpcbiAgICAgKiBBIHZhbGlkIGtleSBJRCBpcyByZXF1aXJlZC4gSWYgeW91IHN1cHBseSBhIG51bGwgb3IgZW1wdHkgc3RyaW5nIHZhbHVlLCB0aGlzIG9wZXJhdGlvbiByZXR1cm5zIGFuIGVycm9yLlxuICAgICAqXG4gICAgICogRm9yIGhlbHAgZmluZGluZyB0aGUga2V5IElEIGFuZCBBUk4sIHNlZSBbRmluZGluZyB0aGUga2V5IElEIGFuZCBBUk5dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3ZpZXdpbmcta2V5cy5odG1sI2ZpbmQtY21rLWlkLWFybikgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFNwZWNpZnkgdGhlIGtleSBJRCBvciB0aGUga2V5IEFSTiBvZiB0aGUgS01TIGtleS5cbiAgICAgKlxuICAgICAqIEZvciBleGFtcGxlOlxuICAgICAqXG4gICAgICogLSBLZXkgSUQ6IGAxMjM0YWJjZC0xMmFiLTM0Y2QtNTZlZi0xMjM0NTY3ODkwYWJgXG4gICAgICogLSBLZXkgQVJOOiBgYXJuOmF3czprbXM6dXMtZWFzdC0yOjExMTEyMjIyMzMzMzprZXkvMTIzNGFiY2QtMTJhYi0zNGNkLTU2ZWYtMTIzNDU2Nzg5MGFiYFxuICAgICAqXG4gICAgICogVG8gZ2V0IHRoZSBrZXkgSUQgYW5kIGtleSBBUk4gZm9yIGEgS01TIGtleSwgdXNlIFtMaXN0S2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0S2V5cy5odG1sKSBvciBbRGVzY3JpYmVLZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVLZXkuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWFsaWFzLmh0bWwjY2ZuLWttcy1hbGlhcy10YXJnZXRrZXlpZFxuICAgICAqL1xuICAgIHB1YmxpYyB0YXJnZXRLZXlJZDogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OktNUzo6QWxpYXNgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkFsaWFzUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkFsaWFzLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnYWxpYXNOYW1lJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICd0YXJnZXRLZXlJZCcsIHRoaXMpO1xuXG4gICAgICAgIHRoaXMuYWxpYXNOYW1lID0gcHJvcHMuYWxpYXNOYW1lO1xuICAgICAgICB0aGlzLnRhcmdldEtleUlkID0gcHJvcHMudGFyZ2V0S2V5SWQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5BbGlhcy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgYWxpYXNOYW1lOiB0aGlzLmFsaWFzTmFtZSxcbiAgICAgICAgICAgIHRhcmdldEtleUlkOiB0aGlzLnRhcmdldEtleUlkLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkFsaWFzUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuS2V5YFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5LZXlQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5IHBvbGljeSB0aGF0IGF1dGhvcml6ZXMgdXNlIG9mIHRoZSBLTVMga2V5LiBUaGUga2V5IHBvbGljeSBtdXN0IGNvbmZvcm0gdG8gdGhlIGZvbGxvd2luZyBydWxlcy5cbiAgICAgKlxuICAgICAqIC0gVGhlIGtleSBwb2xpY3kgbXVzdCBhbGxvdyB0aGUgY2FsbGVyIHRvIG1ha2UgYSBzdWJzZXF1ZW50IFtQdXRLZXlQb2xpY3ldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfUHV0S2V5UG9saWN5Lmh0bWwpIHJlcXVlc3Qgb24gdGhlIEtNUyBrZXkuIFRoaXMgcmVkdWNlcyB0aGUgcmlzayB0aGF0IHRoZSBLTVMga2V5IGJlY29tZXMgdW5tYW5hZ2VhYmxlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgcmVmZXIgdG8gdGhlIHNjZW5hcmlvIGluIHRoZSBbRGVmYXVsdCBrZXkgcG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9rZXktcG9saWNpZXMuaHRtbCNrZXktcG9saWN5LWRlZmF1bHQtYWxsb3ctcm9vdC1lbmFibGUtaWFtKSBzZWN0aW9uIG9mIHRoZSAqKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSoqIC5cbiAgICAgKiAtIEVhY2ggc3RhdGVtZW50IGluIHRoZSBrZXkgcG9saWN5IG11c3QgY29udGFpbiBvbmUgb3IgbW9yZSBwcmluY2lwYWxzLiBUaGUgcHJpbmNpcGFscyBpbiB0aGUga2V5IHBvbGljeSBtdXN0IGV4aXN0IGFuZCBiZSB2aXNpYmxlIHRvIEFXUyBLTVMgLiBXaGVuIHlvdSBjcmVhdGUgYSBuZXcgQVdTIHByaW5jaXBhbCAoZm9yIGV4YW1wbGUsIGFuIElBTSB1c2VyIG9yIHJvbGUpLCB5b3UgbWlnaHQgbmVlZCB0byBlbmZvcmNlIGEgZGVsYXkgYmVmb3JlIGluY2x1ZGluZyB0aGUgbmV3IHByaW5jaXBhbCBpbiBhIGtleSBwb2xpY3kgYmVjYXVzZSB0aGUgbmV3IHByaW5jaXBhbCBtaWdodCBub3QgYmUgaW1tZWRpYXRlbHkgdmlzaWJsZSB0byBBV1MgS01TIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ2hhbmdlcyB0aGF0IEkgbWFrZSBhcmUgbm90IGFsd2F5cyBpbW1lZGlhdGVseSB2aXNpYmxlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvdHJvdWJsZXNob290X2dlbmVyYWwuaHRtbCN0cm91Ymxlc2hvb3RfZ2VuZXJhbF9ldmVudHVhbC1jb25zaXN0ZW5jeSkgaW4gdGhlICpBV1MgSWRlbnRpdHkgYW5kIEFjY2VzcyBNYW5hZ2VtZW50IFVzZXIgR3VpZGUqIC5cbiAgICAgKiAtIFRoZSBrZXkgcG9saWN5IHNpemUgbGltaXQgaXMgMzIga2lsb2J5dGVzICgzMjc2OCBieXRlcykuXG4gICAgICpcbiAgICAgKiBJZiB5b3UgYXJlIHVuc3VyZSBvZiB3aGljaCBwb2xpY3kgdG8gdXNlLCBjb25zaWRlciB0aGUgKmRlZmF1bHQga2V5IHBvbGljeSogLiBUaGlzIGlzIHRoZSBrZXkgcG9saWN5IHRoYXQgQVdTIEtNUyBhcHBsaWVzIHRvIEtNUyBrZXlzIHRoYXQgYXJlIGNyZWF0ZWQgYnkgdXNpbmcgdGhlIENyZWF0ZUtleSBBUEkgd2l0aCBubyBzcGVjaWZpZWQga2V5IHBvbGljeS4gSXQgZ2l2ZXMgdGhlIEFXUyBhY2NvdW50IHRoYXQgb3ducyB0aGUga2V5IHBlcm1pc3Npb24gdG8gcGVyZm9ybSBhbGwgb3BlcmF0aW9ucyBvbiB0aGUga2V5LiBJdCBhbHNvIGFsbG93cyB5b3Ugd3JpdGUgSUFNIHBvbGljaWVzIHRvIGF1dGhvcml6ZSBhY2Nlc3MgdG8gdGhlIGtleS4gRm9yIGRldGFpbHMsIHNlZSBbRGVmYXVsdCBrZXkgcG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9rZXktcG9saWNpZXMuaHRtbCNrZXktcG9saWN5LWRlZmF1bHQpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiAqTWluaW11bSogOiBgMWBcbiAgICAgKlxuICAgICAqICpNYXhpbXVtKiA6IGAzMjc2OGBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1rZXkuaHRtbCNjZm4ta21zLWtleS1rZXlwb2xpY3lcbiAgICAgKi9cbiAgICByZWFkb25seSBrZXlQb2xpY3k6IGFueSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEEgZGVzY3JpcHRpb24gb2YgdGhlIEtNUyBrZXkuIFVzZSBhIGRlc2NyaXB0aW9uIHRoYXQgaGVscHMgeW91IHRvIGRpc3Rpbmd1aXNoIHRoaXMgS01TIGtleSBmcm9tIG90aGVycyBpbiB0aGUgYWNjb3VudCwgc3VjaCBhcyBpdHMgaW50ZW5kZWQgdXNlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LWRlc2NyaXB0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgS01TIGtleSBpcyBlbmFibGVkLiBEaXNhYmxlZCBLTVMga2V5cyBjYW5ub3QgYmUgdXNlZCBpbiBjcnlwdG9ncmFwaGljIG9wZXJhdGlvbnMuXG4gICAgICpcbiAgICAgKiBXaGVuIGBFbmFibGVkYCBpcyBgdHJ1ZWAgLCB0aGUgKmtleSBzdGF0ZSogb2YgdGhlIEtNUyBrZXkgaXMgYEVuYWJsZWRgIC4gV2hlbiBgRW5hYmxlZGAgaXMgYGZhbHNlYCAsIHRoZSBrZXkgc3RhdGUgb2YgdGhlIEtNUyBrZXkgaXMgYERpc2FibGVkYCAuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGB0cnVlYCAuXG4gICAgICpcbiAgICAgKiBUaGUgYWN0dWFsIGtleSBzdGF0ZSBvZiB0aGUgS01TIGtleSBtaWdodCBiZSBhZmZlY3RlZCBieSBhY3Rpb25zIHRha2VuIG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24sIHN1Y2ggYXMgcnVubmluZyB0aGUgW0VuYWJsZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FbmFibGVLZXkuaHRtbCkgLCBbRGlzYWJsZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EaXNhYmxlS2V5Lmh0bWwpICwgb3IgW1NjaGVkdWxlS2V5RGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU2NoZWR1bGVLZXlEZWxldGlvbi5odG1sKSBvcGVyYXRpb25zLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBrZXkgc3RhdGVzIG9mIGEgS01TIGtleSwgc2VlIFtLZXkgc3RhdGU6IEVmZmVjdCBvbiB5b3VyIEtNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2tleS1zdGF0ZS5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LWVuYWJsZWRcbiAgICAgKi9cbiAgICByZWFkb25seSBlbmFibGVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEVuYWJsZXMgYXV0b21hdGljIHJvdGF0aW9uIG9mIHRoZSBrZXkgbWF0ZXJpYWwgZm9yIHRoZSBzcGVjaWZpZWQgS01TIGtleS4gQnkgZGVmYXVsdCwgYXV0b21hdGljIGtleSByb3RhdGlvbiBpcyBub3QgZW5hYmxlZC5cbiAgICAgKlxuICAgICAqIEFXUyBLTVMgc3VwcG9ydHMgYXV0b21hdGljIHJvdGF0aW9uIG9ubHkgZm9yIHN5bW1ldHJpYyBlbmNyeXB0aW9uIEtNUyBrZXlzICggYEtleVNwZWNgID0gYFNZTU1FVFJJQ19ERUZBVUxUYCApLiBGb3IgYXN5bW1ldHJpYyBLTVMga2V5cyBhbmQgSE1BQyBLTVMga2V5cywgb21pdCB0aGUgYEVuYWJsZUtleVJvdGF0aW9uYCBwcm9wZXJ0eSBvciBzZXQgaXQgdG8gYGZhbHNlYCAuXG4gICAgICpcbiAgICAgKiBUbyBlbmFibGUgYXV0b21hdGljIGtleSByb3RhdGlvbiBvZiB0aGUga2V5IG1hdGVyaWFsIGZvciBhIG11bHRpLVJlZ2lvbiBLTVMga2V5LCBzZXQgYEVuYWJsZUtleVJvdGF0aW9uYCB0byBgdHJ1ZWAgb24gdGhlIHByaW1hcnkga2V5IChjcmVhdGVkIGJ5IHVzaW5nIGBBV1M6OktNUzo6S2V5YCApLiBBV1MgS01TIGNvcGllcyB0aGUgcm90YXRpb24gc3RhdHVzIHRvIGFsbCByZXBsaWNhIGtleXMuIEZvciBkZXRhaWxzLCBzZWUgW1JvdGF0aW5nIG11bHRpLVJlZ2lvbiBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1tYW5hZ2UuaHRtbCNtdWx0aS1yZWdpb24tcm90YXRlKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogV2hlbiB5b3UgZW5hYmxlIGF1dG9tYXRpYyByb3RhdGlvbiwgQVdTIEtNUyBhdXRvbWF0aWNhbGx5IGNyZWF0ZXMgbmV3IGtleSBtYXRlcmlhbCBmb3IgdGhlIEtNUyBrZXkgb25lIHllYXIgYWZ0ZXIgdGhlIGVuYWJsZSBkYXRlIGFuZCBldmVyeSB5ZWFyIHRoZXJlYWZ0ZXIuIEFXUyBLTVMgcmV0YWlucyBhbGwga2V5IG1hdGVyaWFsIHVudGlsIHlvdSBkZWxldGUgdGhlIEtNUyBrZXkuIEZvciBkZXRhaWxlZCBpbmZvcm1hdGlvbiBhYm91dCBhdXRvbWF0aWMga2V5IHJvdGF0aW9uLCBzZWUgW1JvdGF0aW5nIEtNUyBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9yb3RhdGUta2V5cy5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LWVuYWJsZWtleXJvdGF0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5hYmxlS2V5Um90YXRpb24/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSB0eXBlIG9mIEtNUyBrZXkgdG8gY3JlYXRlLiBUaGUgZGVmYXVsdCB2YWx1ZSwgYFNZTU1FVFJJQ19ERUZBVUxUYCAsIGNyZWF0ZXMgYSBLTVMga2V5IHdpdGggYSAyNTYtYml0IHN5bW1ldHJpYyBrZXkgZm9yIGVuY3J5cHRpb24gYW5kIGRlY3J5cHRpb24uIFlvdSBjYW4ndCBjaGFuZ2UgdGhlIGBLZXlTcGVjYCB2YWx1ZSBhZnRlciB0aGUgS01TIGtleSBpcyBjcmVhdGVkLiBGb3IgaGVscCBjaG9vc2luZyBhIGtleSBzcGVjIGZvciB5b3VyIEtNUyBrZXksIHNlZSBbQ2hvb3NpbmcgYSBLTVMga2V5IHR5cGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3N5bW0tYXN5bW0tY2hvb3NlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBUaGUgYEtleVNwZWNgIHByb3BlcnR5IGRldGVybWluZXMgdGhlIHR5cGUgb2Yga2V5IG1hdGVyaWFsIGluIHRoZSBLTVMga2V5IGFuZCB0aGUgYWxnb3JpdGhtcyB0aGF0IHRoZSBLTVMga2V5IHN1cHBvcnRzLiBUbyBmdXJ0aGVyIHJlc3RyaWN0IHRoZSBhbGdvcml0aG1zIHRoYXQgY2FuIGJlIHVzZWQgd2l0aCB0aGUgS01TIGtleSwgdXNlIGEgY29uZGl0aW9uIGtleSBpbiBpdHMga2V5IHBvbGljeSBvciBJQU0gcG9saWN5LiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtBV1MgS01TIGNvbmRpdGlvbiBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9wb2xpY3ktY29uZGl0aW9ucy5odG1sI2NvbmRpdGlvbnMta21zKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogPiBJZiB5b3UgY2hhbmdlIHRoZSBgS2V5U3BlY2AgdmFsdWUgb2YgYW4gZXhpc3RpbmcgS01TIGtleSwgdGhlIGV4aXN0aW5nIEtNUyBrZXkgaXMgc2NoZWR1bGVkIGZvciBkZWxldGlvbiBhbmQgYSBuZXcgS01TIGtleSBpcyBjcmVhdGVkIHdpdGggdGhlIHNwZWNpZmllZCBgS2V5U3BlY2AgdmFsdWUuIFdoaWxlIHRoZSBzY2hlZHVsZWQgZGVsZXRpb24gaXMgcGVuZGluZywgeW91IGNhbid0IHVzZSB0aGUgZXhpc3RpbmcgS01TIGtleS4gVW5sZXNzIHlvdSBbY2FuY2VsIHRoZSBzY2hlZHVsZWQgZGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2RlbGV0aW5nLWtleXMuaHRtbCNkZWxldGluZy1rZXlzLXNjaGVkdWxpbmcta2V5LWRlbGV0aW9uKSBvZiB0aGUgS01TIGtleSBvdXRzaWRlIG9mIENsb3VkRm9ybWF0aW9uLCBhbGwgZGF0YSBlbmNyeXB0ZWQgdW5kZXIgdGhlIGV4aXN0aW5nIEtNUyBrZXkgYmVjb21lcyB1bnJlY292ZXJhYmxlIHdoZW4gdGhlIEtNUyBrZXkgaXMgZGVsZXRlZC4gPiBbQVdTIHNlcnZpY2VzIHRoYXQgYXJlIGludGVncmF0ZWQgd2l0aCBBV1MgS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2ZlYXR1cmVzLyNBV1NfU2VydmljZV9JbnRlZ3JhdGlvbikgdXNlIHN5bW1ldHJpYyBlbmNyeXB0aW9uIEtNUyBrZXlzIHRvIHByb3RlY3QgeW91ciBkYXRhLiBUaGVzZSBzZXJ2aWNlcyBkbyBub3Qgc3VwcG9ydCBlbmNyeXB0aW9uIHdpdGggYXN5bW1ldHJpYyBLTVMga2V5cy4gRm9yIGhlbHAgZGV0ZXJtaW5pbmcgd2hldGhlciBhIEtNUyBrZXkgaXMgYXN5bW1ldHJpYywgc2VlIFtJZGVudGlmeWluZyBhc3ltbWV0cmljIEtNUyBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9maW5kLXN5bW0tYXN5bW0uaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEFXUyBLTVMgc3VwcG9ydHMgdGhlIGZvbGxvd2luZyBrZXkgc3BlY3MgZm9yIEtNUyBrZXlzOlxuICAgICAqXG4gICAgICogLSBTeW1tZXRyaWMgZW5jcnlwdGlvbiBrZXkgKGRlZmF1bHQpXG4gICAgICpcbiAgICAgKiAtIGBTWU1NRVRSSUNfREVGQVVMVGAgKEFFUy0yNTYtR0NNKVxuICAgICAqIC0gSE1BQyBrZXlzIChzeW1tZXRyaWMpXG4gICAgICpcbiAgICAgKiAtIGBITUFDXzIyNGBcbiAgICAgKiAtIGBITUFDXzI1NmBcbiAgICAgKiAtIGBITUFDXzM4NGBcbiAgICAgKiAtIGBITUFDXzUxMmBcbiAgICAgKiAtIEFzeW1tZXRyaWMgUlNBIGtleSBwYWlyc1xuICAgICAqXG4gICAgICogLSBgUlNBXzIwNDhgXG4gICAgICogLSBgUlNBXzMwNzJgXG4gICAgICogLSBgUlNBXzQwOTZgXG4gICAgICogLSBBc3ltbWV0cmljIE5JU1QtcmVjb21tZW5kZWQgZWxsaXB0aWMgY3VydmUga2V5IHBhaXJzXG4gICAgICpcbiAgICAgKiAtIGBFQ0NfTklTVF9QMjU2YCAoc2VjcDI1NnIxKVxuICAgICAqIC0gYEVDQ19OSVNUX1AzODRgIChzZWNwMzg0cjEpXG4gICAgICogLSBgRUNDX05JU1RfUDUyMWAgKHNlY3A1MjFyMSlcbiAgICAgKiAtIE90aGVyIGFzeW1tZXRyaWMgZWxsaXB0aWMgY3VydmUga2V5IHBhaXJzXG4gICAgICpcbiAgICAgKiAtIGBFQ0NfU0VDR19QMjU2SzFgIChzZWNwMjU2azEpLCBjb21tb25seSB1c2VkIGZvciBjcnlwdG9jdXJyZW5jaWVzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LWtleXNwZWNcbiAgICAgKi9cbiAgICByZWFkb25seSBrZXlTcGVjPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogRGV0ZXJtaW5lcyB0aGUgW2NyeXB0b2dyYXBoaWMgb3BlcmF0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvY29uY2VwdHMuaHRtbCNjcnlwdG9ncmFwaGljLW9wZXJhdGlvbnMpIGZvciB3aGljaCB5b3UgY2FuIHVzZSB0aGUgS01TIGtleS4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYEVOQ1JZUFRfREVDUllQVGAgLiBUaGlzIHByb3BlcnR5IGlzIHJlcXVpcmVkIGZvciBhc3ltbWV0cmljIEtNUyBrZXlzIGFuZCBITUFDIEtNUyBrZXlzLiBZb3UgY2FuJ3QgY2hhbmdlIHRoZSBgS2V5VXNhZ2VgIHZhbHVlIGFmdGVyIHRoZSBLTVMga2V5IGlzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiA+IElmIHlvdSBjaGFuZ2UgdGhlIGBLZXlVc2FnZWAgdmFsdWUgb2YgYW4gZXhpc3RpbmcgS01TIGtleSwgdGhlIGV4aXN0aW5nIEtNUyBrZXkgaXMgc2NoZWR1bGVkIGZvciBkZWxldGlvbiBhbmQgYSBuZXcgS01TIGtleSBpcyBjcmVhdGVkIHdpdGggdGhlIHNwZWNpZmllZCBgS2V5VXNhZ2VgIHZhbHVlLiBXaGlsZSB0aGUgc2NoZWR1bGVkIGRlbGV0aW9uIGlzIHBlbmRpbmcsIHlvdSBjYW4ndCB1c2UgdGhlIGV4aXN0aW5nIEtNUyBrZXkuIFVubGVzcyB5b3UgW2NhbmNlbCB0aGUgc2NoZWR1bGVkIGRlbGV0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9kZWxldGluZy1rZXlzLmh0bWwjZGVsZXRpbmcta2V5cy1zY2hlZHVsaW5nLWtleS1kZWxldGlvbikgb2YgdGhlIEtNUyBrZXkgb3V0c2lkZSBvZiBDbG91ZEZvcm1hdGlvbiwgYWxsIGRhdGEgZW5jcnlwdGVkIHVuZGVyIHRoZSBleGlzdGluZyBLTVMga2V5IGJlY29tZXMgdW5yZWNvdmVyYWJsZSB3aGVuIHRoZSBLTVMga2V5IGlzIGRlbGV0ZWQuXG4gICAgICpcbiAgICAgKiBTZWxlY3Qgb25seSBvbmUgdmFsaWQgdmFsdWUuXG4gICAgICpcbiAgICAgKiAtIEZvciBzeW1tZXRyaWMgZW5jcnlwdGlvbiBLTVMga2V5cywgb21pdCB0aGUgcHJvcGVydHkgb3Igc3BlY2lmeSBgRU5DUllQVF9ERUNSWVBUYCAuXG4gICAgICogLSBGb3IgYXN5bW1ldHJpYyBLTVMga2V5cyB3aXRoIFJTQSBrZXkgbWF0ZXJpYWwsIHNwZWNpZnkgYEVOQ1JZUFRfREVDUllQVGAgb3IgYFNJR05fVkVSSUZZYCAuXG4gICAgICogLSBGb3IgYXN5bW1ldHJpYyBLTVMga2V5cyB3aXRoIEVDQyBrZXkgbWF0ZXJpYWwsIHNwZWNpZnkgYFNJR05fVkVSSUZZYCAuXG4gICAgICogLSBGb3IgSE1BQyBLTVMga2V5cywgc3BlY2lmeSBgR0VORVJBVEVfVkVSSUZZX01BQ2AgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LWtleXVzYWdlXG4gICAgICovXG4gICAgcmVhZG9ubHkga2V5VXNhZ2U/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGVzIGEgbXVsdGktUmVnaW9uIHByaW1hcnkga2V5IHRoYXQgeW91IGNhbiByZXBsaWNhdGUgaW4gb3RoZXIgQVdTIFJlZ2lvbnMgLiBZb3UgY2FuJ3QgY2hhbmdlIHRoZSBgTXVsdGlSZWdpb25gIHZhbHVlIGFmdGVyIHRoZSBLTVMga2V5IGlzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiA+IElmIHlvdSBjaGFuZ2UgdGhlIGBNdWx0aVJlZ2lvbmAgdmFsdWUgb2YgYW4gZXhpc3RpbmcgS01TIGtleSwgdGhlIGV4aXN0aW5nIEtNUyBrZXkgaXMgc2NoZWR1bGVkIGZvciBkZWxldGlvbiBhbmQgYSBuZXcgS01TIGtleSBpcyBjcmVhdGVkIHdpdGggdGhlIHNwZWNpZmllZCBgTXVsdGktUmVnaW9uYCB2YWx1ZS4gV2hpbGUgdGhlIHNjaGVkdWxlZCBkZWxldGlvbiBpcyBwZW5kaW5nLCB5b3UgY2FuJ3QgdXNlIHRoZSBleGlzdGluZyBLTVMga2V5LiBVbmxlc3MgeW91IFtjYW5jZWwgdGhlIHNjaGVkdWxlZCBkZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGVsZXRpbmcta2V5cy5odG1sI2RlbGV0aW5nLWtleXMtc2NoZWR1bGluZy1rZXktZGVsZXRpb24pIG9mIHRoZSBLTVMga2V5IG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24sIGFsbCBkYXRhIGVuY3J5cHRlZCB1bmRlciB0aGUgZXhpc3RpbmcgS01TIGtleSBiZWNvbWVzIHVucmVjb3ZlcmFibGUgd2hlbiB0aGUgS01TIGtleSBpcyBkZWxldGVkLlxuICAgICAqXG4gICAgICogRm9yIGEgbXVsdGktUmVnaW9uIGtleSwgc2V0IHRvIHRoaXMgcHJvcGVydHkgdG8gYHRydWVgIC4gRm9yIGEgc2luZ2xlLVJlZ2lvbiBrZXksIG9taXQgdGhpcyBwcm9wZXJ0eSBvciBzZXQgaXQgdG8gYGZhbHNlYCAuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGBmYWxzZWAgLlxuICAgICAqXG4gICAgICogKk11bHRpLVJlZ2lvbiBrZXlzKiBhcmUgYW4gQVdTIEtNUyBmZWF0dXJlIHRoYXQgbGV0cyB5b3UgY3JlYXRlIG11bHRpcGxlIGludGVyb3BlcmFibGUgS01TIGtleXMgaW4gZGlmZmVyZW50IEFXUyBSZWdpb25zIC4gQmVjYXVzZSB0aGVzZSBLTVMga2V5cyBoYXZlIHRoZSBzYW1lIGtleSBJRCwga2V5IG1hdGVyaWFsLCBhbmQgb3RoZXIgbWV0YWRhdGEsIHlvdSBjYW4gdXNlIHRoZW0gdG8gZW5jcnlwdCBkYXRhIGluIG9uZSBBV1MgUmVnaW9uIGFuZCBkZWNyeXB0IGl0IGluIGEgZGlmZmVyZW50IEFXUyBSZWdpb24gd2l0aG91dCBtYWtpbmcgYSBjcm9zcy1SZWdpb24gY2FsbCBvciBleHBvc2luZyB0aGUgcGxhaW50ZXh0IGRhdGEuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW011bHRpLVJlZ2lvbiBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1vdmVydmlldy5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogWW91IGNhbiBjcmVhdGUgYSBzeW1tZXRyaWMgZW5jcnlwdGlvbiwgSE1BQywgb3IgYXN5bW1ldHJpYyBtdWx0aS1SZWdpb24gS01TIGtleSwgYW5kIHlvdSBjYW4gY3JlYXRlIGEgbXVsdGktUmVnaW9uIGtleSB3aXRoIGltcG9ydGVkIGtleSBtYXRlcmlhbC4gSG93ZXZlciwgeW91IGNhbm5vdCBjcmVhdGUgYSBtdWx0aS1SZWdpb24ga2V5IGluIGEgY3VzdG9tIGtleSBzdG9yZS5cbiAgICAgKlxuICAgICAqIFRvIGNyZWF0ZSBhIHJlcGxpY2Egb2YgdGhpcyBwcmltYXJ5IGtleSBpbiBhIGRpZmZlcmVudCBBV1MgUmVnaW9uICwgY3JlYXRlIGFuIFtBV1M6OktNUzo6UmVwbGljYUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1yZXBsaWNha2V5Lmh0bWwpIHJlc291cmNlIGluIGEgQ2xvdWRGb3JtYXRpb24gc3RhY2sgaW4gdGhlIHJlcGxpY2EgUmVnaW9uLiBTcGVjaWZ5IHRoZSBrZXkgQVJOIG9mIHRoaXMgcHJpbWFyeSBrZXkuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXktbXVsdGlyZWdpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBtdWx0aVJlZ2lvbj86IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG51bWJlciBvZiBkYXlzIGluIHRoZSB3YWl0aW5nIHBlcmlvZCBiZWZvcmUgQVdTIEtNUyBkZWxldGVzIGEgS01TIGtleSB0aGF0IGhhcyBiZWVuIHJlbW92ZWQgZnJvbSBhIENsb3VkRm9ybWF0aW9uIHN0YWNrLiBFbnRlciBhIHZhbHVlIGJldHdlZW4gNyBhbmQgMzAgZGF5cy4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMzAgZGF5cy5cbiAgICAgKlxuICAgICAqIFdoZW4geW91IHJlbW92ZSBhIEtNUyBrZXkgZnJvbSBhIENsb3VkRm9ybWF0aW9uIHN0YWNrLCBBV1MgS01TIHNjaGVkdWxlcyB0aGUgS01TIGtleSBmb3IgZGVsZXRpb24gYW5kIHN0YXJ0cyB0aGUgbWFuZGF0b3J5IHdhaXRpbmcgcGVyaW9kLiBUaGUgYFBlbmRpbmdXaW5kb3dJbkRheXNgIHByb3BlcnR5IGRldGVybWluZXMgdGhlIGxlbmd0aCBvZiB3YWl0aW5nIHBlcmlvZC4gRHVyaW5nIHRoZSB3YWl0aW5nIHBlcmlvZCwgdGhlIGtleSBzdGF0ZSBvZiBLTVMga2V5IGlzIGBQZW5kaW5nIERlbGV0aW9uYCBvciBgUGVuZGluZyBSZXBsaWNhIERlbGV0aW9uYCAsIHdoaWNoIHByZXZlbnRzIHRoZSBLTVMga2V5IGZyb20gYmVpbmcgdXNlZCBpbiBjcnlwdG9ncmFwaGljIG9wZXJhdGlvbnMuIFdoZW4gdGhlIHdhaXRpbmcgcGVyaW9kIGV4cGlyZXMsIEFXUyBLTVMgcGVybWFuZW50bHkgZGVsZXRlcyB0aGUgS01TIGtleS5cbiAgICAgKlxuICAgICAqIEFXUyBLTVMgd2lsbCBub3QgZGVsZXRlIGEgW211bHRpLVJlZ2lvbiBwcmltYXJ5IGtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtb3ZlcnZpZXcuaHRtbCkgdGhhdCBoYXMgcmVwbGljYSBrZXlzLiBJZiB5b3UgcmVtb3ZlIGEgbXVsdGktUmVnaW9uIHByaW1hcnkga2V5IGZyb20gYSBDbG91ZEZvcm1hdGlvbiBzdGFjaywgaXRzIGtleSBzdGF0ZSBjaGFuZ2VzIHRvIGBQZW5kaW5nUmVwbGljYURlbGV0aW9uYCBzbyBpdCBjYW5ub3QgYmUgcmVwbGljYXRlZCBvciB1c2VkIGluIGNyeXB0b2dyYXBoaWMgb3BlcmF0aW9ucy4gVGhpcyBzdGF0ZSBjYW4gcGVyc2lzdCBpbmRlZmluaXRlbHkuIFdoZW4gdGhlIGxhc3Qgb2YgaXRzIHJlcGxpY2Ega2V5cyBpcyBkZWxldGVkLCB0aGUga2V5IHN0YXRlIG9mIHRoZSBwcmltYXJ5IGtleSBjaGFuZ2VzIHRvIGBQZW5kaW5nRGVsZXRpb25gIGFuZCB0aGUgd2FpdGluZyBwZXJpb2Qgc3BlY2lmaWVkIGJ5IGBQZW5kaW5nV2luZG93SW5EYXlzYCBiZWdpbnMuIFdoZW4gdGhpcyB3YWl0aW5nIHBlcmlvZCBleHBpcmVzLCBBV1MgS01TIGRlbGV0ZXMgdGhlIHByaW1hcnkga2V5LiBGb3IgZGV0YWlscywgc2VlIFtEZWxldGluZyBtdWx0aS1SZWdpb24ga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtZGVsZXRlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBZb3UgY2Fubm90IHVzZSBhIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIHRvIGNhbmNlbCBkZWxldGlvbiBvZiB0aGUgS01TIGtleSBhZnRlciB5b3UgcmVtb3ZlIGl0IGZyb20gdGhlIHN0YWNrLCByZWdhcmRsZXNzIG9mIHRoZSB3YWl0aW5nIHBlcmlvZC4gSWYgeW91IHNwZWNpZnkgYSBLTVMga2V5IGluIHlvdXIgdGVtcGxhdGUsIGV2ZW4gb25lIHdpdGggdGhlIHNhbWUgbmFtZSwgQ2xvdWRGb3JtYXRpb24gY3JlYXRlcyBhIG5ldyBLTVMga2V5LiBUbyBjYW5jZWwgZGVsZXRpb24gb2YgYSBLTVMga2V5LCB1c2UgdGhlIEFXUyBLTVMgY29uc29sZSBvciB0aGUgW0NhbmNlbEtleURlbGV0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NhbmNlbEtleURlbGV0aW9uLmh0bWwpIG9wZXJhdGlvbi5cbiAgICAgKlxuICAgICAqIEZvciBpbmZvcm1hdGlvbiBhYm91dCB0aGUgYFBlbmRpbmcgRGVsZXRpb25gIGFuZCBgUGVuZGluZyBSZXBsaWNhIERlbGV0aW9uYCBrZXkgc3RhdGVzLCBzZWUgW0tleSBzdGF0ZTogRWZmZWN0IG9uIHlvdXIgS01TIGtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUva2V5LXN0YXRlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IGRlbGV0aW5nIEtNUyBrZXlzLCBzZWUgdGhlIFtTY2hlZHVsZUtleURlbGV0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1NjaGVkdWxlS2V5RGVsZXRpb24uaHRtbCkgb3BlcmF0aW9uIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgQVBJIFJlZmVyZW5jZSogYW5kIFtEZWxldGluZyBLTVMga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGVsZXRpbmcta2V5cy5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogKk1pbmltdW0qIDogN1xuICAgICAqXG4gICAgICogKk1heGltdW0qIDogMzBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1rZXkuaHRtbCNjZm4ta21zLWtleS1wZW5kaW5nd2luZG93aW5kYXlzXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVuZGluZ1dpbmRvd0luRGF5cz86IG51bWJlcjtcblxuICAgIC8qKlxuICAgICAqIEFzc2lnbnMgb25lIG9yIG1vcmUgdGFncyB0byB0aGUgcmVwbGljYSBrZXkuXG4gICAgICpcbiAgICAgKiA+IFRhZ2dpbmcgb3IgdW50YWdnaW5nIGEgS01TIGtleSBjYW4gYWxsb3cgb3IgZGVueSBwZXJtaXNzaW9uIHRvIHRoZSBLTVMga2V5LiBGb3IgZGV0YWlscywgc2VlIFtBQkFDIGZvciBBV1MgS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hYmFjLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdGFncyBpbiBBV1MgS01TICwgc2VlIFtUYWdnaW5nIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3RhZ2dpbmcta2V5cy5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdGFncyBpbiBDbG91ZEZvcm1hdGlvbiwgc2VlIFtUYWddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXJlc291cmNlLXRhZ3MuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbktleVByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5LZXlQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5LZXlQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc2NyaXB0aW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlbmFibGVLZXlSb3RhdGlvbicsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZW5hYmxlS2V5Um90YXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2VuYWJsZWQnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmVuYWJsZWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleVBvbGljeScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5rZXlQb2xpY3kpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleVBvbGljeScsIGNkay52YWxpZGF0ZU9iamVjdCkocHJvcGVydGllcy5rZXlQb2xpY3kpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleVNwZWMnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2V5U3BlYykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5VXNhZ2UnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2V5VXNhZ2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ211bHRpUmVnaW9uJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5tdWx0aVJlZ2lvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGVuZGluZ1dpbmRvd0luRGF5cycsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5wZW5kaW5nV2luZG93SW5EYXlzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbktleVByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpLTVM6OktleWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuS2V5UHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OktNUzo6S2V5YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbktleVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5LZXlQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgS2V5UG9saWN5OiBjZGsub2JqZWN0VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtleVBvbGljeSksXG4gICAgICAgIERlc2NyaXB0aW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSxcbiAgICAgICAgRW5hYmxlZDogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZW5hYmxlZCksXG4gICAgICAgIEVuYWJsZUtleVJvdGF0aW9uOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5lbmFibGVLZXlSb3RhdGlvbiksXG4gICAgICAgIEtleVNwZWM6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5U3BlYyksXG4gICAgICAgIEtleVVzYWdlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtleVVzYWdlKSxcbiAgICAgICAgTXVsdGlSZWdpb246IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm11bHRpUmVnaW9uKSxcbiAgICAgICAgUGVuZGluZ1dpbmRvd0luRGF5czogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wZW5kaW5nV2luZG93SW5EYXlzKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbktleVByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuS2V5UHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbktleVByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna2V5UG9saWN5JywgJ0tleVBvbGljeScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QW55KHByb3BlcnRpZXMuS2V5UG9saWN5KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXNjcmlwdGlvbicsICdEZXNjcmlwdGlvbicsIHByb3BlcnRpZXMuRGVzY3JpcHRpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGVzY3JpcHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2VuYWJsZWQnLCAnRW5hYmxlZCcsIHByb3BlcnRpZXMuRW5hYmxlZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuRW5hYmxlZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZW5hYmxlS2V5Um90YXRpb24nLCAnRW5hYmxlS2V5Um90YXRpb24nLCBwcm9wZXJ0aWVzLkVuYWJsZUtleVJvdGF0aW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5FbmFibGVLZXlSb3RhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna2V5U3BlYycsICdLZXlTcGVjJywgcHJvcGVydGllcy5LZXlTcGVjICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLktleVNwZWMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2tleVVzYWdlJywgJ0tleVVzYWdlJywgcHJvcGVydGllcy5LZXlVc2FnZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXlVc2FnZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbXVsdGlSZWdpb24nLCAnTXVsdGlSZWdpb24nLCBwcm9wZXJ0aWVzLk11bHRpUmVnaW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5NdWx0aVJlZ2lvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncGVuZGluZ1dpbmRvd0luRGF5cycsICdQZW5kaW5nV2luZG93SW5EYXlzJywgcHJvcGVydGllcy5QZW5kaW5nV2luZG93SW5EYXlzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlBlbmRpbmdXaW5kb3dJbkRheXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6S01TOjpLZXlgXG4gKlxuICogVGhlIGBBV1M6OktNUzo6S2V5YCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gW0tNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2NvbmNlcHRzLmh0bWwja21zX2tleXMpIGluIEFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIC4gWW91IGNhbiB1c2UgdGhpcyByZXNvdXJjZSB0byBjcmVhdGUgc3ltbWV0cmljIGVuY3J5cHRpb24gS01TIGtleXMsIGFzeW1tZXRyaWMgS01TIGtleXMgZm9yIGVuY3J5cHRpb24gb3Igc2lnbmluZywgYW5kIHN5bW1ldHJpYyBITUFDIEtNUyBrZXlzLiBZb3UgY2FuIHVzZSBgQVdTOjpLTVM6OktleWAgdG8gY3JlYXRlIFttdWx0aS1SZWdpb24gcHJpbWFyeSBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1vdmVydmlldy5odG1sI21yay1wcmltYXJ5LWtleSkgb2YgYWxsIHN1cHBvcnRlZCB0eXBlcy4gVG8gcmVwbGljYXRlIGEgbXVsdGktUmVnaW9uIGtleSwgdXNlIHRoZSBgQVdTOjpLTVM6OlJlcGxpY2FLZXlgIHJlc291cmNlLlxuICpcbiAqIFlvdSBjYW5ub3QgdXNlIHRoZSBgQVdTOjpLTVM6OktleWAgcmVzb3VyY2UgdG8gc3BlY2lmeSBhIEtNUyBrZXkgd2l0aCBbaW1wb3J0ZWQga2V5IG1hdGVyaWFsXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9pbXBvcnRpbmcta2V5cy5odG1sKSBvciBhIEtNUyBrZXkgaW4gYSBbY3VzdG9tIGtleSBzdG9yZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvY3VzdG9tLWtleS1zdG9yZS1vdmVydmlldy5odG1sKSAuXG4gKlxuICogPiBBV1MgS01TIHJlcGxhY2VkIHRoZSB0ZXJtICpjdXN0b21lciBtYXN0ZXIga2V5IChDTUspKiB3aXRoICpBV1MgS01TIGtleSogYW5kICpLTVMga2V5KiAuIFRoZSBjb25jZXB0IGhhcyBub3QgY2hhbmdlZC4gVG8gcHJldmVudCBicmVha2luZyBjaGFuZ2VzLCBBV1MgS01TIGlzIGtlZXBpbmcgc29tZSB2YXJpYXRpb25zIG9mIHRoaXMgdGVybS5cbiAqXG4gKiBZb3UgY2FuIHVzZSBzeW1tZXRyaWMgZW5jcnlwdGlvbiBLTVMga2V5cyB0byBlbmNyeXB0IGFuZCBkZWNyeXB0IHNtYWxsIGFtb3VudHMgb2YgZGF0YSwgYnV0IHRoZXkgYXJlIG1vcmUgY29tbW9ubHkgdXNlZCB0byBnZW5lcmF0ZSBkYXRhIGtleXMgYW5kIGRhdGEga2V5IHBhaXJzLiBZb3UgY2FuIGFsc28gdXNlIGEgc3ltbWV0cmljIGVuY3J5cHRpb24gS01TIGtleSB0byBlbmNyeXB0IGRhdGEgc3RvcmVkIGluIEFXUyBzZXJ2aWNlcyB0aGF0IGFyZSBbaW50ZWdyYXRlZCB3aXRoIEFXUyBLTVNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS8va21zL2ZlYXR1cmVzLyNBV1NfU2VydmljZV9JbnRlZ3JhdGlvbikgLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTeW1tZXRyaWMgZW5jcnlwdGlvbiBLTVMga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvY29uY2VwdHMuaHRtbCNzeW1tZXRyaWMtY21rcykgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiBZb3UgY2FuIHVzZSBhc3ltbWV0cmljIEtNUyBrZXlzIHRvIGVuY3J5cHQgYW5kIGRlY3J5cHQgZGF0YSBvciBzaWduIG1lc3NhZ2VzIGFuZCB2ZXJpZnkgc2lnbmF0dXJlcy4gVG8gY3JlYXRlIGFuIGFzeW1tZXRyaWMga2V5LCB5b3UgbXVzdCBzcGVjaWZ5IGFuIGFzeW1tZXRyaWMgYEtleVNwZWNgIHZhbHVlIGFuZCBhIGBLZXlVc2FnZWAgdmFsdWUuIEZvciBkZXRhaWxzLCBzZWUgW0FzeW1tZXRyaWMga2V5cyBpbiBBV1MgS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9zeW1tZXRyaWMtYXN5bW1ldHJpYy5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICpcbiAqIFlvdSBjYW4gdXNlIEhNQUMgS01TIGtleXMgKHdoaWNoIGFyZSBhbHNvIHN5bW1ldHJpYyBrZXlzKSB0byBnZW5lcmF0ZSBhbmQgdmVyaWZ5IGhhc2gtYmFzZWQgbWVzc2FnZSBhdXRoZW50aWNhdGlvbiBjb2Rlcy4gVG8gY3JlYXRlIGFuIEhNQUMga2V5LCB5b3UgbXVzdCBzcGVjaWZ5IGFuIEhNQUMgYEtleVNwZWNgIHZhbHVlIGFuZCBhIGBLZXlVc2FnZWAgdmFsdWUgb2YgYEdFTkVSQVRFX1ZFUklGWV9NQUNgIC4gRm9yIGRldGFpbHMsIHNlZSBbSE1BQyBrZXlzIGluIEFXUyBLTVNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2htYWMuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiBZb3UgY2FuIGFsc28gY3JlYXRlIHN5bW1ldHJpYyBlbmNyeXB0aW9uLCBhc3ltbWV0cmljLCBhbmQgSE1BQyBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXlzLiBUbyBjcmVhdGUgYSBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXksIHNldCB0aGUgYE11bHRpUmVnaW9uYCBwcm9wZXJ0eSB0byBgdHJ1ZWAgLiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgbXVsdGktUmVnaW9uIGtleXMsIHNlZSBbTXVsdGktUmVnaW9uIGtleXMgaW4gQVdTIEtNU10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtb3ZlcnZpZXcuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiA+IElmIHlvdSBjaGFuZ2UgdGhlIHZhbHVlIG9mIHRoZSBgS2V5VXNhZ2VgICwgYEtleVNwZWNgICwgb3IgYE11bHRpUmVnaW9uYCBwcm9wZXJ0eSBvbiBhbiBleGlzdGluZyBLTVMga2V5LCB0aGUgZXhpc3RpbmcgS01TIGtleSBpcyBbc2NoZWR1bGVkIGZvciBkZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGVsZXRpbmcta2V5cy5odG1sKSBhbmQgYSBuZXcgS01TIGtleSBpcyBjcmVhdGVkIHdpdGggdGhlIHNwZWNpZmllZCB2YWx1ZS5cbiAqID5cbiAqID4gV2hpbGUgc2NoZWR1bGVkIGZvciBkZWxldGlvbiwgdGhlIGV4aXN0aW5nIEtNUyBrZXkgYmVjb21lcyB1bnVzYWJsZS4gSWYgeW91IGRvbid0IFtjYW5jZWwgdGhlIHNjaGVkdWxlZCBkZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGVsZXRpbmcta2V5cy5odG1sI2RlbGV0aW5nLWtleXMtc2NoZWR1bGluZy1rZXktZGVsZXRpb24pIG9mIHRoZSBleGlzdGluZyBLTVMga2V5IG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24sIGFsbCBkYXRhIGVuY3J5cHRlZCB1bmRlciB0aGUgZXhpc3RpbmcgS01TIGtleSBiZWNvbWVzIHVucmVjb3ZlcmFibGUgd2hlbiB0aGUgS01TIGtleSBpcyBkZWxldGVkLlxuICpcbiAqICpSZWdpb25zKlxuICpcbiAqIEFXUyBLTVMgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2VzIGFyZSBzdXBwb3J0ZWQgaW4gYWxsIFJlZ2lvbnMgaW4gd2hpY2ggQVdTIENsb3VkRm9ybWF0aW9uIGlzIHN1cHBvcnRlZC4gSG93ZXZlciwgaW4gdGhlICAoYXAtc291dGhlYXN0LTMpLCB5b3UgY2Fubm90IHVzZSBhIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIHRvIGNyZWF0ZSBvciBtYW5hZ2UgYXN5bW1ldHJpYyBLTVMga2V5cyBvciBtdWx0aS1SZWdpb24gS01TIGtleXMgKHByaW1hcnkgb3IgcmVwbGljYSkuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpLTVM6OktleVxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1rZXkuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuS2V5IGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6S01TOjpLZXlcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbktleSB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuS2V5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbktleShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIEtNUyBrZXksIHN1Y2ggYXMgYGFybjphd3M6a21zOnVzLXdlc3QtMjoxMTExMjIyMjMzMzM6a2V5LzEyMzRhYmNkLTEyYWItMzRjZC01NmVmLTEyMzQ1Njc4OTBhYmAgLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBrZXkgQVJOIG9mIGEgS01TIGtleSwgc2VlIFtLZXkgQVJOXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jb25jZXB0cy5odG1sI2tleS1pZC1rZXktQVJOKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGtleSBJRCBvZiB0aGUgS01TIGtleSwgc3VjaCBhcyBgMTIzNGFiY2QtMTJhYi0zNGNkLTU2ZWYtMTIzNDU2Nzg5MGFiYCAuXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdGhlIGtleSBJRCBvZiBhIEtNUyBrZXksIHNlZSBbS2V5IElEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jb25jZXB0cy5odG1sI2tleS1pZC1rZXktaWQpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEtleUlkXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJLZXlJZDogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGtleSBwb2xpY3kgdGhhdCBhdXRob3JpemVzIHVzZSBvZiB0aGUgS01TIGtleS4gVGhlIGtleSBwb2xpY3kgbXVzdCBjb25mb3JtIHRvIHRoZSBmb2xsb3dpbmcgcnVsZXMuXG4gICAgICpcbiAgICAgKiAtIFRoZSBrZXkgcG9saWN5IG11c3QgYWxsb3cgdGhlIGNhbGxlciB0byBtYWtlIGEgc3Vic2VxdWVudCBbUHV0S2V5UG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1B1dEtleVBvbGljeS5odG1sKSByZXF1ZXN0IG9uIHRoZSBLTVMga2V5LiBUaGlzIHJlZHVjZXMgdGhlIHJpc2sgdGhhdCB0aGUgS01TIGtleSBiZWNvbWVzIHVubWFuYWdlYWJsZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHJlZmVyIHRvIHRoZSBzY2VuYXJpbyBpbiB0aGUgW0RlZmF1bHQga2V5IHBvbGljeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUva2V5LXBvbGljaWVzLmh0bWwja2V5LXBvbGljeS1kZWZhdWx0LWFsbG93LXJvb3QtZW5hYmxlLWlhbSkgc2VjdGlvbiBvZiB0aGUgKipBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqKiAuXG4gICAgICogLSBFYWNoIHN0YXRlbWVudCBpbiB0aGUga2V5IHBvbGljeSBtdXN0IGNvbnRhaW4gb25lIG9yIG1vcmUgcHJpbmNpcGFscy4gVGhlIHByaW5jaXBhbHMgaW4gdGhlIGtleSBwb2xpY3kgbXVzdCBleGlzdCBhbmQgYmUgdmlzaWJsZSB0byBBV1MgS01TIC4gV2hlbiB5b3UgY3JlYXRlIGEgbmV3IEFXUyBwcmluY2lwYWwgKGZvciBleGFtcGxlLCBhbiBJQU0gdXNlciBvciByb2xlKSwgeW91IG1pZ2h0IG5lZWQgdG8gZW5mb3JjZSBhIGRlbGF5IGJlZm9yZSBpbmNsdWRpbmcgdGhlIG5ldyBwcmluY2lwYWwgaW4gYSBrZXkgcG9saWN5IGJlY2F1c2UgdGhlIG5ldyBwcmluY2lwYWwgbWlnaHQgbm90IGJlIGltbWVkaWF0ZWx5IHZpc2libGUgdG8gQVdTIEtNUyAuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NoYW5nZXMgdGhhdCBJIG1ha2UgYXJlIG5vdCBhbHdheXMgaW1tZWRpYXRlbHkgdmlzaWJsZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3Ryb3VibGVzaG9vdF9nZW5lcmFsLmh0bWwjdHJvdWJsZXNob290X2dlbmVyYWxfZXZlbnR1YWwtY29uc2lzdGVuY3kpIGluIHRoZSAqQVdTIElkZW50aXR5IGFuZCBBY2Nlc3MgTWFuYWdlbWVudCBVc2VyIEd1aWRlKiAuXG4gICAgICogLSBUaGUga2V5IHBvbGljeSBzaXplIGxpbWl0IGlzIDMyIGtpbG9ieXRlcyAoMzI3NjggYnl0ZXMpLlxuICAgICAqXG4gICAgICogSWYgeW91IGFyZSB1bnN1cmUgb2Ygd2hpY2ggcG9saWN5IHRvIHVzZSwgY29uc2lkZXIgdGhlICpkZWZhdWx0IGtleSBwb2xpY3kqIC4gVGhpcyBpcyB0aGUga2V5IHBvbGljeSB0aGF0IEFXUyBLTVMgYXBwbGllcyB0byBLTVMga2V5cyB0aGF0IGFyZSBjcmVhdGVkIGJ5IHVzaW5nIHRoZSBDcmVhdGVLZXkgQVBJIHdpdGggbm8gc3BlY2lmaWVkIGtleSBwb2xpY3kuIEl0IGdpdmVzIHRoZSBBV1MgYWNjb3VudCB0aGF0IG93bnMgdGhlIGtleSBwZXJtaXNzaW9uIHRvIHBlcmZvcm0gYWxsIG9wZXJhdGlvbnMgb24gdGhlIGtleS4gSXQgYWxzbyBhbGxvd3MgeW91IHdyaXRlIElBTSBwb2xpY2llcyB0byBhdXRob3JpemUgYWNjZXNzIHRvIHRoZSBrZXkuIEZvciBkZXRhaWxzLCBzZWUgW0RlZmF1bHQga2V5IHBvbGljeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUva2V5LXBvbGljaWVzLmh0bWwja2V5LXBvbGljeS1kZWZhdWx0KSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogKk1pbmltdW0qIDogYDFgXG4gICAgICpcbiAgICAgKiAqTWF4aW11bSogOiBgMzI3NjhgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXkta2V5cG9saWN5XG4gICAgICovXG4gICAgcHVibGljIGtleVBvbGljeTogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGlvbiBvZiB0aGUgS01TIGtleS4gVXNlIGEgZGVzY3JpcHRpb24gdGhhdCBoZWxwcyB5b3UgdG8gZGlzdGluZ3Vpc2ggdGhpcyBLTVMga2V5IGZyb20gb3RoZXJzIGluIHRoZSBhY2NvdW50LCBzdWNoIGFzIGl0cyBpbnRlbmRlZCB1c2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXktZGVzY3JpcHRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzY3JpcHRpb246IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB3aGV0aGVyIHRoZSBLTVMga2V5IGlzIGVuYWJsZWQuIERpc2FibGVkIEtNUyBrZXlzIGNhbm5vdCBiZSB1c2VkIGluIGNyeXB0b2dyYXBoaWMgb3BlcmF0aW9ucy5cbiAgICAgKlxuICAgICAqIFdoZW4gYEVuYWJsZWRgIGlzIGB0cnVlYCAsIHRoZSAqa2V5IHN0YXRlKiBvZiB0aGUgS01TIGtleSBpcyBgRW5hYmxlZGAgLiBXaGVuIGBFbmFibGVkYCBpcyBgZmFsc2VgICwgdGhlIGtleSBzdGF0ZSBvZiB0aGUgS01TIGtleSBpcyBgRGlzYWJsZWRgIC4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYHRydWVgIC5cbiAgICAgKlxuICAgICAqIFRoZSBhY3R1YWwga2V5IHN0YXRlIG9mIHRoZSBLTVMga2V5IG1pZ2h0IGJlIGFmZmVjdGVkIGJ5IGFjdGlvbnMgdGFrZW4gb3V0c2lkZSBvZiBDbG91ZEZvcm1hdGlvbiwgc3VjaCBhcyBydW5uaW5nIHRoZSBbRW5hYmxlS2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0VuYWJsZUtleS5odG1sKSAsIFtEaXNhYmxlS2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rpc2FibGVLZXkuaHRtbCkgLCBvciBbU2NoZWR1bGVLZXlEZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TY2hlZHVsZUtleURlbGV0aW9uLmh0bWwpIG9wZXJhdGlvbnMuXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdGhlIGtleSBzdGF0ZXMgb2YgYSBLTVMga2V5LCBzZWUgW0tleSBzdGF0ZTogRWZmZWN0IG9uIHlvdXIgS01TIGtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUva2V5LXN0YXRlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXktZW5hYmxlZFxuICAgICAqL1xuICAgIHB1YmxpYyBlbmFibGVkOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogRW5hYmxlcyBhdXRvbWF0aWMgcm90YXRpb24gb2YgdGhlIGtleSBtYXRlcmlhbCBmb3IgdGhlIHNwZWNpZmllZCBLTVMga2V5LiBCeSBkZWZhdWx0LCBhdXRvbWF0aWMga2V5IHJvdGF0aW9uIGlzIG5vdCBlbmFibGVkLlxuICAgICAqXG4gICAgICogQVdTIEtNUyBzdXBwb3J0cyBhdXRvbWF0aWMgcm90YXRpb24gb25seSBmb3Igc3ltbWV0cmljIGVuY3J5cHRpb24gS01TIGtleXMgKCBgS2V5U3BlY2AgPSBgU1lNTUVUUklDX0RFRkFVTFRgICkuIEZvciBhc3ltbWV0cmljIEtNUyBrZXlzIGFuZCBITUFDIEtNUyBrZXlzLCBvbWl0IHRoZSBgRW5hYmxlS2V5Um90YXRpb25gIHByb3BlcnR5IG9yIHNldCBpdCB0byBgZmFsc2VgIC5cbiAgICAgKlxuICAgICAqIFRvIGVuYWJsZSBhdXRvbWF0aWMga2V5IHJvdGF0aW9uIG9mIHRoZSBrZXkgbWF0ZXJpYWwgZm9yIGEgbXVsdGktUmVnaW9uIEtNUyBrZXksIHNldCBgRW5hYmxlS2V5Um90YXRpb25gIHRvIGB0cnVlYCBvbiB0aGUgcHJpbWFyeSBrZXkgKGNyZWF0ZWQgYnkgdXNpbmcgYEFXUzo6S01TOjpLZXlgICkuIEFXUyBLTVMgY29waWVzIHRoZSByb3RhdGlvbiBzdGF0dXMgdG8gYWxsIHJlcGxpY2Ega2V5cy4gRm9yIGRldGFpbHMsIHNlZSBbUm90YXRpbmcgbXVsdGktUmVnaW9uIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL211bHRpLXJlZ2lvbi1rZXlzLW1hbmFnZS5odG1sI211bHRpLXJlZ2lvbi1yb3RhdGUpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBXaGVuIHlvdSBlbmFibGUgYXV0b21hdGljIHJvdGF0aW9uLCBBV1MgS01TIGF1dG9tYXRpY2FsbHkgY3JlYXRlcyBuZXcga2V5IG1hdGVyaWFsIGZvciB0aGUgS01TIGtleSBvbmUgeWVhciBhZnRlciB0aGUgZW5hYmxlIGRhdGUgYW5kIGV2ZXJ5IHllYXIgdGhlcmVhZnRlci4gQVdTIEtNUyByZXRhaW5zIGFsbCBrZXkgbWF0ZXJpYWwgdW50aWwgeW91IGRlbGV0ZSB0aGUgS01TIGtleS4gRm9yIGRldGFpbGVkIGluZm9ybWF0aW9uIGFib3V0IGF1dG9tYXRpYyBrZXkgcm90YXRpb24sIHNlZSBbUm90YXRpbmcgS01TIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3JvdGF0ZS1rZXlzLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXktZW5hYmxla2V5cm90YXRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZW5hYmxlS2V5Um90YXRpb246IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIHR5cGUgb2YgS01TIGtleSB0byBjcmVhdGUuIFRoZSBkZWZhdWx0IHZhbHVlLCBgU1lNTUVUUklDX0RFRkFVTFRgICwgY3JlYXRlcyBhIEtNUyBrZXkgd2l0aCBhIDI1Ni1iaXQgc3ltbWV0cmljIGtleSBmb3IgZW5jcnlwdGlvbiBhbmQgZGVjcnlwdGlvbi4gWW91IGNhbid0IGNoYW5nZSB0aGUgYEtleVNwZWNgIHZhbHVlIGFmdGVyIHRoZSBLTVMga2V5IGlzIGNyZWF0ZWQuIEZvciBoZWxwIGNob29zaW5nIGEga2V5IHNwZWMgZm9yIHlvdXIgS01TIGtleSwgc2VlIFtDaG9vc2luZyBhIEtNUyBrZXkgdHlwZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvc3ltbS1hc3ltbS1jaG9vc2UuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFRoZSBgS2V5U3BlY2AgcHJvcGVydHkgZGV0ZXJtaW5lcyB0aGUgdHlwZSBvZiBrZXkgbWF0ZXJpYWwgaW4gdGhlIEtNUyBrZXkgYW5kIHRoZSBhbGdvcml0aG1zIHRoYXQgdGhlIEtNUyBrZXkgc3VwcG9ydHMuIFRvIGZ1cnRoZXIgcmVzdHJpY3QgdGhlIGFsZ29yaXRobXMgdGhhdCBjYW4gYmUgdXNlZCB3aXRoIHRoZSBLTVMga2V5LCB1c2UgYSBjb25kaXRpb24ga2V5IGluIGl0cyBrZXkgcG9saWN5IG9yIElBTSBwb2xpY3kuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0FXUyBLTVMgY29uZGl0aW9uIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3BvbGljeS1jb25kaXRpb25zLmh0bWwjY29uZGl0aW9ucy1rbXMpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiA+IElmIHlvdSBjaGFuZ2UgdGhlIGBLZXlTcGVjYCB2YWx1ZSBvZiBhbiBleGlzdGluZyBLTVMga2V5LCB0aGUgZXhpc3RpbmcgS01TIGtleSBpcyBzY2hlZHVsZWQgZm9yIGRlbGV0aW9uIGFuZCBhIG5ldyBLTVMga2V5IGlzIGNyZWF0ZWQgd2l0aCB0aGUgc3BlY2lmaWVkIGBLZXlTcGVjYCB2YWx1ZS4gV2hpbGUgdGhlIHNjaGVkdWxlZCBkZWxldGlvbiBpcyBwZW5kaW5nLCB5b3UgY2FuJ3QgdXNlIHRoZSBleGlzdGluZyBLTVMga2V5LiBVbmxlc3MgeW91IFtjYW5jZWwgdGhlIHNjaGVkdWxlZCBkZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGVsZXRpbmcta2V5cy5odG1sI2RlbGV0aW5nLWtleXMtc2NoZWR1bGluZy1rZXktZGVsZXRpb24pIG9mIHRoZSBLTVMga2V5IG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24sIGFsbCBkYXRhIGVuY3J5cHRlZCB1bmRlciB0aGUgZXhpc3RpbmcgS01TIGtleSBiZWNvbWVzIHVucmVjb3ZlcmFibGUgd2hlbiB0aGUgS01TIGtleSBpcyBkZWxldGVkLiA+IFtBV1Mgc2VydmljZXMgdGhhdCBhcmUgaW50ZWdyYXRlZCB3aXRoIEFXUyBLTVNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvZmVhdHVyZXMvI0FXU19TZXJ2aWNlX0ludGVncmF0aW9uKSB1c2Ugc3ltbWV0cmljIGVuY3J5cHRpb24gS01TIGtleXMgdG8gcHJvdGVjdCB5b3VyIGRhdGEuIFRoZXNlIHNlcnZpY2VzIGRvIG5vdCBzdXBwb3J0IGVuY3J5cHRpb24gd2l0aCBhc3ltbWV0cmljIEtNUyBrZXlzLiBGb3IgaGVscCBkZXRlcm1pbmluZyB3aGV0aGVyIGEgS01TIGtleSBpcyBhc3ltbWV0cmljLCBzZWUgW0lkZW50aWZ5aW5nIGFzeW1tZXRyaWMgS01TIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2ZpbmQtc3ltbS1hc3ltbS5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQVdTIEtNUyBzdXBwb3J0cyB0aGUgZm9sbG93aW5nIGtleSBzcGVjcyBmb3IgS01TIGtleXM6XG4gICAgICpcbiAgICAgKiAtIFN5bW1ldHJpYyBlbmNyeXB0aW9uIGtleSAoZGVmYXVsdClcbiAgICAgKlxuICAgICAqIC0gYFNZTU1FVFJJQ19ERUZBVUxUYCAoQUVTLTI1Ni1HQ00pXG4gICAgICogLSBITUFDIGtleXMgKHN5bW1ldHJpYylcbiAgICAgKlxuICAgICAqIC0gYEhNQUNfMjI0YFxuICAgICAqIC0gYEhNQUNfMjU2YFxuICAgICAqIC0gYEhNQUNfMzg0YFxuICAgICAqIC0gYEhNQUNfNTEyYFxuICAgICAqIC0gQXN5bW1ldHJpYyBSU0Ega2V5IHBhaXJzXG4gICAgICpcbiAgICAgKiAtIGBSU0FfMjA0OGBcbiAgICAgKiAtIGBSU0FfMzA3MmBcbiAgICAgKiAtIGBSU0FfNDA5NmBcbiAgICAgKiAtIEFzeW1tZXRyaWMgTklTVC1yZWNvbW1lbmRlZCBlbGxpcHRpYyBjdXJ2ZSBrZXkgcGFpcnNcbiAgICAgKlxuICAgICAqIC0gYEVDQ19OSVNUX1AyNTZgIChzZWNwMjU2cjEpXG4gICAgICogLSBgRUNDX05JU1RfUDM4NGAgKHNlY3AzODRyMSlcbiAgICAgKiAtIGBFQ0NfTklTVF9QNTIxYCAoc2VjcDUyMXIxKVxuICAgICAqIC0gT3RoZXIgYXN5bW1ldHJpYyBlbGxpcHRpYyBjdXJ2ZSBrZXkgcGFpcnNcbiAgICAgKlxuICAgICAqIC0gYEVDQ19TRUNHX1AyNTZLMWAgKHNlY3AyNTZrMSksIGNvbW1vbmx5IHVzZWQgZm9yIGNyeXB0b2N1cnJlbmNpZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXkta2V5c3BlY1xuICAgICAqL1xuICAgIHB1YmxpYyBrZXlTcGVjOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBEZXRlcm1pbmVzIHRoZSBbY3J5cHRvZ3JhcGhpYyBvcGVyYXRpb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9jb25jZXB0cy5odG1sI2NyeXB0b2dyYXBoaWMtb3BlcmF0aW9ucykgZm9yIHdoaWNoIHlvdSBjYW4gdXNlIHRoZSBLTVMga2V5LiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBgRU5DUllQVF9ERUNSWVBUYCAuIFRoaXMgcHJvcGVydHkgaXMgcmVxdWlyZWQgZm9yIGFzeW1tZXRyaWMgS01TIGtleXMgYW5kIEhNQUMgS01TIGtleXMuIFlvdSBjYW4ndCBjaGFuZ2UgdGhlIGBLZXlVc2FnZWAgdmFsdWUgYWZ0ZXIgdGhlIEtNUyBrZXkgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IGNoYW5nZSB0aGUgYEtleVVzYWdlYCB2YWx1ZSBvZiBhbiBleGlzdGluZyBLTVMga2V5LCB0aGUgZXhpc3RpbmcgS01TIGtleSBpcyBzY2hlZHVsZWQgZm9yIGRlbGV0aW9uIGFuZCBhIG5ldyBLTVMga2V5IGlzIGNyZWF0ZWQgd2l0aCB0aGUgc3BlY2lmaWVkIGBLZXlVc2FnZWAgdmFsdWUuIFdoaWxlIHRoZSBzY2hlZHVsZWQgZGVsZXRpb24gaXMgcGVuZGluZywgeW91IGNhbid0IHVzZSB0aGUgZXhpc3RpbmcgS01TIGtleS4gVW5sZXNzIHlvdSBbY2FuY2VsIHRoZSBzY2hlZHVsZWQgZGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2RlbGV0aW5nLWtleXMuaHRtbCNkZWxldGluZy1rZXlzLXNjaGVkdWxpbmcta2V5LWRlbGV0aW9uKSBvZiB0aGUgS01TIGtleSBvdXRzaWRlIG9mIENsb3VkRm9ybWF0aW9uLCBhbGwgZGF0YSBlbmNyeXB0ZWQgdW5kZXIgdGhlIGV4aXN0aW5nIEtNUyBrZXkgYmVjb21lcyB1bnJlY292ZXJhYmxlIHdoZW4gdGhlIEtNUyBrZXkgaXMgZGVsZXRlZC5cbiAgICAgKlxuICAgICAqIFNlbGVjdCBvbmx5IG9uZSB2YWxpZCB2YWx1ZS5cbiAgICAgKlxuICAgICAqIC0gRm9yIHN5bW1ldHJpYyBlbmNyeXB0aW9uIEtNUyBrZXlzLCBvbWl0IHRoZSBwcm9wZXJ0eSBvciBzcGVjaWZ5IGBFTkNSWVBUX0RFQ1JZUFRgIC5cbiAgICAgKiAtIEZvciBhc3ltbWV0cmljIEtNUyBrZXlzIHdpdGggUlNBIGtleSBtYXRlcmlhbCwgc3BlY2lmeSBgRU5DUllQVF9ERUNSWVBUYCBvciBgU0lHTl9WRVJJRllgIC5cbiAgICAgKiAtIEZvciBhc3ltbWV0cmljIEtNUyBrZXlzIHdpdGggRUNDIGtleSBtYXRlcmlhbCwgc3BlY2lmeSBgU0lHTl9WRVJJRllgIC5cbiAgICAgKiAtIEZvciBITUFDIEtNUyBrZXlzLCBzcGVjaWZ5IGBHRU5FUkFURV9WRVJJRllfTUFDYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXkta2V5dXNhZ2VcbiAgICAgKi9cbiAgICBwdWJsaWMga2V5VXNhZ2U6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZXMgYSBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXkgdGhhdCB5b3UgY2FuIHJlcGxpY2F0ZSBpbiBvdGhlciBBV1MgUmVnaW9ucyAuIFlvdSBjYW4ndCBjaGFuZ2UgdGhlIGBNdWx0aVJlZ2lvbmAgdmFsdWUgYWZ0ZXIgdGhlIEtNUyBrZXkgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IGNoYW5nZSB0aGUgYE11bHRpUmVnaW9uYCB2YWx1ZSBvZiBhbiBleGlzdGluZyBLTVMga2V5LCB0aGUgZXhpc3RpbmcgS01TIGtleSBpcyBzY2hlZHVsZWQgZm9yIGRlbGV0aW9uIGFuZCBhIG5ldyBLTVMga2V5IGlzIGNyZWF0ZWQgd2l0aCB0aGUgc3BlY2lmaWVkIGBNdWx0aS1SZWdpb25gIHZhbHVlLiBXaGlsZSB0aGUgc2NoZWR1bGVkIGRlbGV0aW9uIGlzIHBlbmRpbmcsIHlvdSBjYW4ndCB1c2UgdGhlIGV4aXN0aW5nIEtNUyBrZXkuIFVubGVzcyB5b3UgW2NhbmNlbCB0aGUgc2NoZWR1bGVkIGRlbGV0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9kZWxldGluZy1rZXlzLmh0bWwjZGVsZXRpbmcta2V5cy1zY2hlZHVsaW5nLWtleS1kZWxldGlvbikgb2YgdGhlIEtNUyBrZXkgb3V0c2lkZSBvZiBDbG91ZEZvcm1hdGlvbiwgYWxsIGRhdGEgZW5jcnlwdGVkIHVuZGVyIHRoZSBleGlzdGluZyBLTVMga2V5IGJlY29tZXMgdW5yZWNvdmVyYWJsZSB3aGVuIHRoZSBLTVMga2V5IGlzIGRlbGV0ZWQuXG4gICAgICpcbiAgICAgKiBGb3IgYSBtdWx0aS1SZWdpb24ga2V5LCBzZXQgdG8gdGhpcyBwcm9wZXJ0eSB0byBgdHJ1ZWAgLiBGb3IgYSBzaW5nbGUtUmVnaW9uIGtleSwgb21pdCB0aGlzIHByb3BlcnR5IG9yIHNldCBpdCB0byBgZmFsc2VgIC4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYGZhbHNlYCAuXG4gICAgICpcbiAgICAgKiAqTXVsdGktUmVnaW9uIGtleXMqIGFyZSBhbiBBV1MgS01TIGZlYXR1cmUgdGhhdCBsZXRzIHlvdSBjcmVhdGUgbXVsdGlwbGUgaW50ZXJvcGVyYWJsZSBLTVMga2V5cyBpbiBkaWZmZXJlbnQgQVdTIFJlZ2lvbnMgLiBCZWNhdXNlIHRoZXNlIEtNUyBrZXlzIGhhdmUgdGhlIHNhbWUga2V5IElELCBrZXkgbWF0ZXJpYWwsIGFuZCBvdGhlciBtZXRhZGF0YSwgeW91IGNhbiB1c2UgdGhlbSB0byBlbmNyeXB0IGRhdGEgaW4gb25lIEFXUyBSZWdpb24gYW5kIGRlY3J5cHQgaXQgaW4gYSBkaWZmZXJlbnQgQVdTIFJlZ2lvbiB3aXRob3V0IG1ha2luZyBhIGNyb3NzLVJlZ2lvbiBjYWxsIG9yIGV4cG9zaW5nIHRoZSBwbGFpbnRleHQgZGF0YS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTXVsdGktUmVnaW9uIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL211bHRpLXJlZ2lvbi1rZXlzLW92ZXJ2aWV3Lmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIGNyZWF0ZSBhIHN5bW1ldHJpYyBlbmNyeXB0aW9uLCBITUFDLCBvciBhc3ltbWV0cmljIG11bHRpLVJlZ2lvbiBLTVMga2V5LCBhbmQgeW91IGNhbiBjcmVhdGUgYSBtdWx0aS1SZWdpb24ga2V5IHdpdGggaW1wb3J0ZWQga2V5IG1hdGVyaWFsLiBIb3dldmVyLCB5b3UgY2Fubm90IGNyZWF0ZSBhIG11bHRpLVJlZ2lvbiBrZXkgaW4gYSBjdXN0b20ga2V5IHN0b3JlLlxuICAgICAqXG4gICAgICogVG8gY3JlYXRlIGEgcmVwbGljYSBvZiB0aGlzIHByaW1hcnkga2V5IGluIGEgZGlmZmVyZW50IEFXUyBSZWdpb24gLCBjcmVhdGUgYW4gW0FXUzo6S01TOjpSZXBsaWNhS2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbCkgcmVzb3VyY2UgaW4gYSBDbG91ZEZvcm1hdGlvbiBzdGFjayBpbiB0aGUgcmVwbGljYSBSZWdpb24uIFNwZWNpZnkgdGhlIGtleSBBUk4gb2YgdGhpcyBwcmltYXJ5IGtleS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1rZXkuaHRtbCNjZm4ta21zLWtleS1tdWx0aXJlZ2lvblxuICAgICAqL1xuICAgIHB1YmxpYyBtdWx0aVJlZ2lvbjogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgbnVtYmVyIG9mIGRheXMgaW4gdGhlIHdhaXRpbmcgcGVyaW9kIGJlZm9yZSBBV1MgS01TIGRlbGV0ZXMgYSBLTVMga2V5IHRoYXQgaGFzIGJlZW4gcmVtb3ZlZCBmcm9tIGEgQ2xvdWRGb3JtYXRpb24gc3RhY2suIEVudGVyIGEgdmFsdWUgYmV0d2VlbiA3IGFuZCAzMCBkYXlzLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAzMCBkYXlzLlxuICAgICAqXG4gICAgICogV2hlbiB5b3UgcmVtb3ZlIGEgS01TIGtleSBmcm9tIGEgQ2xvdWRGb3JtYXRpb24gc3RhY2ssIEFXUyBLTVMgc2NoZWR1bGVzIHRoZSBLTVMga2V5IGZvciBkZWxldGlvbiBhbmQgc3RhcnRzIHRoZSBtYW5kYXRvcnkgd2FpdGluZyBwZXJpb2QuIFRoZSBgUGVuZGluZ1dpbmRvd0luRGF5c2AgcHJvcGVydHkgZGV0ZXJtaW5lcyB0aGUgbGVuZ3RoIG9mIHdhaXRpbmcgcGVyaW9kLiBEdXJpbmcgdGhlIHdhaXRpbmcgcGVyaW9kLCB0aGUga2V5IHN0YXRlIG9mIEtNUyBrZXkgaXMgYFBlbmRpbmcgRGVsZXRpb25gIG9yIGBQZW5kaW5nIFJlcGxpY2EgRGVsZXRpb25gICwgd2hpY2ggcHJldmVudHMgdGhlIEtNUyBrZXkgZnJvbSBiZWluZyB1c2VkIGluIGNyeXB0b2dyYXBoaWMgb3BlcmF0aW9ucy4gV2hlbiB0aGUgd2FpdGluZyBwZXJpb2QgZXhwaXJlcywgQVdTIEtNUyBwZXJtYW5lbnRseSBkZWxldGVzIHRoZSBLTVMga2V5LlxuICAgICAqXG4gICAgICogQVdTIEtNUyB3aWxsIG5vdCBkZWxldGUgYSBbbXVsdGktUmVnaW9uIHByaW1hcnkga2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1vdmVydmlldy5odG1sKSB0aGF0IGhhcyByZXBsaWNhIGtleXMuIElmIHlvdSByZW1vdmUgYSBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXkgZnJvbSBhIENsb3VkRm9ybWF0aW9uIHN0YWNrLCBpdHMga2V5IHN0YXRlIGNoYW5nZXMgdG8gYFBlbmRpbmdSZXBsaWNhRGVsZXRpb25gIHNvIGl0IGNhbm5vdCBiZSByZXBsaWNhdGVkIG9yIHVzZWQgaW4gY3J5cHRvZ3JhcGhpYyBvcGVyYXRpb25zLiBUaGlzIHN0YXRlIGNhbiBwZXJzaXN0IGluZGVmaW5pdGVseS4gV2hlbiB0aGUgbGFzdCBvZiBpdHMgcmVwbGljYSBrZXlzIGlzIGRlbGV0ZWQsIHRoZSBrZXkgc3RhdGUgb2YgdGhlIHByaW1hcnkga2V5IGNoYW5nZXMgdG8gYFBlbmRpbmdEZWxldGlvbmAgYW5kIHRoZSB3YWl0aW5nIHBlcmlvZCBzcGVjaWZpZWQgYnkgYFBlbmRpbmdXaW5kb3dJbkRheXNgIGJlZ2lucy4gV2hlbiB0aGlzIHdhaXRpbmcgcGVyaW9kIGV4cGlyZXMsIEFXUyBLTVMgZGVsZXRlcyB0aGUgcHJpbWFyeSBrZXkuIEZvciBkZXRhaWxzLCBzZWUgW0RlbGV0aW5nIG11bHRpLVJlZ2lvbiBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1kZWxldGUuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFlvdSBjYW5ub3QgdXNlIGEgQ2xvdWRGb3JtYXRpb24gdGVtcGxhdGUgdG8gY2FuY2VsIGRlbGV0aW9uIG9mIHRoZSBLTVMga2V5IGFmdGVyIHlvdSByZW1vdmUgaXQgZnJvbSB0aGUgc3RhY2ssIHJlZ2FyZGxlc3Mgb2YgdGhlIHdhaXRpbmcgcGVyaW9kLiBJZiB5b3Ugc3BlY2lmeSBhIEtNUyBrZXkgaW4geW91ciB0ZW1wbGF0ZSwgZXZlbiBvbmUgd2l0aCB0aGUgc2FtZSBuYW1lLCBDbG91ZEZvcm1hdGlvbiBjcmVhdGVzIGEgbmV3IEtNUyBrZXkuIFRvIGNhbmNlbCBkZWxldGlvbiBvZiBhIEtNUyBrZXksIHVzZSB0aGUgQVdTIEtNUyBjb25zb2xlIG9yIHRoZSBbQ2FuY2VsS2V5RGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ2FuY2VsS2V5RGVsZXRpb24uaHRtbCkgb3BlcmF0aW9uLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBgUGVuZGluZyBEZWxldGlvbmAgYW5kIGBQZW5kaW5nIFJlcGxpY2EgRGVsZXRpb25gIGtleSBzdGF0ZXMsIHNlZSBbS2V5IHN0YXRlOiBFZmZlY3Qgb24geW91ciBLTVMga2V5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9rZXktc3RhdGUuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgZGVsZXRpbmcgS01TIGtleXMsIHNlZSB0aGUgW1NjaGVkdWxlS2V5RGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU2NoZWR1bGVLZXlEZWxldGlvbi5odG1sKSBvcGVyYXRpb24gaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBBUEkgUmVmZXJlbmNlKiBhbmQgW0RlbGV0aW5nIEtNUyBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9kZWxldGluZy1rZXlzLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiAqTWluaW11bSogOiA3XG4gICAgICpcbiAgICAgKiAqTWF4aW11bSogOiAzMFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLWtleS5odG1sI2Nmbi1rbXMta2V5LXBlbmRpbmd3aW5kb3dpbmRheXNcbiAgICAgKi9cbiAgICBwdWJsaWMgcGVuZGluZ1dpbmRvd0luRGF5czogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQXNzaWducyBvbmUgb3IgbW9yZSB0YWdzIHRvIHRoZSByZXBsaWNhIGtleS5cbiAgICAgKlxuICAgICAqID4gVGFnZ2luZyBvciB1bnRhZ2dpbmcgYSBLTVMga2V5IGNhbiBhbGxvdyBvciBkZW55IHBlcm1pc3Npb24gdG8gdGhlIEtNUyBrZXkuIEZvciBkZXRhaWxzLCBzZWUgW0FCQUMgZm9yIEFXUyBLTVNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2FiYWMuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEZvciBpbmZvcm1hdGlvbiBhYm91dCB0YWdzIGluIEFXUyBLTVMgLCBzZWUgW1RhZ2dpbmcga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdGFnZ2luZy1rZXlzLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuIEZvciBpbmZvcm1hdGlvbiBhYm91dCB0YWdzIGluIENsb3VkRm9ybWF0aW9uLCBzZWUgW1RhZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcmVzb3VyY2UtdGFncy5odG1sKSAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMta2V5Lmh0bWwjY2ZuLWttcy1rZXktdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0YWdzOiBjZGsuVGFnTWFuYWdlcjtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpLTVM6OktleWAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuS2V5UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbktleS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ2tleVBvbGljeScsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJBcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0FybicpKTtcbiAgICAgICAgdGhpcy5hdHRyS2V5SWQgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0tleUlkJykpO1xuXG4gICAgICAgIHRoaXMua2V5UG9saWN5ID0gcHJvcHMua2V5UG9saWN5O1xuICAgICAgICB0aGlzLmRlc2NyaXB0aW9uID0gcHJvcHMuZGVzY3JpcHRpb247XG4gICAgICAgIHRoaXMuZW5hYmxlZCA9IHByb3BzLmVuYWJsZWQ7XG4gICAgICAgIHRoaXMuZW5hYmxlS2V5Um90YXRpb24gPSBwcm9wcy5lbmFibGVLZXlSb3RhdGlvbjtcbiAgICAgICAgdGhpcy5rZXlTcGVjID0gcHJvcHMua2V5U3BlYztcbiAgICAgICAgdGhpcy5rZXlVc2FnZSA9IHByb3BzLmtleVVzYWdlO1xuICAgICAgICB0aGlzLm11bHRpUmVnaW9uID0gcHJvcHMubXVsdGlSZWdpb247XG4gICAgICAgIHRoaXMucGVuZGluZ1dpbmRvd0luRGF5cyA9IHByb3BzLnBlbmRpbmdXaW5kb3dJbkRheXM7XG4gICAgICAgIHRoaXMudGFncyA9IG5ldyBjZGsuVGFnTWFuYWdlcihjZGsuVGFnVHlwZS5TVEFOREFSRCwgXCJBV1M6OktNUzo6S2V5XCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5LZXkuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGtleVBvbGljeTogdGhpcy5rZXlQb2xpY3ksXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogdGhpcy5kZXNjcmlwdGlvbixcbiAgICAgICAgICAgIGVuYWJsZWQ6IHRoaXMuZW5hYmxlZCxcbiAgICAgICAgICAgIGVuYWJsZUtleVJvdGF0aW9uOiB0aGlzLmVuYWJsZUtleVJvdGF0aW9uLFxuICAgICAgICAgICAga2V5U3BlYzogdGhpcy5rZXlTcGVjLFxuICAgICAgICAgICAga2V5VXNhZ2U6IHRoaXMua2V5VXNhZ2UsXG4gICAgICAgICAgICBtdWx0aVJlZ2lvbjogdGhpcy5tdWx0aVJlZ2lvbixcbiAgICAgICAgICAgIHBlbmRpbmdXaW5kb3dJbkRheXM6IHRoaXMucGVuZGluZ1dpbmRvd0luRGF5cyxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuS2V5UHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuUmVwbGljYUtleWBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblJlcGxpY2FLZXlQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5IHBvbGljeSB0aGF0IGF1dGhvcml6ZXMgdXNlIG9mIHRoZSByZXBsaWNhIGtleS5cbiAgICAgKlxuICAgICAqIFRoZSBrZXkgcG9saWN5IGlzIG5vdCBhIHNoYXJlZCBwcm9wZXJ0eSBvZiBtdWx0aS1SZWdpb24ga2V5cy4gWW91IGNhbiBzcGVjaWZ5IHRoZSBzYW1lIGtleSBwb2xpY3kgb3IgYSBkaWZmZXJlbnQga2V5IHBvbGljeSBmb3IgZWFjaCBrZXkgaW4gYSBzZXQgb2YgcmVsYXRlZCBtdWx0aS1SZWdpb24ga2V5cy4gQVdTIEtNUyBkb2VzIG5vdCBzeW5jaHJvbml6ZSB0aGlzIHByb3BlcnR5LlxuICAgICAqXG4gICAgICogVGhlIGtleSBwb2xpY3kgbXVzdCBjb25mb3JtIHRvIHRoZSBmb2xsb3dpbmcgcnVsZXMuXG4gICAgICpcbiAgICAgKiAtIFRoZSBrZXkgcG9saWN5IG11c3QgZ2l2ZSB0aGUgY2FsbGVyIFtQdXRLZXlQb2xpY3ldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfUHV0S2V5UG9saWN5Lmh0bWwpIHBlcm1pc3Npb24gb24gdGhlIEtNUyBrZXkuIFRoaXMgcmVkdWNlcyB0aGUgcmlzayB0aGF0IHRoZSBLTVMga2V5IGJlY29tZXMgdW5tYW5hZ2VhYmxlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgcmVmZXIgdG8gdGhlIHNjZW5hcmlvIGluIHRoZSBbRGVmYXVsdCBrZXkgcG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9rZXktcG9saWNpZXMuaHRtbCNrZXktcG9saWN5LWRlZmF1bHQtYWxsb3ctcm9vdC1lbmFibGUtaWFtKSBzZWN0aW9uIG9mIHRoZSAqKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSoqIC5cbiAgICAgKiAtIEVhY2ggc3RhdGVtZW50IGluIHRoZSBrZXkgcG9saWN5IG11c3QgY29udGFpbiBvbmUgb3IgbW9yZSBwcmluY2lwYWxzLiBUaGUgcHJpbmNpcGFscyBpbiB0aGUga2V5IHBvbGljeSBtdXN0IGV4aXN0IGFuZCBiZSB2aXNpYmxlIHRvIEFXUyBLTVMgLiBXaGVuIHlvdSBjcmVhdGUgYSBuZXcgQVdTIHByaW5jaXBhbCAoZm9yIGV4YW1wbGUsIGFuIElBTSB1c2VyIG9yIHJvbGUpLCB5b3UgbWlnaHQgbmVlZCB0byBlbmZvcmNlIGEgZGVsYXkgYmVmb3JlIGluY2x1ZGluZyB0aGUgbmV3IHByaW5jaXBhbCBpbiBhIGtleSBwb2xpY3kgYmVjYXVzZSB0aGUgbmV3IHByaW5jaXBhbCBtaWdodCBub3QgYmUgaW1tZWRpYXRlbHkgdmlzaWJsZSB0byBBV1MgS01TIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ2hhbmdlcyB0aGF0IEkgbWFrZSBhcmUgbm90IGFsd2F5cyBpbW1lZGlhdGVseSB2aXNpYmxlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvdHJvdWJsZXNob290X2dlbmVyYWwuaHRtbCN0cm91Ymxlc2hvb3RfZ2VuZXJhbF9ldmVudHVhbC1jb25zaXN0ZW5jeSkgaW4gdGhlICpBV1MgSWRlbnRpdHkgYW5kIEFjY2VzcyBNYW5hZ2VtZW50IFVzZXIgR3VpZGUqIC5cbiAgICAgKiAtIFRoZSBrZXkgcG9saWN5IHNpemUgbGltaXQgaXMgMzIga2lsb2J5dGVzICgzMjc2OCBieXRlcykuXG4gICAgICpcbiAgICAgKiAqTWluaW11bSogOiBgMWBcbiAgICAgKlxuICAgICAqICpNYXhpbXVtKiA6IGAzMjc2OGBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1yZXBsaWNha2V5Lmh0bWwjY2ZuLWttcy1yZXBsaWNha2V5LWtleXBvbGljeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGtleVBvbGljeTogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXkgdG8gcmVwbGljYXRlLiBUaGUgcHJpbWFyeSBrZXkgbXVzdCBiZSBpbiBhIGRpZmZlcmVudCBBV1MgUmVnaW9uIG9mIHRoZSBzYW1lIEFXUyBwYXJ0aXRpb24uIFlvdSBjYW4gY3JlYXRlIG9ubHkgb25lIHJlcGxpY2Egb2YgYSBnaXZlbiBwcmltYXJ5IGtleSBpbiBlYWNoIEFXUyBSZWdpb24gLlxuICAgICAqXG4gICAgICogPiBJZiB5b3UgY2hhbmdlIHRoZSBgUHJpbWFyeUtleUFybmAgdmFsdWUgb2YgYSByZXBsaWNhIGtleSwgdGhlIGV4aXN0aW5nIHJlcGxpY2Ega2V5IGlzIHNjaGVkdWxlZCBmb3IgZGVsZXRpb24gYW5kIGEgbmV3IHJlcGxpY2Ega2V5IGlzIGNyZWF0ZWQgYmFzZWQgb24gdGhlIHNwZWNpZmllZCBwcmltYXJ5IGtleS4gV2hpbGUgaXQgaXMgc2NoZWR1bGVkIGZvciBkZWxldGlvbiwgdGhlIGV4aXN0aW5nIHJlcGxpY2Ega2V5IGJlY29tZXMgdW51c2FibGUuIFlvdSBjYW4gY2FuY2VsIHRoZSBzY2hlZHVsZWQgZGVsZXRpb24gb2YgdGhlIGtleSBvdXRzaWRlIG9mIENsb3VkRm9ybWF0aW9uLlxuICAgICAqID5cbiAgICAgKiA+IEhvd2V2ZXIsIGlmIHlvdSBpbmFkdmVydGVudGx5IGRlbGV0ZSBhIHJlcGxpY2Ega2V5LCB5b3UgY2FuIGRlY3J5cHQgY2lwaGVydGV4dCBlbmNyeXB0ZWQgYnkgdGhhdCByZXBsaWNhIGtleSBieSB1c2luZyBhbnkgcmVsYXRlZCBtdWx0aS1SZWdpb24ga2V5LiBJZiBuZWNlc3NhcnksIHlvdSBjYW4gcmVjcmVhdGUgdGhlIHJlcGxpY2EgaW4gdGhlIHNhbWUgUmVnaW9uIGFmdGVyIHRoZSBwcmV2aW91cyBvbmUgaXMgY29tcGxldGVseSBkZWxldGVkLiBGb3IgZGV0YWlscywgc2VlIFtEZWxldGluZyBtdWx0aS1SZWdpb24ga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtZGVsZXRlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKlxuICAgICAqXG4gICAgICogU3BlY2lmeSB0aGUga2V5IEFSTiBvZiBhbiBleGlzdGluZyBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXkuIEZvciBleGFtcGxlLCBgYXJuOmF3czprbXM6dXMtZWFzdC0yOjExMTEyMjIyMzMzMzprZXkvbXJrLTEyMzRhYmNkMTJhYjM0Y2Q1NmVmMTIzNDU2Nzg5MGFiYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMtcmVwbGljYWtleS5odG1sI2Nmbi1rbXMtcmVwbGljYWtleS1wcmltYXJ5a2V5YXJuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpbWFyeUtleUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGlvbiBvZiB0aGUgS01TIGtleS5cbiAgICAgKlxuICAgICAqIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGFuIGVtcHR5IHN0cmluZyAobm8gZGVzY3JpcHRpb24pLlxuICAgICAqXG4gICAgICogVGhlIGRlc2NyaXB0aW9uIGlzIG5vdCBhIHNoYXJlZCBwcm9wZXJ0eSBvZiBtdWx0aS1SZWdpb24ga2V5cy4gWW91IGNhbiBzcGVjaWZ5IHRoZSBzYW1lIGRlc2NyaXB0aW9uIG9yIGEgZGlmZmVyZW50IGRlc2NyaXB0aW9uIGZvciBlYWNoIGtleSBpbiBhIHNldCBvZiByZWxhdGVkIG11bHRpLVJlZ2lvbiBrZXlzLiBBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBkb2VzIG5vdCBzeW5jaHJvbml6ZSB0aGlzIHByb3BlcnR5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbCNjZm4ta21zLXJlcGxpY2FrZXktZGVzY3JpcHRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB3aGV0aGVyIHRoZSByZXBsaWNhIGtleSBpcyBlbmFibGVkLiBEaXNhYmxlZCBLTVMga2V5cyBjYW5ub3QgYmUgdXNlZCBpbiBjcnlwdG9ncmFwaGljIG9wZXJhdGlvbnMuXG4gICAgICpcbiAgICAgKiBXaGVuIGBFbmFibGVkYCBpcyBgdHJ1ZWAgLCB0aGUgKmtleSBzdGF0ZSogb2YgdGhlIEtNUyBrZXkgaXMgYEVuYWJsZWRgIC4gV2hlbiBgRW5hYmxlZGAgaXMgYGZhbHNlYCAsIHRoZSBrZXkgc3RhdGUgb2YgdGhlIEtNUyBrZXkgaXMgYERpc2FibGVkYCAuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGB0cnVlYCAuXG4gICAgICpcbiAgICAgKiBUaGUgYWN0dWFsIGtleSBzdGF0ZSBvZiB0aGUgcmVwbGljYSBtaWdodCBiZSBhZmZlY3RlZCBieSBhY3Rpb25zIHRha2VuIG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24sIHN1Y2ggYXMgcnVubmluZyB0aGUgW0VuYWJsZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FbmFibGVLZXkuaHRtbCkgLCBbRGlzYWJsZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EaXNhYmxlS2V5Lmh0bWwpICwgb3IgW1NjaGVkdWxlS2V5RGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU2NoZWR1bGVLZXlEZWxldGlvbi5odG1sKSBvcGVyYXRpb25zLiBBbHNvLCB3aGlsZSB0aGUgcmVwbGljYSBrZXkgaXMgYmVpbmcgY3JlYXRlZCwgaXRzIGtleSBzdGF0ZSBpcyBgQ3JlYXRpbmdgIC4gV2hlbiB0aGUgcHJvY2VzcyBpcyBjb21wbGV0ZSwgdGhlIGtleSBzdGF0ZSBvZiB0aGUgcmVwbGljYSBrZXkgY2hhbmdlcyB0byBgRW5hYmxlZGAgLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBrZXkgc3RhdGVzIG9mIGEgS01TIGtleSwgc2VlIFtLZXkgc3RhdGU6IEVmZmVjdCBvbiB5b3VyIEtNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2tleS1zdGF0ZS5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbCNjZm4ta21zLXJlcGxpY2FrZXktZW5hYmxlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuYWJsZWQ/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBudW1iZXIgb2YgZGF5cyBpbiB0aGUgd2FpdGluZyBwZXJpb2QgYmVmb3JlIEFXUyBLTVMgZGVsZXRlcyBhIHJlcGxpY2Ega2V5IHRoYXQgaGFzIGJlZW4gcmVtb3ZlZCBmcm9tIGEgQ2xvdWRGb3JtYXRpb24gc3RhY2suIEVudGVyIGEgdmFsdWUgYmV0d2VlbiA3IGFuZCAzMCBkYXlzLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAzMCBkYXlzLlxuICAgICAqXG4gICAgICogV2hlbiB5b3UgcmVtb3ZlIGEgcmVwbGljYSBrZXkgZnJvbSBhIENsb3VkRm9ybWF0aW9uIHN0YWNrLCBBV1MgS01TIHNjaGVkdWxlcyB0aGUgcmVwbGljYSBrZXkgZm9yIGRlbGV0aW9uIGFuZCBzdGFydHMgdGhlIG1hbmRhdG9yeSB3YWl0aW5nIHBlcmlvZC4gVGhlIGBQZW5kaW5nV2luZG93SW5EYXlzYCBwcm9wZXJ0eSBkZXRlcm1pbmVzIHRoZSBsZW5ndGggb2Ygd2FpdGluZyBwZXJpb2QuIER1cmluZyB0aGUgd2FpdGluZyBwZXJpb2QsIHRoZSBrZXkgc3RhdGUgb2YgcmVwbGljYSBrZXkgaXMgYFBlbmRpbmcgRGVsZXRpb25gICwgd2hpY2ggcHJldmVudHMgaXQgZnJvbSBiZWluZyB1c2VkIGluIGNyeXB0b2dyYXBoaWMgb3BlcmF0aW9ucy4gV2hlbiB0aGUgd2FpdGluZyBwZXJpb2QgZXhwaXJlcywgQVdTIEtNUyBwZXJtYW5lbnRseSBkZWxldGVzIHRoZSByZXBsaWNhIGtleS5cbiAgICAgKlxuICAgICAqIElmIHRoZSBLTVMga2V5IGlzIGEgbXVsdGktUmVnaW9uIHByaW1hcnkga2V5IHdpdGggcmVwbGljYSBrZXlzLCB0aGUgd2FpdGluZyBwZXJpb2QgYmVnaW5zIHdoZW4gdGhlIGxhc3Qgb2YgaXRzIHJlcGxpY2Ega2V5cyBpcyBkZWxldGVkLiBPdGhlcndpc2UsIHRoZSB3YWl0aW5nIHBlcmlvZCBiZWdpbnMgaW1tZWRpYXRlbHkuXG4gICAgICpcbiAgICAgKiBZb3UgY2Fubm90IHVzZSBhIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIHRvIGNhbmNlbCBkZWxldGlvbiBvZiB0aGUgcmVwbGljYSBhZnRlciB5b3UgcmVtb3ZlIGl0IGZyb20gdGhlIHN0YWNrLCByZWdhcmRsZXNzIG9mIHRoZSB3YWl0aW5nIHBlcmlvZC4gSG93ZXZlciwgaWYgeW91IHNwZWNpZnkgYSByZXBsaWNhIGtleSBpbiB5b3VyIHRlbXBsYXRlIHRoYXQgaXMgYmFzZWQgb24gdGhlIHNhbWUgcHJpbWFyeSBrZXkgYXMgdGhlIG9yaWdpbmFsIHJlcGxpY2Ega2V5LCBDbG91ZEZvcm1hdGlvbiBjcmVhdGVzIGEgbmV3IHJlcGxpY2Ega2V5IHdpdGggdGhlIHNhbWUga2V5IElELCBrZXkgbWF0ZXJpYWwsIGFuZCBvdGhlciBzaGFyZWQgcHJvcGVydGllcyBvZiB0aGUgb3JpZ2luYWwgcmVwbGljYSBrZXkuIFRoaXMgbmV3IHJlcGxpY2Ega2V5IGNhbiBkZWNyeXB0IGNpcGhlcnRleHQgdGhhdCB3YXMgZW5jcnlwdGVkIHVuZGVyIHRoZSBvcmlnaW5hbCByZXBsaWNhIGtleSwgb3IgYW55IHJlbGF0ZWQgbXVsdGktUmVnaW9uIGtleS5cbiAgICAgKlxuICAgICAqIEZvciBkZXRhaWxlZCBpbmZvcm1hdGlvbiBhYm91dCBkZWxldGluZyBtdWx0aS1SZWdpb24ga2V5cywgc2VlIFtEZWxldGluZyBtdWx0aS1SZWdpb24ga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtZGVsZXRlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdGhlIGBQZW5kaW5nRGVsZXRpb25gIGtleSBzdGF0ZSwgc2VlIFtLZXkgc3RhdGU6IEVmZmVjdCBvbiB5b3VyIEtNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2tleS1zdGF0ZS5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBkZWxldGluZyBLTVMga2V5cywgc2VlIHRoZSBbU2NoZWR1bGVLZXlEZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TY2hlZHVsZUtleURlbGV0aW9uLmh0bWwpIG9wZXJhdGlvbiBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIEFQSSBSZWZlcmVuY2UqIGFuZCBbRGVsZXRpbmcgS01TIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2RlbGV0aW5nLWtleXMuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqICpNaW5pbXVtKiA6IDdcbiAgICAgKlxuICAgICAqICpNYXhpbXVtKiA6IDMwXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMtcmVwbGljYWtleS5odG1sI2Nmbi1rbXMtcmVwbGljYWtleS1wZW5kaW5nd2luZG93aW5kYXlzXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVuZGluZ1dpbmRvd0luRGF5cz86IG51bWJlcjtcblxuICAgIC8qKlxuICAgICAqIEFzc2lnbnMgb25lIG9yIG1vcmUgdGFncyB0byB0aGUgcmVwbGljYSBrZXkuXG4gICAgICpcbiAgICAgKiA+IFRhZ2dpbmcgb3IgdW50YWdnaW5nIGEgS01TIGtleSBjYW4gYWxsb3cgb3IgZGVueSBwZXJtaXNzaW9uIHRvIHRoZSBLTVMga2V5LiBGb3IgZGV0YWlscywgc2VlIFtBQkFDIGZvciBBV1MgS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hYmFjLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBUYWdzIGFyZSBub3QgYSBzaGFyZWQgcHJvcGVydHkgb2YgbXVsdGktUmVnaW9uIGtleXMuIFlvdSBjYW4gc3BlY2lmeSB0aGUgc2FtZSB0YWdzIG9yIGRpZmZlcmVudCB0YWdzIGZvciBlYWNoIGtleSBpbiBhIHNldCBvZiByZWxhdGVkIG11bHRpLVJlZ2lvbiBrZXlzLiBBV1MgS01TIGRvZXMgbm90IHN5bmNocm9uaXplIHRoaXMgcHJvcGVydHkuXG4gICAgICpcbiAgICAgKiBFYWNoIHRhZyBjb25zaXN0cyBvZiBhIHRhZyBrZXkgYW5kIGEgdGFnIHZhbHVlLiBCb3RoIHRoZSB0YWcga2V5IGFuZCB0aGUgdGFnIHZhbHVlIGFyZSByZXF1aXJlZCwgYnV0IHRoZSB0YWcgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IChudWxsKSBzdHJpbmcuIFlvdSBjYW5ub3QgaGF2ZSBtb3JlIHRoYW4gb25lIHRhZyBvbiBhIEtNUyBrZXkgd2l0aCB0aGUgc2FtZSB0YWcga2V5LiBJZiB5b3Ugc3BlY2lmeSBhbiBleGlzdGluZyB0YWcga2V5IHdpdGggYSBkaWZmZXJlbnQgdGFnIHZhbHVlLCBBV1MgS01TIHJlcGxhY2VzIHRoZSBjdXJyZW50IHRhZyB2YWx1ZSB3aXRoIHRoZSBzcGVjaWZpZWQgb25lLlxuICAgICAqXG4gICAgICogV2hlbiB5b3UgYXNzaWduIHRhZ3MgdG8gYW4gQVdTIHJlc291cmNlLCBBV1MgZ2VuZXJhdGVzIGEgY29zdCBhbGxvY2F0aW9uIHJlcG9ydCB3aXRoIHVzYWdlIGFuZCBjb3N0cyBhZ2dyZWdhdGVkIGJ5IHRhZ3MuIFRhZ3MgY2FuIGFsc28gYmUgdXNlZCB0byBjb250cm9sIGFjY2VzcyB0byBhIEtNUyBrZXkuIEZvciBkZXRhaWxzLCBzZWUgW1RhZ2dpbmcga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdGFnZ2luZy1rZXlzLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1yZXBsaWNha2V5Lmh0bWwjY2ZuLWttcy1yZXBsaWNha2V5LXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmblJlcGxpY2FLZXlQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuUmVwbGljYUtleVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblJlcGxpY2FLZXlQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc2NyaXB0aW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlbmFibGVkJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5lbmFibGVkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXlQb2xpY3knLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMua2V5UG9saWN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXlQb2xpY3knLCBjZGsudmFsaWRhdGVPYmplY3QpKHByb3BlcnRpZXMua2V5UG9saWN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwZW5kaW5nV2luZG93SW5EYXlzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnBlbmRpbmdXaW5kb3dJbkRheXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ByaW1hcnlLZXlBcm4nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJpbWFyeUtleUFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJpbWFyeUtleUFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wcmltYXJ5S2V5QXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmblJlcGxpY2FLZXlQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6S01TOjpSZXBsaWNhS2V5YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5SZXBsaWNhS2V5UHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OktNUzo6UmVwbGljYUtleWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5SZXBsaWNhS2V5UHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblJlcGxpY2FLZXlQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgS2V5UG9saWN5OiBjZGsub2JqZWN0VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtleVBvbGljeSksXG4gICAgICAgIFByaW1hcnlLZXlBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJpbWFyeUtleUFybiksXG4gICAgICAgIERlc2NyaXB0aW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSxcbiAgICAgICAgRW5hYmxlZDogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZW5hYmxlZCksXG4gICAgICAgIFBlbmRpbmdXaW5kb3dJbkRheXM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucGVuZGluZ1dpbmRvd0luRGF5cyksXG4gICAgICAgIFRhZ3M6IGNkay5saXN0TWFwcGVyKGNkay5jZm5UYWdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnRhZ3MpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5SZXBsaWNhS2V5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5SZXBsaWNhS2V5UHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblJlcGxpY2FLZXlQcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2tleVBvbGljeScsICdLZXlQb2xpY3knLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFueShwcm9wZXJ0aWVzLktleVBvbGljeSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJpbWFyeUtleUFybicsICdQcmltYXJ5S2V5QXJuJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QcmltYXJ5S2V5QXJuKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXNjcmlwdGlvbicsICdEZXNjcmlwdGlvbicsIHByb3BlcnRpZXMuRGVzY3JpcHRpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGVzY3JpcHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2VuYWJsZWQnLCAnRW5hYmxlZCcsIHByb3BlcnRpZXMuRW5hYmxlZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuRW5hYmxlZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncGVuZGluZ1dpbmRvd0luRGF5cycsICdQZW5kaW5nV2luZG93SW5EYXlzJywgcHJvcGVydGllcy5QZW5kaW5nV2luZG93SW5EYXlzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlBlbmRpbmdXaW5kb3dJbkRheXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6S01TOjpSZXBsaWNhS2V5YFxuICpcbiAqIFRoZSBgQVdTOjpLTVM6OlJlcGxpY2FLZXlgIHJlc291cmNlIHNwZWNpZmllcyBhIG11bHRpLVJlZ2lvbiByZXBsaWNhIGtleSB0aGF0IGlzIGJhc2VkIG9uIGEgbXVsdGktUmVnaW9uIHByaW1hcnkga2V5LlxuICpcbiAqICpNdWx0aS1SZWdpb24ga2V5cyogYXJlIGFuIEFXUyBLTVMgZmVhdHVyZSB0aGF0IGxldHMgeW91IGNyZWF0ZSBtdWx0aXBsZSBpbnRlcm9wZXJhYmxlIEtNUyBrZXlzIGluIGRpZmZlcmVudCBBV1MgUmVnaW9ucyAuIEJlY2F1c2UgdGhlc2UgS01TIGtleXMgaGF2ZSB0aGUgc2FtZSBrZXkgSUQsIGtleSBtYXRlcmlhbCwgYW5kIG90aGVyIG1ldGFkYXRhLCB5b3UgY2FuIHVzZSB0aGVtIHRvIGVuY3J5cHQgZGF0YSBpbiBvbmUgQVdTIFJlZ2lvbiBhbmQgZGVjcnlwdCBpdCBpbiBhIGRpZmZlcmVudCBBV1MgUmVnaW9uIHdpdGhvdXQgbWFraW5nIGEgY3Jvc3MtUmVnaW9uIGNhbGwgb3IgZXhwb3NpbmcgdGhlIHBsYWludGV4dCBkYXRhLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtNdWx0aS1SZWdpb24ga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtb3ZlcnZpZXcuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiBBIG11bHRpLVJlZ2lvbiAqcHJpbWFyeSBrZXkqIGlzIGEgZnVsbHkgZnVuY3Rpb25hbCBzeW1tZXRyaWMgZW5jcnlwdGlvbiBLTVMga2V5LCBITUFDIEtNUyBrZXksIG9yIGFzeW1tZXRyaWMgS01TIGtleSB0aGF0IGlzIGFsc28gdGhlIG1vZGVsIGZvciByZXBsaWNhIGtleXMgaW4gb3RoZXIgQVdTIFJlZ2lvbnMgLiBUbyBjcmVhdGUgYSBtdWx0aS1SZWdpb24gcHJpbWFyeSBrZXksIGFkZCBhbiBbQVdTOjpLTVM6OktleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1rZXkuaHRtbCkgcmVzb3VyY2UgdG8geW91ciBDbG91ZEZvcm1hdGlvbiBzdGFjay4gU2V0IGl0cyBgTXVsdGlSZWdpb25gIHByb3BlcnR5IHRvIHRydWUuXG4gKlxuICogQSBtdWx0aS1SZWdpb24gKnJlcGxpY2Ega2V5KiBpcyBhIGZ1bGx5IGZ1bmN0aW9uYWwgS01TIGtleSB0aGF0IGhhcyB0aGUgc2FtZSBrZXkgSUQgYW5kIGtleSBtYXRlcmlhbCBhcyBhIG11bHRpLVJlZ2lvbiBwcmltYXJ5IGtleSwgYnV0IGlzIGxvY2F0ZWQgaW4gYSBkaWZmZXJlbnQgQVdTIFJlZ2lvbiBvZiB0aGUgc2FtZSBBV1MgcGFydGl0aW9uLiBUaGVyZSBjYW4gYmUgbXVsdGlwbGUgcmVwbGljYXMgb2YgYSBwcmltYXJ5IGtleSwgYnV0IGVhY2ggbXVzdCBiZSBpbiBhIGRpZmZlcmVudCBBV1MgUmVnaW9uIC5cbiAqXG4gKiBXaGVuIHlvdSBjcmVhdGUgYSByZXBsaWNhIGtleSBpbiBBV1MgQ2xvdWRGb3JtYXRpb24gLCB0aGUgcmVwbGljYSBrZXkgaXMgY3JlYXRlZCBpbiB0aGUgQVdTIFJlZ2lvbiByZXByZXNlbnRlZCBieSB0aGUgZW5kcG9pbnQgeW91IHVzZSBmb3IgdGhlIHJlcXVlc3QuIElmIHlvdSB0cnkgdG8gcmVwbGljYXRlIGEgbXVsdGktUmVnaW9uIGtleSBpbnRvIGEgUmVnaW9uIGluIHdoaWNoIHRoZSBrZXkgdHlwZSBpcyBub3Qgc3VwcG9ydGVkLCB0aGUgcmVxdWVzdCB3aWxsIGZhaWwuXG4gKlxuICogPiBITUFDIEtNUyBrZXlzIGFyZSBub3Qgc3VwcG9ydGVkIGluIGFsbCBBV1MgUmVnaW9ucyAuIEZvciBhIGxpc3Qgb2Ygc3VwcG9ydGVkIFJlZ2lvbnMsIHNlZSBbSE1BQyBrZXlzIGluIEFXUyBLTVNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2htYWMuaHRtbCNobWFjLXJlZ2lvbnMpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gKlxuICogQSBwcmltYXJ5IGtleSBhbmQgaXRzIHJlcGxpY2FzIGhhdmUgdGhlIHNhbWUga2V5IElEIGFuZCBrZXkgbWF0ZXJpYWwuIFRoZXkgYWxzbyBoYXZlIHRoZSBzYW1lIGtleSBzcGVjLCBrZXkgdXNhZ2UsIGtleSBtYXRlcmlhbCBvcmlnaW4sIGFuZCBhdXRvbWF0aWMga2V5IHJvdGF0aW9uIHN0YXR1cy4gVGhlc2UgcHJvcGVydGllcyBhcmUga25vd24gYXMgKnNoYXJlZCBwcm9wZXJ0aWVzKiAuIElmIHRoZXkgY2hhbmdlLCBBV1MgS01TIHN5bmNocm9uaXplcyB0aGUgY2hhbmdlIHRvIGFsbCByZWxhdGVkIG11bHRpLVJlZ2lvbiBrZXlzLiBBbGwgb3RoZXIgcHJvcGVydGllcyBvZiBhIHJlcGxpY2Ega2V5IGNhbiBkaWZmZXIsIGluY2x1ZGluZyBpdHMga2V5IHBvbGljeSwgdGFncywgYWxpYXNlcywgYW5kIGtleSBzdGF0ZS4gQVdTIEtNUyBkb2VzIG5vdCBzeW5jaHJvbml6ZSB0aGVzZSBwcm9wZXJ0aWVzLlxuICpcbiAqICpSZWdpb25zKlxuICpcbiAqIEFXUyBLTVMgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2VzIGFyZSBzdXBwb3J0ZWQgaW4gYWxsIFJlZ2lvbnMgaW4gd2hpY2ggQVdTIENsb3VkRm9ybWF0aW9uIGlzIHN1cHBvcnRlZC4gSG93ZXZlciwgaW4gdGhlICAoYXAtc291dGhlYXN0LTMpLCB5b3UgY2Fubm90IHVzZSBhIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIHRvIGNyZWF0ZSBvciBtYW5hZ2UgbXVsdGktUmVnaW9uIEtNUyBrZXlzIChwcmltYXJ5IG9yIHJlcGxpY2EpLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6S01TOjpSZXBsaWNhS2V5XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuUmVwbGljYUtleSBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OktNUzo6UmVwbGljYUtleVwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuUmVwbGljYUtleSB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuUmVwbGljYUtleVByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5SZXBsaWNhS2V5KHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgcmVwbGljYSBrZXksIHN1Y2ggYXMgYGFybjphd3M6a21zOnVzLXdlc3QtMjoxMTExMjIyMjMzMzM6a2V5L21yay0xMjM0YWJjZDEyYWIzNGNkNTZlZjEyMzQ1Njc4OTBhYmAgLlxuICAgICAqXG4gICAgICogVGhlIGtleSBBUk5zIG9mIHJlbGF0ZWQgbXVsdGktUmVnaW9uIGtleXMgZGlmZmVyIG9ubHkgaW4gdGhlIFJlZ2lvbiB2YWx1ZS4gRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBrZXkgQVJOcyBvZiBtdWx0aS1SZWdpb24ga2V5cywgc2VlIFtIb3cgbXVsdGktUmVnaW9uIGtleXMgd29ya10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtb3ZlcnZpZXcuaHRtbCNtcmstaG93LWl0LXdvcmtzKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGtleSBJRCBvZiB0aGUgcmVwbGljYSBrZXksIHN1Y2ggYXMgYG1yay0xMjM0YWJjZDEyYWIzNGNkNTZlZjEyMzQ1Njc4OTBhYmAgLlxuICAgICAqXG4gICAgICogUmVsYXRlZCBtdWx0aS1SZWdpb24ga2V5cyBoYXZlIHRoZSBzYW1lIGtleSBJRC4gRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBrZXkgSURzIG9mIG11bHRpLVJlZ2lvbiBrZXlzLCBzZWUgW0hvdyBtdWx0aS1SZWdpb24ga2V5cyB3b3JrXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1vdmVydmlldy5odG1sI21yay1ob3ctaXQtd29ya3MpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEtleUlkXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJLZXlJZDogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGtleSBwb2xpY3kgdGhhdCBhdXRob3JpemVzIHVzZSBvZiB0aGUgcmVwbGljYSBrZXkuXG4gICAgICpcbiAgICAgKiBUaGUga2V5IHBvbGljeSBpcyBub3QgYSBzaGFyZWQgcHJvcGVydHkgb2YgbXVsdGktUmVnaW9uIGtleXMuIFlvdSBjYW4gc3BlY2lmeSB0aGUgc2FtZSBrZXkgcG9saWN5IG9yIGEgZGlmZmVyZW50IGtleSBwb2xpY3kgZm9yIGVhY2gga2V5IGluIGEgc2V0IG9mIHJlbGF0ZWQgbXVsdGktUmVnaW9uIGtleXMuIEFXUyBLTVMgZG9lcyBub3Qgc3luY2hyb25pemUgdGhpcyBwcm9wZXJ0eS5cbiAgICAgKlxuICAgICAqIFRoZSBrZXkgcG9saWN5IG11c3QgY29uZm9ybSB0byB0aGUgZm9sbG93aW5nIHJ1bGVzLlxuICAgICAqXG4gICAgICogLSBUaGUga2V5IHBvbGljeSBtdXN0IGdpdmUgdGhlIGNhbGxlciBbUHV0S2V5UG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1B1dEtleVBvbGljeS5odG1sKSBwZXJtaXNzaW9uIG9uIHRoZSBLTVMga2V5LiBUaGlzIHJlZHVjZXMgdGhlIHJpc2sgdGhhdCB0aGUgS01TIGtleSBiZWNvbWVzIHVubWFuYWdlYWJsZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHJlZmVyIHRvIHRoZSBzY2VuYXJpbyBpbiB0aGUgW0RlZmF1bHQga2V5IHBvbGljeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUva2V5LXBvbGljaWVzLmh0bWwja2V5LXBvbGljeS1kZWZhdWx0LWFsbG93LXJvb3QtZW5hYmxlLWlhbSkgc2VjdGlvbiBvZiB0aGUgKipBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqKiAuXG4gICAgICogLSBFYWNoIHN0YXRlbWVudCBpbiB0aGUga2V5IHBvbGljeSBtdXN0IGNvbnRhaW4gb25lIG9yIG1vcmUgcHJpbmNpcGFscy4gVGhlIHByaW5jaXBhbHMgaW4gdGhlIGtleSBwb2xpY3kgbXVzdCBleGlzdCBhbmQgYmUgdmlzaWJsZSB0byBBV1MgS01TIC4gV2hlbiB5b3UgY3JlYXRlIGEgbmV3IEFXUyBwcmluY2lwYWwgKGZvciBleGFtcGxlLCBhbiBJQU0gdXNlciBvciByb2xlKSwgeW91IG1pZ2h0IG5lZWQgdG8gZW5mb3JjZSBhIGRlbGF5IGJlZm9yZSBpbmNsdWRpbmcgdGhlIG5ldyBwcmluY2lwYWwgaW4gYSBrZXkgcG9saWN5IGJlY2F1c2UgdGhlIG5ldyBwcmluY2lwYWwgbWlnaHQgbm90IGJlIGltbWVkaWF0ZWx5IHZpc2libGUgdG8gQVdTIEtNUyAuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NoYW5nZXMgdGhhdCBJIG1ha2UgYXJlIG5vdCBhbHdheXMgaW1tZWRpYXRlbHkgdmlzaWJsZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3Ryb3VibGVzaG9vdF9nZW5lcmFsLmh0bWwjdHJvdWJsZXNob290X2dlbmVyYWxfZXZlbnR1YWwtY29uc2lzdGVuY3kpIGluIHRoZSAqQVdTIElkZW50aXR5IGFuZCBBY2Nlc3MgTWFuYWdlbWVudCBVc2VyIEd1aWRlKiAuXG4gICAgICogLSBUaGUga2V5IHBvbGljeSBzaXplIGxpbWl0IGlzIDMyIGtpbG9ieXRlcyAoMzI3NjggYnl0ZXMpLlxuICAgICAqXG4gICAgICogKk1pbmltdW0qIDogYDFgXG4gICAgICpcbiAgICAgKiAqTWF4aW11bSogOiBgMzI3NjhgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMtcmVwbGljYWtleS5odG1sI2Nmbi1rbXMtcmVwbGljYWtleS1rZXlwb2xpY3lcbiAgICAgKi9cbiAgICBwdWJsaWMga2V5UG9saWN5OiBhbnkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG11bHRpLVJlZ2lvbiBwcmltYXJ5IGtleSB0byByZXBsaWNhdGUuIFRoZSBwcmltYXJ5IGtleSBtdXN0IGJlIGluIGEgZGlmZmVyZW50IEFXUyBSZWdpb24gb2YgdGhlIHNhbWUgQVdTIHBhcnRpdGlvbi4gWW91IGNhbiBjcmVhdGUgb25seSBvbmUgcmVwbGljYSBvZiBhIGdpdmVuIHByaW1hcnkga2V5IGluIGVhY2ggQVdTIFJlZ2lvbiAuXG4gICAgICpcbiAgICAgKiA+IElmIHlvdSBjaGFuZ2UgdGhlIGBQcmltYXJ5S2V5QXJuYCB2YWx1ZSBvZiBhIHJlcGxpY2Ega2V5LCB0aGUgZXhpc3RpbmcgcmVwbGljYSBrZXkgaXMgc2NoZWR1bGVkIGZvciBkZWxldGlvbiBhbmQgYSBuZXcgcmVwbGljYSBrZXkgaXMgY3JlYXRlZCBiYXNlZCBvbiB0aGUgc3BlY2lmaWVkIHByaW1hcnkga2V5LiBXaGlsZSBpdCBpcyBzY2hlZHVsZWQgZm9yIGRlbGV0aW9uLCB0aGUgZXhpc3RpbmcgcmVwbGljYSBrZXkgYmVjb21lcyB1bnVzYWJsZS4gWW91IGNhbiBjYW5jZWwgdGhlIHNjaGVkdWxlZCBkZWxldGlvbiBvZiB0aGUga2V5IG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24uXG4gICAgICogPlxuICAgICAqID4gSG93ZXZlciwgaWYgeW91IGluYWR2ZXJ0ZW50bHkgZGVsZXRlIGEgcmVwbGljYSBrZXksIHlvdSBjYW4gZGVjcnlwdCBjaXBoZXJ0ZXh0IGVuY3J5cHRlZCBieSB0aGF0IHJlcGxpY2Ega2V5IGJ5IHVzaW5nIGFueSByZWxhdGVkIG11bHRpLVJlZ2lvbiBrZXkuIElmIG5lY2Vzc2FyeSwgeW91IGNhbiByZWNyZWF0ZSB0aGUgcmVwbGljYSBpbiB0aGUgc2FtZSBSZWdpb24gYWZ0ZXIgdGhlIHByZXZpb3VzIG9uZSBpcyBjb21wbGV0ZWx5IGRlbGV0ZWQuIEZvciBkZXRhaWxzLCBzZWUgW0RlbGV0aW5nIG11bHRpLVJlZ2lvbiBrZXlzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tdWx0aS1yZWdpb24ta2V5cy1kZWxldGUuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqXG4gICAgICpcbiAgICAgKiBTcGVjaWZ5IHRoZSBrZXkgQVJOIG9mIGFuIGV4aXN0aW5nIG11bHRpLVJlZ2lvbiBwcmltYXJ5IGtleS4gRm9yIGV4YW1wbGUsIGBhcm46YXdzOmttczp1cy1lYXN0LTI6MTExMTIyMjIzMzMzOmtleS9tcmstMTIzNGFiY2QxMmFiMzRjZDU2ZWYxMjM0NTY3ODkwYWJgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1yZXBsaWNha2V5Lmh0bWwjY2ZuLWttcy1yZXBsaWNha2V5LXByaW1hcnlrZXlhcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcHJpbWFyeUtleUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGlvbiBvZiB0aGUgS01TIGtleS5cbiAgICAgKlxuICAgICAqIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGFuIGVtcHR5IHN0cmluZyAobm8gZGVzY3JpcHRpb24pLlxuICAgICAqXG4gICAgICogVGhlIGRlc2NyaXB0aW9uIGlzIG5vdCBhIHNoYXJlZCBwcm9wZXJ0eSBvZiBtdWx0aS1SZWdpb24ga2V5cy4gWW91IGNhbiBzcGVjaWZ5IHRoZSBzYW1lIGRlc2NyaXB0aW9uIG9yIGEgZGlmZmVyZW50IGRlc2NyaXB0aW9uIGZvciBlYWNoIGtleSBpbiBhIHNldCBvZiByZWxhdGVkIG11bHRpLVJlZ2lvbiBrZXlzLiBBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBkb2VzIG5vdCBzeW5jaHJvbml6ZSB0aGlzIHByb3BlcnR5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbCNjZm4ta21zLXJlcGxpY2FrZXktZGVzY3JpcHRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzY3JpcHRpb246IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB3aGV0aGVyIHRoZSByZXBsaWNhIGtleSBpcyBlbmFibGVkLiBEaXNhYmxlZCBLTVMga2V5cyBjYW5ub3QgYmUgdXNlZCBpbiBjcnlwdG9ncmFwaGljIG9wZXJhdGlvbnMuXG4gICAgICpcbiAgICAgKiBXaGVuIGBFbmFibGVkYCBpcyBgdHJ1ZWAgLCB0aGUgKmtleSBzdGF0ZSogb2YgdGhlIEtNUyBrZXkgaXMgYEVuYWJsZWRgIC4gV2hlbiBgRW5hYmxlZGAgaXMgYGZhbHNlYCAsIHRoZSBrZXkgc3RhdGUgb2YgdGhlIEtNUyBrZXkgaXMgYERpc2FibGVkYCAuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGB0cnVlYCAuXG4gICAgICpcbiAgICAgKiBUaGUgYWN0dWFsIGtleSBzdGF0ZSBvZiB0aGUgcmVwbGljYSBtaWdodCBiZSBhZmZlY3RlZCBieSBhY3Rpb25zIHRha2VuIG91dHNpZGUgb2YgQ2xvdWRGb3JtYXRpb24sIHN1Y2ggYXMgcnVubmluZyB0aGUgW0VuYWJsZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FbmFibGVLZXkuaHRtbCkgLCBbRGlzYWJsZUtleV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EaXNhYmxlS2V5Lmh0bWwpICwgb3IgW1NjaGVkdWxlS2V5RGVsZXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU2NoZWR1bGVLZXlEZWxldGlvbi5odG1sKSBvcGVyYXRpb25zLiBBbHNvLCB3aGlsZSB0aGUgcmVwbGljYSBrZXkgaXMgYmVpbmcgY3JlYXRlZCwgaXRzIGtleSBzdGF0ZSBpcyBgQ3JlYXRpbmdgIC4gV2hlbiB0aGUgcHJvY2VzcyBpcyBjb21wbGV0ZSwgdGhlIGtleSBzdGF0ZSBvZiB0aGUgcmVwbGljYSBrZXkgY2hhbmdlcyB0byBgRW5hYmxlZGAgLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IHRoZSBrZXkgc3RhdGVzIG9mIGEgS01TIGtleSwgc2VlIFtLZXkgc3RhdGU6IEVmZmVjdCBvbiB5b3VyIEtNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2tleS1zdGF0ZS5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Uta21zLXJlcGxpY2FrZXkuaHRtbCNjZm4ta21zLXJlcGxpY2FrZXktZW5hYmxlZFxuICAgICAqL1xuICAgIHB1YmxpYyBlbmFibGVkOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBudW1iZXIgb2YgZGF5cyBpbiB0aGUgd2FpdGluZyBwZXJpb2QgYmVmb3JlIEFXUyBLTVMgZGVsZXRlcyBhIHJlcGxpY2Ega2V5IHRoYXQgaGFzIGJlZW4gcmVtb3ZlZCBmcm9tIGEgQ2xvdWRGb3JtYXRpb24gc3RhY2suIEVudGVyIGEgdmFsdWUgYmV0d2VlbiA3IGFuZCAzMCBkYXlzLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAzMCBkYXlzLlxuICAgICAqXG4gICAgICogV2hlbiB5b3UgcmVtb3ZlIGEgcmVwbGljYSBrZXkgZnJvbSBhIENsb3VkRm9ybWF0aW9uIHN0YWNrLCBBV1MgS01TIHNjaGVkdWxlcyB0aGUgcmVwbGljYSBrZXkgZm9yIGRlbGV0aW9uIGFuZCBzdGFydHMgdGhlIG1hbmRhdG9yeSB3YWl0aW5nIHBlcmlvZC4gVGhlIGBQZW5kaW5nV2luZG93SW5EYXlzYCBwcm9wZXJ0eSBkZXRlcm1pbmVzIHRoZSBsZW5ndGggb2Ygd2FpdGluZyBwZXJpb2QuIER1cmluZyB0aGUgd2FpdGluZyBwZXJpb2QsIHRoZSBrZXkgc3RhdGUgb2YgcmVwbGljYSBrZXkgaXMgYFBlbmRpbmcgRGVsZXRpb25gICwgd2hpY2ggcHJldmVudHMgaXQgZnJvbSBiZWluZyB1c2VkIGluIGNyeXB0b2dyYXBoaWMgb3BlcmF0aW9ucy4gV2hlbiB0aGUgd2FpdGluZyBwZXJpb2QgZXhwaXJlcywgQVdTIEtNUyBwZXJtYW5lbnRseSBkZWxldGVzIHRoZSByZXBsaWNhIGtleS5cbiAgICAgKlxuICAgICAqIElmIHRoZSBLTVMga2V5IGlzIGEgbXVsdGktUmVnaW9uIHByaW1hcnkga2V5IHdpdGggcmVwbGljYSBrZXlzLCB0aGUgd2FpdGluZyBwZXJpb2QgYmVnaW5zIHdoZW4gdGhlIGxhc3Qgb2YgaXRzIHJlcGxpY2Ega2V5cyBpcyBkZWxldGVkLiBPdGhlcndpc2UsIHRoZSB3YWl0aW5nIHBlcmlvZCBiZWdpbnMgaW1tZWRpYXRlbHkuXG4gICAgICpcbiAgICAgKiBZb3UgY2Fubm90IHVzZSBhIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIHRvIGNhbmNlbCBkZWxldGlvbiBvZiB0aGUgcmVwbGljYSBhZnRlciB5b3UgcmVtb3ZlIGl0IGZyb20gdGhlIHN0YWNrLCByZWdhcmRsZXNzIG9mIHRoZSB3YWl0aW5nIHBlcmlvZC4gSG93ZXZlciwgaWYgeW91IHNwZWNpZnkgYSByZXBsaWNhIGtleSBpbiB5b3VyIHRlbXBsYXRlIHRoYXQgaXMgYmFzZWQgb24gdGhlIHNhbWUgcHJpbWFyeSBrZXkgYXMgdGhlIG9yaWdpbmFsIHJlcGxpY2Ega2V5LCBDbG91ZEZvcm1hdGlvbiBjcmVhdGVzIGEgbmV3IHJlcGxpY2Ega2V5IHdpdGggdGhlIHNhbWUga2V5IElELCBrZXkgbWF0ZXJpYWwsIGFuZCBvdGhlciBzaGFyZWQgcHJvcGVydGllcyBvZiB0aGUgb3JpZ2luYWwgcmVwbGljYSBrZXkuIFRoaXMgbmV3IHJlcGxpY2Ega2V5IGNhbiBkZWNyeXB0IGNpcGhlcnRleHQgdGhhdCB3YXMgZW5jcnlwdGVkIHVuZGVyIHRoZSBvcmlnaW5hbCByZXBsaWNhIGtleSwgb3IgYW55IHJlbGF0ZWQgbXVsdGktUmVnaW9uIGtleS5cbiAgICAgKlxuICAgICAqIEZvciBkZXRhaWxlZCBpbmZvcm1hdGlvbiBhYm91dCBkZWxldGluZyBtdWx0aS1SZWdpb24ga2V5cywgc2VlIFtEZWxldGluZyBtdWx0aS1SZWdpb24ga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXVsdGktcmVnaW9uLWtleXMtZGVsZXRlLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdGhlIGBQZW5kaW5nRGVsZXRpb25gIGtleSBzdGF0ZSwgc2VlIFtLZXkgc3RhdGU6IEVmZmVjdCBvbiB5b3VyIEtNUyBrZXldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2tleS1zdGF0ZS5odG1sKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIERldmVsb3BlciBHdWlkZSogLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBkZWxldGluZyBLTVMga2V5cywgc2VlIHRoZSBbU2NoZWR1bGVLZXlEZWxldGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TY2hlZHVsZUtleURlbGV0aW9uLmh0bWwpIG9wZXJhdGlvbiBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIEFQSSBSZWZlcmVuY2UqIGFuZCBbRGVsZXRpbmcgS01TIGtleXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2RlbGV0aW5nLWtleXMuaHRtbCkgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqICpNaW5pbXVtKiA6IDdcbiAgICAgKlxuICAgICAqICpNYXhpbXVtKiA6IDMwXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1rbXMtcmVwbGljYWtleS5odG1sI2Nmbi1rbXMtcmVwbGljYWtleS1wZW5kaW5nd2luZG93aW5kYXlzXG4gICAgICovXG4gICAgcHVibGljIHBlbmRpbmdXaW5kb3dJbkRheXM6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEFzc2lnbnMgb25lIG9yIG1vcmUgdGFncyB0byB0aGUgcmVwbGljYSBrZXkuXG4gICAgICpcbiAgICAgKiA+IFRhZ2dpbmcgb3IgdW50YWdnaW5nIGEgS01TIGtleSBjYW4gYWxsb3cgb3IgZGVueSBwZXJtaXNzaW9uIHRvIHRoZSBLTVMga2V5LiBGb3IgZGV0YWlscywgc2VlIFtBQkFDIGZvciBBV1MgS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hYmFjLmh0bWwpIGluIHRoZSAqQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBUYWdzIGFyZSBub3QgYSBzaGFyZWQgcHJvcGVydHkgb2YgbXVsdGktUmVnaW9uIGtleXMuIFlvdSBjYW4gc3BlY2lmeSB0aGUgc2FtZSB0YWdzIG9yIGRpZmZlcmVudCB0YWdzIGZvciBlYWNoIGtleSBpbiBhIHNldCBvZiByZWxhdGVkIG11bHRpLVJlZ2lvbiBrZXlzLiBBV1MgS01TIGRvZXMgbm90IHN5bmNocm9uaXplIHRoaXMgcHJvcGVydHkuXG4gICAgICpcbiAgICAgKiBFYWNoIHRhZyBjb25zaXN0cyBvZiBhIHRhZyBrZXkgYW5kIGEgdGFnIHZhbHVlLiBCb3RoIHRoZSB0YWcga2V5IGFuZCB0aGUgdGFnIHZhbHVlIGFyZSByZXF1aXJlZCwgYnV0IHRoZSB0YWcgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IChudWxsKSBzdHJpbmcuIFlvdSBjYW5ub3QgaGF2ZSBtb3JlIHRoYW4gb25lIHRhZyBvbiBhIEtNUyBrZXkgd2l0aCB0aGUgc2FtZSB0YWcga2V5LiBJZiB5b3Ugc3BlY2lmeSBhbiBleGlzdGluZyB0YWcga2V5IHdpdGggYSBkaWZmZXJlbnQgdGFnIHZhbHVlLCBBV1MgS01TIHJlcGxhY2VzIHRoZSBjdXJyZW50IHRhZyB2YWx1ZSB3aXRoIHRoZSBzcGVjaWZpZWQgb25lLlxuICAgICAqXG4gICAgICogV2hlbiB5b3UgYXNzaWduIHRhZ3MgdG8gYW4gQVdTIHJlc291cmNlLCBBV1MgZ2VuZXJhdGVzIGEgY29zdCBhbGxvY2F0aW9uIHJlcG9ydCB3aXRoIHVzYWdlIGFuZCBjb3N0cyBhZ2dyZWdhdGVkIGJ5IHRhZ3MuIFRhZ3MgY2FuIGFsc28gYmUgdXNlZCB0byBjb250cm9sIGFjY2VzcyB0byBhIEtNUyBrZXkuIEZvciBkZXRhaWxzLCBzZWUgW1RhZ2dpbmcga2V5c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdGFnZ2luZy1rZXlzLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWttcy1yZXBsaWNha2V5Lmh0bWwjY2ZuLWttcy1yZXBsaWNha2V5LXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6S01TOjpSZXBsaWNhS2V5YC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5SZXBsaWNhS2V5UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmblJlcGxpY2FLZXkuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdrZXlQb2xpY3knLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3ByaW1hcnlLZXlBcm4nLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdBcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0cktleUlkID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdLZXlJZCcpKTtcblxuICAgICAgICB0aGlzLmtleVBvbGljeSA9IHByb3BzLmtleVBvbGljeTtcbiAgICAgICAgdGhpcy5wcmltYXJ5S2V5QXJuID0gcHJvcHMucHJpbWFyeUtleUFybjtcbiAgICAgICAgdGhpcy5kZXNjcmlwdGlvbiA9IHByb3BzLmRlc2NyaXB0aW9uO1xuICAgICAgICB0aGlzLmVuYWJsZWQgPSBwcm9wcy5lbmFibGVkO1xuICAgICAgICB0aGlzLnBlbmRpbmdXaW5kb3dJbkRheXMgPSBwcm9wcy5wZW5kaW5nV2luZG93SW5EYXlzO1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpLTVM6OlJlcGxpY2FLZXlcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmblJlcGxpY2FLZXkuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGtleVBvbGljeTogdGhpcy5rZXlQb2xpY3ksXG4gICAgICAgICAgICBwcmltYXJ5S2V5QXJuOiB0aGlzLnByaW1hcnlLZXlBcm4sXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogdGhpcy5kZXNjcmlwdGlvbixcbiAgICAgICAgICAgIGVuYWJsZWQ6IHRoaXMuZW5hYmxlZCxcbiAgICAgICAgICAgIHBlbmRpbmdXaW5kb3dJbkRheXM6IHRoaXMucGVuZGluZ1dpbmRvd0luRGF5cyxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuUmVwbGljYUtleVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuIl19